/* autogenerated file */
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE
# endif
#include <string.h>
#include <read-file.h>
#include "oci_image_layout_spec.h"

oci_image_layout *make_oci_image_layout (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_image_layout *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "imageLayoutVersion", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->image_layout_version = strdup (str ? str : "");
            if (ret->image_layout_version == NULL)
                abort ();
        }
    }
    if (ret->image_layout_version == NULL) {
        if (asprintf (err, "Required field '%s' not present", "imageLayoutVersion") < 0)
            abort();
        free_oci_image_layout (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "imageLayoutVersion")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_image_layout (oci_image_layout *ptr) {
    if (!ptr)
        return;
    free (ptr->image_layout_version);
    ptr->image_layout_version = NULL;
    free (ptr);
}

bool gen_oci_image_layout (yajl_gen g, oci_image_layout *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->image_layout_version) {
        stat = reformat_map_key (g, (unsigned char *) "imageLayoutVersion", 18 /* strlen ("imageLayoutVersion") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->image_layout_version, strlen (ptr->image_layout_version));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}


oci_image_layout *oci_image_layout_parse_file (const char *filename, struct parser_context *ctx, parser_error *err) {
    yajl_val tree;
    size_t filesize;

    if (!filename || !err)
        return NULL;
    *err = NULL;
    struct parser_context tmp_ctx;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char *content = read_file (filename, &filesize);
    char errbuf[1024];
    if (content == NULL) {
        if (asprintf (err, "cannot read the file: %s", filename) < 0)
            abort ();
        return NULL;
    }
    tree = yajl_tree_parse (content, errbuf, sizeof (errbuf));
    free (content);
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the file: %s", errbuf) < 0)
            abort ();
        return NULL;
    }

    oci_image_layout *ptr = make_oci_image_layout (tree, ctx, err);
    yajl_tree_free (tree);
    return ptr;
}

oci_image_layout *oci_image_layout_parse_file_stream (FILE *stream, struct parser_context *ctx, parser_error *err) {
    yajl_val tree;
    size_t filesize;

    if (!stream || !err)
        return NULL;
    *err = NULL;
    struct parser_context tmp_ctx;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char *content = fread_file (stream, &filesize);
    char errbuf[1024];
    if (content == NULL) {
        *err = strdup ("cannot read the file");
        return NULL;
    }
    tree = yajl_tree_parse (content, errbuf, sizeof (errbuf));
    free (content);
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the stream: %s", errbuf) < 0)
            abort ();
        return NULL;
    }

    oci_image_layout *ptr = make_oci_image_layout (tree, ctx, err);
    yajl_tree_free (tree);
    return ptr;
}

oci_image_layout *oci_image_layout_parse_data (const char *jsondata, struct parser_context *ctx, parser_error *err) {
    yajl_val tree;
    struct parser_context tmp_ctx;

    if (!jsondata || !err)
        return NULL;
    *err = NULL;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char errbuf[1024];
    tree = yajl_tree_parse (jsondata, errbuf, sizeof (errbuf));
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the data: %s", errbuf) < 0)
            abort ();
        return NULL;
    }
    oci_image_layout *ptr = make_oci_image_layout (tree, ctx, err);
    yajl_tree_free (tree);
    return ptr;
}
char *oci_image_layout_generate_json (oci_image_layout *ptr, struct parser_context *ctx, parser_error *err) {
    yajl_gen g = NULL;
    struct parser_context tmp_ctx;
    const unsigned char *gen_buf = NULL;
    char *json_buf = NULL;
    size_t gen_len = 0;

    if (!ptr || !err)
        return NULL;
    *err = NULL;
    if (!ctx) {
        ctx = &tmp_ctx;
        memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }

    if (!json_gen_init (&g)) {
        *err = strdup ("Json_gen init failed");
        goto out;
    }
    if (!gen_oci_image_layout (g, ptr, ctx, err)) {
        *err = strdup ("Failed to generate json");
        goto free_out;
    }

    yajl_gen_get_buf (g, &gen_buf, &gen_len);
    if (!gen_buf) {
        *err = strdup ("Error to get generated json");
        goto free_out;
    }

    json_buf = safe_malloc (gen_len + 1);
    memcpy (json_buf, gen_buf, gen_len);
    json_buf[gen_len] = '\0';

free_out:
    yajl_gen_clear (g);
    yajl_gen_free (g);
out:
    return json_buf;
}
