/* autogenerated file */
#ifndef OCI_CONTAINER_SCHEMA_H
# define OCI_CONTAINER_SCHEMA_H

# include <sys/types.h>
# include <stdint.h>
# include "json_common.h"

typedef struct {
    char *path;
    char **args;
    size_t args_len;

    char **env;
    size_t env_len;

    int timeout;
    unsigned int timeout_present : 1;
}
oci_container_hooks_prestart_element;

void free_oci_container_hooks_prestart_element (oci_container_hooks_prestart_element *ptr);

oci_container_hooks_prestart_element *make_oci_container_hooks_prestart_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *path;
    char **args;
    size_t args_len;

    char **env;
    size_t env_len;

    int timeout;
    unsigned int timeout_present : 1;
}
oci_container_hooks_poststart_element;

void free_oci_container_hooks_poststart_element (oci_container_hooks_poststart_element *ptr);

oci_container_hooks_poststart_element *make_oci_container_hooks_poststart_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *path;
    char **args;
    size_t args_len;

    char **env;
    size_t env_len;

    int timeout;
    unsigned int timeout_present : 1;
}
oci_container_hooks_poststop_element;

void free_oci_container_hooks_poststop_element (oci_container_hooks_poststop_element *ptr);

oci_container_hooks_poststop_element *make_oci_container_hooks_poststop_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    oci_container_hooks_prestart_element **prestart;
    size_t prestart_len;

    oci_container_hooks_poststart_element **poststart;
    size_t poststart_len;

    oci_container_hooks_poststop_element **poststop;
    size_t poststop_len;

}
oci_container_hooks;

void free_oci_container_hooks (oci_container_hooks *ptr);

oci_container_hooks *make_oci_container_hooks (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_hooks (yajl_gen g, oci_container_hooks *ptr, struct parser_context *ctx, parser_error *err);

typedef string_cells oci_container_annotations;

typedef struct {
    char *source;
    char *destination;
    char **options;
    size_t options_len;

    char *type;
}
oci_container_mounts_element;

void free_oci_container_mounts_element (oci_container_mounts_element *ptr);

oci_container_mounts_element *make_oci_container_mounts_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *path;

    bool readonly;

    unsigned int readonly_present : 1;
}
oci_container_root;

void free_oci_container_root (oci_container_root *ptr);

oci_container_root *make_oci_container_root (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_root (yajl_gen g, oci_container_root *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    uint64_t height;

    uint64_t width;

    unsigned int height_present : 1;
    unsigned int width_present : 1;
}
oci_container_process_console_size;

void free_oci_container_process_console_size (oci_container_process_console_size *ptr);

oci_container_process_console_size *make_oci_container_process_console_size (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_process_console_size (yajl_gen g, oci_container_process_console_size *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    uid_t uid;

    gid_t gid;

    gid_t *additional_gids;
    size_t additional_gids_len;

    char *username;

    unsigned int uid_present : 1;
    unsigned int gid_present : 1;
}
oci_container_process_user;

void free_oci_container_process_user (oci_container_process_user *ptr);

oci_container_process_user *make_oci_container_process_user (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_process_user (yajl_gen g, oci_container_process_user *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char **bounding;
    size_t bounding_len;

    char **permitted;
    size_t permitted_len;

    char **effective;
    size_t effective_len;

    char **inheritable;
    size_t inheritable_len;

    char **ambient;
    size_t ambient_len;

}
oci_container_process_capabilities;

void free_oci_container_process_capabilities (oci_container_process_capabilities *ptr);

oci_container_process_capabilities *make_oci_container_process_capabilities (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_process_capabilities (yajl_gen g, oci_container_process_capabilities *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    uint64_t hard;
    uint64_t soft;
    char *type;
    unsigned int hard_present : 1;
    unsigned int soft_present : 1;
}
oci_container_process_rlimits_element;

void free_oci_container_process_rlimits_element (oci_container_process_rlimits_element *ptr);

oci_container_process_rlimits_element *make_oci_container_process_rlimits_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    char **args;
    size_t args_len;

    char *command_line;

    oci_container_process_console_size *console_size;

    char *cwd;

    char **env;
    size_t env_len;

    bool terminal;

    oci_container_process_user *user;

    oci_container_process_capabilities *capabilities;

    char *apparmor_profile;

    int oom_score_adj;

    char *selinux_label;

    bool no_new_privileges;

    oci_container_process_rlimits_element **rlimits;
    size_t rlimits_len;

    unsigned int terminal_present : 1;
    unsigned int oom_score_adj_present : 1;
    unsigned int no_new_privileges_present : 1;
}
oci_container_process;

void free_oci_container_process (oci_container_process *ptr);

oci_container_process *make_oci_container_process (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_process (yajl_gen g, oci_container_process *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *type;
    char *path;
    int file_mode;
    int64_t major;
    int64_t minor;
    uid_t uid;
    gid_t gid;
    unsigned int file_mode_present : 1;
    unsigned int major_present : 1;
    unsigned int minor_present : 1;
    unsigned int uid_present : 1;
    unsigned int gid_present : 1;
}
oci_container_linux_devices_element;

void free_oci_container_linux_devices_element (oci_container_linux_devices_element *ptr);

oci_container_linux_devices_element *make_oci_container_linux_devices_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    uint32_t container_id;
    uint32_t host_id;
    uint32_t size;
    unsigned int container_id_present : 1;
    unsigned int host_id_present : 1;
    unsigned int size_present : 1;
}
oci_container_linux_uid_mappings_element;

void free_oci_container_linux_uid_mappings_element (oci_container_linux_uid_mappings_element *ptr);

oci_container_linux_uid_mappings_element *make_oci_container_linux_uid_mappings_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    uint32_t container_id;
    uint32_t host_id;
    uint32_t size;
    unsigned int container_id_present : 1;
    unsigned int host_id_present : 1;
    unsigned int size_present : 1;
}
oci_container_linux_gid_mappings_element;

void free_oci_container_linux_gid_mappings_element (oci_container_linux_gid_mappings_element *ptr);

oci_container_linux_gid_mappings_element *make_oci_container_linux_gid_mappings_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *type;
    char *path;
}
oci_container_linux_namespaces_element;

void free_oci_container_linux_namespaces_element (oci_container_linux_namespaces_element *ptr);

oci_container_linux_namespaces_element *make_oci_container_linux_namespaces_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    bool allow;
    char *type;
    int64_t major;
    int64_t minor;
    char *access;
    unsigned int allow_present : 1;
    unsigned int major_present : 1;
    unsigned int minor_present : 1;
}
oci_container_linux_resources_devices_element;

void free_oci_container_linux_resources_devices_element (oci_container_linux_resources_devices_element *ptr);

oci_container_linux_resources_devices_element *make_oci_container_linux_resources_devices_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    int64_t limit;

    unsigned int limit_present : 1;
}
oci_container_linux_resources_pids;

void free_oci_container_linux_resources_pids (oci_container_linux_resources_pids *ptr);

oci_container_linux_resources_pids *make_oci_container_linux_resources_pids (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux_resources_pids (yajl_gen g, oci_container_linux_resources_pids *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    int64_t major;
    int64_t minor;
    uint64_t rate;
    unsigned int major_present : 1;
    unsigned int minor_present : 1;
    unsigned int rate_present : 1;
}
oci_container_linux_resources_block_io_throttle_read_bps_device_element;

void free_oci_container_linux_resources_block_io_throttle_read_bps_device_element (oci_container_linux_resources_block_io_throttle_read_bps_device_element *ptr);

oci_container_linux_resources_block_io_throttle_read_bps_device_element *make_oci_container_linux_resources_block_io_throttle_read_bps_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    int64_t major;
    int64_t minor;
    uint64_t rate;
    unsigned int major_present : 1;
    unsigned int minor_present : 1;
    unsigned int rate_present : 1;
}
oci_container_linux_resources_block_io_throttle_write_bps_device_element;

void free_oci_container_linux_resources_block_io_throttle_write_bps_device_element (oci_container_linux_resources_block_io_throttle_write_bps_device_element *ptr);

oci_container_linux_resources_block_io_throttle_write_bps_device_element *make_oci_container_linux_resources_block_io_throttle_write_bps_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    int64_t major;
    int64_t minor;
    uint64_t rate;
    unsigned int major_present : 1;
    unsigned int minor_present : 1;
    unsigned int rate_present : 1;
}
oci_container_linux_resources_block_io_throttle_read_iops_device_element;

void free_oci_container_linux_resources_block_io_throttle_read_iops_device_element (oci_container_linux_resources_block_io_throttle_read_iops_device_element *ptr);

oci_container_linux_resources_block_io_throttle_read_iops_device_element *make_oci_container_linux_resources_block_io_throttle_read_iops_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    int64_t major;
    int64_t minor;
    uint64_t rate;
    unsigned int major_present : 1;
    unsigned int minor_present : 1;
    unsigned int rate_present : 1;
}
oci_container_linux_resources_block_io_throttle_write_iops_device_element;

void free_oci_container_linux_resources_block_io_throttle_write_iops_device_element (oci_container_linux_resources_block_io_throttle_write_iops_device_element *ptr);

oci_container_linux_resources_block_io_throttle_write_iops_device_element *make_oci_container_linux_resources_block_io_throttle_write_iops_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    int64_t major;
    int64_t minor;
    int weight;
    int leaf_weight;
    unsigned int major_present : 1;
    unsigned int minor_present : 1;
    unsigned int weight_present : 1;
    unsigned int leaf_weight_present : 1;
}
oci_container_linux_resources_block_io_weight_device_element;

void free_oci_container_linux_resources_block_io_weight_device_element (oci_container_linux_resources_block_io_weight_device_element *ptr);

oci_container_linux_resources_block_io_weight_device_element *make_oci_container_linux_resources_block_io_weight_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    int weight;

    int leaf_weight;

    oci_container_linux_resources_block_io_throttle_read_bps_device_element **throttle_read_bps_device;
    size_t throttle_read_bps_device_len;

    oci_container_linux_resources_block_io_throttle_write_bps_device_element **throttle_write_bps_device;
    size_t throttle_write_bps_device_len;

    oci_container_linux_resources_block_io_throttle_read_iops_device_element **throttle_read_iops_device;
    size_t throttle_read_iops_device_len;

    oci_container_linux_resources_block_io_throttle_write_iops_device_element **throttle_write_iops_device;
    size_t throttle_write_iops_device_len;

    oci_container_linux_resources_block_io_weight_device_element **weight_device;
    size_t weight_device_len;

    unsigned int weight_present : 1;
    unsigned int leaf_weight_present : 1;
}
oci_container_linux_resources_block_io;

void free_oci_container_linux_resources_block_io (oci_container_linux_resources_block_io *ptr);

oci_container_linux_resources_block_io *make_oci_container_linux_resources_block_io (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux_resources_block_io (yajl_gen g, oci_container_linux_resources_block_io *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *cpus;

    char *mems;

    uint64_t period;

    int64_t quota;

    uint64_t realtime_period;

    int64_t realtime_runtime;

    uint64_t shares;

    unsigned int period_present : 1;
    unsigned int quota_present : 1;
    unsigned int realtime_period_present : 1;
    unsigned int realtime_runtime_present : 1;
    unsigned int shares_present : 1;
}
oci_container_linux_resources_cpu;

void free_oci_container_linux_resources_cpu (oci_container_linux_resources_cpu *ptr);

oci_container_linux_resources_cpu *make_oci_container_linux_resources_cpu (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux_resources_cpu (yajl_gen g, oci_container_linux_resources_cpu *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *page_size;
    uint64_t limit;
    unsigned int limit_present : 1;
}
oci_container_linux_resources_hugepage_limits_element;

void free_oci_container_linux_resources_hugepage_limits_element (oci_container_linux_resources_hugepage_limits_element *ptr);

oci_container_linux_resources_hugepage_limits_element *make_oci_container_linux_resources_hugepage_limits_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    int64_t kernel;

    int64_t kernel_tcp;

    int64_t limit;

    int64_t reservation;

    int64_t swap;

    uint64_t swappiness;

    bool disable_oom_killer;

    unsigned int kernel_present : 1;
    unsigned int kernel_tcp_present : 1;
    unsigned int limit_present : 1;
    unsigned int reservation_present : 1;
    unsigned int swap_present : 1;
    unsigned int swappiness_present : 1;
    unsigned int disable_oom_killer_present : 1;
}
oci_container_linux_resources_memory;

void free_oci_container_linux_resources_memory (oci_container_linux_resources_memory *ptr);

oci_container_linux_resources_memory *make_oci_container_linux_resources_memory (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux_resources_memory (yajl_gen g, oci_container_linux_resources_memory *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *name;
    uint32_t priority;
    unsigned int priority_present : 1;
}
oci_container_linux_resources_network_priorities_element;

void free_oci_container_linux_resources_network_priorities_element (oci_container_linux_resources_network_priorities_element *ptr);

oci_container_linux_resources_network_priorities_element *make_oci_container_linux_resources_network_priorities_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    uint32_t class_id;

    oci_container_linux_resources_network_priorities_element **priorities;
    size_t priorities_len;

    unsigned int class_id_present : 1;
}
oci_container_linux_resources_network;

void free_oci_container_linux_resources_network (oci_container_linux_resources_network *ptr);

oci_container_linux_resources_network *make_oci_container_linux_resources_network (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux_resources_network (yajl_gen g, oci_container_linux_resources_network *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
}
oci_container_linux_resources_rdma;

void free_oci_container_linux_resources_rdma (oci_container_linux_resources_rdma *ptr);

oci_container_linux_resources_rdma *make_oci_container_linux_resources_rdma (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux_resources_rdma (yajl_gen g, oci_container_linux_resources_rdma *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    oci_container_linux_resources_devices_element **devices;
    size_t devices_len;

    oci_container_linux_resources_pids *pids;

    oci_container_linux_resources_block_io *block_io;

    oci_container_linux_resources_cpu *cpu;

    oci_container_linux_resources_hugepage_limits_element **hugepage_limits;
    size_t hugepage_limits_len;

    oci_container_linux_resources_memory *memory;

    oci_container_linux_resources_network *network;

    oci_container_linux_resources_rdma *rdma;

}
oci_container_linux_resources;

void free_oci_container_linux_resources (oci_container_linux_resources *ptr);

oci_container_linux_resources *make_oci_container_linux_resources (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux_resources (yajl_gen g, oci_container_linux_resources *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    uint32_t index;
    uint64_t value;
    uint64_t value_two;
    char *op;
    unsigned int index_present : 1;
    unsigned int value_present : 1;
    unsigned int value_two_present : 1;
}
oci_container_linux_seccomp_syscalls_args_element;

void free_oci_container_linux_seccomp_syscalls_args_element (oci_container_linux_seccomp_syscalls_args_element *ptr);

oci_container_linux_seccomp_syscalls_args_element *make_oci_container_linux_seccomp_syscalls_args_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    char **names;
    size_t names_len;

    char *action;
    oci_container_linux_seccomp_syscalls_args_element **args;
    size_t args_len;

}
oci_container_linux_seccomp_syscalls_element;

void free_oci_container_linux_seccomp_syscalls_element (oci_container_linux_seccomp_syscalls_element *ptr);

oci_container_linux_seccomp_syscalls_element *make_oci_container_linux_seccomp_syscalls_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *default_action;

    char **flags;
    size_t flags_len;

    char **architectures;
    size_t architectures_len;

    oci_container_linux_seccomp_syscalls_element **syscalls;
    size_t syscalls_len;

}
oci_container_linux_seccomp;

void free_oci_container_linux_seccomp (oci_container_linux_seccomp *ptr);

oci_container_linux_seccomp *make_oci_container_linux_seccomp (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux_seccomp (yajl_gen g, oci_container_linux_seccomp *ptr, struct parser_context *ctx, parser_error *err);

typedef string_cells oci_container_linux_sysctl;

typedef struct {
    char *clos_id;

    char *l3cache_schema;

    char *mem_bw_schema;

}
oci_container_linux_intel_rdt;

void free_oci_container_linux_intel_rdt (oci_container_linux_intel_rdt *ptr);

oci_container_linux_intel_rdt *make_oci_container_linux_intel_rdt (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux_intel_rdt (yajl_gen g, oci_container_linux_intel_rdt *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    oci_container_linux_devices_element **devices;
    size_t devices_len;

    oci_container_linux_uid_mappings_element **uid_mappings;
    size_t uid_mappings_len;

    oci_container_linux_gid_mappings_element **gid_mappings;
    size_t gid_mappings_len;

    oci_container_linux_namespaces_element **namespaces;
    size_t namespaces_len;

    oci_container_linux_resources *resources;

    char *cgroups_path;

    char *rootfs_propagation;

    oci_container_linux_seccomp *seccomp;

    oci_container_linux_sysctl *sysctl;

    char **masked_paths;
    size_t masked_paths_len;

    char **readonly_paths;
    size_t readonly_paths_len;

    char *mount_label;

    oci_container_linux_intel_rdt *intel_rdt;

}
oci_container_linux;

void free_oci_container_linux (oci_container_linux *ptr);

oci_container_linux *make_oci_container_linux (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_linux (yajl_gen g, oci_container_linux *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *ncpus;

}
oci_container_solaris_capped_cpu;

void free_oci_container_solaris_capped_cpu (oci_container_solaris_capped_cpu *ptr);

oci_container_solaris_capped_cpu *make_oci_container_solaris_capped_cpu (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_solaris_capped_cpu (yajl_gen g, oci_container_solaris_capped_cpu *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *physical;

    char *swap;

}
oci_container_solaris_capped_memory;

void free_oci_container_solaris_capped_memory (oci_container_solaris_capped_memory *ptr);

oci_container_solaris_capped_memory *make_oci_container_solaris_capped_memory (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_solaris_capped_memory (yajl_gen g, oci_container_solaris_capped_memory *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *linkname;
    char *lower_link;
    char *allowed_address;
    char *configure_allowed_address;
    char *defrouter;
    char *mac_address;
    char *link_protection;
}
oci_container_solaris_anet_element;

void free_oci_container_solaris_anet_element (oci_container_solaris_anet_element *ptr);

oci_container_solaris_anet_element *make_oci_container_solaris_anet_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *milestone;

    char *limitpriv;

    char *max_shm_memory;

    oci_container_solaris_capped_cpu *capped_cpu;

    oci_container_solaris_capped_memory *capped_memory;

    oci_container_solaris_anet_element **anet;
    size_t anet_len;

}
oci_container_solaris;

void free_oci_container_solaris (oci_container_solaris *ptr);

oci_container_solaris *make_oci_container_solaris (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_solaris (yajl_gen g, oci_container_solaris *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *id;
    char *id_type;
}
oci_container_windows_devices_element;

void free_oci_container_windows_devices_element (oci_container_windows_devices_element *ptr);

oci_container_windows_devices_element *make_oci_container_windows_devices_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    uint64_t limit;

    unsigned int limit_present : 1;
}
oci_container_windows_resources_memory;

void free_oci_container_windows_resources_memory (oci_container_windows_resources_memory *ptr);

oci_container_windows_resources_memory *make_oci_container_windows_resources_memory (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_windows_resources_memory (yajl_gen g, oci_container_windows_resources_memory *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    uint64_t count;

    uint16_t shares;

    uint16_t maximum;

    unsigned int count_present : 1;
    unsigned int shares_present : 1;
    unsigned int maximum_present : 1;
}
oci_container_windows_resources_cpu;

void free_oci_container_windows_resources_cpu (oci_container_windows_resources_cpu *ptr);

oci_container_windows_resources_cpu *make_oci_container_windows_resources_cpu (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_windows_resources_cpu (yajl_gen g, oci_container_windows_resources_cpu *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    uint64_t iops;

    uint64_t bps;

    uint64_t sandbox_size;

    unsigned int iops_present : 1;
    unsigned int bps_present : 1;
    unsigned int sandbox_size_present : 1;
}
oci_container_windows_resources_storage;

void free_oci_container_windows_resources_storage (oci_container_windows_resources_storage *ptr);

oci_container_windows_resources_storage *make_oci_container_windows_resources_storage (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_windows_resources_storage (yajl_gen g, oci_container_windows_resources_storage *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    oci_container_windows_resources_memory *memory;

    oci_container_windows_resources_cpu *cpu;

    oci_container_windows_resources_storage *storage;

}
oci_container_windows_resources;

void free_oci_container_windows_resources (oci_container_windows_resources *ptr);

oci_container_windows_resources *make_oci_container_windows_resources (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_windows_resources (yajl_gen g, oci_container_windows_resources *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char **endpoint_list;
    size_t endpoint_list_len;

    bool allow_unqualified_dns_query;

    char **dns_search_list;
    size_t dns_search_list_len;

    char *network_shared_container_name;

    char *network_namespace;

    unsigned int allow_unqualified_dns_query_present : 1;
}
oci_container_windows_network;

void free_oci_container_windows_network (oci_container_windows_network *ptr);

oci_container_windows_network *make_oci_container_windows_network (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_windows_network (yajl_gen g, oci_container_windows_network *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
}
oci_container_windows_credential_spec;

void free_oci_container_windows_credential_spec (oci_container_windows_credential_spec *ptr);

oci_container_windows_credential_spec *make_oci_container_windows_credential_spec (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_windows_credential_spec (yajl_gen g, oci_container_windows_credential_spec *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *utility_vm_path;

}
oci_container_windows_hyperv;

void free_oci_container_windows_hyperv (oci_container_windows_hyperv *ptr);

oci_container_windows_hyperv *make_oci_container_windows_hyperv (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_windows_hyperv (yajl_gen g, oci_container_windows_hyperv *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char **layer_folders;
    size_t layer_folders_len;

    oci_container_windows_devices_element **devices;
    size_t devices_len;

    oci_container_windows_resources *resources;

    oci_container_windows_network *network;

    oci_container_windows_credential_spec *credential_spec;

    bool servicing;

    bool ignore_flushes_during_boot;

    oci_container_windows_hyperv *hyperv;

    unsigned int servicing_present : 1;
    unsigned int ignore_flushes_during_boot_present : 1;
}
oci_container_windows;

void free_oci_container_windows (oci_container_windows *ptr);

oci_container_windows *make_oci_container_windows (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_windows (yajl_gen g, oci_container_windows *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *path;

    char **parameters;
    size_t parameters_len;

}
oci_container_vm_hypervisor;

void free_oci_container_vm_hypervisor (oci_container_vm_hypervisor *ptr);

oci_container_vm_hypervisor *make_oci_container_vm_hypervisor (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_vm_hypervisor (yajl_gen g, oci_container_vm_hypervisor *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *path;

    char **parameters;
    size_t parameters_len;

    char *initrd;

}
oci_container_vm_kernel;

void free_oci_container_vm_kernel (oci_container_vm_kernel *ptr);

oci_container_vm_kernel *make_oci_container_vm_kernel (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_vm_kernel (yajl_gen g, oci_container_vm_kernel *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *path;

    char *format;

}
oci_container_vm_image;

void free_oci_container_vm_image (oci_container_vm_image *ptr);

oci_container_vm_image *make_oci_container_vm_image (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_vm_image (yajl_gen g, oci_container_vm_image *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    oci_container_vm_hypervisor *hypervisor;

    oci_container_vm_kernel *kernel;

    oci_container_vm_image *image;

}
oci_container_vm;

void free_oci_container_vm (oci_container_vm *ptr);

oci_container_vm *make_oci_container_vm (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container_vm (yajl_gen g, oci_container_vm *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *oci_version;

    oci_container_hooks *hooks;

    oci_container_annotations *annotations;

    char *hostname;

    oci_container_mounts_element **mounts;
    size_t mounts_len;

    oci_container_root *root;

    oci_container_process *process;

    oci_container_linux *linux;

    oci_container_solaris *solaris;

    oci_container_windows *windows;

    oci_container_vm *vm;

}
oci_container;

void free_oci_container (oci_container *ptr);

oci_container *make_oci_container (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_container (yajl_gen g, oci_container *ptr, struct parser_context *ctx, parser_error *err);

oci_container *oci_container_parse_file (const char *filename, struct parser_context *ctx, parser_error *err);

oci_container *oci_container_parse_file_stream (FILE *stream, struct parser_context *ctx, parser_error *err);

oci_container *oci_container_parse_data (const char *jsondata, struct parser_context *ctx, parser_error *err);

char *oci_container_generate_json (oci_container *ptr, struct parser_context *ctx, parser_error *err);

#endif
