/* autogenerated file */
#ifndef _JSON_COMMON_H
# define _JSON_COMMON_H

# include <stdbool.h>
# include <stdio.h>
# include <string.h>
# include <stdlib.h>
# include <yajl/yajl_tree.h>
# include <yajl/yajl_gen.h>

# undef linux
# define PARSE_OPTIONS_STRICT 1
typedef char *parser_error;

typedef struct {
    char **keys;
    char **values;
    size_t len;
} string_cells;

struct parser_context {
    unsigned int options;
    FILE *errfile;
};

/* non-zero when we're reformatting a stream */
# define s_streamReformat 0
# define GEN_AND_RETURN(func) {                  \
    yajl_gen_status __stat = func;                    \
    if (__stat == yajl_gen_generation_complete && s_streamReformat) {\
        yajl_gen_reset (g, "\n");                \
        __stat = func;                      \
    }                             \
    return __stat == yajl_gen_status_ok; \
}

bool reformat_integer (void *ctx, long long int num);

bool reformat_double (void *ctx, double num);

bool reformat_number (void *ctx, const char *str, size_t len);

bool reformat_string (void *ctx, const unsigned char *str, size_t len);

bool reformat_null (void *ctx);

bool reformat_boolean (void *ctx, int boolean);

bool reformat_map_key (void *ctx, const unsigned char *str, size_t len);

bool reformat_start_map (void *ctx);

bool reformat_end_map (void *ctx);

bool reformat_start_array (void *ctx);

bool reformat_end_array (void *ctx);

bool gen_map_string_string (void *ctx, string_cells *cells);

bool json_gen_init (yajl_gen *g);

yajl_val get_val (yajl_val tree, const char *name, yajl_type type);

string_cells *read_map_string_string (yajl_val src);

void free_cells (string_cells *cells);

void *safe_malloc (size_t size);

#endif
