/* autogenerated file */
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE
# endif
#include <string.h>
#include <read-file.h>
#include "oci_runtime_spec.h"

oci_container_hooks_prestart_element *make_oci_container_hooks_prestart_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_hooks_prestart_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "path", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->path = strdup (str ? str : "");
            if (ret->path == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "args", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->args_len = len;
            ret->args = safe_malloc ((len + 1) * sizeof (*ret->args));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->args[i] = strdup (str ? str : "");
                    if (ret->args[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "env", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->env_len = len;
            ret->env = safe_malloc ((len + 1) * sizeof (*ret->env));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->env[i] = strdup (str ? str : "");
                    if (ret->env[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "timeout", yajl_t_number);
        if (val) {
            ret->timeout = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->timeout_present = 1;
        }
    }
    if (ret->path == NULL) {
        if (asprintf (err, "Required field '%s' not present", "path") < 0)
            abort();
        free_oci_container_hooks_prestart_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_hooks_prestart_element (oci_container_hooks_prestart_element *ptr) {
    if (!ptr)
        return;
    free (ptr->path);
    ptr->path = NULL;
    if (ptr->args) {
        size_t i;
        for (i = 0; i < ptr->args_len; i++) {
            if (ptr->args[i]) {
                free (ptr->args[i]);
                ptr->args[i] = NULL;
            }
        }
        free (ptr->args);
        ptr->args = NULL;
    }
    if (ptr->env) {
        size_t i;
        for (i = 0; i < ptr->env_len; i++) {
            if (ptr->env[i]) {
                free (ptr->env[i]);
                ptr->env[i] = NULL;
            }
        }
        free (ptr->env);
        ptr->env = NULL;
    }
    free (ptr);
}

bool gen_oci_container_hooks_prestart_element (yajl_gen g, oci_container_hooks_prestart_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->path) {
        stat = reformat_map_key (g, (unsigned char *) "path", 4 /* strlen ("path") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->path, strlen (ptr->path));
        if (!stat)
            return false;
    }
    if (ptr->args) {
        stat = reformat_map_key (g, (unsigned char *) "args", 4 /* strlen ("args") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->args_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->args[i], strlen (ptr->args[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->env) {
        stat = reformat_map_key (g, (unsigned char *) "env", 3 /* strlen ("env") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->env_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->env[i], strlen (ptr->env[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->timeout_present) {
        stat = reformat_map_key (g, (unsigned char *)"timeout", 7 /* strlen ("timeout") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->timeout);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_hooks_poststart_element *make_oci_container_hooks_poststart_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_hooks_poststart_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "path", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->path = strdup (str ? str : "");
            if (ret->path == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "args", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->args_len = len;
            ret->args = safe_malloc ((len + 1) * sizeof (*ret->args));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->args[i] = strdup (str ? str : "");
                    if (ret->args[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "env", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->env_len = len;
            ret->env = safe_malloc ((len + 1) * sizeof (*ret->env));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->env[i] = strdup (str ? str : "");
                    if (ret->env[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "timeout", yajl_t_number);
        if (val) {
            ret->timeout = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->timeout_present = 1;
        }
    }
    if (ret->path == NULL) {
        if (asprintf (err, "Required field '%s' not present", "path") < 0)
            abort();
        free_oci_container_hooks_poststart_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_hooks_poststart_element (oci_container_hooks_poststart_element *ptr) {
    if (!ptr)
        return;
    free (ptr->path);
    ptr->path = NULL;
    if (ptr->args) {
        size_t i;
        for (i = 0; i < ptr->args_len; i++) {
            if (ptr->args[i]) {
                free (ptr->args[i]);
                ptr->args[i] = NULL;
            }
        }
        free (ptr->args);
        ptr->args = NULL;
    }
    if (ptr->env) {
        size_t i;
        for (i = 0; i < ptr->env_len; i++) {
            if (ptr->env[i]) {
                free (ptr->env[i]);
                ptr->env[i] = NULL;
            }
        }
        free (ptr->env);
        ptr->env = NULL;
    }
    free (ptr);
}

bool gen_oci_container_hooks_poststart_element (yajl_gen g, oci_container_hooks_poststart_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->path) {
        stat = reformat_map_key (g, (unsigned char *) "path", 4 /* strlen ("path") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->path, strlen (ptr->path));
        if (!stat)
            return false;
    }
    if (ptr->args) {
        stat = reformat_map_key (g, (unsigned char *) "args", 4 /* strlen ("args") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->args_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->args[i], strlen (ptr->args[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->env) {
        stat = reformat_map_key (g, (unsigned char *) "env", 3 /* strlen ("env") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->env_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->env[i], strlen (ptr->env[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->timeout_present) {
        stat = reformat_map_key (g, (unsigned char *)"timeout", 7 /* strlen ("timeout") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->timeout);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_hooks_poststop_element *make_oci_container_hooks_poststop_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_hooks_poststop_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "path", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->path = strdup (str ? str : "");
            if (ret->path == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "args", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->args_len = len;
            ret->args = safe_malloc ((len + 1) * sizeof (*ret->args));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->args[i] = strdup (str ? str : "");
                    if (ret->args[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "env", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->env_len = len;
            ret->env = safe_malloc ((len + 1) * sizeof (*ret->env));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->env[i] = strdup (str ? str : "");
                    if (ret->env[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "timeout", yajl_t_number);
        if (val) {
            ret->timeout = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->timeout_present = 1;
        }
    }
    if (ret->path == NULL) {
        if (asprintf (err, "Required field '%s' not present", "path") < 0)
            abort();
        free_oci_container_hooks_poststop_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_hooks_poststop_element (oci_container_hooks_poststop_element *ptr) {
    if (!ptr)
        return;
    free (ptr->path);
    ptr->path = NULL;
    if (ptr->args) {
        size_t i;
        for (i = 0; i < ptr->args_len; i++) {
            if (ptr->args[i]) {
                free (ptr->args[i]);
                ptr->args[i] = NULL;
            }
        }
        free (ptr->args);
        ptr->args = NULL;
    }
    if (ptr->env) {
        size_t i;
        for (i = 0; i < ptr->env_len; i++) {
            if (ptr->env[i]) {
                free (ptr->env[i]);
                ptr->env[i] = NULL;
            }
        }
        free (ptr->env);
        ptr->env = NULL;
    }
    free (ptr);
}

bool gen_oci_container_hooks_poststop_element (yajl_gen g, oci_container_hooks_poststop_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->path) {
        stat = reformat_map_key (g, (unsigned char *) "path", 4 /* strlen ("path") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->path, strlen (ptr->path));
        if (!stat)
            return false;
    }
    if (ptr->args) {
        stat = reformat_map_key (g, (unsigned char *) "args", 4 /* strlen ("args") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->args_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->args[i], strlen (ptr->args[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->env) {
        stat = reformat_map_key (g, (unsigned char *) "env", 3 /* strlen ("env") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->env_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->env[i], strlen (ptr->env[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->timeout_present) {
        stat = reformat_map_key (g, (unsigned char *)"timeout", 7 /* strlen ("timeout") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->timeout);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_hooks *make_oci_container_hooks (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_hooks *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val tmp = get_val (tree, "prestart", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->prestart_len = len;
            ret->prestart = safe_malloc ((len + 1) * sizeof (*ret->prestart));
            for (i = 0; i < len; i++) {
                ret->prestart[i] = make_oci_container_hooks_prestart_element (values[i], ctx, err);
                if (ret->prestart[i] == NULL) {
                    free_oci_container_hooks (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "poststart", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->poststart_len = len;
            ret->poststart = safe_malloc ((len + 1) * sizeof (*ret->poststart));
            for (i = 0; i < len; i++) {
                ret->poststart[i] = make_oci_container_hooks_poststart_element (values[i], ctx, err);
                if (ret->poststart[i] == NULL) {
                    free_oci_container_hooks (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "poststop", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->poststop_len = len;
            ret->poststop = safe_malloc ((len + 1) * sizeof (*ret->poststop));
            for (i = 0; i < len; i++) {
                ret->poststop[i] = make_oci_container_hooks_poststop_element (values[i], ctx, err);
                if (ret->poststop[i] == NULL) {
                    free_oci_container_hooks (ret);
                    return NULL;
                }
            }
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "prestart") &&
                strcmp (tree->u.object.keys[i], "poststart") &&
                strcmp (tree->u.object.keys[i], "poststop")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_hooks (oci_container_hooks *ptr) {
    if (!ptr)
        return;
    if (ptr->prestart) {
        size_t i;
        for (i = 0; i < ptr->prestart_len; i++)
            if (ptr->prestart[i]) {
                free_oci_container_hooks_prestart_element (ptr->prestart[i]);
                ptr->prestart[i] = NULL;
            }
        free (ptr->prestart);
        ptr->prestart = NULL;
    }
    if (ptr->poststart) {
        size_t i;
        for (i = 0; i < ptr->poststart_len; i++)
            if (ptr->poststart[i]) {
                free_oci_container_hooks_poststart_element (ptr->poststart[i]);
                ptr->poststart[i] = NULL;
            }
        free (ptr->poststart);
        ptr->poststart = NULL;
    }
    if (ptr->poststop) {
        size_t i;
        for (i = 0; i < ptr->poststop_len; i++)
            if (ptr->poststop[i]) {
                free_oci_container_hooks_poststop_element (ptr->poststop[i]);
                ptr->poststop[i] = NULL;
            }
        free (ptr->poststop);
        ptr->poststop = NULL;
    }
    free (ptr);
}

bool gen_oci_container_hooks (yajl_gen g, oci_container_hooks *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->prestart) {
        stat = reformat_map_key (g, (unsigned char *) "prestart", 8 /* strlen ("prestart") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->prestart_len; i++) {
            stat = gen_oci_container_hooks_prestart_element(g, ptr->prestart[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->poststart) {
        stat = reformat_map_key (g, (unsigned char *) "poststart", 9 /* strlen ("poststart") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->poststart_len; i++) {
            stat = gen_oci_container_hooks_poststart_element(g, ptr->poststart[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->poststop) {
        stat = reformat_map_key (g, (unsigned char *) "poststop", 8 /* strlen ("poststop") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->poststop_len; i++) {
            stat = gen_oci_container_hooks_poststop_element(g, ptr->poststop[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

void free_oci_container_annotations (oci_container_annotations *ptr) {
    if (!ptr)
        return;
    free_cells (ptr);
    ptr = NULL;
    free (ptr);
}

oci_container_mounts_element *make_oci_container_mounts_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_mounts_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "source", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->source = strdup (str ? str : "");
            if (ret->source == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "destination", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->destination = strdup (str ? str : "");
            if (ret->destination == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "options", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->options_len = len;
            ret->options = safe_malloc ((len + 1) * sizeof (*ret->options));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->options[i] = strdup (str ? str : "");
                    if (ret->options[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "type", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->type = strdup (str ? str : "");
            if (ret->type == NULL)
                abort ();
        }
    }
    if (ret->destination == NULL) {
        if (asprintf (err, "Required field '%s' not present", "destination") < 0)
            abort();
        free_oci_container_mounts_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_mounts_element (oci_container_mounts_element *ptr) {
    if (!ptr)
        return;
    free (ptr->source);
    ptr->source = NULL;
    free (ptr->destination);
    ptr->destination = NULL;
    if (ptr->options) {
        size_t i;
        for (i = 0; i < ptr->options_len; i++) {
            if (ptr->options[i]) {
                free (ptr->options[i]);
                ptr->options[i] = NULL;
            }
        }
        free (ptr->options);
        ptr->options = NULL;
    }
    free (ptr->type);
    ptr->type = NULL;
    free (ptr);
}

bool gen_oci_container_mounts_element (yajl_gen g, oci_container_mounts_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->source) {
        stat = reformat_map_key (g, (unsigned char *) "source", 6 /* strlen ("source") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->source, strlen (ptr->source));
        if (!stat)
            return false;
    }
    if (ptr->destination) {
        stat = reformat_map_key (g, (unsigned char *) "destination", 11 /* strlen ("destination") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->destination, strlen (ptr->destination));
        if (!stat)
            return false;
    }
    if (ptr->options) {
        stat = reformat_map_key (g, (unsigned char *) "options", 7 /* strlen ("options") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->options_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->options[i], strlen (ptr->options[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->type) {
        stat = reformat_map_key (g, (unsigned char *) "type", 4 /* strlen ("type") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->type, strlen (ptr->type));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_root *make_oci_container_root (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_root *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "path", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->path = strdup (str ? str : "");
            if (ret->path == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "readonly", yajl_t_true);
        if (val) {
            ret->readonly = YAJL_IS_TRUE (val);
            ret->readonly_present = 1;
        }
    }
    if (ret->path == NULL) {
        if (asprintf (err, "Required field '%s' not present", "path") < 0)
            abort();
        free_oci_container_root (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "path") &&
                strcmp (tree->u.object.keys[i], "readonly")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_root (oci_container_root *ptr) {
    if (!ptr)
        return;
    free (ptr->path);
    ptr->path = NULL;
    free (ptr);
}

bool gen_oci_container_root (yajl_gen g, oci_container_root *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->path) {
        stat = reformat_map_key (g, (unsigned char *) "path", 4 /* strlen ("path") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->path, strlen (ptr->path));
        if (!stat)
            return false;
    }
    if (ptr->readonly_present) {
        stat = reformat_map_key (g, (unsigned char *)"readonly", 8 /* strlen ("readonly") */);
        if (!stat)
            return false;
        stat = reformat_boolean (g, 1);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_process_console_size *make_oci_container_process_console_size (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_process_console_size *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "height", yajl_t_number);
        if (val) {
            ret->height = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->height_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "width", yajl_t_number);
        if (val) {
            ret->width = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->width_present = 1;
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "height") &&
                strcmp (tree->u.object.keys[i], "width")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_process_console_size (oci_container_process_console_size *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_process_console_size (yajl_gen g, oci_container_process_console_size *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->height_present) {
        stat = reformat_map_key (g, (unsigned char *)"height", 6 /* strlen ("height") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->height);
        if (!stat)
            return false;
    }
    if (ptr->width_present) {
        stat = reformat_map_key (g, (unsigned char *)"width", 5 /* strlen ("width") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->width);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_process_user *make_oci_container_process_user (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_process_user *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "uid", yajl_t_number);
        if (val) {
            ret->uid = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->uid_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "gid", yajl_t_number);
        if (val) {
            ret->gid = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->gid_present = 1;
        }
    }
    {
        yajl_val tmp = get_val (tree, "additionalGids", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->additional_gids_len = len;
            ret->additional_gids = safe_malloc ((len + 1) * sizeof (*ret->additional_gids));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    ret->additional_gids[i] = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "username", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->username = strdup (str ? str : "");
            if (ret->username == NULL)
                abort ();
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "uid") &&
                strcmp (tree->u.object.keys[i], "gid") &&
                strcmp (tree->u.object.keys[i], "additionalGids") &&
                strcmp (tree->u.object.keys[i], "username")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_process_user (oci_container_process_user *ptr) {
    if (!ptr)
        return;
   if (ptr->additional_gids)
     free (ptr->additional_gids);
    free (ptr->username);
    ptr->username = NULL;
    free (ptr);
}

bool gen_oci_container_process_user (yajl_gen g, oci_container_process_user *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->uid_present) {
        stat = reformat_map_key (g, (unsigned char *)"uid", 3 /* strlen ("uid") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->uid);
        if (!stat)
            return false;
    }
    if (ptr->gid_present) {
        stat = reformat_map_key (g, (unsigned char *)"gid", 3 /* strlen ("gid") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->gid);
        if (!stat)
            return false;
    }
    if (ptr->additional_gids) {
        stat = reformat_map_key (g, (unsigned char *) "additionalGids", 14 /* strlen ("additionalGids") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->additional_gids_len; i++) {
            stat = reformat_integer (g, ptr->additional_gids[i]);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->username) {
        stat = reformat_map_key (g, (unsigned char *) "username", 8 /* strlen ("username") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->username, strlen (ptr->username));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_process_capabilities *make_oci_container_process_capabilities (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_process_capabilities *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val tmp = get_val (tree, "bounding", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->bounding_len = len;
            ret->bounding = safe_malloc ((len + 1) * sizeof (*ret->bounding));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->bounding[i] = strdup (str ? str : "");
                    if (ret->bounding[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "permitted", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->permitted_len = len;
            ret->permitted = safe_malloc ((len + 1) * sizeof (*ret->permitted));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->permitted[i] = strdup (str ? str : "");
                    if (ret->permitted[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "effective", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->effective_len = len;
            ret->effective = safe_malloc ((len + 1) * sizeof (*ret->effective));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->effective[i] = strdup (str ? str : "");
                    if (ret->effective[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "inheritable", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->inheritable_len = len;
            ret->inheritable = safe_malloc ((len + 1) * sizeof (*ret->inheritable));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->inheritable[i] = strdup (str ? str : "");
                    if (ret->inheritable[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "ambient", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->ambient_len = len;
            ret->ambient = safe_malloc ((len + 1) * sizeof (*ret->ambient));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->ambient[i] = strdup (str ? str : "");
                    if (ret->ambient[i] == NULL)
                        abort ();
                }
            }
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "bounding") &&
                strcmp (tree->u.object.keys[i], "permitted") &&
                strcmp (tree->u.object.keys[i], "effective") &&
                strcmp (tree->u.object.keys[i], "inheritable") &&
                strcmp (tree->u.object.keys[i], "ambient")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_process_capabilities (oci_container_process_capabilities *ptr) {
    if (!ptr)
        return;
    if (ptr->bounding) {
        size_t i;
        for (i = 0; i < ptr->bounding_len; i++) {
            if (ptr->bounding[i]) {
                free (ptr->bounding[i]);
                ptr->bounding[i] = NULL;
            }
        }
        free (ptr->bounding);
        ptr->bounding = NULL;
    }
    if (ptr->permitted) {
        size_t i;
        for (i = 0; i < ptr->permitted_len; i++) {
            if (ptr->permitted[i]) {
                free (ptr->permitted[i]);
                ptr->permitted[i] = NULL;
            }
        }
        free (ptr->permitted);
        ptr->permitted = NULL;
    }
    if (ptr->effective) {
        size_t i;
        for (i = 0; i < ptr->effective_len; i++) {
            if (ptr->effective[i]) {
                free (ptr->effective[i]);
                ptr->effective[i] = NULL;
            }
        }
        free (ptr->effective);
        ptr->effective = NULL;
    }
    if (ptr->inheritable) {
        size_t i;
        for (i = 0; i < ptr->inheritable_len; i++) {
            if (ptr->inheritable[i]) {
                free (ptr->inheritable[i]);
                ptr->inheritable[i] = NULL;
            }
        }
        free (ptr->inheritable);
        ptr->inheritable = NULL;
    }
    if (ptr->ambient) {
        size_t i;
        for (i = 0; i < ptr->ambient_len; i++) {
            if (ptr->ambient[i]) {
                free (ptr->ambient[i]);
                ptr->ambient[i] = NULL;
            }
        }
        free (ptr->ambient);
        ptr->ambient = NULL;
    }
    free (ptr);
}

bool gen_oci_container_process_capabilities (yajl_gen g, oci_container_process_capabilities *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->bounding) {
        stat = reformat_map_key (g, (unsigned char *) "bounding", 8 /* strlen ("bounding") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->bounding_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->bounding[i], strlen (ptr->bounding[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->permitted) {
        stat = reformat_map_key (g, (unsigned char *) "permitted", 9 /* strlen ("permitted") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->permitted_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->permitted[i], strlen (ptr->permitted[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->effective) {
        stat = reformat_map_key (g, (unsigned char *) "effective", 9 /* strlen ("effective") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->effective_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->effective[i], strlen (ptr->effective[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->inheritable) {
        stat = reformat_map_key (g, (unsigned char *) "inheritable", 11 /* strlen ("inheritable") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->inheritable_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->inheritable[i], strlen (ptr->inheritable[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->ambient) {
        stat = reformat_map_key (g, (unsigned char *) "ambient", 7 /* strlen ("ambient") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->ambient_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->ambient[i], strlen (ptr->ambient[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_process_rlimits_element *make_oci_container_process_rlimits_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_process_rlimits_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "hard", yajl_t_number);
        if (val) {
            ret->hard = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->hard_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "soft", yajl_t_number);
        if (val) {
            ret->soft = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->soft_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "type", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->type = strdup (str ? str : "");
            if (ret->type == NULL)
                abort ();
        }
    }
    if (ret->type == NULL) {
        if (asprintf (err, "Required field '%s' not present", "type") < 0)
            abort();
        free_oci_container_process_rlimits_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_process_rlimits_element (oci_container_process_rlimits_element *ptr) {
    if (!ptr)
        return;
    free (ptr->type);
    ptr->type = NULL;
    free (ptr);
}

bool gen_oci_container_process_rlimits_element (yajl_gen g, oci_container_process_rlimits_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->hard_present) {
        stat = reformat_map_key (g, (unsigned char *)"hard", 4 /* strlen ("hard") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->hard);
        if (!stat)
            return false;
    }
    if (ptr->soft_present) {
        stat = reformat_map_key (g, (unsigned char *)"soft", 4 /* strlen ("soft") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->soft);
        if (!stat)
            return false;
    }
    if (ptr->type) {
        stat = reformat_map_key (g, (unsigned char *) "type", 4 /* strlen ("type") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->type, strlen (ptr->type));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_process *make_oci_container_process (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_process *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val tmp = get_val (tree, "args", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->args_len = len;
            ret->args = safe_malloc ((len + 1) * sizeof (*ret->args));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->args[i] = strdup (str ? str : "");
                    if (ret->args[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "commandLine", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->command_line = strdup (str ? str : "");
            if (ret->command_line == NULL)
                abort ();
        }
    }
    ret->console_size = make_oci_container_process_console_size (get_val (tree, "consoleSize", yajl_t_object), ctx, err);
    if (ret->console_size == NULL && *err != 0) {
        free_oci_container_process (ret);
        return NULL;
    }
    {
        yajl_val val = get_val (tree, "cwd", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->cwd = strdup (str ? str : "");
            if (ret->cwd == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "env", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->env_len = len;
            ret->env = safe_malloc ((len + 1) * sizeof (*ret->env));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->env[i] = strdup (str ? str : "");
                    if (ret->env[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "terminal", yajl_t_true);
        if (val) {
            ret->terminal = YAJL_IS_TRUE (val);
            ret->terminal_present = 1;
        }
    }
    ret->user = make_oci_container_process_user (get_val (tree, "user", yajl_t_object), ctx, err);
    if (ret->user == NULL && *err != 0) {
        free_oci_container_process (ret);
        return NULL;
    }
    ret->capabilities = make_oci_container_process_capabilities (get_val (tree, "capabilities", yajl_t_object), ctx, err);
    if (ret->capabilities == NULL && *err != 0) {
        free_oci_container_process (ret);
        return NULL;
    }
    {
        yajl_val val = get_val (tree, "apparmorProfile", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->apparmor_profile = strdup (str ? str : "");
            if (ret->apparmor_profile == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "oomScoreAdj", yajl_t_number);
        if (val) {
            ret->oom_score_adj = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->oom_score_adj_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "selinuxLabel", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->selinux_label = strdup (str ? str : "");
            if (ret->selinux_label == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "noNewPrivileges", yajl_t_true);
        if (val) {
            ret->no_new_privileges = YAJL_IS_TRUE (val);
            ret->no_new_privileges_present = 1;
        }
    }
    {
        yajl_val tmp = get_val (tree, "rlimits", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->rlimits_len = len;
            ret->rlimits = safe_malloc ((len + 1) * sizeof (*ret->rlimits));
            for (i = 0; i < len; i++) {
                ret->rlimits[i] = make_oci_container_process_rlimits_element (values[i], ctx, err);
                if (ret->rlimits[i] == NULL) {
                    free_oci_container_process (ret);
                    return NULL;
                }
            }
        }
    }
    if (ret->cwd == NULL) {
        if (asprintf (err, "Required field '%s' not present", "cwd") < 0)
            abort();
        free_oci_container_process (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "args") &&
                strcmp (tree->u.object.keys[i], "commandLine") &&
                strcmp (tree->u.object.keys[i], "consoleSize") &&
                strcmp (tree->u.object.keys[i], "cwd") &&
                strcmp (tree->u.object.keys[i], "env") &&
                strcmp (tree->u.object.keys[i], "terminal") &&
                strcmp (tree->u.object.keys[i], "user") &&
                strcmp (tree->u.object.keys[i], "capabilities") &&
                strcmp (tree->u.object.keys[i], "apparmorProfile") &&
                strcmp (tree->u.object.keys[i], "oomScoreAdj") &&
                strcmp (tree->u.object.keys[i], "selinuxLabel") &&
                strcmp (tree->u.object.keys[i], "noNewPrivileges") &&
                strcmp (tree->u.object.keys[i], "rlimits")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_process (oci_container_process *ptr) {
    if (!ptr)
        return;
    if (ptr->args) {
        size_t i;
        for (i = 0; i < ptr->args_len; i++) {
            if (ptr->args[i]) {
                free (ptr->args[i]);
                ptr->args[i] = NULL;
            }
        }
        free (ptr->args);
        ptr->args = NULL;
    }
    free (ptr->command_line);
    ptr->command_line = NULL;
    if (ptr->console_size) {
        free_oci_container_process_console_size (ptr->console_size);
        ptr->console_size = NULL;
    }
    free (ptr->cwd);
    ptr->cwd = NULL;
    if (ptr->env) {
        size_t i;
        for (i = 0; i < ptr->env_len; i++) {
            if (ptr->env[i]) {
                free (ptr->env[i]);
                ptr->env[i] = NULL;
            }
        }
        free (ptr->env);
        ptr->env = NULL;
    }
    if (ptr->user) {
        free_oci_container_process_user (ptr->user);
        ptr->user = NULL;
    }
    if (ptr->capabilities) {
        free_oci_container_process_capabilities (ptr->capabilities);
        ptr->capabilities = NULL;
    }
    free (ptr->apparmor_profile);
    ptr->apparmor_profile = NULL;
    free (ptr->selinux_label);
    ptr->selinux_label = NULL;
    if (ptr->rlimits) {
        size_t i;
        for (i = 0; i < ptr->rlimits_len; i++)
            if (ptr->rlimits[i]) {
                free_oci_container_process_rlimits_element (ptr->rlimits[i]);
                ptr->rlimits[i] = NULL;
            }
        free (ptr->rlimits);
        ptr->rlimits = NULL;
    }
    free (ptr);
}

bool gen_oci_container_process (yajl_gen g, oci_container_process *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->args) {
        stat = reformat_map_key (g, (unsigned char *) "args", 4 /* strlen ("args") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->args_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->args[i], strlen (ptr->args[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->command_line) {
        stat = reformat_map_key (g, (unsigned char *) "commandLine", 11 /* strlen ("commandLine") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->command_line, strlen (ptr->command_line));
        if (!stat)
            return false;
    }
    if (ptr->console_size) {
        stat = reformat_map_key (g, (unsigned char *) "consoleSize", 11 /* strlen ("consoleSize") */);
        if (!stat)
            return false;
        stat = gen_oci_container_process_console_size (g, ptr->console_size, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->cwd) {
        stat = reformat_map_key (g, (unsigned char *) "cwd", 3 /* strlen ("cwd") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->cwd, strlen (ptr->cwd));
        if (!stat)
            return false;
    }
    if (ptr->env) {
        stat = reformat_map_key (g, (unsigned char *) "env", 3 /* strlen ("env") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->env_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->env[i], strlen (ptr->env[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->terminal_present) {
        stat = reformat_map_key (g, (unsigned char *)"terminal", 8 /* strlen ("terminal") */);
        if (!stat)
            return false;
        stat = reformat_boolean (g, 1);
        if (!stat)
            return false;
    }
    if (ptr->user) {
        stat = reformat_map_key (g, (unsigned char *) "user", 4 /* strlen ("user") */);
        if (!stat)
            return false;
        stat = gen_oci_container_process_user (g, ptr->user, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->capabilities) {
        stat = reformat_map_key (g, (unsigned char *) "capabilities", 12 /* strlen ("capabilities") */);
        if (!stat)
            return false;
        stat = gen_oci_container_process_capabilities (g, ptr->capabilities, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->apparmor_profile) {
        stat = reformat_map_key (g, (unsigned char *) "apparmorProfile", 15 /* strlen ("apparmorProfile") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->apparmor_profile, strlen (ptr->apparmor_profile));
        if (!stat)
            return false;
    }
    if (ptr->oom_score_adj_present) {
        stat = reformat_map_key (g, (unsigned char *)"oomScoreAdj", 11 /* strlen ("oomScoreAdj") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->oom_score_adj);
        if (!stat)
            return false;
    }
    if (ptr->selinux_label) {
        stat = reformat_map_key (g, (unsigned char *) "selinuxLabel", 12 /* strlen ("selinuxLabel") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->selinux_label, strlen (ptr->selinux_label));
        if (!stat)
            return false;
    }
    if (ptr->no_new_privileges_present) {
        stat = reformat_map_key (g, (unsigned char *)"noNewPrivileges", 15 /* strlen ("noNewPrivileges") */);
        if (!stat)
            return false;
        stat = reformat_boolean (g, 1);
        if (!stat)
            return false;
    }
    if (ptr->rlimits) {
        stat = reformat_map_key (g, (unsigned char *) "rlimits", 7 /* strlen ("rlimits") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->rlimits_len; i++) {
            stat = gen_oci_container_process_rlimits_element(g, ptr->rlimits[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_devices_element *make_oci_container_linux_devices_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_devices_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "type", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->type = strdup (str ? str : "");
            if (ret->type == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "path", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->path = strdup (str ? str : "");
            if (ret->path == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "fileMode", yajl_t_number);
        if (val) {
            ret->file_mode = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->file_mode_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "major", yajl_t_number);
        if (val) {
            ret->major = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->major_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "minor", yajl_t_number);
        if (val) {
            ret->minor = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->minor_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "uid", yajl_t_number);
        if (val) {
            ret->uid = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->uid_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "gid", yajl_t_number);
        if (val) {
            ret->gid = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->gid_present = 1;
        }
    }
    if (ret->type == NULL) {
        if (asprintf (err, "Required field '%s' not present", "type") < 0)
            abort();
        free_oci_container_linux_devices_element (ret);
        return NULL;
    }
    if (ret->path == NULL) {
        if (asprintf (err, "Required field '%s' not present", "path") < 0)
            abort();
        free_oci_container_linux_devices_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_linux_devices_element (oci_container_linux_devices_element *ptr) {
    if (!ptr)
        return;
    free (ptr->type);
    ptr->type = NULL;
    free (ptr->path);
    ptr->path = NULL;
    free (ptr);
}

bool gen_oci_container_linux_devices_element (yajl_gen g, oci_container_linux_devices_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->type) {
        stat = reformat_map_key (g, (unsigned char *) "type", 4 /* strlen ("type") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->type, strlen (ptr->type));
        if (!stat)
            return false;
    }
    if (ptr->path) {
        stat = reformat_map_key (g, (unsigned char *) "path", 4 /* strlen ("path") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->path, strlen (ptr->path));
        if (!stat)
            return false;
    }
    if (ptr->file_mode_present) {
        stat = reformat_map_key (g, (unsigned char *)"fileMode", 8 /* strlen ("fileMode") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->file_mode);
        if (!stat)
            return false;
    }
    if (ptr->major_present) {
        stat = reformat_map_key (g, (unsigned char *)"major", 5 /* strlen ("major") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->major);
        if (!stat)
            return false;
    }
    if (ptr->minor_present) {
        stat = reformat_map_key (g, (unsigned char *)"minor", 5 /* strlen ("minor") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->minor);
        if (!stat)
            return false;
    }
    if (ptr->uid_present) {
        stat = reformat_map_key (g, (unsigned char *)"uid", 3 /* strlen ("uid") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->uid);
        if (!stat)
            return false;
    }
    if (ptr->gid_present) {
        stat = reformat_map_key (g, (unsigned char *)"gid", 3 /* strlen ("gid") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->gid);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_uid_mappings_element *make_oci_container_linux_uid_mappings_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_uid_mappings_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "containerID", yajl_t_number);
        if (val) {
            ret->container_id = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->container_id_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "hostID", yajl_t_number);
        if (val) {
            ret->host_id = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->host_id_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "size", yajl_t_number);
        if (val) {
            ret->size = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->size_present = 1;
        }
    }
    return ret;
}

void free_oci_container_linux_uid_mappings_element (oci_container_linux_uid_mappings_element *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_uid_mappings_element (yajl_gen g, oci_container_linux_uid_mappings_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->container_id_present) {
        stat = reformat_map_key (g, (unsigned char *)"containerID", 11 /* strlen ("containerID") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->container_id);
        if (!stat)
            return false;
    }
    if (ptr->host_id_present) {
        stat = reformat_map_key (g, (unsigned char *)"hostID", 6 /* strlen ("hostID") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->host_id);
        if (!stat)
            return false;
    }
    if (ptr->size_present) {
        stat = reformat_map_key (g, (unsigned char *)"size", 4 /* strlen ("size") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->size);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_gid_mappings_element *make_oci_container_linux_gid_mappings_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_gid_mappings_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "containerID", yajl_t_number);
        if (val) {
            ret->container_id = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->container_id_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "hostID", yajl_t_number);
        if (val) {
            ret->host_id = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->host_id_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "size", yajl_t_number);
        if (val) {
            ret->size = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->size_present = 1;
        }
    }
    return ret;
}

void free_oci_container_linux_gid_mappings_element (oci_container_linux_gid_mappings_element *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_gid_mappings_element (yajl_gen g, oci_container_linux_gid_mappings_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->container_id_present) {
        stat = reformat_map_key (g, (unsigned char *)"containerID", 11 /* strlen ("containerID") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->container_id);
        if (!stat)
            return false;
    }
    if (ptr->host_id_present) {
        stat = reformat_map_key (g, (unsigned char *)"hostID", 6 /* strlen ("hostID") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->host_id);
        if (!stat)
            return false;
    }
    if (ptr->size_present) {
        stat = reformat_map_key (g, (unsigned char *)"size", 4 /* strlen ("size") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->size);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_namespaces_element *make_oci_container_linux_namespaces_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_namespaces_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "type", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->type = strdup (str ? str : "");
            if (ret->type == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "path", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->path = strdup (str ? str : "");
            if (ret->path == NULL)
                abort ();
        }
    }
    return ret;
}

void free_oci_container_linux_namespaces_element (oci_container_linux_namespaces_element *ptr) {
    if (!ptr)
        return;
    free (ptr->type);
    ptr->type = NULL;
    free (ptr->path);
    ptr->path = NULL;
    free (ptr);
}

bool gen_oci_container_linux_namespaces_element (yajl_gen g, oci_container_linux_namespaces_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->type) {
        stat = reformat_map_key (g, (unsigned char *) "type", 4 /* strlen ("type") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->type, strlen (ptr->type));
        if (!stat)
            return false;
    }
    if (ptr->path) {
        stat = reformat_map_key (g, (unsigned char *) "path", 4 /* strlen ("path") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->path, strlen (ptr->path));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_devices_element *make_oci_container_linux_resources_devices_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_devices_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "allow", yajl_t_true);
        if (val) {
            ret->allow = YAJL_IS_TRUE (val);
            ret->allow_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "type", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->type = strdup (str ? str : "");
            if (ret->type == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "major", yajl_t_number);
        if (val) {
            ret->major = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->major_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "minor", yajl_t_number);
        if (val) {
            ret->minor = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->minor_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "access", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->access = strdup (str ? str : "");
            if (ret->access == NULL)
                abort ();
        }
    }
    return ret;
}

void free_oci_container_linux_resources_devices_element (oci_container_linux_resources_devices_element *ptr) {
    if (!ptr)
        return;
    free (ptr->type);
    ptr->type = NULL;
    free (ptr->access);
    ptr->access = NULL;
    free (ptr);
}

bool gen_oci_container_linux_resources_devices_element (yajl_gen g, oci_container_linux_resources_devices_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->allow_present) {
        stat = reformat_map_key (g, (unsigned char *)"allow", 5 /* strlen ("allow") */);
        if (!stat)
            return false;
        stat = reformat_boolean (g, 1);
        if (!stat)
            return false;
    }
    if (ptr->type) {
        stat = reformat_map_key (g, (unsigned char *) "type", 4 /* strlen ("type") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->type, strlen (ptr->type));
        if (!stat)
            return false;
    }
    if (ptr->major_present) {
        stat = reformat_map_key (g, (unsigned char *)"major", 5 /* strlen ("major") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->major);
        if (!stat)
            return false;
    }
    if (ptr->minor_present) {
        stat = reformat_map_key (g, (unsigned char *)"minor", 5 /* strlen ("minor") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->minor);
        if (!stat)
            return false;
    }
    if (ptr->access) {
        stat = reformat_map_key (g, (unsigned char *) "access", 6 /* strlen ("access") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->access, strlen (ptr->access));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_pids *make_oci_container_linux_resources_pids (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_pids *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "limit", yajl_t_number);
        if (val) {
            ret->limit = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->limit_present = 1;
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "limit")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_linux_resources_pids (oci_container_linux_resources_pids *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_resources_pids (yajl_gen g, oci_container_linux_resources_pids *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->limit_present) {
        stat = reformat_map_key (g, (unsigned char *)"limit", 5 /* strlen ("limit") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->limit);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_block_io_throttle_read_bps_device_element *make_oci_container_linux_resources_block_io_throttle_read_bps_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_block_io_throttle_read_bps_device_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "major", yajl_t_number);
        if (val) {
            ret->major = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->major_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "minor", yajl_t_number);
        if (val) {
            ret->minor = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->minor_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "rate", yajl_t_number);
        if (val) {
            ret->rate = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->rate_present = 1;
        }
    }
    return ret;
}

void free_oci_container_linux_resources_block_io_throttle_read_bps_device_element (oci_container_linux_resources_block_io_throttle_read_bps_device_element *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_resources_block_io_throttle_read_bps_device_element (yajl_gen g, oci_container_linux_resources_block_io_throttle_read_bps_device_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->major_present) {
        stat = reformat_map_key (g, (unsigned char *)"major", 5 /* strlen ("major") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->major);
        if (!stat)
            return false;
    }
    if (ptr->minor_present) {
        stat = reformat_map_key (g, (unsigned char *)"minor", 5 /* strlen ("minor") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->minor);
        if (!stat)
            return false;
    }
    if (ptr->rate_present) {
        stat = reformat_map_key (g, (unsigned char *)"rate", 4 /* strlen ("rate") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->rate);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_block_io_throttle_write_bps_device_element *make_oci_container_linux_resources_block_io_throttle_write_bps_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_block_io_throttle_write_bps_device_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "major", yajl_t_number);
        if (val) {
            ret->major = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->major_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "minor", yajl_t_number);
        if (val) {
            ret->minor = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->minor_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "rate", yajl_t_number);
        if (val) {
            ret->rate = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->rate_present = 1;
        }
    }
    return ret;
}

void free_oci_container_linux_resources_block_io_throttle_write_bps_device_element (oci_container_linux_resources_block_io_throttle_write_bps_device_element *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_resources_block_io_throttle_write_bps_device_element (yajl_gen g, oci_container_linux_resources_block_io_throttle_write_bps_device_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->major_present) {
        stat = reformat_map_key (g, (unsigned char *)"major", 5 /* strlen ("major") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->major);
        if (!stat)
            return false;
    }
    if (ptr->minor_present) {
        stat = reformat_map_key (g, (unsigned char *)"minor", 5 /* strlen ("minor") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->minor);
        if (!stat)
            return false;
    }
    if (ptr->rate_present) {
        stat = reformat_map_key (g, (unsigned char *)"rate", 4 /* strlen ("rate") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->rate);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_block_io_throttle_read_iops_device_element *make_oci_container_linux_resources_block_io_throttle_read_iops_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_block_io_throttle_read_iops_device_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "major", yajl_t_number);
        if (val) {
            ret->major = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->major_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "minor", yajl_t_number);
        if (val) {
            ret->minor = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->minor_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "rate", yajl_t_number);
        if (val) {
            ret->rate = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->rate_present = 1;
        }
    }
    return ret;
}

void free_oci_container_linux_resources_block_io_throttle_read_iops_device_element (oci_container_linux_resources_block_io_throttle_read_iops_device_element *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_resources_block_io_throttle_read_iops_device_element (yajl_gen g, oci_container_linux_resources_block_io_throttle_read_iops_device_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->major_present) {
        stat = reformat_map_key (g, (unsigned char *)"major", 5 /* strlen ("major") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->major);
        if (!stat)
            return false;
    }
    if (ptr->minor_present) {
        stat = reformat_map_key (g, (unsigned char *)"minor", 5 /* strlen ("minor") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->minor);
        if (!stat)
            return false;
    }
    if (ptr->rate_present) {
        stat = reformat_map_key (g, (unsigned char *)"rate", 4 /* strlen ("rate") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->rate);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_block_io_throttle_write_iops_device_element *make_oci_container_linux_resources_block_io_throttle_write_iops_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_block_io_throttle_write_iops_device_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "major", yajl_t_number);
        if (val) {
            ret->major = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->major_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "minor", yajl_t_number);
        if (val) {
            ret->minor = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->minor_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "rate", yajl_t_number);
        if (val) {
            ret->rate = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->rate_present = 1;
        }
    }
    return ret;
}

void free_oci_container_linux_resources_block_io_throttle_write_iops_device_element (oci_container_linux_resources_block_io_throttle_write_iops_device_element *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_resources_block_io_throttle_write_iops_device_element (yajl_gen g, oci_container_linux_resources_block_io_throttle_write_iops_device_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->major_present) {
        stat = reformat_map_key (g, (unsigned char *)"major", 5 /* strlen ("major") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->major);
        if (!stat)
            return false;
    }
    if (ptr->minor_present) {
        stat = reformat_map_key (g, (unsigned char *)"minor", 5 /* strlen ("minor") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->minor);
        if (!stat)
            return false;
    }
    if (ptr->rate_present) {
        stat = reformat_map_key (g, (unsigned char *)"rate", 4 /* strlen ("rate") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->rate);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_block_io_weight_device_element *make_oci_container_linux_resources_block_io_weight_device_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_block_io_weight_device_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "major", yajl_t_number);
        if (val) {
            ret->major = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->major_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "minor", yajl_t_number);
        if (val) {
            ret->minor = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->minor_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "weight", yajl_t_number);
        if (val) {
            ret->weight = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->weight_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "leafWeight", yajl_t_number);
        if (val) {
            ret->leaf_weight = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->leaf_weight_present = 1;
        }
    }
    return ret;
}

void free_oci_container_linux_resources_block_io_weight_device_element (oci_container_linux_resources_block_io_weight_device_element *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_resources_block_io_weight_device_element (yajl_gen g, oci_container_linux_resources_block_io_weight_device_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->major_present) {
        stat = reformat_map_key (g, (unsigned char *)"major", 5 /* strlen ("major") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->major);
        if (!stat)
            return false;
    }
    if (ptr->minor_present) {
        stat = reformat_map_key (g, (unsigned char *)"minor", 5 /* strlen ("minor") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->minor);
        if (!stat)
            return false;
    }
    if (ptr->weight_present) {
        stat = reformat_map_key (g, (unsigned char *)"weight", 6 /* strlen ("weight") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->weight);
        if (!stat)
            return false;
    }
    if (ptr->leaf_weight_present) {
        stat = reformat_map_key (g, (unsigned char *)"leafWeight", 10 /* strlen ("leafWeight") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->leaf_weight);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_block_io *make_oci_container_linux_resources_block_io (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_block_io *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "weight", yajl_t_number);
        if (val) {
            ret->weight = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->weight_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "leafWeight", yajl_t_number);
        if (val) {
            ret->leaf_weight = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->leaf_weight_present = 1;
        }
    }
    {
        yajl_val tmp = get_val (tree, "throttleReadBpsDevice", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->throttle_read_bps_device_len = len;
            ret->throttle_read_bps_device = safe_malloc ((len + 1) * sizeof (*ret->throttle_read_bps_device));
            for (i = 0; i < len; i++) {
                ret->throttle_read_bps_device[i] = make_oci_container_linux_resources_block_io_throttle_read_bps_device_element (values[i], ctx, err);
                if (ret->throttle_read_bps_device[i] == NULL) {
                    free_oci_container_linux_resources_block_io (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "throttleWriteBpsDevice", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->throttle_write_bps_device_len = len;
            ret->throttle_write_bps_device = safe_malloc ((len + 1) * sizeof (*ret->throttle_write_bps_device));
            for (i = 0; i < len; i++) {
                ret->throttle_write_bps_device[i] = make_oci_container_linux_resources_block_io_throttle_write_bps_device_element (values[i], ctx, err);
                if (ret->throttle_write_bps_device[i] == NULL) {
                    free_oci_container_linux_resources_block_io (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "throttleReadIOPSDevice", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->throttle_read_iops_device_len = len;
            ret->throttle_read_iops_device = safe_malloc ((len + 1) * sizeof (*ret->throttle_read_iops_device));
            for (i = 0; i < len; i++) {
                ret->throttle_read_iops_device[i] = make_oci_container_linux_resources_block_io_throttle_read_iops_device_element (values[i], ctx, err);
                if (ret->throttle_read_iops_device[i] == NULL) {
                    free_oci_container_linux_resources_block_io (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "throttleWriteIOPSDevice", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->throttle_write_iops_device_len = len;
            ret->throttle_write_iops_device = safe_malloc ((len + 1) * sizeof (*ret->throttle_write_iops_device));
            for (i = 0; i < len; i++) {
                ret->throttle_write_iops_device[i] = make_oci_container_linux_resources_block_io_throttle_write_iops_device_element (values[i], ctx, err);
                if (ret->throttle_write_iops_device[i] == NULL) {
                    free_oci_container_linux_resources_block_io (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "weightDevice", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->weight_device_len = len;
            ret->weight_device = safe_malloc ((len + 1) * sizeof (*ret->weight_device));
            for (i = 0; i < len; i++) {
                ret->weight_device[i] = make_oci_container_linux_resources_block_io_weight_device_element (values[i], ctx, err);
                if (ret->weight_device[i] == NULL) {
                    free_oci_container_linux_resources_block_io (ret);
                    return NULL;
                }
            }
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "weight") &&
                strcmp (tree->u.object.keys[i], "leafWeight") &&
                strcmp (tree->u.object.keys[i], "throttleReadBpsDevice") &&
                strcmp (tree->u.object.keys[i], "throttleWriteBpsDevice") &&
                strcmp (tree->u.object.keys[i], "throttleReadIOPSDevice") &&
                strcmp (tree->u.object.keys[i], "throttleWriteIOPSDevice") &&
                strcmp (tree->u.object.keys[i], "weightDevice")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_linux_resources_block_io (oci_container_linux_resources_block_io *ptr) {
    if (!ptr)
        return;
    if (ptr->throttle_read_bps_device) {
        size_t i;
        for (i = 0; i < ptr->throttle_read_bps_device_len; i++)
            if (ptr->throttle_read_bps_device[i]) {
                free_oci_container_linux_resources_block_io_throttle_read_bps_device_element (ptr->throttle_read_bps_device[i]);
                ptr->throttle_read_bps_device[i] = NULL;
            }
        free (ptr->throttle_read_bps_device);
        ptr->throttle_read_bps_device = NULL;
    }
    if (ptr->throttle_write_bps_device) {
        size_t i;
        for (i = 0; i < ptr->throttle_write_bps_device_len; i++)
            if (ptr->throttle_write_bps_device[i]) {
                free_oci_container_linux_resources_block_io_throttle_write_bps_device_element (ptr->throttle_write_bps_device[i]);
                ptr->throttle_write_bps_device[i] = NULL;
            }
        free (ptr->throttle_write_bps_device);
        ptr->throttle_write_bps_device = NULL;
    }
    if (ptr->throttle_read_iops_device) {
        size_t i;
        for (i = 0; i < ptr->throttle_read_iops_device_len; i++)
            if (ptr->throttle_read_iops_device[i]) {
                free_oci_container_linux_resources_block_io_throttle_read_iops_device_element (ptr->throttle_read_iops_device[i]);
                ptr->throttle_read_iops_device[i] = NULL;
            }
        free (ptr->throttle_read_iops_device);
        ptr->throttle_read_iops_device = NULL;
    }
    if (ptr->throttle_write_iops_device) {
        size_t i;
        for (i = 0; i < ptr->throttle_write_iops_device_len; i++)
            if (ptr->throttle_write_iops_device[i]) {
                free_oci_container_linux_resources_block_io_throttle_write_iops_device_element (ptr->throttle_write_iops_device[i]);
                ptr->throttle_write_iops_device[i] = NULL;
            }
        free (ptr->throttle_write_iops_device);
        ptr->throttle_write_iops_device = NULL;
    }
    if (ptr->weight_device) {
        size_t i;
        for (i = 0; i < ptr->weight_device_len; i++)
            if (ptr->weight_device[i]) {
                free_oci_container_linux_resources_block_io_weight_device_element (ptr->weight_device[i]);
                ptr->weight_device[i] = NULL;
            }
        free (ptr->weight_device);
        ptr->weight_device = NULL;
    }
    free (ptr);
}

bool gen_oci_container_linux_resources_block_io (yajl_gen g, oci_container_linux_resources_block_io *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->weight_present) {
        stat = reformat_map_key (g, (unsigned char *)"weight", 6 /* strlen ("weight") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->weight);
        if (!stat)
            return false;
    }
    if (ptr->leaf_weight_present) {
        stat = reformat_map_key (g, (unsigned char *)"leafWeight", 10 /* strlen ("leafWeight") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->leaf_weight);
        if (!stat)
            return false;
    }
    if (ptr->throttle_read_bps_device) {
        stat = reformat_map_key (g, (unsigned char *) "throttleReadBpsDevice", 21 /* strlen ("throttleReadBpsDevice") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->throttle_read_bps_device_len; i++) {
            stat = gen_oci_container_linux_resources_block_io_throttle_read_bps_device_element(g, ptr->throttle_read_bps_device[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->throttle_write_bps_device) {
        stat = reformat_map_key (g, (unsigned char *) "throttleWriteBpsDevice", 22 /* strlen ("throttleWriteBpsDevice") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->throttle_write_bps_device_len; i++) {
            stat = gen_oci_container_linux_resources_block_io_throttle_write_bps_device_element(g, ptr->throttle_write_bps_device[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->throttle_read_iops_device) {
        stat = reformat_map_key (g, (unsigned char *) "throttleReadIOPSDevice", 22 /* strlen ("throttleReadIOPSDevice") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->throttle_read_iops_device_len; i++) {
            stat = gen_oci_container_linux_resources_block_io_throttle_read_iops_device_element(g, ptr->throttle_read_iops_device[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->throttle_write_iops_device) {
        stat = reformat_map_key (g, (unsigned char *) "throttleWriteIOPSDevice", 23 /* strlen ("throttleWriteIOPSDevice") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->throttle_write_iops_device_len; i++) {
            stat = gen_oci_container_linux_resources_block_io_throttle_write_iops_device_element(g, ptr->throttle_write_iops_device[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->weight_device) {
        stat = reformat_map_key (g, (unsigned char *) "weightDevice", 12 /* strlen ("weightDevice") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->weight_device_len; i++) {
            stat = gen_oci_container_linux_resources_block_io_weight_device_element(g, ptr->weight_device[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_cpu *make_oci_container_linux_resources_cpu (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_cpu *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "cpus", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->cpus = strdup (str ? str : "");
            if (ret->cpus == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "mems", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->mems = strdup (str ? str : "");
            if (ret->mems == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "period", yajl_t_number);
        if (val) {
            ret->period = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->period_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "quota", yajl_t_number);
        if (val) {
            ret->quota = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->quota_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "realtimePeriod", yajl_t_number);
        if (val) {
            ret->realtime_period = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->realtime_period_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "realtimeRuntime", yajl_t_number);
        if (val) {
            ret->realtime_runtime = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->realtime_runtime_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "shares", yajl_t_number);
        if (val) {
            ret->shares = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->shares_present = 1;
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "cpus") &&
                strcmp (tree->u.object.keys[i], "mems") &&
                strcmp (tree->u.object.keys[i], "period") &&
                strcmp (tree->u.object.keys[i], "quota") &&
                strcmp (tree->u.object.keys[i], "realtimePeriod") &&
                strcmp (tree->u.object.keys[i], "realtimeRuntime") &&
                strcmp (tree->u.object.keys[i], "shares")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_linux_resources_cpu (oci_container_linux_resources_cpu *ptr) {
    if (!ptr)
        return;
    free (ptr->cpus);
    ptr->cpus = NULL;
    free (ptr->mems);
    ptr->mems = NULL;
    free (ptr);
}

bool gen_oci_container_linux_resources_cpu (yajl_gen g, oci_container_linux_resources_cpu *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->cpus) {
        stat = reformat_map_key (g, (unsigned char *) "cpus", 4 /* strlen ("cpus") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->cpus, strlen (ptr->cpus));
        if (!stat)
            return false;
    }
    if (ptr->mems) {
        stat = reformat_map_key (g, (unsigned char *) "mems", 4 /* strlen ("mems") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->mems, strlen (ptr->mems));
        if (!stat)
            return false;
    }
    if (ptr->period_present) {
        stat = reformat_map_key (g, (unsigned char *)"period", 6 /* strlen ("period") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->period);
        if (!stat)
            return false;
    }
    if (ptr->quota_present) {
        stat = reformat_map_key (g, (unsigned char *)"quota", 5 /* strlen ("quota") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->quota);
        if (!stat)
            return false;
    }
    if (ptr->realtime_period_present) {
        stat = reformat_map_key (g, (unsigned char *)"realtimePeriod", 14 /* strlen ("realtimePeriod") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->realtime_period);
        if (!stat)
            return false;
    }
    if (ptr->realtime_runtime_present) {
        stat = reformat_map_key (g, (unsigned char *)"realtimeRuntime", 15 /* strlen ("realtimeRuntime") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->realtime_runtime);
        if (!stat)
            return false;
    }
    if (ptr->shares_present) {
        stat = reformat_map_key (g, (unsigned char *)"shares", 6 /* strlen ("shares") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->shares);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_hugepage_limits_element *make_oci_container_linux_resources_hugepage_limits_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_hugepage_limits_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "pageSize", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->page_size = strdup (str ? str : "");
            if (ret->page_size == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "limit", yajl_t_number);
        if (val) {
            ret->limit = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->limit_present = 1;
        }
    }
    if (ret->page_size == NULL) {
        if (asprintf (err, "Required field '%s' not present", "pageSize") < 0)
            abort();
        free_oci_container_linux_resources_hugepage_limits_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_linux_resources_hugepage_limits_element (oci_container_linux_resources_hugepage_limits_element *ptr) {
    if (!ptr)
        return;
    free (ptr->page_size);
    ptr->page_size = NULL;
    free (ptr);
}

bool gen_oci_container_linux_resources_hugepage_limits_element (yajl_gen g, oci_container_linux_resources_hugepage_limits_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->page_size) {
        stat = reformat_map_key (g, (unsigned char *) "pageSize", 8 /* strlen ("pageSize") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->page_size, strlen (ptr->page_size));
        if (!stat)
            return false;
    }
    if (ptr->limit_present) {
        stat = reformat_map_key (g, (unsigned char *)"limit", 5 /* strlen ("limit") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->limit);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_memory *make_oci_container_linux_resources_memory (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_memory *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "kernel", yajl_t_number);
        if (val) {
            ret->kernel = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->kernel_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "kernelTCP", yajl_t_number);
        if (val) {
            ret->kernel_tcp = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->kernel_tcp_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "limit", yajl_t_number);
        if (val) {
            ret->limit = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->limit_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "reservation", yajl_t_number);
        if (val) {
            ret->reservation = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->reservation_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "swap", yajl_t_number);
        if (val) {
            ret->swap = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->swap_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "swappiness", yajl_t_number);
        if (val) {
            ret->swappiness = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->swappiness_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "disableOOMKiller", yajl_t_true);
        if (val) {
            ret->disable_oom_killer = YAJL_IS_TRUE (val);
            ret->disable_oom_killer_present = 1;
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "kernel") &&
                strcmp (tree->u.object.keys[i], "kernelTCP") &&
                strcmp (tree->u.object.keys[i], "limit") &&
                strcmp (tree->u.object.keys[i], "reservation") &&
                strcmp (tree->u.object.keys[i], "swap") &&
                strcmp (tree->u.object.keys[i], "swappiness") &&
                strcmp (tree->u.object.keys[i], "disableOOMKiller")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_linux_resources_memory (oci_container_linux_resources_memory *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_resources_memory (yajl_gen g, oci_container_linux_resources_memory *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->kernel_present) {
        stat = reformat_map_key (g, (unsigned char *)"kernel", 6 /* strlen ("kernel") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->kernel);
        if (!stat)
            return false;
    }
    if (ptr->kernel_tcp_present) {
        stat = reformat_map_key (g, (unsigned char *)"kernelTCP", 9 /* strlen ("kernelTCP") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->kernel_tcp);
        if (!stat)
            return false;
    }
    if (ptr->limit_present) {
        stat = reformat_map_key (g, (unsigned char *)"limit", 5 /* strlen ("limit") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->limit);
        if (!stat)
            return false;
    }
    if (ptr->reservation_present) {
        stat = reformat_map_key (g, (unsigned char *)"reservation", 11 /* strlen ("reservation") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->reservation);
        if (!stat)
            return false;
    }
    if (ptr->swap_present) {
        stat = reformat_map_key (g, (unsigned char *)"swap", 4 /* strlen ("swap") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->swap);
        if (!stat)
            return false;
    }
    if (ptr->swappiness_present) {
        stat = reformat_map_key (g, (unsigned char *)"swappiness", 10 /* strlen ("swappiness") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->swappiness);
        if (!stat)
            return false;
    }
    if (ptr->disable_oom_killer_present) {
        stat = reformat_map_key (g, (unsigned char *)"disableOOMKiller", 16 /* strlen ("disableOOMKiller") */);
        if (!stat)
            return false;
        stat = reformat_boolean (g, 1);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_network_priorities_element *make_oci_container_linux_resources_network_priorities_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_network_priorities_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "name", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->name = strdup (str ? str : "");
            if (ret->name == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "priority", yajl_t_number);
        if (val) {
            ret->priority = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->priority_present = 1;
        }
    }
    if (ret->name == NULL) {
        if (asprintf (err, "Required field '%s' not present", "name") < 0)
            abort();
        free_oci_container_linux_resources_network_priorities_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_linux_resources_network_priorities_element (oci_container_linux_resources_network_priorities_element *ptr) {
    if (!ptr)
        return;
    free (ptr->name);
    ptr->name = NULL;
    free (ptr);
}

bool gen_oci_container_linux_resources_network_priorities_element (yajl_gen g, oci_container_linux_resources_network_priorities_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->name) {
        stat = reformat_map_key (g, (unsigned char *) "name", 4 /* strlen ("name") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->name, strlen (ptr->name));
        if (!stat)
            return false;
    }
    if (ptr->priority_present) {
        stat = reformat_map_key (g, (unsigned char *)"priority", 8 /* strlen ("priority") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->priority);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_network *make_oci_container_linux_resources_network (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_network *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "classID", yajl_t_number);
        if (val) {
            ret->class_id = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->class_id_present = 1;
        }
    }
    {
        yajl_val tmp = get_val (tree, "priorities", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->priorities_len = len;
            ret->priorities = safe_malloc ((len + 1) * sizeof (*ret->priorities));
            for (i = 0; i < len; i++) {
                ret->priorities[i] = make_oci_container_linux_resources_network_priorities_element (values[i], ctx, err);
                if (ret->priorities[i] == NULL) {
                    free_oci_container_linux_resources_network (ret);
                    return NULL;
                }
            }
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "classID") &&
                strcmp (tree->u.object.keys[i], "priorities")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_linux_resources_network (oci_container_linux_resources_network *ptr) {
    if (!ptr)
        return;
    if (ptr->priorities) {
        size_t i;
        for (i = 0; i < ptr->priorities_len; i++)
            if (ptr->priorities[i]) {
                free_oci_container_linux_resources_network_priorities_element (ptr->priorities[i]);
                ptr->priorities[i] = NULL;
            }
        free (ptr->priorities);
        ptr->priorities = NULL;
    }
    free (ptr);
}

bool gen_oci_container_linux_resources_network (yajl_gen g, oci_container_linux_resources_network *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->class_id_present) {
        stat = reformat_map_key (g, (unsigned char *)"classID", 7 /* strlen ("classID") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->class_id);
        if (!stat)
            return false;
    }
    if (ptr->priorities) {
        stat = reformat_map_key (g, (unsigned char *) "priorities", 10 /* strlen ("priorities") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->priorities_len; i++) {
            stat = gen_oci_container_linux_resources_network_priorities_element(g, ptr->priorities[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources_rdma *make_oci_container_linux_resources_rdma (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources_rdma *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    return ret;
}

void free_oci_container_linux_resources_rdma (oci_container_linux_resources_rdma *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_linux_resources_rdma (yajl_gen g, oci_container_linux_resources_rdma *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_resources *make_oci_container_linux_resources (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_resources *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val tmp = get_val (tree, "devices", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->devices_len = len;
            ret->devices = safe_malloc ((len + 1) * sizeof (*ret->devices));
            for (i = 0; i < len; i++) {
                ret->devices[i] = make_oci_container_linux_resources_devices_element (values[i], ctx, err);
                if (ret->devices[i] == NULL) {
                    free_oci_container_linux_resources (ret);
                    return NULL;
                }
            }
        }
    }
    ret->pids = make_oci_container_linux_resources_pids (get_val (tree, "pids", yajl_t_object), ctx, err);
    if (ret->pids == NULL && *err != 0) {
        free_oci_container_linux_resources (ret);
        return NULL;
    }
    ret->block_io = make_oci_container_linux_resources_block_io (get_val (tree, "blockIO", yajl_t_object), ctx, err);
    if (ret->block_io == NULL && *err != 0) {
        free_oci_container_linux_resources (ret);
        return NULL;
    }
    ret->cpu = make_oci_container_linux_resources_cpu (get_val (tree, "cpu", yajl_t_object), ctx, err);
    if (ret->cpu == NULL && *err != 0) {
        free_oci_container_linux_resources (ret);
        return NULL;
    }
    {
        yajl_val tmp = get_val (tree, "hugepageLimits", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->hugepage_limits_len = len;
            ret->hugepage_limits = safe_malloc ((len + 1) * sizeof (*ret->hugepage_limits));
            for (i = 0; i < len; i++) {
                ret->hugepage_limits[i] = make_oci_container_linux_resources_hugepage_limits_element (values[i], ctx, err);
                if (ret->hugepage_limits[i] == NULL) {
                    free_oci_container_linux_resources (ret);
                    return NULL;
                }
            }
        }
    }
    ret->memory = make_oci_container_linux_resources_memory (get_val (tree, "memory", yajl_t_object), ctx, err);
    if (ret->memory == NULL && *err != 0) {
        free_oci_container_linux_resources (ret);
        return NULL;
    }
    ret->network = make_oci_container_linux_resources_network (get_val (tree, "network", yajl_t_object), ctx, err);
    if (ret->network == NULL && *err != 0) {
        free_oci_container_linux_resources (ret);
        return NULL;
    }
    ret->rdma = make_oci_container_linux_resources_rdma (get_val (tree, "rdma", yajl_t_object), ctx, err);
    if (ret->rdma == NULL && *err != 0) {
        free_oci_container_linux_resources (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "devices") &&
                strcmp (tree->u.object.keys[i], "pids") &&
                strcmp (tree->u.object.keys[i], "blockIO") &&
                strcmp (tree->u.object.keys[i], "cpu") &&
                strcmp (tree->u.object.keys[i], "hugepageLimits") &&
                strcmp (tree->u.object.keys[i], "memory") &&
                strcmp (tree->u.object.keys[i], "network") &&
                strcmp (tree->u.object.keys[i], "rdma")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_linux_resources (oci_container_linux_resources *ptr) {
    if (!ptr)
        return;
    if (ptr->devices) {
        size_t i;
        for (i = 0; i < ptr->devices_len; i++)
            if (ptr->devices[i]) {
                free_oci_container_linux_resources_devices_element (ptr->devices[i]);
                ptr->devices[i] = NULL;
            }
        free (ptr->devices);
        ptr->devices = NULL;
    }
    if (ptr->pids) {
        free_oci_container_linux_resources_pids (ptr->pids);
        ptr->pids = NULL;
    }
    if (ptr->block_io) {
        free_oci_container_linux_resources_block_io (ptr->block_io);
        ptr->block_io = NULL;
    }
    if (ptr->cpu) {
        free_oci_container_linux_resources_cpu (ptr->cpu);
        ptr->cpu = NULL;
    }
    if (ptr->hugepage_limits) {
        size_t i;
        for (i = 0; i < ptr->hugepage_limits_len; i++)
            if (ptr->hugepage_limits[i]) {
                free_oci_container_linux_resources_hugepage_limits_element (ptr->hugepage_limits[i]);
                ptr->hugepage_limits[i] = NULL;
            }
        free (ptr->hugepage_limits);
        ptr->hugepage_limits = NULL;
    }
    if (ptr->memory) {
        free_oci_container_linux_resources_memory (ptr->memory);
        ptr->memory = NULL;
    }
    if (ptr->network) {
        free_oci_container_linux_resources_network (ptr->network);
        ptr->network = NULL;
    }
    if (ptr->rdma) {
        free_oci_container_linux_resources_rdma (ptr->rdma);
        ptr->rdma = NULL;
    }
    free (ptr);
}

bool gen_oci_container_linux_resources (yajl_gen g, oci_container_linux_resources *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->devices) {
        stat = reformat_map_key (g, (unsigned char *) "devices", 7 /* strlen ("devices") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->devices_len; i++) {
            stat = gen_oci_container_linux_resources_devices_element(g, ptr->devices[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->pids) {
        stat = reformat_map_key (g, (unsigned char *) "pids", 4 /* strlen ("pids") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux_resources_pids (g, ptr->pids, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->block_io) {
        stat = reformat_map_key (g, (unsigned char *) "blockIO", 7 /* strlen ("blockIO") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux_resources_block_io (g, ptr->block_io, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->cpu) {
        stat = reformat_map_key (g, (unsigned char *) "cpu", 3 /* strlen ("cpu") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux_resources_cpu (g, ptr->cpu, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->hugepage_limits) {
        stat = reformat_map_key (g, (unsigned char *) "hugepageLimits", 14 /* strlen ("hugepageLimits") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->hugepage_limits_len; i++) {
            stat = gen_oci_container_linux_resources_hugepage_limits_element(g, ptr->hugepage_limits[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->memory) {
        stat = reformat_map_key (g, (unsigned char *) "memory", 6 /* strlen ("memory") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux_resources_memory (g, ptr->memory, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->network) {
        stat = reformat_map_key (g, (unsigned char *) "network", 7 /* strlen ("network") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux_resources_network (g, ptr->network, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->rdma) {
        stat = reformat_map_key (g, (unsigned char *) "rdma", 4 /* strlen ("rdma") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux_resources_rdma (g, ptr->rdma, ctx, err);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_seccomp_syscalls_args_element *make_oci_container_linux_seccomp_syscalls_args_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_seccomp_syscalls_args_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "index", yajl_t_number);
        if (val) {
            ret->index = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->index_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "value", yajl_t_number);
        if (val) {
            ret->value = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->value_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "valueTwo", yajl_t_number);
        if (val) {
            ret->value_two = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->value_two_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "op", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->op = strdup (str ? str : "");
            if (ret->op == NULL)
                abort ();
        }
    }
    if (ret->op == NULL) {
        if (asprintf (err, "Required field '%s' not present", "op") < 0)
            abort();
        free_oci_container_linux_seccomp_syscalls_args_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_linux_seccomp_syscalls_args_element (oci_container_linux_seccomp_syscalls_args_element *ptr) {
    if (!ptr)
        return;
    free (ptr->op);
    ptr->op = NULL;
    free (ptr);
}

bool gen_oci_container_linux_seccomp_syscalls_args_element (yajl_gen g, oci_container_linux_seccomp_syscalls_args_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->index_present) {
        stat = reformat_map_key (g, (unsigned char *)"index", 5 /* strlen ("index") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->index);
        if (!stat)
            return false;
    }
    if (ptr->value_present) {
        stat = reformat_map_key (g, (unsigned char *)"value", 5 /* strlen ("value") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->value);
        if (!stat)
            return false;
    }
    if (ptr->value_two_present) {
        stat = reformat_map_key (g, (unsigned char *)"valueTwo", 8 /* strlen ("valueTwo") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->value_two);
        if (!stat)
            return false;
    }
    if (ptr->op) {
        stat = reformat_map_key (g, (unsigned char *) "op", 2 /* strlen ("op") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->op, strlen (ptr->op));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_seccomp_syscalls_element *make_oci_container_linux_seccomp_syscalls_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_seccomp_syscalls_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val tmp = get_val (tree, "names", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->names_len = len;
            ret->names = safe_malloc ((len + 1) * sizeof (*ret->names));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->names[i] = strdup (str ? str : "");
                    if (ret->names[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "action", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->action = strdup (str ? str : "");
            if (ret->action == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "args", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->args_len = len;
            ret->args = safe_malloc ((len + 1) * sizeof (*ret->args));
            for (i = 0; i < len; i++) {
                ret->args[i] = make_oci_container_linux_seccomp_syscalls_args_element (values[i], ctx, err);
                if (ret->args[i] == NULL) {
                    free_oci_container_linux_seccomp_syscalls_element (ret);
                    return NULL;
                }
            }
        }
    }
    if (ret->names == NULL) {
        if (asprintf (err, "Required field '%s' not present", "names") < 0)
            abort();
        free_oci_container_linux_seccomp_syscalls_element (ret);
        return NULL;
    }
    if (ret->action == NULL) {
        if (asprintf (err, "Required field '%s' not present", "action") < 0)
            abort();
        free_oci_container_linux_seccomp_syscalls_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_linux_seccomp_syscalls_element (oci_container_linux_seccomp_syscalls_element *ptr) {
    if (!ptr)
        return;
    if (ptr->names) {
        size_t i;
        for (i = 0; i < ptr->names_len; i++) {
            if (ptr->names[i]) {
                free (ptr->names[i]);
                ptr->names[i] = NULL;
            }
        }
        free (ptr->names);
        ptr->names = NULL;
    }
    free (ptr->action);
    ptr->action = NULL;
    if (ptr->args) {
        size_t i;
        for (i = 0; i < ptr->args_len; i++)
            if (ptr->args[i]) {
                free_oci_container_linux_seccomp_syscalls_args_element (ptr->args[i]);
                ptr->args[i] = NULL;
            }
        free (ptr->args);
        ptr->args = NULL;
    }
    free (ptr);
}

bool gen_oci_container_linux_seccomp_syscalls_element (yajl_gen g, oci_container_linux_seccomp_syscalls_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->names) {
        stat = reformat_map_key (g, (unsigned char *) "names", 5 /* strlen ("names") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->names_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->names[i], strlen (ptr->names[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->action) {
        stat = reformat_map_key (g, (unsigned char *) "action", 6 /* strlen ("action") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->action, strlen (ptr->action));
        if (!stat)
            return false;
    }
    if (ptr->args) {
        stat = reformat_map_key (g, (unsigned char *) "args", 4 /* strlen ("args") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->args_len; i++) {
            stat = gen_oci_container_linux_seccomp_syscalls_args_element(g, ptr->args[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux_seccomp *make_oci_container_linux_seccomp (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_seccomp *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "defaultAction", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->default_action = strdup (str ? str : "");
            if (ret->default_action == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "flags", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->flags_len = len;
            ret->flags = safe_malloc ((len + 1) * sizeof (*ret->flags));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->flags[i] = strdup (str ? str : "");
                    if (ret->flags[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "architectures", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->architectures_len = len;
            ret->architectures = safe_malloc ((len + 1) * sizeof (*ret->architectures));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->architectures[i] = strdup (str ? str : "");
                    if (ret->architectures[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "syscalls", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->syscalls_len = len;
            ret->syscalls = safe_malloc ((len + 1) * sizeof (*ret->syscalls));
            for (i = 0; i < len; i++) {
                ret->syscalls[i] = make_oci_container_linux_seccomp_syscalls_element (values[i], ctx, err);
                if (ret->syscalls[i] == NULL) {
                    free_oci_container_linux_seccomp (ret);
                    return NULL;
                }
            }
        }
    }
    if (ret->default_action == NULL) {
        if (asprintf (err, "Required field '%s' not present", "defaultAction") < 0)
            abort();
        free_oci_container_linux_seccomp (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "defaultAction") &&
                strcmp (tree->u.object.keys[i], "flags") &&
                strcmp (tree->u.object.keys[i], "architectures") &&
                strcmp (tree->u.object.keys[i], "syscalls")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_linux_seccomp (oci_container_linux_seccomp *ptr) {
    if (!ptr)
        return;
    free (ptr->default_action);
    ptr->default_action = NULL;
    if (ptr->flags) {
        size_t i;
        for (i = 0; i < ptr->flags_len; i++) {
            if (ptr->flags[i]) {
                free (ptr->flags[i]);
                ptr->flags[i] = NULL;
            }
        }
        free (ptr->flags);
        ptr->flags = NULL;
    }
    if (ptr->architectures) {
        size_t i;
        for (i = 0; i < ptr->architectures_len; i++) {
            if (ptr->architectures[i]) {
                free (ptr->architectures[i]);
                ptr->architectures[i] = NULL;
            }
        }
        free (ptr->architectures);
        ptr->architectures = NULL;
    }
    if (ptr->syscalls) {
        size_t i;
        for (i = 0; i < ptr->syscalls_len; i++)
            if (ptr->syscalls[i]) {
                free_oci_container_linux_seccomp_syscalls_element (ptr->syscalls[i]);
                ptr->syscalls[i] = NULL;
            }
        free (ptr->syscalls);
        ptr->syscalls = NULL;
    }
    free (ptr);
}

bool gen_oci_container_linux_seccomp (yajl_gen g, oci_container_linux_seccomp *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->default_action) {
        stat = reformat_map_key (g, (unsigned char *) "defaultAction", 13 /* strlen ("defaultAction") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->default_action, strlen (ptr->default_action));
        if (!stat)
            return false;
    }
    if (ptr->flags) {
        stat = reformat_map_key (g, (unsigned char *) "flags", 5 /* strlen ("flags") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->flags_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->flags[i], strlen (ptr->flags[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->architectures) {
        stat = reformat_map_key (g, (unsigned char *) "architectures", 13 /* strlen ("architectures") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->architectures_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->architectures[i], strlen (ptr->architectures[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->syscalls) {
        stat = reformat_map_key (g, (unsigned char *) "syscalls", 8 /* strlen ("syscalls") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->syscalls_len; i++) {
            stat = gen_oci_container_linux_seccomp_syscalls_element(g, ptr->syscalls[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

void free_oci_container_linux_sysctl (oci_container_linux_sysctl *ptr) {
    if (!ptr)
        return;
    free_cells (ptr);
    ptr = NULL;
    free (ptr);
}

oci_container_linux_intel_rdt *make_oci_container_linux_intel_rdt (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux_intel_rdt *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "closID", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->clos_id = strdup (str ? str : "");
            if (ret->clos_id == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "l3CacheSchema", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->l3cache_schema = strdup (str ? str : "");
            if (ret->l3cache_schema == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "memBwSchema", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->mem_bw_schema = strdup (str ? str : "");
            if (ret->mem_bw_schema == NULL)
                abort ();
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "closID") &&
                strcmp (tree->u.object.keys[i], "l3CacheSchema") &&
                strcmp (tree->u.object.keys[i], "memBwSchema")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_linux_intel_rdt (oci_container_linux_intel_rdt *ptr) {
    if (!ptr)
        return;
    free (ptr->clos_id);
    ptr->clos_id = NULL;
    free (ptr->l3cache_schema);
    ptr->l3cache_schema = NULL;
    free (ptr->mem_bw_schema);
    ptr->mem_bw_schema = NULL;
    free (ptr);
}

bool gen_oci_container_linux_intel_rdt (yajl_gen g, oci_container_linux_intel_rdt *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->clos_id) {
        stat = reformat_map_key (g, (unsigned char *) "closID", 6 /* strlen ("closID") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->clos_id, strlen (ptr->clos_id));
        if (!stat)
            return false;
    }
    if (ptr->l3cache_schema) {
        stat = reformat_map_key (g, (unsigned char *) "l3CacheSchema", 13 /* strlen ("l3CacheSchema") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->l3cache_schema, strlen (ptr->l3cache_schema));
        if (!stat)
            return false;
    }
    if (ptr->mem_bw_schema) {
        stat = reformat_map_key (g, (unsigned char *) "memBwSchema", 11 /* strlen ("memBwSchema") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->mem_bw_schema, strlen (ptr->mem_bw_schema));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_linux *make_oci_container_linux (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_linux *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val tmp = get_val (tree, "devices", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->devices_len = len;
            ret->devices = safe_malloc ((len + 1) * sizeof (*ret->devices));
            for (i = 0; i < len; i++) {
                ret->devices[i] = make_oci_container_linux_devices_element (values[i], ctx, err);
                if (ret->devices[i] == NULL) {
                    free_oci_container_linux (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "uidMappings", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->uid_mappings_len = len;
            ret->uid_mappings = safe_malloc ((len + 1) * sizeof (*ret->uid_mappings));
            for (i = 0; i < len; i++) {
                ret->uid_mappings[i] = make_oci_container_linux_uid_mappings_element (values[i], ctx, err);
                if (ret->uid_mappings[i] == NULL) {
                    free_oci_container_linux (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "gidMappings", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->gid_mappings_len = len;
            ret->gid_mappings = safe_malloc ((len + 1) * sizeof (*ret->gid_mappings));
            for (i = 0; i < len; i++) {
                ret->gid_mappings[i] = make_oci_container_linux_gid_mappings_element (values[i], ctx, err);
                if (ret->gid_mappings[i] == NULL) {
                    free_oci_container_linux (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "namespaces", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->namespaces_len = len;
            ret->namespaces = safe_malloc ((len + 1) * sizeof (*ret->namespaces));
            for (i = 0; i < len; i++) {
                ret->namespaces[i] = make_oci_container_linux_namespaces_element (values[i], ctx, err);
                if (ret->namespaces[i] == NULL) {
                    free_oci_container_linux (ret);
                    return NULL;
                }
            }
        }
    }
    ret->resources = make_oci_container_linux_resources (get_val (tree, "resources", yajl_t_object), ctx, err);
    if (ret->resources == NULL && *err != 0) {
        free_oci_container_linux (ret);
        return NULL;
    }
    {
        yajl_val val = get_val (tree, "cgroupsPath", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->cgroups_path = strdup (str ? str : "");
            if (ret->cgroups_path == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "rootfsPropagation", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->rootfs_propagation = strdup (str ? str : "");
            if (ret->rootfs_propagation == NULL)
                abort ();
        }
    }
    ret->seccomp = make_oci_container_linux_seccomp (get_val (tree, "seccomp", yajl_t_object), ctx, err);
    if (ret->seccomp == NULL && *err != 0) {
        free_oci_container_linux (ret);
        return NULL;
    }
    {
        yajl_val tmp = get_val (tree, "sysctl", yajl_t_object);
        if (tmp != NULL) {
            ret->sysctl = read_map_string_string (tmp);
        }
    }
    {
        yajl_val tmp = get_val (tree, "maskedPaths", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->masked_paths_len = len;
            ret->masked_paths = safe_malloc ((len + 1) * sizeof (*ret->masked_paths));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->masked_paths[i] = strdup (str ? str : "");
                    if (ret->masked_paths[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "readonlyPaths", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->readonly_paths_len = len;
            ret->readonly_paths = safe_malloc ((len + 1) * sizeof (*ret->readonly_paths));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->readonly_paths[i] = strdup (str ? str : "");
                    if (ret->readonly_paths[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "mountLabel", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->mount_label = strdup (str ? str : "");
            if (ret->mount_label == NULL)
                abort ();
        }
    }
    ret->intel_rdt = make_oci_container_linux_intel_rdt (get_val (tree, "intelRdt", yajl_t_object), ctx, err);
    if (ret->intel_rdt == NULL && *err != 0) {
        free_oci_container_linux (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "devices") &&
                strcmp (tree->u.object.keys[i], "uidMappings") &&
                strcmp (tree->u.object.keys[i], "gidMappings") &&
                strcmp (tree->u.object.keys[i], "namespaces") &&
                strcmp (tree->u.object.keys[i], "resources") &&
                strcmp (tree->u.object.keys[i], "cgroupsPath") &&
                strcmp (tree->u.object.keys[i], "rootfsPropagation") &&
                strcmp (tree->u.object.keys[i], "seccomp") &&
                strcmp (tree->u.object.keys[i], "sysctl") &&
                strcmp (tree->u.object.keys[i], "maskedPaths") &&
                strcmp (tree->u.object.keys[i], "readonlyPaths") &&
                strcmp (tree->u.object.keys[i], "mountLabel") &&
                strcmp (tree->u.object.keys[i], "intelRdt")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_linux (oci_container_linux *ptr) {
    if (!ptr)
        return;
    if (ptr->devices) {
        size_t i;
        for (i = 0; i < ptr->devices_len; i++)
            if (ptr->devices[i]) {
                free_oci_container_linux_devices_element (ptr->devices[i]);
                ptr->devices[i] = NULL;
            }
        free (ptr->devices);
        ptr->devices = NULL;
    }
    if (ptr->uid_mappings) {
        size_t i;
        for (i = 0; i < ptr->uid_mappings_len; i++)
            if (ptr->uid_mappings[i]) {
                free_oci_container_linux_uid_mappings_element (ptr->uid_mappings[i]);
                ptr->uid_mappings[i] = NULL;
            }
        free (ptr->uid_mappings);
        ptr->uid_mappings = NULL;
    }
    if (ptr->gid_mappings) {
        size_t i;
        for (i = 0; i < ptr->gid_mappings_len; i++)
            if (ptr->gid_mappings[i]) {
                free_oci_container_linux_gid_mappings_element (ptr->gid_mappings[i]);
                ptr->gid_mappings[i] = NULL;
            }
        free (ptr->gid_mappings);
        ptr->gid_mappings = NULL;
    }
    if (ptr->namespaces) {
        size_t i;
        for (i = 0; i < ptr->namespaces_len; i++)
            if (ptr->namespaces[i]) {
                free_oci_container_linux_namespaces_element (ptr->namespaces[i]);
                ptr->namespaces[i] = NULL;
            }
        free (ptr->namespaces);
        ptr->namespaces = NULL;
    }
    if (ptr->resources) {
        free_oci_container_linux_resources (ptr->resources);
        ptr->resources = NULL;
    }
    free (ptr->cgroups_path);
    ptr->cgroups_path = NULL;
    free (ptr->rootfs_propagation);
    ptr->rootfs_propagation = NULL;
    if (ptr->seccomp) {
        free_oci_container_linux_seccomp (ptr->seccomp);
        ptr->seccomp = NULL;
    }
    free_oci_container_linux_sysctl (ptr->sysctl);
    ptr->sysctl = NULL;
    if (ptr->masked_paths) {
        size_t i;
        for (i = 0; i < ptr->masked_paths_len; i++) {
            if (ptr->masked_paths[i]) {
                free (ptr->masked_paths[i]);
                ptr->masked_paths[i] = NULL;
            }
        }
        free (ptr->masked_paths);
        ptr->masked_paths = NULL;
    }
    if (ptr->readonly_paths) {
        size_t i;
        for (i = 0; i < ptr->readonly_paths_len; i++) {
            if (ptr->readonly_paths[i]) {
                free (ptr->readonly_paths[i]);
                ptr->readonly_paths[i] = NULL;
            }
        }
        free (ptr->readonly_paths);
        ptr->readonly_paths = NULL;
    }
    free (ptr->mount_label);
    ptr->mount_label = NULL;
    if (ptr->intel_rdt) {
        free_oci_container_linux_intel_rdt (ptr->intel_rdt);
        ptr->intel_rdt = NULL;
    }
    free (ptr);
}

bool gen_oci_container_linux (yajl_gen g, oci_container_linux *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->devices) {
        stat = reformat_map_key (g, (unsigned char *) "devices", 7 /* strlen ("devices") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->devices_len; i++) {
            stat = gen_oci_container_linux_devices_element(g, ptr->devices[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->uid_mappings) {
        stat = reformat_map_key (g, (unsigned char *) "uidMappings", 11 /* strlen ("uidMappings") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->uid_mappings_len; i++) {
            stat = gen_oci_container_linux_uid_mappings_element(g, ptr->uid_mappings[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->gid_mappings) {
        stat = reformat_map_key (g, (unsigned char *) "gidMappings", 11 /* strlen ("gidMappings") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->gid_mappings_len; i++) {
            stat = gen_oci_container_linux_gid_mappings_element(g, ptr->gid_mappings[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->namespaces) {
        stat = reformat_map_key (g, (unsigned char *) "namespaces", 10 /* strlen ("namespaces") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->namespaces_len; i++) {
            stat = gen_oci_container_linux_namespaces_element(g, ptr->namespaces[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->resources) {
        stat = reformat_map_key (g, (unsigned char *) "resources", 9 /* strlen ("resources") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux_resources (g, ptr->resources, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->cgroups_path) {
        stat = reformat_map_key (g, (unsigned char *) "cgroupsPath", 11 /* strlen ("cgroupsPath") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->cgroups_path, strlen (ptr->cgroups_path));
        if (!stat)
            return false;
    }
    if (ptr->rootfs_propagation) {
        stat = reformat_map_key (g, (unsigned char *) "rootfsPropagation", 17 /* strlen ("rootfsPropagation") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->rootfs_propagation, strlen (ptr->rootfs_propagation));
        if (!stat)
            return false;
    }
    if (ptr->seccomp) {
        stat = reformat_map_key (g, (unsigned char *) "seccomp", 7 /* strlen ("seccomp") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux_seccomp (g, ptr->seccomp, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->sysctl) {
        stat = reformat_map_key (g, (unsigned char *) "sysctl", 6 /* strlen ("sysctl") */);
        if (!stat)
            return false;
        stat = gen_map_string_string (g, ptr->sysctl);
        if (!stat)
            return false;
    }
    if (ptr->masked_paths) {
        stat = reformat_map_key (g, (unsigned char *) "maskedPaths", 11 /* strlen ("maskedPaths") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->masked_paths_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->masked_paths[i], strlen (ptr->masked_paths[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->readonly_paths) {
        stat = reformat_map_key (g, (unsigned char *) "readonlyPaths", 13 /* strlen ("readonlyPaths") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->readonly_paths_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->readonly_paths[i], strlen (ptr->readonly_paths[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->mount_label) {
        stat = reformat_map_key (g, (unsigned char *) "mountLabel", 10 /* strlen ("mountLabel") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->mount_label, strlen (ptr->mount_label));
        if (!stat)
            return false;
    }
    if (ptr->intel_rdt) {
        stat = reformat_map_key (g, (unsigned char *) "intelRdt", 8 /* strlen ("intelRdt") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux_intel_rdt (g, ptr->intel_rdt, ctx, err);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_solaris_capped_cpu *make_oci_container_solaris_capped_cpu (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_solaris_capped_cpu *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "ncpus", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->ncpus = strdup (str ? str : "");
            if (ret->ncpus == NULL)
                abort ();
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "ncpus")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_solaris_capped_cpu (oci_container_solaris_capped_cpu *ptr) {
    if (!ptr)
        return;
    free (ptr->ncpus);
    ptr->ncpus = NULL;
    free (ptr);
}

bool gen_oci_container_solaris_capped_cpu (yajl_gen g, oci_container_solaris_capped_cpu *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->ncpus) {
        stat = reformat_map_key (g, (unsigned char *) "ncpus", 5 /* strlen ("ncpus") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->ncpus, strlen (ptr->ncpus));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_solaris_capped_memory *make_oci_container_solaris_capped_memory (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_solaris_capped_memory *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "physical", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->physical = strdup (str ? str : "");
            if (ret->physical == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "swap", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->swap = strdup (str ? str : "");
            if (ret->swap == NULL)
                abort ();
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "physical") &&
                strcmp (tree->u.object.keys[i], "swap")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_solaris_capped_memory (oci_container_solaris_capped_memory *ptr) {
    if (!ptr)
        return;
    free (ptr->physical);
    ptr->physical = NULL;
    free (ptr->swap);
    ptr->swap = NULL;
    free (ptr);
}

bool gen_oci_container_solaris_capped_memory (yajl_gen g, oci_container_solaris_capped_memory *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->physical) {
        stat = reformat_map_key (g, (unsigned char *) "physical", 8 /* strlen ("physical") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->physical, strlen (ptr->physical));
        if (!stat)
            return false;
    }
    if (ptr->swap) {
        stat = reformat_map_key (g, (unsigned char *) "swap", 4 /* strlen ("swap") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->swap, strlen (ptr->swap));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_solaris_anet_element *make_oci_container_solaris_anet_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_solaris_anet_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "linkname", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->linkname = strdup (str ? str : "");
            if (ret->linkname == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "lowerLink", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->lower_link = strdup (str ? str : "");
            if (ret->lower_link == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "allowedAddress", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->allowed_address = strdup (str ? str : "");
            if (ret->allowed_address == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "configureAllowedAddress", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->configure_allowed_address = strdup (str ? str : "");
            if (ret->configure_allowed_address == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "defrouter", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->defrouter = strdup (str ? str : "");
            if (ret->defrouter == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "macAddress", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->mac_address = strdup (str ? str : "");
            if (ret->mac_address == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "linkProtection", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->link_protection = strdup (str ? str : "");
            if (ret->link_protection == NULL)
                abort ();
        }
    }
    return ret;
}

void free_oci_container_solaris_anet_element (oci_container_solaris_anet_element *ptr) {
    if (!ptr)
        return;
    free (ptr->linkname);
    ptr->linkname = NULL;
    free (ptr->lower_link);
    ptr->lower_link = NULL;
    free (ptr->allowed_address);
    ptr->allowed_address = NULL;
    free (ptr->configure_allowed_address);
    ptr->configure_allowed_address = NULL;
    free (ptr->defrouter);
    ptr->defrouter = NULL;
    free (ptr->mac_address);
    ptr->mac_address = NULL;
    free (ptr->link_protection);
    ptr->link_protection = NULL;
    free (ptr);
}

bool gen_oci_container_solaris_anet_element (yajl_gen g, oci_container_solaris_anet_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->linkname) {
        stat = reformat_map_key (g, (unsigned char *) "linkname", 8 /* strlen ("linkname") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->linkname, strlen (ptr->linkname));
        if (!stat)
            return false;
    }
    if (ptr->lower_link) {
        stat = reformat_map_key (g, (unsigned char *) "lowerLink", 9 /* strlen ("lowerLink") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->lower_link, strlen (ptr->lower_link));
        if (!stat)
            return false;
    }
    if (ptr->allowed_address) {
        stat = reformat_map_key (g, (unsigned char *) "allowedAddress", 14 /* strlen ("allowedAddress") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->allowed_address, strlen (ptr->allowed_address));
        if (!stat)
            return false;
    }
    if (ptr->configure_allowed_address) {
        stat = reformat_map_key (g, (unsigned char *) "configureAllowedAddress", 23 /* strlen ("configureAllowedAddress") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->configure_allowed_address, strlen (ptr->configure_allowed_address));
        if (!stat)
            return false;
    }
    if (ptr->defrouter) {
        stat = reformat_map_key (g, (unsigned char *) "defrouter", 9 /* strlen ("defrouter") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->defrouter, strlen (ptr->defrouter));
        if (!stat)
            return false;
    }
    if (ptr->mac_address) {
        stat = reformat_map_key (g, (unsigned char *) "macAddress", 10 /* strlen ("macAddress") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->mac_address, strlen (ptr->mac_address));
        if (!stat)
            return false;
    }
    if (ptr->link_protection) {
        stat = reformat_map_key (g, (unsigned char *) "linkProtection", 14 /* strlen ("linkProtection") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->link_protection, strlen (ptr->link_protection));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_solaris *make_oci_container_solaris (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_solaris *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "milestone", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->milestone = strdup (str ? str : "");
            if (ret->milestone == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "limitpriv", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->limitpriv = strdup (str ? str : "");
            if (ret->limitpriv == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "maxShmMemory", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->max_shm_memory = strdup (str ? str : "");
            if (ret->max_shm_memory == NULL)
                abort ();
        }
    }
    ret->capped_cpu = make_oci_container_solaris_capped_cpu (get_val (tree, "cappedCPU", yajl_t_object), ctx, err);
    if (ret->capped_cpu == NULL && *err != 0) {
        free_oci_container_solaris (ret);
        return NULL;
    }
    ret->capped_memory = make_oci_container_solaris_capped_memory (get_val (tree, "cappedMemory", yajl_t_object), ctx, err);
    if (ret->capped_memory == NULL && *err != 0) {
        free_oci_container_solaris (ret);
        return NULL;
    }
    {
        yajl_val tmp = get_val (tree, "anet", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->anet_len = len;
            ret->anet = safe_malloc ((len + 1) * sizeof (*ret->anet));
            for (i = 0; i < len; i++) {
                ret->anet[i] = make_oci_container_solaris_anet_element (values[i], ctx, err);
                if (ret->anet[i] == NULL) {
                    free_oci_container_solaris (ret);
                    return NULL;
                }
            }
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "milestone") &&
                strcmp (tree->u.object.keys[i], "limitpriv") &&
                strcmp (tree->u.object.keys[i], "maxShmMemory") &&
                strcmp (tree->u.object.keys[i], "cappedCPU") &&
                strcmp (tree->u.object.keys[i], "cappedMemory") &&
                strcmp (tree->u.object.keys[i], "anet")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_solaris (oci_container_solaris *ptr) {
    if (!ptr)
        return;
    free (ptr->milestone);
    ptr->milestone = NULL;
    free (ptr->limitpriv);
    ptr->limitpriv = NULL;
    free (ptr->max_shm_memory);
    ptr->max_shm_memory = NULL;
    if (ptr->capped_cpu) {
        free_oci_container_solaris_capped_cpu (ptr->capped_cpu);
        ptr->capped_cpu = NULL;
    }
    if (ptr->capped_memory) {
        free_oci_container_solaris_capped_memory (ptr->capped_memory);
        ptr->capped_memory = NULL;
    }
    if (ptr->anet) {
        size_t i;
        for (i = 0; i < ptr->anet_len; i++)
            if (ptr->anet[i]) {
                free_oci_container_solaris_anet_element (ptr->anet[i]);
                ptr->anet[i] = NULL;
            }
        free (ptr->anet);
        ptr->anet = NULL;
    }
    free (ptr);
}

bool gen_oci_container_solaris (yajl_gen g, oci_container_solaris *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->milestone) {
        stat = reformat_map_key (g, (unsigned char *) "milestone", 9 /* strlen ("milestone") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->milestone, strlen (ptr->milestone));
        if (!stat)
            return false;
    }
    if (ptr->limitpriv) {
        stat = reformat_map_key (g, (unsigned char *) "limitpriv", 9 /* strlen ("limitpriv") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->limitpriv, strlen (ptr->limitpriv));
        if (!stat)
            return false;
    }
    if (ptr->max_shm_memory) {
        stat = reformat_map_key (g, (unsigned char *) "maxShmMemory", 12 /* strlen ("maxShmMemory") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->max_shm_memory, strlen (ptr->max_shm_memory));
        if (!stat)
            return false;
    }
    if (ptr->capped_cpu) {
        stat = reformat_map_key (g, (unsigned char *) "cappedCPU", 9 /* strlen ("cappedCPU") */);
        if (!stat)
            return false;
        stat = gen_oci_container_solaris_capped_cpu (g, ptr->capped_cpu, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->capped_memory) {
        stat = reformat_map_key (g, (unsigned char *) "cappedMemory", 12 /* strlen ("cappedMemory") */);
        if (!stat)
            return false;
        stat = gen_oci_container_solaris_capped_memory (g, ptr->capped_memory, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->anet) {
        stat = reformat_map_key (g, (unsigned char *) "anet", 4 /* strlen ("anet") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->anet_len; i++) {
            stat = gen_oci_container_solaris_anet_element(g, ptr->anet[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_windows_devices_element *make_oci_container_windows_devices_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_windows_devices_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "id", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->id = strdup (str ? str : "");
            if (ret->id == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "idType", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->id_type = strdup (str ? str : "");
            if (ret->id_type == NULL)
                abort ();
        }
    }
    if (ret->id == NULL) {
        if (asprintf (err, "Required field '%s' not present", "id") < 0)
            abort();
        free_oci_container_windows_devices_element (ret);
        return NULL;
    }
    if (ret->id_type == NULL) {
        if (asprintf (err, "Required field '%s' not present", "idType") < 0)
            abort();
        free_oci_container_windows_devices_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_container_windows_devices_element (oci_container_windows_devices_element *ptr) {
    if (!ptr)
        return;
    free (ptr->id);
    ptr->id = NULL;
    free (ptr->id_type);
    ptr->id_type = NULL;
    free (ptr);
}

bool gen_oci_container_windows_devices_element (yajl_gen g, oci_container_windows_devices_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->id) {
        stat = reformat_map_key (g, (unsigned char *) "id", 2 /* strlen ("id") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->id, strlen (ptr->id));
        if (!stat)
            return false;
    }
    if (ptr->id_type) {
        stat = reformat_map_key (g, (unsigned char *) "idType", 6 /* strlen ("idType") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->id_type, strlen (ptr->id_type));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_windows_resources_memory *make_oci_container_windows_resources_memory (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_windows_resources_memory *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "limit", yajl_t_number);
        if (val) {
            ret->limit = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->limit_present = 1;
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "limit")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_windows_resources_memory (oci_container_windows_resources_memory *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_windows_resources_memory (yajl_gen g, oci_container_windows_resources_memory *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->limit_present) {
        stat = reformat_map_key (g, (unsigned char *)"limit", 5 /* strlen ("limit") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->limit);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_windows_resources_cpu *make_oci_container_windows_resources_cpu (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_windows_resources_cpu *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "count", yajl_t_number);
        if (val) {
            ret->count = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->count_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "shares", yajl_t_number);
        if (val) {
            ret->shares = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->shares_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "maximum", yajl_t_number);
        if (val) {
            ret->maximum = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->maximum_present = 1;
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "count") &&
                strcmp (tree->u.object.keys[i], "shares") &&
                strcmp (tree->u.object.keys[i], "maximum")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_windows_resources_cpu (oci_container_windows_resources_cpu *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_windows_resources_cpu (yajl_gen g, oci_container_windows_resources_cpu *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->count_present) {
        stat = reformat_map_key (g, (unsigned char *)"count", 5 /* strlen ("count") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->count);
        if (!stat)
            return false;
    }
    if (ptr->shares_present) {
        stat = reformat_map_key (g, (unsigned char *)"shares", 6 /* strlen ("shares") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->shares);
        if (!stat)
            return false;
    }
    if (ptr->maximum_present) {
        stat = reformat_map_key (g, (unsigned char *)"maximum", 7 /* strlen ("maximum") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->maximum);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_windows_resources_storage *make_oci_container_windows_resources_storage (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_windows_resources_storage *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "iops", yajl_t_number);
        if (val) {
            ret->iops = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->iops_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "bps", yajl_t_number);
        if (val) {
            ret->bps = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->bps_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "sandboxSize", yajl_t_number);
        if (val) {
            ret->sandbox_size = strtoull (YAJL_GET_NUMBER (val), NULL, 10);
            ret->sandbox_size_present = 1;
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "iops") &&
                strcmp (tree->u.object.keys[i], "bps") &&
                strcmp (tree->u.object.keys[i], "sandboxSize")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_windows_resources_storage (oci_container_windows_resources_storage *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_windows_resources_storage (yajl_gen g, oci_container_windows_resources_storage *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->iops_present) {
        stat = reformat_map_key (g, (unsigned char *)"iops", 4 /* strlen ("iops") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->iops);
        if (!stat)
            return false;
    }
    if (ptr->bps_present) {
        stat = reformat_map_key (g, (unsigned char *)"bps", 3 /* strlen ("bps") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->bps);
        if (!stat)
            return false;
    }
    if (ptr->sandbox_size_present) {
        stat = reformat_map_key (g, (unsigned char *)"sandboxSize", 11 /* strlen ("sandboxSize") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->sandbox_size);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_windows_resources *make_oci_container_windows_resources (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_windows_resources *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    ret->memory = make_oci_container_windows_resources_memory (get_val (tree, "memory", yajl_t_object), ctx, err);
    if (ret->memory == NULL && *err != 0) {
        free_oci_container_windows_resources (ret);
        return NULL;
    }
    ret->cpu = make_oci_container_windows_resources_cpu (get_val (tree, "cpu", yajl_t_object), ctx, err);
    if (ret->cpu == NULL && *err != 0) {
        free_oci_container_windows_resources (ret);
        return NULL;
    }
    ret->storage = make_oci_container_windows_resources_storage (get_val (tree, "storage", yajl_t_object), ctx, err);
    if (ret->storage == NULL && *err != 0) {
        free_oci_container_windows_resources (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "memory") &&
                strcmp (tree->u.object.keys[i], "cpu") &&
                strcmp (tree->u.object.keys[i], "storage")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_windows_resources (oci_container_windows_resources *ptr) {
    if (!ptr)
        return;
    if (ptr->memory) {
        free_oci_container_windows_resources_memory (ptr->memory);
        ptr->memory = NULL;
    }
    if (ptr->cpu) {
        free_oci_container_windows_resources_cpu (ptr->cpu);
        ptr->cpu = NULL;
    }
    if (ptr->storage) {
        free_oci_container_windows_resources_storage (ptr->storage);
        ptr->storage = NULL;
    }
    free (ptr);
}

bool gen_oci_container_windows_resources (yajl_gen g, oci_container_windows_resources *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->memory) {
        stat = reformat_map_key (g, (unsigned char *) "memory", 6 /* strlen ("memory") */);
        if (!stat)
            return false;
        stat = gen_oci_container_windows_resources_memory (g, ptr->memory, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->cpu) {
        stat = reformat_map_key (g, (unsigned char *) "cpu", 3 /* strlen ("cpu") */);
        if (!stat)
            return false;
        stat = gen_oci_container_windows_resources_cpu (g, ptr->cpu, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->storage) {
        stat = reformat_map_key (g, (unsigned char *) "storage", 7 /* strlen ("storage") */);
        if (!stat)
            return false;
        stat = gen_oci_container_windows_resources_storage (g, ptr->storage, ctx, err);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_windows_network *make_oci_container_windows_network (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_windows_network *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val tmp = get_val (tree, "endpointList", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->endpoint_list_len = len;
            ret->endpoint_list = safe_malloc ((len + 1) * sizeof (*ret->endpoint_list));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->endpoint_list[i] = strdup (str ? str : "");
                    if (ret->endpoint_list[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "allowUnqualifiedDNSQuery", yajl_t_true);
        if (val) {
            ret->allow_unqualified_dns_query = YAJL_IS_TRUE (val);
            ret->allow_unqualified_dns_query_present = 1;
        }
    }
    {
        yajl_val tmp = get_val (tree, "DNSSearchList", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->dns_search_list_len = len;
            ret->dns_search_list = safe_malloc ((len + 1) * sizeof (*ret->dns_search_list));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->dns_search_list[i] = strdup (str ? str : "");
                    if (ret->dns_search_list[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "networkSharedContainerName", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->network_shared_container_name = strdup (str ? str : "");
            if (ret->network_shared_container_name == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "networkNamespace", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->network_namespace = strdup (str ? str : "");
            if (ret->network_namespace == NULL)
                abort ();
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "endpointList") &&
                strcmp (tree->u.object.keys[i], "allowUnqualifiedDNSQuery") &&
                strcmp (tree->u.object.keys[i], "DNSSearchList") &&
                strcmp (tree->u.object.keys[i], "networkSharedContainerName") &&
                strcmp (tree->u.object.keys[i], "networkNamespace")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_windows_network (oci_container_windows_network *ptr) {
    if (!ptr)
        return;
    if (ptr->endpoint_list) {
        size_t i;
        for (i = 0; i < ptr->endpoint_list_len; i++) {
            if (ptr->endpoint_list[i]) {
                free (ptr->endpoint_list[i]);
                ptr->endpoint_list[i] = NULL;
            }
        }
        free (ptr->endpoint_list);
        ptr->endpoint_list = NULL;
    }
    if (ptr->dns_search_list) {
        size_t i;
        for (i = 0; i < ptr->dns_search_list_len; i++) {
            if (ptr->dns_search_list[i]) {
                free (ptr->dns_search_list[i]);
                ptr->dns_search_list[i] = NULL;
            }
        }
        free (ptr->dns_search_list);
        ptr->dns_search_list = NULL;
    }
    free (ptr->network_shared_container_name);
    ptr->network_shared_container_name = NULL;
    free (ptr->network_namespace);
    ptr->network_namespace = NULL;
    free (ptr);
}

bool gen_oci_container_windows_network (yajl_gen g, oci_container_windows_network *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->endpoint_list) {
        stat = reformat_map_key (g, (unsigned char *) "endpointList", 12 /* strlen ("endpointList") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->endpoint_list_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->endpoint_list[i], strlen (ptr->endpoint_list[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->allow_unqualified_dns_query_present) {
        stat = reformat_map_key (g, (unsigned char *)"allowUnqualifiedDNSQuery", 24 /* strlen ("allowUnqualifiedDNSQuery") */);
        if (!stat)
            return false;
        stat = reformat_boolean (g, 1);
        if (!stat)
            return false;
    }
    if (ptr->dns_search_list) {
        stat = reformat_map_key (g, (unsigned char *) "DNSSearchList", 13 /* strlen ("DNSSearchList") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->dns_search_list_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->dns_search_list[i], strlen (ptr->dns_search_list[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->network_shared_container_name) {
        stat = reformat_map_key (g, (unsigned char *) "networkSharedContainerName", 26 /* strlen ("networkSharedContainerName") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->network_shared_container_name, strlen (ptr->network_shared_container_name));
        if (!stat)
            return false;
    }
    if (ptr->network_namespace) {
        stat = reformat_map_key (g, (unsigned char *) "networkNamespace", 16 /* strlen ("networkNamespace") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->network_namespace, strlen (ptr->network_namespace));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_windows_credential_spec *make_oci_container_windows_credential_spec (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_windows_credential_spec *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    return ret;
}

void free_oci_container_windows_credential_spec (oci_container_windows_credential_spec *ptr) {
    if (!ptr)
        return;
    free (ptr);
}

bool gen_oci_container_windows_credential_spec (yajl_gen g, oci_container_windows_credential_spec *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_windows_hyperv *make_oci_container_windows_hyperv (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_windows_hyperv *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "utilityVMPath", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->utility_vm_path = strdup (str ? str : "");
            if (ret->utility_vm_path == NULL)
                abort ();
        }
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "utilityVMPath")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_windows_hyperv (oci_container_windows_hyperv *ptr) {
    if (!ptr)
        return;
    free (ptr->utility_vm_path);
    ptr->utility_vm_path = NULL;
    free (ptr);
}

bool gen_oci_container_windows_hyperv (yajl_gen g, oci_container_windows_hyperv *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->utility_vm_path) {
        stat = reformat_map_key (g, (unsigned char *) "utilityVMPath", 13 /* strlen ("utilityVMPath") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->utility_vm_path, strlen (ptr->utility_vm_path));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_windows *make_oci_container_windows (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_windows *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val tmp = get_val (tree, "layerFolders", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->layer_folders_len = len;
            ret->layer_folders = safe_malloc ((len + 1) * sizeof (*ret->layer_folders));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->layer_folders[i] = strdup (str ? str : "");
                    if (ret->layer_folders[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "devices", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->devices_len = len;
            ret->devices = safe_malloc ((len + 1) * sizeof (*ret->devices));
            for (i = 0; i < len; i++) {
                ret->devices[i] = make_oci_container_windows_devices_element (values[i], ctx, err);
                if (ret->devices[i] == NULL) {
                    free_oci_container_windows (ret);
                    return NULL;
                }
            }
        }
    }
    ret->resources = make_oci_container_windows_resources (get_val (tree, "resources", yajl_t_object), ctx, err);
    if (ret->resources == NULL && *err != 0) {
        free_oci_container_windows (ret);
        return NULL;
    }
    ret->network = make_oci_container_windows_network (get_val (tree, "network", yajl_t_object), ctx, err);
    if (ret->network == NULL && *err != 0) {
        free_oci_container_windows (ret);
        return NULL;
    }
    ret->credential_spec = make_oci_container_windows_credential_spec (get_val (tree, "credentialSpec", yajl_t_object), ctx, err);
    if (ret->credential_spec == NULL && *err != 0) {
        free_oci_container_windows (ret);
        return NULL;
    }
    {
        yajl_val val = get_val (tree, "servicing", yajl_t_true);
        if (val) {
            ret->servicing = YAJL_IS_TRUE (val);
            ret->servicing_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "ignoreFlushesDuringBoot", yajl_t_true);
        if (val) {
            ret->ignore_flushes_during_boot = YAJL_IS_TRUE (val);
            ret->ignore_flushes_during_boot_present = 1;
        }
    }
    ret->hyperv = make_oci_container_windows_hyperv (get_val (tree, "hyperv", yajl_t_object), ctx, err);
    if (ret->hyperv == NULL && *err != 0) {
        free_oci_container_windows (ret);
        return NULL;
    }
    if (ret->layer_folders == NULL) {
        if (asprintf (err, "Required field '%s' not present", "layerFolders") < 0)
            abort();
        free_oci_container_windows (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "layerFolders") &&
                strcmp (tree->u.object.keys[i], "devices") &&
                strcmp (tree->u.object.keys[i], "resources") &&
                strcmp (tree->u.object.keys[i], "network") &&
                strcmp (tree->u.object.keys[i], "credentialSpec") &&
                strcmp (tree->u.object.keys[i], "servicing") &&
                strcmp (tree->u.object.keys[i], "ignoreFlushesDuringBoot") &&
                strcmp (tree->u.object.keys[i], "hyperv")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_windows (oci_container_windows *ptr) {
    if (!ptr)
        return;
    if (ptr->layer_folders) {
        size_t i;
        for (i = 0; i < ptr->layer_folders_len; i++) {
            if (ptr->layer_folders[i]) {
                free (ptr->layer_folders[i]);
                ptr->layer_folders[i] = NULL;
            }
        }
        free (ptr->layer_folders);
        ptr->layer_folders = NULL;
    }
    if (ptr->devices) {
        size_t i;
        for (i = 0; i < ptr->devices_len; i++)
            if (ptr->devices[i]) {
                free_oci_container_windows_devices_element (ptr->devices[i]);
                ptr->devices[i] = NULL;
            }
        free (ptr->devices);
        ptr->devices = NULL;
    }
    if (ptr->resources) {
        free_oci_container_windows_resources (ptr->resources);
        ptr->resources = NULL;
    }
    if (ptr->network) {
        free_oci_container_windows_network (ptr->network);
        ptr->network = NULL;
    }
    if (ptr->credential_spec) {
        free_oci_container_windows_credential_spec (ptr->credential_spec);
        ptr->credential_spec = NULL;
    }
    if (ptr->hyperv) {
        free_oci_container_windows_hyperv (ptr->hyperv);
        ptr->hyperv = NULL;
    }
    free (ptr);
}

bool gen_oci_container_windows (yajl_gen g, oci_container_windows *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->layer_folders) {
        stat = reformat_map_key (g, (unsigned char *) "layerFolders", 12 /* strlen ("layerFolders") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->layer_folders_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->layer_folders[i], strlen (ptr->layer_folders[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->devices) {
        stat = reformat_map_key (g, (unsigned char *) "devices", 7 /* strlen ("devices") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->devices_len; i++) {
            stat = gen_oci_container_windows_devices_element(g, ptr->devices[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->resources) {
        stat = reformat_map_key (g, (unsigned char *) "resources", 9 /* strlen ("resources") */);
        if (!stat)
            return false;
        stat = gen_oci_container_windows_resources (g, ptr->resources, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->network) {
        stat = reformat_map_key (g, (unsigned char *) "network", 7 /* strlen ("network") */);
        if (!stat)
            return false;
        stat = gen_oci_container_windows_network (g, ptr->network, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->credential_spec) {
        stat = reformat_map_key (g, (unsigned char *) "credentialSpec", 14 /* strlen ("credentialSpec") */);
        if (!stat)
            return false;
        stat = gen_oci_container_windows_credential_spec (g, ptr->credential_spec, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->servicing_present) {
        stat = reformat_map_key (g, (unsigned char *)"servicing", 9 /* strlen ("servicing") */);
        if (!stat)
            return false;
        stat = reformat_boolean (g, 1);
        if (!stat)
            return false;
    }
    if (ptr->ignore_flushes_during_boot_present) {
        stat = reformat_map_key (g, (unsigned char *)"ignoreFlushesDuringBoot", 23 /* strlen ("ignoreFlushesDuringBoot") */);
        if (!stat)
            return false;
        stat = reformat_boolean (g, 1);
        if (!stat)
            return false;
    }
    if (ptr->hyperv) {
        stat = reformat_map_key (g, (unsigned char *) "hyperv", 6 /* strlen ("hyperv") */);
        if (!stat)
            return false;
        stat = gen_oci_container_windows_hyperv (g, ptr->hyperv, ctx, err);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_vm_hypervisor *make_oci_container_vm_hypervisor (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_vm_hypervisor *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "path", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->path = strdup (str ? str : "");
            if (ret->path == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "parameters", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->parameters_len = len;
            ret->parameters = safe_malloc ((len + 1) * sizeof (*ret->parameters));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->parameters[i] = strdup (str ? str : "");
                    if (ret->parameters[i] == NULL)
                        abort ();
                }
            }
        }
    }
    if (ret->path == NULL) {
        if (asprintf (err, "Required field '%s' not present", "path") < 0)
            abort();
        free_oci_container_vm_hypervisor (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "path") &&
                strcmp (tree->u.object.keys[i], "parameters")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_vm_hypervisor (oci_container_vm_hypervisor *ptr) {
    if (!ptr)
        return;
    free (ptr->path);
    ptr->path = NULL;
    if (ptr->parameters) {
        size_t i;
        for (i = 0; i < ptr->parameters_len; i++) {
            if (ptr->parameters[i]) {
                free (ptr->parameters[i]);
                ptr->parameters[i] = NULL;
            }
        }
        free (ptr->parameters);
        ptr->parameters = NULL;
    }
    free (ptr);
}

bool gen_oci_container_vm_hypervisor (yajl_gen g, oci_container_vm_hypervisor *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->path) {
        stat = reformat_map_key (g, (unsigned char *) "path", 4 /* strlen ("path") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->path, strlen (ptr->path));
        if (!stat)
            return false;
    }
    if (ptr->parameters) {
        stat = reformat_map_key (g, (unsigned char *) "parameters", 10 /* strlen ("parameters") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->parameters_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->parameters[i], strlen (ptr->parameters[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_vm_kernel *make_oci_container_vm_kernel (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_vm_kernel *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "path", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->path = strdup (str ? str : "");
            if (ret->path == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "parameters", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->parameters_len = len;
            ret->parameters = safe_malloc ((len + 1) * sizeof (*ret->parameters));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->parameters[i] = strdup (str ? str : "");
                    if (ret->parameters[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "initrd", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->initrd = strdup (str ? str : "");
            if (ret->initrd == NULL)
                abort ();
        }
    }
    if (ret->path == NULL) {
        if (asprintf (err, "Required field '%s' not present", "path") < 0)
            abort();
        free_oci_container_vm_kernel (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "path") &&
                strcmp (tree->u.object.keys[i], "parameters") &&
                strcmp (tree->u.object.keys[i], "initrd")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_vm_kernel (oci_container_vm_kernel *ptr) {
    if (!ptr)
        return;
    free (ptr->path);
    ptr->path = NULL;
    if (ptr->parameters) {
        size_t i;
        for (i = 0; i < ptr->parameters_len; i++) {
            if (ptr->parameters[i]) {
                free (ptr->parameters[i]);
                ptr->parameters[i] = NULL;
            }
        }
        free (ptr->parameters);
        ptr->parameters = NULL;
    }
    free (ptr->initrd);
    ptr->initrd = NULL;
    free (ptr);
}

bool gen_oci_container_vm_kernel (yajl_gen g, oci_container_vm_kernel *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->path) {
        stat = reformat_map_key (g, (unsigned char *) "path", 4 /* strlen ("path") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->path, strlen (ptr->path));
        if (!stat)
            return false;
    }
    if (ptr->parameters) {
        stat = reformat_map_key (g, (unsigned char *) "parameters", 10 /* strlen ("parameters") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->parameters_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->parameters[i], strlen (ptr->parameters[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->initrd) {
        stat = reformat_map_key (g, (unsigned char *) "initrd", 6 /* strlen ("initrd") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->initrd, strlen (ptr->initrd));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_vm_image *make_oci_container_vm_image (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_vm_image *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "path", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->path = strdup (str ? str : "");
            if (ret->path == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "format", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->format = strdup (str ? str : "");
            if (ret->format == NULL)
                abort ();
        }
    }
    if (ret->path == NULL) {
        if (asprintf (err, "Required field '%s' not present", "path") < 0)
            abort();
        free_oci_container_vm_image (ret);
        return NULL;
    }
    if (ret->format == NULL) {
        if (asprintf (err, "Required field '%s' not present", "format") < 0)
            abort();
        free_oci_container_vm_image (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "path") &&
                strcmp (tree->u.object.keys[i], "format")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_vm_image (oci_container_vm_image *ptr) {
    if (!ptr)
        return;
    free (ptr->path);
    ptr->path = NULL;
    free (ptr->format);
    ptr->format = NULL;
    free (ptr);
}

bool gen_oci_container_vm_image (yajl_gen g, oci_container_vm_image *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->path) {
        stat = reformat_map_key (g, (unsigned char *) "path", 4 /* strlen ("path") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->path, strlen (ptr->path));
        if (!stat)
            return false;
    }
    if (ptr->format) {
        stat = reformat_map_key (g, (unsigned char *) "format", 6 /* strlen ("format") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->format, strlen (ptr->format));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container_vm *make_oci_container_vm (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container_vm *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    ret->hypervisor = make_oci_container_vm_hypervisor (get_val (tree, "hypervisor", yajl_t_object), ctx, err);
    if (ret->hypervisor == NULL && *err != 0) {
        free_oci_container_vm (ret);
        return NULL;
    }
    ret->kernel = make_oci_container_vm_kernel (get_val (tree, "kernel", yajl_t_object), ctx, err);
    if (ret->kernel == NULL && *err != 0) {
        free_oci_container_vm (ret);
        return NULL;
    }
    ret->image = make_oci_container_vm_image (get_val (tree, "image", yajl_t_object), ctx, err);
    if (ret->image == NULL && *err != 0) {
        free_oci_container_vm (ret);
        return NULL;
    }
    if (ret->kernel == NULL) {
        if (asprintf (err, "Required field '%s' not present", "kernel") < 0)
            abort();
        free_oci_container_vm (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "hypervisor") &&
                strcmp (tree->u.object.keys[i], "kernel") &&
                strcmp (tree->u.object.keys[i], "image")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container_vm (oci_container_vm *ptr) {
    if (!ptr)
        return;
    if (ptr->hypervisor) {
        free_oci_container_vm_hypervisor (ptr->hypervisor);
        ptr->hypervisor = NULL;
    }
    if (ptr->kernel) {
        free_oci_container_vm_kernel (ptr->kernel);
        ptr->kernel = NULL;
    }
    if (ptr->image) {
        free_oci_container_vm_image (ptr->image);
        ptr->image = NULL;
    }
    free (ptr);
}

bool gen_oci_container_vm (yajl_gen g, oci_container_vm *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->hypervisor) {
        stat = reformat_map_key (g, (unsigned char *) "hypervisor", 10 /* strlen ("hypervisor") */);
        if (!stat)
            return false;
        stat = gen_oci_container_vm_hypervisor (g, ptr->hypervisor, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->kernel) {
        stat = reformat_map_key (g, (unsigned char *) "kernel", 6 /* strlen ("kernel") */);
        if (!stat)
            return false;
        stat = gen_oci_container_vm_kernel (g, ptr->kernel, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->image) {
        stat = reformat_map_key (g, (unsigned char *) "image", 5 /* strlen ("image") */);
        if (!stat)
            return false;
        stat = gen_oci_container_vm_image (g, ptr->image, ctx, err);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

oci_container *make_oci_container (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_container *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "ociVersion", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->oci_version = strdup (str ? str : "");
            if (ret->oci_version == NULL)
                abort ();
        }
    }
    ret->hooks = make_oci_container_hooks (get_val (tree, "hooks", yajl_t_object), ctx, err);
    if (ret->hooks == NULL && *err != 0) {
        free_oci_container (ret);
        return NULL;
    }
    {
        yajl_val tmp = get_val (tree, "annotations", yajl_t_object);
        if (tmp != NULL) {
            ret->annotations = read_map_string_string (tmp);
        }
    }
    {
        yajl_val val = get_val (tree, "hostname", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->hostname = strdup (str ? str : "");
            if (ret->hostname == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "mounts", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->mounts_len = len;
            ret->mounts = safe_malloc ((len + 1) * sizeof (*ret->mounts));
            for (i = 0; i < len; i++) {
                ret->mounts[i] = make_oci_container_mounts_element (values[i], ctx, err);
                if (ret->mounts[i] == NULL) {
                    free_oci_container (ret);
                    return NULL;
                }
            }
        }
    }
    ret->root = make_oci_container_root (get_val (tree, "root", yajl_t_object), ctx, err);
    if (ret->root == NULL && *err != 0) {
        free_oci_container (ret);
        return NULL;
    }
    ret->process = make_oci_container_process (get_val (tree, "process", yajl_t_object), ctx, err);
    if (ret->process == NULL && *err != 0) {
        free_oci_container (ret);
        return NULL;
    }
    ret->linux = make_oci_container_linux (get_val (tree, "linux", yajl_t_object), ctx, err);
    if (ret->linux == NULL && *err != 0) {
        free_oci_container (ret);
        return NULL;
    }
    ret->solaris = make_oci_container_solaris (get_val (tree, "solaris", yajl_t_object), ctx, err);
    if (ret->solaris == NULL && *err != 0) {
        free_oci_container (ret);
        return NULL;
    }
    ret->windows = make_oci_container_windows (get_val (tree, "windows", yajl_t_object), ctx, err);
    if (ret->windows == NULL && *err != 0) {
        free_oci_container (ret);
        return NULL;
    }
    ret->vm = make_oci_container_vm (get_val (tree, "vm", yajl_t_object), ctx, err);
    if (ret->vm == NULL && *err != 0) {
        free_oci_container (ret);
        return NULL;
    }
    if (ret->oci_version == NULL) {
        if (asprintf (err, "Required field '%s' not present", "ociVersion") < 0)
            abort();
        free_oci_container (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "ociVersion") &&
                strcmp (tree->u.object.keys[i], "hooks") &&
                strcmp (tree->u.object.keys[i], "annotations") &&
                strcmp (tree->u.object.keys[i], "hostname") &&
                strcmp (tree->u.object.keys[i], "mounts") &&
                strcmp (tree->u.object.keys[i], "root") &&
                strcmp (tree->u.object.keys[i], "process") &&
                strcmp (tree->u.object.keys[i], "linux") &&
                strcmp (tree->u.object.keys[i], "solaris") &&
                strcmp (tree->u.object.keys[i], "windows") &&
                strcmp (tree->u.object.keys[i], "vm")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_container (oci_container *ptr) {
    if (!ptr)
        return;
    free (ptr->oci_version);
    ptr->oci_version = NULL;
    if (ptr->hooks) {
        free_oci_container_hooks (ptr->hooks);
        ptr->hooks = NULL;
    }
    free_oci_container_annotations (ptr->annotations);
    ptr->annotations = NULL;
    free (ptr->hostname);
    ptr->hostname = NULL;
    if (ptr->mounts) {
        size_t i;
        for (i = 0; i < ptr->mounts_len; i++)
            if (ptr->mounts[i]) {
                free_oci_container_mounts_element (ptr->mounts[i]);
                ptr->mounts[i] = NULL;
            }
        free (ptr->mounts);
        ptr->mounts = NULL;
    }
    if (ptr->root) {
        free_oci_container_root (ptr->root);
        ptr->root = NULL;
    }
    if (ptr->process) {
        free_oci_container_process (ptr->process);
        ptr->process = NULL;
    }
    if (ptr->linux) {
        free_oci_container_linux (ptr->linux);
        ptr->linux = NULL;
    }
    if (ptr->solaris) {
        free_oci_container_solaris (ptr->solaris);
        ptr->solaris = NULL;
    }
    if (ptr->windows) {
        free_oci_container_windows (ptr->windows);
        ptr->windows = NULL;
    }
    if (ptr->vm) {
        free_oci_container_vm (ptr->vm);
        ptr->vm = NULL;
    }
    free (ptr);
}

bool gen_oci_container (yajl_gen g, oci_container *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->oci_version) {
        stat = reformat_map_key (g, (unsigned char *) "ociVersion", 10 /* strlen ("ociVersion") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->oci_version, strlen (ptr->oci_version));
        if (!stat)
            return false;
    }
    if (ptr->hooks) {
        stat = reformat_map_key (g, (unsigned char *) "hooks", 5 /* strlen ("hooks") */);
        if (!stat)
            return false;
        stat = gen_oci_container_hooks (g, ptr->hooks, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->annotations) {
        stat = reformat_map_key (g, (unsigned char *) "annotations", 11 /* strlen ("annotations") */);
        if (!stat)
            return false;
        stat = gen_map_string_string (g, ptr->annotations);
        if (!stat)
            return false;
    }
    if (ptr->hostname) {
        stat = reformat_map_key (g, (unsigned char *) "hostname", 8 /* strlen ("hostname") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->hostname, strlen (ptr->hostname));
        if (!stat)
            return false;
    }
    if (ptr->mounts) {
        stat = reformat_map_key (g, (unsigned char *) "mounts", 6 /* strlen ("mounts") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->mounts_len; i++) {
            stat = gen_oci_container_mounts_element(g, ptr->mounts[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->root) {
        stat = reformat_map_key (g, (unsigned char *) "root", 4 /* strlen ("root") */);
        if (!stat)
            return false;
        stat = gen_oci_container_root (g, ptr->root, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->process) {
        stat = reformat_map_key (g, (unsigned char *) "process", 7 /* strlen ("process") */);
        if (!stat)
            return false;
        stat = gen_oci_container_process (g, ptr->process, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->linux) {
        stat = reformat_map_key (g, (unsigned char *) "linux", 5 /* strlen ("linux") */);
        if (!stat)
            return false;
        stat = gen_oci_container_linux (g, ptr->linux, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->solaris) {
        stat = reformat_map_key (g, (unsigned char *) "solaris", 7 /* strlen ("solaris") */);
        if (!stat)
            return false;
        stat = gen_oci_container_solaris (g, ptr->solaris, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->windows) {
        stat = reformat_map_key (g, (unsigned char *) "windows", 7 /* strlen ("windows") */);
        if (!stat)
            return false;
        stat = gen_oci_container_windows (g, ptr->windows, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->vm) {
        stat = reformat_map_key (g, (unsigned char *) "vm", 2 /* strlen ("vm") */);
        if (!stat)
            return false;
        stat = gen_oci_container_vm (g, ptr->vm, ctx, err);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}


oci_container *oci_container_parse_file (const char *filename, struct parser_context *ctx, parser_error *err) {
    yajl_val tree;
    size_t filesize;

    if (!filename || !err)
        return NULL;
    *err = NULL;
    struct parser_context tmp_ctx;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char *content = read_file (filename, &filesize);
    char errbuf[1024];
    if (content == NULL) {
        if (asprintf (err, "cannot read the file: %s", filename) < 0)
            abort ();
        return NULL;
    }
    tree = yajl_tree_parse (content, errbuf, sizeof (errbuf));
    free (content);
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the file: %s", errbuf) < 0)
            abort ();
        return NULL;
    }

    oci_container *ptr = make_oci_container (tree, ctx, err);
    yajl_tree_free (tree);
    return ptr;
}

oci_container *oci_container_parse_file_stream (FILE *stream, struct parser_context *ctx, parser_error *err) {
    yajl_val tree;
    size_t filesize;

    if (!stream || !err)
        return NULL;
    *err = NULL;
    struct parser_context tmp_ctx;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char *content = fread_file (stream, &filesize);
    char errbuf[1024];
    if (content == NULL) {
        *err = strdup ("cannot read the file");
        return NULL;
    }
    tree = yajl_tree_parse (content, errbuf, sizeof (errbuf));
    free (content);
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the stream: %s", errbuf) < 0)
            abort ();
        return NULL;
    }

    oci_container *ptr = make_oci_container (tree, ctx, err);
    yajl_tree_free (tree);
    return ptr;
}

oci_container *oci_container_parse_data (const char *jsondata, struct parser_context *ctx, parser_error *err) {
    yajl_val tree;
    struct parser_context tmp_ctx;

    if (!jsondata || !err)
        return NULL;
    *err = NULL;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char errbuf[1024];
    tree = yajl_tree_parse (jsondata, errbuf, sizeof (errbuf));
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the data: %s", errbuf) < 0)
            abort ();
        return NULL;
    }
    oci_container *ptr = make_oci_container (tree, ctx, err);
    yajl_tree_free (tree);
    return ptr;
}
char *oci_container_generate_json (oci_container *ptr, struct parser_context *ctx, parser_error *err) {
    yajl_gen g = NULL;
    struct parser_context tmp_ctx;
    const unsigned char *gen_buf = NULL;
    char *json_buf = NULL;
    size_t gen_len = 0;

    if (!ptr || !err)
        return NULL;
    *err = NULL;
    if (!ctx) {
        ctx = &tmp_ctx;
        memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }

    if (!json_gen_init (&g)) {
        *err = strdup ("Json_gen init failed");
        goto out;
    }
    if (!gen_oci_container (g, ptr, ctx, err)) {
        *err = strdup ("Failed to generate json");
        goto free_out;
    }

    yajl_gen_get_buf (g, &gen_buf, &gen_len);
    if (!gen_buf) {
        *err = strdup ("Error to get generated json");
        goto free_out;
    }

    json_buf = safe_malloc (gen_len + 1);
    memcpy (json_buf, gen_buf, gen_len);
    json_buf[gen_len] = '\0';

free_out:
    yajl_gen_clear (g);
    yajl_gen_free (g);
out:
    return json_buf;
}
