/* autogenerated file */
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE
# endif
#include <string.h>
#include <read-file.h>
#include "oci_image_manifest_spec.h"

void free_oci_image_manifest_config_annotations (oci_image_manifest_config_annotations *ptr) {
    if (!ptr)
        return;
    free_cells (ptr);
    ptr = NULL;
    free (ptr);
}

oci_image_manifest_config *make_oci_image_manifest_config (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_image_manifest_config *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "mediaType", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->media_type = strdup (str ? str : "");
            if (ret->media_type == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "size", yajl_t_number);
        if (val) {
            ret->size = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->size_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "digest", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->digest = strdup (str ? str : "");
            if (ret->digest == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "urls", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->urls_len = len;
            ret->urls = safe_malloc ((len + 1) * sizeof (*ret->urls));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->urls[i] = strdup (str ? str : "");
                    if (ret->urls[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "annotations", yajl_t_object);
        if (tmp != NULL) {
            ret->annotations = read_map_string_string (tmp);
        }
    }
    if (ret->media_type == NULL) {
        if (asprintf (err, "Required field '%s' not present", "mediaType") < 0)
            abort();
        free_oci_image_manifest_config (ret);
        return NULL;
    }
    if (ret->digest == NULL) {
        if (asprintf (err, "Required field '%s' not present", "digest") < 0)
            abort();
        free_oci_image_manifest_config (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "mediaType") &&
                strcmp (tree->u.object.keys[i], "size") &&
                strcmp (tree->u.object.keys[i], "digest") &&
                strcmp (tree->u.object.keys[i], "urls") &&
                strcmp (tree->u.object.keys[i], "annotations")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_image_manifest_config (oci_image_manifest_config *ptr) {
    if (!ptr)
        return;
    free (ptr->media_type);
    ptr->media_type = NULL;
    free (ptr->digest);
    ptr->digest = NULL;
    if (ptr->urls) {
        size_t i;
        for (i = 0; i < ptr->urls_len; i++) {
            if (ptr->urls[i]) {
                free (ptr->urls[i]);
                ptr->urls[i] = NULL;
            }
        }
        free (ptr->urls);
        ptr->urls = NULL;
    }
    free_oci_image_manifest_config_annotations (ptr->annotations);
    ptr->annotations = NULL;
    free (ptr);
}

bool gen_oci_image_manifest_config (yajl_gen g, oci_image_manifest_config *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->media_type) {
        stat = reformat_map_key (g, (unsigned char *) "mediaType", 9 /* strlen ("mediaType") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->media_type, strlen (ptr->media_type));
        if (!stat)
            return false;
    }
    if (ptr->size_present) {
        stat = reformat_map_key (g, (unsigned char *)"size", 4 /* strlen ("size") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->size);
        if (!stat)
            return false;
    }
    if (ptr->digest) {
        stat = reformat_map_key (g, (unsigned char *) "digest", 6 /* strlen ("digest") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->digest, strlen (ptr->digest));
        if (!stat)
            return false;
    }
    if (ptr->urls) {
        stat = reformat_map_key (g, (unsigned char *) "urls", 4 /* strlen ("urls") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->urls_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->urls[i], strlen (ptr->urls[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->annotations) {
        stat = reformat_map_key (g, (unsigned char *) "annotations", 11 /* strlen ("annotations") */);
        if (!stat)
            return false;
        stat = gen_map_string_string (g, ptr->annotations);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

void free_oci_image_manifest_layers_annotations (oci_image_manifest_layers_annotations *ptr) {
    if (!ptr)
        return;
    free_cells (ptr);
    ptr = NULL;
    free (ptr);
}

oci_image_manifest_layers_element *make_oci_image_manifest_layers_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_image_manifest_layers_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "mediaType", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->media_type = strdup (str ? str : "");
            if (ret->media_type == NULL)
                abort ();
        }
    }
    {
        yajl_val val = get_val (tree, "size", yajl_t_number);
        if (val) {
            ret->size = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->size_present = 1;
        }
    }
    {
        yajl_val val = get_val (tree, "digest", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->digest = strdup (str ? str : "");
            if (ret->digest == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "urls", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->urls_len = len;
            ret->urls = safe_malloc ((len + 1) * sizeof (*ret->urls));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->urls[i] = strdup (str ? str : "");
                    if (ret->urls[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "annotations", yajl_t_object);
        if (tmp != NULL) {
            ret->annotations = read_map_string_string (tmp);
        }
    }
    if (ret->media_type == NULL) {
        if (asprintf (err, "Required field '%s' not present", "mediaType") < 0)
            abort();
        free_oci_image_manifest_layers_element (ret);
        return NULL;
    }
    if (ret->digest == NULL) {
        if (asprintf (err, "Required field '%s' not present", "digest") < 0)
            abort();
        free_oci_image_manifest_layers_element (ret);
        return NULL;
    }
    return ret;
}

void free_oci_image_manifest_layers_element (oci_image_manifest_layers_element *ptr) {
    if (!ptr)
        return;
    free (ptr->media_type);
    ptr->media_type = NULL;
    free (ptr->digest);
    ptr->digest = NULL;
    if (ptr->urls) {
        size_t i;
        for (i = 0; i < ptr->urls_len; i++) {
            if (ptr->urls[i]) {
                free (ptr->urls[i]);
                ptr->urls[i] = NULL;
            }
        }
        free (ptr->urls);
        ptr->urls = NULL;
    }
    free_oci_image_manifest_layers_annotations (ptr->annotations);
    ptr->annotations = NULL;
    free (ptr);
}

bool gen_oci_image_manifest_layers_element (yajl_gen g, oci_image_manifest_layers_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->media_type) {
        stat = reformat_map_key (g, (unsigned char *) "mediaType", 9 /* strlen ("mediaType") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->media_type, strlen (ptr->media_type));
        if (!stat)
            return false;
    }
    if (ptr->size_present) {
        stat = reformat_map_key (g, (unsigned char *)"size", 4 /* strlen ("size") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->size);
        if (!stat)
            return false;
    }
    if (ptr->digest) {
        stat = reformat_map_key (g, (unsigned char *) "digest", 6 /* strlen ("digest") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->digest, strlen (ptr->digest));
        if (!stat)
            return false;
    }
    if (ptr->urls) {
        stat = reformat_map_key (g, (unsigned char *) "urls", 4 /* strlen ("urls") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->urls_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->urls[i], strlen (ptr->urls[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->annotations) {
        stat = reformat_map_key (g, (unsigned char *) "annotations", 11 /* strlen ("annotations") */);
        if (!stat)
            return false;
        stat = gen_map_string_string (g, ptr->annotations);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}

void free_oci_image_manifest_annotations (oci_image_manifest_annotations *ptr) {
    if (!ptr)
        return;
    free_cells (ptr);
    ptr = NULL;
    free (ptr);
}

oci_image_manifest *make_oci_image_manifest (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    oci_image_manifest *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "schemaVersion", yajl_t_number);
        if (val) {
            ret->schema_version = strtoll (YAJL_GET_NUMBER (val), NULL, 10);
            ret->schema_version_present = 1;
        }
    }
    ret->config = make_oci_image_manifest_config (get_val (tree, "config", yajl_t_object), ctx, err);
    if (ret->config == NULL && *err != 0) {
        free_oci_image_manifest (ret);
        return NULL;
    }
    {
        yajl_val tmp = get_val (tree, "layers", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->layers_len = len;
            ret->layers = safe_malloc ((len + 1) * sizeof (*ret->layers));
            for (i = 0; i < len; i++) {
                ret->layers[i] = make_oci_image_manifest_layers_element (values[i], ctx, err);
                if (ret->layers[i] == NULL) {
                    free_oci_image_manifest (ret);
                    return NULL;
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "annotations", yajl_t_object);
        if (tmp != NULL) {
            ret->annotations = read_map_string_string (tmp);
        }
    }
    if (ret->config == NULL) {
        if (asprintf (err, "Required field '%s' not present", "config") < 0)
            abort();
        free_oci_image_manifest (ret);
        return NULL;
    }
    if (ret->layers == NULL) {
        if (asprintf (err, "Required field '%s' not present", "layers") < 0)
            abort();
        free_oci_image_manifest (ret);
        return NULL;
    }

    if (tree->type == yajl_t_object && (ctx->options & PARSE_OPTIONS_STRICT)) {
        size_t i;
        for (i = 0; i < tree->u.object.len; i++)
            if (strcmp (tree->u.object.keys[i], "schemaVersion") &&
                strcmp (tree->u.object.keys[i], "config") &&
                strcmp (tree->u.object.keys[i], "layers") &&
                strcmp (tree->u.object.keys[i], "annotations")) {
                fprintf (ctx->errfile, "WARNING: unknown key found: %s\n", tree->u.object.keys[i]);
            }
        }
    return ret;
}

void free_oci_image_manifest (oci_image_manifest *ptr) {
    if (!ptr)
        return;
    if (ptr->config) {
        free_oci_image_manifest_config (ptr->config);
        ptr->config = NULL;
    }
    if (ptr->layers) {
        size_t i;
        for (i = 0; i < ptr->layers_len; i++)
            if (ptr->layers[i]) {
                free_oci_image_manifest_layers_element (ptr->layers[i]);
                ptr->layers[i] = NULL;
            }
        free (ptr->layers);
        ptr->layers = NULL;
    }
    free_oci_image_manifest_annotations (ptr->annotations);
    ptr->annotations = NULL;
    free (ptr);
}

bool gen_oci_image_manifest (yajl_gen g, oci_image_manifest *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->schema_version_present) {
        stat = reformat_map_key (g, (unsigned char *)"schemaVersion", 13 /* strlen ("schemaVersion") */);
        if (!stat)
            return false;
        stat = reformat_integer (g, ptr->schema_version);
        if (!stat)
            return false;
    }
    if (ptr->config) {
        stat = reformat_map_key (g, (unsigned char *) "config", 6 /* strlen ("config") */);
        if (!stat)
            return false;
        stat = gen_oci_image_manifest_config (g, ptr->config, ctx, err);
        if (!stat)
            return false;
    }
    if (ptr->layers) {
        stat = reformat_map_key (g, (unsigned char *) "layers", 6 /* strlen ("layers") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->layers_len; i++) {
            stat = gen_oci_image_manifest_layers_element(g, ptr->layers[i], ctx, err);
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->annotations) {
        stat = reformat_map_key (g, (unsigned char *) "annotations", 11 /* strlen ("annotations") */);
        if (!stat)
            return false;
        stat = gen_map_string_string (g, ptr->annotations);
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}


oci_image_manifest *oci_image_manifest_parse_file (const char *filename, struct parser_context *ctx, parser_error *err) {
    yajl_val tree;
    size_t filesize;

    if (!filename || !err)
        return NULL;
    *err = NULL;
    struct parser_context tmp_ctx;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char *content = read_file (filename, &filesize);
    char errbuf[1024];
    if (content == NULL) {
        if (asprintf (err, "cannot read the file: %s", filename) < 0)
            abort ();
        return NULL;
    }
    tree = yajl_tree_parse (content, errbuf, sizeof (errbuf));
    free (content);
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the file: %s", errbuf) < 0)
            abort ();
        return NULL;
    }

    oci_image_manifest *ptr = make_oci_image_manifest (tree, ctx, err);
    yajl_tree_free (tree);
    return ptr;
}

oci_image_manifest *oci_image_manifest_parse_file_stream (FILE *stream, struct parser_context *ctx, parser_error *err) {
    yajl_val tree;
    size_t filesize;

    if (!stream || !err)
        return NULL;
    *err = NULL;
    struct parser_context tmp_ctx;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char *content = fread_file (stream, &filesize);
    char errbuf[1024];
    if (content == NULL) {
        *err = strdup ("cannot read the file");
        return NULL;
    }
    tree = yajl_tree_parse (content, errbuf, sizeof (errbuf));
    free (content);
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the stream: %s", errbuf) < 0)
            abort ();
        return NULL;
    }

    oci_image_manifest *ptr = make_oci_image_manifest (tree, ctx, err);
    yajl_tree_free (tree);
    return ptr;
}

oci_image_manifest *oci_image_manifest_parse_data (const char *jsondata, struct parser_context *ctx, parser_error *err) {
    yajl_val tree;
    struct parser_context tmp_ctx;

    if (!jsondata || !err)
        return NULL;
    *err = NULL;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char errbuf[1024];
    tree = yajl_tree_parse (jsondata, errbuf, sizeof (errbuf));
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the data: %s", errbuf) < 0)
            abort ();
        return NULL;
    }
    oci_image_manifest *ptr = make_oci_image_manifest (tree, ctx, err);
    yajl_tree_free (tree);
    return ptr;
}
char *oci_image_manifest_generate_json (oci_image_manifest *ptr, struct parser_context *ctx, parser_error *err) {
    yajl_gen g = NULL;
    struct parser_context tmp_ctx;
    const unsigned char *gen_buf = NULL;
    char *json_buf = NULL;
    size_t gen_len = 0;

    if (!ptr || !err)
        return NULL;
    *err = NULL;
    if (!ctx) {
        ctx = &tmp_ctx;
        memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }

    if (!json_gen_init (&g)) {
        *err = strdup ("Json_gen init failed");
        goto out;
    }
    if (!gen_oci_image_manifest (g, ptr, ctx, err)) {
        *err = strdup ("Failed to generate json");
        goto free_out;
    }

    yajl_gen_get_buf (g, &gen_buf, &gen_len);
    if (!gen_buf) {
        *err = strdup ("Error to get generated json");
        goto free_out;
    }

    json_buf = safe_malloc (gen_len + 1);
    memcpy (json_buf, gen_buf, gen_len);
    json_buf[gen_len] = '\0';

free_out:
    yajl_gen_clear (g);
    yajl_gen_free (g);
out:
    return json_buf;
}
