/* autogenerated file */
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE
# endif
#include <string.h>
#include <read-file.h>
#include "image_manifest_items.h"

image_manifest_items_element *make_image_manifest_items_element (yajl_val tree, struct parser_context *ctx, parser_error *err) {
    image_manifest_items_element *ret = NULL;
    *err = 0;
    (void) ctx;  /* Silence compiler warning.  */
    if (tree == NULL)
        return ret;
    ret = safe_malloc (sizeof (*ret));
    {
        yajl_val val = get_val (tree, "Config", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->config = strdup (str ? str : "");
            if (ret->config == NULL)
                abort ();
        }
    }
    {
        yajl_val tmp = get_val (tree, "Layers", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->layers_len = len;
            ret->layers = safe_malloc ((len + 1) * sizeof (*ret->layers));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->layers[i] = strdup (str ? str : "");
                    if (ret->layers[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val tmp = get_val (tree, "RepoTags", yajl_t_array);
        if (tmp && YAJL_GET_ARRAY (tmp)) {
            size_t i;
            yajl_val *values = YAJL_GET_ARRAY (tmp)->values;
            size_t len = YAJL_GET_ARRAY (tmp)->len;
            ret->repo_tags_len = len;
            ret->repo_tags = safe_malloc ((len + 1) * sizeof (*ret->repo_tags));
            for (i = 0; i < len; i++) {
                yajl_val val = values[i];
                if (val) {
                    char *str = YAJL_GET_STRING (val);
                    ret->repo_tags[i] = strdup (str ? str : "");
                    if (ret->repo_tags[i] == NULL)
                        abort ();
                }
            }
        }
    }
    {
        yajl_val val = get_val (tree, "Parent", yajl_t_string);
        if (val) {
            char *str = YAJL_GET_STRING (val);
            ret->parent = strdup (str ? str : "");
            if (ret->parent == NULL)
                abort ();
        }
    }
    if (ret->config == NULL) {
        if (asprintf (err, "Required field '%s' not present", "Config") < 0)
            abort();
        free_image_manifest_items_element (ret);
        return NULL;
    }
    if (ret->layers == NULL) {
        if (asprintf (err, "Required field '%s' not present", "Layers") < 0)
            abort();
        free_image_manifest_items_element (ret);
        return NULL;
    }
    return ret;
}

void free_image_manifest_items_element (image_manifest_items_element *ptr) {
    if (!ptr)
        return;
    free (ptr->config);
    ptr->config = NULL;
    if (ptr->layers) {
        size_t i;
        for (i = 0; i < ptr->layers_len; i++) {
            if (ptr->layers[i]) {
                free (ptr->layers[i]);
                ptr->layers[i] = NULL;
            }
        }
        free (ptr->layers);
        ptr->layers = NULL;
    }
    if (ptr->repo_tags) {
        size_t i;
        for (i = 0; i < ptr->repo_tags_len; i++) {
            if (ptr->repo_tags[i]) {
                free (ptr->repo_tags[i]);
                ptr->repo_tags[i] = NULL;
            }
        }
        free (ptr->repo_tags);
        ptr->repo_tags = NULL;
    }
    free (ptr->parent);
    ptr->parent = NULL;
    free (ptr);
}

bool gen_image_manifest_items_element (yajl_gen g, image_manifest_items_element *ptr, struct parser_context *ctx, parser_error *err) {
    bool stat = true;
    *err = 0;
    (void) ptr;  /* Silence compiler warning.  */
    (void) ctx;  /* Silence compiler warning.  */
    stat = reformat_start_map (g);
    if (!stat)
        return false;
    if (ptr->config) {
        stat = reformat_map_key (g, (unsigned char *) "Config", 6 /* strlen ("Config") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->config, strlen (ptr->config));
        if (!stat)
            return false;
    }
    if (ptr->layers) {
        stat = reformat_map_key (g, (unsigned char *) "Layers", 6 /* strlen ("Layers") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->layers_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->layers[i], strlen (ptr->layers[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->repo_tags) {
        stat = reformat_map_key (g, (unsigned char *) "RepoTags", 8 /* strlen ("RepoTags") */);
        if (!stat)
            return false;
        size_t i;
        stat = reformat_start_array (g);
        if (!stat)
            return false;
        for (i = 0; i < ptr->repo_tags_len; i++) {
            stat = reformat_string (g, (unsigned char *) ptr->repo_tags[i], strlen (ptr->repo_tags[i]));
            if (!stat)
                return false;
        }
        stat = reformat_end_array (g);
        if (!stat)
            return false;
    }
    if (ptr->parent) {
        stat = reformat_map_key (g, (unsigned char *) "Parent", 6 /* strlen ("Parent") */);
        if (!stat)
            return false;
        stat = reformat_string (g, (unsigned char *) ptr->parent, strlen (ptr->parent));
        if (!stat)
            return false;
    }
    stat = reformat_end_map (g);
    if (!stat)
        return false;
    return true;
}



image_manifest_items_element **make_image_manifest_items (yajl_val tree, struct parser_context *ctx, parser_error *err, size_t *len) {
    image_manifest_items_element **ptr;
    size_t i, alen;
    if (!tree || !err || !len || !YAJL_GET_ARRAY (tree))
        return NULL;
    *err = 0;
    alen = YAJL_GET_ARRAY (tree)->len;
    if (alen == 0)
        return NULL;
    ptr = safe_malloc ((alen + 1) * sizeof (image_manifest_items_element *));
    for (i = 0; i < alen; i++) {
        yajl_val val = YAJL_GET_ARRAY (tree)->values[i];
        ptr[i] = make_image_manifest_items_element (val, ctx, err);
        if (ptr[i] == NULL) {
            free_image_manifest_items(ptr, alen);
            return NULL;
        }
    }
    *len = alen;
    return ptr;
}


void free_image_manifest_items (image_manifest_items_element **ptr, size_t len) {
    size_t i;

    if (!ptr || len <= 0)
        return;

    for (i = 0; i < len; i++) {
        if (ptr[i]) {
            free_image_manifest_items_element (ptr[i]);
            ptr[i] = NULL;
        }
    }
    free (ptr);
}


bool gen_image_manifest_items (yajl_gen g, image_manifest_items_element **ptr, size_t len, struct parser_context *ctx, parser_error *err) {
    bool stat;
    size_t i;
    *err = 0;
    stat = reformat_start_array (g);
    if (!stat)
        return false;
    for (i = 0; i < len; i++) {
        stat = gen_image_manifest_items_element (g, ptr[i], ctx, err);
        if (!stat)
            return false;
    }
    stat = reformat_end_array (g);
    if (!stat)
        return false;
    return true;
}

image_manifest_items_element **image_manifest_items_parse_file (const char *filename, struct parser_context *ctx, parser_error *err, size_t *len) {
    yajl_val tree;
    size_t filesize;

    if (!filename || !err)
        return NULL;
    *err = NULL;
    struct parser_context tmp_ctx;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char *content = read_file (filename, &filesize);
    char errbuf[1024];
    if (content == NULL) {
        if (asprintf (err, "cannot read the file: %s", filename) < 0)
            abort ();
        return NULL;
    }
    tree = yajl_tree_parse (content, errbuf, sizeof (errbuf));
    free (content);
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the file: %s", errbuf) < 0)
            abort ();
        return NULL;
    }

    image_manifest_items_element **ptr = make_image_manifest_items (tree, ctx, err, len);
    yajl_tree_free (tree);
    return ptr;
}

image_manifest_items_element **image_manifest_items_parse_file_stream (FILE *stream, struct parser_context *ctx, parser_error *err, size_t *len) {
    yajl_val tree;
    size_t filesize;

    if (!stream || !err)
        return NULL;
    *err = NULL;
    struct parser_context tmp_ctx;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char *content = fread_file (stream, &filesize);
    char errbuf[1024];
    if (content == NULL) {
        *err = strdup ("cannot read the file");
        return NULL;
    }
    tree = yajl_tree_parse (content, errbuf, sizeof (errbuf));
    free (content);
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the stream: %s", errbuf) < 0)
            abort ();
        return NULL;
    }

    image_manifest_items_element **ptr = make_image_manifest_items (tree, ctx, err, len);
    yajl_tree_free (tree);
    return ptr;
}

image_manifest_items_element **image_manifest_items_parse_data (const char *jsondata, struct parser_context *ctx, parser_error *err, size_t *len) {
    yajl_val tree;
    struct parser_context tmp_ctx;

    if (!jsondata || !err)
        return NULL;
    *err = NULL;
    if (!ctx) {
       ctx = &tmp_ctx;
       memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }
    char errbuf[1024];
    tree = yajl_tree_parse (jsondata, errbuf, sizeof (errbuf));
    if (tree == NULL) {
        if (asprintf (err, "cannot parse the data: %s", errbuf) < 0)
            abort ();
        return NULL;
    }
    image_manifest_items_element **ptr = make_image_manifest_items (tree, ctx, err, len);
    yajl_tree_free (tree);
    return ptr;
}
char *image_manifest_items_generate_json (image_manifest_items_element **ptr, size_t len, struct parser_context *ctx, parser_error *err) {
    yajl_gen g = NULL;
    struct parser_context tmp_ctx;
    const unsigned char *gen_buf = NULL;
    char *json_buf = NULL;
    size_t gen_len = 0;

    if (!ptr || !err)
        return NULL;
    *err = NULL;
    if (!ctx) {
        ctx = &tmp_ctx;
        memset (&tmp_ctx, 0, sizeof (tmp_ctx));
    }

    if (!json_gen_init (&g)) {
        *err = strdup ("Json_gen init failed");
        goto out;
    }
    if (!gen_image_manifest_items (g, ptr, len, ctx, err)) {
        *err = strdup ("Failed to generate json");
        goto free_out;
    }

    yajl_gen_get_buf (g, &gen_buf, &gen_len);
    if (!gen_buf) {
        *err = strdup ("Error to get generated json");
        goto free_out;
    }

    json_buf = safe_malloc (gen_len + 1);
    memcpy (json_buf, gen_buf, gen_len);
    json_buf[gen_len] = '\0';

free_out:
    yajl_gen_clear (g);
    yajl_gen_free (g);
out:
    return json_buf;
}
