title: WebSocket Service
toc: [Documentation, Administration, Web Services, WebSocket Service]

# WebSocket Service

Quick Links: **[WebSocket Options](WebSocket Options)** - **[WebSocket Compression](WebSocket Compression)** - **[Cookie Tracking](Cookie Tracking)**

The WebSocket Service is probably the most important among the Web services provided by the [Web Transport](Web Transport and Services). It provides WAMP-over-WebSocket transport services on a configurable HTTP path, so serving WAMP clients can be mixed with other Web services, and run on one network port.

> The difference between the WebSocket Service here, and the [WebSocket Transport](WebSocket Transport) is that the latter transport is **only** able to serve WAMP-over-WebSocket and nothing else, whereas the WAMP-over-WebSocket transport here can be combined with other Web services all running on one port under the umbrella of a [Web Transport](Web Transport and Services).

## Configuration

To configure a WebSocket Service, attach a dictionary element to a path in your [Web transport](Web Transport and Services):

option | description
---|---
**`type`** | Must be `"websocket"`.
**`url`** | The WebSocket server URL to use.
**`serializers`** | List of WAMP serializers to announce/speak, must be from `"json"` and `"msgpack"` (default: **all available**)
**`options`** | See [WebSocket Options](WebSocket Options).
**`auth`** | Authentication to be used - see [Authentication](Authentication).
**`cookie`** | Configure cookie tracking on this transport - see [Cookie Tracking](Cookie-Tracking).
**`debug`** | Enable transport level debug output. (default: **`false`**)

## Example

The Crossbar.io node configuration generated by default already contains an example for the WebSocket Service.

Just create a new Crossbar.io node

    mkdir ~/mynode
    cd ~/mynode
    crossbar init

This will generate a node configuration `~/mynode/.crossbar/config.json` with this contents (we only show part of the contents):

```json
{
   "workers": [
      {
         "type": "router",
         "transports": [
            {
               "type": "web",
               "paths": {
                  "/": {
                     "type": "static",
                     "directory": ".."
                  },
                  "ws": {
                     "type": "websocket"
                  }
               }
            }
         ]
      }
   ]
}
```

This will run a WebSocket Service on the path `/ws`. All other paths are served by the service configured for the root path `/`, which in this case is just serving the `~/mynode` directory.

The WebSocket transport as used above (as a subpath service) has all the parameters and options like for a standalone WebSocket transport. The only exception is **endpoint**, which must be provided with standalone WebSocket transport, but which must not be specified when running as a subpath service (since the endpoint is already configured on the base Web transport).

If present, the URL in the WebSocket part of the configuration MUST include the path component. In the above, since the WebSocket transport runs on the path **/ws**, the correct URL is **ws://localhost:8080/ws**. A standalone WebSocket transport's URL would have used **ws://localhost:8080**.

---