unit fExLabelPrint;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, ComCtrls, iniFiles, lcltype;

type

  { TfrmExLabelPrint }

  TfrmExLabelPrint = class(TForm)
    btnExport: TButton;
    btnHelp: TButton;
    Cancel: TButton;
    chkAllQSOs: TCheckBox;
    chkMarkSent: TCheckBox;
    edtRemarks: TEdit;
    edtQSOsToLabel: TEdit;
    edtBrowse: TButton;
    edtFile: TEdit;
    gchkExport: TCheckGroup;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    lblProgress: TLabel;
    rbQSORemarks: TRadioButton;
    rbOwnRemarks: TRadioButton;
    dlgSave: TSaveDialog;
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure btnExportClick(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure chkAllQSOsChange(Sender: TObject);
    procedure edtBrowseClick(Sender: TObject);
    procedure edtQSOsToLabelExit(Sender: TObject);
    procedure edtRemarksEnter(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  frmExLabelPrint: TfrmExLabelPrint;

implementation

uses dUtils, dData, uMyIni;
{ TfrmExLabelPrint }

procedure TfrmExLabelPrint.edtQSOsToLabelExit(Sender: TObject);
var
  nr : Integer;
begin
  if not TryStrToInt(edtQSOsToLabel.Text, nr) then
    edtQSOsToLabel.Text := '6'
  else begin
    if not ((nr > 0) and (nr<7)) then
      edtQSOsToLabel.Text := '6'
  end;
end;

procedure TfrmExLabelPrint.FormShow(Sender: TObject);
begin
  edtFile.Text := cqrini.ReadString('QslExport','Path',dmData.DataDir+'qsl.csv');
  dlgSave.InitialDir := ExtractFilePath(edtFile.Text);
  gchkExport.Checked[0] := True;
  gchkExport.Checked[2] := True;
  gchkExport.Checked[4] := True;
  edtQSOsToLabel.Text   := cqrini.ReadString('QslExport','QSOs','6');
  edtRemarks.Text       := cqrini.ReadString('QslExport','Remarks','');
  if edtRemarks.Text <> '' then
    rbOwnRemarks.Checked
end;

procedure TfrmExLabelPrint.btnExportClick(Sender: TObject);
var
  tmp    : String = '';
  f      : TextFile;
  mycall : String = '';
  ex     : Boolean = False;
  old    : String = '';
  lNr    : Integer = 0;
  MaxQ   : Integer;
  i      : Integer;
  band   : String = '';
  rem    : String = '';
  qsl_s  : String = '';
  id     : Int64 = 0;
  qso_nr : Int64 = 0;
begin
  mycall := cqrini.ReadString('Station','Call','');
  if (mycall='') then
  begin
    Application.MessageBox('Your callsign is not set! Please set it in Preferences.','Info ...',mb_OK + mb_IconInformation);
    exit
  end;
  if FileExists(edtFile.Text) then
  begin
    if Application.MessageBox('File already exists! Do you want to overvrite it?',
                              'Question',mb_YesNo + mb_IconQuestion) = idYes then
      DeleteFile(edtFile.Text)
    else
      exit
  end;
  MaxQ := StrToInt(edtQSOsToLabel.Text);
  tmp := dmData.qCQRLOG.SQL.Text;
  dmData.Q.Close;
  Writeln('tmp:',tmp);
  {if not dmData.IsFilter then
  begin
    p := Pos('ORDER BY',UpperCase(tmp));
    tmp := copy(tmp,1,p-1);  //remove order by
    tmp := tmp + ' order by callsign,dxcc_ref'
  end;
  CREATE VIEW view_cqrlog_main_by_qsodate AS SELECT id_cqrlog_main,qsodate,time_on,time_off,callsign, freq,mode,rst_s,rst_r,name,qth,qsl_s,qsl_r,qsl_via,iota,pwr,itu,waz,loc,my_loc,county,
  award,remarks, band, dxcc_id.dxcc_ref AS dxcc_ref ,qso_dxcc, profile,idcall, state, lotw_qslsdate, lotw_qslrdate,lotw_qsls, lotw_qslr, cont, qsls_date,qslr_date,club_nr1,club_nr2,club_nr3,
  club_nr4,club_nr5 FROM cqrlog_main JOIN dxcc_id ON dxcc_id.adif = cqrlog_main.adif order by qsodate DESC, time_on DESC;
  }
  dmData.Q.SQL.Text := tmp;
  if dmData.DebugLevel >= 1 then Writeln(dmData.Q.SQL.Text);
  dmData.trQ.StartTransaction;
  dmData.Q.Open;
  dmData.Q.First;
  AssignFile(f,edtFile.Text);
  Rewrite(f);
  dmData.trQ1.StartTransaction;
  try
    while not dmData.Q.Eof do
    begin
      ex := False;
      if chkAllQSOs.Checked then
        ex := True
      else begin
        if (dmData.Q.Fields[11].AsString = 'SB')  and (gchkExport.Checked[0]) then
          ex := True;
        if (dmData.Q.Fields[11].AsString = 'SD')  and (gchkExport.Checked[1]) then
          ex := True;
        if (dmData.Q.Fields[11].AsString = 'SM')  and (gchkExport.Checked[2]) then
          ex := True;
        if (dmData.Q.Fields[11].AsString = 'SMD') and (gchkExport.Checked[3]) then
          ex := True;
        if (dmData.Q.Fields[11].AsString = 'SMB') and (gchkExport.Checked[4]) then
          ex := True
      end;
      if not ex then
      begin
        dmData.Q.Next;
        Continue
      end;
      band := dmUtils.GetLabelBand(dmData.Q.Fields[5].AsString);
      Writeln('freq:',dmData.Q.Fields[5].AsString);
      Writeln('band:',band);
      if (band = '') then
      begin
        dmData.Q.Next;
        Continue
      end;
      inc(qso_nr);
      id    := dmData.Q.Fields[0].AsInteger;
      qsl_s := dmData.Q.Fields[11].AsString;
      if Pos('S',qsl_s) = 1 then
        qsl_s := copy(qsl_s,2,Length(qsl_s)-1)
      else begin
        if qsl_s = '' then
        begin
          if dmData.Q.Fields[13].AsString <> '' then
            qsl_s := 'MB'
          else
            qsl_s := 'B'
        end
      end;
      if chkMarkSent.Checked then
      begin
        dmData.Q1.SQL.Text := 'update cqrlog_main set qsl_s ='+QuotedStr(qsl_s)  +
                              ', qsls_date = '+ QuotedStr(dmUtils.DateInRightFormat(dmUtils.GetDateTime(0))) +
                              ' where id_cqrlog_main='+IntToStr(id);
        if dmData.DebugLevel >= 1 then Writeln(dmData.Q1.SQL.Text);
        dmData.Q1.ExecSQL
      end;
      if old <> dmData.Q.Fields[4].AsString then
      begin
        if (old <> '') then
        begin
          for i:=lNr+1 to MaxQ do
            Write(f,',,,,,,,,');
          if rbQSORemarks.Checked then
            Write(f,',',rem)
          else
            Write(f,',',edtRemarks.Text);
          Writeln(f);
          lNr := 0;
          old := 'aaa'
        end;
        Write(f,mycall,',',dmData.Q.Fields[1].AsString,',',dmData.Q.Fields[2].AsString,','); //mycall,date,time
        Write(f,dmData.Q.Fields[4].AsString,',',dmData.Q.Fields[13].AsString,','); //call,qsl_via
        Write(f,band,',',dmData.Q.Fields[6].AsString,',',dmData.Q.Fields[7].AsString,',');//band,mode,rst_s
        if dmData.Q.Fields[12].AsString <> 'Q' then
          Write(f,'PSE')
        else
          Write(f,'TNX');
        lNr := 1
      end
      else begin
        Write(f,',',dmData.Q.Fields[1].AsString,',',dmData.Q.Fields[2].AsString,','); //date,time
        Write(f,dmData.Q.Fields[4].AsString,',',dmData.Q.Fields[13].AsString,','); //call,qsl_via
        Write(f,band,',',dmData.Q.Fields[6].AsString,',',dmData.Q.Fields[7].AsString,',');//band.mode,rst_s
        if dmData.Q.Fields[12].AsString <> 'Q' then
          Write(f,'PSE')
        else
          Write(f,'TNX');
        inc(lNr)
      end;
      if lNr+1 > MaxQ then
        old := 'aaa'
      else
        old := dmData.Q.Fields[4].AsString;
      rem := dmData.Q.Fields[22].AsString;
      dmData.Q.Next
    end;
    if qso_nr > 0 then
    begin
      for i:=lNr+1 to MaxQ do
        Write(f,',,,,,,,,');
      if rbQSORemarks.Checked then
        Write(f,',',rem)
      else
        Write(f,',',edtRemarks.Text)
    end;
    dmData.trQ1.Commit;
    lblProgress.Caption := 'Exporting QSO nr. ' + IntToStr(qso_nr);
    lblProgress.Repaint
  finally
    lblProgress.Caption := 'Complete!';
    CloseFile(f);
    dmData.Q.Close();
    dmData.trQ.Rollback;
    dmData.Q1.Close;
    dmData.trQ1.Rollback;
    dmData.RefreshMainDatabase(id)
  end
end;

procedure TfrmExLabelPrint.btnHelpClick(Sender: TObject);
begin
  ShowHelp
end;

procedure TfrmExLabelPrint.chkAllQSOsChange(Sender: TObject);
begin
  if chkAllQSOs.Checked then
    gchkExport.Enabled := False
  else
    gchkExport.Enabled := True
end;

procedure TfrmExLabelPrint.edtBrowseClick(Sender: TObject);
begin
  if dlgSave.Execute then
    edtFile.Text := dlgSave.FileName
end;

procedure TfrmExLabelPrint.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
  cqrini.WriteString('QslExport','Path',edtFile.Text);
  cqrini.WriteString('QslExport','QSOs',edtQSOsToLabel.Text);
  cqrini.WriteString('QslExport','Remarks',edtRemarks.Text)
end;

procedure TfrmExLabelPrint.edtRemarksEnter(Sender: TObject);
begin
  rbOwnRemarks.Checked := True
end;

initialization
  {$I fExLabelPrint.lrs}

end.

