unit fDatabaseUpdate;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, ComCtrls,
  ExtCtrls, StdCtrls, httpsend, inifiles, process;

type

  { TfrmDatabaseUpdate }

  TfrmDatabaseUpdate = class(TForm)
    btnCancel: TButton;
    pnlQRZ:    TPanel;
    tmrQRZ:    TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure tmrQRZTimer(Sender: TObject);
  private
    procedure QRZupdate;
  public
    id_cqrlog_main: Integer;
    NameFromLog : Boolean;
    procedure SynCallBook;
  end;

type
  TQRZThread = class(TThread)
  protected
    procedure Execute; override;
  end;


var
  frmDatabaseUpdate: TfrmDatabaseUpdate;

implementation

{ TfrmDatabaseUpdate }
uses dUtils, dData, uMyIni;

var
  Callbook: string;
  CancelUpdate: boolean;
  CloseW:  boolean;
  running: boolean;


procedure TQRZThread.Execute;
var
  HTTP:   THTTPSend;
  tmp:    string = '';
  qsl_via: string = '';
  m:      TStringList;
  qth:    string = '';
  stnName: string = '';
  dbCall: string = '';
  dbName: string = '';
  dbQTH:  string = '';
  dbQSLVia: string = '';
  dbCounty: string = '';
  dbAward: string = '';
  dbDXCC: string = '';
  dbGrid: string = '';
  dbId:   int64 = 0;
  dbState: string = '';
  idCall: string = '';
  County: string = '';
  StoreTo: string = '';
  dbRemQSO: string = '';
  IgnoreQRZ: boolean = False;
  MvToRem: boolean = True;
  cGrid:  string = '';
  cState: string = '';
  cCounty: string = '';

  procedure DoUpgrade;
  begin
    dbCall   := dmData.qCallBook.FieldByName('callsign').AsString;
    dbName   := dmData.qCallBook.FieldByName('name').AsString;
    dbQTH    := dmData.qCallBook.FieldByName('qth').AsString;
    dbQSLVia := dmData.qCallBook.FieldByName('qsl_via').AsString;
    dbCounty := dmData.qCallBook.FieldByName('county').AsString;
    dbAward  := dmData.qCallBook.FieldByName('award').AsString;
    dbId     := dmData.qCallBook.FieldByName('id_cqrlog_main').AsInteger;
    dbState  := dmData.qCallBook.FieldByName('state').AsString;
    dbRemQSO := dmData.qCallBook.FieldByName('remarks').AsString;
    dbGrid   := dmData.qCallBook.FieldByName('loc').AsString;
    if frmDatabaseUpdate.NameFromLog then
    begin
      dmData.Q.Close;
      dmData.Q.SQL.Text := 'select max(id_cqrlog_main),callsign,name from cqrlog_main where name <> '+QuotedStr('')+
                           ' and callsign = '+QuotedStr(dbCall)+' group by callsign,name';
      if dmData.DebugLevel>=1 then Writeln(dmData.Q.SQL.Text);
      dmData.trQ.StartTransaction;
      dmData.Q.Open();
      dbName := dmData.Q.Fields[2].AsString;
      dmData.trQ.RollBack
    end;

    if dmData.DebugLevel >= 1 then
    begin
      Writeln('----');
      Writeln('dbCall:   ', dbCall);
      Writeln('dbName:   ', dbName);
      Writeln('dbQTH:    ', dbQTH);
      Writeln('dbQSLVIA: ', dbQSLVia);
      Writeln('dbAward:  ', trim(dbAward));
      Writeln('County:   ', County);
      Writeln('dbCounty: ', dbCounty);
      Writeln('dbState:  ', dbState);
      Writeln('dbRemQSO: ', dbRemQSO);
      Writeln('dbGrid:   ', dbGrid);
      Writeln('----');
    end;

    if CancelUpdate then
    begin
      cqrini.WriteInteger('CallBook', 'LastId', dbId);
      CloseW := True;
      Synchronize(@frmDatabaseUpdate.SynCallBook);
    end;

    CallBook := dbCall;
    Synchronize(@frmDatabaseUpdate.SynCallBook);
    idCall := dmUtils.GetIDCall(dbCall);
    HTTP.Clear;
    if HTTP.HTTPMethod('GET', 'http://www.qrz.com/callsign/' + idCall) then
    begin
      qsl_via := '';
      stnName := '';
      qth     := '';
      cState  := '';
      cCounty := '';
      cGrid   := '';
      m.Clear;
      m.LoadFromStream(HTTP.Document);
      tmp := m.Text;
      if Pos('produced no results', tmp) > 0 then
      begin
        if dmData.DebugLevel >= 1 then
          Writeln('Callsign NOT found on qrz.com');
        exit;
      end;

      dmUtils.GetQRZInfo(idCall,tmp,CallBook,cGrid,cState,cCounty,qsl_via);
      if dmData.DebugLevel >= 1 then
      begin
        Writeln('Grid: ', cGrid);
        Writeln('State: ', cState);
        Writeln('County: ', cCounty);
      end;
      m.Clear;
      m.Text := CallBook;
      if m.Count < 2 then
        exit;
      Writeln(m.Text);
      if Pos('<html',m.Text) > 0 then
        exit;

      if Pos(' ',m.Strings[0]) = 0 then
        tmp := m.Strings[0]
      else
        tmp := copy(m.Strings[0], 1, Pos(' ', m.Strings[0]) - 1);
      tmp := LowerCase(tmp);
      if Length(tmp) > 0 then
        tmp[1] := UpCase(tmp[1]);
      stnName := tmp;
      if m.Count >= 2 then
      begin
        qth := dmUtils.ExtractQTH(m.Strings[2]);
        if qth <> '' then
        begin
          if qth[Length(qth)] = ',' then
            qth := copy(qth, 1, Length(qth) - 1);
          if dbQTH = '' then
            dbQTH := qth;
        end;
        qth := m.Strings[2];
      end;
      if (dbState = '') and (cState <> '') then
      begin
        dbState := dmUtils.GetShortState(cState);
        if (dbCounty = '') and (cCounty <> '') then
          dbCounty := dbState + ',' + cCounty;
      end;
      //After ARRL DX we have dbState field filled but not county
      if (dbState <> '') and (dbCounty = '') and (cState <> '') then
        dbCounty := dmUtils.GetShortState(cState)+','+cCounty;


      if (dbGrid = '') and dmUtils.IsLocOK(cGrid) then
        dbGrid := cGrid;
      if qth <> '' then
      begin
        County := dmData.FindCounty1(qth, dbDXCC, StoreTo);
        if County <> '' then
        begin
          if (StoreTo = 'county') and (dbCounty = '') then
            dbCounty := County
          else if (StoreTo = 'QTH') and (dbQTH = '') then
            dbQTH := County
          else if (StoreTo = 'award') and (dbAward = '') then
            dbAward := County
          else if (StoreTo = 'state') and (dbState = '') then
            dbState := County;
        end;
        County := dmData.FindCounty2(qth, dbDXCC, StoreTo);
        if County <> '' then
        begin
          if (StoreTo = 'county') and (dbCounty = '') then
            dbCounty := County
          else if (StoreTo = 'QTH') and (dbQTH = '') then
            dbQTH := County
          else if (StoreTo = 'award') and (dbAward = '') then
            dbAward := County
          else if (StoreTo = 'state') and (dbState = '') then
            dbState := County;
        end;
        County := dmData.FindCounty3(qth, dbDXCC, StoreTo);
        if County <> '' then
        begin
          if (StoreTo = 'county') and (dbCounty = '') then
            dbCounty := County
          else if (StoreTo = 'QTH') and (dbQTH = '') then
            dbQTH := County
          else if (StoreTo = 'award') and (dbAward = '') then
            dbAward := County
          else if (StoreTo = 'state') and (dbState = '') then
            dbState := County;
        end;
      end;
      if dbName = '' then
        dbName := stnName;
      Writeln(5);
      if (dbQSLVia = '') and (not IgnoreQRZ) then
      begin
        dbRemQSO := dmUtils.MyTrim(dbRemQSO);
        qsl_via  := dmUtils.GetQSLVia(qsl_via);
        qsl_via  := dmUtils.MyTrim(qsl_via);
        if dmUtils.IsQSLViaValid(qsl_via) then
          dbQSLVia := dmUtils.CallTrim(qsl_via)
        else
        begin
          if qsl_via <> '' then
          begin
            if MvToRem then
              if dbRemQSO = '' then
                dbRemQSO := qsl_via
              else
                dbRemQSO := dbRemQSO + ', ' + qsl_via
          end
        end
      end;

      dbName   := copy(dbName, 1, 40);
      dbQTH    := copy(dbQTH, 1, 60);
      dbQSLVia := copy(dbQSLVia, 1, 30);
      dbAward  := copy(dbAward, 1, 50);
      dbCounty := copy(dbCounty, 1, 30);
      dbState  := copy(dbState, 1, 4);
      dbRemQSO := copy(dbRemQSO, 1, 200);

      dmData.Q1.SQL.Text := 'update cqrlog_main set name=' + QuotedStr(
        dbName) + ',qth=' + QuotedStr(dbQTH) + ',qsl_via=' +
        QuotedStr(dbQSLVia) + ',county=' + QuotedStr(dbCounty) +
        ',award=' + QuotedStr(dbAward) + ',state =' +
        QuotedStr(dbState) + ',remarks=' + QuotedStr(dbRemQSO) +
        ' where id_cqrlog_main = ' + IntToStr(dbId);
      dmData.trQ1.StartTransaction;
      if dmData.DebugLevel >= 1 then
        Writeln(dmData.Q1.SQL.Text);
      dmData.Q1.ExecSQL;
      dmData.trQ1.Commit
    end
  end;

begin
  FreeOnTerminate := True;
  m    := TStringList.Create();
  HTTP := THTTPSend.Create;
  try
    HTTP.ProxyHost := cqrini.ReadString('Program', 'Proxy', '');
    HTTP.ProxyPort := cqrini.ReadString('Program', 'Port', '');
    HTTP.UserName  := cqrini.ReadString('Program', 'User', '');
    HTTP.Password  := cqrini.ReadString('Program', 'Passwd', '');
    IgnoreQRZ := cqrini.ReadBool('NewQSO', 'IgnoreQRZ', False);
    MvToRem   := cqrini.ReadBool('NewQSO', 'MvToRem', True);
    while not dmData.qCallBook.EOF do
    begin
      DoUpgrade;
      Sleep(1000);
      dmData.qCallBook.Next;
    end;
    CloseW := True;
    Synchronize(@frmDatabaseUpdate.SynCallBook)
  finally
    HTTP.Free;
    m.Free;
    running := False
  end
end;

procedure TfrmDatabaseUpdate.FormCreate(Sender: TObject);
begin
  running := False;
end;

procedure TfrmDatabaseUpdate.FormDestroy(Sender: TObject);
begin
  dmData.qCallBook.Close;
  dmData.qCallBook.SQL.Clear;
end;

procedure TfrmDatabaseUpdate.FormShow(Sender: TObject);
begin
  CloseW := False;
  CancelUpdate := False;
  dmUtils.LoadFontSettings(self);
  tmrQRZ.Enabled := True;
  // I have to do this horrible workaround because sometimes window after show
  // doesn't get focus. Why??
end;

procedure TfrmDatabaseUpdate.btnCancelClick(Sender: TObject);
begin
  CancelUpdate := True;
end;

procedure TfrmDatabaseUpdate.tmrQRZTimer(Sender: TObject);
begin
  tmrQRZ.Enabled := False;
  QRZupdate;
end;

procedure TfrmDatabaseUpdate.SynCallBook;
begin
  try
    pnlQRZ.Caption := 'Updating QSO with ' + Callbook;
    pnlQRZ.Repaint;
    if CloseW then
    begin
      btnCancel.Click;
      frmDatabaseUpdate.Close;
      running := False;
      dmData.RefreshMainDatabase();
    end
  except
    on E: Exception do
      Writeln(E.Message)
  end;
end;

procedure TfrmDatabaseUpdate.QRZupdate;
var
  QRZ:   TQRZThread;
  found: boolean = False;
begin
  if not running then
  begin
    running := True;
    CloseW  := False;
    CancelUpdate := False;
    if dmData.DebugLevel >= 1 then
      Writeln(dmData.qCallBook.SQL.Text);
    dmData.qCallBook.Open();
    dmData.qCallBook.First;
    if id_cqrlog_main > -1 then
    begin
      while not dmData.qCallBook.EOF do
      begin
        if id_cqrlog_main = dmData.qCallBook.FieldByName('id_cqrlog_main').AsInteger then
        begin
          found := True;
          break
        end;
        dmData.qCallBook.Next
      end;
      if not found then
        exit
    end;
    QRZ := TQRZThread.Create(True);
    QRZ.Resume
  end
end;

initialization
  {$I fDatabaseUpdate.lrs}

end.

