unit fCallbook;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls, Buttons, httpsend, iniFiles;

type

  { TfrmCallbook }

  TfrmCallbook = class(TForm)
    btnSearch: TButton;
    edtCall: TEdit;
    Label1: TLabel;
    mCallbook: TMemo;
    Panel1: TPanel;
    procedure FormKeyPress(Sender: TObject; var Key: char);
    procedure FormShow(Sender: TObject);
    procedure btnSearchClick(Sender: TObject);
    procedure edtCallKeyPress(Sender: TObject; var Key: char);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  frmCallbook: TfrmCallbook;

implementation

{ TfrmCallbook }

uses dUtils, dData, uMyIni;

procedure TfrmCallbook.edtCallKeyPress(Sender: TObject; var Key: char);
begin
  if key = #13 then
  begin
    btnSearch.Click;
    key := #0
  end
end;

procedure TfrmCallbook.btnSearchClick(Sender: TObject);
var
  HTTP : THTTPSend;
  tmp  : String = '';
  qsl  : String = '';
  s    : TStringList;
  c    : String = '';
  idcall : String = '';
begin
  mCallbook.Lines.Clear;
  mCallBook.Lines.Add('Working ...');
  mCallbook.Repaint;
  idcall := dmUtils.ExtractCallsign(edtCall.Text);
  Application.ProcessMessages;
  HTTP := THTTPSend.Create;
  s    := TStringList.Create;
  try
    HTTP.ProxyHost := cqrini.ReadString('Program','Proxy','');
    HTTP.ProxyPort := cqrini.ReadString('Program','Port','');
    HTTP.UserName  := cqrini.ReadString('Program','User','');
    HTTP.Password  := cqrini.ReadString('Program','Passwd','');
    HTTP.Timeout   := 2000;
    s.Clear;
    if not HTTP.HTTPMethod('GET', 'http://www.qrz.com/callsign/'+idcall) then
    begin
      Writeln('Error');
      mCallBook.Clear;
      mCallBook.Lines.Add('ERROR');
      mCallBook.Lines.Add(IntToStr(Http.Resultcode))
    end
    else begin
      s.LoadFromStream(HTTP.Document);
      qsl := '';
      tmp := s.Text;
      mCallBook.Clear;
      if Pos('produced no results',tmp) > 0 then
      begin
        mCallbook.Lines.Text := idcall + ' is not in our database'
      end
      else begin
        dmUtils.GetQRZInfo(idcall,tmp,c,tmp,tmp,tmp,qsl);
        mCallBook.Text := c;
        if qsl <> '' then
          mCallBook.Lines.Add('QSL VIA: ' + qsl)
      end
    end;
  finally
    HTTP.Free;
    s.Free
  end
end;

procedure TfrmCallbook.FormShow(Sender: TObject);
begin
  dmUtils.LoadFontSettings(frmCallbook);
  edtCall.SetFocus;
  edtCall.SelectAll;
  mCallbook.Clear
end;

procedure TfrmCallbook.FormKeyPress(Sender: TObject; var Key: char);
begin
  if key = #27 then
  begin
    key := #0;
    Close
  end;
end;

initialization
  {$I fCallbook.lrs}

end.

