// ------------------------------------------------------- 
// Copyright (C) Bradley M. Bell 2003, All rights reserved 
// ------------------------------------------------------- 
Keyword = 
[
'CppAD  cppad-20150000.1: A Package for Differentiation of C++ Algorithms  ',' algorithmic automatic derivative version syntax introduction example include file cppad.hpp preprocessor symbols namespace ',
'Install  CppAD Download, Test, and Install Instructions  ',' step 1: 2: cmake 3: check 4: ',
'download  Download The CppAD Source Code  ',' purpose distribution directory compressed archives current version release versions monthly unix file extraction windows install instructions subversion limitations stable ',
'cmake  Using CMake to Configure CppAD  ',' the program command build directory generator makefile cmake_install_prefix cmake_install_includedirs directories cmake_install_datadir cmake_install_docdir cmake_install_libdirs library cmake_install_postfix package_prefix cppad_cxx_flags c++ compile cppad_testvector cppad_max_num_threads maximum number cppad_sparse_list sparsity internal structure of sets cppad_tape_id_type memory usage cstdint cppad_tape_addr_type cppad_implicit_ctor_from_any_type explicit ',
'adolc_prefix  Including the ADOL-C Examples and Tests  ',' purpose speed unix cygwin get_adolc ',
'get_adolc.sh  Download and Install Adolc in Build Directory  ',' syntax purpose requirements distribution external prefix reuse ',
'colpack_prefix  Including the ColPack Sparsity Calculations  ',' purpose cppad_colpack.cpp example get_colpack ',
'colpack.cpp  Using ColPack: Example and Test  ',' spare ',
'get_colpack.sh  Download and Install ColPack in Build Directory  ',' syntax purpose distribution external prefix reuse ',
'eigen_prefix  Including the Eigen Examples and Tests  ',' purpose vector get_eigen ',
'get_eigen.sh  Download and Install Eigen in Build Directory  ',' syntax purpose distribution external prefix reuse ',
'fadbad_prefix  Including the FADBAD Speed Tests  ',' purpose get_fadbad ',
'get_fadbad.sh  Download and Install Fadbad in Build Directory  ',' syntax purpose distribution external prefix ',
'ipopt_prefix  Including the cppad_ipopt Library and Tests  ',' purpose examples get_ipopt ',
'get_ipopt.sh  Download and Install Ipopt in Build Directory  ',' syntax purpose distribution external prefix reuse ',
'sacado_prefix  Including the Sacado Speed Tests  ',' purpose get_sacado ',
'get_sacado.sh  Download and Install Sacado in Build Directory  ',' syntax purpose distribution external prefix reuse ',
'cppad_testvector  Choosing the CppAD Test Vector Template Class  ',' purpose boost eigen ',
'cmake_check  Checking the CppAD Examples and Tests  ',' purpose all subsets ',
'pkgconfig  CppAD pkg-config Files  ',' pc purpose usage defined fields configuration ',
'InstallUnix  Deprecated Unix Test and Installation  ',' cppad free distribution directory work configure make examples tests profiling speed profile prefix_dir --with-documentation --with-testvector std boost eigen --with-sparse_option internal sets --with-implicit_ctor explicit max_num_threads cxx_flags compile openmp_flags postfix_dir adolc_dir linux cygwin boost_dir eigen_dir fadbad_dir ipopt_dir sacado_dir tape_addr_type memory usage tape_id_type ',
'Introduction  An Introduction by Example to Algorithmic Differentiation  ',' ad automatic purpose preface forward mode reverse operation count efficiency outline reference ',
'get_started.cpp  Getting Started Using CppAD to Compute Derivatives  ',' simple example purpose function value poly exercises program output running ',
'exp_2  Second Order Exponential Approximation  ',' example algorithm syntax purpose mathematical form include type implementation test exercises ',
'exp_2.hpp  exp_2: Implementation  ',' ',
'exp_2.cpp  exp_2: Test  ',' ',
'exp_2_for0  exp_2: Operation Sequence and Zero Order Forward Mode  ',' example mathematical form expansion index code sweep return value verification exercises ',
'exp_2_for1  exp_2: First Order Forward Mode  ',' example expansion purpose mathematical form operation sequence index zero derivative sweep return value verification exercises ',
'exp_2_rev1  exp_2: First Order Reverse Mode  ',' example purpose mathematical form f_5 index 5: f_4 4: f_3 3: f_2 f_1 verification exercises ',
'exp_2_for2  exp_2: Second Order Forward Mode  ',' example expansion purpose mathematical form operation sequence index zero first derivative sweep return value verification exercises ',
'exp_2_rev2  exp_2: Second Order Reverse Mode  ',' example purpose mathematical form f_5 index 5: f_4 4: f_3 3: f_2 f_1 verification exercises ',
'exp_2_for0.cpp  exp_2: Verify Zero Order Forward Sweep  ',' ',
'exp_2_for1.cpp  exp_2: Verify First Order Forward Sweep  ',' ',
'exp_2_rev1.cpp  exp_2: Verify First Order Reverse Sweep  ',' mode ',
'exp_2_for2.cpp  exp_2: Verify Second Order Forward Sweep  ',' ',
'exp_2_rev2.cpp  exp_2: Verify Second Order Reverse Sweep  ',' mode ',
'exp_2_cppad  exp_2: CppAD Forward and Reverse Sweeps  ',' purpose exercises ',
'exp_eps  An Epsilon Accurate Exponential Approximation  ',' example algorithm syntax purpose mathematical function include type implementation test exercises ',
'exp_eps.hpp  exp_eps: Implementation  ',' ',
'exp_eps.cpp  exp_eps: Test of exp_eps  ',' ',
'exp_eps_for0  exp_eps: Operation Sequence and Zero Order Forward Sweep  ',' example mathematical form variable parameter index code return value comparisons verification exercises ',
'exp_eps_for1  exp_eps: First Order Forward Sweep  ',' expansion mathematical form operation sequence index zero derivative return value verification exercises ',
'exp_eps_rev1  exp_eps: First Order Reverse Sweep  ',' mode example purpose mathematical form epsilon f_7 index 7: f_6 6: f_5 5: f_4 4: f_3 3: f_2 2: f_1 verification exercises ',
'exp_eps_for2  exp_eps: Second Order Forward Mode  ',' example expansion purpose mathematical form operation sequence index zero first derivative sweep return value verification exercises ',
'exp_eps_rev2  exp_eps: Second Order Reverse Sweep  ',' mode example purpose mathematical form epsilon f_7 index 7: f_6 6: f_5 5: f_4 4: f_3 3: f_2 2: f_1 verification exercises ',
'exp_eps_for0.cpp  exp_eps: Verify Zero Order Forward Sweep  ',' ',
'exp_eps_for1.cpp  exp_eps: Verify First Order Forward Sweep  ',' exp_2 ',
'exp_eps_rev1.cpp  exp_eps: Verify First Order Reverse Sweep  ',' ',
'exp_eps_for2.cpp  exp_eps: Verify Second Order Forward Sweep  ',' first exp_2 ',
'exp_eps_rev2.cpp  exp_eps: Verify Second Order Reverse Sweep  ',' ',
'exp_eps_cppad  exp_eps: CppAD Forward and Reverse Sweeps  ',' purpose exercises ',
'exp_apx_main.cpp  Correctness Tests For Exponential Approximation in Introduction  ',' run running ',
'AD  AD Objects  ',' purpose base type requirements ',
'ad_ctor  AD Constructors  ',' convert base vecad syntax purpose implicit explicit deprecated example ',
'ad_ctor.cpp  AD Constructors: Example and Test  ',' object ',
'ad_assign  AD Assignment Operator  ',' base vecad syntax purpose example ',
'ad_assign.cpp  AD Assignment: Example and Test  ',' object ',
'Convert  Conversion and I/O of AD Objects  ',' from ',
'Value  Convert From an AD Type to its Base Type  ',' syntax purpose operation sequence restriction example ',
'value.cpp  Convert From AD to its Base Type: Example and Test  ',' record ',
'Integer  Convert From AD to Integer  ',' syntax purpose real types complex operation sequence example ',
'integer.cpp  Convert From AD to Integer: Example and Test  ',' ',
'ad_input  AD Output Stream Operator  ',' >> write syntax purpose is result operation sequence example ',
'ad_output  AD Output Stream Operator  ',' << write syntax purpose assumption result operation sequence example ',
'ad_input.cpp  AD Output Operator: Example and Test  ',' << ',
'ad_output.cpp  AD Output Operator: Example and Test  ',' << ',
'PrintFor  Printing AD Values During Forward Mode  ',' text output debug syntax purpose f.forward(0 x) before var after discussion alternative example ',
'print_for_cout.cpp  Printing During Forward Mode: Example and Test  ',' running source code output ',
'print_for_string.cpp  Print During Zero Order Forward Mode: Example and Test  ',' ',
'Var2Par  Convert an AD Variable to a Parameter  ',' from value_ obtain during taping syntax purpose example ',
'var2par.cpp  Convert an AD Variable to a Parameter: Example and Test  ',' value during taping ',
'ADValued  AD Valued Operations and Functions  ',' ',
'Arithmetic  AD Arithmetic Operators and Computed Assignments  ',' ',
'UnaryPlus  AD Unary Plus Operator  ',' + syntax purpose operation sequence derivative example ',
'unary_plus.cpp  AD Unary Plus Operator: Example and Test  ',' ',
'UnaryMinus  AD Unary Minus Operator  ',' - syntax purpose base operation sequence derivative example ',
'unary_minus.cpp  AD Unary Minus Operator: Example and Test  ',' ',
'ad_binary  AD Binary Arithmetic Operators  ',' + add plus - subtract minus * multiply times / divide syntax purpose base z operation sequence example derivative addition subtraction multiplication division ',
'add.cpp  AD Binary Addition: Example and Test  ',' + plus ',
'sub.cpp  AD Binary Subtraction: Example and Test  ',' - minus ',
'mul.cpp  AD Binary Multiplication: Example and Test  ',' * multiply times ',
'div.cpp  AD Binary Division: Example and Test  ',' / divide quotient ',
'compute_assign  AD Computed Assignment Operators  ',' + add plus - subtract minus * multiply times / divide syntax purpose base result multiple operation sequence example derivative addition subtraction multiplication division ',
'AddEq.cpp  AD Computed Assignment Addition: Example and Test  ',' += plus ',
'sub_eq.cpp  AD Computed Assignment Subtraction: Example and Test  ',' -= plus add ',
'mul_eq.cpp  AD Computed Assignment Multiplication: Example and Test  ',' *= multiply plus add ',
'div_eq.cpp  AD Computed Assignment Division: Example and Test  ',' /= divide plus add ',
'std_math_ad  AD Standard Math Unary Functions  ',' acos asin atan cosh exp fabs log log10 sinh sqrt tanh syntax purpose operation sequence examples derivatives ',
'Acos.cpp  The AD acos Function: Example and Test  ',' ',
'Asin.cpp  The AD asin Function: Example and Test  ',' ',
'atan.cpp  The AD atan Function: Example and Test  ',' ',
'cos.cpp  The AD cos Function: Example and Test  ',' ',
'cosh.cpp  The AD cosh Function: Example and Test  ',' ',
'exp.cpp  The AD exp Function: Example and Test  ',' ',
'log.cpp  The AD log Function: Example and Test  ',' ',
'log10.cpp  The AD log10 Function: Example and Test  ',' ',
'sin.cpp  The AD sin Function: Example and Test  ',' ',
'sinh.cpp  The AD sinh Function: Example and Test  ',' ',
'sqrt.cpp  The AD sqrt Function: Example and Test  ',' ',
'tan.cpp  The AD tan Function: Example and Test  ',' ',
'tanh.cpp  The AD tanh Function: Example and Test  ',' ',
'MathOther  Other AD Math Functions  ',' ',
'abs  AD Absolute Value Function  ',' fabs syntax purpose operation sequence complex types derivative example old ',
'abs.cpp  AD Absolute Value Function: Example and Test  ',' fabs ',
'sign  Sign Function  ',' ad syntax purpose operation sequence complex types derivative example ',
'sign.cpp  Sign Function: Example and Test  ',' ',
'atan2  AD Two Argument Inverse Tangent Function  ',' syntax purpose theta operation sequence example ',
'atan2.cpp  The AD atan2 Function: Example and Test  ',' ',
'erf  The AD Error Function  ',' syntax description operation sequence method cppad_compiler_has_erf other example ',
'erf.cpp  The AD erf Function: Example and Test  ',' ',
'pow  The AD Power Function  ',' exponent syntax see also purpose z operation sequence example ',
'pow.cpp  The AD Power Function: Example and Test  ',' ',
'limits  Numeric Limits For an AD and Base Types  ',' epsilon max min syntax purpose float example ',
'limits.cpp  Numeric Limits: Example and Test  ',' ',
'CondExp  AD Conditional Expressions  ',' assign syntax purpose rel type left right if_true if_false result optimize deprecated operation sequence example test atan2 ',
'cond_exp.cpp  Conditional Expressions: Example and Test  ',' condexp description ',
'Discrete  Discrete AD Functions  ',' syntax purpose base name ay create version cppad_discrete_function operation sequence derivatives parallel mode example deprecated cppadcreatediscrete ',
'tape_index.cpp  Taping Array Index Operation: Example and Test  ',' ',
'interp_onetape.cpp  Interpolation With Out Retaping: Example and Test  ',' interpolate retape see also ',
'interp_retape.cpp  Interpolation With Retaping: Example and Test  ',' interpolate see also ',
'atomic  Atomic AD Functions  ',' operation ',
'checkpoint  Checkpointing Functions  ',' syntax purpose method constructor base advector name ay option algo afun clear restriction example ',
'checkpoint.cpp  Simple Checkpointing: Example and Test  ',' purpose ',
'atomic_base  User Defined Atomic AD Functions  ',' operation syntax purpose virtual examples getting started scalar vector range hessian sparsity patterns general case ',
'atomic_ctor  Atomic Function Constructor  ',' syntax atomic_user ctor_arg_list afun implementation atomic_base restrictions name examples define ',
'atomic_option  Set Atomic Function Options  ',' syntax atomic_sparsity bool_sparsity_enum set_sparsity_enum ',
'atomic_afun  Using AD Version of Atomic Function  ',' use syntax purpose advector ay examples ',
'atomic_forward  Atomic Forward Mode  ',' callback virtual syntax purpose implementation q vx vy tx ty ok discussion examples define use ',
'atomic_reverse  Atomic Reverse Mode  ',' callback virtual syntax purpose implementation q tx ty f g h py px ok examples define use ',
'atomic_for_sparse_jac  Atomic Forward Jacobian Sparsity Patterns  ',' callback virtual syntax purpose implementation q ok examples define use ',
'atomic_rev_sparse_jac  Atomic Reverse Jacobian Sparsity Patterns  ',' callback virtual syntax purpose implementation q st ok examples define use ',
'atomic_rev_sparse_hes  Atomic Reverse Hessian Sparsity Patterns  ',' callback virtual syntax purpose implementation vx q examples define use ',
'atomic_base_clear  Free Static Variables  ',' syntax purpose future use restriction ',
'atomic_get_started.cpp  Getting Started with Atomic Operations: Example and Test  ',' purpose class definition constructor forward end use function recording ',
'atomic_norm_sq.cpp  Euclidean Norm Squared: Example and Test  ',' operation theory start class definition constructor forward reverse for_sparse_jac rev_sparse_jac rev_sparse_hes end use function recording ',
'atomic_reciprocal.cpp  Reciprocal as an Atomic Operation: Example and Test  ',' simple theory start class definition constructor forward reverse for_sparse_jac rev_sparse_jac rev_sparse_hes end use function recording ',
'atomic_tangent.cpp  Tan and Tanh as User Atomic Operations: Example and Test  ',' theory start class definition constructor forward reverse for_sparse_jac rev_sparse_jac rev_sparse_hes end function recording large values ',
'atomic_hes_sparse.cpp  Atomic Operation Hessian Sparsity: Example and Test  ',' purpose start class definition constructor forward for_sparse_jac rev_sparse_hes use function with x_1 both variable parameter ',
'atomic_mat_mul.cpp  User Atomic Matrix Multiply: Example and Test  ',' class definition function constructor recording forward reverse option for_sparse_jac rev_sparse_jac rev_sparse_hes ',
'atomic_matrix_mul.hpp  Matrix Multiply as an Atomic Operation  ',' start class definition constructor left operand element index right result forward multipliy reverse for_sparse_jac rev_sparse_jac rev_sparse_hes end ',
'BoolValued  Bool Valued Operations and Functions with AD Arguments  ',' ',
'Compare  AD Binary Comparison Operators  ',' < <= > >= == != syntax purpose operation sequence assumptions example ',
'compare.cpp  AD Binary Comparison Operators: Example and Test  ',' < <= > >= == != ',
'NearEqualExt  Compare AD and Base Objects for Nearly Equal  ',' with syntax purpose type operation sequence example ',
'near_equal_ext.cpp  Compare AD with Base Objects: Example and Test  ',' nearequalext ',
'BoolFun  AD Boolean Functions  ',' unary binary syntax purpose unary_name create cppad_bool_unary binary_name v cppad_bool_binary operation sequence example deprecated ',
'bool_fun.cpp  AD Boolean Functions: Example and Test  ',' ',
'ParVar  Is an AD Object a Parameter or Variable  ',' syntax purpose operation sequence example ',
'par_var.cpp  AD Parameter and Variable Functions: Example and Test  ',' ',
'EqualOpSeq  Check if Two Value are Identically Equal  ',' operation sequence syntax purpose motivation b example ',
'equal_op_seq.cpp  EqualOpSeq: Example and Test  ',' ',
'VecAD  AD Vectors that Record Index Operations  ',' tape syntax purpose alternatives vecad<base>::reference exceptions constructor size size_t indexing example speed and memory ',
'vec_ad.cpp  AD Vectors that Record Index Operations: Example and Test  ',' vecad ',
'base_require  AD<Base> Requirements for Base Type  ',' syntax warning purpose standard types include order numeric output operator integer suggestion ',
'base_member  Required Base Class Member Functions  ',' notation default constructor double copy unary operators assignment binary bool example ',
'base_cond_exp  Base Type Requirements for Conditional Expressions  ',' condexp purpose compareop condexptemplate ordered not condexprel cppad_cond_exp_rel ',
'base_identical  Base Type Requirements for Identically Equal Comparisons  ',' equalopseq the simple case more complicated cases identicalpar prototypes functions examples ',
'base_ordered  Base Type Requirements for Ordered Comparisons  ',' purpose not ',
'base_std_math  Base Type Requirements for Standard Math Functions  ',' purpose unary cppad_standard_math_unary erf sign pow isnan limits numeric numeric_limits epsilon ',
'base_example  Example AD Base Types That are not AD<OtherBase>  ',' ',
'base_alloc.hpp  Example AD<Base> Where Base Constructor Allocates Memory  ',' purpose include file computed assignment macro binary operator boolean class definition condexpop condexprel equalopseq identical output integer ordered unary standard math erf pow limits ',
'base_require.cpp  Using a User Defined AD Base Type: Example and Test  ',' purpose ',
'base_adolc.hpp  Enable use of AD<Base> where Base is Adolc\'s adouble Type  ',' syntax example include files condexpop equalopseq identical integer ordered unary standard math erf sign abs pow limits ',
'mul_level_adolc.cpp  Using Adolc with Multiple Levels of Taping: Example and Test  ',' purpose memory management configuration requirement ',
'base_float.hpp  Enable use of AD<Base> where Base is float  ',' condexpop condexprel equalopseq identical integer ordered unary standard math sign pow limits ',
'base_double.hpp  Enable use of AD<Base> where Base is double  ',' condexpop condexprel equalopseq identical integer ordered unary standard math sign pow limits ',
'base_complex.hpp  Enable use of AD<Base> where Base is std::complex<double>  ',' example include order condexpop condexprel equalopseq identical ordered erf integer isnan valid unary math invalid pow limits ',
'complex_poly.cpp  Complex Polynomial: Example and Test  ',' ',
'ADFun  ADFun Objects  ',' purpose ',
'Independent  Declare Independent Variables and Start Recording  ',' syntax purpose stop vectorad parallel mode example ',
'independent.cpp  Independent and ADFun Constructor: Example and Test  ',' ',
'FunConstruct  Construct an ADFun Object and Stop Recording  ',' tape syntax purpose vectorad default constructor sequence copy assignment operator taylor coefficients sparsity patterns parallel mode example ',
'fun_assign.cpp  ADFun Assignment: Example and Test  ',' ',
'Dependent  Stop Recording and Store Operation Sequence  ',' adfun tape syntax purpose advector taping forward parallel mode example ',
'abort_recording  Abort Recording of an Operation Sequence  ',' tape syntax purpose example ',
'abort_recording.cpp  Abort Current Recording: Example and Test  ',' ',
'seq_property  ADFun Sequence Properties  ',' syntax see also purpose domain range parameter size_var size_par size_op size_op_arg size_text size_vecad size_op_seq example ',
'seq_property.cpp  ADFun Sequence Properties: Example and Test  ',' domain range parameter size_var size_par size_op size_op_arg size_vecad ',
'FunEval  Evaluate ADFun Functions, Derivatives, and Sparsity Patterns  ',' ',
'Forward  Forward Mode  ',' ',
'forward_zero  Zero Order Forward Mode: Function Values  ',' syntax purpose x0 y0 vector example special case ',
'forward_one  First Order Forward Mode: Derivative Values  ',' syntax purpose x0 x1 vector example special case ',
'forward_two  Second Order Forward Mode: Derivative Values  ',' syntax purpose x0 x1 x2 y2 vector example special case ',
'forward_order  Multiple Order Forward Mode  ',' any syntax purpose function values derivative notation one q xq orders restrictions x(t) y(t) yq vector zero first second example ',
'forward.cpp  Forward Mode: Example and Test  ',' ',
'forward_order.cpp  Forward Mode: Example and Test of Multiple Orders  ',' ',
'forward_dir  Multiple Directions Forward Mode  ',' syntax purpose notation q xq zero order non-zero lower orders x(t) y(t) yq vector example ',
'forward_dir.cpp  Forward Mode: Example and Test of Multiple Directions  ',' orders ',
'size_order  Number Taylor Coefficient Orders Currently Stored  ',' syntax see also purpose constructor forward capacity_order example ',
'CompareChange  Comparison Changes During Zero Order Forward Mode  ',' adfun syntax purpose discussion restrictions ndebug example ',
'compare_change.cpp  CompareChange and Re-Tape: Example and Test  ',' ',
'capacity_order  Controlling Taylor Coefficients Memory Allocation  ',' forward syntax see also purpose pre-allocating freeing original state example ',
'capacity_order.cpp  Controlling Taylor Coefficient Memory Allocation: Example and Test  ',' ',
'number_skip  Number of Variables that Can be Skipped  ',' syntax see also purpose example ',
'number_skip.cpp  Number of Variables That Can be Skipped: Example and Test  ',' optimize conditional expression ',
'Reverse  Reverse Mode  ',' multiple directions ',
'reverse_one  First Order Reverse Mode  ',' derivative syntax purpose w dw vector example ',
'reverse_one.cpp  First Order Reverse Mode: Example and Test  ',' ',
'reverse_two  Second Order Reverse Mode  ',' derivative syntax purpose x^(k) f dw first partials vector hessian times direction example ',
'reverse_two.cpp  Second Order Reverse ModeExample and Test  ',' ',
'hes_times_dir.cpp  Hessian Times Direction: Example and Test  ',' ',
'reverse_any  Any Order Reverse Mode  ',' derivative syntax purpose notation u^(k) x(t u) y(t w^(k) w(u) f q dw first second vector example ',
'reverse_three.cpp  Third Order Reverse Mode: Example and Test  ',' taylor coefficients ',
'reverse_any.cpp  Reverse Mode General Case: Example and Test  ',' purpose processing steps ',
'Sparse  Calculating Sparsity Patterns  ',' ',
'ForSparseJac  Jacobian Sparsity Pattern: Forward Mode  ',' syntax purpose size_forward_bool size_forward_set q transpose false true vectorset entire example ',
'for_sparse_jac.cpp  Forward Mode Jacobian Sparsity: Example and Test  ',' forsparsejac ',
'RevSparseJac  Jacobian Sparsity Pattern: Reverse Mode  ',' syntax purpose f q transpose nz_compare false true vectorset entire example ',
'rev_sparse_jac.cpp  Reverse Mode Jacobian Sparsity: Example and Test  ',' revsparsejac ',
'RevSparseHes  Hessian Sparsity Pattern: Reverse Mode  ',' syntax purpose f q transpose false true vectorset entire example ',
'rev_sparse_hes.cpp  Reverse Mode Hessian Sparsity: Example and Test  ',' revsparsehes ',
'Drivers  First and Second Derivatives: Easy Drivers  ',' forward reverse ',
'Jacobian  Jacobian: Driver Routine  ',' first derivative syntax purpose vector forward reverse example ',
'jacobian.cpp  Jacobian: Example and Test  ',' ',
'ForOne  First Order Partial Derivative: Driver Routine  ',' easy syntax purpose j dy vector uses forward example ',
'for_one.cpp  First Order Partial Driver: Example and Test  ',' ',
'RevOne  First Order Derivative: Driver Routine  ',' easy syntax purpose dw vector uses forward example ',
'rev_one.cpp  First Order Derivative Driver: Example and Test  ',' ',
'Hessian  Hessian: Easy Driver  ',' second derivative syntax purpose f l w vector uses forward example ',
'hessian.cpp  Hessian: Example and Test  ',' ',
'hes_lagrangian.cpp  Hessian of Lagrangian and ADFun Default Constructor: Example and Test  ',' heslagrangian ',
'ForTwo  Forward Mode Second Partial Derivative Driver  ',' order easy syntax purpose j k ddy vectorbase vectorsize_t uses examples ',
'for_two.cpp  Subset of Second Order Partials: Example and Test  ',' ',
'RevTwo  Reverse Mode Second Partial Derivative Driver  ',' order easy syntax purpose f j ddw vectorbase vectorsize_t uses forward examples ',
'rev_two.cpp  Second Partials Reverse Driver: Example and Test  ',' ',
'sparse_jacobian  Sparse Jacobian: Easy Driver  ',' sparsejacobian syntax purpose f row col work color_method n_sweep vectorbase vectorset restrictions vectorsize uses forward example ',
'sparse_jacobian.cpp  Sparse Jacobian: Example and Test  ',' spare ',
'sparse_hessian  Sparse Hessian: Easy Driver  ',' sparsehessian syntax purpose f w row col work n_sweep vectorbase vectorset restrictions vectorsize uses forward example ',
'sparse_hessian.cpp  Sparse Hessian: Example and Test  ',' spare ',
'FunCheck  Check an ADFun Sequence of Operations  ',' syntax purpose g ok vector uses forward discussion example ',
'fun_check.cpp  ADFun Check and Re-Tape: Example and Test  ',' funcheck dependent ',
'optimize  Optimize an ADFun Object Tape  ',' sequence operations speed memory syntax purpose improvements testing efficiency comparison operators atomic functions rev_sparse_jac nan checking optimization ndebug example ',
'optimize.cpp  ADFun Operation Sequence Optimization: Example and Test  ',' ',
'check_for_nan  Check an ADFun Object For Nan  ',' in syntax purpose default example ',
'check_for_nan.cpp  ADFun Checking For Nan: Example and Test  ',' ',
'preprocessor  CppAD API Preprocessor Symbols  ',' cppad_ purpose documented here cppad_null pointer cppad_package_string elsewhere deprecated ',
'multi_thread  Using CppAD in a Multi-Threading Environment  ',' parallel mode execution purpose cppad_max_num_threads maximum number of parallel_setup hold_memory initialization same prohibited ',
'parallel_ad  Enable AD Calculations During Parallel Mode  ',' syntax purpose discussion checksimplevector example restriction ',
'thread_test.cpp  Run Multi-Threading Examples and Speed Tests  ',' syntax running openmp pthread bthread purpose a11c simple_ad team_example harmonic test_time max_threads mega_sum multi_newton num_zero num_sub num_sum use_ad implementations source ',
'a11c_openmp.cpp  A Simple OpenMP Example and Test  ',' a.1.1c thread purpose source code ',
'a11c_bthread.cpp  A Simple Boost Thread Example and Test  ',' a.1.1c purpose source code ',
'a11c_pthread.cpp  A Simple Parallel Pthread Example and Test  ',' openmp a.1.1c purpose source code ',
'simple_ad_openmp.cpp  A Simple OpenMP AD: Example and Test  ',' purpose source code ',
'simple_ad_bthread.cpp  A Simple Boost Threading AD: Example and Test  ',' purpose source code ',
'simple_ad_pthread.cpp  A Simple pthread AD: Example and Test  ',' purpose source code ',
'team_example.cpp  Using a Team of AD Threads: Example and Test  ',' purpose thread_team source code ',
'harmonic.cpp  Multi-Threaded Implementation of Summation of 1/i  ',' multi_thread syntax ok num_sum num_threads source ',
'harmonic_time.cpp  Timing Test of Multi-Threaded Summation of 1/i  ',' multi_thread speed syntax purpose ok time_out test_time num_threads mega_sum source ',
'harmonic_work.cpp  Multi-threading Sum of 1/i Utility Routines  ',' harmonic_setup harmonic_worker harmonic_combine syntax purpose num_sum num_threads source ',
'multi_newton.cpp  A Multi-Threaded Newton\'s Method  ',' threading multi-threading syntax purpose ok xout fun num_sub xlow xup epsilon max_itr num_threads source ',
'multi_newton_time.cpp  Timing Test of Multi-Threaded Newton Method  ',' multi_thread speed syntax purpose ok time_out test_time num_threads num_zero num_sub num_sum use_ad source ',
'multi_newton_work.cpp  Multi-threading Newton Method Utility Routines  ',' multi_newton_setup multi_newton_worker multi_newton_combine syntax purpose fun num_sub xlow xup epsilon max_itr num_threads xout source ',
'team_thread.hpp  Specifications for A Team of AD Threads  ',' syntax purpose restrictions team_create team_work team_destroy team_name ok example use implementation speed test source ',
'team_openmp.cpp  OpenMP Implementation of a Team of AD Threads  ',' ',
'team_bthread.cpp  Boost Thread Implementation of a Team of AD Threads  ',' ',
'team_pthread.cpp  Pthread Implementation of a Team of AD Threads  ',' bug in cygwin pthread_exit ',
'library  The CppAD General Purpose Library  ',' numerical c++ template error handler testing utilities concepts ',
'ErrorHandler  Replacing the CppAD Error Handler  ',' replace assert exception syntax constructor parallel mode call info known line file exp msg example ',
'error_handler.cpp  Replacing The CppAD Error Handler: Example and Test  ',' ',
'cppad_assert  CppAD Assertions During Execution  ',' error macro syntax purpose ndebug restriction known cppad_assert_known unknown cppad_assert_unknown exp msg handler ',
'NearEqual  Determine if Two Values Are Nearly Equal  ',' absolute difference relative syntax purpose type include files example exercise ',
'near_equal.cpp  NearEqual Function: Example and Test  ',' file name ',
'speed_test  Run One Speed Test and Return Results  ',' syntax purpose motivation include vector size repeat size_vec time_min rate_vec timing example ',
'SpeedTest  Run One Speed Test and Print Results  ',' syntax purpose motivation include size repeat name first last rate errors example ',
'speed_test.cpp  speed_test: Example and test  ',' ',
'speed_program.cpp  Example Use of SpeedTest  ',' running this output ',
'time_test  Determine Amount of Time to Execute a Test  ',' speed syntax purpose motivation include size repeat time_min test_size timing example ',
'elapsed_seconds  Returns Elapsed Number of Seconds  ',' time syntax purpose microsoft systems example ',
'elapsed_seconds.cpp  Elapsed Seconds: Example and Test  ',' timer ',
'time_test.cpp  time_test: Example and test  ',' ',
'NumericType  Definition of a Numeric Type  ',' requirements default constructor from integer copy assignment operators example exercise ',
'numeric_type.cpp  The NumericType: Example and Test  ',' ',
'CheckNumericType  Check NumericType Class Concept  ',' syntax purpose include parallel mode example ',
'check_numeric_type.cpp  The CheckNumericType Function: Example and Test  ',' ',
'SimpleVector  Definition of a Simple Vector  ',' class template requirements elements specified type default constructor sizing size copy and destructor assignment resize value value_type access [] using example exercise ndebug ',
'simple_vector.cpp  Simple Vector Template Class: Example and Test  ',' ',
'CheckSimpleVector  Check Simple Vector Concept  ',' syntax purpose restrictions include parallel mode example ',
'check_simple_vector.cpp  The CheckSimpleVector Function: Example and Test  ',' ',
'nan  Obtain Nan or Determine if a Value is Nan  ',' isnan hasnan syntax purpose include macros z scalar vector example ',
'nan.cpp  nan: Example and Test  ',' ',
'pow_int  The Integer Power Function  ',' exponent syntax see also purpose include z type operation sequence example ',
'pow_int.cpp  The Pow Integer Exponent: Example and Test  ',' ',
'Poly  Evaluate a Polynomial or its Derivative  ',' template syntax description include k z type operations vector sequence example source ',
'poly.cpp  Polynomial Evaluation: Example and Test  ',' ',
'poly.hpp  Source: Poly  ',' ',
'LuDetAndSolve  Compute Determinants and Solve Equations by LU Factorization  ',' matrix linear ',
'LuSolve  Compute Determinant and Solve Linear Equations  ',' syntax description include factor invert matrix storage signdet b logdet float floatvector leqzero absgeq example source ',
'lu_solve.cpp  LuSolve With Complex Arguments: Example and Test  ',' ',
'lu_solve.hpp  Source: LuSolve  ',' ',
'LuFactor  LU Factorization of A Square Matrix  ',' linear equation determinant solve syntax description include storage sign jp sizevector floatvector absgeq example source ',
'lu_factor.cpp  LuFactor: Example and Test  ',' ',
'lu_factor.hpp  Source: LuFactor  ',' ',
'LuInvert  Invert an LU Factored Equation  ',' linear syntax description include matrix storage jp example source ',
'lu_invert.cpp  LuInvert: Example and Test  ',' ',
'lu_invert.hpp  Source: LuInvert  ',' ',
'RombergOne  One DimensionalRomberg Integration  ',' integrate syntax description include f float example source code ',
'romberg_one.cpp  One Dimensional Romberg Integration: Example and Test  ',' ',
'RombergMul  Multi-dimensional Romberg Integration  ',' integrate syntax description include f float floatvector example source code ',
'Rombergmul.cpp  One Dimensional Romberg Integration: Example and Test  ',' ',
'Runge45  An Embedded 4th and 5th Order Runge-Kutta ODE Solver  ',' differential equation syntax purpose operation sequence include xf fun warning tf xi scalar fabs vector parallel mode example source code ',
'runge45_1.cpp  Runge45: Example and Test  ',' ',
'runge45_2.cpp  Runge45: Example and Test  ',' ',
'Rosen34  A 3rd and 4th Order Rosenbrock ODE Solver  ',' stiff differential equation syntax description include xf fun f_t f_x nan warning optimization tf xi scalar vector parallel mode example source code ',
'rosen_34.cpp  Rosen34: Example and Test  ',' ',
'OdeErrControl  An Error Controller for ODE Solvers  ',' differential equation syntax description include notation xf method step nan order tf xi smin smax scur eabs erel ef maxabs nstep criteria discussion scalar vector example theory source code ',
'ode_err_control.cpp  OdeErrControl: Example and Test  ',' nan ',
'ode_err_maxabs.cpp  OdeErrControl: Example and Test Using Maxabs Argument  ',' ',
'OdeGear  An Arbitrary Order Gear Method  ',' stiff differential equation syntax purpose include fun f_x warning scalar vector example source code theory gear\'s ',
'ode_gear.cpp  OdeGear: Example and Test  ',' ',
'OdeGearControl  An Error Controller for Gear\'s Ode Solvers  ',' differential equation syntax purpose include notation xf fun f_x warning m tf xi smin smax sini eabs erel ef maxabs nstep criteria discussion scalar vector example theory source code ',
'ode_gear_control.cpp  OdeGearControl: Example and Test  ',' ',
'CppAD_vector  The CppAD::vector Template Class  ',' syntax description include capacity assignment check size return reference move semantics element access [] push_back push_vector output resize clear data vectorbool memory type and parallel mode thread_alloc example exercise ',
'cppad_vector.cpp  CppAD::vector Template Class: Example and Test  ',' ',
'vector_bool.cpp  CppAD::vectorBool Class: Example and Test  ',' ',
'thread_alloc  A Fast Multi-Threading Memory Allocator  ',' allocation syntax purpose include ',
'thread_alloc.cpp  Fast Multi-Threading Memory Allocator: Example and Test  ',' openmp allocation pthread boost ',
'ta_parallel_setup  Setup thread_alloc For Use in Multi-Threading Environment  ',' num_threads in_parallel thread_num initialize syntax purpose speed restrictions example ',
'ta_num_threads  Get Number of Threads  ',' thread_alloc syntax purpose example ',
'ta_in_parallel  Is The Current Execution in Parallel Mode  ',' thread_alloc sequential syntax purpose flag example ',
'ta_thread_num  Get the Current Thread Number  ',' thread_alloc syntax purpose example ',
'ta_get_memory  Get At Least A Specified Amount of Memory  ',' thread_num thread_alloc allocate syntax purpose min_bytes cap_bytes v_ptr allocation speed alignment example ',
'ta_return_memory  Return Memory to thread_alloc  ',' available syntax purpose v_ptr ndebug example ',
'ta_free_available  Free Memory Currently Available for Quick Use by a Thread  ',' thread_alloc syntax purpose extra example ',
'ta_hold_memory  Control When Thread Alloc Retains Memory For Future Use  ',' thread_alloc syntax purpose value free_available ',
'ta_inuse  Amount of Memory a Thread is Currently Using  ',' thread_alloc syntax purpose num_bytes example ',
'ta_available  Amount of Memory Available for Quick Use by a Thread  ',' thread_alloc syntax purpose num_bytes example ',
'ta_create_array  Allocate An Array and Call Default Constructor for its Elements  ',' thread_alloc syntax purpose type size_min size_out delta alignment example ',
'ta_delete_array  Deallocate An Array and Call Destructor for its Elements  ',' thread_alloc syntax purpose type delta example ',
'ta_free_all  Free All Memory That Was Allocated for Use by thread_alloc  ',' syntax purpose ok restrictions example ',
'index_sort  Returns Indices that Sort a Vector  ',' syntax keys example ',
'index_sort.cpp  Index Sort: Example and Test  ',' ',
'BenderQuad  Computing Jacobian and Hessian of Bender\'s Reduced Objective  ',' syntax see also problem purpose fun fun.f fun.h fun.dy gx gxx bavector advector example ',
'bender_quad.cpp  BenderQuad: Example and Test  ',' ',
'opt_val_hes  Jacobian and Hessian of Optimal Values  ',' syntax see also reference purpose basevector fun fun::ad_vector fun.ell fun.s fun.sy signdet example ',
'opt_val_hes.cpp  opt_val_hes: Example and Test  ',' ',
'LuRatio  LU Factorization of A Square Matrix and Stability Calculation  ',' linear equation determinant solve syntax description include storage sign jp purpose sizevector advector example ',
'lu_ratio.cpp  LuRatio: Example and Test  ',' ',
'ipopt_solve  Use Ipopt to Solve a Nonlinear Programming Problem  ',' syntax purpose include file bvector dvector options retape sparse string numeric integer xi xl xu gl gu fg_eval advector solution status zl zu lambda obj_value example get_started ode_inverse ',
'ipopt_solve_get_started.cpp  Nonlinear Programming Using CppAD and Ipopt: Example and Test  ',' purpose configuration requirement ',
'ipopt_solve_retape.cpp  Nonlinear Programming Retaping: Example and Test  ',' purpose ',
'ipopt_solve_ode_inverse.cpp  ODE Inverse Problem Definitions: Source Code  ',' example purpose forward measurements simulation analytic solution parameter values simulated trapezoidal approximation method ',
'Example  Examples  ',' introduction running the cppad test vector template class ',
'General  General Examples  ',' realistic description ',
'ExampleUtility  Utility Routines used by CppAD Examples  ',' ',
'ListAllExamples  List of All the CppAD Examples  ',' ',
'ad_fun.cpp  Creating Your Own Interface to an ADFun Object  ',' example test ',
'ad_in_c.cpp  Example and Test Linking CppAD to Languages Other than C++  ',' algorithmic differentiation automatic ',
'conj_grad.cpp  Differentiate Conjugate Gradient Algorithm: Example and Test  ',' purpose ',
'cppad_eigen.hpp  Enable Use of Eigen Linear Algebra Package with CppAD  ',' syntax purpose example include files numtraits namespace ',
'eigen_plugin.hpp  Source Code for eigen_plugin.hpp  ',' ',
'eigen_array.cpp  Using Eigen Arrays: Example and Test  ',' ',
'eigen_det.cpp  Using Eigen To Compute Determinant: Example and Test  ',' ',
'hes_minor_det.cpp  Gradient of Determinant Using Expansion by Minors: Example and Test  ',' ',
'hes_lu_det.cpp  Gradient of Determinant Using LU Factorization: Example and Test  ',' ',
'interface2c.cpp  Interfacing to C: Example and Test  ',' difference central ',
'jac_minor_det.cpp  Gradient of Determinant Using Expansion by Minors: Example and Test  ',' ',
'jac_lu_det.cpp  Gradient of Determinant Using Lu Factorization: Example and Test  ',' ',
'mul_level  Using Multiple Levels of AD  ',' background motivation general solution procedure start adbasetape addbasetape inner function calculations derivative outer example ',
'mul_level.cpp  Multiple Tapes: Example and Test  ',' ad purpose ',
'change_const.cpp  Computing a Jacobian With Constants that Change  ',' multiple ad level purpose ',
'ode_stiff.cpp  A Stiff Ode: Example and Test  ',' ',
'mul_level_ode.cpp  Taylor\'s Ode Solver: An Example and Test  ',' purpose solution derivative of method using ad ',
'mul_level_adolc_ode.cpp  Using Adolc with Taylor\'s Ode Solver: An Example and Test  ',' purpose solution derivative of method base_adolc.hpp memory management configuration requirement ',
'ode_taylor.cpp  Taylor\'s Ode Solver: An Example and Test  ',' purpose solution forward mode ',
'stack_machine.cpp  Example Differentiating a Stack Machine Interpreter  ',' test ',
'example.cpp  CppAD Examples and Tests  ',' running ',
'speed_example.cpp  Run the Speed Examples  ',' program running tests ',
'lu_vec_ad.cpp  Lu Factor and Solve with Recorded Pivoting  ',' luvecad linear equation determinant syntax purpose storage convention matrix rhs result logdet example ',
'lu_vec_ad_ok.cpp  Lu Factor and Solve With Recorded Pivoting: Example and Test  ',' ',
'testvector  Using The CppAD Test Vector Template Class  ',' cppad_testvector syntax introduction cppad::vector std::vector boost::numeric::ublas::vector eigen vectors ',
'speed  Speed Test an Operator Overloading AD Package  ',' purpose ',
'speed_main  Running the Speed Test Program  ',' cppad syntax purpose package double profile correct seed uniform_01 option_list onetape optimize atomic memory sparsity options boolsparsity colpack correctness results sparse_jacobian link functions ',
'link_det_lu  Speed Testing Gradient of Determinant Using Lu Factorization  ',' prototype purpose method return value size repeat matrix double ',
'link_det_minor  Speed Testing Gradient of Determinant by Minor Expansion  ',' prototype purpose method return value size repeat matrix double ',
'link_mat_mul  Speed Testing Derivative of Matrix Multiply  ',' multiple prototype purpose return value repeat z dz ',
'link_ode  Speed Testing the Jacobian of Ode Solution  ',' prototype purpose method return value size repeat x double ',
'link_poly  Speed Testing Second Derivative of a Polynomial  ',' prototype purpose method return value size repeat ddp double ',
'link_sparse_hessian  Speed Testing Sparse Hessian  ',' prototype method size repeat x row col double ',
'link_sparse_jacobian  Speed Testing Sparse Jacobian  ',' prototype method size repeat row col x n_sweep double ',
'microsoft_timer  Microsoft Version of Elapsed Number of Seconds  ',' syntax purpose linking ',
'speed_utility  Speed Testing Utilities  ',' main program routines library source code ',
'det_by_lu  Determinant Using Expansion by Lu Factorization  ',' syntax inclusion constructor scalar vector example source code ',
'det_by_lu.cpp  Determinant Using Lu Factorization: Example and Test  ',' minors ',
'det_by_lu.hpp  Source: det_by_lu  ',' ',
'det_of_minor  Determinant of a Minor  ',' matrix syntax inclusion purpose scalar example source code ',
'det_of_minor.cpp  Determinant of a Minor: Example and Test  ',' ',
'det_of_minor.hpp  Source: det_of_minor  ',' ',
'det_by_minor  Determinant Using Expansion by Minors  ',' syntax inclusion constructor scalar vector example source code ',
'det_by_minor.cpp  Determinant Using Expansion by Minors: Example and Test  ',' ',
'det_by_minor.hpp  Source: det_by_minor  ',' ',
'det_33  Check Determinant of 3 by 3 matrix  ',' correct syntax purpose inclusion vector ok source code ',
'det_33.hpp  Source: det_33  ',' ',
'det_grad_33  Check Gradient of Determinant of 3 by 3 matrix  ',' correct syntax purpose inclusion vector ok source code ',
'det_grad_33.hpp  Source: det_grad_33  ',' ',
'mat_sum_sq  Sum Elements of a Matrix Times Itself  ',' multiply speed test syntax purpose inclusion z vector example source code ',
'mat_sum_sq.cpp  Sum of the Elements of the Square of a Matrix: Example and Test  ',' ',
'mat_sum_sq.hpp  Source: mat_sum_sq  ',' ',
'ode_evaluate  Evaluate a Function Defined in Terms of an ODE  ',' syntax purpose inclusion float operation sequence fabs == 0 1 fp gradient example source code ',
'ode_evaluate.cpp  ode_evaluate: Example and test  ',' ',
'ode_evaluate.hpp  Source: ode_evaluate  ',' ',
'sparse_jac_fun  Evaluate a Function That Has a Sparse Jacobian  ',' syntax purpose inclusion float floatvector m row col fp example source code ',
'sparse_jac_fun.cpp  sparse_jac_fun: Example and test  ',' ',
'sparse_jac_fun.hpp  Source: sparse_jac_fun  ',' ',
'sparse_hes_fun  Evaluate a Function That Has a Sparse Hessian  ',' syntax purpose inclusion float floatvector row col fp gradient example source code ',
'sparse_hes_fun.cpp  sparse_hes_fun: Example and test  ',' ',
'sparse_hes_fun.hpp  Source: sparse_hes_fun  ',' ',
'uniform_01  Simulate a [0,1] Uniform Random Variate  ',' [01] vector syntax purpose inclusion seed source code ',
'uniform_01.hpp  Source: uniform_01  ',' ',
'speed_double  Speed Test of Functions in Double  ',' purpose running tests ',
'double_det_minor.cpp  Double Speed: Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'double_det_lu.cpp  Double Speed: Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'double_mat_mul.cpp  CppAD Speed: Matrix Multiplication (Double Version)  ',' multiply specifications implementation link_mat_mul ',
'double_ode.cpp  Double Speed: Ode Solution  ',' link_ode specifications implementation ',
'double_poly.cpp  Double Speed: Evaluate a Polynomial  ',' link_poly specifications implementation ',
'double_sparse_hessian.cpp  Double Speed: Sparse Hessian  ',' link_sparse_hessian specifications implementation ',
'double_sparse_jacobian.cpp  Double Speed: Sparse Jacobian  ',' link_sparse_jacobian specifications implementation ',
'speed_adolc  Speed Test of Derivatives Using Adolc  ',' purpose adolc_prefix running tests ',
'adolc_det_minor.cpp  Adolc Speed: Gradient of Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'adolc_det_lu.cpp  Adolc Speed: Gradient of Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'adolc_mat_mul.cpp  Adolc Speed: Matrix Multiplication  ',' link_mat_mul multiply specifications implementation ',
'adolc_ode.cpp  Adolc Speed: Ode  ',' link_ode specifications implementation ',
'adolc_poly.cpp  Adolc Speed: Second Derivative of a Polynomial  ',' link_poly specifications implementation ',
'adolc_sparse_hessian.cpp  Adolc Speed: Sparse Hessian  ',' link_sparse_hessian specifications implementation ',
'adolc_sparse_jacobian.cpp  adolc Speed: Sparse Jacobian  ',' link_sparse_jacobian specifications implementation ',
'adolc_alloc_mat  Adolc Test Utility: Allocate and Free Memory For a Matrix  ',' syntax purpose ',
'speed_cppad  Speed Test Derivatives Using CppAD  ',' purpose running tests ',
'cppad_det_minor.cpp  CppAD Speed: Gradient of Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'cppad_det_lu.cpp  CppAD Speed: Gradient of Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'cppad_mat_mul.cpp  CppAD Speed: Matrix Multiplication  ',' link_mat_mul multiply specifications implementation ',
'cppad_ode.cpp  CppAD Speed: Gradient of Ode Solution  ',' link_ode specifications implementation ',
'cppad_poly.cpp  CppAD Speed: Second Derivative of a Polynomial  ',' link_poly specifications implementation ',
'cppad_sparse_hessian.cpp  CppAD Speed: Sparse Hessian  ',' link_sparse_hessian specifications implementation ',
'cppad_sparse_jacobian.cpp  CppAD Speed: Sparse Jacobian  ',' link_sparse_jacobian specifications implementation ',
'speed_fadbad  Speed Test Derivatives Using Fadbad  ',' purpose fadbad_prefix running tests ',
'fadbad_det_minor.cpp  Fadbad Speed: Gradient of Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'fadbad_det_lu.cpp  Fadbad Speed: Gradient of Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'fadbad_mat_mul.cpp  Fadbad Speed: Matrix Multiplication  ',' link_mat_mul multiply specifications implementation ',
'fadbad_ode.cpp  Fadbad Speed: Ode  ',' link_ode specifications implementation ',
'fadbad_poly.cpp  Fadbad Speed: Second Derivative of a Polynomial  ',' link_poly specifications implementation ',
'fadbad_sparse_hessian.cpp  Fadbad Speed: Sparse Hessian  ',' ',
'fadbad_sparse_jacobian.cpp  fadbad Speed: sparse_jacobian  ',' ',
'speed_sacado  Speed Test Derivatives Using Sacado  ',' purpose sacado_prefix running tests ',
'sacado_det_minor.cpp  Sacado Speed: Gradient of Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'sacado_det_lu.cpp  Sacado Speed: Gradient of Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'sacado_mat_mul.cpp  Sacado Speed: Matrix Multiplication  ',' link_mat_mul multiply specifications implementation ',
'sacado_ode.cpp  Sacado Speed: Gradient of Ode Solution  ',' link_ode specifications implementation ',
'sacado_poly.cpp  Sacado Speed: Second Derivative of a Polynomial  ',' link_poly specifications implementation ',
'sacado_sparse_hessian.cpp  Sacado Speed: Sparse Hessian  ',' ',
'sacado_sparse_jacobian.cpp  sacado Speed: sparse_jacobian  ',' ',
'Appendix  Appendix  ',' ',
'Faq  Frequently Asked Questions and Answers  ',' assignment independent operator bugs reporting comparechange ndebug complex types exceptions test errorhandler variables tape avoid record speed taping math functions matrix inverse mode: forward reverse namespace vector preprocessor symbol cppad_testvector symbols using standard optimize memory allocation storage: disk ',
'Theory  The Theory of Derivative Calculations  ',' ',
'ForwardTheory  The Theory of Forward Mode  ',' taylor notation binary operators addition subtraction multiplication division standard math functions differential equation coefficients recursion formula cases that apply above special ',
'ExpForward  Exponential Function Forward Taylor Polynomial Theory  ',' ',
'LogForward  Logarithm Function Forward Taylor Polynomial Theory  ',' ',
'SqrtForward  Square Root Function Forward Taylor Polynomial Theory  ',' ',
'SinCosForward  Trigonometric and Hyperbolic Sine and Cosine Forward Theory  ',' sinh cosh differential equation ',
'AtanForward  Arctangent Function Forward Taylor Polynomial Theory  ',' ',
'AsinForward  Arcsine Function Forward Taylor Polynomial Theory  ',' ',
'AcosForward  Arccosine Function Forward Taylor Polynomial Theory  ',' ',
'tan_forward  Tangent and Hyperbolic Tangent Forward Taylor Polynomial Theory  ',' derivatives coefficients recursion ',
'erf_forward  Error Function Forward Taylor Polynomial Theory  ',' derivatives coefficients recursion ',
'ReverseTheory  The Theory of Reverse Mode  ',' taylor notation binary operators addition subtraction multiplication division standard math functions ',
'ExpReverse  Exponential Function Reverse Mode Theory  ',' ',
'LogReverse  Logarithm Function Reverse Mode Theory  ',' ',
'SqrtReverse  Square Root Function Reverse Mode Theory  ',' ',
'SinCosReverse  Trigonometric and Hyperbolic Sine and Cosine Reverse Theory  ',' sinh cosh ',
'AtanReverse  Arctangent Function Reverse Mode Theory  ',' ',
'AsinReverse  Arcsine Function Reverse Mode Theory  ',' ',
'AcosReverse  Arccosine Function Reverse Mode Theory  ',' ',
'tan_reverse  Tangent and Hyperbolic Tangent Reverse Mode Theory  ',' notation eliminating y(t) positive orders z(t) zero ',
'erf_reverse  Error Function Reverse Mode Theory  ',' notation positive orders z(t) zero ',
'reverse_identity  An Important Reverse Mode Identity  ',' notation sweep theorem proof ',
'glossary  Glossary  ',' ad function of base levels above type elementary vector operation atomic sequence dependent independent parameter sparsity pattern efficient boolean sets tape active inactive variable variables taylor coefficient ',
'Bib  Bibliography  ',' abramowitz and stegun the c++ programming language evaluating derivatives numerical recipes shampine l.f. ',
'Bugs  Know Bugs and Problems Using CppAD  ',' gcc 3.4.4 -o2 example adolc ',
'WishList  The CppAD Wish List  ',' new features adolc atan2 benderquad checkpointing conditional expressions nesting sparsity forward mode recomputation iterator interface library compile speed ad<double> multiple directions numeric limits testing machine epsilon operation sequence optimization optimize tape hashing variable pairs preprocessor symbols software guidelines boost tracing ',
'whats_new  Changes and Additions to CppAD  ',' introduction this year previous years ',
'whats_new_14  CppAD Changes and Additions During 2014  ',' introduction 12-30 12-29 12-28 12-27 12-26 12-25 12-23 12-22 12-17 12-16 12-15 11-28 11-27 09-28 09-27 09-25 09-21 05-28 05-27 05-23 05-22 05-20 05-19 05-16 05-14 03-18 03-17 03-09 03-05 03-02 03-01 02-28 02-27 02-26 02-23 02-22 02-17 02-15 01-26 01-21 01-10 ',
'whats_new_13  CppAD Changes and Additions During 2013  ',' introduction 12-29 12-27 12-26 12-24 11-27 11-13 11-12 10-29 10-23 10-22 10-16 10-15 10-14 10-13 10-12 09-20 09-19 09-18 09-07 08-12 08-11 08-06 07-26 05-28 05-21 05-17 05-15 05-14 05-12 05-11 05-04 04-28 04-27 04-26 ',
'whats_new_12  CppAD Changes and Additions During 2012  ',' introduction 12-30 12-29 12-28 12-27 12-26 12-23 12-22 12-20 12-19 12-17 12-15 12-14 12-13 11-28 11-21 11-20 11-17 11-16 11-14 11-09 11-06 11-04 10-31 10-30 10-25 10-24 10-12 10-04 10-03 10-02 09-24 09-11 08-05 07-30 07-08 07-07 07-05 07-04 07-03 07-02 07-01 06-17 06-16 06-15 06-12 06-10 06-09 06-08 06-07 06-05 06-04 06-03 06-02 06-01 05-31 05-30 05-29 05-27 05-24 04-19 04-18 04-17 04-10 04-06 04-05 04-01 03-27 03-26 03-23 03-21 03-17 03-11 03-03 03-02 02-11 02-10 02-09 01-30 01-27 01-24 01-23 01-20 01-19 01-16 01-15 01-12 01-07 01-02 ',
'whats_new_11  Changes and Additions to CppAD During 2011  ',' introduction 12-30 12-28 12-21 12-20 11-29 11-27 11-24 11-21 11-20 11-18 11-17 11-09 11-07 11-06 11-04 11-01 10-30 10-29 10-14 10-12 09-06 09-05 09-02 09-01 08-31 08-30 08-25 08-23 08-21 08-11 08-10 08-09 08-08 08-07 08-06 08-04 08-03 08-02 07-31 07-29 07-28 07-27 07-25 07-18 07-17 07-14 07-13 07-11 openmp/run.sh 07-10 07-09 07-07 06-23 06-21 06-18 05-29 05-28 05-26 05-22 05-11 05-03 04-29 04-20 04-19 03-19 03-11 03-05 02-22 02-19 02-17 02-15 02-09 02-06 02-02 02-01 01-19 01-16 01-09 ',
'whats_new_10  Changes and Additions to CppAD During 2010  ',' introduction 12-31 11-27 09-26 09-22 08-21 07-14 07-11 06-01 04-28 04-26 04-24 04-01 03-11 03-10 03-09 03-03 02-11 02-08 02-06 02-05 02-03 01-26 01-24 01-23 01-20 01-18 01-04 ',
'whats_new_09  Changes and Additions to CppAD During 2009  ',' introduction 12-23 12-22 12-18 12-12 12-04 12-02 11-28 11-27 11-26 10-30 10-29 10-28 10-27 10-24 10-23 10-21 10-16 10-14 10-03 09-30 09-29 09-28 09-26 09-20 09-19 09-18 08-25 08-14 08_13 08-13 08-11 08-10 08-09 08-06 08-02 08-01 07-31 07-26 07-25 07-24 07-23 07-06 07-04 07-03 07-02 07-01 06-30 06-29 06-28 06-25 06-22 06-21 06-20 06-06 05-20 03-24 02-20 02-15 02-01 01-31 01-18 01-06 ',
'whats_new_08  Changes and Additions to CppAD During 2008  ',' introduction 12-19 12-14 12-04 11-22 11-21 11-20 erf 10-27 10-17 10-16 09-30 09-26 09-18 09-17 09-16 09-12 09-10 09-09 09-07 09-06 09-05 09-04 09-03 09-01 08-29 ipopt_cppad_nlp 08-19 08-08 07-02 06-18 06-15 06-11 06-10 05-08 05-03 04-20 04-18 04-10 04-06 04-04 03-27 02-05 02-03 01-26 01-24 01-21 01-20 01-11 01-08 ',
'whats_new_07  Changes and Additions to CppAD During 2007  ',' introduction 12-29 12-25 12-21 12-08 12-05 12-04 12-03 12-02 11-29 11-23 11-18 11-06 11-05 11-04 11-03 11-02 11-01 10-30 10-27 10-23 10-22 10-16 10-13 10-05 10-02 09-06 08-09 08-07 07-30 07-29 07-28 07-26 07-25 07-23 07-22 07-21 07-20 07-19 07-18 07-14 07-13 06-22 06-20 06-14 05-26 05-25 05-24 05-22 05-08 05-05 04-19 04-17 04-14 04-11 04-10 04-07 04-06 04-05 03-31 03-30 03-29 03-20 03-15 03-14 03-13 03-09 03-28 02-27 02-22 02-17 02-16 02-15 02-06 02-04 02-03 02-02 02-01 01-29 ',
'whats_new_06  Changes and Additions to CppAD During 2006  ',' introduction 12-24 12-23 12-22 12-21 12-19 12-18 12-17 12-15 12-13 12-12 12-11 12-10 12-09 12-07 12-05 12-03 12-02 12-01 11-30 11-29 11-28 11-23 11-18 11-12 11-08 11-06 11-05 11-04 11-02 11-01 10-31 10-29 10-28 10-27 10-26 10-25 10-18 10-16 10-10 09-30 08-17 07-14 07-12 06-29 06-22 06-19 06-17 06-18 06-15 06-09 06-07 06-05 06-02 05-31 05-29 05-27 05-03 04-29 04-28 04-26 04-25 04-19 04-18 04-17 04-15 04-14 04-13 04-08 04-06 04-05 04-04 04-03 04-02 04-01 03-31 03-30 03-29 03-28 03-27 03-26 03-24 03-23 03-22 03-18 03-17 03-16 03-15 03-11 03-10 03-09 03-07 03-05 02-28 02-25 02-24 02-23 02-21 02-15 02-14 02-13 02-11 02-10 02-04 01-20 01-18 01-08 aclocal 01-07 01-02 01-05 ',
'whats_new_05  Changes and Additions to CppAD During 2005  ',' 12-24 12-23 12-22 12-20 12-19 12-16 12-15 12-14 12-11 12-08 12-07 12-06 12-05 12-03 12-02 12-01 11-23 11-22 11-20 11-19 11-15 11-12 11-09 11-07 11-06 11-01 10-20 10-18 10-14 10-12 10-06 09-29 09-27 09-24 09-20 09-14 09-09 09-07 08-30 08-24 08-20 08-19 08-15 08-14 08-13 08-07 07-21 07-19 07-15 07-11 07-08 07-05 07-04 07-03 07-02 07-01 06-25 06-24 06-18 06-14 06-13 06-06 05-19 05-18 05-16 05-12 05-06 05-01 04-21 04-20 04-19 03-26 03-23 03-22 03-09 03-04 03-01 02-24 01-08 ',
'whats_new_04  Changes and Additions to CppAD During 2004  ',' introduction 12-11 12-09 12-03 11-17 11-16 11-15 11-14 11-13 11-12 11-10 11-04 11-02 11-01 10-29 10-28 10-27 10-21 10-19 10-16 10-06 09-29 09-26 09-23 09-21 09-13 09-10 09-09 09-07 09-04 09-02 08-27 08-25 08-24 08-12 07-31 07-08 07-07 07-03 07-02 06-29 06-25 06-12 06-04 06-03 06-01 05-30 05-29 05-26 05-25 05-14 05-12 05-09 05-07 05-04 05-03 04-29 04-28 04-25 04-24 04-22 04-21 04-20 04-19 04-09 04-08 04-07 04-03 04-02 04-01 03-30 03-28 03-25 03-18 03-17 03-15 03-12 03-11 03-09 03-07 03-06 03-05 03-04 03-03 03-01 02-29 02-28 02-21 02-20 02-17 02-16 02-15 02-12 02-01 01-29 01-28 01-22 ',
'whats_new_03  Changes and Additions to CppAD During 2003  ',' introduction 12-24 12-22 12-14 12-13 12-12 12-10 12-05 12-01 11-21 11-20 11-16 11-15 11-14 11-12 11-11 11-06 11-04 11-02 10-21 10-16 10-14 10-10 10-06 10-05 09-30 09-20 09-19 09-18 09-15 09-14 09-13 09-06 09-05 09-04 09-03 08-23 08-22 08-19 08-17 08-16 08-11 08-10 08-07 08-06 08-05 08-04 08-03 08-01 07-30 07-29 07-26 07-22 07-20 07-18 07-16 07-14 ',
'deprecated  CppAD Deprecated API Features  ',' ',
'include_deprecated  Deprecated Include Files  ',' purpose linking new to commands ',
'FunDeprecated  ADFun Object Deprecated Member Functions  ',' syntax purpose dependent order memory size taylor_size use_vecad size_taylor capacity_taylor ',
'omp_max_thread  OpenMP Parallel Setup  ',' deprecated depreciated syntax purpose number independent restriction ',
'TrackNewDel  Routines That Track Use of New and Delete  ',' memory deprecated syntax purpose include file line oldptr newlen head newptr ncopy tracknewvec ndebug macro cppad_track_new_vec previously cppadtracknewvec trackdelvec cppad_track_del_vec cppadtrackdelvec trackextend cppad_track_extend cppadtrackextend trackcount cppad_track_count multi-threading example ',
'TrackNewDel.cpp  Tracking Use of New and Delete: Example and Test  ',' ',
'omp_alloc  A Quick OpenMP Memory Allocator Used by CppAD  ',' multi-threading allocation syntax purpose include ',
'omp_max_num_threads  Set and Get Maximum Number of Threads for omp_alloc Allocator  ',' deprecated set_max_num_threads get_max_num_threads syntax purpose restrictions ',
'omp_in_parallel  Is The Current Execution in OpenMP Parallel Mode  ',' deprecated omp_alloc syntax purpose flag example ',
'omp_get_thread_num  Get the Current OpenMP Thread Number  ',' deprecated omp_alloc syntax purpose example ',
'omp_get_memory  Get At Least A Specified Amount of Memory  ',' deprecated get_thread_num omp_alloc syntax purpose min_bytes cap_bytes v_ptr allocation speed example ',
'omp_return_memory  Return Memory to omp_alloc  ',' deprecated syntax purpose v_ptr thread ndebug example ',
'omp_free_available  Free Memory Currently Available for Quick Use by a Thread  ',' deprecated omp_alloc syntax purpose example ',
'omp_inuse  Amount of Memory a Thread is Currently Using  ',' deprecated omp_alloc syntax purpose num_bytes example ',
'omp_available  Amount of Memory Available for Quick Use by a Thread  ',' deprecated omp_alloc syntax purpose num_bytes example ',
'omp_create_array  Allocate Memory and Create A Raw Array  ',' deprecated omp_alloc syntax purpose type size_min size_out delta example ',
'omp_delete_array  Return A Raw Array to The Available Memory for a Thread  ',' deprecated omp_alloc syntax purpose type delta example ',
'omp_efficient  Check If A Memory Allocation is Efficient for Another Use  ',' removed omp_alloc syntax purpose v_ptr num_bytes flag thread ndebug ',
'old_max_num_threads  Set Maximum Number of Threads for omp_alloc Allocator  ',' removed syntax purpose restrictions ',
'omp_alloc.cpp  OpenMP Memory Allocator: Example and Test  ',' allocation multi-thread deprecated ',
'memory_leak  Memory Leak Detection  ',' check static deprecated syntax purpose thread add_static flag inuse available track_count error message ',
'epsilon  Machine Epsilon For AD Types  ',' deprecated syntax purpose float ',
'test_vector  Choosing The Vector Testing Template Class  ',' cppad_test_vector deprecated syntax introduction ms windows cppad::vector std::vector boost::numeric::ublas::vector cppadvector ',
'cppad_ipopt_nlp  Nonlinear Programming Using the CppAD Interface to Ipopt  ',' deprecated syntax purpose namespace ipopt_library_paths fg(x) index vector projection injection representation simple sizevector numbervector adnumber advector x_i x_l x_u g_l g_u fg_info fg_info.number_functions fg_info.eval_r fg_info.retape fg_info.domain_size fg_info.range_size fg_info.number_terms fg_info.index solution status z_l z_u lambda obj_value example wish list ',
'ipopt_nlp_get_started.cpp  Nonlinear Programming Using CppAD and Ipopt: Example and Test  ',' purpose configuration requirement ',
'ipopt_nlp_ode  Example Simultaneous Solution of Forward and Inverse Problem  ',' ',
'ipopt_nlp_ode_problem  An ODE Inverse Problem Example  ',' notation forward measurements simulation analytic solution parameter values simulated trapezoidal approximation time grid black box method two levels of iteration derivatives simultaneous source ',
'ipopt_nlp_ode_simple  ODE Fitting Using Simple Representation  ',' cppad_ipopt_nlp purpose argument vector objective function initial condition constraint trapezoidal approximation source ',
'ipopt_nlp_ode_fast  ODE Fitting Using Fast Representation  ',' cppad_ipopt_nlp purpose objective function range indices i(k0) domain j(k0) initial condition trapezoidal approximation source ',
'ipopt_nlp_ode_problem.hpp  ODE Inverse Problem Definitions: Source Code  ',' example ',
'ipopt_nlp_ode_simple.hpp  ODE Fitting Using Simple Representation  ',' cppad_ipopt_nlp example source ',
'ipopt_nlp_ode_fast.hpp  ODE Fitting Using Fast Representation  ',' cppad_ipopt_nlp example source ',
'ipopt_nlp_ode_run.hpp  Driver for Running the Ipopt ODE Example  ',' ',
'ipopt_nlp_ode_check.cpp  Correctness Check for Both Simple and Fast Representations  ',' ',
'ipopt_ode_speed.cpp  Speed Test for Both Simple and Fast Representations  ',' ',
'old_atomic  User Defined Atomic AD Functions  ',' cppad_user_atomic operation syntax callback routines free static memory purpose partial implementation tvector base ok id tx ty forward reverse afun ay parallel mode usage vx vy py px for_jac_sparse q rev_jac_sparse rev_hes_sparse clear restriction example simple tangent matrix multiplication ',
'old_reciprocal.cpp  Old Atomic Operation Reciprocal: Example and Test  ',' user deprecated theory ',
'old_usead_1.cpp  Using AD to Compute Atomic Function Derivatives  ',' inside user checkpoint deprecated purpose simple case ',
'old_usead_2.cpp  Using AD to Compute Atomic Function Derivatives  ',' inside user checkpoint deprecated purpose ',
'old_tan.cpp  Tan and Tanh as User Atomic Operations: Example and Test  ',' old_atomic deprecated theory ',
'old_mat_mul.cpp  Matrix Multiply as a User Atomic Operation: Example and Test  ',' old_atomic deprecated include file ',
'old_mat_mul.hpp  Define Matrix Multiply as a User Atomic Operation  ',' old_atomic test example syntax begin source extra call information indexing one reverse partials order set union cppad callback functions declare ',
'compare_c  Compare Speed of C and C++  ',' with syntax purpose ',
'det_of_minor_c  Determinant of a Minor  ',' syntax purpose source code ',
'det_by_minor_c  Compute Determinant using Expansion by Minors  ',' syntax purpose source code ',
'uniform_01_c  Simulate a [0,1] Uniform Random Variate  ',' [01] syntax purpose seed source code ',
'correct_det_by_minor_c  Correctness Test of det_by_minor Routine  ',' syntax flag source code ',
'repeat_det_by_minor_c  Repeat det_by_minor Routine A Specified Number of Times  ',' syntax size source code ',
'elapsed_seconds_c  Returns Elapsed Number of Seconds  ',' syntax purpose source code ',
'time_det_by_minor_c  Determine Amount of Time to Execute det_by_minor  ',' syntax purpose time_min source code ',
'main_compare_c  Main Program For Comparing C and C++ Speed  ',' source code ',
'License  Your License for the CppAD Software  ',' '
]

var MaxList = 100;
var Nstring = -1;
var Nkeyword = Keyword.length / 2;
Initialize();

function Initialize()
{
	UpdateList();
	document.search.keywords.focus();
}
function UpdateList(event)
{
	key = 0;
	if( window.event )
		key = window.event.keyCode;
	else if( event )
		key = event.which;
	if( key == 13 )
	{	Goto();
		return;
	}
	var string  = document.search.keywords.value;
	if( Nstring == string.length )
		return;
	Nstring     = string.length;

	var word    = string.match(/\S+/g);
	var nword   = 0;
	if(word != null )
		nword   = word.length;

	var pattern = new Array(nword);
	for(var j = 0; j < nword; j++)
		pattern[j] = new RegExp(word[j], 'i');

	var nlist = 0;
	var list  = '';
	for(i = 0; (i < Nkeyword) && (nlist < MaxList) ; i++)
	{
		var match = true;
		for(j = 0; j < nword; j++)
		{	var flag = pattern[j].test(Keyword[2*i]);
			flag     = flag || pattern[j].test(Keyword[2*i+1]);
			match    = match && flag;
		}

		if( match )
		{
			line  = Keyword[2*i].split(/\s+/);
			line  = line.join(' ');
			list  = list + line + '\n';
			nlist = nlist + 1;
		}
	}
	document.search.list.value    = list;
}
function Choose(textarea)
{	var start_select = textarea.value.substring(0, textarea.selectionStart);
	var start_pos    = Math.max(0, start_select.lastIndexOf('\n') );
	var length       = textarea.value.length;
	var end_select   = 
		textarea.value.substring(textarea.selectionEnd, length);
	var end_pos      = end_select.indexOf('\n');
	if( end_pos >= 0 ) 
	{	end_pos = textarea.selectionEnd + end_pos;
	} else 
	{	end_pos = length;
	}
	// highlight the selected line
	textarea.selectionStart = start_pos;
	textarea.selectionEnd   = end_pos;
	// get the choice from the beginning of the line
	var line = textarea.value.substring(start_pos, length);
	var end_choice = line.indexOf(' ');
	if( end_choice >= 0 )
	{	var choice = line.substring(0, end_choice);
		document.search.choice.value = choice.toLowerCase();
	}
	
	return true;
}
function Goto()
{
parent.location = document.search.choice.value + '.xml';
}
