/* $Id: cpl_io_fits-test.c,v 1.2 2011/11/25 14:09:21 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2008 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: llundin $
 * $Date: 2011/11/25 14:09:21 $
 * $Revision: 1.2 $
 * $Name: cpl-6_0 $
 */

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "cpl_io_fits.h"

#include "cpl_test.h"

#include "cpl_fits.h"

/*-----------------------------------------------------------------------------
                                  Defines
 -----------------------------------------------------------------------------*/

#ifndef NEXT
#define NEXT 12
#endif

#define FILENAME "cpl_io_fits_test.fits"

/*-----------------------------------------------------------------------------
                                  Private functions
 -----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
                                  Main
 -----------------------------------------------------------------------------*/
int main(void)
{
    cpl_error_code error;
    cpl_boolean    do_bench;
    FILE         * stream;
    cpl_image    * image;
    int            i;


    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);

    do_bench = cpl_msg_get_level() <= CPL_MSG_INFO ? CPL_TRUE : CPL_FALSE;

    stream = cpl_msg_get_level() > CPL_MSG_INFO
        ? fopen("/dev/null", "a") : stdout;

    /* Insert tests below */

    cpl_test_nonnull( stream );

    image = cpl_image_new(1, 1, CPL_TYPE_INT);

    error = cpl_image_save(image, FILENAME, CPL_TYPE_INT, NULL,
                           CPL_IO_CREATE);
    cpl_test_eq_error(error, CPL_ERROR_NONE);

    for (i = 0; i < NEXT; i++) {
        error = cpl_image_add_scalar(image, 1.0);
        cpl_test_eq_error(error, CPL_ERROR_NONE);
        error = cpl_image_save(image, FILENAME, CPL_TYPE_INT, NULL,
                               CPL_IO_EXTEND);
        cpl_test_eq_error(error, CPL_ERROR_NONE);
    }

    cpl_test_eq(cpl_fits_count_extensions(FILENAME), NEXT);

    for (i = 0; i < NEXT; i++) {
        int is_bad;

        cpl_image_delete(image);
        image = cpl_image_load(FILENAME, CPL_TYPE_INT, 0, i);
        cpl_test_error(CPL_ERROR_NONE);
        cpl_test_nonnull(image);
        cpl_test_eq(cpl_image_get(image, 1, 1, &is_bad), i);
    }

    cpl_image_delete(image);
    image = cpl_image_new(1, 1, CPL_TYPE_INT);

    error = cpl_image_save(image, FILENAME, CPL_TYPE_INT, NULL,
                           CPL_IO_CREATE);
    cpl_test_eq_error(error, CPL_ERROR_NONE);

    for (i = 0; i < NEXT; i++) {
        error = cpl_image_add_scalar(image, 1.0);
        cpl_test_eq_error(error, CPL_ERROR_NONE);
        error = cpl_image_save(image, FILENAME, CPL_TYPE_INT, NULL,
                               CPL_IO_EXTEND);
        cpl_test_eq_error(error, CPL_ERROR_NONE);
    }

    cpl_test_eq(cpl_fits_count_extensions(FILENAME), NEXT);

    for (i = 0; i < NEXT; i++) {
        int is_bad;

        cpl_image_delete(image);
        image = cpl_image_load(FILENAME, CPL_TYPE_INT, 0, i);
        cpl_test_error(CPL_ERROR_NONE);
        cpl_test_nonnull(image);
        cpl_test_eq(cpl_image_get(image, 1, 1, &is_bad), i);
    }

    cpl_image_delete(image);

    if (stream != stdout) cpl_test_zero( fclose(stream) );

    /* End of tests */
    return cpl_test_end(0);
}
