/* $Id: cpl_io_fits.h,v 1.7 2012/01/10 09:47:19 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2008 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: llundin $
 * $Date: 2012/01/10 09:47:19 $
 * $Revision: 1.7 $
 * $Name: cpl-6_0 $
 */

#ifndef CPL_IO_FITS_H
#define CPL_IO_FITS_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl_macros.h>

#include <cpl_type.h>
#include <cpl_error.h>

#include <fitsio.h>

CPL_BEGIN_DECLS

/*-----------------------------------------------------------------------------
                               Defines
 -----------------------------------------------------------------------------*/

#ifndef CPL_IO_FITS_MAX_OPEN
/* May be set to zero to disable the caching of file handles */
/* Default value set to 0, to use this module define it to a positive
   number, e.g. the output of ulimit -n (1024). */
#define CPL_IO_FITS_MAX_OPEN 1024
#endif

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

void cpl_io_fits_init(cpl_boolean);
cpl_error_code cpl_io_fits_end(void);

cpl_boolean cpl_io_fits_is_enabled(void);

int cpl_io_fits_create_file(fitsfile **, const char *, int *) CPL_ATTR_NONNULL;

int cpl_io_fits_open_diskfile(fitsfile **, const char *, int, int *)
    CPL_ATTR_NONNULL;

int cpl_io_fits_close_file(fitsfile *, int *) CPL_ATTR_NONNULL;

int cpl_io_fits_close_all(int *) CPL_ATTR_NONNULL;

CPL_END_DECLS

#endif 
