/* $Id: cpl_image_bpm.h,v 1.19 2011/07/19 14:37:27 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2008 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: llundin $
 * $Date: 2011/07/19 14:37:27 $
 * $Revision: 1.19 $
 * $Name: cpl-6_0 $
 */

#ifndef CPL_IMAGE_BPM_H
#define CPL_IMAGE_BPM_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "cpl_image.h"
#include "cpl_bivector.h"
#include "cpl_mask.h"

CPL_BEGIN_DECLS

/*-----------------------------------------------------------------------------
                            Function prototypes
 -----------------------------------------------------------------------------*/

/* Info on the bad pixels */
cpl_size cpl_image_count_rejected(const cpl_image *);
int cpl_image_is_rejected(const cpl_image *, cpl_size, cpl_size);

/* To modify an image's bad pixel map */
cpl_error_code cpl_image_reject(cpl_image *, cpl_size, cpl_size);
cpl_error_code cpl_image_accept(cpl_image *, cpl_size, cpl_size);
cpl_error_code cpl_image_accept_all(cpl_image *);
cpl_error_code cpl_image_reject_from_mask(cpl_image *, const cpl_mask *);

CPL_END_DECLS

#endif 
