# CPL_CHECK_CFITSIO
#------------------
# Checks for the cfitsio library and header files.
AC_DEFUN([CPL_CHECK_CFITSIO],
[
    AC_MSG_CHECKING([for cfitsio])

    cpl_cfitsio_check_header="fitsio.h"
    # FIXME: Check first for the dynamic library...
    cpl_cfitsio_check_lib="libcfitsio.a"

    cpl_cfitsio_dir=""
    cpl_cfitsio_incdirs=""
    cpl_cfitsio_libdirs=""
    cpl_cfitsio_includes=""
    cpl_cfitsio_libraries=""

    # Get the CFITSIO directory from the --with-cfitsio CLI option, or
    # else fall back on the environment variable $CFITSIODIR
    AC_ARG_WITH(cfitsio,
                AC_HELP_STRING([--with-cfitsio],
                               [location where cfitsio is installed]),
                [
                    cpl_cfitsio_dir=$withval
                ],
                [
                    cpl_cfitsio_dir=$CFITSIODIR
                ])

    # Check for the cfitsio includes, either in include/, include/cfitsio/
    # or include/libcfitsio0/
    cpl_cfitsio_incdirs="$cpl_cfitsio_dir/include"
    ESO_FIND_FILE($cpl_cfitsio_check_header, $cpl_cfitsio_incdirs, cpl_cfitsio_includes)
    if test x"$cpl_cfitsio_includes" = xno; then
      # include/cfitsio/ is seen on a 64-bit Fedora 10
      cpl_cfitsio_incdirs="$cpl_cfitsio_dir/include/cfitsio"
      ESO_FIND_FILE($cpl_cfitsio_check_header, $cpl_cfitsio_incdirs, cpl_cfitsio_includes)
      if test x"$cpl_cfitsio_includes" = xno; then
        # include/libcfitsio0/ is seen on a 64-bit Suse
        cpl_cfitsio_incdirs="$cpl_cfitsio_dir/include/libcfitsio0"
        ESO_FIND_FILE($cpl_cfitsio_check_header, $cpl_cfitsio_incdirs, cpl_cfitsio_includes)
      fi
    fi

    # Check for the cfitsio library, either in lib64/, lib32/ or lib/
    cpl_cfitsio_libdirs="$cpl_cfitsio_dir/lib64"
    ESO_FIND_FILE($cpl_cfitsio_check_lib, $cpl_cfitsio_libdirs, cpl_cfitsio_libraries)

    if test x"$cpl_cfitsio_libraries" = xno; then
      cpl_cfitsio_libdirs="$cpl_cfitsio_dir/lib32"
      ESO_FIND_FILE($cpl_cfitsio_check_lib, $cpl_cfitsio_libdirs, cpl_cfitsio_libraries)
      if test x"$cpl_cfitsio_libraries" = xno; then
        cpl_cfitsio_libdirs="$cpl_cfitsio_dir/lib"
        ESO_FIND_FILE($cpl_cfitsio_check_lib, $cpl_cfitsio_libdirs, cpl_cfitsio_libraries)
      fi
    fi

    if test x"$cpl_cfitsio_includes" = xno || test x"$cpl_cfitsio_libraries" = xno; then
        AC_MSG_ERROR([cfitsio was not found on your system. Please check!])
    else
        AC_MSG_RESULT([libraries $cpl_cfitsio_libraries, headers $cpl_cfitsio_includes])
        # Attempt to check the version via CFITSIO_VERSION in the include file
        cpl_cfitsio_check_vers=`perl -nle 's/^#\s*define\s+CFITSIO_VERSION\s+\b// and s/\s.*//, print' $cpl_cfitsio_includes/fitsio.h`
       if test -z "$cpl_cfitsio_check_vers" ; then
         # Attempt to check the version by checking the include files
         cpl_cfitsio_check_vers=`grep "Version Info: This file is distributed with version 2.510 of CFITSIO" $cpl_cfitsio_includes/fitsio.h`
         if test -z "$cpl_cfitsio_check_vers" ; then
             AC_MSG_WARN([cfitsio version seems to be different from 2.510 and less than 3.X.])
	 else
             AC_MSG_WARN([cfitsio version seems to be 2.510])
         fi
       else
          CFLAGS="-D_LARGEFILE_SOURCE=1 -D_FILE_OFFSET_BITS=64 $CFLAGS"
       fi
    fi

    # Set up the symbols
    CFITSIO_INCLUDES="-I$cpl_cfitsio_includes"
    CFITSIO_LDFLAGS="-L$cpl_cfitsio_libraries"
    LIBCFITSIO="-lcfitsio"

    AC_SUBST(CFITSIO_INCLUDES)
    AC_SUBST(CFITSIO_LDFLAGS)
    AC_SUBST(LIBCFITSIO)
])

# CPL_CHECK_WCS
#--------------
# Checks for the wcs library and header files.
AC_DEFUN([CPL_CHECK_WCS],
[
    AC_MSG_CHECKING([for wcs])

    cpl_wcs_check_header="wcslib/wcslib.h"
    cpl_wcs_check_lib="libwcs.a"

    cpl_wcs_includes=""
    cpl_wcs_libraries=""

    AC_ARG_WITH(wcs,
                AC_HELP_STRING([--with-wcs],
                               [location where wcs is installed]),
                [
                    cpl_with_wcs_includes=$withval/include
                    cpl_with_wcs_libs=$withval/lib
                ])

    # Check for the wcs includes
    if test -z "$cpl_with_wcs_includes"; then
        test -n "$WCSDIR" && cpl_wcs_incdirs="$WCSDIR/include"
    else
        cpl_wcs_incdirs="$cpl_with_wcs_includes"
    fi
    ESO_FIND_FILE($cpl_wcs_check_header, $cpl_wcs_incdirs, cpl_wcs_includes)

    # Check for the wcs library
    if test -z "$cpl_with_wcs_libs"; then
        test -n "$WCSDIR" && cpl_wcs_libdirs="$WCSDIR/lib"
    else
        cpl_wcs_libdirs="$cpl_with_wcs_libs"
    fi
    ESO_FIND_FILE($cpl_wcs_check_lib, $cpl_wcs_libdirs, cpl_wcs_libraries)

    if test x"$cpl_wcs_includes" = xno || test x"$cpl_wcs_libraries" = xno; then
        AC_MSG_WARN([wcs was not found on your system.])
    else
        AC_MSG_RESULT([libraries $cpl_wcs_libraries, headers $cpl_wcs_includes])
        # Attempt to check the version by checking the include files
        cpl_wcs_check_vers43=`grep "WCSLIB 4.3 - an implementation of the FITS WCS standard" $cpl_wcs_includes/wcslib/wcslib.h`
        if test -z "$cpl_wcs_check_vers43" ; then
            cpl_wcs_check_vers44=`grep "WCSLIB 4.4 - an implementation of the FITS WCS standard" $cpl_wcs_includes/wcslib/wcslib.h`
            if test -z "$cpl_wcs_check_vers44" ; then
                AC_MSG_WARN([wcs version seems to be older than 4.3])
            fi
        fi
        AC_DEFINE_UNQUOTED(CPL_WCS_INSTALLED, 1, [Defined if WCS is available])
        # Set up the symbols
        WCS_INCLUDES="-I$cpl_wcs_includes/wcslib"
        WCS_LDFLAGS="-L$cpl_wcs_libraries"
        LIBWCS="-lwcs"

        AC_SUBST(WCS_INCLUDES)
        AC_SUBST(WCS_LDFLAGS)
        AC_SUBST(LIBWCS)
    fi

])

# CPL_CHECK_WCS
#--------------
# Checks for the wcs library and header files.
AC_DEFUN([CPL_CHECK_FFTW],
[
    AC_MSG_CHECKING([for fftw])

    cpl_fftw_check_header="fftw3.h"
    cpl_fftwf_check_header="fftw3.h"
    cpl_fftw_check_lib="libfftw3.a"
    cpl_fftwf_check_lib="libfftw3f.a"

    cpl_fftw_includes=""
    cpl_fftwf_includes=""
    cpl_fftw_libraries=""
    cpl_fftwf_libraries=""

    AC_ARG_WITH(fftw,
                AC_HELP_STRING([--with-fftw],
                               [location where fftw is installed]),
                [
                    cpl_with_fftw_includes=$withval/include
                    cpl_with_fftw_libs=$withval/lib
                ])

    # Check for the fftw includes
    if test -z "$cpl_with_fftw_includes"; then
        test -n "$FFTWDIR" && cpl_fftw_incdirs="$FFTWDIR/include"
    else
        cpl_fftw_incdirs="$cpl_with_fftw_includes"
    fi
    ESO_FIND_FILE($cpl_fftw_check_header, $cpl_fftw_incdirs, cpl_fftw_includes)
    ESO_FIND_FILE($cpl_fftwf_check_header, $cpl_fftw_incdirs, cpl_fftwf_includes)

    # Check for the fftw library
    if test -z "$cpl_with_fftw_libs"; then
        test -n "$FFTWDIR" && cpl_fftw_libdirs="$FFTWDIR/lib"
    else
        cpl_fftw_libdirs="$cpl_with_fftw_libs"
    fi
    ESO_FIND_FILE($cpl_fftw_check_lib, $cpl_fftw_libdirs, cpl_fftw_libraries)
    ESO_FIND_FILE($cpl_fftwf_check_lib, $cpl_fftw_libdirs, cpl_fftwf_libraries)

    if test x"$cpl_fftw_includes" = xno || test x"$cpl_fftw_libraries" = xno; then
        AC_MSG_WARN([fftw (normal-precision) was not found on your system.])
    else
        AC_MSG_RESULT([libraries $cpl_fftw_libraries, headers $cpl_fftw_includes])
        # FIXME: Attempt to check the version

        AC_DEFINE_UNQUOTED(CPL_FFTW_INSTALLED, 1, [Defined if FFTW (normal-precision) is available])
        # Set up the symbols
        FFTW_INCLUDES="-I$cpl_fftw_includes"
        FFTW_LDFLAGS="-L$cpl_fftw_libraries"
        LIBFFTW="-lfftw3"

        AC_SUBST(FFTW_INCLUDES)
        AC_SUBST(FFTW_LDFLAGS)
        AC_SUBST(LIBFFTW)
    fi

    if test x"$cpl_fftwf_includes" = xno || test x"$cpl_fftwf_libraries" = xno; then
        AC_MSG_WARN([fftw (single-precision) was not found on your system.])
    else
        AC_MSG_RESULT([libraries $cpl_fftwf_libraries, headers $cpl_fftwf_includes])
        # FIXME: Attempt to check the version

        AC_DEFINE_UNQUOTED(CPL_FFTWF_INSTALLED, 1, [Defined if FFTW (single-precision) is available])
        # Set up the symbols
        FFTWF_INCLUDES="-I$cpl_fftwf_includes"
        FFTWF_LDFLAGS="-L$cpl_fftwf_libraries"
        LIBFFTWF="-lfftw3f"

        AC_SUBST(FFTWF_INCLUDES)
        AC_SUBST(FFTWF_LDFLAGS)
        AC_SUBST(LIBFFTWF)
    fi

])


# Try to determine the Cache size - using /proc/cpuinfo
#------------------
AC_DEFUN([CPL_CHECK_CPU],
[
    AC_MSG_CHECKING([/proc/cpuinfo for the CPU cache and cores])

    if test -r "/proc/cpuinfo"; then
        cpl_cpu_cache_string=`grep "cache size" /proc/cpuinfo | head -1 | perl -ne 's/^\D+//;s/\b\s*kB\b\D*/<<10/i || s/\b\s*MB\b\D*/<<20/i;/^\d+/ and print eval'`
        if test -n "$cpl_cpu_cache_string"; then
            AC_DEFINE_UNQUOTED(CPL_CPU_CACHE, $cpl_cpu_cache_string, [Defined to number of bytes in (L2) Cache])
            AC_MSG_RESULT([CPU cache $cpl_cpu_cache_string B])
        fi
        cpl_cpu_core_string=`grep "cpu cores" /proc/cpuinfo | head -1 | perl -ne 's/^\D+//g;/^\d+/ and print'`
        if test -n "$cpl_cpu_core_string"; then
            AC_DEFINE_UNQUOTED(CPL_CPU_CORES, $cpl_cpu_core_string, [Defined to number of cores (possibly sharing the (L2) Cache)])
            AC_MSG_RESULT([CPU cores $cpl_cpu_core_string])
        fi
    fi

])

# CHECK MEMORY MODE
#------------------
AC_DEFUN([CPL_CHECK_MEMORYMODE],
[
    AC_MSG_CHECKING([for extended memory mode])

    AC_ARG_ENABLE(memory-mode,
                AC_HELP_STRING([--enable-memory-mode=M],
                               [where M=0 switches off the internal memory
                                handling, M=1 exits the program
                                whenever a memory allocation fails (default),
                                M=2 switches on the internal memory handling]),
                [
                    cpl_memory_flag=yes
                    # $enableval=yes when no argument is given
                    cpl_memory_mode=$enableval
                ])

    AC_ARG_ENABLE(max-ptrs,
                AC_HELP_STRING([--enable-max-ptrs=MAXPTRS],
                               [MAXPTRS Set MAXPTRS as the maximum number of
                pointers allowed when using memory-mode=2 (200003)]),
                [
                    cpl_max_ptrs_flag=yes
                    cpl_max_ptrs=$enableval
                ])

    # Pending: check cpl_max_ptrs is numeric, otherwise AC_MSG_ERROR 
    if test "x$cpl_max_ptrs_flag" = xyes ; then
        CPL_MAXPTRS_CFLAGS="-DCPL_XMEMORY_MAXPTRS=$cpl_max_ptrs"
    else
        CPL_MAXPTRS_CFLAGS="-DCPL_XMEMORY_MAXPTRS=200003"
    fi

    if test "x$cpl_memory_flag" = xyes ; then
        CPL_CFLAGS="-DCPL_XMEMORY_MODE=$cpl_memory_mode"
        case $cpl_memory_mode in
        yes)
          CPL_CFLAGS="-DCPL_XMEMORY_MODE=0 -DCPL_XMEMORY_MAXPTRS=1"
          break ;;
        0|1)
          CPL_CFLAGS="-DCPL_XMEMORY_MODE=$cpl_memory_mode -DCPL_XMEMORY_MAXPTRS=1"
          break ;;
        2)
          CPL_CFLAGS="-DCPL_XMEMORY_MODE=2 $CPL_MAXPTRS_CFLAGS"
          break ;;
        *)
          AC_MSG_ERROR([Option --enable-memory-mode=$cpl_memory_mode not valid. Please check!])
          break ;;
        esac

    else
        CPL_CFLAGS="-DCPL_XMEMORY_MODE=1 -DCPL_XMEMORY_MAXPTRS=1"
    fi

    AC_MSG_RESULT([CPL_CFLAGS=$CPL_CFLAGS])
    AC_SUBST(CPL_CFLAGS)
])

#
# CPL_CREATE_SYMBOLS(build=[])
#-----------------------------
# Sets the Makefile symbols for the CPL and C extension libraries. If an
# argument is provided the symbols are setup for building CPL, if no
# argument is given (default) the symbols are set for using the libraries
# for external package development.
AC_DEFUN([CPL_CREATE_SYMBOLS],
[

    if test -z "$1"; then
        LIBCPLCORE='-lcplcore'
        LIBCPLDRS='-lcpldrs'
        LIBCPLUI='-lcplui'
        LIBCPLDFS='-lcpldfs'

        # Third party libraries
        LIBCEXT='-lcext'
    else
        LIBCPLCORE='$(top_builddir)/cplcore/libcplcore.la'
        LIBCPLDRS='$(top_builddir)/cpldrs/libcpldrs.la'
        LIBCPLUI='$(top_builddir)/cplui/libcplui.la'
        LIBCPLDFS='$(top_builddir)/cpldfs/libcpldfs.la'

        # Third party libraries
        LIBCEXT='$(top_builddir)/libcext/cext/libcext.la'
    fi

   AC_SUBST(LIBCPLCORE)
   AC_SUBST(LIBCPLDRS)
   AC_SUBST(LIBCPLUI)
   AC_SUBST(LIBCPLDFS)

   AC_SUBST(LIBCEXT)

])

# CPL_CHECK_VA_ARGS
#---------------
# Checks for the support of variadic macros
AC_DEFUN([CPL_CHECK_VA_ARGS],
[

    AC_COMPILE_IFELSE([#define cpl_check_va_args(A, ...) printf(A, __VA_ARGS__)],
                      AC_DEFINE(CPL_HAVE_VA_ARGS, 1,
                      Define to 1 if you have variadic macros.),
                      AC_MSG_WARN([Variadic macros are not available]))
])

# CPL_CHECK_COMPLEX
#---------------
# Checks for the support of complex primitive types
AC_DEFUN([CPL_CHECK_COMPLEX],
[

    AC_COMPILE_IFELSE(AC_LANG_PROGRAM(
                      [[#include <complex.h>]],
                      [[double complex a, b;
                        a = 2.0 + 2.0 * I;
                        b = cabs(a);]]),
                      AC_DEFINE(CPL_HAVE_COMPLEX, 1,
                      Define to 1 if you have complex primitive types.),
                      AC_MSG_WARN([Complex primitive types are not available]))
])
