/* $Id: cxtypes.h,v 1.2 2009/02/11 12:27:50 llundin Exp $
 *
 * This file is part of the ESO C Extension Library
 * Copyright (C) 2001-2006 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _CX_TYPES_H
#define _CX_TYPES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <limits.h>
#include <float.h>

#include <cxmacros.h>

CX_BEGIN_DECLS

/*
 * Some mathematical constants. Some strict ISO C implementations
 * don't provide them as symbols.
 */

/* Deprecated, use constants from cpl_math_const.h instead. */

#define CX_PI    3.14159265358979323846e0

/*
 * Limits for numerical data types
 */

#define CX_MINSHORT  SHRT_MIN
#define CX_MAXSHORT  SHRT_MAX
#define CX_MAXUSHORT USHRT_MAX
#define CX_MININT    INT_MIN
#define CX_MAXINT    INT_MAX
#define CX_MAXUINT   UINT_MAX
#define CX_MINLONG   LONG_MIN
#define CX_MAXLONG   LONG_MAX
#define CX_MAXULONG  ULONG_MAX

#define CX_MINFLOAT  FLT_MIN
#define CX_MAXFLOAT  FLT_MAX
#define CX_MINDOUBLE DBL_MIN
#define CX_MAXDOUBLE DBL_MAX


#define CX_MININT64  ((cxint64)  0x8000000000000000)
#define CX_MAXINT64  ((cxint64)  0x7fffffffffffffff)
#define CX_MAXUINT64 ((cxuint64) 0xffffffffffffffff)


/*
 * Sized types
 */

typedef signed char cxint8;
typedef unsigned char cxuint8;
typedef signed short cxint16;
typedef unsigned short cxuint16;
typedef signed int cxint32;
typedef unsigned int cxuint32;


#if defined SIZEOF_LONG && SIZEOF_LONG == 8
CX_GNUC_EXTENSION typedef signed long cxint64;
CX_GNUC_EXTENSION typedef unsigned long cxuint64;
#else
CX_GNUC_EXTENSION typedef signed long long cxint64;
CX_GNUC_EXTENSION typedef unsigned long long cxuint64;
#endif

#if defined SIZEOF_SIZE_T && SIZEOF_SIZE_T == 8
typedef cxint64 cxssize;
typedef cxuint64 cxsize;
#else
typedef cxint32 cxssize;
typedef cxuint32 cxsize;
#endif

/*
 * For completeness: Definitions for standard types
 */

typedef char cxchar;
typedef short cxshort;
typedef int cxint;
typedef long cxlong;

typedef unsigned char cxbyte;

typedef unsigned char cxuchar;
typedef unsigned short cxushort;
typedef unsigned int cxuint;
typedef unsigned long cxulong;

typedef float cxfloat;
typedef double cxdouble;

typedef void * cxptr;
typedef const void * cxcptr;

typedef int cxbool;


/*
 * Generic, frequently used types.
 */

typedef cxint (*cx_compare_func) (cxcptr a, cxcptr b);
typedef cxint (*cx_compare_data_func) (cxcptr a, cxcptr b, cxptr data);

typedef cxbool (*cx_equal_func) (cxcptr a, cxcptr b);

typedef void (*cx_free_func) (cxptr data);

CX_END_DECLS

#endif /* _CX_TYPES_H */
