/* $Id: cpl_frameset.h,v 1.19 2010/11/11 10:31:52 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2005 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: llundin $
 * $Date: 2010/11/11 10:31:52 $
 * $Revision: 1.19 $
 * $Name: cpl-5_3_0-BRANCH $
 */

#ifndef CPL_FRAMESET_H
#define CPL_FRAMESET_H

#include <stdio.h>

#include <cpl_macros.h>
#include <cpl_frame.h>


CPL_BEGIN_DECLS

/**
 * @ingroup cpl_frameset
 *
 * @brief
 *   The frame set data type.
 *
 * This data type is opaque.
 */

typedef struct _cpl_frameset_ cpl_frameset;


/*
 * Create, copy and destroy operations
 */

cpl_frameset *cpl_frameset_new(void) CPL_ATTR_ALLOC;
cpl_frameset *cpl_frameset_duplicate(const cpl_frameset *other) CPL_ATTR_ALLOC;
void cpl_frameset_delete(cpl_frameset *self);

/*
 * Non modifying operations
 */

int cpl_frameset_get_size(const cpl_frameset *self);
int cpl_frameset_is_empty(const cpl_frameset *self);
int cpl_frameset_count_tags(const cpl_frameset *self, const char *tag);

/*
 * Search operations
 */

const cpl_frame *cpl_frameset_find_const(const cpl_frameset *self,
                                         const char *tag);
cpl_frame *cpl_frameset_find(cpl_frameset *self, const char *tag);

/*
 * Sequential access
 */

const cpl_frame *cpl_frameset_get_first_const(const cpl_frameset *self);
cpl_frame *cpl_frameset_get_first(cpl_frameset *self);

const cpl_frame *cpl_frameset_get_next_const(const cpl_frameset *self);
cpl_frame *cpl_frameset_get_next(cpl_frameset *self);

/*
 * Inserting and removing elements
 */

cpl_error_code cpl_frameset_insert(cpl_frameset *self, cpl_frame *frame);
int cpl_frameset_erase(cpl_frameset *self, const char *tag);
cpl_error_code cpl_frameset_erase_frame(cpl_frameset *self, cpl_frame *frame);

/*
 * Element access
 */

const cpl_frame *cpl_frameset_get_frame_const(const cpl_frameset *self, int position);
cpl_frame *cpl_frameset_get_frame(cpl_frameset *self, int position);

/*
 * Miscellaneous functions
 */

int *cpl_frameset_labelise(const cpl_frameset *self,
                           int (*compare)(const cpl_frame *, const cpl_frame *),
                           int *nb_labels);
cpl_frameset *cpl_frameset_extract(const cpl_frameset *self, const int *labels,
                                   int desired_label) CPL_ATTR_ALLOC;

void cpl_frameset_dump(const cpl_frameset *self, FILE *stream);

CPL_END_DECLS

#endif /* CPL_FRAMESET_H */
