/* $Id: cpl_filter_median_float.c,v 1.6 2010/03/24 13:56:44 llundin Exp $
 *
 * This file is part of the cpl package 
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: llundin $
 * $Date: 2010/03/24 13:56:44 $
 * $Revision: 1.6 $
 * $Name: cpl-5_3_0-BRANCH $
 */

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

#define PIX_TYPE float
/* FIXME: Use FLT_MIN */
#define PIX_MIN (-FLT_MAX)
#define PIX_MAX FLT_MAX

#define GET_KTH cpl_tools_get_kth_float

/*-----------------------------------------------------------------------------
                     Includes
 -----------------------------------------------------------------------------*/

#include "cpl_filter_median_impl.h"

#include "cpl_tools.h"

#include <float.h>

/*-----------------------------------------------------------------------------
                     Include - Static Function Definitions
 -----------------------------------------------------------------------------*/

#include "cpl_filter_median.c"

/*-----------------------------------------------------------------------------
                                   Function definition
 -----------------------------------------------------------------------------*/

void cpl_filter_median_fast_float(void * out, const void * in,
                                  int Nx, int Ny, int hsizex,
                                  int hsizey, cpl_border_mode mode)
{

    filter_median(in, out, (unsigned)Nx, (unsigned)Ny,
                  (unsigned)hsizex, (unsigned)hsizey, (unsigned)mode);

    return;
}
