/*                                                                           *
 *   This file is part of the ESO UVES  Pipeline                             *
 *   Copyright (C) 2004,2005 European Southern Observatory                   *
 *                                                                           *
 *   This library is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by    *
 *   the Free Software Foundation; either version 2 of the License, or       *
 *   (at your option) any later version.                                     *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU General Public License for more details.                            *
 *                                                                           *
 *   You should have received a copy of the GNU General Public License       *
 *   along with this program; if not, write to the Free Software             *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA    *
 *                                                                           */

/*
 * $Author: amodigli $
 * $Date: 2011-11-23 17:29:09 $
 * $Revision: 1.6 $
 * $Name: not supported by cvs2svn $
 * $Log: not supported by cvs2svn $
 * Revision 1.5  2006/10/25 06:46:09  amodigli
 * fixed warnings from static checks
 *
 * Revision 1.4  2006/10/17 11:13:30  amodigli
 * added config.h
 *
 * Revision 1.3  2006/10/16 07:26:23  amodigli
 * shortened line length
 *
 * Revision 1.2  2006/10/04 06:17:45  amodigli
 * added doxygen doc
 *
 * Revision 1.1  2006/08/09 12:20:11  amodigli
 * added sinfo_dump.h sinfo_dump.c
 *
 * Revision 1.2  2005/12/19 16:17:56  jmlarsen
 * Replaced bool -> int
 *
 */
#ifndef SINFO_DUMP_H
#define SINFO_DUMP_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <cpl.h>
#include <sinfo_cpl_size.h>

cpl_error_code 
sinfo_print_cpl_propertylist(const cpl_propertylist *pl, 
                             long low, 
                             long high);

cpl_error_code 
sinfo_print_cpl_property(const cpl_property *);

cpl_error_code 
sinfo_print_cpl_frameset(const cpl_frameset *);

cpl_error_code 
sinfo_print_cpl_frame(const cpl_frame *);

const char *
sinfo_tostring_cpl_type(cpl_type t);

const char *
sinfo_tostring_cpl_frame_type(cpl_frame_type);

const char *
sinfo_tostring_cpl_frame_group(cpl_frame_group);

const char *
sinfo_tostring_cpl_frame_level(cpl_frame_level);

#endif /* SINFO_DUMP_H */
