/**************************************************************************/
/*                                                                        */
/*  cpbk - a mirroring utility for backing up your files                  */
/*  Copyright (C) 1998 Kevin Lindsay <klindsay@mkintraweb.com>            */
/*  Copyright (C) 2001 Yuuki NINOMIYA <gm@debian.or.jp>                   */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2, or (at your option)   */
/*  any later version.                                                    */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful,       */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*  GNU General Public License for more details.                          */
/*                                                                        */
/*  You should have received a copy of the GNU General Public License     */
/*  along with this program; if not, write to the                         */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,          */
/*  Boston, MA 02111-1307, USA.                                           */
/*                                                                        */
/**************************************************************************/

/* $Id: proto.h,v 1.7 2001/03/30 13:16:36 gm Exp $ */

#ifndef PROTO_H_INCLUDED
#define PROTO_H_INCLUDED

#include <sys/types.h>


/* copyproc.c */
void prepare_source_dir(void);
void prepare_dest_dir(void);
void copy_procedure(void);

/* cpbk.c */
void err_printf(ProcessOnError proc, const char *func_name, const char *format, ...);
void internal_error(const char *file, int line);

/* exclude.c */
void parse_linear_exclude_path(void);
void prepare_exclude_path(void);
bool is_exclude_path(const char *path, const char *displayed_path);

/* fileop.c */
char *canonicalize_path(char *path_dir, const char *dir_type);
int mkdir_parents(const char *path_dir, mode_t mode);
void check_valid_dir(const char *path_dir, const char *dir_type);
void get_file_data(FileData *file_data, const char *top_dir);
void sort_file_state(FileState *file_state, int num_files);
void sort_path_state(PathState *path_state, int num_paths);
void output_file_data(const FileData *file_data, int nest_level);
void free_file_data(FileData *file_data);
bool is_src_newer(FileState *src_stat, FileState *dest_stat, const char *src_dir, const char *dest_dir);
bool is_src_mode_changed(FileState *src_stat, FileState *dest_stat, const char *src_dir, const char *dest_dir);
void copy_file(Order *order, const char *src, const char *dest);
void remove_file(Order *order, const char *dest);
void make_dir(Order *order, const char *dest);
void remove_dir(Order *order, const char *dest);
void change_mode(Order *order, const char *dest);
bool am_i_root(void);

/* linklist.c */
cfgList *insert_list_head(cfgList *list, char *string);
void output_list(cfgList *list);

/* order.c */
Order *compare_files_and_generate_order(FileData *local_file_data, FileData *remote_file_data, const char *local_top_dir, const char *remote_top_dir);
void free_order(Order *order);
void put_listing_of_updated_file(Order *order);
void put_the_number_of_updated_file(Order *order);
int search_path_num(PathState *path_state, int num_paths, const char *path);
int search_file_num(PathState *path_state, int path_num, const char *name);

/* progress.c */
void update_progress_bar(void);
void init_progress_info(Order *order);
void output_progress_info(Action act, const char *path_file, const char *dest_for_verbose, Order *order);

/* trashbin.c */
void prepare_trashbin_dir(void);
void trash_it(Action act, const char *path_file);


#endif /* PROTO_H_INCLUDED */
