/*****************************************************************
 *
 *   xacv.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"
#include "defaults.h"

extern gboolean if_xa;
extern gboolean if_cv;
gboolean temp_xa;
gboolean temp_cv;
GtkWidget *check_xa;
GtkWidget *check_cv;
GtkWidget *entry[1];

void exec(GtkWidget *button, gpointer *data)
{
	gchar *exec_command;
	if(if_xa && if_cv)
		exec_command = g_strconcat("xa cv ",gtk_entry_get_text(GTK_ENTRY(entry[0]))," &", NULL);	
	else if(if_xa)
		exec_command = g_strconcat("xa ",gtk_entry_get_text(GTK_ENTRY(entry[0]))," &", NULL);	
	else if(if_cv)
		exec_command = g_strconcat("cv ",gtk_entry_get_text(GTK_ENTRY(entry[0]))," &", NULL);	
	else
		exec_command = g_strconcat(gtk_entry_get_text(GTK_ENTRY(entry[0]))," &", NULL);	
	system(exec_command);
}

void xa(GtkWidget *button, gpointer *data)
{
	if(!if_xa)
		temp_xa=1;
	else
		temp_xa=0;
}

void cv(GtkWidget *button, gpointer *data)
{
	if(!if_cv)
		temp_cv=1;
	else
		temp_cv=0;
}

void ok_xacv(GtkWidget *button, gpointer *data)
{
	if_xa = temp_xa;
	if_cv = temp_cv;
}

void def_xacv(GtkWidget *button, gpointer *data)
{
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check_xa),IF_XA);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check_cv),IF_CV);
}

void help_xacv(GtkWidget *button, gpointer *data)
{
	show_help("xacv_opt",_("Help - XA+CV"),600,300);
}

void xacv(GtkWidget *button, gpointer *data)
{
	GtkWidget *win;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	GtkWidget *hbox;
	GtkWidget *vbox;

	win = make_opt_win(_("XA+CV"),button);

	vbox = gtk_vbox_new(FALSE,0);
	hbox = make_opt(_("Run program: "),entry,0,"");
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);

	hbox = gtk_hbox_new(FALSE,0);
	ok_button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(ok_button),"clicked",
			GTK_SIGNAL_FUNC(exec),NULL);
	gtk_signal_connect(GTK_OBJECT(ok_button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(hbox),ok_button,FALSE,FALSE,3);
	
	cancel_button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(cancel_button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(hbox),cancel_button,FALSE,FALSE,3);

	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,2);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_widget_show_all(win);
}

void xacv_opt(GtkWidget *button, gpointer *data)
{
	GtkWidget *win;
	GtkWidget *vbox;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	GtkWidget *def_button;
	GtkWidget *help_button;
	GtkWidget *separator;
	GtkWidget *hbox;


temp_cv = if_cv;
temp_xa = if_xa;

	win = make_opt_win(_("Option - XA+CV"),button);

	vbox = gtk_vbox_new(FALSE,0);

	check_xa = make_check_opt(_("Use XA"),if_xa);
	gtk_signal_connect(GTK_OBJECT(check_xa),"toggled",
			GTK_SIGNAL_FUNC(xa),NULL);
	gtk_box_pack_start(GTK_BOX(vbox),check_xa,FALSE,FALSE,1);

	check_cv = make_check_opt(_("Use CV"),if_cv);
	gtk_signal_connect(GTK_OBJECT(check_cv),"toggled",
			GTK_SIGNAL_FUNC(cv),NULL);
	gtk_box_pack_start(GTK_BOX(vbox),check_cv,FALSE,FALSE,1);


        /* --------------------------------------------------- */
        ok_button = gtk_button_new_with_label(_("OK"));
        gtk_signal_connect(GTK_OBJECT(ok_button),"clicked",
                        GTK_SIGNAL_FUNC(ok_xacv),NULL);

        cancel_button = gtk_button_new_with_label(_("Cancel"));

        def_button = gtk_button_new_with_label(_("Use Defaults"));
        gtk_signal_connect(GTK_OBJECT(def_button),"clicked",
                        GTK_SIGNAL_FUNC(def_xacv),NULL);

        help_button = gtk_button_new_with_label(_("Help"));
        gtk_signal_connect(GTK_OBJECT(help_button),"clicked",
                        GTK_SIGNAL_FUNC(help_xacv),NULL);

        separator = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,5);
        hbox = make_button(ok_button,cancel_button,def_button,help_button,win,button);
        gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

        gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_widget_show_all(win);
}

void xacv_help(GtkWidget *button, gpointer *data)
{
	show_help("xacv_help",_("Help - XA+CV"),600,300);
}
