#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"

extern gboolean if_not_warning;
gboolean temp_if_not_warning;

void backup_config(GtkWidget *button, gpointer data)
{
	make_backup_file("/etc/apt/sources.list","/etc/apt/sources.list.cpanel");
}

void restore_user_setting(GtkWidget *button, gpointer data)
{
	make_backup_file("/etc/apt/sources.list.cpanel","/etc/apt/sources.list");
	system("rm /etc/apt/sources.list.cpanel");
}

void assign_warning(GtkWidget *button, gpointer data)
{
	if_not_warning = temp_if_not_warning;
}

void set_warning(GtkWidget *button, gpointer data)
{
	if(!if_not_warning)
		temp_if_not_warning=1;
	else
		temp_if_not_warning=0;
}

void warning_dialog(GtkWidget *pre_button, gpointer win)
{
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *check_box;

	gtk_widget_destroy(GTK_WIDGET(win));

	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog),_("Warning"));
	gtk_container_set_border_width(GTK_CONTAINER(dialog),10);

	label = gtk_label_new(_("Warning! The file /etc/apt/sources.list has been overwritten.\nThe old file is /etc/apt/sources.list.cpanel"));
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,FALSE,FALSE,2);
	check_box = make_check_opt(_("Don't show me this kind of warning again"),if_not_warning);
	gtk_signal_connect(GTK_OBJECT(check_box),"toggled",
			GTK_SIGNAL_FUNC(set_warning),NULL);
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),check_box,FALSE,FALSE,2);

	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(assign_warning),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),dialog);
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),button,FALSE,FALSE,2);

	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
}

void apt_update(GtkWidget *pre_button, gpointer data)
{
	system("crxvt -e apt-get update");
}

void apt_install(GtkWidget *pre_button, gpointer program)
{
	gchar *str;
	str = g_strconcat("crxvt -e apt-get install ",(gchar *)program,NULL);
	system(str);
	g_free(str);
}

void write_cpanel_deb(GtkWidget *pre_button, gpointer combo)
{
#define APT_SOURCES_LIST "/etc/apt/sources.list"
	gchar *str;
	gchar deb[256];
	FILE *f;

	str = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));
	if(!strcasecmp(str,_("Hong Kong (debian.org.hk)")))
		strcpy(deb,"deb http://www.debian.org.hk/~kamtik/cpanel ");
	if(!strcasecmp(str,_("Hong Kong (linux.org.hk)")))
		strcpy(deb,"deb http://www.linux.org.hk/~kamtik/cpanel ");
			

	f = fopen(APT_SOURCES_LIST,"w");
	if(!f)
	{
		printf("Error saving sources.list at: %s\n",APT_SOURCES_LIST);
		printf("Are you root?\n");
		return;
	}

	fprintf(f,"# This file is generated by CPANEL %d.%d.%d\n\n",VERSION_MAJOR,VERSION_MINOR,VERSION_MICRO);
	/* origanal contents */
	fprintf(f,"# See sources.list(5) for more information, especialy\n# Remember that you can only use http, ftp or file URIs\n# CDROMs are managed through the apt-cdrom tool.\n\n");
	fprintf(f,"#deb http://http.us.debian.org/debian stable main contrib non-free\n#deb http://www.debian.org.hk/debian stable main contrib non-free\n#deb http://non-us.debian.org/debian-non-US potato/non-US main contrib non-free\n#deb http://security.debian.org stable/updates main contrib non-free\n\n");
	fprintf(f,"# Uncomment if you want the apt-get source function to work\n#deb-src http://http.us.debian.org/debian stable main contrib non-free\n#deb-src http://non-us.debian.org/debian-non-US stable non-US\n\n");

	fprintf(f,"%s",deb);
	fclose(f);
}

void write_ext_deb(GtkWidget *pre_button, gpointer combo)
{
	gchar *str;
	gchar deb[256];
	FILE *f;

	str = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));
	if(!strcasecmp(str,_("Default (US)")))
		strcpy(deb,"deb http://http.us.debian.org/debian ");
	if(!strcasecmp(str,_("Hong Kong (debian.org.hk)")))
		strcpy(deb,"deb http://www.debian.org.hk/debian ");
			
	f = fopen(APT_SOURCES_LIST,"a");
	if(!f)
	{
		printf("Error saving sources.list at: %s\n",APT_SOURCES_LIST);
		printf("Are you root?\n");
		return;
	}

	fprintf(f,"%s",deb);
	fclose(f);
}

void write_cpanel_distro_deb(GtkWidget *pre_button, gpointer combo)
{
	gchar *str;
	gchar deb[256];
	FILE *f;

	str = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));
	if(!strcasecmp(str,"potato"))
		strcpy(deb,"potato main\n");
	if(!strcasecmp(str,"woody"))
		strcpy(deb,"woody main\n");
	if(!strcasecmp(str,"sid"))
		strcpy(deb,"sid main\n");
			
	f = fopen(APT_SOURCES_LIST,"a");
	if(!f)
	{
		printf("Error saving sources.list at: %s\n",APT_SOURCES_LIST);
		printf("Are you root?\n");
		return;
	}

	fprintf(f,"%s",deb);
	fclose(f);
}

void write_distro_deb(GtkWidget *pre_button, gpointer combo)
{
	gchar *str;
	gchar deb[256];
	FILE *f;

	str = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));
	if(!strcasecmp(str,"potato"))
		strcpy(deb,"potato main contrib non-free");
	if(!strcasecmp(str,"woody"))
		strcpy(deb,"woody main contrib non-free");
	if(!strcasecmp(str,"sid"))
		strcpy(deb,"sid main contrib non-free");
			
	f = fopen(APT_SOURCES_LIST,"a");
	if(!f)
	{
		printf("Error saving sources.list at: %s\n",APT_SOURCES_LIST);
		printf("Are you root?\n");
		return;
	}

	fprintf(f,"%s",deb);
	fclose(f);
}

void cancel_apt(GtkWidget *pre_button, gpointer win)
{
        GtkWidget *cancel_dialog;
        GtkWidget *button;
        GtkWidget *label;

        cancel_dialog = gtk_dialog_new();
        gtk_container_set_border_width(GTK_CONTAINER(cancel_dialog),10);

        label = gtk_label_new(_("Installation is not complete\nDo you really want to abort?"));
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cancel_dialog)->vbox),label,FALSE,FALSE,2);

        button = gtk_button_new_with_label(_("Continue"));
        GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
        gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(close_win),cancel_dialog);
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cancel_dialog)->action_area),button,TRUE,TRUE,2);
        gtk_widget_grab_default(button);

        button = gtk_button_new_with_label(_("Abort"));
        GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
        gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(close_win),win);
        gtk_signal_connect(GTK_OBJECT(button),"clicked",
                        GTK_SIGNAL_FUNC(close_win),cancel_dialog);
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cancel_dialog)->action_area),button,TRUE,TRUE,2);

        gtk_grab_add(cancel_dialog);
        gtk_widget_show_all(cancel_dialog);
}

void apt_step_3(GtkWidget *pre_button, gpointer program)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *label;
	gchar *str;

	win = gtk_dialog_new();
	gtk_signal_connect(GTK_OBJECT(win),"destroy",
			GTK_SIGNAL_FUNC(close_win),win);
	str = g_strconcat(_("Installing "),(gchar *)program,_(" - Step 3"),NULL);
	gtk_window_set_title(GTK_WINDOW(win),str);
	gtk_container_set_border_width(GTK_CONTAINER(win),10);

	label = gtk_label_new(_("Step 3\n"));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),label,FALSE,FALSE,1);

	str = g_strconcat(_("APT will now help you to install "),(gchar *)program,_(" with all its dependencies.\nYou may be asked for some questions about some configuration.\nPlease restart CPanel after you've installed all the program that you want."),NULL);
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),label,FALSE,FALSE,3);

	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(cancel_apt),win);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	button = gtk_button_new_with_label(_("Finish"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(restore_user_setting),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_install),program);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	gtk_widget_grab_default(button);

	gtk_widget_show_all(win);
}

void apt_step_2(GtkWidget *pre_button, gpointer program)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *label;
	gchar *title;
	
	win = gtk_dialog_new();
	gtk_signal_connect(GTK_OBJECT(win),"destroy",
			GTK_SIGNAL_FUNC(close_win),win);
	title = g_strconcat(_("Installing "),(gchar *)program,_(" - Step 2"),NULL);
	gtk_window_set_title(GTK_WINDOW(win),title);
	gtk_container_set_border_width(GTK_CONTAINER(win),10);

	label = gtk_label_new(_("Step 2\n"));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),label,FALSE,FALSE,1);

	label = gtk_label_new(_("CPanel will now help you to update the packages\n database. If you are sure that\nPlease don't skip this step unless you know what you're doing.\nPlease make sure that you've the internet connected"));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),label,FALSE,FALSE,3);

	/* wait for next version
	button = gtk_button_new_with_label(_("Help"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);
	*/

	button = gtk_button_new_with_label(_("Skip this step"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_step_3),program);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(cancel_apt),win);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	button = gtk_button_new_with_label(_("Next"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_step_3),program);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_update),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	gtk_widget_grab_default(button);
	
	gtk_widget_show_all(win);
}

void apt_process(GtkWidget *pre_button, gpointer program)
{
	GtkWidget *win;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *sub_vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *ext_combo;
	GtkWidget *distro_combo;
	GtkWidget *cpanel_combo;
	GList *sources = NULL;
	GList *cpanel_sources = NULL;
	/* potato or woody */
	GList *distro = NULL;
	gchar *title;

	win = gtk_dialog_new();

	gtk_signal_connect(GTK_OBJECT(win),"destroy",
			GTK_SIGNAL_FUNC(close_win),win);
	title = g_strconcat(_("Installing "),(gchar *)program,_(" - Step 1"),NULL);
	gtk_window_set_title(GTK_WINDOW(win),title);
	gtk_container_set_border_width(GTK_CONTAINER(win),10);

	label = gtk_label_new(_("Step 1\n"));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),label,FALSE,FALSE,1);

	frame = gtk_frame_new(_("External source path"));
	gtk_container_set_border_width(GTK_CONTAINER(frame),3);

	sub_vbox = gtk_vbox_new(FALSE,0);

	label = gtk_label_new(_("Please select the position which is nearest to you and which version you want\n(Hint: potato = Debian 2.2 ; woody = Debian 2.3/3.0 ; sid = Debian > 3.0)"));
	gtk_box_pack_start(GTK_BOX(sub_vbox),label,FALSE,FALSE,0);

	hbox = gtk_hbox_new(FALSE,2);
	sources = g_list_append(sources,_("Default (US)"));
	sources = g_list_append(sources,_("Hong Kong (debian.org.hk)"));
	ext_combo = gtk_combo_new();
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(ext_combo)->entry),FALSE);
	gtk_combo_set_popdown_strings(GTK_COMBO(ext_combo),sources);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(ext_combo)->entry),_("Default (US)"));
	gtk_box_pack_start(GTK_BOX(hbox),ext_combo,TRUE,TRUE,0);

if(strcasecmp((gchar *)program,"pydict")&&strcasecmp((gchar *)program,"chinput"))
	distro = g_list_append(distro,"potato");
else
	simple_message_dialog(_("The program your're installing is not available in the current stable distribution.\nIf you want to install it, you're going to upgrade your system to woody/sid.\nNote that it is difficult to undo this upgrade!"),_("Close"));
	distro = g_list_append(distro,"woody");
	distro = g_list_append(distro,"sid");
	distro_combo = gtk_combo_new();
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(distro_combo)->entry),FALSE);
	gtk_combo_set_popdown_strings(GTK_COMBO(distro_combo),distro);
	gtk_box_pack_start(GTK_BOX(hbox),distro_combo,FALSE,TRUE,0);

	gtk_box_pack_start(GTK_BOX(sub_vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame),sub_vbox);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,3);

	frame = gtk_frame_new(_("CPanel source path"));
	gtk_container_set_border_width(GTK_CONTAINER(frame),3);
	
	sub_vbox = gtk_vbox_new(FALSE,0);
	label = gtk_label_new(_("Please select the position which is nearest to you"));
	gtk_box_pack_start(GTK_BOX(sub_vbox),label,FALSE,FALSE,0);

	cpanel_sources = g_list_append(cpanel_sources,_("Hong Kong (debian.org.hk)"));
	cpanel_sources = g_list_append(cpanel_sources,_("Hong Kong (linux.org.hk)"));
	cpanel_combo = gtk_combo_new();
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cpanel_combo)->entry),FALSE);
	gtk_combo_set_popdown_strings(GTK_COMBO(cpanel_combo),cpanel_sources);
	gtk_box_pack_start(GTK_BOX(sub_vbox),cpanel_combo,FALSE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(frame),sub_vbox);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox),frame,FALSE,FALSE,3);

	/* wait for next version
	button = gtk_button_new_with_label(_("Help"));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);
	*/

	button = gtk_button_new_with_label(_("Skip this step"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_step_2),program);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(cancel_apt),win);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);

	button = gtk_button_new_with_label(_("Next"));
	/* write to file WAITING */
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(backup_config),NULL);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(write_cpanel_deb),cpanel_combo);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(write_cpanel_distro_deb),distro_combo);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(write_ext_deb),ext_combo);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(write_distro_deb),distro_combo);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(apt_step_2),program);
	if(if_not_warning)
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(close_win),win);
	else
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(warning_dialog),win);
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(win)->action_area),button,TRUE,TRUE,0);
	
	gtk_widget_grab_default(button);

	gtk_widget_show_all(win);
}
