&QS
  METHOD GPW
  EPS_DEFAULT 1.0E-12
  MAP_CONSISTENT
  EXTRAPOLATION ASPC
  EXTRAPOLATION_ORDER 3
  &CDFT
    TYPE_OF_CONSTRAINT HIRSHFELD
    STRENGTH           ${HIRSHFELD_STR}
    ! The constraint target: sum_i coeff_i * N_i
    ! where N_i is the number of VALENCE electrons on i
    TARGET             ${HIRSHFELD_TARGET}
    ATOMIC_CHARGES     FALSE
    @IF ( ${HIRSHFELD_FRAGMENT} == TRUE )
      &ATOM_GROUP
        ATOMS           1
        COEFF           1
        FRAGMENT_CONSTRAINT
      &END ATOM_GROUP
      &DUMMY_ATOMS
        ATOMS 2
      &END DUMMY_ATOMS
      FRAGMENT_A_FILE_NAME He+-noconstraint-ELECTRON_DENSITY-1_0.cube
      FRAGMENT_B_FILE_NAME H-noconstraint-ELECTRON_DENSITY-1_0.cube
    @ENDIF
    @IF ( ${HIRSHFELD_FRAGMENT} == FALSE )
      &ATOM_GROUP
        ATOMS           1..2
        COEFF           1 -1
      &END ATOM_GROUP
    @ENDIF
    &OUTER_SCF ON
      EPS_SCF 2.0e-1
      TYPE CDFT_CONSTRAINT
      OPTIMIZER BISECT
      BISECT_TRUST_COUNT 8
      EXTRAPOLATION_ORDER 2
      MAX_SCF  ${MAX_SCF}
      STEP_SIZE -3.0
    &END
    &HIRSHFELD_CONSTRAINT
      SHAPE_FUNCTION ${HIRSHFELD_SHAPEFN}
      GAUSSIAN_SHAPE ${GAUSSIAN_SHAPE}
    &END HIRSHFELD_CONSTRAINT
    &PROGRAM_RUN_INFO ON
      ! Print weight function to cube file
      @IF ( ${PRINT_WEIGHT_FUNCTION} == TRUE )
        &WEIGHT_FUNCTION
        &END WEIGHT_FUNCTION
      @ENDIF
      &EACH
        QS_SCF 1
      &END EACH
      COMMON_ITERATION_LEVELS 2
      ADD_LAST NUMERIC
      FILENAME ./${PROJECT_NAME}
    &END PROGRAM_RUN_INFO
  &END CDFT
&END QS
