!--------------------------------------------------------------------------------------------------!
!   CP2K: A general program to perform molecular dynamics simulations                              !
!   Copyright (C) 2000 - 2019  CP2K developers group                                               !
!--------------------------------------------------------------------------------------------------!

! **************************************************************************************************
!> \brief Routines to calculate the minimax coefficients in order to
!>        approximate 1/x as a sum over exponential functions
!>        1/x ~ SUM_{i}^{K} w_i EXP(-a_i * x) for x belonging to [1:Rc].
!>        This module contains coefficients for minimax approximations with 1 <= k <= 53.
!>        Generated from data from
!>        http://www.mis.mpg.de/scicomp/EXP_SUM/1_x
!>        This module should not be modified manually and should not be used anywhere
!>        except in main minimax module.
!>        This file was created using the scripts in cp2k/tools/minimax_tools.
! **************************************************************************************************

MODULE minimax_exp_k53
   USE kinds,                           ONLY: dp

   IMPLICIT NONE
   PRIVATE
   PUBLIC :: R_max, R_mm, err_mm, get_minimax_coeff_low, k_max, k_mm, k_p, n_approx

   INTEGER, PARAMETER :: n_approx = 935
   INTEGER, PARAMETER :: n_k = 53
   INTEGER, PARAMETER :: k_max = 53
   REAL(KIND=dp), PARAMETER :: R_max = 4.0E+12_dp

   INTEGER, PARAMETER, DIMENSION(n_k + 1) :: k_p = &
                                             [1, 10, 23, 42, 64, &
                                              92, 121, 154, 177, 201, &
                                              227, 254, 282, 311, 342, &
                                              380, 419, 458, 497, 536, &
                                              575, 612, 646, 681, 717, &
                                              744, 789, 826, 831, 833, &
                                              836, 839, 843, 848, 855, &
                                              861, 863, 865, 867, 870, &
                                              873, 877, 881, 883, 885, &
                                              887, 890, 892, 896, 901, &
                                              927, 929, 931, 936]

   INTEGER, PARAMETER, DIMENSION(n_approx) :: k_mm = &
                                              [1, 1, 1, 1, 1, &
                                               1, 1, 1, 1, 2, &
                                               2, 2, 2, 2, 2, &
                                               2, 2, 2, 2, 2, &
                                               2, 2, 3, 3, 3, &
                                               3, 3, 3, 3, 3, &
                                               3, 3, 3, 3, 3, &
                                               3, 3, 3, 3, 3, &
                                               3, 4, 4, 4, 4, &
                                               4, 4, 4, 4, 4, &
                                               4, 4, 4, 4, 4, &
                                               4, 4, 4, 4, 4, &
                                               4, 4, 4, 5, 5, &
                                               5, 5, 5, 5, 5, &
                                               5, 5, 5, 5, 5, &
                                               5, 5, 5, 5, 5, &
                                               5, 5, 5, 5, 5, &
                                               5, 5, 5, 5, 5, &
                                               5, 6, 6, 6, 6, &
                                               6, 6, 6, 6, 6, &
                                               6, 6, 6, 6, 6, &
                                               6, 6, 6, 6, 6, &
                                               6, 6, 6, 6, 6, &
                                               6, 6, 6, 6, 6, &
                                               7, 7, 7, 7, 7, &
                                               7, 7, 7, 7, 7, &
                                               7, 7, 7, 7, 7, &
                                               7, 7, 7, 7, 7, &
                                               7, 7, 7, 7, 7, &
                                               7, 7, 7, 7, 7, &
                                               7, 7, 7, 8, 8, &
                                               8, 8, 8, 8, 8, &
                                               8, 8, 8, 8, 8, &
                                               8, 8, 8, 8, 8, &
                                               8, 8, 8, 8, 8, &
                                               8, 9, 9, 9, 9, &
                                               9, 9, 9, 9, 9, &
                                               9, 9, 9, 9, 9, &
                                               9, 9, 9, 9, 9, &
                                               9, 9, 9, 9, 9, &
                                               10, 10, 10, 10, 10, &
                                               10, 10, 10, 10, 10, &
                                               10, 10, 10, 10, 10, &
                                               10, 10, 10, 10, 10, &
                                               10, 10, 10, 10, 10, &
                                               10, 11, 11, 11, 11, &
                                               11, 11, 11, 11, 11, &
                                               11, 11, 11, 11, 11, &
                                               11, 11, 11, 11, 11, &
                                               11, 11, 11, 11, 11, &
                                               11, 11, 11, 12, 12, &
                                               12, 12, 12, 12, 12, &
                                               12, 12, 12, 12, 12, &
                                               12, 12, 12, 12, 12, &
                                               12, 12, 12, 12, 12, &
                                               12, 12, 12, 12, 12, &
                                               12, 13, 13, 13, 13, &
                                               13, 13, 13, 13, 13, &
                                               13, 13, 13, 13, 13, &
                                               13, 13, 13, 13, 13, &
                                               13, 13, 13, 13, 13, &
                                               13, 13, 13, 13, 13, &
                                               14, 14, 14, 14, 14, &
                                               14, 14, 14, 14, 14, &
                                               14, 14, 14, 14, 14, &
                                               14, 14, 14, 14, 14, &
                                               14, 14, 14, 14, 14, &
                                               14, 14, 14, 14, 14, &
                                               14, 15, 15, 15, 15, &
                                               15, 15, 15, 15, 15, &
                                               15, 15, 15, 15, 15, &
                                               15, 15, 15, 15, 15, &
                                               15, 15, 15, 15, 15, &
                                               15, 15, 15, 15, 15, &
                                               15, 15, 15, 15, 15, &
                                               15, 15, 15, 15, 16, &
                                               16, 16, 16, 16, 16, &
                                               16, 16, 16, 16, 16, &
                                               16, 16, 16, 16, 16, &
                                               16, 16, 16, 16, 16, &
                                               16, 16, 16, 16, 16, &
                                               16, 16, 16, 16, 16, &
                                               16, 16, 16, 16, 16, &
                                               16, 16, 16, 17, 17, &
                                               17, 17, 17, 17, 17, &
                                               17, 17, 17, 17, 17, &
                                               17, 17, 17, 17, 17, &
                                               17, 17, 17, 17, 17, &
                                               17, 17, 17, 17, 17, &
                                               17, 17, 17, 17, 17, &
                                               17, 17, 17, 17, 17, &
                                               17, 17, 18, 18, 18, &
                                               18, 18, 18, 18, 18, &
                                               18, 18, 18, 18, 18, &
                                               18, 18, 18, 18, 18, &
                                               18, 18, 18, 18, 18, &
                                               18, 18, 18, 18, 18, &
                                               18, 18, 18, 18, 18, &
                                               18, 18, 18, 18, 18, &
                                               18, 19, 19, 19, 19, &
                                               19, 19, 19, 19, 19, &
                                               19, 19, 19, 19, 19, &
                                               19, 19, 19, 19, 19, &
                                               19, 19, 19, 19, 19, &
                                               19, 19, 19, 19, 19, &
                                               19, 19, 19, 19, 19, &
                                               19, 19, 19, 19, 19, &
                                               20, 20, 20, 20, 20, &
                                               20, 20, 20, 20, 20, &
                                               20, 20, 20, 20, 20, &
                                               20, 20, 20, 20, 20, &
                                               20, 20, 20, 20, 20, &
                                               20, 20, 20, 20, 20, &
                                               20, 20, 20, 20, 20, &
                                               20, 20, 20, 20, 21, &
                                               21, 21, 21, 21, 21, &
                                               21, 21, 21, 21, 21, &
                                               21, 21, 21, 21, 21, &
                                               21, 21, 21, 21, 21, &
                                               21, 21, 21, 21, 21, &
                                               21, 21, 21, 21, 21, &
                                               21, 21, 21, 21, 21, &
                                               21, 22, 22, 22, 22, &
                                               22, 22, 22, 22, 22, &
                                               22, 22, 22, 22, 22, &
                                               22, 22, 22, 22, 22, &
                                               22, 22, 22, 22, 22, &
                                               22, 22, 22, 22, 22, &
                                               22, 22, 22, 22, 22, &
                                               23, 23, 23, 23, 23, &
                                               23, 23, 23, 23, 23, &
                                               23, 23, 23, 23, 23, &
                                               23, 23, 23, 23, 23, &
                                               23, 23, 23, 23, 23, &
                                               23, 23, 23, 23, 23, &
                                               23, 23, 23, 23, 23, &
                                               24, 24, 24, 24, 24, &
                                               24, 24, 24, 24, 24, &
                                               24, 24, 24, 24, 24, &
                                               24, 24, 24, 24, 24, &
                                               24, 24, 24, 24, 24, &
                                               24, 24, 24, 24, 24, &
                                               24, 24, 24, 24, 24, &
                                               24, 25, 25, 25, 25, &
                                               25, 25, 25, 25, 25, &
                                               25, 25, 25, 25, 25, &
                                               25, 25, 25, 25, 25, &
                                               25, 25, 25, 25, 25, &
                                               25, 25, 25, 26, 26, &
                                               26, 26, 26, 26, 26, &
                                               26, 26, 26, 26, 26, &
                                               26, 26, 26, 26, 26, &
                                               26, 26, 26, 26, 26, &
                                               26, 26, 26, 26, 26, &
                                               26, 26, 26, 26, 26, &
                                               26, 26, 26, 26, 26, &
                                               26, 26, 26, 26, 26, &
                                               26, 26, 26, 27, 27, &
                                               27, 27, 27, 27, 27, &
                                               27, 27, 27, 27, 27, &
                                               27, 27, 27, 27, 27, &
                                               27, 27, 27, 27, 27, &
                                               27, 27, 27, 27, 27, &
                                               27, 27, 27, 27, 27, &
                                               27, 27, 27, 27, 27, &
                                               28, 28, 28, 28, 28, &
                                               29, 29, 30, 30, 30, &
                                               31, 31, 31, 32, 32, &
                                               32, 32, 33, 33, 33, &
                                               33, 33, 34, 34, 34, &
                                               34, 34, 34, 34, 35, &
                                               35, 35, 35, 35, 35, &
                                               36, 36, 37, 37, 38, &
                                               38, 39, 39, 39, 40, &
                                               40, 40, 41, 41, 41, &
                                               41, 42, 42, 42, 42, &
                                               43, 43, 44, 44, 45, &
                                               45, 46, 46, 46, 47, &
                                               47, 48, 48, 48, 48, &
                                               49, 49, 49, 49, 49, &
                                               50, 50, 50, 50, 50, &
                                               50, 50, 50, 50, 50, &
                                               50, 50, 50, 50, 50, &
                                               50, 50, 50, 50, 50, &
                                               50, 50, 50, 50, 50, &
                                               50, 51, 51, 52, 52, &
                                               53, 53, 53, 53, 53]

   REAL(KIND=dp), PARAMETER, DIMENSION(n_approx) :: R_mm = &
                                                    [2.0E+00_dp, 3.0E+00_dp, 4.0E+00_dp, 5.0E+00_dp, 6.0E+00_dp, &
                                                     7.0E+00_dp, 8.0E+00_dp, 9.0E+00_dp, 1.0E+01_dp, 2.0E+00_dp, &
                                                     3.0E+00_dp, 4.0E+00_dp, 5.0E+00_dp, 6.0E+00_dp, 7.0E+00_dp, &
                                                     8.0E+00_dp, 9.0E+00_dp, 1.0E+01_dp, 2.0E+01_dp, 3.0E+01_dp, &
                                                     4.0E+01_dp, 5.0E+01_dp, 2.0E+00_dp, 3.0E+00_dp, 4.0E+00_dp, &
                                                     5.0E+00_dp, 6.0E+00_dp, 7.0E+00_dp, 8.0E+00_dp, 9.0E+00_dp, &
                                                     1.0E+01_dp, 2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, 5.0E+01_dp, &
                                                     6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, &
                                                     2.0E+02_dp, 2.0E+00_dp, 3.0E+00_dp, 4.0E+00_dp, 5.0E+00_dp, &
                                                     6.0E+00_dp, 7.0E+00_dp, 8.0E+00_dp, 9.0E+00_dp, 1.0E+01_dp, &
                                                     2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, 5.0E+01_dp, 6.0E+01_dp, &
                                                     7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, 2.0E+02_dp, &
                                                     3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, 2.0E+00_dp, 3.0E+00_dp, &
                                                     4.0E+00_dp, 5.0E+00_dp, 6.0E+00_dp, 7.0E+00_dp, 8.0E+00_dp, &
                                                     9.0E+00_dp, 1.0E+01_dp, 2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, &
                                                     5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, &
                                                     1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, &
                                                     6.0E+02_dp, 7.0E+02_dp, 8.0E+02_dp, 9.0E+02_dp, 1.0E+03_dp, &
                                                     2.0E+03_dp, 2.0E+00_dp, 3.0E+00_dp, 4.0E+00_dp, 5.0E+00_dp, &
                                                     6.0E+00_dp, 7.0E+00_dp, 8.0E+00_dp, 9.0E+00_dp, 1.0E+01_dp, &
                                                     2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, 5.0E+01_dp, 6.0E+01_dp, &
                                                     7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, 2.0E+02_dp, &
                                                     3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, 6.0E+02_dp, 7.0E+02_dp, &
                                                     8.0E+02_dp, 9.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, &
                                                     2.0E+00_dp, 3.0E+00_dp, 4.0E+00_dp, 5.0E+00_dp, 6.0E+00_dp, &
                                                     7.0E+00_dp, 8.0E+00_dp, 9.0E+00_dp, 1.0E+01_dp, 2.0E+01_dp, &
                                                     3.0E+01_dp, 4.0E+01_dp, 5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, &
                                                     8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, &
                                                     4.0E+02_dp, 5.0E+02_dp, 6.0E+02_dp, 7.0E+02_dp, 8.0E+02_dp, &
                                                     9.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, &
                                                     5.0E+03_dp, 6.0E+03_dp, 7.0E+03_dp, 1.0E+01_dp, 2.0E+01_dp, &
                                                     3.0E+01_dp, 4.0E+01_dp, 5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, &
                                                     8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, &
                                                     4.0E+02_dp, 5.0E+02_dp, 7.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, &
                                                     3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, 7.0E+03_dp, 1.0E+04_dp, &
                                                     2.0E+04_dp, 1.0E+01_dp, 2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, &
                                                     5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, &
                                                     1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, &
                                                     7.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, &
                                                     5.0E+03_dp, 7.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, &
                                                     1.0E+01_dp, 2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, 5.0E+01_dp, &
                                                     6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, &
                                                     2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, 7.0E+02_dp, &
                                                     1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, &
                                                     7.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, 5.0E+04_dp, &
                                                     1.0E+05_dp, 1.0E+01_dp, 2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, &
                                                     5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, &
                                                     1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, &
                                                     7.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, &
                                                     5.0E+03_dp, 7.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, &
                                                     5.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, 1.0E+01_dp, 2.0E+01_dp, &
                                                     3.0E+01_dp, 4.0E+01_dp, 5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, &
                                                     8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, &
                                                     4.0E+02_dp, 5.0E+02_dp, 7.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, &
                                                     3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, 7.0E+03_dp, 1.0E+04_dp, &
                                                     2.0E+04_dp, 3.0E+04_dp, 5.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, &
                                                     3.0E+05_dp, 1.0E+01_dp, 2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, &
                                                     5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, &
                                                     1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, &
                                                     7.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, &
                                                     5.0E+03_dp, 7.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, &
                                                     5.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, 3.0E+05_dp, 4.0E+05_dp, &
                                                     1.0E+01_dp, 2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, 5.0E+01_dp, &
                                                     6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, &
                                                     2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, 7.0E+02_dp, &
                                                     1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, &
                                                     7.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, 5.0E+04_dp, &
                                                     1.0E+05_dp, 2.0E+05_dp, 3.0E+05_dp, 4.0E+05_dp, 5.0E+05_dp, &
                                                     7.0E+05_dp, 1.0E+01_dp, 2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, &
                                                     5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, &
                                                     1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, &
                                                     6.0E+02_dp, 7.0E+02_dp, 8.0E+02_dp, 9.0E+02_dp, 1.0E+03_dp, &
                                                     2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, 6.0E+03_dp, &
                                                     7.0E+03_dp, 8.0E+03_dp, 9.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, &
                                                     3.0E+04_dp, 4.0E+04_dp, 5.0E+04_dp, 7.0E+04_dp, 1.0E+05_dp, &
                                                     2.0E+05_dp, 5.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, 1.0E+01_dp, &
                                                     2.0E+01_dp, 3.0E+01_dp, 4.0E+01_dp, 5.0E+01_dp, 6.0E+01_dp, &
                                                     7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, 2.0E+02_dp, &
                                                     3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, 6.0E+02_dp, 7.0E+02_dp, &
                                                     8.0E+02_dp, 9.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, &
                                                     4.0E+03_dp, 5.0E+03_dp, 6.0E+03_dp, 7.0E+03_dp, 8.0E+03_dp, &
                                                     9.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, 4.0E+04_dp, &
                                                     5.0E+04_dp, 7.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, 5.0E+05_dp, &
                                                     1.0E+06_dp, 2.0E+06_dp, 3.0E+06_dp, 2.0E+01_dp, 3.0E+01_dp, &
                                                     4.0E+01_dp, 5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, &
                                                     9.0E+01_dp, 1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, &
                                                     5.0E+02_dp, 6.0E+02_dp, 7.0E+02_dp, 8.0E+02_dp, 9.0E+02_dp, &
                                                     1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, &
                                                     6.0E+03_dp, 7.0E+03_dp, 8.0E+03_dp, 9.0E+03_dp, 1.0E+04_dp, &
                                                     2.0E+04_dp, 3.0E+04_dp, 4.0E+04_dp, 5.0E+04_dp, 7.0E+04_dp, &
                                                     1.0E+05_dp, 2.0E+05_dp, 5.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, &
                                                     3.0E+06_dp, 4.0E+06_dp, 4.0E+01_dp, 5.0E+01_dp, 6.0E+01_dp, &
                                                     7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, 2.0E+02_dp, &
                                                     3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, 6.0E+02_dp, 7.0E+02_dp, &
                                                     8.0E+02_dp, 9.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, &
                                                     4.0E+03_dp, 5.0E+03_dp, 6.0E+03_dp, 7.0E+03_dp, 8.0E+03_dp, &
                                                     9.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, 4.0E+04_dp, &
                                                     5.0E+04_dp, 7.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, 5.0E+05_dp, &
                                                     1.0E+06_dp, 2.0E+06_dp, 3.0E+06_dp, 4.0E+06_dp, 5.0E+06_dp, &
                                                     7.0E+06_dp, 5.0E+01_dp, 6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, &
                                                     9.0E+01_dp, 1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, &
                                                     5.0E+02_dp, 6.0E+02_dp, 7.0E+02_dp, 8.0E+02_dp, 9.0E+02_dp, &
                                                     1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, &
                                                     6.0E+03_dp, 7.0E+03_dp, 8.0E+03_dp, 9.0E+03_dp, 1.0E+04_dp, &
                                                     2.0E+04_dp, 3.0E+04_dp, 4.0E+04_dp, 5.0E+04_dp, 7.0E+04_dp, &
                                                     1.0E+05_dp, 2.0E+05_dp, 5.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, &
                                                     3.0E+06_dp, 4.0E+06_dp, 5.0E+06_dp, 7.0E+06_dp, 1.0E+07_dp, &
                                                     6.0E+01_dp, 7.0E+01_dp, 8.0E+01_dp, 9.0E+01_dp, 1.0E+02_dp, &
                                                     2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, 6.0E+02_dp, &
                                                     7.0E+02_dp, 8.0E+02_dp, 9.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, &
                                                     3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, 6.0E+03_dp, 7.0E+03_dp, &
                                                     8.0E+03_dp, 9.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, &
                                                     4.0E+04_dp, 5.0E+04_dp, 7.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, &
                                                     5.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, 3.0E+06_dp, 4.0E+06_dp, &
                                                     5.0E+06_dp, 7.0E+06_dp, 1.0E+07_dp, 2.0E+07_dp, 9.0E+01_dp, &
                                                     1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, &
                                                     6.0E+02_dp, 7.0E+02_dp, 8.0E+02_dp, 9.0E+02_dp, 1.0E+03_dp, &
                                                     2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, 6.0E+03_dp, &
                                                     7.0E+03_dp, 8.0E+03_dp, 9.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, &
                                                     3.0E+04_dp, 4.0E+04_dp, 5.0E+04_dp, 7.0E+04_dp, 1.0E+05_dp, &
                                                     2.0E+05_dp, 5.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, 3.0E+06_dp, &
                                                     4.0E+06_dp, 5.0E+06_dp, 7.0E+06_dp, 1.0E+07_dp, 2.0E+07_dp, &
                                                     3.0E+07_dp, 1.0E+02_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, &
                                                     5.0E+02_dp, 7.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, &
                                                     4.0E+03_dp, 5.0E+03_dp, 7.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, &
                                                     3.0E+04_dp, 4.0E+04_dp, 5.0E+04_dp, 7.0E+04_dp, 1.0E+05_dp, &
                                                     2.0E+05_dp, 3.0E+05_dp, 4.0E+05_dp, 5.0E+05_dp, 7.0E+05_dp, &
                                                     1.0E+06_dp, 2.0E+06_dp, 3.0E+06_dp, 4.0E+06_dp, 5.0E+06_dp, &
                                                     7.0E+06_dp, 1.0E+07_dp, 2.0E+07_dp, 3.0E+07_dp, 4.0E+07_dp, &
                                                     2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, 7.0E+02_dp, &
                                                     1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, &
                                                     7.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, 4.0E+04_dp, &
                                                     5.0E+04_dp, 7.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, 3.0E+05_dp, &
                                                     4.0E+05_dp, 5.0E+05_dp, 7.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, &
                                                     3.0E+06_dp, 4.0E+06_dp, 5.0E+06_dp, 7.0E+06_dp, 1.0E+07_dp, &
                                                     2.0E+07_dp, 3.0E+07_dp, 4.0E+07_dp, 5.0E+07_dp, 7.0E+07_dp, &
                                                     2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, 7.0E+02_dp, &
                                                     1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, &
                                                     7.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, 3.0E+04_dp, 4.0E+04_dp, &
                                                     5.0E+04_dp, 7.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, 3.0E+05_dp, &
                                                     4.0E+05_dp, 5.0E+05_dp, 7.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, &
                                                     3.0E+06_dp, 4.0E+06_dp, 5.0E+06_dp, 7.0E+06_dp, 1.0E+07_dp, &
                                                     2.0E+07_dp, 3.0E+07_dp, 4.0E+07_dp, 5.0E+07_dp, 7.0E+07_dp, &
                                                     1.0E+08_dp, 2.0E+02_dp, 3.0E+02_dp, 4.0E+02_dp, 5.0E+02_dp, &
                                                     7.0E+02_dp, 1.0E+03_dp, 2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, &
                                                     5.0E+03_dp, 6.0E+03_dp, 7.0E+03_dp, 8.0E+03_dp, 9.0E+03_dp, &
                                                     1.0E+04_dp, 2.0E+04_dp, 5.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, &
                                                     5.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, 5.0E+06_dp, 1.0E+07_dp, &
                                                     5.0E+07_dp, 1.0E+08_dp, 2.0E+08_dp, 4.0E+02_dp, 5.0E+02_dp, &
                                                     6.0E+02_dp, 7.0E+02_dp, 8.0E+02_dp, 9.0E+02_dp, 1.0E+03_dp, &
                                                     2.0E+03_dp, 3.0E+03_dp, 4.0E+03_dp, 5.0E+03_dp, 6.0E+03_dp, &
                                                     7.0E+03_dp, 8.0E+03_dp, 9.0E+03_dp, 1.0E+04_dp, 2.0E+04_dp, &
                                                     3.0E+04_dp, 4.0E+04_dp, 5.0E+04_dp, 6.0E+04_dp, 7.0E+04_dp, &
                                                     8.0E+04_dp, 9.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, 3.0E+05_dp, &
                                                     4.0E+05_dp, 5.0E+05_dp, 7.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, &
                                                     3.0E+06_dp, 4.0E+06_dp, 5.0E+06_dp, 7.0E+06_dp, 1.0E+07_dp, &
                                                     2.0E+07_dp, 3.0E+07_dp, 4.0E+07_dp, 5.0E+07_dp, 7.0E+07_dp, &
                                                     1.0E+08_dp, 2.0E+08_dp, 3.0E+08_dp, 1.0E+04_dp, 2.0E+04_dp, &
                                                     3.0E+04_dp, 4.0E+04_dp, 5.0E+04_dp, 6.0E+04_dp, 7.0E+04_dp, &
                                                     8.0E+04_dp, 9.0E+04_dp, 1.0E+05_dp, 2.0E+05_dp, 3.0E+05_dp, &
                                                     4.0E+05_dp, 5.0E+05_dp, 6.0E+05_dp, 7.0E+05_dp, 8.0E+05_dp, &
                                                     9.0E+05_dp, 1.0E+06_dp, 2.0E+06_dp, 3.0E+06_dp, 4.0E+06_dp, &
                                                     5.0E+06_dp, 6.0E+06_dp, 7.0E+06_dp, 8.0E+06_dp, 9.0E+06_dp, &
                                                     1.0E+07_dp, 2.0E+07_dp, 3.0E+07_dp, 4.0E+07_dp, 5.0E+07_dp, &
                                                     7.0E+07_dp, 1.0E+08_dp, 2.0E+08_dp, 3.0E+08_dp, 4.0E+08_dp, &
                                                     1.0E+08_dp, 2.0E+08_dp, 3.0E+08_dp, 4.0E+08_dp, 7.0E+08_dp, &
                                                     7.0E+08_dp, 1.0E+09_dp, 7.0E+08_dp, 1.0E+09_dp, 2.0E+09_dp, &
                                                     7.0E+08_dp, 1.0E+09_dp, 2.0E+09_dp, 7.0E+08_dp, 1.0E+09_dp, &
                                                     2.0E+09_dp, 3.0E+09_dp, 7.0E+08_dp, 1.0E+09_dp, 2.0E+09_dp, &
                                                     3.0E+09_dp, 4.0E+09_dp, 7.0E+08_dp, 1.0E+09_dp, 2.0E+09_dp, &
                                                     3.0E+09_dp, 4.0E+09_dp, 5.0E+09_dp, 7.0E+09_dp, 7.0E+08_dp, &
                                                     1.0E+09_dp, 2.0E+09_dp, 3.0E+09_dp, 5.0E+09_dp, 1.0E+10_dp, &
                                                     1.0E+10_dp, 2.0E+10_dp, 1.0E+10_dp, 2.0E+10_dp, 1.0E+10_dp, &
                                                     3.0E+10_dp, 1.0E+10_dp, 2.0E+10_dp, 4.0E+10_dp, 1.0E+10_dp, &
                                                     2.0E+10_dp, 5.0E+10_dp, 1.0E+10_dp, 2.0E+10_dp, 3.0E+10_dp, &
                                                     7.0E+10_dp, 1.0E+10_dp, 2.0E+10_dp, 5.0E+10_dp, 1.0E+11_dp, &
                                                     1.0E+11_dp, 2.0E+11_dp, 1.0E+11_dp, 2.0E+11_dp, 1.0E+11_dp, &
                                                     3.0E+11_dp, 1.0E+11_dp, 2.0E+11_dp, 4.0E+11_dp, 1.0E+11_dp, &
                                                     5.0E+11_dp, 1.0E+11_dp, 2.0E+11_dp, 3.0E+11_dp, 7.0E+11_dp, &
                                                     1.0E+11_dp, 2.0E+11_dp, 3.0E+11_dp, 5.0E+11_dp, 1.0E+12_dp, &
                                                     2.0E+08_dp, 3.0E+08_dp, 4.0E+08_dp, 5.0E+08_dp, 7.0E+08_dp, &
                                                     1.0E+09_dp, 2.0E+09_dp, 3.0E+09_dp, 4.0E+09_dp, 5.0E+09_dp, &
                                                     6.0E+09_dp, 7.0E+09_dp, 1.0E+10_dp, 2.0E+10_dp, 3.0E+10_dp, &
                                                     4.0E+10_dp, 5.0E+10_dp, 7.0E+10_dp, 1.0E+11_dp, 2.0E+11_dp, &
                                                     3.0E+11_dp, 4.0E+11_dp, 5.0E+11_dp, 7.0E+11_dp, 1.0E+12_dp, &
                                                     2.0E+12_dp, 1.0E+12_dp, 2.0E+12_dp, 1.0E+12_dp, 3.0E+12_dp, &
                                                     4.0E+11_dp, 1.0E+12_dp, 2.0E+12_dp, 3.0E+12_dp, 4.0E+12_dp]

   REAL(KIND=dp), PARAMETER, DIMENSION(n_approx) :: err_mm = &
                                                    [2.128E-02_dp, 4.358E-02_dp, 5.960E-02_dp, 7.075E-02_dp, 7.825E-02_dp, &
                                                     8.288E-02_dp, 8.516E-02_dp, 8.556E-02_dp, 8.556E-02_dp, 2.080E-04_dp, &
                                                     1.035E-03_dp, 2.191E-03_dp, 3.437E-03_dp, 4.659E-03_dp, 5.811E-03_dp, &
                                                     6.878E-03_dp, 7.857E-03_dp, 8.752E-03_dp, 1.448E-02_dp, 1.699E-02_dp, &
                                                     1.784E-02_dp, 1.785E-02_dp, 1.834E-06_dp, 2.223E-05_dp, 7.279E-05_dp, &
                                                     1.500E-04_dp, 2.463E-04_dp, 3.553E-04_dp, 4.718E-04_dp, 5.924E-04_dp, &
                                                     7.145E-04_dp, 1.819E-03_dp, 2.627E-03_dp, 3.215E-03_dp, 3.659E-03_dp, &
                                                     4.001E-03_dp, 4.271E-03_dp, 4.485E-03_dp, 4.655E-03_dp, 4.789E-03_dp, &
                                                     5.052E-03_dp, 1.542E-08_dp, 4.556E-07_dp, 2.311E-06_dp, 6.258E-06_dp, &
                                                     1.246E-05_dp, 2.079E-05_dp, 3.098E-05_dp, 4.273E-05_dp, 5.577E-05_dp, &
                                                     2.169E-04_dp, 3.795E-04_dp, 5.230E-04_dp, 6.469E-04_dp, 7.541E-04_dp, &
                                                     8.474E-04_dp, 9.293E-04_dp, 1.002E-03_dp, 1.066E-03_dp, 1.456E-03_dp, &
                                                     1.628E-03_dp, 1.695E-03_dp, 1.700E-03_dp, 1.261E-10_dp, 9.088E-09_dp, &
                                                     7.139E-08_dp, 2.543E-07_dp, 6.143E-07_dp, 1.185E-06_dp, 1.982E-06_dp, &
                                                     3.004E-06_dp, 4.243E-06_dp, 2.521E-05_dp, 5.336E-05_dp, 8.266E-05_dp, &
                                                     1.110E-04_dp, 1.377E-04_dp, 1.626E-04_dp, 1.858E-04_dp, 2.074E-04_dp, &
                                                     2.274E-04_dp, 3.707E-04_dp, 4.554E-04_dp, 5.117E-04_dp, 5.517E-04_dp, &
                                                     5.811E-04_dp, 6.031E-04_dp, 6.193E-04_dp, 6.309E-04_dp, 6.385E-04_dp, &
                                                     6.428E-04_dp, 1.012E-12_dp, 1.780E-10_dp, 2.167E-09_dp, 1.016E-08_dp, &
                                                     2.976E-08_dp, 6.643E-08_dp, 1.246E-07_dp, 2.076E-07_dp, 3.173E-07_dp, &
                                                     2.880E-06_dp, 7.379E-06_dp, 1.285E-05_dp, 1.872E-05_dp, 2.471E-05_dp, &
                                                     3.066E-05_dp, 3.648E-05_dp, 4.213E-05_dp, 4.760E-05_dp, 9.217E-05_dp, &
                                                     1.235E-04_dp, 1.467E-04_dp, 1.649E-04_dp, 1.795E-04_dp, 1.915E-04_dp, &
                                                     2.016E-04_dp, 2.102E-04_dp, 2.177E-04_dp, 2.570E-04_dp, 2.646E-04_dp, &
                                                     8.020E-15_dp, 3.444E-12_dp, 6.498E-11_dp, 4.007E-10_dp, 1.424E-09_dp, &
                                                     3.677E-09_dp, 7.741E-09_dp, 1.417E-08_dp, 2.344E-08_dp, 3.252E-07_dp, &
                                                     1.008E-06_dp, 1.973E-06_dp, 3.121E-06_dp, 4.382E-06_dp, 5.711E-06_dp, &
                                                     7.077E-06_dp, 8.458E-06_dp, 9.841E-06_dp, 2.261E-05_dp, 3.297E-05_dp, &
                                                     4.141E-05_dp, 4.842E-05_dp, 5.438E-05_dp, 5.952E-05_dp, 6.401E-05_dp, &
                                                     6.799E-05_dp, 7.153E-05_dp, 9.365E-05_dp, 1.047E-04_dp, 1.110E-04_dp, &
                                                     1.146E-04_dp, 1.162E-04_dp, 1.163E-04_dp, 1.716E-09_dp, 3.640E-08_dp, &
                                                     1.365E-07_dp, 3.003E-07_dp, 5.155E-07_dp, 7.701E-07_dp, 1.054E-06_dp, &
                                                     1.361E-06_dp, 1.683E-06_dp, 2.016E-06_dp, 5.498E-06_dp, 8.724E-06_dp, &
                                                     1.157E-05_dp, 1.407E-05_dp, 1.829E-05_dp, 2.321E-05_dp, 3.341E-05_dp, &
                                                     3.926E-05_dp, 4.316E-05_dp, 4.596E-05_dp, 4.969E-05_dp, 5.271E-05_dp, &
                                                     5.392E-05_dp, 1.248E-10_dp, 4.045E-09_dp, 1.836E-08_dp, 4.539E-08_dp, &
                                                     8.456E-08_dp, 1.344E-07_dp, 1.933E-07_dp, 2.598E-07_dp, 3.325E-07_dp, &
                                                     4.103E-07_dp, 1.327E-06_dp, 2.292E-06_dp, 3.209E-06_dp, 4.061E-06_dp, &
                                                     5.577E-06_dp, 7.468E-06_dp, 1.180E-05_dp, 1.456E-05_dp, 1.654E-05_dp, &
                                                     1.804E-05_dp, 2.021E-05_dp, 2.232E-05_dp, 2.546E-05_dp, 2.611E-05_dp, &
                                                     9.021E-12_dp, 4.470E-10_dp, 2.456E-09_dp, 6.822E-09_dp, 1.380E-08_dp, &
                                                     2.333E-08_dp, 3.525E-08_dp, 4.932E-08_dp, 6.532E-08_dp, 8.303E-08_dp, &
                                                     3.186E-07_dp, 5.986E-07_dp, 8.850E-07_dp, 1.165E-06_dp, 1.691E-06_dp, &
                                                     2.389E-06_dp, 4.140E-06_dp, 5.360E-06_dp, 6.284E-06_dp, 7.020E-06_dp, &
                                                     8.137E-06_dp, 9.296E-06_dp, 1.133E-05_dp, 1.230E-05_dp, 1.307E-05_dp, &
                                                     1.312E-05_dp, 6.492E-13_dp, 4.918E-11_dp, 3.270E-10_dp, 1.021E-09_dp, &
                                                     2.241E-09_dp, 4.031E-09_dp, 6.398E-09_dp, 9.323E-09_dp, 1.278E-08_dp, &
                                                     1.673E-08_dp, 7.613E-08_dp, 1.557E-07_dp, 2.430E-07_dp, 3.326E-07_dp, &
                                                     5.101E-07_dp, 7.605E-07_dp, 1.445E-06_dp, 1.963E-06_dp, 2.375E-06_dp, &
                                                     2.715E-06_dp, 3.254E-06_dp, 3.844E-06_dp, 4.975E-06_dp, 5.583E-06_dp, &
                                                     6.242E-06_dp, 6.795E-06_dp, 6.807E-06_dp, 4.654E-14_dp, 5.389E-12_dp, &
                                                     4.337E-11_dp, 1.522E-10_dp, 3.625E-10_dp, 6.939E-10_dp, 1.157E-09_dp, &
                                                     1.756E-09_dp, 2.490E-09_dp, 3.357E-09_dp, 1.812E-08_dp, 4.032E-08_dp, &
                                                     6.645E-08_dp, 9.463E-08_dp, 1.533E-07_dp, 2.412E-07_dp, 5.025E-07_dp, &
                                                     7.157E-07_dp, 8.936E-07_dp, 1.046E-06_dp, 1.295E-06_dp, 1.582E-06_dp, &
                                                     2.171E-06_dp, 2.514E-06_dp, 2.920E-06_dp, 3.379E-06_dp, 3.630E-06_dp, &
                                                     3.630E-06_dp, 3.326E-15_dp, 5.888E-13_dp, 5.735E-12_dp, 2.262E-11_dp, &
                                                     5.847E-11_dp, 1.191E-10_dp, 2.085E-10_dp, 3.295E-10_dp, 4.836E-10_dp, &
                                                     6.716E-10_dp, 4.301E-09_dp, 1.041E-08_dp, 1.812E-08_dp, 2.683E-08_dp, &
                                                     4.594E-08_dp, 7.623E-08_dp, 1.741E-07_dp, 2.601E-07_dp, 3.351E-07_dp, &
                                                     4.013E-07_dp, 5.138E-07_dp, 6.481E-07_dp, 9.429E-07_dp, 1.127E-06_dp, &
                                                     1.357E-06_dp, 1.646E-06_dp, 1.877E-06_dp, 1.966E-06_dp, 1.984E-06_dp, &
                                                     2.371E-16_dp, 6.414E-14_dp, 7.562E-13_dp, 3.352E-12_dp, 9.405E-12_dp, &
                                                     2.038E-11_dp, 3.749E-11_dp, 6.169E-11_dp, 9.369E-11_dp, 1.340E-10_dp, &
                                                     1.018E-09_dp, 2.681E-09_dp, 4.926E-09_dp, 7.587E-09_dp, 1.372E-08_dp, &
                                                     2.403E-08_dp, 6.017E-08_dp, 9.426E-08_dp, 1.253E-07_dp, 1.536E-07_dp, &
                                                     2.032E-07_dp, 2.648E-07_dp, 4.081E-07_dp, 5.029E-07_dp, 6.283E-07_dp, &
                                                     7.973E-07_dp, 9.491E-07_dp, 1.023E-06_dp, 1.066E-06_dp, 1.092E-06_dp, &
                                                     1.108E-06_dp, 1.708E-17_dp, 6.972E-15_dp, 9.947E-14_dp, 4.956E-13_dp, &
                                                     1.509E-12_dp, 3.479E-12_dp, 6.723E-12_dp, 1.152E-11_dp, 1.811E-11_dp, &
                                                     2.667E-11_dp, 2.403E-10_dp, 6.888E-10_dp, 1.336E-09_dp, 2.140E-09_dp, &
                                                     3.067E-09_dp, 4.091E-09_dp, 5.190E-09_dp, 6.349E-09_dp, 7.555E-09_dp, &
                                                     2.074E-08_dp, 3.407E-08_dp, 4.673E-08_dp, 5.861E-08_dp, 6.972E-08_dp, &
                                                     8.014E-08_dp, 8.993E-08_dp, 9.917E-08_dp, 1.079E-07_dp, 1.762E-07_dp, &
                                                     2.238E-07_dp, 2.604E-07_dp, 2.898E-07_dp, 3.356E-07_dp, 3.847E-07_dp, &
                                                     4.770E-07_dp, 5.797E-07_dp, 6.280E-07_dp, 6.311E-07_dp, 5.136E-18_dp, &
                                                     7.562E-16_dp, 1.306E-14_dp, 7.312E-14_dp, 2.417E-13_dp, 5.927E-13_dp, &
                                                     1.203E-12_dp, 2.147E-12_dp, 3.492E-12_dp, 5.298E-12_dp, 5.663E-11_dp, &
                                                     1.766E-10_dp, 3.616E-10_dp, 6.025E-10_dp, 8.902E-10_dp, 1.217E-09_dp, &
                                                     1.576E-09_dp, 1.962E-09_dp, 2.371E-09_dp, 7.134E-09_dp, 1.229E-08_dp, &
                                                     1.739E-08_dp, 2.232E-08_dp, 2.704E-08_dp, 3.154E-08_dp, 3.584E-08_dp, &
                                                     3.995E-08_dp, 4.388E-08_dp, 7.587E-08_dp, 9.939E-08_dp, 1.180E-07_dp, &
                                                     1.334E-07_dp, 1.579E-07_dp, 1.850E-07_dp, 2.389E-07_dp, 3.048E-07_dp, &
                                                     3.445E-07_dp, 3.658E-07_dp, 3.659E-07_dp, 8.202E-17_dp, 1.711E-15_dp, &
                                                     1.077E-14_dp, 3.863E-14_dp, 1.008E-13_dp, 2.150E-13_dp, 4.004E-13_dp, &
                                                     6.723E-13_dp, 1.050E-12_dp, 1.332E-11_dp, 4.519E-11_dp, 9.771E-11_dp, &
                                                     1.693E-10_dp, 2.579E-10_dp, 3.613E-10_dp, 4.776E-10_dp, 6.052E-10_dp, &
                                                     7.426E-10_dp, 2.450E-09_dp, 4.425E-09_dp, 6.461E-09_dp, 8.484E-09_dp, &
                                                     1.046E-08_dp, 1.239E-08_dp, 1.425E-08_dp, 1.606E-08_dp, 1.780E-08_dp, &
                                                     3.261E-08_dp, 4.404E-08_dp, 5.336E-08_dp, 6.124E-08_dp, 7.409E-08_dp, &
                                                     8.877E-08_dp, 1.193E-07_dp, 1.597E-07_dp, 1.867E-07_dp, 2.076E-07_dp, &
                                                     2.148E-07_dp, 2.155E-07_dp, 1.584E-15_dp, 6.165E-15_dp, 1.711E-14_dp, &
                                                     3.834E-14_dp, 7.420E-14_dp, 1.292E-13_dp, 2.079E-13_dp, 3.128E-12_dp, &
                                                     1.155E-11_dp, 2.636E-11_dp, 4.750E-11_dp, 7.459E-11_dp, 1.071E-10_dp, &
                                                     1.445E-10_dp, 1.864E-10_dp, 2.322E-10_dp, 8.396E-10_dp, 1.590E-09_dp, &
                                                     2.396E-09_dp, 3.220E-09_dp, 4.043E-09_dp, 4.858E-09_dp, 5.659E-09_dp, &
                                                     6.445E-09_dp, 7.213E-09_dp, 1.399E-08_dp, 1.948E-08_dp, 2.409E-08_dp, &
                                                     2.807E-08_dp, 3.471E-08_dp, 4.251E-08_dp, 5.942E-08_dp, 8.339E-08_dp, &
                                                     1.007E-07_dp, 1.157E-07_dp, 1.227E-07_dp, 1.265E-07_dp, 1.284E-07_dp, &
                                                     1.289E-07_dp, 9.826E-16_dp, 2.902E-15_dp, 6.829E-15_dp, 1.376E-14_dp, &
                                                     2.480E-14_dp, 4.110E-14_dp, 7.333E-13_dp, 2.946E-12_dp, 7.099E-12_dp, &
                                                     1.331E-11_dp, 2.154E-11_dp, 3.170E-11_dp, 4.367E-11_dp, 5.732E-11_dp, &
                                                     7.251E-11_dp, 2.874E-10_dp, 5.708E-10_dp, 8.873E-10_dp, 1.220E-09_dp, &
                                                     1.560E-09_dp, 1.902E-09_dp, 2.244E-09_dp, 2.582E-09_dp, 2.918E-09_dp, &
                                                     5.993E-09_dp, 8.602E-09_dp, 1.086E-08_dp, 1.284E-08_dp, 1.623E-08_dp, &
                                                     2.032E-08_dp, 2.955E-08_dp, 4.346E-08_dp, 5.421E-08_dp, 6.415E-08_dp, &
                                                     6.923E-08_dp, 7.240E-08_dp, 7.454E-08_dp, 7.706E-08_dp, 7.811E-08_dp, &
                                                     4.914E-16_dp, 1.215E-15_dp, 2.549E-15_dp, 4.754E-15_dp, 8.114E-15_dp, &
                                                     1.717E-13_dp, 7.507E-13_dp, 1.910E-12_dp, 3.723E-12_dp, 6.213E-12_dp, &
                                                     9.371E-12_dp, 1.318E-11_dp, 1.760E-11_dp, 2.261E-11_dp, 9.824E-11_dp, &
                                                     2.046E-10_dp, 3.281E-10_dp, 4.617E-10_dp, 6.011E-10_dp, 7.438E-10_dp, &
                                                     8.883E-10_dp, 1.033E-09_dp, 1.179E-09_dp, 2.564E-09_dp, 3.793E-09_dp, &
                                                     4.886E-09_dp, 5.868E-09_dp, 7.580E-09_dp, 9.700E-09_dp, 1.467E-08_dp, &
                                                     2.260E-08_dp, 2.911E-08_dp, 3.548E-08_dp, 3.893E-08_dp, 4.118E-08_dp, &
                                                     4.279E-08_dp, 4.495E-08_dp, 4.679E-08_dp, 4.794E-08_dp, 9.103E-16_dp, &
                                                     1.600E-15_dp, 4.017E-14_dp, 1.910E-13_dp, 5.132E-13_dp, 1.040E-12_dp, &
                                                     1.790E-12_dp, 2.767E-12_dp, 3.972E-12_dp, 5.400E-12_dp, 7.044E-12_dp, &
                                                     3.354E-11_dp, 7.325E-11_dp, 1.212E-10_dp, 1.745E-10_dp, 2.313E-10_dp, &
                                                     2.905E-10_dp, 3.513E-10_dp, 4.131E-10_dp, 4.755E-10_dp, 1.095E-09_dp, &
                                                     1.671E-09_dp, 2.196E-09_dp, 2.678E-09_dp, 3.535E-09_dp, 4.624E-09_dp, &
                                                     7.274E-09_dp, 1.174E-08_dp, 1.560E-08_dp, 1.958E-08_dp, 2.184E-08_dp, &
                                                     2.336E-08_dp, 2.448E-08_dp, 2.605E-08_dp, 2.752E-08_dp, 2.955E-08_dp, &
                                                     2.976E-08_dp, 3.153E-16_dp, 9.385E-15_dp, 4.857E-14_dp, 1.377E-13_dp, &
                                                     2.905E-13_dp, 8.162E-13_dp, 2.192E-12_dp, 1.144E-11_dp, 2.620E-11_dp, &
                                                     4.472E-11_dp, 6.588E-11_dp, 1.133E-10_dp, 1.916E-10_dp, 4.674E-10_dp, &
                                                     7.350E-10_dp, 9.860E-10_dp, 1.221E-09_dp, 1.647E-09_dp, 2.201E-09_dp, &
                                                     3.602E-09_dp, 4.619E-09_dp, 5.422E-09_dp, 6.089E-09_dp, 7.155E-09_dp, &
                                                     8.351E-09_dp, 1.079E-08_dp, 1.223E-08_dp, 1.322E-08_dp, 1.397E-08_dp, &
                                                     1.505E-08_dp, 1.611E-08_dp, 1.780E-08_dp, 1.848E-08_dp, 1.868E-08_dp, &
                                                     2.191E-15_dp, 1.234E-14_dp, 3.693E-14_dp, 8.101E-14_dp, 2.405E-13_dp, &
                                                     6.813E-13_dp, 3.898E-12_dp, 9.359E-12_dp, 1.648E-11_dp, 2.485E-11_dp, &
                                                     4.417E-11_dp, 7.715E-11_dp, 1.993E-10_dp, 3.230E-10_dp, 4.422E-10_dp, &
                                                     5.557E-10_dp, 7.663E-10_dp, 1.047E-09_dp, 1.782E-09_dp, 2.334E-09_dp, &
                                                     2.779E-09_dp, 3.154E-09_dp, 3.765E-09_dp, 4.464E-09_dp, 5.936E-09_dp, &
                                                     6.834E-09_dp, 7.471E-09_dp, 7.960E-09_dp, 8.679E-09_dp, 9.404E-09_dp, &
                                                     1.065E-08_dp, 1.124E-08_dp, 1.157E-08_dp, 1.176E-08_dp, 1.185E-08_dp, &
                                                     5.111E-16_dp, 3.131E-15_dp, 9.895E-15_dp, 2.278E-14_dp, 7.080E-14_dp, &
                                                     2.116E-13_dp, 1.327E-12_dp, 3.341E-12_dp, 6.071E-12_dp, 9.364E-12_dp, &
                                                     1.720E-11_dp, 3.103E-11_dp, 8.488E-11_dp, 1.418E-10_dp, 1.981E-10_dp, &
                                                     2.528E-10_dp, 3.562E-10_dp, 4.975E-10_dp, 8.804E-10_dp, 1.178E-09_dp, &
                                                     1.423E-09_dp, 1.632E-09_dp, 1.979E-09_dp, 2.384E-09_dp, 3.262E-09_dp, &
                                                     3.815E-09_dp, 4.216E-09_dp, 4.528E-09_dp, 4.997E-09_dp, 5.481E-09_dp, &
                                                     6.349E-09_dp, 6.791E-09_dp, 7.067E-09_dp, 7.254E-09_dp, 7.478E-09_dp, &
                                                     7.583E-09_dp, 1.192E-16_dp, 7.939E-16_dp, 2.649E-15_dp, 6.284E-15_dp, &
                                                     2.083E-14_dp, 6.566E-14_dp, 4.514E-13_dp, 1.192E-12_dp, 2.234E-12_dp, &
                                                     3.526E-12_dp, 5.023E-12_dp, 6.692E-12_dp, 8.504E-12_dp, 1.044E-11_dp, &
                                                     1.247E-11_dp, 3.612E-11_dp, 1.149E-10_dp, 2.362E-10_dp, 4.347E-10_dp, &
                                                     8.439E-10_dp, 1.272E-09_dp, 1.791E-09_dp, 2.573E-09_dp, 3.190E-09_dp, &
                                                     4.444E-09_dp, 4.802E-09_dp, 4.898E-09_dp, 7.087E-16_dp, 1.749E-15_dp, &
                                                     3.501E-15_dp, 6.122E-15_dp, 9.739E-15_dp, 1.446E-14_dp, 2.036E-14_dp, &
                                                     1.534E-13_dp, 4.246E-13_dp, 8.214E-13_dp, 1.327E-12_dp, 1.924E-12_dp, &
                                                     2.602E-12_dp, 3.347E-12_dp, 4.152E-12_dp, 5.009E-12_dp, 1.536E-11_dp, &
                                                     2.727E-11_dp, 3.968E-11_dp, 5.218E-11_dp, 6.458E-11_dp, 7.679E-11_dp, &
                                                     8.879E-11_dp, 1.005E-10_dp, 1.120E-10_dp, 2.144E-10_dp, 2.992E-10_dp, &
                                                     3.719E-10_dp, 4.359E-10_dp, 5.451E-10_dp, 6.777E-10_dp, 9.820E-10_dp, &
                                                     1.185E-09_dp, 1.338E-09_dp, 1.460E-09_dp, 1.650E-09_dp, 1.854E-09_dp, &
                                                     2.246E-09_dp, 2.464E-09_dp, 2.609E-09_dp, 2.715E-09_dp, 2.863E-09_dp, &
                                                     2.999E-09_dp, 3.179E-09_dp, 3.190E-09_dp, 2.010E-12_dp, 6.528E-12_dp, &
                                                     1.195E-11_dp, 1.774E-11_dp, 2.368E-11_dp, 2.966E-11_dp, 3.561E-11_dp, &
                                                     4.152E-11_dp, 4.735E-11_dp, 5.310E-11_dp, 1.057E-10_dp, 1.506E-10_dp, &
                                                     1.899E-10_dp, 2.250E-10_dp, 2.567E-10_dp, 2.858E-10_dp, 3.126E-10_dp, &
                                                     3.375E-10_dp, 3.609E-10_dp, 5.381E-10_dp, 6.595E-10_dp, 7.525E-10_dp, &
                                                     8.280E-10_dp, 8.916E-10_dp, 9.465E-10_dp, 9.947E-10_dp, 1.038E-09_dp, &
                                                     1.076E-09_dp, 1.333E-09_dp, 1.480E-09_dp, 1.581E-09_dp, 1.656E-09_dp, &
                                                     1.763E-09_dp, 1.866E-09_dp, 2.028E-09_dp, 2.086E-09_dp, 2.094E-09_dp, &
                                                     1.159E-09_dp, 1.284E-09_dp, 1.341E-09_dp, 1.371E-09_dp, 1.385E-09_dp, &
                                                     9.203E-10_dp, 9.227E-10_dp, 6.020E-10_dp, 6.162E-10_dp, 6.188E-10_dp, &
                                                     3.912E-10_dp, 4.053E-10_dp, 4.177E-10_dp, 2.536E-10_dp, 2.651E-10_dp, &
                                                     2.814E-10_dp, 2.837E-10_dp, 1.642E-10_dp, 1.730E-10_dp, 1.870E-10_dp, &
                                                     1.925E-10_dp, 1.938E-10_dp, 1.062E-10_dp, 1.128E-10_dp, 1.238E-10_dp, &
                                                     1.289E-10_dp, 1.316E-10_dp, 1.329E-10_dp, 1.331E-10_dp, 6.860E-11_dp, &
                                                     7.343E-11_dp, 8.181E-11_dp, 8.593E-11_dp, 9.004E-11_dp, 9.194E-11_dp, &
                                                     6.365E-11_dp, 6.382E-11_dp, 4.353E-11_dp, 4.452E-11_dp, 2.962E-11_dp, &
                                                     3.121E-11_dp, 2.011E-11_dp, 2.147E-11_dp, 2.197E-11_dp, 1.364E-11_dp, &
                                                     1.476E-11_dp, 1.554E-11_dp, 9.246E-12_dp, 1.013E-11_dp, 1.055E-11_dp, &
                                                     1.104E-11_dp, 6.262E-12_dp, 6.943E-12_dp, 7.635E-12_dp, 7.869E-12_dp, &
                                                     5.591E-12_dp, 5.633E-12_dp, 3.938E-12_dp, 4.047E-12_dp, 2.766E-12_dp, &
                                                     2.919E-12_dp, 1.940E-12_dp, 2.063E-12_dp, 2.113E-12_dp, 1.360E-12_dp, &
                                                     1.534E-12_dp, 9.524E-13_dp, 1.035E-12_dp, 1.074E-12_dp, 1.118E-12_dp, &
                                                     6.667E-13_dp, 7.317E-13_dp, 7.639E-13_dp, 7.969E-13_dp, 8.172E-13_dp, &
                                                     4.429E-14_dp, 5.718E-14_dp, 6.780E-14_dp, 7.692E-14_dp, 9.218E-14_dp, &
                                                     1.103E-13_dp, 1.515E-13_dp, 1.790E-13_dp, 1.998E-13_dp, 2.167E-13_dp, &
                                                     2.309E-13_dp, 2.432E-13_dp, 2.724E-13_dp, 3.314E-13_dp, 3.911E-13_dp, &
                                                     3.911E-13_dp, 4.100E-13_dp, 4.380E-13_dp, 4.664E-13_dp, 5.171E-13_dp, &
                                                     5.430E-13_dp, 5.594E-13_dp, 5.708E-13_dp, 5.855E-13_dp, 5.983E-13_dp, &
                                                     5.992E-13_dp, 4.321E-13_dp, 4.407E-13_dp, 3.120E-13_dp, 3.251E-13_dp, &
                                                     2.025E-13_dp, 2.251E-13_dp, 2.371E-13_dp, 2.405E-13_dp, 2.405E-13_dp]

CONTAINS

! **************************************************************************************************
!> \brief ...
!> \param i ...
!> \param aw ...
! **************************************************************************************************
   SUBROUTINE get_minimax_coeff_low(i, aw)
      INTEGER, INTENT(IN)                                :: i
      REAL(KIND=dp), DIMENSION(k_mm(i)*2), INTENT(OUT)   :: aw

      SELECT CASE (i)

      CASE (1)

         aw(:) = & ! a
            [0.7151291879699049_dp, &
             ! w
             2.000945890508967_dp]

      CASE (2)

         aw(:) = & ! a
            [0.5970833669667293_dp, &
             ! w
             1.737635742582102_dp]

      CASE (3)

         aw(:) = & ! a
            [0.5323920576673996_dp, &
             ! w
             1.601503072363919_dp]

      CASE (4)

         aw(:) = & ! a
            [0.49316306690405565_dp, &
             ! w
             1.5216296303352121_dp]

      CASE (5)

         aw(:) = & ! a
            [0.4688474749950737_dp, &
             ! w
             1.4730921650589592_dp]

      CASE (6)

         aw(:) = & ! a
            [0.4545496122972507_dp, &
             ! w
             1.4448869123259267_dp]

      CASE (7)

         aw(:) = & ! a
            [0.4476963168465264_dp, &
             ! w
             1.4314535341251469_dp]

      CASE (8)

         aw(:) = & ! a
            [0.44649260629880866_dp, &
             ! w
             1.429099786979271_dp]

      CASE (9)

         aw(:) = & ! a
            [0.4464926062994778_dp, &
             ! w
             1.4290997869805788_dp]

      CASE (10)

         aw(:) = & ! a
            [0.4072692399097063_dp, 2.4428035233716465_dp, &
             ! w
             1.0724401884999553_dp, 3.2918896543848644_dp]

      CASE (11)

         aw(:) = & ! a
            [0.32451524499523515_dp, 2.035129346922339_dp, &
             ! w
             0.8627352798623843_dp, 2.8723614320211905_dp]

      CASE (12)

         aw(:) = & ! a
            [0.2748454853769434_dp, 1.8026054538227607_dp, &
             ! w
             0.7381177111390874_dp, 2.6510075653784217_dp]

      CASE (13)

         aw(:) = & ! a
            [0.2412189720039558_dp, 1.6503932424456509_dp, &
             ! w
             0.654413821579126_dp, 2.5128880395953934_dp]

      CASE (14)

         aw(:) = & ! a
            [0.21677626323385438_dp, 1.5424317633410847_dp, &
             ! w
             0.5939961099849468_dp, 2.417973551456907_dp]

      CASE (15)

         aw(:) = & ! a
            [0.19814373071471802_dp, 1.461666823401535_dp, &
             ! w
             0.5482353429308007_dp, 2.348496068608947_dp]

      CASE (16)

         aw(:) = & ! a
            [0.18344320998999283_dp, 1.3988865294263442_dp, &
             ! w
             0.5123441656997128_dp, 2.2953108404122684_dp]

      CASE (17)

         aw(:) = & ! a
            [0.17153706461006926_dp, 1.3486468789878938_dp, &
             ! w
             0.4834323382159764_dp, 2.2532140530550535_dp]

      CASE (18)

         aw(:) = & ! a
            [0.16169273989379984_dp, 1.307514133065234_dp, &
             ! w
             0.4596450781301019_dp, 2.2190206174604987_dp]

      CASE (19)

         aw(:) = & ! a
            [0.11377055334818492_dp, 1.112242083226372_dp, &
             ! w
             0.34568839455577144_dp, 2.0588931989746815_dp]

      CASE (20)

         aw(:) = & ! a
            [0.09798314302456711_dp, 1.0494466863388991_dp, &
             ! w
             0.30892698728560847_dp, 2.00757054644027_dp]

      CASE (21)

         aw(:) = & ! a
            [0.09318559554449489_dp, 1.0304678137783845_dp, &
             ! w
             0.297838783224004_dp, 1.9920021768207374_dp]

      CASE (22)

         aw(:) = & ! a
            [0.09310617256883674_dp, 1.0301539335400713_dp, &
             ! w
             0.2976555432327633_dp, 1.9917443679019897_dp]

      CASE (23)

         aw(:) = & ! a
            [0.2874933084171688_dp, 1.6046370491507347_dp, 4.506486437639924_dp, &
             ! w
             0.7470594125158281_dp, 1.9588903206974837_dp, 4.161788370499587_dp]

      CASE (24)

         aw(:) = & ! a
            [0.22719994406103003_dp, 1.290960582912292_dp, 3.7605449827660413_dp, &
             ! w
             0.5926726335139195_dp, 1.6100816777502402_dp, 3.6515813642302706_dp]

      CASE (25)

         aw(:) = & ! a
            [0.190820901834524_dp, 1.1043195988478427_dp, 3.334024351088452_dp, &
             ! w
             0.49973085683672597_dp, 1.4071850340285912_dp, 3.383430297960359_dp]

      CASE (26)

         aw(:) = & ! a
            [0.16607313750141492_dp, 0.9784372085453776_dp, 3.0530159808682455_dp, &
             ! w
             0.4365792105033684_dp, 1.2723305210744182_dp, 3.2151540832501007_dp]

      CASE (27)

         aw(:) = & ! a
            [0.14797546872033812_dp, 0.8869636853585635_dp, 2.851850660065598_dp, &
             ! w
             0.39043661216740244_dp, 1.1753669469725918_dp, 3.0981972422591575_dp]

      CASE (28)

         aw(:) = & ! a
            [0.13407826516448915_dp, 0.8170825513653607_dp, 2.699682964801345_dp, &
             ! w
             0.35503082305979605_dp, 1.1018792658187146_dp, 3.011330116355922_dp]

      CASE (29)

         aw(:) = & ! a
            [0.12302217745120096_dp, 0.7617320987617905_dp, 2.579950751689479_dp, &
             ! w
             0.32688491641152817_dp, 1.0440277074411328_dp, 2.943745649391346_dp]

      CASE (30)

         aw(:) = & ! a
            [0.11398687647296017_dp, 0.716672821402158_dp, 2.4829070960193653_dp, &
             ! w
             0.30390175304476086_dp, 0.9971555180958862_dp, 2.8893365676093965_dp]

      CASE (31)

         aw(:) = & ! a
            [0.10644554843011034_dp, 0.6791933646735415_dp, 2.402416310116676_dp, &
             ! w
             0.2847348675836868_dp, 0.9583115118002355_dp, 2.844377225487889_dp]

      CASE (32)

         aw(:) = & ! a
            [0.06790136894058926_dp, 0.4897948875089661_dp, 1.996201580919574_dp, &
             ! w
             0.18718659453518208_dp, 0.7633857188437595_dp, 2.6169711142660255_dp]

      CASE (33)

         aw(:) = & ! a
            [0.0526373510053126_dp, 0.4159550868841871_dp, 1.835980917898024_dp, &
             ! w
             0.14893502807079687_dp, 0.6872993149781067_dp, 2.5251745372914685_dp]

      CASE (34)

         aw(:) = & ! a
            [0.044324908247723685_dp, 0.3760267128377693_dp, 1.7481061682069727_dp, &
             ! w
             0.1282763604743763_dp, 0.6457800255491173_dp, 2.4737466774457357_dp]

      CASE (35)

         aw(:) = & ! a
            [0.039082098432306915_dp, 0.3509230683778315_dp, 1.6921947262166477_dp, &
             ! w
             0.11533107566965783_dp, 0.6194232578183114_dp, 2.440503632678777_dp]

      CASE (36)

         aw(:) = & ! a
            [0.03548785756339287_dp, 0.33373310920779525_dp, 1.6535367452293752_dp, &
             ! w
             0.1065007940761847_dp, 0.6012169550303839_dp, 2.417244683821898_dp]

      CASE (37)

         aw(:) = & ! a
            [0.0328950169895425_dp, 0.32133337767322623_dp, 1.6254323321274151_dp, &
             ! w
             0.10015530773686102_dp, 0.5879845498502224_dp, 2.4001809699912178_dp]

      CASE (38)

         aw(:) = & ! a
            [0.030966040572607583_dp, 0.3121038074526534_dp, 1.6043802276101924_dp, &
             ! w
             0.09544856149463261_dp, 0.5780719785823824_dp, 2.3873083432732534_dp]

      CASE (39)

         aw(:) = & ! a
            [0.029508058669578938_dp, 0.3051223245003003_dp, 1.5883739921280895_dp, &
             ! w
             0.09189920985752194_dp, 0.5705336658200345_dp, 2.3774665399131085_dp]

      CASE (40)

         aw(:) = & ! a
            [0.02840380481995328_dp, 0.29983005709471117_dp, 1.57619075925612_dp, &
             ! w
             0.08921570790896699_dp, 0.5647942501087851_dp, 2.369942817167733_dp]

      CASE (41)

         aw(:) = & ! a
            [0.026349272848143715_dp, 0.28996855484815137_dp, 1.553366185278856_dp, &
             ! w
             0.0842336964653582_dp, 0.554036433153334_dp, 2.355768842922469_dp]

      CASE (42)

         aw(:) = & ! a
            [0.22252821013426086_dp, 1.2118271769428668_dp, 3.187481792030648_dp, &
             6.739887374833184_dp, &
             ! w
             0.5753086924118194_dp, 1.4324382751398494_dp, 2.601504267946919_dp, &
             4.837282274455988_dp]

      CASE (43)

         aw(:) = & ! a
            [0.17527105138036778_dp, 0.9635165380263817_dp, 2.5825322433881674_dp, &
             5.633585403420891_dp, &
             ! w
             0.45408560693614775_dp, 1.1521496451107505_dp, 2.170818682065073_dp, &
             4.2622256210860705_dp]

      CASE (44)

         aw(:) = & ! a
            [0.14671950647800755_dp, 0.8142596432786335_dp, 2.2245993655671508_dp, &
             5.000745372447783_dp, &
             ! w
             0.38090986643822805_dp, 0.98502848337898_dp, 1.9245224600485114_dp, &
             3.961347573512278_dp]

      CASE (45)

         aw(:) = & ! a
            [0.1272851568278456_dp, 0.7128840158683422_dp, 1.9837003473579684_dp, &
             4.582740315117001_dp, &
             ! w
             0.33111140294414865_dp, 0.8719992880247881_dp, 1.7621447067201108_dp, &
             3.7722154835897865_dp]

      CASE (46)

         aw(:) = & ! a
            [0.11306686288605404_dp, 0.6387959915512463_dp, 1.8086875076613338_dp, &
             4.282405371555544_dp, &
             ! w
             0.2946777813201027_dp, 0.78961356147058_dp, 1.645743241597089_dp, &
             3.640143062267599_dp]

      CASE (47)

         aw(:) = & ! a
            [0.10214418415560887_dp, 0.5819143686208856_dp, 1.6748643119314177_dp, &
             4.054266665255846_dp, &
             ! w
             0.26668604228316484_dp, 0.7264788634360871_dp, 1.5575123311575398_dp, &
             3.541449719416932_dp]

      CASE (48)

         aw(:) = & ! a
            [0.09345102611264643_dp, 0.5366603519779132_dp, 1.5686956963951062_dp, &
             3.8739609091686398_dp, &
             ! w
             0.24440500260960255_dp, 0.6763200419930573_dp, 1.4879051296978405_dp, &
             3.464152056212784_dp]

      CASE (49)

         aw(:) = & ! a
            [0.08634379244020035_dp, 0.4996723020499699_dp, 1.4820860449391133_dp, &
             3.727163003860314_dp, &
             ! w
             0.2261863808727144_dp, 0.6353676827863498_dp, 1.4313117857432134_dp, &
             3.4014990384232084_dp]

      CASE (50)

         aw(:) = & ! a
            [0.08040902441555287_dp, 0.46879309466888663_dp, 1.409871537871361_dp, &
             3.6048552773416724_dp, &
             ! w
             0.21097144230678308_dp, 0.6012085214120437_dp, 1.3842061450697847_dp, &
             3.3493765842990433_dp]

      CASE (51)

         aw(:) = & ! a
            [0.04996987754589871_dp, 0.3105631707014664_dp, 1.0398249107852826_dp, &
             2.9750469432139246_dp, &
             ! w
             0.13291800704161472_dp, 0.42649085342514365_dp, 1.1416477627542354_dp, &
             3.078067534660662_dp]

      CASE (52)

         aw(:) = & ! a
            [0.03774937905247896_dp, 0.24717316890019844_dp, 0.8901553582336263_dp, &
             2.7154179633949425_dp, &
             ! w
             0.1016013598614176_dp, 0.35645000765859947_dp, 1.0408682232432722_dp, &
             2.962067059993243_dp]

      CASE (53)

         aw(:) = & ! a
            [0.030971882763324972_dp, 0.21207745700491543_dp, 0.806200001127913_dp, &
             2.567223570690613_dp, &
             ! w
             0.0842613451067412_dp, 0.3175083683168244_dp, 0.9827580985120555_dp, &
             2.8938728508266505_dp]

      CASE (54)

         aw(:) = & ! a
            [0.026607943720184272_dp, 0.1895065774790961_dp, 0.7515202985781508_dp, &
             2.469348057181892_dp, &
             ! w
             0.0731190495973734_dp, 0.29232694965731365_dp, 0.9440309351700997_dp, &
             2.8478366618531807_dp]

      CASE (55)

         aw(:) = & ! a
            [0.023541991865702758_dp, 0.17366047680464378_dp, 0.7126891672717475_dp, &
             2.399053964746976_dp, &
             ! w
             0.0653078213757229_dp, 0.2745449432568481_dp, 0.9160037860065624_dp, &
             2.8142148838640844_dp]

      CASE (56)

         aw(:) = & ! a
            [0.021260416555732336_dp, 0.16187242115691308_dp, 0.6835043049845141_dp, &
             2.3457307234433387_dp, &
             ! w
             0.059507528591388775_dp, 0.261239936416624_dp, 0.894605770150256_dp, &
             2.7883700207922746_dp]

      CASE (57)

         aw(:) = & ! a
            [0.019491643253607_dp, 0.1527342674760213_dp, 0.6606717166460769_dp, &
             2.3036894119803124_dp, &
             ! w
             0.055020249665865696_dp, 0.25086805101326054_dp, 0.877642602016386_dp, &
             2.7677729356352665_dp]

      CASE (58)

         aw(:) = & ! a
            [0.018077782916019164_dp, 0.14542839561841847_dp, 0.6422668197625268_dp, &
             2.2695770442654135_dp, &
             ! w
             0.051440413450525975_dp, 0.24253168056726374_dp, 0.8638140458215766_dp, &
             2.750910552833004_dp]

      CASE (59)

         aw(:) = & ! a
            [0.016920441215969285_dp, 0.13944586119810226_dp, 0.6270840649394218_dp, &
             2.241276902218253_dp, &
             ! w
             0.04851544830010834_dp, 0.23567104569970013_dp, 0.8522950664164703_dp, &
             2.736815432948413_dp]

      CASE (60)

         aw(:) = & ! a
            [0.011401253796233394_dp, 0.1108289024285984_dp, 0.5527015496667355_dp, &
             2.1002718748225484_dp, &
             ! w
             0.034652854429156214_dp, 0.20226202325315296_dp, 0.7941993308902318_dp, &
             2.6650476801253453_dp]

      CASE (61)

         aw(:) = & ! a
            [0.009566774796103916_dp, 0.10123798051872637_dp, 0.5269302725083039_dp, &
             2.050377006102403_dp, &
             ! w
             0.030084225422181535_dp, 0.1907535375929733_dp, 0.7733295903723639_dp, &
             2.6389901708906205_dp]

      CASE (62)

         aw(:) = & ! a
            [0.00891495849661671_dp, 0.09781044366597424_dp, 0.5175885566543471_dp, &
             2.032141359098191_dp, &
             ! w
             0.0284661205929678_dp, 0.18658781633705007_dp, 0.7656572669069769_dp, &
             2.6293741631156147_dp]

      CASE (63)

         aw(:) = & ! a
            [0.008868536794666326_dp, 0.09756583502709744_dp, 0.5169189990170088_dp, &
             2.0308311260118175_dp, &
             ! w
             0.028350982414551848_dp, 0.18628933861057068_dp, 0.7651050730792038_dp, &
             2.6286812528458148_dp]

      CASE (64)

         aw(:) = & ! a
            [0.18161223444789812_dp, 0.9776830415195706_dp, 2.5060472629612187_dp, &
             4.995923809435138_dp, 9.078298047219704_dp, &
             ! w
             0.4683556115061091_dp, 1.1387420740801897_dp, 1.95318188970844_dp, &
             3.1153038431409947_dp, 5.397941851023563_dp]

      CASE (65)

         aw(:) = & ! a
            [0.1427866528332531_dp, 0.7731653372376538_dp, 2.0043671769709315_dp, &
             4.06918816955637_dp, 7.599088437689025_dp, &
             ! w
             0.36871557779169384_dp, 0.9070179518196302_dp, 1.5911924263942965_dp, &
             2.6280030891313686_dp, 4.771668084689307_dp]

      CASE (66)

         aw(:) = & ! a
            [0.1193145236895995_dp, 0.6498239284000503_dp, 1.7039690954687403_dp, &
             3.5232332927125776_dp, 6.75309425511802_dp, &
             ! w
             0.3085046174714676_dp, 0.7677830644995077_dp, 1.377717871730129_dp, &
             2.3531329292269723_dp, 4.445303796640638_dp]

      CASE (67)

         aw(:) = & ! a
            [0.10333512117595546_dp, 0.5658998554798739_dp, 1.500259486444618_dp, &
             3.156388982390542_dp, 6.193584172208591_dp, &
             ! w
             0.2675144938257101_dp, 0.6731648185410648_dp, 1.2341495375414908_dp, &
             2.173074998760648_dp, 4.240049104595772_dp]

      CASE (68)

         aw(:) = & ! a
            [0.09164442849128951_dp, 0.5044896950537755_dp, 1.3514626526197429_dp, &
             2.8899298640154387_dp, 5.790782426391747_dp, &
             ! w
             0.23752137119510233_dp, 0.6039528783972736_dp, 1.1298096471277477_dp, &
             2.0442936920871437_dp, 4.096349191177988_dp]

      CASE (69)

         aw(:) = & ! a
            [0.08266403865575715_dp, 0.4572948614526955_dp, 1.2372195309898968_dp, &
             2.686051267949959_dp, 5.484100671224871_dp, &
             ! w
             0.2144769745022462_dp, 0.5507585162114406_dp, 1.04995382939453_dp, &
             1.9466601062734827_dp, 3.98859281695391_dp]

      CASE (70)

         aw(:) = & ! a
            [0.07551738726841437_dp, 0.41971519861212586_dp, 1.1462958376485461_dp, &
             2.524114942076429_dp, 5.241123104161658_dp, &
             ! w
             0.19613395743207157_dp, 0.5083904835637346_dp, 0.9865228049566487_dp, &
             1.8695023711995027_dp, 3.9038727784001863_dp]

      CASE (71)

         aw(:) = & ! a
            [0.06967518048938522_dp, 0.3889757291641015_dp, 1.0719353806517393_dp, &
             2.3918121851951577_dp, 5.042803535262377_dp, &
             ! w
             0.18113555675752338_dp, 0.4737218817910962_dp, 0.9347038834466117_dp, &
             1.8066027816920285_dp, 3.8349340375191976_dp]

      CASE (72)

         aw(:) = & ! a
            [0.06479731629497418_dp, 0.3632942397911341_dp, 1.009808499526931_dp, &
             2.2813077174805523_dp, 4.877153951942815_dp, &
             ! w
             0.16861003324210627_dp, 0.44474622263913965_dp, 0.8914300222454683_dp, &
             1.7540776690871602_dp, 3.777359367020908_dp]

      CASE (73)

         aw(:) = & ! a
            [0.03979103551863197_dp, 0.23131332253827694_dp, 0.6899245534043174_dp, &
             1.709843508205596_dp, 4.01492257681544_dp, &
             ! w
             0.10434198456045442_dp, 0.2955585665005043_dp, 0.6678313388646437_dp, &
             1.478881661645208_dp, 3.472870891680209_dp]

      CASE (74)

         aw(:) = & ! a
            [0.029757786779991018_dp, 0.17814645562861608_dp, 0.5601138852938733_dp, &
             1.4739028120126259_dp, 3.6519366545145373_dp, &
             ! w
             0.07852022967252373_dp, 0.2352291127246095_dp, 0.5755235459038333_dp, &
             1.36036132731287_dp, 3.3389033426820007_dp]

      CASE (75)

         aw(:) = & ! a
            [0.024190180350097283_dp, 0.14857337492633746_dp, 0.4872759750389151_dp, &
             1.339149099031898_dp, 3.4411575727997534_dp, &
             ! w
             0.06418148380506787_dp, 0.2015553177348804_dp, 0.5226910879403149_dp, &
             1.2901011954205592_dp, 3.258411518133752_dp]

      CASE (76)

         aw(:) = & ! a
            [0.02059851693641806_dp, 0.12946507144298772_dp, 0.439797239670509_dp, &
             1.2499372840249323_dp, 3.299772274458194_dp, &
             ! w
             0.054928968471960854_dp, 0.17972260846046623_dp, 0.48760926843571956_dp, &
             1.2421875649935035_dp, 3.2030368198904093_dp]

      CASE (77)

         aw(:) = & ! a
            [0.018067709913646333_dp, 0.11598435008616298_dp, 0.40601702895000163_dp, &
             1.1856093034676984_dp, 3.1967392715623495_dp, &
             ! w
             0.0484092394476768_dp, 0.16426671642208504_dp, 0.4622317543222329_dp, &
             1.2068045801673655_dp, 3.1618887677979015_dp]

      CASE (78)

         aw(:) = & ! a
            [0.016177447463648808_dp, 0.10590557466186795_dp, 0.38055858744901055_dp, &
             1.1365624686784197_dp, 3.1174919552876026_dp, &
             ! w
             0.04354046414237496_dp, 0.15267140778657548_dp, 0.4428218963958594_dp, &
             1.1792923812761709_dp, 3.129743372172042_dp]

      CASE (79)

         aw(:) = & ! a
            [0.014705949753103624_dp, 0.09805286816785048_dp, 0.3605733280656045_dp, &
             1.0976668403036145_dp, 3.0541811446566616_dp, &
             ! w
             0.03975143315365374_dp, 0.14360627651378796_dp, 0.42738350642551687_dp, &
             1.1571122334202288_dp, 3.1037318963686116_dp]

      CASE (80)

         aw(:) = & ! a
            [0.013524447064889847_dp, 0.09174282146012296_dp, 0.3444004900958718_dp, &
             1.0659073186356656_dp, 3.0021576019667893_dp, &
             ! w
             0.03671031159339888_dp, 0.1362975085252603_dp, 0.41474261404916296_dp, &
             1.1387451937085928_dp, 3.0821271502266367_dp]

      CASE (81)

         aw(:) = & ! a
            [0.01255272754046799_dp, 0.08654939487728926_dp, 0.33100124293713873_dp, &
             1.0393832416814095_dp, 2.9584699518773347_dp, &
             ! w
             0.03421030348746315_dp, 0.1302622960820673_dp, 0.404158415645879_dp, &
             1.1232181675451096_dp, 3.0638169728620763_dp]

      CASE (82)

         aw(:) = & ! a
            [0.0077919805414365445_dp, 0.061030287502729146_dp, 0.26354517613629047_dp, &
             0.9023059551184773_dp, 2.7287535886135674_dp, &
             ! w
             0.021992413199290763_dp, 0.10020642248192244_dp, 0.34896373518542456_dp, &
             1.0398862719837947_dp, 2.9648211490348504_dp]

      CASE (83)

         aw(:) = & ! a
            [0.006003383449447628_dp, 0.051381028213895265_dp, 0.2369999919944957_dp, &
             0.846323438825162_dp, 2.6327559231103215_dp, &
             ! w
             0.01742823123743174_dp, 0.08855164468272898_dp, 0.32612062131196123_dp, &
             1.004141456348347_dp, 2.9219747649465218_dp]

      CASE (84)

         aw(:) = & ! a
            [0.005055044709474687_dp, 0.04623422613950649_dp, 0.2224845241613079_dp, &
             0.8150922595119978_dp, 2.578567083457729_dp, &
             ! w
             0.01501876146021437_dp, 0.08222284510376696_dp, 0.31328309235675417_dp, &
             0.9837032818773332_dp, 2.897369577036015_dp]

      CASE (85)

         aw(:) = & ! a
            [0.004470091020653244_dp, 0.043042233518954816_dp, 0.21332569755781333_dp, &
             0.7951322401352172_dp, 2.543679303681629_dp, &
             ! w
             0.013537186918918044_dp, 0.07824517136303201_dp, 0.30503984426641567_dp, &
             0.9704412982176837_dp, 2.88136144708144_dp]

      CASE (86)

         aw(:) = & ! a
            [0.004079351161198711_dp, 0.04089971785147186_dp, 0.20710038537556108_dp, &
             0.7814442554474885_dp, 2.5196339666338297_dp, &
             ! w
             0.012549702236901892_dp, 0.07554802779982046_dp, 0.29936846535124767_dp, &
             0.9612526221486811_dp, 2.870250216273631_dp]

      CASE (87)

         aw(:) = & ! a
            [0.0038074691411251675_dp, 0.039402728467349026_dp, 0.202709695765557_dp, &
             0.7717281393047815_dp, 2.5025046733436875_dp, &
             ! w
             0.011863663762419518_dp, 0.07364871574594964_dp, 0.29533335962239976_dp, &
             0.9546824601007418_dp, 2.8622952932595034_dp]

      CASE (88)

         aw(:) = & ! a
            [0.0036161175535254345_dp, 0.038345504980682704_dp, 0.1995869766812679_dp, &
             0.7647855301606952_dp, 2.4902332388884396_dp, &
             ! w
             0.011381349717183978_dp, 0.07229930785193518_dp, 0.2924451938945003_dp, &
             0.949963002876562_dp, 2.856575920404516_dp]

      CASE (89)

         aw(:) = & ! a
            [0.0034843237838238315_dp, 0.0376153534981393_dp, 0.19741919379317616_dp, &
             0.7599497569265251_dp, 2.481669850578368_dp, &
             ! w
             0.011049399698694484_dp, 0.07136320544570081_dp, 0.2904310341712172_dp, &
             0.9466633544503644_dp, 2.8525745409845267_dp]

      CASE (90)

         aw(:) = & ! a
            [0.0034004600489073895_dp, 0.037149816796615_dp, 0.19603210903786736_dp, &
             0.7568483876518314_dp, 2.476170832968167_dp, &
             ! w
             0.01083827265702328_dp, 0.07076449780867321_dp, 0.2891382091047488_dp, &
             0.9445417262916082_dp, 2.8500005633404064_dp]

      CASE (91)

         aw(:) = & ! a
            [0.0033529112764591387_dp, 0.03688552380863027_dp, 0.1952428895765193_dp, &
             0.7550812995393414_dp, 2.4730352459564653_dp, &
             ! w
             0.010718601062497496_dp, 0.07042393570386862_dp, 0.28840120533084923_dp, &
             0.9433310104981166_dp, 2.8485313369244247_dp]

      CASE (92)

         aw(:) = & ! a
            [0.15344232732696164_dp, 0.8208030144142543_dp, 2.076326637759574_dp, &
             4.037544944825249_dp, 6.9549672561485965_dp, 11.489101449975879_dp, &
             ! w
             0.3951503586666183_dp, 0.9483584803953559_dp, 1.5813287669193052_dp, &
             2.3797403876283134_dp, 3.548133935573261_dp, 5.8817260741536765_dp]

      CASE (93)

         aw(:) = & ! a
            [0.12050409838853515_dp, 0.6471706374763834_dp, 1.649502383645565_dp, &
             3.2457669505020714_dp, 5.688110896918401_dp, 9.628826117919456_dp, &
             ! w
             0.31060826041851003_dp, 0.7514093561343357_dp, 1.272007612541384_dp, &
             1.9595162535981736_dp, 3.01771994304632_dp, 5.212640690904524_dp]

      CASE (94)

         aw(:) = & ! a
            [0.10058381094183846_dp, 0.5423052006448188_dp, 1.39268940689611_dp, &
             2.773384987559996_dp, 4.944377020913284_dp, 8.56530729992123_dp, &
             ! w
             0.259492533708378_dp, 0.6326994281541639_dp, 1.0873449642129085_dp, &
             1.714381139255248_dp, 2.721852627098835_dp, 4.865160915450924_dp]

      CASE (95)

         aw(:) = & ! a
            [0.08702163406475558_dp, 0.47091367520479227_dp, 1.2180676458000685_dp, &
             2.4535517473926842_dp, 4.445294940570353_dp, 7.861429581448342_dp, &
             ! w
             0.22469037674868492_dp, 0.5519095844142892_dp, 0.9622019394266136_dp, &
             1.5504627855961601_dp, 2.5290208569930264_dp, 4.646614158574707_dp]

      CASE (96)

         aw(:) = & ! a
            [0.07709989750137178_dp, 0.41866258611030904_dp, 1.0902916798550335_dp, &
             2.220067742808422_dp, 4.082849994717455_dp, 7.3540700896552895_dp, &
             ! w
             0.19922622623379935_dp, 0.49276258797330597_dp, 0.8707649507441914_dp, &
             1.431682309041832_dp, 2.391339554164293_dp, 4.493362869549154_dp]

      CASE (97)

         aw(:) = & ! a
            [0.06947912297479582_dp, 0.3785036647871915_dp, 0.9920629035718725_dp, &
             2.0408032638639466_dp, 3.8053977452053824_dp, 6.967212719012414_dp, &
             ! w
             0.17966376455572852_dp, 0.447278321906676_dp, 0.8005082241463485_dp, &
             1.3408813762157024_dp, 2.2869350476400565_dp, 4.378184574358267_dp]

      CASE (98)

         aw(:) = & ! a
            [0.06341523419030931_dp, 0.34652627576455186_dp, 0.9138093905878505_dp, &
             1.8980781549742471_dp, 3.5848315846970733_dp, 6.6602309134426045_dp, &
             ! w
             0.16409461040061746_dp, 0.41103624081412404_dp, 0.7445371549477633_dp, &
             1.268755832367187_dp, 2.2043138776461757_dp, 4.287402567458178_dp]

      CASE (99)

         aw(:) = & ! a
            [0.0584588699633234_dp, 0.3203701144935931_dp, 0.849763287841353_dp, &
             1.7812813101063347_dp, 3.40442656718486_dp, 6.409267895239723_dp, &
             ! w
             0.1513663895024808_dp, 0.38137058330649815_dp, 0.6987115135433852_dp, &
             1.2097848806132692_dp, 2.1368239386439773_dp, 4.213342398454894_dp]

      CASE (100)

         aw(:) = & ! a
            [0.05432125985000594_dp, 0.2985187647358117_dp, 0.7962225930216239_dp, &
             1.683622952477423_dp, 3.2535534765211933_dp, 6.199310760184936_dp, &
             ! w
             0.1407385838051434_dp, 0.356569420068569_dp, 0.6603802616738013_dp, &
             1.1604682915072342_dp, 2.0803301182531366_dp, 4.1513349861478135_dp]

      CASE (101)

         aw(:) = & ! a
            [0.033125384072048854_dp, 0.18624531899278388_dp, 0.5202262124793207_dp, &
             1.1783399761432671_dp, 2.468203283261333_dp, 5.09898230836826_dp, &
             ! w
             0.08624967411800354_dp, 0.228755231383876_dp, 0.4619231653435139_dp, &
             0.9029137915898263_dp, 1.7807264424526321_dp, 3.8200570280772443_dp]

      CASE (102)

         aw(:) = & ! a
            [0.02463386018680619_dp, 0.14102557634568977_dp, 0.4082545329312478_dp, &
             0.970749927523341_dp, 2.1393343031375327_dp, 4.629695544074457_dp, &
             ! w
             0.06438753922607744_dp, 0.17699255332037328_dp, 0.3803989314000022_dp, &
             0.7936758834219183_dp, 1.6486087888192316_dp, 3.671677753256644_dp]

      CASE (103)

         aw(:) = & ! a
            [0.019927292158899282_dp, 0.11586876096539546_dp, 0.345547325025503_dp, &
             0.8529186964399603_dp, 1.949300779528476_dp, 4.35439826891279_dp, &
             ! w
             0.05225747423429781_dp, 0.14807969939302706_dp, 0.3341395292959525_dp, &
             0.7296921875931182_dp, 1.5689274489411984_dp, 3.5813517206284184_dp]

      CASE (104)

         aw(:) = & ! a
            [0.016893837552218283_dp, 0.09960917776823842_dp, 0.3047652371799654_dp, &
             0.7753183769485388_dp, 1.8222505520282237_dp, 4.1681458423137245_dp, &
             ! w
             0.044433418238675776_dp, 0.12933083480399385_dp, 0.30367117547648526_dp, &
             0.6863985328086_dp, 1.513850308723576_dp, 3.5185424210031164_dp]

      CASE (105)

         aw(:) = & ! a
            [0.014757794449453762_dp, 0.08813396805017469_dp, 0.2758135968716969_dp, &
             0.7195968816061252_dp, 1.7298527418488276_dp, 4.031389035577503_dp, &
             ! w
             0.03892075392146144_dp, 0.11606060550997924_dp, 0.2817827958041293_dp, &
             0.6545864705958214_dp, 1.4727168297337245_dp, 3.4714354715327134_dp]

      CASE (106)

         aw(:) = & ! a
            [0.013163067275079546_dp, 0.0795507056312876_dp, 0.25403700481526015_dp, &
             0.677249443803188_dp, 1.6588625672007167_dp, 3.925479637456699_dp, &
             ! w
             0.034803217566193485_dp, 0.10610858572603164_dp, 0.2651359722976122_dp, &
             0.6299268945664218_dp, 1.4404181621079915_dp, 3.434327679345151_dp]

      CASE (107)

         aw(:) = & ! a
            [0.011921868297062481_dp, 0.07285946900570793_dp, 0.23697015769013335_dp, &
             0.6437479496493271_dp, 1.6021676951562196_dp, 3.84032618251257_dp, &
             ! w
             0.031597334451890974_dp, 0.09833125045975417_dp, 0.25195493890390575_dp, &
             0.6100807113831754_dp, 1.4141485422756008_dp, 3.404069746353219_dp]

      CASE (108)

         aw(:) = & ! a
            [0.010925238490803518_dp, 0.0674791066323321_dp, 0.22317706781392338_dp, &
             0.6164401736272703_dp, 1.55556859114024_dp, 3.7699289128884463_dp, &
             ! w
             0.02902243561550214_dp, 0.09206299625144375_dp, 0.24120038626341075_dp, &
             0.5936581793011397_dp, 1.392217727402881_dp, 3.378756504485369_dp]

      CASE (109)

         aw(:) = & ! a
            [0.010105361344629787_dp, 0.06304737930382137_dp, 0.21176070087633833_dp, &
             0.5936601207247773_dp, 1.51640746079713_dp, 3.7104671222364463_dp, &
             ! w
             0.026903750347277787_dp, 0.08688840346469896_dp, 0.23221984689982497_dp, &
             0.5797744666263794_dp, 1.3735366550622796_dp, 3.357156154496523_dp]

      CASE (110)

         aw(:) = & ! a
            [0.006074556160583506_dp, 0.04116568929465924_dp, 0.15431499997262116_dp, &
             0.47583402653062223_dp, 1.3088413484383163_dp, 3.3901114378459396_dp, &
             ! w
             0.016484631406817916_dp, 0.06110676281193284_dp, 0.18555599341475487_dp, &
             0.5047457845186151_dp, 1.2702004011589922_dp, 3.237028368952973_dp]

      CASE (111)

         aw(:) = & ! a
            [0.0045403772662585915_dp, 0.032777244620163834_dp, 0.1315230758019218_dp, &
             0.4270458936595013_dp, 1.2198581690530463_dp, 3.2496928841682373_dp, &
             ! w
             0.012522087399164902_dp, 0.051044965137218956_dp, 0.16606657745371223_dp, &
             0.4717249694785839_dp, 1.2233401903869243_dp, 3.182181287962263_dp]

      CASE (112)

         aw(:) = & ! a
            [0.0037126126629825553_dp, 0.028227596539976623_dp, 0.11885555456344414_dp, &
             0.3992215234884477_dp, 1.168114174117086_dp, 3.1670518413818134_dp, &
             ! w
             0.010387584330417182_dp, 0.045509430030571195_dp, 0.15488496346531724_dp, &
             0.4522533544737275_dp, 1.1952746785512347_dp, 3.149214520189165_dp]

      CASE (113)

         aw(:) = & ! a
            [0.0031893814523236115_dp, 0.025338999611455863_dp, 0.11066043250792441_dp, &
             0.3808951402331244_dp, 1.1335878719950365_dp, 3.111472453208487_dp, &
             ! w
             0.009040751564373343_dp, 0.0419530265693815_dp, 0.14748815509853327_dp, &
             0.43914352406806945_dp, 1.1761879348950757_dp, 3.126742024435687_dp]

      CASE (114)

         aw(:) = & ! a
            [0.0028268458406437787_dp, 0.023329602254469856_dp, 0.10487319183563992_dp, &
             0.3677786713597671_dp, 1.108641964111255_dp, 3.0710862053749617_dp, &
             ! w
             0.00810913855401357_dp, 0.03945410196052096_dp, 0.1421765733804508_dp, &
             0.42961079747665915_dp, 1.1622091695018335_dp, 3.1102558315953166_dp]

      CASE (115)

         aw(:) = & ! a
            [0.0025601001960133666_dp, 0.021845744822363813_dp, 0.10054616021655595_dp, &
             0.35786818283376687_dp, 1.0896558648067596_dp, 3.040214954555503_dp, &
             ! w
             0.007424732308214915_dp, 0.037592711108251284_dp, 0.1381527530049599_dp, &
             0.42232059870164745_dp, 1.151460470160175_dp, 3.097562766245219_dp]

      CASE (116)

         aw(:) = & ! a
            [0.0023553678339827302_dp, 0.02070300562775958_dp, 0.0971788429385239_dp, &
             0.3500900854010226_dp, 1.0746683097025738_dp, 3.0157614053961606_dp, &
             ! w
             0.006900154654307798_dp, 0.03614838297117291_dp, 0.13498801054740742_dp, &
             0.41654403926734435_dp, 1.1429068035001628_dp, 3.087451474766092_dp]

      CASE (117)

         aw(:) = & ! a
            [0.0021932677980895975_dp, 0.01979537163607368_dp, 0.09448030910814234_dp, &
             0.3438129085859722_dp, 1.062515385363092_dp, 2.9958772123567106_dp, &
             ! w
             0.006485309446126698_dp, 0.034993586030055_dp, 0.13242947055069354_dp, &
             0.4118457658248257_dp, 1.135925466915433_dp, 3.0791919318758856_dp]

      CASE (118)

         aw(:) = & ! a
            [0.0020618552752413614_dp, 0.019057395573237303_dp, 0.09226917084160827_dp, &
             0.3386390121450569_dp, 1.0524587572217026_dp, 2.979384587274735_dp, &
             ! w
             0.0061493505796972655_dp, 0.03404912883205661_dp, 0.13031750436562978_dp, &
             0.4079481557970085_dp, 1.1301170634334539_dp, 3.0723153218216233_dp]

      CASE (119)

         aw(:) = & ! a
            [0.0014764458510144259_dp, 0.015736804651964958_dp, 0.08209752558374095_dp, &
             0.31445243244806775_dp, 1.0049446929502894_dp, 2.90097660575702_dp, &
             ! w
             0.0046569405523143575_dp, 0.029724286090695502_dp, 0.12040494837441577_dp, &
             0.389411597615533_dp, 1.1022784500339817_dp, 3.0392951653690305_dp]

      CASE (120)

         aw(:) = & ! a
            [0.00138020194524145_dp, 0.015183614381572768_dp, 0.08036151185525324_dp, &
             0.310255608632774_dp, 0.9966114862688712_dp, 2.887139653946674_dp, &
             ! w
             0.004412235352657983_dp, 0.028989220321940696_dp, 0.11867791139299246_dp, &
             0.38613951254853507_dp, 1.0973265611814316_dp, 3.033410611192584_dp]

      CASE (121)

         aw(:) = & ! a
            [0.1328537955998788_dp, 0.7079130219116617_dp, 1.7769359317465696_dp, &
             3.4093982762602817_dp, 5.73641479371703_dp, 9.022775927136047_dp, &
             13.953318359742749_dp, &
             ! w
             0.34183027419014206_dp, 0.8139373975876502_dp, 1.3352973461439932_dp, &
             1.9505008993945934_dp, 2.744440392392776_dp, 3.9247848246178934_dp, &
             6.309956840322047_dp]

      CASE (122)

         aw(:) = & ! a
            [0.1042559111992259_dp, 0.5571299562861916_dp, 1.4060269600791764_dp, &
             2.720266979333603_dp, 4.631373848989341_dp, 7.4035412706077315_dp, &
             11.706208031960966_dp, &
             ! w
             0.2684261108739403_dp, 0.6428494301097513_dp, 1.0661026045730193_dp, &
             1.5833307838749986_dp, 2.279828399460775_dp, 3.3594350485176023_dp, &
             5.603774368653575_dp]

      CASE (123)

         aw(:) = & ! a
            [0.08695630513426755_dp, 0.46599558018018294_dp, 1.1823447473116389_dp, &
             2.3066801208193026_dp, 3.9742794392437286_dp, 6.455652812958656_dp, &
             10.422112499317336_dp, &
             ! w
             0.22402959509378434_dp, 0.5395688431206702_dp, 0.9044919147174741_dp, &
             1.3657443364559092_dp, 2.01152465270939_dp, 3.0469664839439665_dp, &
             5.238102296673424_dp]

      CASE (124)

         aw(:) = & ! a
            [0.07517801205393558_dp, 0.40394057377108084_dp, 1.0300953839123785_dp, &
             2.0257208844822334_dp, 3.5300416178849785_dp, 5.8202600945046035_dp, &
             9.571879302298791_dp, &
             ! w
             0.19380100796794852_dp, 0.4692435586300529_dp, 0.7946376596686956_dp, &
             1.2188241997775222_dp, 1.8330663504453952_dp, 2.844141721918306_dp, &
             5.0081428000286365_dp]

      CASE (125)

         aw(:) = & ! a
            [0.06656176398587473_dp, 0.35852406376155277_dp, 0.9186334445646663_dp, &
             1.820181207842435_dp, 3.205920829057035_dp, 5.35889789623272_dp, &
             8.958513851633413_dp, &
             ! w
             0.17168478698145412_dp, 0.4177512782833647_dp, 0.7142178763847493_dp, &
             1.1116696392634222_dp, 1.7040902635819437_dp, 2.6995153646546877_dp, &
             4.846714032397592_dp]

      CASE (126)

         aw(:) = & ! a
            [0.05994431184969806_dp, 0.3236222394928578_dp, 0.8329240783297642_dp, &
             1.6621487568152902_dp, 2.9570712920382243_dp, 5.005596919496737_dp, &
             8.490350769144383_dp, &
             ! w
             0.15469632923142762_dp, 0.3781553650192849_dp, 0.6523457119440436_dp, &
             1.0293972455516656_dp, 1.605588731877836_dp, 2.5898198883040795_dp, &
             4.725197806343358_dp]

      CASE (127)

         aw(:) = & ! a
            [0.05467935470040509_dp, 0.2958355411939927_dp, 0.7646359311879659_dp, &
             1.536208458069161_dp, 2.7588796360606658_dp, 4.724545136307037_dp, &
             8.118442969694092_dp, &
             ! w
             0.14117768906298914_dp, 0.3466092767684028_dp, 0.603008829024842_dp, &
             0.9638568128475085_dp, 1.5273335779508246_dp, 2.502917653016165_dp, &
             4.629251753453269_dp]

      CASE (128)

         aw(:) = & ! a
            [0.05037653168752645_dp, 0.27311145827271915_dp, 0.7087438967352819_dp, &
             1.4330831595065083_dp, 2.596601846366239_dp, 4.494470571023396_dp, &
             7.814060433661144_dp, &
             ! w
             0.1301275574325502_dp, 0.3207919173372999_dp, 0.5625882013965461_dp, &
             0.910172757571702_dp, 1.4632925602129687_dp, 2.431819911650354_dp, &
             4.550838356843569_dp]

      CASE (129)

         aw(:) = & ! a
            [0.04678497191969506_dp, 0.2541310917703071_dp, 0.6620206366128168_dp, &
             1.3468236945914096_dp, 2.4608175652259985_dp, 4.301871868914413_dp, &
             7.559127174440305_dp, &
             ! w
             0.12090244093952099_dp, 0.2992121471107249_dp, 0.5287623608132956_dp, &
             0.8652325406126139_dp, 1.4096599453909606_dp, 2.372198230000475_dp, &
             4.4850705608595405_dp]

      CASE (130)

         aw(:) = & ! a
            [0.02839787501935781_dp, 0.15669465451979245_dp, 0.4212835366409848_dp, &
             0.9007103394850067_dp, 1.7551920884002583_dp, 3.2943879648814645_dp, &
             6.216752116933116_dp, &
             ! w
             0.07364094379374109_dp, 0.1880960775887743_dp, 0.3535856122925518_dp, &
             0.6310263698265569_dp, 1.1268723268357688_dp, 2.0532076958089367_dp, &
             4.131214614090865_dp]

      CASE (131)

         aw(:) = & ! a
            [0.02104159749657532_dp, 0.11751591067464534_dp, 0.3237851994719232_dp, &
             0.7182511074334368_dp, 1.4622083631638707_dp, 2.868129060797868_dp, &
             5.639128283714038_dp, &
             ! w
             0.05470812366039994_dp, 0.14316733618034405_dp, 0.2818519061350474_dp, &
             0.5330147207850684_dp, 1.0042678371684879_dp, 1.9102105077080431_dp, &
             3.97078392780554_dp]

      CASE (132)

         aw(:) = & ! a
            [0.01696894434764736_dp, 0.09574540214390341_dp, 0.2692943329972381_dp, &
             0.6152724295093569_dp, 1.2943422432026803_dp, 2.6197801492130472_dp, &
             5.297964533423825_dp, &
             ! w
             0.04421634439751523_dp, 0.11809953230597657_dp, 0.24136520239356096_dp, &
             0.47639520405533553_dp, 0.9312065231173353_dp, 1.8229592256705782_dp, &
             3.8722630501939475_dp]

      CASE (133)

         aw(:) = & ! a
            [0.01434661695411904_dp, 0.08168663696512406_dp, 0.23392918256659598_dp, &
             0.547817369616115_dp, 1.18289671872084_dp, 2.452604838409686_dp, &
             5.065840953958105_dp, &
             ! w
             0.037455686176677_dp, 0.10185840534484672_dp, 0.21485110258922235_dp, &
             0.43851262496240967_dp, 0.8811012601672848_dp, 1.7621025260651733_dp, &
             3.8032676122312763_dp]

      CASE (134)

         aw(:) = & ! a
            [0.012501624790553638_dp, 0.07177123210528669_dp, 0.20887384143197713_dp, &
             0.4996135480465156_dp, 1.1023091213725187_dp, 2.3303116968910063_dp, &
             4.894562576543979_dp, &
             ! w
             0.03269607742097257_dp, 0.09037208740586535_dp, 0.19590828145261074_dp, &
             0.4109239117501715_dp, 0.8438800600320582_dp, 1.7163114229596177_dp, &
             3.751205173302536_dp]

      CASE (135)

         aw(:) = & ! a
            [0.011125203816029645_dp, 0.06435860149721041_dp, 0.1900644749502538_dp, &
             0.46313529471763043_dp, 1.0406826317548055_dp, 2.2358669464308134_dp, &
             4.761334307488529_dp, &
             ! w
             0.029143346494564064_dp, 0.08176423354275007_dp, 0.18157540048038484_dp, &
             0.3896901972802879_dp, 0.8147620352906384_dp, 1.6801229596135674_dp, &
             3.7099722173278535_dp]

      CASE (136)

         aw(:) = & ! a
            [0.010054615399715751_dp, 0.05858247648365217_dp, 0.17535029502975125_dp, &
             0.43438561313685364_dp, 0.991657281318819_dp, 2.1600909301499334_dp, &
             4.65378692704619_dp, &
             ! w
             0.02637871732005645_dp, 0.07504215090863822_dp, 0.17027978818667666_dp, &
             0.37269963545122914_dp, 0.7911419754631662_dp, 1.6505212211957283_dp, &
             3.6761865418821604_dp]

      CASE (137)

         aw(:) = & ! a
            [0.009195480405483587_dp, 0.05393966047189065_dp, 0.16347931911580282_dp, &
             0.4110293908202165_dp, 0.9514935033869456_dp, 2.097545864519508_dp, &
             4.564548258392167_dp, &
             ! w
             0.024159221705021952_dp, 0.06962821946939234_dp, 0.16110291618092115_dp, &
             0.35870654013259184_dp, 0.7714604530426776_dp, 1.6256811668432707_dp, &
             3.647795593113763_dp]

      CASE (138)

         aw(:) = & ! a
            [0.008489082134020809_dp, 0.05011664201496171_dp, 0.15366998285929265_dp, &
             0.3916035531845051_dp, 0.9178336466850517_dp, 2.0447798621093103_dp, &
             4.488912743216377_dp, &
             ! w
             0.022333642551176373_dp, 0.06516201073040385_dp, 0.15346948447776387_dp, &
             0.3469229620284128_dp, 0.754717937038961_dp, 1.604422129926041_dp, &
             3.6234684847661183_dp]

      CASE (139)

         aw(:) = & ! a
            [0.005021341168426651_dp, 0.03125464109942908_dp, 0.10459702700841456_dp, &
             0.2920522758702768_dp, 0.7407504784499062_dp, 1.7609744335543205_dp, &
             4.075903696914512_dp, &
             ! w
             0.013361554718382558_dp, 0.04297284694243602_dp, 0.11430293990815156_dp, &
             0.28388812669341895_dp, 0.6622322841999484_dp, 1.4847175320092705_dp, &
             3.4859753729916254_dp]

      CASE (140)

         aw(:) = & ! a
            [0.003702129096267596_dp, 0.02402035633785203_dp, 0.08527629374441756_dp, &
             0.25124270854584935_dp, 0.6652246780099562_dp, 1.6360585970149728_dp, &
             3.8902964899531036_dp, &
             ! w
             0.009943477668559816_dp, 0.03435111065922189_dp, 0.09818698596300013_dp, &
             0.2563375496711153_dp, 0.6200522686047906_dp, 1.4287348681193341_dp, &
             3.4213578343787923_dp]

      CASE (141)

         aw(:) = & ! a
            [0.0029885877621226805_dp, 0.020086057792296826_dp, 0.07455690900558905_dp, &
             0.2279899926003867_dp, 0.6211585820580099_dp, 1.5618502570945418_dp, &
             3.778745593374526_dp, &
             ! w
             0.008093917805684206_dp, 0.02961377120275156_dp, 0.08897105543150366_dp, &
             0.24003462235871895_dp, 0.5945144839955654_dp, 1.3943733291175233_dp, &
             3.3815881302823882_dp]

      CASE (142)

         aw(:) = & ! a
            [0.002535797864365192_dp, 0.017578759091398184_dp, 0.06761316861077361_dp, &
             0.21262834171859676_dp, 0.5915602300563042_dp, 1.5113889410817196_dp, &
             3.7022956650360443_dp, &
             ! w
             0.006920304813525343_dp, 0.026567898179860355_dp, 0.08286374742528071_dp, &
             0.22897941405638794_dp, 0.576932442449835_dp, 1.370498834102023_dp, &
             3.3539045747733187_dp]

      CASE (143)

         aw(:) = & ! a
            [0.002220603088272845_dp, 0.015827051545107267_dp, 0.06269465031628192_dp, &
             0.20157811436912737_dp, 0.5700007444812679_dp, 1.4742950212653216_dp, &
             3.645772538526923_dp, &
             ! w
             0.006103579691650011_dp, 0.0244232192416007_dp, 0.07845898683705749_dp, &
             0.22087024192514393_dp, 0.5638921330027344_dp, 1.352672001922338_dp, &
             3.3332048728001094_dp]

      CASE (144)

         aw(:) = & ! a
            [0.001987459760689592_dp, 0.014527207706942338_dp, 0.05900120240242023_dp, &
             0.193175465285863_dp, 0.5534433535878025_dp, 1.4456024138634962_dp, &
             3.601854362338122_dp, &
             ! w
             0.005499733478671553_dp, 0.02282055828311453_dp, 0.07510209589065722_dp, &
             0.21460869698738236_dp, 0.5537362828757469_dp, 1.338715519022809_dp, &
             3.3169815640530342_dp]

      CASE (145)

         aw(:) = & ! a
            [0.0018074376308293873_dp, 0.013520634224809635_dp, 0.056111063613119946_dp, &
             0.1865310578633184_dp, 0.5402437912418699_dp, 1.4225951349686723_dp, &
             3.5665103665179134_dp, &
             ! w
             0.005033717325569482_dp, 0.02157155721867786_dp, 0.0724425268654194_dp, &
             0.20959525364169268_dp, 0.5455484720427803_dp, 1.3274159182138672_dp, &
             3.303834943091577_dp]

      CASE (146)

         aw(:) = & ! a
            [0.001663906158190309_dp, 0.012715963868680322_dp, 0.05377913143326573_dp, &
             0.1811218120543097_dp, 0.5294244944099309_dp, 1.4036450526560744_dp, &
             3.5373112546752496_dp, &
             ! w
             0.0046623733840567665_dp, 0.020567251935995977_dp, 0.07027373966039487_dp, &
             0.2054711368999697_dp, 0.5387744815015728_dp, 1.3180345908931348_dp, &
             3.2929120497385744_dp]

      CASE (147)

         aw(:) = & ! a
            [0.0015465907100920744_dp, 0.012056643172650844_dp, 0.05185248993325443_dp, &
             0.17661795467136937_dp, 0.5203635254756013_dp, 1.3877091798262136_dp, &
             3.5126938632453744_dp, &
             ! w
             0.0043590321081121135_dp, 0.019739937643250896_dp, 0.06846531409283038_dp, &
             0.20200683741399486_dp, 0.5330567089683809_dp, 1.3100924544159886_dp, &
             3.2836589740207804_dp]

      CASE (148)

         aw(:) = & ! a
            [0.0009839513388777788_dp, 0.008865469103519473_dp, 0.04226812138861273_dp, &
             0.15367245013063802_dp, 0.4733864179916387_dp, 1.304067249716343_dp, &
             3.382502968419956_dp, &
             ! w
             0.0029076880267603932_dp, 0.015659795689673513_dp, 0.05920955020430181_dp, &
             0.1838875600867601_dp, 0.5027200930136522_dp, 1.2675787498436362_dp, &
             3.2340325901955294_dp]

      CASE (149)

         aw(:) = & ! a
            [0.0007821171870305443_dp, 0.007701702998949635_dp, 0.03862942520670454_dp, &
             0.14468193071323893_dp, 0.4545657667811826_dp, 1.2700397189863826_dp, &
             3.329040949966218_dp, &
             ! w
             0.002389135991366753_dp, 0.014127070818368568_dp, 0.0555607731872177_dp, &
             0.1765507108276268_dp, 0.49021766809565676_dp, 1.2498655911588725_dp, &
             3.213306254204669_dp]

      CASE (150)

         aw(:) = & ! a
            [0.0006828418611695833_dp, 0.0071228279773048585_dp, 0.03678031908136637_dp, &
             0.14004272890256222_dp, 0.444751966020422_dp, 1.2521695310166052_dp, &
             3.30084297204394_dp, &
             ! w
             0.0021345887454745104_dp, 0.01335161150081422_dp, 0.05367243060786458_dp, &
             0.17270668365493763_dp, 0.48361359837566975_dp, 1.2404615898649594_dp, &
             3.202290193666039_dp]

      CASE (151)

         aw(:) = & ! a
            [0.0006308136329875133_dp, 0.006817140620478282_dp, 0.03579160751106932_dp, &
             0.13754098637797435_dp, 0.4394293305525137_dp, 1.2424396843361853_dp, &
             3.2854539018961137_dp, &
             ! w
             0.002001311088035267_dp, 0.012937890869550871_dp, 0.05265247259283306_dp, &
             0.1706164960435683_dp, 0.48000667433517574_dp, 1.2353112694406894_dp, &
             3.196253285166892_dp]

      CASE (152)

         aw(:) = & ! a
            [0.0006085749350024497_dp, 0.006685902159141663_dp, 0.03536430717421001_dp, &
             0.1364550050371723_dp, 0.4371119961322448_dp, 1.2381951172423498_dp, &
             3.278732451656292_dp, &
             ! w
             0.0019443655262837806_dp, 0.012759280727803383_dp, 0.05220935096523234_dp, &
             0.16970529863934425_dp, 0.4784306996286164_dp, 1.2330577486624195_dp, &
             3.193610952471498_dp]

      CASE (153)

         aw(:) = & ! a
            [0.0006068004605425494_dp, 0.006675414550308602_dp, 0.03533008531165831_dp, &
             0.1363679064445001_dp, 0.43692597185507065_dp, 1.2378541669818244_dp, &
             3.278192298140961_dp, &
             ! w
             0.001939822244031596_dp, 0.012744981074293062_dp, 0.052173800858709714_dp, &
             0.16963212116290538_dp, 0.47830405076036075_dp, 1.2328765453712285_dp, &
             3.193398415618935_dp]

      CASE (154)

         aw(:) = & ! a
            [0.041096167724934025_dp, 0.22159210039399246_dp, 0.5688643520073686_dp, &
             1.1299764765876945_dp, 1.9937655342879093_dp, 3.3208105201716793_dp, &
             5.409823121081442_dp, 8.948554779106718_dp, &
             ! w
             0.10602646910567383_dp, 0.25852905669687154_dp, 0.4435891050076718_dp, &
             0.6929754149010114_dp, 1.0604512558549937_dp, 1.6406263617959378_dp, &
             2.636487509406833_dp, 4.787520763764322_dp]

      CASE (155)

         aw(:) = & ! a
            [0.02486266414966956_dp, 0.13560482860785025_dp, 0.3561108775384803_dp, &
             0.7334936098496532_dp, 1.3603355122458833_dp, 2.4047037240593268_dp, &
             4.17436963925409_dp, 7.36122931342208_dp, &
             ! w
             0.06430916462238742_dp, 0.160465799927234_dp, 0.28808044473936617_dp, &
             0.48165041896975763_dp, 0.7991696608085076_dp, 1.3381266056699614_dp, &
             2.301417441287326_dp, 4.41406270779838_dp]

      CASE (156)

         aw(:) = & ! a
            [0.01837515238630235_dp, 0.10109103962531879_dp, 0.2701415651193927_dp, &
             0.5719241549530382_dp, 1.0991792961155158_dp, 2.020941274862189_dp, &
             3.647536911785666_dp, 6.673761667175686_dp, &
             ! w
             0.047619383133358346_dp, 0.1209066723887145_dp, 0.2245974893577788_dp, &
             0.39396856430486504_dp, 0.6878199173590028_dp, 1.2046845144004612_dp, &
             2.149404405565857_dp, 4.243245954411484_dp]

      CASE (157)

         aw(:) = & ! a
            [0.01478688449158526_dp, 0.08193908775465297_dp, 0.22218948449558504_dp, &
             0.4811176249313396_dp, 0.9506792305778743_dp, 1.7993973054918035_dp, &
             3.3386937535433483_dp, 6.265728126848089_dp, &
             ! w
             0.0383807437367189_dp, 0.09887277234911501_dp, 0.18889510206656607_dp, &
             0.34383252442421686_dp, 0.6224537875740375_dp, 1.1241351163372293_dp, &
             2.0558777824169634_dp, 4.137687467758895_dp]

      CASE (158)

         aw(:) = & ! a
            [0.012478362825083333_dp, 0.06958512369187221_dp, 0.1911241780349973_dp, &
             0.42187946175263485_dp, 0.8527570534377368_dp, 1.651381610017021_dp, &
             3.129749265706254_dp, 5.986990637663619_dp, &
             ! w
             0.03243314247535478_dp, 0.08461681524598316_dp, 0.16560014581798357_dp, &
             0.3106025687325339_dp, 0.57813757860161_dp, 1.0683503216704084_dp, &
             1.990224850235617_dp, 4.0633908158171135_dp]

      CASE (159)

         aw(:) = & ! a
            [0.010855351097420482_dp, 0.060880248851111846_dp, 0.1691520259232484_dp, &
             0.37971034141061927_dp, 0.7823660354159746_dp, 1.5437686299849278_dp, &
             2.9762479203500893_dp, 5.780606277045765_dp, &
             ! w
             0.02824933969172581_dp, 0.07454603913718215_dp, 0.1490178202155422_dp, &
             0.28660129449280364_dp, 0.545507820648827_dp, 1.026582992088914_dp, &
             1.9405634730900532_dp, 4.00708798269101_dp]

      CASE (160)

         aw(:) = & ! a
            [0.009645335139589121_dp, 0.0543778231378708_dp, 0.15268317853560984_dp, &
             0.34791260514597394_dp, 0.7288141658794776_dp, 1.4610854083998512_dp, &
             2.8572596946046263_dp, 5.61957954529671_dp, &
             ! w
             0.025128643705808987_dp, 0.06700649821821521_dp, 0.1365152448171116_dp, &
             0.26826059735147795_dp, 0.5201604752923397_dp, 0.9936935209922502_dp, &
             1.9011380241938254_dp, 3.962328550369193_dp]

      CASE (161)

         aw(:) = & ! a
            [0.008704741723334132_dp, 0.04931450289315343_dp, 0.1398190631110848_dp, &
             0.32293423980780295_dp, 0.6864049880172786_dp, 1.3950320723685947_dp, &
             2.7614744811077356_dp, 5.489232398769128_dp, &
             ! w
             0.02270175596341297_dp, 0.061123900907299696_dp, 0.12669535656869585_dp, &
             0.2536760883721414_dp, 0.49971581877262344_dp, 0.9668633389980442_dp, &
             1.8687591398468626_dp, 3.92552895170279_dp]

      CASE (162)

         aw(:) = & ! a
            [0.007950339699079541_dp, 0.0452471530544418_dp, 0.1294552708085345_dp, &
             0.30270343388656173_dp, 0.6518003973409469_dp, 1.3407130798147102_dp, &
             2.6821760146617595_dp, 5.380800620728163_dp, &
             ! w
             0.020754516169563704_dp, 0.05638989857987046_dp, 0.11874302529615148_dp, &
             0.2417297705831964_dp, 0.48275998370961964_dp, 0.9443959761885042_dp, &
             1.8414905485795192_dp, 3.8945094081684952_dp]

      CASE (163)

         aw(:) = & ! a
            [0.007330367889227327_dp, 0.041899841948996194_dp, 0.12090283062560349_dp, &
             0.2859242916917437_dp, 0.6229028130797221_dp, 1.2950331295281308_dp, &
             2.6150915210491834_dp, 5.288681179279969_dp, &
             ! w
             0.019153697215708195_dp, 0.052487499170134476_dp, 0.11214831768328601_dp, &
             0.23171781920936582_dp, 0.46839273666695513_dp, 0.9251988674368323_dp, &
             1.8180761380444024_dp, 3.8678537676116576_dp]

      CASE (164)

         aw(:) = & ! a
            [0.004292369050515735_dp, 0.025415422465390292_dp, 0.07833933625763832_dp, &
             0.20079259921259504_dp, 0.4726395102313897_dp, 1.0517208224751955_dp, &
             2.2505781328076893_dp, 4.781104701694306_dp, &
             ! w
             0.011299708072695298_dp, 0.03315384599330144_dp, 0.07869657572341132_dp, &
             0.1789636493609062_dp, 0.3899113717033012_dp, 0.8174921432572277_dp, &
             1.6846079041638187_dp, 3.715537026453917_dp]

      CASE (165)

         aw(:) = & ! a
            [0.003140000416042068_dp, 0.019110817347133886_dp, 0.06173604440993229_dp, &
             0.16642818361581635_dp, 0.4095542480247393_dp, 0.9458455055554492_dp, &
             2.08738342309079_dp, 4.549417092859298_dp, &
             ! w
             0.008314770073237271_dp, 0.02568102055845356_dp, 0.0651854465211138_dp, &
             0.15634108007807077_dp, 0.3545343631542286_dp, 0.7671776007943374_dp, &
             1.620923646350249_dp, 3.6426182431755443_dp]

      CASE (166)

         aw(:) = & ! a
            [0.002517652556701411_dp, 0.015687085526692218_dp, 0.05258053100648433_dp, &
             0.14701518319112136_dp, 0.37301617466915876_dp, 0.8831960386953908_dp, &
             1.9892072955102489_dp, 4.408493070315262_dp, &
             ! w
             0.006700887588905575_dp, 0.02159084964403569_dp, 0.057542315578722775_dp, &
             0.1430624602634638_dp, 0.33318420591832787_dp, 0.7362076092535838_dp, &
             1.5812540713021126_dp, 3.5971080384364664_dp]

      CASE (167)

         aw(:) = & ! a
            [0.0021229535274735287_dp, 0.013506419943363183_dp, 0.04667371867458424_dp, &
             0.1342539621944194_dp, 0.3485587576491087_dp, 0.8406244096896625_dp, &
             1.921727596399514_dp, 4.3108989561714495_dp, &
             ! w
             0.005676595472761695_dp, 0.018968428553127636_dp, 0.052510258462381006_dp, &
             0.13408946335725638_dp, 0.3184836575206165_dp, 0.7145967548360082_dp, &
             1.5533459981559692_dp, 3.565046943939176_dp]

      CASE (168)

         aw(:) = & ! a
            [0.0016447651044251732_dp, 0.010851661468111345_dp, 0.03937106572628469_dp, &
             0.11814688325978337_dp, 0.3170960230793337_dp, 0.7850072328236102_dp, &
             1.8325419240849563_dp, 4.18093122478255_dp, &
             ! w
             0.004434875104399002_dp, 0.01574993184106714_dp, 0.0461450866606819_dp, &
             0.12243364470001045_dp, 0.29902783933586385_dp, 0.6856106320477459_dp, &
             1.5156041931287734_dp, 3.5216267135009915_dp]

      CASE (169)

         aw(:) = & ! a
            [0.0012593274957499998_dp, 0.008697850453973345_dp, 0.03331819801427228_dp, &
             0.10444133341331838_dp, 0.2897059260448648_dp, 0.7357066637534232_dp, &
             1.752418955036336_dp, 4.0631526124948225_dp, &
             ! w
             0.003433576050391069_dp, 0.013108057719402625_dp, 0.040711374217526033_dp, &
             0.11217166530926562_dp, 0.2815304358415968_dp, 0.6591413831361904_dp, &
             1.4808119960150754_dp, 3.481532103291602_dp]

      CASE (170)

         aw(:) = & ! a
            [0.0007623416133137365_dp, 0.005890810975737877_dp, 0.025149545186670872_dp, &
             0.08523766862430776_dp, 0.25013407265478554_dp, 0.6627794284196206_dp, &
             1.6318321257986887_dp, 3.883916595608218_dp, &
             ! w
             0.0021430462268822023_dp, 0.009593451326400984_dp, 0.03305675473132598_dp, &
             0.09713197940984239_dp, 0.25518467736496675_dp, 0.6185015005689335_dp, &
             1.4267377848347798_dp, 3.419075109519514_dp]

      CASE (171)

         aw(:) = & ! a
            [0.0005779647722766573_dp, 0.004834508041275553_dp, 0.02194359693177028_dp, &
             0.07739916773698584_dp, 0.23349001096806937_dp, 0.6314114180649208_dp, &
             1.579120648939428_dp, 3.8047625323126018_dp, &
             ! w
             0.0016651967973811464_dp, 0.008234495899626803_dp, 0.029913258361711683_dp, &
             0.09072287364059083_dp, 0.24367301553143572_dp, 0.6004207194957538_dp, &
             1.402406578053114_dp, 3.390910901261706_dp]

      CASE (172)

         aw(:) = & ! a
            [0.0004803056376499483_dp, 0.004269208788726529_dp, 0.02018253421181372_dp, &
             0.07299928590414934_dp, 0.22399874724744046_dp, 0.6133156517874289_dp, &
             1.548459707964839_dp, 3.7584802839867817_dp, &
             ! w
             0.0014125661829260472_dp, 0.007493769268018652_dp, 0.02814264460179232_dp, &
             0.08704429226649443_dp, 0.23698080612286268_dp, 0.5898121473669076_dp, &
             1.3880475721468792_dp, 3.3742707589985144_dp]

      CASE (173)

         aw(:) = & ! a
            [0.0004196991604112789_dp, 0.0039154579369630625_dp, 0.019060101588172385_dp, &
             0.07015487445149451_dp, 0.21780047958598356_dp, 0.6014111142968014_dp, &
             1.5281833987584514_dp, 3.727773036068565_dp, &
             ! w
             0.0012560128074441002_dp, 0.007023904657541629_dp, 0.026995379037448926_dp, &
             0.08463234039908399_dp, 0.2325573562750163_dp, 0.5827590540484507_dp, &
             1.3784658861922865_dp, 3.363158703600496_dp]

      CASE (174)

         aw(:) = & ! a
            [0.00034930745430810777_dp, 0.003500714479076156_dp, 0.0177200698247083_dp, &
             0.06671353770291188_dp, 0.210231191212566_dp, 0.5867753361711184_dp, &
             1.5031361158199719_dp, 3.6897272261912297_dp, &
             ! w
             0.0010744332166565012_dp, 0.006465273349026221_dp, 0.02560440150682541_dp, &
             0.08167628463428958_dp, 0.22709597493762274_dp, 0.5740045808031631_dp, &
             1.366532924057776_dp, 3.349310441935163_dp]

      CASE (175)

         aw(:) = & ! a
            [0.00029964174428975153_dp, 0.003204686902545453_dp, 0.01674488767701508_dp, &
             0.06417502390498837_dp, 0.20459531728809519_dp, 0.5758049688355265_dp, &
             1.4842730758101719_dp, 3.6609907150717964_dp, &
             ! w
             0.0009464736592531919_dp, 0.006060314212579553_dp, 0.024576150889317736_dp, &
             0.07946757918251539_dp, 0.22298546196725477_dp, 0.5673808117367402_dp, &
             1.3574743205521425_dp, 3.3387907492178366_dp]

      CASE (176)

         aw(:) = & ! a
            [0.00028127089949768415_dp, 0.0030942621869177655_dp, 0.016376552972548756_dp, &
             0.06320813546148488_dp, 0.20243640179262407_dp, 0.5715854881795668_dp, &
             1.4769970948293096_dp, 3.6498865034832644_dp, &
             ! w
             0.0008991679845521025_dp, 0.005907694052883593_dp, 0.02418399221444927_dp, &
             0.07861972999994296_dp, 0.2214005640066087_dp, 0.5648187066649002_dp, &
             1.353963338681178_dp, 3.334711769038868_dp]

      CASE (177)

         aw(:) = & ! a
            [0.03664663996285433_dp, 0.196621045088126_dp, 0.49988724525066536_dp, &
             0.9775594233646503_dp, 1.6858162243103594_dp, 2.7212944265320904_dp, &
             4.248587129766745_dp, 6.565902165746518_dp, 10.361975057294288_dp, &
             ! w
             0.09444081799100229_dp, 0.22798682547002244_dp, 0.3835833446278581_dp, &
             0.580876962423688_dp, 0.8513259963968657_dp, 1.2461698737081928_dp, &
             1.8552456496972611_dp, 2.878254284214635_dp, 5.064864774966903_dp]

      CASE (178)

         aw(:) = & ! a
            [0.02211601616717754_dp, 0.11970056172643999_dp, 0.3095577652107071_dp, &
             0.6220398529933125_dp, 1.114702211483489_dp, 1.8885600218294079_dp, &
             3.1147249042730754_dp, 5.0981371610313975_dp, 8.527471659429366_dp, &
             ! w
             0.05710689683806502_dp, 0.14030460024012567_dp, 0.24428884251928015_dp, &
             0.39000280939785126_dp, 0.6117598936983984_dp, 0.9636093286970012_dp, &
             1.5367428589142293_dp, 2.5294131477214146_dp, 4.67401573757719_dp]

      CASE (179)

         aw(:) = & ! a
            [0.01631421657105954_dp, 0.0888739577095855_dp, 0.23282412387217624_dp, &
             0.47762157517138293_dp, 0.8804879707385603_dp, 1.542669021349391_dp, &
             2.636221658061287_dp, 4.468355767093642_dp, 7.729002946792687_dp, &
             ! w
             0.042186813259380146_dp, 0.10501161699893571_dp, 0.18760642523953358_dp, &
             0.311262968587439_dp, 0.5109461867562471_dp, 0.8412092785410361_dp, &
             1.3943134568732372_dp, 2.3697175189404875_dp, 4.494047315704001_dp]

      CASE (180)

         aw(:) = & ! a
            [0.01310769278658543_dp, 0.07178932791056176_dp, 0.1901024737453173_dp, &
             0.39670951451930686_dp, 0.7480739001355727_dp, 1.3446599602615252_dp, &
             2.3582852576121467_dp, 4.097389192379444_dp, 7.253327633896303_dp, &
             ! w
             0.033935259759454994_dp, 0.08538754041252856_dp, 0.1558201128416026_dp, &
             0.26654675338405603_dp, 0.4525182570791364_dp, 0.7683860176045938_dp, &
             1.3074948146510295_dp, 2.2708533075573003_dp, 4.382308901189268_dp]

      CASE (181)

         aw(:) = & ! a
            [0.011046162027061476_dp, 0.060780358590888095_dp, 0.16246957067470932_dp, &
             0.3440842840849094_dp, 0.661228691056707_dp, 1.2133287214430295_dp, &
             2.1716507047182065_dp, 3.8454420774551985_dp, 6.927402028599623_dp, &
             ! w
             0.028627268985310098_dp, 0.07270850592790482_dp, 0.13513575605066283_dp, &
             0.23710656804635652_dp, 0.41333272977734137_dp, 0.7184889744300452_dp, &
             1.2469241956836628_dp, 2.201122430059486_dp, 4.303366802485584_dp]

      CASE (182)

         aw(:) = & ! a
            [0.00959767293150908_dp, 0.053030158150609935_dp, 0.1429528058023013_dp, &
             0.30672868385932517_dp, 0.5991056928552874_dp, 1.1184415035302333_dp, &
             2.0353775012644673_dp, 3.659744161164704_dp, 6.685457309051659_dp, &
             ! w
             0.024895972176476603_dp, 0.06376235712417291_dp, 0.12044910511050758_dp, &
             0.2159745478825277_dp, 0.38473919314424293_dp, 0.6814342485253309_dp, &
             1.201306390551467_dp, 2.1481696096724234_dp, 4.243353313165919_dp]

      CASE (183)

         aw(:) = & ! a
            [0.008518360871648093_dp, 0.047245437550452345_dp, 0.12834328815009152_dp, &
             0.27863568352195117_dp, 0.5520531959128403_dp, 1.0459297104212417_dp, &
             1.9302841753638598_dp, 3.515390795108448_dp, 6.496258291887618_dp, &
             ! w
             0.022114523859998472_dp, 0.05707172554263855_dp, 0.10940265203680985_dp, &
             0.19991824725567156_dp, 0.36269407103471935_dp, 0.6524437931310794_dp, &
             1.165208706530346_dp, 2.1059899831229174_dp, 4.195511171460698_dp]

      CASE (184)

         aw(:) = & ! a
            [0.007679789483948467_dp, 0.04274416689670455_dp, 0.1169452389354415_dp, &
             0.25662289986184644_dp, 0.514940659935099_dp, 0.9882757618211389_dp, &
             1.8460526692834496_dp, 3.398895119289925_dp, 6.342795057626663_dp, &
             ! w
             0.019952678430106358_dp, 0.05185630039334263_dp, 0.10074660869725498_dp, &
             0.18721649412691854_dp, 0.3450262461891317_dp, 0.6289183401844696_dp, &
             1.1356374020567792_dp, 2.0712467277560673_dp, 4.156078967198704_dp]

      CASE (185)

         aw(:) = & ! a
            [0.007007525840355502_dp, 0.03913062459196527_dp, 0.10777290996272314_dp, &
             0.23883615703861727_dp, 0.4847687047212495_dp, 0.941062053978471_dp, &
             1.7765815928488142_dp, 3.3022331320416156_dp, 6.214897269621191_dp, &
             ! w
             0.018218993905498363_dp, 0.04766271101136857_dp, 0.09375242604685922_dp, &
             0.17686154628295433_dp, 0.33045366257578834_dp, 0.6093043202241387_dp, &
             1.1107832014454115_dp, 2.0419093040247858_dp, 4.122764944772186_dp]

      CASE (186)

         aw(:) = & ! a
            [0.0064552940709981695_dp, 0.03615852291388057_dp, 0.10021175216681184_dp, &
             0.22411697154250507_dp, 0.4596569999787067_dp, 0.9015052273114635_dp, &
             1.7180040401346317_dp, 3.2202910181231106_dp, 6.106054374868566_dp, &
             ! w
             0.016794417745794436_dp, 0.04420843632131467_dp, 0.08796472897000776_dp, &
             0.1682207519727353_dp, 0.31816462771886816_dp, 0.5926071686898263_dp, &
             1.0894766158992761_dp, 2.016657531293518_dp, 4.094077743972719_dp]

      CASE (187)

         aw(:) = & ! a
            [0.003753505907258484_dp, 0.02155182075421551_dp, 0.06273631153032878_dp, &
             0.1500627747875536_dp, 0.3306054926762188_dp, 0.6934050066019539_dp, &
             1.4030303812801839_dp, 2.7716770734119853_dp, 5.502433394755472_dp, &
             ! w
             0.00981702804109182_dp, 0.02714183122363002_dp, 0.05885554054999135_dp, &
             0.12336869370144365_dp, 0.2520334255785889_dp, 0.4999564200366364_dp, &
             0.9685402483680957_dp, 1.8714190637073345_dp, 3.9288430703647426_dp]

      CASE (188)

         aw(:) = & ! a
            [0.00273146050814806_dp, 0.015983936853035185_dp, 0.04822855460935647_dp, &
             0.12059563145779052_dp, 0.27738623596598116_dp, 0.6044051058271435_dp, &
             1.2638987330530245_dp, 2.5683342984551687_dp, 5.223861350006336_dp, &
             ! w
             0.007172698427828807_dp, 0.020576588872870942_dp, 0.04727844477596849_dp, &
             0.10455119508323607_dp, 0.22278452857668699_dp, 0.4572258464535361_dp, &
             0.9110357207216384_dp, 1.801108799828981_dp, 3.848690607070614_dp]

      CASE (189)

         aw(:) = & ! a
            [0.002180530109983482_dp, 0.012966829796073573_dp, 0.04027380641050435_dp, &
             0.10410674805475155_dp, 0.24688474333689828_dp, 0.5522250628274896_dp, &
             1.1807304388190987_dp, 2.444927751309307_dp, 5.05303534364627_dp, &
             ! w
             0.005745521949355099_dp, 0.016995748484371104_dp, 0.04079999911086326_dp, &
             0.09363900972689708_dp, 0.2052932850347775_dp, 0.43106468673745896_dp, &
             0.8752159980258892_dp, 1.7568568252994703_dp, 3.798180091949992_dp]

      CASE (190)

         aw(:) = & ! a
            [0.0018316193162704233_dp, 0.011048247676452443_dp, 0.03516488856787591_dp, &
             0.0933425211230552_dp, 0.22661138549778412_dp, 0.5169700044462441_dp, &
             1.1237641613889138_dp, 2.359501711743573_dp, 4.9339327011643235_dp, &
             ! w
             0.00484084226221103_dp, 0.014706549877645558_dp, 0.03656917957236209_dp, &
             0.0863219618381845_dp, 0.19331294173316757_dp, 0.41285608032480475_dp, &
             0.8499869026869297_dp, 1.7254635478924916_dp, 3.762313206988196_dp]

      CASE (191)

         aw(:) = & ! a
            [0.0014095059934701932_dp, 0.008716394943563546_dp, 0.028880260117061844_dp, &
             0.07985102079144676_dp, 0.20070186121842573_dp, 0.4711331220524638_dp, &
             1.04864495451299_dp, 2.245626201329628_dp, 4.774002223938378_dp, &
             ! w
             0.0037452979413056405_dp, 0.011906536498876437_dp, 0.03126205748967432_dp, &
             0.0768822495241899_dp, 0.1775211901125934_dp, 0.38846227970546593_dp, &
             0.8157768943467678_dp, 1.6825795696161268_dp, 3.713268572163096_dp]

      CASE (192)

         aw(:) = & ! a
            [0.0010697132697980306_dp, 0.006827699189441219_dp, 0.023702137973609167_dp, &
             0.06845703145726359_dp, 0.1782853335724231_dp, 0.43064914538427485_dp, &
             0.9811811804065309_dp, 2.142050481175247_dp, 4.627299876929942_dp, &
             ! w
             0.0028624090304025795_dp, 0.009618099703285324_dp, 0.026772710656902746_dp, &
             0.06862135720991581_dp, 0.163352677554946_dp, 0.3661615356237251_dp, &
             0.7840601806864651_dp, 1.6424763479445015_dp, 3.6673470190152675_dp]

      CASE (193)

         aw(:) = & ! a
            [0.0006313454889490319_dp, 0.004366846985787416_dp, 0.016754567817872237_dp, &
             0.05258401592915444_dp, 0.1459750048379582_dp, 0.3706381471395139_dp, &
             0.8789214132697631_dp, 1.9823948779811633_dp, 4.398639838848585_dp, &
             ! w
             0.0017219984012311613_dp, 0.006588442625411695_dp, 0.020496274793963855_dp, &
             0.05652945093522863_dp, 0.14192707509516378_dp, 0.3315985863927448_dp, &
             0.7339849281745117_dp, 1.5784277751334237_dp, 3.5938760022078236_dp]

      CASE (194)

         aw(:) = & ! a
            [0.0004677826770463522_dp, 0.003436913173081709_dp, 0.014027484844973091_dp, &
             0.04608466268371336_dp, 0.13227034370139945_dp, 0.34446469222973564_dp, &
             0.8333436224059947_dp, 1.9100798947374522_dp, 4.293972597070242_dp, &
             ! w
             0.0012962831308852621_dp, 0.005418064450388919_dp, 0.017913634087816786_dp, &
             0.051323222153869655_dp, 0.13240949292960194_dp, 0.3158801151655617_dp, &
             0.7108062282245082_dp, 1.5484532018565422_dp, 3.5594302119364722_dp]

      CASE (195)

         aw(:) = & ! a
            [0.0003803762514503546_dp, 0.0029354867547009725_dp, 0.012518840564158371_dp, &
             0.0423977620853282_dp, 0.12434109876798174_dp, 0.32908940347314647_dp, &
             0.8062550457285699_dp, 1.866728574542357_dp, 4.2308745838119775_dp, &
             ! w
             0.0010688850352942277_dp, 0.0047768063467026785_dp, 0.016443757155660196_dp, &
             0.04828720609205642_dp, 0.12676597891135466_dp, 0.30644185437677185_dp, &
             0.6967562347704147_dp, 1.5301758899530689_dp, 3.538405395173158_dp]

      CASE (196)

         aw(:) = & ! a
            [0.0003254404360101519_dp, 0.0026180514674484442_dp, 0.01154517732693377_dp, &
             0.03997641243207779_dp, 0.11906408321953327_dp, 0.31875343796582456_dp, &
             0.7879045136257067_dp, 1.837195090818923_dp, 4.187731284690917_dp, &
             ! w
             0.0009260627770325223_dp, 0.004365663939146157_dp, 0.015476137494080599_dp, &
             0.046256432129645954_dp, 0.12294951395737774_dp, 0.3000063118609165_dp, &
             0.6871166160166533_dp, 1.517587078958083_dp, 3.523914413006404_dp]

      CASE (197)

         aw(:) = & ! a
            [0.0002596868790846979_dp, 0.0022348903483392375_dp, 0.010345396602249564_dp, &
             0.03694010841533558_dp, 0.11236044056791297_dp, 0.3054946294132512_dp, &
             0.7641900750527943_dp, 1.798821603444244_dp, 4.131477966912905_dp, &
             ! w
             0.000755293632344843_dp, 0.0038622717168615727_dp, 0.014259845002795556_dp, &
             0.04366428520270354_dp, 0.1180264413253419_dp, 0.2916386422069089_dp, &
             0.6745080482776007_dp, 1.5010591549296193_dp, 3.5048765058635483_dp]

      CASE (198)

         aw(:) = & ! a
            [0.00020784696525288592_dp, 0.0019292989209037795_dp, 0.00936414928646571_dp, &
             0.03440695455808136_dp, 0.10668662080214998_dp, 0.2941521685207763_dp, &
             0.7437390948258376_dp, 1.7655336768516126_dp, 4.082494835296907_dp, &
             ! w
             0.0006208594515187709_dp, 0.003453412616156619_dp, 0.013242316836217145_dp, &
             0.041459127716502404_dp, 0.11378993066689655_dp, 0.2843755027087347_dp, &
             0.6634927640743865_dp, 1.4865608254662939_dp, 3.488164179515476_dp]

      CASE (199)

         aw(:) = & ! a
            [0.0001468747327408845_dp, 0.0015634875681823865_dp, 0.008151590050869005_dp, &
             0.031203069191438823_dp, 0.09939208476306977_dp, 0.2793935723291259_dp, &
             0.7168880009925573_dp, 1.7215411744800457_dp, 4.017487616446215_dp, &
             ! w
             0.00046301946625643294_dp, 0.0029518667511140365_dp, 0.011951279637165236_dp, &
             0.038608343330302074_dp, 0.10824204346377927_dp, 0.27477195324743986_dp, &
             0.6488225767108784_dp, 1.4671639226752504_dp, 3.465786603779763_dp]

      CASE (200)

         aw(:) = & ! a
            [0.00013620787587729222_dp, 0.0014984233172990983_dp, 0.007930484313668681_dp, &
             0.030608852526075443_dp, 0.09802331751259105_dp, 0.2766007114067538_dp, &
             0.7117747229082216_dp, 1.7131253759530025_dp, 4.005015434301447_dp, &
             ! w
             0.0004354299056155451_dp, 0.002860852031658403_dp, 0.011711291382515341_dp, &
             0.038071387509506595_dp, 0.10718758733492406_dp, 0.27293433084542407_dp, &
             0.6460013499115237_dp, 1.4634218815677373_dp, 3.461467001531876_dp]

      CASE (201)

         aw(:) = & ! a
            [0.03306976242729251_dp, 0.17680784378248424_dp, 0.44648534486771163_dp, &
             0.8637994095087874_dp, 1.466530420117529_dp, 2.317211400137225_dp, &
             3.5172089429912434_dp, 5.232873218058406_dp, 7.761728768017606_dp, &
             11.795294979146854_dp, &
             ! w
             0.08515488845128172_dp, 0.20412213773751856_dp, 0.3387624704041514_dp, &
             0.5020218012767448_dp, 0.7136389791481699_dp, 1.004228338368501_dp, &
             1.4225951252649078_dp, 2.055377543960623_dp, 3.101316839233214_dp, &
             5.321560424063531_dp]

      CASE (202)

         aw(:) = & ! a
            [0.0199190782019327_dp, 0.1072334417383125_dp, 0.2744085978174513_dp, &
             0.5421416040798438_dp, 0.9483605618497398_dp, 1.5578821538499603_dp, &
             2.4764307129347025_dp, 3.8758067491779373_dp, 6.058295080044497_dp, &
             9.71184803990698_dp, &
             ! w
             0.05137209581340257_dp, 0.12485945800871932_dp, 0.21283441302264827_dp, &
             0.32879262838087114_dp, 0.49422642050095056_dp, 0.74206692724155_dp, &
             1.1227892497020227_dp, 1.7234803772519538_dp, 2.7403911047158_dp, &
             4.91502735537284_dp]

      CASE (203)

         aw(:) = & ! a
            [0.014672089347410964_dp, 0.07938691179467121_dp, 0.20517497813391075_dp, &
             0.41184592426970557_dp, 0.736738817100995_dp, 1.2445399693315784_dp, &
             2.041220998765312_dp, 3.2995507853921113_dp, 5.323729672106679_dp, &
             8.80146136115717_dp, &
             ! w
             0.037882989131618645_dp, 0.09301632450371458_dp, 0.1617466336454914_dp, &
             0.25765519527407565_dp, 0.40269419497450526_dp, 0.6301925993044387_dp, &
             0.9910799607619161_dp, 1.57344701648294_dp, 2.5740012849105933_dp, &
             4.726857011736634_dp]

      CASE (204)

         aw(:) = & ! a
            [0.011774025170233755_dp, 0.0639700951282584_dp, 0.1666917616889322_dp, &
             0.3390289700500115_dp, 0.6176072358757309_dp, 1.0663680454451372_dp, &
             1.7906093738966222_dp, 2.9631424352797224_dp, 4.889379313076166_dp, &
             8.257531682354081_dp, &
             ! w
             0.03042835426798262_dp, 0.0753370830029148_dp, 0.1331690520655589_dp, &
             0.21744811936857542_dp, 0.3501479372604659_dp, 0.5645330070305195_dp, &
             0.9118556551925829_dp, 1.4812981052443768_dp, 2.4704999769201472_dp, &
             4.609597851526631_dp]

      CASE (205)

         aw(:) = & ! a
            [0.009911839853047714_dp, 0.05404467176447483_dp, 0.141834651822087_dp, &
             0.2917769967006175_dp, 0.5397886064780781_dp, 0.9489117072037068_dp, &
             1.6235559881076618_dp, 2.736311064442644_dp, 4.593474331342694_dp, &
             7.883962032792184_dp, &
             ! w
             0.025636076499812976_dp, 0.06392887219780452_dp, 0.11461312317687036_dp, &
             0.1910990220813975_dp, 0.315211226733076_dp, 0.5200333749196062_dp, &
             0.8571142202739548_dp, 1.416643388358046_dp, 2.397230987996018_dp, &
             4.526514342364133_dp]

      CASE (206)

         aw(:) = & ! a
            [0.008604064608033616_dp, 0.04706270872618831_dp, 0.12429966311710704_dp, &
             0.25830664284518123_dp, 0.484331180051568_dp, 0.8645073678078468_dp, &
             1.5023398624500846_dp, 2.570112871924677_dp, 4.374813518228905_dp, &
             7.6060959473532055_dp, &
             ! w
             0.022269224904038827_dp, 0.05588806630464082_dp, 0.10146365565522789_dp, &
             0.17226893055438913_dp, 0.2899119020042487_dp, 0.4872765569924376_dp, &
             0.8161879928937111_dp, 1.3677291102282898_dp, 2.341423980323161_dp, &
             4.463197532355998_dp]

      CASE (207)

         aw(:) = & ! a
            [0.007630040579213754_dp, 0.04185500587435238_dp, 0.1111879397803506_dp, &
             0.23318545543856892_dp, 0.4424728513495299_dp, 0.8003165994032522_dp, &
             1.4093598104639633_dp, 2.4415582485058356_dp, 4.2044568362569175_dp, &
             7.3884269231485025_dp, &
             ! w
             0.019760738475349357_dp, 0.04988023165757547_dp, 0.09159139706158959_dp, &
             0.1580208841785473_dp, 0.27053665184305753_dp, 0.4618333919085842_dp, &
             0.7839904120304717_dp, 1.3288768434592462_dp, 2.296856375044337_dp, &
             4.412613921753437_dp]

      CASE (208)

         aw(:) = & ! a
            [0.006873584630849889_dp, 0.037805265177748806_dp, 0.10096864775958635_dp, &
             0.21353808268362326_dp, 0.4095631635599569_dp, 0.749498579552089_dp, &
             1.3351857641416567_dp, 2.3382521089266644_dp, 4.066705245618029_dp, &
             7.211595244532029_dp, &
             ! w
             0.01781196457799392_dp, 0.04520104299920789_dp, 0.08386868600678984_dp, &
             0.14679334916722228_dp, 0.25509977725182514_dp, 0.44131140027782323_dp, &
             0.7577390458093131_dp, 1.2969458549711415_dp, 2.260063004909375_dp, &
             4.370842386544174_dp]

      CASE (209)

         aw(:) = & ! a
            [0.006267382968008953_dp, 0.03455606410432884_dp, 0.09275251241973845_dp, &
             0.1976907281888568_dp, 0.3828877720426687_dp, 0.7080447357505528_dp, &
             1.2742625091008632_dp, 2.25284939047651_dp, 3.952204179611082_dp, &
             7.06401285647989_dp, &
             ! w
             0.01624982988730891_dp, 0.0414415425972865_dp, 0.07763876472913307_dp, &
             0.13767351439365783_dp, 0.24243359586166527_dp, 0.42428979480948564_dp, &
             0.735762739448808_dp, 1.2700319870608947_dp, 2.228931348991005_dp, &
             4.335490774803464_dp]

      CASE (210)

         aw(:) = & ! a
            [0.0057695950967900245_dp, 0.03188503735236182_dp, 0.0859854511862231_dp, &
             0.1845984841571088_dp, 0.3607477727164536_dp, 0.6734363415369501_dp, &
             1.2230817507171463_dp, 2.1806860194693054_dp, 3.8549835889359443_dp, &
             6.938254312061828_dp, &
             ! w
             0.014966733330367177_dp, 0.03834702878119511_dp, 0.07249146439732221_dp, &
             0.13008928187098504_dp, 0.2318018689487819_dp, 0.409864313242222_dp, &
             0.716987073246654_dp, 1.2469010750155314_dp, 2.20208574116089_dp, &
             4.305000487897624_dp]

      CASE (211)

         aw(:) = & ! a
            [0.0033373898429685275_dp, 0.018782920102500628_dp, 0.05255601754553826_dp, &
             0.1191576576823401_dp, 0.24812207557829966_dp, 0.4935977722085606_dp, &
             0.9512698505332244_dp, 1.7897496715257404_dp, 3.3196100790475946_dp, &
             6.2374001617059704_dp, &
             ! w
             0.008691576585670246_dp, 0.023096915721798953_dp, 0.046761944252935964_dp, &
             0.09121522731605315_dp, 0.17546964148618782_dp, 0.3309435153894121_dp, &
             0.6115252378444787_dp, 1.11442752382245_dp, 2.0466210507551135_dp, &
             4.1283173287555055_dp]

      CASE (212)

         aw(:) = & ! a
            [0.002419472338931235_dp, 0.013804633431198317_dp, 0.03969259714997238_dp, &
             0.09342229848814294_dp, 0.2024464290319135_dp, 0.41810184647482834_dp, &
             0.8332962399975895_dp, 1.6150345745196448_dp, 3.0746551660908783_dp, &
             5.911309202082852_dp, &
             ! w
             0.006319480627819706_dp, 0.017256004783303094_dp, 0.03664720484282423_dp, &
             0.07523541712130324_dp, 0.15108705453980023_dp, 0.29520356140995513_dp, &
             0.5620186886646714_dp, 1.050575234327714_dp, 1.9705361918601552_dp, &
             4.041763024591411_dp]

      CASE (213)

         aw(:) = & ! a
            [0.001925490917079591_dp, 0.011112891434512117_dp, 0.03267157966957963_dp, &
             0.07914231127444575_dp, 0.17654897955074694_dp, 0.3743260077419205_dp, &
             0.763465141856196_dp, 1.5097794912507614_dp, 2.9250174225165053_dp, &
             5.710152417296363_dp, &
             ! w
             0.005041488711366136_dp, 0.01408000545000744_dp, 0.031036726307924655_dp, &
             0.06608638494458426_dp, 0.13667658371254043_dp, 0.27352566637805875_dp, &
             0.5313705135370472_dp, 1.0104385988466746_dp, 1.9222796166689597_dp, &
             3.986827718496853_dp]

      CASE (214)

         aw(:) = & ! a
            [0.001613055445090334_dp, 0.009404070986281243_dp, 0.028179289645629872_dp, &
             0.0698808951661137_dp, 0.15946969745111075_dp, 0.34497335680324653_dp, &
             0.7159420334350729_dp, 1.4372483830045268_dp, 2.8208885751505575_dp, &
             5.569217376576335_dp, &
             ! w
             0.004232468560920475_dp, 0.012054637074887036_dp, 0.02739864157379049_dp, &
             0.06000636980438821_dp, 0.12688158041115283_dp, 0.2585247942583659_dp, &
             0.5098606010576789_dp, 0.981968501582794_dp, 1.8878328906613233_dp, &
             3.9475916782101654_dp]

      CASE (215)

         aw(:) = & ! a
            [0.0012356310955025927_dp, 0.007331032472325871_dp, 0.022677688858641562_dp, &
             0.05835663352935596_dp, 0.13781848901562838_dp, 0.30709662141570726_dp, &
             0.6536553453439855_dp, 1.3409422950604044_dp, 2.6812225946439_dp, &
             5.378859676938215_dp, &
             ! w
             0.003254204988938095_dp, 0.009584571527771694_dp, 0.022871636879711024_dp, &
             0.05223282184648336_dp, 0.11406297049810572_dp, 0.2385322997992477_dp, &
             0.48077611616865584_dp, 0.9430492834876176_dp, 1.840433117231212_dp, &
             3.8935670915039187_dp]

      CASE (216)

         aw(:) = & ! a
            [0.0009323990731474346_dp, 0.005656005251340616_dp, 0.018171976481109728_dp, &
             0.048711670607687746_dp, 0.11926194585764506_dp, 0.27391713557144975_dp, &
             0.598060633554161_dp, 1.2536454845296414_dp, 2.5531023689261665_dp, &
             5.202804863940397_dp, &
             ! w
             0.0024672464939504654_dp, 0.0075740393679528135_dp, 0.019081354523931775_dp, &
             0.04549790683754734_dp, 0.10264676840998525_dp, 0.22034384503099905_dp, &
             0.45386487819252747_dp, 0.9065719038631264_dp, 1.7956602125219736_dp, &
             3.842494156645649_dp]

      CASE (217)

         aw(:) = & ! a
            [0.000542169647820812_dp, 0.003480673073208015_dp, 0.012180844662780915_dp, &
             0.035434707946528865_dp, 0.09280878667460729_dp, 0.22514555176454076_dp, &
             0.5142100271408127_dp, 1.1191922258880422_dp, 2.352574322476114_dp, &
             4.924224886750447_dp, &
             ! w
             0.001452680781671318_dp, 0.004929747195516357_dp, 0.013855151302821705_dp, &
             0.035746821242962044_dp, 0.08549708589224828_dp, 0.19223374522917086_dp, &
             0.4113201462352774_dp, 0.8478938111702771_dp, 1.722869004271629_dp, &
             3.7593552654949773_dp]

      CASE (218)

         aw(:) = & ! a
            [0.0003967302317420766_dp, 0.0026604835814450934_dp, 0.009848928612008827_dp, &
             0.030048816748303474_dp, 0.08166219386211819_dp, 0.20393288868216913_dp, &
             0.4767849144334122_dp, 1.0579265306400314_dp, 2.2597542577639733_dp, &
             4.7939093124023815_dp, &
             ! w
             0.001073880461895617_dp, 0.003915231331134727_dp, 0.011728458153009026_dp, &
             0.03157155026457845_dp, 0.07788195876052818_dp, 0.17940022094088975_dp, &
             0.3914628342219864_dp, 0.8200399624470611_dp, 1.6879552117417538_dp, &
             3.719424268448312_dp]

      CASE (219)

         aw(:) = & ! a
            [0.00031890135131914344_dp, 0.002218040837918263_dp, 0.008562208380223413_dp, &
             0.02699845169830664_dp, 0.07520683111420867_dp, 0.1914251600871076_dp, &
             0.45439737636288313_dp, 1.0208561605370439_dp, 2.20310436847618_dp, &
             4.7139161935991885_dp, &
             ! w
             0.0008710258738679723_dp, 0.0033608319216372057_dp, 0.010520901561447929_dp, &
             0.029131879268255015_dp, 0.073342527978235_dp, 0.1716321958691351_dp, &
             0.37929632229606325_dp, 0.8028142821879096_dp, 1.6662385945818383_dp, &
             3.69456689051089_dp]

      CASE (220)

         aw(:) = & ! a
            [0.00026986356050743616_dp, 0.0019374881805125897_dp, 0.007731658122650176_dp, &
             0.024991954089039963_dp, 0.07089423488187012_dp, 0.18296615376928954_dp, &
             0.439108530776862_dp, 0.9953449891370985_dp, 2.163893145603384_dp, &
             4.658334784577247_dp, &
             ! w
             0.0007431794401095744_dp, 0.0030055420983453205_dp, 0.00972495697615314_dp, &
             0.02749231394684896_dp, 0.07025059678298039_dp, 0.16628654509079477_dp, &
             0.37085524684180093_dp, 0.7907883037645156_dp, 1.6510183817369137_dp, &
             3.6771356408478857_dp]

      CASE (221)

         aw(:) = & ! a
            [0.00021088927916765304_dp, 0.0015975896285734081_dp, 0.00670512901453706_dp, &
             0.022462537087632618_dp, 0.06537177483149399_dp, 0.17200075407454882_dp, &
             0.4190975398123097_dp, 0.9617003167186998_dp, 2.11188565408034_dp, &
             4.584336718927931_dp, &
             ! w
             0.0005894337117817898_dp, 0.0025697219209575386_dp, 0.008719298224014765_dp, &
             0.025380603698704346_dp, 0.06621509234256368_dp, 0.1592383500598886_dp, &
             0.3596358039121045_dp, 0.7747051418395836_dp, 1.6305850484217999_dp, &
             3.653720535967335_dp]

      CASE (222)

         aw(:) = & ! a
            [0.0001638448168262917_dp, 0.0013236958800674286_dp, 0.005856363480641509_dp, &
             0.02032121754616425_dp, 0.06061117238246225_dp, 0.16241571930937454_dp, &
             0.401414372352973_dp, 0.9317156300794015_dp, 2.0652402323623247_dp, &
             4.51768916274079_dp, &
             ! w
             0.0004668500190071136_dp, 0.0022125830949226376_dp, 0.007865544601183026_dp, &
             0.02354853492163057_dp, 0.06266121898451606_dp, 0.1529600992483177_dp, &
             0.34955143608834877_dp, 0.7601490813086588_dp, 1.6120121524724762_dp, &
             3.632423318172745_dp]

      CASE (223)

         aw(:) = & ! a
            [0.0001044471836183439_dp, 0.0009720821957014101_dp, 0.004725443567268713_dp, &
             0.01737862810508732_dp, 0.0539181294703908_dp, 0.1487055525765664_dp, &
             0.37578058267914366_dp, 0.8877951802573104_dp, 1.9963843960430068_dp, &
             4.418804877219708_dp, &
             ! w
             0.0003122983278971261_dp, 0.00174201049818798_dp, 0.006687907463837846_dp, &
             0.020953148975112912_dp, 0.05753309764487348_dp, 0.14377294911196278_dp, &
             0.3346309405621727_dp, 0.7384301152245304_dp, 1.5841532058029584_dp, &
             3.6004513613032674_dp]

      CASE (224)

         aw(:) = & ! a
            [8.35622857860373e-05_dp, 0.0008458181869110869_dp, 0.004303148689255562_dp, &
             0.016247236036916173_dp, 0.051290689636432255_dp, 0.1432399532634682_dp, &
             0.36544035137816383_dp, 0.8699163624140205_dp, 1.9681651743163817_dp, &
             4.3780996775916_dp, &
             ! w
             0.0002580490502292502_dp, 0.0015680060081697754_dp, 0.006233523092257048_dp, &
             0.019927658890088462_dp, 0.05547349612734545_dp, 0.14003731505420994_dp, &
             0.328505211932211_dp, 0.7294474860966533_dp, 1.5725780732758836_dp, &
             3.587157358005245_dp]

      CASE (225)

         aw(:) = & ! a
            [6.924968347849166e-05_dp, 0.0007579413760384286_dp, 0.004002314214743724_dp, &
             0.015428199217226279_dp, 0.04936735277326966_dp, 0.13920627880981634_dp, &
             0.3577616046206043_dp, 0.8565758106159339_dp, 1.947034404522222_dp, &
             4.347548930323242_dp, &
             ! w
             0.0002208934821832957_dp, 0.0014446374339168884_dp, 0.005903963658001153_dp, &
             0.019174503377867066_dp, 0.05394773475305085_dp, 0.13725188732361046_dp, &
             0.3239144208051743_dp, 0.7226896593627993_dp, 1.5638487674530244_dp, &
             3.5771277827054706_dp]

      CASE (226)

         aw(:) = & ! a
            [6.844390138830508e-05_dp, 0.0007529515955878675_dp, 0.003985035599836493_dp, &
             0.015380799076269465_dp, 0.04925546526265801_dp, 0.1389707382811857_dp, &
             0.35731192893101876_dp, 0.8557928463574533_dp, 1.9457922045681717_dp, &
             4.345751081595515_dp, &
             ! w
             0.00021880174937623183_dp, 0.0014375664500890244_dp, 0.005884874351952866_dp, &
             0.019130624082222252_dp, 0.05385848744224646_dp, 0.13708846821179432_dp, &
             0.3236444502032899_dp, 0.7222915374704976_dp, 1.5633339391232095_dp, &
             3.576536192951217_dp]

      CASE (227)

         aw(:) = & ! a
            [0.030130988527136335_dp, 0.1606809945496052_dp, 0.4037750551486719_dp, &
             0.7751832496328281_dp, 1.3015684469973898_dp, 2.0256723922926536_dp, &
             3.0143817180020074_dp, 4.371828909011248_dp, 6.26500179983537_dp, &
             8.990999251581144_dp, 13.245430012558954_dp, &
             ! w
             0.07754180311163038_dp, 0.18491238919978073_dp, 0.30385030485580955_dp, &
             0.4433256105757104_dp, 0.6164377958322639_dp, 0.842713034584987_dp, &
             1.1516837447426178_dp, 1.5901310218673417_dp, 2.242721174892849_dp, &
             3.3086113852215573_dp, 5.560937168307053_dp]

      CASE (228)

         aw(:) = & ! a
            [0.018121079712724322_dp, 0.09717503809053926_dp, 0.24679851729920788_dp, &
             0.4817566785490354_dp, 0.8282771166045614_dp, 1.3300696805608714_dp, &
             2.0567305766295165_dp, 3.1164004963694247_dp, 4.680507613564424_dp, &
             7.0492221261381145_dp, 10.911604422719243_dp, &
             ! w
             0.04669379968228601_dp, 0.11260338022623151_dp, 0.18903914404436575_dp, &
             0.28514829660319224_dp, 0.41504033333966167_dp, 0.5999483249149236_dp, &
             0.8710338480743368_dp, 1.2759883242857373_dp, 1.8993330622314406_dp, &
             2.9368796146680767_dp, 5.140078286417148_dp]

      CASE (229)

         aw(:) = & ! a
            [0.013332142168378771_dp, 0.07178446747588552_dp, 0.18375050791754996_dp, &
             0.3631906488145699_dp, 0.6356426510512829_dp, 1.0444692700724252_dp, &
             1.6592152251340613_dp, 2.58830483947198_dp, 4.004145202137294_dp, &
             6.2084129877437375_dp, 9.888554680124999_dp, &
             ! w
             0.03438538281941105_dp, 0.0836001053696773_dp, 0.1425876773323265_dp, &
             0.22044407827130794_dp, 0.33155187607849695_dp, 0.4974967407138458_dp, &
             0.7496946753853811_dp, 1.1363279712558223_dp, 1.7427500950293133_dp, &
             2.7645508616331735_dp, 4.944458579778126_dp]

      CASE (230)

         aw(:) = & ! a
            [0.010688453945637362_dp, 0.057739605989888636_dp, 0.14875435974316353_dp, &
             0.2970663897990964_dp, 0.5275519950057115_dp, 0.8829075520464834_dp, &
             1.4319631560494335_dp, 2.282648411744307_dp, 3.6076327856256674_dp, &
             5.7096768822342785_dp, 9.275873043842799_dp, &
             ! w
             0.027587389940205532_dp, 0.0675179313170176_dp, 0.11665978806309565_dp, &
             0.18400492341463712_dp, 0.283949354121628_dp, 0.4380335127182524_dp, &
             0.6776838734799814_dp, 1.0515697426467314_dp, 1.6460013694707742_dp, &
             2.6569503323667347_dp, 4.822200407234935_dp]

      CASE (231)

         aw(:) = & ! a
            [0.008990500158375417_dp, 0.04870417709230819_dp, 0.12617621226056372_dp, &
             0.2542357904458434_dp, 0.4571594292572616_dp, 0.7769092949171713_dp, &
             1.2814468596702209_dp, 2.078030149813022_dp, 3.3393616918465425_dp, &
             5.369054124614137_dp, 8.854288513719101_dp, &
             ! w
             0.023219556679335892_dp, 0.057151318173521565_dp, 0.09985528545071565_dp, &
             0.1602055619046999_dp, 0.25250354389485224_dp, 0.3981171244943777_dp, &
             0.6284424002596707_dp, 0.9926088267135148_dp, 1.577815572456583_dp, &
             2.580559279052842_dp, 4.735374139934867_dp]

      CASE (232)

         aw(:) = & ! a
            [0.00779855030728434_dp, 0.04235242011099923_dp, 0.11026525511118422_dp, &
             0.22394750615744496_dp, 0.40713580038316777_dp, 0.7010697302865118_dp, &
             1.1728396207014495_dp, 1.9290152408304664_dp, 3.1422391785388206_dp, &
             5.116820253028923_dp, 8.540207013979234_dp, &
             ! w
             0.02015234701752812_dp, 0.04985139674349512_dp, 0.08796626461982837_dp, &
             0.14325152757656873_dp, 0.22986665559520938_dp, 0.3689707967994121_dp, &
             0.5919302613549222_dp, 0.9482919217093115_dp, 1.5260458052374906_dp, &
             2.522236190314505_dp, 4.6690760135659035_dp]

      CASE (233)

         aw(:) = & ! a
            [0.006911123151973878_dp, 0.037617544377860225_dp, 0.09837885543161767_dp, &
             0.20124939360566238_dp, 0.3694783097483234_dp, 0.6436206330275096_dp, &
             1.0899407695335288_dp, 1.814350827026615_dp, 2.9893905748368823_dp, &
             4.919951938106212_dp, 8.293825536803077_dp, &
             ! w
             0.017868083742747738_dp, 0.04440159746301195_dp, 0.07905343422266112_dp, &
             0.13046141332449654_dp, 0.21262346265016102_dp, 0.34648736986481427_dp, &
             0.5633974185429599_dp, 0.9132730201360275_dp, 1.4848031156704544_dp, &
             2.4755646905106925_dp, 4.61602072885565_dp]

      CASE (234)

         aw(:) = & ! a
            [0.006222156846201917_dp, 0.03393745119365244_dp, 0.0891223549172806_dp, &
             0.1835224902391903_dp, 0.33994441123141017_dp, 0.5983039637414346_dp, &
             1.0240978685121114_dp, 1.7226238644716445_dp, 2.8662979670373296_dp, &
             4.760509608503989_dp, 8.093419785392712_dp, &
             ! w
             0.016094195143138396_dp, 0.04016017419248495_dp, 0.07209069721209424_dp, &
             0.12041126251744641_dp, 0.19895221819667774_dp, 0.3284599168601711_dp, &
             0.5402638660330097_dp, 0.8846145384436354_dp, 1.4508208171080412_dp, &
             2.436965669932821_dp, 4.572141876812747_dp]

      CASE (235)

         aw(:) = & ! a
            [0.005670214189250698_dp, 0.03098626556992178_dp, 0.08168603873992042_dp, &
             0.16924340664004847_dp, 0.3160607081649595_dp, 0.5614600806021925_dp, &
             0.9702293534113281_dp, 1.6470963177289164_dp, 2.764343118490741_dp, &
             4.627789942664766_dp, 7.925974405427083_dp, &
             ! w
             0.014672760181410385_dp, 0.036754698281782155_dp, 0.0664809481604872_dp, &
             0.11226966842914492_dp, 0.18778449751520476_dp, 0.31358447094093145_dp, &
             0.5209897018134803_dp, 0.860545213956893_dp, 1.4221134659936936_dp, &
             2.4042539239717673_dp, 4.53495589588831_dp]

      CASE (236)

         aw(:) = & ! a
            [0.00521711579001643_dp, 0.02856132097318766_dp, 0.07556567145631886_dp, &
             0.15746184069012953_dp, 0.296280949416954_dp, 0.5307942425023797_dp, &
             0.9251356226523106_dp, 1.5835045879490817_dp, 2.678045059132043_dp, &
             4.514954717187926_dp, 7.7831431411206164_dp, &
             ! w
             0.013505622891399446_dp, 0.033953336487602744_dp, 0.06185157183615044_dp, &
             0.10551618687024221_dp, 0.1784485164513013_dp, 0.3010351533892806_dp, &
             0.5045904598592531_dp, 0.8399224594117822_dp, 1.3973915223155493_dp, &
             2.376004757996431_dp, 4.502843252178717_dp]

      CASE (237)

         aw(:) = & ! a
            [0.003005695991918856_dp, 0.01668589503036214_dp, 0.045412158513915044_dp, &
             0.09886416435482326_dp, 0.19648852690779_dp, 0.3731861006919959_dp, &
             0.6885800478141613_dp, 1.2431291028181768_dp, 2.2076885241065622_dp, &
             3.8906895639880266_dp, 6.984079759654594_dp, &
             ! w
             0.007804654340042264_dp, 0.020179039473228334_dp, 0.03881773764993935_dp, &
             0.07123828209592745_dp, 0.12967996499604464_dp, 0.23339590799829762_dp, &
             0.41368187645494986_dp, 0.7229529177297216_dp, 1.2547944496604302_dp, &
             2.2115303605695886_dp, 4.315875214695467_dp]

      CASE (238)

         aw(:) = & ! a
            [0.0021727378031523377_dp, 0.012186596428899627_dp, 0.033865629464411746_dp, &
             0.07603076681008096_dp, 0.1565903606314177_dp, 0.308173763767149_dp, &
             0.58778690361397_dp, 1.0936113751271432_dp, 1.9954974609163636_dp, &
             3.6029405911917065_dp, 6.609943656627655_dp, &
             ! w
             0.005654329530181336_dp, 0.014923845603807212_dp, 0.029841061750614697_dp, &
             0.057386404242061054_dp, 0.1090165155437166_dp, 0.20338355405894115_dp, &
             0.3717369601140614_dp, 0.667264631875859_dp, 1.1853197469033225_dp, &
             2.1303494112152292_dp, 4.22357887008893_dp]

      CASE (239)

         aw(:) = & ! a
            [0.0017251108842001406_dp, 0.00975870366315658_dp, 0.027586318979494935_dp, &
             0.06344777081151343_dp, 0.13418908694113843_dp, 0.2708946251364909_dp, &
             0.5287828806322352_dp, 1.0044247033581155_dp, 1.8668735332583042_dp, &
             3.426263796963456_dp, 6.378103336168637_dp, &
             ! w
             0.004497626052151732_dp, 0.012074116805691842_dp, 0.024895278858103238_dp, &
             0.04954771657188593_dp, 0.09695687927319423_dp, 0.1853828690454563_dp, &
             0.34600844390650487_dp, 0.632482450036626_dp, 1.1413356299301325_dp, &
             2.078553347438098_dp, 4.1646774569138225_dp]

      CASE (240)

         aw(:) = & ! a
            [0.0014423138924763025_dp, 0.008219798589139462_dp, 0.02358071050996141_dp, &
             0.05533215139217533_dp, 0.11952504895081274_dp, 0.2460990065813065_dp, &
             0.48893784639873406_dp, 0.9433780372993746_dp, 1.7778182811830074_dp, &
             3.3028236886633358_dp, 6.21507446845864_dp, &
             ! w
             0.003766288741081957_dp, 0.010260753270741874_dp, 0.021706183150243887_dp, &
             0.04438379397805724_dp, 0.08883047269225096_dp, 0.1730191077007709_dp, &
             0.32805941902406205_dp, 0.6079089945236059_dp, 1.1099636389059035_dp, &
             2.041404419000145_dp, 4.122422598454609_dp]

      CASE (241)

         aw(:) = & ! a
            [0.0011011368472607192_dp, 0.006356190430447665_dp, 0.01869276431717682_dp, &
             0.04529792991109369_dp, 0.10108540562921922_dp, 0.21437076457370233_dp, &
             0.43712168928244916_dp, 0.8628534639195983_dp, 1.6589340653420583_dp, &
             3.1364760958078275_dp, 5.993909833379412_dp, &
             ! w
             0.0028831912480045086_dp, 0.008054789696030526_dp, 0.017764191867862825_dp, &
             0.037842624769486494_dp, 0.07828705211822772_dp, 0.15665995872237118_dp, &
             0.303927329683743_dp, 0.5744369494539767_dp, 1.0668055886728782_dp, &
             1.9900009359991648_dp, 4.063935518109033_dp]

      CASE (242)

         aw(:) = & ! a
            [0.0008275060405979829_dp, 0.0048538992490044595_dp, 0.014709683757547234_dp, &
             0.03697056590495137_dp, 0.08543906157163482_dp, 0.186852311634262_dp, &
             0.39128223664162726_dp, 0.7903843504629097_dp, 1.550400192178853_dp, &
             2.98289946493133_dp, 5.788115495076612_dp, &
             ! w
             0.0021740872264102923_dp, 0.0062654140734613555_dp, 0.014493434412544949_dp, &
             0.03223848021628171_dp, 0.06898803495334238_dp, 0.14189336224047105_dp, &
             0.28173013348362336_dp, 0.5431705675223087_dp, 1.0260142895533086_dp, &
             1.9410767529159068_dp, 4.0082438733806685_dp]

      CASE (243)

         aw(:) = & ! a
            [0.00047633867638452546_dp, 0.002909964655167804_dp, 0.009457493514563445_dp, &
             0.025652164792170237_dp, 0.06344016008115329_dp, 0.14691472784904946_dp, &
             0.32287836144553367_dp, 0.6796431373233776_dp, 1.3812552178932358_dp, &
             2.739865543352038_dp, 5.458966455736076_dp, &
             ! w
             0.0012623682047825586_dp, 0.003925652675398484_dp, 0.01004658375330077_dp, &
             0.024242501459288118_dp, 0.05518051512738748_dp, 0.11927023809408377_dp, &
             0.2468429160149552_dp, 0.49298608655375087_dp, 0.9594751280677348_dp, &
             1.8604943398396532_dp, 3.916442326880172_dp]

      CASE (244)

         aw(:) = & ! a
            [0.00034586004935876314_dp, 0.002180068448344695_dp, 0.0074338002448057355_dp, &
             0.021122671958534404_dp, 0.05429114786508466_dp, 0.1297318847429076_dp, &
             0.2925888019277062_dp, 0.6294124318896298_dp, 1.3030115311584665_dp, &
             2.6257268942687264_dp, 5.302769236620561_dp, &
             ! w
             0.000922883899415914_dp, 0.003034681058102913_dp, 0.008264552339266687_dp, &
             0.020862922814715763_dp, 0.04910404525683061_dp, 0.10899880862103302_dp, &
             0.2305969093077354_dp, 0.46912654138356547_dp, 0.9273310285024502_dp, &
             1.8211892895434076_dp, 3.871623662017366_dp]

      CASE (245)

         aw(:) = & ! a
            [0.0002761320530126241_dp, 0.0017871801758091305_dp, 0.0063237062667975815_dp, &
             0.018574957233231215_dp, 0.04902279026213492_dp, 0.11963878645348468_dp, &
             0.27450111774609626_dp, 0.5990053817796526_dp, 1.2551208194212886_dp, &
             2.5552713219979286_dp, 5.205792916917917_dp, &
             ! w
             0.0007412355914717759_dp, 0.0025500918289050423_dp, 0.007260652343017782_dp, &
             0.018898305189684796_dp, 0.04549056619090046_dp, 0.10278288849115716_dp, &
             0.22062449477394547_dp, 0.4543089394242019_dp, 0.9071881653619919_dp, &
             1.7964239050734692_dp, 3.843367561798431_dp]

      CASE (246)

         aw(:) = & ! a
            [0.0002322146395909956_dp, 0.0015383078777110473_dp, 0.0056097155499255456_dp, &
             0.01690524019317347_dp, 0.0455116261284354_dp, 0.11281827094933433_dp, &
             0.2621385842803853_dp, 0.5780283644600492_dp, 1.2218328763756419_dp, &
             2.5060164008391586_dp, 5.137732154838399_dp, &
             ! w
             0.0006267332758852317_dp, 0.002240499431309514_dp, 0.006601770852296073_dp, &
             0.017580377812750667_dp, 0.043028675267022684_dp, 0.09849704584143885_dp, &
             0.21368155960769558_dp, 0.4439105540875763_dp, 0.892965923250978_dp, &
             1.778872245964063_dp, 3.8233333460474905_dp]

      CASE (247)

         aw(:) = & ! a
            [0.00017937019485878274_dp, 0.0012368771763232084_dp, 0.004729537850198795_dp, &
             0.014804694996910868_dp, 0.04101686411438877_dp, 0.10396278870461453_dp, &
             0.24590220936842966_dp, 0.550218803660413_dp, 1.1773684055533487_dp, &
             2.4398440817448357_dp, 5.045937842151792_dp, &
             ! w
             0.0004888589654993824_dp, 0.0018616953743137686_dp, 0.005771405969229113_dp, &
             0.01588216091220091_dp, 0.03980659796626245_dp, 0.09282001291518131_dp, &
             0.20439489927666582_dp, 0.42989081733198803_dp, 0.8736723641609264_dp, &
             1.7549721269953933_dp, 3.7960404785939112_dp]

      CASE (248)

         aw(:) = & ! a
            [0.00013711729501785012_dp, 0.0009937039401902875_dp, 0.0040024563087556735_dp, &
             0.013025287217430374_dp, 0.03712946550086021_dp, 0.09617646982553832_dp, &
             0.2314355666053776_dp, 0.5251727289213195_dp, 1.1369760622900191_dp, &
             2.3793366605690114_dp, 4.961630042198732_dp, &
             ! w
             0.0003785550695185705_dp, 0.0015517451432116936_dp, 0.005066275361096803_dp, &
             0.014402394221929217_dp, 0.03694817371211211_dp, 0.08771369686719463_dp, &
             0.19594815380436012_dp, 0.4170227140801809_dp, 0.855839089207469_dp, &
             1.7327854324885192_dp, 3.770690478597186_dp]

      CASE (249)

         aw(:) = & ! a
            [8.322776802917285e-05_dp, 0.0006789846232488049_dp, 0.0030262161445555554_dp, &
             0.010550805930632207_dp, 0.03157256088269674_dp, 0.08480476655604943_dp, &
             0.20994413805118853_dp, 0.4874504767676322_dp, 1.075470439657678_dp, &
             2.2864325945367705_dp, 4.831457842787824_dp, &
             ! w
             0.00023787241240500552_dp, 0.0011410910795990356_dp, 0.004082078710881861_dp, &
             0.012267293008636779_dp, 0.03272778769529988_dp, 0.0800397386211778_dp, &
             0.18307197907468373_dp, 0.39717840089040185_dp, 0.828091222345798_dp, &
             1.6980729553696199_dp, 3.731000175331714_dp]

      CASE (250)

         aw(:) = & ! a
            [6.348423252433597e-05_dp, 0.0005614631095692756_dp, 0.0026458704217153886_dp, &
             0.009551452042587599_dp, 0.029267376085073665_dp, 0.07999047048687996_dp, &
             0.2006996270874012_dp, 0.47101726159173085_dp, 1.0484057106225948_dp, &
             2.245240143304216_dp, 4.773448082651668_dp, &
             ! w
             0.00018637903410584144_dp, 0.0009832196596205357_dp, 0.0036830423775804813_dp, &
             0.011374078549377407_dp, 0.030923673307909894_dp, 0.0767048805977973_dp, &
             0.1774024737754178_dp, 0.3883477284904973_dp, 0.8156424850848444_dp, &
             1.6824209713496043_dp, 3.71309132927725_dp]

      CASE (251)

         aw(:) = & ! a
            [4.681778510201952e-05_dp, 0.0004605499591683695_dp, 0.0023087081448212162_dp, &
             0.00864381633616296_dp, 0.027137006340929144_dp, 0.07548306313644564_dp, &
             0.19195672251086449_dp, 0.45535106823555815_dp, 1.0224408958727922_dp, &
             2.2055334225191645_dp, 4.717353301417677_dp, &
             ! w
             0.00014295682470358455_dp, 0.0008444325077663087_dp, 0.003319674228999414_dp, &
             0.010544379264967827_dp, 0.029224680527137968_dp, 0.073531409505792_dp, &
             0.17196246801986348_dp, 0.3798178817818088_dp, 0.803556031079179_dp, &
             1.6671760315071371_dp, 3.695640346653618_dp]

      CASE (252)

         aw(:) = & ! a
            [3.571906216558647e-05_dp, 0.0003919230767898415_dp, 0.0020718641379196025_dp, &
             0.007991553201685386_dp, 0.025581519027222978_dp, 0.07215319936467512_dp, &
             0.1854393637310578_dp, 0.4435894412459486_dp, 1.0028379881400717_dp, &
             2.175429273739434_dp, 4.674705369175517_dp, &
             ! w
             0.00011405903698367499_dp, 0.0007476279138218427_dp, 0.0030579149948176663_dp, &
             0.00993589863751133_dp, 0.02796320103187524_dp, 0.07115305887788502_dp, &
             0.16785529241781696_dp, 0.37333970513687387_dp, 0.7943349361889072_dp, &
             1.6555123760808559_dp, 3.6822834226183354_dp]

      CASE (253)

         aw(:) = & ! a
            [3.550348465924681e-05_dp, 0.0003905739575885531_dp, 0.0020671330057150483_dp, &
             0.00797838466010411_dp, 0.02554988645008824_dp, 0.07208512275482128_dp, &
             0.18530557881445084_dp, 0.4433472301960455_dp, 1.0024332764988158_dp, &
             2.174806566306048_dp, 4.67382205788286_dp, &
             ! w
             0.00011349768781191745_dp, 0.0007457000167406751_dp, 0.00305262454150563_dp, &
             0.009923500448762425_dp, 0.02793735378855931_dp, 0.07110412222577314_dp, &
             0.16777050240847788_dp, 0.37320560837397676_dp, 0.794143662646913_dp, &
             1.6552701124330567_dp, 3.6820059233978353_dp]

      CASE (254)

         aw(:) = & ! a
            [0.02767312926220816_dp, 0.14728661310153135_dp, 0.3687581752417785_dp, &
             0.7039332404419827_dp, 1.172365441249489_dp, 1.8045683154882166_dp, &
             2.646952430489296_dp, 3.7693192226293997_dp, 5.27735243988307_dp, &
             7.338174973596355_dp, 10.248846166739662_dp, 14.70999228737189_dp, &
             ! w
             0.07118467663536959_dp, 0.16908953223627346_dp, 0.2757926387649255_dp, &
             0.3977636094386997_dp, 0.54410574348806_dp, 0.7279147631051287_dp, &
             0.9682939484624312_dp, 1.2936786640404163_dp, 1.7493131133110282_dp, &
             2.418770402622885_dp, 3.5024366140575562_dp, 5.785552407989267_dp]

      CASE (255)

         aw(:) = & ! a
            [0.016621986833340294_dp, 0.08887641901396574_dp, 0.22446216418490886_dp, &
             0.43430080891188433_dp, 0.7372692134906315_dp, 1.1640767884289862_dp, &
             1.76265927443391_dp, 2.6056037700656303_dp, 3.802129378655715_dp, &
             5.522886860404714_dp, 8.066542148084695_dp, 12.124597250003708_dp, &
             ! w
             0.04280253466281205_dp, 0.10261564373695731_dp, 0.1703341135440457_dp, &
             0.2524250366464258_dp, 0.35854064076296327_dp, 0.5029449307365429_dp, &
             0.7061343335450083_dp, 0.9975940043005186_dp, 1.4229943025732463_dp, &
             2.0653230769823834_dp, 3.120898077906089_dp, 5.351475189683586_dp]

      CASE (256)

         aw(:) = & ! a
            [0.012217590485622118_dp, 0.06554383522960264_dp, 0.16659237203973748_dp, &
             0.32558270571482617_dp, 0.5606935393689713_dp, 0.9021601691438875_dp, &
             1.397705445731634_dp, 2.119903667111354_dp, 3.1783136457891827_dp, &
             4.744534993463762_dp, 7.1183009631362095_dp, 10.988266599537688_dp, &
             ! w
             0.031484785005288264_dp, 0.07598807870443566_dp, 0.12776669458080814_dp, &
             0.19317510324206744_dp, 0.2819959712025566_dp, 0.4087743922620433_dp, &
             0.5942255934432832_dp, 0.8680605358456985_dp, 1.2764587208952323_dp, &
             1.903008836197448_dp, 2.943222654358237_dp, 5.149016836830881_dp]

      CASE (257)

         aw(:) = & ! a
            [0.009787250213222088_dp, 0.05264669751460476_dp, 0.1345082558306065_dp, &
             0.2650565360294569_dp, 0.46186942457185204_dp, 0.7545813463702145_dp, &
             1.190270456056405_dp, 1.8408744447358316_dp, 2.8156533824155634_dp, &
             4.286609772539828_dp, 6.554364102152325_dp, 10.306420412806078_dp, &
             ! w
             0.025237117064509148_dp, 0.061238802880255835_dp, 0.10405085556044878_dp, &
             0.15990524330983047_dp, 0.23857118674932304_dp, 0.35458212495967756_dp, &
             0.5285932206532509_dp, 0.7904471850597391_dp, 1.1868782571026184_dp, &
             1.8022353684717614_dp, 2.831945778444912_dp, 5.022182355440811_dp]

      CASE (258)

         aw(:) = & ! a
            [0.008226923180261456_dp, 0.04435476571968886_dp, 0.11382938114522073_dp, &
             0.225910987843479_dp, 0.3976625203871757_dp, 0.6581133163982475_dp, &
             1.0535979897201335_dp, 1.6552845367932827_dp, 2.571982747933977_dp, &
             3.9759001427243166_dp, 6.1684054473566166_dp, 9.836513308538686_dp, &
             ! w
             0.021224651302760023_dp, 0.05173983688640228_dp, 0.08870403403015269_dp, &
             0.13823277713967072_dp, 0.21002162997077486_dp, 0.31848388786257004_dp, &
             0.48414783544765566_dp, 0.736976098003317_dp, 1.1242221404269488_dp, &
             1.730958028955162_dp, 2.75276052749726_dp, 4.931935957863172_dp]

      CASE (259)

         aw(:) = & ! a
            [0.0071319631843329125_dp, 0.0385288520026887_dp, 0.09926949796073953_dp, &
             0.19826580289961176_dp, 0.35213340700048434_dp, 0.5893267643752341_dp, &
             0.955441720557511_dp, 1.5208802148863778_dp, 2.3939769277419587_dp, &
             3.7470487790881046_dp, 5.882102309653825_dp, 9.485972661585034_dp, &
             ! w
             0.018408098383937928_dp, 0.045056081276050215_dp, 0.07786113143898855_dp, &
             0.122831059386808_dp, 0.18956093445734312_dp, 0.2923043033618055_dp, &
             0.4514544295919487_dp, 0.6970886541216346_dp, 1.076924350663281_dp, &
             1.6766859343620684_dp, 2.6921885124990736_dp, 4.862917181590072_dp]

      CASE (260)

         aw(:) = & ! a
            [0.006317001356062951_dp, 0.034188087739164805_dp, 0.08840086940238588_dp, &
             0.1775737848854597_dp, 0.31792844578021495_dp, 0.5373835811949759_dp, &
             0.8808348910539449_dp, 1.4179620136198705_dp, 2.256637850632205_dp, &
             3.5692344888793874_dp, 5.6583087139239066_dp, 9.210677590301046_dp, &
             ! w
             0.01631125461774546_dp, 0.04006973564565049_dp, 0.0697424933664369_dp, &
             0.1112380896871292_dp, 0.1740396434997305_dp, 0.2722299633243372_dp, &
             0.4260759427480407_dp, 0.6657626611697179_dp, 1.0394169828252717_dp, &
             1.6333462645016368_dp, 2.6436380689380594_dp, 4.807608641074463_dp]

      CASE (261)

         aw(:) = & ! a
            [0.005684475858101966_dp, 0.030815812656619954_dp, 0.07994292383209656_dp, &
             0.16143190116044875_dp, 0.291152971588611_dp, 0.49652875773662286_dp, &
             0.8218028957748642_dp, 1.335985987778696_dp, 2.1465138972910536_dp, &
             3.425780060211239_dp, 5.476821513760035_dp, 8.986526926934294_dp, &
             ! w
             0.014683440378687724_dp, 0.0361914353823823_dp, 0.06340726558223926_dp, &
             0.10214785527990394_dp, 0.1617806182160849_dp, 0.2562191165902424_dp, &
             0.40561646277705926_dp, 0.6402570726581068_dp, 1.0086292613465813_dp, &
             1.5975625195441152_dp, 2.6034273539351465_dp, 4.761810257792545_dp]

      CASE (262)

         aw(:) = & ! a
            [0.005177883653409764_dp, 0.028112585847666887_dp, 0.0731525476894913_dp, &
             0.14844332176028877_dp, 0.26953853518176357_dp, 0.4634018779090883_dp, &
             0.7736733807857686_dp, 1.2687470578926419_dp, 2.055648798399003_dp, &
             3.3067709916274914_dp, 5.3255742673945_dp, 8.79907055107436_dp, &
             ! w
             0.013379449457657585_dp, 0.03307930263759621_dp, 0.0583083622425076_dp, &
             0.09479860562631726_dp, 0.1518020216293596_dp, 0.24306983539405944_dp, &
             0.38865380693947577_dp, 0.6189288727611131_dp, 0.9827038031723337_dp, &
             1.5672784492918068_dp, 2.5693057474657723_dp, 4.722954399845834_dp]

      CASE (263)

         aw(:) = & ! a
            [0.004762117357297583_dp, 0.025892231189378046_dp, 0.06756718406524467_dp, &
             0.13773723574799498_dp, 0.25166827727237495_dp, 0.4358989325752496_dp, &
             0.7335111188980595_dp, 1.2123305594792853_dp, 1.978999373338425_dp, &
             3.2058935052153563_dp, 5.196850709872084_dp, 8.639036294627692_dp, &
             ! w
             0.01230904592078374_dp, 0.03052060654576384_dp, 0.05410461513536041_dp, &
             0.08871396312775404_dp, 0.14348763916152588_dp, 0.23202358585890717_dp, &
             0.37428328477056766_dp, 0.6007236370303556_dp, 0.9604392175073997_dp, &
             1.5411563493400489_dp, 2.5398045743466136_dp, 4.689365635807877_dp]

      CASE (264)

         aw(:) = & ! a
            [0.002734772548216079_dp, 0.015033916035287382_dp, 0.040110919550103284_dp, &
             0.08469311373235947_dp, 0.16209254870784667_dp, 0.29585299509549345_dp, &
             0.525182239750685_dp, 0.9139677614786229_dp, 1.5660334617940184_dp, &
             2.6532976247909676_dp, 4.481951863229659_dp, 7.740949632915444_dp, &
             ! w
             0.0070860134344731774_dp, 0.01796384745053746_dp, 0.03326483860847221_dp, &
             0.05805971178818426_dp, 0.10057714481103108_dp, 0.17333339296520517_dp, &
             0.2957310433985091_dp, 0.49871603403504905_dp, 0.83315161426675_dp, &
             1.3896105342194978_dp, 2.367294950712571_dp, 4.4930548591707975_dp]

      CASE (265)

         aw(:) = & ! a
            [0.0019724053061639557_dp, 0.010930068316984159_dp, 0.029639159205617847_dp, &
             0.06417083780725863_dp, 0.126692767641025_dp, 0.2389728369268008_dp, &
             0.43796655665209683_dp, 0.7852367571901353_dp, 1.3828078771058658_dp, &
             2.402073550428113_dp, 4.150438718514592_dp, 7.318326982604391_dp, &
             ! w
             0.005119598334286014_dp, 0.01318928537450709_dp, 0.02519760960181168_dp, &
             0.045838577075039494_dp, 0.08274424240086012_dp, 0.14782334419627308_dp, &
             0.26017272629411214_dp, 0.45093045744030513_dp, 0.7718498864664847_dp, &
             1.3151307967790185_dp, 2.281566539053284_dp, 4.395551521193392_dp]

      CASE (266)

         aw(:) = & ! a
            [0.00156320176896099_dp, 0.008719429282445866_dp, 0.023961109876658067_dp, &
             0.0529226964629682_dp, 0.1069822237653646_dp, 0.20669168458800416_dp, &
             0.38747343994181427_dp, 0.7092770597551052_dp, 1.272817610450666_dp, &
             2.249019230469243_dp, 3.94605690383392_dp, 7.055504983503552_dp, &
             ! w
             0.00406322999100781_dp, 0.0106063465272963_dp, 0.020775731297102012_dp, &
             0.038990282127968_dp, 0.07246291949761123_dp, 0.13270410923150439_dp, &
             0.23859287372275573_dp, 0.4213494413144101_dp, 0.7332827906426044_dp, &
             1.2677049097445012_dp, 2.2266091411905946_dp, 4.333056111653106_dp]

      CASE (267)

         aw(:) = & ! a
            [0.0013049277071097104_dp, 0.007320172278045236_dp, 0.020347839561300884_dp, &
             0.04570046774727458_dp, 0.09416383067198496_dp, 0.1853856908569084_dp, &
             0.35364802698136605_dp, 0.6576800518814916_dp, 1.1971736850908161_dp, &
             2.1426416636948535_dp, 3.802802086222116_dp, 6.8701597226829625_dp, &
             ! w
             0.003396042287459571_dp, 0.008965861319430082_dp, 0.017936773769428257_dp, &
             0.03451341490836681_dp, 0.06559528308063958_dp, 0.12240405308635692_dp, &
             0.22364618721018073_dp, 0.4005751196598172_dp, 0.7058874382446316_dp, &
             1.2337273932034403_dp, 2.1870446405759956_dp, 4.288066679809135_dp]

      CASE (268)

         aw(:) = & ! a
            [0.000993683472150266_dp, 0.005628371952263191_dp, 0.01595141882853389_dp, &
             0.036817978762499176_dp, 0.07816337835263072_dp, 0.15834925822365145_dp, &
             0.3100284584585824_dp, 0.5901523820112894_dp, 1.096873044119201_dp, &
             2.0000185378949156_dp, 3.6090366250071586_dp, 6.617868081069637_dp, &
             ! w
             0.002591396443098623_dp, 0.006974568747265797_dp, 0.014445878248169917_dp, &
             0.028891038917439545_dp, 0.05676567335226572_dp, 0.10888726021450111_dp, &
             0.20369414604773922_dp, 0.3724435069704642_dp, 0.6683474147663148_dp, &
             1.1867479034725879_dp, 2.1320583937567417_dp, 4.22553878529586_dp]

      CASE (269)

         aw(:) = & ! a
            [0.0007444374958604835_dp, 0.004267483163526778_dp, 0.01238341904919077_dp, &
             0.029499518285170032_dp, 0.06471515255300529_dp, 0.13514013046615872_dp, &
             0.2718256002117981_dp, 0.5299318074134547_dp, 1.0060016003098822_dp, &
             1.869072580692834_dp, 3.42925262833547_dp, 6.382014136726755_dp, &
             ! w
             0.001946354897725961_dp, 0.005364126523625145_dp, 0.011570567870099505_dp, &
             0.02412623896654783_dp, 0.04906122192210912_dp, 0.09680064117270458_dp, &
             0.1854888010464085_dp, 0.3463341660098126_dp, 0.6330104554036071_dp, &
             1.1420476000340243_dp, 2.0794138334222345_dp, 4.1656658270973_dp]

      CASE (270)

         aw(:) = & ! a
            [0.0004253461425896496_dp, 0.0025124573159036588_dp, 0.007711033123349251_dp, &
             0.019666768891738344_dp, 0.04606996645974101_dp, 0.10193456174953619_dp, &
             0.21557145284519655_dp, 0.43896854975244937_dp, 0.8656822115642425_dp, &
             1.6631068381675098_dp, 3.142330171348081_dp, 6.001714225275986_dp, &
             ! w
             0.001119157921380432_dp, 0.0032686761628313806_dp, 0.007708739991268936_dp, &
             0.017432462565101902_dp, 0.03778046628285069_dp, 0.07850101026832947_dp, &
             0.15715272263412114_dp, 0.3047343816013479_dp, 0.5755987681276237_dp, &
             1.0683278448896232_dp, 1.991827320223211_dp, 4.066017442783831_dp]

      CASE (271)

         aw(:) = & ! a
            [0.0003071487155038261_dp, 0.0018562367167545763_dp, 0.005926962713218073_dp, &
             0.01578531225429062_dp, 0.038431367060375164_dp, 0.08784952530017573_dp, &
             0.19096824701843967_dp, 0.3981208018572958_dp, 0.8012392220997078_dp, &
             1.566739379849031_dp, 3.0061217791432275_dp, 5.8193331245322035_dp, &
             ! w
             0.0008121033978678006_dp, 0.002475891449187961_dp, 0.0061840387301675456_dp, &
             0.014647615943609724_dp, 0.032879924438971635_dp, 0.07027723931085329_dp, &
             0.14405963768242985_dp, 0.2850571929983485_dp, 0.5479078906024393_dp, &
             1.0322349251234493_dp, 1.948564005643397_dp, 4.016770558125771_dp]

      CASE (272)

         aw(:) = & ! a
            [0.00024410845884712435_dp, 0.001503965954085424_dp, 0.00495431741873133_dp, &
             0.013620324176661923_dp, 0.034069498653249104_dp, 0.07963642987258447_dp, &
             0.1763621932285932_dp, 0.37349824006702287_dp, 0.7618906435501059_dp, &
             1.5072708912101296_dp, 2.9213720831136536_dp, 5.705202579937019_dp, &
             ! w
             0.0006481129780097904_dp, 0.0020466770735909014_dp, 0.005333058743876843_dp, &
             0.013042184119851218_dp, 0.02998380183138278_dp, 0.06532249265267938_dp, &
             0.1360452092785601_dp, 0.2728507539383112_dp, 0.5305383007341931_dp, &
             1.0094001089269478_dp, 1.9210522466051994_dp, 3.985441972650604_dp]

      CASE (273)

         aw(:) = & ! a
            [0.00020445702266883183_dp, 0.001281256958284562_dp, 0.004331576125033463_dp, &
             0.012209581331053501_dp, 0.031178020766606883_dp, 0.07411040155756039_dp, &
             0.16641059131119462_dp, 0.3565435846098175_dp, 0.7345542696373139_dp, &
             1.465654518888358_dp, 2.861727762472194_dp, 5.6245660855886985_dp, &
             ! w
             0.0005448622032481286_dp, 0.001773432389097132_dp, 0.004778122743988018_dp, &
             0.011970700521301728_dp, 0.028017415245052215_dp, 0.06191327500495124_dp, &
             0.13047012959118923_dp, 0.2642812084313893_dp, 0.5182503659100501_dp, &
             0.9931501845600177_dp, 1.9014045488724225_dp, 3.963061960527494_dp]

      CASE (274)

         aw(:) = & ! a
            [0.00015680129241092775_dp, 0.0010120177099265388_dp, 0.003567435469483656_dp, &
             0.01044442956687408_dp, 0.027493628154220823_dp, 0.06695941940829239_dp, &
             0.15336555072636895_dp, 0.3340773637667245_dp, 0.6980031233317447_dp, &
             1.4095969802818262_dp, 2.780925706814588_dp, 5.514893295772328_dp, &
             ! w
             0.00042064061830746427_dp, 0.001440362888929025_dp, 0.004083002663268586_dp, &
             0.010595792883007661_dp, 0.025449706287729155_dp, 0.05740079837258294_dp, &
             0.12300842150184972_dp, 0.25270414931933_dp, 0.5015205762704295_dp, &
             0.9708929815731903_dp, 1.874395859947349_dp, 3.932287409204537_dp]

      CASE (275)

         aw(:) = & ! a
            [0.00011872520483091538_dp, 0.0007951872127706306_dp, 0.002939312555228744_dp, &
             0.008956825862427074_dp, 0.024318736549766254_dp, 0.06068283979249307_dp, &
             0.1417406039031726_dp, 0.3138030384443519_dp, 0.664670854136532_dp, &
             1.358037548959736_dp, 2.7061158915034746_dp, 5.412892843244912_dp, &
             ! w
             0.00032127284046629584_dp, 0.001169004120712643_dp, 0.00349615969152817_dp, &
             0.009401211526504768_dp, 0.02317272329168829_dp, 0.053335496528745405_dp, &
             0.11619870985460978_dp, 0.242023840172228_dp, 0.48594762151819965_dp, &
             0.9500306179525972_dp, 1.848973326909618_dp, 3.903308669782224_dp]

      CASE (276)

         aw(:) = & ! a
            [7.008775402149382e-05_dp, 0.000514603341447927_dp, 0.002098964346237113_dp, &
             0.0068925799028730994_dp, 0.01977566522553707_dp, 0.051476174041109345_dp, &
             0.12434197056428334_dp, 0.28295181355533494_dp, 0.6132492392975714_dp, &
             1.277605091192352_dp, 2.588407362029324_dp, 5.251456362040042_dp, &
             ! w
             0.00019418571177335728_dp, 0.000810864352634179_dp, 0.002679316147965226_dp, &
             0.00767337842141309_dp, 0.01978936954067177_dp, 0.047167641120222_dp, &
             0.10568998356363599_dp, 0.22530693312206004_dp, 0.46128519787253686_dp, &
             0.9166901694437996_dp, 1.808120167667663_dp, 3.856714277189032_dp]

      CASE (277)

         aw(:) = & ! a
            [5.2138943102830404e-05_dp, 0.000409306526224381_dp, 0.0017704069260422984_dp, &
             0.0060528420260062485_dp, 0.017868708168537473_dp, 0.047515945104408215_dp, &
             0.1167105055867729_dp, 0.26920332146424586_dp, 0.5900340204014407_dp, &
             1.2409091384781628_dp, 2.534271438492348_dp, 5.176802135930046_dp, &
             ! w
             0.00014726020232260983_dp, 0.0006729441549679708_dp, 0.0023457790853374234_dp, &
             0.0069407052297282635_dp, 0.01831668661440417_dp, 0.044428524253441744_dp, &
             0.10094689382399291_dp, 0.21766012257552927_dp, 0.44987888309975665_dp, &
             0.9011384471340759_dp, 1.7889649083208523_dp, 3.8348545304578163_dp]

      CASE (278)

         aw(:) = & ! a
            [3.666426779379303e-05_dp, 0.0003171191362127202_dp, 0.0014728761601310882_dp, &
             0.005270021984096421_dp, 0.016051805758001095_dp, 0.04367929297588455_dp, &
             0.10921931955714444_dp, 0.25556352388338877_dp, 0.566802085460325_dp, &
             1.2039297761375631_dp, 2.4794259728407133_dp, 5.10089572719918_dp, &
             ! w
             0.00010681809466084738_dp, 0.0005493937032447625_dp, 0.002033953285766026_dp, &
             0.0062380475151624214_dp, 0.01687918929910473_dp, 0.04171847231017417_dp, &
             0.09620291520770906_dp, 0.20994326535366173_dp, 0.4382833418657671_dp, &
             0.8852388105310183_dp, 1.7693129347305854_dp, 3.812418836388984_dp]

      CASE (279)

         aw(:) = & ! a
            [2.416123354593282e-05_dp, 0.00024094573061246368_dp, 0.0012165203508505715_dp, &
             0.004573330630431546_dp, 0.014396497097563623_dp, 0.040121878233495056_dp, &
             0.10217741169459016_dp, 0.24259997023082036_dp, 0.5445239847651634_dp, &
             1.168213603282065_dp, 2.426163849504265_dp, 5.02690808444167_dp, &
             ! w
             7.417208130549883e-05_dp, 0.00044414355192226227_dp, 0.0017555465728734156_dp, &
             0.005593682473722872_dp, 0.015536312172565325_dp, 0.03915086280491433_dp, &
             0.09165742495916719_dp, 0.20248085367321886_dp, 0.4269852391095038_dp, &
             0.8696564606558904_dp, 1.7499840776440918_dp, 3.7903424576358176_dp]

      CASE (280)

         aw(:) = & ! a
            [1.894164014898326e-05_dp, 0.00020834134170772181_dp, 0.001102573174965553_dp, &
             0.004255354573720039_dp, 0.013626917540883616_dp, 0.03844527490385057_dp, &
             0.09882343542158212_dp, 0.2363736023713517_dp, 0.5337511717653998_dp, &
             1.1508488521066906_dp, 2.400161597773302_dp, 4.990687337267393_dp, &
             ! w
             6.054825300265897e-05_dp, 0.0003977512966816704_dp, 0.0016281580671739016_dp, &
             0.005292662029315792_dp, 0.014899928076456488_dp, 0.037920841856142196_dp, &
             0.08946113299959055_dp, 0.1988498907193317_dp, 0.4214565362923436_dp, &
             0.8619976422582177_dp, 1.7404580408085224_dp, 3.779458581884993_dp]

      CASE (281)

         aw(:) = & ! a
            [1.8934012296256358e-05_dp, 0.0002082931461534274_dp, 0.0011024023520154727_dp, &
             0.004254873447773686_dp, 0.013625745873543612_dp, 0.03844271076566545_dp, &
             0.09881828764566687_dp, 0.23636401719642108_dp, 0.5337345457964074_dp, &
             1.1508219943995057_dp, 2.4001213099764143_dp, 4.990631150994172_dp, &
             ! w
             6.0528329999281435e-05_dp, 0.00039768193515047327_dp, 0.0016279651361197933_dp, &
             0.005292202990367738_dp, 0.014898953114611908_dp, 0.03791895060651046_dp, &
             0.0894577452373523_dp, 0.19884427477508254_dp, 0.42144796502526766_dp, &
             0.8619857428372386_dp, 1.7404432216810901_dp, 3.779441649091308_dp]

      CASE (282)

         aw(:) = & ! a
            [0.025586820712050914_dp, 0.13597714269309533_dp, 0.33948150304260816_dp, &
             0.6452380388667339_dp, 1.0680388682879818_dp, 1.6304515219187843_dp, &
             2.3659824436194987_dp, 3.323714805077131_dp, 4.575354754714008_dp, &
             6.22741235775151_dp, 8.446967193322976_dp, 11.531429023710713_dp, &
             16.1870932176644_dp, &
             ! w
             0.06579511197062445_dp, 0.15581449707044234_dp, 0.2526931220910248_dp, &
             0.3612508995957037_dp, 0.48806015573646977_dp, 0.642274063861049_dp, &
             0.8368561747820078_dp, 1.0903726151683377_dp, 1.4302814690796488_dp, &
             1.9007339128043295_dp, 2.5848157519580366_dp, 3.684622548349423_dp, &
             5.9974171438876_dp]

      CASE (283)

         aw(:) = & ! a
            [0.015352742449764926_dp, 0.08190582986667876_dp, 0.20597658744065508_dp, &
             0.39588447355131207_dp, 0.6656749056064382_dp, 1.0376871217418018_dp, &
             1.546150772948807_dp, 2.24196428609261_dp, 3.199493073654813_dp, &
             4.528287494545492_dp, 6.398138729903282_dp, 9.106778496873513_dp, &
             13.3491215794235_dp, &
             ! w
             0.03951386830420629_dp, 0.09430497087174285_dp, 0.15519500637374517_dp, &
             0.22691929188907797_dp, 0.31632490899004906_dp, 0.4333263112160413_dp, &
             0.5919767118483865_dp, 0.8118655465128661_dp, 1.1210827091354272_dp, &
             1.5638845436284246_dp, 2.2224139656716746_dp, 3.2940777647231294_dp, &
             5.5510419006212235_dp]

      CASE (284)

         aw(:) = & ! a
            [0.01127574349610271_dp, 0.06032239787221326_dp, 0.1525007237397826_dp, &
             0.2955277282819509_dp, 0.5027902095349923_dp, 0.7960938616773462_dp, &
             1.2093501035922478_dp, 1.7933089972016882_dp, 2.622363474304417_dp, &
             3.8064590061885735_dp, 5.516260496116213_dp, 8.050119245723234_dp, &
             12.098989522348345_dp, &
             ! w
             0.02903917514657867_dp, 0.06969309707580232_dp, 0.11591945784093333_dp, &
             0.1723198518541611_dp, 0.24577780538823762_dp, 0.34640460833112163_dp, &
             0.4884592767890423_dp, 0.6916744519623734_dp, 0.9843875484296041_dp, &
             1.4113359869286717_dp, 2.0550145974924656_dp, 3.1115307366236418_dp, &
             5.342250701176915_dp]

      CASE (285)

         aw(:) = & ! a
            [0.009026898154561844_dp, 0.04839933033898771_dp, 0.12288198160156376_dp, &
             0.2397391142273434_dp, 0.41182175891984385_dp, 0.6603888791946663_dp, &
             1.018784626228823_dp, 1.5371450840589502_dp, 2.2893425823845694_dp, &
             3.3851999418594696_dp, 4.995853148865419_dp, 7.4203059140681455_dp, &
             11.347630826479701_dp, &
             ! w
             0.023259371522787082_dp, 0.05607233406744155_dp, 0.09407216033479125_dp, &
             0.14173660359977427_dp, 0.20591056376397773_dp, 0.2967053050336383_dp, &
             0.4283329410906127_dp, 0.6205113431853985_dp, 0.9018119630642786_dp, &
             1.3175182943399095_dp, 1.950675047069855_dp, 2.996916913306896_dp, &
             5.211189067278923_dp]

      CASE (286)

         aw(:) = & ! a
            [0.007583566224204744_dp, 0.04073763079402279_dp, 0.10380803619051947_dp, &
             0.2037030441964128_dp, 0.3528297904687777_dp, 0.5719362889920455_dp, &
             0.8937509529926758_dp, 1.3676956728177228_dp, 2.0670104178735342_dp, &
             3.101260624440397_dp, 4.641888042160206_dp, 6.988499295038847_dp, &
             10.829141964301934_dp, &
             ! w
             0.01954876830141318_dp, 0.047306690644147206_dp, 0.07995321519886125_dp, &
             0.12185677751129535_dp, 0.17979436712684913_dp, 0.26379797808027833_dp, &
             0.3879558647919772_dp, 0.571946108592381_dp, 0.8445649615904518_dp, &
             1.2516047076139492_dp, 1.8766592674405786_dp, 2.9152010854831847_dp, &
             5.117788931492246_dp]

      CASE (287)

         aw(:) = & ! a
            [0.006571003540270054_dp, 0.03535697894808773_dp, 0.09038798510022897_dp, &
             0.17828212453182066_dp, 0.31107006018785655_dp, 0.5090319817929683_dp, &
             0.804294662529962_dp, 1.2455733860384253_dp, 1.9054792787505055_dp, &
             2.8932856501032744_dp, 4.3806489535904545_dp, 6.667715839723064_dp, &
             10.441936803488176_dp, &
             ! w
             0.016944972378415024_dp, 0.0411429334765565_dp, 0.069989346884536_dp, &
             0.10775614466512438_dp, 0.1611404671865264_dp, 0.24006224528660414_dp, &
             0.3584665626662519_dp, 0.5359938990470181_dp, 0.8016474287450003_dp, &
             1.201672057883574_dp, 1.820170175732486_dp, 2.85259527233136_dp, &
             5.0462646056798155_dp]

      CASE (288)

         aw(:) = & ! a
            [0.00581756844645099_dp, 0.03134961581118217_dp, 0.08037675834692043_dp, &
             0.1592740538724147_dp, 0.27974646477337584_dp, 0.4616472946686746_dp, &
             0.7365358864903887_dp, 1.152461515922996_dp, 1.7814423255914706_dp, &
             2.732456742950032_dp, 4.1773180520687125_dp, 6.416654069276692_dp, &
             10.137558331678514_dp, &
             ! w
             0.0150071017032093_dp, 0.03654719753795217_dp, 0.06253657270889061_dp, &
             0.09716122078717658_dp, 0.14703419585189478_dp, 0.22195120873509197_dp, &
             0.3357153160293236_dp, 0.5079360945962476_dp, 0.7678029510712538_dp, &
             1.1619597933934014_dp, 1.774971707625038_dp, 2.802347223798614_dp, &
             4.988882893643294_dp]

      CASE (289)

         aw(:) = & ! a
            [0.005232938971153595_dp, 0.028237522193697503_dp, 0.07259067018283133_dp, &
             0.14445951077075755_dp, 0.2552626614849805_dp, 0.42446316473997137_dp, &
             0.6830922302920382_dp, 1.0785818503932039_dp, 1.6824002197305863_dp, &
             2.603239326783796_dp, 4.013029479317588_dp, 6.2128284447499835_dp, &
             9.88951840694477_dp, &
             ! w
             0.013503115172407102_dp, 0.03297459314353523_dp, 0.056726387700893124_dp, &
             0.08886720981520872_dp, 0.1359255258845317_dp, 0.20757045072921196_dp, &
             0.31747132217542084_dp, 0.48521293975581137_dp, 0.7401508114959612_dp, &
             1.129281387058064_dp, 1.737590139062592_dp, 2.7606812801987437_dp, &
             4.941319591053454_dp]

      CASE (290)

         aw(:) = & ! a
            [0.004764812206990202_dp, 0.025743717023161722_dp, 0.06634309763098721_dp, &
             0.13254918901322424_dp, 0.23552556282645784_dp, 0.39437719281092637_dp, &
             0.6396459009904628_dp, 1.018194486068431_dp, 1.6009832616680564_dp, &
             2.4964300537331274_dp, 3.8765534322194464_dp, 6.042797435469854_dp, &
             9.681926134606167_dp, &
             ! w
             0.012298624445397305_dp, 0.03010915114692234_dp, 0.05205409224682944_dp, &
             0.0821720281454225_dp, 0.12690822677767305_dp, 0.19580758337318957_dp, &
             0.3024160839681164_dp, 0.46629843854623454_dp, 0.7169579916993148_dp, &
             1.1017045394902962_dp, 1.7059067569607391_dp, 2.725287468572967_dp, &
             4.900929525247936_dp]

      CASE (291)

         aw(:) = & ! a
            [0.004380695877988043_dp, 0.023696032529779535_dp, 0.061206817958545164_dp, &
             0.12273976774091432_dp, 0.21922884725225694_dp, 0.36944915428665787_dp, &
             0.6034892573939584_dp, 0.9676872342224387_dp, 1.5325340755817476_dp, &
             2.4061866587862055_dp, 3.760730311086456_dp, 5.897958210150131_dp, &
             9.504578462029908_dp, &
             ! w
             0.011310131876868038_dp, 0.027754333129107387_dp, 0.04820514535602219_dp, &
             0.07663699929378934_dp, 0.11941431361329644_dp, 0.1859624116085837_dp, &
             0.28971433902840205_dp, 0.45021808459781604_dp, 0.6971087365781358_dp, &
             1.0779765276442093_dp, 1.6785411291166155_dp, 2.69465685384593_dp, &
             4.865985188743286_dp]

      CASE (292)

         aw(:) = & ! a
            [0.0025091447649231518_dp, 0.013693954323940598_dp, 0.03600534963956549_dp, &
             0.0742866820971901_dp, 0.13795424770764012_dp, 0.24347562392253488_dp, &
             0.41776894357208094_dp, 0.7035481042365874_dp, 1.1680019135509343_dp, &
             1.91726565781939_dp, 3.1235654399781727_dp, 5.090979407316672_dp, &
             8.506780966608327_dp, &
             ! w
             0.0064910169387615785_dp, 0.01621706891887387_dp, 0.029181234262053293_dp, &
             0.04891003792535065_dp, 0.08111585359226478_dp, 0.13432719007941266_dp, &
             0.22123864262390655_dp, 0.36128939869381554_dp, 0.5848980597832798_dp, &
             0.9414285557062445_dp, 1.5190239900002864_dp, 2.5149049645269637_dp, &
             4.661108986894671_dp]

      CASE (293)

         aw(:) = & ! a
            [0.001806344761894647_dp, 0.009921598041914002_dp, 0.02642548679866468_dp, &
             0.05564594784382461_dp, 0.1061317262233611_dp, 0.19297872173170383_dp, &
             0.341247835854634_dp, 0.5915378195802624_dp, 1.0090348395240913_dp, &
             1.698503088979307_dp, 2.8320126081133545_dp, 4.714893936031113_dp, &
             8.035297141565342_dp, &
             ! w
             0.004679508185843388_dp, 0.01184276418242282_dp, 0.02185653875493935_dp, &
             0.03797172723427941_dp, 0.06546164362694586_dp, 0.11231904712276647_dp, &
             0.1908397923835511_dp, 0.32036737167335694_dp, 0.5316673394828265_dp, &
             0.875036346274796_dp, 1.4400626713409013_dp, 2.4250786861151266_dp, &
             4.558840325251003_dp]

      CASE (294)

         aw(:) = & ! a
            [0.0014294954818313335_dp, 0.007892561660233931_dp, 0.021243656118378387_dp, &
             0.0454727229384415_dp, 0.08853415433528523_dp, 0.16457980344733686_dp, &
             0.29740499192555203_dp, 0.5261556981667116_dp, 0.9146013961828088_dp, &
             1.5664758893112252_dp, 2.6536401907715668_dp, 4.482250787728166_dp, &
             7.741239498452869_dp, &
             ! w
             0.003707454782787126_dp, 0.009481200335284304_dp, 0.01785788759977449_dp, &
             0.031890560274698374_dp, 0.056536120284522984_dp, 0.09942866225608747_dp, &
             0.17259663294033112_dp, 0.2952899874667848_dp, 0.49846247913640174_dp, &
             0.8330134160758221_dp, 1.3895433034020468_dp, 2.367271349260771_dp, &
             4.493058443621265_dp]

      CASE (295)

         aw(:) = & ! a
            [0.0011918361572482998_dp, 0.006609790028561528_dp, 0.017952705675068747_dp, &
             0.03896391960290669_dp, 0.07715294167358444_dp, 0.14596684889042683_dp, &
             0.2682605794022303_dp, 0.4820900184432985_dp, 0.8501377564276386_dp, &
             1.475315159861829_dp, 2.5292704379654323_dp, 4.318759829944416_dp, &
             7.533387743823241_dp, &
             ! w
             0.00309407700416737_dp, 0.00798376946113414_dp, 0.015299313447531767_dp, &
             0.027940576171147948_dp, 0.05062324037940678_dp, 0.0907199318854559_dp, &
             0.1600583567295716_dp, 0.27780021778331876_dp, 0.4750130531377467_dp, &
             0.8030283835320917_dp, 1.353217071700287_dp, 2.3255281638367187_dp, &
             4.445569586002092_dp]

      CASE (296)

         aw(:) = & ! a
            [0.0009057063557368289_dp, 0.0050609742799303005_dp, 0.013957892715390264_dp, &
             0.030992890873339434_dp, 0.06303652695019926_dp, 0.12252994015290011_dp, &
             0.23098802484999104_dp, 0.42489232364695106_dp, 0.7653181374523063_dp, &
             1.3539125860336707_dp, 2.3619293562501906_dp, 4.096957480580569_dp, &
             7.249693224217848_dp, &
             ! w
             0.0023551074366808126_dp, 0.006169560864039772_dp, 0.012165999842184581_dp, &
             0.02301642604983647_dp, 0.0430881697404924_dp, 0.07938914807328232_dp, &
             0.14345232336953492_dp, 0.25428183685705325_dp, 0.4430674773326117_dp, &
             0.7617342359687818_dp, 1.3027813128385979_dp, 2.2673081489216234_dp, &
             4.379349667919726_dp]

      CASE (297)

         aw(:) = & ! a
            [0.0006768696090223793_dp, 0.003817439892751027_dp, 0.01072651642580349_dp, &
             0.024464299529105633_dp, 0.05127171840130901_dp, 0.1026078910917859_dp, &
             0.1986759226082186_dp, 0.37438694444199266_dp, 0.6891677591849794_dp, &
             1.243312621519654_dp, 2.207575740341867_dp, 3.8903332120321474_dp, &
             6.983503032159278_dp, &
             ! w
             0.0017635661455619365_dp, 0.004706110756320155_dp, 0.009600116197389492_dp, &
             0.01888391584913048_dp, 0.036584034840318434_dp, 0.06935918825624371_dp, &
             0.12843766518029287_dp, 0.23262901684656914_dp, 0.41319494401699847_dp, &
             0.7226149903814322_dp, 1.25453089790273_dp, 2.211302264573346_dp, &
             4.315657718002286_dp]

      CASE (298)

         aw(:) = & ! a
            [0.00038452714734484467_dp, 0.002218600873633601_dp, 0.006518782483552045_dp, &
             0.015779014074440583_dp, 0.035172364824389984_dp, 0.0745116209124148_dp, &
             0.15177184191745516_dp, 0.2991167658475698_dp, 0.5729793346936465_dp, &
             1.071061805318608_dp, 1.962978129683943_dp, 3.5583604501642894_dp, &
             6.551558946577899_dp, &
             ! w
             0.0010067371248319557_dp, 0.0028099546056502035_dp, 0.00618802787423932_dp, &
             0.013163809149326671_dp, 0.02720166466963974_dp, 0.05437575286824172_dp, &
             0.10534346464598406_dp, 0.19848144775358342_dp, 0.365055625720691_dp, &
             0.6584198791878357_dp, 1.1742485462233792_dp, 2.117375670194502_dp, &
             4.20884361574561_dp]

      CASE (299)

         aw(:) = & ! a
            [0.0002765305534557809_dp, 0.0016230480146192058_dp, 0.004924194174712558_dp, &
             0.012392626875699645_dp, 0.028674604784592495_dp, 0.06277505950348358_dp, &
             0.1315527145078089_dp, 0.26575193734456104_dp, 0.5202041093762643_dp, &
             0.9911579072113549_dp, 1.8474989877676289_dp, 3.399439816082922_dp, &
             6.3427254429993996_dp, &
             ! w
             0.0007266173762481529_dp, 0.0020964974323044224_dp, 0.00485817671567068_dp, &
             0.010822599427408885_dp, 0.02318605457776981_dp, 0.0477278172991908_dp, &
             0.09478793298707364_dp, 0.18247331930475158_dp, 0.3419906840673959_dp, &
             0.6270943201002195_dp, 1.1345214719922043_dp, 2.07051977057129_dp, &
             4.155550678612812_dp]

      CASE (300)

         aw(:) = & ! a
            [0.0002190369434955462_dp, 0.0013041638214468583_dp, 0.004059496158467338_dp, &
             0.010519066359753125_dp, 0.024997669627579076_dp, 0.05599099115221941_dp, &
             0.11964332368032968_dp, 0.24577445856885485_dp, 0.488152408807871_dp, &
             0.9420361988247535_dp, 1.775783724038284_dp, 3.299957459828327_dp, &
             6.211259721847333_dp, &
             ! w
             0.0005772981384290037_dp, 0.0017117321655301405_dp, 0.004122409744541786_dp, &
             0.009485681360429935_dp, 0.020831898560872888_dp, 0.04374884426072721_dp, &
             0.08836114093280086_dp, 0.17258330268935843_dp, 0.3275606215791396_dp, &
             0.607288120762629_dp, 1.1091987143511128_dp, 2.040510996781803_dp, &
             4.121413407696248_dp]

      CASE (301)

         aw(:) = & ! a
            [0.00018292554248688548_dp, 0.0011029602809106097_dp, 0.003508204077638724_dp, &
             0.009305558270018882_dp, 0.022575689079456448_dp, 0.05145322081026685_dp, &
             0.11157011580444981_dp, 0.2320750581708474_dp, 0.4659542555149446_dp, &
             0.907726951170141_dp, 1.7253408354432977_dp, 3.2295976939344446_dp, &
             6.117918237876528_dp, &
             ! w
             0.00048341836983747076_dp, 0.001467549224849752_dp, 0.0036457480254511606_dp, &
             0.00859915348968931_dp, 0.01924178101950627_dp, 0.04102220781900407_dp, &
             0.0839043742330625_dp, 0.16565495050506554_dp, 0.3173632327682836_dp, &
             0.5931886289713928_dp, 1.0910702058875275_dp, 2.018956366734576_dp, &
             4.096889505593968_dp]

      CASE (302)

         aw(:) = & ! a
            [0.00013959111039492074_dp, 0.0008602478231696832_dp, 0.002834933533612028_dp, &
             0.007796820896148651_dp, 0.019509164130539908_dp, 0.0456141150523087_dp, &
             0.10103628350635624_dp, 0.2139863759050597_dp, 0.4363438111546552_dp, &
             0.8615632167206827_dp, 1.6569797098202836_dp, 3.1337076649686693_dp, &
             5.99020477695265_dp, &
             ! w
             0.0003706377943815103_dp, 0.0011709747407894105_dp, 0.003052834447777809_dp, &
             0.007468703767697578_dp, 0.017175337038177165_dp, 0.03742598157368391_dp, &
             0.07795396841799117_dp, 0.15630785109678166_dp, 0.30348236203184703_dp, &
             0.5738515410841367_dp, 1.0660630760791807_dp, 1.989121140896082_dp, &
             4.0629379599812605_dp]

      CASE (303)

         aw(:) = & ! a
            [0.00010503032595626133_dp, 0.0006653037355264198_dp, 0.002284808747141548_dp, &
             0.00653479029689385_dp, 0.01688516727545049_dp, 0.04051858357228697_dp, &
             0.09168996420612356_dp, 0.19770945978443402_dp, 0.40937831727498003_dp, &
             0.819094877997119_dp, 1.5935618858617477_dp, 3.0441685261321627_dp, &
             5.8704038773647556_dp, &
             ! w
             0.00028056761655329845_dp, 0.0009304915861452455_dp, 0.0025563936765912246_dp, &
             0.006493022545935985_dp, 0.015351319502275317_dp, 0.034195774587582224_dp, &
             0.072531801119424_dp, 0.14768599429281498_dp, 0.2905441729112578_dp, &
             0.5556692375929922_dp, 1.0423899529883427_dp, 1.9607638827744525_dp, &
             4.0306601210273865_dp]

      CASE (304)

         aw(:) = & ! a
            [6.0956302303357914e-05_dp, 0.0004138256560681806_dp, 0.0015544459121753231_dp, &
             0.004798361250838413_dp, 0.013155891287071456_dp, 0.03307746300802235_dp, &
             0.07772964065380825_dp, 0.1729320306822195_dp, 0.3676675397432615_dp, &
             0.7525109383547484_dp, 1.4930192950672836_dp, 2.9009782543357345_dp, &
             5.677660607120728_dp, &
             ! w
             0.0001654908148945107_dp, 0.0006151784699279699_dp, 0.001871869030778897_dp, &
             0.005090033368441002_dp, 0.012648088621176327_dp, 0.029294877358506985_dp, &
             0.0641449465226693_dp, 0.13413056599077305_dp, 0.2699174240072517_dp, &
             0.5263420537685121_dp, 1.0038603898502862_dp, 1.9143610028934042_dp, &
             3.9778209431449656_dp]

      CASE (305)

         aw(:) = & ! a
            [4.468259611956098e-05_dp, 0.00031958277172101316_dp, 0.0012704370862732053_dp, &
             0.004095065206711756_dp, 0.011592626388800938_dp, 0.029870575454816518_dp, &
             0.07157599078255672_dp, 0.16180480043873144_dp, 0.3486416674339012_dp, &
             0.7217412890707888_dp, 1.4460582142493035_dp, 2.833542511723205_dp, &
             5.586367411415857_dp, &
             ! w
             0.00012292811035454133_dp, 0.000494404960373647_dp, 0.0015937643014944905_dp, &
             0.004495058589365715_dp, 0.011466756376369864_dp, 0.02710293595495223_dp, &
             0.0603224187630089_dp, 0.1278538769406165_dp, 0.2602377796731581_dp, &
             0.5124251314491098_dp, 0.9854183262584159_dp, 1.8920351868576104_dp, &
             3.9523876209156668_dp]

      CASE (306)

         aw(:) = & ! a
            [3.059290317116564e-05_dp, 0.00023687354026147777_dp, 0.0010129814071288485_dp, &
             0.0034370642238080416_dp, 0.010092843649304992_dp, 0.026732628752206854_dp, &
             0.06545858862460072_dp, 0.15059872432458815_dp, 0.329273330106885_dp, &
             0.6901352746833209_dp, 1.3974653098481216_dp, 2.7633665911407808_dp, &
             5.490992564617657_dp, &
             ! w
             8.605164165141342e-05_dp, 0.00038623147208030476_dp, 0.0013328549100884563_dp, &
             0.003919749917228889_dp, 0.010300190614591443_dp, 0.02490300747167536_dp, &
             0.056435183477473685_dp, 0.12140061114751656_dp, 0.25019343575120073_dp, &
             0.4978723341593861_dp, 0.9660184769062037_dp, 1.8684653230203156_dp, &
             3.925528352086655_dp]

      CASE (307)

         aw(:) = & ! a
            [1.895213311382775e-05_dp, 0.00016714197755685704_dp, 0.0007862261856894293_dp, &
             0.002835117155929301_dp, 0.00868087251405237_dp, 0.02371259819497883_dp, &
             0.059467448761291966_dp, 0.1394672790474465_dp, 0.3098074145316526_dp, &
             0.6580601213399029_dp, 1.347759389326439_dp, 2.6911441396230593_dp, &
             5.392424421173327_dp, &
             ! w
             5.5585566252102124e-05_dp, 0.0002923026615596326_dp, 0.0010933457681329864_dp, &
             0.0033736175164245734_dp, 0.00916670704022603_dp, 0.022726961980710926_dp, &
             0.05253447378770823_dp, 0.11484741580812091_dp, 0.23989110364890742_dp, &
             0.4828213524067168_dp, 0.9458252126439093_dp, 1.843835848614256_dp, &
             3.8974510845721055_dp]

      CASE (308)

         aw(:) = & ! a
            [1.2631096573461333e-05_dp, 0.00012823114964889898_dp, 0.0006533583639144626_dp, &
             0.00246894477740814_dp, 0.007798455611566926_dp, 0.02178661814865923_dp, &
             0.055585788243469034_dp, 0.13216284059551617_dp, 0.2968998479855184_dp, &
             0.6366075269218335_dp, 1.3142815347706613_dp, 2.6422386687752124_dp, &
             5.325432923990921_dp, &
             ! w
             3.905245929050013e-05_dp, 0.0002379839928024588_dp, 0.000947155383419069_dp, &
             0.003029866845825191_dp, 0.008437929334998805_dp, 0.02130504814726735_dp, &
             0.04995246800201147_dp, 0.11046334300216694_dp, 0.23293749231829983_dp, &
             0.47258778725902156_dp, 0.9320171019691014_dp, 1.8269360619592532_dp, &
             3.8781787480793275_dp]

      CASE (309)

         aw(:) = & ! a
            [1.0714409072106346e-05_dp, 0.00011616318173188649_dp, 0.0006107789893315344_dp, &
             0.002348904241494349_dp, 0.007504570726957518_dp, 0.02113765842610693_dp, &
             0.05426601592774816_dp, 0.12966135357159264_dp, 0.2924534242934999_dp, &
             0.6291816606770987_dp, 1.3026475945125682_dp, 2.6251922772109966_dp, &
             5.302034557078597_dp, &
             ! w
             3.4038922791420766e-05_dp, 0.000220701484722969_dp, 0.0008991359743572639_dp, &
             0.0029149378829502514_dp, 0.008191276251697455_dp, 0.020819342283799648_dp, &
             0.049064011688295966_dp, 0.108945747440993_dp, 0.2305184102400087_dp, &
             0.46901297791286584_dp, 0.9271782595854164_dp, 1.8210023119996728_dp, &
             3.8714105759372774_dp]

      CASE (310)

         aw(:) = & ! a
            [1.0347391661194427e-05_dp, 0.0001138316914487579_dp, 0.0006024601498553105_dp, &
             0.0023252777266436543_dp, 0.007446434516969326_dp, 0.02100880434492859_dp, &
             0.05400321926097351_dp, 0.12916211533151045_dp, 0.2915643750527972_dp, &
             0.6276946181536831_dp, 1.3003150067055842_dp, 2.6217712688276107_dp, &
             5.297335744076939_dp, &
             ! w
             3.3078584812160216e-05_dp, 0.0002173321916008654_dp, 0.0008896788976872138_dp, &
             0.002892175605306567_dp, 0.008142234962777087_dp, 0.020722487658696522_dp, &
             0.04888643421469716_dp, 0.10864184956111259_dp, 0.2300332300492383_dp, &
             0.46829507330399833_dp, 0.9262055359666433_dp, 1.8198087510110939_dp, &
             3.8700490617962435_dp]

      CASE (311)

         aw(:) = & ! a
            [0.023793668953689447_dp, 0.12629694647320955_dp, 0.31461360338889965_dp, &
             0.5959506165914683_dp, 0.98178691600779_dp, 1.4893061716231275_dp, &
             2.1434977755714617_dp, 2.980176648509616_dp, 4.050338926336829_dp, &
             5.4269062114355195_dp, 7.216800700018506_dp, 9.587045277238834_dp, &
             12.835749414907768_dp, 17.675331254557754_dp, &
             ! w
             0.061167271098039745_dp, 0.1445085337560793_dp, 0.23330870431024597_dp, &
             0.33125530133208725_dp, 0.4432467435331535_dp, 0.5759071772555117_dp, &
             0.7383746794403463_dp, 0.943375885464417_dp, 1.2089176341155743_dp, &
             1.5616549458497542_dp, 2.0450074532252134_dp, 2.741985094335031_dp, &
             3.856675506769058_dp, 6.198181331454723_dp]

      CASE (312)

         aw(:) = & ! a
            [0.014264102057225569_dp, 0.07596385221308057_dp, 0.19039853035057047_dp, &
             0.36406075206460514_dp, 0.6076945939410506_dp, 0.9380409019477502_dp, &
             1.3802978464353806_dp, 1.9713646649512173_dp, 2.7641415826304563_dp, &
             3.8339843611569067_dp, 5.290378851043468_dp, 7.3023268339139555_dp, &
             10.167121192094225_dp, 14.583797074551883_dp, &
             ! w
             0.036697133494631565_dp, 0.08727260903458155_dp, 0.14265932551810612_dp, &
             0.20642712177378034_dp, 0.28358973861827835_dp, 0.3812489108142731_dp, &
             0.5093454281471229_dp, 0.6815036880705535_dp, 0.9164311767479404_dp, &
             1.2411293792614433_dp, 1.6988916309365063_dp, 2.371479369041959_dp, &
             3.457751863425088_dp, 5.74024728694743_dp]

      CASE (313)

         aw(:) = & ! a
            [0.010469205433632786_dp, 0.055885282300705635_dp, 0.1406960623012082_dp, &
             0.2708801030466687_dp, 0.45658265580748264_dp, 0.713999068872431_dp, &
             1.0679417676762393_dp, 1.5550829406200728_dp, 2.228212327235486_dp, &
             3.1627623992935905_dp, 4.468652779969455_dp, 6.315645590979072_dp, &
             9.001211922079047_dp, 13.219418343427552_dp, &
             ! w
             0.02694857193241024_dp, 0.06439208283566383_dp, 0.10620510716864073_dp, &
             0.15582262426848184_dp, 0.21823871034834755_dp, 0.30067604733989817_dp, &
             0.4132531737378125_dp, 0.5697250681720737_dp, 0.7889239435759887_dp, &
             1.0981226631535514_dp, 1.5410283271380334_dp, 2.1995131318883794_dp, &
             3.2707215533727316_dp, 5.525548933707593_dp]

      CASE (314)

         aw(:) = & ! a
            [0.008376635467243343_dp, 0.04479919644102725_dp, 0.11319023446557304_dp, &
             0.21914567583183742_dp, 0.37233917623427065_dp, 0.5884689484069489_dp, &
             0.8918422272547547_dp, 1.318584467247321_dp, 1.9209270418492403_dp, &
             2.773912789743336_dp, 3.987478435091623_dp, 5.731868093843135_dp, &
             8.304953050914408_dp, 12.398249969934723_dp, &
             ! w
             0.02157140484578431_dp, 0.05173884593742352_dp, 0.08595433665197048_dp, &
             0.1275363375090656_dp, 0.18142368247815055_dp, 0.25483450865047297_dp, &
             0.3578645442824938_dp, 0.5042194995002234_dp, 0.7127864027157677_dp, &
             1.0111326193554142_dp, 1.4434560698218157_dp, 2.0919781635689985_dp, &
             3.153048296436189_dp, 5.390553588406537_dp]

      CASE (315)

         aw(:) = & ! a
            [0.007033979537092302_dp, 0.03767845776050892_dp, 0.09548945031954283_dp, &
             0.18576388023211604_dp, 0.31779274694968784_dp, 0.5068344028592785_dp, &
             0.7766828152420552_dp, 1.162849189524159_dp, 1.7169175230748923_dp, &
             2.5134448279597255_dp, 3.6622634753022947_dp, 5.333968785846338_dp, &
             7.8268675578464855_dp, 11.830958084696892_dp, &
             ! w
             0.018120390399748474_dp, 0.04360094729961982_dp, 0.07288184584725375_dp, &
             0.10918243318101181_dp, 0.15737533850088423_dp, 0.2246218843896931_dp, &
             0.32092402692893673_dp, 0.45989685263698105_dp, 0.6604755354010544_dp, &
             0.9505074044318574_dp, 1.3746503676746198_dp, 2.015510837239436_dp, &
             3.0690175985474153_dp, 5.294223339872018_dp]

      CASE (316)

         aw(:) = & ! a
            [0.006092281782467828_dp, 0.0326796427354352_dp, 0.08304320403684408_dp, &
             0.16223734107994103_dp, 0.27923353713325183_dp, 0.4489001056044332_dp, &
             0.6945418267921846_dp, 1.0510655723020723_dp, 1.5694187175490266_dp, &
             2.323670781635799_dp, 3.4235072283402714_dp, 5.039793906527383_dp, &
             7.471257554117014_dp, 11.406912447727011_dp, &
             ! w
             0.015699437791355096_dp, 0.03788173333538656_dp, 0.06366548182511249_dp, &
             0.09618473759480022_dp, 0.14024328897973412_dp, 0.20292278108490766_dp, &
             0.2941076299401058_dp, 0.42731861873832927_dp, 0.621538679846388_dp, &
             0.9048675733944339_dp, 1.3223740652817815_dp, 1.9570374697495083_dp, &
             3.004553995154926_dp, 5.22037367009797_dp]

      CASE (317)

         aw(:) = & ! a
            [0.005391735866188923_dp, 0.028957954603636153_dp, 0.07376354638484661_dp, &
             0.14466052258820267_dp, 0.25034735943968095_dp, 0.40534378380722114_dp, &
             0.6324982596023326_dp, 0.9661477674983822_dp, 1.4566423523519518_dp, &
             2.1775887642399563_dp, 3.238510386071566_dp, 4.810487992794182_dp, &
             7.192639119323395_dp, 11.073305447184763_dp, &
             ! w
             0.013898109410051639_dp, 0.03361953824395259_dp, 0.05677783232042905_dp, &
             0.0864325676208157_dp, 0.1273193360592727_dp, 0.18643070735698647_dp, &
             0.27352872709342707_dp, 0.40204660101994955_dp, 0.5910134830489486_dp, &
             0.868752818168269_dp, 1.2806972849123448_dp, 1.910175277355787_dp, &
             2.9527569215812304_dp, 5.161069674409225_dp]

      CASE (318)

         aw(:) = & ! a
            [0.00484825925160011_dp, 0.026068629301107003_dp, 0.06655004077408314_dp, &
             0.1309719715774268_dp, 0.22779534002542953_dp, 0.37122571954561345_dp, &
             0.5836889969345771_dp, 0.8989929313055354_dp, 1.3669355474682265_dp, &
             2.060691761648574_dp, 3.0896188502677946_dp, 4.624971917108687_dp, &
             6.966228180332507_dp, 10.80125317612083_dp, &
             ! w
             0.012500421264673638_dp, 0.030307691418891464_dp, 0.05141246143779468_dp, &
             0.07880839701021243_dp, 0.11716490991039365_dp, 0.1733827405509416_dp, &
             0.25710460680089164_dp, 0.3816850457961545_dp, 0.5661965543161639_dp, &
             0.8391601113814531_dp, 1.2463316648187273_dp, 1.8713633171352735_dp, &
             2.9097642414871805_dp, 5.111871222135591_dp]

      CASE (319)

         aw(:) = & ! a
            [0.004413168781924726_dp, 0.023754010752811715_dp, 0.06076457786681532_dp, &
             0.11997470973785124_dp, 0.20963557196151325_dp, 0.34366743099740693_dp, &
             0.5441054324421765_dp, 0.844268319686792_dp, 1.2934459449065359_dp, &
             1.9644120588566827_dp, 2.9663588112266797_dp, 4.470684882051529_dp, &
             6.7771978107945285_dp, 10.573418176382921_dp, &
             ! w
             0.011381304125104947_dp, 0.027652477612770014_dp, 0.04710099946812233_dp, &
             0.07266153181156448_dp, 0.1089398770918275_dp, 0.16274559652344747_dp, &
             0.2436082848337518_dp, 0.36481237099885855_dp, 0.5454701187758315_dp, &
             0.8142773411254591_dp, 1.217278942214352_dp, 1.8384268358954554_dp, &
             2.873211216315124_dp, 5.070060574632702_dp]

      CASE (320)

         aw(:) = & ! a
            [0.004056224537639509_dp, 0.021853974309257018_dp, 0.05601024565262235_dp, &
             0.11092329056913866_dp, 0.19465685777434072_dp, 0.3208703362477144_dp, &
             0.511237203549927_dp, 0.7986245539444243_dp, 1.2318541070578792_dp, &
             1.8833267887511218_dp, 2.8620729340610342_dp, 4.339610870617615_dp, &
             6.616051909273061_dp, 10.378663116498753_dp, &
             ! w
             0.010463061182274542_dp, 0.025471251874033252_dp, 0.043551694367213026_dp, &
             0.06758571090396688_dp, 0.10211824396619247_dp, 0.15387007964196028_dp, &
             0.2322649456760445_dp, 0.3505246753474143_dp, 0.5277975088592344_dp, &
             0.7929346987934134_dp, 1.1922412421604374_dp, 1.8099472513036932_dp, &
             2.8415520082506047_dp, 5.033861770652594_dp]

      CASE (321)

         aw(:) = & ! a
            [0.002318228823055896_dp, 0.012582373148663025_dp, 0.03271956185523208_dp, &
             0.06632553676179402_dp, 0.12025455907099865_dp, 0.20636944282486241_dp, &
             0.3438043885629948_dp, 0.5622945792714699_dp, 0.9074155937680068_dp, &
             1.4488825900310236_dp, 2.294363498102311_dp, 3.615926928952993_dp, &
             5.715774128586636_dp, 9.28056534370184_dp, &
             ! w
             0.0059897754697515_dp, 0.014799327003276113_dp, 0.02605247704571643_dp, &
             0.042272541370318134_dp, 0.06752646013008466_dp, 0.1078388793634545_dp, &
             0.17190192927606873_dp, 0.27254095421632174_dp, 0.4291033113493527_dp, &
             0.6713790246552778_dp, 1.047359969242586_dp, 1.6432750177593765_dp, &
             2.6552117669183684_dp, 4.8210711548907295_dp]

      CASE (322)

         aw(:) = & ! a
            [0.001666361328381412_dp, 0.009091717350004885_dp, 0.02389076500814641_dp, &
             0.049245714464806946_dp, 0.09133750366284342_dp, 0.16096835309780874_dp, &
             0.27577340973498193_dp, 0.46366223695930214_dp, 0.768288083326851_dp, &
             1.2576815493486098_dp, 2.0385090183531704_dp, 3.282955139328998_dp, &
             5.294434037924235_dp, 8.75989883375243_dp, &
             ! w
             0.00431050555030777_dp, 0.010762996303283687_dp, 0.019344699253129392_dp, &
             0.03236862423762432_dp, 0.05358025504012204_dp, 0.08856507291533267_dp, &
             0.14560785425842068_dp, 0.23730641760902718_dp, 0.38305910746031374_dp, &
             0.6131010801761819_dp, 0.9763482420250424_dp, 1.5602761224141384_dp, &
             2.561660651628839_dp, 4.714407504454591_dp]

      CASE (323)

         aw(:) = & ! a
            [0.001317125050908727_dp, 0.007216593069539949_dp, 0.01912487995618562_dp, &
             0.03995618721778877_dp, 0.07543526951836034_dp, 0.13563310227543893_dp, &
             0.2371598253031562_dp, 0.40667738866120773_dp, 0.686500757576153_dp, &
             1.1434436672367445_dp, 1.883389915309971_dp, 3.07851501265906_dp, &
             5.033059170837773_dp, 8.434387218341376_dp, &
             ! w
             0.0034102793689438035_dp, 0.00858770676444383_dp, 0.015694822236987458_dp, &
             0.02689698752610825_dp, 0.045704926161504116_dp, 0.07740221972288289_dp, &
             0.13000398878108615_dp, 0.21594125807286957_dp, 0.3546111560919621_dp, &
             0.5765112081449788_dp, 0.9311714010393723_dp, 1.5069617811410725_dp, &
             2.501262800806158_dp, 4.645597053062268_dp]

      CASE (324)

         aw(:) = & ! a
            [0.0010970334583767882_dp, 0.00603234068032961_dp, 0.016103087843071007_dp, &
             0.03402965537383759_dp, 0.06519718711042698_dp, 0.1191293407601384_dp, &
             0.2116738402433356_dp, 0.36856118641837915_dp, 0.6310911840532925_dp, &
             1.0651302197216859_dp, 1.7759219386721268_dp, 2.935585417502371_dp, &
             4.848974717177059_dp, 8.203864682046829_dp, &
             ! w
             0.002842666311093802_dp, 0.007210324160903711_dp, 0.013365727519587825_dp, &
             0.0233612862120285_dp, 0.040526365073116286_dp, 0.06992153045699963_dp, &
             0.11936365985825013_dp, 0.2011495081893048_dp, 0.3346541988448492_dp, &
             0.5505486506765955_dp, 0.8988127429424152_dp, 1.4685085046890018_dp, &
             2.457538764929661_dp, 4.595806077787992_dp]

      CASE (325)

         aw(:) = & ! a
            [0.0008322695037266466_dp, 0.0046041779357021044_dp, 0.01244213757850956_dp, &
             0.026796443186325423_dp, 0.052566141462612966_dp, 0.09849126392519111_dp, &
             0.17933349904469312_dp, 0.31948641371298403_dp, 0.5587657706361328_dp, &
             0.9616156945673737_dp, 1.632272275282876_dp, 2.7426945317859523_dp, &
             4.598610352054523_dp, 7.888529242760485_dp, &
             ! w
             0.0021594492963257278_dp, 0.005544274203005808_dp, 0.010522682293089395_dp, &
             0.01898044963568778_dp, 0.0339808497464532_dp, 0.06027111111097718_dp, &
             0.10538515841359175_dp, 0.1814084463685946_dp, 0.3076509595262928_dp, &
             0.5149978645662089_dp, 0.8540615398602766_dp, 1.4149345700297018_dp, &
             2.3963776420823_dp, 4.526187182673834_dp]

      CASE (326)

         aw(:) = & ! a
            [0.0006207557929943959_dp, 0.0034593749933095317_dp, 0.00948884518046029_dp, &
             0.02090054667171633_dp, 0.0421152120539184_dp, 0.08110525250097157_dp, &
             0.15157149669631095_dp, 0.2765844306591898_dp, 0.4944571460594124_dp, &
             0.8681492267517379_dp, 1.500790443602208_dp, 2.564082798645993_dp, &
             4.364606150011944_dp, 7.5917614754962415_dp, &
             ! w
             0.0016132124497670363_dp, 0.00420331796732863_dp, 0.00820516814263875_dp, &
             0.015334374359018485_dp, 0.028388806800141737_dp, 0.0518157306160421_dp, &
             0.0928668402052448_dp, 0.16339320159873136_dp, 0.2825994389709872_dp, &
             0.48154081648437635_dp, 0.8114387138683526_dp, 1.3634496747327067_dp, &
             2.3373123988437143_dp, 4.458980609708005_dp]

      CASE (327)

         aw(:) = & ! a
            [0.0003510368022941439_dp, 0.001991370297862904_dp, 0.005660955552562638_dp, &
             0.013120833766572953_dp, 0.027978805324674217_dp, 0.05691665897610339_dp, &
             0.11184337459575114_dp, 0.21354011284411326_dp, 0.39763380584307784_dp, &
             0.7243220713184966_dp, 1.2945431454910699_dp, 2.2792966515798136_dp, &
             3.986588778702906_dp, 7.10774102165579_dp, &
             ! w
             0.0009157569104258144_dp, 0.002472193770080037_dp, 0.005147847078762964_dp, &
             0.010354088235585797_dp, 0.020440799298929627_dp, 0.03936088428275196_dp, &
             0.07385970672203142_dp, 0.1353151948841132_dp, 0.24264830676571894_dp, &
             0.42710268361778675_dp, 0.7409052083663801_dp, 1.27715698373519_dp, &
             2.23760787462859_dp, 4.345574578366373_dp]

      CASE (328)

         aw(:) = & ! a
            [0.00025163195510559877_dp, 0.0014463966580943882_dp, 0.00421928634217767_dp, &
             0.010119565206226807_dp, 0.022352100147247436_dp, 0.04696516665200164_dp, &
             0.09497611733572855_dp, 0.18599495643301286_dp, 0.3542301980022189_dp, &
             0.6583664765398028_dp, 1.1980745909205335_dp, 2.1438544125498438_dp, &
             3.804408366070667_dp, 6.872224936180135_dp, &
             ! w
             0.0006582780968990025_dp, 0.0018238955102013433_dp, 0.0039689243401756155_dp, &
             0.00834715035690808_dp, 0.017091734724666522_dp, 0.03391225628989364_dp, &
             0.06528123379627732_dp, 0.12229910480859243_dp, 0.22368972347688337_dp, &
             0.40073684144048183_dp, 0.7061527331295446_dp, 1.234083194357158_dp, &
             2.187472583120084_dp, 4.288560018892773_dp]

      CASE (329)

         aw(:) = & ! a
            [0.00019879789350306175_dp, 0.001155266613227247_dp, 0.0034409962587201824_dp, &
             0.008471121868838132_dp, 0.01919615146362964_dp, 0.04126544677289401_dp, &
             0.08512799329935912_dp, 0.16963442951218227_dp, 0.3280570368244356_dp, &
             0.6180615250656186_dp, 1.138440292460392_dp, 2.0593131981714614_dp, &
             3.689818329462071_dp, 6.723268180635575_dp, &
             ! w
             0.0005212677491514955_dp, 0.001475424141415463_dp, 0.003321571161298502_dp, &
             0.007212088049560924_dp, 0.015145745290034129_dp, 0.030676415146612054_dp, &
             0.06009357511543142_dp, 0.11430448144640727_dp, 0.21188560202242127_dp, &
             0.38412470507388513_dp, 0.6840362336317067_dp, 1.2064609599820673_dp, &
             2.155181281852188_dp, 4.25183836321432_dp]

      CASE (330)

         aw(:) = & ! a
            [0.00016565509837365063_dp, 0.0009719040519362572_dp, 0.0029465717920729977_dp, &
             0.00740937623356772_dp, 0.01713075134685372_dp, 0.03747754007118164_dp, &
             0.07849213724446259_dp, 0.15847540973525662_dp, 0.3100135420433681_dp, &
             0.5900153839041758_dp, 1.0966083910583349_dp, 1.999608115087129_dp, &
             3.608459123387142_dp, 6.617103943396409_dp, &
             ! w
             0.0004352427581767984_dp, 0.0012548576180906005_dp, 0.0029046595378673015_dp, &
             0.006464558611470215_dp, 0.013839272006944079_dp, 0.028470484166535776_dp, &
             0.05651194178611248_dp, 0.10872444766731394_dp, 0.2035678909477675_dp, &
             0.3723216049428288_dp, 0.6682119500204294_dp, 1.1865913419286378_dp, &
             2.1318813562162844_dp, 4.225340930493407_dp]

      CASE (331)

         aw(:) = & ! a
            [0.00012593990399240612_dp, 0.0007511606113890969_dp, 0.0023452526412624827_dp, &
             0.006097436900567215_dp, 0.014533480971501483_dp, 0.032635362170355266_dp, &
             0.06988524500770414_dp, 0.143817073802175_dp, 0.2860481254040681_dp, &
             0.55240381972184_dp, 1.0400418005232401_dp, 1.9183099739324458_dp, &
             3.4970663804887807_dp, 6.471180050842394_dp, &
             ! w
             0.00033205236024469117_dp, 0.0009877883512064986_dp, 0.0023894838975166595_dp, &
             0.005518054937658007_dp, 0.012151608899108974_dp, 0.02557555583391717_dp, &
             0.051749652677722136_dp, 0.10122106011972111_dp, 0.19227284584225376_dp, &
             0.35615595907222597_dp, 0.6463818938212137_dp, 1.1590285100821416_dp, &
             2.0994562104528667_dp, 4.188463742112101_dp]

      CASE (332)

         aw(:) = & ! a
            [9.432504161652162e-05_dp, 0.0005743348523820048_dp, 0.0018566487446835668_dp, &
             0.005008541893268789_dp, 0.012329127593858291_dp, 0.02844172371620226_dp, &
             0.06229888069160124_dp, 0.13069903077317394_dp, 0.26431705530112054_dp, &
             0.5179082172316746_dp, 0.9876519994633036_dp, 1.842398000470507_dp, &
             3.392383628136573_dp, 6.333419494072734_dp, &
             ! w
             0.00024979755372032573_dp, 0.0007721386329534672_dp, 0.0019617570439813717_dp, &
             0.0047078208097291975_dp, 0.010671852299116087_dp, 0.022989121646123302_dp, &
             0.04742817482302329_dp, 0.09432095411354324_dp, 0.18176499644466768_dp, &
             0.3409650001887979_dp, 0.6256934039371225_dp, 1.132736399634179_dp, &
             2.0684084060135146_dp, 4.153149177338219_dp]

      CASE (333)

         aw(:) = & ! a
            [5.411491253465531e-05_dp, 0.00034712951476670404_dp, 0.0012134406295876315_dp, &
             0.0035264446522853933_dp, 0.0092288791875334_dp, 0.022372536105391687_dp, &
             0.05104857330359674_dp, 0.11083599543130185_dp, 0.2308180075705037_dp, &
             0.4639056583092208_dp, 0.904547009867386_dp, 1.720649638824277_dp, &
             3.223037137645256_dp, 6.1091989539711875_dp, &
             ! w
             0.00014496785037750894_dp, 0.0004912763971936477_dp, 0.001378902188720698_dp, &
             0.0035543625962753084_dp, 0.008495076648918189_dp, 0.019085692482120022_dp, &
             0.04076655101195879_dp, 0.08349013523408717_dp, 0.16501058496368268_dp, &
             0.3164121765948108_dp, 0.591869702979274_dp, 1.0893701786456509_dp, &
             2.0169320276678824_dp, 4.094586174432079_dp]

      CASE (334)

         aw(:) = & ! a
            [3.9300884986618324e-05_dp, 0.0002623153389586003_dp, 0.0009655315853114956_dp, &
             0.002932105025064018_dp, 0.007940134743043187_dp, 0.019772649033196633_dp, &
             0.04610736632184178_dp, 0.1019272143223431_dp, 0.21552364928462556_dp, &
             0.4388730436176661_dp, 0.8655243916325448_dp, 1.6628681648767378_dp, &
             3.141992361576881_dp, 6.001262340418874_dp, &
             ! w
             0.00010626070791558328_dp, 0.00038450847708988684_dp, 0.0011446716833487984_dp, &
             0.0030688076099272287_dp, 0.007547733414566504_dp, 0.01734252518854569_dp, &
             0.03772804497713254_dp, 0.0784608084602891_dp, 0.15711015119496588_dp, &
             0.3046803290832214_dp, 0.5755275193529117_dp, 1.0682374296805368_dp, &
             1.991720174776034_dp, 4.065895935435006_dp]

      CASE (335)

         aw(:) = & ! a
            [2.6474838971722706e-05_dp, 0.0001879969436971919_dp, 0.0007418596247248935_dp, &
             0.0023783053577616318_dp, 0.0067060613090639725_dp, 0.017227402137173373_dp, &
             0.041181819263646564_dp, 0.09291231300375254_dp, 0.19984996655960596_dp, &
             0.4129422999765327_dp, 0.8247322320497623_dp, 1.6020104793093735_dp, &
             3.05613055764379_dp, 5.8864401090495555_dp, &
             ! w
             7.26984225218588e-05_dp, 0.0002893195987653552_dp, 0.0009259204579195344_dp, &
             0.002599686145099633_dp, 0.006610308897826231_dp, 0.015585353790063133_dp, &
             0.03461837903925443_dp, 0.07324767730849191_dp, 0.14883123612108737_dp, &
             0.29227091156461876_dp, 0.5581052043607662_dp, 1.0455708717528165_dp, &
             1.9645808458523943_dp, 4.035005340705382_dp]

      CASE (336)

         aw(:) = & ! a
            [1.583091392566193e-05_dp, 0.00012520603813060788_dp, 0.0005448204397084741_dp, &
             0.0018700887819500696_dp, 0.005535996249593052_dp, 0.014751340367424074_dp, &
             0.036290041440967064_dp, 0.08380560818355155_dp, 0.1837896860325149_dp, &
             0.38605057200929904_dp, 0.7819973916253243_dp, 1.53771962729618_dp, &
             2.964833415574557_dp, 5.7637950604709385_dp, &
             ! w
             4.481321399041367e-05_dp, 0.0002067554141339402_dp, 0.0007245138992999495_dp, &
             0.0021504886393591276_dp, 0.005687791620873926_dp, 0.013819201766022637_dp, &
             0.031438733990656526_dp, 0.06784025662859389_dp, 0.14013843256663194_dp, &
             0.2791046160922478_dp, 0.5394581270165297_dp, 1.0211465978723961_dp, &
             1.9352189367908148_dp, 4.001575478322477_dp]

      CASE (337)

         aw(:) = & ! a
            [9.879098487133625e-06_dp, 8.921120682367847e-05_dp, 0.00042591995967115117_dp, &
             0.0015496891813780627_dp, 0.004773671233411263_dp, 0.01309699436300676_dp, &
             0.03295591404984426_dp, 0.07749731631973529_dp, 0.1725140716994954_dp, &
             0.36695624751661815_dp, 0.7513652468643365_dp, 1.4912765733052293_dp, &
             2.8984822282192_dp, 5.674287619811761_dp, &
             ! w
             2.9217197910873096e-05_dp, 0.00015774239553229696_dp, 0.0005970685206904868_dp, &
             0.00185517048136989_dp, 0.0050649977665210314_dp, 0.012602399661328837_dp, &
             0.02921201049634923_dp, 0.06400179605954581_dp, 0.1338968878030112_dp, &
             0.26955866677335194_dp, 0.5258281092343448_dp, 1.0031812141289602_dp, &
             1.9135401620880086_dp, 3.976885986963906_dp]

      CASE (338)

         aw(:) = & ! a
            [7.753277327156187e-06_dp, 7.605204330358708e-05_dp, 0.0003806666145700972_dp, &
             0.0014239784197318734_dp, 0.004467972401590203_dp, 0.012422665107787384_dp, &
             0.031579448787572406_dp, 0.07486609461124191_dp, 0.1677709581830264_dp, &
             0.35886717527466633_dp, 0.7383113916383872_dp, 1.4713888415525989_dp, &
             2.869962763920454_dp, 5.635715122518086_dp, &
             ! w
             2.3648127307189253e-05_dp, 0.00013928634487856857_dp, 0.0005469375253764436_dp, &
             0.0017360956451197699_dp, 0.004809547223882456_dp, 0.012096771438445859_dp, &
             0.028277071837355484_dp, 0.062376320873386674_dp, 0.13123476221452038_dp, &
             0.26546235450160005_dp, 0.5199495630844788_dp, 0.9954024569825356_dp, &
             1.9041314494641703_dp, 3.9661684959592667_dp]

      CASE (339)

         aw(:) = & ! a
            [6.696075236885778e-06_dp, 6.940993090965878e-05_dp, 0.00035732186352038304_dp, &
             0.0013581310319656613_dp, 0.004306130142902661_dp, 0.01206283349398925_dp, &
             0.03084043432481198_dp, 0.07344644767858383_dp, 0.16520150343654666_dp, &
             0.3544703630207691_dp, 0.7311960172904285_dp, 1.4605235201037703_dp, &
             2.8543539073991235_dp, 5.614578248780441_dp, &
             ! w
             2.08782574912506e-05_dp, 0.00012981230044218096_dp, 0.0005206466240105108_dp, &
             0.0016728965705399956_dp, 0.004672840820625864_dp, 0.011824481632581034_dp, &
             0.027771081411684398_dp, 0.06149301612074717_dp, 0.12978317872441927_dp, &
             0.2632222906375393_dp, 0.5167271419666196_dp, 0.9911304562174131_dp, &
             1.8989584974329314_dp, 3.960275403412971_dp]

      CASE (340)

         aw(:) = & ! a
            [6.120260181978378e-06_dp, 6.57560511305431e-05_dp, 0.00034430982484925335_dp, &
             0.0013211024594849182_dp, 0.004214562828893384_dp, 0.01185833139217857_dp, &
             0.030418971726480306_dp, 0.07263456481617418_dp, 0.1637287034613831_dp, &
             0.35194534500283137_dp, 0.7271033023740112_dp, 1.4542657643355081_dp, &
             2.845355161303602_dp, 5.6023840927620085_dp, &
             ! w
             1.936916825247699e-05_dp, 0.00012454582047396193_dp, 0.0005058519763189434_dp, &
             0.0016370898195280585_dp, 0.004595022046215853_dp, 0.011668932264647821_dp, &
             0.027481213087688194_dp, 0.060985829088612185_dp, 0.12894808457200949_dp, &
             0.26193148531711846_dp, 0.5148677455824445_dp, 0.9886628439296682_dp, &
             1.8959685802046633_dp, 3.9568690606905945_dp]

      CASE (341)

         aw(:) = & ! a
            [5.779310360886807e-06_dp, 6.357821325660413e-05_dp, 0.00033649100160858427_dp, &
             0.0012987332474693207_dp, 0.0041590436292552775_dp, 0.01173400402932722_dp, &
             0.03016221209209259_dp, 0.07213913881528675_dp, 0.16282875663814733_dp, &
             0.35040070791304617_dp, 0.724597300191373_dp, 1.4504311395006662_dp, &
             2.839837629245966_dp, 5.5949042429760905_dp, &
             ! w
             1.847532346082452e-05_dp, 0.00012138616450563895_dp, 0.0004969107802932144_dp, &
             0.0016153616951963146_dp, 0.004547667195500915_dp, 0.011574075510211794_dp, &
             0.027304150630042847_dp, 0.06067559706847823_dp, 0.1284366973240137_dp, &
             0.2611402694575219_dp, 0.5137270825249222_dp, 0.9871481159900667_dp, &
             1.8941325485709735_dp, 3.9547772395130827_dp]

      CASE (342)

         aw(:) = & ! a
            [0.022236374209981875_dp, 0.11791766919744567_dp, 0.2932181611149397_dp, &
             0.5539290777205831_dp, 0.9091507799137611_dp, 1.372290803221144_dp, &
             1.9625022213863008_dp, 2.7067233856900885_dp, 3.642533914113716_dp, &
             4.822283592881374_dp, 6.319658729817172_dp, 8.241777536872023_dp, &
             10.755677335590809_dp, 14.160475342580211_dp, 19.175063516833696_dp, &
             ! w
             0.057151196247983434_dp, 0.13476098203537124_dp, 0.21679241734108728_dp, &
             0.30613005549755173_dp, 0.4065242973198528_dp, 0.5229143871001193_dp, &
             0.6619515007536857_dp, 0.8326876570348027_dp, 1.0475551694593583_dp, &
             1.3240406119874788_dp, 1.6881745466647176_dp, 2.1829224353081296_dp, &
             2.8914979429762138_dp, 4.020155735554085_dp, 6.389664773839351_dp]

      CASE (343)

         aw(:) = & ! a
            [0.013319986361304756_dp, 0.07083579672152751_dp, 0.17707544003870992_dp, &
             0.3372094560469261_dp, 0.5596497412025824_dp, 0.8572651840652747_dp, &
             1.249100413601347_dp, 1.7626491360944359_dp, 2.436770909892311_dp, &
             3.3256722098160103_dp, 4.50520271619247_dp, 6.0845927692710795_dp, &
             8.232190523166691_dp, 11.24526638554403_dp, 15.827490930567276_dp, &
             ! w
             0.03425707558406306_dp, 0.08123895745525056_dp, 0.13208806420884975_dp, &
             0.1895620574511708_dp, 0.25743475526325454_dp, 0.3409324413871414_dp, &
             0.44727250246519884_dp, 0.5862378479869452_dp, 0.7709416195632693_dp, &
             1.0193233364053462_dp, 1.3575648828950586_dp, 1.8283241651243347_dp, &
             2.513297129714605_dp, 3.613022574802447_dp, 5.920293613177617_dp]

      CASE (344)

         aw(:) = & ! a
            [0.009770683987955369_dp, 0.052065600250376584_dp, 0.13064783675261413_dp, &
             0.2502493155231965_dp, 0.41874801446408033_dp, 0.6484848684705119_dp, &
             0.9580829940330154_dp, 1.374754414402287_dp, 1.9371818079908711_dp, &
             2.6994958848433686_dp, 3.7376744793080214_dp, 5.161396389003349_dp, &
             7.139628574735659_dp, 9.969393775979658_dp, 14.348477927481863_dp, &
             ! w
             0.025140460599849_dp, 0.05986150445520789_dp, 0.09807687730060566_dp, &
             0.14241735374966083_dp, 0.19660642495789066_dp, 0.2659327500342726_dp, &
             0.3577519270311488_dp, 0.48197465447938836_dp, 0.6518014776973908_dp, &
             0.8853077937671971_dp, 1.208952690788188_dp, 1.6657167955120669_dp, &
             2.3371854613987044_dp, 3.421831279185492_dp, 5.700050886680071_dp]

      CASE (345)

         aw(:) = & ! a
            [0.007814083335386305_dp, 0.0417064349886099_dp, 0.10497252408020417_dp, &
             0.20202015970696996_dp, 0.34031535059655627_dp, 0.5317496824765323_dp, &
             0.7944899302065639_dp, 1.1552671367902654_dp, 1.6522434451894115_dp, &
             2.3390686809253647_dp, 3.291457699350984_dp, 4.619206665040386_dp, &
             6.491733402413081_dp, 9.206204449567815_dp, 13.45724445221323_dp, &
             ! w
             0.020113453882336103_dp, 0.04804689001617416_dp, 0.07920474912528992_dp, &
             0.11611217015946855_dp, 0.16242908854580934_dp, 0.22342941349560405_dp, &
             0.3064598852976081_dp, 0.4213902130844776_dp, 0.5814003222278704_dp, &
             0.8046842905645214_dp, 1.118016679838287_dp, 1.5647904440413158_dp, &
             2.2267586807525968_dp, 3.301329533845546_dp, 5.561372468379086_dp]

      CASE (346)

         aw(:) = & ! a
            [0.0065589737028395635_dp, 0.03505508535410041_dp, 0.08845958576104579_dp, &
             0.17092819133140455_dp, 0.2895971214269864_dp, 0.45597509431125866_dp, &
             0.6877928532962936_dp, 1.0112643890368855_dp, 1.46396209397375_dp, &
             2.098978792068047_dp, 2.9916804481492303_dp, 4.251871991065483_dp, &
             6.049327218771119_dp, 8.681471187710688_dp, 12.84095643519424_dp, &
             ! w
             0.016888050445770582_dp, 0.040452365710777934_dp, 0.0670338169082043_dp, &
             0.0990695634544053_dp, 0.1401553278525078_dp, 0.19551843921678796_dp, &
             0.2724397623186262_dp, 0.38069885879339954_dp, 0.5334384650052095_dp, &
             0.7489681402627489_dp, 1.0543592358076195_dp, 1.4933981322491248_dp, &
             2.148075195978754_dp, 3.2151626673716205_dp, 5.462301709306798_dp]

      CASE (347)

         aw(:) = & ! a
            [0.0056788702569020915_dp, 0.03038732653250226_dp, 0.07685464920229881_dp, &
             0.1490327845948825_dp, 0.2537854202184757_dp, 0.4022900808658429_dp, &
             0.6118736806237611_dp, 0.9082474519754038_dp, 1.3284052305443363_dp, &
             1.9248935323363436_dp, 2.7727204966996775_dp, 3.9816530453020174_dp, &
             5.721754809996626_dp, 8.29073958875012_dp, 12.379918566854883_dp, &
             ! w
             0.014625921787252189_dp, 0.035117506444987685_dp, 0.05846019571054044_dp, &
             0.08701656853891046_dp, 0.12432078010685567_dp, 0.17553968940573733_dp, &
             0.2478661231331975_dp, 0.3509786266364573_dp, 0.49798500909446447_dp, &
             0.7073027698955995_dp, 1.0062683560617502_dp, 1.4390235276810452_dp, &
             2.0878094629421766_dp, 3.1489876316118783_dp, 5.386280084251533_dp]

      CASE (348)

         aw(:) = & ! a
            [0.005024274436918441_dp, 0.026913143108849905_dp, 0.0682062998374951_dp, &
             0.13268617365179883_dp, 0.22698556198400419_dp, 0.36199116993088_dp, &
             0.5546589943832143_dp, 0.8302275837852374_dp, 1.2251474742957151_dp, &
             1.7914531635436965_dp, 2.6038082335791435_dp, 3.771918204892345_dp, &
             5.466087357167651_dp, 7.984318517067509_dp, 12.016957660758704_dp, &
             ! w
             0.01294313857608113_dp, 0.031143396217599553_dp, 0.05205762286983721_dp, &
             0.07798404343584268_dp, 0.1123987204649185_dp, 0.1604023598955141_dp, &
             0.22909264975941185_dp, 0.3280493759577527_dp, 0.4703507500452663_dp, &
             0.6745122915667454_dp, 0.968104164489216_dp, 1.3955858527294684_dp, &
             2.039444860968879_dp, 3.0957651278694307_dp, 5.325182143344801_dp]

      CASE (349)

         aw(:) = & ! a
            [0.00451653735813712_dp, 0.024216696398001444_dp, 0.06148639749263848_dp, &
             0.11996390252722296_dp, 0.20608254876660995_dp, 0.330470376569777_dp, &
             0.5097429488165323_dp, 0.7686998504455994_dp, 1.1432889758299511_dp, &
             1.68507155299078_dp, 2.468385959962654_dp, 3.602863723807878_dp, &
             5.259012010579803_dp, 7.735111843845486_dp, 11.720786699599223_dp, &
             ! w
             0.011637695929719756_dp, 0.028056563128754045_dp, 0.047073462681424004_dp, &
             0.07093023318086474_dp, 0.10304837479507904_dp, 0.1484608343730584_dp, &
             0.2141699383993229_dp, 0.30966329040709384_dp, 0.4479943584047823_dp, &
             0.6477664122253113_dp, 0.9367556700653058_dp, 1.3597062225198744_dp, &
             1.9993413337952957_dp, 3.051552625398909_dp, 5.27445878592156_dp]

      CASE (350)

         aw(:) = & ! a
            [0.0041101270238754406_dp, 0.022057130001892678_dp, 0.05609892843875579_dp, &
             0.10974902632500383_dp, 0.18926575471008383_dp, 0.3050446106979406_dp, &
             0.473388051967266_dp, 0.7186895877224461_dp, 1.0764340399712193_dp, &
             1.5977464735297437_dp, 2.3566601731303014_dp, 3.4627257320720157_dp, &
             5.086623533173339_dp, 7.526898140387448_dp, 11.472616340715833_dp, &
             ! w
             0.010592634434090541_dp, 0.02558260773574769_dp, 0.043070796710343195_dp, &
             0.0652489962492778_dp, 0.09548747656979081_dp, 0.1387519341256913_dp, &
             0.20195228350980532_dp, 0.2944915569107426_dp, 0.4294022509808315_dp, &
             0.6253657255484111_dp, 0.9103406991822888_dp, 1.3293276205302154_dp, &
             1.9652732153735464_dp, 3.013934377400175_dp, 5.231323963368795_dp]

      CASE (351)

         aw(:) = & ! a
            [0.0037767636667319993_dp, 0.020284783350103888_dp, 0.051673260806997495_dp, &
             0.1013462127489563_dp, 0.17540646964753462_dp, 0.28403858719520364_dp, &
             0.44325614892799137_dp, 0.677077058827935_dp, 1.0205594158683728_dp, &
             1.5244258129485722_dp, 2.262423525735423_dp, 3.344018507192219_dp, &
             4.940040599987986_dp, 7.349282402405416_dp, 11.26037224551846_dp, &
             ! w
             0.009735303525025218_dp, 0.02355093562907654_dp, 0.039777578408647846_dp, &
             0.06056213114892813_dp, 0.08922669612322283_dp, 0.13067133729833505_dp, &
             0.19171789934992506_dp, 0.2816922494803035_dp, 0.41360870552369505_dp, &
             0.6062180228309941_dp, 0.8876415482272523_dp, 1.303112114550926_dp, &
             1.9357875430219507_dp, 2.9813305239671295_dp, 5.193956481924646_dp]

      CASE (352)

         aw(:) = & ! a
            [0.0021545257831798764_dp, 0.011643650096875076_dp, 0.03002159361496933_dp, &
             0.06002975766012449_dp, 0.10678656324749078_dp, 0.17905295169846994_dp, &
             0.29081998970365036_dp, 0.46348600584637584_dp, 0.7291591909739005_dp, &
             1.1357391474843714_dp, 1.7548471860364_dp, 2.695116115806408_dp, &
             4.1281869152446315_dp, 6.354665973727979_dp, 10.061464318030847_dp, &
             ! w
             0.005561444579369837_dp, 0.013622443101964081_dp, 0.02357504877630784_dp, &
             0.03727297185434665_dp, 0.05767502313601273_dp, 0.08915470712053893_dp, &
             0.13789213957374424_dp, 0.21270878404495483_dp, 0.32649369729261973_dp, &
             0.4983953354087469_dp, 0.7575386633983471_dp, 1.150704588625524_dp, &
             1.7626459217391768_dp, 2.7889482630945155_dp, 4.973804296754859_dp]

      CASE (353)

         aw(:) = & ! a
            [0.0015467042849176954_dp, 0.008395281647213891_dp, 0.021833498105180888_dp, &
             0.04426551232805565_dp, 0.08027493484236987_dp, 0.1377946023687582_dp, &
             0.22961694638506064_dp, 0.3756070866312024_dp, 0.6061451901696485_dp, &
             0.9674225764379704_dp, 1.5296736237746063_dp, 2.4008394966710966_dp, &
             3.7528692640339534_dp, 5.887488128860728_dp, 9.491335915341685_dp, &
             ! w
             0.00399637634878453_dp, 0.009875100905968779_dp, 0.017387396634635732_dp, &
             0.028220974798764165_dp, 0.04509585062219922_dp, 0.07203996361679202_dp, &
             0.11485953787837302_dp, 0.18209812208238063_dp, 0.2865444576764014_dp, &
             0.44750175734874115_dp, 0.6945970376068834_dp, 1.0754922855491433_dp, &
             1.675987119509339_dp, 2.6919852463147227_dp, 4.863059946671454_dp]

      CASE (354)

         aw(:) = & ! a
            [0.0012213088418495538_dp, 0.006652212840138926_dp, 0.017421036052630262_dp, &
             0.03571531963858667_dp, 0.06576084772314154_dp, 0.11492088242881206_dp, &
             0.19516517038963463_dp, 0.3253123101170386_dp, 0.5345514314848429_dp, &
             0.8678657429638242_dp, 1.3944649527164186_dp, 2.2217212147441034_dp, &
             3.5217221726634937_dp, 5.59697902058961_dp, 9.134180652860735_dp, &
             ! w
             0.0031580665533451928_dp, 0.0078585696681408_dp, 0.014029668666190268_dp, &
             0.02324497834093027_dp, 0.0380499461297273_dp, 0.06222888856781097_dp, &
             0.10133876158503932_dp, 0.16373235062412314_dp, 0.26210759057693517_dp, &
             0.4158369767907243_dp, 0.6548585051238817_dp, 1.0274341017750817_dp, &
             1.6201338736773288_dp, 2.6292153158930103_dp, 4.791440233102354_dp]

      CASE (355)

         aw(:) = & ! a
            [0.0010163654596489673_dp, 0.0055523279214757_dp, 0.014627213267154257_dp, &
             0.03027301304168235_dp, 0.05645108226259123_dp, 0.10009822610470911_dp, &
             0.1725709802348771_dp, 0.2919086142773966_dp, 0.4864039250725653_dp, &
             0.8001129679399844_dp, 1.3014354844107494_dp, 2.097263745799141_dp, &
             3.359747856790814_dp, 5.391995406737326_dp, 8.880844953668603_dp, &
             ! w
             0.0026298460390556484_dp, 0.0065832442531841_dp, 0.011891760353531402_dp, &
             0.02004290428535919_dp, 0.033446472957147144_dp, 0.05570395478367397_dp, &
             0.09218995507492977_dp, 0.1511113941004667_dp, 0.2450839575131379_dp, &
             0.3935114036889439_dp, 0.6265467178768755_dp, 0.9928992278647892_dp, &
             1.5797450704374967_dp, 2.583677532614033_dp, 4.73951497299954_dp]

      CASE (356)

         aw(:) = & ! a
            [0.0008744958294475132_dp, 0.0047897439227468615_dp, 0.012684537183536447_dp, &
             0.026471524446639985_dp, 0.04990479669928629_dp, 0.08958471195173273_dp, &
             0.15638598932792558_dp, 0.2677347395888904_dp, 0.45121163531576486_dp, &
             0.7501246982213589_dp, 1.2322057652185714_dp, 2.0039333213152113_dp, &
             3.237480334364189_dp, 5.236429810163087_dp, 8.68780371413627_dp, &
             ! w
             0.0022640577225830362_dp, 0.005697330305768576_dp, 0.010398105760650445_dp, &
             0.017785216586660536_dp, 0.03015875363482246_dp, 0.050976629501325935_dp, &
             0.08547163636018314_dp, 0.14173226938992878_dp, 0.2322996708593134_dp, &
             0.3765894209406676_dp, 0.6049134328425472_dp, 0.966333675141072_dp, &
             1.5485236223280243_dp, 2.5483852865162735_dp, 4.699290104861745_dp]

      CASE (357)

         aw(:) = & ! a
            [0.0007699970490877884_dp, 0.004227263039996045_dp, 0.011247967102625068_dp, &
             0.02364907508575807_dp, 0.04501573330675333_dp, 0.08167319397751645_dp, &
             0.14410347433199278_dp, 0.24923170950722728_dp, 0.42405163921518896_dp, &
             0.7112470016203498_dp, 1.177982638095075_dp, 1.9303738608286636_dp, &
             3.140593991068739_dp, 5.1126181849943695_dp, 8.53366064618028_dp, &
             ! w
             0.001994538063877984_dp, 0.005042790711367482_dp, 0.009288972459623018_dp, &
             0.016095093047755187_dp, 0.027669961291400685_dp, 0.04735487643408512_dp, &
             0.08026756989727749_dp, 0.1343967267489981_dp, 0.22221568187459867_dp, &
             0.3631409974153666_dp, 0.587607506425437_dp, 0.94496571152293_dp, &
             1.5233094274329126_dp, 2.5198228955401025_dp, 4.666746342486291_dp]

      CASE (358)

         aw(:) = & ! a
            [0.0006895611127582456_dp, 0.003793771263036526_dp, 0.010138302361517542_dp, &
             0.02146095802251129_dp, 0.041205263921542445_dp, 0.07546556482301157_dp, &
             0.134395064162407_dp, 0.23449817276910057_dp, 0.4022718771382512_dp, &
             0.6798660151460763_dp, 1.133953764561905_dp, 1.8703271767807597_dp, &
             3.061146420673472_dp, 5.010718338220209_dp, 8.40644792105068_dp, &
             ! w
             0.0017870212715594368_dp, 0.004537600273700881_dp, 0.008429030056570658_dp, &
             0.014775062127092764_dp, 0.025706911662564964_dp, 0.04446868748654226_dp, &
             0.07608185116897298_dp, 0.12844879827351857_dp, 0.21398087768135024_dp, &
             0.35208925142447856_dp, 0.5733069875972592_dp, 0.927227144514161_dp, &
             1.5023065731054268_dp, 2.495987956892389_dp, 4.639595890201489_dp]

      CASE (359)

         aw(:) = & ! a
            [0.0006255780084365578_dp, 0.003448563506901705_dp, 0.009252790051906358_dp, &
             0.019709005547203024_dp, 0.0381394934269199_dp, 0.07044087422946572_dp, &
             0.12648528169149412_dp, 0.22241633640795855_dp, 0.38430207682454826_dp, &
             0.6538272042959847_dp, 1.0972315718134094_dp, 1.8200161955372063_dp, &
             2.994319698223544_dp, 4.9247349165318255_dp, 8.298851830464779_dp, &
             ! w
             0.001621908467086356_dp, 0.004134753100077638_dp, 0.007740459671259435_dp, &
             0.013710985682103825_dp, 0.024110475583018008_dp, 0.04210037037509712_dp, &
             0.07261969647900664_dp, 0.12349486157075798_dp, 0.20708025408375177_dp, &
             0.3427777482480648_dp, 0.5612008838336487_dp, 0.9121508407153058_dp, &
             1.4844032778764127_dp, 2.4756385101249463_dp, 4.616420489631633_dp]

      CASE (360)

         aw(:) = & ! a
            [0.0005733678386173403_dp, 0.0031665856795662917_dp, 0.00852808551109951_dp, &
             0.018270763473988684_dp, 0.03561138654189378_dp, 0.06627456654781967_dp, &
             0.11988821705853822_dp, 0.2122814420767167_dp, 0.36914601818150405_dp, &
             0.6317554902189304_dp, 1.0659628718482381_dp, 1.7770046979357534_dp, &
             2.936992734626107_dp, 4.8507701846577405_dp, 8.20610444968673_dp, &
             ! w
             0.0014871445606266375_dp, 0.0038052862730260425_dp, 0.007175164832047987_dp, &
             0.012831987215754884_dp, 0.022781135733066275_dp, 0.040112571829962605_dp, &
             0.06969345214233551_dp, 0.11928232476685569_dp, 0.20118097215415276_dp, &
             0.3347795767086457_dp, 0.5507588922017482_dp, 0.8991015649090148_dp, &
             1.4688669259558778_dp, 2.4579547964873605_dp, 4.596284356252853_dp]

      CASE (361)

         aw(:) = & ! a
            [0.00032302400345152345_dp, 0.001809571450258827_dp, 0.005016189032917566_dp, &
             0.011221288784793264_dp, 0.023017041072208755_dp, 0.04511475652147593_dp, &
             0.08570449837387419_dp, 0.15873709987044146_dp, 0.28760821760041116_dp, &
             0.5110180594894183_dp, 0.8923202702949009_dp, 1.534945362091075_dp, &
             2.6106708645312535_dp, 4.425849001568645_dp, 7.669625966066977_dp, &
             ! w
             0.0008404149095994822_dp, 0.0022127172568996187_dp, 0.004404415771810006_dp, &
             0.008425277738802644_dp, 0.01592959737226886_dp, 0.02959388006800317_dp, &
             0.05385111124331897_dp, 0.09601861984218273_dp, 0.16802320266993814_dp, &
             0.28911105098501644_dp, 0.49030195578440955_dp, 0.8226597473598823_dp, &
             1.3770544599011862_dp, 2.352951908922952_dp, 4.476775135243211_dp]

      CASE (362)

         aw(:) = & ! a
            [0.0002309479118724317_dp, 0.001307288415953211_dp, 0.0037002878105363976_dp, &
             0.008525783297610773_dp, 0.018065957266800242_dp, 0.036533906615871956_dp, &
             0.07140833938868062_dp, 0.13568854796893848_dp, 0.25157213145227064_dp, &
             0.4563724471127593_dp, 0.8120423512111979_dp, 1.4209334533330518_dp, &
             2.454524013880335_dp, 4.219933248501357_dp, 7.4072221155356335_dp, &
             ! w
             0.0006021998451342177_dp, 0.0016187261267440272_dp, 0.0033452393365352765_dp, &
             0.006674211828226234_dp, 0.013086819211628463_dp, 0.025059091042315712_dp, &
             0.04679690043877067_dp, 0.08536753743553713_dp, 0.15246529091869512_dp, &
             0.2672108204861979_dp, 0.46074954971779497_dp, 0.7846876596876935_dp, &
             1.3308927436829059_dp, 2.299805756787061_dp, 4.4163157384143945_dp]

      CASE (363)

         aw(:) = & ! a
            [0.0001820782633968936_dp, 0.0010395111289733386_dp, 0.002992518041134211_dp, &
             0.00705453203212621_dp, 0.01531164122266209_dp, 0.03166333811769612_dp, &
             0.06313673858107553_dp, 0.1221173957421379_dp, 0.23001680215937964_dp, &
             0.42322173412829067_dp, 0.7627288970210382_dp, 1.3501284949179844_dp, &
             2.356651925392222_dp, 4.089910831961853_dp, 7.240637442438634_dp, &
             ! w
             0.0004756369084263005_dp, 0.001300352080479198_dp, 0.002767286459160053_dp, &
             0.005692847078211061_dp, 0.01145011201060995_dp, 0.02238848101496398_dp, &
             0.04256339138227245_dp, 0.07887048489516325_dp, 0.1428378098730393_dp, &
             0.25348444003380916_dp, 0.44201784909441627_dp, 0.760390204298733_dp, &
             1.3011427010528307_dp, 2.265417075418835_dp, 4.377202122006528_dp]

      CASE (364)

         aw(:) = & ! a
            [0.00015145635064703637_dp, 0.0008711260387687643_dp, 0.002544236167079167_dp, &
             0.006111572326002756_dp, 0.013520155993096897_dp, 0.028447563369405873_dp, &
             0.05759880321508503_dp, 0.11291655201288686_dp, 0.21523828131969222_dp, &
             0.40026579443472193_dp, 0.7282787055024561_dp, 1.3002835551871088_dp, &
             2.2873048529384317_dp, 3.9973073734529803_dp, 7.1215488770918425_dp, &
             ! w
             0.00039626775058836133_dp, 0.0010992903894092524_dp, 0.0023969412766162127_dp, &
             0.005050871742805682_dp, 0.010358340399326064_dp, 0.020578367630362422_dp, &
             0.03965559019306404_dp, 0.07435653129978974_dp, 0.1360810125724632_dp, &
             0.24376413894234467_dp, 0.42864805165100434_dp, 0.742932031095579_dp, &
             1.2796585097760809_dp, 2.240512293189428_dp, 4.348877998943321_dp]

      CASE (365)

         aw(:) = & ! a
            [0.00013033103406794383_dp, 0.0007546147404157981_dp, 0.0022321298968959614_dp, &
             0.005448428722604167_dp, 0.012245002457801791_dp, 0.02613113290971849_dp, &
             0.05356582832282522_dp, 0.10615046394251602_dp, 0.2042761733917355_dp, &
             0.3831072245356745_dp, 0.7023544400177716_dp, 1.2625539646581452_dp, &
             2.2345533125141976_dp, 3.9265876434223164_dp, 7.030343965244846_dp, &
             ! w
             0.0003414757206547955_dp, 0.0009596636276879567_dp, 0.0021365303957790903_dp, &
             0.004591778079753565_dp, 0.009565621418706611_dp, 0.019247852256063992_dp, &
             0.037496331172369966_dp, 0.07097499857232124_dp, 0.1309799832669097_dp, &
             0.2363753024370087_dp, 0.41842364841844976_dp, 0.7295129765209069_dp, &
             1.2630808671191904_dp, 2.2212530740729632_dp, 4.326975585389564_dp]

      CASE (366)

         aw(:) = & ! a
            [0.00011480821110753842_dp, 0.0006687803525803461_dp, 0.0020009370081711234_dp, &
             0.004952879233832503_dp, 0.011282327983739444_dp, 0.024364935643347487_dp, &
             0.05046316608457395_dp, 0.10090370653772263_dp, 0.19571590322897758_dp, &
             0.36962513440574296_dp, 0.6818738938022625_dp, 1.2326061877222592_dp, &
             2.192515387605805_dp, 3.87005289218891_dp, 6.957266894726307_dp, &
             ! w
             0.0003011910603773181_dp, 0.0008564729701576366_dp, 0.001941949039919808_dp, &
             0.004243812767569963_dp, 0.008957291926001311_dp, 0.01821665289633639_dp, &
             0.03580899730849507_dp, 0.06831372308127896_dp, 0.12694034675372626_dp, &
             0.2304915026927615_dp, 0.41024232450349957_dp, 0.7187313324855581_dp, &
             1.2497198359483892_dp, 2.2057032208277745_dp, 4.30929205486255_dp]

      CASE (367)

         aw(:) = & ! a
            [0.00010288125515705975_dp, 0.0006026772000226355_dp, 0.001822006664337531_dp, &
             0.004566347413687135_dp, 0.010524744801794937_dp, 0.022963211356889522_dp, &
             0.047982064100025854_dp, 0.09667998948287258_dp, 0.18878427387251762_dp, &
             0.358651662541209_dp, 0.6651285739047629_dp, 1.20802403908763_dp, &
             2.157895226097974_dp, 3.8233719362259295_dp, 6.896813043249191_dp, &
             ! w
             0.0002702223025865614_dp, 0.0007767771880651209_dp, 0.001790180565135051_dp, &
             0.0039690416370657304_dp, 0.008471888750834608_dp, 0.017386988046962246_dp, &
             0.03444206730612096_dp, 0.06614499357639096_dp, 0.1236312094677251_dp, &
             0.22564948578040867_dp, 0.403482391855154_dp, 0.7097924619431463_dp, &
             1.2386136266646492_dp, 2.1927583985724617_dp, 4.294571189852885_dp]

      CASE (368)

         aw(:) = & ! a
            [9.340687201826213e-05_dp, 0.0005500573606271143_dp, 0.0016789264798342002_dp, &
             0.004255075995680376_dp, 0.009909868948963068_dp, 0.021817123424575507_dp, &
             0.045940142089935354_dp, 0.09318394358039717_dp, 0.18301796157967218_dp, &
             0.34948266839017517_dp, 0.6510827012489292_dp, 1.1873356150225314_dp, &
             2.128676796058516_dp, 3.783886720061892_dp, 6.84559604089572_dp, &
             ! w
             0.0002456102897028887_dp, 0.0007131730524152648_dp, 0.001667963204438964_dp, &
             0.0037453590318413544_dp, 0.00807317743648729_dp, 0.016700649976084902_dp, &
             0.03330460517970574_dp, 0.06433116993653835_dp, 0.12085128264622179_dp, &
             0.22156584058117093_dp, 0.3977616018252502_dp, 0.7022056961576497_dp, &
             1.2291664486410006_dp, 2.181733284169996_dp, 4.282033460231659_dp]

      CASE (369)

         aw(:) = & ! a
            [8.568398259700287e-05_dp, 0.0005070831754268762_dp, 0.0015615827771326923_dp, &
             0.00399814853161422_dp, 0.009398769381362596_dp, 0.020858242041970152_dp, &
             0.0442219155511724_dp, 0.09022732758979565_dp, 0.17811997012053413_dp, &
             0.34166444021898185_dp, 0.6390657647645775_dp, 1.16958416047751_dp, &
             2.103545046297059_dp, 3.7498584977918745_dp, 6.801396144000696_dp, &
             ! w
             0.00022553973536760532_dp, 0.0006611042867166782_dp, 0.0015670812397325414_dp, &
             0.0035589310274069556_dp, 0.007738253960003522_dp, 0.016120538591168715_dp, &
             0.03233824599695246_dp, 0.06278338066607869_dp, 0.11846991021405431_dp, &
             0.21805572258820682_dp, 0.39282956855052187_dp, 0.6956484406594744_dp, &
             1.2209854833881975_dp, 2.172175315798922_dp, 4.271164158873577_dp]

      CASE (370)

         aw(:) = & ! a
            [4.8739190172902635e-05_dp, 0.00030010585008340243_dp, 0.0009876738995310717_dp, &
             0.002712785098174194_dp, 0.006780417981129713_dp, 0.015838848845221645_dp, &
             0.03505674762899372_dp, 0.07419657960460874_dp, 0.15118187349477635_dp, &
             0.29812570854867027_dp, 0.5714107430373463_dp, 1.068696241936488_dp, &
             1.9595754022136687_dp, 3.5536970419800036_dp, 6.5454496859105245_dp, &
             ! w
             0.00012938678278271335_dp, 0.00040815193181071137_dp, 0.001062214062252585_dp, &
             0.0025953168134927747_dp, 0.0059625322233694805_dp, 0.012982592757148673_dp, &
             0.027023043168572618_dp, 0.05414698872008696_dp, 0.1050139537402174_dp, &
             0.19800028720439314_dp, 0.3643742896013531_dp, 0.6575035004193269_dp, &
             1.1730934362815018_dp, 2.1160177713084845_dp, 4.207299694970199_dp]

      CASE (371)

         aw(:) = & ! a
            [3.5169359346347595e-05_dp, 0.0002231914509169778_dp, 0.0007685348839439618_dp, &
             0.0022034376739169226_dp, 0.0057045634082146255_dp, 0.013710371978094897_dp, &
             0.031064716844303373_dp, 0.06705280643482078_dp, 0.13893935298222163_dp, &
             0.27799940351856034_dp, 0.5396720621929763_dp, 1.02076429001262_dp, &
             1.890448314510032_dp, 3.4587222980581394_dp, 6.420791960269669_dp, &
             ! w
             9.398706889507707e-05_dp, 0.00031270814722341594_dp, 0.0008619223237327935_dp, &
             0.002194170537323732_dp, 0.005196273282319835_dp, 0.011590120665894764_dp, &
             0.02460940238679822_dp, 0.050147397997076994_dp, 0.09867528571252786_dp, &
             0.18841094455177004_dp, 0.3505909246252059_dp, 0.6388233010426897_dp, &
             1.1494424326720414_dp, 2.0881498525600604_dp, 4.175604138897015_dp]

      CASE (372)

         aw(:) = & ! a
            [2.7962527836574136e-05_dp, 0.00018200952935360935_dp, 0.0006489023697117784_dp, &
             0.0019185523076751792_dp, 0.005089358226233148_dp, 0.012470406549450759_dp, &
             0.028702769593906517_dp, 0.0627704515067165_dp, 0.1315181973788553_dp, &
             0.26568150949006847_dp, 0.5200852967808487_dp, 0.9909733978710837_dp, &
             1.8472289819832828_dp, 3.399065544970394_dp, 6.342231455315601_dp, &
             ! w
             7.515949613893913e-05_dp, 0.00026103760606393373_dp, 0.0007497640070200919_dp, &
             0.0019630356691321526_dp, 0.004745588219399585_dp, 0.01075792076659256_dp, &
             0.02314781051220141_dp, 0.047698255802753414_dp, 0.09475624512994404_dp, &
             0.18243211814053142_dp, 0.3419342955770852_dp, 0.6270188755573953_dp, &
             1.13442609846837_dp, 2.0704073288446456_dp, 4.155422960799509_dp]

      CASE (373)

         aw(:) = & ! a
            [2.3442211847579637e-05_dp, 0.00015601207874397938_dp, 0.0005722023469705627_dp, &
             0.0017325672580031299_dp, 0.004681307602456673_dp, 0.011637162572818341_dp, &
             0.027098380528090743_dp, 0.05983525087597221_dp, 0.12639251721341946_dp, &
             0.257117676564694_dp, 0.5063906918916145_dp, 0.9700434173842551_dp, &
             1.8167422775653321_dp, 3.3568508191244555_dp, 6.286515566528177_dp, &
             ! w
             6.333851992393269e-05_dp, 0.0002281248435418086_dp, 0.000676464514215691_dp, &
             0.0018089259063906505_dp, 0.004440787185753832_dp, 0.010188848719609588_dp, &
             0.022139253940655763_dp, 0.0459952627953969_dp, 0.09201316146721433_dp, &
             0.17822329561444525_dp, 0.33581010830815566_dp, 0.6186327602932166_dp, &
             1.1237237866556156_dp, 2.0577381714562333_dp, 4.14101145084166_dp]

      CASE (374)

         aw(:) = & ! a
            [1.8025083924085845e-05_dp, 0.00012462455979027703_dp, 0.00047794208773949565_dp, &
             0.0014994930548697962_dp, 0.004161413461356942_dp, 0.010561202669204389_dp, &
             0.025003792418828705_dp, 0.055968059141112844_dp, 0.11958690105092243_dp, &
             0.2456715923201127_dp, 0.4879826826781143_dp, 0.9417729177120128_dp, &
             1.775396810166009_dp, 3.2994185175201984_dp, 6.210545634506915_dp, &
             ! w
             4.915855213036491e-05_dp, 0.00018796748269911816_dp, 0.0005844875268236697_dp, &
             0.0016115425732556384_dp, 0.004044712467570624_dp, 0.009441020488982278_dp, &
             0.02080166234517673_dp, 0.043719135072158646_dp, 0.08832247940785155_dp, &
             0.17252783018099083_dp, 0.3274812974448913_dp, 0.6071797272127996_dp, &
             1.1090601210810358_dp, 2.040346649221291_dp, 4.12122653593576_dp]

      CASE (375)

         aw(:) = & ! a
            [1.3713201078198846e-05_dp, 9.938731807296921e-05_dp, 0.00040033849607394297_dp, &
             0.0013028886787681718_dp, 0.0037140838982274832_dp, 0.009620682410111355_dp, &
             0.02314928988686572_dp, 0.05250769666415305_dp, 0.11344273080991822_dp, &
             0.23525920440588335_dp, 0.47112782773955647_dp, 0.9157439170756236_dp, &
             1.7371540183027678_dp, 3.2461043412074573_dp, 6.139843829293329_dp, &
             ! w
             3.786021104247671e-05_dp, 0.00015520778775327015_dp, 0.000506766192819174_dp, &
             0.0014406853409254816_dp, 0.003696032942457307_dp, 0.008774030326622207_dp, &
             0.01959590850322764_dp, 0.04164897434399873_dp, 0.08494009065360072_dp, &
             0.1672736315408742_dp, 0.31975392819781684_dp, 0.5965027187924734_dp, &
             1.095339467866635_dp, 2.024038131358753_dp, 4.10267171027402_dp]

      CASE (376)

         aw(:) = & ! a
            [8.241390969460819e-06_dp, 6.682828547515902e-05_dp, 0.0002964966549912458_dp, &
             0.0010306941688953423_dp, 0.0030780394598367983_dp, 0.00825525528467757_dp, &
             0.02041166047918162_dp, 0.04732896673960058_dp, 0.10414123315508589_dp, &
             0.21934170448715923_dp, 0.4451461228571678_dp, 0.8753351088762175_dp, &
             1.6774340998452855_dp, 3.1624654656299014_dp, 6.02856867999779_dp, &
             ! w
             2.3509713948686844e-05_dp, 0.00011193516343481133_dp, 0.00039887745388847906_dp, &
             0.0011959084983082509_dp, 0.003185370388606981_dp, 0.007780425656002086_dp, &
             0.017774776728682256_dp, 0.03848607637085464_dp, 0.07972142358903424_dp, &
             0.15909821973325272_dp, 0.30764243135637825_dp, 0.5796652215027419_dp, &
             1.0735996091356506_dp, 1.9981255460279612_dp, 4.073185575994722_dp]

      CASE (377)

         aw(:) = & ! a
            [4.552150151574599e-06_dp, 4.421084777083031e-05_dp, 0.0002201145769694895_dp, &
             0.0008208720232572033_dp, 0.002570421715333931_dp, 0.007136351257862949_dp, &
             0.018121029796242263_dp, 0.04292174992456705_dp, 0.09611318317440591_dp, &
             0.2054392332913893_dp, 0.4222231162936867_dp, 0.8393771127857702_dp, &
             1.623914646674579_dp, 3.0870953868842137_dp, 5.927906145240573_dp, &
             ! w
             1.383120882196413e-05_dp, 8.064969674292988e-05_dp, 0.00031540243318754985_dp, &
             0.000998802769663293_dp, 0.0027625888028654623_dp, 0.0069401552242630395_dp, &
             0.016208194317830372_dp, 0.03572659643246346_dp, 0.07511371637549026_dp, &
             0.1518056921914172_dp, 0.2967435010669072_dp, 0.5644011641235893_dp, &
             1.0537786810559537_dp, 1.974420231979491_dp, 4.046205680024345_dp]

      CASE (378)

         aw(:) = & ! a
            [3.359044487633565e-06_dp, 3.664525662033725e-05_dp, 0.00019322206826094169_dp, &
             0.0007442365167359122_dp, 0.0023801663474433475_dp, 0.006708860705186679_dp, &
             0.017232713424910437_dp, 0.04119198146784048_dp, 0.09293096926312501_dp, &
             0.19988258085084912_dp, 0.41299654611678777_dp, 0.8248179681623964_dp, &
             1.6021388900621432_dp, 3.056312285460253_dp, 5.886683650439728_dp, &
             ! w
             1.06997832196879e-05_dp, 6.976964094308859e-05_dp, 0.00028482927867991807_dp, &
             0.0009244837486827712_dp, 0.0025999456482000308_dp, 0.006611953048067482_dp, &
             0.015588862131619368_dp, 0.034624789851089674_dp, 0.07325855975868562_dp, &
             0.1488486445351574_dp, 0.2922971450475792_dp, 0.558142191475726_dp, &
             1.0456191489815219_dp, 1.9646387631965558_dp, 4.035071257281259_dp]

      CASE (379)

         aw(:) = & ! a
            [3.291667899337863e-06_dp, 3.6211649942309474e-05_dp, 0.0001916520413872042_dp, &
             0.0007397073815295243_dp, 0.0023688276459558682_dp, 0.006683226213018714_dp, &
             0.017179191903350474_dp, 0.041087365085774624_dp, 0.09273790706811486_dp, &
             0.19954458193741717_dp, 0.41243407495664974_dp, 0.8239287603035587_dp, &
             1.6008068838318577_dp, 3.054427060491967_dp, 5.884156997235583_dp, &
             ! w
             1.0522817667026174e-05_dp, 6.91367855732188e-05_dp, 0.00028302083846862936_dp, &
             0.000920046489898947_dp, 0.0025901722444491987_dp, 0.006592135178427996_dp, &
             0.015551321239944434_dp, 0.03455779403365817_dp, 0.07314545968838804_dp, &
             0.14866796426944323_dp, 0.2920249462823512_dp, 0.5577584133433053_dp, &
             1.0451182163084207_dp, 1.9640378140134063_dp, 4.034387153432591_dp]

      CASE (380)

         aw(:) = & ! a
            [0.021196358905225136_dp, 0.1123242174600216_dp, 0.2789480531208277_dp, &
             0.5259381094628535_dp, 0.8608525827545033_dp, 1.294656051873865_dp, &
             1.842724085023887_dp, 2.5262309525576914_dp, 3.3740205529595078_dp, &
             4.425147362890342_dp, 5.732563387051012_dp, 7.36921058654392_dp, &
             9.439771820038764_dp, 12.10713043916233_dp, 15.665047158983352_dp, &
             20.827683329961864_dp, &
             ! w
             0.05446939933237892_dp, 0.1282577437959811_dp, 0.20579167705894114_dp, &
             0.2894365923450767_dp, 0.38220323102415954_dp, 0.4879433905317225_dp, &
             0.6116909136127484_dp, 0.7600887458718383_dp, 0.9419406889769545_dp, &
             1.169043376627181_dp, 1.4577672298738047_dp, 1.8325870880315658_dp, &
             2.334694767335279_dp, 3.045727170513805_dp, 4.171279433120403_dp, &
             6.534983731344117_dp]

      CASE (381)

         aw(:) = & ! a
            [0.01249335598340411_dp, 0.06636347934040579_dp, 0.16554012109404947_dp, &
             0.3142122161559276_dp, 0.5190964445166673_dp, 0.790303614338604_dp, &
             1.14256205246528_dp, 1.5968455073257304_dp, 2.182439219932948_dp, &
             2.9396026075790025_dp, 3.9233621214215906_dp, 5.209757485204127_dp, &
             6.907690198558372_dp, 9.185012378465641_dp, 12.33931597149999_dp, &
             17.07928007504425_dp, &
             ! w
             0.0321225885764125_dp, 0.07600169220553715_dp, 0.1230393637303321_dp, &
             0.1754101491069477_dp, 0.23602314019090215_dp, 0.30881881858347765_dp, &
             0.39915952341596667_dp, 0.5142450102957286_dp, 0.6635919448742423_dp, &
             0.8598082538447277_dp, 1.1202030710426285_dp, 1.4703548620534355_dp, &
             1.9525233214943742_dp, 2.6485569231618076_dp, 3.7608140990416503_dp, &
             6.092181707707883_dp]

      CASE (382)

         aw(:) = & ! a
            [0.009159784924232068_dp, 0.04874124565626381_dp, 0.12198111404576532_dp, &
             0.232692995418522_dp, 0.38712219115716845_dp, 0.5948850330998255_dp, &
             0.8702777453847756_dp, 1.233954861820021_dp, 1.7149841111626252_dp, &
             2.3534803627430483_dp, 3.204432603105609_dp, 4.344054149447819_dp, &
             5.881684905596398_dp, 7.985635754045998_dp, 10.952845642003844_dp, &
             15.485273091084188_dp, &
             ! w
             0.023560919726193764_dp, 0.05594131340168916_dp, 0.09116326281033685_dp, &
             0.1312859571784798_dp, 0.17915330472587593_dp, 0.23872704337829892_dp, &
             0.31546694974446954_dp, 0.4166893847022847_dp, 0.5519940219255626_dp, &
             0.7340636247311381_dp, 0.9803606385561896_dp, 1.3167257512871589_dp, &
             1.785640077047676_dp, 2.4686440241868266_dp, 3.565729803472949_dp, &
             5.866704271620807_dp]

      CASE (383)

         aw(:) = & ! a
            [0.007322560141813404_dp, 0.039019303320244614_dp, 0.09790678446590025_dp, &
             0.187522875978312_dp, 0.3137542183667891_dp, 0.4858136923194133_dp, &
             0.7175823469735936_dp, 1.029286936368008_dp, 1.4495317958082097_dp, &
             2.017951611756463_dp, 2.7891432547193737_dp, 3.8391679753262133_dp, &
             5.277547112934667_dp, 7.272981854778001_dp, 10.122302228244262_dp, &
             14.523744726813701_dp, &
             ! w
             0.018841222624291037_dp, 0.04486054935433717_dp, 0.07349307310161883_dp, &
             0.10670408062782458_dp, 0.14727159188773734_dp, 0.19913285414852644_dp, &
             0.2677423025669557_dp, 0.3603915702110762_dp, 0.4866411695538599_dp, &
             0.6591954549030602_dp, 0.8956803685351775_dp, 1.2222440383488673_dp, &
             1.6816930580726246_dp, 2.3555756876213545_dp, 3.4425924383299704_dp, &
             5.724556568819595_dp]

      CASE (384)

         aw(:) = & ! a
            [0.006144279628950153_dp, 0.03277911224232179_dp, 0.08243143408680947_dp, &
             0.15842545956161763_dp, 0.2663633767071308_dp, 0.41512300978947586_dp, &
             0.6182082205518974_dp, 0.8954087492618855_dp, 1.274817140373277_dp, &
             1.7955250328439663_dp, 2.511671361173349_dp, 3.499086710699372_dp, &
             4.867379267125952_dp, 6.785582282555889_dp, 9.550605650905268_dp, &
             13.858296262592724_dp, &
             ! w
             0.015813720032822463_dp, 0.037740980322357426_dp, 0.062106580525873915_dp, &
             0.09079863087031755_dp, 0.1265341518126833_dp, 0.17320811624424157_dp, &
             0.23622773902770974_dp, 0.3228120296047017_dp, 0.4424551929503153_dp, &
             0.6078787063087151_dp, 0.8368663078342602_dp, 1.1558545652842125_dp, &
             1.6079713225351366_dp, 2.274872303451242_dp, 3.3544410264652536_dp, &
             5.622910311607047_dp]

      CASE (385)

         aw(:) = & ! a
            [0.005318206626187421_dp, 0.028401132818993903_dp, 0.07156053986480068_dp, &
             0.13794842392532944_dp, 0.23293358815672274_dp, 0.36510922545412866_dp, &
             0.5476393721885707_dp, 0.7998966011997658_dp, 1.1494732580738143_dp, &
             1.6349308451367353_dp, 2.309957873522667_dp, 3.2501382678703843_dp, &
             4.565119676968007_dp, 6.424218342852793_dp, 9.12449771873384_dp, &
             13.36013347283737_dp, &
             ! w
             0.013690837729939604_dp, 0.032741734632585666_dp, 0.05409121573881286_dp, &
             0.07956259327454886_dp, 0.11181728320952655_dp, 0.15470082310158226_dp, &
             0.2135556027713844_dp, 0.29551330198325365_dp, 0.41000015242482113_dp, &
             0.5697558701772301_dp, 0.7927078885207337_dp, 1.1055499871864973_dp, &
             1.5517056878524866_dp, 2.212974007155654_dp, 3.286677802349345_dp, &
             5.544848727853524_dp]

      CASE (386)

         aw(:) = & ! a
            [0.004703903160134626_dp, 0.025143461350440856_dp, 0.06346245800840158_dp, &
             0.1226699481548257_dp, 0.20793818507598555_dp, 0.32761384294384377_dp, &
             0.4945540693857813_dp, 0.727742231258249_dp, 1.0543005913145043_dp, &
             1.512294703134273_dp, 2.154989672686737_dp, 3.0577259786550077_dp, &
             4.3301629301894_dp, 6.141859693294843_dp, 8.79006196623135_dp, &
             12.967709297738798_dp, &
             ! w
             0.01211194222848858_dp, 0.02901895327156339_dp, 0.04810931086327413_dp, &
             0.07115084222869922_dp, 0.10075425998731947_dp, 0.14071320966019513_dp, &
             0.19629857621820135_dp, 0.27455289222346774_dp, 0.38483957921000617_dp, &
             0.5399170453962834_dp, 0.7578406304494023_dp, 1.0655310964555629_dp, &
             1.5066799629278596_dp, 2.1632416780817367_dp, 3.23213398805937_dp, &
             5.482067206815196_dp]

      CASE (387)

         aw(:) = & ! a
            [0.00422749413273055_dp, 0.022615645154839315_dp, 0.05717240489148407_dp, &
             0.1107855007815738_dp, 0.1884582617757678_dp, 0.29832047060331274_dp, &
             0.452950710213161_dp, 0.6709720585108714_dp, 0.9790711090780677_dp, &
             1.414855708895712_dp, 2.0311982614953905_dp, 2.903205265470869_dp, &
             4.140529901781275_dp, 5.912941751200072_dp, 8.517877774821814_dp, &
             12.647326367116241_dp, &
             ! w
             0.010887306886137257_dp, 0.02612826632233438_dp, 0.04345528500785436_dp, &
             0.06458788949871225_dp, 0.09209034960236005_dp, 0.12970422989847916_dp, &
             0.18262748876520904_dp, 0.25781680518497263_dp, 0.3645792437854545_dp, &
             0.515691279201699_dp, 0.729321297550378_dp, 1.0325907226271627_dp, &
             1.4694338205014248_dp, 2.1219626037538277_dp, 3.186791641347356_dp, &
             5.429913659794066_dp]

      CASE (388)

         aw(:) = & ! a
            [0.003846215689887253_dp, 0.020591567605920486_dp, 0.052131236756410314_dp, &
             0.10124813840432649_dp, 0.17279805880579355_dp, 0.27471750430074443_dp, &
             0.41933078052311024_dp, 0.6249280273155943_dp, 0.9177937594965698_dp, &
             1.3351147388188598_dp, 1.9294001189108119_dp, 2.775533661043749_dp, &
             3.9831504408499843_dp, 5.722203938971686_dp, 8.290322245610936_dp, &
             12.378740047913006_dp, &
             ! w
             0.009907094205358409_dp, 0.02381219843928404_dp, 0.03971970223882869_dp, &
             0.059306507415729695_dp, 0.08509411213091364_dp, 0.12077294875471438_dp, &
             0.17146923106208586_dp, 0.24405896397709637_dp, 0.34779893650915916_dp, &
             0.49548237669575296_dp, 0.7053775625652202_dp, 1.0047843223684194_dp, &
             1.4378576455423158_dp, 2.0868647293083935_dp, 3.14818751482594_dp, &
             5.385537697274526_dp]

      CASE (389)

         aw(:) = & ! a
            [0.0035335098097274502_dp, 0.018930747017319782_dp, 0.04799132910586563_dp, &
             0.09340633146197712_dp, 0.15990097589914684_dp, 0.25523772056519983_dp, &
             0.3915075062326464_dp, 0.5866925245564957_dp, 0.8667062212594495_dp, &
             1.2683475596560745_dp, 1.8437892243513303_dp, 2.6677035867305716_dp, &
             3.849699295046004_dp, 5.559891904882398_dp, 8.096096154837575_dp, &
             12.148935783294984_dp, &
             ! w
             0.009103084606394137_dp, 0.021910709462719523_dp, 0.03664772176776826_dp, &
             0.054952977443978805_dp, 0.07930837363114634_dp, 0.1133547294055117_dp, &
             0.16214897233480427_dp, 0.23249210399071235_dp, 0.333595921973549_dp, &
             0.4782687636968508_dp, 0.6848674256397951_dp, 0.9808514234763911_dp, &
             1.4105774826377881_dp, 2.056463551205302_dp, 3.1147098104802877_dp, &
             5.347075263990651_dp]

      CASE (390)

         aw(:) = & ! a
            [0.0020125660928861262_dp, 0.010839302580047023_dp, 0.02776073727683414_dp, &
             0.05491535485485394_dp, 0.09621390677878901_dp, 0.15826858590132964_dp, &
             0.25155176221863657_dp, 0.3918898940757439_dp, 0.6026248579910799_dp, &
             0.9178653621745613_dp, 1.3873828979151186_dp, 2.0842135216668547_dp, &
             3.1175469236537974_dp, 4.658456142887671_dp, 7.006244025097976_dp, &
             10.848771624757788_dp, &
             ! w
             0.005191005039162004_dp, 0.012627761284911658_dp, 0.02156064071318729_dp, &
             0.033384664006361114_dp, 0.050295370164638205_dp, 0.07553538085132828_dp, &
             0.11363368103946318_dp, 0.1708798850219695_dp, 0.256195443232919_dp, &
             0.3824592769646401_dp, 0.5685478192743597_dp, 0.842929673227647_dp, &
             1.2513442211943193_dp, 1.8774322383842335_dp, 2.916747074100502_dp, &
             5.120036241800754_dp]

      CASE (391)

         aw(:) = & ! a
            [0.0014432114855624366_dp, 0.007801531779809701_dp, 0.020125469832939162_dp, &
             0.04027487358928148_dp, 0.07172700433101158_dp, 0.12043784221977033_dp, &
             0.19592250866598496_dp, 0.3127387451926994_dp, 0.4927264320226538_dp, &
             0.7683981194605783_dp, 1.1880336160297063_dp, 1.823551281651308_dp, &
             2.7837030596469976_dp, 4.239997459981806_dp, 6.4927254010870055_dp, &
             10.228937612952235_dp, &
             ! w
             0.003725556416991007_dp, 0.009130298705641785_dp, 0.015817113603965635_dp, &
             0.025046690407301304_dp, 0.038832707327519145_dp, 0.060151024090465445_dp, &
             0.09320815067576782_dp, 0.1440089851094002_dp, 0.22130250395541864_dp, &
             0.33796141989191814_dp, 0.513089899907686_dp, 0.7756846839561413_dp, &
             1.172301678749089_dp, 1.7874363147483472_dp, 2.8166376845013903_dp, &
             5.005481438637751_dp]

      CASE (392)

         aw(:) = & ! a
            [0.001138607606637662_dp, 0.006172997812692638_dp, 0.016016909835216055_dp, &
             0.03235243234811286_dp, 0.058370258317666956_dp, 0.09957778943079486_dp, &
             0.16483155756290288_dp, 0.2678221908723548_dp, 0.42936026818301354_dp, &
             0.680845171457615_dp, 1.0694838116053031_dp, 1.6663482146929018_dp, &
             2.5798010052893874_dp, 3.9815934666964297_dp, 6.172734113102047_dp, &
             9.839972278801387_dp, &
             ! w
             0.0029411704155330163_dp, 0.007250637976088699_dp, 0.0127075060808784_dp, &
             0.0204817457415187_dp, 0.032455233648936765_dp, 0.051412045731351635_dp, &
             0.08133999621352078_dp, 0.1280531259067859_dp, 0.20017159948716043_dp, &
             0.31053680925413074_dp, 0.4783756936706183_dp, 0.7330239927551989_dp, &
             1.121605973954248_dp, 1.7292644544768974_dp, 2.751681290901997_dp, &
             4.931240718471879_dp]

      CASE (393)

         aw(:) = & ! a
            [0.0009468599039160355_dp, 0.005146160887302762_dp, 0.013418571153765537_dp, &
             0.027319234990486427_dp, 0.049828746034209906_dp, 0.08611936057782459_dp, &
             0.14455569569598634_dp, 0.2381830158803071_dp, 0.3870414798533882_dp, &
             0.6216847902584319_dp, 0.9884865630628115_dp, 1.5578388987534184_dp, &
             2.4377619194799007_dp, 3.8001562576159_dp, 5.946586577844916_dp, &
             9.56369803004218_dp, &
             ! w
             0.002447213193628341_dp, 0.006063096162127432_dp, 0.010731255021633994_dp, &
             0.017554051482094653_dp, 0.02831105177630225_dp, 0.04564029610353025_dp, &
             0.07336883599358635_dp, 0.11716847667926884_dp, 0.18555466002953247_dp, &
             0.2913293199019894_dp, 0.4537929108325465_dp, 0.7025225505971376_dp, &
             1.0850730482430841_dp, 1.6871056785919718_dp, 2.704472005383909_dp, &
             4.877325329085324_dp]

      CASE (394)

         aw(:) = & ! a
            [0.0008141838379395475_dp, 0.0044346795523015625_dp, 0.011613638985669604_dp, &
             0.02380926309685988_dp, 0.04383837761827239_dp, 0.07660898723413151_dp, &
             0.1300986481276461_dp, 0.2168455261816723_dp, 0.3562805725175744_dp, &
             0.5782804460787271_dp, 0.9285403059074989_dp, 1.4768849008164218_dp, &
             2.3310307802189953_dp, 3.662975489583911_dp, 5.7747339253388486_dp, &
             9.352938686108484_dp, &
             ! w
             0.0021053197367968384_dp, 0.005238881032241541_dp, 0.009352740756311956_dp, &
             0.015495836964274748_dp, 0.025364843770632677_dp, 0.041481888656963145_dp, &
             0.06754908621571802_dp, 0.10912528140851005_dp, 0.1746371114059134_dp, &
             0.27684504062967474_dp, 0.4350961478436266_dp, 0.6791506110084174_dp, &
             1.0569067323081625_dp, 1.6544567764087874_dp, 2.6678292216763007_dp, &
             4.83550044561988_dp]

      CASE (395)

         aw(:) = & ! a
            [0.0007164949012989691_dp, 0.003910186382166121_dp, 0.010280107246459396_dp, &
             0.021207046467061254_dp, 0.03937487847212398_dp, 0.0694755195241084_dp, &
             0.11917077023509802_dp, 0.20058512720646549_dp, 0.33264946256516004_dp, &
             0.5446788598533016_dp, 0.8817981251009139_dp, 1.4133459060584153_dp, &
             2.24676696687539_dp, 3.5541234904565746_dp, 5.637806288890546_dp, &
             9.184482411224847_dp, &
             ! w
             0.0018535144254540458_dp, 0.004630391151922406_dp, 0.008330547866480902_dp, &
             0.013959036425840211_dp, 0.023143355601873458_dp, 0.038310745695463555_dp, &
             0.06306228606568692_dp, 0.10286331693679289_dp, 0.16606321357597628_dp, &
             0.2653813785938354_dp, 0.42019534692385324_dp, 0.6604101630611989_dp, &
             1.0342079766011074_dp, 1.6280489633923891_dp, 2.6381353298352224_dp, &
             4.8016213243881145_dp]

      CASE (396)

         aw(:) = & ! a
            [0.0006413268094817408_dp, 0.0035061734626053672_dp, 0.009250850744827762_dp, &
             0.01919232793589403_dp, 0.035903368401840566_dp, 0.06389445073545688_dp, &
             0.11056285245895803_dp, 0.187686236929584_dp, 0.3137737097128846_dp, &
             0.5176624942979188_dp, 0.8439866686004004_dp, 1.3616601833297932_dp, &
             2.1778821657413934_dp, 3.464758288901994_dp, 5.52500051528786_dp, &
             9.045335753558277_dp, &
             ! w
             0.001659711097960326_dp, 0.004161063262449229_dp, 0.007539020145854125_dp, &
             0.012761570676967888_dp, 0.02139721225887122_dp, 0.03579364194675145_dp, &
             0.05946778021054195_dp, 0.09780530353975819_dp, 0.15908716848022886_dp, &
             0.25599310022175054_dp, 0.4079207043380653_dp, 0.6448932537552953_dp, &
             1.015333520252577_dp, 1.6060220091447996_dp, 2.613327684839822_dp, &
             4.773326490075026_dp]

      CASE (397)

         aw(:) = & ! a
            [0.0005815528588767196_dp, 0.0031845872823828758_dp, 0.00843009848407876_dp, &
             0.01758116593260212_dp, 0.03311565064103493_dp, 0.059388592600538914_dp, &
             0.1035710999862279_dp, 0.1771438940187625_dp, 0.2982529920600857_dp, &
             0.4953210601193777_dp, 0.8125524576330856_dp, 1.3184844662501274_dp, &
             2.12009233578979_dp, 3.389510703935226_dp, 5.429730790303327_dp, &
             8.927553354440402_dp, &
             ! w
             0.0015055631595250563_dp, 0.0037870450506321844_dp, 0.00690596865384866_dp, &
             0.011798367130382651_dp, 0.019981560165404876_dp, 0.03373529707545055_dp, &
             0.05650478663366711_dp, 0.09360638685684552_dp, 0.15325966504078803_dp, &
             0.24810642080935616_dp, 0.3975573296197845_dp, 0.6317344227996358_dp, &
             0.9992684300875393_dp, 1.5872230602253214_dp, 2.5921258825123528_dp, &
             4.749150852289011_dp]

      CASE (398)

         aw(:) = & ! a
            [0.00053279144924341_dp, 0.002922014073309145_dp, 0.007758841968395698_dp, &
             0.01625999258428908_dp, 0.03082088275147343_dp, 0.055661259823171286_dp, &
             0.09775570475722127_dp, 0.16832648559008362_dp, 0.2852019800763538_dp, &
             0.47643972768349957_dp, 0.7858625488052698_dp, 1.2816696415764266_dp, &
             2.0706307332283274_dp, 3.3248991112367183_dp, 5.347712267242679_dp, &
             8.825952375092989_dp, &
             ! w
             0.0013797888502005509_dp, 0.003481329651598812_dp, 0.0063868138275758575_dp, &
             0.011004275089362643_dp, 0.018806041634350512_dp, 0.032012926679498024_dp, &
             0.054007928408406826_dp, 0.09004611020303548_dp, 0.14829138721719914_dp, &
             0.2413494780456323_dp, 0.3886392366518693_dp, 0.6203667158670122_dp, &
             0.9853451315581527_dp, 1.570891642620387_dp, 2.573684140962671_dp, &
             4.728127112746264_dp]

      CASE (399)

         aw(:) = & ! a
            [0.0002992241208797295_dp, 0.001660263135655202_dp, 0.004513817000332386_dp, &
             0.009811141296951102_dp, 0.019461643837338276_dp, 0.036886468087944185_dp, &
             0.0679045674012652_dp, 0.12220413506291097_dp, 0.21569238652733375_dp, &
             0.37416770691201034_dp, 0.6390292853494859_dp, 1.076252660472402_dp, &
             1.7911592740081455_dp, 2.9558684609147226_dp, 4.87513923191185_dp, &
             8.236677844794322_dp, &
             ! w
             0.0007768847420693004_dp, 0.0020065660238064885_dp, 0.0038523102169686027_dp, &
             0.007051878544035466_dp, 0.012805153586703547_dp, 0.022990435633194663_dp, &
             0.040622319624940055_dp, 0.07056844316216015_dp, 0.12061532382449311_dp, &
             0.20309076737149567_dp, 0.33739500108413983_dp, 0.5541903301702226_dp, &
             0.903401381371959_dp, 1.4739942115085554_dp, 2.4637954099354933_dp, &
             4.602935860942909_dp]

      CASE (400)

         aw(:) = & ! a
            [0.00021347052176661868_dp, 0.0011944382121612197_dp, 0.0033030929481546053_dp, &
             0.007363357489812759_dp, 0.015044018797984875_dp, 0.02937269792814372_dp, &
             0.05559890919235446_dp, 0.10264072671139964_dp, 0.18541432635682942_dp, &
             0.3285173216429233_dp, 0.5720171780433249_dp, 0.9806147524370287_dp, &
             1.6587347438742526_dp, 2.778367566830957_dp, 4.645072034217995_dp, &
             7.947202683584637_dp, &
             ! w
             0.0005552467027450947_dp, 0.0014584383837619175_dp, 0.00289028275110568_dp, &
             0.005500374295153524_dp, 0.010351689150413703_dp, 0.019157144552366685_dp, &
             0.03474388578238406_dp, 0.061766102540009006_dp, 0.1077870257402971_dp, &
             0.18494941009745244_dp, 0.31259502169534753_dp, 0.5215821469062484_dp, &
             0.8624104031684324_dp, 1.4249765739881088_dp, 2.4078703105469663_dp, &
             4.539270216652968_dp]

      CASE (401)

         aw(:) = & ! a
            [0.00016801259282013013_dp, 0.0009465404888159955_dp, 0.0026538938383495574_dp, &
             0.006034351110706909_dp, 0.012604425731931665_dp, 0.025143940441556847_dp, &
             0.0485422220818331_dp, 0.09122333027409636_dp, 0.1674571159436081_dp, &
             0.3010446184572927_dp, 0.5311533323793718_dp, 0.9216025899928024_dp, &
             1.57617191456792_dp, 2.6667207963614876_dp, 4.499332232355596_dp, &
             7.762866885048903_dp, &
             ! w
             0.000437651070085769_dp, 0.0011653666641048587_dp, 0.002368045639112556_dp, &
             0.004637983434429464_dp, 0.00895184829397263_dp, 0.016919009702432652_dp, &
             0.031244175158437585_dp, 0.056436696333444086_dp, 0.09990333732068696_dp, &
             0.17365015462436198_dp, 0.2969613931046049_dp, 0.5008065845528724_dp, &
             0.8360592730493394_dp, 1.3932536792220334_dp, 2.371544562997579_dp, &
             4.497930679204095_dp]

      CASE (402)

         aw(:) = & ! a
            [0.00013955614082720468_dp, 0.0007908754043432692_dp, 0.0022437319728956973_dp, &
             0.005186144951081648_dp, 0.011026546539096826_dp, 0.022369463798109702_dp, &
             0.04384805790935869_dp, 0.08353122276508576_dp, 0.15521869940229618_dp, &
             0.28212529566655037_dp, 0.5027477680571566_dp, 0.8802381938407274_dp, &
             1.5178750221968238_dp, 2.587397219128016_dp, 4.395269353498463_dp, &
             7.630762334254393_dp, &
             ! w
             0.0003639842736266964_dp, 0.0009806443211126503_dp, 0.0020348019995182053_dp, &
             0.0040773537715263096_dp, 0.008024124570268312_dp, 0.015411167807786183_dp, &
             0.028853742267538167_dp, 0.052752952804675055_dp, 0.0943962899936183_dp, &
             0.16568218983720878_dp, 0.28584292951765694_dp, 0.4859200114387559_dp, &
             0.8170578475224641_dp, 1.370269754790146_dp, 2.3451567673310105_dp, &
             4.467906601942395_dp]

      CASE (403)

         aw(:) = & ! a
            [0.00011994063377784437_dp, 0.0006832918618089672_dp, 0.0019587716841422183_dp, &
             0.0045917452487347415_dp, 0.009908557035023382_dp, 0.020380871666707084_dp, &
             0.040446666413748104_dp, 0.07790186288971854_dp, 0.14618166223046783_dp, &
             0.2680422516895201_dp, 0.48145067435423805_dp, 0.8490259511837919_dp, &
             1.4736387032169467_dp, 2.5269188569364047_dp, 4.315626638157058_dp, &
             7.52937595194575_dp, &
             ! w
             0.0003131740893025812_dp, 0.0008525743777120363_dp, 0.0018013124768756677_dp, &
             0.003678443406853745_dp, 0.007353895406997607_dp, 0.014307935501779015_dp, &
             0.027086131721960074_dp, 0.050003945167185586_dp, 0.09025317138847347_dp, &
             0.1596439284804762_dp, 0.27736209279270935_dp, 0.47449946366194173_dp, &
             0.8024095949928362_dp, 1.3524864442578874_dp, 2.3246983701212196_dp, &
             4.444632015708798_dp]

      CASE (404)

         aw(:) = & ! a
            [0.00010553730746574328_dp, 0.000604114890345993_dp, 0.0017480808776888786_dp, &
             0.004148923513394785_dp, 0.009067774828527468_dp, 0.018870873650537016_dp, &
             0.03784054837713197_dp, 0.07355347439504066_dp, 0.13914997017207897_dp, &
             0.25701261969287315_dp, 0.4646737063801709_dp, 0.8243107746878443_dp, &
             1.4384517778893633_dp, 2.4786279831485563_dp, 4.251838403590527_dp, &
             7.4479905527901975_dp, &
             ! w
             0.00027584562442111983_dp, 0.0007580596968981613_dp, 0.0016273891617054745_dp, &
             0.0033773574743789_dp, 0.006841653021452152_dp, 0.013456040844322448_dp, &
             0.02570946297821904_dp, 0.04784700463715347_dp, 0.08698098534525467_dp, &
             0.15484690947378996_dp, 0.2705890951533227_dp, 0.4653363336543718_dp, &
             0.7906106418418388_dp, 1.3381198015624958_dp, 2.3081433515491243_dp, &
             4.425799819861813_dp]

      CASE (405)

         aw(:) = & ! a
            [9.44773691119612e-05_dp, 0.0005431933718162297_dp, 0.0015852907600157036_dp, &
             0.0038044511901996255_dp, 0.008408308889468244_dp, 0.0176766622119812_dp, &
             0.03576363220270861_dp, 0.07006420341351442_dp, 0.13347287505346608_dp, &
             0.24805897708410202_dp, 0.45098801346782985_dp, 0.8040623195001615_dp, &
             1.4095152073454302_dp, 2.4387882648489327_dp, 4.1990791711593305_dp, &
             7.380551388696279_dp, &
             ! w
             0.0002471688129707959_dp, 0.0006851572503816519_dp, 0.001492108730335673_dp, &
             0.00314045446537675_dp, 0.006434308779518773_dp, 0.012772732039276265_dp, &
             0.024597271852795737_dp, 0.04609359446526941_dp, 0.08430634115029434_dp, &
             0.15090661441253608_dp, 0.2650012689108123_dp, 0.4577473064340514_dp, &
             0.7808066064884537_dp, 1.3261526510468242_dp, 2.2943342451891664_dp, &
             4.410092262245033_dp]

      CASE (406)

         aw(:) = & ! a
            [8.569660149849527e-05_dp, 0.0004947372328309369_dp, 0.0014553149185678176_dp, &
             0.0035277193978652814_dp, 0.007874624380363664_dp, 0.016703189593832206_dp, &
             0.03405934243782461_dp, 0.06718393471622092_dp, 0.12876188160322527_dp, &
             0.24059411841847955_dp, 0.43953025508857146_dp, 0.7870474597304489_dp, &
             1.3851212211488515_dp, 2.4051111576427746_dp, 4.154383977803103_dp, &
             7.323329501473544_dp, &
             ! w
             0.00022439206057515914_dp, 0.0006270417067617411_dp, 0.0013834406617184846_dp, &
             0.0029481984836296285_dp, 0.006100685387801727_dp, 0.012208928667195511_dp, &
             0.023673922381027016_dp, 0.044630131267802894_dp, 0.08206346425748633_dp, &
             0.14758850802717696_dp, 0.26027810439683907_dp, 0.4513113627618849_dp, &
             0.7724689548824036_dp, 1.3159538709954992_dp, 2.282551732648174_dp, &
             4.396690573561224_dp]

      CASE (407)

         aw(:) = & ! a
            [7.854272602555263e-05_dp, 0.0004551924617865592_dp, 0.0013488674597178577_dp, &
             0.003299800617017515_dp, 0.007432161479352753_dp, 0.01589088903155438_dp, &
             0.0326288715086645_dp, 0.06475380759368868_dp, 0.12476876597066035_dp, &
             0.23424081600708707_dp, 0.4297430785088648_dp, 0.7724665951175793_dp, &
             1.36415811068297_dp, 2.3761018937333027_dp, 4.1158110002476525_dp, &
             7.2738777917555995_dp, &
             ! w
             0.00020582829623399666_dp, 0.0005795163034704685_dp, 0.0012939465354750554_dp, &
             0.0027884026266817487_dp, 0.005821143293247567_dp, 0.011733451054604781_dp, &
             0.02289102009240368_dp, 0.04338348628660218_dp, 0.08014502483782908_dp, &
             0.14473997264133082_dp, 0.2562100884259844_dp, 0.44575216929552997_dp, &
             0.765249583727319_dp, 1.3071066983128932_dp, 2.2723201246218485_dp, &
             4.3850533669438825_dp]

      CASE (408)

         aw(:) = & ! a
            [4.438030891276061e-05_dp, 0.00026521859119764385_dp, 0.0008308553234953406_dp, &
             0.0021681420195814446_dp, 0.005184894515915768_dp, 0.011675259442432782_dp, &
             0.025060075084169537_dp, 0.05167393749203477_dp, 0.1029490023128316_dp, &
             0.1990559138490817_dp, 0.3748926900570616_dp, 0.6898868043563599_dp, &
             1.2443377611462834_dp, 2.2090007328076124_dp, 3.8922422143769677_dp, &
             6.985966667401165_dp, &
             ! w
             0.000117061244040588_dp, 0.00034950794424142814_dp, 0.0008496206466648573_dp, &
             0.001969812141289176_dp, 0.004350855675227548_dp, 0.009179371194722275_dp, &
             0.018610919257334716_dp, 0.03646352165879841_dp, 0.06935185327196657_dp, &
             0.12852071337270213_dp, 0.23279774492844996_dp, 0.4134538405984293_dp, &
             0.7229685667095224_dp, 1.2549753888336732_dp, 2.2118227859778363_dp, &
             4.316251314870445_dp]

      CASE (409)

         aw(:) = & ! a
            [3.1869297987576294e-05_dp, 0.00019492414358100198_dp, 0.0006347353178457845_dp, &
             0.0017249961805337506_dp, 0.0042731255047116735_dp, 0.009908912660440592_dp, &
             0.0217985806983987_dp, 0.045899088408401324_dp, 0.09310959388200447_dp, &
             0.18289308993042971_dp, 0.3492826893011757_dp, 0.6507752647865163_dp, &
             1.1868817849172504_dp, 2.128034841130706_dp, 3.783018195545699_dp, &
             6.844468560787563_dp, &
             ! w
             8.448026199337955e-05_dp, 0.0002632874914218408_dp, 0.0006755667833759133_dp, &
             0.0016333352520148353_dp, 0.0037231451439136633_dp, 0.008056050505449877_dp, &
             0.016681572051630133_dp, 0.03327770276479761_dp, 0.06429041263785437_dp, &
             0.12078976154424555_dp, 0.22147582665240537_dp, 0.3976355572801984_dp, &
             0.7020384395715727_dp, 1.2289580237584161_dp, 2.1814899323970374_dp, &
             4.281756738279945_dp]

      CASE (410)

         aw(:) = & ! a
            [2.5237260590899675e-05_dp, 0.00015739213321288803_dp, 0.0005282742418487217_dp, &
             0.0014789294512643717_dp, 0.003755478032527643_dp, 0.008886464712803572_dp, &
             0.01987922539030577_dp, 0.042452297501102826_dp, 0.0871647656143441_dp, &
             0.1730235335659833_dp, 0.33349845244429505_dp, 0.6264730726762878_dp, &
             1.1509296666579922_dp, 2.0770723714927852_dp, 3.7139476866747994_dp, &
             6.754688452385413_dp, &
             ! w
             6.718393629837033e-05_dp, 0.0002168208345444966_dp, 0.0005788588947156977_dp, &
             0.0014407960268770614_dp, 0.0033559510750659906_dp, 0.007387535199394252_dp, &
             0.015516922014445595_dp, 0.031331077655121255_dp, 0.06116486142945538_dp, &
             0.11597110720426056_dp, 0.21436069380758427_dp, 0.3876228814720941_dp, &
             0.6887092107459465_dp, 1.2123118442248106_dp, 2.1620309084314937_dp, &
             4.259627929219993_dp]

      CASE (411)

         aw(:) = & ! a
            [2.1082873548577104e-05_dp, 0.0001337470439232748_dp, 0.00046030281417542055_dp, &
             0.001319089763942155_dp, 0.0034137383474493192_dp, 0.008202087463151552_dp, &
             0.018579493629608562_dp, 0.04009511197148702_dp, 0.08306468185959978_dp, &
             0.1661664950863389_dp, 0.3224617078849208_dp, 0.6093852721745535_dp, &
             1.125528328870905_dp, 2.040920061690538_dp, 3.664793009090272_dp, &
             6.6906493119640364_dp, &
             ! w
             5.6337542332766104e-05_dp, 0.0001873246783489965_dp, 0.0005159972380937614_dp, &
             0.001312978231978969_dp, 0.0031084065425590326_dp, 0.006931415407562781_dp, &
             0.014714390964448161_dp, 0.029978357818984606_dp, 0.05897697436502451_dp, &
             0.11257635906715585_dp, 0.20931967320582956_dp, 0.3804938243645329_dp, &
             0.6791790411475707_dp, 1.2003720104102569_dp, 2.1480477932275974_dp, &
             4.24372611094621_dp]

      CASE (412)

         aw(:) = & ! a
            [1.6110113710538974e-05_dp, 0.00010525743276785337_dp, 0.00037712446983756675_dp, &
             0.0011197396274799417_dp, 0.002980146520082011_dp, 0.007321198137565308_dp, &
             0.016886396920392316_dp, 0.036993331008405586_dp, 0.07762262425518779_dp, &
             0.15699688339935772_dp, 0.3076065127490934_dp, 0.5862549467587914_dp, &
             1.090976478991713_dp, 1.991542924984651_dp, 3.597440016489703_dp, &
             6.60269853853355_dp, &
             ! w
             4.333963424548889e-05_dp, 0.00015146749877325874_dp, 0.00043752467813129413_dp, &
             0.0011498795669194505_dp, 0.0027875032300416283_dp, 0.006332802126765144_dp, &
             0.013650409454938476_dp, 0.02816943790659501_dp, 0.05602936487631326_dp, &
             0.10797291643134632_dp, 0.2024444906981969_dp, 0.37072201387265813_dp, &
             0.6660605757138923_dp, 1.1838831818663529_dp, 2.1287009881566656_dp, &
             4.221724085650139_dp]

      CASE (413)

         aw(:) = & ! a
            [1.2155659454479203e-05_dp, 8.23983748572736e-05_dp, 0.00030896339837188365_dp, &
             0.0009523844991238111_dp, 0.00260842886057528_dp, 0.0065529068469690355_dp, &
             0.015388629583570622_dp, 0.03421662486963583_dp, 0.07270148210006128_dp, &
             0.14863264693165792_dp, 0.29395360397538245_dp, 0.5648571365830944_dp, &
             1.058832268452671_dp, 1.94538975252448_dp, 3.5342504978551266_dp, &
             6.519965789612569_dp, &
             ! w
             3.298926985269553e-05_dp, 0.0001223396739804258_dp, 0.00037155550618144374_dp, &
             0.0010091184074026995_dp, 0.002505333059976472_dp, 0.00579875266691652_dp, &
             0.012689822990371706_dp, 0.026519802978088165_dp, 0.05331793945992571_dp, &
             0.10370625210667844_dp, 0.19602994006852997_dp, 0.3615520738062023_dp, &
             0.6536898851571188_dp, 1.1682759321744662_dp, 2.110348795720481_dp, &
             4.200852320889001_dp]

      CASE (414)

         aw(:) = & ! a
            [7.1347100247199335e-06_dp, 5.2946703245104454e-05_dp, 0.000218126901539138_dp, &
             0.0007213605174662919_dp, 0.0020801549987173647_dp, 0.0054352820488359245_dp, &
             0.01316810092854344_dp, 0.030034571986660617_dp, 0.06519017840645336_dp, &
             0.13571934513026973_dp, 0.2726660803143451_dp, 0.5312071536236472_dp, &
             1.007909806861108_dp, 1.871824248249456_dp, 3.4330417706090337_dp, &
             6.38699885280502_dp, &
             ! w
             1.982579385525325e-05_dp, 8.402964621199333e-05_dp, 0.00028027397034065396_dp, &
             0.0008073287509403286_dp, 0.0020906122694838783_dp, 0.004998491640357875_dp, &
             0.011227464556565028_dp, 0.023974849535111926_dp, 0.04908696620605363_dp, &
             0.09698216582820675_dp, 0.18583284242914896_dp, 0.3468642560745065_dp, &
             0.6337485237556535_dp, 1.1429936952444755_dp, 2.0805350942159366_dp, &
             4.1669429466397085_dp]

      CASE (415)

         aw(:) = & ! a
            [3.7097586748543876e-06_dp, 3.2309597434583886e-05_dp, 0.0001507517917969462_dp, &
             0.0005409158661299352_dp, 0.0016506956662183882_dp, 0.004498014666298744_dp, &
             0.011259045818190115_dp, 0.026365064213282143_dp, 0.058485913189924764_dp, &
             0.12402482296873713_dp, 0.25314553559046893_dp, 0.5000163512983511_dp, &
             0.96027196458498_dp, 1.8024735420794404_dp, 3.3370542604812856_dp, &
             6.260351489602218_dp, &
             ! w
             1.0833600090655349e-05_dp, 5.616469138296074e-05_dp, 0.0002087064146430226_dp, &
             0.0006414984365406365_dp, 0.0017384232317709935_dp, 0.0043014936821916885_dp, &
             0.009927488029139939_dp, 0.02167361222899649_dp, 0.04520531727383878_dp, &
             0.09073556164946321_dp, 0.17625604547943877_dp, 0.33293876490726154_dp, &
             0.614690683320622_dp, 1.1186828635705408_dp, 2.051763837867852_dp, &
             4.134215156273755_dp]

      CASE (416)

         aw(:) = & ! a
            [2.4354136243317077e-06_dp, 2.436740109204857e-05_dp, 0.00012323987512766869_dp, &
             0.00046375324881587233_dp, 0.0014607921847590419_dp, 0.004072968279409224_dp, &
             0.010375983633463258_dp, 0.024640239423978902_dp, 0.055292431712294324_dp, &
             0.11839141619367698_dp, 0.24365163823066568_dp, 0.48472124409945827_dp, &
             0.936747200836527_dp, 1.7680261579625183_dp, 3.2891576433756384_dp, &
             6.196951887474531_dp, &
             ! w
             7.486209571735704e-06_dp, 4.4974493230726e-05_dp, 0.0001779984909799321_dp, &
             0.000567577081138818_dp, 0.0015772245267925906_dp, 0.00397598562426191_dp, &
             0.009310528653457151_dp, 0.020566865562055732_dp, 0.043317469396910266_dp, &
             0.08766818952983264_dp, 0.17151409332861423_dp, 0.3259937254252641_dp, &
             0.6051282005497428_dp, 1.106427609421274_dp, 2.0372203067713297_dp, &
             4.117669733570923_dp]

      CASE (417)

         aw(:) = & ! a
            [1.9085961715955434e-06_dp, 2.0995043960013904e-05_dp, 0.00011111398867441926_dp, &
             0.00042885255913484543_dp, 0.0013733360820866016_dp, 0.003874593789234121_dp, &
             0.009959559027290782_dp, 0.023820069278143882_dp, 0.0537634425665394_dp, &
             0.11567862202124427_dp, 0.23905729559633404_dp, 0.47728836137347114_dp, &
             0.9252740091801204_dp, 1.7511759472651802_dp, 3.2656740667243875_dp, &
             6.165816271073438_dp, &
             ! w
             6.101229797346719e-06_dp, 4.00837025306848e-05_dp, 0.0001640844444725366_dp, &
             0.00053340032030255_dp, 0.00150164908261384_dp, 0.003821757919080607_dp, &
             0.009015751682969649_dp, 0.020034430842349286_dp, 0.04240401234061361_dp, &
             0.08617667866638216_dp, 0.1691984867198657_dp, 0.3225898169116341_dp, &
             0.6004269137751367_dp, 1.1003880758298388_dp, 2.0300430086921573_dp, &
             4.109503927013779_dp]

      CASE (418)

         aw(:) = & ! a
            [1.908279945252509e-06_dp, 2.099299427495672e-05_dp, 0.00011110651444748947_dp, &
             0.00042883085533252464_dp, 0.0013732813892174006_dp, 0.0038744692237789734_dp, &
             0.00995929668391619_dp, 0.023819551138145992_dp, 0.05376247448222308_dp, &
             0.11567690110584063_dp, 0.23905437629412185_dp, 0.47728363290101083_dp, &
             0.9252667046693415_dp, 1.7511652086513543_dp, 3.265659074902631_dp, &
             6.1657963486574845_dp, &
             ! w
             6.10039728638634e-06_dp, 4.008069629625031e-05_dp, 0.00016407578363587837_dp, &
             0.000533378918013126_dp, 0.0015016015641512589_dp, 0.0038216606296993015_dp, &
             0.009015565175734293_dp, 0.02003409319715033_dp, 0.042403432006524695_dp, &
             0.08617572939827894_dp, 0.16919701115096455_dp, 0.32258764719545124_dp, &
             0.6004239149409639_dp, 1.100384212656272_dp, 2.0300383954052896_dp, &
             4.109498654374117_dp]

      CASE (419)

         aw(:) = & ! a
            [0.011763649966993063_dp, 0.062428205737342514_dp, 0.15544990740250392_dp, &
             0.29427287137907343_dp, 0.4843511156615427_dp, 0.7337793906644704_dp, &
             1.0541795508192826_dp, 1.4618861427706884_dp, 1.9794504252494227_dp, &
             2.63752178585389_dp, 3.4773350777344394_dp, 4.55440587644354_dp, &
             5.944785288108488_dp, 7.75703952819382_dp, 10.158682924645307_dp, &
             13.44791160523966_dp, 18.338684467263775_dp, &
             ! w
             0.030239769948628595_dp, 0.07141117296934633_dp, 0.11519834133086981_dp, &
             0.16334634556994845_dp, 0.2181445810861672_dp, 0.2826292106846991_dp, &
             0.3608685543158396_dp, 0.45827228192839375_dp, 0.5819243715708697_dp, &
             0.7410321325985205_dp, 0.9477492570824826_dp, 1.2188845101312764_dp, &
             1.57958056177065_dp, 2.071871446036535_dp, 2.7779101419370362_dp, &
             3.901959355820747_dp, 6.2568211133691465_dp]

      CASE (420)

         aw(:) = & ! a
            [0.008620957574467123_dp, 0.04582067200269628_dp, 0.11442264748254989_dp, &
             0.21754831945248493_dp, 0.36023713511117667_dp, 0.5501295551911949_dp, &
             0.7984222655089384_dp, 1.1211082157416934_dp, 1.540490816448991_dp, &
             2.0870398051392733_dp, 2.801872780790989_dp, 3.7405073580248507_dp, &
             4.979201454264444_dp, 6.626927101387456_dp, 8.851486285748587_dp, &
             11.950038790447127_dp, 16.629053519985472_dp, &
             ! w
             0.02216899543476805_dp, 0.05251363169828869_dp, 0.085202491882224_dp, &
             0.1218775877465484_dp, 0.16475754546913823_dp, 0.21687267548632566_dp, &
             0.2823530993770712_dp, 0.3667057338149049_dp, 0.47709784588892884_dp, &
             0.6227933403263984_dp, 0.8160260402127403_dp, 1.0737693823036798_dp, &
             1.421396979956243_dp, 1.9010620007560268_dp, 2.5944356141359597_dp, &
             3.703154472169265_dp, 6.026307922042811_dp]

      CASE (421)

         aw(:) = & ! a
            [0.006889377762839884_dp, 0.03666190803574594_dp, 0.09176037150749558_dp, &
             0.17507037815620646_dp, 0.2913192809176048_dp, 0.44778720445993453_dp, &
             0.6552926902022264_dp, 0.9294428610717238_dp, 1.2921313629933526_dp, &
             1.7733859123770381_dp, 2.413897575278871_dp, 3.2688815574094914_dp, &
             4.414534121752955_dp, 5.960042491831377_dp, 8.073518859029836_dp, &
             11.051769565150513_dp, 15.597025220046245_dp, &
             ! w
             0.017721171780941552_dp, 0.04208044998936166_dp, 0.06858925211169453_dp, &
             0.09880696703542288_dp, 0.13488771487291526_dp, 0.1798302894659236_dp, &
             0.23775709667732445_dp, 0.3141621682693045_dp, 0.4161787636643034_dp, &
             0.5530505032238192_dp, 0.7370736963599462_dp, 0.9854093744573996_dp, &
             1.3237121967377334_dp, 1.7943741588876145_dp, 2.478935025274032_dp, &
             3.5775455854296867_dp, 5.880876156058426_dp]

      CASE (422)

         aw(:) = & ! a
            [0.005779061268096959_dp, 0.030784849069456433_dp, 0.07719912472356236_dp, &
             0.14772533472747335_dp, 0.24684498770688412_dp, 0.38154420376776327_dp, &
             0.562310957764068_dp, 0.8043777658932391_dp, 1.1292008564500715_dp, &
             1.5663159266865059_dp, 2.155932832858683_dp, 2.9529057092101003_dp, &
             4.033296773451878_dp, 5.506429240336444_dp, 7.540703753038025_dp, &
             10.432830899152323_dp, 14.882266755973522_dp, &
             ! w
             0.01486866603880088_dp, 0.035379580456098146_dp, 0.057891335478331786_dp, &
             0.08389601665202415_dp, 0.11549092435956188_dp, 0.15563470586681194_dp, &
             0.20841320749677028_dp, 0.2792663830727313_dp, 0.3752605918790275_dp, &
             0.5056075720898942_dp, 0.6826650143959483_dp, 0.9237725888705499_dp, &
             1.254850152598101_dp, 1.7185396923469536_dp, 2.3963756361848145_dp, &
             3.487537801182031_dp, 5.776796760268069_dp]

      CASE (423)

         aw(:) = & ! a
            [0.005000767488016341_dp, 0.02666265026927288_dp, 0.06697428709127144_dp, &
             0.12849263546697673_dp, 0.21549854969570803_dp, 0.3347316344380094_dp, &
             0.49638900920800944_dp, 0.7153535743415229_dp, 1.0126577716550769_dp, &
             1.4173574351365212_dp, 1.9691940995077597_dp, 2.7226634022245193_dp, &
             3.7536719703944716_dp, 5.171634173848079_dp, 7.145208539203496_dp, &
             9.971124475461954_dp, 14.34686193502478_dp, &
             ! w
             0.012868864174744343_dp, 0.030675943104970887_dp, 0.05036525777390434_dp, &
             0.073372753832673_dp, 0.10174556517314705_dp, 0.13839960202350926_dp, &
             0.18737164472211038_dp, 0.2540325726980337_dp, 0.3453754544025245_dp, &
             0.47058211473370076_dp, 0.642068590905447_dp, 0.8773350492032141_dp, &
             1.202538866223134_dp, 1.6605588690218929_dp, 2.3329791005813414_dp, &
             3.418291325722145_dp, 5.696809904804326_dp]

      CASE (424)

         aw(:) = & ! a
            [0.0044220826490264055_dp, 0.02359598421362561_dp, 0.05936008899326881_dp, &
             0.1141499987320069_dp, 0.19207831536019496_dp, 0.2996733309241805_dp, &
             0.4468736581015505_dp, 0.648239768682221_dp, 0.9244066057150568_dp, &
             1.3039805390235892_dp, 1.826265661366115_dp, 2.545418158136293_dp, &
             3.5371843477475413_dp, 4.911040657049191_dp, 6.835874198167441_dp, &
             9.608488910004654_dp, 13.924877699901952_dp, &
             ! w
             0.011381759979217747_dp, 0.027174359344044833_dp, 0.04475154671090715_dp, &
             0.06550144903949855_dp, 0.09142650354599316_dp, 0.12539976786986748_dp, &
             0.17140391911969466_dp, 0.23473676962871573_dp, 0.32232050377890237_dp, &
             0.4433112013591309_dp, 0.6101784217262354_dp, 0.8405640412966287_dp, &
             1.1608360910097697_dp, 1.6140922256599763_dp, 2.281992414549576_dp, &
             3.3625148353540113_dp, 5.632440674010009_dp]

      CASE (425)

         aw(:) = & ! a
            [0.0039733564241690176_dp, 0.021216843249974877_dp, 0.05344768383817142_dp, &
             0.10299863204844592_dp, 0.1738382188340671_dp, 0.2723103794523001_dp, &
             0.40812171683281745_dp, 0.5955361059459275_dp, 0.8548199579708161_dp, &
             1.2141643235424078_dp, 1.7124696860301576_dp, 2.403575315218784_dp, &
             3.3630688929233137_dp, 4.700468631856519_dp, 6.584864495752914_dp, &
             9.313163003961266_dp, 13.580193642335534_dp, &
             ! w
             0.010228490409033503_dp, 0.024456161592103284_dp, 0.04038608186423737_dp, &
             0.05936493428426412_dp, 0.08335494359406384_dp, 0.11518728600334556_dp, &
             0.15878918103150655_dp, 0.21938622069978075_dp, 0.30383483930485183_dp, &
             0.42126916739472764_dp, 0.5842068690607539_dp, 0.8104146081742157_dp, &
             1.1264476636364262_dp, 1.5756047826778998_dp, 2.2396347826394383_dp, &
             3.316118284642388_dp, 5.578937934634807_dp]

      CASE (426)

         aw(:) = & ! a
            [0.0036142847601028185_dp, 0.019312197936351656_dp, 0.04871062565606132_dp, &
             0.09405361299570067_dp, 0.15918429328598857_dp, 0.25028350487151524_dp, &
             0.3768478515919124_dp, 0.5528681138914167_dp, 0.7982702270194616_dp, &
             1.140862874047967_dp, 1.6191750225339965_dp, 2.286751024183023_dp, &
             3.2190241844884033_dp, 4.525539770823869_dp, 6.3755685758961_dp, &
             9.06613362289836_dp, 13.291127529467497_dp, &
             ! w
             0.00930554527992734_dp, 0.022278887164099686_dp, 0.03688376103369464_dp, &
             0.05443042467660224_dp, 0.07684460681041379_dp, 0.10691705032991418_dp, &
             0.14852004495201218_dp, 0.20680991906152918_dp, 0.28858301637420974_dp, &
             0.402954506487906_dp, 0.5624848391441751_dp, 0.7850508763672497_dp, &
             1.0973753054331812_dp, 1.5429418443905634_dp, 2.2035942157384123_dp, &
             3.2765969845607468_dp, 5.533394223709508_dp]

      CASE (427)

         aw(:) = & ! a
            [0.0033198247340284217_dp, 0.017749631331696807_dp, 0.044821455936419015_dp, &
             0.08670170571507395_dp, 0.1471228721624465_dp, 0.2321198066274997_dp, &
             0.35099758950161103_dp, 0.5174948868641361_dp, 0.7512229986159361_dp, &
             1.0796383396633986_dp, 1.540927319309597_dp, 2.1883595496344137_dp, &
             3.0972191923966146_dp, 4.377067543193302_dp, 6.197337489998881_dp, &
             8.855174803475688_dp, 13.043700459848505_dp, &
             ! w
             0.008548602711241414_dp, 0.020491752428293177_dp, 0.03400477083242754_dp, &
             0.05036551539464545_dp, 0.07146632918399287_dp, 0.10005915841952623_dp, &
             0.13996286257638943_dp, 0.19626829904821647_dp, 0.27571710170098357_dp, &
             0.38740772532883344_dp, 0.5439384928815124_dp, 0.7632840773608892_dp, &
             1.0723178584501674_dp, 1.514694260200086_dp, 2.172354226390208_dp, &
             3.2423058243498173_dp, 5.493900885483596_dp]

      CASE (428)

         aw(:) = & ! a
            [0.0018882627435518682_dp, 0.010141716994752921_dp, 0.02583472761831859_dp, &
             0.05066872653408917_dp, 0.08769367251778923_dp, 0.14199794933436113_dp, &
             0.22157713402556642_dp, 0.3384059441793975_dp, 0.509905782056896_dp, &
             0.7610963644983121_dp, 1.1277658774087937_dp, 1.6611792947718913_dp, &
             2.4354020371117624_dp, 3.559892362248305_dp, 5.205100219607091_dp, &
             7.669306130543646_dp, 11.641887484729258_dp, &
             ! w
             0.00486734104806698_dp, 0.011774633045678043_dp, 0.019887079142862772_dp, &
             0.030277600427505283_dp, 0.04460586633113461_dp, 0.06531793316988077_dp, &
             0.09581248220465682_dp, 0.1407135799336433_dp, 0.20640432448587542_dp, &
             0.3018653172872778_dp, 0.43990111840158036_dp, 0.6390746417174834_dp, &
             0.9272349393169635_dp, 1.34924330660015_dp, 1.9879267827114793_dp, &
             3.039156813544293_dp, 5.260387230811638_dp]

      CASE (429)

         aw(:) = & ! a
            [0.0013527924373737048_dp, 0.0072886986335998_dp, 0.018681297463412815_dp, &
             0.036999273564417796_dp, 0.06493527017972293_dp, 0.10704888590724806_dp, &
             0.17056757629874036_dp, 0.26642384857892054_dp, 0.4107577410338992_dp, &
             0.6271579934161993_dp, 0.9499639456298539_dp, 1.4291576240431079_dp, &
             2.1379244969668703_dp, 3.1854886763815116_dp, 4.742811677117564_dp, &
             7.109007686904927_dp, 10.972131782040323_dp, &
             ! w
             0.003489557005875298_dp, 0.008495377107671717_dp, 0.014527041401980967_dp, &
             0.022546802751019696_dp, 0.03407194037548306_dp, 0.0513432024006064_dp, &
             0.07749186527362117_dp, 0.11687403369619569_dp, 0.1756713275412031_dp, &
             0.26277313531696966_dp, 0.39104830780991007_dp, 0.5793369494164639_dp, &
             0.8560194482301063_dp, 1.2666966821386287_dp, 1.894870709031309_dp, &
             2.936128075912932_dp, 5.142256045981233_dp]

      CASE (430)

         aw(:) = & ! a
            [0.0010664804747085547_dp, 0.00576045171825998_dp, 0.014836817086855152_dp, &
             0.029616562839403903_dp, 0.05255860019576755_dp, 0.0878641811279735_dp, &
             0.14223231648066315_dp, 0.22588150203936602_dp, 0.3540758486226656_dp, &
             0.5494155210276604_dp, 0.8452157720214318_dp, 1.2905193491966398_dp, &
             1.9578266197559235_dp, 2.956120434508262_dp, 4.456673816212555_dp, &
             6.75923087522096_dp, 10.551209538157856_dp, &
             ! w
             0.0027525568817549193_dp, 0.006734925870965941_dp, 0.011630694813380601_dp, &
             0.018328397086009855_dp, 0.028243588680285404_dp, 0.04346768068443954_dp, &
             0.066946825683937_dp, 0.10285810200166813_dp, 0.15724216557766652_dp, &
             0.23890847369320603_dp, 0.3607421430923924_dp, 0.5417453516089881_dp, &
             0.8106492863971688_dp, 1.2135804900968097_dp, 1.8345705538017225_dp, &
             2.8691445129195685_dp, 5.065557756580005_dp]

      CASE (431)

         aw(:) = & ! a
            [0.0008863304499981982_dp, 0.004797478687156452_dp, 0.012407937782549144_dp, &
             0.024933671543423255_dp, 0.04466350896406489_dp, 0.07553210536955951_dp, &
             0.1238433200134319_dp, 0.19928383025465143_dp, 0.31646429392274816_dp, &
             0.49723949290802594_dp, 0.7741388461621441_dp, 1.195466624778922_dp, &
             1.8331629335494573_dp, 2.7959834160555097_dp, 4.255410703916915_dp, &
             6.511688762572313_dp, 10.251886422940728_dp, &
             ! w
             0.0022886748517332673_dp, 0.00562368283450409_dp, 0.009792873303731632_dp, &
             0.015630407664363275_dp, 0.02447336577695618_dp, 0.03829819219676908_dp, &
             0.0599135544832279_dp, 0.09336464230798491_dp, 0.1445828113357693_dp, &
             0.22230646763359777_dp, 0.3394170592751431_dp, 0.5150227219028766_dp, &
             0.7781099899771061_dp, 1.1752094119195156_dp, 1.7907855704489537_dp, &
             2.8203860853302944_dp, 5.009777496447649_dp]

      CASE (432)

         aw(:) = & ! a
            [0.0007617277641131662_dp, 0.004130617806061752_dp, 0.010722167674873705_dp, &
             0.021672433881065812_dp, 0.03913841256538039_dp, 0.06684502062270839_dp, &
             0.11078483737003565_dp, 0.18022671433961276_dp, 0.28926629000646814_dp, &
             0.45916520195104404_dp, 0.7218187960719699_dp, 1.124924555369314_dp, &
             1.7399490705067022_dp, 2.675438183296255_dp, 4.103024447436759_dp, &
             6.323363228630736_dp, 10.023320633186344_dp, &
             ! w
             0.0019677354874388323_dp, 0.004853001746142512_dp, 0.008512641693891775_dp, &
             0.013738205589199897_dp, 0.02180334470995126_dp, 0.034592412327327654_dp, &
             0.05480672949392181_dp, 0.08638807202337442_dp, 0.13517816253357462_dp, &
             0.20985174763033818_dp, 0.32327734113038836_dp, 0.49463718513740845_dp, &
             0.7531150452829314_dp, 1.1455673736824923_dp, 1.7568239419680498_dp, &
             2.782491770486839_dp, 4.966453841342643_dp]

      CASE (433)

         aw(:) = & ! a
            [0.000670014476793155_dp, 0.003639256680814586_dp, 0.00947761441997857_dp, &
             0.01925754176216679_dp, 0.035029474705086584_dp, 0.06034701897970911_dp, &
             0.10094857952065324_dp, 0.16576236607034503_dp, 0.2684625388540078_dp, &
             0.42982118843709644_dp, 0.6812043753394367_dp, 1.0697957652746826_dp, &
             1.666652242217474_dp, 2.580126489097479_dp, 3.981962769209941_dp, &
             6.17316428323695_dp, 9.840477650921452_dp, &
             ! w
             0.0017314513798382411_dp, 0.004284407889281309_dp, 0.007564451405461784_dp, &
             0.012328362033896246_dp, 0.0197968832453667_dp, 0.031778415851714335_dp, &
             0.05088734010781185_dp, 0.08098084577261747_dp, 0.12782454895000084_dp, &
             0.20003572183631715_dp, 0.31046542437755614_dp, 0.47835010535418493_dp, &
             0.7330321104341379_dp, 1.12163962047183_dp, 1.7293175542134887_dp, &
             2.7517493678958247_dp, 4.931324161744377_dp]

      CASE (434)

         aw(:) = & ! a
            [0.0005994659006691419_dp, 0.003260929328746702_dp, 0.008517683368674414_dp, &
             0.017389897955788717_dp, 0.03183926194759523_dp, 0.05527562479185905_dp, &
             0.09322430615404195_dp, 0.15432815172523684_dp, 0.25190682909537176_dp, &
             0.4063175936906406_dp, 0.6484737266112314_dp, 1.0251141636009289_dp, &
             1.6069349856798574_dp, 2.502110635448886_dp, 3.8824710537171936_dp, &
             6.049319622362817_dp, 9.689334495884646_dp, &
             ! w
             0.0015496548496931517_dp, 0.0038461093612214814_dp, 0.006831009858755705_dp, &
             0.011231934737732102_dp, 0.018224474401726948_dp, 0.02955297127098162_dp, &
             0.04775941289319049_dp, 0.07662968471095458_dp, 0.12186323208611664_dp, &
             0.192025057361598_dp, 0.29994658510881267_dp, 0.4649051786447571_dp, &
             0.7163744310297717_dp, 1.1017145944498874_dp, 1.7063473740013237_dp, &
             2.7260403665683968_dp, 4.9019578207789705_dp]

      CASE (435)

         aw(:) = & ! a
            [0.0005433808812488209_dp, 0.0029599069426816398_dp, 0.007752684216764555_dp, &
             0.015897848233704857_dp, 0.02928149980759579_dp, 0.05119036260266149_dp, &
             0.08696747345379538_dp, 0.14501159846505923_dp, 0.23833799205350642_dp, &
             0.3869453058931429_dp, 0.6213522337346994_dp, 0.987906301446031_dp, &
             1.5569814737710108_dp, 2.436587099282762_dp, 3.7986202418785147_dp, &
             5.944647520478597_dp, 9.561311563070827_dp, &
             ! w
             0.0014051007766722966_dp, 0.0034970054384386865_dp, 0.006244986422830312_dp, &
             0.010351561402402542_dp, 0.016953108432719518_dp, 0.02773897849645473_dp, &
             0.04518956343570459_dp, 0.07302927511499638_dp, 0.11689902572804858_dp, &
             0.18531596227571526_dp, 0.2910909270989169_dp, 0.4535328802956833_dp, &
             0.702226457158761_dp, 1.0847337738721048_dp, 1.6867230015056864_dp, &
             2.7040488024480958_dp, 4.876845927033721_dp]

      CASE (436)

         aw(:) = & ! a
            [0.0004976403321071418_dp, 0.002714212750478709_dp, 0.007127380424846257_dp, &
             0.01467548508745452_dp, 0.027179113748376327_dp, 0.04781782740021432_dp, &
             0.08177621466071466_dp, 0.13724081513199407_dp, 0.22696117487490997_dp, &
             0.37062107412592427_dp, 0.5983902924464397_dp, 0.9562673114382849_dp, &
             1.5143353451316333_dp, 2.380450186248581_dp, 3.7265623220764432_dp, &
             5.85447219564017_dp, 9.450809001670763_dp, &
             ! w
             0.0012871872080564162_dp, 0.003211794161382628_dp, 0.005764831078351174_dp, &
             0.00962694414424929_dp, 0.015899986192882947_dp, 0.026225417129850274_dp, &
             0.04303030664412398_dp, 0.06998514403816393_dp, 0.11267837845960989_dp, &
             0.17958307908069895_dp, 0.28348923994622244_dp, 0.44373063669581314_dp, &
             0.6899874875249782_dp, 1.070000048658365_dp, 1.669658407541783_dp, &
             2.684904664172808_dp, 4.8549914587310425_dp]

      CASE (437)

         aw(:) = & ! a
            [0.00027873969184184674_dp, 0.00153509211230705_dp, 0.004110690792904548_dp, &
             0.008729310582552594_dp, 0.016827760292598675_dp, 0.030952553619796153_dp, &
             0.055356499116054905_dp, 0.09697227413991218_dp, 0.16695506247712322_dp, &
             0.28305998361524637_dp, 0.4732691834136238_dp, 0.7813315385337429_dp, &
             1.2753824306906016_dp, 2.0621523950909895_dp, 3.3137957600148757_dp, &
             5.333592025630548_dp, 8.808438491898944_dp, &
             ! w
             0.000722522787781202_dp, 0.0018383479865653803_dp, 0.0034284305708949456_dp, &
             0.006041941094276915_dp, 0.010569894375873_dp, 0.018372683734438747_dp, &
             0.031565549776009595_dp, 0.053486530005002426_dp, 0.08937927959131456_dp, &
             0.1474044567948892_dp, 0.24016684640466546_dp, 0.38709004953734244_dp, &
             0.6183966764795468_dp, 0.9829329898408707_dp, 1.568061487599537_dp, &
             2.5704877366016645_dp, 4.724484641752887_dp]

      CASE (438)

         aw(:) = & ! a
            [0.0001984953473166477_dp, 0.0011007426306861563_dp, 0.0029892040618499705_dp, &
             0.0064860166922959565_dp, 0.012839078088964787_dp, 0.024282422724072522_dp, &
             0.044610697853502225_dp, 0.08013208455353914_dp, 0.14118815552223068_dp, &
             0.24452183065262578_dp, 0.41693201821252734_dp, 0.7009081577243788_dp, &
             1.1634433815360945_dp, 1.9105417240992761_dp, 3.1143693332951914_dp, &
             5.0790073624075776_dp, 8.491728023012124_dp, &
             ! w
             0.0005152964505271766_dp, 0.0013294206789940207_dp, 0.00254676554648255_dp, &
             0.004649177220738149_dp, 0.008420105358948896_dp, 0.015083554228289199_dp, &
             0.02659967787776162_dp, 0.04612823689556763_dp, 0.07871505212539648_dp, &
             0.13232748859318125_dp, 0.21943270040383067_dp, 0.35945626577909584_dp, &
             0.5828720549538152_dp, 0.939113828916259_dp, 1.5163956265285226_dp, &
             2.5119855345932347_dp, 4.657820695446526_dp]

      CASE (439)

         aw(:) = & ! a
            [0.0001560036351335973_dp, 0.0008699543072648038_dp, 0.002389404106247081_dp, &
             0.00527339002010383_dp, 0.010650437240237379_dp, 0.02055766557308312_dp, &
             0.038500719124384054_dp, 0.0703892927052089_dp, 0.12603760027070512_dp, &
             0.22152163651719636_dp, 0.38284726583797_dp, 0.6516434522803097_dp, &
             1.0941030700653211_dp, 1.8156960891012024_dp, 2.988555833847681_dp, &
             4.917298397923595_dp, 8.28952974750375_dp, &
             ! w
             0.0004054777725141608_dp, 0.001057885055165663_dp, 0.0020701844217904607_dp, &
             0.0038805823916970897_dp, 0.007204052901643639_dp, 0.013179504777142824_dp, &
             0.023667219999698796_dp, 0.041707389259586766_dp, 0.07220904546186369_dp, &
             0.12300112756582732_dp, 0.20644444370191073_dp, 0.34194772283335984_dp, &
             0.5601360518319131_dp, 0.9108314795281586_dp, 1.4828393697982243_dp, &
             2.4738623767994983_dp, 4.614399607769071_dp]

      CASE (440)

         aw(:) = & ! a
            [0.00012942660369669388_dp, 0.0007252109691484227_dp, 0.0020112414165164147_dp, &
             0.004502205499976117_dp, 0.009241924957420352_dp, 0.018128200916790103_dp, &
             0.034461652810250175_dp, 0.06386657781717088_dp, 0.11577518861573856_dp, &
             0.2057748375160446_dp, 0.35928348369804525_dp, 0.6172838037451012_dp, &
             1.0453574126507788_dp, 1.748553561064432_dp, 2.8989593755718_dp, &
             4.80158540961176_dp, 8.14432591416385_dp, &
             ! w
             0.0003367471971412926_dp, 0.0008870248350176341_dp, 0.0017671250240551047_dp, &
             0.0033837180880403332_dp, 0.006403200196190485_dp, 0.011904536113767494_dp, &
             0.021675708252598944_dp, 0.03866812999138343_dp, 0.0676873864573128_dp, &
             0.1164553957031185_dp, 0.1972469731352802_dp, 0.3294489379855182_dp, &
             0.5437893337218036_dp, 0.8903748071315685_dp, 1.4584594866065748_dp, &
             2.4460979032403842_dp, 4.582786015781227_dp]

      CASE (441)

         aw(:) = & ! a
            [0.00011111963314320988_dp, 0.000625278687246286_dp, 0.0017489792522994028_dp, &
             0.00396340573031236_dp, 0.00824803957348528_dp, 0.016395107811091034_dp, &
             0.0315493517865167_dp, 0.05911635446494708_dp, 0.1082330020586242_dp, &
             0.1941055905637425_dp, 0.34168954280208236_dp, 0.5914540652570976_dp, &
             1.0084890439982894_dp, 1.6974976864246518_dp, 2.8305173366405514_dp, &
             4.712867256904743_dp, 8.032692308689725_dp, &
             ! w
             0.00028937880586602514_dp, 0.0007687334262258107_dp, 0.0015554121481513774_dp, &
             0.00303179736256024_dp, 0.0058274883277793475_dp, 0.010976070665113313_dp, &
             0.02020954884085334_dp, 0.03640939553666422_dp, 0.06429864525039648_dp, &
             0.1115124584041263_dp, 0.19025376465279834_dp, 0.3198864932433305_dp, &
             0.5312141007951445_dp, 0.8745650190632126_dp, 1.4395525665351276_dp, &
             2.424525925156707_dp, 4.558228384233685_dp]

      CASE (442)

         aw(:) = & ! a
            [9.768541498147083e-05_dp, 0.0005517983285910077_dp, 0.0015553737137321002_dp, &
             0.0035630585294778006_dp, 0.007503206642130452_dp, 0.015084302733820118_dp, &
             0.029327016433648698_dp, 0.05546166717945008_dp, 0.10238679885885461_dp, &
             0.18499904005737647_dp, 0.3278752751518903_dp, 0.5710612168073389_dp, &
             0.9792371997555712_dp, 1.656813253858836_dp, 2.775776972366038_dp, &
             4.641699008772861_dp, 7.942944658981498_dp, &
             ! w
             0.0002546024856868256_dp, 0.0006815428354254016_dp, 0.0013981202324835494_dp, &
             0.002767207087865029_dp, 0.0053892678391408485_dp, 0.010261856997860481_dp, &
             0.019071700100119625_dp, 0.03464297025325642_dp, 0.061630412276498785_dp, &
             0.10759654307172731_dp, 0.18468271032482161_dp, 0.31223039308565087_dp, &
             0.5211010386267269_dp, 0.8618030928018889_dp, 1.4242478034182446_dp, &
             2.4070372300275924_dp, 4.538322169383284_dp]

      CASE (443)

         aw(:) = & ! a
            [8.73752485729232e-05_dp, 0.0004953046592686002_dp, 0.0014059944165274103_dp, &
             0.0032523542512961734_dp, 0.006920780986677007_dp, 0.014051128308219434_dp, &
             0.027562034504967203_dp, 0.052538848222604025_dp, 0.09768179259767383_dp, &
             0.17762834439838698_dp, 0.31663675253655615_dp, 0.554393972308045_dp, &
             0.955230608435182_dp, 1.6233028811680008_dp, 2.730550113923314_dp, &
             4.582753592147178_dp, 7.868474720030727_dp, &
             ! w
             0.00022790231031207566_dp, 0.0006143635134771986_dp, 0.001276061383204444_dp, &
             0.002559718460344272_dp, 0.005041980338497405_dp, 0.009690807264611922_dp, &
             0.01815515505247096_dp, 0.03321092592577857_dp, 0.05945488947841082_dp, &
             0.10438728849400189_dp, 0.18009572483079425_dp, 0.3059001779584581_dp, &
             0.5127082722054082_dp, 0.8511788881930034_dp, 1.4114768032680935_dp, &
             2.3924251516095367_dp, 4.521692150398395_dp]

      CASE (444)

         aw(:) = & ! a
            [7.91937539895247e-05_dp, 0.00045040231500375445_dp, 0.0012868784814711026_dp, &
             0.0030032754553129806_dp, 0.006450716747020653_dp, 0.013211411470947522_dp, &
             0.026118015886734368_dp, 0.05013308761410789_dp, 0.0937880163778335_dp, &
             0.17149857922072664_dp, 0.3072490907067271_dp, 0.5404164110122928_dp, &
             0.9350268144743565_dp, 1.5950131357874375_dp, 2.6922684555193763_dp, &
             4.53275436155042_dp, 7.805208492281784_dp, &
             ! w
             0.00020670692329994715_dp, 0.0005608633909978252_dp, 0.00117822162433395_dp, &
             0.0023918307239149386_dp, 0.0047583847220433_dp, 0.009220914082914599_dp, &
             0.017396140411831254_dp, 0.032018442928032666_dp, 0.05763439977639338_dp, &
             0.10168990311563929_dp, 0.1762249592552838_dp, 0.3005391543097987_dp, &
             0.5055778600099088_dp, 0.8421284564034203_dp, 1.4005756769476354_dp, &
             2.3799387445050417_dp, 4.507482674005179_dp]

      CASE (445)

         aw(:) = & ! a
            [7.253109651073766e-05_dp, 0.00041378154246698155_dp, 0.0011894399545926847_dp, &
             0.002798526161215177_dp, 0.0060619459096750185_dp, 0.012512555917585542_dp, &
             0.024909165862831623_dp, 0.048108395498071804_dp, 0.09049532883191257_dp, &
             0.16629281149996789_dp, 0.29924575163888323_dp, 0.5284587376245806_dp, &
             0.9176892895564356_dp, 1.570671056991115_dp, 2.6592530593275407_dp, &
             4.489553818009151_dp, 7.750470715825014_dp, &
             ! w
             0.00018944048236774636_dp, 0.0005171521579185408_dp, 0.0010978019908693144_dp, &
             0.0022526568166520147_dp, 0.004521376664593447_dp, 0.008825576279679542_dp, &
             0.01675397683357181_dp, 0.031004652336597036_dp, 0.05608005851915602_dp, &
             0.09937797972756338_dp, 0.1728957766066036_dp, 0.29591376298043276_dp, &
             0.49940880628805856_dp, 0.8342799329605631_dp, 1.3911056054623188_dp, &
             2.3690809988090367_dp, 4.495127507755016_dp]

      CASE (446)

         aw(:) = & ! a
            [4.076405814605627e-05_dp, 0.0002382538909882903_dp, 0.0007172785036174207_dp, &
             0.0017887553118032778_dp, 0.004103604590222173_dp, 0.008917043928917007_dp, &
             0.01856727787107811_dp, 0.03729823641325223_dp, 0.0726364608741809_dp, &
             0.13765684708104833_dp, 0.2546598181053789_dp, 0.46108210773932384_dp, &
             0.8190039334641068_dp, 1.430877164081293_dp, 2.4682103026290094_dp, &
             4.238054139494266_dp, 7.4303818821050625_dp, &
             ! w
             0.0001070172373037324_dp, 0.0003062882624906517_dp, 0.0007012936016619437_dp, &
             0.0015459700494373915_dp, 0.003285238333576259_dp, 0.006718115008619782_dp, &
             0.013267499406418276_dp, 0.02541228267400262_dp, 0.04738390796270287_dp, &
             0.08627812215453308_dp, 0.15381430652300426_dp, 0.2691274981527009_dp, &
             0.46335419123057037_dp, 0.7880529629290074_dp, 1.3350005054020597_dp, &
             2.3045456706196203_dp, 4.4217074746843075_dp]

      CASE (447)

         aw(:) = & ! a
            [2.9160936668075905e-05_dp, 0.00017355365502172055_dp, 0.0005398265608048895_dp, &
             0.001397672386055173_dp, 0.003319019707423856_dp, 0.007429464246465446_dp, &
             0.01586691150562701_dp, 0.032577269870254215_dp, 0.0646612793531233_dp, &
             0.12461399088347623_dp, 0.23399280448585136_dp, 0.4293596632660751_dp, &
             0.771894119047728_dp, 1.3633337240128052_dp, 2.3749596565687208_dp, &
             4.114290731871903_dp, 7.271927422956754_dp, &
             ! w
             7.68502849403993e-05_dp, 0.00022768629688079903_dp, 0.0005477514153739001_dp, &
             0.0012592680559984917_dp, 0.0027636737709961353_dp, 0.005800766185918572_dp, &
             0.01171012014882713_dp, 0.022857962653192496_dp, 0.04333336440525826_dp, &
             0.08006903987145882_dp, 0.14462760292712087_dp, 0.25604969227661944_dp, &
             0.4455328439242189_dp, 0.764964512131641_dp, 1.3067570821118795_dp, &
             2.271915618884096_dp, 4.384593311974348_dp]

      CASE (448)

         aw(:) = & ! a
            [2.3021089475914032e-05_dp, 0.00013909831636292537_dp, 0.0004439894685442402_dp, &
             0.0011820562313644377_dp, 0.002876968546066814_dp, 0.0065746397526069145_dp, &
             0.014288246252458177_dp, 0.02977581333132268_dp, 0.05986665219462856_dp, &
             0.11668233589728014_dp, 0.22129675320222594_dp, 0.4096963661407671_dp, &
             0.7424605034446863_dp, 1.3208411240770856_dp, 2.315951441084732_dp, &
             4.035609898218205_dp, 7.170851898076781_dp, &
             ! w
             6.086526423575163e-05_dp, 0.00018549226025884883_dp, 0.0004630837126782273_dp, &
             0.0010964616570390648_dp, 0.0024605616099429603_dp, 0.005257849618763615_dp, &
             0.010774390164609474_dp, 0.021303199826252648_dp, 0.04083970904018302_dp, &
             0.07620781031516743_dp, 0.13886307130363254_dp, 0.24777738090808893_dp, &
             0.43417998023950005_dp, 0.7501681263270686_dp, 1.2885748376435835_dp, &
             2.250855744705992_dp, 4.360641433740663_dp]

      CASE (449)

         aw(:) = & ! a
            [1.918021108184618e-05_dp, 0.00011743496619441033_dp, 0.00038304286724531316_dp, &
             0.001042728254363479_dp, 0.002586697547420851_dp, 0.006005284015735613_dp, &
             0.0132238415003511_dp, 0.027866969228087193_dp, 0.05656974441752018_dp, &
             0.11118456754211066_dp, 0.21243440078169615_dp, 0.39588493368778044_dp, &
             0.7216727864412544_dp, 1.290687002879518_dp, 2.273908671258199_dp, &
             3.97937103189813_dp, 7.098438341837911_dp, &
             ! w
             5.085499126425964e-05_dp, 0.00015879189104924546_dp, 0.00040835568622275446_dp, &
             0.0009889473088433097_dp, 0.0022570984755315_dp, 0.004888731455877956_dp, &
             0.01013143228792217_dp, 0.020225156256024016_dp, 0.039096903340007934_dp, &
             0.07349025105641002_dp, 0.13478058532324966_dp, 0.24188623737314655_dp, &
             0.42605539338067017_dp, 0.7395353696295928_dp, 1.2754678823800256_dp, &
             2.2356474193399447_dp, 4.343345438395721_dp]

      CASE (450)

         aw(:) = & ! a
            [1.458933897784122e-05_dp, 9.139030473073127e-05_dp, 0.00030878602244267865_dp, &
             0.0008699113552462914_dp, 0.0022203856912609544_dp, 0.005275934475200526_dp, &
             0.011842849219186052_dp, 0.02536325103370956_dp, 0.05220450013744886_dp, &
             0.10384529109056181_dp, 0.20051790022964933_dp, 0.37719525869318016_dp, &
             0.693384842204357_dp, 1.2494531716280413_dp, 2.2161817777173987_dp, &
             3.9019002052844005_dp, 6.998451151508137_dp, &
             ! w
             3.887610761530127e-05_dp, 0.00012644811783661284_dp, 0.00034043738029018326_dp, &
             0.0008524591235363151_dp, 0.0019944061590717213_dp, 0.0044058236614755355_dp, &
             0.009281013741210436_dp, 0.01878586883941478_dp, 0.03675107494621722_dp, &
             0.06980604654338901_dp, 0.1292105276995719_dp, 0.2338027267855387_dp, &
             0.4148514548104739_dp, 0.7248105725372748_dp, 1.2572582238153398_dp, &
             2.214479692495519_dp, 4.319272791830595_dp]

      CASE (451)

         aw(:) = & ! a
            [1.094467766532379e-05_dp, 7.05492793489514e-05_dp, 0.00024826530528285906_dp, &
             0.0007257578826090639_dp, 0.0019082025868475256_dp, 0.0046429506569553_dp, &
             0.010625881647910675_dp, 0.023128160320095827_dp, 0.04826405446679087_dp, &
             0.0971559894122433_dp, 0.18956460617133714_dp, 0.35988820424996204_dp, &
             0.6670182563676718_dp, 1.210802132037608_dp, 2.1618127797467053_dp, &
             3.8286597689957436_dp, 6.903666187020532_dp, &
             ! w
             2.9352097161866914e-05_dp, 0.00010029392135425999_dp, 0.00028373169352337215_dp, &
             0.0007353067079803949_dp, 0.001764340847949028_dp, 0.003976196228625831_dp, &
             0.008514548590324024_dp, 0.017474274911499204_dp, 0.034592820280502694_dp, &
             0.06638783728179978_dp, 0.12400402849715236_dp, 0.2261967623795507_dp, &
             0.4042480651027011_dp, 0.7108065227642008_dp, 1.239874982587707_dp, &
             2.194229503181971_dp, 4.29624415000418_dp]

      CASE (452)

         aw(:) = & ! a
            [6.324325770733568e-06_dp, 4.3784561254680955e-05_dp, 0.00016816473585988095_dp, &
             0.0005282005147507511_dp, 0.0014671088196661216_dp, 0.0037257757029787344_dp, &
             0.008825379661917565_dp, 0.01976288365694673_dp, 0.04224170211896209_dp, &
             0.08679945016337094_dp, 0.1724141912175066_dp, 0.33252003315428064_dp, &
             0.6249614244473011_dp, 1.1486866961091953_dp, 2.0738849996148088_dp, &
             3.7096192517530233_dp, 6.749054263778715_dp, &
             ! w
             1.7253691427870995e-05_dp, 6.61075093598061e-05_dp, 0.00020587498387287116_dp, &
             0.0005681844806581525_dp, 0.001427042343733492_dp, 0.0033327392817497216_dp, &
             0.0073462825544027685_dp, 0.015445168213430206_dp, 0.031210765117142113_dp, &
             0.060970923123981585_dp, 0.11567098057508378_dp, 0.21391601027046922_dp, &
             0.38699520861360387_dp, 0.6878714833474024_dp, 1.2112635921527724_dp, &
             2.1608041389741195_dp, 4.2582328395774445_dp]

      CASE (453)

         aw(:) = & ! a
            [3.1670669624630847e-06_dp, 2.5052531441846564e-05_dp, 0.00010902841455310801_dp, &
             0.0003742726254346608_dp, 0.0011080238570622418_dp, 0.0029526032160513437_dp, &
             0.007264006197212855_dp, 0.01677531479403189_dp, 0.03678836441783677_dp, &
             0.0772609556461209_dp, 0.15638455439270008_dp, 0.3066103993953317_dp, &
             0.584698378696311_dp, 1.088644124244412_dp, 1.9882012310283597_dp, &
             3.5928725132260033_dp, 6.596725571953208_dp, &
             ! w
             8.965616478824352e-06_dp, 4.137395639487357e-05_dp, 0.00014500041419237566_dp, &
             0.0004304187360175022_dp, 0.0011384650973003435_dp, 0.0027661473380765607_dp, &
             0.006293153696944768_dp, 0.013579682026016221_dp, 0.028048615716789703_dp, &
             0.055831592359072896_dp, 0.10766278586866126_dp, 0.20197964422880343_dp, &
             0.3700592361637516_dp, 0.6651684395231704_dp, 1.1827595511959288_dp, &
             2.127381043276869_dp, 4.220222956712289_dp]

      CASE (454)

         aw(:) = & ! a
            [1.965911550315286e-06_dp, 1.770295804549473e-05_dp, 8.437297409462314e-05_dp, &
             0.0003066685457418877_dp, 0.0009440066551254706_dp, 0.002588657239420727_dp, &
             0.006511290198022752_dp, 0.01530672479228543_dp, 0.0340637495531545_dp, &
             0.07242905648873617_dp, 0.14816747455480803_dp, 0.29319128274260775_dp, &
             0.5636582621311574_dp, 1.057025981563586_dp, 1.9427898698613837_dp, &
             3.530684028828231_dp, 6.515289845676721_dp, &
             ! w
             5.808320991888156e-06_dp, 3.126204272475528e-05_dp, 0.0001181671116181515_dp, &
             0.0003668656543048002_dp, 0.001001065818698379_dp, 0.0024897630531041798_dp, &
             0.005769323981310001_dp, 0.01263665982819144_dp, 0.0264280618037184_dp, &
             0.05316647860380902_dp, 0.10346697694454568_dp, 0.1956689648535538_dp, &
             0.361034481345287_dp, 0.6529898473246921_dp, 1.167391014750996_dp, &
             2.1093070606847255_dp, 4.199667534273998_dp]

      CASE (455)

         aw(:) = & ! a
            [1.322039824529103e-06_dp, 1.3644660379054517e-05_dp, 7.009393117838189e-05_dp, &
             0.00026610080001424833_dp, 0.0008430526078221751_dp, 0.002360344948253793_dp, &
             0.006032017423532955_dp, 0.014360324623452917_dp, 0.03229034093158516_dp, &
             0.06925745438801997_dp, 0.14273483967194414_dp, 0.2842639156919321_dp, &
             0.5495851108359164_dp, 1.0357792776721013_dp, 1.9121561433509082_dp, &
             3.4886047381494176_dp, 6.4600675716736635_dp, &
             ! w
             4.114809371932191e-06_dp, 2.5478322550811068e-05_dp, 0.00010202607816647103_dp, &
             0.00032752443441371446_dp, 0.0009143026109553528_dp, 0.002312574577843141_dp, &
             0.0054294213552350526_dp, 0.012018640081376365_dp, 0.025357083262282858_dp, &
             0.05139248419554339_dp, 0.10065661073380844_dp, 0.19141889836816153_dp, &
             0.35492758163493465_dp, 0.6447156623336303_dp, 1.1569173598543177_dp, &
             2.0969675718938148_dp, 4.185633290543016_dp]

      CASE (456)

         aw(:) = & ! a
            [1.1414784913290507e-06_dp, 1.2479906043254122e-05_dp, 6.586792350915943e-05_dp, &
             0.0002538405276329722_dp, 0.0008120970203781402_dp, 0.0022895846593795665_dp, &
             0.005882241099735417_dp, 0.014062591248535634_dp, 0.03172936041406355_dp, &
             0.06824953475591365_dp, 0.14100154430186176_dp, 0.28140590790837133_dp, &
             0.5450664617927452_dp, 1.0289401016118418_dp, 1.9022745807980563_dp, &
             3.475008679695429_dp, 6.442203962408087_dp, &
             ! w
             3.6393993327764124e-06_dp, 2.377803001827817e-05_dp, 9.714146248334506e-05_dp, &
             0.00031542480855583033_dp, 0.0008873180020119566_dp, 0.0022569990672555566_dp, &
             0.005322094224988005_dp, 0.01182242228760336_dp, 0.02501548554271099_dp, &
             0.050824423584506936_dp, 0.09975361540313847_dp, 0.19004924595880676_dp, &
             0.3529544360619371_dp, 0.6420364207351131_dp, 1.1535202206350186_dp, &
             2.092961336457584_dp, 4.181076696726021_dp]

      CASE (457)

         aw(:) = & ! a
            [1.1242594032445634e-06_dp, 1.2367981585927119e-05_dp, 6.545818610240409e-05_dp, &
             0.00025264486136782104_dp, 0.0008090660491099191_dp, 0.002282635952329536_dp, &
             0.005867499650624025_dp, 0.01403323416656616_dp, 0.03167396391496785_dp, &
             0.06814987799660217_dp, 0.140829982868287_dp, 0.2811227618501116_dp, &
             0.5446184400971232_dp, 1.028261542994931_dp, 1.901293617264876_dp, &
             3.4736583783930577_dp, 6.440429281216567_dp, &
             ! w
             3.594037148536206e-06_dp, 2.3613463975539957e-05_dp, 9.666492767447006e-05_dp, &
             0.00031423914840777593_dp, 0.0008846656273099036_dp, 0.0022515238099725353_dp, &
             0.005311501090248518_dp, 0.01180302674525577_dp, 0.024981677330889934_dp, &
             0.050768141814753705_dp, 0.09966406660924938_dp, 0.18991331154444588_dp, &
             0.35275847212429345_dp, 0.6417701759163508_dp, 1.1531824876019705_dp, &
             2.0925629496356657_dp, 4.180623589040228_dp]

      CASE (458)

         aw(:) = & ! a
            [0.006504707620870862_dp, 0.03457638451151281_dp, 0.0863605588515674_dp, &
             0.16424368204284412_dp, 0.2720827762576999_dp, 0.4157314705178234_dp, &
             0.6037727276832092_dp, 0.8484615472103956_dp, 1.166857443526373_dp, &
             1.582174844949876_dp, 2.1255130141272733_dp, 2.8383150330853875_dp, &
             3.776184489691636_dp, 5.015317845923547_dp, 6.664555312407246_dp, &
             8.891550981317133_dp, 11.99335122869203_dp, 16.676470342449512_dp, &
             ! w
             0.016727416580251387_dp, 0.039632078965078775_dp, 0.06432780440458163_dp, &
             0.09207266697943958_dp, 0.12456890894406929_dp, 0.1641431837719012_dp, &
             0.21396298272289155_dp, 0.2782357700589099_dp, 0.36239707430805856_dp, &
             0.47338134062580534_dp, 0.6201412070315351_dp, 0.8146289484700561_dp, &
             1.073624694183775_dp, 1.4223973563857537_dp, 1.9030598837282355_dp, &
             2.5972903740046815_dp, 3.7067955624904116_dp, 6.030987538475906_dp]

      CASE (459)

         aw(:) = & ! a
            [0.005454939230439086_dp, 0.029022386751768166_dp, 0.07261074660919156_dp, &
             0.13845019379721252_dp, 0.23018463741887507_dp, 0.3534092543271198_dp, &
             0.5164149110038168_dp, 0.731130518398276_dp, 1.0142408538670358_dp, &
             1.3885292100345954_dp, 1.8846365428304332_dp, 2.54359362391212_dp, &
             3.4207312377096155_dp, 4.592187425556606_dp, 6.166964644487724_dp, &
             8.312948853281073_dp, 11.326920786084592_dp, 15.912264062176604_dp, &
             ! w
             0.01403076052185356_dp, 0.03330310464763135_dp, 0.05423910675979884_dp, &
             0.07803827495869796_dp, 0.10635069588915873_dp, 0.14146455058864316_dp, &
             0.1865163683259881_dp, 0.24567372242915428_dp, 0.32431567595192745_dp, &
             0.4293269788840337_dp, 0.5696635237812344_dp, 0.7573699308590284_dp, &
             1.0094100056379167_dp, 1.351286818847722_dp, 1.825296248222896_dp, &
             2.51301336523117_dp, 3.615041310021613_dp, 5.924599133293403_dp]

      CASE (460)

         aw(:) = & ! a
            [0.004719198693065434_dp, 0.025127630757328167_dp, 0.06295892659890262_dp, &
             0.12031784280556994_dp, 0.20067504660898328_dp, 0.309411065083213_dp, &
             0.4545645972722522_dp, 0.6477672584542331_dp, 0.9053458892365164_dp, &
             1.249664455458483_dp, 1.710918733883249_dp, 2.329738102077569_dp, &
             3.1611777285324156_dp, 4.281292057468559_dp, 5.799205871677062_dp, &
             7.883025436388123_dp, 10.829418604027625_dp, 15.339510264532255_dp, &
             ! w
             0.012140534751940763_dp, 0.028861839393117896_dp, 0.04714535342349926_dp, &
             0.0681419618356386_dp, 0.09345666238084763_dp, 0.125339489076594_dp, &
             0.1668879549209818_dp, 0.2222166633555844_dp, 0.2966388361651315_dp, &
             0.39698882246477685_dp, 0.532227240148291_dp, 0.7144836697800593_dp, &
             0.9608859859076535_dp, 1.2971489546989525_dp, 1.765749845406465_dp, &
             2.4482320396481305_dp, 3.544401097573219_dp, 5.842786282198943_dp]

      CASE (461)

         aw(:) = & ! a
            [0.004172227365416325_dp, 0.022230729039644317_dp, 0.05577357985498636_dp, &
             0.10680180401545937_dp, 0.1786412823496513_dp, 0.2764899558231186_dp, &
             0.40816545243668184_dp, 0.5850289259794452_dp, 0.8230733480317899_dp, &
             1.1442695863965273_dp, 1.578397776516414_dp, 2.1657119062532786_dp, &
             2.961003018513874_dp, 4.040231570611905_dp, 5.512616711937986_dp, &
             7.546467437808507_dp, 10.438420006766224_dp, 14.887879452056895_dp, &
             ! w
             0.010735123281046864_dp, 0.02555645084196436_dp, 0.04185658199776483_dp, &
             0.06074514237930913_dp, 0.08378759015379075_dp, 0.11319722246504531_dp, &
             0.15202936990628974_dp, 0.2043411997280821_dp, 0.2753797326933137_dp, &
             0.3719329029533199_dp, 0.5029671890258762_dp, 0.6806881808303616_dp, &
             0.9223683599982286_dp, 1.25391179651718_dp, 1.7179680619759234_dp, &
             2.3960872496711834_dp, 3.48746813284328_dp, 5.7769132915013195_dp]

      CASE (462)

         aw(:) = & ! a
            [0.0037481479791149834_dp, 0.01998370529062772_dp, 0.05019572951738094_dp, &
             0.09629745946207843_dp, 0.16149116096897648_dp, 0.2508165176467207_dp, &
             0.37189480031827843_dp, 0.535840488647031_dp, 0.7583376619109063_dp, &
             1.0609933975927763_dp, 1.4732045849654014_dp, 2.0348781672529332_dp, &
             2.80055616694921_dp, 3.8461009998400413_dp, 5.280805511730411_dp, &
             7.273163367832301_dp, 10.119825359903327_dp, 14.518835947441595_dp, &
             ! w
             0.009645363471445978_dp, 0.022991191495488852_dp, 0.037745580186778954_dp, &
             0.05498251401259031_dp, 0.07623233046456797_dp, 0.10367334795226314_dp, &
             0.14031795924770327_dp, 0.19016545993566092_dp, 0.25839972669382333_dp, &
             0.35176706596839663_dp, 0.47924011713604087_dp, 0.6530917220917539_dp, &
             0.8907218049245282_dp, 1.2182039602924128_dp, 1.678349191099112_dp, &
             2.352736388659292_dp, 3.440085680309329_dp, 5.722136250605784_dp]

      CASE (463)

         aw(:) = & ! a
            [0.0034088324466304944_dp, 0.018185090875107682_dp, 0.045727748399452345_dp, &
             0.0878744053671484_dp, 0.1477199920402149_dp, 0.23016494655539427_dp, &
             0.34265422432112574_dp, 0.49607641643219097_dp, 0.7058303459086763_dp, &
             0.9931876484911322_dp, 1.3871927775883186_dp, 1.927432411321234_dp, &
             2.6682148354966255_dp, 3.685303441973784_dp, 5.088049018579727_dp, &
             7.045113179204027_dp, 9.853188552772256_dp, 14.209212193237015_dp, &
             ! w
             0.008773340443438755_dp, 0.02093683847149185_dp, 0.03444861897423562_dp, &
             0.05035142585071726_dp, 0.0701440561722791_dp, 0.09597166675239711_dp, &
             0.13080419499020232_dp, 0.17858454783419062_dp, 0.24443766561939323_dp, &
             0.33507267593781265_dp, 0.4594680837150753_dp, 0.6299560570532854_dp, &
             0.8640493534648978_dp, 1.1879741820719463_dp, 1.6446922479162214_dp, &
             2.31582446184048_dp, 3.3997031182761037_dp, 5.6754851807026565_dp]

      CASE (464)

         aw(:) = & ! a
            [0.0031306056830560135_dp, 0.016709748015357007_dp, 0.042060375264030045_dp, &
             0.08095396529993411_dp, 0.13639096785774668_dp, 0.21314779812291593_dp, &
             0.3185096464168493_dp, 0.46315734143844034_dp, 0.6622260349962985_dp, &
             0.9366779619610529_dp, 1.3152330549324225_dp, 1.8371818862508218_dp, &
             2.5566133546364127_dp, 3.5491924578909004_dp, 4.924315664937931_dp, &
             6.850797628249299_dp, 9.625389361929418_dp, 13.944106543599815_dp, &
             ! w
             0.008058250952104717_dp, 0.01925096094766146_dp, 0.0317394427938591_dp, &
             0.046538725017352435_dp, 0.06511901428038042_dp, 0.08959406553832734_dp, &
             0.12289248368821457_dp, 0.16890315352568652_dp, 0.23269648792897377_dp, &
             0.3209482711730135_dp, 0.44264224272054753_dp, 0.610162954106963_dp, &
             0.8411236798163042_dp, 1.1618888828134089_dp, 1.6155610054874723_dp, &
             2.283811039826218_dp, 3.3646504591932693_dp, 5.635017031535249_dp]

      CASE (465)

         aw(:) = & ! a
            [0.0017784976328254598_dp, 0.00953050331705429_dp, 0.0241715763670107_dp, &
             0.047078713382615565_dp, 0.08067449545094924_dp, 0.12894431670112244_dp, &
             0.1980991783943776_dp, 0.2973741996928436_dp, 0.4400631372091785_dp, &
             0.6449848392880045_dp, 0.9386073149270318_dp, 1.3581198602013644_dp, &
             1.9559668797684324_dp, 2.806943867096501_dp, 4.020578184661381_dp, &
             5.766696293860253_dp, 8.342817860954147_dp, 12.440295670973242_dp, &
             ! w
             0.004582036896370416_dp, 0.01103391709664276_dp, 0.018471916277182893_dp, &
             0.027737429369125297_dp, 0.04010723661606406_dp, 0.0574545178903398_dp, &
             0.08237765899599424_dp, 0.11836408860959646_dp, 0.17011549140639595_dp, &
             0.24408915011169383_dp, 0.34928075268957354_dp, 0.4983722612841169_dp, &
             0.7095962619273725_dp, 1.010234642279125_dp, 1.4444207813624754_dp, &
             2.094410418461798_dp, 3.156654855251119_dp, 5.395389620425401_dp]

      CASE (466)

         aw(:) = & ! a
            [0.0012731020932926379_dp, 0.006840889911889719_dp, 0.017441871151260967_dp, &
             0.03425676267104925_dp, 0.059409560309849466_dp, 0.09645246374479774_dp, &
             0.15097458736251926_dp, 0.23135661755667683_dp, 0.34981080772217094_dp, &
             0.5239021241748318_dp, 0.7787609548262905_dp, 1.1502794202181457_dp, &
             1.6898140333634362_dp, 2.4714863686327306_dp, 3.604749420902687_dp, &
             5.259977275676536_dp, 7.735354575200575_dp, 11.72042732080812_dp, &
             ! w
             0.0032819955090503555_dp, 0.007946879349381084_dp, 0.013446306697748859_dp, &
             0.020529284744824725_dp, 0.030358207775712336_dp, 0.04464691816132566_dp, &
             0.06577726530888198_dp, 0.09699728556123041_dp, 0.14280235347746628_dp, &
             0.20951654252840063_dp, 0.3061070498052226_dp, 0.4453729615003168_dp, &
             0.6458550254409235_dp, 0.9353531013878362_dp, 1.358657352007492_dp, &
             1.9985335334287477_dp, 3.0509031139521676_dp, 5.2738872947947355_dp]

      CASE (467)

         aw(:) = & ! a
            [0.001003007640618_dp, 0.005401192853243206_dp, 0.013829006030721161_dp, &
             0.027343138381717924_dp, 0.04787398783803675_dp, 0.07868305861976885_dp, &
             0.12493283084954603_dp, 0.19441735623604497_dp, 0.2986096720559634_dp, &
             0.4542136973287632_dp, 0.6854260121554199_dp, 1.0272086576277664_dp, &
             1.5301066611493623_dp, 2.2676993471981066_dp, 3.34931803735087_dp, &
             4.945688630210126_dp, 7.355525423831127_dp, 11.267417319265014_dp, &
             ! w
             0.0025869658738650997_dp, 0.006291196597285421_dp, 0.010735193719682509_dp, &
             0.016607063768514875_dp, 0.02498881534373861_dp, 0.037477989189976496_dp, &
             0.0563035562499745_dp, 0.08455225510195966_dp, 0.12657933799322968_dp, &
             0.18860809792637548_dp, 0.279565535852876_dp, 0.4123050051435338_dp, &
             0.6055566517564234_dp, 0.8874705225249772_dp, 1.3033133509688122_dp, &
             1.9362701532184283_dp, 2.9820300811488276_dp, 5.194874374428528_dp]

      CASE (468)

         aw(:) = & ! a
            [0.0008331309433943816_dp, 0.004494533393081155_dp, 0.011548438889181107_dp, &
             0.02296365335753164_dp, 0.04053062382391568_dp, 0.06729580026343036_dp, &
             0.10810275820315267_dp, 0.17030803184533577_dp, 0.26483404269108474_dp, &
             0.4077390338229544_dp, 0.622509561219692_dp, 0.9433866330993251_dp, &
             1.4202692025580552_dp, 2.1262840620169734_dp, 3.1706302181916914_dp, &
             4.7242816837238015_dp, 7.086385390567176_dp, 10.944946439250204_dp, &
             ! w
             0.002149695374373156_dp, 0.005246886200683311_dp, 0.009017223092835954_dp, &
             0.014104263829788848_dp, 0.021528561526898454_dp, 0.03279756255363238_dp, &
             0.05002531062141126_dp, 0.07617992934245178_dp, 0.11551095755702746_dp, &
             0.17415921094997922_dp, 0.26100924839686485_dp, 0.38894044098202907_dp, &
             0.5768126546101896_dp, 0.8530354319361633_dp, 1.26324693268147_dp, &
             1.890984014251146_dp, 2.9318282815396244_dp, 5.137338630737624_dp]

      CASE (469)

         aw(:) = & ! a
            [0.0007156743708438212_dp, 0.003866973046724055_dp, 0.009966773656909301_dp, &
             0.019917211061448056_dp, 0.03540081508361522_dp, 0.05929543332843836_dp, &
             0.09619333707801735_dp, 0.15310711854368658_dp, 0.24052609212096823_dp, &
             0.3739971151430409_dp, 0.5764378796819639_dp, 0.8815030388162307_dp, &
             1.3385557188415094_dp, 2.0203347643968717_dp, 3.03590765912303_dp, &
             4.556433918219239_dp, 6.8814234769517055_dp, 10.698495570575057_dp, &
             ! w
             0.0018472812466389012_dp, 0.004523095116174931_dp, 0.007821851870583206_dp, &
             0.012352432321382304_dp, 0.019085978253845236_dp, 0.029457307511689484_dp, &
             0.04549005278246955_dp, 0.07005984566079591_dp, 0.10733141410643547_dp, &
             0.16337536445860176_dp, 0.24703471719863157_dp, 0.37120018459651805_dp, &
             0.554826538805612_dp, 0.8265266831834693_dp, 1.232241560519569_dp, &
             1.8558099395439571_dp, 2.8927683242146855_dp, 5.092604852951585_dp]

      CASE (470)

         aw(:) = & ! a
            [0.0006292469835733137_dp, 0.003404765182263968_dp, 0.008799834740885864_dp, &
             0.017663661343047414_dp, 0.031591910790609926_dp, 0.053325027865730824_dp, &
             0.0872499733034381_dp, 0.1400989014371246_dp, 0.22200741905845026_dp, &
             0.3481020164414586_dp, 0.5408282237151643_dp, 0.8333481626537103_dp, &
             1.2745678967141136_dp, 1.9368869444029295_dp, 2.929245971365592_dp, &
             4.42294883364497_dp, 6.71781677985601_dp, 10.50120072187859_dp, &
             ! w
             0.0016247092432591461_dp, 0.003989399431325142_dp, 0.006937405507990823_dp, &
             0.011049473564568906_dp, 0.017255655639838212_dp, 0.02693051891930886_dp, &
             0.04202413865776385_dp, 0.06533700289003663_dp, 0.10096305774931143_dp, &
             0.15491167253317023_dp, 0.23598628401178987_dp, 0.3570806030334209_dp, &
             0.537221991259609_dp, 0.8051888646508266_dp, 1.2071767417464814_dp, &
             1.8272882686574476_dp, 2.861049495849007_dp, 5.056298944057487_dp]

      CASE (471)

         aw(:) = & ! a
            [0.0005627823349452919_dp, 0.0030490190788550874_dp, 0.00790029086110356_dp, &
             0.015922394599248355_dp, 0.028638903303737875_dp, 0.048675131703015205_dp, &
             0.08024582715328522_dp, 0.12984825884578247_dp, 0.20732114251968206_dp, &
             0.3274359941701851_dp, 0.5122363225944793_dp, 0.7944607143227888_dp, &
             1.2226172507136812_dp, 1.8688040470778537_dp, 2.8418409276923855_dp, &
             4.313147383547011_dp, 6.582816326266341_dp, 10.338005655836904_dp, &
             ! w
             0.0014535131106379318_dp, 0.003578211128353728_dp, 0.006253890790180701_dp, &
             0.01003778483872021_dp, 0.015824937514605023_dp, 0.02493883699939866_dp, &
             0.03926815195450443_dp, 0.06155046121917452_dp, 0.09581900405954127_dp, &
             0.14802882375626922_dp, 0.226946010516923_dp, 0.34546224809925985_dp, &
             0.5226622305512622_dp, 0.7874628303833764_dp, 1.1862785054223426_dp, &
             1.8034459541421743_dp, 2.834501267371012_dp, 5.0259251227466635_dp]

      CASE (472)

         aw(:) = & ! a
            [0.0005099568208449972_dp, 0.002766060793701837_dp, 0.0071837947293005204_dp, &
             0.014532473440193957_dp, 0.026274445734568615_dp, 0.04493651798185145_dp, &
             0.07458604801491614_dp, 0.12151947948149408_dp, 0.1953210695123804_dp, &
             0.3104564089196821_dp, 0.48862004258264824_dp, 0.7621798194464763_dp, &
             1.1792917816666157_dp, 1.811783037470562_dp, 2.768358759293376_dp, &
             4.220533150129275_dp, 6.4686395215857635_dp, 10.199693737592291_dp, &
             ! w
             0.0013174240913447924_dp, 0.0032508514395187126_dp, 0.005708210041233193_dp, &
             0.009226639366647683_dp, 0.014670806696528513_dp, 0.023320152255546962_dp, &
             0.03701103207597337_dp, 0.058427146196618984_dp, 0.09154862030420802_dp, &
             0.14228168423189544_dp, 0.21935730563808947_dp, 0.3356619957096291_dp, &
             0.5103268370972778_dp, 0.77238695806063_dp, 1.1684483932541831_dp, &
             1.7830579341042165_dp, 2.811774344897853_dp, 4.999932993106821_dp]

      CASE (473)

         aw(:) = & ! a
            [0.0004668841916966001_dp, 0.0025351831509706916_dp, 0.006598421692551525_dp, &
             0.013394663714263032_dp, 0.02433332568028017_dp, 0.04185553599376796_dp, &
             0.0699004840051102_dp, 0.11459008560534774_dp, 0.18528689359114475_dp, &
             0.29618860170128614_dp, 0.4686822380294337_dp, 0.734806567718747_dp, &
             1.1424023311783487_dp, 1.7630505379545083_dp, 2.7053476877215945_dp, &
             4.140886916302708_dp, 6.370216716705846_dp, 10.080246883158214_dp, &
             ! w
             0.001206442622027735_dp, 0.0029835180690567413_dp, 0.005261449937462656_dp, &
             0.00855990693672605_dp, 0.013716816741912066_dp, 0.021973107576248586_dp, &
             0.03511983495236686_dp, 0.05579372725380304_dp, 0.08792773068803054_dp, &
             0.13738377236828653_dp, 0.21285979561082896_dp, 0.32723512527144366_dp, &
             0.49967909195525034_dp, 0.7593294858673185_dp, 1.1529622794480074_dp, &
             1.7653147148395656_dp, 2.7919762112360456_dp, 4.977297624597095_dp]

      CASE (474)

         aw(:) = & ! a
            [0.000260914461772336_dp, 0.0014284110053859973_dp, 0.003779313366150407_dp, &
             0.007875534265517174_dp, 0.014818727120990572_dp, 0.02654437101786918_dp, &
             0.04623735420014881_dp, 0.07899162477486178_dp, 0.1328484337557623_dp, &
             0.22037931923229523_dp, 0.3610645276411059_dp, 0.5848529330794866_dp, &
             0.9375236694343315_dp, 1.4889766904451114_dp, 2.3469686778446492_dp, &
             3.6834788445658697_dp, 5.800450143499236_dp, 9.3845111360647_dp, &
             ! w
             0.0006754355558846693_dp, 0.0016981110123511526_dp, 0.003093562039844899_dp, &
             0.0052777001406530315_dp, 0.008924677726232818_dp, 0.015046730066029211_dp, &
             0.025171297216547893_dp, 0.04165165016169422_dp, 0.06811847034128733_dp, &
             0.11013206715594186_dp, 0.17614288778329085_dp, 0.2789306706204916_dp, &
             0.4378452602827844_dp, 0.6826254815697036_dp, 1.0611210798041206_dp, &
             1.6593600203583403_dp, 2.6733428837255038_dp, 4.841796324444054_dp]

      CASE (475)

         aw(:) = & ! a
            [0.00018551321377360634_dp, 0.0010215028674021077_dp, 0.0027344893872422236_dp, &
             0.0058038700988552044_dp, 0.011181048177484084_dp, 0.020551830095233446_dp, &
             0.03673043057862141_dp, 0.06430201414145639_dp, 0.11064025372147042_dp, &
             0.1874733094281667_dp, 0.31326429093244756_dp, 0.5168126983136785_dp, &
             0.8427221509500933_dp, 1.3598834122689585_dp, 2.1754818299235206_dp, &
             3.4616215444359195_dp, 5.5210242574181025_dp, 9.040418361508078_dp, &
             ! w
             0.00048085270575301206_dp, 0.0012230540357134345_dp, 0.0022794773615028817_dp, &
             0.00401365797781974_dp, 0.007015403763875897_dp, 0.012184761187942284_dp, &
             0.020920071473765355_dp, 0.03542655912789011_dp, 0.05916587370855765_dp, &
             0.09751885164172235_dp, 0.1587743800332417_dp, 0.2556200593738798_dp, &
             0.40746039857466365_dp, 0.6443266992963216_dp, 1.0146526822324917_dp, &
             1.6052318670779617_dp, 2.612440353907917_dp, 4.772316603465554_dp]

      CASE (476)

         aw(:) = & ! a
            [0.00014562382710294662_dp, 0.0008055881529796759_dp, 0.0021769113040709318_dp, &
             0.0046881273958434425_dp, 0.009196001236600226_dp, 0.017228905560492613_dp, &
             0.03136764944560351_dp, 0.05587429246023262_dp, 0.09769241006638396_dp, &
             0.16799814339082067_dp, 0.28457797728806533_dp, 0.4754535138655539_dp, &
             0.7844166640229894_dp, 1.279641798278453_dp, 2.0678834725616793_dp, &
             3.3212938447939195_dp, 5.3431231415756_dp, 8.820257814253507_dp, &
             ! w
             0.0003778416599558625_dp, 0.0009700552711586841_dp, 0.0018409801051395853_dp, &
             0.0033204021060857123_dp, 0.005944000305659858_dp, 0.010541731118507081_dp, &
             0.01842984272446517_dp, 0.031715495560804136_dp, 0.05374476719644769_dp, &
             0.089772198289391_dp, 0.14796801202917811_dp, 0.24094326281169415_dp, &
             0.3881219089533589_dp, 0.6197175136938446_dp, 0.9845552848798075_dp, &
             1.5699678410487687_dp, 2.5726424686871687_dp, 4.726941044835544_dp]

      CASE (477)

         aw(:) = & ! a
            [0.00012069306501636694_dp, 0.0006703183122791028_dp, 0.0018259870924344271_dp, &
             0.003980667589060772_dp, 0.0079240714937168_dp, 0.01507315081217762_dp, &
             0.0278434453982068_dp, 0.05026645010562097_dp, 0.0889754985015726_dp, &
             0.15474407546557292_dp, 0.26485954501264436_dp, 0.4467628386148967_dp, &
             0.743631633383162_dp, 1.2230881055827414_dp, 1.9915418966860663_dp, &
             3.2211612799836016_dp, 5.215590858427921_dp, 8.661879729838459_dp, &
             ! w
             0.0003134246142158033_dp, 0.0008110913445565603_dp, 0.001562938469288158_dp, &
             0.0028744264048654856_dp, 0.005242599992383257_dp, 0.009448127503548561_dp, &
             0.0167483721901341_dp, 0.029178210827365967_dp, 0.049996895682636794_dp, &
             0.08436235623763434_dp, 0.14035158628733707_dp, 0.23051125331945824_dp, &
             0.374270678501655_dp, 0.6019710721015192_dp, 0.962727552491358_dp, &
             1.5442858258917591_dp, 2.54359484716486_dp, 4.693835053963997_dp]

      CASE (478)

         aw(:) = & ! a
            [0.00010353081360477903_dp, 0.000577010708614185_dp, 0.0015829797899359808_dp, &
             0.003487643090278658_dp, 0.00702981637575661_dp, 0.013542012955254482_dp, &
             0.02531434596654306_dp, 0.04620212975837872_dp, 0.08259960522442154_dp, &
             0.14496728229470254_dp, 0.2502012538239559_dp, 0.42528316526304255_dp, &
             0.7128998743123581_dp, 1.1802262631739215_dp, 1.9333849194731854_dp, &
             3.1445446516847144_dp, 5.117661524304808_dp, 8.539939250261368_dp, &
             ! w
             0.0002690595993960665_dp, 0.0007011712205890843_dp, 0.0013691799768125582_dp, &
             0.0025598301686818336_dp, 0.004740768169827436_dp, 0.0086554545194189_dp, &
             0.015515970318803389_dp, 0.02730051705055568_dp, 0.047199373682666385_dp, &
             0.08029272329388433_dp, 0.13458110045081412_dp, 0.22255593727666947_dp, &
             0.36364527296104165_dp, 0.5882861097353751_dp, 0.9458213024215231_dp, &
             1.5243296194546507_dp, 2.5209846078020965_dp, 4.6680728012172406_dp]

      CASE (479)

         aw(:) = & ! a
            [9.094343130849975e-05_dp, 0.0005084550515824451_dp, 0.0014038244792441586_dp, &
             0.0031221229770495226_dp, 0.006361736151585623_dp, 0.012388206466221354_dp, &
             0.02339197730376753_dp, 0.04308751795427685_dp, 0.07767658914909154_dp, &
             0.13736600522163228_dp, 0.2387325306496574_dp, 0.40838029574768436_dp, &
             0.6885894480169676_dp, 1.1461602509232325_dp, 1.8869698702994993_dp, &
             3.0831793456937975_dp, 5.039000247922106_dp, 8.44178006007088_dp, &
             ! w
             0.00023650765020381912_dp, 0.0006202374982483119_dp, 0.0012255391766448991_dp, &
             0.002324124178832601_dp, 0.004360281588623125_dp, 0.008048021240346297_dp, &
             0.014562986383659132_dp, 0.025837103982347814_dp, 0.0450037848576161_dp, &
             0.07707846816747213_dp, 0.12999708938848178_dp, 0.2162028653520236_dp, &
             0.35511913345417484_dp, 0.5772581722343985_dp, 0.9321489117777328_dp, &
             1.508148002041756_dp, 2.5026251803844644_dp, 4.647158214149157_dp]

      CASE (480)

         aw(:) = & ! a
            [8.128780459273251e-05_dp, 0.00045578417617948527_dp, 0.0012657578123163504_dp, &
             0.0028390119726776426_dp, 0.005840758669466495_dp, 0.01148166594744145_dp, &
             0.021870335147125514_dp, 0.04060496584282268_dp, 0.07372748394495345_dp, &
             0.13123282773857478_dp, 0.22942956229848835_dp, 0.394602877306536_dp, &
             0.6686870205875045_dp, 1.1181608634571265_dp, 1.8486875233181934_dp, &
             3.032415620913765_dp, 4.973772138903806_dp, 8.360237513682502_dp, &
             ! w
             0.0002115284740783797_dp, 0.0005579383421879089_dp, 0.0011142909499591146_dp, &
             0.002139849008725855_dp, 0.004059756005062852_dp, 0.007563907832157933_dp, &
             0.013797676055523244_dp, 0.024654104457232505_dp, 0.04321845009911772_dp, &
             0.07445088564571238_dp, 0.12623156194056043_dp, 0.21096100031431056_dp, &
             0.34805600038710355_dp, 0.5680899756605817_dp, 0.920748230015768_dp, &
             1.494625048261868_dp, 2.487264046018687_dp, 4.629662033992615_dp]

      CASE (481)

         aw(:) = & ! a
            [7.362902380322699e-05_dp, 0.0004139464765750486_dp, 0.0011557812297434123_dp, &
             0.0026124632635369602_dp, 0.0054213163235300055_dp, 0.010746931198410465_dp, &
             0.02062903374098843_dp, 0.03856750896122895_dp, 0.07046844263299985_dp, &
             0.1261458233762945_dp, 0.22167806260075487_dp, 0.38307528434830906_dp, &
             0.6519717385575523_dp, 1.094565508121492_dp, 1.816330140277326_dp, &
             2.9893991734035_dp, 4.918384968674218_dp, 8.290890939893337_dp, &
             ! w
             0.00019170870711407288_dp, 0.0005083673996572885_dp, 0.0010252753388815708_dp, &
             0.001991147955096542_dp, 0.0038150596475737433_dp, 0.007166653733954372_dp, &
             0.013165550359203417_dp, 0.023671412268265173_dp, 0.041727894784833346_dp, &
             0.07224710204648896_dp, 0.12306019974849018_dp, 0.20652945524229882_dp, &
             0.3420641412628419_dp, 0.5602885647626088_dp, 0.9110222459597854_dp, &
             1.48306650559867_dp, 2.4741208992697565_dp, 4.614694078252486_dp]

      CASE (482)

         aw(:) = & ! a
            [6.739449324435924e-05_dp, 0.00037984457242887693_dp, 0.0010659079537327376_dp, &
             0.002426542068960052_dp, 0.0050751785351652095_dp, 0.01013697193763941_dp, &
             0.01959256624028302_dp, 0.03685714980164952_dp, 0.06771926281964358_dp, &
             0.12183564859596094_dp, 0.21508388041400503_dp, 0.37323301422066457_dp, &
             0.6376531033583206_dp, 1.0742933968444754_dp, 1.788457502038564_dp, &
             2.952262375077832_dp, 4.870482497534054_dp, 8.230835304724469_dp, &
             ! w
             0.00017556987663771791_dp, 0.00046789829255630005_dp, 0.0009522284541816575_dp, &
             0.001868179296820573_dp, 0.003611085140121934_dp, 0.006833240477242143_dp, &
             0.012631955334979236_dp, 0.022837752985687437_dp, 0.04045778008255227_dp, &
             0.07036171339893307_dp, 0.12033713046284121_dp, 0.20271168814760507_dp, &
             0.33688662391872987_dp, 0.5535294427041705_dp, 0.9025767816825688_dp, &
             1.4730129882137049_dp, 2.462678834399958_dp, 4.601664805063239_dp]

      CASE (483)

         aw(:) = & ! a
            [3.770972671447743e-05_dp, 0.00021671815823933924_dp, 0.0006319647958778312_dp, &
             0.0015150185101379097_dp, 0.0033448466783742893_dp, 0.007025124585709654_dp, &
             0.014201414935093517_dp, 0.027801329556036924_dp, 0.052926656904140085_dp, &
             0.09830251130329612_dp, 0.17860015065735232_dp, 0.3181200064054065_dp, &
             0.5565968916143585_dp, 0.9584083064077357_dp, 1.6277447068619073_dp, &
             2.736552172466405_dp, 4.590583863831329_dp, 7.87837440091346_dp, &
             ! w
             9.864614157749192e-05_dp, 0.0002732211433595114_dp, 0.0005941975577521344_dp, &
             0.0012489573415471545_dp, 0.002556203182249123_dp, 0.005069908308872515_dp, &
             0.00975621380152378_dp, 0.018270493030267572_dp, 0.03339675488588097_dp, &
             0.059740515679277045_dp, 0.10481090900822707_dp, 0.18070308280191333_dp, &
             0.306740164242035_dp, 0.513823817457257_dp, 0.852592911322043_dp, &
             1.4131782077857424_dp, 2.39437286369401_dp, 4.523908764999524_dp]

      CASE (484)

         aw(:) = & ! a
            [2.6892519554907363e-05_dp, 0.0001567937858852912_dp, 0.00046989399004324_dp, &
             0.0011654522038541332_dp, 0.002659895069561157_dp, 0.005753840073969323_dp, &
             0.011934211172250079_dp, 0.02389280033840905_dp, 0.04639252185719773_dp, &
             0.08769012794026224_dp, 0.16183935850207254_dp, 0.2923748366935609_dp, &
             0.5181611748116954_dp, 0.9027178845025317_dp, 1.5496007583408882_dp, &
             2.6306172996201584_dp, 4.4520231849372305_dp, 7.7028603230062735_dp, &
             ! w
             7.05638795782659e-05_dp, 0.0002010028679147231_dp, 0.0004569474254904519_dp, &
             0.00100093647179562_dp, 0.002116528445009556_dp, 0.00431084332567352_dp, &
             0.008484575895053869_dp, 0.016203457881559215_dp, 0.030134877504812176_dp, &
             0.05474301588738865_dp, 0.09738330010494875_dp, 0.1700150284458082_dp, &
             0.2919005680926316_dp, 0.49404330049838874_dp, 0.8274397076545656_dp, &
             1.382839379424492_dp, 2.3595954111938178_dp, 4.484334415134187_dp]

      CASE (485)

         aw(:) = & ! a
            [2.117764284060119e-05_dp, 0.00012495595709202876_dp, 0.00038274936178464845_dp, &
             0.000973991658367676_dp, 0.0022768841713981217_dp, 0.00502884426710744_dp, &
             0.01061831718959387_dp, 0.021588822141837025_dp, 0.04248772649919_dp, &
             0.08127067048807829_dp, 0.1515902772342063_dp, 0.2764785036017604_dp, &
             0.4942222305733775_dp, 0.8677632859471236_dp, 1.5002201240187492_dp, &
             2.5632899998356247_dp, 4.3635548020944075_dp, 7.590418907169732_dp, &
             ! w
             5.570901072452278e-05_dp, 0.0001623667699557508_dp, 0.00038178255643626983_dp, &
             0.0008611922014131465_dp, 0.0018628123283926767_dp, 0.003864421172997219_dp, &
             0.007724785323416311_dp, 0.014951470752811016_dp, 0.02813530637477198_dp, &
             0.05164647162933681_dp, 0.0927364294632549_dp, 0.16326990553539597_dp, &
             0.2824618316106025_dp, 0.4813744803843905_dp, 0.8112354873409041_dp, &
             1.3632083348029826_dp, 2.337037609569253_dp, 4.458669560744956_dp]

      CASE (486)

         aw(:) = & ! a
            [1.7607027510129746e-05_dp, 0.00010497463258634355_dp, 0.0003275240571061572_dp, &
             0.0008508891384294316_dp, 0.0020267594369468207_dp, 0.00454854527962152_dp, &
             0.009735483724482805_dp, 0.020025950938082987_dp, 0.03981323330404025_dp, &
             0.07683612602150897_dp, 0.14445632795349211_dp, 0.2653385950247986_dp, &
             0.4773444815371746_dp, 0.8429864668461382_dp, 1.465052941517388_dp, &
             2.5151506872652627_dp, 4.30009786276047_dp, 7.509578251764822_dp, &
             ! w
             4.6418688781564724e-05_dp, 0.00013798379756057278_dp, 0.0003334522876238467_dp, &
             0.0007694194914053827_dp, 0.0016933362995822042_dp, 0.003562194356292001_dp, &
             0.007204639023093123_dp, 0.014086099235944071_dp, 0.026741496764881377_dp, &
             0.04947175447035527_dp, 0.0894508734055345_dp, 0.1584717931748057_dp, &
             0.2757109740714004_dp, 0.4722696710372406_dp, 0.7995424678739795_dp, &
             1.34899902892753_dp, 2.320682074663291_dp, 4.44006317705371_dp]

      CASE (487)

         aw(:) = & ! a
            [1.3345094685759858e-05_dp, 8.100133456933608e-05_dp, 0.00026050551878049904_dp, &
             0.0006990271202941324_dp, 0.0017129267268830544_dp, 0.003936641186117154_dp, &
             0.008595728011419668_dp, 0.017984913280872282_dp, 0.03628522800112553_dp, &
             0.07093447544172429_dp, 0.1348875922544271_dp, 0.25029216032872337_dp, &
             0.4544059616545287_dp, 0.8091261466532933_dp, 1.416760821430585_dp, &
             2.448774725138738_dp, 4.212315572771937_dp, 7.39748146374_dp, &
             ! w
             3.53174020538624e-05_dp, 0.00010853921152648619_dp, 0.0002738195210148376_dp, &
             0.0006535800730987856_dp, 0.0014755921767249933_dp, 0.003168438229454705_dp, &
             0.006519064629723313_dp, 0.01293407952215318_dp, 0.02486972094779215_dp, &
             0.046528561218468496_dp, 0.08497336062732552_dp, 0.1518920884205169_dp, &
             0.26640150356795944_dp, 0.4596518597177716_dp, 0.7832699688296861_dp, &
             1.3291621588649858_dp, 2.297808666622791_dp, 4.414044285275878_dp]

      CASE (488)

         aw(:) = & ! a
            [9.967611585535554e-06_dp, 6.186929142075591e-05_dp, 0.00020617003621056866_dp, &
             0.0005732111078902096_dp, 0.0014473024069595088_dp, 0.0034089209953625916_dp, &
             0.007596850079955685_dp, 0.01617128837200462_dp, 0.033112560068507886_dp, &
             0.06557132006336473_dp, 0.12611115961852515_dp, 0.23637786866043078_dp, &
             0.4330380932913855_dp, 0.777379946000164_dp, 1.371228004151114_dp, &
             2.385892431854792_dp, 4.128836800009076_dp, 7.290584309037711_dp, &
             ! w
             2.650715831062608e-05_dp, 8.482932543960835e-05_dp, 0.00022439089726813142_dp, &
             0.0005548115989066422_dp, 0.0012859342248887997_dp, 0.0028196916909736833_dp, &
             0.0059033849193231265_dp, 0.011887161404925883_dp, 0.023151011322468745_dp, &
             0.04380121306039398_dp, 0.08079022758313453_dp, 0.14569985265956242_dp, &
             0.2575826900435412_dp, 0.44762979378375634_dp, 0.7676898787855397_dp, &
             1.3100989864647254_dp, 2.275781795930811_dp, 4.388990568421244_dp]

      CASE (489)

         aw(:) = & ! a
            [5.696283282011203e-06_dp, 3.7394747769333536e-05_dp, 0.0001348082926064332_dp, &
             0.000402363370425018_dp, 0.0010752236274931557_dp, 0.002649879374199912_dp, &
             0.006127709733401064_dp, 0.013452712759965424_dp, 0.02827842220929969_dp, &
             0.05728235585657594_dp, 0.11237595298013743_dp, 0.21435935889926439_dp, &
             0.3988910474008291_dp, 0.726205544331862_dp, 1.2972724973010605_dp, &
             2.2831028096327666_dp, 3.9916826660137774_dp, 7.1143030231141795_dp, &
             ! w
             1.5341201465564108e-05_dp, 5.403787101728824e-05_dp, 0.00015718832128219762_dp, &
             0.0004150424006100662_dp, 0.0010095539551882964_dp, 0.002299668561776539_dp, &
             0.004967711953511185_dp, 0.01027011013570269_dp, 0.020458660533292164_dp, &
             0.03947552409429393_dp, 0.07408207511497567_dp, 0.1356715340876873_dp, &
             0.24317428843000152_dp, 0.4278346574865771_dp, 0.7418671103674677_dp, &
             1.2783452047799542_dp, 2.2389880177703896_dp, 4.347144558391107_dp]

      CASE (490)

         aw(:) = & ! a
            [2.782832013879544e-06_dp, 2.0342603732064615e-05_dp, 8.2625907295173e-05_dp, &
             0.0002705161068050067_dp, 0.0007744772173361553_dp, 0.0020126926988123786_dp, &
             0.004855389088415757_dp, 0.011036089952012563_dp, 0.023884657719413113_dp, &
             0.04960259574228993_dp, 0.09943549273473215_dp, 0.19330747767180548_dp, &
             0.3658165918240841_dp, 0.6760691117386491_dp, 1.2240942741386258_dp, &
             2.180539227329422_dp, 3.8539170196075587_dp, 6.936381923548616_dp, &
             ! w
             7.700874967225928e-06_dp, 3.195765846889435e-05_dp, 0.00010517748542706982_dp, &
             0.0003004829197892872_dp, 0.000773582704782333_dp, 0.0018413406871863173_dp, &
             0.004121261522515641_dp, 0.008774678444653202_dp, 0.017921132855175225_dp, &
             0.03533049138870044_dp, 0.06755938506374413_dp, 0.12579283396331942_dp, &
             0.2288155791403282_dp, 0.4079058107963534_dp, 0.7156450471221592_dp, &
             1.2458883318824714_dp, 2.2012394565082762_dp, 4.304215870787817_dp]

      CASE (491)

         aw(:) = & ! a
            [1.6693645060820608e-06_dp, 1.3643146486114305e-05_dp, 6.088783522060366e-05_dp, &
             0.00021246429938838942_dp, 0.0006361564791437423_dp, 0.001709451765030174_dp, &
             0.004233050310459982_dp, 0.00982704453711614_dp, 0.021644342092136296_dp, &
             0.04562282514340107_dp, 0.09263486884498745_dp, 0.1821078041898917_dp, &
             0.3480309173484621_dp, 0.6488535836239001_dp, 1.184046085764974_dp, &
             2.124023770793666_dp, 3.7775910854683334_dp, 6.837422776978846_dp, &
             ! w
             4.773877589090357e-06_dp, 2.2950812678044945e-05_dp, 8.219558575957006e-05_dp, &
             0.00024717682984820225_dp, 0.0006597465544647993_dp, 0.0016139989585811682_dp, &
             0.003691831245964453_dp, 0.008001596714215905_dp, 0.01658813887916468_dp, &
             0.03312264491246706_dp, 0.06404259600944529_dp, 0.12040908345969413_dp, &
             0.22091544412851835_dp, 0.3968490483283259_dp, 0.7009937354717216_dp, &
             1.227655558898501_dp, 2.179968861224675_dp, 4.280026981213034_dp]

      CASE (492)

         aw(:) = & ! a
            [1.0515321068239267e-06_dp, 9.821093591985666e-06_dp, 4.7839586195355874e-05_dp, &
             0.00017615019972178953_dp, 0.000546950548985951_dp, 0.0015092946854455794_dp, &
             0.0038146738458003215_dp, 0.009002030655836032_dp, 0.020096495053154233_dp, &
             0.042844000310692514_dp, 0.08784307510117485_dp, 0.17415379677431764_dp, &
             0.33531195548043674_dp, 0.6292732085239225_dp, 1.15508235334966_dp, &
             2.082971031911345_dp, 3.721955351083245_dp, 6.765109279421807_dp, &
             ! w
             3.148188163122602e-06_dp, 1.7626578682896585e-05_dp, 6.777978796775255e-05_dp, &
             0.0002125503405426769_dp, 0.0005839809932350042_dp, 0.0014598459218290425_dp, &
             0.0033962665131134846_dp, 0.007462888404998172_dp, 0.01564949908707742_dp, &
             0.031553908557126566_dp, 0.06152411499343817_dp, 0.11652685139536159_dp, &
             0.21518370464952713_dp, 0.38878400274729047_dp, 0.6902582498684185_dp, &
             1.2142495238844528_dp, 2.16429814216164_dp, 4.26220623979455_dp]

      CASE (493)

         aw(:) = & ! a
            [8.347282146216849e-07_dp, 8.445609044597734e-06_dp, 4.295846963332234e-05_dp, &
             0.0001621772442246233_dp, 0.0005119326807149494_dp, 0.0014295422866934379_dp, &
             0.003646020808733424_dp, 0.008666316825666471_dp, 0.019461724107915235_dp, &
             0.0416968867194958_dp, 0.0858538110406806_dp, 0.17083559167621434_dp, &
             0.32998326007632633_dp, 0.6210393049021322_dp, 1.142863410912603_dp, &
             2.065605413079893_dp, 3.6983708639129658_dp, 6.734408153656111_dp, &
             ! w
             2.5772983376536385e-06_dp, 1.565429375462735e-05_dp, 6.222292762979304e-05_dp, &
             0.00019889915108187086_dp, 0.0005536417003478005_dp, 0.001397382607273151_dp, &
             0.003275368729985348_dp, 0.0072408211256767335_dp, 0.015260039647555644_dp, &
             0.030899361769210924_dp, 0.06046817347535602_dp, 0.11489215639079002_dp, &
             0.21276113132017072_dp, 0.3853639896416572_dp, 0.6856931427378729_dp, &
             1.2085366578097234_dp, 2.157612021347045_dp, 4.254602733848133_dp]

      CASE (494)

         aw(:) = & ! a
            [7.316974182351593e-07_dp, 7.781929137475314e-06_dp, 4.055569727018987e-05_dp, &
             0.00015520451039960237_dp, 0.0004942921590440873_dp, 0.0013890847744510468_dp, &
             0.003559999883048024_dp, 0.008494338776437845_dp, 0.01913537296945844_dp, &
             0.04110533461974308_dp, 0.08482530332484546_dp, 0.16911611957268938_dp, &
             0.3272165484785323_dp, 0.6167568714399279_dp, 1.1364989952199356_dp, &
             2.0565490922764194_dp, 3.6860593260682344_dp, 6.718370381403715_dp, &
             ! w
             2.305790352725447e-06_dp, 1.4687672181131984e-05_dp, 5.944769342524119e-05_dp, &
             0.00019200911058081936_dp, 0.000538216569141813_dp, 0.001365449054091066_dp, &
             0.003213289879430834_dp, 0.00712638348625628_dp, 0.015058734373588631_dp, &
             0.03056016399499463_dp, 0.05991974024033199_dp, 0.11404146352172441_dp, &
             0.21149824594524436_dp, 0.38357844041147665_dp, 0.6833067027828519_dp, &
             1.2055472917707855_dp, 2.1541114020539553_dp, 4.250621777795089_dp]

      CASE (495)

         aw(:) = & ! a
            [6.83039002664919e-07_dp, 7.465620502939985e-06_dp, 3.939791188408471e-05_dp, &
             0.00015182028159449893_dp, 0.0004856876672380213_dp, 0.0013692786766684858_dp, &
             0.0035177690374484398_dp, 0.008409717013647835_dp, 0.018974491763188005_dp, &
             0.04081325821750734_dp, 0.0843167978175517_dp, 0.16826500323032495_dp, &
             0.32584567313942464_dp, 0.6146330978111908_dp, 1.1333403062727645_dp, &
             2.052051529487636_dp, 3.6799420689868114_dp, 6.710398787959083_dp, &
             ! w
             2.1774829197749774e-06_dp, 1.4222934167466683e-05_dp, 5.8100167850820926e-05_dp, &
             0.00018864510331566967_dp, 0.0005306565260497579_dp, 0.001349752915044938_dp, &
             0.003182707093407167_dp, 0.0070699014087847595_dp, 0.014959222366659827_dp, &
             0.030392262780165366_dp, 0.059647953666310274_dp, 0.11361945826445594_dp, &
             0.21087120318738792_dp, 0.3826911935136782_dp, 0.682120087405447_dp, &
             1.2040601301845306_dp, 2.1523693922115394_dp, 4.248640732432654_dp]

      CASE (496)

         aw(:) = & ! a
            [6.722003459742127e-07_dp, 7.394878326781196e-06_dp, 3.913777831822341e-05_dp, &
             0.0001510576318092805_dp, 0.00048374465492350934_dp, 0.001364799496628946_dp, &
             0.00350820740770161_dp, 0.008390539676953471_dp, 0.018938004226196844_dp, &
             0.0407469730322969_dp, 0.08420133138459711_dp, 0.16807164831677698_dp, &
             0.32553411304757646_dp, 0.614150254525752_dp, 1.1326219530034776_dp, &
             2.051028424957739_dp, 3.678550234303169_dp, 6.7085847754388865_dp, &
             ! w
             2.1488928684308334e-06_dp, 1.4118608741100246e-05_dp, 5.779644587032146e-05_dp, &
             0.00018788516541697197_dp, 0.0005289460218468404_dp, 0.001346197377932109_dp, &
             0.0031757728853528105_dp, 0.007057085096263939_dp, 0.014936627666151461_dp, &
             0.030354118963994026_dp, 0.05958617995199161_dp, 0.11352350292151672_dp, &
             0.21072857617648197_dp, 0.3824893168833493_dp, 0.6818500228117441_dp, &
             1.2037215951561886_dp, 2.151972796095301_dp, 4.248189705220419_dp]

      CASE (497)

         aw(:) = & ! a
            [0.005165332477997096_dp, 0.027453090782803845_dp, 0.06855153379067212_dp, &
             0.13032338044494676_dp, 0.21577379193928328_dp, 0.3294542097505737_dp, &
             0.4780240766071933_dp, 0.6709722829701888_dp, 0.9214784312982677_dp, &
             1.2474223230855346_dp, 1.6726364905803062_dp, 2.228608038820973_dp, &
             2.9569665965904703_dp, 3.9133470930293974_dp, 5.173861728624551_dp, &
             6.847189934997828_dp, 9.100821151066391_dp, 12.231834752574837_dp, &
             16.947785452928883_dp, &
             ! w
             0.013282683019441681_dp, 0.031461954436631044_dp, 0.05104059411093964_dp, &
             0.07299734987692671_dp, 0.09865267984972562_dp, 0.12980597075173161_dp, &
             0.1689008819771996_dp, 0.21917552422581316_dp, 0.28479635641945156_dp, &
             0.37103591540574876_dp, 0.4846000732932077_dp, 0.6342194960650418_dp, &
             0.8316683182797598_dp, 1.093592784169909_dp, 1.4451639886413101_dp, &
             1.9284445503402172_dp, 2.6251732346689796_dp, 3.7374625254639873_dp, &
             6.066869248120491_dp]

      CASE (498)

         aw(:) = & ! a
            [0.0044677297018304385_dp, 0.02376189784088184_dp, 0.0594114160764658_dp, &
             0.11317093214998303_dp, 0.18789536211406485_dp, 0.28794844749529214_dp, &
             0.41976897974556754_dp, 0.5925893569356319_dp, 0.8192848729010562_dp, &
             1.1173745143468252_dp, 1.5102875368184387_dp, 2.0291096314075596_dp, &
             2.715135152022554_dp, 3.6237951049992803_dp, 4.831173118640435_dp, &
             6.446086093346339_dp, 8.636197950109521_dp, 11.698348017873675_dp, &
             16.33756949580318_dp, &
             ! w
             0.011490630911616305_dp, 0.02725513553317332_dp, 0.04433158603485956_dp, &
             0.06365656069161345_dp, 0.08651012831570848_dp, 0.11465712070877483_dp, &
             0.15050854605641303_dp, 0.19726168532262914_dp, 0.25902858102020215_dp, &
             0.3410272082701835_dp, 0.4499384688954574_dp, 0.5945251772892179_dp, &
             0.7866617733644203_dp, 1.0431535016530118_dp, 1.3893547388990992_dp, &
             1.86745854223555_dp, 2.559101435919116_dp, 3.665503059769784_dp, &
             5.9833141100858835_dp]

      CASE (499)

         aw(:) = & ! a
            [0.003949175377103119_dp, 0.021016882386231287_dp, 0.05260879735865853_dp, &
             0.10039031150584306_dp, 0.1670911065683335_dp, 0.2569161924165607_dp, &
             0.37611307512913306_dp, 0.5336840427318839_dp, 0.7422230579726513_dp, &
             1.0189113226927433_dp, 1.3868011096110702_dp, 1.8766039948207272_dp, &
             2.529299526096628_dp, 3.400119796208777_dp, 4.565105925112592_dp, &
             6.133187318271295_dp, 8.27219699809758_dp, 11.27883963479663_dp, &
             15.856211970486438_dp, &
             ! w
             0.010158393680043698_dp, 0.02412496650581039_dp, 0.039331705782722326_dp, &
             0.05667950869858235_dp, 0.07741342305966409_dp, 0.10326604898933696_dp, &
             0.1366142104363427_dp, 0.1806104453158263_dp, 0.23931023886372965_dp, &
             0.3178792354262361_dp, 0.4229766430140424_dp, 0.5633951382996059_dp, &
             0.751097950652108_dp, 1.0030307849707563_dp, 1.344713789847315_dp, &
             1.8184693928995797_dp, 2.5058806026915006_dp, 3.6074792807362663_dp, &
             5.916010788202849_dp]

      CASE (500)

         aw(:) = & ! a
            [0.0035471729434616347_dp, 0.01888800297150949_dp, 0.04732929776618154_dp, &
             0.09046100392857725_dp, 0.1509061231439061_dp, 0.23273276411601526_dp, &
             0.3420200251314302_dp, 0.4875623001214235_dp, 0.6816944583909494_dp, &
             0.9412849564184215_dp, 1.2890380629860994_dp, 1.7553205830818768_dp, &
             2.3808198111687657_dp, 3.2205776977543294_dp, 4.350584880671707_dp, &
             5.879863728649131_dp, 7.976406435902832_dp, 10.93684621410959_dp, &
             15.462735633741266_dp, &
             ! w
             0.009125498784984032_dp, 0.021696203027985347_dp, 0.035446687289527296_dp, &
             0.05124710107741155_dp, 0.0703116698276112_dp, 0.09434298192192263_dp, &
             0.12568361751443963_dp, 0.1674405452010151_dp, 0.22361398943119276_dp, &
             0.29932128320477897_dp, 0.4012029270053877_dp, 0.5380785623375758_dp, &
             0.7219895571621229_dp, 0.9700058375983625_dp, 1.3077973829622653_dp, &
             1.7778112511735331_dp, 2.4616068500429553_dp, 3.5591669824444745_dp, &
             5.860021619326129_dp]

      CASE (501)

         aw(:) = & ! a
            [0.003225554724122865_dp, 0.017184201050827182_dp, 0.04310121966398131_dp, &
             0.08250161959105298_dp, 0.137915957094343_dp, 0.2132924060260648_dp, &
             0.3145599254731431_dp, 0.4503238031101212_dp, 0.6326802072272908_dp, &
             0.878208923740481_dp, 1.209293959635216_dp, 1.6559849705361138_dp, &
             2.2586984151318545_dp, 3.072295727918567_dp, 4.172712399660881_dp, &
             5.669048301548914_dp, 7.729443854495566_dp, 10.650500818188634_dp, &
             15.132505473025887_dp, &
             ! w
             0.00829907171621874_dp, 0.01975153693123908_dp, 0.03233200976266627_dp, &
             0.04688374618524252_dp, 0.06459350616949455_dp, 0.08713589301190912_dp, &
             0.11681991816309456_dp, 0.15670769662898318_dp, 0.2107469020009805_dp, &
             0.28401083088203033_dp, 0.3831236427983252_dp, 0.5169289349957699_dp, &
             0.6975369065990421_dp, 0.9421279423087208_dp, 1.276507993989929_dp, &
             1.7432428305202894_dp, 2.4238875934879394_dp, 3.5179749485496643_dp, &
             5.812320538203648_dp]

      CASE (502)

         aw(:) = & ! a
            [0.002961864180714168_dp, 0.015786815087024474_dp, 0.039631457288065275_dp, &
             0.07596408434342933_dp, 0.1272340255084237_dp, 0.19728303997467087_dp, &
             0.29190484380803305_dp, 0.41953163457991377_dp, 0.5920391937559307_dp, &
             0.8257407447584977_dp, 1.1427253075563295_dp, 1.5727502568695093_dp, &
             2.15598061389256_dp, 2.947106721803515_dp, 4.022006234464495_dp, &
             5.489844122345034_dp, 7.518898371344817_dp, 10.405765620794869_dp, &
             14.849671080259483_dp, &
             ! w
             0.007621442842353354_dp, 0.01815595740871083_dp, 0.029773414721636585_dp, &
             0.04329325782769944_dp, 0.059877517744280344_dp, 0.08117463392642735_dp, &
             0.1094610878193479_dp, 0.14775561986267893_dp, 0.19995655418437847_dp, &
             0.27109714745190816_dp, 0.3677870191914155_dp, 0.4988908543475857_dp, &
             0.676579712238261_dp, 0.9181328491895517_dp, 1.2494802737705826_dp, &
             1.7133003460929643_dp, 2.391156903481232_dp, 3.4822059278807114_dp, &
             5.770927160681232_dp]

      CASE (503)

         aw(:) = & ! a
            [0.0016808496363439748_dp, 0.008990245536228625_dp, 0.022719025953813983_dp, &
             0.04399824644267399_dp, 0.07478375998620589_dp, 0.11824766620688688_dp, &
             0.17928978549413466_dp, 0.26514963680237874_dp, 0.3861629508899112_dp, &
             0.5567903239126517_dp, 0.7970794175700454_dp, 1.1347440178303774_dp, &
             1.6081340933944712_dp, 2.2706150896082855_dp, 3.1974823735060673_dp, &
             4.498198428702973_dp, 6.342000037109199_dp, 9.025883690750419_dp, &
             13.243550011832678_dp, &
             ! w
             0.004328598642613239_dp, 0.010384126789943299_dp, 0.017257580190711136_dp, &
             0.025620290592801503_dp, 0.036470805511324374_dp, 0.05126353915187415_dp, &
             0.07201501396525314_dp, 0.10141055674991709_dp, 0.1430022075061157_dp, &
             0.20155976382969545_dp, 0.2835890026511507_dp, 0.3980612231238237_dp, &
             0.5575035245976293_dp, 0.7798189698962098_dp, 1.0917817435362196_dp, &
             1.5369312378288846_dp, 2.197147988277921_dp, 3.2696589291009506_dp, &
             5.525504384643781_dp]

      CASE (504)

         aw(:) = & ! a
            [0.0012023276934156263_dp, 0.006446201408636427_dp, 0.016364897278616404_dp, &
             0.03192252431995431_dp, 0.054822603663368594_dp, 0.08787698176768015_dp, &
             0.13547622022660977_dp, 0.2041578642460905_dp, 0.30335004847620206_dp, &
             0.446429285736762_dp, 0.6522422871307547_dp, 0.9472699310767672_dp, &
             1.3687143312558199_dp, 1.9690313692588841_dp, 2.8230182294664274_dp, &
             4.04018536414647_dp, 5.790322365644983_dp, 8.370914401336751_dp, &
             12.4733976940383_dp, &
             ! w
             0.003097974462586997_dp, 0.007467725802530155_dp, 0.01252619138269576_dp, &
             0.01886677597849433_dp, 0.02739413310558101_dp, 0.03943711299491686_dp, &
             0.056838922266154654_dp, 0.08207843716980122_dp, 0.11851038043355511_dp, &
             0.170753769295393_dp, 0.24523539450065154_dp, 0.3509470243329158_dp, &
             0.5005717676750603_dp, 0.7123372377603621_dp, 1.0135106474518483_dp, &
             1.448203987048529_dp, 2.098657942341444_dp, 3.161354951047662_dp, &
             5.400811786336295_dp]

      CASE (505)

         aw(:) = & ! a
            [0.000946710334071774_dp, 0.0050852716789430924_dp, 0.012956849885372646_dp, &
             0.02542043796551092_dp, 0.044017129742518125_dp, 0.07131939341169745_dp, &
             0.11137026084970997_dp, 0.1702248746342488_dp, 0.2566902491099955_dp, &
             0.38340084008456893_dp, 0.5683723645798634_dp, 0.8372148082210225_dp, &
             1.2262949576500524_dp, 1.7873765690459487_dp, 2.594839065860491_dp, &
             3.7581658499459922_dp, 5.447516158593702_dp, 7.96079685841498_dp, &
             11.98818313201349_dp, &
             ! w
             0.0024403793946805316_dp, 0.005904858284596696_dp, 0.009977468741504241_dp, &
             0.015200659502200606_dp, 0.022414145315007575_dp, 0.03285545421008699_dp, &
             0.04824348878059537_dp, 0.07091596819765357_dp, 0.10409503054738367_dp, &
             0.15229253688991193_dp, 0.22186728407930348_dp, 0.3218037042202939_dp, &
             0.46486896417039536_dp, 0.6694974161260359_dp, 0.9632966712338786_dp, &
             1.3908032045867567_dp, 2.034575296781476_dp, 3.090712546128751_dp, &
             5.319610438419082_dp]

      CASE (506)

         aw(:) = & ! a
            [0.0007859972597901745_dp, 0.00422864508174495_dp, 0.010807191180201696_dp, &
             0.021306354928461373_dp, 0.037150467041811346_dp, 0.06073600511400965_dp, &
             0.09584674374420246_dp, 0.14817763607213577_dp, 0.22607314271643042_dp, &
             0.3416133201382743_dp, 0.5121865056933581_dp, 0.7627346252904954_dp, &
             1.1289701593483565_dp, 1.6620985323511748_dp, 2.4361419560409874_dp, &
             3.560528165360248_dp, 5.205685528678884_dp, 7.669879227625732_dp, &
             11.642476628696276_dp, &
             ! w
             0.0020268234806406437_dp, 0.004919747616795269_dp, 0.008364274194348474_dp, &
             0.012865817442588336_dp, 0.01921494067840693_dp, 0.028578322419148434_dp, &
             0.04258033439228271_dp, 0.06345440080080501_dp, 0.09432416333569144_dp, &
             0.13961749853097102_dp, 0.20563341013423364_dp, 0.301338501784395_dp, &
             0.4395500701480455_dp, 0.6388484681139391_dp, 0.9270974528650047_dp, &
             1.34916901046183_dp, 1.9878975548392614_dp, 3.039159900437875_dp, &
             5.260415972624009_dp]

      CASE (507)

         aw(:) = & ! a
            [0.0006749106811276842_dp, 0.0036359671789622104_dp, 0.009317270444530974_dp, &
             0.018447331323020285_dp, 0.03236085062677534_dp, 0.05331691112605414_dp, &
             0.0848951333994518_dp, 0.1325070880425022_dp, 0.20413372020293258_dp, &
             0.31141752683934143_dp, 0.4712470658078653_dp, 0.7080253033514385_dp, &
             1.0569284598192545_dp, 1.5686944224027135_dp, 2.3170340367907776_dp, &
             3.4113076576662587_dp, 5.022150513644707_dp, 7.448135962415542_dp, &
             11.37807004269694_dp, &
             ! w
             0.0017409056747026545_dp, 0.0042373726647584415_dp, 0.007242914212328824_dp, &
             0.011234272431903903_dp, 0.016962755023494452_dp, 0.025537748458784645_dp, &
             0.03850864084104038_dp, 0.058027528348821675_dp, 0.08714017870974422_dp, &
             0.13020508064061637_dp, 0.19346802487478867_dp, 0.2858736433521274_dp, &
             0.4202707496074738_dp, 0.615349485169685_dp, 0.8991767958325522_dp, &
             1.3169010232478595_dp, 1.9515988935832955_dp, 2.999009218436354_dp, &
             5.214350185617482_dp]

      CASE (508)

         aw(:) = & ! a
            [0.0005931923431999074_dp, 0.003199612449303557_dp, 0.008218636383443556_dp, &
             0.016334246861398966_dp, 0.02880927232199247_dp, 0.047791160121336454_dp, &
             0.07669276842752676_dp, 0.12069449660077518_dp, 0.1874807694527077_dp, &
             0.28833554144519097_dp, 0.43973450273256925_dp, 0.665630752192438_dp, &
             1.0007472532129744_dp, 1.4954200773895119_dp, 2.22308434925753_dp, &
             3.293028604961744_dp, 4.876053144425764_dp, 7.27100026846775_dp, &
             11.166264590427467_dp, &
             ! w
             0.0015305359756900181_dp, 0.0037344643826074083_dp, 0.006413946863512824_dp, &
             0.010022571076355022_dp, 0.01527915010348538_dp, 0.023245372856115606_dp, &
             0.035409259518815225_dp, 0.05385698229021926_dp, 0.08157013511548536_dp, &
             0.12284797170435875_dp, 0.18388845376767188_dp, 0.2736127817131254_dp, &
             0.40489005306629033_dp, 0.5964965514724115_dp, 0.8766662842850093_dp, &
             1.2907818526477846_dp, 1.9221351370573638_dp, 2.9663769540121385_dp, &
             5.176933586227603_dp]

      CASE (509)

         aw(:) = & ! a
            [0.0005303640593514309_dp, 0.002863875828720506_dp, 0.007372171384282706_dp, &
             0.014702784436254413_dp, 0.026059084455907586_dp, 0.04349518442903838_dp, &
             0.07028405219235231_dp, 0.11141242414631897_dp, 0.17431616280077114_dp, &
             0.2699773161196801_dp, 0.41452143643123013_dp, 0.631516777062393_dp, &
             0.9552945400406361_dp, 1.4358387761816822_dp, 2.146337308966376_dp, &
             3.1960058415130623_dp, 4.755780070315955_dp, 7.124740121900398_dp, &
             10.990967501145983_dp, &
             ! w
             0.0013687675835145836_dp, 0.003347167664642771_dp, 0.005773805080108536_dp, &
             0.009082995430859022_dp, 0.013965956169906004_dp, 0.021443794869635376_dp, &
             0.032953085265131986_dp, 0.05052499444706983_dp, 0.0770866644446477_dp, &
             0.11688563792535352_dp, 0.17607651378540942_dp, 0.26355683459933454_dp, &
             0.3922087439664238_dp, 0.5808782178139423_dp, 0.8579402313528373_dp, &
             1.2689802114182223_dp, 1.8974831878073657_dp, 2.9390436880013247_dp, &
             5.1456085823147975_dp]

      CASE (510)

         aw(:) = & ! a
            [0.00048043949565518106_dp, 0.0025969131851087024_dp, 0.006698261270896518_dp, &
             0.013401437886575702_dp, 0.023859457437051215_dp, 0.040046704515545414_dp, &
             0.06511639852607326_dp, 0.10388969035025705_dp, 0.16358969167239085_dp, &
             0.25493892371210936_dp, 0.39376004721705454_dp, 0.6032859114740475_dp, &
             0.9175033038061544_dp, 1.3860832943401065_dp, 2.081989581968695_dp, &
             3.1143657390872033_dp, 4.654260889694073_dp, 7.0009678541599_dp, &
             10.842323113643882_dp, &
             ! w
             0.0012402032728556424_dp, 0.0030389525605399796_dp, 0.005263112644710338_dp, &
             0.008330589975932237_dp, 0.012908711049654284_dp, 0.01998346855547739_dp, &
             0.03094747872394875_dp, 0.04778498019481216_dp, 0.07337590416452335_dp, &
             0.11192190570373758_dp, 0.16953797143187854_dp, 0.25509835045157353_dp, &
             0.3814933442739696_dp, 0.5676266444396509_dp, 0.8419945520361988_dp, &
             1.2503609824414232_dp, 1.8763860059088577_dp, 2.915629011144059_dp, &
             5.1187856317997875_dp]

      CASE (511)

         aw(:) = & ! a
            [0.0004397402753084449_dp, 0.002379146979898393_dp, 0.0061479118280827125_dp, &
             0.012336836108433634_dp, 0.02205550437562051_dp, 0.03720904397663541_dp, &
             0.06084651911069953_dp, 0.09764519545293227_dp, 0.1546430661551105_dp, &
             0.24233590782150838_dp, 0.37628025727117576_dp, 0.5794123567757681_dp, &
             0.8854121264367747_dp, 1.3436690831379876_dp, 2.0269420472401176_dp, &
             3.044304019820955_dp, 4.566900745885466_dp, 6.8942170928054125_dp, &
             10.713893661358698_dp, &
             ! w
             0.001135380846526007_dp, 0.002787345925072663_dp, 0.004845270506795661_dp, &
             0.007712839937737775_dp, 0.01203638389600089_dp, 0.018771095935044793_dp, &
             0.029271450212838973_dp, 0.04548093611798933_dp, 0.07023786898195965_dp, &
             0.10770266935820304_dp, 0.16395389873842114_dp, 0.2478431596680922_dp, &
             0.37226548984175384_dp, 0.5561732580829527_dp, 0.8281688204004571_dp, &
             1.2341752039531853_dp, 1.8580124017735813_dp, 2.8952193255576355_dp, &
             5.095413388496554_dp]

      CASE (512)

         aw(:) = & ! a
            [0.0002452565599847984_dp, 0.001336251823050387_dp, 0.003501471540929438_dp, &
             0.007185182036997784_dp, 0.013246418692518382_dp, 0.02318269575948486_dp, &
             0.0394296163815743_dp, 0.06581836011474483_dp, 0.10828972542414658_dp, &
             0.17597420011785742_dp, 0.2827944009101576_dp, 0.44982567053123507_dp, &
             0.7087746360197066_dp, 1.1071629823550355_dp, 1.7163201146111902_dp, &
             2.6447268869307314_dp, 4.064049145958035_dp, 6.275049984375717_dp, &
             9.964551282442011_dp, &
             ! w
             0.0006342268344939126_dp, 0.0015791476671186966_dp, 0.002822483197848424_dp, &
             0.004684406041435337_dp, 0.0076828924255215175_dp, 0.012588202719370847_dp, &
             0.020532509954255537_dp, 0.03321747100526211_dp, 0.05322084663019754_dp, &
             0.08443001798367637_dp, 0.13266627167354036_dp, 0.20659665811833028_dp, &
             0.31909344154293573_dp, 0.48936280251203956_dp, 0.746643309005604_dp, &
             1.1378801459629069_dp, 1.7480036471772586_dp, 2.7726434417237336_dp, &
             4.9552013805472646_dp]

      CASE (513)

         aw(:) = & ! a
            [0.0001741460746723223_dp, 0.0009534786680525147_dp, 0.0025232247863159526_dp, &
             0.005259664108906556_dp, 0.009900685826684632_dp, 0.01774286641177327_dp, &
             0.030920261624485742_dp, 0.052847162031634545_dp, 0.08891488519445367_dp, &
             0.1475536351631822_dp, 0.2418254321034717_dp, 0.39179749092196814_dp, &
             0.6280735734632387_dp, 0.997090807689619_dp, 1.5692989749944635_dp, &
             2.4527462114550977_dp, 3.8193114566860196_dp, 5.970494231428673_dp, &
             9.592943100394793_dp, &
             ! w
             0.0004508258133707264_dp, 0.0011336422409792784_dp, 0.0020660275741542743_dp, &
             0.00352662470860865_dp, 0.005967095404007063_dp, 0.010065762904314173_dp, &
             0.016846712842950907_dp, 0.027888329322930703_dp, 0.045626180291767605_dp, &
             0.07378963156087867_dp, 0.1180410005696795_dp, 0.1869178535193543_dp, &
             0.2932425855458447_dp, 0.45632059507388456_dp, 0.7057115787411917_dp, &
             1.0889288542900775_dp, 1.6915795941607348_dp, 2.709496127735778_dp, &
             4.883067088161423_dp]

      CASE (514)

         aw(:) = & ! a
            [0.00013655809986376583_dp, 0.0007506111348062843_dp, 0.0020021522024140184_dp, &
             0.00422582322624809_dp, 0.008083551134479257_dp, 0.014745206886610122_dp, &
             0.02615513568683237_dp, 0.04546393670455775_dp, 0.07771094306053655_dp, &
             0.1308709458375622_dp, 0.21743750607560622_dp, 0.3568011133504739_dp, &
             0.5788120768616463_dp, 0.929150761248229_dp, 1.4776339845111246_dp, &
             2.3319730133114933_dp, 3.6641596499525497_dp, 5.7762017388518485_dp, &
             9.354729635731525_dp, &
             ! w
             0.0003538233776194803_dp, 0.000896760446405615_dp, 0.0016597826113511904_dp, &
             0.0028949781278375048_dp, 0.005011224904955544_dp, 0.008629133943598814_dp, &
             0.01470470788060809_dp, 0.02473573889045818_dp, 0.04106161575848743_dp, &
             0.06730190835605325_dp, 0.10900497514904041_dp, 0.174610211143539_dp, &
             0.27689173728297317_dp, 0.4352058494881356_dp, 0.6793173395993287_dp, &
             1.0571253666352238_dp, 1.6547207576581278_dp, 2.668131723866405_dp, &
             4.835849410661586_dp]

      CASE (515)

         aw(:) = & ! a
            [0.00011308121399109941_dp, 0.000623634637975123_dp, 0.0016746960030130308_dp, &
             0.0035719327882889505_dp, 0.006923587329983111_dp, 0.012809842189313183_dp, &
             0.023040879793721047_dp, 0.04057974918190759_dp, 0.07021293758054123_dp, &
             0.11958451843089579_dp, 0.20077071735581575_dp, 0.33265963265552606_dp, &
             0.5445354247209374_dp, 0.8815016077516146_dp, 1.4128825664410358_dp, &
             2.2461144930477452_dp, 3.553256200333291_dp, 5.636699231526024_dp, &
             9.183109505873462_dp, &
             ! w
             0.0002932076769236164_dp, 0.0007481120070367528_dp, 0.0014028117638563895_dp, &
             0.002490340581151832_dp, 0.00438889273577708_dp, 0.007678445938318215_dp, &
             0.013266560967431732_dp, 0.02259210160528784_dp, 0.037922658195971584_dp, &
             0.06279446256056287_dp, 0.10266764145907013_dp, 0.1659029476447847_dp, &
             0.26523093116487967_dp, 0.42003727377417416_dp, 0.6602331680011628_dp, &
             1.034006152965516_dp, 1.6278213442595888_dp, 2.637883596163789_dp, &
             4.8013369479657255_dp]

      CASE (516)

         aw(:) = & ! a
            [9.692871428992666e-05_dp, 0.0005361166667958782_dp, 0.0014482287494156359_dp, &
             0.0031172124973499363_dp, 0.006110624576204801_dp, 0.011440671384384876_dp, &
             0.02081585035726263_dp, 0.037056288258413915_dp, 0.06475423314355687_dp, &
             0.11129755258357511_dp, 0.1884364659911477_dp, 0.31466329164292456_dp, &
             0.518812102943515_dp, 0.8455228759939528_dp, 1.363718309371896_dp, &
             2.1806024816750234_dp, 3.4682764293725907_dp, 5.529437384651954_dp, &
             9.050808091542981_dp, &
             ! w
             0.0002514859830440869_dp, 0.0006454345166225561_dp, 0.0012241052339225014_dp, &
             0.002205910494090055_dp, 0.003945601656522417_dp, 0.0069924961499716895_dp, &
             0.01221714691770993_dp, 0.02101246469495393_dp, 0.03558924924552499_dp, &
             0.05941703186696812_dp, 0.09788430469712169_dp, 0.1592864348880946_dp, &
             0.2563149746526521_dp, 0.4083735982934267_dp, 0.6454851278879378_dp, &
             1.016065286906939_dp, 1.606883214799993_dp, 2.614301806930561_dp, &
             4.774439568301108_dp]

      CASE (517)

         aw(:) = & ! a
            [8.508757405840501e-05_dp, 0.0004718588003697698_dp, 0.0012814541772765324_dp, &
             0.002780723343367501_dp, 0.0055049358203099925_dp, 0.010412383380469936_dp, &
             0.019130864807767222_dp, 0.03436651212901931_dp, 0.060555602889510285_dp, &
             0.10487887023776117_dp, 0.1788212031017138_dp, 0.30055061645761594_dp, &
             0.49852969740380165_dp, 0.8170125736689722_dp, 1.3245836332330116_dp, &
             2.1282463931469673_dp, 3.400129263283795_dp, 5.443182007912334_dp, &
             8.944192595254204_dp, &
             ! w
             0.00022088958216943074_dp, 0.0005699037544084404_dp, 0.0010918633813335535_dp, &
             0.0019934561476842214_dp, 0.0036107454977517797_dp, 0.006468811700138278_dp, &
             0.011408586421372484_dp, 0.019785608074966144_dp, 0.03376400181826369_dp, &
             0.05675798125314822_dp, 0.09409596810809624_dp, 0.15401750761816266_dp, &
             0.24917910679867586_dp, 0.3989957294671794_dp, 0.6335791266820889_dp, &
             1.0015325615248678_dp, 1.5898803365209977_dp, 2.5951273723316794_dp, &
             4.75257476360093_dp]

      CASE (518)

         aw(:) = & ! a
            [7.600822373816234e-05_dp, 0.00042251989138572483_dp, 0.0011530576109491102_dp, &
             0.002520537010995768_dp, 0.00503375307570398_dp, 0.009606823836148306_dp, &
             0.017801365585411767_dp, 0.03222959135625519_dp, 0.05719853610097257_dp, &
             0.09971631339025547_dp, 0.17104546310578572_dp, 0.28908070363547056_dp, &
             0.48196968203540597_dp, 0.7936371205258098_dp, 1.2923758135249086_dp, &
             2.0850128708834323_dp, 3.3436945551800945_dp, 5.371584770055354_dp, &
             8.855539374950604_dp, &
             ! w
             0.00019742194726119186_dp, 0.0005118116348137076_dp, 0.0009896106633899505_dp, &
             0.0018278066285044969_dp, 0.00334710232508817_dp, 0.0060527664083277226_dp, &
             0.010761229345322946_dp, 0.018796720675713002_dp, 0.03228394099920342_dp, &
             0.05459003681519023_dp, 0.09099185987169944_dp, 0.14968034692654478_dp, &
             0.24328029632329165_dp, 0.3912137314868303_dp, 0.6236655095108314_dp, &
             0.9893972810105117_dp, 1.5756526218352265_dp, 2.5790649790605737_dp, &
             4.734262357502428_dp]

      CASE (519)

         aw(:) = & ! a
            [6.880928317894288e-05_dp, 0.0003833503298649437_dp, 0.0010508770061426042_dp, &
             0.002312651921688992_dp, 0.004655223586962406_dp, 0.008955622505370815_dp, &
             0.01671983269130878_dp, 0.030480787690744485_dp, 0.05443587925776594_dp, &
             0.09544606234459735_dp, 0.16458342414963958_dp, 0.2795074718395376_dp, &
             0.46809341944311916_dp, 0.7739793587128425_dp, 1.2652023159621386_dp, &
             2.0484320743641677_dp, 3.2958263420011202_dp, 5.310734231725445_dp, &
             8.780079439268203_dp, &
             ! w
             0.0001788093141587951_dp, 0.0004656227515863443_dp, 0.0009079146920660995_dp, &
             0.0016944583618168278_dp, 0.003133034563393297_dp, 0.005712304059638192_dp, &
             0.01022793028426971_dp, 0.017977327533170728_dp, 0.03105120439534169_dp, &
             0.05277587836847496_dp, 0.08838313096087348_dp, 0.1460209186406147_dp, &
             0.23828514680469007_dp, 0.38460209116681837_dp, 0.6152181442361673_dp, &
             0.9790314957725786_dp, 1.5634775601762414_dp, 2.5653069289627086_dp, &
             4.718579708657027_dp]

      CASE (520)

         aw(:) = & ! a
            [6.295112287955062e-05_dp, 0.00035143926303216196_dp, 0.0009674449077851094_dp, &
             0.002142288054406022_dp, 0.004343464409125552_dp, 0.00841626764552616_dp, &
             0.01581901191689761_dp, 0.029016435920813478_dp, 0.052111201960826185_dp, &
             0.09183658041303387_dp, 0.1590987271080321_dp, 0.27135137173711127_dp, &
             0.4562303359239874_dp, 0.757120560817237_dp, 1.2418316253697426_dp, &
             2.016891435981481_dp, 3.2544646697665223_dp, 5.258063120748616_dp, &
             8.714676931404934_dp, &
             ! w
             0.00016365924209062137_dp, 0.00042794058548162057_dp, 0.0008409665962780909_dp, &
             0.0015844273205295669_dp, 0.0029550333285744625_dp, 0.0054272463089888685_dp, &
             0.00977879306129542_dp, 0.017283724934061266_dp, 0.030002969237911285_dp, &
             0.05122688543495452_dp, 0.08614730779022037_dp, 0.14287372210428936_dp, &
             0.23397553373032692_dp, 0.37888133830939713_dp, 0.6078902873632925_dp, &
             0.9700201717118178_dp, 1.552876616437419_dp, 2.5533176914480835_dp, &
             4.704915228054113_dp]

      CASE (521)

         aw(:) = & ! a
            [3.50923765549347e-05_dp, 0.00019906223521234002_dp, 0.0005658227010916817_dp, &
             0.0013112600862214884_dp, 0.002795691991344798_dp, 0.005686375699459768_dp, &
             0.011172361573755608_dp, 0.021327764214291525_dp, 0.039704519451766944_dp, &
             0.07228303182843565_dp, 0.12897767034865545_dp, 0.2259952894860738_dp, &
             0.3894999842443624_dp, 0.6612942621298318_dp, 1.107733975533177_dp, &
             1.834399485287558_dp, 3.0134332599269062_dp, 4.949343749742555_dp, &
             8.329664463657704_dp, &
             ! w
             9.154515676928922e-05_dp, 0.00024711067481745976_dp, 0.0005144625693660486_dp, &
             0.0010345563254320219_dp, 0.0020420553280663415_dp, 0.003931618264674404_dp, &
             0.007376458095215753_dp, 0.013510948790764584_dp, 0.024214894207119277_dp, &
             0.042556260434951816_dp, 0.07347469127524059_dp, 0.12482920693843112_dp, &
             0.20900384152891088_dp, 0.3454123871036579_dp, 0.5646508697430568_dp, &
             0.9164636544285858_dp, 1.4895357525021196_dp, 2.481478609821539_dp, &
             4.623073141582258_dp]

      CASE (522)

         aw(:) = & ! a
            [2.4961643626420166e-05_dp, 0.00014325538880899323_dp, 0.0004166190459596854_dp, &
             0.0009953067753841886_dp, 0.0021897853867406682_dp, 0.0045846919129257195_dp, &
             0.009242375349019675_dp, 0.018049263792974266_dp, 0.03428720929349682_dp, &
             0.0635603099919389_dp, 0.11527813392006443_dp, 0.2050013660740282_dp, &
             0.35811690427455783_dp, 0.6155736203439862_dp, 1.0429211305719979_dp, &
             1.7451864079195214_dp, 2.8944536047876546_dp, 4.795753346588278_dp, &
             8.136995520351189_dp, &
             ! w
             6.527874600971004e-05_dp, 0.0001803101026628384_dp, 0.0003903773935193581_dp, &
             0.0008169568416950697_dp, 0.0016661613185203136_dp, 0.0032951267881748455_dp, &
             0.006325424753489499_dp, 0.011820345517797207_dp, 0.021565549275927652_dp, &
             0.03851089525954203_dp, 0.06745861076716163_dp, 0.11612613576464842_dp, &
             0.19678430892254414_dp, 0.3288189265297978_dp, 0.5429632598598246_dp, &
             0.8893385370883415_dp, 1.4572221437311055_dp, 2.4446873321018328_dp, &
             4.581180141661304_dp]

      CASE (523)

         aw(:) = & ! a
            [1.9617012655046446e-05_dp, 0.00011366648314194275_dp, 0.0003366953613831632_dp, &
             0.0008232767446361525_dp, 0.0018534020117487947_dp, 0.003961157009342624_dp, &
             0.008130525125759252_dp, 0.016130337156362747_dp, 0.03107118199767957_dp, &
             0.058315897326562505_dp, 0.10694701127707384_dp, 0.1921022453393694_dp, &
             0.33865429849344675_dp, 0.5869804811235751_dp, 1.0020822693327578_dp, &
             1.6885999894712855_dp, 2.8185608307430305_dp, 4.69733858956372_dp, &
             8.013124704005667_dp, &
             ! w
             5.140590766964981e-05_dp, 0.0001446769568848332_dp, 0.0003228319226838376_dp, &
             0.0006952849249727678_dp, 0.001450829346359788_dp, 0.0029232870179219717_dp, &
             0.005701277073926892_dp, 0.010802074024944673_dp, 0.01994968391747334_dp, &
             0.03601567362546221_dp, 0.06370987485784774_dp, 0.11065265677969342_dp, &
             0.18903424695638463_dp, 0.3182142226840104_dp, 0.5290090154686774_dp, &
             0.8717862474618457_dp, 1.4362235296767876_dp, 2.4207239620574272_dp, &
             4.553900677754615_dp]

      CASE (524)

         aw(:) = & ! a
            [1.6281405779463337e-05_dp, 9.512659178743429e-05_dp, 0.0002861985923491392_dp, &
             0.0007131714186454165_dp, 0.0016348973811832423_dp, 0.0035503274738605136_dp, &
             0.007388507606706449_dp, 0.014835060986634086_dp, 0.02887837687796663_dp, &
             0.05470782386444532_dp, 0.10116907248925192_dp, 0.18309132265540146_dp, &
             0.3249694333826912_dp, 0.5667572812430093_dp, 0.9730460419880588_dp, &
             1.6481813652257802_dp, 2.7641390095504597_dp, 4.626543550118046_dp, &
             7.923809500369194_dp, &
             ! w
             4.2740140642576924e-05_dp, 0.00012224141038606366_dp, 0.0002796057724806588_dp, &
             0.0006158240808728694_dp, 0.0013077327168002295_dp, 0.0026727197246771343_dp, &
             0.005275780482944472_dp, 0.010100895050296082_dp, 0.018827103769685136_dp, &
             0.034268394430410846_dp, 0.06106598978688563_dp, 0.10676724019893825_dp, &
             0.18350025665191808_dp, 0.31060142549762465_dp, 0.5189443281390518_dp, &
             0.8590760280967278_dp, 1.4209723957768996_dp, 2.4032913239127405_dp, &
             4.534058816117401_dp]

      CASE (525)

         aw(:) = & ! a
            [1.2304945119076357e-05_dp, 7.292351774261556e-05_dp, 0.0002251311557808773_dp, &
             0.0005780322481414275_dp, 0.0013623090196823618_dp, 0.003029923325619632_dp, &
             0.006435733107169324_dp, 0.013151901958734974_dp, 0.02599874033747604_dp, &
             0.04992512436887561_dp, 0.09344589123353757_dp, 0.17095614759273242_dp, &
             0.30641511798921023_dp, 0.53917140896192_dp, 0.9332235610030336_dp, &
             1.592483956251792_dp, 2.6888412505984496_dp, 4.528273242726516_dp, &
             7.799533805537941_dp, &
             ! w
             3.239903959562625e-05_dp, 9.522129762770216e-05_dp, 0.00022655377517401506_dp, &
             0.0005161132502868733_dp, 0.0011248542380179888_dp, 0.0023478039849185945_dp, &
             0.00471730288797133_dp, 0.00917089202986637_dp, 0.017324380030818508_dp, &
             0.031910090895016896_dp, 0.05747098937553483_dp, 0.10144850017198352_dp, &
             0.17587851178903252_dp, 0.30005880675241453_dp, 0.5049381379035155_dp, &
             0.8413154749308983_dp, 1.3995955064041223_dp, 2.3788154334443536_dp, &
             4.506204424483072_dp]

      CASE (526)

         aw(:) = & ! a
            [9.158906924641075e-06_dp, 5.524761971790829e-05_dp, 0.00017585244309199227_dp, &
             0.000466802761859249_dp, 0.0011332274091289303_dp, 0.002584195953243527_dp, &
             0.005606011776588414_dp, 0.011664774554501928_dp, 0.02342205633786763_dp, &
             0.0455974819206607_dp, 0.08638774823864112_dp, 0.1597669501965131_dp, &
             0.2891702749993733_dp, 0.5133484804696632_dp, 0.8957077457524608_dp, &
             1.5397186886864043_dp, 2.6171682373404486_dp, 4.434376819763486_dp, &
             7.680456182068045_dp, &
             ! w
             2.4206493619596893e-05_dp, 7.354335277694569e-05_dp, 0.00018288288517215708_dp, &
             0.0004316998316850065_dp, 0.0009665545131583606_dp, 0.002061584008863792_dp, &
             0.004218111510571009_dp, 0.008329116753254096_dp, 0.015949150868050394_dp, &
             0.029730634518310185_dp, 0.05411931553202164_dp, 0.09645029113769904_dp, &
             0.16866451551898268_dp, 0.2900154622749679_dp, 0.49151866551395207_dp, &
             0.8242165544949457_dp, 1.378940088367101_dp, 2.3551182694931776_dp, &
             4.47924034669797_dp]

      CASE (527)

         aw(:) = & ! a
            [5.19029150262673e-06_dp, 3.2722110439752425e-05_dp, 0.00011160878348221042_dp, &
             0.0003172077653535399_dp, 0.0008154724337136965_dp, 0.0019488844868831275_dp, &
             0.0043954064518988666_dp, 0.009450834921083295_dp, 0.01951828044608681_dp, &
             0.038939339737308114_dp, 0.07537985113390941_dp, 0.14210327821060348_dp, &
             0.26164989903231645_dp, 0.47173646049880735_dp, 0.8347284889062151_dp, &
             1.4533004419994764_dp, 2.4990264931021193_dp, 4.278804468598045_dp, &
             7.4824156472824015_dp, &
             ! w
             1.3850204080335596e-05_dp, 4.5557645282158684e-05_dp, 0.0001241114216171513_dp, &
             0.00031337765278543686_dp, 0.0007376986503677276_dp, 0.0016376059312250481_dp, &
             0.003463555865930534_dp, 0.0070344574635327955_dp, 0.01380170555938623_dp, &
             0.026281356728176226_dp, 0.048750784417235085_dp, 0.08835746236989919_dp, &
             0.15686948805103113_dp, 0.27344954854889764_dp, 0.4692113290431111_dp, &
             0.7956056213247642_dp, 1.344206602536058_dp, 2.315160397334174_dp, &
             4.433781938609984_dp]

      CASE (528)

         aw(:) = & ! a
            [2.4924753233952614e-06_dp, 1.7118437447398564e-05_dp, 6.516270735243685e-05_dp, &
             0.0002032636733439574_dp, 0.0005616807883809547_dp, 0.001420778879204668_dp, &
             0.0033548614120475057_dp, 0.007493225943974826_dp, 0.015981492754211193_dp, &
             0.03277820330635238_dp, 0.06500272830332274_dp, 0.1251758373959574_dp, &
             0.23488816490635614_dp, 0.4307410628645935_dp, 0.7739549761250911_dp, &
             1.3663002690697095_dp, 2.3790690886567667_dp, 4.119759472952184_dp, &
             7.278942730043317_dp, &
             ! w
             6.786237192393222e-06_dp, 2.5684800488837132e-05_dp, 7.925374861155672e-05_dp, &
             0.0002174473475364847_dp, 0.0005438316508360725_dp, 0.0012659212987209333_dp, &
             0.0027830814293904353_dp, 0.005838471763570109_dp, 0.011776140410452742_dp, &
             0.022967732148922337_dp, 0.04350890268529781_dp, 0.08033985421409949_dp, &
             0.14503045836283687_dp, 0.2566258897659328_dp, 0.44632127494860924_dp, &
             0.765989503933193_dp, 1.3080142097696057_dp, 2.273370132073467_dp, &
             4.386247620457227_dp]

      CASE (529)

         aw(:) = & ! a
            [1.461966158609154e-06_dp, 1.1009731789564298e-05_dp, 4.5966283009810174e-05_dp, &
             0.0001534333044003547_dp, 0.0004453845157919598_dp, 0.0011695487715724902_dp, &
             0.0028445380837141933_dp, 0.006508520878403069_dp, 0.014163900032884008_dp, &
             0.02955307040462143_dp, 0.05948293544966251_dp, 0.11604421244170511_dp, &
             0.22027071499953227_dp, 0.40810100520469544_dp, 0.7400641860587582_dp, &
             1.3173712465885603_dp, 2.311120758915002_dp, 4.029155795065795_dp, &
             7.1625487254662_dp, &
             ! w
             4.079288005747578e-06_dp, 1.7642043099409914e-05_dp, 5.9574366010494085e-05_dp, &
             0.00017290493733516016_dp, 0.0004501462629445721_dp, 0.0010806618462506246_dp, &
             0.0024352436170679346_dp, 0.005214027218554562_dp, 0.01069918530764597_dp, &
             0.021177905946895486_dp, 0.04063792846934924_dp, 0.0758940798066644_dp, &
             0.1383929029311083_dp, 0.2471003408735595_dp, 0.4332479762560413_dp, &
             0.7489502885386315_dp, 1.2870753808887139_dp, 2.24911704847337_dp, &
             4.3586640362079185_dp]

      CASE (530)

         aw(:) = & ! a
            [8.859033513429025e-07_dp, 7.508053265009177e-06_dp, 3.4393231054237084e-05_dp, &
             0.00012201111318451792_dp, 0.00036947521089982025_dp, 0.001001122074039284_dp, &
             0.0024950331420367337_dp, 0.005822213888380374_dp, 0.012878358226281203_dp, &
             0.027243245295628875_dp, 0.055486604657474896_dp, 0.10936998327513861_dp, &
             0.20949745442067044_dp, 0.391291572322708_dp, 0.7147376255535827_dp, &
             1.2805996944375402_dp, 2.2598121231113746_dp, 3.9604803768674763_dp, &
             7.074082625656915_dp, &
             ! w
             2.563433245112962e-06_dp, 1.2875251273252788e-05_dp, 4.712950891677713e-05_dp, &
             0.000143579483008374_dp, 0.00038670724802844064_dp, 0.0009524678071029245_dp, &
             0.0021903022479781557_dp, 0.004767854649246107_dp, 0.009920104105446772_dp, &
             0.019869199452744225_dp, 0.03851893740706719_dp, 0.07258546456730267_dp, &
             0.1334165417375979_dp, 0.23991165744593146_dp, 0.42332462958913447_dp, &
             0.735953170908337_dp, 1.271044215651141_dp, 2.2305093221643633_dp, &
             4.337502149389349_dp]

      CASE (531)

         aw(:) = & ! a
            [6.771039542043292e-07_dp, 6.208318576240484e-06_dp, 2.9915017861882194e-05_dp, &
             0.0001094455076719625_dp, 0.0003383807820201672_dp, 0.0009308638879072167_dp, &
             0.00234713732657807_dp, 0.005528400690381031_dp, 0.012322654695363946_dp, &
             0.02623653999163814_dp, 0.05373250263226416_dp, 0.10642239085323879_dp, &
             0.20471380756311588_dp, 0.3837920823769138_dp, 0.7033908654656422_dp, &
             1.2640654304722831_dp, 2.2366706297925742_dp, 3.9294306889669364_dp, &
             7.034014847750328_dp, &
             ! w
             2.013522758229603e-06_dp, 1.1052967741072955e-05_dp, 4.21425407948508e-05_dp, &
             0.0001315016317352101_dp, 0.0003600774846699093_dp, 0.0008978682399497888_dp, &
             0.0020847573739226377_dp, 0.004573742829347724_dp, 0.009578393916507038_dp, &
             0.01929117118474441_dp, 0.03757731005632088_dp, 0.07110729012854762_dp, &
             0.1311826603475626_dp, 0.2366709672585805_dp, 0.4188344496775948_dp, &
             0.7300536173037036_dp, 1.2637500246407039_dp, 2.2220312818465495_dp, &
             4.32786062713236_dp]

      CASE (532)

         aw(:) = & ! a
            [5.68819045552737e-07_dp, 5.52351190658554e-06_dp, 2.749772742682204e-05_dp, &
             0.00010254187781768126_dp, 0.0003210816966437369_dp, 0.0008914085768859882_dp, &
             0.002263472522695641_dp, 0.005361204135596198_dp, 0.012004872256967385_dp, &
             0.025658455071349475_dp, 0.052721638878488616_dp, 0.1047184624992845_dp, &
             0.2019409791059891_dp, 0.37943461536749024_dp, 0.6967841385672375_dp, &
             1.2544206868495094_dp, 2.2231510458066617_dp, 3.9112689194008645_dp, &
             7.010557546281332_dp, &
             ! w
             1.728185389568122e-06_dp, 1.0075359372946279e-05_dp, 3.93997461739934e-05_dp, &
             0.00012476452050813863_dp, 0.0003450770099333706_dp, 0.0008668826924992558_dp, &
             0.0020245037333139794_dp, 0.004462386003686064_dp, 0.0093815566476513_dp, &
             0.01895703067376839_dp, 0.03703131170034896_dp, 0.07024785897794121_dp, &
             0.1298807355865842_dp, 0.23477824454275165_dp, 0.4162070570365943_dp, &
             0.72659608006411_dp, 1.2594699836156429_dp, 2.2170531791959536_dp, &
             4.322199408665857_dp]

      CASE (533)

         aw(:) = & ! a
            [5.036035637541466e-07_dp, 5.106227651566605e-06_dp, 2.6000730005218392e-05_dp, &
             9.821804965444753e-05_dp, 0.00031016127134223345_dp, 0.0008663553783451762_dp, &
             0.0022101049299463457_dp, 0.0052541616950661585_dp, 0.011800802792244033_dp, &
             0.025286274265090457_dp, 0.052069394216198474_dp, 0.10361692663814434_dp, &
             0.20014543357163195_dp, 0.37660878507469897_dp, 0.6924941226232905_dp, &
             1.2481509488714801_dp, 2.214354116476969_dp, 3.8994425712422096_dp, &
             6.9952746811971185_dp, &
             ! w
             1.5562488693691335e-06_dp, 9.472207387093138e-06_dp, 3.768077541188872e-05_dp, &
             0.00012050482291113932_dp, 0.00033553438555474543_dp, 0.0008470794934041222_dp, &
             0.001985852897771394_dp, 0.004390737661777333_dp, 0.009254586794852051_dp, &
             0.018741023985196545_dp, 0.03667768083340908_dp, 0.06969029922765917_dp, &
             0.12903486163065656_dp, 0.2335469142232332_dp, 0.4144958151279039_dp, &
             0.724341970728508_dp, 1.2566775844427207_dp, 2.2138039788911006_dp, &
             4.318504359669525_dp]

      CASE (534)

         aw(:) = & ! a
            [4.339896887672607e-07_dp, 4.65564005221034e-06_dp, 2.436047208357923e-05_dp, &
             9.343355300147844e-05_dp, 0.0002979947693769855_dp, 0.0008383028157196583_dp, &
             0.0021501146036319338_dp, 0.005133457452291181_dp, 0.011570090523687961_dp, &
             0.024864581040360018_dp, 0.05132899232074033_dp, 0.10236447152028563_dp, &
             0.19810097526676756_dp, 0.37338718612642047_dp, 0.6875978968353142_dp, &
             1.2409884314500514_dp, 2.2042964890581773_dp, 3.885912770448123_dp, &
             6.977782469133344_dp, &
             ! w
             1.3725865537365244e-06_dp, 8.813403577432947e-06_dp, 3.57776170575683e-05_dp, &
             0.00011575276862931395_dp, 0.0003248326583234597_dp, 0.0008247824253947033_dp, &
             0.0019421971881413143_dp, 0.004309602390337023_dp, 0.009110492925937144_dp, &
             0.01849543001121996_dp, 0.036274963433171103_dp, 0.06905444676841588_dp, &
             0.12806899965551122_dp, 0.23213935259497862_dp, 0.41253774119811615_dp, &
             0.7217605914897661_dp, 1.2534777451029218_dp, 2.2100793483284416_dp, &
             4.314268659532059_dp]

      CASE (535)

         aw(:) = & ! a
            [4.0740554113376073e-07_dp, 4.481870010855176e-06_dp, 2.3720531008039338e-05_dp, &
             9.155264818763086e-05_dp, 0.0002931868035281797_dp, 0.0008271744153249903_dp, &
             0.002126245940334511_dp, 0.0050853179281050084_dp, 0.011477896732699876_dp, &
             0.024695791449217387_dp, 0.05103221437097328_dp, 0.10186182915129238_dp, &
             0.1972796019132273_dp, 0.37209167052453734_dp, 0.6856273280530193_dp, &
             1.2381036862280144_dp, 2.2002432689570703_dp, 3.8804576345416524_dp, &
             6.970727248623774_dp, &
             ! w
             1.3023957441521602e-06_dp, 8.556972572385258e-06_dp, 3.5029131851504276e-05_dp, &
             0.00011387299161161442_dp, 0.00032058234018585044_dp, 0.0008159000869000376_dp, &
             0.0019247647814086837_dp, 0.004277140486126056_dp, 0.009052746988393966_dp, &
             0.0183968695537645_dp, 0.036113150525904275_dp, 0.06879868763860304_dp, &
             0.127680134900435_dp, 0.23157218079563613_dp, 0.4117481601944227_dp, &
             0.7207190146581787_dp, 1.2521859976389873_dp, 2.2085753256603984_dp, &
             4.312558258635529_dp]

      CASE (536)

         aw(:) = & ! a
            [0.004241772553326922_dp, 0.02253863119170212_dp, 0.056252654578538085_dp, &
             0.10686297889578697_dp, 0.1767480303461968_dp, 0.26949675659200595_dp, &
             0.3903413741971059_dp, 0.5467141952811087_dp, 0.7489117852179463_dp, &
             1.0108647945710778_dp, 1.3510691399479386_dp, 1.793807628117466_dp, &
             2.370861271523886_dp, 3.1240180104942112_dp, 4.108948832501714_dp, &
             5.401688717441938_dp, 7.110753186116057_dp, 9.403471755301473_dp, &
             12.577053574970028_dp, 17.340642837706508_dp, &
             ! w
             0.010907089591214697_dp, 0.025821555710638135_dp, 0.04184928755405365_dp, &
             0.05976267618514956_dp, 0.08059837177459536_dp, 0.10576178276629854_dp, &
             0.13715507702276258_dp, 0.17729395534104633_dp, 0.22940779422008004_dp, &
             0.29756098082666815_dp, 0.3868670008889286_dp, 0.5038662196520325_dp, &
             0.6571437130474139_dp, 0.8583463758021642_dp, 1.1240021612615954_dp, &
             1.4791765085968618_dp, 1.9658740246659219_dp, 2.6659270101860626_dp, &
             3.782037265499978_dp, 6.118868095133639_dp]

      CASE (537)

         aw(:) = & ! a
            [0.0037488236103774817_dp, 0.019930293094675297_dp, 0.04979367932847378_dp, &
             0.09474082604624894_dp, 0.15704128191906463_dp, 0.24014528833308854_dp, &
             0.3491180664641332_dp, 0.49119352491964474_dp, 0.6764290683010313_dp, &
             0.9184668186510055_dp, 1.2354696723048324_dp, 1.6513682763417639_dp, &
             2.1976141031064995_dp, 2.9157364131133_dp, 3.861262156315753_dp, &
             5.110222459112411_dp, 6.77125238546136_dp, 9.0118118124226_dp, &
             12.128876175292088_dp, 16.82945136817126_dp, &
             ! w
             0.009640765748083391_dp, 0.022848814032431896_dp, 0.03710791484432057_dp, &
             0.053159507527788_dp, 0.07200919439511491_dp, 0.09503373260213062_dp, &
             0.12410655429508652_dp, 0.16170807287053018_dp, 0.2110214333163202_dp, &
             0.2760608847838723_dp, 0.3619046982414856_dp, 0.47509300165250873_dp, &
             0.6242574247591812_dp, 0.8211393223377071_dp, 1.082398587279776_dp, &
             1.4332424319088186_dp, 1.9157658348468556_dp, 2.6116952045089157_dp, &
             3.722973616876625_dp, 6.050192571793496_dp]

      CASE (538)

         aw(:) = & ! a
            [0.003366711683945265_dp, 0.01790770400246352_dp, 0.044781949092794454_dp, &
             0.0853260304433367_dp, 0.141716925654248_dp, 0.21728571203971078_dp, &
             0.316951657717353_dp, 0.44777110422795546_dp, 0.6195826682748403_dp, &
             0.8457617284670842_dp, 1.144163390200643_dp, 1.538393878511835_dp, &
             2.059600705991394_dp, 2.749071598154428_dp, 3.6621932897973233_dp, &
             4.874982879934231_dp, 6.496177865342313_dp, 8.693366989786185_dp, &
             11.76337124369219_dp, 16.41148115443289_dp, &
             ! w
             0.008659086358856514_dp, 0.020542642029852693_dp, 0.03342496579440091_dp, &
             0.04802087594522252_dp, 0.06530883702481378_dp, 0.0866394015413651_dp, &
             0.11385780643252849_dp, 0.14940847567110874_dp, 0.19642850913376267_dp, &
             0.25888470832290356_dp, 0.3418237825042459_dp, 0.45178630917617296_dp, &
             0.5974451909198462_dp, 0.7906248922759673_dp, 1.0481026458644116_dp, &
             1.3952152791208259_dp, 1.8741487865464226_dp, 2.5665602251435766_dp, &
             3.673781879670697_dp, 5.993048686887826_dp]

      CASE (539)

         aw(:) = & ! a
            [0.0030610352418640446_dp, 0.016289177186963568_dp, 0.040769082545252106_dp, &
             0.07778121534986662_dp, 0.1294224655903178_dp, 0.19891986790782226_dp, &
             0.29106335536902744_dp, 0.4127488785997983_dp, 0.5736143080480764_dp, &
             0.7867888460422182_dp, 1.0698439857964348_dp, 1.4460876939879321_dp, &
             1.946387359192112_dp, 2.6118055197376453_dp, 3.4975936449624725_dp, &
             4.67974761147643_dp, 6.267092973678195_dp, 8.427342184767177_dp, &
             11.457213472814704_dp, 16.06058220891612_dp, &
             ! w
             0.007873717027041583_dp, 0.018696448865385552_dp, 0.03047316116125044_dp, &
             0.04389542682419414_dp, 0.05991766909579364_dp, 0.07986634142466169_dp, &
             0.10555939472911423_dp, 0.13940569332571925_dp, 0.1844978629111232_dp, &
             0.2447586471699034_dp, 0.3252065290407138_dp, 0.43238268938229696_dp, &
             0.5749963524427604_dp, 0.7649452820216595_dp, 1.0191115839910416_dp, &
             1.3629507887370282_dp, 1.8387382016027254_dp, 2.5280860401426817_dp, &
             3.6318216968458192_dp, 5.944342632641489_dp]

      CASE (540)

         aw(:) = & ! a
            [0.002810436815627241_dp, 0.014961887863999799_dp, 0.03747651589044989_dp, &
             0.07158581140689843_dp, 0.11931639930252208_dp, 0.18380327975121988_dp, &
             0.26972048155186484_dp, 0.3838179390096638_dp, 0.5355486564059357_dp, &
             0.7378144249753411_dp, 1.0079252585553353_dp, 1.3689145349419942_dp, &
             1.8513909726764064_dp, 2.4962069757188354_dp, 3.3584842422582812_dp, &
             4.514192584071912_dp, 6.072233996634713_dp, 8.200438614882817_dp, &
             11.195457749923326_dp, 15.759975208198068_dp, &
             ! w
             0.007229813962328594_dp, 0.017181904981950723_dp, 0.0280490206203563_dp, &
             0.040502182119883684_dp, 0.05547427727826987_dp, 0.07426947848061351_dp, &
             0.09867951729362494_dp, 0.13107871029321663_dp, 0.1745173777820914_dp, &
             0.23287765125272755_dp, 0.3111526534957363_dp, 0.41588403717792344_dp, &
             0.5558129803400383_dp, 0.7429022864397854_dp, 0.9941284651201723_dp, &
             1.3350562364091412_dp, 1.808047525332381_dp, 2.4946869354115937_dp, &
             3.595376226505887_dp, 5.902068778258447_dp]

      CASE (541)

         aw(:) = & ! a
            [0.0015934091103306748_dp, 0.008509049468496795_dp, 0.02143813248916623_dp, &
             0.04132179241341644_dp, 0.06976208604731934_dp, 0.10932110468507521_dp, &
             0.16391894913083357_dp, 0.2393122305717882_dp, 0.343666004319766_dp, &
             0.48829689150562916_dp, 0.6887039382594222_dp, 0.9660147447332132_dp, &
             1.3490093267327685_dp, 1.8769921238144998_dp, 2.6040387411362604_dp, &
             3.6057691428697556_dp, 4.991494853262373_dp, 6.929917169042379_dp, &
             9.717722394528794_dp, 14.051261273391312_dp, &
             ! w
             0.00410193054094625_dp, 0.009809035790519609_dp, 0.01620265422744076_dp, &
             0.023826697381147642_dp, 0.03347420139913778_dp, 0.046289223081208496_dp, &
             0.06385657144849423_dp, 0.08827874183675773_dp, 0.12229802015324023_dp, &
             0.16952318533991945_dp, 0.2347790375469691_dp, 0.3245925111476496_dp, &
             0.44787902068913005_dp, 0.616992015749277_dp, 0.8495175968623115_dp, &
             1.1717832983682304_dp, 1.6268516930985548_dp, 2.2963863207527395_dp, &
             3.37853613531568_dp, 5.651133287053622_dp]

      CASE (542)

         aw(:) = & ! a
            [0.0011390449921040572_dp, 0.0060955201406988_dp, 0.015419250308827093_dp, &
             0.02990826519226592_dp, 0.05094935194943481_dp, 0.08080106924314619_dp, &
             0.1229612992811983_dp, 0.18260687338320566_dp, 0.26714281943879_dp, &
             0.38695596655717285_dp, 0.5564845870412083_dp, 0.7957234718437416_dp, &
             1.132328903295979_dp, 1.6046003100378334_dp, 2.2658640492658004_dp, &
             3.191389682165693_dp, 4.490627547122133_dp, 6.332813436815695_dp, &
             9.014943119477653_dp, 13.230670944948036_dp, &
             ! w
             0.0029336693857008778_dp, 0.007045155559718517_dp, 0.011732149752537013_dp, &
             0.017472271568595172_dp, 0.024980140626674693_dp, 0.035299034077060434_dp, &
             0.04987532809486311_dp, 0.0706377004364661_dp, 0.10014776931950316_dp, &
             0.14186018661282754_dp, 0.20049505044558505_dp, 0.282543540531873_dp, &
             0.3969798598412203_dp, 0.55634100754055_dp, 0.7785426625143363_dp, &
             1.0903727561666794_dp, 1.5353838262114279_dp, 2.1954643644645224_dp, &
             3.267829696349966_dp, 5.523411180505148_dp]

      CASE (543)

         aw(:) = & ! a
            [0.000896430353358387_dp, 0.004805119176955691_dp, 0.012193651558632754_dp, &
             0.023770227053445305_dp, 0.04078388271252856_dp, 0.06529332852670133_dp, &
             0.10051033124932444_dp, 0.15121365150247307_dp, 0.22428734299024927_dp, &
             0.32948247592091867_dp, 0.48050771905089906_dp, 0.6965665705233484_dp, &
             1.0045115922971968_dp, 1.4418995293281531_dp, 2.061474082778248_dp, &
             2.938193998409961_dp, 4.1815556890979115_dp, 5.961164867318764_dp, &
             8.574326896911181_dp, 12.71314678078166_dp, &
             ! w
             0.0023096719274510653_dp, 0.005565099697046422_dp, 0.00932697130056929_dp, &
             0.014029831490400173_dp, 0.02033483456646612_dp, 0.029212591178159775_dp, &
             0.04200916174497004_dp, 0.06053237096664171_dp, 0.0872222769826313_dp, &
             0.12542753127673448_dp, 0.17978826736121206_dp, 0.2567550853442525_dp, &
             0.3653220398036224_dp, 0.5181328291292073_dp, 0.7333190532368281_dp, &
             1.0379927221561274_dp, 1.4760781532543799_dp, 2.1296885906061567_dp, &
             3.19552335247835_dp, 5.440133455439082_dp]

      CASE (544)

         aw(:) = & ! a
            [0.0007439418581085582_dp, 0.0039932450657249995_dp, 0.01016041215644215_dp, &
             0.01989032315884935_dp, 0.0343334526398138_dp, 0.05540249311027042_dp, &
             0.08609649749456823_dp, 0.13089688630363036_dp, 0.19629951199337_dp, &
             0.29158147617537883_dp, 0.4299035699271377_dp, 0.6298673381976871_dp, &
             0.9177032441082223_dp, 1.3303801631760857_dp, 1.9201651329774694_dp, &
             2.7617427757686337_dp, 3.964614476648414_dp, 5.698662188893201_dp, &
             8.261471019071442_dp, 12.34412488855432_dp, &
             ! w
             0.001917383127252153_dp, 0.004632732016633214_dp, 0.007806163909567718_dp, &
             0.01184107613662278_dp, 0.017358546055447416_dp, 0.02527294887811247_dp, &
             0.03685334833110203_dp, 0.05381752047687813_dp, 0.07851580781114899_dp, &
             0.11421603606997456_dp, 0.1654925894048662_dp, 0.23875601493646906_dp, &
             0.3430036016845556_dp, 0.4909482023914976_dp, 0.7008773996077388_dp, &
             1.000150454248501_dp, 1.4329899005282858_dp, 2.08171532337389_dp, &
             3.1427009603970153_dp, 5.379366047067225_dp]

      CASE (545)

         aw(:) = & ! a
            [0.0006385690974850548_dp, 0.0034317403777428604_dp, 0.00875196804462231_dp, &
             0.017196311234527913_dp, 0.029839877029217036_dp, 0.04848187410129415_dp, &
             0.07595415290631778_dp, 0.11650406456540177_dp, 0.17632240507939068_dp, &
             0.26431308457328057_dp, 0.39320244745486965_dp, 0.5811095604063918_dp, &
             0.853759528622832_dp, 1.2476356308222163_dp, 1.8146016852789122_dp, &
             2.629098453882577_dp, 3.8006115297650886_dp, 5.499239639730987_dp, &
             8.022817145154024_dp, 12.061699046719113_dp, &
             ! w
             0.0016462492734708235_dp, 0.003987211222706093_dp, 0.006749927848474149_dp, &
             0.010313786046778031_dp, 0.015268078039520693_dp, 0.022481702890543482_dp, &
             0.03316218958817866_dp, 0.04895682507679239_dp, 0.07214562675632333_dp, &
             0.1059310341581058_dp, 0.15483131157096713_dp, 0.2252190529196926_dp, &
             0.32608670198114226_dp, 0.4701949338490822_dp, 0.6759509282977448_dp, &
             0.9709121995668761_dp, 1.3995495469103152_dp, 2.0443694768055507_dp, &
             3.1015254823222613_dp, 5.332037723557218_dp]

      CASE (546)

         aw(:) = & ! a
            [0.0005610725711432293_dp, 0.0030184719671453096_dp, 0.007713921315130133_dp, &
             0.015206663999710929_dp, 0.026511569454176265_dp, 0.043335950204500394_dp, &
             0.06837521035458008_dp, 0.10568566283565914_dp, 0.16120938549632083_dp, &
             0.24354520431861942_dp, 0.36506197351819525_dp, 0.5434781501498771_dp, &
             0.8040946723737953_dp, 1.182981838612351_dp, 1.7316542057370126_dp, &
             2.524333383016714_dp, 3.6704779200261983_dp, 5.340362657551184_dp, &
             7.832044678316398_dp, 11.835330483075156_dp, &
             ! w
             0.0014468089890773762_dp, 0.0035116704407315387_dp, 0.005969689339056726_dp, &
             0.00918093559184832_dp, 0.01370852778480848_dp, 0.02038345914096959_dp, &
             0.03036259649524996_dp, 0.045236019613996474_dp, 0.06722629097370483_dp, &
             0.09948092471425347_dp, 0.14646915175447675_dp, 0.21452807430388857_dp, &
             0.3126410766661178_dp, 0.4536033319935106_dp, 0.6559174963072968_dp, &
             0.9473055307348146_dp, 1.3724504245122913_dp, 2.0140282495547255_dp, &
             3.0680352452904605_dp, 5.293568706378472_dp]

      CASE (547)

         aw(:) = & ! a
            [0.0005015028829405916_dp, 0.0027005909930681474_dp, 0.006914486955199627_dp, &
             0.01367152910902928_dp, 0.023936894632908164_dp, 0.039341265669578386_dp, &
             0.06246564620060502_dp, 0.09720625003680655_dp, 0.14929680764893682_dp, &
             0.2270798198518985_dp, 0.3426219915469064_dp, 0.513300567195081_dp, &
             0.7640519475501053_dp, 1.130587662424983_dp, 1.664114344190769_dp, &
             2.438654789416963_dp, 3.563634197053104_dp, 5.209474209237955_dp, &
             7.674432292794263_dp, 11.647886503479498_dp, &
             ! w
             0.001293480478970173_dp, 0.003145591393180043_dp, 0.005367581432016754_dp, &
             0.008303496086809293_dp, 0.012494314976958765_dp, 0.01873872475063063_dp, &
             0.028150920427841508_dp, 0.04227326683064738_dp, 0.06327996456401508_dp, &
             0.09427117790892246_dp, 0.13967258345880318_dp, 0.20578820712319962_dp, &
             0.30159011010787845_dp, 0.43989907236368175_dp, 0.6392962249306502_dp, &
             0.9276433398220163_dp, 1.3498083621591483_dp, 1.9886219964371001_dp, &
             3.0399647857026815_dp, 5.261342694789207_dp]

      CASE (548)

         aw(:) = & ! a
            [0.0004541767980519825_dp, 0.002447893212537064_dp, 0.006278273148409975_dp, &
             0.012447764284239307_dp, 0.021879565191843225_dp, 0.03613903396558967_dp, &
             0.05770927188182987_dp, 0.0903495739014426_dp, 0.1396154853300277_dp, &
             0.21362961592784094_dp, 0.32419806433545034_dp, 0.48840180253933013_dp, &
             0.7308582772942873_dp, 1.086962252899046_dp, 1.6076451348571192_dp, &
             2.366747876877618_dp, 3.4736587933681657_dp, 5.098924335828885_dp, &
             7.540983597428812_dp, 11.488870490534087_dp, &
             ! w
             0.001171649233791555_dp, 0.002854363744491754_dp, 0.004887525207822211_dp, &
             0.0076015761052112005_dp, 0.011518388693923184_dp, 0.017408639729659964_dp, &
             0.026349928628182206_dp, 0.039843964094377245_dp, 0.06002331710036192_dp, &
             0.0899465532002833_dp, 0.13400017629258867_dp, 0.19845737327731705_dp, &
             0.2922776803300323_dp, 0.4283012619476658_dp, 0.6251751945622182_dp, &
             0.9108823666733669_dp, 1.3304544089975425_dp, 1.9668638852113633_dp, &
             3.0159043047515124_dp, 5.233732854758063_dp]

      CASE (549)

         aw(:) = & ! a
            [0.00041560272898321613_dp, 0.002241813192412507_dp, 0.005758898463407207_dp, &
             0.011447193138584475_dp, 0.020193770835598295_dp, 0.03350733934525363_dp, &
             0.05378585498474616_dp, 0.08466962315807926_dp, 0.13155928186988688_dp, &
             0.2023856910924211_dp, 0.30872657532736725_dp, 0.4674017464982133_dp, &
             0.7027456289571763_dp, 1.0498697079903423_dp, 1.559456679494127_dp, &
             2.305180002998289_dp, 3.3963892157202724_dp, 5.0037385567561214_dp, &
             7.425832889926019_dp, 11.351423637829141_dp, &
             ! w
             0.001072335584192338_dp, 0.0026167011819126502_dp, 0.004494970236155722_dp, &
             0.00702582820415164_dp, 0.01071439556145332_dp, 0.016306731243294847_dp, &
             0.024848587534049695_dp, 0.037806435462356625_dp, 0.057276384992356724_dp, &
             0.08627992469107162_dp, 0.12916797666084973_dp, 0.19218491545905134_dp, &
             0.28427715878659077_dp, 0.4182997388385609_dp, 0.6129561237291932_dp, &
             0.8963356883659791_dp, 1.313616686843964_dp, 1.9479025693636614_dp, &
             2.9949203773370825_dp, 5.209662761405782_dp]

      CASE (550)

         aw(:) = & ! a
            [0.00023138954565206143_dp, 0.0012557354836193616_dp, 0.003264674188789077_dp, &
             0.006615259390547789_dp, 0.011987718051028634_dp, 0.020558775484834778_dp, &
             0.03422479630665998_dp, 0.05592679003656871_dp, 0.09015105663108257_dp, &
             0.14368197637518992_dp, 0.22670752132903546_dp, 0.3544262626829793_dp, &
             0.5493766307654294_dp, 0.8448259409096455_dp, 1.2897823199991467_dp, &
             1.9567226023270095_dp, 2.954615621729697_dp, 4.454728654494038_dp, &
             6.75680531467233_dp, 10.548255884539723_dp, &
             ! w
             0.0005978419885949287_dp, 0.0014767718631817715_dp, 0.002598448344073917_dp, &
             0.004213188499592838_dp, 0.006724277304707164_dp, 0.010728665934929072_dp, &
             0.01708536858417583_dp, 0.02705401971171137_dp, 0.04250716462384939_dp, &
             0.06622639694306004_dp, 0.10231973475161851_dp, 0.15681891336454068_dp, &
             0.23854515401437476_dp, 0.36039785241191397_dp, 0.5413913490296749_dp, &
             0.8102669926540256_dp, 1.2131602744747734_dp, 1.8341101331108358_dp, &
             2.8686436013263883_dp, 5.064992123138682_dp]

      CASE (551)

         aw(:) = & ! a
            [0.00016410687347897756_dp, 0.0008943560944810265_dp, 0.0023447971546885437_dp, &
             0.00481575108056489_dp, 0.00888843116175323_dp, 0.015576509779991123_dp, &
             0.02652969704976162_dp, 0.044345403227743795_dp, 0.0730554063217297_dp, &
             0.118861997867758_dp, 0.191229739550222_dp, 0.3044906682984813_dp, &
             0.48019573446875213_dp, 0.750565238695917_dp, 1.163617043503107_dp, &
             1.7910716090620555_dp, 2.7415868113584296_dp, 4.18670920782827_dp, &
             6.4268615884660525_dp, 10.149012221330613_dp, &
             ! w
             0.0004244010974768446_dp, 0.0010572758982993402_dp, 0.0018917249558589985_dp, &
             0.0031445443054133513_dp, 0.005166527520630457_dp, 0.008479543782697985_dp, &
             0.013851786363182749_dp, 0.022439566003445564_dp, 0.035996327160287896_dp, &
             0.05716806795048214_dp, 0.08991770235316487_dp, 0.14013975784179847_dp, &
             0.21655728802956828_dp, 0.33205806317432546_dp, 0.5057921887798438_dp, &
             0.7668399326093335_dp, 1.1618799561175959_dp, 1.775539474385565_dp, &
             2.8033893736182858_dp, 4.990346897743811_dp]

      CASE (552)

         aw(:) = & ! a
            [0.0001285687160662041_dp, 0.0007030265145218757_dp, 0.0018556066468578645_dp, &
             0.0038520805744970844_dp, 0.007211906522971537_dp, 0.012846033073725241_dp, &
             0.022249041166251503_dp, 0.0378016757009909_dp, 0.06324608416940793_dp, &
             0.10440835102683746_dp, 0.1702784124967893_dp, 0.2746109811926541_dp, &
             0.43828839519493173_dp, 0.6928091186450619_dp, 1.0854928248814808_dp, &
             1.6875078196578601_dp, 2.607259000024923_dp, 4.0164561880298075_dp, &
             6.215999416155189_dp, 9.892663886988673_dp, &
             ! w
             0.00033274122489221656_dp, 0.0008345346294245275_dp, 0.00151314890244546_dp, &
             0.0025641220402895077_dp, 0.004304308656322565_dp, 0.007208139365701322_dp, &
             0.011986914291511_dp, 0.01973026005032079_dp, 0.03211195340172582_dp, &
             0.05168477847723007_dp, 0.08230924705368046_dp, 0.12977945449930747_dp, &
             0.20274072172405352_dp, 0.3140586398153147_dp, 0.48296069776984113_dp, &
             0.7387477919649796_dp, 1.1284719744874216_dp, 1.7371875880089804_dp, &
             2.760554454781633_dp, 4.94138714425316_dp]

      CASE (553)

         aw(:) = & ! a
            [0.00010638513337661713_dp, 0.0005833704497286544_dp, 0.0015485833354592_dp, &
             0.003243857779284663_dp, 0.006145151631333021_dp, 0.011090719399673434_dp, &
             0.019465510810252128_dp, 0.03349659199969773_dp, 0.056718875461408656_dp, &
             0.09468643752912093_dp, 0.15604237902086526_dp, 0.2541149900337321_dp, &
             0.40928721170803795_dp, 0.6525116370013598_dp, 1.0305718769518786_dp, &
             1.614202496363769_dp, 2.511596469919324_dp, 3.8945710669852747_dp, &
             6.064390848408057_dp, 9.707739662116053_dp, &
             ! w
             0.0002755007456293087_dp, 0.0006949144419033539_dp, 0.001274169153691706_dp, &
             0.002193630728460829_dp, 0.0037457419701558727_dp, 0.006371425385050147_dp, &
             0.010741743538383912_dp, 0.017897978924549002_dp, 0.02945482683025403_dp, &
             0.04789478310608085_dp, 0.07699984237828225_dp, 0.12248529451509546_dp, &
             0.19293260035204676_dp, 0.3011832664673696_dp, 0.4665147559883756_dp, &
             0.7183877529337838_dp, 1.1041357993848417_dp, 1.7091472734101285_dp, &
             2.7291791887956056_dp, 4.905544722001163_dp]

      CASE (554)

         aw(:) = & ! a
            [9.11299266109851e-05_dp, 0.0005009551141945329_dp, 0.0013364798805110458_dp, &
             0.002821657430933893_dp, 0.005399551234210625_dp, 0.009853324512425465_dp, &
             0.01748490637696873_dp, 0.030404533385128128_dp, 0.05198841321460045_dp, &
             0.08758059860064037_dp, 0.14555419725765043_dp, 0.23890283571194187_dp, &
             0.38761418843942763_dp, 0.6222047474237472_dp, 0.9890249822958673_dp, &
             1.5584530834516235_dp, 2.438500055428932_dp, 3.801059007802197_dp, &
             5.947687483988444_dp, 9.565027952205712_dp, &
             ! w
             0.00023612333676443841_dp, 0.0005985629681840805_dp, 0.0011082635962737625_dp, &
             0.0019339921633778057_dp, 0.003349486082006665_dp, 0.005770347649989956_dp, &
             0.00983706815425649_dp, 0.016553457676045477_dp, 0.02748768823260326_dp, &
             0.045066259082733595_dp, 0.07300785235072305_dp, 0.1169631532290535_dp, &
             0.18545960822716298_dp, 0.2913150984442548_dp, 0.4538418132150399_dp, &
             0.7026237141263744_dp, 1.0852185580301998_dp, 1.6872881704391611_dp, &
             2.704685059280989_dp, 4.877573997791687_dp]

      CASE (555)

         aw(:) = & ! a
            [7.995132118180791e-05_dp, 0.00044048010027379365_dp, 0.0011804328722135864_dp, &
             0.0025097286666722054_dp, 0.004845367703405868_dp, 0.00892681999663504_dp, &
             0.015990188929398_dp, 0.028052723146404997_dp, 0.048363517911433784_dp, &
             0.0820972791919213_dp, 0.13740797572233093_dp, 0.22701582280163482_dp, &
             0.3705833787404193_dp, 0.598265757020446_dp, 0.9560512745983604_dp, &
             1.5140162498697851_dp, 2.3800124105653953_dp, 3.725988927950908_dp, &
             5.853747072378959_dp, 9.449915264805615_dp, &
             ! w
             0.00020725952314682136_dp, 0.0005277431684360765_dp, 0.000985682497105203_dp, &
             0.0017405679883607983_dp, 0.0030511858987081137_dp, 0.005313115155973688_dp, &
             0.009142495573192385_dp, 0.015512798367128966_dp, 0.025954084638724124_dp, &
             0.04284657521764742_dp, 0.06985613461186108_dp, 0.11257886286898659_dp, &
             0.17949549992255948_dp, 0.28340146512637426_dp, 0.44363426571246983_dp, &
             0.6898770636570903_dp, 1.0698728982917909_dp, 1.6695145014205042_dp, &
             2.6847452179286795_dp, 4.854810790543109_dp]

      CASE (556)

         aw(:) = & ! a
            [7.138319759578014e-05_dp, 0.00039407055741463057_dp, 0.0010603983810765622_dp, &
             0.002268877358945472_dp, 0.0044151612591759315_dp, 0.008202922843677896_dp, &
             0.014814330720832129_dp, 0.026190163148415824_dp, 0.0454744113356478_dp, &
             0.07770096275156518_dp, 0.13084055992928648_dp, 0.21738356683378604_dp, &
             0.35671768422829436_dp, 0.5786906301817148_dp, 0.9289803945008825_dp, &
             1.4774018721298756_dp, 2.3316652624744667_dp, 3.6637625466597186_dp, &
             5.77570286165078_dp, 9.354116581076887_dp, &
             ! w
             0.00018512990988537123_dp, 0.0004733136428774598_dp, 0.0008910302345945904_dp, &
             0.001590110314295655_dp, 0.0028170215892367894_dp, 0.004950980035778313_dp, &
             0.008588067479626081_dp, 0.014676426665476994_dp, 0.024714009713086252_dp, &
             0.04104177082339774_dp, 0.0672804167578405_dp, 0.10897889875029373_dp, &
             0.17457687560090157_dp, 0.2768486379035145_dp, 0.43515078112079053_dp, &
             0.6792487312638682_dp, 1.0570427273451812_dp, 1.6546249337670091_dp, &
             2.6680241617729963_dp, 4.8357267236022885_dp]

      CASE (557)

         aw(:) = & ! a
            [6.459190461722343e-05_dp, 0.00035724435900411127_dp, 0.0009649470914152303_dp, &
             0.0020766909397591077_dp, 0.004070207966574025_dp, 0.007619118305242462_dp, &
             0.013860295060617365_dp, 0.024670071758435087_dp, 0.04310343856843796_dp, &
             0.07407445849146964_dp, 0.12539723010997336_dp, 0.20936469832195895_dp, &
             0.3451273583100701_dp, 0.5622662571957021_dp, 0.906188494647872_dp, &
             1.4464787367027907_dp, 2.2907199059439574_dp, 3.610937461958469_dp, &
             5.709321201296618_dp, 9.272513232139142_dp, &
             ! w
             0.00016758500638978994_dp, 0.00043006514282330785_dp, 0.0008155017874436882_dp, &
             0.001469248097150156_dp, 0.002627386997774696_dp, 0.004655426682192709_dp, &
             0.008132509888542614_dp, 0.013985146277627593_dp, 0.023683660533506797_dp, &
             0.03953502236781608_dp, 0.06512060492073322_dp, 0.1059479409027388_dp, &
             0.17042006610748636_dp, 0.2712914564768583_dp, 0.42793345558814766_dp, &
             0.6701812710599258_dp, 1.046071187548854_dp, 1.641870595521293_dp, &
             2.653688472529268_dp, 4.819368382240202_dp]

      CASE (558)

         aw(:) = & ! a
            [5.90671705438591e-05_dp, 0.00032725560625953594_dp, 0.0008870654681564532_dp, &
             0.001919380669129223_dp, 0.0037865946804733056_dp, 0.0071366131501388996_dp, &
             0.013067530856092496_dp, 0.023400328296027062_dp, 0.04111322369837066_dp, &
             0.07101647927822646_dp, 0.12078794040720191_dp, 0.20254813669344618_dp, &
             0.3352395392683722_dp, 0.5482082740098587_dp, 0.8866215226553135_dp, &
             1.4198584985308402_dp, 2.2553865435031883_dp, 3.5652577795257527_dp, &
             5.651821361392682_dp, 9.201737270796274_dp, &
             ! w
             0.000153308858399679_dp, 0.0003948028739733491_dp, 0.0007536794802031423_dp, &
             0.0013697121315453817_dp, 0.0024700705801408646_dp, 0.004408554074507663_dp, &
             0.007749721299145884_dp, 0.01340127663813159_dp, 0.022809381067901244_dp, &
             0.03825113202338237_dp, 0.06327313847041809_dp, 0.10334606017832278_dp, &
             0.16683992578410292_dp, 0.2664906249918933_dp, 0.4216811064028229_dp, &
             0.6623068297126378_dp, 1.0365236624009746_dp, 1.6307550397909834_dp, &
             2.641185142411161_dp, 4.805103347322468_dp]

      CASE (559)

         aw(:) = & ! a
            [3.282244845679842e-05_dp, 0.00018428019757663435_dp, 0.0005131297932514203_dp, &
             0.0011553395530343967_dp, 0.002387152274167475_dp, 0.004712323365880187_dp, &
             0.009010683603238598_dp, 0.016787745478661017_dp, 0.03057773526449549_dp, &
             0.05458202416656862_dp, 0.09566826339550022_dp, 0.1649179422994952_dp, &
             0.2800025692621691_dp, 0.4688114688558269_dp, 0.7749976991407692_dp, &
             1.2666117185092605_dp, 2.050331632839722_dp, 3.2983146221139155_dp, &
             5.313900078330825_dp, 8.784007925670132_dp, &
             ! w
             8.543536907994339e-05_dp, 0.00022594418279482442_dp, 0.0004534407500189063_dp, &
             0.0008756622753532169_dp, 0.001669533056188414_dp, 0.0031234054784167746_dp, &
             0.005717707148168715_dp, 0.01024843812867291_dp, 0.018015553258346157_dp, &
             0.031112489242744585_dp, 0.05286827390244286_dp, 0.08851737705733385_dp, &
             0.14621020274352442_dp, 0.23854430050242964_dp, 0.38494581966192026_dp, &
             0.6156579968253519_dp, 0.9795718925153979_dp, 1.5641128247650342_dp, &
             2.566025112898437_dp, 4.719398313268424_dp]

      CASE (560)

         aw(:) = & ! a
            [2.3296240216139954e-05_dp, 0.00013205598109267732_dp, 0.00037483997796931476_dp, &
             0.0008670180330958671_dp, 0.0018448086515574628_dp, 0.0037452033977933554_dp, &
             0.00734592546659092_dp, 0.014001974700058187_dp, 0.026031328267862423_dp, &
             0.04733299962040928_dp, 0.0843648984201871_dp, 0.14767359121846338_dp, &
             0.2542643418782515_dp, 0.4312479420643727_dp, 0.7214499968181386_dp, &
             1.1921724790624288_dp, 1.9496202226863095_dp, 3.1659629223902988_dp, &
             5.1450686884499515_dp, 8.574095257167548_dp, &
             ! w
             6.0763619216622206e-05_dp, 0.0001637936305323157_dp, 0.0003401748566576009_dp, &
             0.0006823060326976989_dp, 0.0013438522290620373_dp, 0.002582735666319016_dp, &
             0.004838306668765428_dp, 0.008850115868929915_dp, 0.015842574525153197_dp, &
             0.02781225803715432_dp, 0.047970804615602824_dp, 0.08142156305547979_dp, &
             0.13618750655782294_dp, 0.22477638237901468_dp, 0.36661726952946033_dp, &
             0.592120682929402_dp, 0.9505653583803337_dp, 1.5299354639822842_dp, &
             2.5273395599440844_dp, 4.675313119453099_dp]

      CASE (561)

         aw(:) = & ! a
            [1.8276868638413513e-05_dp, 0.00010441734791908067_dp, 0.00030100095146226835_dp, &
             0.0007108478106689388_dp, 0.0015457136129836213_dp, 0.003201818623579705_dp, &
             0.006393972429505417_dp, 0.012383246948387211_dp, 0.023351000974342766_dp, &
             0.04300305996357401_dp, 0.07753274085079426_dp, 0.1371376078702122_dp, &
             0.23838371716071566_dp, 0.40786296778662046_dp, 0.6878424945034628_dp, &
             1.1451105980936995_dp, 1.8855365450248804_dp, 3.081280965420726_dp, &
             5.036563393505113_dp, 8.43873603575549_dp, &
             ! w
             4.7751051453804356e-05_dp, 0.00013072534819952663_dp, 0.0002788396785103831_dp, &
             0.000574965922084612_dp, 0.0011586413313408029_dp, 0.0022690307150705883_dp, &
             0.004319416175125798_dp, 0.008012921142966554_dp, 0.014524625638736806_dp, &
             0.025787112468465653_dp, 0.044933465258560235_dp, 0.07697790652636302_dp, &
             0.12985476862376266_dp, 0.21600595832397973_dp, 0.3548547440342577_dp, &
             0.5769157832693194_dp, 0.9317238561593227_dp, 1.5076443958234427_dp, &
             2.502053463991033_dp, 4.646507016588269_dp]

      CASE (562)

         aw(:) = & ! a
            [1.5147340401565904e-05_dp, 8.712436592340288e-05_dp, 0.00025446897357620836_dp, &
             0.0006112999997930726_dp, 0.001352405918572009_dp, 0.0028457170686157877_dp, &
             0.005762058855060931_dp, 0.011296221165483266_dp, 0.021532316189895696_dp, &
             0.04003756333306515_dp, 0.07281403028357235_dp, 0.12980520659833916_dp, &
             0.2272551001522987_dp, 0.39137224595415776_dp, 0.6640076136938744_dp, &
             1.1115623832190098_dp, 1.83964746537561_dp, 3.0204076691520507_dp, &
             4.958321444052936_dp, 8.340902576822307_dp, &
             ! w
             3.963142520908971e-05_dp, 0.00010994677153384957_dp, 0.00023974999696204358_dp, &
             0.0005052398564666033_dp, 0.0010362041171127665_dp, 0.002058660329900395_dp, &
             0.0039672605226802465_dp, 0.007438819612369857_dp, 0.01361250064614926_dp, &
             0.02437391757564572_dp, 0.042797988134900745_dp, 0.0738322409424064_dp, &
             0.1253436635886914_dp, 0.20972248093193413_dp, 0.346383680564076_dp, &
             0.565915026807196_dp, 0.9180391646116518_dp, 1.4914076613135867_dp, &
             2.4836068652550582_dp, 4.6254969283030345_dp]

      CASE (563)

         aw(:) = & ! a
            [1.1420704827384798e-05_dp, 6.644841306144953e-05_dp, 0.0001983647056325913_dp, &
             0.0004896803425685338_dp, 0.001112575152543483_dp, 0.002397220375369971_dp, &
             0.004955211654653356_dp, 0.009891192823939993_dp, 0.01915581859674716_dp, &
             0.036124523403920084_dp, 0.06653271030106435_dp, 0.11996697540771133_dp, &
             0.21221560024727218_dp, 0.36894041220632945_dp, 0.63139368249158_dp, &
             1.0654133065902547_dp, 1.7762262715303474_dp, 2.935941135547897_dp, &
             4.849404223266529_dp, 8.2043854281906_dp, &
             ! w
             2.995382356019056e-05_dp, 8.498045566980717e-05_dp, 0.000192001219094592_dp, &
             0.0004182489471985938_dp, 0.0008805842181958542_dp, 0.001787234799634824_dp, &
             0.0035071677345569767_dp, 0.006680559720881566_dp, 0.01239613980992307_dp, &
             0.022473018064728997_dp, 0.039903011342209464_dp, 0.06953734554432704_dp, &
             0.11914429878216869_dp, 0.2010359691226609_dp, 0.33460966467006525_dp, &
             0.5505516804951869_dp, 0.8988505091143713_dp, 1.4685722300308928_dp, &
             2.4576216714489925_dp, 4.595906548055523_dp]

      CASE (564)

         aw(:) = & ! a
            [8.476697961661328e-06_dp, 5.0024283797197366e-05_dp, 0.00015327557410932326_dp, &
             0.00039018260856822564_dp, 0.0009124207524581635_dp, 0.002015783790247564_dp, &
             0.00425730835582959_dp, 0.008657599106267897_dp, 0.01704155339535864_dp, &
             0.03260212202884126_dp, 0.06081866885650867_dp, 0.1109321284586668_dp, &
             0.1982855745959643_dp, 0.3480019224842352_dp, 0.600737297535444_dp, &
             1.0217613928506457_dp, 1.7159047521703672_dp, 2.8552241413630974_dp, &
             4.7449266063584945_dp, 8.073063372241517_dp, &
             ! w
             2.2299256835178584e-05_dp, 6.501368491357918e-05_dp, 0.00015294213063525062_dp, &
             0.0003451303428258545_dp, 0.00074676518206715_dp, 0.0015495513359210218_dp, &
             0.003098115315442275_dp, 0.005997523818292902_dp, 0.011287704989923162_dp, &
             0.02072278731325668_dp, 0.03721253945710439_dp, 0.06551194352534437_dp, &
             0.11328896357247986_dp, 0.19277363412593645_dp, 0.3233390657908395_dp, &
             0.5357619930962504_dp, 0.8802904393288624_dp, 1.4464064256116258_dp, &
             2.4323501049508445_dp, 4.567135023797751_dp]

      CASE (565)

         aw(:) = & ! a
            [4.7716221797505265e-06_dp, 2.9166885633180936e-05_dp, 9.488213798553663e-05_dp, &
             0.0002575982926136552_dp, 0.0006375727582029251_dp, 0.0014774229588766239_dp, &
             0.0032482763223485823_dp, 0.00683617387254335_dp, 0.01386165477796786_dp, &
             0.027217146466065434_dp, 0.05195509451290508_dp, 0.09673321633202932_dp, &
             0.17613457437375343_dp, 0.31435090332573695_dp, 0.5509942722729587_dp, &
             0.9503220681177528_dp, 1.6164370030051054_dp, 2.721267610650231_dp, &
             4.570638705803211_dp, 7.853153537926083_dp, &
             ! w
             1.2647092064865676e-05_dp, 3.9370942470099255e-05_dp, 0.0001008859404259641_dp, &
             0.0002436690353121397_dp, 0.0005550198767466638_dp, 0.001200217079464494_dp, &
             0.0024840317756176177_dp, 0.004953203500815161_dp, 0.009565504281249658_dp, &
             0.017964199971957393_dp, 0.032917106613217804_dp, 0.05901000203418003_dp, &
             0.1037306466940394_dp, 0.17915556535870944_dp, 0.3046001281541802_dp, &
             0.5109813069925129_dp, 0.848989087313391_dp, 1.4088411497502464_dp, &
             2.389407421830208_dp, 4.518257900670752_dp]

      CASE (566)

         aw(:) = & ! a
            [2.2625144552501487e-06_dp, 1.4803988063613585e-05_dp, 5.314161280887496e-05_dp, &
             0.00015804064684016368_dp, 0.00042114762589958213_dp, 0.0010356367729601466_dp, &
             0.0023906096253725638_dp, 0.005240607980956467_dp, 0.011002381447191449_dp, &
             0.022263167173878565_dp, 0.04363452639852565_dp, 0.08316223374806304_dp, &
             0.1546194098389664_dp, 0.281189489616428_dp, 0.5013340157200542_dp, &
             0.8781701413341072_dp, 1.5149498825876013_dp, 2.583405360334611_dp, &
             4.390020468388924_dp, 7.624087892633641_dp, &
             ! w
             6.088709124201673e-06_dp, 2.1330742418718056e-05_dp, 6.174883670218116e-05_dp, &
             0.0001625193575379217_dp, 0.000394389143487223_dp, 0.000896733927318685_dp, &
             0.0019342164075336617_dp, 0.0039937427909891_dp, 0.007947265479864692_dp, &
             0.015320156788974165_dp, 0.028726472441608926_dp, 0.05256489400045494_dp, &
             0.09411850623687122_dp, 0.1652810054934653_dp, 0.2852822627217757_dp, &
             0.4851674727364836_dp, 0.8160949153709705_dp, 1.3691026876884091_dp, &
             2.3438153680168_dp, 4.466380534326724_dp]

      CASE (567)

         aw(:) = & ! a
            [1.3068207621557417e-06_dp, 9.212301034193857e-06_dp, 3.6077782050654243e-05_dp, &
             0.00011500739057496833_dp, 0.0003229427492826557_dp, 0.0008269998002373854_dp, &
             0.0019719812010534125_dp, 0.004439942621358676_dp, 0.009533291178960537_dp, &
             0.0196653009055035_dp, 0.03919256823145737_dp, 0.07580215709742091_dp, &
             0.14278614824851238_dp, 0.26272111524073444_dp, 0.4733660643226754_dp, &
             0.8371294493366118_dp, 1.4567190605583722_dp, 2.5037186827496347_dp, &
             4.285002931524411_dp, 7.490324507832817_dp, &
             ! w
             3.5816674054485943e-06_dp, 1.4101262482462756e-05_dp, 4.478947228580631e-05_dp, &
             0.00012516093805595003_dp, 0.00031717470933051873_dp, 0.0007458650505276785_dp, &
             0.0016532480898984255_dp, 0.003491877014477954_dp, 0.007083648720003959_dp, &
             0.013884118766664413_dp, 0.026414876268207557_dp, 0.048960181920969924_dp, &
             0.08867526689094965_dp, 0.15733550325276405_dp, 0.2741076348432424_dp, &
             0.4701017642448502_dp, 0.7967523128574955_dp, 1.3456029417014697_dp, &
             2.316769496854295_dp, 4.435612368010766_dp]

      CASE (568)

         aw(:) = & ! a
            [7.719913676011955e-07_dp, 6.011880174868863e-06_dp, 2.5833115041406673e-05_dp, &
             8.793439483979573e-05_dp, 0.0002587987590789933_dp, 0.0006866221045972633_dp, &
             0.001683480458012479_dp, 0.0038771043195828425_dp, 0.008483137655494119_dp, &
             0.01778139263631939_dp, 0.0359308996111747_dp, 0.07033817179348717_dp, &
             0.13391568640227072_dp, 0.24875679620964244_dp, 0.4520556566223064_dp, &
             0.8056441782199937_dp, 1.4117790557247591_dp, 2.441909128739049_dp, &
             4.203216432929416_dp, 7.385843906709667_dp, &
             ! w
             2.175165277102975e-06_dp, 9.83686937874479e-06_dp, 3.409117948071228e-05_dp, &
             0.00010051617583215904_dp, 0.0002646118121177824_dp, 0.0006406344379419803_dp, &
             0.0014533580241736681_dp, 0.0031288694916891424_dp, 0.006450075747897291_dp, &
             0.01281757872600264_dp, 0.02467942475720512_dp, 0.046227844304853834_dp, &
             0.0845138014752303_dp, 0.15121400342164015_dp, 0.26543857578837204_dp, &
             0.45834250505310004_dp, 0.7815767477876203_dp, 1.3270937794223034_dp, &
             2.2954209095646343_dp, 4.411328312061586_dp]

      CASE (569)

         aw(:) = & ! a
            [5.767350027933078e-07_dp, 4.817969498146783e-06_dp, 2.18483421872876e-05_dp, &
             7.701733937490957e-05_dp, 0.00023221706761777325_dp, 0.000627214064392759_dp, &
             0.001559331226024905_dp, 0.003631570338125293_dp, 0.00801975002563171_dp, &
             0.01694196918554081_dp, 0.03446529360605312_dp, 0.0678648367359474_dp, &
             0.12987423262364467_dp, 0.24235782752728424_dp, 0.442240387974228_dp, &
             0.7910767630296573_dp, 1.390904281788192_dp, 2.4131024951612994_dp, &
             4.164997890797416_dp, 7.336925716603451_dp, &
             ! w
             1.660951372249949e-06_dp, 8.200747534699697e-06_dp, 2.9767649798932182e-05_dp, &
             9.023633700653982e-05_dp, 0.00024219817565194083_dp, 0.0005949966260560371_dp, &
             0.0013654767982160731_dp, 0.002967456950233177_dp, 0.006165636395223621_dp, &
             0.012334776477467158_dp, 0.023888104756525554_dp, 0.04497396126499374_dp, &
             0.08259314219416934_dp, 0.14837421782705118_dp, 0.2613984947819671_dp, &
             0.45284008435611717_dp, 0.7744514766121792_dp, 1.3183808151857417_dp, &
             2.28535676109961_dp, 4.399881040416567_dp]

      CASE (570)

         aw(:) = & ! a
            [4.7388642561389144e-07_dp, 4.1797058086417e-06_dp, 1.9662371656572396e-05_dp, &
             7.090495144500604e-05_dp, 0.00021711030969899913_dp, 0.0005930677103712356_dp, &
             0.0014873345502435555_dp, 0.003488144657184059_dp, 0.0077474283248112116_dp, &
             0.016446123987808585_dp, 0.03359572824940348_dp, 0.06639170171369385_dp, &
             0.12745893321145077_dp, 0.23852209419315182_dp, 0.4363411083235919_dp, &
             0.7823006219890122_dp, 1.37830238440943_dp, 2.395681972917204_dp, &
             4.141853570937379_dp, 7.3072720454936135_dp, &
             ! w
             1.3899318059443448e-06_dp, 7.30994082205168e-06_dp, 2.734395449496093e-05_dp, &
             8.437484078302796e-05_dp, 0.00022926593102704486_dp, 0.0005684251915448996_dp, &
             0.0013139378741909092_dp, 0.0028722257036821338_dp, 0.005996968727206591_dp, &
             0.01204723285079215_dp, 0.023415021757870382_dp, 0.04422182173025604_dp, &
             0.08143759376776773_dp, 0.14666111213623687_dp, 0.25895547493701826_dp, &
             0.4495057695676949_dp, 0.7701260580617737_dp, 1.313084434504986_dp, &
             2.279234394283262_dp, 4.39291748104259_dp]

      CASE (571)

         aw(:) = & ! a
            [4.100989232498314e-07_dp, 3.7792850055544382e-06_dp, 1.8265622126749353e-05_dp, &
             6.694535998747585e-05_dp, 0.00020722729743620524_dp, 0.0005705629536785965_dp, &
             0.0014396080104541477_dp, 0.0033926203121782852_dp, 0.007565347472925269_dp, &
             0.016113491491623846_dp, 0.03301072623762438_dp, 0.06539818512564702_dp, &
             0.12582644154342598_dp, 0.23592452788793758_dp, 0.4323392610500245_dp, &
             0.776338212526684_dp, 1.3697295133957719_dp, 2.38381787615515_dp, &
             4.126077347051756_dp, 7.28704571113364_dp, &
             ! w
             1.2217736426804093e-06_dp, 6.74353773355063e-06_dp, 2.5772627348365625e-05_dp, &
             8.053221944722147e-05_dp, 0.00022072210692964357_dp, 0.0005507667496675252_dp, &
             0.0012795253756694418_dp, 0.002808392942412839_dp, 0.005883541894372713_dp, &
             0.01185331971280634_dp, 0.023095203280387715_dp, 0.04371225453828949_dp, &
             0.08065321770760842_dp, 0.14549627510752375_dp, 0.2572917811972208_dp, &
             0.44723203630635106_dp, 0.7671731038907279_dp, 1.3094654749292953_dp, &
             2.2750490100353447_dp, 4.388157119115768_dp]

      CASE (572)

         aw(:) = & ! a
            [3.354963113466894e-07_dp, 3.3050371581884835e-06_dp, 1.6580517486360618e-05_dp, &
             6.210454841433054e-05_dp, 0.00019503097427437302_dp, 0.0005425956338420271_dp, &
             0.0013799720857646176_dp, 0.0032727313966212225_dp, 0.007335986456582696_dp, &
             0.01569318510958676_dp, 0.032269559816750004_dp, 0.06413653008195322_dp, &
             0.12374913088292729_dp, 0.232613219846265_dp, 0.4272296599438312_dp, &
             0.7687145982595106_dp, 1.3587546505204962_dp, 2.36861386762867_dp, &
             4.105843169048649_dp, 7.2610883454495765_dp, &
             ! w
             1.0250016238292935e-06_dp, 6.063313137015976e-06_dp, 2.385015349539664e-05_dp, &
             7.578115888234317e-05_dp, 0.000210080879734588_dp, 0.0005286508368144408_dp, &
             0.0012362350038488553_dp, 0.002727799407650043_dp, 0.005739892440563216_dp, &
             0.01160709192962607_dp, 0.02268817286993225_dp, 0.04306242402953251_dp, &
             0.079651141191263_dp, 0.1440057588408086_dp, 0.25515988558352654_dp, &
             0.4443147466825058_dp, 0.7633803090692989_dp, 1.3048134995846872_dp, &
             2.269666478851866_dp, 4.382035245212188_dp]

      CASE (573)

         aw(:) = & ! a
            [2.805804082793107e-07_dp, 2.950491711590651e-06_dp, 1.5294524832459847e-05_dp, &
             5.835751095078004e-05_dp, 0.0001854966794063506_dp, 0.0005205720877313719_dp, &
             0.001332742491953696_dp, 0.003177347426631186_dp, 0.007152812858160808_dp, &
             0.015356440842625177_dp, 0.031674112010656084_dp, 0.06312050119151012_dp, &
             0.12207273231301714_dp, 0.2299360270721139_dp, 0.4230917648931671_dp, &
             0.7625318381111248_dp, 1.3498427892818028_dp, 2.356254680336709_dp, &
             4.089381045912591_dp, 7.239956935214296_dp, &
             ! w
             8.800313125655099e-07_dp, 5.546616092028536e-06_dp, 2.2360917667162985e-05_dp, &
             7.205995092666968e-05_dp, 0.00020168226711326395_dp, 0.0005110944183033088_dp, &
             0.0012017111041264781_dp, 0.002663283448126958_dp, 0.005624534587322935_dp, &
             0.011408821456866228_dp, 0.02235964579311844_dp, 0.04253683727063298_dp, &
             0.0788391630738978_dp, 0.14279601338564965_dp, 0.2534270362095085_dp, &
             0.4419404420333103_dp, 0.7602900749137744_dp, 1.3010200857113459_dp, &
             2.2652752854237397_dp, 4.377040955310725_dp]

      CASE (574)

         aw(:) = & ! a
            [2.5003705454345945e-07_dp, 2.7506585025356867e-06_dp, 1.455800325385011e-05_dp, &
             5.6188613414129365e-05_dp, 0.00017993755812697063_dp, 0.0005076618125728505_dp, &
             0.0013049410663844576_dp, 0.003121012466836724_dp, 0.007044329613188399_dp, &
             0.015156542145764723_dp, 0.031319935722695355_dp, 0.06251511350101867_dp, &
             0.121072355633586_dp, 0.228336294921602_dp, 0.4206162709239359_dp, &
             0.7588291323317048_dp, 1.344500825200748_dp, 2.348840610134819_dp, &
             4.079499633205373_dp, 7.227267122695254_dp, &
             ! w
             7.993194986512641e-07_dp, 5.251671423470672e-06_dp, 2.1498431524474387e-05_dp, &
             6.988727944617676e-05_dp, 0.00019675102255989173_dp, 0.0005007424166542977_dp, &
             0.001181286012366606_dp, 0.0026250095685235878_dp, 0.005555941237957179_dp, &
             0.011290694759850419_dp, 0.022163579406079995_dp, 0.04222269431934139_dp, &
             0.07835319878537338_dp, 0.1420711274231852_dp, 0.2523876013999611_dp, &
             0.4405149033915557_dp, 0.7584332213100451_dp, 1.2987393328305021_dp, &
             2.262634225050463_dp, 4.374037187868886_dp]

      CASE (575)

         aw(:) = & ! a
            [0.002912528593439275_dp, 0.01548387838805494_dp, 0.03868327142039642_dp, &
             0.07359696772760346_dp, 0.1219830715395445_dp, 0.18651336109281208_dp, &
             0.27110865226768727_dp, 0.3813659503887679_dp, 0.5250622903507938_dp, &
             0.7127369661872631_dp, 0.9583997086853228_dp, 1.2804583869211272_dp, &
             1.7029906701275614_dp, 2.2575275719668424_dp, 2.985629614050784_dp, &
             3.942813034813778_dp, 5.205057218138501_dp, 6.8809123894389_dp, &
             9.137755989603955_dp, 12.27260150378066_dp, 16.993101810540406_dp, &
             ! w
             0.0074900483223948955_dp, 0.017750820333776663_dp, 0.02882615963470279_dp, &
             0.041290287294848266_dp, 0.05592161752072061_dp, 0.0737852627229118_dp, &
             0.09632974562624953_dp, 0.1254714338211335_dp, 0.16366622513075452_dp, &
             0.21400291283514866_dp, 0.2803697297994583_dp, 0.3677314569449578_dp, &
             0.48254653787196883_dp, 0.6333911635673961_dp, 0.8319632752888728_dp, &
             1.094881276100746_dp, 1.447312868707311_dp, 1.9313305500629703_dp, &
             2.6286997142342043_dp, 3.741608814883541_dp, 6.071946179849819_dp]

      CASE (576)

         aw(:) = & ! a
            [0.00267378214367888_dp, 0.014219954786944013_dp, 0.035550495769850046_dp, &
             0.0677091084669288_dp, 0.11239276193583495_dp, 0.1721931043977421_dp, &
             0.25093061240883624_dp, 0.3540775849447265_dp, 0.48925482102077406_dp, &
             0.6668081866580396_dp, 0.90051910139462_dp, 1.2085451570071766_dp, &
             1.614713038391973_dp, 2.1503280006439773_dp, 2.856777537336051_dp, &
             3.7894827822055683_dp, 5.024421251113702_dp, 6.670224516794641_dp, &
             8.894364773819014_dp, 11.993728835725038_dp, 16.67465556084517_dp, &
             ! w
             0.006876665981029532_dp, 0.016309405974623603_dp, 0.026522810022282926_dp, &
             0.03807328171604787_dp, 0.051720381805334975_dp, 0.06850994848593445_dp, &
             0.08986884041935923_dp, 0.11768576157341548_dp, 0.15438141970985333_dp, &
             0.20300682324310207_dp, 0.26742008709387566_dp, 0.3525735848301676_dp, &
             0.4649375134490115_dp, 0.613127034319381_dp, 0.8089062540298723_dp, &
             1.06898173147446_dp, 1.418615523926716_dp, 1.8999430641846025_dp, &
             2.594670220646987_dp, 3.704516452733679_dp, 6.0288246751663515_dp]

      CASE (577)

         aw(:) = & ! a
            [0.0015146491737760147_dp, 0.008077578446770248_dp, 0.020299219623305678_dp, &
             0.03897162476889744_dp, 0.06542403207952556_dp, 0.10175367034403547_dp, &
             0.15113754543766353_dp, 0.21821167260561974_dp, 0.30951561954124396_dp, &
             0.4340455501733756_dp, 0.603997953286101_dp, 0.8357981794242986_dp, &
             1.151520119331662_dp, 1.580851318131861_dp, 2.1638751702975596_dp, &
             2.9552066015459304_dp, 4.0306582223099_dp, 5.499339294147026_dp, &
             7.529480986100923_dp, 10.417648515189345_dp, 14.86308806543036_dp, &
             ! w
             0.0038979756780079264_dp, 0.009296138987866744_dp, 0.015276566196327761_dp, &
             0.022285959542313886_dp, 0.030963148882563418_dp, 0.04221928459682924_dp, &
             0.05731383340559683_dp, 0.07791534299340988_dp, 0.10617973964302194_dp, &
             0.14489596550735878_dp, 0.1977230804501745_dp, 0.2695241987672367_dp, &
             0.3668223890330759_dp, 0.4984541081634047_dp, 0.6765908300356022_dp, &
             0.9185215674834927_dp, 1.250186506194148_dp, 1.714272601393396_dp, &
             2.392353892036537_dp, 3.4836105936009223_dp, 5.772628869195125_dp]

      CASE (578)

         aw(:) = & ! a
            [0.0010821191288824547_dp, 0.00578174027870024_dp, 0.014581468708472323_dp, &
             0.028149812106127912_dp, 0.047630855357227546_dp, 0.0748632213865804_dp, &
             0.11266955091322602_dp, 0.16520337502327978_dp, 0.23836733325808943_dp, &
             0.3403637601835302_dp, 0.48246148352122803_dp, 0.6800654271214926_dp, &
             0.9541932711298037_dp, 1.333518024241693_dp, 1.8572519632567737_dp, &
             2.579402937933566_dp, 3.575555741833236_dp, 4.955023113517167_dp, &
             6.886534745313462_dp, 9.666786433520393_dp, 13.991920002667486_dp, &
             ! w
             0.00278604825370396_dp, 0.00666942429734448_dp, 0.01103901261361446_dp, &
             0.016284704991226685_dp, 0.022978941257169292_dp, 0.03195047184585896_dp, &
             0.04434763310061658_dp, 0.061694821897650194_dp, 0.08598756830441465_dp, &
             0.11986583039894727_dp, 0.16687284958336243_dp, 0.2318045507930067_dp, &
             0.32118305078668047_dp, 0.4439333058024178_dp, 0.6124285789377593_dp, &
             0.8442838049251395_dp, 1.1658622068098023_dp, 1.6202614555945163_dp, &
             2.2891590291234873_dp, 3.3706338493558206_dp, 5.6420208133079734_dp]

      CASE (579)

         aw(:) = & ! a
            [0.0008512472313432425_dp, 0.0045548640886128025_dp, 0.011519454211287847_dp, &
             0.02233617991912903_dp, 0.038031227907940994_dp, 0.06027433547090194_dp, &
             0.09164991237657227_dp, 0.13598116475965577_dp, 0.198733636734997_dp, &
             0.2875666853675028_dp, 0.4131133991401827_dp, 0.59007180077374_dp, &
             0.8387139977059008_dp, 1.186977989659552_dp, 1.6734219663811696_dp, &
             2.3515700471370193_dp, 3.2967868832052964_dp, 4.618486149495916_dp, &
             6.485754181553083_dp, 9.195482690425992_dp, 13.441990875715812_dp, &
             ! w
             0.002192373569931531_dp, 0.005263723727113722_dp, 0.008761656098735913_dp, &
             0.013039335307264994_dp, 0.01862448511551076_dp, 0.02628712330705854_dp, &
             0.03709468783248873_dp, 0.05246974493351825_dp, 0.07429894626409213_dp, &
             0.10512138695293262_dp, 0.1483969314828238_dp, 0.20886431445073794_dp, &
             0.29302831654438866_dp, 0.4098559803558632_dp, 0.5718437172722399_dp, &
             0.7968250446598246_dp, 1.1114665234817016_dp, 1.5591858781562895_dp, &
             2.2218010666112384_dp, 3.296756650714444_dp, 5.556766892575554_dp]

      CASE (580)

         aw(:) = & ! a
            [0.000706181665637202_dp, 0.0037832605940279836_dp, 0.009590445123069941_dp, &
             0.01866449257764946_dp, 0.031947559450222186_dp, 0.050986704657108785_dp, &
             0.0781900087460827_dp, 0.11713410554001233_dp, 0.17295856953307964_dp, &
             0.25291832156219207_dp, 0.3671708931450052_dp, 0.5298801213301267_dp, &
             0.760746428151499_dp, 1.0871337311202325_dp, 1.5470769030245328_dp, &
             2.1936982168610255_dp, 3.102159686708988_dp, 4.381926793986992_dp, &
             6.202358299955479_dp, 8.86054490346503_dp, 13.049581916125424_dp, &
             ! w
             0.0018192654620688945_dp, 0.004378652711843947_dp, 0.007322936786695653_dp, &
             0.010978833423347286_dp, 0.01584083918432559_dp, 0.022633761587539332_dp, &
             0.03236256666552527_dp, 0.04637319722671109_dp, 0.06647194613474862_dp, &
             0.09512233609235062_dp, 0.1357183287037266_dp, 0.19294871528877855_dp, &
             0.2732955699077965_dp, 0.38574692949055506_dp, 0.542882823922086_dp, &
             0.7626975682168371_dp, 1.0720921461682396_dp, 1.5147451907325926_dp, &
             2.172617144585184_dp, 3.2427363246876157_dp, 5.494503309968946_dp]

      CASE (581)

         aw(:) = & ! a
            [0.0006059630517732656_dp, 0.0032497850589363313_dp, 0.008254857572833242_dp, &
             0.01611692190326042_dp, 0.027714088207360835_dp, 0.044498489502335536_dp, &
             0.06873997623329513_dp, 0.103821076432779_dp, 0.15462511699747838_dp, &
             0.2280890173902606_dp, 0.33399454826255653_dp, 0.4860796870810229_dp, &
             0.7035837752077377_dp, 1.0134011681732502_dp, 1.4531310223338998_dp, &
             2.075551951975214_dp, 2.95564083269993_dp, 4.202887971921243_dp, &
             5.986869699658992_dp, 8.604864682867454_dp, 12.749079488048517_dp, &
             ! w
             0.0015614572648853513_dp, 0.0037661449167832725_dp, 0.006324458258380648_dp, &
             0.009542795415729098_dp, 0.013889474376249412_dp, 0.020052830575055577_dp, &
             0.028987614866875185_dp, 0.041979430673447615_dp, 0.06077179965328263_dp, &
             0.08776803441847775_dp, 0.1263073361292365_dp, 0.1810342464369783_dp, &
             0.2584066380241655_dp, 0.3674224365145487_dp, 0.5207222466943435_dp, &
             0.7364255479986647_dp, 1.0416231554631343_dp, 1.4802133869629102_dp, &
             2.1342925843994744_dp, 3.2005943960052603_dp, 5.4459745084875015_dp]

      CASE (582)

         aw(:) = & ! a
            [0.000532273008995531_dp, 0.0028572600783288472_dp, 0.007270929683116969_dp, &
             0.014236638215925999_dp, 0.02458144975050972_dp, 0.03968089378992191_dp, &
             0.061692210640403054_dp, 0.09383947346201514_dp, 0.14079708166644644_dp, &
             0.20924239460212252_dp, 0.30864896478807224_dp, 0.4524027445775415_dp, &
             0.6593582837561238_dp, 0.9560136522539945_dp, 1.3795951312980856_dp, &
             1.9825811680572736_dp, 2.839779117516862_dp, 4.060687995093856_dp, &
             5.815063497550326_dp, 8.400358437200548_dp, 12.508099878674136_dp, &
             ! w
             0.0013718631357690669_dp, 0.0033150960728274923_dp, 0.005587367036493863_dp, &
             0.008478777888709727_dp, 0.012436201589577962_dp, 0.018117599305360377_dp, &
             0.026436169643263188_dp, 0.03862837475769106_dp, 0.056386700438688396_dp, &
             0.08206451686895867_dp, 0.11895408749309858_dp, 0.17166029934290608_dp, &
             0.24661686117090256_dp, 0.3528251858348808_dp, 0.5029717126255187_dp, &
             0.7152771534219993_dp, 1.0169910497627965_dp, 1.4522011191312796_dp, &
             2.103131043718737_dp, 3.166295213723693_dp, 5.406505108251993_dp]

      CASE (583)

         aw(:) = & ! a
            [0.0004756401331268577_dp, 0.002555412870813139_dp, 0.006513464784162022_dp, &
             0.01278672176443298_dp, 0.022160241472440705_dp, 0.03594585244615309_dp, &
             0.05620648606275404_dp, 0.08603338976071762_dp, 0.12992598514475306_dp, &
             0.19434390160992548_dp, 0.2885009228780811_dp, 0.42548429765391527_dp, &
             0.6238194389850323_dp, 0.9096622964489856_dp, 1.3199135679348086_dp, &
             1.9067852837180768_dp, 2.744928837289791_dp, 3.943841765535262_dp, &
             5.673431184795017_dp, 8.231310557456482_dp, 12.308468051499757_dp, &
             ! w
             0.0012261344973695885_dp, 0.002967989517341061_dp, 0.005018888492974004_dp, &
             0.007655451479431189_dp, 0.011306487871651802_dp, 0.01660407096271243_dp, &
             0.02442624854976384_dp, 0.035968419164715645_dp, 0.052880333531535886_dp, &
             0.07747275201189595_dp, 0.11299683760848225_dp, 0.16402160027423562_dp, &
             0.23695725624307062_dp, 0.34080478602001063_dp, 0.4882864055201595_dp, &
             0.6977070085715041_dp, 0.9964519980401344_dp, 1.4287753328272155_dp, &
             2.07701947561897_dp, 3.1375298304844623_dp, 5.373422854917393_dp]

      CASE (584)

         aw(:) = & ! a
            [0.00043065506645819203_dp, 0.002315517422070806_dp, 0.005910861730887108_dp, &
             0.011631499224766407_dp, 0.020227079342209225_dp, 0.032955252043211355_dp, &
             0.05179830098846239_dp, 0.07973385406557651_dp, 0.12111174177371571_dp, &
             0.18220510290012484_dp, 0.2720042348018754_dp, 0.4033378649152963_dp, &
             0.5944445770290845_dp, 0.8711798296951927_dp, 1.27015561887797_dp, &
             1.8433445206760664_dp, 2.6652536847868804_dp, 3.8453724749666325_dp, &
             5.5537382035583_dp, 8.088112683148747_dp, 12.139044831188432_dp, &
             ! w
             0.00111036369019524_dp, 0.0026919404252636367_dp, 0.004565885827633419_dp, &
             0.0069974035369530195_dp, 0.010399766180461586_dp, 0.015382590348554808_dp, &
             0.02279366702294027_dp, 0.03379337933152443_dp, 0.04999488149844764_dp, &
             0.07367181978477365_dp, 0.10803879981146143_dp, 0.15763210713416884_dp, &
             0.22883938894461284_dp, 0.33065869615942317_dp, 0.4758408266732641_dp, &
             0.6827621656764927_dp, 0.9789264997486924_dp, 1.408735765820335_dp, &
             2.0546432560808214_dp, 3.1128606984101044_dp, 5.345065392286852_dp]

      CASE (585)

         aw(:) = & ! a
            [0.0003939949106784257_dp, 0.0021199200095252226_dp, 0.005419082605229479_dp, &
             0.010687427388557852_dp, 0.018644192955283894_dp, 0.03050013370359804_dp, &
             0.0481674309363621_dp, 0.07452495424254636_dp, 0.11379254714935771_dp, &
             0.17208096789507601_dp, 0.2581851127309392_dp, 0.38470647150976683_dp, &
             0.5696299884851689_dp, 0.8385435956292172_dp, 1.2278001525977922_dp, &
             1.7891548298725095_dp, 2.596980705488982_dp, 3.7607544609508485_dp, &
             5.450627005441288_dp, 7.964497534517149_dp, 11.992549225640493_dp, &
             ! w
             0.0010160065520274173_dp, 0.002466728414763598_dp, 0.004195634291500846_dp, &
             0.006458082875483104_dp, 0.009653763951944621_dp, 0.014372540502803585_dp, &
             0.021435790597874885_dp, 0.031973548678985074_dp, 0.04756707324919973_dp, &
             0.0704571667488686_dp, 0.103825522086608_dp, 0.15217836717321465_dp, &
             0.2218817837045788_dp, 0.3219292605213171_dp, 0.4650948451783752_dp, &
             0.6698166547223037_dp, 0.963703094771255_dp, 1.3912893105721738_dp, &
             2.035132216082195_dp, 3.0913356591946104_dp, 5.320332409219109_dp]

      CASE (586)

         aw(:) = & ! a
            [0.0002190201476233999_dp, 0.0011847161401304554_dp, 0.003060084761396343_dp, &
             0.006136335172214816_dp, 0.0109597725831443_dp, 0.018467814404298503_dp, &
             0.030159993867000315_dp, 0.048334749228975196_dp, 0.07644683648695118_dp, &
             0.11964186116918914_dp, 0.1855350566645857_dp, 0.2853305828454066_dp, &
             0.4354219713649722_dp, 0.6596805705680682_dp, 0.9927514549523896_dp, &
             1.4849033418439166_dp, 2.2095246760539875_dp, 3.2758891700834396_dp, &
             4.854819166433461_dp, 7.245196580178857_dp, 11.13535800313594_dp, &
             ! w
             0.000565468130145394_dp, 0.0013876071557883598_dp, 0.0024100067566517175_dp, &
             0.0038312495526718225_dp, 0.005969093786937915_dp, 0.00929310973684461_dp, &
             0.01446849232337032_dp, 0.022448054187728918_dp, 0.0346209657962691_dp, &
             0.05301996131594804_dp, 0.08060759210882006_dp, 0.12167829753613657_dp, &
             0.18242930518473746_dp, 0.2717835378593405_dp, 0.4026166639626322_dp, &
             0.59372008416868_dp, 0.8733542859866111_dp, 1.2869382219003953_dp, &
             1.917797589111749_dp, 2.961572640926896_dp, 5.171428698629114_dp]

      CASE (587)

         aw(:) = & ! a
            [0.00015517344947997203_dp, 0.0008424335208536418_dp, 0.0021918115852921803_dp, &
             0.004446652568997501_dp, 0.008071288924584091_dp, 0.0138696235071661_dp, &
             0.02313830852773234_dp, 0.03789100023944764_dp, 0.061204348253109386_dp, &
             0.09773839417102638_dp, 0.15450101702605973_dp, 0.2419587075389428_dp, &
             0.3756424269293803_dp, 0.5784661086721002_dp, 0.8840901320899797_dp, &
             1.3418876792688652_dp, 2.024605927146014_dp, 3.041312973632217_dp, &
             4.563157580178045_dp, 6.8896323136008455_dp, 10.708369152416786_dp, &
             ! w
             0.0004009559297720304_dp, 0.0009911823752180814_dp, 0.0017466456327943532_dp, &
             0.002838439770140455_dp, 0.004542366816484977_dp, 0.0072667993199022575_dp, &
             0.0116005297484477_dp, 0.018409115416900507_dp, 0.028981752270524994_dp, &
             0.04523615263541352_dp, 0.07000724593704305_dp, 0.10745874153358762_dp, &
             0.16367285846708884_dp, 0.24750410051086227_dp, 0.3718503082852143_dp, &
             0.555667642795944_dp, 0.8275641592095919_dp, 1.233470550370284_dp, &
             1.8572143372678382_dp, 2.894334050531638_dp, 5.0944008838246715_dp]

      CASE (588)

         aw(:) = & ! a
            [0.00012147264200089475_dp, 0.0006613812626125256_dp, 0.0017307123666432847_dp, &
             0.003543804109616693_dp, 0.006514149721044517_dp, 0.01136169943762222_dp, &
             0.01925551859486475_dp, 0.03203007532635975_dp, 0.052522187576779344_dp, &
             0.08507990794097489_dp, 0.13631520282946505_dp, 0.21620654455954455_dp, &
             0.33970549965315155_dp, 0.5290723342685504_dp, 0.8172824781640463_dp, &
             1.253071068792377_dp, 1.908709813966847_dp, 2.893087621803284_dp, &
             4.37755416983146_dp, 6.662039749581136_dp, 10.433811187142528_dp, &
             ! w
             0.0003140777097500278_dp, 0.0007809486573442481_dp, 0.001392071768161044_dp, &
             0.0023012464750372277_dp, 0.0037571677173666358_dp, 0.006129282815059349_dp, &
             0.009958597763291138_dp, 0.016055003773824093_dp, 0.025641599315711278_dp, &
             0.040557817757522575_dp, 0.0635495940374247_dp, 0.09868686839246495_dp, &
             0.15196556657136023_dp, 0.23218224780602373_dp, 0.3522360971124796_dp, &
             0.5311823234924457_dp, 0.7978588520009688_dp, 1.1985522831317563_dp, &
             1.8174611604172524_dp, 2.850114187630499_dp, 5.0437886145056465_dp]

      CASE (589)

         aw(:) = & ! a
            [0.00010044700235109968_dp, 0.0005482349511701674_dp, 0.0014416441325587794_dp, &
             0.0029749923122860756_dp, 0.005526095076794716_dp, 0.009755543321313273_dp, &
             0.016742265881198613_dp, 0.028193907371639727_dp, 0.04677630232745053_dp, &
             0.0766128789691386_dp, 0.12402759069454374_dp, 0.19864018969200373_dp, &
             0.31497182291102216_dp, 0.49479165979551865_dp, 0.7705539131146174_dp, &
             1.1905002842753047_dp, 1.826525115183567_dp, 2.7873615929411506_dp, &
             4.244497893864711_dp, 6.498202967388789_dp, 10.235526693121074_dp, &
             ! w
             0.00025985429340269966_dp, 0.0006492964286643749_dp, 0.0011686354886819145_dp, &
             0.001959396137997961_dp, 0.0032507572779906795_dp, 0.0053845561304046675_dp, &
             0.008868118442681846_dp, 0.014471318074345456_dp, 0.02336858168319099_dp, &
             0.037340676750970296_dp, 0.05906581203253332_dp, 0.09254126300992202_dp, &
             0.14369418985372256_dp, 0.22127180608899147_dp, 0.3381670236492554_dp, &
             0.5135021981275897_dp, 0.7762837135098907_dp, 1.1730686840762399_dp, &
             1.788349203299166_dp, 2.8176773541740805_dp, 5.0066848839663445_dp]

      CASE (590)

         aw(:) = & ! a
            [8.599442188034258e-05_dp, 0.000470350900814204_dp, 0.0012421341212631414_dp, &
             0.002580754204023296_dp, 0.004837119681568471_dp, 0.008626855764683935_dp, &
             0.014960667614142279_dp, 0.025449977697599838_dp, 0.042630062483500444_dp, &
             0.07045147959964136_dp, 0.11501474612676975_dp, 0.18565910655166207_dp, &
             0.29656641066373673_dp, 0.4691153814629614_dp, 0.7353418333403009_dp, &
             1.1430865744051124_dp, 1.76393151870596_dp, 2.7064729119448008_dp, &
             4.14230107530687_dp, 6.3719596992717324_dp, 10.082359662962014_dp, &
             ! w
             0.00022257021619058302_dp, 0.0005585177734638947_dp, 0.0010137514175097924_dp, &
             0.0017204506800246545_dp, 0.0028928179412600332_dp, 0.004851772621472659_dp, &
             0.00807914994440924_dp, 0.013314000515191627_dp, 0.021692609285552854_dp, &
             0.034949206147216735_dp, 0.05570768038394759_dp, 0.08790625574110784_dp, &
             0.13741509522253004_dp, 0.21293868905721705_dp, 0.3273605237131328_dp, &
             0.4998518335187192_dp, 0.7595502031932437_dp, 1.153229578317593_dp, &
             1.7656243978325539_dp, 2.792323837820332_dp, 4.977696280828467_dp]

      CASE (591)

         aw(:) = & ! a
            [7.540797086138839e-05_dp, 0.00041323116155337535_dp, 0.00109547398488451_dp, &
             0.0022898773494122934_dp, 0.004326073041963684_dp, 0.007784032902941941_dp, &
             0.013620400601584133_dp, 0.02337015087416255_dp, 0.03946424807687831_dp, &
             0.06571422926866606_dp, 0.10803975588548556_dp, 0.17555156500650804_dp, &
             0.2821533143971902_dp, 0.44890140513320964_dp, 0.7074836019137458_dp, &
             1.1054040446449467_dp, 1.7139784119319859_dp, 2.6416810161420936_dp, &
             4.060180999003668_dp, 6.2702522708681_dp, 9.958712550509539_dp, &
             ! w
             0.000195252119193883_dp, 0.000491841469415062_dp, 0.000899463243933757_dp, &
             0.0015428467443871746_dp, 0.0026242036972888073_dp, 0.004447885595551735_dp, &
             0.007475499776797756_dp, 0.012421262454536815_dp, 0.02039032445087072_dp, &
             0.03307857916623063_dp, 0.053064785821927786_dp, 0.08423760254500576_dp, &
             0.13241862701918977_dp, 0.20627478095816168_dp, 0.31867881474028964_dp, &
             0.4888392749696272_dp, 0.7460001633741213_dp, 1.137115520208229_dp, &
             1.7471257751603202_dp, 2.7716629434799165_dp, 4.9540811400439475_dp]

      CASE (592)

         aw(:) = & ! a
            [6.729643786378191e-05_dp, 0.00036941713801818963_dp, 0.000982743648624791_dp, &
             0.002065553108023886_dp, 0.00393007800116474_dp, 0.007127084830737928_dp, &
             0.012568949878724436_dp, 0.02172788237991511_dp, 0.03694877587872289_dp, &
             0.06192782168070114_dp, 0.10243380613489918_dp, 0.167385819384109_dp, &
             0.2704529437371129_dp, 0.4324182512644755_dp, 0.6846724893717545_dp, &
             1.0744302470741618_dp, 1.6727755057013247_dp, 2.5880728031271683_dp, &
             3.992054110974834_dp, 6.185690851191553_dp, 9.855736649525161_dp, &
             ! w
             0.00017431525736926246_dp, 0.0004406288539898687_dp, 0.0008113179024998627_dp, &
             0.0014049751563060245_dp, 0.0024139165345136693_dp, 0.004128942576256952_dp, &
             0.006995057826103786_dp, 0.011705825328993887_dp, 0.019340237024596_dp, &
             0.03156174211027009_dp, 0.05091064097770643_dp, 0.08123300118908505_dp, &
             0.1283081856801461_dp, 0.20076964370622172_dp, 0.311478928072386_dp, &
             0.4796740514736403_dp, 0.7346878745529786_dp, 1.12362789176655_dp, &
             1.7316133945678072_dp, 2.7543213284758723_dp, 4.934265345112631_dp]

      CASE (593)

         aw(:) = & ! a
            [6.0868989705923946e-05_dp, 0.00033466527259304297_dp, 0.0008931609466182841_dp, &
             0.0018867521999880012_dp, 0.0036130815932197253_dp, 0.0065984003015285885_dp, &
             0.01171793245060595_dp, 0.02039107070830741_dp, 0.03488995726268834_dp, &
             0.05881281922101638_dp, 0.09779970387493107_dp, 0.16060542497340377_dp, &
             0.26069706572986057_dp, 0.418621190967853_dp, 0.6655101626463257_dp, &
             1.0483250193870877_dp, 1.6379448418403901_dp, 2.5426344047167566_dp, &
             3.9341770026864693_dp, 6.113716577533663_dp, 9.767962121034467_dp, &
             ! w
             0.00015772147273873319_dp, 0.0003999596931299437_dp, 0.0007410568415063558_dp, &
             0.0012944266899096982_dp, 0.002244029472612469_dp, 0.0038693093037720627_dp, &
             0.0066012947792468855_dp, 0.011115964328758596_dp, 0.01846985189215927_dp, &
             0.03029838650471412_dp, 0.049108460638350844_dp, 0.078708886835214_dp, &
             0.12484171636309181_dp, 0.1961102483160019_dp, 0.3053647957640326_dp, &
             0.47186724243669576_dp, 0.7250262838503878_dp, 1.1120827118535555_dp, &
             1.7183136759905717_dp, 2.739441351104487_dp, 4.91726629929826_dp]

      CASE (594)

         aw(:) = & ! a
            [5.564168523389408e-05_dp, 0.0003063767219819402_dp, 0.000820112933650957_dp, &
             0.001740547561579862_dp, 0.003352848507146081_dp, 0.006162292801037561_dp, &
             0.011012318975462503_dp, 0.019277015860940546_dp, 0.03316587125100979_dp, &
             0.05619238773363049_dp, 0.09388481739853197_dp, 0.15485475069686305_dp, &
             0.2523924548090117_dp, 0.4068366053084554_dp, 0.6490913884563478_dp, &
             1.0258926665366521_dp, 1.6079360107994058_dp, 2.5033948043719034_dp, &
             3.8840950722938197_dp, 6.051333589748005_dp, 9.691788275891206_dp, &
             ! w
             0.00014422331203087961_dp, 0.000366817828320172_dp, 0.0006836027200453245_dp, &
             0.0012035377444222029_dp, 0.0021034007134757096_dp, 0.0036529349024215893_dp, &
             0.006271171436251541_dp, 0.010618842583150186_dp, 0.017732875959945806_dp, &
             0.029224115132592453_dp, 0.047569993405388866_dp, 0.07654627577754439_dp, &
             0.12186163689246807_dp, 0.19209196968868958_dp, 0.3000765188025008_dp, &
             0.4650968948346712_dp, 0.7166276244326747_dp, 1.1020270430120542_dp, &
             1.7067134247371432_dp, 2.7264535603396656_dp, 4.902431804326037_dp]

      CASE (595)

         aw(:) = & ! a
            [3.083377978935453e-05_dp, 0.0001716918817843317_dp, 0.00047016234008688887_dp, &
             0.0010330577445665406_dp, 0.0020756637538341624_dp, 0.003985744196797509_dp, &
             0.007428346797028242_dp, 0.013520613055502718_dp, 0.02411162341928319_dp, &
             0.04222055329478319_dp, 0.07271445563788197_dp, 0.12334656570201324_dp, &
             0.20633331010896683_dp, 0.3407331791900437_dp, 0.5560235495363512_dp, &
             0.8975058425831819_dp, 1.4346744226900925_dp, 2.275061638453358_dp, &
             3.5907050145294876_dp, 5.683864561369749_dp, 9.241189399766812_dp, &
             ! w
             8.011632840203526e-05_dp, 0.00020840708614676008_dp, 0.00040557197218575364_dp, &
             0.0007550993662412823_dp, 0.0013930606728961821_dp, 0.0025351052964841412_dp, &
             0.004531749822278851_dp, 0.007953849399608116_dp, 0.013720351878088203_dp, &
             0.02329179212333578_dp, 0.038962544293425896_dp, 0.06429900804198811_dp, &
             0.10479269780388148_dp, 0.16883229334972397_dp, 0.2691642694828368_dp, &
             0.4251652810015576_dp, 0.6666972571667594_dp, 1.0418492388024758_dp, &
             1.6369572152923662_dp, 2.648162791712954_dp, 4.813063877831505_dp]

      CASE (596)

         aw(:) = & ! a
            [2.1843886267148253e-05_dp, 0.0001226115344584977_dp, 0.0003412445362479306_dp, &
             0.0007677866770065332_dp, 0.0015851381803132431_dp, 0.0031267123806553525_dp, &
             0.005974531545979752_dp, 0.01112401268704387_dp, 0.02024997142908746_dp, &
             0.036127839190946226_dp, 0.06329257560393403_dp, 0.10905857618050065_dp, &
             0.1850834948879888_dp, 0.3097474479418764_dp, 0.5117566118040039_dp, &
             0.8356186163043576_dp, 1.3501405787534337_dp, 2.1624585651509625_dp, &
             3.444683730574412_dp, 5.499599959573985_dp, 9.01395053028111_dp, &
             ! w
             5.685567373893893e-05_dp, 0.0001502882705863255_dp, 0.00030133892991527587_dp, &
             0.0005813318543203359_dp, 0.0011073624809622472_dp, 0.002070120939024701_dp, &
             0.0037871123913737793_dp, 0.006784157156423117_dp, 0.011919636682893794_dp, &
             0.02057535159513807_dp, 0.03494775205842657_dp, 0.05848847775239787_dp, &
             0.09656611035083078_dp, 0.15745738782834195_dp, 0.2538423170885136_dp, &
             0.40512892282713914_dp, 0.6413709506048875_dp, 1.0110486304571666_dp, &
             1.601018295015051_dp, 2.607690435600062_dp, 4.766900034742349_dp]

      CASE (597)

         aw(:) = & ! a
            [1.7112421593039018e-05_dp, 9.667887908343418e-05_dp, 0.0002725993795411437_dp, &
             0.0006247505069310555_dp, 0.001316254650473843_dp, 0.0026473835104980285_dp, &
             0.005149190726116361_dp, 0.009741454936799017_dp, 0.01798935036656839_dp, &
             0.03251317395340915_dp, 0.05763422839237732_dp, 0.10038164215363311_dp, &
             0.17204611425473573_dp, 0.29055757932899445_dp, 0.4841046235435331_dp, &
             0.7966550263577111_dp, 1.2965398845963385_dp, 2.0906096632109947_dp, &
             3.351008538943259_dp, 5.380872387007378_dp, 8.86704752750853_dp, &
             ! w
             4.4602503512288176e-05_dp, 0.0001194339909226873_dp, 0.0002451466441127063_dp, &
             0.0004855039030383321_dp, 0.0009460416633712225_dp, 0.0018021710205014941_dp, &
             0.0033505882612748705_dp, 0.006088166580896316_dp, 0.010833865291437199_dp, &
             0.018917650224075534_dp, 0.03247072571972182_dp, 0.05486721783516996_dp, &
             0.0913912127189436_dp, 0.1502403237361068_dp, 0.24404374097076204_dp, &
             0.3922227747900555_dp, 0.6249528853887316_dp, 0.9909750652499932_dp, &
             1.5775040719445264_dp, 2.581156129169046_dp, 4.73664626737336_dp]

      CASE (598)

         aw(:) = & ! a
            [1.41649915911182e-05_dp, 8.047399413750059e-05_dp, 0.00022943618302964997_dp, &
             0.0005339007069024527_dp, 0.0011432774315932592_dp, 0.0023348741837511846_dp, &
             0.004604210346816311_dp, 0.008817847557679646_dp, 0.01646313255382169_dp, &
             0.03004934363197619_dp, 0.053743722552847054_dp, 0.0943682075397624_dp, &
             0.16294507398423763_dp, 0.27707255577447965_dp, 0.46455489062468663_dp, &
             0.7689553326998437_dp, 1.2582438544762815_dp, 2.0390486035596584_dp, &
             3.2835296248615986_dp, 5.295084122334434_dp, 8.760654763508924_dp, &
             ! w
             3.6964108046494346e-05_dp, 0.00010008079766551082_dp, 0.0002094623058182378_dp, &
             0.00042356799284893395_dp, 0.0008399481991473502_dp, 0.0016233635819141474_dp, &
             0.0030556998175141504_dp, 0.005612973525604237_dp, 0.010085500817981104_dp, &
             0.01776528598319665_dp, 0.030735351685566282_dp, 0.05231204673070483_dp, &
             0.08771573443395678_dp, 0.1450832612696229_dp, 0.23700291350613867_dp, &
             0.3829018510939877_dp, 0.6130422282941844_dp, 0.9763576546764727_dp, &
             1.5603337233482597_dp, 2.561752368669122_dp, 4.7145282901975465_dp]

      CASE (599)

         aw(:) = & ! a
            [1.0658693363771162e-05_dp, 6.112716585570099e-05_dp, 0.00017752753948224734_dp, &
             0.00042336093012651987_dp, 0.0009297709482899602_dp, 0.0019434695866266387_dp, &
             0.003912268389572392_dp, 0.007630569595321666_dp, 0.014479204405932394_dp, &
             0.026814217807765356_dp, 0.048588528520964645_dp, 0.08633366861709256_dp, &
             0.15069290097592897_dp, 0.2587925858841355_dp, 0.43788580983815056_dp, &
             0.7309503643078487_dp, 1.2054270297429985_dp, 1.9676098500571977_dp, &
             3.1896685541669147_dp, 5.175374708251614_dp, 8.611837673854831_dp, &
             ! w
             2.7870025895968315e-05_dp, 7.687434278540856e-05_dp, 0.00016605276560382017_dp, &
             0.0003467205740320005_dp, 0.0007058403459088256_dp, 0.001393846710751239_dp, &
             0.0026722805230958197_dp, 0.004988175081253384_dp, 0.009091702553352312_dp, &
             0.016221225232550988_dp, 0.028391097046579633_dp, 0.04883453628449765_dp, &
             0.08267913787571335_dp, 0.13797169422191538_dp, 0.2272371892571991_dp, &
             0.3699052175608948_dp, 0.5963567025351203_dp, 0.955799820659188_dp, &
             1.5361153935084064_dp, 2.534342063449899_dp, 4.683291704847945_dp]

      CASE (600)

         aw(:) = & ! a
            [7.892434153316376e-06_dp, 4.5788817789895694e-05_dp, 0.00013595708158935886_dp, &
             0.0003334197450044836_dp, 0.0007527599584934758_dp, 0.001612903287966996_dp, &
             0.0033178729718671596_dp, 0.0065950281879726185_dp, 0.012725129681698973_dp, &
             0.023918803241542497_dp, 0.043923665303214225_dp, 0.07899058578567784_dp, &
             0.13939334710808485_dp, 0.24179426233703347_dp, 0.4128993522007532_dp, &
             0.6950990600003744_dp, 1.1552956846103808_dp, 1.8994336900335373_dp, &
             3.0996769096229384_dp, 5.060167666236354_dp, 8.46821297892514_dp, &
             ! w
             2.068746536878967e-05_dp, 5.8366174355884795e-05_dp, 0.0001307403941695114_dp, &
             0.0002825766070063738_dp, 0.0005912922369900919_dp, 0.001194107145135195_dp, &
             0.002333350602644015_dp, 0.004428340557145883_dp, 0.008190478884113032_dp, &
             0.014805816746590095_dp, 0.026221068552197097_dp, 0.04558666377887202_dp, &
             0.07793656848444662_dp, 0.13122487471400268_dp, 0.21790838526485265_dp, &
             0.3574121831292319_dp, 0.5802285309385055_dp, 0.935836061127093_dp, &
             1.5125157488527603_dp, 2.507583126606479_dp, 4.6528058410856445_dp]

      CASE (601)

         aw(:) = & ! a
            [4.418388821010736e-06_dp, 2.6370994115626698e-05_dp, 8.243143951282628e-05_dp, &
             0.00021459032298976595_dp, 0.0005120728769743897_dp, 0.0011509921719024172_dp, &
             0.0024667437155003764_dp, 0.005079773663539318_dp, 0.010108773048559434_dp, &
             0.019525542332661537_dp, 0.0367361458456207_dp, 0.06751879269641345_dp, &
             0.1215176047961805_dp, 0.21459459998503147_dp, 0.37250040508925586_dp, &
             0.6365849539892988_dp, 1.0727785358893198_dp, 1.7863717442812288_dp, &
             2.9494801311566308_dp, 4.8668903872545135_dp, 8.226328780379669_dp, &
             ! w
             1.1651168641595598e-05_dp, 3.47038903064258e-05_dp, 8.409306993493593e-05_dp, &
             0.0001944654163319163_dp, 0.00042869180768247654_dp, 0.0009030286038907991_dp, &
             0.0018284541239802245_dp, 0.0035783353694742244_dp, 0.00679891264113387_dp, &
             0.012587133020572096_dp, 0.022772912159559053_dp, 0.040361596251024597_dp, &
             0.07022015730768517_dp, 0.12013312348093634_dp, 0.20242563801366176_dp, &
             0.33649835211553897_dp, 0.553022018683502_dp, 0.9019421184630673_dp, &
             1.472256887039661_dp, 2.461817935667705_dp, 4.600684550507741_dp]

      CASE (602)

         aw(:) = & ! a
            [2.0743271806678598e-06_dp, 1.3073066405216227e-05_dp, 4.45673502581949e-05_dp, &
             0.00012660782684807668_dp, 0.00032535893157724117_dp, 0.0007773352089554563_dp, &
             0.0017527248978991834_dp, 0.0037678609628291116_dp, 0.007780175804185964_dp, &
             0.015519208114120065_dp, 0.030038358779849415_dp, 0.056619610071248064_dp, &
             0.1042353544726883_dp, 0.1878801249953549_dp, 0.33225157016566387_dp, &
             0.5775311972238041_dp, 0.9885311982867303_dp, 1.66975650498371_dp, &
             2.7932114967129467_dp, 4.664386299049412_dp, 7.9715740003446784_dp, &
             ! w
             5.534883336124387e-06_dp, 1.819505046125667e-05_dp, 4.953744928212405e-05_dp, &
             0.00012502596147360274_dp, 0.0002942194229029913_dp, 0.000652966679398471_dp, &
             0.0013807422709053692_dp, 0.002803780477493753_dp, 0.005500215110149796_dp, &
             0.010472143028510765_dp, 0.019422847999362777_dp, 0.03519729563841886_dp, &
             0.06247364102101911_dp, 0.10883861931331701_dp, 0.18645399322934625_dp, &
             0.31466901581062295_dp, 0.5243270159619963_dp, 0.8658789178529748_dp, &
             1.4291400665938667_dp, 2.412630288083889_dp, 4.544688126332677_dp]

      CASE (603)

         aw(:) = & ! a
            [1.1848840139033052e-06_dp, 7.928088911749566e-06_dp, 2.9269703388652913e-05_dp, &
             8.910420219507101e-05_dp, 0.00024174577469616895_dp, 0.000602876041777134_dp, &
             0.001407473526206281_dp, 0.0031143929338972405_dp, 0.006590314556407938_dp, &
             0.013426088394369429_dp, 0.02647005871107781_dp, 0.05071147138822162_dp, &
             0.09472094736384139_dp, 0.17296707080961687_dp, 0.3095000722938025_dp, &
             0.543771813076156_dp, 0.9398824410794905_dp, 1.601819250330051_dp, &
             2.7014868869158017_dp, 4.544803335824005_dp, 7.820462911779673_dp, &
             ! w
             3.2055517151208895e-06_dp, 1.1645329797178361e-05_dp, 3.4781949406695064e-05_dp, &
             9.34486899719997e-05_dp, 0.00023019445382517747_dp, 0.0005295612623495888_dp, &
             0.0011531655722754395_dp, 0.002400042410783118_dp, 0.004808360895478562_dp, &
             0.009323665567699509_dp, 0.017572545368782437_dp, 0.032301238353315775_dp, &
             0.058069502790228454_dp, 0.1023369677099046_dp, 0.1771555391128928_dp, &
             0.3018300360012234_dp, 0.5072969281932966_dp, 0.844312595932769_dp, &
             1.4032083732522427_dp, 2.3829555075306437_dp, 4.510915652022847_dp]

      CASE (604)

         aw(:) = & ! a
            [6.878751123100988e-07_dp, 4.9948767416867265e-06_dp, 2.015699004918653e-05_dp, &
             6.568802767519742e-05_dp, 0.00018743455161509808_dp, 0.0004858708901612455_dp, &
             0.0011697753797923571_dp, 0.002654543750041718_dp, 0.005737287713786191_dp, &
             0.011901236423373663_dp, 0.023833846557235198_dp, 0.0462923293979264_dp, &
             0.08752575769190367_dp, 0.16157779501740915_dp, 0.29197053807820966_dp, &
             0.5175542867838526_dp, 0.9018343271794528_dp, 1.5483557793555442_dp, &
             2.6289235916220406_dp, 4.449801582463132_dp, 7.700040386038932_dp, &
             ! w
             1.9000957811429553e-06_dp, 7.810564821052788e-06_dp, 2.554752626950506e-05_dp, &
             7.270906778891163e-05_dp, 0.0001866792005936189_dp, 0.0004434249568882415_dp, &
             0.0009908189388700367_dp, 0.0021066906488315744_dp, 0.004297675246827283_dp, &
             0.00846418906901924_dp, 0.016170946368608767_dp, 0.030083639167527126_dp, &
             0.0546642209806848_dp, 0.09726561097215576_dp, 0.1698448319003003_dp, &
             0.2916631565740895_dp, 0.493725512461792_dp, 0.8270341645085848_dp, &
             1.3823489161549267_dp, 2.3590323614542648_dp, 4.483693775727391_dp]

      CASE (605)

         aw(:) = & ! a
            [5.061640205986907e-07_dp, 3.901463019636847e-06_dp, 1.6621231641870892e-05_dp, &
             5.625200743355926e-05_dp, 0.00016488607412711224_dp, 0.00043614441685021045_dp, &
             0.001066838479367986_dp, 0.002452293136064197_dp, 0.0053571838404891815_dp, &
             0.01121413923570821_dp, 0.022634398225602648_dp, 0.04426448571974849_dp, &
             0.08419908424199538_dp, 0.1562765354008451_dp, 0.2837620898658193_dp, &
             0.505211424593177_dp, 0.8838359412734615_dp, 1.5229591564512728_dp, &
             2.594331429778299_dp, 4.404383614480078_dp, 7.642348953780425_dp, &
             ! w
             1.421847853168403e-06_dp, 6.343941882114338e-06_dp, 2.1818316695028234e-05_dp, &
             6.403312137967499e-05_dp, 0.0001680209625352613_dp, 0.0004057818334235415_dp, &
             0.0009187664110742089_dp, 0.0019748059914727178_dp, 0.004065544646288029_dp, &
             0.008069779773294754_dp, 0.015522364908592219_dp, 0.02904982931900183_dp, &
             0.05306617908861603_dp, 0.09487147002913786_dp, 0.16637487522935984_dp, &
             0.286814102187985_dp, 0.48722488066562347_dp, 0.8187279211409486_dp, &
             1.3722938354689747_dp, 2.347483116177906_dp, 4.470553404219168_dp]

      CASE (606)

         aw(:) = & ! a
            [4.100938733228521e-07_dp, 3.3155394914994624e-06_dp, 1.4676907157299696e-05_dp, &
             5.094618385319114e-05_dp, 0.00015199147272580924_dp, 0.00040733605745022275_dp, &
             0.0010065839612636732_dp, 0.0023328989731728326_dp, 0.005131201803264373_dp, &
             0.010803164170675303_dp, 0.021913206172056034_dp, 0.04303960746488527_dp, &
             0.08218152686751376_dp, 0.15304984050498888_dp, 0.278749798912173_dp, &
             0.4976528599748241_dp, 0.8727858248165798_dp, 1.5073319699678924_dp, &
             2.5730056001144685_dp, 4.376341217310294_dp, 7.606688885079443_dp, &
             ! w
             1.1687630938559981e-06_dp, 5.54424000123924e-06_dp, 1.9718654817081773e-05_dp, &
             5.9052016080665624e-05_dp, 0.00015716176210840287_dp, 0.0003836425515132985_dp, &
             0.0008760300901730673_dp, 0.001896030458208616_dp, 0.003926062860727896_dp, &
             0.00783156643042515_dp, 0.015128870890417048_dp, 0.02842011464034791_dp, &
             0.05208931261756143_dp, 0.09340327280130209_dp, 0.16424079622420096_dp, &
             0.2838241160233927_dp, 0.48320731465291844_dp, 0.8135844997577173_dp, &
             1.366058408159859_dp, 2.340315333753395_dp, 4.462398553417637_dp]

      CASE (607)

         aw(:) = & ! a
            [3.501357202075409e-07_dp, 2.9459693996539737e-06_dp, 1.3426973328470624e-05_dp, &
             4.7482089803544514e-05_dp, 0.00014347589354796487_dp, 0.00038814453276351515_dp, &
             0.0009661661178699956_dp, 0.00225235994199906_dp, 0.0049780455709448985_dp, &
             0.010523517221249844_dp, 0.021420777857497974_dp, 0.042200739412231465_dp, &
             0.08079610790521065_dp, 0.1508288892607995_dp, 0.275292530420094_dp, &
             0.49242945014670403_dp, 0.8651367590576851_dp, 1.496498733615495_dp, &
             2.558203541609602_dp, 4.356857920045129_dp, 7.581894954949414_dp, &
             ! w
             1.010724147932948e-06_dp, 5.033108794495802e-06_dp, 1.834657966789752e-05_dp, &
             5.575410701856889e-05_dp, 0.00014990614428587735_dp, 0.00036874629611273956_dp, &
             0.0008471132800042783_dp, 0.001842479847515402_dp, 0.003830870702682751_dp, &
             0.007668440384675904_dp, 0.014858610778179576_dp, 0.027986479957459145_dp, &
             0.05141505042147568_dp, 0.09238775326185764_dp, 0.16276191003943608_dp, &
             0.2817485787224856_dp, 0.4804142828131193_dp, 0.810004236404613_dp, &
             1.3617138652122631_dp, 2.3353185233346876_dp, 4.456713823855711_dp]

      CASE (608)

         aw(:) = & ! a
            [2.788872510079027e-07_dp, 2.5015172326619714e-06_dp, 1.1893342531609396e-05_dp, &
             4.31652429499386e-05_dp, 0.00013274363548895136_dp, 0.000363750189970843_dp, &
             0.0009144450456379911_dp, 0.0021487335321277484_dp, 0.004780087465197236_dp, &
             0.010160668353126024_dp, 0.020779708411780732_dp, 0.04110547655044329_dp, &
             0.07898260306123993_dp, 0.14791505559610219_dp, 0.2707474633014034_dp, &
             0.48555008592337023_dp, 0.8550465147165376_dp, 1.4821879623223857_dp, &
             2.5386265936917582_dp, 4.331065042303935_dp, 7.549048672876_dp, &
             ! w
             8.228289636356286e-07_dp, 4.409511560022702e-06_dp, 1.6635225176741835e-05_dp, &
             5.15877295813827e-05_dp, 0.00014065768585962049_dp, 0.00034962869166831225_dp, &
             0.0008097986366680321_dp, 0.0017730647829614257_dp, 0.0037070063448228553_dp, &
             0.007455483174206394_dp, 0.014504782020311642_dp, 0.027417324229650517_dp, &
             0.05052807349179981_dp, 0.09104916136954654_dp, 0.16080899140673677_dp, &
             0.2790032823400865_dp, 0.4767146260880311_dp, 0.8052560273436701_dp, &
             1.3559467494679023_dp, 2.3286821687664747_dp, 4.449164055024924_dp]

      CASE (609)

         aw(:) = & ! a
            [2.2331049379156777e-07_dp, 2.1493362107956597e-06_dp, 1.0648525332767434e-05_dp, &
             3.959877089846541e-05_dp, 0.00012376428800077265_dp, 0.00034314638375491495_dp, &
             0.0008704363112021186_dp, 0.002060029594783014_dp, 0.004609790775546505_dp, &
             0.009847202998571773_dp, 0.020223874460895987_dp, 0.04015282821336016_dp, &
             0.07740083420588519_dp, 0.1453672737761853_dp, 0.2667646134676391_dp, &
             0.4795098377342551_dp, 0.8461715776313841_dp, 1.4695816306250906_dp, &
             2.5213590183078898_dp, 4.308291294087543_dp, 7.520025232375245_dp, &
             ! w
             6.761641402555621e-07_dp, 3.906504271368701e-06_dp, 1.5219967735416549e-05_dp, &
             4.809290314842326e-05_dp, 0.0001328228608435159_dp, 0.0003333109289956591_dp, &
             0.0007777571311883246_dp, 0.0017131639888326245_dp, 0.0035996733075395857_dp, &
             0.007270287177887106_dp, 0.014196119050221367_dp, 0.02691945566967618_dp, &
             0.04975029370021081_dp, 0.08987279454658673_dp, 0.15908936697521675_dp, &
             0.2765816598168249_dp, 0.47344605898772424_dp, 0.8010555456821149_dp, &
             1.3508398088544546_dp, 2.322802236825114_dp, 4.442475034650325_dp]

      CASE (610)

         aw(:) = & ! a
            [1.6096310157758968e-07_dp, 1.745556264548495e-06_dp, 9.17905978498298e-06_dp, &
             3.530256560731041e-05_dp, 0.00011279352524850985_dp, 0.00031770738024748126_dp, &
             0.0008156537639023174_dp, 0.0019488792610287153_dp, 0.004395231445814714_dp, &
             0.009450434185452402_dp, 0.01951752866336194_dp, 0.03893802589373031_dp, &
             0.07537764977804465_dp, 0.14209971246675993_dp, 0.26164430114180565_dp, &
             0.4717279409198301_dp, 0.834715933004493_dp, 1.4532825603151018_dp, &
             2.499001945379153_dp, 4.278772035515032_dp, 7.4823742587314275_dp, &
             ! w
             5.114221428998643e-07_dp, 3.316705865711376e-06_dp, 1.3513345930342916e-05_dp, &
             4.3811406375243465e-05_dp, 0.000123118420931326_dp, 0.00031293028733250377_dp, &
             0.000737472025888166_dp, 0.0016374415939337899_dp, 0.003463369106033315_dp, &
             0.007034181505999811_dp, 0.013801265341094505_dp, 0.026280653893201885_dp, &
             0.04874968704417199_dp, 0.08835579903077295_dp, 0.1568670496936143_dp, &
             0.2734461051177345_dp, 0.469206669371532_dp, 0.7955996198724832_dp, &
             1.3441992933320523_dp, 2.315151972966625_dp, 4.43377235389112_dp]

      CASE (611)

         aw(:) = & ! a
            [1.5525223911803474e-07_dp, 1.7079307630783979e-06_dp, 9.039312804975794e-06_dp, &
             3.488846949389105e-05_dp, 0.00011172630045699344_dp, 0.00031521588043412_dp, &
             0.0008102601724418445_dp, 0.001937889892473448_dp, 0.004373944336610003_dp, &
             0.009410954103945535_dp, 0.01944706780961745_dp, 0.03881657996249597_dp, &
             0.07517500107351_dp, 0.14177186841365733_dp, 0.2611297910531973_dp, &
             0.4709449345803328_dp, 0.8335619068660356_dp, 1.4516389079134377_dp, &
             2.4967454014347084_dp, 4.275790504661201_dp, 7.478569449641779_dp, &
             ! w
             4.963110691971377e-07_dp, 3.26085242745912e-06_dp, 1.3348743445358974e-05_dp, &
             4.3394204565772326e-05_dp, 0.00012216606605915654_dp, 0.0003109195086290514_dp, &
             0.0007334806436291823_dp, 0.0016299132169148047_dp, 0.0034497783792020883_dp, &
             0.0070105814011425715_dp, 0.013761712713974061_dp, 0.02621654426105851_dp, &
             0.04864909895290178_dp, 0.08820307161296995_dp, 0.15664301130909247_dp, &
             0.2731296194225628_dp, 0.46877831303722_dp, 0.7950478463847267_dp, &
             1.3435272619685936_dp, 2.3143774598196103_dp, 4.432891311378277_dp]

      CASE (612)

         aw(:) = & ! a
            [0.0025498370150328175_dp, 0.013548969777634706_dp, 0.033817943783834084_dp, &
             0.06424953119334481_dp, 0.10627975304616633_dp, 0.16207613815785146_dp, &
             0.23479913882388248_dp, 0.32893749312111326_dp, 0.450705961835072_dp, &
             0.6085016447686721_dp, 0.8134463091063422_dp, 1.0800779942862897_dp, &
             1.4272779198638608_dp, 1.8795392499056383_dp, 2.468734525435586_dp, &
             3.2366628180256325_dp, 4.238943312512284_dp, 5.551503932825093_dp, &
             7.2827145663903305_dp, 9.599777136767443_dp, 12.799970662820616_dp, &
             17.59344480624227_dp, &
             ! w
             0.006556575820857464_dp, 0.015523085992047754_dp, 0.02516140409226648_dp, &
             0.03593802829197264_dp, 0.04847931133583091_dp, 0.0636345758902718_dp, &
             0.08255289856653057_dp, 0.10675206175174021_dp, 0.1381755122195695_dp, &
             0.17925816196500918_dp, 0.23303896694606002_dp, 0.30335047363213585_dp, &
             0.3951027279091373_dp, 0.5146907878671897_dp, 0.6706040029739012_dp, &
             0.8744204749875732_dp, 1.142609350548909_dp, 1.5001857181231342_dp, &
             1.9891334481256275_dp, 2.6913589917013168_dp, 3.8099502339343427_dp, &
             6.151546796176026_dp]

      CASE (613)

         aw(:) = & ! a
            [0.0014433340386207543_dp, 0.007688392310249193_dp, 0.019279234224944517_dp, &
             0.03688917533394893_dp, 0.06163378396171419_dp, 0.09525074537776242_dp, &
             0.14034568784044757_dp, 0.200695519607924_dp, 0.28160142129290044_dp, &
             0.3903123150009398_dp, 0.5365742231545787_dp, 0.7333763702377785_dp, &
             0.9979697637341145_dp, 1.353254099028081_dp, 1.8296850115231906_dp, &
             2.4679765042769186_dp, 3.3231453968588354_dp, 4.471098972104022_dp, &
             6.020717964130783_dp, 8.139833862536845_dp, 11.125057670998743_dp, &
             15.678729852361213_dp, &
             ! w
             0.003713462441096966_dp, 0.00883562839083754_dp, 0.014456236618062607_dp, &
             0.020946604959131625_dp, 0.028828100701419928_dp, 0.03883500473592093_dp, &
             0.051978528412584706_dp, 0.0695977507610946_dp, 0.09341322433495981_dp, &
             0.12562063830520065_dp, 0.16905128676816808_dp, 0.22740539901027826_dp, &
             0.3055668201409863_dp, 0.41003392517468645_dp, 0.5495486747937728_dp, &
             0.7360999452634414_dp, 0.9867036394465815_dp, 1.32696824727902_dp, &
             1.7992917757189784_dp, 2.4852614735754917_dp, 3.585169939050862_dp, &
             5.890302419371061_dp]

      CASE (614)

         aw(:) = & ! a
            [0.0010306343501664476_dp, 0.005499231563027791_dp, 0.01383349827107724_dp, &
             0.0265993900808953_dp, 0.04475207822999643_dp, 0.06980682492527533_dp, &
             0.10406842817267943_dp, 0.15090869184117758_dp, 0.215093367125172_dp, &
             0.30319499719802995_dp, 0.42415335184399106_dp, 0.5900495327971398_dp, &
             0.8171651863150591_dp, 1.1274243926114875_dp, 1.550374562931633_dp, &
             2.1259821473449616_dp, 2.9087815074786754_dp, 3.9745523714679707_dp, &
             5.432422039917516_dp, 7.450671490328925_dp, 10.325865977094331_dp, &
             14.756856074517449_dp, &
             ! w
             0.0026526748248829027_dp, 0.006332949644865581_dp, 0.010428000997806431_dp, &
             0.015260141588040224_dp, 0.02129391608002459_dp, 0.029195076534516938_dp, &
             0.03988474153491644_dp, 0.05458335544802141_dp, 0.07487223431702189_dp, &
             0.10280824658475067_dp, 0.14110454665011496_dp, 0.19337774294779675_dp, &
             0.26447517091195055_dp, 0.36092237375507297_dp, 0.4915723524824677_dp, &
             0.6686264207948882_dp, 0.909416270057912_dp, 1.2399335441278_dp, &
             1.702912155379959_dp, 2.379933761144888_dp, 3.470040102233809_dp, &
             5.756937427107729_dp]

      CASE (615)

         aw(:) = & ! a
            [0.0008104199790971963_dp, 0.004329875360730728_dp, 0.010919012319056941_dp, &
             0.02107673237142483_dp, 0.03565649285758547_dp, 0.05602932398536984_dp, &
             0.08429943257418211_dp, 0.12356253950538487_dp, 0.17821692803580538_dp, &
             0.25437202738110054_dp, 0.3604160241889657_dp, 0.5078046150652303_dp, &
             0.7121420980421576_dp, 0.9946562131749794_dp, 1.3842276646310172_dp, &
             1.920252111992597_dp, 2.656868488960321_dp, 3.669712288097814_dp, &
             5.068051260362004_dp, 7.020499406454845_dp, 9.823704410141259_dp, &
             14.174435088645948_dp, &
             ! w
             0.002086505465145412_dp, 0.004994391287343446_dp, 0.008265217758225094_dp, &
             0.012189748117177721_dp, 0.017194645140954118_dp, 0.02389742801595452_dp, &
             0.03315367691473142_dp, 0.04609892897663443_dp, 0.06421876876729789_dp, &
             0.08947647592157501_dp, 0.12450301352326126_dp, 0.1728506675634372_dp, &
             0.23932904425005275_dp, 0.3304660870304807_dp, 0.4551747091761119_dp, &
             0.6257905360208326_dp, 0.8598614155317791_dp, 1.183658805451631_dp, &
             1.6401869362244077_dp, 2.3110916977896885_dp, 3.3946746991979184_dp, &
             5.669797142951594_dp]

      CASE (616)

         aw(:) = & ! a
            [0.000672087511475086_dp, 0.0035947054183472003_dp, 0.009083881993347333_dp, &
             0.017591439976140398_dp, 0.029898578901409817_dp, 0.047272106253395535_dp, &
             0.07166850076409409_dp, 0.10597777312236537_dp, 0.15432400098495969_dp, &
             0.2224716732390262_dp, 0.3183974030771918_dp, 0.45308673892441814_dp, &
             0.6416285695762037_dp, 0.9047123865908624_dp, 1.2706934035218946_dp, &
             1.7785055184801077_dp, 2.481953467258232_dp, 3.456530860901502_dp, &
             4.811592320437186_dp, 6.7160119585640246_dp, 9.466554998203438_dp, &
             13.758573565893395_dp, &
             ! w
             0.0017307848794568584_dp, 0.0041519802524565335_dp, 0.006899934997819808_dp, &
             0.010242768374466787_dp, 0.014579206722752402_dp, 0.020489899917730776_dp, &
             0.028779679355755518_dp, 0.0405195853742844_dp, 0.05712422522558132_dp, &
             0.08048743941881376_dp, 0.11317694631593994_dp, 0.15869195987723836_dp, &
             0.22180615220011649_dp, 0.30903994739476703_dp, 0.42934193007211885_dp, &
             0.595141807058348_dp, 0.8241488988880186_dp, 1.1428536067336916_dp, &
             1.5944846584505448_dp, 2.260772273647255_dp, 3.3395202020108496_dp, &
             5.60610623943483_dp]

      CASE (617)

         aw(:) = & ! a
            [0.0005063013743488893_dp, 0.002712787611711358_dp, 0.006878560171515061_dp, &
             0.013392060728198618_dp, 0.022935896645317134_dp, 0.03663196032652959_dp, &
             0.05622748586918589_dp, 0.08431860056070759_dp, 0.12463785106108936_dp, &
             0.1824576214136149_dp, 0.26516475573963166_dp, 0.38306435128385913_dp, &
             0.5504889380824046_dp, 0.7873248203387914_dp, 1.1211272303598854_dp, &
             1.5901086505618087_dp, 2.2475295833277014_dp, 3.1686224666594622_dp, &
             4.462834516292547_dp, 6.299427453335221_dp, 8.975416451876987_dp, &
             13.184308089492959_dp, &
             ! w
             0.001304372659245205_dp, 0.0031402228978207516_dp, 0.005254432516770554_dp, &
             0.007883898331350975_dp, 0.011387629548733064_dp, 0.016292044710639664_dp, &
             0.02332703893194826_dp, 0.033470688296525344_dp, 0.04803709678108123_dp, &
             0.06882036328494114_dp, 0.09829319312262905_dp, 0.13986970465204632_dp, &
             0.1982592331882949_dp, 0.27995640866067345_dp, 0.3939463420383559_dp, &
             0.5527834423655349_dp, 0.7744083228662891_dp, 1.0856411205501726_dp, &
             1.5300686203625449_dp, 2.1895987210126213_dp, 3.26139926305612_dp, &
             5.516009839239283_dp]

      CASE (618)

         aw(:) = & ! a
            [0.0003745365136890047_dp, 0.002010938742561351_dp, 0.005119314038479357_dp, &
             0.010030061600758183_dp, 0.01733388889706926_dp, 0.028014388712027473_dp, &
             0.0436151707268864_dp, 0.06644465469390803_dp, 0.09985274691474497_dp, &
             0.1486302704296793_dp, 0.21958209355794206_dp, 0.32233244541629946_dp, &
             0.47044384389332883_dp, 0.6829685773053592_dp, 0.9866119113627806_dp, &
             1.4187973417742634_dp, 2.0321632884481837_dp, 2.901607861554979_dp, &
             4.136625105064002_dp, 5.906873105924336_dp, 8.509708045070505_dp, &
             12.637016008506167_dp, &
             ! w
             0.000965363281953965_dp, 0.0023337582508529296_dp, 0.003936547907743397_dp, &
             0.005981161609432484_dp, 0.008787633586983897_dp, 0.012827313323225745_dp, &
             0.018754505971305256_dp, 0.027456238360757803_dp, 0.04014899712892212_dp, &
             0.058526961594539344_dp, 0.08496234944321378_dp, 0.12277332511237751_dp, &
             0.17658944834174675_dp, 0.2528609560266091_dp, 0.360590351441224_dp, &
             0.5124416667367092_dp, 0.72658263876052_dp, 1.0301780477641367_dp, &
             1.4672133875969238_dp, 2.119842512679787_dp, 3.184695372753126_dp, &
             5.427677356202323_dp]

      CASE (619)

         aw(:) = & ! a
            [0.00020791631177922895_dp, 0.0011215576115341443_dp, 0.002881277587342122_dp, &
             0.0057277275160863275_dp, 0.010105412362063743_dp, 0.016770405324037792_dp, &
             0.026924485919518657_dp, 0.042392190719159964_dp, 0.06588055696093978_dp, &
             0.10136496839774164_dp, 0.1546479615518937_dp, 0.2341547740325862_dp, &
             0.35205766361810475_dp, 0.5258613793548387_dp, 0.7806445176312687_dp, &
             1.1522621668013824_dp, 1.6920459781761579_dp, 2.4740999448194474_dp, &
             3.6078621869746055_dp, 5.263691913493065_dp, 7.739760682851753_dp, &
             11.725620514661394_dp, &
             ! w
             0.0005364677150234348_dp, 0.00130915525385517_dp, 0.002249112270561428_dp, &
             0.003516048983454188_dp, 0.0053631362663547014_dp, 0.008164303355271952_dp, &
             0.012443719513996662_dp, 0.018936537096784868_dp, 0.02869359385043377_dp, &
             0.04322927420950235_dp, 0.0647224871099812_dp, 0.09629387004026087_dp, &
             0.14239269869895335_dp, 0.20934229131747628_dp, 0.30612380147438845_dp, &
             0.4455505203477931_dp, 0.6461730120898519_dp, 0.9357959485392984_dp, &
             1.3592103902597157_dp, 1.9991818670317985_dp, 3.051637588010361_dp, &
             5.274743376553333_dp]

      CASE (620)

         aw(:) = & ! a
            [0.0001471710349114242_dp, 0.0007964283238371479_dp, 0.0020589666400482724_dp, &
             0.0041346670676657244_dp, 0.007399362011036264_dp, 0.012498745872237612_dp, &
             0.020466740916424406_dp, 0.032890613598826925_dp, 0.05216105943866098_dp, &
             0.08184646328125295_dp, 0.12723849744538981_dp, 0.19613666759968496_dp, &
             0.2999693795086896_dp, 0.4553912580033871_dp, 0.686560914454681_dp, &
             1.0284151057074777_dp, 1.5314829201664935_dp, 2.2693330000065535_dp, &
             3.3512877011453703_dp, 4.94806350992283_dp, 7.358365821367246_dp, &
             11.270786599832105_dp, &
             ! w
             0.0003800055385784594_dp, 0.000933338699389642_dp, 0.0016239022722212787_dp, &
             0.0025885536580075577_dp, 0.004046539472539789_dp, 0.006321896533186526_dp, &
             0.009874557653625002_dp, 0.015365506374564575_dp, 0.023761180611981632_dp, &
             0.036478724592218015_dp, 0.05558690158181038_dp, 0.08408802094333777_dp, &
             0.12631592475527947_dp, 0.1885008895204224_dp, 0.27958327696553686_dp, &
             0.4124277695295831_dp, 0.6057717894232834_dp, 0.8877687175607093_dp, &
             1.3036856034687678_dp, 1.936706722484125_dp, 2.9825243016709715_dp, &
             5.195448539479865_dp]

      CASE (621)

         aw(:) = & ! a
            [0.000115126529151328_dp, 0.0006245898803638764_dp, 0.0016228126960023878_dp, &
             0.003285072370393567_dp, 0.005944847791810198_dp, 0.010178627753497673_dp, &
             0.016914798187963254_dp, 0.027591536967412126_dp, 0.04439965148672822_dp, &
             0.07064742847500395_dp, 0.11129557181084923_dp, 0.17373237765032498_dp, &
             0.2688902586273879_dp, 0.412848323366157_dp, 0.6291319815031875_dp, &
             0.952033554436149_dp, 1.4315041901002497_dp, 2.1407086591738773_dp, &
             3.1888541267228843_dp, 4.746884550329156_dp, 7.113897113042695_dp, &
             10.977950238749214_dp, &
             ! w
             0.0002974321961854475_dp, 0.0007342487847945801_dp, 0.0012903520200170308_dp, &
             0.0020883247126737008_dp, 0.00332556285051951_dp, 0.005294186756249974_dp, &
             0.008413884982695352_dp, 0.013298756645919474_dp, 0.020860101876359848_dp, &
             0.032449552558703146_dp, 0.050059844405449846_dp, 0.07660961255208805_dp, &
             0.11634840799236064_dp, 0.1754344892901406_dp, 0.26276898087098216_dp, &
             0.3912386670448714_dp, 0.5796971670712566_dp, 0.8565316777219318_dp, &
             1.267344101703483_dp, 1.8956350842413046_dp, 2.936996041080307_dp, &
             5.1432642736468015_dp]

      CASE (622)

         aw(:) = & ! a
            [9.514367291620342e-05_dp, 0.0005172709654815866_dp, 0.0013496509500609878_dp, &
             0.002750636162709005_dp, 0.005024098350995886_dp, 0.008697667742000297_dp, &
             0.014625188214634419_dp, 0.024139481461350202_dp, 0.0392893016178502_dp, &
             0.06319642222628762_dp, 0.10058182898448903_dp, 0.15853295688946847_dp, &
             0.2476156128409093_dp, 0.3834790112794715_dp, 0.5891701416639776_dp, &
             0.898487922099274_dp, 1.3609332693224756_dp, 2.0493467890519708_dp, &
             3.0728292294129096_dp, 4.602485817216761_dp, 6.937721321765447_dp, &
             10.766253760503595_dp, &
             ! w
             0.0002459219473295276_dp, 0.0006096815755691054_dp, 0.0010804821743334398_dp, &
             0.001770829053446422_dp, 0.002862400284638159_dp, 0.004624582015563799_dp, &
             0.007448725891021077_dp, 0.011915481323164235_dp, 0.01889585291374632_dp, &
             0.029692673830559676_dp, 0.04624119184447866_dp, 0.07139577990665456_dp, &
             0.1093399115507425_dp, 0.16617337311744232_dp, 0.2507618426717478_dp, &
             0.3760017690770574_dp, 0.5608278246799532_dp, 0.8338002926317234_dp, &
             1.2407776166400746_dp, 1.8655141384575193_dp, 2.9035563143259813_dp, &
             5.1049609072768725_dp]

      CASE (623)

         aw(:) = & ! a
            [7.13592602953326e-05_dp, 0.00038931505362841393_dp, 0.0010229001663757625_dp, &
             0.0021080853469690884_dp, 0.003908912280027379_dp, 0.0068867293285242845_dp, &
             0.01179429779960341_dp, 0.019821310659832368_dp, 0.032822110060808846_dp, &
             0.05366061188096963_dp, 0.08672283428904878_dp, 0.13867133500502646_dp, &
             0.21954868776753408_dp, 0.3443838061331869_dp, 0.535525179860289_dp, &
             0.8260415203975644_dp, 1.2647556730487695_dp, 1.9240055871194643_dp, &
             2.9127062906594374_dp, 4.402181196223899_dp, 6.692300183988522_dp, &
             10.470374439791838_dp, &
             ! w
             0.00018458807343583818_dp, 0.0004608466693838815_dp, 0.0008280986466169222_dp, &
             0.0013851374779097951_dp, 0.0022919144304074947_dp, 0.003786825675332275_dp, &
             0.006222876025953849_dp, 0.01013457518150216_dp, 0.01633597442955237_dp, &
             0.026059708114393242_dp, 0.041157129296882936_dp, 0.06438737977541568_dp, &
             0.09983403206068221_dp, 0.15350552677575705_dp, 0.23420708813959973_dp, &
             0.3548385374544674_dp, 0.5344423777298078_dp, 0.8018257422487299_dp, &
             1.2032266345637266_dp, 1.8227918917133776_dp, 2.8560488027248003_dp, &
             5.050579148637396_dp]

      CASE (624)

         aw(:) = & ! a
            [5.259694976356289e-05_dp, 0.0002881402996578436_dp, 0.0007633887292551905_dp, &
             0.0015941662418338454_dp, 0.003007917514492729_dp, 0.005404637613018257_dp, &
             0.009443606087814827_dp, 0.01618159434941184_dp, 0.027290489775856935_dp, &
             0.04538909497904027_dp, 0.07454088104296895_dp, 0.12099408847367578_dp, &
             0.19427462426170708_dp, 0.3087909560785084_dp, 0.48618322335785347_dp, &
             0.7587679233895701_dp, 1.174655343174268_dp, 1.8056379928380988_dp, &
             2.7604051692599185_dp, 4.210479468821175_dp, 6.456219840123295_dp, &
             10.184627120582004_dp, &
             ! w
             0.00013617892489091487_dp, 0.0003428252348200111_dp, 0.0006261917491684965_dp, &
             0.0010722809011884272_dp, 0.0018205124597653688_dp, 0.0030805661377643332_dp, &
             0.005169950838676587_dp, 0.008579264374559897_dp, 0.014066876001072053_dp, &
             0.022795501947998915_dp, 0.03653159876412404_dp, 0.05793625577970115_dp, &
             0.09098787643388874_dp, 0.14159534642345972_dp, 0.21849231140971936_dp, &
             0.33456911582344556_dp, 0.5089647311618987_dp, 0.7707290917457327_dp, &
             1.166490627864167_dp, 1.7808204404334202_dp, 2.8092810452644454_dp, &
             4.997083558490311_dp]

      CASE (625)

         aw(:) = & ! a
            [2.907628904077249e-05_dp, 0.00016082076404549538_dp, 0.0004344226262905925_dp, &
             0.000935039866616583_dp, 0.0018328848707020412_dp, 0.0034315182108896193_dp, &
             0.006243306390460532_dp, 0.011113960485139207_dp, 0.019420565118187023_dp, &
             0.033378358807301514_dp, 0.05650996713571822_dp, 0.09435652357765235_dp, &
             0.1555466129045531_dp, 0.253391770241248_dp, 0.4082558539800291_dp, &
             0.6510708114984333_dp, 1.028599996026718_dp, 1.6115614693892595_dp, &
             2.508139912548048_dp, 3.8901562541340384_dp, 6.05888858834258_dp, &
             9.701018208484912_dp, &
             ! w
             7.543962146410753e-05_dp, 0.00019361118472649178_dp, 0.00036718303617062903_dp, &
             0.0006616570874122843_dp, 0.0011834229834969839_dp, 0.002097215495283438_dp, &
             0.0036640937154858028_dp, 0.006301740769991501_dp, 0.010673039318204436_dp, &
             0.017818070112319753_dp, 0.029351245221424006_dp, 0.04775394580328058_dp, &
             0.07680618496930319_dp, 0.122220852210936_dp, 0.19257729406487864_dp, &
             0.3007162043507918_dp, 0.4659168788385335_dp, 0.7176458827644393_dp, &
             1.1032472256367993_dp, 1.7081218801678342_dp, 2.728030963374664_dp, &
             4.904233360385957_dp]

      CASE (626)

         aw(:) = & ! a
            [2.0565388925150248e-05_dp, 0.00011452086738863314_dp, 0.0003136409940865938_dp, &
             0.0006892618540574246_dp, 0.0013851734754525018_dp, 0.002660386561993515_dp, &
             0.004959184594424867_dp, 0.009027974061423995_dp, 0.016102354309045712_dp, &
             0.028200033096785246_dp, 0.048573946082239555_dp, 0.08240631462638882_dp, &
             0.13786227352142752_dp, 0.22767678515526849_dp, 0.3715304050376075_dp, &
             0.599598522246047_dp, 0.9578899455685994_dp, 1.5164982000898621_dp, &
             2.383284206644635_dp, 3.73019408610862_dp, 5.859015232690362_dp, &
             9.456376372561994_dp, &
             ! w
             5.3436320129668144e-05_dp, 0.00013902007350660616_dp, 0.0002705992840788777_dp, &
             0.0005039390287103258_dp, 0.0009299301932313514_dp, 0.001692647409765458_dp, &
             0.003026314668002718_dp, 0.005312442079680487_dp, 0.009165238802257964_dp, &
             0.01556098295787941_dp, 0.026033389716835276_dp, 0.04296634623718816_dp, &
             0.07002935076265354_dp, 0.11282199043147696_dp, 0.1798279128849883_dp, &
             0.2838440038224664_dp, 0.44420648856691275_dp, 0.6905930126272187_dp, &
             1.0707361369610693_dp, 1.6705153985027792_dp, 2.6858687149928993_dp, &
             4.856093234006202_dp]

      CASE (627)

         aw(:) = & ! a
            [1.609052231918399e-05_dp, 9.009247051933442e-05_dp, 0.00024948071463684515_dp, &
             0.0005572536975209218_dp, 0.0011410895881533065_dp, 0.002232864066776534_dp, &
             0.004235203306907991_dp, 0.007833073623532659_dp, 0.014173444552420823_dp, &
             0.025148827489848043_dp, 0.04383934716025634_dp, 0.07519483722635223_dp, &
             0.12707730021135805_dp, 0.21184071986381642_dp, 0.34870934356364736_dp, &
             0.5673474201799109_dp, 0.9132468032319611_dp, 1.45606441575003_dp, &
             2.303423381715056_dp, 3.627339038363811_dp, 5.729944660907998_dp, &
             9.29787769290753_dp, &
             ! w
             4.185826305307244e-05_dp, 0.00011009520112019157_dp, 0.00021872915447843373_dp, &
             0.0004174813429819902_dp, 0.0007877670580220323_dp, 0.0014610780035391713_dp, &
             0.002654850403603292_dp, 0.004727453228189115_dp, 0.008261528702862685_dp, &
             0.014191502731255152_dp, 0.023997545648579352_dp, 0.039998042618849663_dp, &
             0.0657871441778338_dp, 0.1068856464861666_dp, 0.1717082822357783_dp, &
             0.27301595559947645_dp, 0.4301756299678513_dp, 0.6730008855624591_dp, &
             1.0494855277800719_dp, 1.6458419594230096_dp, 2.6581535061540267_dp, &
             4.824463093496843_dp]

      CASE (628)

         aw(:) = & ! a
            [1.3305128161768152e-05_dp, 7.484483849903708e-05_dp, 0.00020921431279245214_dp, &
             0.00047366931164595977_dp, 0.0009847260553730605_dp, 0.001955478929988737_dp, &
             0.003759587969985003_dp, 0.0070389264410185_dp, 0.012877741347257892_dp, &
             0.023079205235352323_dp, 0.04059917197933613_dp, 0.0702191345034593_dp, &
             0.119579941024401_dp, 0.2007556469243858_dp, 0.33263274752569577_dp, &
             0.544494103839673_dp, 0.8814421372321949_dp, 1.4128003770418798_dp, &
             2.2460045209204793_dp, 3.553113386180909_dp, 5.636518976441996_dp, &
             9.182887253811643_dp, &
             ! w
             3.4646946406306446e-05_dp, 9.198028959622438e-05_dp, 0.00018589042112813993_dp, &
             0.0003618585743323598_dp, 0.0006947409657712479_dp, 0.00130729901127845_dp, &
             0.0024050786957438806_dp, 0.004329824182817451_dp, 0.007641295559829068_dp, &
             0.013243340979253797_dp, 0.02257669593810452_dp, 0.0379110871371775_dp, &
             0.06278413125383121_dp, 0.10265672379663088_dp, 0.16589002088145904_dp, &
             0.26521480370347716_dp, 0.420016957188921_dp, 0.6602079616764603_dp, &
             1.0339757942811347_dp, 1.6277861052124318_dp, 2.637844018849805_dp, &
             4.801291850775574_dp]

      CASE (629)

         aw(:) = & ! a
            [9.994542740935452e-06_dp, 5.666436362998256e-05_dp, 0.00016089650336480974_dp, &
             0.0003723340067523509_dp, 0.0007926338891327812_dp, 0.0016099040749552114_dp, &
             0.00315902992422393_dp, 0.006023642179884833_dp, 0.011202408166728408_dp, &
             0.02037554156616011_dp, 0.03632647691947301_dp, 0.06360135519041037_dp, &
             0.10952954268536703_dp, 0.18578792300483257_dp, 0.3107801275293393_dp, &
             0.5132392549917393_dp, 0.8377008664344392_dp, 1.3529965228826508_dp, &
             2.166276717918943_dp, 3.4496505228681706_dp, 5.5058835064249285_dp, &
             9.021714441715968_dp, &
             ! w
             2.6069739402847784e-05_dp, 7.029728726324608e-05_dp, 0.00014608462923361386_dp, &
             0.0002931967587981263_dp, 0.0005777823809891892_dp, 0.001110924663326483_dp, &
             0.002081910677238233_dp, 0.0038094440103938506_dp, 0.0068212874581884365_dp, &
             0.011978179782407453_dp, 0.020664796632037394_dp, 0.035081077350493484_dp, &
             0.0586827296947812_dp, 0.09684271394637756_dp, 0.15784181259572214_dp, &
             0.25436254930586366_dp, 0.40581209123918516_dp, 0.6422376969978276_dp, &
             1.012105986377126_dp, 1.602254840102212_dp, 2.609084595329209_dp, &
             4.768489877216812_dp]

      CASE (630)

         aw(:) = & ! a
            [7.385803069679391e-06_dp, 4.227574694811219e-05_dp, 0.0001223191163656762_dp, &
             0.0002902801054977791_dp, 0.000634352507020876_dp, 0.0013200016688163828_dp, &
             0.0026466560925759008_dp, 0.005144039699098433_dp, 0.0097306998692072_dp, &
             0.01797053349015137_dp, 0.032482296228305806_dp, 0.05758529670594118_dp, &
             0.10030605859938087_dp, 0.17193195077297738_dp, 0.29038882231680097_dp, &
             0.4838605491838165_dp, 0.796309975940986_dp, 1.2960638180350468_dp, &
             2.0899698717806348_dp, 3.350172551857285_dp, 5.379810930581977_dp, &
             8.86573240555866_dp, &
             ! w
             1.930427853367265e-05_dp, 5.304586990760832e-05_dp, 0.00011386068161043624_dp, &
             0.00023626199362835186_dp, 0.00047854702457381354_dp, 0.0009411025287812773_dp, &
             0.001797934521557631_dp, 0.003345775885001045_dp, 0.006081561709059225_dp, &
             0.010824092794473432_dp, 0.018902971335607945_dp, 0.032448864559875425_dp, &
             0.05483522091516178_dp, 0.09134536694924299_dp, 0.15017619103932486_dp, &
             0.2439564036196247_dp, 0.39210740982256_dp, 0.6248057509645889_dp, &
             0.9907947822223216_dp, 1.5772925510685056_dp, 2.5809172423866595_dp, &
             4.736373936739432_dp]

      CASE (631)

         aw(:) = & ! a
            [4.115776479310656e-06_dp, 2.411091715911636e-05_dp, 7.289598787314097e-05_dp, &
             0.00018270555863340862_dp, 0.00042113531761360246_dp, 0.000918895701336235_dp, &
             0.0019201355511383707_dp, 0.003869038599387592_dp, 0.00755495901793931_dp, &
             0.014351494332714721_dp, 0.026604353815777797_dp, 0.04825198768892436_dp, &
             0.08580625861471436_dp, 0.1498846529828027_dp, 0.25758129461707013_dp, &
             0.43611143227920507_dp, 0.7284124343155312_dp, 1.2018882628721763_dp, &
             1.9628093615255051_dp, 3.1833455512262274_dp, 5.167294070117107_dp, &
             8.601776929190557_dp, &
             ! w
             1.0810345188889222e-05_dp, 3.107711443421804e-05_dp, 7.162742980568071e-05_dp, &
             0.00015881869889964977_dp, 0.00033901739593960846_dp, 0.0006958031127464125_dp, &
             0.0013783701049361041_dp, 0.002647137342734728_dp, 0.004947366366394651_dp, &
             0.009026606995623458_dp, 0.016119619786181386_dp, 0.028236086579038488_dp, &
             0.04860351975916543_dp, 0.0823430936734954_dp, 0.1374952980316822_dp, &
             0.22658057386609046_dp, 0.3690284268622359_dp, 0.5952276920259331_dp, &
             0.9544053187516136_dp, 1.534469552748104_dp, 2.532477479787969_dp, &
             4.681167161159148_dp]

      CASE (632)

         aw(:) = & ! a
            [2.9305924895869842e-06_dp, 1.746588021850344e-05_dp, 5.4458374568486694e-05_dp, &
             0.00014137766009695115_dp, 0.00033653439896220847_dp, 0.0007548527496616238_dp, &
             0.0016149024336884344_dp, 0.0033205479987406367_dp, 0.006599245851076902_dp, &
             0.012732075450476141_dp, 0.02393020827089087_dp, 0.043942071931938026_dp, &
             0.07901966773713946_dp, 0.13943828233577243_dp, 0.2418621302578669_dp, &
             0.4129994860663833_dp, 0.6952432263860158_dp, 1.1554978966979625_dp, &
             1.8997094388903577_dp, 3.1000417425438385_dp, 5.06063560401213_dp, &
             8.468797162886261_dp, &
             ! w
             7.725516861387516e-06_dp, 2.2948552619922402e-05_dp, 5.5404525147651974e-05_dp, &
             0.0001277430275140598_dp, 0.0002809706840034871_dp, 0.0005907844113491288_dp, &
             0.001194401745754514_dp, 0.002334424663937724_dp, 0.004430404753644415_dp, &
             0.008193961165177384_dp, 0.0148113872318636_dp, 0.026229688892851245_dp, &
             0.0455996442864698_dp, 0.07795561204486247_dp, 0.1312520748882399_dp, &
             0.2179461285374548_dp, 0.3574628892842476_dp, 0.5802941745418465_dp, &
             0.9359175063050069_dp, 1.5126121941158353_dp, 2.5076925839219726_dp, &
             4.652930527115194_dp]

      CASE (633)

         aw(:) = & ! a
            [2.306174184144005e-06_dp, 1.3942077704310813e-05_dp, 4.4542827301993846e-05_dp, &
             0.00011870317245919812_dp, 0.00028914976624303294_dp, 0.0006612451346436_dp, &
             0.0014378812907588148_dp, 0.0029979405922768224_dp, 0.006030161184301492_dp, &
             0.011757257796546421_dp, 0.022304869364607207_dp, 0.04129974306377381_dp, &
             0.07482633777651287_dp, 0.13293784043221613_dp, 0.23201756887371683_dp, &
             0.39844020405143754_dp, 0.6742374529450357_dp, 1.125979071636211_dp, &
             1.859389038737105_dp, 3.046619981435971_dp, 4.992038216815227_dp, &
             8.383085655430445_dp, &
             ! w
             6.09799434345543e-06_dp, 1.860312946108542e-05_dp, 4.650264066094958e-05_dp, &
             0.00011021580996852004_dp, 0.0002475195510616622_dp, 0.000529229248136808_dp, &
             0.0010850393997767066_dp, 0.002146259565366962_dp, 0.004116013484315798_dp, &
             0.007682782253863377_dp, 0.014001409375520133_dp, 0.024977915861741543_dp, &
             0.04371248294521763_dp, 0.07518165279510011_dp, 0.12728180337618636_dp, &
             0.21242588020667255_dp, 0.35003287938612626_dp, 0.5706592850049449_dp, &
             0.923946461035049_dp, 1.4984214987473523_dp, 2.491578285380307_dp, &
             4.634575679349051_dp]

      CASE (634)

         aw(:) = & ! a
            [1.9167341710834677e-06_dp, 1.1732939415540843e-05_dp, 3.825587180532255e-05_dp, &
             0.00010410275220852359_dp, 0.000258167492293394_dp, 0.0005992089507552246_dp, &
             0.001319197775231019_dp, 0.002779480057935501_dp, 0.005641434848854611_dp, &
             0.011086290577696107_dp, 0.021178560626502488_dp, 0.03945759882288879_dp, &
             0.07188696226609412_dp, 0.1283588310449827_dp, 0.2250519566356205_dp, &
             0.38809690292211496_dp, 0.6592596319494779_dp, 1.104861800226036_dp, &
             1.830460683345014_dp, 3.008196909414185_dp, 4.942601492904754_dp, &
             8.321222911182769_dp, &
             ! w
             5.081836203782143e-06_dp, 1.5861174079219656e-05_dp, 4.0769226803539744e-05_dp, &
             9.869784994404195e-05_dp, 0.00022519886548116018_dp, 0.0004876597434992643_dp, &
             0.0010104445186403786_dp, 0.0020168119876538_dp, 0.0038981070805253325_dp, &
             0.007326130843566232_dp, 0.013432935660525535_dp, 0.024094683916204878_dp, &
             0.042374485546041556_dp, 0.07320623685794946_dp, 0.12444304818760343_dp, &
             0.20846432479715432_dp, 0.34468295739329824_dp, 0.5637011756413218_dp, &
             0.9152796880265074_dp, 1.4881287118735915_dp, 2.47987867707641_dp, &
             4.621251074311755_dp]

      CASE (635)

         aw(:) = & ! a
            [1.4526713724223414e-06_dp, 9.08473901898181e-06_dp, 3.061944212328142e-05_dp, &
             8.6060184739444e-05_dp, 0.00021924418970420545_dp, 0.0005201525745205668_dp, &
             0.0011661063155848053_dp, 0.002494742688117069_dp, 0.005130198087643422_dp, &
             0.010196883032712201_dp, 0.01967513142984135_dp, 0.03698332459219403_dp, &
             0.06791685338341993_dp, 0.12214290048939122_dp, 0.2155530107827441_dp, &
             0.3739333319546899_dp, 0.6386728183862534_dp, 1.075738619559729_dp, &
             1.7904466363100695_dp, 2.9549150974802854_dp, 4.873906826343713_dp, &
             8.235130859142439_dp, &
             ! w
             3.869508185825249e-06_dp, 1.2549273531393551e-05_dp, 3.3681257015489096e-05_dp, &
             8.415120164832965e-05_dp, 0.00019655669995435456_dp, 0.00043364660810554524_dp, &
             0.000912509887585908_dp, 0.001845347890115005_dp, 0.0036072326385272876_dp, &
             0.006846792419674942_dp, 0.012664245883225053_dp, 0.02289382449863763_dp, &
             0.040546279994912476_dp, 0.07049487030033823_dp, 0.12053059943964924_dp, &
             0.2029837898330989_dp, 0.33725637860402813_dp, 0.5540128513490986_dp, &
             0.9031814650529043_dp, 1.473733373092902_dp, 2.4634990612961887_dp, &
             4.60259878286634_dp]

      CASE (636)

         aw(:) = & ! a
            [1.085589752657538e-06_dp, 6.9728537617290735e-06_dp, 2.4418713178803406e-05_dp, &
             7.10783551714023e-05_dp, 0.00018625175765404317_dp, 0.00045196433874997654_dp, &
             0.0010321132651102676_dp, 0.002242407990007849_dp, 0.004672261828590809_dp, &
             0.00939273150226986_dp, 0.018304590395138598_dp, 0.03471120028933651_dp, &
             0.06424716020214687_dp, 0.11636335404415295_dp, 0.20667373180833964_dp, &
             0.360629672694155_dp, 0.6192513576853955_dp, 1.0481563321712526_dp, &
             1.7524189111155486_dp, 2.904129346601461_dp, 4.808275070590371_dp, &
             8.152732459150297_dp, &
             ! w
             2.9090419927337045e-06_dp, 9.880348014549353e-06_dp, 2.77915178824644e-05_dp, &
             7.174257694053725e-05_dp, 0.0001716519919076494_dp, 0.0003859723114971427_dp, &
             0.0008249907138330951_dp, 0.0016904933160286398_dp, 0.0033421181002970674_dp, &
             0.006406371814138363_dp, 0.011952893071099027_dp, 0.021775382022870965_dp, &
             0.0388336452846908_dp, 0.06794148598001919_dp, 0.11682836622087606_dp, &
             0.19777493463890497_dp, 0.3301698525099383_dp, 0.5447355297055014_dp, &
             0.8915621148708586_dp, 1.459877249681947_dp, 2.4477141753149776_dp, &
             4.584626217811039_dp]

      CASE (637)

         aw(:) = & ! a
            [6.224431281538362e-07_dp, 4.27249258996541e-06_dp, 1.6252943498189566e-05_dp, &
             5.0672355137218765e-05_dp, 0.00013997020529883417_dp, 0.000353952707704477_dp, &
             0.0008355872390364983_dp, 0.0018659615297569223_dp, 0.003979065943914597_dp, &
             0.008159972875517616_dp, 0.016180116573415067_dp, 0.031154373878512873_dp, &
             0.05845186877074167_dp, 0.10716378586598481_dp, 0.19243913316093703_dp, &
             0.3391644085997884_dp, 0.5877323407461922_dp, 1.0031592819519326_dp, &
             1.6900961601207674_dp, 2.8205718888427906_dp, 4.699951071061254_dp, &
             8.016417246117232_dp, &
             ! w
             1.694475270981636e-06_dp, 6.407588365259449e-06_dp, 1.9757970289128656e-05_dp, &
             5.4186085421936505e-05_dp, 0.0001354758978179595_dp, 0.0003152817236420061_dp, &
             0.0006929994120358675_dp, 0.001453568245346649_dp, 0.002931426723551464_dp, &
             0.00571664630206478_dp, 0.010828077297736145_dp, 0.019991546704514262_dp, &
             0.036080807768958834_dp, 0.06380822909502767_dp, 0.11079684246112612_dp, &
             0.1892391105384695_dp, 0.3184954007460031_dp, 0.5293799939902119_dp, &
             0.8722539267280729_dp, 1.4367839721200395_dp, 2.4213641138161845_dp, &
             4.55462934975407_dp]

      CASE (638)

         aw(:) = & ! a
            [4.532562799594293e-07_dp, 3.26878734999866e-06_dp, 1.310279521964712e-05_dp, &
             4.249209846715176e-05_dp, 0.00012082093518252708_dp, 0.00031235986624583327_dp, &
             0.0007504521403401499_dp, 0.0017000678880343262_dp, 0.0036691213185990135_dp, &
             0.007601850177671225_dp, 0.015207747118217482_dp, 0.029510726995139624_dp, &
             0.05575087781395988_dp, 0.10284335228442375_dp, 0.18570808382078036_dp, &
             0.32895131097217595_dp, 0.5726520401592662_dp, 0.9815230690057081_dp, &
             1.6599978550476977_dp, 2.7800681697240037_dp, 4.647284785520889_dp, &
             7.949995037481279_dp, &
             ! w
             1.249717643725271e-06_dp, 5.08693360054884e-06_dp, 1.6531295536842016e-05_dp, &
             4.685988762883603e-05_dp, 0.00011996777012040138_dp, 0.00028433812458919413_dp, &
             0.0006342293017384891_dp, 0.0013465546833093518_dp, 0.0027436382184886014_dp, &
             0.005397887809564109_dp, 0.010303335618756094_dp, 0.019152382420540383_dp, &
             0.03477605767786949_dp, 0.06183590292962856_dp, 0.10790095757559305_dp, &
             0.18511790591877123_dp, 0.31283032173907516_dp, 0.5218952916023468_dp, &
             0.8628071245651988_dp, 1.425453395965989_dp, 2.408415787742415_dp, &
             4.539891226053357_dp]

      CASE (639)

         aw(:) = & ! a
            [3.63740571041785e-07_dp, 2.7312576145227483e-06_dp, 1.137336857547309e-05_dp, &
             3.789505483325795e-05_dp, 0.0001098600318011658_dp, 0.00028820684073496054_dp, &
             0.0007004376614657953_dp, 0.0016016735442746317_dp, 0.0034838006608538365_dp, &
             0.0072658277810501385_dp, 0.014618801473853648_dp, 0.028509940886325216_dp, &
             0.05409859250720024_dp, 0.10018935036277664_dp, 0.18155774890926699_dp, &
             0.32263269714411774_dp, 0.5632938703862731_dp, 0.9680601811056361_dp, &
             1.6412249262644083_dp, 2.7547540453008534_dp, 4.6143157467676685_dp, &
             7.9083648631221655_dp, &
             ! w
             1.0140963202412089e-06_dp, 4.368314114037337e-06_dp, 1.4715669445840793e-05_dp, &
             4.264716986550399e-05_dp, 0.00011091372630792967_dp, 0.00026605898017014904_dp, &
             0.0005991797662263173_dp, 0.0012822231428428461_dp, 0.0026299791274983914_dp, &
             0.005203820117594278_dp, 0.009982205853548788_dp, 0.0186364744122212_dp, &
             0.03397061525051465_dp, 0.06061384263455983_dp, 0.10610063141309317_dp, &
             0.18254800907116142_dp, 0.3092879761443027_dp, 0.517203741948951_dp, &
             0.8568735416170536_dp, 1.418325657440262_dp, 2.400263528805926_dp, &
             4.530612827850915_dp]

      CASE (640)

         aw(:) = & ! a
            [3.077840821133388e-07_dp, 2.392009243763714e-06_dp, 1.0261226862316773e-05_dp, &
             3.488932893869941e-05_dp, 0.00010260157530157011_dp, 0.00027205396680495913_dp, &
             0.0006667250573443441_dp, 0.0015349201867330272_dp, 0.0033573902089459665_dp, &
             0.00703555583758743_dp, 0.014213578734120918_dp, 0.027818919981082824_dp, &
             0.05295415884281253_dp, 0.09834596716185788_dp, 0.17866785975512275_dp, &
             0.3182231472326581_dp, 0.556749934505825_dp, 0.9586289559770258_dp, &
             1.6280530290652069_dp, 2.736968693465074_dp, 4.5911271573872705_dp, &
             7.879061189229068_dp, &
             ! w
             8.666908627455346e-07_dp, 3.909108559965584e-06_dp, 1.3527428823570999e-05_dp, &
             3.984903963722437e-05_dp, 0.0001048373469555314_dp, 0.00025369313971816075_dp, &
             0.0005753153350118134_dp, 0.0012381854596213628_dp, 0.002551818588850117_dp, &
             0.005069836800714532_dp, 0.009759731363646357_dp, 0.018277963193603128_dp, &
             0.033409368173551036_dp, 0.05976018738276161_dp, 0.1048402268183189_dp, &
             0.18074518466516518_dp, 0.30679841931444884_dp, 0.5139011879036711_dp, &
             0.8526909757713815_dp, 1.4132961911822142_dp, 2.3945079194948695_dp, &
             4.524062469931456_dp]

      CASE (641)

         aw(:) = & ! a
            [2.4103814806544383e-07_dp, 1.9828863468972035e-06_dp, 8.892458440490006e-06_dp, &
             3.112621582982953e-05_dp, 9.339672340844572e-05_dp, 0.0002513668688873825_dp, &
             0.0006232099401055233_dp, 0.0014482037763767143_dp, 0.0031922931500065793_dp, &
             0.0067334334125224715_dp, 0.01367980882935721_dp, 0.02690553004910012_dp, &
             0.051436807555299474_dp, 0.09589523094628315_dp, 0.17481640954167654_dp, &
             0.3123334626238051_dp, 0.5479921460740338_dp, 0.9459848232969446_dp, &
             1.6103665524174429_dp, 2.713056115376807_dp, 4.559916945373085_dp, &
             7.839589785978144_dp, &
             ! w
             6.907365523060062e-07_dp, 3.3475800016893185e-06_dp, 1.2038335949315703e-05_dp, &
             3.6290280018094995e-05_dp, 9.702897169395816e-05_dp, 0.00023767590692235968_dp, &
             0.0005442057794583839_dp, 0.0011804723784007742_dp, 0.0024489235489897404_dp, &
             0.004892766329469883_dp, 0.009464710820660667_dp, 0.017801114144700203_dp, &
             0.032660856364312145_dp, 0.05861894792059943_dp, 0.1031515205888081_dp, &
             0.17832494275276503_dp, 0.303450271132607_dp, 0.5094526130277873_dp, &
             0.8470494821875164_dp, 1.4065055786951166_dp, 2.3867326188554623_dp, &
             4.515213948548148_dp]

      CASE (642)

         aw(:) = & ! a
            [1.8835198768753053e-07_dp, 1.655163141434324e-06_dp, 7.767853488699547e-06_dp, &
             2.7971422271936744e-05_dp, 8.556491566287217e-05_dp, 0.00023356693127181766_dp, &
             0.0005854348419665418_dp, 0.001372381054699316_dp, 0.003047064776996418_dp, &
             0.0064663060617234135_dp, 0.013205775084944834_dp, 0.026091220699612793_dp, &
             0.05007943009714656_dp, 0.09369621133269618_dp, 0.1713511447392023_dp, &
             0.30702139855422717_dp, 0.5400759543368066_dp, 0.9345334201280188_dp, &
             1.5943209939161322_dp, 2.6913305237500067_dp, 4.53152801808003_dp, &
             7.8036555420105485_dp, &
             ! w
             5.517399553949089e-07_dp, 2.889653492614516e-06_dp, 1.0788562895210595e-05_dp, &
             3.325274142870607e-05_dp, 9.028547059373886e-05_dp, 0.00022371808461766243_dp, &
             0.0005168998098551514_dp, 0.0011295123042554256_dp, 0.0023576084416140485_dp, &
             0.004734939322710739_dp, 0.009200753072023286_dp, 0.017373041759390886_dp, &
             0.03198690023257358_dp, 0.057588620343763344_dp, 0.10162322946489928_dp, &
             0.17612978922007602_dp, 0.30040748688745306_dp, 0.5054026696846113_dp, &
             0.8419059152590296_dp, 1.4003074290664757_dp, 2.3796313556839412_dp, &
             4.5071328990104815_dp]

      CASE (643)

         aw(:) = & ! a
            [1.2346376587197007e-07_dp, 1.2422701485189172e-06_dp, 6.300998213159383e-06_dp, &
             2.3749595418446697e-05_dp, 7.489006051760966e-05_dp, 0.00020896895769364996_dp, &
             0.0005326662805833826_dp, 0.0012655321399984989_dp, 0.0028409147850449144_dp, &
             0.006084773330042828_dp, 0.012525109756709202_dp, 0.024916510596851297_dp, &
             0.04811326408925896_dp, 0.09049931156486629_dp, 0.1662969836519555_dp, &
             0.29925100116945247_dp, 0.528465936613629_dp, 0.9176993713274656_dp, &
             1.5706850182920673_dp, 2.6592718941092843_dp, 4.489578414164911_dp, &
             7.750501858575766_dp, &
             ! w
             3.803623428754792e-07_dp, 2.297765919865831e-06_dp, 9.113818320269844e-06_dp, &
             2.909728582097957e-05_dp, 8.092623608086364e-05_dp, 0.0002041322787473526_dp, &
             0.0004782461633713341_dp, 0.0010568512125217107_dp, 0.0022266112574506887_dp, &
             0.004507338297061447_dp, 0.008818361313405623_dp, 0.016750399606735494_dp, &
             0.031003096001689958_dp, 0.056079761981500255_dp, 0.0993786263009129_dp, &
             0.17289728361889742_dp, 0.29591616630774_dp, 0.49941218028353873_dp, &
             0.8342843183732713_dp, 1.3911109483610424_dp, 2.3690871525765855_dp, &
             4.4951345242729905_dp]

      CASE (644)

         aw(:) = & ! a
            [1.0297967656240002e-07_dp, 1.1085496889876147e-06_dp, 5.8097120229033355e-06_dp, &
             2.2302564430945705e-05_dp, 7.117198100206764e-05_dp, 0.0002002989439588021_dp, &
             0.000513894394260242_dp, 0.0012272378227995335_dp, 0.002766574972144618_dp, &
             0.005946471176210231_dp, 0.012277270054106542_dp, 0.0244871162678801_dp, &
             0.04739210559800999_dp, 0.08932317821659377_dp, 0.16443252815740209_dp, &
             0.29637758102037026_dp, 0.5241633249195753_dp, 0.9114486796705003_dp, &
             1.5618937917651499_dp, 2.647330755963641_dp, 4.47393507086348_dp, &
             7.730663602175375_dp, &
             ! w
             3.261718111907601e-07_dp, 2.1010489906176792e-06_dp, 8.539149721413985e-06_dp, &
             2.764557002766996e-05_dp, 7.76156655549409e-05_dp, 0.00019713889179205033_dp, &
             0.0004643409697944965_dp, 0.0010305518984628523_dp, 0.002178953401583239_dp, &
             0.004424170574123751_dp, 0.008678097182038987_dp, 0.01652124188516167_dp, &
             0.030639934264252204_dp, 0.055521291114271565_dp, 0.09854583123662566_dp, &
             0.17169533993315336_dp, 0.2942428763766681_dp, 0.4971764802826427_dp, &
             0.8314357065956599_dp, 1.3876699254604818_dp, 2.36513945874929_dp, &
             4.490642595795109_dp]

      CASE (645)

         aw(:) = & ! a
            [9.744958304131219e-08_dp, 1.0720432579948353e-06_dp, 5.673844907917884e-06_dp, &
             2.189898390128409e-05_dp, 7.012897187268582e-05_dp, 0.00019785641975160915_dp, &
             0.0005085885147987631_dp, 0.0012163852625058323_dp, 0.002745461114725889_dp, &
             0.0059071183974160855_dp, 0.012206637633445712_dp, 0.024364573926812943_dp, &
             0.047186050009072215_dp, 0.08898676399255895_dp, 0.1638987215187362_dp, &
             0.2955541979246799_dp, 0.5229294621817844_dp, 0.9096549458515194_dp, &
             1.559369508336902_dp, 2.6439002808649326_dp, 4.469439189655929_dp, &
             7.724960396502579_dp, &
             ! w
             3.115272361025735e-07_dp, 2.046789561440139e-06_dp, 8.378811642172586e-06_dp, &
             2.7237910200027115e-05_dp, 7.668186167310419e-05_dp, 0.00019515965051577553_dp, &
             0.0004603951182157937_dp, 0.0010230727758135927_dp, 0.002165375536984058_dp, &
             0.004400438903430516_dp, 0.008638019146467266_dp, 0.01645568652631624_dp, &
             0.03053593511670295_dp, 0.055361210290825226_dp, 0.09830691482753337_dp, &
             0.17135025594719783_dp, 0.2937621357261106_dp, 0.49653376650515635_dp, &
             0.8306163712072967_dp, 1.3866798085553493_dp, 2.364003304613395_dp, &
             4.489349822212133_dp]

      CASE (646)

         aw(:) = & ! a
            [0.0013784527567334275_dp, 0.0073354844632425595_dp, 0.018359969705865502_dp, &
             0.03502942550932789_dp, 0.058289702515891675_dp, 0.08959653490759337_dp, &
             0.1311105964523301_dp, 0.18594175167845706_dp, 0.25843374169755695_dp, &
             0.35449679430290737_dp, 0.4820233176813449_dp, 0.6514394721188445_dp, &
             0.8764497569134696_dp, 1.1750392718170326_dp, 1.5708251549437284_dp, &
             2.0949094237780543_dp, 2.7885121062494354_dp, 3.706942131142376_dp, &
             4.926129947502942_dp, 6.554719238492812_dp, 8.760213250865423_dp, &
             11.839415233776139_dp, 16.497920468553467_dp, &
             ! w
             0.00354572268123833_dp, 0.008419694079078813_dp, 0.013723899364581463_dp, &
             0.019770325752220336_dp, 0.026989584770299464_dp, 0.0359800906589701_dp, &
             0.047561610147702445_dp, 0.06281920344881087_dp, 0.08314301912201755_dp, &
             0.11028942885960276_dp, 0.14648904740151114_dp, 0.19461084589556935_dp, &
             0.25838505593068395_dp, 0.34269989517715693_dp, 0.4540128542158546_dp, &
             0.6009620726696401_dp, 0.7953586283730821_dp, 1.0539711347571572_dp, &
             1.4021274023180144_dp, 1.8820102292923664_dp, 2.575302758463919_dp, &
             3.683469654055837_dp, 6.004428599991783_dp]

      CASE (647)

         aw(:) = & ! a
            [0.0009838433750908838_dp, 0.0052434702103699975_dp, 0.013161195082932432_dp, &
             0.025220671773101215_dp, 0.042227902831257706_dp, 0.06544576314488094_dp, &
             0.09677690802056031_dp, 0.1389878363126464_dp, 0.19596994186479394_dp, &
             0.2730571178152942_dp, 0.3774436108993491_dp, 0.5187535576303994_dp, &
             0.7098147054429543_dp, 0.9677002381150995_dp, 1.3151332568378022_dp, &
             1.782409081280922_dp, 2.4101128036163164_dp, 3.253179002717379_dp, &
             4.387491340512361_dp, 5.921965585700212_dp, 8.024496067416576_dp, &
             10.991668108635901_dp, 15.525222502428994_dp, &
             ! w
             0.002531568227368319_dp, 0.006029734418473026_dp, 0.009884808828892902_dp, &
             0.014366254036005877_dp, 0.019855613958281632_dp, 0.02689346062497072_dp, &
             0.036225608183600176_dp, 0.04883963416459039_dp, 0.06600672021458406_dp, &
             0.08935730037176266_dp, 0.12100695788899504_dp, 0.16373374434827284_dp, &
             0.22121102210315727_dp, 0.29831579902789673_dp, 0.4015553421818241_dp, &
             0.5396953344107225_dp, 0.7247638198482657_dp, 0.9738304012176817_dp, &
             1.312565267657188_dp, 1.7834173081309153_dp, 2.467966286243429_dp, &
             3.566291736228225_dp, 5.868424131929509_dp]

      CASE (648)

         aw(:) = & ! a
            [0.0007733451749411847_dp, 0.004126446422581911_dp, 0.010380457947273032_dp, &
             0.01996053388869254_dp, 0.033584305845319976_dp, 0.052390344963260546_dp, &
             0.07811061891535163_dp, 0.11327898502880308_dp, 0.1614767991746906_dp, &
             0.22764293851389547_dp, 0.31849418636000465_dp, 0.44310446733722775_dp, &
             0.6136936382370711_dp, 0.846691605275164_dp, 1.1641760565010792_dp, &
             1.5958420934257882_dp, 2.181781266464886_dp, 2.976610706787062_dp, &
             4.056132561496171_dp, 5.529429791006581_dp, 7.564698381371439_dp, &
             10.458494106139828_dp, 14.910230229878495_dp, &
             ! w
             0.0019904626321219174_dp, 0.004752115279114086_dp, 0.007825331882399034_dp, &
             0.011452292907696131_dp, 0.015982109728513053_dp, 0.021915147950907186_dp, &
             0.02994368605027909_dp, 0.04098489007279177_dp, 0.056226992719640136_dp, &
             0.07721521067732742_dp, 0.10598660941777005_dp, 0.14525308457861175_dp, &
             0.19863996923630922_dp, 0.27100336432018013_dp, 0.36886956796242293_dp, &
             0.5010780810072235_dp, 0.6797979865901491_dp, 0.9223087517289797_dp, &
             1.2545353217250466_dp, 1.719149774910329_dp, 2.397727246126472_dp, &
             3.489512104808864_dp, 5.779479043787369_dp]

      CASE (649)

         aw(:) = & ! a
            [0.0006411479248635202_dp, 0.003424399445834742_dp, 0.008630339909711753_dp, &
             0.01664311878123391_dp, 0.02811776389910474_dp, 0.04410343671493797_dp, &
             0.0662070484554279_dp, 0.09678960535069649_dp, 0.13920111363677218_dp, &
             0.19808610472624708_dp, 0.2798055840310687_dp, 0.3930214628429474_dp, &
             0.5494939208505794_dp, 0.7651598432960415_dp, 1.061593990328445_dp, &
             1.4680140159913153_dp, 2.0241075362987018_dp, 2.7842179701404697_dp, &
             3.824056597073975_dp, 5.252818375214606_dp, 7.238940571624984_dp, &
             10.079015448393468_dp, 14.47085627829025_dp, &
             ! w
             0.00165057711461096_dp, 0.003948383830537736_dp, 0.0065261492191724885_dp, &
             0.009606527488024248_dp, 0.013514866435068726_dp, 0.01872103203952206_dp, &
             0.025875861766723386_dp, 0.03584261034388069_dp, 0.04974756898427098_dp, &
             0.06907295452251423_dp, 0.09579652320540147_dp, 0.1325775235222265_dp, &
             0.18299955104276386_dp, 0.2518952848356535_dp, 0.3457966560788414_dp, &
             0.4735906749253684_dp, 0.647547528461446_dp, 0.8851055905287044_dp, &
             1.2123916202617506_dp, 1.6722672690680787_dp, 2.346339184988275_dp, &
             3.433280456586048_dp, 5.714423112450276_dp]

      CASE (650)

         aw(:) = & ! a
            [0.0004827586136186306_dp, 0.002582523947211592_dp, 0.00652828862179465_dp, &
             0.012649103360050854_dp, 0.021514853424688632_dp, 0.034051007309957686_dp, &
             0.05168819520599923_dp, 0.07654094288171073_dp, 0.111628798217135_dp, &
             0.1611764619157916_dp, 0.23103640646860754_dp, 0.3292771698582933_dp, &
             0.4669890452263814_dp, 0.6593797617232361_dp, 0.9272672650833411_dp, &
             1.299135552154824_dp, 1.8140338856516904_dp, 2.5258516610325015_dp, &
             3.5101187216445453_dp, 4.876166853234648_dp, 6.7928011209831025_dp, &
             9.556751007429314_dp, 13.863719858601991_dp, &
             ! w
             0.0012432682282453626_dp, 0.002983537501195038_dp, 0.004961553773013737_dp, &
             0.007373136756858046_dp, 0.010510088879566464_dp, 0.014797707747711709_dp, &
             0.020825501037925_dp, 0.02937835649869728_dp, 0.04149452516174276_dp, &
             0.058566527662603306_dp, 0.08248485775889107_dp, 0.11582703647554439_dp, &
             0.16210683219429933_dp, 0.22611061566030374_dp, 0.31436455122518836_dp, &
             0.43581138861819096_dp, 0.6028592074271457_dp, 0.8331774026770082_dp, &
             1.153200496001535_dp, 1.606098551942477_dp, 2.2735776855316536_dp, &
             3.3535651290761983_dp, 5.622321088044751_dp]

      CASE (651)

         aw(:) = & ! a
            [0.00035692023310357295_dp, 0.0019128752334149788_dp, 0.004852633616926041_dp, &
             0.00945491631376296_dp, 0.016210590129236452_dp, 0.02592780369047276_dp, &
             0.03986646023375293_dp, 0.059900050843840584_dp, 0.08872505438366671_dp, &
             0.1301559011363722_dp, 0.18954536231254243_dp, 0.2743721725499398_dp, &
             0.3950504478761171_dp, 0.5660386399682379_dp, 0.8073610964746365_dp, &
             1.1467139624836917_dp, 1.6224394080489497_dp, 2.2878978340828704_dp, &
             3.218371500254624_dp, 4.523292909063757_dp, 6.371852918156335_dp, &
             9.061014679349572_dp, 13.284596435150553_dp, &
             ! w
             0.0009195778520630333_dp, 0.0022149609710024475_dp, 0.003709826622298377_dp, &
             0.005574782458897983_dp, 0.008068998522385486_dp, 0.011572767041690859_dp, &
             0.016613404423587844_dp, 0.023898367419202288_dp, 0.03438046582522217_dp, &
             0.049363688639634355_dp, 0.07064838010330315_dp, 0.10072270488821705_dp, &
             0.14301861890330705_dp, 0.20226068962866398_dp, 0.2849518213563298_dp, &
             0.4000737709446778_dp, 0.5601610685629225_dp, 0.7831142642081589_dp, &
             1.0956942346302607_dp, 1.541421433114326_dp, 2.2021674780100557_dp, &
             3.275206621507311_dp, 5.531925426035051_dp]

      CASE (652)

         aw(:) = & ! a
            [0.00019789189844647632_dp, 0.0010649878171288582_dp, 0.0027234651961959575_dp, &
             0.005374548717725806_dp, 0.009384283220862263_dp, 0.015369429211464058_dp, &
             0.024304580834858498_dp, 0.037657962063126806_dp, 0.057583691066766536_dp, &
             0.08720448876336913_dp, 0.13101920601121675_dp, 0.19547855085950874_dp, &
             0.28979052809416106_dp, 0.42704294498751244_dp, 0.6257676531360138_dp, &
             0.9121310962247107_dp, 1.3230460435749691_dp, 1.910735194796546_dp, &
             2.7498559549133126_dp, 3.9499044644464085_dp, 5.680778760748135_dp, &
             8.24008277332823_dp, 12.318831434261737_dp, &
             ! w
             0.0005103331140406049_dp, 0.001239524790388038_dp, 0.002109968177448312_dp, &
             0.003251753194812805_dp, 0.004868736593361478_dp, 0.00726180067785983_dp, &
             0.01085008506003253_dp, 0.016211062141110212_dp, 0.024154157048959544_dp, &
             0.03582779518743183_dp, 0.05286353718083628_dp, 0.0775714003961799_dp, &
             0.11320820677637615_dp, 0.16434942012955056_dp, 0.2374103604805345_dp, &
             0.3413949149535763_dp, 0.4890254624467801_dp, 0.6986038745110555_dp, &
             0.9975093266876792_dp, 1.4299875628567857_dp, 2.07837499462709_dp, &
             3.1390257639054786_dp, 5.375144375514531_dp]

      CASE (653)

         aw(:) = & ! a
            [0.00013996012907137545_dp, 0.0007553529554818944_dp, 0.0019423634055118642_dp, &
             0.0038671946033628658_dp, 0.006837743957151046_dp, 0.011378627141444005_dp, &
             0.01832468563502512_dp, 0.028945478778156647_dp, 0.045129013545104325_dp, &
             0.06965504563013547_dp, 0.10659117476438364_dp, 0.16185730083750358_dp, &
             0.24402375620195257_dp, 0.3654355201113753_dp, 0.543793856419_dp, &
             0.8043881771437233_dp, 1.1832813270735483_dp, 1.731983053099483_dp, &
             2.5247116633074644_dp, 3.6709230752851725_dp, 5.340889692053782_dp, &
             7.832666548614906_dp, 11.836060856280595_dp, &
             ! w
             0.0003611662950579334_dp, 0.0008822319573707234_dp, 0.0015185931673152625_dp, &
             0.002381116213671972_dp, 0.0036458905000068408_dp, 0.005573017590205212_dp, &
             0.008527700693144891_dp, 0.013024072938109452_dp, 0.019799793571297068_dp, &
             0.029920949184449853_dp, 0.04492487252084988_dp, 0.06701733613497259_dp, &
             0.09934715278462358_dp, 0.1463900696284206_dp, 0.21448958268011928_dp, &
             0.31263394697361147_dp, 0.45362164626001367_dp, 0.6559573637613074_dp, &
             0.9473640989598018_dp, 1.372525198685822_dp, 2.0141168666286617_dp, &
             3.0681362610503005_dp, 5.293686964509947_dp]

      CASE (654)

         aw(:) = & ! a
            [0.00010941640926740673_dp, 0.0005918230362322702_dp, 0.0015285156545133051_dp, &
             0.0030646401423472134_dp, 0.00547242071880935_dp, 0.009218909467412637_dp, &
             0.01505113987332291_dp, 0.02411393970450653_dp, 0.03812767312753826_dp, &
             0.059653980645693425_dp, 0.09248269052068217_dp, 0.14218708167089744_dp, &
             0.21691520940588246_dp, 0.32851301847789_dp, 0.494115228513199_dp, &
             0.7384028363074433_dp, 1.0968370085897698_dp, 1.6204083947121235_dp, &
             2.3829973908178337_dp, 3.493999488072853_dp, 5.123931585986614_dp, &
             7.571189815542324_dp, 11.52488375748675_dp, &
             ! w
             0.0002824892025218642_dp, 0.0006931357485954232_dp, 0.0012036148565504033_dp, &
             0.0019128614084413366_dp, 0.002979163271259069_dp, 0.0046364280084281485_dp, &
             0.00721593819731318_dp, 0.01119203499519941_dp, 0.01725603356047215_dp, &
             0.026419123606108694_dp, 0.040154210570503696_dp, 0.06059417807957928_dp, &
             0.0908103436881852_dp, 0.13520413437375134_dp, 0.20006106528557996_dp, &
             0.2943474886925393_dp, 0.43090193737392596_dp, 0.6283583257636025_dp, &
             0.9146730531333217_dp, 1.33484088250569_dp, 1.9718018663295296_dp, &
             3.02136860618871_dp, 5.240003704493937_dp]

      CASE (655)

         aw(:) = & ! a
            [9.037755850786657e-05_dp, 0.000489751888332228_dp, 0.0012695476399375437_dp, &
             0.0025604674384136746_dp, 0.004609893379999404_dp, 0.007844323272598373_dp, &
             0.012948790175995175_dp, 0.02098006948683223_dp, 0.03353970625295641_dp, &
             0.05303351539408618_dp, 0.08305097980689792_dp, 0.12891290356153357_dp, &
             0.1984567102137522_dp, 0.30315754192766375_dp, 0.45972468008999984_dp, &
             0.6923768859292504_dp, 1.0361118510975211_dp, 1.541512797682683_dp, &
             2.282185453474102_dp, 3.367461582867472_dp, 4.968034929819057_dp, &
             7.382574192857667_dp, 11.29972777109869_dp, &
             ! w
             0.00023343207909754665_dp, 0.0005749109301438361_dp, 0.0010056920640549231_dp, &
             0.0016163277989382093_dp, 0.002552329974714457_dp, 0.004028881825258552_dp, &
             0.0063533565414724364_dp, 0.009971877630473854_dp, 0.015542154829216576_dp, &
             0.024034745367677076_dp, 0.03687412483277579_dp, 0.05613759897836612_dp, &
             0.0848363994203121_dp, 0.12731293386377773_dp, 0.18980450153444506_dp, &
             0.2812550459994511_dp, 0.41452674601066225_dp, 0.6083454493292306_dp, &
             0.8908418849813289_dp, 1.3072512917110222_dp, 1.9407287816980878_dp, &
             2.9869788339832106_dp, 5.20055654459162_dp]

      CASE (656)

         aw(:) = & ! a
            [6.772773294215754e-05_dp, 0.0003681330933123696_dp, 0.0009600833165707886_dp, &
             0.0019552449376276843_dp, 0.003567713091430119_dp, 0.006169065398236549_dp, &
             0.010360290808617492_dp, 0.01707873599614676_dp, 0.027763859202613803_dp, &
             0.04460692601859343_dp, 0.0709187089702277_dp, 0.11166511932544645_dp, &
             0.17424241515195532_dp, 0.26959358500617825_dp, 0.41381062527233786_dp, &
             0.6304335224229871_dp, 0.9537697039665054_dp, 1.43378406743243_dp, &
             2.1436511658590613_dp, 3.1925811542392095_dp, 4.7515127354614215_dp, &
             7.119533572817901_dp, 10.98471358527973_dp, &
             ! w
             0.00017504982451554808_dp, 0.0004337767668035506_dp, 0.0007680401893588274_dp, &
             0.0012570470205922682_dp, 0.0020286716203614854_dp, 0.0032724733594189375_dp, &
             0.005263494761006937_dp, 0.008409222390791752_dp, 0.013320223444780142_dp, &
             0.02090894585054932_dp, 0.032529588757453924_dp, 0.05017767149599278_dp, &
             0.07677453271404558_dp, 0.11657222338192556_dp, 0.17573107324937454_dp, &
             0.26315342393439656_dp, 0.39172577731792474_dp, 0.5802991932790549_dp, &
             0.857255440873771_dp, 1.268188460658404_dp, 1.8965911680238352_dp, &
             2.938056828544457_dp, 5.144479743330254_dp]

      CASE (657)

         aw(:) = & ! a
            [4.987207666488572e-05_dp, 0.00027205475767331497_dp, 0.0007146345422466652_dp, &
             0.0014722191397521602_dp, 0.0027284598111320772_dp, 0.0048041780793437175_dp, &
             0.00822269297766136_dp, 0.013810729833984306_dp, 0.022856290787743434_dp, &
             0.037347730632978596_dp, 0.060328871577925096_dp, 0.0964214485525208_dp, &
             0.1525885955589112_dp, 0.23924434617093937_dp, 0.3718591684287968_dp, &
             0.5732799635662582_dp, 0.877097767550666_dp, 1.3326219091134706_dp, &
             2.0125526853465634_dp, 3.025941368805157_dp, 4.5439577131822535_dp, &
             6.866137665752377_dp, 10.680072188887511_dp, &
             ! w
             0.00012900282840194976_dp, 0.00032199367417021875_dp, 0.0005783176855982976_dp, &
             0.0009666664699148756_dp, 0.001598248366470722_dp, 0.0026387756507622756_dp, &
             0.004333464445542502_dp, 0.007053372705401387_dp, 0.011363343009572492_dp, &
             0.01811830505874965_dp, 0.028601785950045554_dp, 0.044725747349435414_dp, &
             0.06931796399000324_dp, 0.10653403873953471_dp, 0.16244852673889768_dp, &
             0.24591097260205097_dp, 0.3698201597375351_dp, 0.5531429340627326_dp, &
             0.8245109549522822_dp, 1.2298906861496806_dp, 1.8531461123791817_dp, &
             2.8898126482562834_dp, 5.0892243556771914_dp]

      CASE (658)

         aw(:) = & ! a
            [2.75112874260035e-05_dp, 0.00015132248585800022_dp, 0.0004041877235074668_dp, &
             0.0008549328027316614_dp, 0.0016398749507422741_dp, 0.0030001755058056264_dp, &
             0.005337327169366603_dp, 0.009303281079111313_dp, 0.01594298286835429_dp, &
             0.026913147758594918_dp, 0.04481329749825336_dp, 0.07368219492456587_dp, &
             0.11973662615023326_dp, 0.19246329199547735_dp, 0.30622341037334644_dp, &
             0.4826028639725151_dp, 0.7538600970056132_dp, 1.1680498487977171_dp, &
             1.7969214159595308_dp, 2.7491452473384066_dp, 4.196258205003464_dp, &
             6.438657287329958_dp, 10.163323639802494_dp, &
             ! w
             7.129263674426213e-05_dp, 0.00018093736070606692_dp, 0.0003357867862829417_dp, &
             0.0005878240594227028_dp, 0.0010213725350442346_dp, 0.0017646805505146953_dp, &
             0.0030159602052222314_dp, 0.005086543041365371_dp, 0.008463586378211357_dp, &
             0.013901902468198004_dp, 0.02255946912538166_dp, 0.03619662958374437_dp, &
             0.05746714450315467_dp, 0.09034135764961466_dp, 0.14072034440494527_dp, &
             0.21733190704459512_dp, 0.33306516219511023_dp, 0.5070659345337035_dp, &
             0.7684024059794611_dp, 1.1637330762849774_dp, 1.7776625641173411_dp, &
             2.8057583068033236_dp, 4.993055600329781_dp]

      CASE (659)

         aw(:) = & ! a
            [1.943077545695233e-05_dp, 0.00010749914754601933_dp, 0.0002905375350137754_dp, &
             0.000625845877103975_dp, 0.0012279962234922016_dp, 0.002301395524603954_dp, &
             0.004191270004871865_dp, 0.0074678572675019005_dp, 0.013060313322173217_dp, &
             0.022464241892482667_dp, 0.03805925427102047_dp, 0.06359039011556974_dp, &
             0.1048918559039895_dp, 0.17096678270696955_dp, 0.27558771893430817_dp, &
             0.43965871656865374_dp, 0.6947023252260974_dp, 1.0880619339494948_dp, &
             1.6909249126686423_dp, 2.611705180921732_dp, 4.022107275350649_dp, &
             6.223014736639974_dp, 9.901207941028282_dp, &
             ! w
             5.041676706466184e-05_dp, 0.00012945846815702803_dp, 0.0002457626343830027_dp, &
             0.0004434351520031084_dp, 0.0007941201289321444_dp, 0.0014088488489885562_dp, &
             0.0024637631977260477_dp, 0.004240896723975039_dp, 0.007188115369875548_dp, &
             0.012008502670013273_dp, 0.01979389776733372_dp, 0.032223128583752016_dp, &
             0.051854207104282866_dp, 0.08255253338096369_dp, 0.13011654607334777_dp, &
             0.20319485641760857_dp, 0.31465430013839985_dp, 0.4837201142383853_dp, &
             0.7396859310632805_dp, 1.1295911124194844_dp, 1.7384751475926694_dp, &
             2.7619940863025993_dp, 4.943032210081897_dp]

      CASE (660)

         aw(:) = & ! a
            [1.5186028788487787e-05_dp, 8.440689165581798e-05_dp, 0.00023028964370770395_dp, &
             0.0005032170072102935_dp, 0.0010045305117883968_dp, 0.0019162708437991153_dp, &
             0.0035493344020672743_dp, 0.006423614760193411_dp, 0.011396058560892755_dp, &
             0.019860601987159356_dp, 0.03405654040598402_dp, 0.057539526657774384_dp, &
             0.09589457766863309_dp, 0.1578066878477717_dp, 0.25665716234505115_dp, &
             0.41289199266412385_dp, 0.6575333669388179_dp, 1.0374337878643975_dp, &
             1.6233840757330766_dp, 2.523605279932863_dp, 3.9099015937720365_dp, &
             6.083490615602792_dp, 9.731065378730635_dp, &
             ! w
             3.944278813817094e-05_dp, 0.00010222950025951529_dp, 0.00019757345912072447_dp, &
             0.00036470563524428187_dp, 0.0006674907691885711_dp, 0.0012065052478867878_dp, &
             0.0021441921604794805_dp, 0.0037439458410990214_dp, 0.006428251061381941_dp, &
             0.010866386448031513_dp, 0.018106484768346254_dp, 0.029772871054980683_dp, &
             0.0483586944734761_dp, 0.07765711952438033_dp, 0.12339430747578661_dp, &
             0.19416052189741978_dp, 0.302800925064658_dp, 0.4685871070120731_dp, &
             0.7209596705006001_dp, 1.1072161383206613_dp, 1.7127015405508177_dp, &
             2.733159034676653_dp, 4.910090392492674_dp]

      CASE (661)

         aw(:) = & ! a
            [1.254573522126483e-05_dp, 7.000771758757615e-05_dp, 0.00019254082708660645_dp, &
             0.00042578076534042055_dp, 0.0008619147234744453_dp, 0.0016675160825434612_dp, &
             0.0031296665520386957_dp, 0.005733059254379714_dp, 0.010283700465173956_dp, &
             0.018103197704366195_dp, 0.03133023713881733_dp, 0.05338366921363135_dp, &
             0.08966722278247792_dp, 0.14863281371340806_dp, 0.24337306308632814_dp, &
             0.39399344154356175_dp, 0.6311410700612039_dp, 1.001296744089423_dp, &
             1.574946468154319_dp, 2.46015699578551_dp, 3.8287995465905684_dp, &
             5.982343497975724_dp, 9.607440868469775_dp, &
             ! w
             3.2612992923360705e-05_dp, 8.519990467040972e-05_dp, 0.00016714535926317734_dp, &
             0.00031426486684134715_dp, 0.000585025383471879_dp, 0.0010727738947416787_dp, &
             0.0019303032966276204_dp, 0.003407663506622901_dp, 0.005908988748277583_dp, &
             0.01007892147011934_dp, 0.016933492678545287_dp, 0.02805666761951195_dp, &
             0.04589312978699421_dp, 0.07418148319009715_dp, 0.1185924698841046_dp, &
             0.18767032784355986_dp, 0.29424061083351266_dp, 0.4576056637352122_dp, &
             0.7073128951841113_dp, 1.0908528291173565_dp, 1.6938045862241802_dp, &
             2.711990371906971_dp, 4.885915259856555_dp]

      CASE (662)

         aw(:) = & ! a
            [9.410117883516404e-06_dp, 5.2858585086734156e-05_dp, 0.00014733052988380674_dp, &
             0.0003321923374009351_dp, 0.0006874574809019757_dp, 0.0013591459030404722_dp, &
             0.002602548429823122_dp, 0.0048549414563873365_dp, 0.008853055000827214_dp, &
             0.01581925797475768_dp, 0.02775305790155189_dp, 0.04788258820815112_dp, &
             0.08135695572382737_dp, 0.13629831261354758_dp, 0.22538782142458622_dp, &
             0.3682418508356122_dp, 0.5949641847990454_dp, 0.9514915617504976_dp, &
             1.5078570567158924_dp, 2.3718892054824887_dp, 3.715544574069324_dp, &
             5.840658930949642_dp, 9.433860134519659_dp, &
             ! w
             2.4496693437567276e-05_dp, 6.484786415367783e-05_dp, 0.00013037460720919538_dp, &
             0.00025229015677215826_dp, 0.0004818808577720569_dp, 0.0009028670546788508_dp, &
             0.0016549153246979227_dp, 0.002969640998663022_dp, 0.005225582928230421_dp, &
             0.00903273748103435_dp, 0.015361621868829443_dp, 0.025738493324956084_dp, &
             0.04253809442491115_dp, 0.0694194275313286_dp, 0.11197116436683657_dp, &
             0.1786675112597719_dp, 0.2823006252472037_dp, 0.4422114131620818_dp, &
             0.6880968881446058_dp, 1.0677262708282482_dp, 1.6670252661896332_dp, &
             2.6819509150656184_dp, 4.85162133575408_dp]

      CASE (663)

         aw(:) = & ! a
            [6.941897803062561e-06_dp, 3.930718144472374e-05_dp, 0.00011132880383520508_dp, &
             0.0002567325037691151_dp, 0.0005445129662364841_dp, 0.0011020985023357935_dp, &
             0.0021558143141816766_dp, 0.004099226505195036_dp, 0.007604457397456052_dp, &
             0.013800334018344265_dp, 0.024553878934543985_dp, 0.04290999587795706_dp, &
             0.07377099149949082_dp, 0.12493660635158689_dp, 0.20868220713701893_dp, &
             0.34413740821626987_dp, 0.5608598663503145_dp, 0.9042329141327881_dp, &
             1.443820952904812_dp, 2.287195584921532_dp, 3.606385003553035_dp, &
             5.703594743292729_dp, 9.265468359287246_dp, &
             ! w
             1.8102306402496735e-05_dp, 4.868973008587396e-05_dp, 0.00010073248747868423_dp, &
             0.00020121333400762914_dp, 0.00039493378905936774_dp, 0.0007568535682459059_dp, &
             0.00141437258556732_dp, 0.0025815877463692726_dp, 0.004612447683791073_dp, &
             0.008083337543304418_dp, 0.013920191319419782_dp, 0.023592172436583077_dp, &
             0.039404079626994624_dp, 0.06493430660962199_dp, 0.10568701217030595_dp, &
             0.1700621442417167_dp, 0.27081247100109584_dp, 0.4273105898193215_dp, &
             0.6693977463190739_dp, 1.0451220792581715_dp, 1.6407663510306043_dp, &
             2.652446791729949_dp, 4.817951665848005_dp]

      CASE (664)

         aw(:) = & ! a
            [3.853270779220833e-06_dp, 2.2241728520864382e-05_dp, 6.540535214803702e-05_dp, &
             0.00015848095993119255_dp, 0.0003536244659221865_dp, 0.0007498239134427326_dp, &
             0.0015284896933536677_dp, 0.0030142094326381257_dp, 0.00577545291759329_dp, &
             0.010788712861079184_dp, 0.019702267183033417_dp, 0.03525456088102581_dp, &
             0.06193000221398213_dp, 0.10697581653408518_dp, 0.18196357847991113_dp, &
             0.3051681669273905_dp, 0.5051751930610341_dp, 0.8263670489211143_dp, &
             1.337441035048714_dp, 2.145468106363411_dp, 3.4225682931292067_dp, &
             5.471607451639996_dp, 8.979350067431634_dp, &
             ! w
             1.008923347743312e-05_dp, 2.8184249820085405e-05_dp, 6.215059000915936e-05_dp, &
             0.00013238189012683877_dp, 0.0002738301923412137_dp, 0.0005478253821267155_dp, &
             0.0010619800865001483_dp, 0.0020015524541288367_dp, 0.003679414729906491_dp, &
             0.006615037197040588_dp, 0.011657836051224385_dp, 0.020177631353302125_dp, &
             0.03435572824472115_dp, 0.05762579147969522_dp, 0.09533688650333176_dp, &
             0.15574761784426483_dp, 0.2515266054875526_dp, 0.4020855285971333_dp, &
             0.6375069898886988_dp, 1.0063320893911387_dp, 1.5954999890268287_dp, &
             2.6014672997866284_dp, 4.759803740089366_dp]

      CASE (665)

         aw(:) = & ! a
            [2.7362333478713395e-06_dp, 1.6018569703292616e-05_dp, 4.8370196970770565e-05_dp, &
             0.00012105776534796837_dp, 0.0002786559313463596_dp, 0.0006072901874353698_dp, &
             0.0012677047096366792_dp, 0.002552144881886733_dp, 0.0049796485001332436_dp, &
             0.009452945428134405_dp, 0.017512908651776883_dp, 0.03174554692684556_dp, &
             0.05642483340555305_dp, 0.0985164532120049_dp, 0.1692291202896758_dp, &
             0.28639169186936664_dp, 0.47807591103041425_dp, 0.788126912084251_dp, &
             1.2847667026913803_dp, 2.0747790909381907_dp, 3.330313861838757_dp, &
             5.354586342504829_dp, 8.834470380703861_dp, &
             ! w
             7.1858684275017036e-06_dp, 2.0630979485376434e-05_dp, 4.745986258647168e-05_dp, &
             0.00010505591731147411_dp, 0.00022396334666135973_dp, 0.0004591816028414762_dp, &
             0.0009088204482574491_dp, 0.0017440343322827272_dp, 0.003257314375616538_dp, &
             0.005939501541007813_dp, 0.010601002767896068_dp, 0.018560306569222466_dp, &
             0.03193400287429269_dp, 0.0540787024973376_dp, 0.09025922312502486_dp, &
             0.14865489391753492_dp, 0.2418827597820275_dp, 0.3893662735237943_dp, &
             0.621307584280122_dp, 0.9865063325718852_dp, 1.5722591866906825_dp, &
             2.5752315823883256_dp, 4.729892490545373_dp]

      CASE (666)

         aw(:) = & ! a
            [2.1485725653763096e-06_dp, 1.2725610767311947e-05_dp, 3.9245142611661685e-05_dp, &
             0.00010064280220769361_dp, 0.0002369377809828602_dp, 0.0005264866822571787_dp, &
             0.0011174066214606883_dp, 0.002281957430450397_dp, 0.004508325425233879_dp, &
             0.00865279241950343_dp, 0.016188048305457656_dp, 0.029602600787565818_dp, &
             0.05303486610867192_dp, 0.09326792686007114_dp, 0.16127356372682886_dp, &
             0.2745873962730799_dp, 0.46094083148020853_dp, 0.7638201245999824_dp, &
             1.251126090041441_dp, 2.0294437662643596_dp, 3.270935367983161_dp, &
             5.2790476004623095_dp, 8.740743253412464_dp, &
             ! w
             5.65649586565214e-06_dp, 1.6605705580539614e-05_dp, 3.9446425858471386e-05_dp, &
             8.974499020101461e-05_dp, 0.0001954003495832924_dp, 0.00040751067567562703_dp, &
             0.0008182291847597183_dp, 0.0015897833190846396_dp, 0.0030016549532205315_dp, &
             0.005526264207570665_dp, 0.009948722859607129_dp, 0.01755397631792136_dp, &
             0.03041598678412126_dp, 0.05184015834737924_dp, 0.08703470054229626_dp, &
             0.14412476230304141_dp, 0.23569058190270062_dp, 0.3811600453758225_dp, &
             0.6108113783709254_dp, 0.9736145851829946_dp, 1.5571070220101144_dp, &
             2.5581032573117777_dp, 4.710369279446002_dp]

      CASE (667)

         aw(:) = & ! a
            [1.7824706410759602e-06_dp, 1.0664679395860483e-05_dp, 3.3477483043565994e-05_dp, &
             8.755432504560044e-05_dp, 0.0002097898001019664_dp, 0.0004731857022262164_dp, &
             0.0010170805983356738_dp, 0.0020997284782958876_dp, 0.004187543363553217_dp, &
             0.008103823087121502_dp, 0.015272563497365_dp, 0.028112274082148475_dp, &
             0.05066357019125376_dp, 0.08957716662770761_dp, 0.15565229251041415_dp, &
             0.266210000526289_dp, 0.4487314096726897_dp, 0.7464373080973531_dp, &
             1.2269890470068183_dp, 1.9968210991849522_dp, 3.2281010731629847_dp, &
             5.224445722641455_dp, 8.672891426699495_dp, &
             ! w
             4.702774535850405e-06_dp, 1.4072069665725788e-05_dp, 3.4308600212246764e-05_dp, &
             7.973113777740445e-05_dp, 0.00017642252796476598_dp, 0.0003727491433089244_dp, &
             0.0007566482109370002_dp, 0.0014839867603136827_dp, 0.0028249227856203076_dp, &
             0.005238599767886166_dp, 0.009491799679652798_dp, 0.01684503147251877_dp, &
             0.029341031589271156_dp, 0.05024746706993103_dp, 0.0847305187997003_dp, &
             0.1408746551083355_dp, 0.23123171364003703_dp, 0.3752311332166879_dp, &
             0.6032054963076499_dp, 0.964249624854869_dp, 1.5460798447272006_dp, &
             2.5456258671900445_dp, 4.696149561069354_dp]

      CASE (668)

         aw(:) = & ! a
            [1.3467681462972046e-06_dp, 8.198860357499511e-06_dp, 2.6496696210333228e-05_dp, &
             7.145685836364103e-05_dp, 0.00017585481273804296_dp, 0.00040558881091113774_dp, &
             0.0008882435632021239_dp, 0.001863163506477378_dp, 0.0037671538655925565_dp, &
             0.007378366175564499_dp, 0.014053754977722729_dp, 0.026114933731968496_dp, &
             0.0474664461277602_dp, 0.08457394532975825_dp, 0.1479942673747438_dp, &
             0.25474559325113605_dp, 0.4319539299558102_dp, 0.7224611849900392_dp, &
             1.193584228439049_dp, 1.9515374993058465_dp, 3.168490743879836_dp, &
             5.1483017379991205_dp, 8.578122934982396_dp, &
             ! w
             3.5664597412040825e-06_dp, 1.102053066184845e-05_dp, 2.798851972323109e-05_dp, &
             6.71465542046445e-05_dp, 0.0001521757617941444_dp, 0.00032775436577814956_dp, &
             0.0006760695251468474_dp, 0.0013442548368026391_dp, 0.0025895869655016717_dp, &
             0.004852760329243902_dp, 0.008874943793593926_dp, 0.015882313076166738_dp, &
             0.02787348652034074_dp, 0.048062485834429604_dp, 0.08155529805703034_dp, &
             0.1363774769490829_dp, 0.22503864306235727_dp, 0.3669679588738693_dp, &
             0.5925727957129064_dp, 0.9511243439282931_dp, 1.530595683200551_dp, &
             2.528087817945579_dp, 4.676165651686418_dp]

      CASE (669)

         aw(:) = & ! a
            [1.0026839856435724e-06_dp, 6.237374911349773e-06_dp, 2.085488117019199e-05_dp, &
             5.8169860962251726e-05_dp, 0.00014726530103885307_dp, 0.00034761468217947886_dp, &
             0.0007760506242668873_dp, 0.0016544475048729074_dp, 0.0033920199690078592_dp, &
             0.006724528433187649_dp, 0.012945540976798798_dp, 0.024284472752256092_dp, &
             0.04451562010911718_dp, 0.07992648877663189_dp, 0.1408392826829582_dp, &
             0.2439773649648799_dp, 0.41611901860654604_dp, 0.6997326251964361_dp, &
             1.161792368043248_dp, 1.9082899184919446_dp, 3.111390784105834_dp, &
             5.075188373470443_dp, 8.486961793889565_dp, &
             ! w
             2.6677497664863237e-06_dp, 8.570867779929502e-06_dp, 2.27697678977458e-05_dp, &
             5.647449772745657e-05_dp, 0.0001311983698388498_dp, 0.00028820979562128906_dp, &
             0.0006043208498015859_dp, 0.001218436354839996_dp, 0.0023756073959409715_dp, &
             0.004498898436014983_dp, 0.008304842477225361_dp, 0.014986380937835705_dp, &
             0.026499148704522437_dp, 0.0460045332196876_dp, 0.07854895830488497_dp, &
             0.13209894950407378_dp, 0.21912062008531333_dp, 0.35904004517695376_dp, &
             0.582335157967353_dp, 0.9384489894823416_dp, 1.5156092124431433_dp, &
             2.511093527097568_dp, 4.656804703604224_dp]

      CASE (670)

         aw(:) = & ! a
            [5.695482478296897e-07_dp, 3.7387017738497234e-06_dp, 1.347689628824476e-05_dp, &
             4.0221708631463127e-05_dp, 0.00010747729778809903_dp, 0.00026486531922520533_dp, &
             0.0006124658291870136_dp, 0.0013445619054028325_dp, 0.0028262791776858076_dp, &
             0.0057249298443552985_dp, 0.011230766633054922_dp, 0.021421627311030516_dp, &
             0.03985594956400731_dp, 0.07252373374554023_dp, 0.12935242860677965_dp, &
             0.2265656641001338_dp, 0.39034764448334164_dp, 0.6625228293427873_dp, &
             1.1094676161248844_dp, 1.8367762213694017_dp, 3.0165921840800327_dp, &
             4.953410355808327_dp, 8.33475527994059_dp, &
             ! w
             1.5338807594779788e-06_dp, 5.4023566807865e-06_dp, 1.5713159764209495e-05_dp, &
             4.1486613858198684e-05_dp, 0.00010090782806823178_dp, 0.00022985012460898297_dp, &
             0.0004965042419198246_dp, 0.0010264330911921925_dp, 0.0020446666858529397_dp, &
             0.003945128002854194_dp, 0.0074032682164944_dp, 0.013556132913603127_dp, &
             0.024286436303487514_dp, 0.042665437452962626_dp, 0.07363642754530832_dp, &
             0.1250620781292975_dp, 0.20932925335779837_dp, 0.3458523034842012_dp, &
             0.5652235213079986_dp, 0.9171774324449022_dp, 1.4903838853512916_dp, &
             2.482442933394029_dp, 4.624171367544714_dp]

      CASE (671)

         aw(:) = & ! a
            [4.1164904819495056e-07_dp, 2.813586205810931e-06_dp, 1.0651434826377284e-05_dp, &
             3.3082761700612936e-05_dp, 9.112484119257757e-05_dp, 0.0002299316740026587_dp, &
             0.0005418624311686956_dp, 0.001208311396446073_dp, 0.002573568614363697_dp, &
             0.0052722665767247_dp, 0.010444876531852484_dp, 0.020095585931105338_dp, &
             0.037677130745476024_dp, 0.06903275657764923_dp, 0.12389379924342069_dp, &
             0.21823385468524384_dp, 0.3779376665647566_dp, 0.644502363140509_dp, &
             1.083997113679983_dp, 1.801807658345806_dp, 2.9700592959374554_dp, &
             4.893448560821683_dp, 8.259637315234952_dp, &
             ! w
             1.1194489831490663e-06_dp, 4.205376538166022e-06_dp, 1.2901940067937311e-05_dp, &
             3.526918985534942e-05_dp, 8.797446712170179e-05_dp, 0.00020436565991084073_dp, &
             0.00044854676342248823_dp, 0.000939688100172495_dp, 0.0018931321660813649_dp, &
             0.0036885731095298766_dp, 0.006981232024143092_dp, 0.012880402988628177_dp, &
             0.023232297578308286_dp, 0.0410626624397191_dp, 0.07126217027911405_dp, &
             0.12163973033975671_dp, 0.20453992579830765_dp, 0.339368109347748_dp, &
             0.5567712192770106_dp, 0.9066296495958464_dp, 1.4778395493609238_dp, &
             2.468173248830966_dp, 4.607921241408812_dp]

      CASE (672)

         aw(:) = & ! a
            [3.2815106747013573e-07_dp, 2.3190388059084265e-06_dp, 9.105727958600882e-06_dp, &
             2.9083697560823515e-05_dp, 8.17846074303215e-05_dp, 0.00020966506586372546_dp, &
             0.0005003797625227516_dp, 0.0011274098319519973_dp, 0.002422169665104748_dp, &
             0.004998980872010807_dp, 0.009967215710163558_dp, 0.019284836586730216_dp, &
             0.036337952140351105_dp, 0.06687692803473942_dp, 0.12050849505479717_dp, &
             0.21304676333872524_dp, 0.37018468401267685_dp, 0.6332087786116111_dp, &
             1.0679893680205574_dp, 1.7797757896739255_dp, 2.940679102110993_dp, &
             4.855524732089155_dp, 8.212067192145357_dp, &
             ! w
             8.999600465203641e-07_dp, 3.556322522670299e-06_dp, 1.1325322843811366e-05_dp, &
             3.1699581990752516e-05_dp, 8.042516831768671e-05_dp, 0.00018929780097494032_dp, &
             0.00041989246827121634_dp, 0.0008873994705141611_dp, 0.0018010964747775297_dp, &
             0.003531724472102502_dp, 0.00672171495324129_dp, 0.012462738070578742_dp, &
             0.022577719603031936_dp, 0.04006323357801831_dp, 0.0697760365043427_dp, &
             0.11949011551442518_dp, 0.2015221588442651_dp, 0.33527066815854195_dp, &
             0.5514165114504993_dp, 0.8999331123660025_dp, 1.469862746831253_dp, &
             2.459091523474792_dp, 4.5975801498593105_dp]

      CASE (673)

         aw(:) = & ! a
            [2.7594881331818964e-07_dp, 2.0071743154717217e-06_dp, 8.11348505740982e-06_dp, &
             2.6472042546690133e-05_dp, 7.560063764703147e-05_dp, 0.00019610109104827052_dp, &
             0.0004723729023173509_dp, 0.0010723935089931224_dp, 0.00231858238510834_dp, &
             0.004811016795118102_dp, 0.009637183157578435_dp, 0.018722410693781336_dp, &
             0.0354056347865589_dp, 0.0653712807509657_dp, 0.11813738322454047_dp, &
             0.20940423059591254_dp, 0.3647275214801527_dp, 0.6252425984794626_dp, &
             1.0566764814931602_dp, 1.7641795077178264_dp, 2.9198513093858764_dp, &
             4.8286094086064715_dp, 8.178276854090898_dp, &
             ! w
             7.625962204237235e-07_dp, 3.1423807227117575e-06_dp, 1.0294757811612861e-05_dp, &
             2.9328060814257294e-05_dp, 7.535206068659267e-05_dp, 0.0001790822453176794_dp, &
             0.0004003253885991469_dp, 0.0008514774801044953_dp, 0.001737542145001489_dp, &
             0.0034229293515005083_dp, 0.006540997996161008_dp, 0.01217087807441986_dp, &
             0.022118876234280778_dp, 0.03936067958064679_dp, 0.0687286718990807_dp, &
             0.117971616113168_dp, 0.19938584721339075_dp, 0.3323644416301962_dp, &
             0.5476120341444782_dp, 0.8951684302967229_dp, 1.4641810458591635_dp, &
             2.452619061954174_dp, 4.5902106376365115_dp]

      CASE (674)

         aw(:) = & ! a
            [2.1362409300071513e-07_dp, 1.6311281636796907e-06_dp, 6.893176859606963e-06_dp, &
             2.320153079525968e-05_dp, 6.774691203990355e-05_dp, 0.00017868447935486168_dp, &
             0.00043609280506814156_dp, 0.0010006058866571556_dp, 0.0021825883100299727_dp, &
             0.004562953020253901_dp, 0.009199639171096712_dp, 0.01797378094055829_dp, &
             0.03416024251330929_dp, 0.06335364565520049_dp, 0.11495091609566763_dp, &
             0.20449652369965488_dp, 0.3573577666309494_dp, 0.6144618441497989_dp, &
             1.0413377140747122_dp, 1.7429979275258771_dp, 2.8915247368561734_dp, &
             4.791961865329579_dp, 8.132229446127386_dp, &
             ! w
             5.984358998815298e-07_dp, 2.6367879582450793e-06_dp, 9.002944281445811e-06_dp, &
             2.6306011923403513e-05_dp, 6.881220908810481e-05_dp, 0.00016579495326258533_dp, &
             0.00037468954278266624_dp, 0.0008041286795896982_dp, 0.001653338234998219_dp, &
             0.0032781404014528208_dp, 0.0062995485176757515_dp, 0.011779577101252508_dp, &
             0.021501782066665597_dp, 0.03841316784413099_dp, 0.06731252682000821_dp, &
             0.11591368382941206_dp, 0.1964845080528559_dp, 0.3284099185074698_dp, &
             0.5424264689547013_dp, 0.8886648138160013_dp, 1.456417454638106_dp, &
             2.443769844988774_dp, 4.580135594434126_dp]

      CASE (675)

         aw(:) = & ! a
            [1.642797958173549e-07_dp, 1.3293855129189586e-06_dp, 5.888879200396203e-06_dp, &
             2.0450536928130472e-05_dp, 6.103049181883815e-05_dp, 0.0001635987345737612_dp, &
             0.0004043470549977173_dp, 0.000937264853526142_dp, 0.0020617540488895377_dp, &
             0.004341222878829549_dp, 0.008806516244467185_dp, 0.017298098709055992_dp, &
             0.03303168247513459_dp, 0.061518728279676645_dp, 0.11204368275724312_dp, &
             0.20000588030509914_dp, 0.350596606796668_dp, 0.6045479497995547_dp, &
             1.027202405571357_dp, 1.7234418124625002_dp, 2.865330402770221_dp, &
             4.7580295734761116_dp, 8.089553289290992_dp, &
             ! w
             4.6832912902611977e-07_dp, 2.224128312700839e-06_dp, 7.915040539097015e-06_dp, &
             2.3711823649761866e-05_dp, 6.312260513406812e-05_dp, 0.00015411538082922845_dp, &
             0.0003519672887267903_dp, 0.0007618699251709589_dp, 0.001577743567749907_dp, &
             0.003147494012590352_dp, 0.006080713471153958_dp, 0.011423528828298082_dp, &
             0.020938307009986876_dp, 0.03754524465754437_dp, 0.06601161090853291_dp, &
             0.11401826336980933_dp, 0.1938059263435469_dp, 0.32475115466366694_dp, &
             0.5376195808085394_dp, 0.8826264458112499_dp, 1.4492005982831313_dp, &
             2.4355384691127506_dp, 4.570764632337974_dp]

      CASE (676)

         aw(:) = & ! a
            [1.0236764121615025e-07_dp, 9.425968155937635e-07_dp, 4.553432239128545e-06_dp, &
             1.6683963942562624e-05_dp, 5.1634730582147975e-05_dp, 0.000142147023612431_dp, &
             0.0003586178348423604_dp, 0.0008450564941822454_dp, 0.0018842947714475182_dp, &
             0.004013136165950289_dp, 0.008221044247124321_dp, 0.016286094130054978_dp, &
             0.031332887620934474_dp, 0.05874430817058738_dp, 0.10763026421256834_dp, &
             0.19316406939810196_dp, 0.34026188251061096_dp, 0.5893495405675959_dp, &
             1.0054753168931867_dp, 1.6933128661726842_dp, 2.8248947704965333_dp, &
             4.705565890786283_dp, 8.023492871028985_dp, &
             ! w
             3.048838482564978e-07_dp, 1.6813054036109682e-06_dp, 6.423195826201865e-06_dp, &
             2.0066197946680867e-05_dp, 5.498887148884597e-05_dp, 0.00013719787601013992_dp, &
             0.00031870589417680125_dp, 0.0006994681188301581_dp, 0.0014652879406124022_dp, &
             0.0029519016672341267_dp, 0.0057512664670887345_dp, 0.010884874190899094_dp, &
             0.020082099271589843_dp, 0.03622121562957775_dp, 0.06401995184162773_dp, &
             0.11110700807552402_dp, 0.1896796134233492_dp, 0.3190998055068231_dp, &
             0.530177226613226_dp, 0.8732587638764073_dp, 1.4379879356005678_dp, &
             2.422739199643848_dp, 4.55619459265961_dp]

      CASE (677)

         aw(:) = & ! a
            [8.046371021012933e-08_dp, 8.02108847484878e-07_dp, 4.0489926441448694e-06_dp, &
             1.521986893157837e-05_dp, 4.790740389735278e-05_dp, 0.00013350658054668902_dp, &
             0.000339978350380571_dp, 0.0008071084564914788_dp, 0.0018106762238904546_dp, &
             0.003876105908789264_dp, 0.007975084303408493_dp, 0.015858779524321617_dp, &
             0.030612358509774795_dp, 0.05756286716240572_dp, 0.10574417462454092_dp, &
             0.19023081518969803_dp, 0.33581831427883096_dp, 0.582797742111891_dp, &
             0.9960873023195477_dp, 1.680267873386839_dp, 2.807356803893998_dp, &
             4.682779200862605_dp, 7.994770949519867_dp, &
             ! w
             2.4697645676339603e-07_dp, 1.4783354679370506e-06_dp, 5.842470798410027e-06_dp, &
             1.861419518956962e-05_dp, 5.169736429525192e-05_dp, 0.00013026854204282543_dp, &
             0.00030495029513828297_dp, 0.0006734558822313016_dp, 0.0014180968944220984_dp, &
             0.0028693519960576084_dp, 0.0056115292727673734_dp, 0.010655395374307581_dp, &
             0.019715908812675716_dp, 0.035652956396335714_dp, 0.0631624440936236_dp, &
             0.10984996331403596_dp, 0.18789326409600282_dp, 0.3166474639418603_dp, &
             0.5269409416836507_dp, 0.8691780769919247_dp, 1.4330971028809125_dp, &
             2.417152295738832_dp, 4.549835191259431_dp]

      CASE (678)

         aw(:) = & ! a
            [6.97509166551491e-08_dp, 7.322783968639456e-07_dp, 3.7929649175433556e-06_dp, &
             1.446607224553548e-05_dp, 4.596920541297255e-05_dp, 0.0001289804171133798_dp, &
             0.00033015837797235295_dp, 0.0007870237419688569_dp, 0.0017715634116700508_dp, &
             0.003803068161853224_dp, 0.007843623154709661_dp, 0.01562983643225872_dp, &
             0.030225499458253757_dp, 0.05692734377673081_dp, 0.10472789421740605_dp, &
             0.18864789650982447_dp, 0.33341708642435836_dp, 0.5792529112294669_dp, &
             0.9910023644134035_dp, 1.673195341828092_dp, 2.7978405347031763_dp, &
             4.670406762121503_dp, 7.9791682579659255_dp, &
             ! w
             2.1862331324695392e-07_dp, 1.3758059479346798e-06_dp, 5.54328351617483e-06_dp, &
             1.7857786196301592e-05_dp, 4.99694394589399e-05_dp, 0.00012660965398606224_dp, &
             0.0002976533088853177_dp, 0.0006596047169180028_dp, 0.0013928882717624761_dp, &
             0.0028251352857489717_dp, 0.005536503651580631_dp, 0.010531930574906107_dp, &
             0.01951852560501222_dp, 0.035346146522593914_dp, 0.06269877224808298_dp, &
             0.10916933024048832_dp, 0.18692484253419805_dp, 0.31531650946748363_dp, &
             0.5251827836269845_dp, 0.8669593404119038_dp, 1.430436218907681_dp, &
             2.4141116777556366_dp, 4.546374261265121_dp]

      CASE (679)

         aw(:) = & ! a
            [6.417150621734594e-08_dp, 6.955307285698317e-07_dp, 3.656575263586883e-06_dp, &
             1.4061256330510396e-05_dp, 4.4922524237699306e-05_dp, 0.0001265261447907051_dp, &
             0.00032481668790693645_dp, 0.0007760705667137015_dp, 0.001750188344007474_dp, &
             0.003763082183390906_dp, 0.007771542172269596_dp, 0.01550413863323877_dp, &
             0.030012851959179694_dp, 0.05657764885399067_dp, 0.10416817042945352_dp, &
             0.18777536661262895_dp, 0.33209249870152535_dp, 0.5772961583543643_dp, &
             0.9881937758018039_dp, 1.6692868642511767_dp, 2.7925792087923744_dp, &
             4.663563847069891_dp, 7.970536451977698_dp, &
             ! w
             2.0384316972412146e-07_dp, 1.3213269320747846e-06_dp, 5.382552054907922e-06_dp, &
             1.7448904426729824e-05_dp, 4.903139047955951e-05_dp, 0.00012461690541656648_dp, &
             0.00029366896419342624_dp, 0.0006520257820507237_dp, 0.0013790706502032032_dp, &
             0.0028008623244754095_dp, 0.005495264273797778_dp, 0.010463987842098016_dp, &
             0.01940979502032141_dp, 0.03517698304271777_dp, 0.06244291062300987_dp, &
             0.1087934656357535_dp, 0.18638969044989154_dp, 0.314580569994382_dp, &
             0.5242100979284817_dp, 0.8657312824871871_dp, 1.4289629306473244_dp, &
             2.4124278226777585_dp, 4.544457676956261_dp]

      CASE (680)

         aw(:) = & ! a
            [6.179038412892102e-08_dp, 6.797562684401005e-07_dp, 3.5976455420632004e-06_dp, &
             1.3885607229494045e-05_dp, 4.446705672522031e-05_dp, 0.0001254558908957228_dp, &
             0.0003224834721762476_dp, 0.0007712799863038676_dp, 0.0017408293801960475_dp, &
             0.0037455584454521174_dp, 0.007739927988342882_dp, 0.015448970771089355_dp, &
             0.02991946643576507_dp, 0.056423996239399504_dp, 0.10392211580052599_dp, &
             0.18739163782269105_dp, 0.3315097348903452_dp, 0.5764349685681808_dp, &
             0.9869572987208006_dp, 1.6675656932846914_dp, 2.790261751781642_dp, &
             4.6605491967257295_dp, 7.966733208853524_dp, &
             ! w
             1.975317596154078e-07_dp, 1.2978189319536624e-06_dp, 5.312798439624158e-06_dp, &
             1.7270889128557884e-05_dp, 4.8622083044750136e-05_dp, 0.00012374593586876733_dp, &
             0.000291925224357549_dp, 0.0006487052905521958_dp, 0.0013730113661025365_dp, &
             0.0027902099111700982_dp, 0.005477153831574969_dp, 0.01043413298656968_dp, &
             0.019361992591081827_dp, 0.035102576901136155_dp, 0.0623303226240599_dp, &
             0.10862800851281051_dp, 0.18615403206967085_dp, 0.3142563908089402_dp, &
             0.5237815129929865_dp, 0.8651900497697063_dp, 1.4283135102178455_dp, &
             2.41168552624284_dp, 4.5436128189152685_dp]

      CASE (681)

         aw(:) = & ! a
            [0.0013191708171382422_dp, 0.007013952244568126_dp, 0.017526845075845704_dp, &
             0.0333571762122411_dp, 0.05531426154998188_dp, 0.08462988169142081_dp, &
             0.12311406077479778_dp, 0.17335279408223145_dp, 0.23894016949454994_dp, &
             0.32474521457344047_dp, 0.4372340609281586_dp, 0.5848856078879786_dp, &
             0.7787449431160711_dp, 1.0331614665744948_dp, 1.3667708081197638_dp, &
             1.8038106398102907_dp, 2.375923866086619_dp, 3.1247325963124015_dp, &
             4.105750881454465_dp, 5.3948814186995575_dp, 7.100534729218748_dp, &
             9.389955610016083_dp, 12.560267378276638_dp, 17.320448524523357_dp, &
             ! w
             0.0033925596897429067_dp, 0.008042037219228835_dp, 0.01306564813422215_dp, &
             0.018728055881360426_dp, 0.02538880935359407_dp, 0.03354078196264304_dp, &
             0.04385470099486025_dp, 0.05721738360336377_dp, 0.0747635996265248_dp, &
             0.09791735828377998_dp, 0.12846436813436518_dp, 0.16866740509917058_dp, &
             0.2214266697433495_dp, 0.2904907275587165_dp, 0.3807381363095051_dp, &
             0.498573667268664_dp, 0.6525272048530176_dp, 0.854240467429174_dp, &
             1.1202609140421145_dp, 1.475681670900564_dp, 1.9625327292416328_dp, &
             2.662659520035786_dp, 3.778741804491519_dp, 6.115254808272038_dp]

      CASE (682)

         aw(:) = & ! a
            [0.0009411302711210234_dp, 0.005010776748467259_dp, 0.012553305018747674_dp, &
             0.02398551551351663_dp, 0.03999407580327986_dp, 0.061642358579819756_dp, &
             0.090517072942732_dp, 0.12891042621147536_dp, 0.18003192722958608_dp, &
             0.24825861535947816_dp, 0.3394531443872367_dp, 0.4613895163423435_dp, &
             0.6243271076486784_dp, 0.8417776615581216_dp, 1.1315256799297877_dp, &
             1.5169952236339346_dp, 2.0291179682075584_dp, 2.7089825914562047_dp, &
             3.611821627047202_dp, 4.813554899249381_dp, 6.422876441315519_dp, &
             8.607357522526408_dp, 11.663737122712822_dp, 16.296795135086885_dp, &
             ! w
             0.0024211008057564223_dp, 0.005754967263036798_dp, 0.009398336695779457_dp, &
             0.013578768450602307_dp, 0.01861312264968949_dp, 0.02494483622588476_dp, &
             0.03318311473900336_dp, 0.044134415578475084_dp, 0.058832891141752885_dp, &
             0.07859059331877351_dp, 0.1050846660033124_dp, 0.14048532852853143_dp, &
             0.18762501598265888_dp, 0.2502177421819362_dp, 0.33315178590832834_dp, &
             0.44289962052824366_dp, 0.588130089211663_dp, 0.7807015575852408_dp, &
             1.0374444892928816_dp, 1.3837539542389072_dp, 1.8618615509861853_dp, &
             2.55342180378167_dp, 3.6596083700818394_dp, 5.976718686024244_dp]

      CASE (683)

         aw(:) = & ! a
            [0.0007395263543945543_dp, 0.003941572518727916_dp, 0.009894400012631439_dp, &
             0.018963475200702556_dp, 0.03175820110588902_dp, 0.04923397194387599_dp, &
             0.07283085095946515_dp, 0.10464331336284902_dp, 0.14761801054081408_dp, &
             0.205794626102374_dp, 0.28462292647256027_dp, 0.39139439965443834_dp, &
             0.5358267908257189_dp, 0.7308464630310925_dp, 0.9936315582964159_dp, &
             1.347011993582268_dp, 1.8213829134058839_dp, 2.457410280015274_dp, &
             3.3100773627989186_dp, 4.4552735151891225_dp, 6.001876066367415_dp, &
             8.117720744584359_dp, 11.099407203813982_dp, 15.649154276631815_dp, &
             ! w
             0.0019029291244265622_dp, 0.004532913211473161_dp, 0.007432503720489143_dp, &
             0.010805526095993041_dp, 0.014940827705365648_dp, 0.020247879918085653_dp, &
             0.027291697480156557_dp, 0.0368204077486961_dp, 0.0497970766767931_dp, &
             0.06745734254118603_dp, 0.09140486632412054_dp, 0.12374480952309476_dp, &
             0.16725719970540492_dp, 0.22562218675340426_dp, 0.3037217122755203_dp, &
             0.4080611028787368_dp, 0.5473934713361166_dp, 0.7337212829333106_dp, &
             0.984075704843862_dp, 1.3240808647498064_dp, 1.7961472991589371_dp, &
             2.4818626849087813_dp, 3.5814796050492324_dp, 5.886040667021983_dp]

      CASE (684)

         aw(:) = & ! a
            [0.0006129501526138582_dp, 0.00326980917654684_dp, 0.008221722031198595_dp, &
             0.015798203310283643_dp, 0.026554002530065395_dp, 0.04136707111295181_dp, &
             0.061570449432561965_dp, 0.08911208566379174_dp, 0.1267424836037067_dp, &
             0.1782496201537085_dp, 0.24877547351043894_dp, 0.34525075918403986_dp, &
             0.47698504141795145_dp, 0.6564582447340319_dp, 0.9003790198621467_dp, &
             1.2311086464346916_dp, 1.678608871418133_dp, 2.2831918955304893_dp, &
             3.099616300088342_dp, 4.203717226586259_dp, 5.704494140694199_dp, &
             7.769992887680097_dp, 10.696761820106_dp, 15.185234602997046_dp, &
             ! w
             0.0015775444698891115_dp, 0.003764457801212348_dp, 0.006193191407435528_dp, &
             0.009050604552440167_dp, 0.012605099621571506_dp, 0.017240539524123223_dp, &
             0.023487797087749663_dp, 0.0320500661731545_dp, 0.043836870994993685_dp, &
             0.060027237298224644_dp, 0.08216985901718306_dp, 0.11231926553983515_dp, &
             0.15321187264621117_dp, 0.20849593377631764_dp, 0.2830406454125993_dp, &
             0.3833675689982923_dp, 0.5182858023813587_dp, 0.6999020681545637_dp, &
             0.9454003082021856_dp, 1.280587343651824_dp, 1.7480292773401191_dp, &
             2.4292968405980573_dp, 3.524004248152637_dp, 5.81939298104682_dp]

      CASE (685)

         aw(:) = & ! a
            [0.00046131770047957684_dp, 0.002464432680446064_dp, 0.006213450082941195_dp, &
             0.011989713237440542_dp, 0.0202739670923448_dp, 0.03183770990271786_dp, &
             0.047864160735242814_dp, 0.07009325128549257_dp, 0.10099574452427537_dp, &
             0.14400101711456137_dp, 0.20381247218744628_dp, 0.28684429110282955_dp, &
             0.40181627215137466_dp, 0.5605554522652554_dp, 0.779074123523175_dp, &
             1.0790272450715859_dp, 1.489710948988265_dp, 2.0508806536274333_dp, &
             2.8169263178406574_dp, 3.863574512674365_dp, 5.299999835657104_dp, &
             7.29459539669274_dp, 10.143942604884918_dp, 14.546123831909066_dp, &
             ! w
             0.0011876772426390693_dp, 0.0028422624266297245_dp, 0.00470164567550287_dp, &
             0.0069294826805314_dp, 0.009765569875563148_dp, 0.013556709647476461_dp, &
             0.01878334347268186_dp, 0.02608292084610775_dp, 0.0362884493956485_dp, &
             0.05049880066327403_dp, 0.07018333845808819_dp, 0.09732040012787682_dp, &
             0.1345770042517659_dp, 0.18554614609096862_dp, 0.2550676629093684_dp, &
             0.3496754575275062_dp, 0.4782507116559213_dp, 0.6530477944791613_dp, &
             0.8914784297039305_dp, 1.2196343781360022_dp, 1.6803434771868369_dp, &
             2.355205115670181_dp, 3.4429887645006825_dp, 5.7256520566153215_dp]

      CASE (686)

         aw(:) = & ! a
            [0.00034089498965815616_dp, 0.001824133600156173_dp, 0.004613646570599141_dp, &
             0.008946853774764174_dp, 0.015236030518234703_dp, 0.024152193288095838_dp, &
             0.03673410832337178_dp, 0.05451857619209025_dp, 0.07970266880066451_dp, &
             0.11536532576269588_dp, 0.16578001208385867_dp, 0.23684987689224068_dp, &
             0.3367031868087777_dp, 0.4765012070768546_dp, 0.6715326750881394_dp, &
             0.9427027157804668_dp, 1.3185821764209442_dp, 1.8382976097143267_dp, &
             2.555794682986875_dp, 3.546626869756141_dp, 4.920110196125663_dp, &
             6.845003706638745_dp, 9.618014659823633_dp, 13.93508725407195_dp, &
             ! w
             0.0008779770928030986_dp, 0.0021081160334263773_dp, 0.003509543421451002_dp, &
             0.00522417896258082_dp, 0.0074641751489964185_dp, 0.010539131229068377_dp, &
             0.014878201275783298_dp, 0.02105329693480702_dp, 0.029822905091615504_dp, &
             0.042207487086141526_dp, 0.059595941453445_dp, 0.08388520698504935_dp, &
             0.11766363072685189_dp, 0.16445609334096556_dp, 0.229057495231711_dp, &
             0.3179973760891294_dp, 0.44021398789701405_dp, 0.6081003912027022_dp, &
             0.8392988888820658_dp, 1.1602065365684422_dp, 1.6139545135007922_dp, &
             2.282233801677403_dp, 3.3630564778542484_dp, 5.633281022925557_dp]

      CASE (687)

         aw(:) = & ! a
            [0.0001887958055683052_dp, 0.0010140011514231941_dp, 0.002583003922601531_dp, &
             0.005065843636089984_dp, 0.008767303672868059_dp, 0.014195806645690045_dp, &
             0.022150085281441592_dp, 0.033825817559567886_dp, 0.05096071305489695_dp, &
             0.07604460262093993_dp, 0.11262094036163765_dp, 0.16571019421414088_dp, &
             0.2423970234164884_dp, 0.35264021704239473_dp, 0.5103880232179784_dp, &
             0.7351166780546029_dp, 1.0539684383384267_dp, 1.5047765109252977_dp, &
             2.1405059805604374_dp, 3.0362342895097014_dp, 4.301436353372956_dp, &
             6.105565182872631_dp, 8.745790105013906_dp, 12.91480089982088_dp, &
             ! w
             0.0004866548172524495_dp, 0.0011772553374289525_dp, 0.001988302817545131_dp, &
             0.0030270108282469885_dp, 0.004459200392617905_dp, 0.006529200493232991_dp, &
             0.009576285769530103_dp, 0.014061355427484788_dp, 0.020618451757895194_dp, &
             0.030132944360771286_dp, 0.04384682754072329_dp, 0.06349915029377412_dp, &
             0.09151598975211848_dp, 0.13126986512357425_dp, 0.18743679329973525_dp, &
             0.2664949553638483_dp, 0.37744243279562967_dp, 0.5328904322696564_dp, &
             0.7508917684920442_dp, 1.0584332354854833_dp, 1.4992910285546268_dp, &
             2.155484367516968_dp, 3.223907162182144_dp, 5.472819232890789_dp]

      CASE (688)

         aw(:) = & ! a
            [0.00013342797987973343_dp, 0.0007184332548415464_dp, 0.0018390692702492176_dp, &
             0.0036350651574475375_dp, 0.006361497859811503_dp, 0.010449127026494677_dp, &
             0.016579552724153_dp, 0.025781310602525833_dp, 0.039567123007227666_dp, &
             0.06013626034170526_dp, 0.09066648681820992_dp, 0.13572698761687055_dp, &
             0.201856747454321_dp, 0.2983708670958517_dp, 0.4384820926388917_dp, &
             0.6408613830131488_dp, 0.9318208285622838_dp, 1.3484125488338308_dp, &
             1.9429738003820318_dp, 2.7902294585597747_dp, 3.9996767562662234_dp, &
             5.741148624572861_dp, 8.312178747319939_dp, 12.404009589084724_dp, &
             ! w
             0.0003441303682860819_dp, 0.0008367064277683689_dp, 0.0014271485282657704_dp, &
             0.0022063350723832945_dp, 0.0033170826663852255_dp, 0.004970229512062173_dp, &
             0.007459814830044763_dp, 0.01119250331316113_dp, 0.01674087326122238_dp, &
             0.024920250826889152_dp, 0.036892239616004956_dp, 0.05430535765067142_dp, &
             0.07948827337017293_dp, 0.11571649985817099_dp, 0.16758205278780863_dp, &
             0.24151137898409777_dp, 0.3465094381247945_dp, 0.4952839640656329_dp, &
             0.7061011756092086_dp, 1.006282080220728_dp, 1.4400007613120491_dp, &
             2.0895417976739252_dp, 3.1513302933553375_dp, 5.38929409080123_dp]

      CASE (689)

         aw(:) = & ! a
            [0.00010425047596871953_dp, 0.0005624348465868834_dp, 0.0014452921523250921_dp, &
             0.0028743854555867534_dp, 0.0050744449677817835_dp, 0.008427914037653294_dp, &
             0.013542889158904291_dp, 0.021343015765992533_dp, 0.03319959616368126_dp, &
             0.05112789056756592_dp, 0.07807138857580394_dp, 0.11830635507395201_dp, &
             0.17801276250383263_dp, 0.2660763393912661_dp, 0.3952121551997967_dp, &
             0.5835378573858977_dp, 0.8567851515927054_dp, 1.2514483302756385_dp, &
             1.819402229050183_dp, 2.635093881857171_dp, 3.808006307894955_dp, &
             5.508225843603138_dp, 8.033573159828725_dp, 12.074433686364182_dp, &
             ! w
             0.00026899663267416335_dp, 0.0006566251673895259_dp, 0.00112870041866376_dp, &
             0.0017660182423269914_dp, 0.0026967294542568783_dp, 0.004110114750662556_dp, &
             0.006271625788925743_dp, 0.009553959411800093_dp, 0.014490415308751625_dp, &
             0.021850120738124184_dp, 0.032740222014243536_dp, 0.04874654977830935_dp, &
             0.0721287903700858_dp, 0.10609175301845192_dp, 0.15516329894602404_dp, &
             0.22572540588939047_dp, 0.32677691084377064_dp, 0.47108079534345704_dp, &
             0.6770418744422565_dp, 0.972210621290131_dp, 1.4010476557873797_dp, &
             2.0460514237227136_dp, 3.103385390621538_dp, 5.334177993889868_dp]

      CASE (690)

         aw(:) = & ! a
            [8.607026921566776e-05_dp, 0.0004651149399599326_dp, 0.0011990714173133468_dp, &
             0.0023970742868090343_dp, 0.004262797199943254_dp, 0.007144731139314655_dp, &
             0.011599103119600454_dp, 0.018475562086382267_dp, 0.02904539171788074_dp, &
             0.04519283422904983_dp, 0.06969307828951081_dp, 0.10660994270366297_dp, &
             0.16186050755153258_dp, 0.24401302932384153_dp, 0.36541091229727196_dp, &
             0.5437541677448378_dp, 0.8043311718104402_dp, 1.1832039084244395_dp, &
             1.731881450340041_dp, 2.524581668394068_dp, 3.6707603384419523_dp, &
             5.340690019952558_dp, 7.832425996094568_dp, 11.83577476996332_dp, &
             ! w
             0.0002221683929426592_dp, 0.0005441123408987849_dp, 0.0009413819308082749_dp, &
             0.0014877198010867876_dp, 0.002300785473681304_dp, 0.0035544114405579833_dp, &
             0.005493850588446286_dp, 0.008467812372742653_dp, 0.012981331176203046_dp, &
             0.019769567948437095_dp, 0.02989896794631233_dp, 0.044907858676198946_dp, &
             0.06700288575139283_dp, 0.09933347646179794_dp, 0.1463757770523572_dp, &
             0.2144735415612446_dp, 0.3126152110717114_dp, 0.4535994422732931_dp, &
             0.6559311255358178_dp, 0.9473335289111675_dp, 1.3724903135207094_dp, &
             2.014077934557657_dp, 3.0680933792197753_dp, 5.293637803543986_dp]

      CASE (691)

         aw(:) = & ! a
            [6.445145739993479e-05_dp, 0.00034922573864358704_dp, 0.000905098491367133_dp, &
             0.00182487183604718_dp, 0.0032841141209512636_dp, 0.005585441589281539_dp, &
             0.009214804580489082_dp, 0.014921600245856427_dp, 0.023841045810697594_dp, &
             0.03767767689185784_dp, 0.05897354931366518_dp, 0.09149519837154177_dp, &
             0.14078810334579403_dp, 0.21496721497254054_dp, 0.32583971635823444_dp, &
             0.4904963926650961_dp, 0.7335709216685262_dp, 1.090477379205174_dp, &
             1.6121653554439899_dp, 2.3724879281399867_dp, 3.4808347512663413_dp, &
             5.107741028138104_dp, 7.551630076446481_dp, 11.501561931691924_dp, &
             ! w
             0.00016646513159794063_dp, 0.00040990072343832025_dp, 0.0007167644763677765_dp, &
             0.0011512986965996007_dp, 0.0018167165349732256_dp, 0.0028656421619792493_dp, &
             0.004515985656032691_dp, 0.0070838041047658114_dp, 0.011034785918661583_dp, &
             0.01705581702372685_dp, 0.026154602882558043_dp, 0.03979999061796447_dp, &
             0.06011991500298289_dp, 0.09018010732401763_dp, 0.1343764044627956_dp, &
             0.19898978208377358_dp, 0.29298466878551144_dp, 0.4292023522421472_dp, &
             0.6262863980504009_dp, 0.9122110915261565_dp, 1.3319955279595996_dp, &
             1.9686010802961946_dp, 3.0178281260791664_dp, 5.235941524008776_dp]

      CASE (692)

         aw(:) = & ! a
            [4.7418643294369677e-05_dp, 0.00025774669745857575_dp, 0.0006722154232610096_dp, &
             0.0013690484998241299_dp, 0.002498229525311891_dp, 0.004320072604535644_dp, &
             0.0072556219168702215_dp, 0.011961599431667937_dp, 0.019446569033982664_dp, &
             0.031245928732123392_dp, 0.04967959675089279_dp, 0.07822734872513695_dp, &
             0.12207187243213447_dp, 0.18888021292811724_dp, 0.2899231791889234_dp, &
             0.4416742098213092_dp, 0.6680939923915001_dp, 1.0039191866663002_dp, &
             1.4995008048615612_dp, 2.228284598653206_dp, 3.299560036031712_dp, &
             4.884116013550487_dp, 7.280777885983118_dp, 11.177960883088987_dp, &
             ! w
             0.0001225590896420599_dp, 0.0003037117142893077_dp, 0.000537776362192978_dp, &
             0.000880243545699582_dp, 0.0014207003340747865_dp, 0.0022919513418779218_dp, &
             0.0036867037086758146_dp, 0.005890483891323854_dp, 0.009331142025327265_dp, &
             0.014648091876885297_dp, 0.022790320946691468_dp, 0.03515617241771672_dp, &
             0.05379238772587816_dp, 0.08167658856617606_dp, 0.12311755994413606_dp, &
             0.18432433390541256_dp, 0.27422633207022185_dp, 0.405696473576583_dp, &
             0.5975095853432105_dp, 0.877892506855791_dp, 1.2922160174644357_dp, &
             1.9237605372451725_dp, 2.968181765164774_dp, 5.179004985329604_dp]

      CASE (693)

         aw(:) = & ! a
            [2.610837918220881e-05_dp, 0.00014294152953711235_dp, 0.00037823829830779283_dp, &
             0.0007883291636858416_dp, 0.0014836670604052187_dp, 0.0026583205059523204_dp, &
             0.004631674459068387_dp, 0.00791463449746751_dp, 0.013313792801150573_dp, &
             0.02209008059205638_dp, 0.03619642308260961_dp, 0.0586305139732096_dp, &
             0.09395470218112094_dp, 0.14905715670184888_dp, 0.23425987030445888_dp, &
             0.3649244441932152_dp, 0.5637754403243422_dp, 0.8642762772190523_dp, &
             1.315618090876835_dp, 1.9904139347500776_dp, 2.997683363901554_dp, &
             4.5086347976046985_dp, 6.822885222851859_dp, 10.62795212409125_dp, &
             ! w
             6.758819619053168e-05_dp, 0.00016994182958350685_dp, 0.0003096606452866372_dp, &
             0.0005284497656785211_dp, 0.0008939097374504265_dp, 0.0015075545451875359_dp, &
             0.0025226054448607266_dp, 0.004175159641001831_dp, 0.0068294356160370035_dp, &
             0.011042869269580353_dp, 0.01766093958916291_dp, 0.027955193660039738_dp, &
             0.0438230950360496_dp, 0.068075890272548_dp, 0.10485184235327691_dp, &
             0.1602097043710146_dp, 0.24298868411754887_dp, 0.36608844939550544_dp, &
             0.5484950112040988_dp, 0.8188834122309723_dp, 1.2232864492484932_dp, &
             1.8456362557073374_dp, 2.8814637006610293_dp, 5.0796664597325_dp]

      CASE (694)

         aw(:) = & ! a
            [1.8416687750042485e-05_dp, 0.00010133824836742902_dp, 0.00027089196657057704_dp, &
             0.0005736944887975803_dp, 0.0011021428620727463_dp, 0.0020197910232608593_dp, &
             0.003599193320138108_dp, 0.006283462534768932_dp, 0.010783661573626497_dp, &
             0.018228384440102482_dp, 0.030390269197808767_dp, 0.05002593152632277_dp, &
             0.08138213463949241_dp, 0.13094406849250767_dp, 0.20853441581974552_dp, &
             0.32891928525221653_dp, 0.5141484657577192_dp, 0.7969749765790031_dp, &
             1.2259243497387693_dp, 1.8731090193558748_dp, 2.847353490609118_dp, &
             4.320067886379148_dp, 6.591326168156173_dp, 10.348296583711107_dp, &
             ! w
             4.772900699701755e-05_dp, 0.00012122903472759187_dp, 0.00022532396215831503_dp, &
             0.00039527422396702915_dp, 0.0006882803215319564_dp, 0.0011914420915486407_dp, &
             0.0020396288849587915_dp, 0.003444984760152902_dp, 0.005739822200722312_dp, &
             0.009439520785622884_dp, 0.015335425407593311_dp, 0.024631475028841925_dp, &
             0.03914384125939362_dp, 0.061590900140885974_dp, 0.09601259400560788_dp, &
             0.14837638042963047_dp, 0.22745864953556036_dp, 0.34615685917191813_dp, &
             0.5235557930050255_dp, 0.788565881874275_dp, 1.187589036874192_dp, &
             1.8049477083780807_dp, 2.836177413417193_dp, 5.02784446982278_dp]

      CASE (695)

         aw(:) = & ! a
            [1.4379476875660705e-05_dp, 7.944072677434636e-05_dp, 0.00021408793237907966_dp, &
             0.0004591364105742203_dp, 0.0008960284465084502_dp, 0.001669765608058009_dp, &
             0.003024395620001795_dp, 0.005361428416498812_dp, 0.009332618282514442_dp, &
             0.015983422381147253_dp, 0.02697194804698383_dp, 0.04490003834434733_dp, &
             0.07380978782009179_dp, 0.11992243664630477_dp, 0.1927303597797634_dp, &
             0.30660168304523033_dp, 0.4831302611675917_dp, 0.754583091101484_dp, &
             1.1690231093810213_dp, 1.7982059981854133_dp, 2.7508049978432276_dp, &
             4.198354868072518_dp, 6.4412469792254665_dp, 10.166465347935803_dp, &
             ! w
             3.729872339597181e-05_dp, 9.550233077636349e-05_dp, 0.0001803067692627087_dp, &
             0.00032300059771685007_dp, 0.0005743849804293405_dp, 0.0010128151727083604_dp, &
             0.0017618544393789915_dp, 0.00301850376221718_dp, 0.00509455509525917_dp, &
             0.008478010392251779_dp, 0.013924585500662114_dp, 0.02259322051719583_dp, &
             0.036245322842248864_dp, 0.05753583167231124_dp, 0.09043633888597612_dp, &
             0.1408491093142117_dp, 0.21750283201225123_dp, 0.33328682182437386_dp, &
             0.5073459035430433_dp, 0.7687455716329866_dp, 1.164139885864926_dp, &
             1.7781285068318022_dp, 2.806278126354343_dp, 4.993649960979745_dp]

      CASE (696)

         aw(:) = & ! a
            [1.1869868659392883e-05_dp, 6.579873725198031e-05_dp, 0.00017854787249337202_dp, &
             0.00038696563339825655_dp, 0.0007649275248015224_dp, 0.0014446147759121677_dp, &
             0.0026503399256163815_dp, 0.004754611765203933_dp, 0.008367479644380128_dp, &
             0.014475441545644327_dp, 0.024654734736066126_dp, 0.041395736394096064_dp, &
             0.06859208178274945_dp, 0.1122722094970158_dp, 0.18168553543521138_dp, &
             0.2909053494701547_dp, 0.46118515796801196_dp, 0.7244260174106174_dp, &
             1.128338801713982_dp, 1.744403106065123_dp, 2.6811688492959522_dp, &
             4.110257448035766_dp, 6.332301390958184_dp, 10.034173171220958_dp, &
             ! w
             3.0811805276188275e-05_dp, 7.943163795834799e-05_dp, 0.00015194604998942248_dp, &
             0.0002768673144293447_dp, 0.0005005463277249662_dp, 0.0008953032650243461_dp, &
             0.0015767804865357874_dp, 0.002731180786330725_dp, 0.004655501963583216_dp, &
             0.007817846205637882_dp, 0.01294783208509387_dp, 0.021171179313085778_dp, &
             0.03420852514002672_dp, 0.054667132055999455_dp, 0.08646661201864665_dp, &
             0.13545877645622853_dp, 0.21033398807356385_dp, 0.32397199966905077_dp, &
             0.49555889181324647_dp, 0.754273716590566_dp, 1.146960090641393_dp, &
             1.7584316253358412_dp, 2.784292793904677_dp, 4.968516083047481_dp]

      CASE (697)

         aw(:) = & ! a
            [8.89159792421572e-06_dp, 4.956797593859735e-05_dp, 0.00013605354182909428_dp, &
             0.0002999774816598003_dp, 0.0006051679566362878_dp, 0.00116678643116254_dp, &
             0.0021828650626226297_dp, 0.003986975454291722_dp, 0.007132642404241459_dp, &
             0.012525733218187958_dp, 0.021629584892391147_dp, 0.036779651382950494_dp, &
             0.0616616759570113_dp, 0.10203213364836669_dp, 0.16679522934986216_dp, &
             0.26960221458280226_dp, 0.4312155609159948_dp, 0.6830036801795011_dp, &
             1.0721593594555405_dp, 1.6697490515158864_dp, 2.584128848182079_dp, &
             3.9870352267500606_dp, 6.179454382406481_dp, 9.848135697648654_dp, &
             ! w
             2.3109035961115926e-05_dp, 6.02520826232466e-05_dp, 0.00011776415169459174_dp, &
             0.0002204230294433494_dp, 0.0004086458426170141_dp, 0.0007467421454615169_dp, &
             0.0013396412087189713_dp, 0.002358684841842503_dp, 0.004080293702975978_dp, &
             0.006944658969234459_dp, 0.011644500486560797_dp, 0.01925818170073456_dp, &
             0.03144771528388423_dp, 0.050751140066791114_dp, 0.0810116930296267_dp, &
             0.128005765901508_dp, 0.2003643814385786_dp, 0.3109482560832928_dp, &
             0.47899756088003065_dp, 0.7338517483047018_dp, 1.1226297817929844_dp, &
             1.7304644346169935_dp, 2.753036319086578_dp, 4.932797214633451_dp]

      CASE (698)

         aw(:) = & ! a
            [6.549491470164241e-06_dp, 3.675992118587304e-05_dp, 0.00010229150016471586_dp, &
             0.0002300989740473544_dp, 0.00047493000524356923_dp, 0.0009365735438397159_dp, &
             0.0017891969325523956_dp, 0.003330624821140441_dp, 0.006061879975247759_dp, &
             0.010813119748880438_dp, 0.01894060303116302_dp, 0.032631462568626646_dp, &
             0.055370618240384466_dp, 0.09264953682645319_dp, 0.15303313601953122_dp, &
             0.24975422887365265_dp, 0.40308392826372863_dp, 0.6438521352879277_dp, &
             1.0187211865744763_dp, 1.5983264375784603_dp, 2.4908108720262887_dp, &
             3.8680138685284535_dp, 6.031281971845975_dp, 9.667284640639497_dp, &
             ! w
             1.7046848045904e-05_dp, 4.5053300950849274e-05_dp, 9.030890460672315e-05_dp, &
             0.00017416234574369624_dp, 0.00033165942589621856_dp, 0.0006198574580607246_dp, &
             0.0011337386013460233_dp, 0.0020305792700609517_dp, 0.0035670932629317644_dp, &
             0.006156476235375433_dp, 0.010455416007863942_dp, 0.017495580981029508_dp, &
             0.028880586770290206_dp, 0.04707873752414965_dp, 0.07585527931046517_dp, &
             0.12090809746721247_dp, 0.19080410426804453_dp, 0.29837876715472794_dp, &
             0.46291986847412764_dp, 0.7139231268669681_dp, 1.098785068946494_dp, &
             1.7029702014986956_dp, 2.7222607571156687_dp, 4.8976434161101405_dp]

      CASE (699)

         aw(:) = & ! a
            [3.6231638489974144e-06_dp, 2.0666258959103596e-05_dp, 5.9386798192876944e-05_dp, &
             0.00013966450003425118_dp, 0.0003023929535973138_dp, 0.0006239132203842525_dp, &
             0.0012415834836647572_dp, 0.002397144375103838_dp, 0.0045078532857277245_dp, &
             0.008281207668000756_dp, 0.014897519896363329_dp, 0.02629696756823826_dp, &
             0.04562587704763145_dp, 0.07792345533646255_dp, 0.13116863985229227_dp, &
             0.21786277904917078_dp, 0.35740709728432757_dp, 0.5796646568492807_dp, &
             0.9303290701340091_dp, 1.479228481229943_dp, 2.3340803353211097_dp, &
             3.666874529654296_dp, 5.779609662224813_dp, 9.358915696134543_dp, &
             ! w
             9.462829356948298e-06_dp, 2.582393719143882e-05_dp, 5.478764776929219e-05_dp, &
             0.00011235789917428121_dp, 0.00022541050884424443_dp, 0.000439823252088218_dp, &
             0.000834658513466712_dp, 0.0015441503518772801_dp, 0.0027922257555908062_dp, &
             0.004946544716387514_dp, 0.00860219334755444_dp, 0.014709922383457669_dp, &
             0.024770725090628422_dp, 0.041128475924466626_dp, 0.06740672052351113_dp, &
             0.10915712459144415_dp, 0.1748216337102886_dp, 0.27717575500987374_dp, &
             0.43557523319367486_dp, 0.6797814172535712_dp, 1.0576866281492552_dp, &
             1.6553728925553162_dp, 2.668864528354028_dp, 4.8366857728249535_dp]

      CASE (700)

         aw(:) = & ! a
            [2.5668709485767075e-06_dp, 1.4814047860829722e-05_dp, 4.354977911304416e-05_dp, &
             0.0001054830813475211_dp, 0.00023527920077971498_dp, 0.0004987161664713565_dp, &
             0.0010163147078496892_dp, 0.0020036725802634477_dp, 0.003838312404310137_dp, &
             0.007168624053973503_dp, 0.013088905936750479_dp, 0.0234169831350074_dp, &
             0.041129298418742875_dp, 0.071035384896434_dp, 0.12081306080965104_dp, &
             0.20258331502155236_dp, 0.3352894288899701_dp, 0.5482785725387223_dp, &
             0.8867190554907874_dp, 1.4199910810974723_dp, 2.2555625506289085_dp, &
             3.5654854406299905_dp, 5.652108093475424_dp, 9.202090376235223_dp, &
             ! w
             6.720754064709411e-06_dp, 1.8768558315887263e-05_dp, 4.1366860990526335e-05_dp, &
             8.807052852907412e-05_dp, 0.00018210431008171_dp, 0.0003642068566959797_dp, &
             0.0007058451367603335_dp, 0.0013300309146330846_dp, 0.0024444809051307687_dp, &
             0.0043940258680745135_dp, 0.007742447448539034_dp, 0.013398821459845719_dp, &
             0.02281056032708231_dp, 0.038255613474036575_dp, 0.06328116523818518_dp, &
             0.10335828612475916_dp, 0.16685729887724446_dp, 0.2665142613433028_dp, &
             0.42171210872629666_dp, 0.6623460252619595_dp, 1.0365712927147028_dp, &
             1.6308105671358557_dp, 2.641247645709985_dp, 4.8051746648398295_dp]

      CASE (701)

         aw(:) = & ! a
            [2.011895465153751e-06_dp, 1.1723364824408138e-05_dp, 3.5095911795379164e-05_dp, &
             8.6933699715748e-05_dp, 0.000198162808962633_dp, 0.00042819888773423977_dp, &
             0.0008873107078046534_dp, 0.0017749933315776947_dp, 0.0034440403924321595_dp, &
             0.006505714062992247_dp, 0.011999826233963971_dp, 0.02166608795082084_dp, &
             0.03837168245094283_dp, 0.06677738979294004_dp, 0.11436466679637546_dp, &
             0.19300477352150924_dp, 0.321338201704145_dp, 0.5283683943596655_dp, &
             0.8589104739875735_dp, 1.3820396045324734_dp, 2.205048749977677_dp, &
             3.500024113698465_dp, 5.569547496757411_dp, 9.10031727857536_dp, &
             ! w
             5.278413113034664e-06_dp, 1.5018920759248883e-05_dp, 3.408515870926816e-05_dp, &
             7.45495484921219e-05_dp, 0.00015745171307314743_dp, 0.00032038145105777865_dp, &
             0.0006300591094180497_dp, 0.0012024073387134865_dp, 0.002234813343462219_dp, &
             0.004057440936514008_dp, 0.007213800137548638_dp, 0.012585769386347333_dp, &
             0.021585518740865547_dp, 0.03644727448239819_dp, 0.0606670935229573_dp, &
             0.09966141461388588_dp, 0.1617510054591899_dp, 0.2596428303540104_dp, &
             0.41273447392037604_dp, 0.6510072177861492_dp, 1.0227908517919093_dp, &
             1.61473916165854_dp, 2.6231536107639766_dp, 4.784535081917654_dp]

      CASE (702)

         aw(:) = & ! a
            [1.666508049577257e-06_dp, 9.79195922229786e-06_dp, 2.976719639569971e-05_dp, &
             7.508899432805849e-05_dp, 0.00017412054971556627_dp, 0.00038190131085698016_dp, &
             0.0008015896454444582_dp, 0.0016214196504195668_dp, 0.003176764750821056_dp, &
             0.006052561661062765_dp, 0.011249758614268303_dp, 0.02045204387106796_dp, &
             0.03644783683230977_dp, 0.0637901575616464_dp, 0.10981753798220796_dp, &
             0.18621860962502862_dp, 0.31141135429804784_dp, 0.5141452889209098_dp, &
             0.8389729980451124_dp, 1.3547409306661051_dp, 2.1686083562292353_dp, &
             3.452683059026712_dp, 5.50971944265975_dp, 9.026453576778804_dp, &
             ! w
             4.379962540155109e-06_dp, 1.2663911715794544e-05_dp, 2.943582064293583e-05_dp, &
             6.57479994815269e-05_dp, 0.0001411440051568916_dp, 0.0002910168337339391_dp, &
             0.0005787330395056623_dp, 0.0011151701949330154_dp, 0.002090319268985992_dp, &
             0.0038237812425822963_dp, 0.006844385901186699_dp, 0.01201420933272734_dp, &
             0.020719622038716173_dp, 0.035162659118903865_dp, 0.058801490767019744_dp, &
             0.0970117352483137_dp, 0.15807663136259326_dp, 0.254680227579877_dp, &
             0.40622915836632156_dp, 0.6427667192153472_dp, 1.0127512301683719_dp, &
             1.603009332455124_dp, 2.609935199620177_dp, 4.769459884767857_dp]

      CASE (703)

         aw(:) = & ! a
            [1.255930727790156e-06_dp, 7.485090992357303e-06_dp, 2.3338069007555833e-05_dp, &
             6.0586242535196434e-05_dp, 0.00014421698572414032_dp, 0.00032347734989359025_dp, &
             0.0006920276156423274_dp, 0.001422928393350737_dp, 0.0028279012496830623_dp, &
             0.005455896976071931_dp, 0.01025441015651299_dp, 0.018829635036160114_dp, &
             0.03386045932107693_dp, 0.05974928969115446_dp, 0.10363391727551965_dp, &
             0.17694522226743298_dp, 0.29778558218846346_dp, 0.4945424083818464_dp, &
             0.8113915309260751_dp, 1.3168483088441403_dp, 2.1178747891163106_dp, &
             3.386604034305876_dp, 5.426036692072949_dp, 8.922975819603801_dp, &
             ! w
             3.310831078414613e-06_dp, 9.834627350156096e-06_dp, 2.3743161673730403e-05_dp, &
             5.4742290332050724e-05_dp, 0.00012040403243127354_dp, 0.0002531654467926627_dp, &
             0.0005118255426143177_dp, 0.0010003409616212845_dp, 0.001898491496210142_dp, &
             0.0035112072124122446_dp, 0.00634681078723501_dp, 0.011239561453289684_dp, &
             0.01953938600509518_dp, 0.0334025813261772_dp, 0.05623313295897414_dp, &
             0.09334779037508346_dp, 0.15297494677240175_dp, 0.24776390329859116_dp, &
             0.3971316051305622_dp, 0.6312074278898153_dp, 0.9986323715834984_dp, &
             1.5864826416512963_dp, 2.591293052132225_dp, 4.748203054927835_dp]

      CASE (704)

         aw(:) = & ! a
            [9.321825065344991e-07_dp, 5.6542705004737865e-06_dp, 1.8164164292428563e-05_dp, &
             4.868435806347234e-05_dp, 0.00011917940460300414_dp, 0.0002736711878849238_dp, &
             0.0005971531854435529_dp, 0.0012486956410471333_dp, 0.002518013953726868_dp, &
             0.004920305859126883_dp, 0.00935256125525346_dp, 0.01734726177328151_dp, &
             0.03147845316954256_dp, 0.05600351983890705_dp, 0.09786585523202557_dp, &
             0.16824531735274884_dp, 0.28493513576069945_dp, 0.4759658094889152_dp, &
             0.7851391108561293_dp, 1.2806383949936875_dp, 2.069223747075352_dp, &
             3.3230467688977554_dp, 5.34535083343202_dp, 8.82301987561055_dp, &
             ! w
             2.4666340152198957e-06_dp, 7.571121223884459e-06_dp, 1.907074078403665e-05_dp, &
             4.54661847163987e-05_dp, 0.00010255839531299155_dp, 0.0002200603944884196_dp, &
             0.00045250663772550433_dp, 0.0008973371311270423_dp, 0.0017246436783749544_dp, &
             0.0032253374428767826_dp, 0.005888012258500257_dp, 0.01051999061798292_dp, &
             0.018435678660655788_dp, 0.031746491251632536_dp, 0.05380284110291157_dp, &
             0.08986271981527012_dp, 0.14809896124004462_dp, 0.24112426177007623_dp, &
             0.3883627540985915_dp, 0.6200259387896603_dp, 0.9849341399869239_dp, &
             1.570413029025758_dp, 2.573145656790633_dp, 4.727514713964398_dp]

      CASE (705)

         aw(:) = & ! a
            [5.255908925744213e-07_dp, 3.3304383238004107e-06_dp, 1.1443109624783916e-05_dp, &
             3.274314854585307e-05_dp, 8.463509922732927e-05_dp, 0.00020315325962123426_dp, &
             0.00045982128598097156_dp, 0.0009916500017658595_dp, 0.002053220067040241_dp, &
             0.00410523807758926_dp, 0.007962336583849743_dp, 0.015035684133530595_dp, &
             0.027725300435719146_dp, 0.050045899108959103_dp, 0.0886130494935645_dp, &
             0.15418005146046893_dp, 0.26401070026274287_dp, 0.44551914501472983_dp, &
             0.7418549215172512_dp, 1.2206148402757315_dp, 1.9881924548156118_dp, &
             3.216756274228061_dp, 5.209968530749456_dp, 8.65488645350951_dp, &
             ! w
             1.4041187144128398e-06_dp, 4.65945746373288e-06_dp, 1.2808883635109877e-05_dp, &
             3.254706865100145e-05_dp, 7.697394301879186e-05_dp, 0.0001715035993932324_dp, &
             0.0003638326660916254_dp, 0.0007408314505770373_dp, 0.0014567119340833138_dp, &
             0.00277917966751328_dp, 0.0051638676664433536_dp, 0.00937269395086945_dp, &
             0.016659663050867045_dp, 0.029059174847929973_dp, 0.04982878864662892_dp, &
             0.08412338360307972_dp, 0.1400164244118149_dp, 0.2300519591079407_dp, &
             0.3736595968476675_dp, 0.6011862346544015_dp, 0.9617600219211764_dp, &
             1.5431454519436787_dp, 2.542303828767266_dp, 4.692363952999028_dp]

      CASE (706)

         aw(:) = & ! a
            [3.7774678648482005e-07_dp, 2.4736741274966162e-06_dp, 8.889106086152047e-06_dp, &
             2.645955995169582e-05_dp, 7.055878390956706e-05_dp, 0.00017360501573076073_dp, &
             0.00040091829666080155_dp, 0.0008792012945017072_dp, 0.0018464100101047538_dp, &
             0.00373718127951489_dp, 0.007326353218524106_dp, 0.013965944349060873_dp, &
             0.025970410593154174_dp, 0.047234212273879084_dp, 0.08420924677686167_dp, &
             0.14743427869652181_dp, 0.2539048399756715_dp, 0.43072029620078806_dp, &
             0.7206940248780189_dp, 1.1911168284756521_dp, 1.9481863345109296_dp, &
             3.1640721870991877_dp, 5.142650229948148_dp, 8.571082168791298_dp, &
             ! w
             1.0167569611090138e-06_dp, 3.566831543882181e-06_dp, 1.0337803281361749e-05_dp, &
             2.7230318663633734e-05_dp, 6.611901304740002e-05_dp, 0.00015040557419417_dp, &
             0.0003245395042251765_dp, 0.0006703139684105778_dp, 0.0013342325720729195_dp, &
             0.0025726267479815514_dp, 0.004824827146280093_dp, 0.008830100585281596_dp, &
             0.015812063472740504_dp, 0.027766033422029608_dp, 0.04790200308733762_dp, &
             0.08132141759645975_dp, 0.136045354853115_dp, 0.22458017769344552_dp, &
             0.3663549105011692_dp, 0.5917824245359105_dp, 0.9501471066912243_dp, &
             1.529441431923682_dp, 2.526779629080599_dp, 4.674675165636894_dp]

      CASE (707)

         aw(:) = & ! a
            [2.9966407897336536e-07_dp, 2.016765294564868e-06_dp, 7.498124840720449e-06_dp, &
             2.2956278962220296e-05_dp, 6.25512438204073e-05_dp, 0.0001565168360911557_dp, &
             0.0003663881428105752_dp, 0.0008125263631454981_dp, 0.001722587190363661_dp, &
             0.003514953682145494_dp, 0.006939513652529784_dp, 0.013311010271228278_dp, &
             0.024889724812769225_dp, 0.04549364407386586_dp, 0.08147014396008116_dp, &
             0.14322042524415524_dp, 0.24756729363735042_dp, 0.4214065474802654_dp, &
             0.707333082751402_dp, 1.1724374904804709_dp, 1.922787539352113_dp, &
             3.1305508751701203_dp, 5.099741320746874_dp, 8.517593757798599_dp, &
             ! w
             8.118402379748681e-07_dp, 2.9767643746759905e-06_dp, 8.958773407829602e-06_dp, &
             2.4188732065655904e-05_dp, 5.9798319523643864e-05_dp, 0.00013794980257671275_dp, &
             0.0003010774357778089_dp, 0.000627802625559086_dp, 0.0012597845443616017_dp, &
             0.0024461671298049736_dp, 0.004615926724791454_dp, 0.008493873895452728_dp, &
             0.015284139459586966_dp, 0.02695686044632157_dp, 0.04669122323293095_dp, &
             0.07955384903484494_dp, 0.13353135931176155_dp, 0.22110480988315032_dp, &
             0.361701630907671_dp, 0.5857762060870976_dp, 0.9427135896538691_dp, &
             1.5206550628946045_dp, 2.516817619908326_dp, 4.6633255815492225_dp]

      CASE (708)

         aw(:) = & ! a
            [2.508770003629448e-07_dp, 1.729068468961415e-06_dp, 6.607740100941875e-06_dp, &
             2.0674684595674792e-05_dp, 5.7260600901523145e-05_dp, 0.00014509500912665858_dp, &
             0.00034308853971090245_dp, 0.000767180190633804_dp, 0.0016378076010595578_dp, &
             0.0033619147940743906_dp, 0.006671762625750891_dp, 0.012855668170377534_dp, &
             0.0241353830487588_dp, 0.04427434286100904_dp, 0.07954515300427452_dp, &
             0.14025033414148916_dp, 0.24308844289971918_dp, 0.414808411277222_dp, &
             0.6978469777919645_dp, 1.159149156469379_dp, 1.9046874825976505_dp, &
             3.106626816750737_dp, 5.069080437067063_dp, 8.479338721964988_dp, &
             ! w
             6.836563523641364e-07_dp, 2.6014659035089563e-06_dp, 8.059929137868434e-06_dp, &
             2.217141044768141e-05_dp, 5.5554101192827904e-05_dp, 0.00012950532288842745_dp, &
             0.00028504570826151426_dp, 0.0005985616762051011_dp, 0.0012082846777621118_dp, &
             0.002358253947292533_dp, 0.00447006649626699_dp, 0.008258196383373868_dp, &
             0.014912797502291792_dp, 0.026385886747062_dp, 0.04583440446545356_dp, &
             0.07829971929200558_dp, 0.13174331431614134_dp, 0.21862753274127927_dp, &
             0.358378061505983_dp, 0.5814786679503154_dp, 0.9373868478064913_dp, &
             1.5143519070265659_dp, 2.5096668658111927_dp, 4.6551795101428715_dp]

      CASE (709)

         aw(:) = & ! a
            [1.9264176595371223e-07_dp, 1.3825832395128835e-06_dp, 5.5153140488003255e-06_dp, &
             1.7823143088041275e-05_dp, 5.054859269604775e-05_dp, 0.00013043097252956172_dp, &
             0.0003128844221271794_dp, 0.0007079223298258678_dp, 0.0015262624924254136_dp, &
             0.003159378216683541_dp, 0.006315598415537916_dp, 0.012247235884980208_dp, &
             0.0231233786773664_dp, 0.042632676394778427_dp, 0.07694493696959968_dp, &
             0.13622663593188175_dp, 0.2370045571917654_dp, 0.4058239952180038_dp, &
             0.6849016600652033_dp, 1.1409791450984343_dp, 1.8798947902726888_dp, &
             3.07380771882253_dp, 5.026968967980853_dp, 8.426749577323196_dp, &
             ! w
             5.304678113603172e-07_dp, 2.1441982380002112e-06_dp, 6.935522600851609e-06_dp, &
             1.960233077880767e-05_dp, 5.0080402524234486e-05_dp, 0.00011850729898150323_dp, &
             0.0002639983610371424_dp, 0.0005599137777205965_dp, 0.001139824428678728_dp, &
             0.002240802569465352_dp, 0.004274338514400611_dp, 0.007940702969032808_dp, &
             0.01441078297259345_dp, 0.025611536253611074_dp, 0.04466903136518609_dp, &
             0.07658944767779852_dp, 0.1292990290313732_dp, 0.21523354513821583_dp, &
             0.3538154427413664_dp, 0.5755684418219095_dp, 0.930050217100013_dp, &
             1.5056607768670003_dp, 2.499801166835287_dp, 4.643941527524527_dp]

      CASE (710)

         aw(:) = & ! a
            [1.465093527715584e-07_dp, 1.104765369990518e-06_dp, 4.61781450163179e-06_dp, &
             1.5426407928811306e-05_dp, 4.480505746825221e-05_dp, 0.00011770507939170671_dp, &
             0.00028637398065797174_dp, 0.0006554227878941288_dp, 0.0014266572050182665_dp, &
             0.0029772946861361263_dp, 0.005993513620315467_dp, 0.011694169130008907_dp, &
             0.02219923087295149_dp, 0.04112735852385193_dp, 0.07455184399663503_dp, &
             0.13251102962603944_dp, 0.2313694058851084_dp, 0.3974792277873134_dp, &
             0.6728478405632048_dp, 1.1240223182008329_dp, 1.856711476234256_dp, &
             3.043066972808633_dp, 4.98747026753634_dp, 8.377372807978487_dp, &
             ! w
             4.089527360579679e-07_dp, 1.771766178634674e-06_dp, 5.989339334151199e-06_dp, &
             1.7394373224397768e-05_dp, 4.530586031890046e-05_dp, 0.00010880335423639561_dp, &
             0.00024525370455501315_dp, 0.0005252250685532874_dp, 0.0010779678226346802_dp, &
             0.002134067583029784_dp, 0.004095567387984674_dp, 0.007649411506065918_dp, &
             0.013948343834735324_dp, 0.024895638638926576_dp, 0.04358807360109462_dp, &
             0.07499828521684905_dp, 0.12701870298893356_dp, 0.21205923460732037_dp, &
             0.3495383727121509_dp, 0.5700168596564025_dp, 0.9231470428842837_dp, &
             1.4974727731915656_dp, 2.490500299376918_dp, 4.633347908597025_dp]

      CASE (711)

         aw(:) = & ! a
            [8.83557997605878e-08_dp, 7.476213250134589e-07_dp, 3.420943251523543e-06_dp, &
             1.2127504869383644e-05_dp, 3.670730785970545e-05_dp, 9.942693908157206e-05_dp, &
             0.0002477292775619158_dp, 0.0005779578063836622_dp, 0.0012781790562788173_dp, &
             0.002703491888580084_dp, 0.005505511046375136_dp, 0.010850615936809553_dp, &
             0.020781376406521064_dp, 0.038805683225496386_dp, 0.07084344830010995_dp, &
             0.12672857536342025_dp, 0.22256557731930715_dp, 0.3843961800833152_dp, &
             0.653889333621267_dp, 1.0972757549508916_dp, 1.8200511535755035_dp, &
             2.9943509949545093_dp, 4.9247661507819975_dp, 8.298885375184273_dp, &
             ! w
             2.555293260969674e-07_dp, 1.2810163275365013e-06_dp, 4.684831369496089e-06_dp, &
             1.4264538683883918e-05_dp, 3.840469132181553e-05_dp, 9.456489514034605e-05_dp, &
             0.0002174140317560235_dp, 0.00047318215464642603_dp, 0.0009843651188738444_dp, &
             0.001971351097648105_dp, 0.003821255399580891_dp, 0.007199864383142737_dp, &
             0.013230984500068333_dp, 0.02377994099873053_dp, 0.041896344862730604_dp, &
             0.07249850403177445_dp, 0.1234236275312518_dp, 0.2070386570876527_dp, &
             0.342753920314871_dp, 0.5611879619355967_dp, 0.9121448015943489_dp, &
             1.484401674574574_dp, 2.4756397828331553_dp, 4.616423772883867_dp]

      CASE (712)

         aw(:) = & ! a
            [6.73037114169863e-08_dp, 6.150839283045243e-07_dp, 2.9579920066772968e-06_dp, &
             1.0809320024687083e-05_dp, 3.3393911429821674e-05_dp, 9.181253556911713e-05_dp, &
             0.00023140128944992754_dp, 0.0005448492708841132_dp, 0.0012141085798527968_dp, &
             0.002584376070646481_dp, 0.0052917119047038936_dp, 0.010478768888306074_dp, &
             0.02015297090975294_dp, 0.037771710505760975_dp, 0.06918471366540907_dp, &
             0.12413199592129741_dp, 0.21859824461020386_dp, 0.37848151893692467_dp, &
             0.6452935409989419_dp, 1.0851172251044725_dp, 1.8033476977103298_dp, &
             2.9721111718644626_dp, 4.896095224989115_dp, 8.262955422511705_dp, &
             ! w
             1.999055905481422e-07_dp, 1.093467199972253e-06_dp, 4.1627088549732715e-06_dp, &
             1.2977597964210251e-05_dp, 3.551324730754912e-05_dp, 8.851309228664333e-05_dp, &
             0.00020544454619325942_dp, 0.0004505933008500562_dp, 0.0009434105470464506_dp, &
             0.0018996643448384969_dp, 0.0036996752462780985_dp, 0.006999557208772001_dp, &
             0.012909832266855032_dp, 0.023278331362169436_dp, 0.04113282583934989_dp, &
             0.07136633688524384_dp, 0.12179018414807075_dp, 0.2047508638810021_dp, &
             0.33965417285495386_dp, 0.5571446626274162_dp, 0.9070962569494883_dp, &
             1.4783949942011378_dp, 2.4688054050477204_dp, 4.6086410889496_dp]

      CASE (713)

         aw(:) = & ! a
            [5.637566905316404e-08_dp, 5.451412979973509e-07_dp, 2.7076988495492482e-06_dp, &
             1.0084001391821436e-05_dp, 3.154783868772073e-05_dp, 8.753036775597828e-05_dp, &
             0.00022215155841846787_dp, 0.0005259823855587696_dp, 0.001177418607738147_dp, &
             0.0025158803381232827_dp, 0.005168329134193652_dp, 0.010263505757182758_dp, &
             0.019788181537049913_dp, 0.03717001579327548_dp, 0.06821733135608407_dp, &
             0.12261465737440959_dp, 0.21627573734908737_dp, 0.3750134096418765_dp, &
             0.640245931716625_dp, 1.0779681129759702_dp, 1.7935148190838959_dp, &
             2.9590062450557983_dp, 4.879187275234374_dp, 8.241754080516271_dp, &
             ! w
             1.7100456010361993e-07_dp, 9.926971823345007e-07_dp, 3.875173981192119e-06_dp, &
             1.2258858785979523e-05_dp, 3.3882578450733986e-05_dp, 8.507468118673443e-05_dp, &
             0.00019860359066267353_dp, 0.0004376200824290833_dp, 0.0009197929818837754_dp, &
             0.0018581786910477557_dp, 0.0036291002929185476_dp, 0.00688296869424028_dp, &
             0.012722456858343813_dp, 0.022985037749146005_dp, 0.04068552296418643_dp, &
             0.0707018891871148_dp, 0.12082999746152481_dp, 0.20340404725924074_dp, &
             0.3378269224946423_dp, 0.5547583804229727_dp, 0.9041137292525309_dp, &
             1.4748437939726093_dp, 2.4647632473887784_dp, 4.604038280587225_dp]

      CASE (714)

         aw(:) = & ! a
            [4.9772733442355435e-08_dp, 5.023627036539797e-07_dp, 2.5521009941598543e-06_dp, &
             9.627965328776978e-06_dp, 3.0377916882720864e-05_dp, 8.480061372498682e-05_dp, &
             0.0002162280934113343_dp, 0.0005138554691296738_dp, 0.0011537633995521374_dp, &
             0.0024716044334467937_dp, 0.005088396256815142_dp, 0.010123777822512099_dp, &
             0.019550990554601085_dp, 0.03677819071667573_dp, 0.06758651152968595_dp, &
             0.12162400289281462_dp, 0.21475771435539226_dp, 0.3727443278690883_dp, &
             0.6369404310716952_dp, 1.0732826008768912_dp, 1.7870657505421097_dp, &
             2.9504058932368378_dp, 4.868085651331815_dp, 8.227828346148627_dp, &
             ! w
             1.5352793724805392e-07_dp, 9.302920906943039e-07_dp, 3.694296677365706e-06_dp, &
             1.1802709208025934e-05_dp, 3.28412887152216e-05_dp, 8.286877595237555e-05_dp, &
             0.0001941985153917856_dp, 0.00042924083999099956_dp, 0.0009044996597311365_dp, &
             0.0018312562516105324_dp, 0.003583213002283877_dp, 0.00680703685979662_dp, &
             0.012600241261229146_dp, 0.022793481565913754_dp, 0.04039302751764794_dp, &
             0.07026692412795217_dp, 0.12020080496789606_dp, 0.20252069802280734_dp, &
             0.3366274759254646_dp, 0.553190825239167_dp, 0.902153291225225_dp, &
             1.4725084903030499_dp, 2.4621044257781532_dp, 4.6010107637177535_dp]

      CASE (715)

         aw(:) = & ! a
            [4.263327905827938e-08_dp, 4.555442061369081e-07_dp, 2.3792518347357195e-06_dp, &
             9.116263349047226e-06_dp, 2.9056050443521292e-05_dp, 8.170048898751679e-05_dp, &
             0.0002094741174576538_dp, 0.0004999839009847217_dp, 0.0011266331853945625_dp, &
             0.0024207104010501605_dp, 0.004996338354509343_dp, 0.009962584423797492_dp, &
             0.01927695706724967_dp, 0.036324909521959395_dp, 0.06685589234985742_dp, &
             0.12047540676637648_dp, 0.21299598672344616_dp, 0.37010868482805165_dp, &
             0.6330979340995081_dp, 1.0678320789361795_dp, 1.779559095270237_dp, &
             2.9403898906362462_dp, 4.855151166518804_dp, 8.211598370792768_dp, &
             ! w
             1.3461276471971353e-07_dp, 8.611940074775547e-07_dp, 3.4912528480249925e-06_dp, &
             1.1286685298132144e-05_dp, 3.1656985894881816e-05_dp, 8.034971335483267e-05_dp, &
             0.00018915187167193505_dp, 0.0004196159018889861_dp, 0.0008868938798695513_dp, &
             0.0018002042472326056_dp, 0.003530200096345398_dp, 0.006719187013547815_dp, &
             0.012458661301896497_dp, 0.022571318613227937_dp, 0.040053444121103794_dp, &
             0.0697614577762599_dp, 0.11946899912327133_dp, 0.20149247709176296_dp, &
             0.3352303212847525_dp, 0.5513637313713607_dp, 0.8998670503124884_dp, &
             1.4697840051404651_dp, 2.4590018441782022_dp, 4.597478038703463_dp]

      CASE (716)

         aw(:) = & ! a
            [3.9553391093700604e-08_dp, 4.3512701604117224e-07_dp, 2.302932448530375e-06_dp, &
             8.888484166138473e-06_dp, 2.8464346060959095e-05_dp, 8.030708924025138e-05_dp, &
             0.00020642879968401902_dp, 0.0004937133696804489_dp, 0.0011143433683227335_dp, &
             0.0023976147411339946_dp, 0.004954498813196079_dp, 0.009889226135376591_dp, &
             0.019152100287430633_dp, 0.03611816885552533_dp, 0.06652234941493979_dp, &
             0.11995061108518992_dp, 0.21219044329517284_dp, 0.36890272417691433_dp, &
             0.6313386823977204_dp, 1.065335227969929_dp, 1.7761186703751048_dp, &
             2.9357974929020836_dp, 4.849218651837246_dp, 8.204152504629592_dp, &
             ! w
             1.2644444670913428e-07_dp, 8.307625908807098e-07_dp, 3.4008397351421422e-06_dp, &
             1.1055477945937366e-05_dp, 3.112407025450718e-05_dp, 7.92125092015585e-05_dp, &
             0.00018686778963648376_dp, 0.0004152505968138721_dp, 0.000878894923058918_dp, &
             0.001786074996990426_dp, 0.0035060468295567814_dp, 0.006679115968754238_dp, &
             0.01239401686072571_dp, 0.022469788335589352_dp, 0.03989812431819047_dp, &
             0.06953009360685869_dp, 0.11913380626768146_dp, 0.20102122327344038_dp, &
             0.33458961786871366_dp, 0.5505254519244984_dp, 0.8988176770561613_dp, &
             1.468533093256879_dp, 2.4575770930727106_dp, 4.595855787712363_dp]

      CASE (717)

         aw(:) = & ! a
            [0.001264792186980667_dp, 0.006719746651533019_dp, 0.016768017908939923_dp, &
             0.031844448136599694_dp, 0.0526472378282337_dp, 0.08022815891214524_dp, &
             0.11611779125345187_dp, 0.16248635442730888_dp, 0.22233443343108342_dp, &
             0.29971065725666435_dp, 0.3999670587299389_dp, 0.5300785700219749_dp, &
             0.6990609349677402_dp, 0.9185230328881094_dp, 1.2033945239351396_dp, &
             1.57288547941923_dp, 2.05176801026866_dp, 2.6721351455965645_dp, &
             3.475925118934264_dp, 4.518789245187692_dp, 5.876568283988842_dp, &
             7.657453476949997_dp, 10.028500579165467_dp, 13.287269360867699_dp, &
             18.14623369152218_dp, &
             ! w
             0.003252145480014078_dp, 0.0076975105222907006_dp, 0.012470420302847464_dp, &
             0.01779733205666143_dp, 0.023981454966389173_dp, 0.03143278617471357_dp, &
             0.04070499044555699_dp, 0.052528630015347126_dp, 0.06783811086572537_dp, &
             0.08780110197318536_dp, 0.11386730855277_dp, 0.1478492255578618_dp, &
             0.19203831857080877_dp, 0.24935836314489407_dp, 0.32356528303352233_dp, &
             0.41951663072333456_dp, 0.5435564428716237_dp, 0.7041057265580195_dp, &
             0.9126477303176014_dp, 1.1855344800342673_dp, 1.5476658838496187_dp, &
             2.040972683230338_dp, 2.7475175625354233_dp, 3.871228739305233_dp, &
             6.223067895896287_dp]

      CASE (718)

         aw(:) = & ! a
            [0.0009019824790200289_dp, 0.004798124254710645_dp, 0.012000746348039203_dp, &
             0.022871751440315988_dp, 0.03800119549154519_dp, 0.05829287604467917_dp, &
             0.0850825523222433_dp, 0.12028681558582045_dp, 0.16657694336046427_dp, &
             0.22758018137914815_dp, 0.308127055853057_dp, 0.4145747903547037_dp, &
             0.5552391756094838_dp, 0.7409680922083405_dp, 0.9858974236592485_dp, &
             1.3084480812745232_dp, 1.7326562975658777_dp, 2.28999239287103_dp, &
             3.021951489169225_dp, 3.9839817826240718_dp, 5.2519896863678_dp, &
             6.934448454158269_dp, 9.19866879249285_dp, 12.341660976789266_dp, &
             17.071365106394726_dp, &
             ! w
             0.0023199217015820485_dp, 0.005504737687714373_dp, 0.008959830143646782_dp, &
             0.012879116787825596_dp, 0.017528426762849436_dp, 0.023275060735463298_dp, &
             0.03062082762942329_dp, 0.04022960422654227_dp, 0.052951146875945564_dp, &
             0.06985510396167391_dp, 0.09229106033536737_dp, 0.1219809080285301_dp, &
             0.1611433783359864_dp, 0.21265402736794287_dp, 0.2802529626775681_dp, &
             0.368824700890271_dp, 0.4847948235861328_dp, 0.6367303498539257_dp, &
             0.8363269121288506_dp, 1.100199228179841_dp, 1.453509336286211_dp, &
             1.9383294376081197_dp, 2.6364512391097206_dp, 3.750184287401272_dp, &
             6.082028458308234_dp]

      CASE (719)

         aw(:) = & ! a
            [0.0007085512156654903_dp, 0.0037727899369717727_dp, 0.00945329942157289_dp, &
             0.01806669347522852_dp, 0.03013508634097651_dp, 0.04646782774258337_dp, &
             0.068273597307657_dp, 0.0972994741805902_dp, 0.13599257725520975_dp, &
             0.1876913601172234_dp, 0.2568693114902722_dp, 0.34946123924173056_dp, &
             0.4733023835428611_dp, 0.6387127549098096_dp, 0.8592688031239546_dp, &
             1.1528235835592535_dp, 1.5428697612523479_dp, 2.060401317965205_dp, &
             2.7465549468899155_dp, 3.6565886495831417_dp, 4.8664192619846345_dp, &
             6.484710858886317_dp, 8.678997458851105_dp, 11.746043311320129_dp, &
             16.391005542660675_dp, &
             ! w
             0.001822815327019953_dp, 0.0043335625369764685_dp, 0.007079293766997166_dp, &
             0.010233166183811936_dp, 0.014036631513600822_dp, 0.018827963291972654_dp, &
             0.025072076341200674_dp, 0.03338440128882293_dp, 0.04455422758869428_dp, &
             0.059583552116233604_dp, 0.07975424053254619_dp, 0.1067258461620191_dp, &
             0.14266372370616048_dp, 0.19040297254662666_dp, 0.2536622653768278_dp, &
             0.3373323285973978_dp, 0.4478828664017129_dp, 0.5939726136047219_dp, &
             0.7874413987581261_dp, 1.0450934815760544_dp, 1.392294376947921_dp, &
             1.8712540835771283_dp, 2.563641274471628_dp, 3.670766294275969_dp, &
             5.989685252015426_dp]

      CASE (720)

         aw(:) = & ! a
            [0.0005871234347755582_dp, 0.0031287200652076437_dp, 0.0078512444963358_dp, &
             0.015039656424595605_dp, 0.025168156255180565_dp, 0.038978665802516604_dp, &
             0.05758766442879519_dp, 0.08261725534928242_dp, 0.11634769905813049_dp, &
             0.1619020956225047_dp, 0.22348801795368534_dp, 0.3067253573068742_dp, &
             0.41908918122991323_dp, 0.5705001351482432_dp, 0.7741061157332458_dp, &
             1.0473185683450876_dp, 1.4131997008186337_dp, 1.902357383842213_dp, &
             2.5556273324806322_dp, 3.428094379825971_dp, 4.595661373412782_dp, &
             6.167131087440881_dp, 8.310227643324977_dp, 11.321593639412928_dp, &
             15.904445742481778_dp, &
             ! w
             0.0015107073128955751_dp, 0.0035973055122298626_dp, 0.0058943513015849635_dp, &
             0.008560208866273868_dp, 0.011818649758528189_dp, 0.015986251841427174_dp, &
             0.021499578975118144_dp, 0.028936632844159926_dp, 0.03904081582912841_dp, &
             0.05276384156990716_dp, 0.07133734501495034_dp, 0.09637343934591731_dp, &
             0.12999476767136203_dp, 0.17500140425029448_dp, 0.23508969587799808_dp, &
             0.31514794383224387_dp, 0.42167211672068877_dp, 0.5633847121589651_dp, &
             0.7522324969102645_dp, 1.0051667327810028_dp, 1.347718400914871_dp, &
             1.8222228967949816_dp, 2.5102890093994676_dp, 3.6125290036140374_dp, &
             5.922063719269106_dp]

      CASE (721)

         aw(:) = & ! a
            [0.0004417080509811216_dp, 0.0023568550576626873_dp, 0.005928750741980419_dp, &
             0.011399959195168034_dp, 0.019179858286514417_dp, 0.029917869648884148_dp, &
             0.04460177540868037_dp, 0.06467657455632461_dp, 0.0921844276675197_dp, &
             0.12994111778154407_dp, 0.1817749780205105_dp, 0.2528553526857663_dp, &
             0.35013801637260483_dp, 0.4829612992348114_dp, 0.663839589671581_dp, &
             0.9095210876064569_dp, 1.2424093852661684_dp, 1.6925076615145789_dp, &
             2.3001639500572266_dp, 3.1201617914958137_dp, 4.228345829166758_dp, &
             5.733708343533177_dp, 7.80427923143218_dp, 10.736615909318328_dp, &
             15.231332635232285_dp, &
             ! w
             0.001136880339581742_dp, 0.002714170371144598_dp, 0.004469230300280583_dp, &
             0.006540200735350515_dp, 0.00912617932193502_dp, 0.012512488697308382_dp, &
             0.017093863177163406_dp, 0.02339322113866336_dp, 0.03208786436364899_dp, &
             0.044058159386898936_dp, 0.060463772641010945_dp, 0.08284644560289782_dp, &
             0.11326219989230159_dp, 0.1544526957921216_dp, 0.2100719158630194_dp, &
             0.2849932222053517_dp, 0.3857393193911573_dp, 0.5211162173285876_dp, &
             0.7032224241921012_dp, 0.9492284420468897_dp, 1.2849241319990852_dp, &
             1.7528605803247912_dp, 2.4346096953010528_dp, 3.529847802726062_dp, &
             5.82619538482212_dp]

      CASE (722)

         aw(:) = & ! a
            [0.0003262535595199603_dp, 0.0017434199537284323_dp, 0.004398099842318326_dp, &
             0.008494298409170108_dp, 0.014381655852945128_dp, 0.022622793807727856_dp, &
             0.03408218435149266_dp, 0.050032524995280984_dp, 0.07228323247045655_dp, &
             0.1033499551626597_dp, 0.1466902323003018_dp, 0.2070299965141243_dp, &
             0.2908080924552534_dp, 0.406774672911357_dp, 0.5667934798265516_dp, &
             0.7869187233713909_dp, 1.0888500069802247_dp, 1.5019270616584413_dp, &
             2.0659428465931056_dp, 2.8353129484242574_dp, 3.8857721810642007_dp, &
             5.326483675070013_dp, 7.325816120062528_dp, 10.18034555502146_dp, &
             14.588305981135823_dp, &
             ! w
             0.0008400077217026571_dp, 0.0020114539866088552_dp, 0.0033311567594055294_dp, &
             0.004918390568617975_dp, 0.006948597149564836_dp, 0.009675992360220152_dp, &
             0.013452813534252008_dp, 0.01874667507622429_dp, 0.02617014374857054_dp, &
             0.0365341784293806_dp, 0.05092670607027173_dp, 0.07081610661771791_dp, &
             0.09818523679512947_dp, 0.13570750377963123_dp, 0.18698192797385246_dp, &
             0.2568525291351039_dp, 0.3518542662263154_dp, 0.48086496152888847_dp, &
             0.656130073792686_dp, 0.8950464506676085_dp, 1.2236864381239394_dp, &
             1.6848592606126291_dp, 2.3601606496817835_dp, 3.448414412325281_dp, &
             5.731928513162785_dp]

      CASE (723)

         aw(:) = & ! a
            [0.000180504034187792_dp, 0.0009677909232647818_dp, 0.002457067830655028_dp, &
             0.004793386594545536_dp, 0.008233109949766969_dp, 0.013199466782144407_dp, &
             0.020353344898168105_dp, 0.030678758517746343_dp, 0.045594545452208084_dp, &
             0.0671126972368621_dp, 0.09806431502621629_dp, 0.1424154516907746_dp, &
             0.20570194812171275_dp, 0.2956238088012079_dp, 0.4228553011226151_dp, &
             0.6021489503388819_dp, 0.8538453320227214_dp, 1.205958439293759_dp, &
             1.6971190764874222_dp, 2.380906744587034_dp, 3.3327097985491454_dp, &
             4.661924210433044_dp, 6.537583830945129_dp, 9.256546322555412_dp, &
             13.513357840422676_dp, &
             ! w
             0.0004650985558755235_dp, 0.001121199495154307_dp, 0.0018809030351167075_dp, &
             0.002833526802666685_dp, 0.004115270502048328_dp, 0.005926196770047863_dp, &
             0.008543753564650484_dp, 0.012340956696035143_dp, 0.01782223348030816_dp, &
             0.02568072389205102_dp, 0.03687636827959418_dp, 0.05273877038388262_dp, &
             0.0751042367877035_dp, 0.10650038716651011_dp, 0.15039657389883376_dp, &
             0.2115466914021172_dp, 0.29646715921927974_dp, 0.4141277064806729_dp, &
             0.5770147946970628_dp, 0.8029372794911709_dp, 1.118523719568458_dp, &
             1.5671495268263922_dp, 2.2306121771715315_dp, 3.306436300834295_dp, &
             5.567937308843291_dp]

      CASE (724)

         aw(:) = & ! a
            [0.00012748242557475265_dp, 0.0006850527494782257_dp, 0.0017468339770502412_dp, &
             0.003431466926960379_dp, 0.0059524621630289605_dp, 0.009666989141616962_dp, &
             0.015137072366623847_dp, 0.023205423454124772_dp, 0.03509977712727163_dp, &
             0.05258469302395082_dp, 0.07817965599693827_dp, 0.11546571121454734_dp, &
             0.16951138907591248_dp, 0.2474609338166582_dp, 0.3593442669486373_dp, &
             0.5191911379339048_dp, 0.7465667188905931_dp, 1.068704231242412_dp, &
             1.5235213888504655_dp, 2.164049766002809_dp, 3.0654021846471866_dp, &
             4.337047808735618_dp, 6.148396389496952_dp, 8.7965806917738_dp, &
             12.97446814102286_dp, &
             ! w
             0.0003286476870063008_dp, 0.0007958627181726459_dp, 0.0013469131692074481_dp, &
             0.0020571136160102803_dp, 0.0030433861619813497_dp, 0.004478112460201092_dp, &
             0.0066008146679634614_dp, 0.009738022407722997_dp, 0.014341194024062346_dp, &
             0.021043513267904906_dp, 0.030736255679443006_dp, 0.044670945053259144_dp, &
             0.06459781068431443_dp, 0.09295463409942827_dp, 0.13312513044835475_dp, &
             0.18979456872590492_dp, 0.2694463340509089_dp, 0.3810768384968753_dp, &
             0.5372855064162958_dp, 0.7561005957214038_dp, 1.0644716593771493_dp, &
             1.506131941775474_dp, 2.1630745122045925_dp, 3.2322525293459914_dp, &
             5.4824309616088165_dp]

      CASE (725)

         aw(:) = & ! a
            [9.955390749628301e-05_dp, 0.0005359138839270567_dp, 0.0013712169422480686_dp, &
             0.0027083199385988_dp, 0.004734686293982663_dp, 0.007766568196366141_dp, &
             0.012304068333119863_dp, 0.019101261186273897_dp, 0.029265946400809005_dp, &
             0.044406537963453376_dp, 0.06684386833669606_dp, 0.09991049648239901_dp, &
             0.1483693879065867_dp, 0.218996526744258_dp, 0.32138902710012773_dp, &
             0.4690841703677293_dp, 0.6811105307080174_dp, 0.9841512807395667_dp, &
             1.4156103270278033_dp, 2.0281107035520822_dp, 2.896541558358517_dp, &
             4.130396263161919_dp, 5.8993400355237124_dp, 8.500736158455918_dp, &
             12.626440449344825_dp, &
             ! w
             0.00025675042802745477_dp, 0.000623956515071796_dp, 0.0010632771032706336_dp, &
             0.0016414252161794363_dp, 0.0024631061065698897_dp, 0.003682879416989593_dp, &
             0.005516179860252556_dp, 0.008260430709806157_dp, 0.01233353074178115_dp, &
             0.01832954402112065_dp, 0.027093669693146402_dp, 0.039823847996241696_dp, &
             0.05820999607973761_dp, 0.08462543028283542_dp, 0.12239034301438824_dp, &
             0.17613596669689047_dp, 0.2523139947275561_dp, 0.35992885090826865_dp, &
             0.5116477957889787_dp, 0.7256438403125711_dp, 1.0290892961832774_dp, &
             1.4659783509963051_dp, 2.1184706996036184_dp, 3.1831868209091585_dp, &
             5.425942401291094_dp]

      CASE (726)

         aw(:) = & ! a
            [8.215807403170786e-05_dp, 0.000442916595190489_dp, 0.001136510726862081_dp, &
             0.0022550228849497565_dp, 0.003967903510412303_dp, 0.006562734133348864_dp, &
             0.010495962956598773_dp, 0.016459162257057024_dp, 0.025475446392116217_dp, &
             0.03904237926444667_dp, 0.059338613769440315_dp, 0.08951722749355775_dp, &
             0.13411840461361346_dp, 0.1996471072194891_dp, 0.2953788694181808_dp, &
             0.434481401989287_dp, 0.6355762302772984_dp, 0.9249241228448893_dp, &
             1.3395283561287001_dp, 1.9316861809734545_dp, 2.7760989845340425_dp, &
             3.9822636487988174_dp, 5.720035712729033_dp, 8.286973026241188_dp, &
             12.374237998029473_dp, &
             ! w
             0.0002119563365174039_dp, 0.0005166159869332959_dp, 0.0008854373156153062_dp, &
             0.0013791388260692866_dp, 0.0020937195766920504_dp, 0.0031709519917747994_dp, &
             0.004809199260521118_dp, 0.007285375173981507_dp, 0.010993396355784456_dp, &
             0.016498765841585675_dp, 0.024612445032308566_dp, 0.0364919995762332_dp, &
             0.053781289501141485_dp, 0.07880363228033524_dp, 0.11482890342125626_dp, &
             0.16644398360248885_dp, 0.2400718981074724_dp, 0.34471756529244935_dp, &
             0.4930940621929616_dp, 0.7034801866821311_dp, 1.003217276757435_dp, &
             1.436504337343956_dp, 2.0856438400662087_dp, 3.147035856880362_dp, &
             5.384355430178487_dp]

      CASE (727)

         aw(:) = & ! a
            [7.021686258873252e-05_dp, 0.0003790200863573012_dp, 0.0009749682115072822_dp, &
             0.0019421944995459464_dp, 0.003436718189804632_dp, 0.005724532076937601_dp, &
             0.009229092137382197_dp, 0.01459473604792678_dp, 0.022780464801540973_dp, &
             0.03519950199269977_dp, 0.0539215934422907_dp, 0.08196134134582536_dp, &
             0.12368579889839859_dp, 0.1853877831707111_dp, 0.2760892627216751_dp, &
             0.40866432004628184_dp, 0.6014084191549361_dp, 0.880240819769707_dp, &
             1.2818371864757045_dp, 1.8582239487895156_dp, 2.6839407484972315_dp, &
             3.868477812270853_dp, 5.581840581871271_dp, 8.121754189657269_dp, &
             12.17886862474053_dp, &
             ! w
             0.0001812012633421688_dp, 0.0004427802336149792_dp, 0.0007626824708471096_dp, &
             0.0011971290226881104_dp, 0.001835475089161348_dp, 0.002809710643856534_dp, &
             0.00430527166119313_dp, 0.006583561761706038_dp, 0.010020115577166918_dp, &
             0.015158188785670825_dp, 0.02278174339558203_dp, 0.03401618988560197_dp, &
             0.050468346925082015_dp, 0.0744208606308063_dp, 0.10910205213131634_dp, &
             0.15906126553322625_dp, 0.23069575478300078_dp, 0.33300740031422793_dp, &
             0.4787424522310096_dp, 0.6862618646184032_dp, 0.9830422725672653_dp, &
             1.4134508792715863_dp, 2.0599144949988957_dp, 3.118675692803574_dp, &
             5.351750118071792_dp]

      CASE (728)

         aw(:) = & ! a
            [6.148028464317523e-05_dp, 0.00033223361925589014_dp, 0.0008565041655540711_dp, &
             0.0017122522792201729_dp, 0.003044973414624125_dp, 0.005103615118848573_dp, &
             0.008285524083416975_dp, 0.01319765852571231_dp, 0.02074818140075173_dp, &
             0.032283136854842416_dp, 0.049785028325928925_dp, 0.07615686947469912_dp, &
             0.11562537536868181_dp, 0.17431039435158174_dp, 0.26102593262051577_dp, &
             0.38840377671798154_dp, 0.5744685620188198_dp, 0.844853786959293_dp, &
             1.2359585054786772_dp, 1.7995775399889744_dp, 2.6101084615600976_dp, &
             3.7770294393517774_dp, 5.470468492797603_dp, 7.98829702894451_dp, &
             12.020767113719403_dp, &
             ! w
             0.00015869568265594475_dp, 0.0003886624475751539_dp, 0.0006724378555591735_dp, &
             0.0010627006799714058_dp, 0.001643502496417106_dp, 0.002539022751823654_dp, &
             0.003924461747988385_dp, 0.006048927640241453_dp, 0.009273204159843512_dp, &
             0.014122468734473325_dp, 0.021358540255837232_dp, 0.03208025681664322_dp, &
             0.04786359147467303_dp, 0.07095701916061443_dp, 0.10455353819661095_dp, &
             0.1531699951474543_dp, 0.22318037347626207_dp, 0.3235817256226352_dp, &
             0.46714546010899227_dp, 0.6722989795002908_dp, 0.9666311605954334_dp, &
             1.3946516333613748_dp, 2.0388971282442068_dp, 3.095491916157144_dp, &
             5.325108518389744_dp]

      CASE (729)

         aw(:) = & ! a
            [5.479313180147018e-05_dp, 0.00029639667003451424_dp, 0.000765642361268275_dp, &
             0.0015355194375918956_dp, 0.0027429825108886735_dp, 0.004623060530367564_dp, &
             0.007551747850685785_dp, 0.012105431466630439_dp, 0.019150609287267164_dp, &
             0.02997804151925011_dp, 0.04649808399619563_dp, 0.07152100484783801_dp, &
             0.10915630129096324_dp, 0.16537864168032657_dp, 0.2488266191663795_dp, &
             0.37192660408869965_dp, 0.5524723719439752_dp, 0.8158523396706655_dp, &
             1.1982265657121662_dp, 1.7511876687098333_dp, 2.549006543630126_dp, &
             3.7011463253498205_dp, 5.37783801889113_dp, 7.877082757123006_dp, &
             11.888812505829732_dp, &
             ! w
             0.00014146662501784236_dp, 0.0003471734807843872_dp, 0.0006030668066653917_dp, &
             0.000958937532686493_dp, 0.0014944660094504613_dp, 0.0023274014491732964_dp, &
             0.0036245741707887974_dp, 0.005625011498626868_dp, 0.008677270896814525_dp, &
             0.013291393984229799_dp, 0.020210525195289996_dp, 0.03051095506798608_dp, &
             0.045742318511552436_dp, 0.06812369995285124_dp, 0.10081742950258604_dp, &
             0.1483117280118188_dp, 0.2169594244414413_dp, 0.3157518120202655_dp, &
             0.45748002004462734_dp, 0.6606267834863961_dp, 0.9528765192769223_dp, &
             1.3788621749647323_dp, 2.021218892451167_dp, 3.0759788788493503_dp, &
             5.302693748973033_dp]

      CASE (730)

         aw(:) = & ! a
            [4.9499305956758506e-05_dp, 0.00026800832441533794_dp, 0.0006935783426909829_dp, &
             0.001395084929017318_dp, 0.002502366702353727_dp, 0.004238797545465045_dp, &
             0.00696247384781783_dp, 0.011224152795523258_dp, 0.017855328690749968_dp, &
             0.02810014301069517_dp, 0.043807849872026156_dp, 0.0677098299052879_dp, &
             0.10381545286687396_dp, 0.157974853630235_dp, 0.23867552253285154_dp, &
             0.35816611016937044_dp, 0.5340397295755684_dp, 0.7914706652789757_dp, &
             1.1664088503127215_dp, 1.710267569806086_dp, 2.497203415964356_dp, &
             3.6366628444969025_dp, 5.298965176412673_dp, 7.782227946821637_dp, &
             11.776118747184311_dp, &
             ! w
             0.00012782536954313628_dp, 0.0003142817856536682_dp, 0.0005479372478421675_dp, &
             0.0008761669299397903_dp, 0.0013749613804741672_dp, 0.002156652108508143_dp, &
             0.003381055960707149_dp, 0.0052787238950210025_dp, 0.008187833155272854_dp, &
             0.012605467966736391_dp, 0.019258690631970676_dp, 0.029204274503283847_dp, &
             0.04396893519473523_dp, 0.06574602482814026_dp, 0.09767081131996845_dp, &
             0.14420595561955962_dp, 0.2116849238731724_dp, 0.30909277838655835_dp, &
             0.4492364929938319_dp, 0.650645899027967_dp, 0.9410883282520589_dp, &
             1.3653053208077086_dp, 2.006021060190052_dp, 3.0591941971640715_dp, &
             5.283419302910287_dp]

      CASE (731)

         aw(:) = & ! a
            [4.519762499227449e-05_dp, 0.00024492676244518096_dp, 0.000634920373209974_dp, &
             0.0012805772860692618_dp, 0.0023056852387015048_dp, 0.003923665897377026_dp, &
             0.006477322234611608_dp, 0.010495505480897805_dp, 0.01677973026454833_dp, &
             0.02653407379121565_dp, 0.041555077867808786_dp, 0.0645058070978417_dp, &
             0.09930859853038251_dp, 0.15170494294108228_dp, 0.23005002124932783_dp, &
             0.3464362769980205_dp, 0.5182797372274011_dp, 0.770564860926563_dp, &
             1.1390542991010253_dp, 1.6750003018694268_dp, 2.452455323014001_dp, &
             3.5808482696575616_dp, 5.230575427684372_dp, 7.699859800511608_dp, &
             11.678146110650195_dp, &
             ! w
             0.00011673919420422583_dp, 0.000287519310039334_dp, 0.0005029812091582358_dp, &
             0.0008084384255100748_dp, 0.0012767086380551036_dp, 0.0020154753965507134_dp, &
             0.0031785651431472544_dp, 0.004989260348386967_dp, 0.00777676022864231_dp, &
             0.012026863707474748_dp, 0.018452556050915593_dp, 0.028093451708589783_dp, &
             0.04245602410857346_dp, 0.06371077890544444_dp, 0.09496879577587958_dp, &
             0.14066966253479712_dp, 0.2071290100905957_dp, 0.30332545733815075_dp, &
             0.44207895382865575_dp, 0.6419601085917797_dp, 0.9308093097081083_dp, &
             1.3534650043970295_dp, 1.9927326529385034_dp, 3.0445109282514466_dp, &
             5.266562685130558_dp]

      CASE (732)

         aw(:) = & ! a
            [2.4843321760964006e-05_dp, 0.00013548385572651294_dp, 0.00035569059580520745_dp, &
             0.0007321049569446866_dp, 0.0013551882864955888_dp, 0.0023828939807497523_dp, &
             0.004072700686233339_dp, 0.0068309675524773_dp, 0.011290106484141487_dp, &
             0.018425398262852583_dp, 0.029728381433891584_dp, 0.047461715976099966_dp, &
             0.07503122259746353_dp, 0.11752563959530793_dp, 0.1824953326208795_dp, &
             0.2810704130352564_dp, 0.4295611232659895_dp, 0.6517486848432811_dp, &
             0.9821872250775617_dp, 1.471064207098613_dp, 2.1917112831592482_dp, &
             3.253385663308098_dp, 4.826940950169208_dp, 7.211313348103594_dp, &
             11.094765630954075_dp, &
             ! w
             6.425761918826272e-05_dp, 0.00016029834414485488_dp, 0.0002875858720772758_dp, &
             0.00047992902442626774_dp, 0.0007920547073873528_dp, 0.0013054715655174355_dp, &
             0.0021406084460843574_dp, 0.0034794196973347512_dp, 0.005598573393288146_dp, &
             0.008916435620917037_dp, 0.014060558132806392_dp, 0.02196491813436451_dp, &
             0.034009473911800654_dp, 0.05221945092222558_dp, 0.07954876007125977_dp, &
             0.12028231922495505_dp, 0.1806088079166697_dp, 0.26944662692061266_dp, &
             0.39967509169074217_dp, 0.5901020972670652_dp, 0.8690208340474251_dp, &
             1.2818969352624743_dp, 1.9121002156255709_dp, 2.9552571833698327_dp, &
             5.164190413529473_dp]

      CASE (733)

         aw(:) = & ! a
            [1.1264255419591642e-05_dp, 6.209747765944256e-05_dp, 0.00016662427381156723_dp, &
             0.0003549575704893148_dp, 0.0006869798909584008_dp, 0.0012689773472266972_dp, &
             0.002278893846679679_dp, 0.004007665131127903_dp, 0.006924733464710715_dp, &
             0.011778984949636095_dp, 0.019752171049436267_dp, 0.03268998821484311_dp, &
             0.05344731770236428_dp, 0.0864001366970387_dp, 0.13819927492725134_dp, &
             0.21887340544380418_dp, 0.34343521255423776_dp, 0.5342149781239465_dp, &
             0.8242623270666383_dp, 1.2623822438794168_dp, 1.9208992263493259_dp, &
             2.9087230063930716_dp, 4.3971823059618655_dp, 6.686159196138108_dp, &
             10.462955777325103_dp, &
             ! w
             2.920455382460861e-05_dp, 7.445663532265556e-05_dp, 0.00013940490970779088_dp, &
             0.000246977148074537_dp, 0.00043438011979209844_dp, 0.0007586007724358414_dp, &
             0.0013086554502651927_dp, 0.0022254850183210024_dp, 0.0037309676582622645_dp, &
             0.006170727647565829_dp, 0.010077629077303293_dp, 0.016265462257876492_dp, &
             0.02596621390714508_dp, 0.041029870377742375_dp, 0.06421359995014883_dp, &
             0.09959865728823639_dp, 0.1531912267289187_dp, 0.23379495604406195_dp, &
             0.3543096555544806_dp, 0.5337804796639635_dp, 0.8010208436801388_dp, &
             1.2022786064563087_dp, 1.8217110566480992_dp, 2.854845724237211_dp, &
             5.0492026348538435_dp]

      CASE (734)

         aw(:) = & ! a
            [6.199943375647319e-06_dp, 3.4546040998317437e-05_dp, 9.47282552509405e-05_dp, &
             0.00020855662035306_dp, 0.00042002157026893344_dp, 0.0008084350623379755_dp, &
             0.0015100310249675942_dp, 0.002754020247234398_dp, 0.004920347655474828_dp, &
             0.00863020980732986_dp, 0.014886201713503853_dp, 0.02528713981625875_dp, &
             0.042354308956978254_dp, 0.07002265281685803_dp, 0.1143744006234503_dp, &
             0.18472691356373172_dp, 0.29523612394053766_dp, 0.4672511645069706_dp, &
             0.7327761804620658_dp, 1.1396215489399737_dp, 1.7593452868711055_dp, &
             2.700532870414355_dp, 4.134781931896993_dp, 6.362656872099852_dp, &
             10.071059348264148_dp, &
             ! w
             1.6111804268762397e-05_dp, 4.196739261169908e-05_dp, 8.187596326793673e-05_dp, &
             0.00015290724980524182_dp, 0.0002828950741753467_dp, 0.0005160526712214646_dp, &
             0.000924404125599723_dp, 0.0016254291085378556_dp, 0.0028084809469429_dp, &
             0.004774847665721209_dp, 0.007998292739743871_dp, 0.013215791628827338_dp, &
             0.021562403825986034_dp, 0.03477023312980401_dp, 0.05545997676611259_dp, &
             0.08756593983229598_dp, 0.13695426666173635_dp, 0.2123263245374691_dp, &
             0.3265648551837351_dp, 0.4988446579906151_dp, 0.7583130721280241_dp, &
             1.151760343195254_dp, 1.7639393660613107_dp, 2.7904427623104366_dp, &
             4.975546041382247_dp]

      CASE (735)

         aw(:) = & ! a
            [3.4196571099608765e-06_dp, 1.9317302510179668e-05_dp, 5.445369716840836e-05_dp, &
             0.00012475344197668988_dp, 0.000262734115419447_dp, 0.0005282417074206697_dp, &
             0.0010270920854476512_dp, 0.0019425136588267248_dp, 0.003586237275142373_dp, &
             0.00648003763457304_dp, 0.011484245398160816_dp, 0.01999800366146877_dp, &
             0.034268057646653756_dp, 0.05786028096787109_dp, 0.09637325777616398_dp, &
             0.1585094055170075_dp, 0.25767155812951503_dp, 0.41433102524223286_dp, &
             0.6595377813431746_dp, 1.0401717421626346_dp, 1.6270460558522717_dp, &
             2.528392873063054_dp, 3.9160111572814453_dp, 6.091099892632757_dp, &
             9.740355969773836_dp, &
             ! w
             8.912885151808805e-06_dp, 2.3860262170370725e-05_dp, 4.895236482292354e-05_dp, &
             9.689967627691996e-05_dp, 0.00018873577688507327_dp, 0.0003594069343782077_dp, &
             0.0006680055012211502_dp, 0.0012134721038989397_dp, 0.0021588532320399546_dp, &
             0.0037688838189787396_dp, 0.006467701799409704_dp, 0.010926598083724216_dp, &
             0.018196197876542582_dp, 0.02990388435521927_dp, 0.04854643172153566_dp, &
             0.07792104974793211_dp, 0.12375797387870123_dp, 0.19465080643623195_dp, &
             0.30344605212452697_dp, 0.469412888467795_dp, 0.7219838904242313_dp, &
             1.108442261642557_dp, 1.714115857034585_dp, 2.7347424409424503_dp, &
             4.91189896583111_dp]

      CASE (736)

         aw(:) = & ! a
            [1.565215043869209e-06_dp, 9.064118577487203e-06_dp, 2.6820097046204684e-05_dp, &
             6.54917636237459e-05_dp, 0.00014724624144701632_dp, 0.000314336088855382_dp, &
             0.0006445459518849094_dp, 0.0012776079741076665_dp, 0.0024591013270511912_dp, &
             0.004612186745379088_dp, 0.008453144388013931_dp, 0.01517502237720394_dp, &
             0.026736032851169943_dp, 0.04630742523338557_dp, 0.07896194439723125_dp, &
             0.13272229581434794_dp, 0.22014485727579744_dp, 0.360696787605786_dp, &
             0.5843150352946623_dp, 0.9367679737971693_dp, 1.487946929523944_dp, &
             2.345603815090952_dp, 3.681718599945985_dp, 5.798239875445144_dp, &
             9.381796113013031_dp, &
             ! w
             4.101112570124687e-06_dp, 1.1529361186157911e-05_dp, 2.5681643827430185e-05_dp, &
             5.522119889632262e-05_dp, 0.00011508128698872398_dp, 0.0002316373352874172_dp, &
             0.0004513633812348636_dp, 0.000854531910453043_dp, 0.001577112280826013_dp, &
             0.002845462769165114_dp, 0.00503061436727277_dp, 0.00873223424771311_dp, &
             0.014907131604148268_dp, 0.02506404331452572_dp, 0.04155631506896698_dp, &
             0.06801838977907979_dp, 0.11001333434185726_dp, 0.17599307687390944_dp, &
             0.27873835614392195_dp, 0.437600510760203_dp, 0.6823212732034437_dp, &
             1.0607552093108712_dp, 1.658936184008103_dp, 2.6728673613641423_dp, &
             4.841253907411157_dp]

      CASE (737)

         aw(:) = & ! a
            [8.713697777228801e-07_dp, 5.180339365844703e-06_dp, 1.608208485260699e-05_dp, &
             4.1549376214282944e-05_dp, 9.847676556022646e-05_dp, 0.00022007585250690613_dp, &
             0.00046936041944032844_dp, 0.0009625283024460607_dp, 0.001908510357182973_dp, &
             0.003674669429975828_dp, 0.0068942001898652915_dp, 0.01263915773096621_dp, &
             0.02269554288139395_dp, 0.03999536534874257_dp, 0.0692877658323846_dp, &
             0.11817097085610004_dp, 0.1986649094461807_dp, 0.3295905350452975_dp, &
             0.5401564033072582_dp, 0.8753887012448163_dp, 1.4045452560527425_dp, &
             2.235024265184526_dp, 3.5388922053039833_dp, 5.618591524728985_dp, &
             9.160795815577712_dp, &
             ! w
             2.295859306466071e-06_dp, 6.787921332668822e-06_dp, 1.628370937713575e-05_dp, &
             3.734919457310432e-05_dp, 8.182464937546473e-05_dp, 0.00017150062274318687_dp, &
             0.00034579871317058034_dp, 0.0006742998163093093_dp, 0.0012771568116403166_dp, &
             0.0023578943800193616_dp, 0.004255385640779721_dp, 0.007525185781024726_dp, &
             0.013065350328789586_dp, 0.022309036385143068_dp, 0.03751654143470807_dp, &
             0.06221445436658023_dp, 0.10185190224664521_dp, 0.16477939833589778_dp, &
             0.26372153712762997_dp, 0.41806749638128915_dp, 0.6577474812725869_dp, &
             1.0309872197173404_dp, 1.624302170941023_dp, 2.6339224676647457_dp, &
             4.796818296375671_dp]

      CASE (738)

         aw(:) = & ! a
            [4.883241996554254e-07_dp, 3.0088259189500505e-06_dp, 9.912782840669955e-06_dp, &
             2.7255308553705595e-05_dp, 6.818239858452662e-05_dp, 0.00015938602642772903_dp, &
             0.0003529842589666131_dp, 0.0007474503545214432_dp, 0.0015236095434014677_dp, &
             0.0030053388936021335_dp, 0.005760131050612457_dp, 0.010763076516090155_dp, &
             0.019660443729506462_dp, 0.035187848837047085_dp, 0.06182581634012212_dp, &
             0.10681639895365452_dp, 0.18172453204217945_dp, 0.3048169670462201_dp, &
             0.504669992471773_dp, 0.825656303591553_dp, 1.3364646854441895_dp, &
             2.1441610304547405_dp, 3.420866033318728_dp, 5.469451883364541_dp, &
             8.97668473307791_dp, &
             ! w
             1.2965326194500702e-06_dp, 4.094893563823615e-06_dp, 1.0671835210228798e-05_dp, &
             2.610140425245674e-05_dp, 6.0011742804439186e-05_dp, 0.0001307469077612145_dp, &
             0.0002722840208901892_dp, 0.0005458090319333597_dp, 0.0010588672406050298_dp, &
             0.0019965242746077944_dp, 0.0036713095709842744_dp, 0.006602182035206125_dp, &
             0.011637849501482691_dp, 0.020147197451855975_dp, 0.034310355575618234_dp, &
             0.05755959492334501_dp, 0.09524246641781352_dp, 0.1556161641446703_dp, &
             0.2513484158600284_dp, 0.4018511702505057_dp, 0.6372092532083357_dp, &
             1.0059684723607225_dp, 1.595074405573704_dp, 2.6009872518894688_dp, &
             4.759256271268356_dp]

      CASE (739)

         aw(:) = & ! a
            [2.3042764731077874e-07_dp, 1.5207981128567643e-06_dp, 5.519939135940997e-06_dp, &
             1.656990649286297e-05_dp, 4.447512403910891e-05_dp, 0.00010998837641112904_dp, &
             0.00025505329787449795_dp, 0.0005612363368639505_dp, 0.0011820570597910107_dp, &
             0.0023984522841291726_dp, 0.004712080960225412_dp, 0.008999570487557137_dp, &
             0.01676354114391053_dp, 0.03053537746215978_dp, 0.05451320443713787_dp, &
             0.09556065883308584_dp, 0.16475419989132453_dp, 0.27975919838802754_dp, &
             0.4684578970304113_dp, 0.7744959039132902_dp, 1.2659170149411658_dp, &
             2.049395210405526_dp, 3.2970879168615475_dp, 5.312339306259277_dp, &
             8.782071149061263_dp, &
             ! w
             6.213641483196901e-07_dp, 2.2078986035867742e-06_dp, 6.471823739924832e-06_dp, &
             1.7175112070393368e-05_dp, 4.193130995889504e-05_dp, 9.579170687508408e-05_dp, &
             0.0002074149436250891_dp, 0.00042964721493660304_dp, 0.0008573152755713464_dp, &
             0.0016565970771438379_dp, 0.003112708358217391_dp, 0.0057061879880921425_dp, &
             0.010233309135432661_dp, 0.017993840335993303_dp, 0.031080613444186164_dp, &
             0.05282174345081988_dp, 0.08845060655332937_dp, 0.14611652685413618_dp, &
             0.23841631374346434_dp, 0.38477621909678056_dp, 0.6154410588823396_dp, &
             0.9793054213913431_dp, 1.5637996067067725_dp, 2.5656710256056474_dp, &
             4.718994713588816_dp]

      CASE (740)

         aw(:) = & ! a
            [1.327175541448639e-07_dp, 9.438178623818151e-07_dp, 3.7301080641544722e-06_dp, &
             1.197175820749871e-05_dp, 3.378435404421081e-05_dp, 8.68440254762962e-05_dp, &
             0.00020770178727482063_dp, 0.0004687908408362699_dp, 0.0010086367977198087_dp, &
             0.0020842561167125134_dp, 0.004160160557644024_dp, 0.008056769636071534_dp, &
             0.01519382393948342_dp, 0.027983703321766397_dp, 0.050458440198246905_dp, &
             0.08925710773010012_dp, 0.15516372659811797_dp, 0.2654803964351467_dp, &
             0.4476660762195086_dp, 0.7449179872238292_dp, 1.2248761465465403_dp, &
             1.993961517107183_dp, 3.2243420305535375_dp, 5.219649489119213_dp, &
             8.666927126017093_dp, &
             ! w
             3.645758498225645e-07_dp, 1.454069433897389e-06_dp, 4.66052516524013e-06_dp, &
             1.3097561078829885e-05_dp, 3.3325986685701564e-05_dp, 7.861436387739844e-05_dp, &
             0.00017469049517061734_dp, 0.0003697350960989417_dp, 0.0007513620746125136_dp, &
             0.0014749038726824797_dp, 0.0028097117261707597_dp, 0.0052137686462714284_dp, &
             0.009452246750517389_dp, 0.016783501875886783_dp, 0.02924751145081051_dp, &
             0.050108598529512466_dp, 0.08452920684627144_dp, 0.14059016891056764_dp, &
             0.23084075335332718_dp, 0.37471046698337523_dp, 0.6025366401491944_dp, &
             0.9634251258767191_dp, 1.5451081737746009_dp, 2.544525914054537_dp, &
             4.694896120185015_dp]

      CASE (741)

         aw(:) = & ! a
            [4.1509507648568625e-08_dp, 3.8501017045618464e-07_dp, 1.8678724835605602e-06_dp, &
             6.8613519035536315e-06_dp, 2.127095396634838e-05_dp, 5.8629353909852336e-05_dp, &
             0.00014805297972904282_dp, 0.0003491373183998186_dp, 0.0007789802444679077_dp, &
             0.0016599148385480068_dp, 0.0034018933783145945_dp, 0.0067418179869114464_dp, &
             0.012974971447907857_dp, 0.02433327153442646_dp, 0.04459456058838998_dp, &
             0.08005120791908409_dp, 0.14103184034857943_dp, 0.24426791323596783_dp, &
             0.4165472811611236_dp, 0.700348640949321_dp, 1.162655680069885_dp, &
             1.9094662990912807_dp, 3.11294620678584_dp, 5.077182331380454_dp, &
             8.489450123985996_dp, &
             ! w
             1.239582798927541e-07_dp, 6.889331943778639e-07_dp, 2.6408328220497027e-06_dp, &
             8.266195091035281e-06_dp, 2.2682853714550032e-05_dp, 5.6650293373146646e-05_dp, &
             0.00013169882542383215_dp, 0.0002892226580402232_dp, 0.0006061969872000422_dp, &
             0.0012217565087766166_dp, 0.002381286869805621_dp, 0.004508333443322077_dp, &
             0.00832010210383892_dp, 0.015010444247232127_dp, 0.026536175130160315_dp, &
             0.04606013237485493_dp, 0.07863038746762252_dp, 0.13221510835886743_dp, &
             0.21928163450349258_dp, 0.359256163334978_dp, 0.5826147213623573_dp, &
             0.9387956211657306_dp, 1.5160194854873386_dp, 2.5115590322397567_dp, &
             4.657334992677762_dp]

      CASE (742)

         aw(:) = & ! a
            [2.8443374693489808e-08_dp, 3.002519531842274e-07_dp, 1.5592635600572266e-06_dp, &
             5.955543062267902e-06_dp, 1.8942955744544263e-05_dp, 5.318603868181537e-05_dp, &
             0.0001362130896252716_dp, 0.0003248334613956672_dp, 0.0007314317060541503_dp, &
             0.0015706224811796632_dp, 0.003240091265248646_dp, 0.006457789778995354_dp, &
             0.012490525532144055_dp, 0.02352861183379133_dp, 0.04329087110861864_dp, &
             0.07798862644950662_dp, 0.13784334847258925_dp, 0.23945132580692272_dp, &
             0.4094403348998895_dp, 0.6901163096126491_dp, 1.148303457122562_dp, &
             1.8898947731718565_dp, 3.087051968101036_dp, 5.0439703017080895_dp, &
             8.447987625269661_dp, &
             ! w
             8.935397327863303e-08_dp, 5.652103855965392e-07_dp, 2.2817025333755027e-06_dp, &
             7.358663604454459e-06_dp, 2.0606239145207474e-05_dp, 5.2239370765696735e-05_dp, &
             0.0001228641628927642_dp, 0.00027236151733490494_dp, 0.0005753077728344892_dp, &
             0.0011671489174657262_dp, 0.0022877637374243954_dp, 0.004352718719159734_dp, &
             0.008068019538090526_dp, 0.014612341341718776_dp, 0.025922782623229175_dp, &
             0.04513791980818469_dp, 0.07727820981652639_dp, 0.13028422360905742_dp, &
             0.2166025820511699_dp, 0.35565715940102066_dp, 0.5779556035652323_dp, &
             0.9330150500328237_dp, 1.5091743379939138_dp, 2.5037903930166054_dp, &
             4.648485512471723_dp]

      CASE (743)

         aw(:) = & ! a
            [2.554579889604458e-08_dp, 2.810294220765616e-07_dp, 1.4873628395563149e-06_dp, &
             5.740681200604643e-06_dp, 1.838386987009761e-05_dp, 5.186681866269023e-05_dp, &
             0.00013332328701137438_dp, 0.0003188677616442055_dp, 0.0007197053941881947_dp, &
             0.0015485139572249372_dp, 0.003199892941004378_dp, 0.006387016060749789_dp, &
             0.012369496823590988_dp, 0.02332711804159323_dp, 0.04296373775101195_dp, &
             0.07747009634664107_dp, 0.13704040753166502_dp, 0.23823652291098327_dp, &
             0.40764536615910757_dp, 0.6875286965581676_dp, 1.1446698405502618_dp, &
             1.8849347747858303_dp, 3.080483974473673_dp, 5.035540331415703_dp, &
             8.437458047722917_dp, &
             ! w
             8.166491643944941e-08_dp, 5.36553041282175e-07_dp, 2.19645287891008e-06_dp, &
             7.140247229758977e-06_dp, 2.0101668784085108e-05_dp, 5.115987742795437e-05_dp, &
             0.00012068969051501977_dp, 0.00026819210586740566_dp, 0.0005676395931593945_dp, &
             0.001153547314942272_dp, 0.0022644014268544885_dp, 0.0043137466160405435_dp, &
             0.008004745060257093_dp, 0.014512211808681529_dp, 0.025768221137273818_dp, &
             0.0449051551032205_dp, 0.07693640317514334_dp, 0.12979544911834126_dp, &
             0.21592355403333233_dp, 0.3547439046991982_dp, 0.5767721283796079_dp, &
             0.9315454465159397_dp, 1.507432974391191_dp, 2.5018134278609336_dp, &
             4.646233602095899_dp]

      CASE (744)

         aw(:) = & ! a
            [0.0006800749873795562_dp, 0.0036180609518548304_dp, 0.009051034040537087_dp, &
             0.017255218557269508_dp, 0.028681546356864825_dp, 0.0440216450314727_dp, &
             0.064298921450207_dp, 0.09098305996381034_dp, 0.12612360081366136_dp, &
             0.17250484994749662_dp, 0.23383687530980404_dp, 0.31500578433073784_dp, &
             0.4224077355675651_dp, 0.5643913046944888_dp, 0.7518375867825707_dp, &
             0.9989185642237394_dp, 1.3240935264429308_dp, 1.7514366936810328_dp, &
             2.3124519410747997_dp, 3.0486587241920478_dp, 4.015515745006521_dp, &
             5.2889233348583575_dp, 6.977334310897264_dp, 9.24803865935702_dp, &
             12.398072495443248_dp, 17.135640902026932_dp, &
             ! w
             0.0017492124137767726_dp, 0.004151428434220628_dp, 0.006759790942916095_dp, &
             0.009722649029950382_dp, 0.013243753829833964_dp, 0.017605088369397736_dp, &
             0.023192187728296527_dp, 0.030515135053755513_dp, 0.04022687334263273_dp, &
             0.05314985672890279_dp, 0.07032303477487614_dp, 0.09307350437086273_dp, &
             0.12311225260130998_dp, 0.16265589937224748_dp, 0.21458226628508223_dp, &
             0.28263445811521504_dp, 0.371698214670462_dp, 0.4881968860169695_dp, &
             0.6406907276970475_dp, 0.8408637117595529_dp, 1.1053148462533489_dp, &
             1.4591894859327104_dp, 1.9445496150321826_dp, 2.6432012332347354_dp, &
             3.7575497780492193_dp, 6.09060522815089_dp]

      CASE (745)

         aw(:) = & ! a
            [0.0005633988017409629_dp, 0.002999507406231127_dp, 0.007513857739307147_dp, &
             0.014354642661966652_dp, 0.023930518590500636_dp, 0.03687395055560716_dp, &
             0.05412818023599751_dp, 0.0770553297202473_dp, 0.10756206451038458_dp, &
             0.14824775993630188_dp, 0.20259227209399158_dp, 0.27520646053315306_dp, &
             0.37216860136055147_dp, 0.5014708154554379_dp, 0.6736057579721793_dp, &
             0.9023357442796528_dp, 1.2057058656117183_dp, 1.6073955838420657_dp, &
             2.138564901528592_dp, 2.840477131471388_dp, 3.7684586586283975_dp, &
             4.998423622481113_dp, 6.638967722626174_dp, 8.85754099227774_dp, &
             11.950981664059256_dp, 16.625396046433927_dp, &
             ! w
             0.001449352926846467_dp, 0.0034447791946423272_dp, 0.005624563401801641_dp, &
             0.008124072237332277_dp, 0.011131632594439013_dp, 0.014910623249740238_dp, &
             0.019822771899184428_dp, 0.026346879498449504_dp, 0.03509674789928704_dp, &
             0.046850497845360384_dp, 0.06260145127849621_dp, 0.08363260096924342_dp, &
             0.11161402044660416_dp, 0.14872650657761394_dp, 0.19782042727834628_dp, &
             0.26262488322047406_dp, 0.34803178637849824_dp, 0.46049847654577_dp, &
             0.6086539564534136_dp, 0.804288896153698_dp, 1.0641411475539202_dp, &
             1.413503320514965_dp, 1.894533795125528_dp, 2.5889391931258023_dp, &
             3.6983716437752316_dp, 6.021770425521848_dp]

      CASE (746)

         aw(:) = & ! a
            [0.000482868650475416_dp, 0.0025723714812009393_dp, 0.006451425203361023_dp, &
             0.012347223026310378_dp, 0.02063653528583523_dp, 0.03190679395449839_dp, &
             0.04703949320634453_dp, 0.0673129250297651_dp, 0.09452160320639286_dp, &
             0.13111951708025688_dp, 0.1804056680544861_dp, 0.24677450069657977_dp, &
             0.3360533672450059_dp, 0.45595110229230046_dp, 0.6166489144395308_dp, &
             0.8315772230424938_dp, 1.118441519134094_dp, 1.5005929832257932_dp, &
             2.008900372471863_dp, 2.6844038388074605_dp, 3.5823063935310624_dp, &
             4.778520545565925_dp, 6.38175364033621_dp, 8.559597226954661_dp, &
             11.608770253008302_dp, 16.233797296706665_dp, &
             ! w
             0.0012423657316500449_dp, 0.0029565153785674637_dp, 0.004838766072050065_dp, &
             0.007014616100407565_dp, 0.009660513652046008_dp, 0.013025195915537968_dp, &
             0.017451277120328422_dp, 0.02339233265703512_dp, 0.03143098560382007_dp, &
             0.0423105530809966_dp, 0.05698858695878928_dp, 0.07671289981587993_dp, &
             0.10311989223847585_dp, 0.13835964417127153_dp, 0.18525750368309649_dp, &
             0.24752753568022848_dp, 0.3300623386101616_dp, 0.4393423474253336_dp, &
             0.5840484835859676_dp, 0.7760558681498742_dp, 1.0322160091516717_dp, &
             1.3779466028542828_dp, 1.8554960292106963_dp, 2.5465111854590297_dp, &
             3.652075387805127_dp, 5.967977078570323_dp]

      CASE (747)

         aw(:) = & ! a
            [0.0004237037834910963_dp, 0.0022584250258391057_dp, 0.005669926553394399_dp, &
             0.010868911143328828_dp, 0.018206964975942954_dp, 0.02823567299372345_dp, &
             0.04178689225729039_dp, 0.06007091736987142_dp, 0.08479086560189315_dp, &
             0.11828218712891493_dp, 0.16369648584732052_dp, 0.22525157385900133_dp, &
             0.3085691852960936_dp, 0.4211246104207476_dp, 0.5728403866115461_dp, &
             0.776868940166554_dp, 1.0506285914083997_dp, 1.4171898092611077_dp, &
             1.9071687571092122_dp, 2.5614078786888856_dp, 3.434995540350199_dp, &
             4.603833669091058_dp, 6.176719596270857_dp, 8.321370353332446_dp, &
             11.33443073360128_dp, 15.91917469743004_dp, &
             ! w
             0.0010902788963688841_dp, 0.0025974522054153897_dp, 0.004260002737132316_dp, &
             0.006195586302948424_dp, 0.00857110307043823_dp, 0.011623310939915346_dp, &
             0.01567895848254813_dp, 0.021170669423382915_dp, 0.02865545855115553_dp, &
             0.03884833339107419_dp, 0.052677659828228876_dp, 0.07136205274301125_dp, &
             0.09650926148254177_dp, 0.13024244971693058_dp, 0.1753641278888878_dp, &
             0.23557328055506793_dp, 0.31576015614127284_dp, 0.4224214843120374_dp, &
             0.5642790237556757_dp, 0.7532771428412752_dp, 1.006363166804727_dp, &
             1.349063291104767_dp, 1.8237091035609123_dp, 2.5119110565578304_dp, &
             3.6143024283761602_dp, 5.9241235182278835_dp]

      CASE (748)

         aw(:) = & ! a
            [0.0003782669796188801_dp, 0.0020172331287092054_dp, 0.005069119686178599_dp, &
             0.009731235748105319_dp, 0.016334609195701042_dp, 0.025401361290988092_dp, &
             0.037722209480860816_dp, 0.05445069114683172_dp, 0.07721339376379627_dp, &
             0.10824650532415606_dp, 0.15057821335956886_dp, 0.20827817350771893_dp, &
             0.2867949825724002_dp, 0.3934062169633969_dp, 0.5378140330377112_dp, &
             0.7329323304659365_dp, 0.9959310718753651_dp, 1.3496357175092744_dp, &
             1.8244394085419915_dp, 2.4610070435796634_dp, 3.314320267516937_dp, &
             4.460265045300612_dp, 6.007713152691113_dp, 8.124494075689427_dp, &
             11.107207013050493_dp, 15.658103924584907_dp, &
             ! w
             0.0009734706766828854_dp, 0.002321471243960268_dp, 0.0038145436905808665_dp, &
             0.005563909138165681_dp, 0.00772855429135239_dp, 0.010535159498998865_dp, &
             0.014296981759005418_dp, 0.019428854353673957_dp, 0.026466260006582223_dp, &
             0.036100551006574624_dp, 0.0492355729938984_dp, 0.06706502306889205_dp, &
             0.09117170497025595_dp, 0.1236548221025004_dp, 0.16729594494773173_dp, &
             0.22577934030863508_dp, 0.30399113034440967_dp, 0.40843979736958863_dp, &
             0.5478801676084779_dp, 0.7343148739219543_dp, 0.9847738403081407_dp, &
             1.324879035386037_dp, 1.7970391136650552_dp, 2.4828429723726506_dp, &
             3.582556064398403_dp, 5.887293715164641_dp]

      CASE (749)

         aw(:) = & ! a
            [0.0003421989583335503_dp, 0.0018257085835073476_dp, 0.004591736677656845_dp, &
             0.008826434220953463_dp, 0.014843624961940874_dp, 0.02314062269237656_dp, &
             0.03447325637711267_dp, 0.04994665535974386_dp, 0.07112199266415632_dp, &
             0.10015062275900183_dp, 0.1399552377517428_dp, 0.19447860488209762_dp, &
             0.2690204942807069_dp, 0.37068771079581253_dp, 0.5089910086382617_dp, &
             0.6966358669709843_dp, 0.9505737785372849_dp, 1.2934130109358752_dp, &
             1.755347096540008_dp, 2.3768798048940627_dp, 3.2128931351947743_dp, &
             4.3392537332948615_dp, 5.864896048508325_dp, 7.957750984839813_dp, &
             10.914390629911459_dp, 15.436209910892218_dp, &
             ! w
             0.0008807402834673146_dp, 0.0021022300401999684_dp, 0.0034602274566588615_dp, &
             0.005060545410177445_dp, 0.007055458888449444_dp, 0.009662991250291022_dp, &
             0.013184714534354523_dp, 0.01802009401257509_dp, 0.024686169357615355_dp, &
             0.033854107476560605_dp, 0.04640669245488154_dp, 0.06351591519186055_dp, &
             0.08674249204042286_dp, 0.11816404128490503_dp, 0.16054283890141222_dp, &
             0.21754896946404417_dp, 0.29406337043978603_dp, 0.396603109143591_dp, &
             0.5339503928386523_dp, 0.7181578449236157_dp, 0.9663277769718858_dp, &
             1.3041677661571567_dp, 1.7741579608285538_dp, 2.457875518507209_dp, &
             3.5552775883497483_dp, 5.855665566184162_dp]

      CASE (750)

         aw(:) = & ! a
            [0.0003128233455421415_dp, 0.001669673082754051_dp, 0.004202590323833114_dp, &
             0.008088244445134112_dp, 0.013625780354074402_dp, 0.02129122886077477_dp, &
             0.031810297971517354_dp, 0.04624612856927586_dp, 0.0661030672949113_dp, &
             0.09345878680220564_dp, 0.13114431580517746_dp, 0.18299194836082766_dp, &
             0.2541714354460333_dp, 0.3516397443271608_dp, 0.4847388725624787_dp, &
             0.665989565060541_dp, 0.9121485459810947_dp, 1.2456291627103782_dp, &
             1.696444332912379_dp, 2.3049503123129553_dp, 3.1259357340551794_dp, &
             4.235245837328704_dp, 5.741868646575056_dp, 7.813827252112669_dp, &
             10.747679303707777_dp, 15.244086992898186_dp, &
             ! w
             0.0008052105618199396_dp, 0.0019235456225993144_dp, 0.0031711267284408634_dp, &
             0.00464913495010319_dp, 0.006504049546727353_dp, 0.008946334909568856_dp, &
             0.012267295895854357_dp, 0.016852937982288426_dp, 0.023204264803511575_dp, &
             0.03197492692120719_dp, 0.04402930212447864_dp, 0.060520172804849934_dp, &
             0.08298844397008205_dp, 0.11349210127434721_dp, 0.15477555393617257_dp, &
             0.2104952983462872_dp, 0.2855264524289269_dp, 0.3863923757324024_dp, &
             0.5218983468942295_dp, 0.7041405495761667_dp, 0.9502855859216035_dp, &
             1.2861183798558435_dp, 1.7541856586724158_dp, 2.4360596337389633_dp, &
             3.5314340789662326_dp, 5.828034228091876_dp]

      CASE (751)

         aw(:) = & ! a
            [0.00017291384829261748_dp, 0.0009257017264827352_dp, 0.002343428682416174_dp, &
             0.004550887296601435_dp, 0.0077657271212931145_dp, 0.012343486742842325_dp, &
             0.01883581627466424_dp, 0.0280601401141889_dp, 0.04118739304737253_dp, &
             0.05986307934498813_dp, 0.08637863703453268_dp, 0.12391006673044795_dp, &
             0.17684452734831274_dp, 0.25122321899461836_dp, 0.3553395162863297_dp, &
             0.5005457238316426_dp, 0.7023425951686122_dp, 0.9818585585484546_dp, &
             1.367883443668756_dp, 1.899736310727328_dp, 2.6315013931260287_dp, &
             3.6387891962644465_dp, 5.0308760443364715_dp, 6.976408925336727_dp, &
             9.772046782104916_dp, 14.114347646235071_dp, &
             ! w
             0.00044538864678129233_dp, 0.001070442099632409_dp, 0.0017853069225190193_dp, &
             0.002665130248769398_dp, 0.0038228260935726658_dp, 0.00542348973304381_dp, &
             0.007695984976677009_dp, 0.010945841708647623_dp, 0.015580097131435197_dp, &
             0.02214925242788893_dp, 0.03140581949728218_dp, 0.044380943055469295_dp, &
             0.0624850007126613_dp, 0.0876413379578901_dp, 0.12246539457248491_dp, &
             0.1705061984424023_dp, 0.23657567214516587_dp, 0.3272079129865313_dp, &
             0.451326853417839_dp, 0.6212859750175638_dp, 0.8546591396119484_dp, &
             1.1777506269719031_dp, 1.6335969803040233_dp, 2.303855263440203_dp, &
             3.386754092935651_dp, 5.660652309580738_dp]

      CASE (752)

         aw(:) = & ! a
            [0.00012204736632389048_dp, 0.0006547137273899111_dp, 0.0016639000148910713_dp, &
             0.003251243782910262_dp, 0.0055971716804018344_dp, 0.009000548470427925_dp, &
             0.013928979534077724_dp, 0.02107983727274523_dp, 0.03146103095517637_dp, &
             0.04650634895170061_dp, 0.06824037715051341_dp, 0.09950928232473315_dp, &
             0.1442990837276884_dp, 0.20817146698932965_dp, 0.29885839998364283_dp, &
             0.42707194755339606_dp, 0.6076073469310884_dp, 0.8608509722899242_dp, &
             1.2148626443424309_dp, 1.708314515620925_dp, 2.3948171373116023_dp, &
             3.3497734374647177_dp, 4.682573434159799_dp, 6.5622280936143556_dp, &
             9.285580848932232_dp, 13.547287670945307_dp, &
             ! w
             0.0003145128504221444_dp, 0.0007589894136388903_dp, 0.0012758739204803116_dp, &
             0.0019282168286111723_dp, 0.0028126071752766673_dp, 0.004071087399604989_dp, &
             0.00590069576977076_dp, 0.00856711682788079_dp, 0.012431523524338491_dp, &
             0.017992747443828772_dp, 0.025944436118419567_dp, 0.037250543967667894_dp, &
             0.05324622803435168_dp, 0.07577388445162916_dp, 0.10736719834183205_dp, &
             0.15150102153058_dp, 0.21293342752906466_dp, 0.29818262367612935_dp, &
             0.4162163619168194_dp, 0.5795138909103924_dp, 0.8058705985837914_dp, &
             1.1218958671286532_dp, 1.5709443976412079_dp, 2.234803707306745_dp, &
             3.3110364585859893_dp, 5.573243754665258_dp]

      CASE (753)

         aw(:) = & ! a
            [9.526509192089255e-05_dp, 0.000511849317855352_dp, 0.0013047972405718026_dp, &
             0.0025619436154127573_dp, 0.004441178863289631_dp, 0.007206419360121439_dp, &
             0.011272760908284383_dp, 0.01726231298621627_dp, 0.02608077662266949_dp, &
             0.03902871102265026_dp, 0.05796133129339388_dp, 0.08551305403153013_dp, &
             0.12540912878216595_dp, 0.18289549332952543_dp, 0.26532958134866874_dp, &
             0.38299052704205755_dp, 0.5501896143879951_dp, 0.7867960945495058_dp, &
             1.1203515692013901_dp, 1.589057834152725_dp, 2.2461675629862587_dp, &
             3.1669084116597372_dp, 4.460726006347194_dp, 6.296883118054435_dp, &
             8.97239575407156_dp, 13.180758650806741_dp, &
             ! w
             0.0002455835345996807_dp, 0.0005945321076836713_dp, 0.001005590506513917_dp, &
             0.0015344097783881383_dp, 0.0022672945223508384_dp, 0.003331465910298092_dp, &
             0.004903660968025277_dp, 0.007224570182614312_dp, 0.010626490699482138_dp, &
             0.015574890455045828_dp, 0.022724298768935162_dp, 0.03299295754449749_dp, &
             0.04766380478583325_dp, 0.06852184803420519_dp, 0.09804127527987248_dp, &
             0.13964079380481373_dp, 0.19803431686386955_dp, 0.2797202571589431_dp, &
             0.3936868428581616_dp, 0.5524913223814614_dp, 0.7740772341332859_dp, &
             1.0852678812413343_dp, 1.529653162676978_dp, 2.18914280855039_dp, &
             3.26090124218018_dp, 5.51543804685709_dp]

      CASE (754)

         aw(:) = & ! a
            [7.858861003020861e-05_dp, 0.0004228020464457426_dp, 0.0010805462378518911_dp, &
             0.002130252817788983_dp, 0.0037142745052382445_dp, 0.006072113312843861_dp, &
             0.009581896655499004_dp, 0.014812684077224287_dp, 0.022598093415146167_dp, &
             0.03414433920987659_dp, 0.0511858287410983_dp, 0.07620462665802546_dp, &
             0.11273665224621121_dp, 0.16579649471749044_dp, 0.24246462859737236_dp, &
             0.35269700416871586_dp, 0.5104400080582252_dp, 0.7351686953234271_dp, &
             1.0540245992710164_dp, 1.5048404927542525_dp, 2.140581184434082_dp, &
             3.036323893616461_dp, 4.3015432912995335_dp, 6.105692100995696_dp, &
             8.745939425896696_dp, 12.914975468664835_dp, &
             ! w
             0.00020265339583361557_dp, 0.0004918982582778122_dp, 0.0008362766563318414_dp, &
             0.0012862999440733855_dp, 0.0019209731163454416_dp, 0.0028568827096219947_dp, &
             0.0042563322914238935_dp, 0.006342407652999645_dp, 0.009426891026795546_dp, &
             0.01395106428566226_dp, 0.02054056376541806_dp, 0.030079374296996947_dp, &
             0.04381079506645361_dp, 0.0634756690751343_dp, 0.09150161349300447_dp, &
             0.131262299953859_dp, 0.1874345607168912_dp, 0.26649713497987665_dp, &
             0.37744847034119006_dp, 0.5328999922547795_dp, 0.7509046167323155_dp, &
             1.0584491474299464_dp, 1.499309735077973_dp, 2.1555055775468994_dp, &
             3.2239307912772914_dp, 5.4728466747818_dp]

      CASE (755)

         aw(:) = & ! a
            [6.714426849047052e-05_dp, 0.00036164102959078935_dp, 0.0009262784506638192_dp, &
             0.0018325623909533754_dp, 0.0032112886223927104_dp, 0.005283616037873613_dp, &
             0.00839975673005728_dp, 0.01308869472633626_dp, 0.020129540913442486_dp, &
             0.03065688468541363_dp, 0.0463128535174269_dp, 0.06946232702680057_dp, &
             0.10349456355542663_dp, 0.15324367637099853_dp, 0.22557255051246414_dp, &
             0.3301813868362005_dp, 0.48072560674769427_dp, 0.6963633182667466_dp, &
             1.0039113022008568_dp, 1.4408991611387025_dp, 2.060050881627079_dp, &
             2.9363121518368174_dp, 4.179172457541649_dp, 5.958235594916836_dp, &
             8.570806240608334_dp, 12.70897453511031_dp, &
             ! w
             0.00017318657061009572_dp, 0.0004213320140074014_dp, 0.0007194962326474239_dp, &
             0.0011143450627180186_dp, 0.0016793292440978331_dp, 0.002522894677866273_dp, &
             0.0037963911442654955_dp, 0.005709609204305061_dp, 0.00855868509856927_dp, &
             0.012766158004867703_dp, 0.01893497524969928_dp, 0.02792194469050403_dp, &
             0.04093862503708093_dp, 0.05969013643384049_dp, 0.0865659582207842_dp, &
             0.12490223520242975_dp, 0.17934393610775015_dp, 0.2563511945376545_dp, &
             0.3649273526603343_dp, 0.5177240866121879_dp, 0.732879960475268_dp, &
             1.0375133842387705_dp, 1.475554452783257_dp, 2.1291202716182727_dp, &
             3.1949073591976322_dp, 5.439431394436815_dp]

      CASE (756)

         aw(:) = & ! a
            [5.877315524615591e-05_dp, 0.0003168711662988032_dp, 0.0008131992640388029_dp, &
             0.0016138929285165722_dp, 0.0028407114967937673_dp, 0.004700355781807101_dp, &
             0.007520959244613406_dp, 0.011799804781544607_dp, 0.018272833050634645_dp, &
             0.02801769164159514_dp, 0.0426027571868882_dp, 0.06429871390008898_dp, &
             0.09637624933257341_dp, 0.1435227319529147_dp, 0.21242311104366365_dp, &
             0.3125672220038115_dp, 0.4573696852254068_dp, 0.665724556106723_dp, &
             0.9641759960011973_dp, 1.3899966830196846_dp, 1.9957036283725886_dp, &
             2.8561257255148917_dp, 4.080758897727319_dp, 5.839331470206991_dp, &
             8.4292690716787_dp, 12.542192007323566_dp, &
             ! w
             0.00015162903684708888_dp, 0.00036963089478142606_dp, 0.0006337009534260716_dp, &
             0.0009874834034994374_dp, 0.0015000048648289156_dp, 0.0022732061293618917_dp, &
             0.0034497504917524137_dp, 0.005228907684193824_dp, 0.007894311564724681_dp, &
             0.011853330682507974_dp, 0.01769036325055092_dp, 0.026239826104261222_dp, &
             0.03868693657247448_dp, 0.05670693263215636_dp, 0.08265708247627895_dp, &
             0.11984141269223443_dp, 0.1728769971924686_dp, 0.24820661328798427_dp, &
             0.35483544642595605_dp, 0.5054464541904394_dp, 0.7182479592359079_dp, &
             1.0204680489230487_dp, 1.4561678358074204_dp, 2.107552574061816_dp, &
             3.171167079399473_dp, 5.4121122040770615_dp]

      CASE (757)

         aw(:) = & ! a
            [5.236704996319027e-05_dp, 0.0002825881255930106_dp, 0.000726501835385866_dp, &
             0.0014459244001574544_dp, 0.0025552945385815713_dp, 0.004249523006647992_dp, &
             0.006838695021021226_dp, 0.010794177343872474_dp, 0.016816569310599196_dp, &
             0.025936739410602375_dp, 0.03966219561819804_dp, 0.06018549854548548_dp, &
             0.09067851669750725_dp, 0.13570573156226848_dp, 0.20180237122472047_dp, &
             0.298280397685904_dp, 0.43834978275159403_dp, 0.6406789305357604_dp, &
             0.9315775615488228_dp, 1.348095684361383_dp, 1.9425688768701441_dp, &
             2.7897210073366367_dp, 3.99904918585352_dp, 5.7403870801623125_dp, &
             8.311269185020835_dp, 12.402935022288148_dp, &
             ! w
             0.00013512937937597535_dp, 0.0003300084672626687_dp, 0.0005677892969331586_dp, &
             0.0008896577635894677_dp, 0.0013610003019452943_dp, 0.002078397292795582_dp, &
             0.003177401426481483_dp, 0.004848673307520871_dp, 0.007365521409612725_dp, &
             0.011122652393007337_dp, 0.016688860382451792_dp, 0.024879609005058326_dp, &
             0.03685768601441181_dp, 0.05427271905426708_dp, 0.07945415275827052_dp, &
             0.11567797414127165_dp, 0.1675364723188058_dp, 0.24145627805588288_dp, &
             0.346442555192769_dp, 0.4952033681167655_dp, 0.7060054816300838_dp, &
             1.0061706977203289_dp, 1.4398740382193465_dp, 2.089400751365336_dp, &
             3.1511750506850524_dp, 5.389115656189673_dp]

      CASE (758)

         aw(:) = & ! a
            [4.729664275456446e-05_dp, 0.0002554372921586266_dp, 0.0006577650984095654_dp, &
             0.0013125261902318568_dp, 0.0023280695025991497_dp, 0.003889443955632863_dp, &
             0.006291611504771252_dp, 0.009984221292039549_dp, 0.015638213125297302_dp, &
             0.024245068850249414_dp, 0.03726083665287899_dp, 0.056811748319294884_dp, &
             0.08598542050725545_dp, 0.12924113074742682_dp, 0.1929854034335601_dp, &
             0.2863766572597064_dp, 0.4224474368212489_dp, 0.6196695877367286_dp, &
             0.9041475232578073_dp, 1.3127349678868334_dp, 1.8976060372032333_dp, &
             2.733389180009217_dp, 3.9295792573513793_dp, 5.656100817459108_dp, &
             8.210587167709864_dp, 12.283961153847606_dp, &
             ! w
             0.00012206820286482532_dp, 0.0002986063874566603_dp, 0.0005154370795698593_dp, &
             0.0008116935386320558_dp, 0.0012496935459225039_dp, 0.0019214969912302185_dp, &
             0.0029566943589554753_dp, 0.004538721617540457_dp, 0.006932147823841688_dp, &
             0.010520867636437416_dp, 0.015860265062596017_dp, 0.02374943136179607_dp, &
             0.035331681887801045_dp, 0.05223428821109438_dp, 0.07676224676312167_dp, &
             0.11216668895608872_dp, 0.16301761827733965_dp, 0.2357266266099482_dp, &
             0.33929766687775437_dp, 0.48645944894469645_dp, 0.6955287493215354_dp, &
             0.993908969243626_dp, 1.4258757892032492_dp, 2.07378760223158_dp, &
             3.133970205705443_dp, 5.369331945406666_dp]

      CASE (759)

         aw(:) = & ! a
            [4.317719967734884e-05_dp, 0.00023336680795860756_dp, 0.0006018336980996464_dp, &
             0.0012038098681020043_dp, 0.0021424731842022656_dp, 0.0035944592715023886_dp, &
             0.0058418112137322625_dp, 0.009315624184933058_dp, 0.014661460733321648_dp, &
             0.02283700051662502_dp, 0.035253966060629735_dp, 0.0539812412007093_dp, &
             0.08203333029208569_dp, 0.12377788723451821_dp, 0.18550894397332324_dp, &
             0.27625022632293883_dp, 0.40887804274180545_dp, 0.6016904475676462_dp, &
             0.880609486600425_dp, 1.2823135418640648_dp, 1.8588313164004495_dp, &
             2.684703826327194_dp, 3.8694213674528846_dp, 5.582988110894329_dp, &
             8.123127725101146_dp, 12.180494361547703_dp, &
             ! w
             0.0001114553663670069_dp, 0.00027306329577101926_dp, 0.0004727669329327756_dp, &
             0.0007479507039135482_dp, 0.001158296425411531_dp, 0.0017919822969572356_dp, &
             0.0027735042629080794_dp, 0.004280115138194904_dp, 0.0065688452893215565_dp, &
             0.010014192680666882_dp, 0.015159823746232407_dp, 0.022790460929301412_dp, &
             0.0340322562933408_dp, 0.05049268292856977_dp, 0.07445496359297314_dp, &
             0.10914792741732254_dp, 0.15912134288705304_dp, 0.23077275756915933_dp, &
             0.3331041335784785_dp, 0.4788614828660507_dp, 0.6864050949448307_dp, &
             0.9832104763402225_dp, 1.4136434040592538_dp, 2.0601296079172973_dp, &
             3.1189129246260654_dp, 5.352022810567828_dp]

      CASE (760)

         aw(:) = & ! a
            [2.3696529954394216e-05_dp, 0.0001287991639836404_dp, 0.0003358900143682699_dp, &
             0.0006840018203583861_dp, 0.0012479643063968945_dp, 0.0021576439182584258_dp, &
             0.00362307508597025_dp, 0.005971815423400454_dp, 0.009706836302634192_dp, &
             0.015593724727794812_dp, 0.02478907709106132_dp, 0.039027475868502096_dp, &
             0.06089192350092822_dp, 0.09420272871142639_dp, 0.14457376171485573_dp, &
             0.22020433186469504_dp, 0.33300222359717174_dp, 0.5001733066799745_dp, &
             0.7464757579764995_dp, 1.107447768762324_dp, 1.6341471400324594_dp, &
             2.4004987655686034_dp, 3.5159072377751035_dp, 5.1508589046691355_dp, &
             7.60370514440916_dp, 11.56363867454749_dp, &
             ! w
             6.124599029230103e-05_dp, 0.0001517616577131681_dp, 0.00026868279454353525_dp, &
             0.00043969140770755015_dp, 0.0007094771072731152_dp, 0.001144285532736754_dp, &
             0.0018402242460228186_dp, 0.002939659068074601_dp, 0.004655881337856208_dp, &
             0.007307603500267008_dp, 0.011367772916235558_dp, 0.017533157983462947_dp, &
             0.026823343966772453_dp, 0.04072093632178502_dp, 0.061369278265663324_dp, &
             0.09185045423350256_dp, 0.1365760999125589_dp, 0.2018398104771673_dp, &
             0.2966114304084227_dp, 0.4337250840314629_dp, 0.6317987962384561_dp, &
             0.9187594711215165_dp, 1.3395618189041059_dp, 1.9771109985323623_dp, &
             3.02724046742181_dp, 5.246741506122488_dp]

      CASE (761)

         aw(:) = & ! a
            [1.6679761052170168e-05_dp, 9.101192188301173e-05_dp, 0.00023919164954058672_dp, &
             0.0004931572545336922_dp, 0.0009149548256836711_dp, 0.0016130186534847929_dp, &
             0.0027643325460259298_dp, 0.004648738213819286_dp, 0.007702635771125785_dp, &
             0.012600335960416894_dp, 0.020374962475382938_dp, 0.03259640993397566_dp, &
             0.05163145666661519_dp, 0.08102156631683173_dp, 0.1260284038388582_dp, &
             0.19441731882678862_dp, 0.2975776063742286_dp, 0.452119881100164_dp, &
             0.6821552622417691_dp, 1.0225728478099656_dp, 1.5238595292012491_dp, &
             2.259554964896021_dp, 3.3389738577108115_dp, 4.932849838085886_dp, &
             7.339916404870769_dp, 11.248722848339217_dp, &
             ! w
             4.314752437063996e-05_dp, 0.0001077518470897124_dp, 0.00019372208534351962_dp, &
             0.0003242819198625428_dp, 0.0005370339651032575_dp, 0.0008880358909871951_dp, &
             0.001460355558412263_dp, 0.0023798609437167477_dp, 0.0038383451961807357_dp, &
             0.006126335148697903_dp, 0.009680314796525412_dp, 0.015150863373628917_dp, &
             0.023500546187326967_dp, 0.0361437896419946_dp, 0.05514576524182976_dp, &
             0.08350412873760803_dp, 0.12554761090545138_dp, 0.18750202639477245_dp, &
             0.2783055524409113_dp, 0.41082511709594727_dp, 0.6038071990387519_dp, &
             0.8854226612224724_dp, 1.3009630601208435_dp, 1.933635218726777_dp, &
             2.979122332070239_dp, 5.19154796123303_dp]

      CASE (762)

         aw(:) = & ! a
            [1.3001984766087793e-05_dp, 7.116127252637867e-05_dp, 0.00018817390586289379_dp, &
             0.00039177798215826384_dp, 0.000736317267557241_dp, 0.001317226634587859_dp, &
             0.002291437482409679_dp, 0.003909705064102591_dp, 0.006567450381777662_dp, &
             0.010882153716399596_dp, 0.01780919686112579_dp, 0.02881367441365547_dp, &
             0.04612336665840598_dp, 0.07309871650984166_dp, 0.11477052968045261_dp, &
             0.17861695314795428_dp, 0.2756807345400839_dp, 0.4221704741533257_dp, &
             0.6417552650517414_dp, 0.9688747801678594_dp, 1.453613451097974_dp, &
             2.1692304640732014_dp, 3.224961686972853_dp, 4.791700519824695_dp, &
             7.168453178851233_dp, 11.043391139785637_dp, &
             ! w
             3.3656483278626174e-05_dp, 8.456823687052525e-05_dp, 0.00015389367787899035_dp, &
             0.00026213567417783024_dp, 0.00044252524733419586_dp, 0.0007449246515256214_dp, &
             0.00124446031871493_dp, 0.0020567162013199157_dp, 0.003359798043574568_dp, &
             0.005426034221366777_dp, 0.0086681019808671_dp, 0.013706102010484613_dp, &
             0.021464561703110372_dp, 0.03331189149601876_dp, 0.051259805563100766_dp, &
             0.07824729413002185_dp, 0.11854418715925116_dp, 0.17832617800528477_dp, &
             0.2665044110441916_dp, 0.39596175844669834_dp, 0.5855263623893628_dp, &
             0.8635326580612234_dp, 1.2755057756967882_dp, 1.9048723028837835_dp, &
             2.947242456506994_dp, 5.155005283166501_dp]

      CASE (763)

         aw(:) = & ! a
            [1.0718315150846706e-05_dp, 5.881320145962588e-05_dp, 0.00015632942277764856_dp, &
             0.0003281518552075014_dp, 0.00062332794816116_dp, 0.001128323720864188_dp, &
             0.001986229916290794_dp, 0.0034276341421111277_dp, 0.0058193228837554595_dp, &
             0.009738731357604379_dp, 0.016086019185961465_dp, 0.026251272351910014_dp, &
             0.042362065679764256_dp, 0.06764743024649592_dp, 0.10696943276619618_dp, &
             0.16759486682665498_dp, 0.26030968200090215_dp, 0.40102240616981333_dp, &
             0.6130695622943815_dp, 0.9305495355846601_dp, 1.403237379436583_dp, &
             2.104172046054719_dp, 3.1425207112169447_dp, 4.689291880522299_dp, &
             7.043702668151617_dp, 10.893671223171374_dp, &
             ! w
             2.7760738237263172e-05_dp, 7.01153213129313e-05_dp, 0.0001288943151317459_dp, &
             0.00022271096190231769_dp, 0.00038174758961133826_dp, 0.0006515914028297886_dp, &
             0.0011018585433675834_dp, 0.0018408678817666408_dp, 0.00303692172873389_dp, &
             0.004949194003149661_dp, 0.007973020736397898_dp, 0.012706134825041512_dp, &
             0.020044933254893073_dp, 0.03132351809116701_dp, 0.04851338525188155_dp, &
             0.07450890842713345_dp, 0.11353445966618125_dp, 0.1717260603688044_dp, &
             0.2579717028831469_dp, 0.38516284347180335_dp, 0.5721858020223305_dp, &
             0.8474963588483271_dp, 1.2567971101894204_dp, 1.8836871237354142_dp, &
             2.9237369830113087_dp, 5.1280743071765436_dp]

      CASE (764)

         aw(:) = & ! a
            [9.15411230314752e-06_dp, 5.034266515471185e-05_dp, 0.0001344215205311866_dp, &
             0.0002841762993812937_dp, 0.0005447221182910752_dp, 0.0009958535694640329_dp, &
             0.001770359728477814_dp, 0.003083753793747608_dp, 0.005281282444557467_dp, &
             0.00891005811317354_dp, 0.014828163199826862_dp, 0.024368193450410778_dp, &
             0.03958049176175854_dp, 0.06359225971157109_dp, 0.1011341216286402_dp, &
             0.15930737165974232_dp, 0.24869580555977153_dp, 0.38497041841672236_dp, &
             0.591202881998948_dp, 0.9012178771234863_dp, 1.3645400663240932_dp, &
             2.05402736409595_dp, 3.078786447927888_dp, 4.609914264036999_dp, &
             6.946799170983685_dp, 10.777175748831938_dp, &
             ! w
             2.3721059578624046e-05_dp, 6.018269104938307e-05_dp, 0.00011161473856337134_dp, &
             0.00019521590515585212_dp, 0.0003388839801873327_dp, 0.0005850277011660742_dp, &
             0.0009991379266343222_dp, 0.0016840167695220487_dp, 0.002800448281015556_dp, &
             0.0045974499581123195_dp, 0.00745689003858124_dp, 0.011959029457061846_dp, &
             0.018978162261342146_dp, 0.029821265806689926_dp, 0.04642782113319274_dp, &
             0.07165639789647535_dp, 0.10969449346539786_dp, 0.16664536319575102_dp, &
             0.25137686407541915_dp, 0.3767852098891963_dp, 0.5618010406082176_dp, &
             0.83497568188825_dp, 1.2421540703958742_dp, 1.8670769420552227_dp, &
             2.9052924737232733_dp, 5.106949117695199_dp]

      CASE (765)

         aw(:) = & ! a
            [8.011538951299322e-06_dp, 4.414727291794558e-05_dp, 0.00011835753345467715_dp, &
             0.00025180037890242717_dp, 0.00048652048813320784_dp, 0.0008970977310091758_dp, &
             0.0016082625192058758_dp, 0.0028236899068712793_dp, 0.0048716196079025935_dp, &
             0.008275092041820052_dp, 0.013858615599877711_dp, 0.022908694129468363_dp, &
             0.03741346973416002_dp, 0.06041777457032838_dp, 0.0965454566542163_dp, &
             0.15276279943191157_dp, 0.23948797977879843_dp, 0.3721965199962738_dp, &
             0.5737410815468109_dp, 0.8777187458387989_dp, 1.3334444502119562_dp, &
             2.0136226230150567_dp, 3.027306012240332_dp, 4.545662487348452_dp, &
             6.868224112057717_dp, 10.682585450364686_dp, &
             ! w
             2.0769397324140803e-05_dp, 5.2906323736100554e-05_dp, 9.889262192397104e-05_dp, &
             0.00017481475500315155_dp, 0.0003067753173183288_dp, 0.0005346999147658447_dp, &
             0.0009208330644032769_dp, 0.0015635853005832032_dp, 0.002617710352322344_dp, &
             0.004324036000417397_dp, 0.007053519028158293_dp, 0.011372198534568688_dp, &
             0.018136291512382954_dp, 0.028630480476273423_dp, 0.044767788499736005_dp, &
             0.06937700611935885_dp, 0.10661470164401311_dp, 0.16255626657905964_dp, &
             0.24605178510545586_dp, 0.37000002030091594_dp, 0.5533669086075808_dp, &
             0.8247820343947609_dp, 1.2302086902725924_dp, 1.853507615443971_dp, &
             2.890214488065904_dp, 5.089684427285232_dp]

      CASE (766)

         aw(:) = & ! a
            [7.138085793298004e-06_dp, 3.9405631758569e-05_dp, 0.0001060352833027681_dp, &
             0.00022687560276351_dp, 0.00044148675932495095_dp, 0.0008202264039839037_dp, &
             0.0014812941305292087_dp, 0.0026187369149824405_dp, 0.004546897907731144_dp, &
             0.007769057361543425_dp, 0.013082044991362951_dp, 0.02173421319378046_dp, &
             0.0356620224735299_dp, 0.05784161484001245_dp, 0.09280747681831969_dp, &
             0.14741250169574235_dp, 0.2319352727234425_dp, 0.36168594382991653_dp, &
             0.5593311504242302_dp, 0.8582737567184606_dp, 1.3076486668608143_dp, &
             1.9800272468824947_dp, 2.9844136452994183_dp, 4.492034370694095_dp, &
             6.802544985878319_dp, 10.603429293059833_dp, &
             ! w
             1.8512370629960755e-05_dp, 4.732945859321389e-05_dp, 8.909826890297781e-05_dp, &
             0.00015899978707284963_dp, 0.0002816773836864989_dp, 0.0004950469671479302_dp, &
             0.0008587066944865137_dp, 0.0014674528621459308_dp, 0.002471046150477078_dp, &
             0.004103503672681867_dp, 0.006726672049493583_dp, 0.010894669757205598_dp, &
             0.01744850144125048_dp, 0.02765401000420138_dp, 0.04340175997229905_dp, &
             0.0674951310697116_dp, 0.10406411793062145_dp, 0.15915990674959807_dp, &
             0.24161669534906116_dp, 0.364334431323379_dp, 0.5463080659088638_dp, &
             0.8162331100436446_dp, 1.220173835507811_dp, 1.8420949280175116_dp, &
             2.8775256863897587_dp, 5.075158651624107_dp]

      CASE (767)

         aw(:) = & ! a
            [6.447315515366079e-06_dp, 3.565176486703362e-05_dp, 9.626007413356028e-05_dp, &
             0.00020703770332841388_dp, 0.00040548020721979184_dp, 0.0007584353512550411_dp, &
             0.001378668354058478_dp, 0.0024521881184671364_dp, 0.0042816885080338716_dp, &
             0.007353819035777134_dp, 0.012442027858609615_dp, 0.020762327251525197_dp, &
             0.034207224651822514_dp, 0.05569426004567119_dp, 0.08968144901899952_dp, &
             0.14292435773222398_dp, 0.22558138492200114_dp, 0.35281985768272145_dp, &
             0.5471451926965387_dp, 0.8417912748197468_dp, 1.285735580345591_dp, &
             1.9514321579354552_dp, 2.9478409553323104_dp, 4.446238090069938_dp, &
             6.746387183468815_dp, 10.535681985640965_dp, &
             ! w
             1.672697610229953e-05_dp, 4.290869969643856e-05_dp, 8.130280692501406e-05_dp, &
             0.0001463337856486874_dp, 0.0002614283887292092_dp, 0.0004628322923203653_dp, &
             0.0008079289993928696_dp, 0.0013884657112219609_dp, 0.0023499696871174336_dp, &
             0.003920662117809293_dp, 0.006454610341780787_dp, 0.010495719371635402_dp, &
             0.016871915675052147_dp, 0.026832788191691517_dp, 0.04224945081571206_dp, &
             0.0659031778945015_dp, 0.10190071388430866_dp, 0.15627187321146097_dp, &
             0.23783650335833062_dp, 0.3594948520759777_dp, 0.5402662973560344_dp, &
             0.8089030734470476_dp, 1.211557287848049_dp, 1.8322851959845272_dp, &
             2.8666136837008023_dp, 5.062669240266597_dp]

      CASE (768)

         aw(:) = & ! a
            [5.886464532610611e-06_dp, 3.26009883977612e-05_dp, 8.830085016020185e-05_dp, &
             0.00019083628569058127_dp, 0.0003759514078148174_dp, 0.000707515919470363_dp, &
             0.0012936792774264547_dp, 0.002313602302956732_dp, 0.004060017906661753_dp, &
             0.007005305248647172_dp, 0.011902784199625784_dp, 0.019940542093872384_dp, &
             0.03297302481367222_dp, 0.05386688560504225_dp, 0.08701355932587622_dp, &
             0.13908364884683921_dp, 0.22013035661059766_dp, 0.345195649969885_dp, &
             0.5366430226212573_dp, 0.8275570983865407_dp, 1.2667756919189468_dp, &
             1.926648038438562_dp, 2.916093569090425_dp, 4.406431131413416_dp, &
             6.697520241556893_dp, 10.47667986222305_dp, &
             ! w
             1.5277060504852664e-05_dp, 3.931172288617379e-05_dp, 7.493636143456648e-05_dp, &
             0.0001359306286734141_dp, 0.0002446866870411191_dp, 0.00043603315339804124_dp, &
             0.0007654621403872697_dp, 0.0013220987812271629_dp, 0.00224781435948968_dp, &
             0.0037658086315521485_dp, 0.006223389032138102_dp, 0.010155559272038444_dp, &
             0.016378813919777503_dp, 0.026128490277382923_dp, 0.041258591043675796_dp, &
             0.06453086923997488_dp, 0.10003143553506957_dp, 0.1537709906727131_dp, &
             0.23455630469152183_dp, 0.3552873327074355_dp, 0.5350044018773913_dp, &
             0.8025093600096891_dp, 1.2040318800128793_dp, 1.8237099628961988_dp, &
             2.857070745862338_dp, 5.0517485608055965_dp]

      CASE (769)

         aw(:) = & ! a
            [3.238290342763316e-06_dp, 1.8147006909029444e-05_dp, 5.033876912627858e-05_dp, &
             0.0001127211083700331_dp, 0.00023147402305268534_dp, 0.0004542039985673368_dp, &
             0.0008637266102421281_dp, 0.0016011912287843474_dp, 0.002903345669071525_dp, &
             0.005161413976376238_dp, 0.009012995229989893_dp, 0.0154839918407676_dp, &
             0.02620565577794412_dp, 0.04374347600981119_dp, 0.07209129932837946_dp, &
             0.11740787283271652_dp, 0.1891070004539759_dp, 0.3014616684326893_dp, &
             0.47595615272918557_dp, 0.7447399264392535_dp, 1.155763209038512_dp, &
             1.7806937116698627_dp, 2.728165947692135_dp, 4.169743178819503_dp, &
             6.405894023548097_dp, 10.123564208163382_dp, &
             ! w
             8.425712395489665e-06_dp, 2.2199090084818415e-05_dp, 4.424309111678013e-05_dp, &
             8.475802931549623e-05_dp, 0.00016046069122317423_dp, 0.0002984272062873808_dp, &
             0.0005435392147754277_dp, 0.0009698932108728927_dp, 0.0016981275601559143_dp, &
             0.0029219684484493415_dp, 0.004948645838038015_dp, 0.008259865616146308_dp, &
             0.013602988254368778_dp, 0.022126276621676415_dp, 0.03557803136637922_dp, &
             0.05659788853283017_dp, 0.08914080316166212_dp, 0.1390929679984203_dp, &
             0.2151709890217123_dp, 0.3302614294763991_dp, 0.5035227312131432_dp, &
             0.7640571560951969_dp, 1.158579669857566_dp, 1.7717581608167268_dp, &
             2.7991701379927383_dp, 4.9855231331525784_dp]

      CASE (770)

         aw(:) = & ! a
            [2.285579515756328e-06_dp, 1.2916168150052104e-05_dp, 3.643855776314386e-05_dp, &
             8.357358643218068e-05_dp, 0.00017621980068586836_dp, 0.00035470375292651714_dp, &
             0.0006903830063139463_dp, 0.0013069087103258074_dp, 0.0024147882876834545_dp, &
             0.00436657453629266_dp, 0.007743883762308679_dp, 0.013493047752426329_dp, &
             0.023134360466563225_dp, 0.03908169856021381_dp, 0.06512631804527541_dp, &
             0.10716304411356753_dp, 0.174272077117968_dp, 0.28032030082697834_dp, &
             0.44632164343163794_dp, 0.7039179735406376_dp, 1.1005688895743868_dp, &
             1.7075546101068342_dp, 2.63333285070587_dp, 4.049582659154745_dp, &
             6.257108262455116_dp, 9.942716594325063_dp, &
             ! w
             5.957569970239744e-06_dp, 1.5961399544905822e-05_dp, 3.279326246751011e-05_dp, &
             6.501372582428369e-05_dp, 0.0001267968088939736_dp, 0.00024172022284842305_dp, &
             0.00044968778967707324_dp, 0.0008175543699416209_dp, 0.0014555522999045497_dp, &
             0.0025427533904299904_dp, 0.004366185129628688_dp, 0.007380323404093707_dp, &
             0.012296733668891757_dp, 0.020217978976422968_dp, 0.03283608171899166_dp, &
             0.05272460273645505_dp, 0.08376609702851401_dp, 0.1317759663965641_dp, &
             0.20541621778515945_dp, 0.31755809083044245_dp, 0.4874148637360738_dp, &
             0.7442443638411245_dp, 1.1350242822854533_dp, 1.7447224041208844_dp, &
             2.7689771696044665_dp, 4.95101187969963_dp]

      CASE (771)

         aw(:) = & ! a
            [1.7861558372834072e-06_dp, 1.0162721058852052e-05_dp, 2.9060588508942103e-05_dp, &
             6.789596292856617e-05_dp, 0.00014600269803134486_dp, 0.0002993435657128908_dp, &
             0.0005923499518536362_dp, 0.0011379739592923908_dp, 0.0021305031806454285_dp, &
             0.0038983505999002992_dp, 0.006987871231312497_dp, 0.012294860199886357_dp, &
             0.02126858894879571_dp, 0.03622517010223238_dp, 0.06082429418572556_dp, &
             0.10078820422628014_dp, 0.16497745141785863_dp, 0.26698965911671196_dp, &
             0.42752457973177455_dp, 0.6778821952071029_dp, 1.0651882557933707_dp, &
             1.660455177790823_dp, 2.572012927187589_dp, 3.971611807802713_dp, &
             6.160283663308771_dp, 9.82476529573032_dp, &
             ! w
             4.662533480362757e-06_dp, 1.2661413094988166e-05_dp, 2.6636099529206454e-05_dp, &
             5.415225318786296e-05_dp, 0.0001078642327690994_dp, 0.0002092323166044308_dp, &
             0.0003950756349935989_dp, 0.0007276994384505561_dp, 0.0013107362017076303_dp, &
             0.0023138839050105974_dp, 0.004011141473828312_dp, 0.006839284695947886_dp, &
             0.011486429548608422_dp, 0.01902496489031138_dp, 0.031109447558056426_dp, &
             0.050269047843786725_dp, 0.08033713804466817_dp, 0.12708025941636275_dp, &
             0.1991215155361568_dp, 0.309318746436775_dp, 0.4769185658253315_dp, &
             0.7312806126357808_dp, 1.1195591691660303_dp, 1.7269286628173137_dp, &
             2.749081262408883_dp, 4.9282786480308785_dp]

      CASE (772)

         aw(:) = & ! a
            [1.4758868942766727e-06_dp, 8.446492268214608e-06_dp, 2.4431064615535108e-05_dp, &
             5.795432708718084e-05_dp, 0.00012659498285636373_dp, 0.0002633258955025601_dp, &
             0.0005277997978086226_dp, 0.0010255246365668323_dp, 0.0019394145847126698_dp, &
             0.0035808371077294867_dp, 0.006471089731273009_dp, 0.011469843264226893_dp, &
             0.019975321354642264_dp, 0.03423300201914935_dp, 0.05780704553303091_dp, &
             0.09629377525783753_dp, 0.15839271284010523_dp, 0.2575031184071795_dp, &
             0.41409210152319825_dp, 0.6592050291523002_dp, 1.0397172730720725_dp, &
             1.626438282013283_dp, 2.5275983692066166_dp, 3.9149973674907232_dp, &
             6.089837346283289_dp, 9.738814548838203_dp, &
             ! w
             3.857394121672818e-06_dp, 1.0596286281071076e-05_dp, 2.273234190005156e-05_dp, &
             4.7144763035542114e-05_dp, 9.54502029898154e-05_dp, 0.00018764450035005142_dp, &
             0.0003583786230253613_dp, 0.0006667312998957075_dp, 0.0012116235799954208_dp, &
             0.002156021174408096_dp, 0.0037645117030672562_dp, 0.006461013683953383_dp, &
             0.010916516308120102_dp, 0.0181812491808032_dp, 0.029882098168377766_dp, &
             0.048515241942874286_dp, 0.07787722288582287_dp, 0.12369760320915187_dp, &
             0.19456943351685493_dp, 0.30333899766238975_dp, 0.46927587476273364_dp, &
             0.721813971920214_dp, 1.1082388668891696_dp, 1.713881260267566_dp, &
             2.7344798060252042_dp, 4.911598980700791_dp]

      CASE (773)

         aw(:) = & ! a
            [1.1077877649427223e-06_dp, 6.402638149833196e-06_dp, 1.8874666145988735e-05_dp, &
             4.587683636768642e-05_dp, 0.00010267991565522593_dp, 0.00021831670940809556_dp, &
             0.0004460914127549677_dp, 0.0008815325120941069_dp, 0.0016921821445671226_dp, &
             0.0031662002330419266_dp, 0.005790540391736413_dp, 0.010375055881095956_dp, &
             0.018247167221152834_dp, 0.03155385038925613_dp, 0.05372535506370829_dp, &
             0.09018060831193814_dp, 0.1493911462461239_dp, 0.2444739725204163_dp, &
             0.3955634096033509_dp, 0.6333384633681044_dp, 1.0043116535466552_dp, &
             1.5789951495220627_dp, 2.4654691452956343_dp, 3.835599417899475_dp, &
             5.9908338975379865_dp, 9.617827300722704_dp, &
             ! w
             2.901379205756704e-06_dp, 8.125550269009479e-06_dp, 1.7990728087923447e-05_dp, &
             3.846683146136776e-05_dp, 7.980897314073075e-05_dp, 0.0001600595942316087_dp, &
             0.0003109308943834929_dp, 0.0005870898272973621_dp, 0.0010809710716045255_dp, &
             0.0019462127601313614_dp, 0.003434284018913239_dp, 0.005951077062542574_dp, &
             0.010143432300365619_dp, 0.017030157415800114_dp, 0.028198670235951587_dp, &
             0.04609779007725842_dp, 0.07447078432757803_dp, 0.1189931535703577_dp, &
             0.18821312745614455_dp, 0.2949580395663386_dp, 0.45852775317354455_dp, &
             0.7084607088626661_dp, 1.0922310401482862_dp, 1.695397799392969_dp, &
             2.71377602104654_dp, 4.887954245341748_dp]

      CASE (774)

         aw(:) = & ! a
            [8.183008324342162e-07_dp, 4.7869328118446346e-06_dp, 1.4434782215019975e-05_dp, &
             3.606718198820443e-05_dp, 8.2892943372501e-05_dp, 0.00018041064363924077_dp, &
             0.0003761684980123291_dp, 0.0007565463301234727_dp, 0.0014748546162566816_dp, &
             0.0027975778218020234_dp, 0.005179335987080592_dp, 0.009382735228561147_dp, &
             0.016667585631734243_dp, 0.029086196168817708_dp, 0.04993932932066799_dp, &
             0.08447335815914907_dp, 0.14093676109851508_dp, 0.23216875614889984_dp, &
             0.377974124098394_dp, 0.6086665999330783_dp, 0.9703939297636615_dp, &
             1.5333657922460842_dp, 2.4055048323204384_dp, 3.7587362918930065_dp, &
             5.894754155450519_dp, 9.500190793802554_dp, &
             ! w
             2.14867181339874e-06_dp, 6.16002456580921e-06_dp, 1.4140116837101387e-05_dp, &
             3.1241003267484476e-05_dp, 6.65034489516716e-05_dp, 0.00013618689718180696_dp, &
             0.00026927291480151815_dp, 0.0005162882307712134_dp, 0.0009635305101728781_dp, &
             0.0017557451601807163_dp, 0.003131803773929586_dp, 0.0054801682991530536_dp, &
             0.009424172034020486_dp, 0.015951831579185092_dp, 0.026611623497497155_dp, &
             0.04380529144029536_dp, 0.07122267990949183_dp, 0.11448442283946264_dp, &
             0.18209225345061755_dp, 0.2868519276029316_dp, 0.4480902878467663_dp, &
             0.6954472580415753_dp, 1.0765844994587044_dp, 1.6772927565040117_dp, &
             2.6934741516834713_dp, 4.864774978505916_dp]

      CASE (775)

         aw(:) = & ! a
            [4.562469115792869e-07_dp, 2.7489989909837295e-06_dp, 8.733256639479415e-06_dp, &
             2.313553852401061e-05_dp, 5.6065343224443786e-05_dp, 0.00012766173192385065_dp, &
             0.00027659892703900174_dp, 0.0005749289666160984_dp, 0.0011533647274757695_dp, &
             0.0022435484153307266_dp, 0.004247543879449043_dp, 0.007850371478578814_dp, &
             0.014199759029268406_dp, 0.025189678388356212_dp, 0.04390248052004506_dp, &
             0.07529110942395219_dp, 0.12722169511208972_dp, 0.21205345763526556_dp, &
             0.34901695658559384_dp, 0.567783550996382_dp, 0.9138523278999139_dp, &
             1.45688636804011_dp, 2.3045122105770037_dp, 3.6287443136582156_dp, &
             5.731711127649081_dp, 9.300049739455408_dp, &
             ! w
             1.2055417783624751e-06_dp, 3.6548938859666544e-06_dp, 9.064243779199115e-06_dp, &
             2.1351301895744585e-05_dp, 4.772868408283207e-05_dp, 0.00010167189451844998_dp, &
             0.00020780488107187674_dp, 0.00040995984916220176_dp, 0.000784397091197657_dp, &
             0.0014611613352540625_dp, 0.0026580886076477362_dp, 0.004734256192807689_dp, &
             0.0082730012717923_dp, 0.01420947197842467_dp, 0.024024657367570274_dp, &
             0.04003789476951579_dp, 0.06584441041165796_dp, 0.10696612228341267_dp, &
             0.17181875284754664_dp, 0.2731637461533346_dp, 0.4303676823388346_dp, &
             0.6732422871885089_dp, 1.0497777366867178_dp, 1.6461817469712032_dp, &
             2.6585354781080484_dp, 4.824898945578199_dp]

      CASE (776)

         aw(:) = & ! a
            [3.25265730426002e-07_dp, 2.0035191019575433e-06_dp, 6.597545356466585e-06_dp, &
             1.8131385561348473e-05_dp, 4.5339723074456194e-05_dp, 0.00010595343922598583_dp, &
             0.00023458629322630387_dp, 0.0004966271796323126_dp, 0.001012131192490257_dp, &
             0.001996101875632395_dp, 0.0038252220799851826_dp, 0.007146658088996184_dp, &
             0.01305293395579405_dp, 0.023359346104199475_dp, 0.041038814112132095_dp, &
             0.07089608918057082_dp, 0.1206026947029687_dp, 0.2022716353192338_dp, &
             0.33483653817640013_dp, 0.5476336463177783_dp, 0.8858200806040595_dp, &
             1.4187664281412384_dp, 2.2539351357253308_dp, 3.563379356119668_dp, &
             5.649454848852348_dp, 9.198822480060773_dp, &
             ! w
             8.635439899868441e-07_dp, 2.725856315656924e-06_dp, 7.0994213722346605e-06_dp, &
             1.7355782909820106e-05_dp, 3.989010526416555e-05_dp, 8.688395110476006e-05_dp, &
             0.00018089644979700931_dp, 0.0003625463451390064_dp, 0.0007032195398968159_dp, &
             0.0013257444468314594_dp, 0.00243752696376032_dp, 0.0043829361927625364_dp, &
             0.007725107679712813_dp, 0.013372248408964655_dp, 0.022770646233599017_dp, &
             0.03819685882258097_dp, 0.06319644851448913_dp, 0.10323876059224307_dp, &
             0.1666925649378866_dp, 0.26629302896736046_dp, 0.42142359618353004_dp, &
             0.6619822257699717_dp, 1.0361297559113467_dp, 1.630296139192321_dp, &
             2.6406687738665062_dp, 4.804514283790612_dp]

      CASE (777)

         aw(:) = & ! a
            [2.563074156685936e-07_dp, 1.607980393135116e-06_dp, 5.445152672881355e-06_dp, &
             1.537236590890338e-05_dp, 3.9304209698318675e-05_dp, 9.352137528947918e-05_dp, &
             0.00021016538522819494_dp, 0.0004505297160373182_dp, 0.0009280651390003391_dp, &
             0.0018473900916196446_dp, 0.003569242801571125_dp, 0.006716868690485611_dp, &
             0.012347717844607661_dp, 0.022226847547468974_dp, 0.039256966691641006_dp, &
             0.06814731540406455_dp, 0.11644343855962974_dp, 0.19609825174043236_dp, &
             0.32585143878115014_dp, 0.5348192758282327_dp, 0.8679331030458826_dp, &
             1.3943687963570828_dp, 2.2214775102875945_dp, 3.5213348462304936_dp, &
             5.5964459408466345_dp, 9.133494928157374_dp, &
             ! w
             6.83208305844842e-07_dp, 2.2280942089216503e-06_dp, 6.0156296650280774e-06_dp, &
             1.5093320782926295e-05_dp, 3.5364324331927196e-05_dp, 7.821442437169257e-05_dp, &
             0.0001649202372588765_dp, 0.00033408963376083275_dp, 0.0006540375465176137_dp, &
             0.001243017515602559_dp, 0.002301784838692949_dp, 0.004165279337555477_dp, &
             0.0073836186025581195_dp, 0.012847561151804607_dp, 0.021980806472522638_dp, &
             0.037031915687568376_dp, 0.061513749884552535_dp, 0.10086076190661072_dp, &
             0.1634101460233071_dp, 0.2618786620996169_dp, 0.41565939025123094_dp, &
             0.6547056217611429_dp, 1.0272899267715916_dp, 1.6199898554700722_dp, &
             2.6290672484301876_dp, 4.791280175104064_dp]

      CASE (778)

         aw(:) = & ! a
            [2.1331448551822771e-07_dp, 1.3598455236373702e-06_dp, 4.712455049255939e-06_dp, &
             1.358923138754769e-05_dp, 3.5344829206273556e-05_dp, 8.526240947760915e-05_dp, &
             0.00019376961238278562_dp, 0.00041930195390112846_dp, 0.00087067515213978_dp, &
             0.0017451825269790492_dp, 0.0033922651238883997_dp, 0.006418150525220796_dp, &
             0.01185524278272199_dp, 0.021432598978481203_dp, 0.03800245231158692_dp, &
             0.0662051645142036_dp, 0.11349515567901422_dp, 0.19170919473803671_dp, &
             0.3194458205559337_dp, 0.5256606865849021_dp, 0.8551196101465752_dp, &
             1.3768549287486878_dp, 2.1981347341403645_dp, 3.4910495322750164_dp, &
             5.558213601175604_dp, 9.086331820346_dp, &
             ! w
             5.70641618758739e-07_dp, 1.9133732731057717e-06_dp, 5.314856848340553e-06_dp, &
             1.3602560595794284e-05_dp, 3.234090980634155e-05_dp, 7.236001203013158e-05_dp, &
             0.000154035080434313_dp, 0.0003145533052232731_dp, 0.0006200497020551953_dp, &
             0.0011855162537368045_dp, 0.002206947866273621_dp, 0.004012509785061605_dp, &
             0.007142933415833243_dp, 0.012476353250468444_dp, 0.021420069321076148_dp, &
             0.03620224262900055_dp, 0.0603118072107132_dp, 0.09915754900371249_dp, &
             0.16105323210691005_dp, 0.2587016001330439_dp, 0.41150205574261634_dp, &
             0.6494476549208797_dp, 1.020892402854168_dp, 1.6125224809282726_dp, &
             2.6206564269384836_dp, 4.781686937387278_dp]

      CASE (779)

         aw(:) = & ! a
            [1.6209697952431938e-07_dp, 1.0621207532674978e-06_dp, 3.8196403038495165e-06_dp, &
             1.1377044908742176e-05_dp, 3.035407021338941e-05_dp, 7.47136878588221e-05_dp, &
             0.00017259682600429232_dp, 0.00037859984505164506_dp, 0.0007952756107111344_dp, &
             0.0016099686831430103_dp, 0.0031567057394169093_dp, 0.006018397360265397_dp, &
             0.011192999370617062_dp, 0.020359878718521313_dp, 0.03630136651204807_dp, &
             0.06356213519623669_dp, 0.10946962130897177_dp, 0.18569824830714887_dp, &
             0.31064864885118676_dp, 0.5130504936656559_dp, 0.837435790235141_dp, &
             1.3526329915060715_dp, 2.165790757845518_dp, 3.449018426920561_dp, &
             5.505083896037599_dp, 9.020726506086614_dp, &
             ! w
             4.363663601255748e-07_dp, 1.53228932356218e-06_dp, 4.444927563068069e-06_dp, &
             1.1714959912480046e-05_dp, 2.845757318003008e-05_dp, 6.47558740625986e-05_dp, &
             0.00013976549835195825_dp, 0.00028874116660658553_dp, 0.0005748381707210744_dp, &
             0.0011085704019482992_dp, 0.002079370038052941_dp, 0.00380602720092813_dp, &
             0.006816237183809477_dp, 0.011970539851458245_dp, 0.020653298327029196_dp, &
             0.03506403608486011_dp, 0.05865795844322412_dp, 0.0968074771379298_dp, &
             0.15779286524713165_dp, 0.2542963296261624_dp, 0.4057251488289527_dp, &
             0.6421274079977688_dp, 1.0119714582931185_dp, 1.6020975259562231_dp, &
             2.60890723646412_dp, 4.768287623198237_dp]

      CASE (780)

         aw(:) = & ! a
            [1.2159442913104213e-07_dp, 8.243730182204329e-07_dp, 3.091676765701303e-06_dp, &
             9.531572935721358e-06_dp, 2.6108405278076098e-05_dp, 6.559538893843423e-05_dp, &
             0.00015405278147180495_dp, 0.00034255570175291975_dp, 0.0007278732562795857_dp, &
             0.0014881067872836008_dp, 0.0029428845606593017_dp, 0.005653230886874244_dp, &
             0.010584623121125201_dp, 0.019369386563771403_dp, 0.03472342134992166_dp, &
             0.061100129874337744_dp, 0.10570540127826548_dp, 0.18005771856776853_dp, &
             0.3023669316346305_dp, 0.501144015187033_dp, 0.8206936733885926_dp, &
             1.329644896459046_dp, 2.1350278995423517_dp, 3.408967849246569_dp, &
             5.4543813593328565_dp, 8.958046902931521_dp, &
             ! w
             3.3000837018863036e-07_dp, 1.2241351358880593e-06_dp, 3.7185437627628266e-06_dp, &
             1.0100606974943695e-05_dp, 2.5079067604936404e-05_dp, 5.80513034808428e-05_dp, &
             0.000127045158412295_dp, 0.0002655170011660814_dp, 0.0005338333043321268_dp, &
             0.0010382949937234127_dp, 0.0019621306562343024_dp, 0.003615229082370892_dp, &
             0.006512856391182795_dp, 0.011498709238735225_dp, 0.01993510486244627_dp, &
             0.03399392534961634_dp, 0.057097665976302565_dp, 0.09458324993504132_dp, &
             0.15469795948682544_dp, 0.25010322473547075_dp, 0.40021281493423944_dp, &
             0.6351270437338562_dp, 1.0034246567292198_dp, 1.592096297274434_dp, &
             2.5976276791918864_dp, 4.755425643242011_dp]

      CASE (781)

         aw(:) = & ! a
            [7.052975884312649e-08_dp, 5.197955677855847e-07_dp, 2.1276690374112563e-06_dp, &
             7.004433907177465e-06_dp, 2.0132835741658847e-05_dp, 5.2476952485410094e-05_dp, &
             0.00012689199981142868_dp, 0.00028897064246147426_dp, 0.0006263938324777338_dp, &
             0.0013026214844699955_dp, 0.0026143105547792767_dp, 0.00508734177304204_dp, &
             0.009634732952540989_dp, 0.017812413864436525_dp, 0.03222785254022472_dp, &
             0.0571847581607159_dp, 0.09968874160836598_dp, 0.1710001547350933_dp, &
             0.28901155294857744_dp, 0.4818683466151774_dp, 0.7934930317010055_dp, &
             1.2921764681762131_dp, 2.084744586227854_dp, 3.3433437135151185_dp, &
             5.3711390804443955_dp, 8.854986996732828_dp, &
             ! w
             1.9561193405027e-07_dp, 8.211326080308579e-07_dp, 2.722329317890698e-06_dp, &
             7.812623642594039e-06_dp, 2.0177918058892047e-05_dp, 4.81469185038245e-05_dp, &
             0.00010797283819659017_dp, 0.0002302580302968393_dp, 0.00047090901116113_dp, &
             0.0009294424341572963_dp, 0.0017790338160186688_dp, 0.0033150627005034804_dp, &
             0.006032423815980427_dp, 0.010747060733819303_dp, 0.018784772556782105_dp, &
             0.032271402281262886_dp, 0.05457462789889467_dp, 0.09097143674482834_dp, &
             0.14965271129052868_dp, 0.24324318676508597_dp, 0.39116500381675556_dp, &
             0.6236035183214605_dp, 0.9893214014091501_dp, 1.5755636315243469_dp, &
             2.5789644963330822_dp, 4.73414783068008_dp]

      CASE (782)

         aw(:) = & ! a
            [5.1912254806258856e-08_dp, 4.064298044289749e-07_dp, 1.754108690626556e-06_dp, &
             5.988375017342114e-06_dp, 1.7660392002570632e-05_dp, 4.6926305057114624e-05_dp, &
             0.00011519181314117514_dp, 0.0002655441644202491_dp, 0.0005814741123172845_dp, &
             0.001219638527807168_dp, 0.0024659474839121794_dp, 0.00482973871865107_dp, &
             0.009199197671456494_dp, 0.017093905302257184_dp, 0.031069490931963935_dp, &
             0.055357775373296086_dp, 0.09686776962063608_dp, 0.16673478703167277_dp, &
             0.2826970123716483_dp, 0.4727211648145708_dp, 0.7805418912730915_dp, &
             1.2742826268895935_dp, 2.0606665734772056_dp, 3.311847974107182_dp, &
             5.331113569377905_dp, 8.805363270581289_dp, &
             ! w
             1.4650135732549935e-07_dp, 6.671451570675598e-07_dp, 2.321073342098677e-06_dp, &
             6.8596035229181975e-06_dp, 1.8087820827534897e-05_dp, 4.3845772229369525e-05_dp, &
             9.956761668810095e-05_dp, 0.00021452752182226473_dp, 0.0004425410914476478_dp, &
             0.0008799233091916595_dp, 0.0016950768608085711_dp, 0.0031764546788083437_dp, &
             0.005809175795710938_dp, 0.010395799466371885_dp, 0.01824442637696643_dp, &
             0.03145847261894628_dp, 0.05337876156198433_dp, 0.08925271012636814_dp, &
             0.14724306915049712_dp, 0.2399557494148676_dp, 0.3868158574542994_dp, &
             0.6180492833977588_dp, 0.9825083162880089_dp, 1.5675635676961452_dp, &
             2.569925577614872_dp, 4.723844207232645_dp]

      CASE (783)

         aw(:) = & ! a
            [4.208569882627062e-08_dp, 3.457314509885065e-07_dp, 1.5488722536902445e-06_dp, &
             5.417942675409361e-06_dp, 1.624963127815529e-05_dp, 4.371951649112457e-05_dp, &
             0.00010836516024425826_dp, 0.0002517647716722562_dp, 0.0005548731198006199_dp, &
             0.001170212469173054_dp, 0.00237713718336983_dp, 0.0046748601241764325_dp, &
             0.008936322779653746_dp, 0.01665873098993253_dp, 0.030365722071732895_dp, &
             0.05424464408595678_dp, 0.09514460917677328_dp, 0.1641232208353827_dp, &
             0.27882250115931784_dp, 0.4670975787863619_dp, 0.772565451446009_dp, &
             1.263244285855089_dp, 2.0457921726220456_dp, 3.292367483805231_dp, &
             5.306332827678124_dp, 8.774617165689104_dp, &
             ! w
             1.205499917804331e-07_dp, 5.832343398605094e-07_dp, 2.0955623571610993e-06_dp, &
             6.313921164805509e-06_dp, 1.6875372279390854e-05_dp, 4.13256010622087e-05_dp, &
             9.460286095384661e-05_dp, 0.00020517350569730435_dp, 0.0004255763339626193_dp, &
             0.0008501642625591446_dp, 0.0016444056200206384_dp, 0.0030924821585722037_dp, &
             0.005673468154296855_dp, 0.010181624646802669_dp, 0.017914050513205427_dp, &
             0.030960182960912516_dp, 0.05264405649928463_dp, 0.08819453273453204_dp, &
             0.14575660929741757_dp, 0.23792414696099684_dp, 0.38412372964310065_dp, &
             0.6146062145487327_dp, 0.978279757373532_dp, 1.5625938599305607_dp, &
             2.564307883856202_dp, 4.717441017149218_dp]

      CASE (784)

         aw(:) = & ! a
            [3.596098619284216e-08_dp, 3.074731120664885e-07_dp, 1.4170469172369373e-06_dp, &
             5.046019234421252e-06_dp, 1.5319646787208583e-05_dp, 4.1587863609753575e-05_dp, &
             0.00010379727352356543_dp, 0.0002424950009272166_dp, 0.0005368975213073445_dp, &
             0.0011366851852783028_dp, 0.0023166953133367477_dp, 0.004569149287853463_dp, &
             0.00875644149255929_dp, 0.01636026865790445_dp, 0.029882055905283526_dp, &
             0.0534782249002233_dp, 0.09395617081720738_dp, 0.16231929459815117_dp, &
             0.2761424430009272_dp, 0.4632026656870715_dp, 0.7670344878695877_dp, &
             1.2555820952923231_dp, 2.0354575820580743_dp, 3.278821835460838_dp, &
             5.289090538849389_dp, 8.75321380519321_dp, &
             ! w
             1.0436269930271532e-07_dp, 5.296379626445037e-07_dp, 1.948422782434836e-06_dp, &
             5.953398109913807e-06_dp, 1.6067301184286198e-05_dp, 3.9634688369127006e-05_dp, &
             9.125382179028327e-05_dp, 0.0001988355585252619_dp, 0.0004140383710344944_dp, &
             0.0008298592025667272_dp, 0.0016097341693117417_dp, 0.0030348812273952334_dp, &
             0.00558017247924242_dp, 0.0100340901652149_dp, 0.017686058540336145_dp, &
             0.030615746220543045_dp, 0.05213543243522042_dp, 0.08746095529297568_dp, &
             0.1447248064447004_dp, 0.2365122818688088_dp, 0.38225082838017044_dp, &
             0.6122086132987152_dp, 0.9753328353500473_dp, 1.5591283926766577_dp, &
             2.5603893555790145_dp, 4.7129748111549175_dp]

      CASE (785)

         aw(:) = & ! a
            [2.8696648550828397e-08_dp, 2.615205495534795e-07_dp, 1.2555474964211257e-06_dp, &
             4.583490060110546e-06_dp, 1.4150516874439488e-05_dp, 3.8886103533575105e-05_dp, &
             9.797046053858556e-05_dp, 0.00023060866916394578_dp, 0.0005137476899219403_dp, &
             0.0010933475538228887_dp, 0.0022383184289575192_dp, 0.004431688365059123_dp, &
             0.008521956642064303_dp, 0.015970352164543313_dp, 0.029248938687012213_dp, &
             0.05247319548815225_dp, 0.09239520967289142_dp, 0.15994641805058724_dp, &
             0.27261234960576525_dp, 0.45806607711909814_dp, 0.7597321006855186_dp, &
             1.2454556701617865_dp, 2.0217870652719485_dp, 3.260890043369849_dp, &
             5.266250952792777_dp, 8.724849119816746_dp, &
             ! w
             8.514842125767189e-08_dp, 4.6433452833849786e-07_dp, 1.7653108380368226e-06_dp, &
             5.499213090653743e-06_dp, 1.5040568300805852e-05_dp, 3.747216759239332e-05_dp, &
             8.69483092306617e-05_dp, 0.0001906523567526129_dp, 0.0003990869500618729_dp, &
             0.000803464640920814_dp, 0.0015645417769315675_dp, 0.0029596208203120536_dp, &
             0.005458012570879126_dp, 0.009840538606075607_dp, 0.017386432662911767_dp, &
             0.03016237039977218_dp, 0.05146496663872449_dp, 0.08649266526856679_dp, &
             0.14336119680033282_dp, 0.23464428097593612_dp, 0.3797702952294165_dp, &
             0.609030255084238_dp, 0.9714232922916174_dp, 1.5545283268289154_dp, &
             2.555186349271952_dp, 4.7070448888563785_dp]

      CASE (786)

         aw(:) = & ! a
            [2.3055037366271908e-08_dp, 2.2524315032163081e-07_dp, 1.1250109310969348e-06_dp, &
             4.203214111811963e-06_dp, 1.317761524365091e-05_dp, 3.661742410741837e-05_dp, &
             9.304300021456431e-05_dp, 0.00022049937019305994_dp, 0.0004939651430452657_dp, &
             0.0010561643210257171_dp, 0.0021708382921015743_dp, 0.004312979713275232_dp, &
             0.008318917875782683_dp, 0.015631921370997275_dp, 0.0286982448022773_dp, &
             0.05159731927205979_dp, 0.09103245868669334_dp, 0.15787154071157386_dp, &
             0.2695210848474995_dp, 0.45356203334603384_dp, 0.7533212082709582_dp, &
             1.2365557978018051_dp, 2.0097607725344036_dp, 3.2451019728972086_dp, &
             5.246128345665338_dp, 8.699846097028562_dp, &
             ! w
             7.021058268659199e-08_dp, 4.118673016298507e-07_dp, 1.6146494462719496e-06_dp, &
             5.120413282241957e-06_dp, 1.4176126219971765e-05_dp, 3.56383432270676e-05_dp, &
             8.327626010540199e-05_dp, 0.00018364019629097647_dp, 0.000386224208480141_dp, &
             0.0007806799510242194_dp, 0.0015254144218179238_dp, 0.002894290355702903_dp, &
             0.005351723868468956_dp, 0.009671782079669023_dp, 0.017124697583850754_dp, &
             0.029765648532727274_dp, 0.05087736061187036_dp, 0.08564281703539799_dp, &
             0.14216279517834943_dp, 0.2330005949209192_dp, 0.37758520954061753_dp, &
             0.6062277044764331_dp, 0.9679731690831382_dp, 1.5504663513126933_dp, &
             2.550590484693577_dp, 4.7018072065809235_dp]

      CASE (787)

         aw(:) = & ! a
            [1.6950925300941922e-08_dp, 1.8512469702023082e-07_dp, 9.765948837475134e-07_dp, &
             3.762570822068381e-06_dp, 1.2035276919132553e-05_dp, 3.392743547937393e-05_dp, &
             8.715580480355002e-05_dp, 0.0002083466216701058_dp, 0.00047006246038659797_dp, &
             0.0010110429565318437_dp, 0.0020886480676058712_dp, 0.00416792578404592_dp, &
             0.008070110703677505_dp, 0.01521615022368248_dp, 0.028020163637497274_dp, &
             0.050516619758622934_dp, 0.08934789714247594_dp, 0.1553023354280069_dp, &
             0.2656874176626726_dp, 0.44796839837719643_dp, 0.7453491951934768_dp, &
             1.225475888063848_dp, 1.994773280523565_dp, 3.2254092151877547_dp, &
             5.221011220048849_dp, 8.668620569340153_dp, &
             ! w
             5.4019823518473496e-08_dp, 3.525903920767117e-07_dp, 1.4399367103706628e-06_dp, &
             4.674617165176197e-06_dp, 1.3148314237770694e-05_dp, 3.3440956246506917e-05_dp, &
             7.884900549956665e-05_dp, 0.00017514302608273168_dp, 0.00037057106886326626_dp, &
             0.0007528513867465941_dp, 0.0014774740912708991_dp, 0.002814022028611975_dp, &
             0.0052208088038653636_dp, 0.009463464159725534_dp, 0.016800955649814573_dp, &
             0.029274044503458354_dp, 0.05014800390154651_dp, 0.08458633970195358_dp, &
             0.14067091819215147_dp, 0.23095173902804203_dp, 0.3748582906825795_dp, &
             0.602726555350653_dp, 0.963659252649939_dp, 1.5453841081675022_dp, &
             2.5448382872983824_dp, 4.6952520673997595_dp]

      CASE (788)

         aw(:) = & ! a
            [1.6638079120434184e-08_dp, 1.8303560195222553e-07_dp, 9.687254852298032e-07_dp, &
             3.7389290792019776e-06_dp, 1.1973489220109e-05_dp, 3.3781069709670776e-05_dp, &
             8.68339986656858e-05_dp, 0.00020767987051717866_dp, 0.0004687470535353466_dp, &
             0.0010085534493369784_dp, 0.0020841033078915854_dp, 0.00415988949808476_dp, &
             0.008056302924136456_dp, 0.015193041898562215_dp, 0.027982425468244553_dp, &
             0.050456401034446936_dp, 0.08925392663621129_dp, 0.155158872857305_dp, &
             0.2654731527003931_dp, 0.4476555074111315_dp, 0.7449029267545827_dp, &
             1.224855217726335_dp, 1.9939332097233924_dp, 3.2243048377395063_dp, &
             5.2196020530995515_dp, 8.666868147708719_dp, &
             ! w
             5.318868744626686e-08_dp, 3.4945918122391136e-07_dp, 1.4305587424661624e-06_dp, &
             4.6504720775060675e-06_dp, 1.3092298484954104e-05_dp, 3.3320635920296754e-05_dp, &
             7.860568651872461e-05_dp, 0.00017467461085176437_dp, 0.0003697059802303021_dp, &
             0.0007513100691572613_dp, 0.0014748138594482874_dp, 0.0028095605349709373_dp, &
             0.0052135215681561615_dp, 0.009451853132067834_dp, 0.016782889801361688_dp, &
             0.029246581804004673_dp, 0.05010721933494469_dp, 0.0845272095628814_dp, &
             0.14058734964400246_dp, 0.23083688331264704_dp, 0.37470531773777044_dp, &
             0.6025300293209096_dp, 0.9634169796585248_dp, 1.545098576519601_dp, &
             2.5445150510338057_dp, 4.694883722789503_dp]

      CASE (789)

         aw(:) = & ! a
            [4.133114668827588e-05_dp, 0.00022288422647064897_dp, 0.0005722500412080675_dp, &
             0.0011365051344008781_dp, 0.0020024427143605157_dp, 0.003317529283367159_dp, &
             0.005315993003722334_dp, 0.008353073591163749_dp, 0.012955066872823568_dp, &
             0.0198935766090916_dp, 0.03029293738457279_dp, 0.04578283545975285_dp, &
             0.06871321925219903_dp, 0.1024553158776816_dp, 0.15182147045059854_dp, &
             0.22364855693380606_dp, 0.32760630033354343_dp, 0.47731544725862374_dp, &
             0.6918962569705502_dp, 0.9981265915587121_dp, 1.433499530894329_dp, &
             2.050709804377275_dp, 2.9246867888040753_dp, 4.164921201624245_dp, &
             5.9410346956099644_dp, 8.550348782636469_dp, 12.684884831267697_dp, &
             ! w
             0.00010663577847824833_dp, 0.0002600677285126925_dp, 0.0004462614740991329_dp, &
             0.0006963595781430342_dp, 0.001059665527236895_dp, 0.001608995574289536_dp, &
             0.0024463241525708797_dp, 0.0037143355279016365_dp, 0.005616489210303001_dp, &
             0.008445415779015034_dp, 0.012621394172473247_dp, 0.01874511978764135_dp, &
             0.027670626460677458_dp, 0.040606044213690164_dp, 0.05925246976764002_dp, &
             0.08599496648369329_dp, 0.12416524566715859_dp, 0.17840443722654367_dp, &
             0.2551703458356085_dp, 0.36346673323426393_dp, 0.5159498918773728_dp, &
             0.7307684564801469_dp, 1.0350565159676461_dp, 1.4727627382852992_dp, &
             2.126016463967528_dp, 3.191491831744027_dp, 5.4355002435163255_dp]

      CASE (790)

         aw(:) = & ! a
            [2.265199677518572e-05_dp, 0.00012276899544090978_dp, 0.0003183419308487753_dp, &
             0.0006423569924739833_dp, 0.0011572917670961626_dp, 0.0019709003624358437_dp, &
             0.0032563154740661536_dp, 0.0052807693555526536_dp, 0.008449529858618562_dp, &
             0.013371806281620383_dp, 0.02095712759715817_dp, 0.032554484153668795_dp, &
             0.05015179288902161_dp, 0.07666027133969103_dp, 0.11631783981237262_dp, &
             0.17525874343944897_dp, 0.2623146833760234_dp, 0.390138323022376_dp, &
             0.5767778193874423_dp, 0.8478916342891016_dp, 1.239903109976466_dp, &
             1.8046275240320706_dp, 2.6164751246680287_dp, 3.7849253510314402_dp, &
             5.480095553876378_dp, 7.999844070821326_dp, 12.034456801672523_dp, &
             ! w
             5.8508820083244256e-05_dp, 0.00014414371476422158_dp, 0.00025230438272487633_dp, &
             0.0004058732799564563_dp, 0.0006416322037341139_dp, 0.0010139785941349164_dp, &
             0.001600673042559488_dp, 0.002514700378198619_dp, 0.003922777968903744_dp, &
             0.006071085147745618_dp, 0.009321122344390921_dp, 0.014200250553697977_dp, &
             0.021472956898305726_dp, 0.03224097897434797_dp, 0.048083391826744905_dp, &
             0.07125193872093943_dp, 0.10494290980217887_dp, 0.15367615432779677_dp, &
             0.22382783186584307_dp, 0.32439554826773487_dp, 0.46814862907720634_dp, &
             0.6735087489637548_dp, 0.9680549833035281_dp, 1.3962844112141117_dp, &
             2.0407239117987688_dp, 3.0975076650112148_dp, 5.3274244904589585_dp]

      CASE (791)

         aw(:) = & ! a
            [1.5930005105884995e-05_dp, 8.663411175959597e-05_dp, 0.0002261837933722728_dp, &
             0.0004614286035206294_dp, 0.0008439518082670551_dp, 0.0014633743227644115_dp, &
             0.002464830928593016_dp, 0.004075124572650641_dp, 0.006643334297919195_dp, &
             0.010702033121911687_dp, 0.017057545864950126_dp, 0.02692160183418139_dp, &
             0.042102054413649725_dp, 0.06527754003404436_dp, 0.10039083939974913_dp, &
             0.15320935650564652_dp, 0.232120090055218_dp, 0.34925322966436173_dp, &
             0.5220677314182667_dp, 0.7755941878823863_dp, 1.145640874222958_dp, &
             1.6834993820955622_dp, 2.463247734197893_dp, 3.594319334805111_dp, &
             5.247091844654251_dp, 7.719762398705776_dp, 11.701828983405496_dp, &
             ! w
             4.1177814957352994e-05_dp, 0.00010215054011081087_dp, 0.00018125542596989232_dp, &
             0.0002976097990460291_dp, 0.0004820949764557738_dp, 0.0007805172353090585_dp, &
             0.0012595332509567295_dp, 0.002018233079954551_dp, 0.003205473162508219_dp, &
             0.005044159087528887_dp, 0.007865700792910102_dp, 0.012159223700477275_dp, &
             0.018641678072609098_dp, 0.028357239422026687_dp, 0.042817563296153396_dp, &
             0.06419888682736664_dp, 0.0956183006446552_dp, 0.1415211119286643_dp, &
             0.20822739362048467_dp, 0.30471744005396384_dp, 0.44380815317579525_dp, &
             0.6440603134910088_dp, 0.9332965752824595_dp, 1.356331750428908_dp, &
             1.9959513198168084_dp, 3.048068109993711_dp, 5.270645994332936_dp]

      CASE (792)

         aw(:) = & ! a
            [1.240889092145128e-05_dp, 6.76671091268666e-05_dp, 0.00017762160245782312_dp, &
             0.00036550248004403347_dp, 0.0006763538692074322_dp, 0.001188816546413399_dp, &
             0.0020310587228498335_dp, 0.0034053040718067177_dp, 0.005626177878735291_dp, &
             0.0091787448466855_dp, 0.014804637047488132_dp, 0.02362862298990212_dp, &
             0.03734331499822549_dp, 0.05847703452884025_dp, 0.09077998560884071_dp, &
             0.13977793255427248_dp, 0.21356213175752478_dp, 0.32391186013012424_dp, &
             0.48788615771042404_dp, 0.7300844292903402_dp, 1.0858865799076862_dp, &
             1.606212352488915_dp, 2.3648949144149687_dp, 3.4713195980057203_dp, &
             5.096034856403628_dp, 7.537483826966416_dp, 11.484690958024949_dp, &
             ! w
             3.209523556566068e-05_dp, 8.005307973745117e-05_dp, 0.00014357689284989373_dp, &
             0.0002394976888656755_dp, 0.0003950589838930408_dp, 0.0006508310711966158_dp, &
             0.0010667311727420943_dp, 0.0017332493022486793_dp, 0.0027879358542838_dp, &
             0.0044387353063556545_dp, 0.006997490531757815_dp, 0.010928201154780473_dp, &
             0.016916248555250018_dp, 0.02596715717716741_dp, 0.03954676484811979_dp, &
             0.0597792801010827_dp, 0.08972626093635792_dp, 0.13377939308098147_dp, &
             0.19821628079861398_dp, 0.2919998895221959_dp, 0.4279734467837606_dp, &
             0.6247874756186418_dp, 0.9104292207224619_dp, 1.3299354585510081_dp, &
             1.9662831184567857_dp, 3.0152638779267087_dp, 5.232999568682095_dp]

      CASE (793)

         aw(:) = & ! a
            [1.0223540928768244e-05_dp, 5.5876327283269576e-05_dp, 0.00014733957605593857_dp, &
             0.0003053918596320136_dp, 0.0005705924768091414_dp, 0.0010140142990323277_dp, &
             0.0017521274582417957_dp, 0.002970151217082029_dp, 0.00495870735070803_dp, &
             0.008169490356635136_dp, 0.013298325293877252_dp, 0.021407936085750322_dp, &
             0.034108116238316104_dp, 0.05381840802569134_dp, 0.08414870439032592_dp, &
             0.1304475271025096_dp, 0.2005877378754264_dp, 0.3060876737670577_dp, &
             0.4637068009925585_dp, 0.6977188845167406_dp, 1.043177174915754_dp, &
             1.5507141223286136_dp, 2.293969059792534_dp, 3.3822821296037353_dp, &
             4.986326271706307_dp, 7.404736942557135_dp, 11.32621477560715_dp, &
             ! w
             2.6456127295513986e-05_dp, 6.62889792871176e-05_dp, 0.00011996267680836016_dp, &
             0.00020272597601243074_dp, 0.0003392847646235578_dp, 0.0005665923061765598_dp, &
             0.0009399058016811227_dp, 0.0015436703493629995_dp, 0.0025073688411316026_dp, &
             0.00402816319932474_dp, 0.006403683131362698_dp, 0.010079542136917337_dp, &
             0.015717848121982025_dp, 0.024295409254463527_dp, 0.0372437371039372_dp, &
             0.0566476893397916_dp, 0.0855263277738046_dp, 0.12822961246401526_dp, &
             0.19100103793311565_dp, 0.2827876396394856_dp, 0.41644916662806325_dp, &
             0.610700804133677_dp, 0.8936525855943015_dp, 1.3105108102105707_dp, &
             1.9444042040818155_dp, 2.9910487933809717_dp, 5.205223868786751_dp]

      CASE (794)

         aw(:) = & ! a
            [8.727273674917548e-06_dp, 4.7792436114632105e-05_dp, 0.00012652378347591833_dp, &
             0.00026390047051243524_dp, 0.0004971583487991961_dp, 0.0008917450698057281_dp, &
             0.001555432572989849_dp, 0.002660754440823174_dp, 0.004480319340654578_dp, &
             0.007440616143799667_dp, 0.012202652833705552_dp, 0.019781715049912406_dp, &
             0.031723918509701556_dp, 0.050364715904059866_dp, 0.07920496621241908_dp, &
             0.12345474533656438_dp, 0.1908154389871886_dp, 0.29259941227369274_dp, &
             0.4453283336858533_dp, 0.6730158762720717_dp, 1.0104524774319095_dp, &
             1.5080371702737234_dp, 2.2392489882684807_dp, 3.313386474160821_dp, &
             4.9012191295438825_dp, 7.301539793246007_dp, 11.202810314075098_dp, &
             ! w
             2.2593943669260506e-05_dp, 5.683645477453563e-05_dp, 0.0001036613454234445_dp, &
             0.0001771360696133468_dp, 0.00030006391159141297_dp, 0.0005067076799329426_dp, &
             0.0008488470371810808_dp, 0.0014063541860811727_dp, 0.0023025418091215436_dp, &
             0.003726265079658037_dp, 0.005964138785013461_dp, 0.009447446330501801_dp, &
             0.014820052117746589_dp, 0.023036120406281942_dp, 0.03549992286424345_dp, &
             0.054264866181846255_dp, 0.08231575009495752_dp, 0.12396848107981792_dp, &
             0.1854380898065737_dp, 0.27565716822563574_dp, 0.407496608300226_dp, &
             0.5997213168950433_dp, 0.8805384358917568_dp, 1.2952907778060012_dp, &
             1.9272326688375536_dp, 2.9720291907799243_dp, 5.183415666643532_dp]

      CASE (795)

         aw(:) = & ! a
            [7.634695215101426e-06_dp, 4.18825900310198e-05_dp, 0.00011127155589772385_dp, &
             0.00023338846923811062_dp, 0.000442878044053161_dp, 0.0008007935114935354_dp, &
             0.0014081088941739503_dp, 0.002427412201719985_dp, 0.004117118046229363_dp, &
             0.006883746435844753_dp, 0.01136058020349976_dp, 0.01852494717865621_dp, &
             0.02987177824680481_dp, 0.04766863771121763_dp, 0.07532798299212069_dp, &
             0.11794717177489715_dp, 0.18308739394395435_dp, 0.28189189308881496_dp, &
             0.4306862020648562_dp, 0.6532684048738324_dp, 0.9842098231967747_dp, &
             1.4737133706638015_dp, 2.1951215282037992_dp, 3.257694636436478_dp, &
             4.832280258914759_dp, 7.217804103278141_dp, 11.102542953703383_dp, &
             ! w
             1.9773009620194447e-05_dp, 4.9916067561900825e-05_dp, 9.16728514439909e-05_dp, &
             0.00015818390169340446_dp, 0.0002707564834876735_dp, 0.000461551434310484_dp, &
             0.0007796197133890599_dp, 0.0013012040914587013_dp, 0.0021446785646228863_dp, &
             0.0034922118403545896_dp, 0.005621509848737885_dp, 0.008952212246681059_dp, &
             0.014113290945894693_dp, 0.022040336976209742_dp, 0.0341151650393001_dp, &
             0.05236510536911372_dp, 0.07974635467222059_dp, 0.12054611971679802_dp, &
             0.18095503549814676_dp, 0.26989258207035016_dp, 0.4002375169727702_dp, &
             0.5907946627938913_dp, 0.869850986907248_dp, 1.2828631790667058_dp, &
             1.9131925658213558_dp, 2.9564682389481747_dp, 5.165578431314193_dp]

      CASE (796)

         aw(:) = & ! a
            [6.799711235012341e-06_dp, 3.7361354633700115e-05_dp, 9.957947254448849e-05_dp, &
             0.0002099227073059153_dp, 0.00040094161028759475_dp, 0.0007301330868347708_dp, &
             0.0012929669202120357_dp, 0.002243954252451219_dp, 0.0038299313825976068_dp, &
             0.0064410546017474035_dp, 0.010687788549118879_dp, 0.017516094336635833_dp, &
             0.02837844324702902_dp, 0.04548587637015833_dp, 0.07217698601496424_dp, &
             0.1134546161511556_dp, 0.17676199097776782_dp, 0.2730995400527115_dp, &
             0.4186265473792023_dp, 0.6369576060949826_dp, 0.9624766463202936_dp, &
             1.4452177877127192_dp, 2.158404668439873_dp, 3.2112624524878743_dp, &
             4.774703705183174_dp, 7.1477688750728365_dp, 11.018586146362084_dp, &
             ! w
             1.7616646117932288e-05_dp, 4.461493874379961e-05_dp, 8.245248664300384e-05_dp, &
             0.00014351648725796493_dp, 0.00024789737902234326_dp, 0.00042605516793132347_dp, &
             0.0007248221610441795_dp, 0.0012174613056593114_dp, 0.002018264346258695_dp, &
             0.0033038475127682198_dp, 0.005344489195173677_dp, 0.008550083694002198_dp, &
             0.01353708991379313_dp, 0.02122543080342086_dp, 0.03297789647354285_dp, &
             0.050799622269392795_dp, 0.07762232191991819_dp, 0.11770844687256254_dp, &
             0.17722730637565837_dp, 0.26508641687843854_dp, 0.39417025816712203_dp, &
             0.583316698481399_dp, 0.8608801601929675_dp, 1.2724147545931694_dp, &
             1.9013749164935645_dp, 2.9433634809003704_dp, 5.1505602940292095_dp]

      CASE (797)

         aw(:) = & ! a
            [6.1395417881484415e-06_dp, 3.378330751979996e-05_dp, 9.030955268263924e-05_dp, &
             0.00019126343967728574_dp, 0.00036745700300121214_dp, 0.000673432056752497_dp, &
             0.0012000820294391706_dp, 0.0020951839599493162_dp, 0.0035958826736603193_dp, &
             0.006078582798442805_dp, 0.010134501349156695_dp, 0.016683048305770786_dp, &
             0.02714063496044963_dp, 0.0436701463813738_dp, 0.06954705096992769_dp, &
             0.10969317959060103_dp, 0.17145033759904488_dp, 0.26569579709253305_dp, &
             0.40844501522698434_dp, 0.6231532848612138_dp, 0.9440411837113356_dp, &
             1.4209948993777566_dp, 2.127132943760494_dp, 3.171647951945379_dp, &
             4.725507832636439_dp, 7.087853839608335_dp, 10.946691631028461_dp, &
             ! w
             1.591137768041326e-05_dp, 4.041483047325665e-05_dp, 7.512051138507467e-05_dp, &
             0.00013178708504117987_dp, 0.00022948982935111316_dp, 0.00039727576552600846_dp, &
             0.0006801247749489536_dp, 0.0011487909519981932_dp, 0.0019141097499693535_dp, &
             0.003147978035748912_dp, 0.005114339469158271_dp, 0.00821474908851756_dp, &
             0.013054922396612592_dp, 0.020541283992213315_dp, 0.03202017473589182_dp, &
             0.04947746291488608_dp, 0.07582350771117832_dp, 0.11529902939205904_dp, &
             0.17405441003731065_dp, 0.2609861860864805_dp, 0.38898308357892836_dp, &
             0.5769109678235358_dp, 0.8531824556277925_dp, 1.2634365984125957_dp, &
             1.8912101693813979_dp, 2.9320864250312906_dp, 5.137639333493501_dp]

      CASE (798)

         aw(:) = & ! a
            [5.603667028771084e-06_dp, 3.087640355676106e-05_dp, 8.276575797200318e-05_dp, &
             0.00017603762482989614_dp, 0.00034003045822112956_dp, 0.0006267796957423577_dp, &
             0.00112329481386439_dp, 0.0019716225618062015_dp, 0.0034006318025334974_dp, &
             0.005774942705550669_dp, 0.009669223839769881_dp, 0.01597998728856444_dp, &
             0.02609245562819452_dp, 0.04212774759630914_dp, 0.06730643643223058_dp, &
             0.10647971524037368_dp, 0.16690072741036277_dp, 0.2593387916882687_dp, &
             0.3996829422383991_dp, 0.6112480215113266_dp, 0.9281100739740955_dp, &
             1.4000237909644244_dp, 2.100013494392458_dp, 3.1372416013711932_dp, &
             4.682723964609551_dp, 7.035691606989607_dp, 10.884047055781624_dp, &
             ! w
             1.4526899396791722e-05_dp, 3.699892843585587e-05_dp, 6.913756455117421e-05_dp, &
             0.00012216632300348179_dp, 0.00021429669440599125_dp, 0.00037337750744536295_dp, &
             0.0006428098938279197_dp, 0.0010911941164545888_dp, 0.0018263843904255505_dp, &
             0.0030161932306861203_dp, 0.004919065493233738_dp, 0.007929296216031927_dp, &
             0.012643220556482752_dp, 0.019955442197383218_dp, 0.031197851672182128_dp, &
             0.04833933300292733_dp, 0.07427134369500363_dp, 0.11321526310864316_dp, &
             0.17130447153509062_dp, 0.2574253707582148_dp, 0.3844698762941206_dp, &
             0.5713280031973806_dp, 0.8464633891520393_dp, 1.2555902479324408_dp, &
             1.882319099902882_dp, 2.9222183918906004_dp, 5.126334767750104_dp]

      CASE (799)

         aw(:) = & ! a
            [3.07556759937867e-06_dp, 1.7120389080799702e-05_dp, 4.6853128112836807e-05_dp, &
             0.00010285090387188242_dp, 0.0002064251564884343_dp, 0.0003959434946189406_dp, &
             0.0007371624578557768_dp, 0.001340455688058299_dp, 0.002388384628065489_dp, &
             0.0041788443496681375_dp, 0.007191765955163697_dp, 0.012191217406834163_dp, &
             0.02038025663073623_dp, 0.033633774376380626_dp, 0.05484578928210916_dp, &
             0.08844357053828202_dp, 0.14114347983097553_dp, 0.2230554104887353_dp, &
             0.3492889284995764_dp, 0.5422841074022949_dp, 0.8352061696480149_dp, &
             1.276968415268258_dp, 1.9399768148925256_dp, 2.9331728491314037_dp, &
             4.427852418603856_dp, 6.7238232066155925_dp, 10.508444012839721_dp, &
             ! w
             7.990802942553031e-06_dp, 2.0773608757718692e-05_dp, 4.0379093148952514e-05_dp, &
             7.506951892876223e-05_dp, 0.0001383080586862562_dp, 0.00025140850434764015_dp, &
             0.0004489776719220188_dp, 0.0007873351786187929_dp, 0.0013570877229921278_dp, &
             0.0023021589521644795_dp, 0.0038485068239294635_dp, 0.006347110013377911_dp, &
             0.010337784120358736_dp, 0.016643193773484617_dp, 0.026506365965223846_dp, &
             0.04179053873944084_dp, 0.06526800790339253_dp, 0.10103603842558948_dp, &
             0.15511568011466423_dp, 0.23632081159919982_dp, 0.3575516109837995_dp, &
             0.5378371660619029_dp, 0.8059525909923124_dp, 1.208085676942769_dp, &
             1.8283301837108623_dp, 2.862212837539241_dp, 5.057632827916134_dp]

      CASE (800)

         aw(:) = & ! a
            [2.1673609335192107e-06_dp, 1.215224051225794e-05_dp, 3.374660631523813e-05_dp, &
             7.568699457885438e-05_dp, 0.00015570215911308465_dp, 0.0003060569597332415_dp, &
             0.0005829440518138641_dp, 0.0010822478805588526_dp, 0.00196496222304419_dp, &
             0.0034973790885279733_dp, 0.0061138619253917675_dp, 0.01051385631305701_dp, &
             0.017810334922367325_dp, 0.029754857523013108_dp, 0.04907586053909264_dp, &
             0.07998308288769955_dp, 0.12891418626142448_dp, 0.20563260607688139_dp, &
             0.32483332415567084_dp, 0.508484949133822_dp, 0.7892543212254228_dp, &
             1.2155853711805809_dp, 1.859528113177115_dp, 2.8298812799801762_dp, &
             4.298077884309647_dp, 6.56424790623646_dp, 10.315523815734926_dp, &
             ! w
             5.6399182085561305e-06_dp, 1.4875539568427877e-05_dp, 2.9706600466251618e-05_dp, &
             5.7042709795691895e-05_dp, 0.00010821411645355367_dp, 0.00020160556376608125_dp, &
             0.00036773763782613987_dp, 0.0006570506588635632_dp, 0.0011517408890466632_dp, &
             0.001983909900924021_dp, 0.003363214566695296_dp, 0.005618603943735307_dp, &
             0.009260765054366163_dp, 0.015074789762713156_dp, 0.02425664980358899_dp, &
             0.03861280525257212_dp, 0.060850405521274874_dp, 0.09499735173872459_dp, &
             0.14700970906083427_dp, 0.22565568898541846_dp, 0.3438316948268284_dp, &
             0.520633598989393_dp, 0.7849996799831586_dp, 1.1833765833329497_dp, &
             1.8001353196528784_dp, 2.830815316819402_dp, 5.0217109329159_dp]

      CASE (801)

         aw(:) = & ! a
            [1.691730705048351e-06_dp, 9.54071766830379e-06_dp, 2.6806041134225265e-05_dp, &
             6.113045145136684e-05_dp, 0.0001280997244778255_dp, 0.00025632773264514105_dp, &
             0.0004962458692015434_dp, 0.0009349135417337102_dp, 0.0017200427656529288_dp, &
             0.00309826726310608_dp, 0.005475344082345973_dp, 0.009509803511055041_dp, &
             0.016257124566554013_dp, 0.0273895590216702_dp, 0.045528294014298316_dp, &
             0.0747411835192999_dp, 0.12128285278497943_dp, 0.19468762759706384_dp, &
             0.30937437548335495_dp, 0.4869953114925414_dp, 0.7598799169444655_dp, &
             1.1761509244737791_dp, 1.807610521952662_dp, 2.7629522010321566_dp, &
             4.213695305352366_dp, 6.460190203652438_dp, 10.189442245039029_dp, &
             ! w
             4.407722571378931e-06_dp, 1.176115655626714e-05_dp, 2.39884409008301e-05_dp, &
             4.717891004010905e-05_dp, 9.138709728583761e-05_dp, 0.0001732345639523079_dp, &
             0.0003207228941348957_dp, 0.0005806111503735416_dp, 0.0010297763010637384_dp, &
             0.001792777731541497_dp, 0.0030687864783234832_dp, 0.005172467240627817_dp, &
             0.008595471468440743_dp, 0.014098145427171844_dp, 0.022845222442037023_dp, &
             0.036605148453676545_dp, 0.0580410333780952_dp, 0.09113331477230503_dp, &
             0.14179276505536956_dp, 0.21875441800278994_dp, 0.33490893200321337_dp, &
             0.5093937512720524_dp, 0.7712547059516909_dp, 1.1671134596324746_dp, &
             1.7815335816178006_dp, 2.810076525420082_dp, 4.997993167777528_dp]

      CASE (802)

         aw(:) = & ! a
            [1.3964676148401791e-06_dp, 7.914733199522862e-06_dp, 2.2459042745629518e-05_dp, &
             5.192676184508766e-05_dp, 0.00011043851426979227_dp, 0.00022411075108363782_dp, &
             0.0004394103291024476_dp, 0.0008372733563690645_dp, 0.0015561229648987992_dp, &
             0.0028287456266441343_dp, 0.00504061602155553_dp, 0.008821079052363718_dp, &
             0.015184370432406967_dp, 0.025745545690322027_dp, 0.043048050035191944_dp, &
             0.07105638251543377_dp, 0.11589119331008618_dp, 0.18691830015098546_dp, &
             0.2983524845018051_dp, 0.47161086678594194_dp, 0.73877075630945_dp, &
             1.1477129954359122_dp, 1.7700509507293882_dp, 2.71439494346417_dp, &
             4.152325422262254_dp, 6.384358529639266_dp, 10.097417649445605_dp, &
             ! w
             3.642289081161589e-06_dp, 9.815110147232306e-06_dp, 2.0373579861892006e-05_dp, &
             4.084095814010183e-05_dp, 8.040068758765127e-05_dp, 0.00015446011969151734_dp, &
             0.00028925627836834194_dp, 0.0005289433004641359_dp, 0.0009466080619320775_dp, &
             0.0016614027961660265_dp, 0.0028649367693126273_dp, 0.004861515254945349_dp, &
             0.008128908421998236_dp, 0.013409318745026535_dp, 0.021844447823907917_dp, &
             0.035174549175898254_dp, 0.056029854950862816_dp, 0.08835507587768701_dp, &
             0.1380264727693674_dp, 0.21375312503577767_dp, 0.32841975553615993_dp, &
             0.5011929946321245_dp, 0.7611975412622868_dp, 1.15518574690366_dp, &
             1.767867622333308_dp, 2.7948279390360464_dp, 4.980558958520095_dp]

      CASE (803)

         aw(:) = & ! a
            [1.1942234450519989e-06_dp, 6.798219946527863e-06_dp, 1.9459054656655945e-05_dp, &
             4.55242257725863e-05_dp, 9.803164701017266e-05_dp, 0.00020125084716356384_dp, &
             0.0003987014727301214_dp, 0.000766737481734197_dp, 0.0014367880712821733_dp, &
             0.002631155676368643_dp, 0.004719881066623696_dp, 0.008309996697234727_dp, &
             0.014384069954118965_dp, 0.024513058207663523_dp, 0.04118023330524608_dp, &
             0.06826979454430288_dp, 0.1117979189054743_dp, 0.18099853910797675_dp, &
             0.28992610432002736_dp, 0.4598123019397362_dp, 0.7225346404759638_dp, &
             1.1257812310755833_dp, 1.7410136867637176_dp, 2.676773715708587_dp, &
             4.104688097668651_dp, 6.325404890426148_dp, 10.025790179284742_dp, &
             ! w
             3.1177034786852475e-06_dp, 8.474775154204022e-06_dp, 1.7859243856699156e-05_dp, &
             3.637321832747758e-05_dp, 7.255733868504639e-05_dp, 0.00014091503560671306_dp, &
             0.00026635256685154994_dp, 0.0004910450960806109_dp, 0.0008851850047830547_dp, &
             0.001563775367008409_dp, 0.0027125966070728116_dp, 0.00462793382879038_dp, &
             0.0077767650188767514_dp, 0.012887127682260247_dp, 0.02108266638710988_dp, &
             0.03408143313603231_dp, 0.05448763969262228_dp, 0.0862175473337454_dp, &
             0.13511968719572154_dp, 0.2098818897227727_dp, 0.3233831950464604_dp, &
             0.4948122242697113_dp, 0.7533552427288275_dp, 1.1458680534841634_dp, &
             1.7571781838064222_dp, 2.7828929483013316_dp, 4.9669160397426655_dp]

      CASE (804)

         aw(:) = & ! a
            [1.0464712042947327e-06_dp, 5.980765144499402e-06_dp, 1.7252912521418522e-05_dp, &
             4.0783161490628e-05_dp, 8.876738629846045e-05_dp, 0.00018403740756034773_dp, &
             0.0003678080831135085_dp, 0.000712830378331724_dp, 0.0013450064289208113_dp, &
             0.002478316125274995_dp, 0.004470498011029695_dp, 0.007910732144522105_dp, &
             0.013756158386157673_dp, 0.023542208712553594_dp, 0.039703526423184164_dp, &
             0.06605922025338419_dp, 0.10854053067202926_dp, 0.17627385180523522_dp, &
             0.2831825041882665_dp, 0.4503460322167156_dp, 0.7094774230739503_dp, &
             1.1081053799498974_dp, 1.717565143051345_dp, 2.646340127338585_dp, &
             4.066093876570879_dp, 6.277583419982657_dp, 9.967632598319918_dp, &
             ! w
             2.734274551489556e-06_dp, 7.490860523813445e-06_dp, 1.599759316674891e-05_dp, &
             3.3027373538925784e-05_dp, 6.662155784032936e-05_dp, 0.0001305754517744195_dp, &
             0.0002487420572117283_dp, 0.0004617213609950396_dp, 0.0008373921287557189_dp, &
             0.001487428059682766_dp, 0.002592915139280559_dp, 0.0044436564421224_dp, &
             0.007497877837941563_dp, 0.012472090964712896_dp, 0.020475197790728546_dp, &
             0.03320705940605024_dp, 0.053250483139833285_dp, 0.08449821410559463_dp, &
             0.1327757008439797_dp, 0.20675283025921906_dp, 0.3193033205979091_dp, &
             0.4896331534634429_dp, 0.7469786775266661_dp, 1.138280811182018_dp, &
             1.7484648203675952_dp, 2.7731592386245523_dp, 4.9557911742029015_dp]

      CASE (805)

         aw(:) = & ! a
            [9.334940484340804e-07_dp, 5.354497799872867e-06_dp, 1.555605701411221e-05_dp, &
             3.711403620499326e-05_dp, 8.154528636899452e-05_dp, 0.00017052106298692595_dp, &
             0.0003433880813302074_dp, 0.0006699632905117456_dp, 0.001271628922970902_dp, &
             0.0023555330779712674_dp, 0.00426928090829956_dp, 0.0075873007430232705_dp, &
             0.01324565918686754_dp, 0.02275026452866146_dp, 0.03849524042073429_dp, &
             0.06424532184076445_dp, 0.10586062217346191_dp, 0.17237726034028275_dp, &
             0.2776082029524206_dp, 0.4425046157711749_dp, 0.6986402497193854_dp, &
             1.0934084035518217_dp, 1.6980363736627428_dp, 2.620956977737536_dp, &
             4.033863893529919_dp, 6.237606604502866_dp, 9.918976607722271_dp, &
             ! w
             2.440963409080761e-06_dp, 6.735292344884374e-06_dp, 1.4556990779779755e-05_dp, &
             3.0412437742943997e-05_dp, 6.194078700143371e-05_dp, 0.0001223622925883734_dp, &
             0.00023466745662608176_dp, 0.0004381604321687307_dp, 0.0007988099305001273_dp, &
             0.0014255320748368298_dp, 0.0024955126739356678_dp, 0.0042931535862008405_dp, &
             0.007269367128492974_dp, 0.012131006670921922_dp, 0.019974585716419146_dp, &
             0.0324846342799765_dp, 0.0522258613200382_dp, 0.0830710485959085_dp, &
             0.13082593709502557_dp, 0.20414491725289174_dp, 0.3158967544682297_dp, &
             0.48530159829683467_dp, 0.7416377516096644_dp, 1.1319181146456272_dp, &
             1.741151348786439_dp, 2.7649857955486956_dp, 4.946450781717605_dp]

      CASE (806)

         aw(:) = & ! a
            [8.441211641730451e-07_dp, 4.858207942250597e-06_dp, 1.4206528664414055e-05_dp, &
             3.417966429409421e-05_dp, 7.573188643794205e-05_dp, 0.0001595718551868552_dp, &
             0.00032349106371144484_dp, 0.0006348540020901873_dp, 0.0012112510891073285_dp, &
             0.002254080489963278_dp, 0.004102393417179351_dp, 0.007318131840783266_dp, &
             0.012819480113685465_dp, 0.02208723394180414_dp, 0.03748097367526316_dp, &
             0.06271898000087829_dp, 0.10360047076902992_dp, 0.16908411408601043_dp, &
             0.2728879977895823_dp, 0.4358526631543596_dp, 0.6894315779878049_dp, &
             1.0809007047240158_dp, 1.6813933600106372_dp, 2.5992977217281976_dp, &
             4.006332775717232_dp, 6.203428036405983_dp, 9.87734953214134_dp, &
             ! w
             2.208843275547235e-06_dp, 6.135260827516492e-06_dp, 1.340496256663769e-05_dp, &
             2.830282523663812e-05_dp, 5.8135050065726424e-05_dp, 0.00011564223621869513_dp, &
             0.00022309042213660292_dp, 0.0004186911465422955_dp, 0.0007667977662685246_dp, &
             0.0013739877507456377_dp, 0.002414130428439646_dp, 0.004167023204621714_dp, &
             0.007077328591464908_dp, 0.011843626812300917_dp, 0.019551794107026794_dp, &
             0.031873163586931284_dp, 0.051356822052345354_dp, 0.08185826147561384_dp, &
             0.12916607293781923_dp, 0.20192103328817493_dp, 0.31298730066731956_dp, &
             0.4815968788875952_dp, 0.7370639953435186_dp, 1.1264636930067569_dp, &
             1.7348771730028434_dp, 2.757971240663341_dp, 4.938435612332332_dp]

      CASE (807)

         aw(:) = & ! a
            [7.715351902207404e-07_dp, 4.454488657860146e-06_dp, 1.3105081443546808e-05_dp, &
             3.177251563809805e-05_dp, 7.093507588008882e-05_dp, 0.00015048606873562504_dp, &
             0.00030689522743429385_dp, 0.0006054352971308557_dp, 0.0011604522626860166_dp, &
             0.002168410367058879_dp, 0.003961001827656396_dp, 0.007089400993579225_dp, &
             0.012456337353068097_dp, 0.021520857873617932_dp, 0.036612567967373125_dp, &
             0.061409361772741256_dp, 0.10165741874646757_dp, 0.1662478270145436_dp, &
             0.268815734552769_dp, 0.43010478939785496_dp, 0.6814628764322307_dp, &
             1.0700626854907365_dp, 1.666954483379765_dp, 2.5804865543829907_dp, &
             3.98239954584697_dp, 6.173693340567358_dp, 9.841113471805645_dp, &
             ! w
             2.02025512306358e-06_dp, 5.646195978302999e-06_dp, 1.2459981376118931e-05_dp, &
             2.6558616120894655e-05_dp, 5.496677329540227e-05_dp, 0.00011001661381376335_dp, &
             0.0002133536129728687_dp, 0.00040225031783798357_dp, 0.0007396681720342874_dp, &
             0.0013301645286480231_dp, 0.0023447373376501383_dp, 0.0040591887385540365_dp, &
             0.006912746797741015_dp, 0.011596783031411219_dp, 0.019187885775472535_dp, &
             0.031345840306920725_dp, 0.05060603076581172_dp, 0.08080873986051144_dp, &
             0.127727410418948_dp, 0.19999069795789906_dp, 0.3104584670174118_dp, &
             0.4783728335700245_dp, 0.7330793153515601_dp, 1.121707471323126_dp, &
             1.7294025536587003_dp, 2.751848599129929_dp, 4.931440243933937_dp]

      CASE (808)

         aw(:) = & ! a
            [4.282997688066794e-07_dp, 2.5345161992402055e-06_dp, 7.804107618589548e-06_dp, &
             1.9977993343585435e-05_dp, 4.695744035623908e-05_dp, 0.00010419816341491701_dp, &
             0.00022088984011488607_dp, 0.00045064587806774786_dp, 0.0008895356267617178_dp, &
             0.0017059657107671494_dp, 0.0031894197252649243_dp, 0.005828823769633867_dp, &
             0.010436905268064723_dp, 0.018345184374114178_dp, 0.03170635866252156_dp, &
             0.053958479122247334_dp, 0.09053083668174715_dp, 0.14990832371153687_dp, &
             0.24522452570721986_dp, 0.39663337274530724_dp, 0.634835526371784_dp, &
             1.0063650387875287_dp, 1.581751822372174_dp, 2.4690851649384156_dp, &
             3.8402271206551823_dp, 5.9966110593710225_dp, 9.624893612606934_dp, &
             ! w
             1.1273646363230135e-06_dp, 3.30407491325403e-06_dp, 7.830421910507519e-06_dp, &
             1.7780384248535214e-05_dp, 3.865532573862084e-05_dp, 8.051945551775281e-05_dp, &
             0.0001615093363451519_dp, 0.0003135324773607453_dp, 0.0005915273858953615_dp, &
             0.001088311890188869_dp, 0.001958068346765551_dp, 0.0034530298414055904_dp, &
             0.0059801398994152625_dp, 0.010187650886489156_dp, 0.017096213065079784_dp, &
             0.028295565972774144_dp, 0.046237324565874476_dp, 0.07466791417101255_dp, &
             0.11926605834805211_dp, 0.18858268715811125_dp, 0.29544632977911794_dp, &
             0.45915514943809826_dp, 0.7092414841649864_dp, 1.0931683345070318_dp, &
             1.6964811418306054_dp, 2.7149901181714964_dp, 4.88934061869101_dp]

      CASE (809)

         aw(:) = & ! a
            [3.044077869225635e-07_dp, 1.8345797051288298e-06_dp, 5.8306518190610556e-06_dp, &
             1.5452902624503837e-05_dp, 3.746195190021638e-05_dp, 8.532865882390207e-05_dp, &
             0.00018492717447337773_dp, 0.00038447068756841023_dp, 0.0007714380154039876_dp, &
             0.0015008747152174746_dp, 0.0028419264854728896_dp, 0.0052532011229795865_dp, &
             0.009503152656455776_dp, 0.016859985737617073_dp, 0.029387797103631402_dp, &
             0.05040351645324855_dp, 0.08517511727583636_dp, 0.14197907169434135_dp, &
             0.23368954926580837_dp, 0.38015290552527153_dp, 0.611729093898482_dp, &
             0.9746121803917456_dp, 1.5390504533360434_dp, 2.4129869268184634_dp, &
             3.7683396667726585_dp, 5.906771478610304_dp, 9.514916534301372_dp, &
             ! w
             8.043791158110075e-07_dp, 2.4397787368067945e-06_dp, 6.054236773947436e-06_dp, &
             1.4267550169056792e-05_dp, 3.190457591131693e-05_dp, 6.798194633826852e-05_dp, &
             0.00013897861724333242_dp, 0.00027423236514752215_dp, 0.0005247921696292247_dp, &
             0.00097772032108461_dp, 0.0017788682611212536_dp, 0.0031686768506202726_dp, &
             0.005537784752788189_dp, 0.009512468968782824_dp, 0.016084612913245176_dp, &
             0.02680759793413749_dp, 0.04408911600333397_dp, 0.07162578735056811_dp, &
             0.11504524024551752_dp, 0.18285518937714626_dp, 0.28786426742283683_dp, &
             0.44939607977744067_dp, 0.6970778609773493_dp, 1.0785475713046209_dp, &
             1.6795664194936384_dp, 2.696024912444383_dp, 4.867686914030128_dp]

      CASE (810)

         aw(:) = & ! a
            [2.392806012063374e-07_dp, 1.4640669800963385e-06_dp, 4.77029549570211e-06_dp, &
             1.2971799915495292e-05_dp, 3.214975810349573e-05_dp, 7.458285899582335e-05_dp, &
             0.0001641313533637601_dp, 0.0003456955183275747_dp, 0.0007014385500812336_dp, &
             0.001378075285586933_dp, 0.002631983387012906_dp, 0.004902617785847488_dp, &
             0.008930302768378003_dp, 0.015942799349190424_dp, 0.027947325215813817_dp, &
             0.04818268331975345_dp, 0.08181231490338949_dp, 0.13697702864538128_dp, &
             0.22638136969925596_dp, 0.3696696252832951_dp, 0.5969767421433326_dp, &
             0.9542708407154293_dp, 1.511611335932235_dp, 2.3768408963523915_dp, &
             3.7219115701391203_dp, 5.848638064442507_dp, 9.443648530012794_dp, &
             ! w
             6.343440691502285e-07_dp, 1.978296825743782e-06_dp, 5.0801425036158145e-06_dp, &
             1.2289730260022029e-05_dp, 2.802660675530703e-05_dp, 6.0664864739766854e-05_dp, &
             0.00012565503531272474_dp, 0.0002507279450051139_dp, 0.00048448296908444144_dp, &
             0.000910333753249535_dp, 0.0016688182926602518_dp, 0.002992813546784709_dp, &
             0.005262443217918938_dp, 0.009089738617475543_dp, 0.015447838854484948_dp, &
             0.025866309579826947_dp, 0.04272390819565634_dp, 0.06968422652033_dp, &
             0.11234070289454058_dp, 0.1791716678399734_dp, 0.2829713527152451_dp, &
             0.4430786436162086_dp, 0.6891821372320907_dp, 1.0690350994295952_dp, &
             1.668543120096164_dp, 2.6836548658754666_dp, 4.853566250440072_dp]

      CASE (811)

         aw(:) = & ! a
            [1.9872290995100557e-07_dp, 1.2320479928210371e-06_dp, 4.098304154463825e-06_dp, &
             1.137482340280105e-05_dp, 2.8679349116364172e-05_dp, 6.747187816793742e-05_dp, &
             0.00015021843719519121_dp, 0.00031950970238100903_dp, 0.000653780674403012_dp, &
             0.001293872102374736_dp, 0.0024871155604689293_dp, 0.004659337070576442_dp, &
             0.0085307640725342_dp, 0.01530015616462431_dp, 0.026933802420064816_dp, &
             0.04661410282101341_dp, 0.07942879353027087_dp, 0.13342012741836712_dp, &
             0.22116903812549918_dp, 0.3621720802476913_dp, 0.5863991104964001_dp, &
             0.9396517597170191_dp, 1.491849410464224_dp, 2.3507592133887694_dp, &
             3.6883566201161844_dp, 5.806567956794808_dp, 9.39202130324481_dp, &
             ! w
             5.283353751060703e-07_dp, 1.6873028954141597e-06_dp, 4.452982770378373e-06_dp, &
             1.0991723602931945e-05_dp, 2.544492068026009e-05_dp, 5.573859282224164e-05_dp, &
             0.00011660074493091565_dp, 0.00023462701275100932_dp, 0.0004566776617926573_dp, &
             0.0008635640585389771_dp, 0.0015920184391628952_dp, 0.002869478656358298_dp, &
             0.005068479068145049_dp, 0.008790732002078987_dp, 0.014995750805662462_dp, &
             0.02519572629194617_dp, 0.04174822470849311_dp, 0.06829253924420949_dp, &
             0.11039680309103479_dp, 0.17651736754983788_dp, 0.279437266163447_dp, &
             0.43850583064257825_dp, 0.6834560157675487_dp, 1.0621255598884007_dp, &
             1.6605269303073051_dp, 2.6746540314901255_dp, 4.843293051470446_dp]

      CASE (812)

         aw(:) = & ! a
            [1.708663148980379e-07_dp, 1.0719407612707742e-06_dp, 3.629880565729153e-06_dp, &
             1.0247447633606835e-05_dp, 2.6200412588732798e-05_dp, 6.234120102184512e-05_dp, &
             0.00014009464704303065_dp, 0.0003003174052814775_dp, 0.0006186324716746418_dp, &
             0.0012314319838720523_dp, 0.0023791716502456874_dp, 0.004477284013418298_dp, &
             0.008230624112551932_dp, 0.014815705600642588_dp, 0.02616734026765008_dp, &
             0.04542444214765721_dp, 0.07761624061811427_dp, 0.13070864439986096_dp, &
             0.21718660976337473_dp, 0.3564317055692259_dp, 0.5782849494949315_dp, &
             0.9284176256739851_dp, 1.47663898094982_dp, 2.330656116732063_dp, &
             3.6624618440001444_dp, 5.7740696850698265_dp, 9.352110178540393_dp, &
             ! w
             4.554568714186842e-07_dp, 1.4853146580114608e-06_dp, 4.010109783706538e-06_dp, &
             1.0061276109700429e-05_dp, 2.357374234051719e-05_dp, 5.213699289131018e-05_dp, &
             0.00010993342107847236_dp, 0.00022269782569833403_dp, 0.0004359666166167894_dp, &
             0.0008285632929813975_dp, 0.0015343035723806068_dp, 0.002776444652921308_dp, &
             0.004921670982814177_dp, 0.008563719353161213_dp, 0.014651543788182222_dp, &
             0.024683833967299302_dp, 0.04100164172617943_dp, 0.06722526041781025_dp, &
             0.10890294768949611_dp, 0.17447365764087136_dp, 0.2767113164346024_dp, &
             0.434972958995465_dp, 0.6790257660043966_dp, 1.0567733191226292_dp, &
             1.6543120445112234_dp, 2.6676726498929257_dp, 4.8353256005667715_dp]

      CASE (813)

         aw(:) = & ! a
            [1.5046600842380787e-07_dp, 9.542091743770965e-07_dp, 3.282386897052522e-06_dp, &
             9.402124660146259e-06_dp, 2.4323478144930646e-05_dp, 5.842447532946064e-05_dp, &
             0.00013231283468887587_dp, 0.0002854785131857045_dp, 0.0005913199720108167_dp, &
             0.0011826986439803994_dp, 0.0022945971607639024_dp, 0.0043341531128298005_dp, &
             0.007993923204493958_dp, 0.014432583881101056_dp, 0.025559655102631463_dp, &
             0.04447904108994307_dp, 0.0761727790922896_dp, 0.12854508379167245_dp, &
             0.21400320755658808_dp, 0.35183544654773324_dp, 0.5717780879330294_dp, &
             0.9193961924705142_dp, 1.4644089308699892_dp, 2.314473872998031_dp, &
             3.6415973555746186_dp, 5.747863832738934_dp, 9.31990744402916_dp, &
             ! w
             4.020435349049668e-07_dp, 1.3360185007046638e-06_dp, 3.677937554062206e-06_dp, &
             9.354777083526352e-06_dp, 2.2140148908614583e-05_dp, 4.935819599174935e-05_dp, &
             0.00010475930715355836_dp, 0.0002133943822876141_dp, 0.00041974486395866855_dp, &
             0.0008010457006218791_dp, 0.0014887759343406993_dp, 0.0027028352627257233_dp, &
             0.004805199475603059_dp, 0.008383171971295142_dp, 0.01437717115673257_dp, &
             0.024274949643709864_dp, 0.04040415055730206_dp, 0.06636959953403641_dp, &
             0.10770331687412875_dp, 0.1728299588562054_dp, 0.2745158119623451_dp, &
             0.432123883647418_dp, 0.6754489227647645_dp, 1.0524479806828497_dp, &
             1.649286085341666_dp, 2.662024822646241_dp, 4.828880580255117_dp]

      CASE (814)

         aw(:) = & ! a
            [1.3483327719929097e-07_dp, 8.636623673712753e-07_dp, 3.013026640776208e-06_dp, &
             8.740768544062583e-06_dp, 2.2842797919313344e-05_dp, 5.531318070879643e-05_dp, &
             0.00012609546846510718_dp, 0.0002735647687929553_dp, 0.0005692993510592034_dp, &
             0.001143263875482272_dp, 0.0022259397121263524_dp, 0.004217627406270247_dp, &
             0.00780072652380558_dp, 0.014119154597089926_dp, 0.025061468426791706_dp, &
             0.04370250697165623_dp, 0.07498506712165497_dp, 0.1267619865516396_dp, &
             0.21137570939225736_dp, 0.34803661544585673_dp, 0.5663933525277494_dp, &
             0.9119219090702436_dp, 1.4542657015593066_dp, 2.301040356501029_dp, &
             3.6242631250794344_dp, 5.7260778508230965_dp, 9.29312278000876_dp, &
             ! w
             3.6108505326641745e-07_dp, 1.2206636594598906e-06_dp, 3.4179800936920884e-06_dp, &
             8.79610918590675e-06_dp, 2.0997982030650414e-05_dp, 4.713122236305409e-05_dp, &
             0.00010059249655814108_dp, 0.0002058711628328325_dp, 0.00040658022071106577_dp, &
             0.0007786439055636062_dp, 0.0014516091552813555_dp, 0.002642593964458383_dp, &
             0.004709665757474432_dp, 0.008234778512255804_dp, 0.01415124081315477_dp, &
             0.023937679004776856_dp, 0.039910526447777483_dp, 0.06566164979656054_dp, &
             0.10670942689099573_dp, 0.1714664426624184_dp, 0.27269242820113926_dp, &
             0.42975518987978567_dp, 0.6724723712141347_dp, 1.0488457304122376_dp, &
             1.645097944008935_dp, 2.6573170966013433_dp, 4.823508711705557_dp]

      CASE (815)

         aw(:) = & ! a
            [1.2244238590252792e-07_dp, 7.916553732779728e-07_dp, 2.797295392425009e-06_dp, &
             8.206737559771293e-06_dp, 2.163854105266043e-05_dp, 5.276758321201203e-05_dp, &
             0.00012098328108035421_dp, 0.0002637277506440087_dp, 0.0005510519884690576_dp, &
             0.0011104844409749947_dp, 0.0021687130694728117_dp, 0.004120265828114491_dp, &
             0.007638951954037942_dp, 0.013856187180338079_dp, 0.024642745114058458_dp, &
             0.04304877443075282_dp, 0.07398369418795818_dp, 0.12525658445561255_dp, &
             0.20915462117943184_dp, 0.34482164841651886_dp, 0.5618313659445509_dp, &
             0.9055834564062765_dp, 1.445656280064054_dp, 2.28962923681839_dp, &
             3.6095286193874356_dp, 5.7075490823946735_dp, 9.270333167914828_dp, &
             ! w
             3.2860085327856715e-07_dp, 1.128541850454422e-06_dp, 3.2080114878353213e-06_dp, &
             8.340817679428347e-06_dp, 2.0061146327110713e-05_dp, 4.529536944721871e-05_dp, &
             9.714319556288765e-05_dp, 0.00019962141911422605_dp, 0.0003956106141301545_dp, &
             0.0007599273953992115_dp, 0.0014204830296747515_dp, 0.0025920366672210413_dp, &
             0.004629336304109948_dp, 0.00810978571737166_dp, 0.013960636986767397_dp, &
             0.02365273068745493_dp, 0.03949292178335002_dp, 0.06506198367811626_dp, &
             0.10586658786156224_dp, 0.1703089189789739_dp, 0.2711429850192632_dp, &
             0.42774055306794734_dp, 0.6699387197252387_dp, 1.0457774484685272_dp, &
             1.6415288899622589_dp, 2.6533042648466525_dp, 4.818930022908951_dp]

      CASE (816)

         aw(:) = & ! a
            [1.1236083484313051e-07_dp, 7.328909531736803e-07_dp, 2.62009489348869e-06_dp, &
             7.764867659479818e-06_dp, 2.063575920856369e-05_dp, 5.0636754203679484e-05_dp, &
             0.00011668548489616494_dp, 0.0002554276253367132_dp, 0.0005356074653546425_dp, &
             0.0010826649055450436_dp, 0.002120030038940355_dp, 0.004037265202660264_dp, &
             0.0075007793354132145_dp, 0.013631203651731203_dp, 0.02428395192499402_dp, &
             0.04248782177814056_dp, 0.07312333577965469_dp, 0.12396164928213008_dp, &
             0.2072419840715197_dp, 0.34205038714986946_dp, 0.557895371990459_dp, &
             0.9001101548018628_dp, 1.4382163086880388_dp, 2.2797614573200717_dp, &
             3.596779537816259_dp, 5.691509413645565_dp, 9.250597946672741_dp, &
             ! w
             3.021567212669974e-07_dp, 1.0530708400970992e-06_dp, 3.0342324625713977e-06_dp, &
             7.96103199823831e-06_dp, 1.9275266697830992e-05_dp, 4.374854303521141e-05_dp, &
             9.422638341582306e-05_dp, 0.00019432024327497953_dp, 0.0003862812771383207_dp, &
             0.0007439726118163856_dp, 0.0013938952501706453_dp, 0.002548771646479404_dp, &
             0.004560479797197636_dp, 0.00800248421553169_dp, 0.013796787031162794_dp, &
             0.02340747128432762_dp, 0.039133067219051576_dp, 0.06454469181817421_dp, &
             0.10513880558145955_dp, 0.16930849011625215_dp, 0.26980268817526193_dp, &
             0.42599650407617173_dp, 0.6677438591497824_dp, 1.0431179254762268_dp, &
             1.6384340141027387_dp, 2.6498238231617117_dp, 4.81495898517923_dp]

      CASE (817)

         aw(:) = & ! a
            [6.439693341715039e-08_dp, 4.502819297916944e-07_dp, 1.7482289018145977e-06_dp, &
             5.53670926896511e-06_dp, 1.547280917746472e-05_dp, 3.947823696344194e-05_dp, &
             9.386249835099445e-05_dp, 0.000210830651240247_dp, 0.00045178774147190497_dp, &
             0.0009303673560010658_dp, 0.0018514771580851032_dp, 0.0035763009582114973_dp, &
             0.006728754373286237_dp, 0.012367272315853876_dp, 0.022258325510475113_dp, &
             0.03930660181991045_dp, 0.06822403817692177_dp, 0.11655974256953242_dp, &
             0.1962711661218106_dp, 0.3261034969387611_dp, 0.5351792658275734_dp, &
             0.8684362472695254_dp, 1.3950558834185884_dp, 2.222392532587447_dp, &
             3.5225211903063993_dp, 5.597942744224213_dp, 9.135340584239298_dp, &
             ! w
             1.7612730922301005e-07_dp, 6.850472968731309e-07_dp, 2.157059548465582e-06_dp, &
             5.994847488728639e-06_dp, 1.5132238090479849e-05_dp, 3.547726848834456e-05_dp, &
             7.844604663600577e-05_dp, 0.00016535511280926297_dp, 0.0003348701672504547_dp, &
             0.0006553927766784215_dp, 0.001245305119248374_dp, 0.00230554962030188_dp, &
             0.004171331845030701_dp, 0.007393136947647742_dp, 0.01286221703738584_dp, &
             0.022002911822893913_dp, 0.037064577553237055_dp, 0.061561006228935934_dp, &
             0.10092764698021395_dp, 0.1635026001105081_dp, 0.2620031614990439_dp, &
             0.4158221528766768_dp, 0.6549113061391172_dp, 1.0275400176778966_dp, &
             1.6202816220933072_dp, 2.62939579200687_dp, 4.79165492595066_dp]

      CASE (818)

         aw(:) = & ! a
            [4.692145622912571e-08_dp, 3.453726723137099e-07_dp, 1.4120419658352095e-06_dp, &
             4.644659065216893e-06_dp, 1.3342153037171206e-05_dp, 3.4761117866121466e-05_dp, &
             8.402438233137593e-05_dp, 0.00019129325375463404_dp, 0.0004145616772277768_dp, &
             0.0008619287326724236_dp, 0.0017295529763624714_dp, 0.0033651217300925706_dp, &
             0.0063722155908638835_dp, 0.01177933576631991_dp, 0.02130991999737814_dp, &
             0.0378083100384182_dp, 0.06590408267384229_dp, 0.11303736863200164_dp, &
             0.19102669703365602_dp, 0.3184484077141203_dp, 0.5242328503414031_dp, &
             0.8531197161722289_dp, 1.374118625810681_dp, 2.194484447273052_dp, &
             3.486309919495051_dp, 5.552226517971586_dp, 9.078942675712826_dp, &
             ! w
             1.3009025718548029e-07_dp, 5.451311569451456e-07_dp, 1.805287286636814e-06_dp, &
             5.177331270434758e-06_dp, 1.3365177498646305e-05_dp, 3.187908771076395e-05_dp, &
             7.14699447019722e-05_dp, 0.00015237652289038387_dp, 0.00031156693651894995_dp, &
             0.0006148379670237801_dp, 0.001176673973986873_dp, 0.002192327312638174_dp, &
             0.003988904463008586_dp, 0.007105667338441195_dp, 0.012418770683599542_dp, &
             0.0213329383455694_dp, 0.03607312097482517_dp, 0.06012447964156094_dp, &
             0.09889174257967095_dp, 0.16068495436194105_dp, 0.25820460645737253_dp, &
             0.4108510425715523_dp, 0.6486235337002515_dp, 1.0198889019105355_dp, &
             1.6113505071374186_dp, 2.6193359980392366_dp, 4.780180966203478_dp]

      CASE (819)

         aw(:) = & ! a
            [3.769025339720575e-08_dp, 2.892293662887212e-07_dp, 1.2275616354232278e-06_dp, &
             4.143923800207455e-06_dp, 1.2124950008347731e-05_dp, 3.2029192476915924e-05_dp, &
             7.826379843796882e-05_dp, 0.0001797496325970079_dp, 0.00039239902316021494_dp, &
             0.0008209176117875542_dp, 0.001656077005404812_dp, 0.003237223335389175_dp, &
             0.006155326859559991_dp, 0.011420268223210758_dp, 0.020728638895969025_dp, &
             0.036887031659902474_dp, 0.0644733710392377_dp, 0.11085927201776558_dp, &
             0.1877757047257223_dp, 0.31369231695675587_dp, 0.5174176872289247_dp, &
             0.8435655874175582_dp, 1.3610359192316241_dp, 2.177019387180813_dp, &
             3.463619038073598_dp, 5.523549121267125_dp, 9.04353624914506_dp, &
             ! w
             1.0573738585540205e-07_dp, 4.690145806438172e-07_dp, 1.6076130131872165e-06_dp, &
             4.7084240586299786e-06_dp, 1.2336949577033776e-05_dp, 2.97619620671435e-05_dp, &
             6.732817995011226e-05_dp, 0.00014461298568028174_dp, 0.0002975380330592539_dp, &
             0.0005902879414245153_dp, 0.0011349258369968832_dp, 0.0021231577679816913_dp, &
             0.0038770268380961077_dp, 0.006928757867333576_dp, 0.012145012359387941_dp, &
             0.020918144424417976_dp, 0.03545766845761392_dp, 0.05923057540951733_dp, &
             0.09762201262557958_dp, 0.1589240170757832_dp, 0.2558260746622655_dp, &
             0.4077328490421953_dp, 0.6446733326221191_dp, 1.01507598040183_dp, &
             1.6057270693344223_dp, 2.6129987726487443_dp, 4.772953585782717_dp]

      CASE (820)

         aw(:) = & ! a
            [3.192688511226688e-08_dp, 2.5381515538577897e-07_dp, 1.108986911961877e-06_dp, &
             3.8168657094130495e-06_dp, 1.1320216847351783e-05_dp, 3.0206065300549993e-05_dp, &
             7.439080500091955e-05_dp, 0.00017194106197723167_dp, 0.0003773304168625865_dp, &
             0.0007929116378581136_dp, 0.0016057107721317047_dp, 0.0031492597498130478_dp, &
             0.006005718908476013_dp, 0.01117193311394401_dp, 0.020325663351667567_dp, &
             0.03624697696426884_dp, 0.06347744157648616_dp, 0.1093403658603171_dp, &
             0.18550488617051494_dp, 0.31036517774846006_dp, 0.5126435227116273_dp, &
             0.8368642656986087_dp, 1.3518491553949243_dp, 2.164742896560698_dp, &
             3.447655400232127_dp, 5.50335958744786_dp, 9.018596028920532_dp, &
             ! w
             9.051900758375318e-08_dp, 4.203887118531679e-07_dp, 1.4784016574047624e-06_dp, &
             4.397599618263773e-06_dp, 1.164865445535051e-05_dp, 2.8334024418389487e-05_dp, &
             6.451762027438563e-05_dp, 0.00013931799719955234_dp, 0.0002879286642202782_dp, &
             0.0005734094505042307_dp, 0.0011061300978658056_dp, 0.002075310889819803_dp, &
             0.003799438502918505_dp, 0.0068057853417516695_dp, 0.011954319281190876_dp, &
             0.02062865619967732_dp, 0.03502738454414652_dp, 0.058604605623970504_dp, &
             0.0967315367741743_dp, 0.15768734573052112_dp, 0.2541535518492713_dp, &
             0.4055376711363269_dp, 0.6418895697728475_dp, 1.0116813328986147_dp, &
             1.6017582471360277_dp, 2.6085247198738886_dp, 4.767851415182237_dp]

      CASE (821)

         aw(:) = & ! a
            [2.506231356064682e-08_dp, 2.1113777525198703e-07_dp, 9.631716903097764e-07_dp, &
             3.407993565741137e-06_dp, 1.0301817554137037e-05_dp, 2.7877267164845783e-05_dp, &
             6.940690332605619e-05_dp, 0.00016183191675560055_dp, 0.0003577235548645196_dp, &
             0.0007563138536316547_dp, 0.0015396472707742605_dp, 0.003033503861178697_dp, &
             0.005808271877715008_dp, 0.010843341955159265_dp, 0.01979121468863471_dp, &
             0.03539631206039053_dp, 0.06215126305945643_dp, 0.10731424798130924_dp, &
             0.18247090314363906_dp, 0.3059133185528314_dp, 0.5062468435108554_dp, &
             0.8278743955344539_dp, 1.3395112993009697_dp, 2.148239229000104_dp, &
             3.4261768105937573_dp, 5.476176477499033_dp, 8.984999125160064_dp, &
             ! w
             7.237677372735283e-08_dp, 3.609608852035123e-07_dp, 1.316742490004197e-06_dp, &
             4.003257285933263e-06_dp, 1.0766846352372117e-05_dp, 2.649085541623535e-05_dp, &
             6.0867829164729415e-05_dp, 0.00013240747364775282_dp, 0.00027533418133416564_dp, &
             0.0005512068025827516_dp, 0.0010681299869222435_dp, 0.0020119917780688362_dp, &
             0.0036965016864726357_dp, 0.0066422670774409385_dp, 0.0117002308706876_dp, &
             0.020242205558766137_dp, 0.03445199249647781_dp, 0.05776621053751845_dp, &
             0.0955371316573405_dp, 0.1560263441077744_dp, 0.2519043522986348_dp, &
             0.4025822610720924_dp, 0.638137969771434_dp, 1.0071026176143199_dp, &
             1.5964017770696073_dp, 2.602484432456299_dp, 4.760963550075687_dp]

      CASE (822)

         aw(:) = & ! a
            [1.9657634446563594e-08_dp, 1.7700877117699972e-07_dp, 8.436085924054425e-07_dp, &
             3.066197163932294e-06_dp, 9.43846448130806e-06_dp, 2.5881981725346932e-05_dp, &
             6.510097076310213e-05_dp, 0.00015303844387372722_dp, 0.0003405716397025741_dp, &
             0.0007241439465780422_dp, 0.0014813346880753638_dp, 0.0029309567299341845_dp, &
             0.005632791790008266_dp, 0.010550468959010304_dp, 0.019313630762516264_dp, &
             0.03463438117209301_dp, 0.06096089704944261_dp, 0.1054920956922182_dp, &
             0.17973749918952178_dp, 0.3018959738693043_dp, 0.5004658785371005_dp, &
             0.8197387740111778_dp, 1.3283320795922557_dp, 2.1332690916641397_dp, &
             3.4066758177063945_dp, 5.451477451164133_dp, 8.954454893740664_dp, &
             ! w
             5.807796213947274e-08_dp, 3.1257763684768025e-07_dp, 1.1814849204825377e-06_dp, &
             3.668034015752292e-06_dp, 1.000887614257514e-05_dp, 2.4893043706635218e-05_dp, &
             5.7682323503348534e-05_dp, 0.00012634209100652221_dp, 0.00026422745677494324_dp, &
             0.0005315469486941688_dp, 0.0010343620807832697_dp, 0.001955547967111518_dp, &
             0.0036044850072998384_dp, 0.006495727881305546_dp, 0.01147200712260352_dp, &
             0.019894372755884956_dp, 0.033933114546447915_dp, 0.057008838839305874_dp, &
             0.094456413106498_dp, 0.15452119924401148_dp, 0.24986340186171588_dp, &
             0.3998971307163926_dp, 0.6347256815232175_dp, 1.0029341600492385_dp, &
             1.591521926539097_dp, 2.596979655447138_dp, 4.754686758063712_dp]

      CASE (823)

         aw(:) = & ! a
            [1.3077493553669045e-08_dp, 1.3446428461721632e-07_dp, 6.894775445454599e-07_dp, &
             2.614771927043685e-06_dp, 8.278412819111448e-06_dp, 2.3166284975862367e-05_dp, &
             5.918104565603476e-05_dp, 0.00014084993201930442_dp, 0.00031663592227642397_dp, &
             0.0006789915688675132_dp, 0.0013990828051893673_dp, 0.0027856827527221305_dp, &
             0.00538324428105995_dp, 0.010132556783363701_dp, 0.01863005822568714_dp, &
             0.03354079810465206_dp, 0.059248090669115176_dp, 0.10286419746112514_dp, &
             0.175787113058364_dp, 0.29607881519989404_dp, 0.4920801981687992_dp, &
             0.8079184922400721_dp, 1.312066104038825_dp, 2.1114591846486728_dp, &
             3.378233572831204_dp, 5.415421552586376_dp, 8.909835894750403_dp, &
             ! w
             4.064100105566295e-08_dp, 2.5073515305060495e-07_dp, 1.0026614671897668e-06_dp, &
             3.2161935234769364e-06_dp, 8.973372235973011e-06_dp, 2.2687699878913255e-05_dp, &
             5.324951565336133e-05_dp, 0.0001178448071382357_dp, 0.00024857907404769936_dp, &
             0.0005037129306199607_dp, 0.0009863512624435078_dp, 0.0018749966254274046_dp, &
             0.0034727302074631277_dp, 0.006285277663788842_dp, 0.011143361160208523_dp, &
             0.019392255752118715_dp, 0.033182397498854106_dp, 0.05591079878196936_dp, &
             0.09288659185447329_dp, 0.15233101253679696_dp, 0.24688872314683835_dp, &
             0.39597777284640007_dp, 0.6297383942856121_dp, 0.9968350013211065_dp, &
             1.5843761176989153_dp, 2.588915338343739_dp, 4.745492178729012_dp]

      CASE (824)

         aw(:) = & ! a
            [1.1168676780778662e-08_dp, 1.2180640938260491e-07_dp, 6.42168305551965e-07_dp, &
             2.4732613601403548e-06_dp, 7.909425136687957e-06_dp, 2.2293132150776055e-05_dp, &
             5.726170006022515e-05_dp, 0.00013687153406210996_dp, 0.0003087795790773896_dp, &
             0.0006641014961387852_dp, 0.0013718484409475933_dp, 0.0027374115157595986_dp, &
             0.0053000676633829236_dp, 0.009992877648448003_dp, 0.018401021216170845_dp, &
             0.033173564254514905_dp, 0.058671749775199934_dp, 0.10197830271938904_dp, &
             0.17445314028708012_dp, 0.2941114245403274_dp, 0.48924009838623994_dp, &
             0.8039099679980727_dp, 1.3065435035515134_dp, 2.104046661822854_dp, &
             3.368558366679237_dp, 5.403147594518706_dp, 8.894638694743145_dp, &
             ! w
             3.5571636295387056e-08_dp, 2.31885701828602e-07_dp, 9.465595172037144e-07_dp, &
             3.072114962558827e-06_dp, 8.639440026864074e-06_dp, 2.1970436349182598e-05_dp, &
             5.1798036627847485e-05_dp, 0.0001150470429434874_dp, 0.00024340284217001595_dp, &
             0.0004944693115174225_dp, 0.0009703519870024377_dp, 0.0018480720795338971_dp, &
             0.0034285721559179512_dp, 0.006214574348251618_dp, 0.011032707828043933_dp, &
             0.019222860545356376_dp, 0.0329286751042282_dp, 0.05553907272594601_dp, &
             0.09235433563597871_dp, 0.15158736673964276_dp, 0.24587739838392697_dp, &
             0.3946436974261759_dp, 0.6280390312929831_dp, 0.9947549539603935_dp, &
             1.5819375458963196_dp, 2.5861623872104706_dp, 4.742353579150264_dp]

      CASE (825)

         aw(:) = & ! a
            [1.0922730895902452e-08_dp, 1.2016102516355542e-07_dp, 6.359585057110366e-07_dp, &
             2.454569217019536e-06_dp, 7.860474879922026e-06_dp, 2.2176931492332475e-05_dp, &
             5.700564421868153e-05_dp, 0.0001363397401881642_dp, 0.00030772771266482525_dp, &
             0.0006621051667921726_dp, 0.0013681927984210268_dp, 0.0027309254735746026_dp, &
             0.0052888814206166895_dp, 0.009974077440709614_dp, 0.018370171673379145_dp, &
             0.033124068583551186_dp, 0.05859402503065693_dp, 0.10185876781344852_dp, &
             0.1742730574112346_dp, 0.2938457126503781_dp, 0.4888563624925515_dp, &
             0.8033681592277302_dp, 1.3057967934848087_dp, 2.103044115506054_dp, &
             3.367249456232268_dp, 5.401486766267579_dp, 8.892581990434447_dp, &
             ! w
             3.4917836241702025e-08_dp, 2.2941642585284216e-07_dp, 9.391473806911131e-07_dp, &
             3.0529880030367227e-06_dp, 8.594961885280855e-06_dp, 2.187466137505282e-05_dp, &
             5.16038403352657e-05_dp, 0.00011467212020671116_dp, 0.00024270824710016293_dp, &
             0.0004932274820766183_dp, 0.000968200417363755_dp, 0.0018444481009988747_dp, &
             0.003422623944082986_dp, 0.006205043746542174_dp, 0.01101778264918649_dp, &
             0.01919999899424585_dp, 0.032894414774324136_dp, 0.05548885404115657_dp, &
             0.09228239800037577_dp, 0.1514868173024687_dp, 0.24574060407320872_dp, &
             0.3944631850526886_dp, 0.6278090221906757_dp, 0.9944733474269393_dp, &
             1.5816073386937182_dp, 2.58578957328932_dp, 4.741928546959684_dp]

      CASE (826)

         aw(:) = & ! a
            [1.7269308367952925e-08_dp, 1.4409917834746486e-07_dp, 6.529178049482427e-07_dp, &
             2.3003976110457863e-06_dp, 6.9335280303051496e-06_dp, 1.872244518172413e-05_dp, &
             4.6536901677980466e-05_dp, 0.00010836353287044556_dp, 0.00023927174031028936_dp, &
             0.0005054117792115246_dp, 0.0010280658785693684_dp, 0.0020241623971503264_dp, &
             0.003873331220201111_dp, 0.007227148098818627_dp, 0.01318458630956751_dp, &
             0.023570158372693398_dp, 0.041369635210886456_dp, 0.07140521350827259_dp, &
             0.12137137993196333_dp, 0.2034102602720391_dp, 0.33649068642728003_dp, &
             0.5499887380182457_dp, 0.8891023139229457_dp, 1.423237033551061_dp, &
             2.2598751952697516_dp, 3.571065635766467_dp, 5.659137075269493_dp, &
             9.210746809665743_dp, &
             ! w
             4.971556930715025e-08_dp, 2.4512493877760624e-07_dp, 8.891604477379925e-07_dp, &
             2.694261409494383e-06_dp, 7.229461600687299e-06_dp, 1.7756493210436763e-05_dp, &
             4.074312476992274e-05_dp, 8.853098139463149e-05_dp, 0.00018392439212625014_dp, &
             0.0003679174154176068_dp, 0.0007124640923785046_dp, 0.001341235454485254_dp, &
             0.0024628585175915647_dp, 0.004423429117921111_dp, 0.007788460877492792_dp, &
             0.013469340669403152_dp, 0.02291646325370977_dp, 0.03841146380316371_dp, &
             0.06350581851904569_dp, 0.10367515954543258_dp, 0.16729391138716596_dp, &
             0.2671004770572327_dp, 0.42247643359100207_dp, 0.6633096115860233_dp, &
             1.0377405893818756_dp, 1.6321727347271557_dp, 2.642780361790678_dp, &
             4.806923220998057_dp]

      CASE (827)

         aw(:) = & ! a
            [1.0895118188773762e-08_dp, 1.0361461369511614e-07_dp, 5.099387053585073e-07_dp, &
             1.8889980533211041e-06_dp, 5.88889989698775e-06_dp, 1.6297328885123057e-05_dp, &
             4.128203713269053e-05_dp, 9.759101349023368e-05_dp, 0.0002181813642563272_dp, &
             0.00046570807815313593_dp, 0.0009558250785549132_dp, 0.0018966229932148376_dp, &
             0.0036541807006673865_dp, 0.006859768638436293_dp, 0.012582620547436744_dp, &
             0.022604694878683863_dp, 0.03985234994690154_dp, 0.06906703563584927_dp, &
             0.11783683036588014_dp, 0.19816876208730336_dp, 0.32886814809215037_dp, &
             0.5391258007622018_dp, 0.8739496829893695_dp, 1.402581890053244_dp, &
             2.232411606340228_dp, 3.5355070894776253_dp, 5.614322846490277_dp, &
             9.155534456578883_dp, &
             ! w
             3.2839863601841547e-08_dp, 1.8739359803730697e-07_dp, 7.263651992676576e-07_dp, &
             2.2884015454775067e-06_dp, 6.307323394138954e-06_dp, 1.5804182030425448e-05_dp, &
             3.683499130551101e-05_dp, 8.106008232173656e-05_dp, 0.00017018933037044374_dp, &
             0.0003435054727216734_dp, 0.0006703536787260965_dp, 0.0012705239221892889_dp, &
             0.002347008096574626_dp, 0.004237921456370455_dp, 0.007497771484212962_dp, &
             0.013023208384202923_dp, 0.02224556894310608_dp, 0.03742289330933707_dp, &
             0.062079132132665645_dp, 0.10166059521771431_dp, 0.1645152428331757_dp, &
             0.263366174652487_dp, 0.4176033322538294_dp, 0.6571613706264396_dp, &
             1.030275025843508_dp, 1.6234716823769342_dp, 2.632987540204431_dp, &
             4.795751925353884_dp]

      CASE (828)

         aw(:) = & ! a
            [8.686257796942393e-09_dp, 8.919696282086086e-08_dp, 4.570716481175889e-07_dp, &
             1.7327705015742483e-06_dp, 5.4846862714460755e-06_dp, 1.5345733427853057e-05_dp, &
             3.919746772902721e-05_dp, 9.327982031192661e-05_dp, 0.00020967903002880602_dp, &
             0.00044960263715763813_dp, 0.0009263647086384991_dp, 0.0018443690285837458_dp, &
             0.003564023785290968_dp, 0.006708078244491314_dp, 0.012333253475007086_dp, &
             0.022203560424990262_dp, 0.039220242900969364_dp, 0.06809054434939908_dp, &
             0.11635737134162893_dp, 0.19597028083401266_dp, 0.3256648803141617_dp, &
             0.5345528134164331_dp, 0.8675606542040445_dp, 1.3938601548717462_dp, &
             2.2208000955914096_dp, 3.520456525260697_dp, 5.595337727613425_dp, &
             9.132128390894607_dp, &
             ! w
             2.6980081083251742e-08_dp, 1.6624567460090667e-07_dp, 6.644782645212181e-07_dp, &
             2.1308307661703125e-06_dp, 5.944038862967199e-06_dp, 1.5026472087285735e-05_dp, &
             3.526437353714725e-05_dp, 7.803580146688705e-05_dp, 0.00016459526397817446_dp, &
             0.0003335108211481309_dp, 0.0006530344972615959_dp, 0.0012413251317080235_dp, &
             0.0022989997312832505_dp, 0.004160801491081188_dp, 0.0073765759148882734_dp, &
             0.012836716065087616_dp, 0.02196444734149504_dp, 0.03700774200099543_dp, &
             0.06147877161491803_dp, 0.10081125096924243_dp, 0.16334170296863154_dp, &
             0.26178649001588755_dp, 0.41553888302241315_dp, 0.654553327700573_dp, &
             1.0271047446927402_dp, 1.6197738071528085_dp, 2.628823963269949_dp, &
             4.7910026746157115_dp]

      CASE (829)

         aw(:) = & ! a
            [7.671273313771633e-09_dp, 8.246653720266085e-08_dp, 4.319208228961266e-07_dp, &
             1.657499869973599e-06_dp, 5.288224970217288e-06_dp, 1.4880232520420768e-05_dp, &
             3.8172620472173735e-05_dp, 9.11517264793093e-05_dp, 0.0002054680831908991_dp, &
             0.00044160358972318255_dp, 0.0009116972086216568_dp, 0.0018182982406914155_dp, &
             0.0035189584951300233_dp, 0.006632129546944244_dp, 0.012208214225227915_dp, &
             0.02200215105480042_dp, 0.03890247551718217_dp, 0.06759910518692695_dp, &
             0.11561204500293476_dp, 0.19486168724660805_dp, 0.32404822946051837_dp, &
             0.5322430581587142_dp, 0.8643313100206577_dp, 1.3894488613828202_dp, &
             2.2149238058950504_dp, 3.5128360373358216_dp, 5.585721189765881_dp, &
             9.120268878396354_dp, &
             ! w
             2.4283524094186823e-08_dp, 1.5622667959094901e-07_dp, 6.346474379082405e-07_dp, &
             2.0541345596170542e-06_dp, 5.766014636954599e-06_dp, 1.4643412114020715e-05_dp, &
             3.448763147103683e-05_dp, 7.653519444362885e-05_dp, 0.00016181183908035672_dp, &
             0.000328525972612215_dp, 0.0006443786762640081_dp, 0.001226705580173265_dp, &
             0.002274923610931946_dp, 0.004122069991043817_dp, 0.0073156290368224285_dp, &
             0.012742821283291895_dp, 0.02182275498434219_dp, 0.0367982863242317_dp, &
             0.06117559347037739_dp, 0.10038197186455844_dp, 0.16274809915012775_dp, &
             0.2609868667420739_dp, 0.41449318247761086_dp, 0.6532315053067045_dp, &
             1.025497177480197_dp, 1.617898036350469_dp, 2.6267115695473024_dp, &
             4.788593230920815_dp]

      CASE (830)

         aw(:) = & ! a
            [7.224670406097342e-09_dp, 7.947863910702089e-08_dp, 4.206448481347126e-07_dp, &
             1.6235365711505292e-06_dp, 5.19918864515336e-06_dp, 1.4668585790987458e-05_dp, &
             3.770549508112107e-05_dp, 9.01797965289321e-05_dp, 0.000203541699941023_dp, &
             0.000437939143953494_dp, 0.0009049698024305546_dp, 0.00180632808469462_dp, &
             0.0034982481306861314_dp, 0.0065971977022233645_dp, 0.012150661437625986_dp, &
             0.021909385344928273_dp, 0.038756029199628304_dp, 0.06737249607573904_dp, &
             0.1152681922822958_dp, 0.19435000676075964_dp, 0.32330173425574815_dp, &
             0.5311761033956246_dp, 0.8628390341616623_dp, 1.3874097511841712_dp, &
             2.2122067283986606_dp, 3.5093116150558297_dp, 5.58127272273365_dp, &
             9.114782018092576_dp, &
             ! w
             2.309585929819499e-08_dp, 1.5174392188415117e-07_dp, 6.211844049937118e-07_dp, &
             2.0193513504159787e-06_dp, 5.6850036192212944e-06_dp, 1.4468653900847362e-05_dp, &
             3.4132556019911704e-05_dp, 7.584808684951865e-05_dp, 0.00016053558751073918_dp, &
             0.0003262376307891843_dp, 0.0006404010741259164_dp, 0.0012199814339694012_dp, &
             0.002263841156732525_dp, 0.004104228788350288_dp, 0.0072875364620794015_dp, &
             0.01269951644940393_dp, 0.021757370535522964_dp, 0.03670158455693872_dp, &
             0.06103555811986859_dp, 0.10018360817068753_dp, 0.16247369653227667_dp, &
             0.2606170955483817_dp, 0.4140094588830583_dp, 0.6526198748762307_dp, &
             1.0247531479018466_dp, 1.6170297205319772_dp, 2.625733629364565_dp, &
             4.787477793232314_dp]

      CASE (831)

         aw(:) = & ! a
            [4.890645884223405e-09_dp, 5.346835756244272e-08_dp, 2.8219783521734554e-07_dp, &
             1.0875205444346661e-06_dp, 3.4792237248085507e-06_dp, 9.80911144534961e-06_dp, &
             2.5200818617118126e-05_dp, 6.0247106985450285e-05_dp, 0.00013593488918485006_dp, &
             0.00029239261970033005_dp, 0.0006040603418194576_dp, 0.0012054545017448292_dp, &
             0.002334125256849457_dp, 0.004401104084881071_dp, 0.008104724264444686_dp, &
             0.014612044924607787_dp, 0.025844477960580623_dp, 0.04492239656886703_dp, &
             0.07685004766602561_dp, 0.12956069327096761_dp, 0.2154981870645946_dp, &
             0.35399478000374274_dp, 0.5748361381784521_dp, 0.9236374349598716_dp, &
             1.4701603719471905_dp, 2.322085952668327_dp, 3.6514142020878886_dp, &
             5.760196125481564_dp, 9.335063986598556_dp, &
             ! w
             1.5592747620641986e-08_dp, 1.0187252225551975e-07_dp, 4.1618033737199206e-07_dp, &
             1.3513577703602567e-06_dp, 3.8014751833405837e-06_dp, 9.669478419645624e-06_dp, &
             2.28009664432225e-05_dp, 5.0649612224263475e-05_dp, 0.00010717079799613371_dp, &
             0.00021773713983986508_dp, 0.00042732554661221853_dp, 0.0008139170851046121_dp, &
             0.001510088797614535_dp, 0.002737318892683081_dp, 0.004859798057286487_dp, &
             0.00846785740113327_dp, 0.014505934426944358_dp, 0.024466934225796544_dp, &
             0.040684820199761246_dp, 0.06677171332232251_dp, 0.10826729851668633_dp, &
             0.17360299064147638_dp, 0.275548704559566_dp, 0.43346466404609535_dp, &
             0.6771326482537319_dp, 1.0544845043053257_dp, 1.6516528760694162_dp, &
             2.6646846837095786_dp, 4.831915823791932_dp]

      CASE (832)

         aw(:) = & ! a
            [4.812759772953049e-09_dp, 5.294519764317041e-08_dp, 2.8021522517422377e-07_dp, &
             1.081529154918912e-06_dp, 3.4634724049925327e-06_dp, 9.771571233703745e-06_dp, &
             2.5117754150364363e-05_dp, 6.0073842178958874e-05_dp, 0.00013559059166838792_dp, &
             0.0002917359327067932_dp, 0.0006028513621342238_dp, 0.001203296886389132_dp, &
             0.0023303801238177563_dp, 0.0043947649154089646_dp, 0.008094239409301568_dp, &
             0.014595072007464545_dp, 0.02581755330318436_dp, 0.044880504206811264_dp, &
             0.07678607902197492_dp, 0.12946480387553347_dp, 0.21535708628666447_dp, &
             0.35379104020903807_dp, 0.5745476860856313_dp, 0.9232374848809692_dp, &
             1.469618141479175_dp, 2.3213684608298886_dp, 3.6504890666849574_dp, &
             5.759034110809281_dp, 9.33363601989092_dp, &
             ! w
             1.5385452499199807e-08_dp, 1.010851728188466e-07_dp, 4.1380592001901117e-07_dp, &
             1.3452036757300674e-06_dp, 3.7871011298293366e-06_dp, 9.638385357216226e-06_dp, &
             2.273761821531586e-05_dp, 5.052668312371716e-05_dp, 0.0001069417977665692_dp, &
             0.00021732526283174355_dp, 0.0004266072291235271_dp, 0.000812698351688377_dp, &
             0.0015080720903299575_dp, 0.0027340578037247146_dp, 0.0048546374058443505_dp, &
             0.008459856732422336_dp, 0.01449377475748681_dp, 0.024448811500597547_dp, &
             0.04065833561308718_dp, 0.06673378190463429_dp, 0.10821411487469357_dp, &
             0.17353011484141603_dp, 0.2754513573094572_dp, 0.43333833040036834_dp, &
             0.6769740356261437_dp, 1.0542926918144637_dp, 1.6514299865841433_dp, &
             2.6644342117277717_dp, 4.831629998579591_dp]

      CASE (833)

         aw(:) = & ! a
            [3.804375181340491e-09_dp, 3.935982447244553e-08_dp, 2.0243496686863693e-07_dp, &
             7.690245020716379e-07_dp, 2.437458631969324e-06_dp, 6.826421584042175e-06_dp, &
             1.7449496529635047e-05_dp, 4.1549509592649746e-05_dp, 9.344161633364424e-05_dp, &
             0.00020044148569934553_dp, 0.0004131318527229444_dp, 0.0008227778314210594_dp, &
             0.0015903314696256367_dp, 0.002993950871694882_dp, 0.005505707351292169_dp, &
             0.00991375334702772_dp, 0.017514514361181902_dp, 0.03041164391315124_dp, &
             0.0519762331063012_dp, 0.08754850113003598_dp, 0.14549840038468892_dp, &
             0.2388166286374863_dp, 0.3874879198297343_dp, 0.6220257788038007_dp, &
             0.9887778185352368_dp, 1.5581199039694678_dp, 2.4380618190873404_dp, &
             3.8004970643897833_dp, 5.946984950139086_dp, 9.564167753835683_dp, &
             ! w
             1.1852704834299035e-08_dp, 7.356055305797649e-08_dp, 2.948286027219457e-07_dp, &
             9.469397224773148e-07_dp, 2.6443397183912438e-06_dp, 6.690093962883938e-06_dp, &
             1.5709942271330333e-05_dp, 3.4781168003337754e-05_dp, 7.33910180731409e-05_dp, &
             0.000148759163613605_dp, 0.00029136501374616043_dp, 0.0005539849958266668_dp, &
             0.0010262412137055422_dp, 0.0018576969880209763_dp, 0.0032940568223956573_dp, &
             0.005733250151688456_dp, 0.009811397221278993_dp, 0.016533288720888207_dp, &
             0.027468647944840975_dp, 0.04504494630170926_dp, 0.07298128212836737_dp, &
             0.11692841356837667_dp, 0.18541372406073434_dp, 0.29125509973179725_dp, &
             0.4537650240170743_dp, 0.7025282586185895_dp, 1.0851039652631607_dp, &
             1.6871556804302998_dp, 2.704536556421705_dp, 4.877404478782175_dp]

      CASE (834)

         aw(:) = & ! a
            [3.3134503349836226e-09_dp, 3.608498533142176e-08_dp, 1.9011847928770186e-07_dp, &
             7.319662342284968e-07_dp, 2.340270090661021e-06_dp, 6.595092489447575e-06_dp, &
             1.6937917384176332e-05_dp, 4.04823914860191e-05_dp, 9.13201679614226e-05_dp, &
             0.00019639182818262564_dp, 0.0004056675123603829_dp, 0.0008094363023868033_dp, &
             0.0015671304719257469_dp, 0.0029545925730648293_dp, 0.005440439168141161_dp, &
             0.009807773928891286_dp, 0.01734579702393029_dp, 0.030148044518178835_dp, &
             0.051571767879787726_dp, 0.08693874270376438_dp, 0.14459507851027603_dp, &
             0.23750177886062_dp, 0.38560834927147014_dp, 0.6193892446977899_dp, &
             0.9851530791566221_dp, 1.5532433748555086_dp, 2.4316530671136922_dp, &
             3.792282009462555_dp, 5.936715818601933_dp, 9.551594399877043_dp, &
             ! w
             1.0546706558608307e-08_dp, 6.866270981728613e-08_dp, 2.8014883557613883e-07_dp, &
             9.089943560190775e-07_dp, 2.555822467853219e-06_dp, 6.498696213089496e-06_dp, &
             1.5319915728895588e-05_dp, 3.4023800205307144e-05_dp, 7.19786159000504e-05_dp, &
             0.0001462151129951584_dp, 0.00028691999017650585_dp, 0.0005464264994504308_dp, &
             0.0010137005219056972_dp, 0.0018373548246353182_dp, 0.0032617474474084915_dp, &
             0.005682944796407503_dp, 0.009734554467607629_dp, 0.016418075761145318_dp, &
             0.02729906915461958_dp, 0.04479997340963112_dp, 0.07263417530984664_dp, &
             0.11644656655937333_dp, 0.1847595583406944_dp, 0.2903887279362842_dp, &
             0.45264944069120344_dp, 0.7011373056140865_dp, 1.0834315322877162_dp, &
             1.6852204298982336_dp, 2.7023664698008694_dp, 4.8749268318211865_dp]

      CASE (835)

         aw(:) = & ! a
            [3.2277853370689604e-09_dp, 3.5508879544032905e-08_dp, 1.8793259862024362e-07_dp, &
             7.253516826107841e-07_dp, 2.3228551593847557e-06_dp, 6.55352264696734e-06_dp, &
             1.684578318399642e-05_dp, 4.0289864548122024e-05_dp, 9.093685947668871e-05_dp, &
             0.00019565921955821226_dp, 0.00040431572903936976_dp, 0.0008070179277369389_dp, &
             0.0015629214703412756_dp, 0.002947447213908762_dp, 0.005428582242796608_dp, &
             0.009788509882685351_dp, 0.017315112616128985_dp, 0.03010008063297874_dp, &
             0.05149813945632546_dp, 0.08682769718568484_dp, 0.14443050842682587_dp, &
             0.23726215106948967_dp, 0.38526569126005245_dp, 0.6189084430055133_dp, &
             0.9844918850115439_dp, 1.5523536175802912_dp, 2.4304834852708677_dp, &
             3.790782495589435_dp, 5.934841076819336_dp, 9.549298723505517_dp, &
             ! w
             1.031859770999886e-08_dp, 6.779502918940319e-08_dp, 2.7752817895547813e-07_dp, &
             9.021908998510344e-07_dp, 2.53990402599357e-06_dp, 6.464198588155243e-06_dp, &
             1.5249491700854352e-05_dp, 3.388684875974896e-05_dp, 7.172290532189939e-05_dp, &
             0.00014575404037904681_dp, 0.00028611366362355813_dp, 0.0005450542981372343_dp, &
             0.0010114222229491994_dp, 0.0018336568725213762_dp, 0.0032558706474323223_dp, &
             0.005673789927642685_dp, 0.00972056352368552_dp, 0.016397089507610332_dp, &
             0.02726816762130151_dp, 0.044755316505812354_dp, 0.07257087812878067_dp, &
             0.11635867024786603_dp, 0.18464019257694717_dp, 0.29023059690010355_dp, &
             0.45244577163002175_dp, 0.7008833060184235_dp, 1.083126075127924_dp, &
             1.6848669231413513_dp, 2.7019700388938115_dp, 4.874474223578542_dp]

      CASE (836)

         aw(:) = & ! a
            [3.1845944711504063e-09_dp, 3.062565373864878e-08_dp, 1.5165979920425427e-07_dp, &
             5.638281922145305e-07_dp, 1.7619102915230689e-06_dp, 4.884415431291482e-06_dp, &
             1.2388762684211555e-05_dp, 2.93177603715543e-05_dp, 6.560108052631578e-05_dp, &
             0.00014012625837886894_dp, 0.0002877736974598507_dp, 0.0005713275090458673_dp, &
             0.0011012788665867993_dp, 0.002068220925429868_dp, 0.0037950695363253672_dp, &
             0.006820127692535034_dp, 0.012027609023346132_dp, 0.02085044860146694_dp, &
             0.03558219035273891_dp, 0.05985204657514571_dp, 0.09934214332184858_dp, &
             0.16286180047957247_dp, 0.26394562151771084_dp, 0.42321955831834573_dp, &
             0.6719029559611558_dp, 1.057042430210382_dp, 1.6495864415953405_dp, &
             2.557833812048899_dp, 3.9535508586446024_dp, 6.137823273687407_dp, &
             9.797373954261273_dp, &
             ! w
             9.639585515944762e-09_dp, 5.564426172692384e-08_dp, 2.1671657015199341e-07_dp, &
             6.84652746143391e-07_dp, 1.8906083709807276e-06_dp, 4.743878011458212e-06_dp, &
             1.1068610446597444e-05_dp, 2.437922509012781e-05_dp, 5.122249008654145e-05_dp, &
             0.00010344971164694936_dp, 0.0002019899874457242_dp, 0.00038300965684843715_dp, &
             0.0007078137691350674_dp, 0.0012785437951806115_dp, 0.0022627528609037413_dp, &
             0.003931437728477649_dp, 0.006717275169929913_dp, 0.011302927563836291_dp, &
             0.018753737880066363_dp, 0.03071547854144781_dp, 0.04970686503016066_dp, &
             0.07954962370663313_dp, 0.1259986383225653_dp, 0.19766759346099036_dp, &
             0.30741081389556224_dp, 0.4744823575825175_dp, 0.728265527941699_dp, &
             1.115956209881396_dp, 1.7227781046847763_dp, 2.744437510874053_dp, &
             4.922973584796601_dp]

      CASE (837)

         aw(:) = & ! a
            [2.614744083510958e-09_dp, 2.688237126126951e-08_dp, 1.3783484491503914e-07_dp, &
             5.22709611360505e-07_dp, 1.654877177389852e-06_dp, 4.630942200106908e-06_dp, &
             1.18301771653152e-05_dp, 2.8155406665662463e-05_dp, 6.329399728880794e-05_dp, &
             0.0001357264088590724_dp, 0.00027966710028101563_dp, 0.0005568367214600874_dp, &
             0.0010760656326571985_dp, 0.0020254071271373826_dp, 0.003723970125732682_dp, &
             0.006704462386123155_dp, 0.011843033412287093_dp, 0.020561226213594824_dp, &
             0.0351368263246369_dp, 0.05917773976473135_dp, 0.09833801659762247_dp, &
             0.16139108263179805_dp, 0.26182733833297284_dp, 0.4202209097704564_dp, &
             0.6677344410671792_dp, 1.0513588141283412_dp, 1.6419973379864579_dp, &
             2.5479267043823772_dp, 3.9409243089737362_dp, 6.122113743522572_dp, &
             9.778208718764887_dp, &
             ! w
             8.125520506758604e-09_dp, 5.0125607916936874e-08_dp, 2.0043912377050387e-07_dp, &
             6.429260492232504e-07_dp, 1.7937761172093916e-06_dp, 4.5352203882991204e-06_dp, &
             1.0644371008022252e-05_dp, 2.355656188833363e-05_dp, 4.9689386170120104e-05_dp, &
             0.00010068856353159997_dp, 0.0001971636779855515_dp, 0.00037479541953100095_dp, &
             0.0006941662051497843_dp, 0.0012563643649085657_dp, 0.0022274398205488757_dp, &
             0.0038762892645047625_dp, 0.006632721728478365_dp, 0.01117558097351962_dp, &
             0.018565270991873776_dp, 0.030441398892789955_dp, 0.04931533214127755_dp, &
             0.07900059788163354_dp, 0.12524385267380814_dp, 0.1966521029399133_dp, &
             0.30607712119059755_dp, 0.47277810489956124_dp, 0.7261549179242754_dp, &
             1.1134326871375837_dp, 1.7198698825840846_dp, 2.741183067612954_dp, &
             4.9192558869931835_dp]

      CASE (838)

         aw(:) = & ! a
            [2.1787458780262544e-09_dp, 2.3968395495525904e-08_dp, 1.2685398495855995e-07_dp, &
             4.896103797672603e-07_dp, 1.5679207803163633e-06_dp, 4.423609538287889e-06_dp, &
             1.137085674601753e-05_dp, 2.7195546578135382e-05_dp, 6.138212764097406e-05_dp, &
             0.00013206943067252137_dp, 0.00027291199740262986_dp, 0.0005447348665197471_dp, &
             0.0010549676607129856_dp, 0.0019895186908721525_dp, 0.0036642779200419923_dp, &
             0.006607216759357309_dp, 0.011687651384989322_dp, 0.02031746210699567_dp, &
             0.03476105601784757_dp, 0.058608234836563224_dp, 0.09748917166252391_dp, &
             0.16014674084013042_dp, 0.2600336871063626_dp, 0.4176799473893431_dp, &
             0.6641997715442408_dp, 1.0465364144916542_dp, 1.6355545310279818_dp, &
             2.539511774008115_dp, 3.9301948760196233_dp, 6.108759798533507_dp, &
             9.76191279536916_dp, &
             ! w
             6.965024762559501e-09_dp, 4.576145712214594e-08_dp, 1.8733075548117227e-07_dp, &
             6.089763540408482e-07_dp, 1.714428138748042e-06_dp, 4.363316022360521e-06_dp, &
             1.0293364509786185e-05_dp, 2.2873528863061142e-05_dp, 4.841276222784802e-05_dp, &
             9.838357393289472e-05_dp, 0.0001931259314535998_dp, 0.00036791014076412203_dp, &
             0.000682707192398689_dp, 0.001237713290760065_dp, 0.002197703581386773_dp, &
             0.0038297919711411687_dp, 0.006561350605892816_dp, 0.011067975224802441_dp, &
             0.018405864815580965_dp, 0.030209372117502065_dp, 0.0489835953962935_dp, &
             0.07853505727143946_dp, 0.1246033730081683_dp, 0.19578981351605798_dp, &
             0.30494392066682646_dp, 0.4713292165651563_dp, 0.7243596472914394_dp, &
             1.1112852899854118_dp, 1.7173943688658317_dp, 2.738412422896213_dp, &
             4.916090989014146_dp]

      CASE (839)

         aw(:) = & ! a
            [2.767021311165133e-09_dp, 2.470897578316426e-08_dp, 1.1715183049317973e-07_dp, &
             4.2447516072931566e-07_dp, 1.303898160769746e-06_dp, 3.570081050913815e-06_dp, &
             8.969321267195784e-06_dp, 2.1065246041920245e-05_dp, 4.6842552845020986e-05_dp, &
             9.95350916452484e-05_dp, 0.00020349990649065624_dp, 0.0004024498461168286_dp, &
             0.0007731124503203641_dp, 0.001447531076102062_dp, 0.002648952398683364_dp, &
             0.0047488207473153545_dp, 0.008356206843962828_dp, 0.014456578828256522_dp, &
             0.02462494147840596_dp, 0.04135009889978807_dp, 0.06852364461467833_dp, &
             0.1121713902236897_dp, 0.18153944901715083_dp, 0.29069710037494106_dp, &
             0.46089321106839937_dp, 0.7240238333491288_dp, 1.1277950058262287_dp, &
             1.7436825054904146_dp, 2.6802345093709774_dp, 4.109073574901631_dp, &
             6.330835496723875_dp, 10.032391399182695_dp, &
             ! w
             8.150999103544128e-09_dp, 4.3465724381411364e-08_dp, 1.6361499618951993e-07_dp, &
             5.067302733329273e-07_dp, 1.380403892672682e-06_dp, 3.428950928415803e-06_dp, &
             7.937899350886596e-06_dp, 1.7372820256132283e-05_dp, 3.6309224312367875e-05_dp, &
             7.300292161365094e-05_dp, 0.00014199196745666448_dp, 0.00026833559291066764_dp, &
             0.0004944161454164482_dp, 0.0008907052621727821_dp, 0.0015725935638907747_dp, &
             0.00272640025284791_dp, 0.004649149834755108_dp, 0.007808815366918761_dp, &
             0.012934741801168766_dp, 0.02115224281028113_dp, 0.03418142604297223_dp, &
             0.05462891717096371_dp, 0.08641362306704227_dp, 0.1353866625946753_dp, &
             0.21023786354533242_dp, 0.323846829686917_dp, 0.4954001831549247_dp, &
             0.7540785095327599_dp, 1.1467280142008094_dp, 1.7581652628740891_dp, &
             2.783995328292136_dp, 4.96817607331292_dp]

      CASE (840)

         aw(:) = & ! a
            [2.203466921804996e-09_dp, 2.1071106578590218e-08_dp, 1.040203852052522e-07_dp, &
             3.860190231048324e-07_dp, 1.2048298944557593e-06_dp, 3.3371778763733884e-06_dp, &
             8.458784673738406e-06_dp, 2.000703218271227e-05_dp, 4.4748225491272484e-05_dp, &
             9.554928250009321e-05_dp, 0.0001961665438043751_dp, 0.00038935229641236284_dp, &
             0.0007503309854883149_dp, 0.0014088411173314634_dp, 0.002584662656729996_dp, &
             0.0046441222466164335_dp, 0.008188873850230283_dp, 0.014193835129575973_dp, &
             0.024219288290103193_dp, 0.04073390779902237_dp, 0.06760237304558675_dp, &
             0.11081541351296809_dp, 0.17957477275934855_dp, 0.28789568704225843_dp, &
             0.456964392578087_dp, 0.7186093043844168_dp, 1.1204710325330132_dp, &
             1.7339736134446486_dp, 2.6676415298986362_dp, 4.093112663178782_dp, &
             6.311067556234632_dp, 10.008359226648214_dp, &
             ! w
             6.6554842586876194e-09_dp, 3.819567850616357e-08_dp, 1.484034301052858e-07_dp, &
             4.681858424781042e-07_dp, 1.2916301220661442e-06_dp, 3.2386653672525398e-06_dp, &
             7.552469969483705e-06_dp, 1.6627415270638327e-05_dp, 3.492263912431139e-05_dp, &
             7.050849020294223e-05_dp, 0.0001376341952789599_dp, 0.0002609187375695711_dp, &
             0.00048208696273975175_dp, 0.0008706477509008647_dp, 0.0015406092940473733_dp, &
             0.002676344743269549_dp, 0.004572195259892361_dp, 0.007692515467777068_dp, &
             0.01276189104301442_dp, 0.02089955572835164_dp, 0.03381812491828403_dp, &
             0.05411542122765271_dp, 0.08570069711346631_dp, 0.1344156192239567_dp, &
             0.20894270553280317_dp, 0.3221594684715971_dp, 0.49325977993136966_dp, &
             0.751444908118862_dp, 1.143596061494864_dp, 1.7545698412499509_dp, &
             2.7799796441837357_dp, 4.9635861961716214_dp]

      CASE (841)

         aw(:) = & ! a
            [1.5590197220129705e-09_dp, 1.6812521913433517e-08_dp, 8.818391606430967e-08_dp, &
             3.386777849441256e-07_dp, 1.081107279119066e-06_dp, 3.0431937273604944e-06_dp, &
             7.808974574632904e-06_dp, 1.8651064556230853e-05_dp, 4.204961818310387e-05_dp, &
             9.038915343256561e-05_dp, 0.00018663394058807532_dp, 0.0003722663790061768_dp, &
             0.0007205191180170731_dp, 0.0013580699568548778_dp, 0.002500086356581223_dp, &
             0.004506073690889394_dp, 0.007967783986710286_dp, 0.013846027584983215_dp, &
             0.023681372283795212_dp, 0.03991550066149132_dp, 0.06637695508261407_dp, &
             0.10900930018314296_dp, 0.17695455161127305_dp, 0.28415510038379477_dp, &
             0.4517126448115705_dp, 0.7113641614453075_dp, 1.1106616368066464_dp, &
             1.7209588171500714_dp, 2.6507477180992725_dp, 4.071686600754953_dp, &
             6.284516586003154_dp, 9.976067400722108_dp, &
             ! w
             4.941688849815975e-09_dp, 3.188453405153541e-08_dp, 1.2966459529352903e-07_dp, &
             4.199349641021897e-07_dp, 1.1792515540793927e-06_dp, 2.995732540485393e-06_dp, &
             7.057074391486454e-06_dp, 1.5664023586120457e-05_dp, 3.3122203675255304e-05_dp, &
             6.725662263132082e-05_dp, 0.00013193347072925867_dp, 0.0002511865724024704_dp, &
             0.0004658650661061385_dp, 0.0008441931610852995_dp, 0.001498331163696893_dp, &
             0.0026100467203816675_dp, 0.004470082816615264_dp, 0.00753793480587778_dp, &
             0.012531787667315511_dp, 0.020562686208356728_dp, 0.033333139034003735_dp, &
             0.053429073318249316_dp, 0.08474666813689917_dp, 0.13311475165594086_dp, &
             0.20720585207003916_dp, 0.3198944994834913_dp, 0.49038418594386834_dp, &
             0.7479039917633125_dp, 1.1393824285088334_dp, 1.749730456221594_dp, &
             2.7745733663071763_dp, 4.957407313118424_dp]

      CASE (842)

         aw(:) = & ! a
            [1.479683649697902e-09_dp, 1.6278008122146516e-08_dp, 8.615220829458904e-08_dp, &
             3.3251628207071743e-07_dp, 1.0648450488017557e-06_dp, 3.004270865022241e-06_dp, &
             7.722456822337955e-06_dp, 1.8469710681822967e-05_dp, 4.168734522971689e-05_dp, &
             8.969425081797155e-05_dp, 0.0001853467303496863_dp, 0.00036995378510729657_dp, &
             0.0007164756713893742_dp, 0.0013511710277301961_dp, 0.0024885748322353617_dp, &
             0.004487256006984869_dp, 0.007937605727405291_dp, 0.013798493564046305_dp, &
             0.023607772592359827_dp, 0.03980340519027969_dp, 0.06620894875596875_dp, &
             0.10876145620961274_dp, 0.17659469006056397_dp, 0.28364096700054375_dp, &
             0.4509902833033633_dp, 0.7103669453765807_dp, 1.1093106441791758_dp, &
             1.719165355243869_dp, 2.648418555980675_dp, 4.0687313008763955_dp, &
             6.280853112112665_dp, 9.971610596180174_dp, &
             ! w
             4.730259456981354e-09_dp, 3.1078649871532e-08_dp, 1.2722468500418828e-07_dp, &
             4.13583047959329e-07_dp, 1.1643447419542326e-06_dp, 2.963322847463187e-06_dp, &
             6.990683711042888e-06_dp, 1.5534435365376526e-05_dp, 3.287926976195174e-05_dp, &
             6.681668055560068e-05_dp, 0.00013116044841311768_dp, 0.00024986421384895415_dp, &
             0.00046365695555379473_dp, 0.0008405863897573469_dp, 0.0014925586633026797_dp, &
             0.0026009826759276194_dp, 0.004456105483221565_dp, 0.007516752041572211_dp, &
             0.012500223434600246_dp, 0.02051643253409508_dp, 0.03326648949207963_dp, &
             0.05333467369887276_dp, 0.08461535079090401_dp, 0.132935564560582_dp, &
             0.206966449248565_dp, 0.3195821076971402_dp, 0.4899873486084814_dp, &
             0.7474150925905267_dp, 1.138800404131442_dp, 1.749061796714666_dp, &
             2.7738262678122343_dp, 4.956553485781041_dp]

      CASE (843)

         aw(:) = & ! a
            [2.46193468149273e-09_dp, 2.0517012422421106e-08_dp, 9.287924072309443e-08_dp, &
             3.270507112276594e-07_dp, 9.85364443448603e-07_dp, 2.659993261324006e-06_dp, &
             6.610267053741911e-06_dp, 1.5389598264383788e-05_dp, 3.397595269753531e-05_dp, &
             7.17582291905975e-05_dp, 0.00014594898237369207_dp, 0.00028733283396248875_dp, &
             0.0005497802425245835_dp, 0.0010257462855167148_dp, 0.0018711613306756434_dp, &
             0.003344888018347371_dp, 0.005870527663059019_dp, 0.01013217833576613_dp, &
             0.01722129639833083_dp, 0.02885982141492794_dp, 0.047736208655418395_dp, &
             0.07800739824654102_dp, 0.12604305799805285_dp, 0.2015216621653775_dp, &
             0.31903598360084906_dp, 0.5004377357962535_dp, 0.7782693884430489_dp, &
             1.2008567827791354_dp, 1.8401592102840052_dp, 2.8049374107325544_dp, &
             4.266656832885215_dp, 6.525528510362614_dp, 10.268635671946859_dp, &
             ! w
             7.084603793567241e-09_dp, 3.487794902176719e-08_dp, 1.2641993365178165e-07_dp, &
             3.828954860328335e-07_dp, 1.0270959992861877e-06_dp, 2.522090631405802e-06_dp, &
             5.785992814360229e-06_dp, 1.2570535838393628e-05_dp, 2.611220585614889e-05_dp, &
             5.2228599126264525e-05_dp, 0.00010113024587310934_dp, 0.0001903654408516313_dp, &
             0.00034953570526057763_dp, 0.0006277452204999214_dp, 0.0011052254890226505_dp, &
             0.001911272019678177_dp, 0.0032516344763093307_dp, 0.005449942858830312_dp, &
             0.009009806228701298_dp, 0.01470713146731143_dp, 0.023726317579465396_dp, &
             0.037859771247372616_dp, 0.059798399966042054_dp, 0.09355265288967414_dp, &
             0.1450620168584118_dp, 0.223082680822343_dp, 0.3405092257401168_dp, &
             0.5164531885374843_dp, 0.7798927693583374_dp, 1.1773391573927072_dp, &
             1.7932339000678958_dp, 2.8231233080187206_dp, 5.012913153382189_dp]

      CASE (844)

         aw(:) = & ! a
            [1.922413676656194e-09_dp, 1.7093474898443425e-08_dp, 8.082681497358473e-08_dp, &
             2.923829231740008e-07_dp, 8.971570384635643e-07_dp, 2.454466770026462e-06_dp, &
             6.162726670460494e-06_dp, 1.4466634276744057e-05_dp, 3.2156358606086885e-05_dp, &
             6.83054947875524e-05_dp, 0.0001396104395564152_dp, 0.0002760299723475552_dp, &
             0.0005301407120357934_dp, 0.0009924100642055152_dp, 0.0018157710541713212_dp, &
             0.003254646575211859_dp, 0.005726175809988567_dp, 0.00990521387615887_dp, &
             0.016870229644687446_dp, 0.028325248764529746_dp, 0.04693450329297555_dp, &
             0.07682289014450558_dp, 0.1243187438960345_dp, 0.19904880596501584_dp, &
             0.31554350865908315_dp, 0.49558313821495364_dp, 0.7716340132292909_dp, &
             1.1919494827994221_dp, 1.8284329193502338_dp, 2.7898213351802297_dp, &
             4.247599688415033_dp, 6.502028755280721_dp, 10.240162993383235_dp, &
             ! w
             5.65446976352149e-09_dp, 3.00092619294288e-08_dp, 1.1271885326739491e-07_dp, &
             3.4865970289504667e-07_dp, 9.48972707804224e-07_dp, 2.3557429581430375e-06_dp, &
             5.450701803863703e-06_dp, 1.1924468972543018e-05_dp, 2.4913659481533083e-05_dp, &
             5.0076619306384265e-05_dp, 9.737556426799699e-05_dp, 0.0001839795553079753_dp, &
             0.0003389221740468162_dp, 0.0006104729519847454_dp, 0.0010776592793886632_dp, &
             0.0018680714471799164_dp, 0.003185089761796948_dp, 0.005349117507477816_dp, &
             0.008859464546163485_dp, 0.014486449711618709_dp, 0.023407418608529736_dp, &
             0.0374061956185725_dp, 0.05916374688458975_dp, 0.0926798090495142_dp, &
             0.14388364902098358_dp, 0.22152397366571794_dp, 0.3384940772087924_dp, &
             0.5139148920856795_dp, 0.7767889054879342_dp, 1.173666814364205_dp, &
             1.789033616708445_dp, 2.8184405532645274_dp, 5.007557729288295_dp]

      CASE (845)

         aw(:) = & ! a
            [1.261030077714601e-09_dp, 1.2793937998754653e-08_dp, 6.516649566813368e-08_dp, &
             2.4621038055808034e-07_dp, 7.775933394609482e-07_dp, 2.172185169231488e-06_dp, &
             5.541673297875507e-06_dp, 1.3175074497154998e-05_dp, 2.9592307805657116e-05_dp, &
             6.341130181996039e-05_dp, 0.00013057974442088255_dp, 0.00025985454092306183_dp, &
             0.0005019237795876626_dp, 0.0009443458540415964_dp, 0.0017356564226109629_dp, &
             0.003123750292819559_dp, 0.005516245220402361_dp, 0.009574351312611156_dp, &
             0.016357329788737593_dp, 0.0275426673392691_dp, 0.04575865116702402_dp, &
             0.07508255383048805_dp, 0.12178118273769663_dp, 0.19540415195153182_dp, &
             0.3103888029196236_dp, 0.4884085796170796_dp, 0.7618156715683803_dp, &
             1.1787545186576538_dp, 1.8110441627913738_dp, 2.7673853965454445_dp, &
             4.219291917049886_dp, 6.4670992068777755_dp, 10.197820536344981_dp, &
             ! w
             3.897830549575035e-09_dp, 2.3738634233636e-08_dp, 9.445515329659807e-08_dp, &
             3.021123361058843e-07_dp, 8.412797520957919e-07_dp, 2.1240098832730693e-06_dp, &
             4.979685373667982e-06_dp, 1.1010584593813334e-05_dp, 2.3208374123614428e-05_dp, &
             4.6999454942670736e-05_dp, 9.198323953647233e-05_dp, 0.00017477313588458253_dp, &
             0.00032356845720150034_dp, 0.0005854098146343251_dp, 0.0010375478210232424_dp, &
             0.0018050514332640386_dp, 0.0030877909185145374_dp, 0.005201380646780763_dp, &
             0.008638738470225492_dp, 0.014161860293578658_dp, 0.02293756737668983_dp, &
             0.036736854113909534_dp, 0.05822579313669984_dp, 0.09138802916483149_dp, &
             0.14213741531143836_dp, 0.21921127457447104_dp, 0.3355007314007439_dp, &
             0.5101405228480381_dp, 0.7721693129240349_dp, 1.1681969906276446_dp, &
             1.7827740424660827_dp, 2.8114601073233194_dp, 4.9995752593999_dp]

      CASE (846)

         aw(:) = & ! a
            [1.0566655865248073e-09_dp, 1.1429446718821667e-08_dp, 6.003152656757956e-08_dp, &
             2.307312190308448e-07_dp, 7.368890784250718e-07_dp, 2.0749868676338605e-06_dp, &
             5.325929053394356e-06_dp, 1.2723204286686793e-05_dp, 2.868994076455378e-05_dp, &
             6.168028886922652e-05_dp, 0.00012737199574422252_dp, 0.0002540874507998262_dp, &
             0.000491830300236805_dp, 0.0009271023133570745_dp, 0.0017068386891889334_dp, &
             0.0030765538769786777_dp, 0.005440387856828313_dp, 0.009454558847580249_dp, &
             0.016171290642443614_dp, 0.027258332659636383_dp, 0.0453307659406808_dp, &
             0.07444834300772185_dp, 0.12085520773362532_dp, 0.19407252797301192_dp, &
             0.3085032661998795_dp, 0.4857813537342025_dp, 0.7582167058469943_dp, &
             1.1739133416178547_dp, 1.804658907142145_dp, 2.7591405783368064_dp, &
             4.208882545107766_dp, 6.4542480086803975_dp, 10.182235566361792_dp, &
             ! w
             3.3536290243901775e-09_dp, 2.1697913917655122e-08_dp, 8.832811534902565e-08_dp, &
             2.862265243919859e-07_dp, 8.040858507665811e-07_dp, 2.043252732175792e-06_dp, &
             4.814364128606313e-06_dp, 1.0687940871855503e-05_dp, 2.2603367111934036e-05_dp, &
             4.5903135360071666e-05_dp, 9.005506725395092e-05_dp, 0.00017147055947368438_dp, &
             0.0003180449760528093_dp, 0.0005763703232462657_dp, 0.0010230474492465636_dp, &
             0.0017822217168556931_dp, 0.0030524755923080583_dp, 0.005147663784744834_dp, &
             0.00855835199223758_dp, 0.014043468966128462_dp, 0.022765951832222037_dp, &
             0.036492052556536404_dp, 0.05788232888727132_dp, 0.09091445383858077_dp, &
             0.14149654191415614_dp, 0.2183616481154842_dp, 0.33440002020304904_dp, &
             0.5087514244690141_dp, 0.7704678570840019_dp, 1.166181126239908_dp, &
             1.7804660879041752_dp, 2.8088857975140793_dp, 4.996631628712299_dp]

      CASE (847)

         aw(:) = & ! a
            [1.0108113209759398e-09_dp, 1.1119941118942126e-08_dp, 5.8852869505338446e-08_dp, &
             2.2715073464609125e-07_dp, 7.27424034697187e-07_dp, 2.0522975046032946e-06_dp, &
             5.275416096488924e-06_dp, 1.261715168325287e-05_dp, 2.8477736732801676e-05_dp, &
             6.127253362733354e-05_dp, 0.0001266152921605661_dp, 0.00025272529228248535_dp, &
             0.0004894436299305439_dp, 0.0009230209463726673_dp, 0.001700011801374611_dp, &
             0.0030653641684659986_dp, 0.0054223899133845005_dp, 0.009426117969241535_dp, &
             0.016127094667807193_dp, 0.027190747324971835_dp, 0.04522900620842918_dp, &
             0.07429744201903152_dp, 0.12063478680154299_dp, 0.19375541282834224_dp, &
             0.30805406608466984_dp, 0.48515523003175626_dp, 0.7573587063924442_dp, &
             1.1727588376783455_dp, 1.8031357461248292_dp, 2.757173333766668_dp, &
             4.206398288168869_dp, 6.451180444982384_dp, 10.178514936439111_dp, &
             ! w
             3.231366266745103e-09_dp, 2.1230653971588304e-08_dp, 8.691057314412012e-08_dp, &
             2.8252960348951036e-07_dp, 7.953949280707434e-07_dp, 2.024324824377468e-06_dp, &
             4.7755223828501555e-06_dp, 1.0611986881536505e-05_dp, 2.2460705609533583e-05_dp, &
             4.564425558157518e-05_dp, 8.959919860757453e-05_dp, 0.0001706889050477756_dp, &
             0.0003167364258501587_dp, 0.000574226969130065_dp, 0.0010196066020646871_dp, &
             0.0017768005530869207_dp, 0.0030440841831127097_dp, 0.005134892358176567_dp, &
             0.0085392292962598_dp, 0.014015291234860975_dp, 0.022725087209662195_dp, &
             0.03643373542318754_dp, 0.057800474416534686_dp, 0.0908015476745432_dp, &
             0.1413436944826071_dp, 0.2181589446681848_dp, 0.334137330397612_dp, &
             0.5084198143667269_dp, 0.7700615767490158_dp, 1.1656996689709882_dp, &
             1.7799147858399724_dp, 2.808270824290397_dp, 4.9959284427881485_dp]

      CASE (848)

         aw(:) = & ! a
            [2.2274857143791788e-09_dp, 1.7452329222319866e-08_dp, 7.536813911823567e-08_dp, &
             2.5740414429863387e-07_dp, 7.59327680166685e-07_dp, 2.0180698598548547e-06_dp, &
             4.954642624566124e-06_dp, 1.1423118799152858e-05_dp, 2.5016452846667024e-05_dp, &
             5.2476709506426854e-05_dp, 0.00010610938292451702_dp, 0.00020783739218017472_dp, &
             0.0003958918029415031_dp, 0.0007356841401316799_dp, 0.001337227084379473_dp, &
             0.002382692155023381_dp, 0.004169493694660976_dp, 0.007176921221194825_dp, &
             0.012168162938270537_dp, 0.020345069658743716_dp, 0.03358089387804767_dp, &
             0.05476746737966397_dp, 0.08832919918046878_dp, 0.14097880029878562_dp, &
             0.2228216410192318_dp, 0.3489618913715647_dp, 0.5418335052445565_dp, &
             0.8345952495177218_dp, 1.2761543471145376_dp, 1.9389121348256646_dp, &
             2.9318081385079755_dp, 4.426139751694001_dp, 6.721718216312974_dp, &
             10.50589803308251_dp, &
             ! w
             6.287579033693602e-09_dp, 2.866027383361553e-08_dp, 9.976565058340684e-08_dp, &
             2.9493834459446365e-07_dp, 7.778875343938408e-07_dp, 1.8859609309719048e-06_dp, &
             4.283334530991183e-06_dp, 9.229859066286541e-06_dp, 1.904171264820599e-05_dp, &
             3.786445165425619e-05_dp, 7.294677515836348e-05_dp, 0.00013670536272714038_dp, &
             0.000250023354478363_dp, 0.00044744998077084636_dp, 0.0007852983999726469_dp, &
             0.0013541178012168918_dp, 0.0022977068553191042_dp, 0.00384182561573767_dp, &
             0.006337172298157243_dp, 0.01032318575822768_dp, 0.016622042719138596_dp, &
             0.02647615953244465_dp, 0.04174803928941701_dp, 0.0652091373356819_dp, &
             0.10095582752341163_dp, 0.155008329527622_dp, 0.23617994440111334_dp, &
             0.3573708113077927_dp, 0.5376108754377592_dp, 0.8056773157854522_dp, &
             1.207761153615302_dp, 1.8279594993512716_dp, 2.861798789933721_dp, &
             5.057156122401313_dp]

      CASE (849)

         aw(:) = & ! a
            [1.715309112348382e-09_dp, 1.425409001773944e-08_dp, 6.439519041631614e-08_dp, &
             2.2645730242254954e-07_dp, 6.8168300178667e-07_dp, 1.8390035143806345e-06_dp, &
             4.567742447217839e-06_dp, 1.0630010928305093e-05_dp, 2.3460250634512634e-05_dp, &
             4.953476052598097e-05_dp, 0.00010072428474217605_dp, 0.0001982562144431605_dp, &
             0.00037927137752271966_dp, 0.0007075045238302819_dp, 0.0012904353064366785_dp, &
             0.0023064738668260283_dp, 0.004047541622747156_dp, 0.006985037765068907_dp, &
             0.011871003071710214_dp, 0.019891805726090395_dp, 0.03289957696104173_dp, &
             0.05375788881310137_dp, 0.08685414909656929_dp, 0.13885382053739456_dp, &
             0.21980373604102527_dp, 0.34473826389225415_dp, 0.5360122829747642_dp, &
             0.8267013421235555_dp, 1.265634746697012_dp, 1.9251553238411157_dp, &
             2.914179996913433_dp, 4.404030178131559_dp, 6.694571226488991_dp, &
             10.473117699372983_dp, &
             ! w
             4.9315025940713775e-09_dp, 2.4194703351949433e-08_dp, 8.754662294721111e-08_dp, &
             2.64887150380061e-07_dp, 7.100413219338123e-07_dp, 1.7426177383969601e-06_dp, &
             3.996109991729874e-06_dp, 8.678912282075467e-06_dp, 1.8023184044986598e-05_dp, &
             3.604052979017424e-05_dp, 6.977067221692719e-05_dp, 0.000131310749906133_dp, &
             0.00024106444628761297_dp, 0.00043287446869576756_dp, 0.0007620310027319267_dp, &
             0.0013176277114705_dp, 0.002241428588688711_dp, 0.0037564011546314616_dp, &
             0.006209485281774303_dp, 0.010135169634845363_dp, 0.01634927008604028_dp, &
             0.02608626793602375_dp, 0.04119913190986708_dp, 0.06444843085884665_dp, &
             0.09991901963522484_dp, 0.1536204308327971_dp, 0.23435862796633256_dp, &
             0.35503353194151316_dp, 0.5346867248437237_dp, 0.8021230560409275_dp, &
             1.203576913384259_dp, 1.8231912934310703_dp, 2.856493419943409_dp, &
             5.051087937188491_dp]

      CASE (850)

         aw(:) = & ! a
            [1.0758659340255967e-09_dp, 1.0167164015240067e-08_dp, 4.9859592286185096e-08_dp, &
             1.8431400593006791e-07_dp, 5.738015222033274e-07_dp, 1.5863937162236038e-06_dp, &
             4.015360098808803e-06_dp, 9.486576708604261e-06_dp, 2.119830152313252e-05_dp, &
             4.5228863817178745e-05_dp, 9.279513732526955e-05_dp, 0.00018407435527092067_dp, &
             0.00035455547351989603_dp, 0.0006654246358606789_dp, 0.0012203003184695523_dp, &
             0.0021918438571634814_dp, 0.003863560773416426_dp, 0.006694733518895417_dp, &
             0.01142024757192155_dp, 0.01920259575640197_dp, 0.031861275677595516_dp, &
             0.05221611486432177_dp, 0.0845971409884596_dp, 0.13559641313576798_dp, &
             0.2151696546607952_dp, 0.3382423823171786_dp, 0.5270459012716615_dp, &
             0.8145253874758794_dp, 1.2493876688137333_dp, 1.9038830603298444_dp, &
             2.886891897531776_dp, 4.3697720246036935_dp, 6.652472907190046_dp, &
             10.422247573899798_dp, &
             ! w
             3.235159378159741e-09_dp, 1.8339242831941008e-08_dp, 7.088982438417943e-08_dp, &
             2.2297988277124975e-07_dp, 6.13909232292796e-07_dp, 1.5370220364486574e-06_dp, &
             3.580100476231876e-06_dp, 7.87446076916954e-06_dp, 1.6525813148385928e-05_dp, &
             3.334332260153284e-05_dp, 6.504971734511139e-05_dp, 0.0001232558121611228_dp, &
             0.00022763336577209098_dp, 0.00041094352775341956_dp, 0.0007269064798609755_dp, &
             0.0012623766488428546_dp, 0.0021559807094720745_dp, 0.0036263710068930814_dp, &
             0.006014667749255997_dp, 0.009847678812396432_dp, 0.01593133030777213_dp, &
             0.025487740131110808_dp, 0.04035498769146014_dp, 0.06327659551707043_dp, &
             0.09831931929717358_dp, 0.15147580801769658_dp, 0.23154027931032156_dp, &
             0.3514119476229571_dp, 0.5301501843862094_dp, 0.7966027741178908_dp, &
             1.1970718345468874_dp, 1.815772457762836_dp, 2.8482340034483533_dp, &
             5.0416374859708_dp]

      CASE (851)

         aw(:) = & ! a
            [8.530766154470298e-10_dp, 8.70284226105799e-09_dp, 4.4451066257575195e-08_dp, &
             1.6820644584206475e-07_dp, 5.317809778430233e-07_dp, 1.48660479151414e-06_dp, &
             3.7947395852828838e-06_dp, 9.025815552131148e-06_dp, 2.0280074380309348e-05_dp, &
             4.346995032147937e-05_dp, 8.953868442507957e-05_dp, 0.00017822251684367218_dp, &
             0.0003443145843865128_dp, 0.0006479244821443401_dp, 0.0011910355495978132_dp, &
             0.0021438689242639325_dp, 0.003786350128625508_dp, 0.00657259701154879_dp, &
             0.011230169121998363_dp, 0.018911345617281236_dp, 0.03142164025632888_dp, &
             0.05156210536058579_dp, 0.08363810242925038_dp, 0.13421008768472792_dp, &
             0.21319449779576682_dp, 0.33546983718241036_dp, 0.523213948281257_dp, &
             0.8093154919519803_dp, 1.242428071386227_dp, 1.894761638454777_dp, &
             2.875180343614518_dp, 4.355057581604841_dp, 6.634379367985747_dp, &
             10.400373073436226_dp, &
             ! w
             2.6427031908949146e-09_dp, 1.6181094404493005e-08_dp, 6.451780298222103e-08_dp, &
             2.0660472994990585e-07_dp, 5.757877767181744e-07_dp, 1.4545748849486805e-06_dp, &
             3.4117817238528944e-06_dp, 7.546587060800534e-06_dp, 1.591175588447046e-05_dp, &
             3.223137637007654e-05_dp, 6.30945186273881e-05_dp, 0.00011990633629638359_dp, &
             0.00022202824003445852_dp, 0.0004017616623647714_dp, 0.0007121579415223659_dp, &
             0.0012391155524192623_dp, 0.002119919181919329_dp, 0.0035713719081832155_dp, &
             0.005932095426075794_dp, 0.009725594268101923_dp, 0.015753533712217164_dp, &
             0.025232695523749075_dp, 0.03999472044455227_dp, 0.06277574334983835_dp, &
             0.09763465396721004_dp, 0.15055673187308719_dp, 0.2303310159894199_dp, &
             0.34985629290085185_dp, 0.5281995078641347_dp, 0.7942269487213767_dp, &
             1.1942700872213858_dp, 1.8125754547977413_dp, 2.8446738520936137_dp, &
             5.037564323693374_dp]

      CASE (852)

         aw(:) = & ! a
            [7.485517113163199e-10_dp, 8.004464374515241e-09_dp, 4.182104218009189e-08_dp, &
             1.6027133146953048e-07_dp, 5.108935884752593e-07_dp, 1.4366722946534533e-06_dp, &
             3.683775648135436e-06_dp, 8.793107317512489e-06_dp, 1.981472855754801e-05_dp, &
             4.257596613387601e-05_dp, 8.787942807692114e-05_dp, 0.00017523434466571028_dp, &
             0.00033907515416720774_dp, 0.0006389557687380277_dp, 0.0011760145270830638_dp, &
             0.0021192101718956412_dp, 0.003746614335982069_dp, 0.006509667929861093_dp, &
             0.011132130017987636_dp, 0.018760976882557942_dp, 0.031194456333704244_dp, &
             0.05122385794200837_dp, 0.08314170804254446_dp, 0.1334920064851158_dp, &
             0.21217071784296496_dp, 0.3340318306728112_dp, 0.5212252858817166_dp, &
             0.8066102233296886_dp, 1.2388124123187383_dp, 1.8900206583520773_dp, &
             2.8690905795689696_dp, 4.347403635360103_dp, 6.624964954718267_dp, &
             10.388988746922239_dp, &
             ! w
             2.364271870423896e-09_dp, 1.5136190827701523e-08_dp, 6.137755396060629e-08_dp, &
             1.9845357947137618e-07_dp, 5.566795770926899e-07_dp, 1.4130310746080372e-06_dp, &
             3.326614800119239e-06_dp, 7.380121200576499e-06_dp, 1.5599097942649512e-05_dp, &
             3.1663823009091906e-05_dp, 6.209443482620178e-05_dp, 0.00011818987687018821_dp, &
             0.00021915108769775198_dp, 0.00039704152484541045_dp, 0.0007045659357474019_dp, &
             0.001227126947942397_dp, 0.002101312533897999_dp, 0.0035429648673508704_dp, &
             0.005889406304828762_dp, 0.00966242210021254_dp, 0.01566145812776196_dp, &
             0.025100514361634532_dp, 0.03980787201150227_dp, 0.06251580736786437_dp, &
             0.09727909653041707_dp, 0.1500791576366265_dp, 0.22970230377822035_dp, &
             0.34904706896485305_dp, 0.5271843216790469_dp, 0.7929899889654172_dp, &
             1.1928108742711225_dp, 1.8109099762845895_dp, 2.8428189713625165_dp, &
             5.035442247417427_dp]

      CASE (853)

         aw(:) = & ! a
            [7.015759952264556e-10_dp, 7.687605461805616e-09_dp, 4.06153328751681e-08_dp, &
             1.5660890498596987e-07_dp, 5.012083723973226e-07_dp, 1.4134403460572587e-06_dp, &
             3.6320117485286108e-06_dp, 8.684320848399275e-06_dp, 1.9596808212053662e-05_dp, &
             4.215669691359067e-05_dp, 8.710026616696479e-05_dp, 0.0001738295916548252_dp, &
             0.00033660967382591756_dp, 0.000634731765933465_dp, 0.0011689345559288055_dp, &
             0.0021075793996146617_dp, 0.0037278601949364072_dp, 0.006479949846403211_dp, &
             0.01108580642816379_dp, 0.01868989224086861_dp, 0.031087009113049235_dp, &
             0.05106381475153055_dp, 0.08290674373042546_dp, 0.1331519826617938_dp, &
             0.21168577277828624_dp, 0.3333504543600378_dp, 0.5202827061155677_dp, &
             0.8053276295681061_dp, 1.2370977503636218_dp, 1.8877718031140505_dp, &
             2.866201329763345_dp, 4.34377161068584_dp, 6.620496869060699_dp, &
             10.383585113156837_dp, &
             ! w
             2.238997466106155e-09_dp, 1.4658206914195193e-08_dp, 5.992792460965658e-08_dp, &
             1.9467135835313114e-07_dp, 5.477814545209847e-07_dp, 1.3936332861904557e-06_dp, &
             3.286763847132626e-06_dp, 7.302093832260751e-06_dp, 1.5452332489261882e-05_dp, &
             3.139707453996938e-05_dp, 6.162389023876517e-05_dp, 0.00011738150729535318_dp, &
             0.00021779494577127908_dp, 0.0003948150140722096_dp, 0.0007009823090453667_dp, &
             0.0012214645018813195_dp, 0.002092519275230718_dp, 0.003529533071018548_dp, &
             0.005869211749643338_dp, 0.009632524485049173_dp, 0.015617863248112181_dp, &
             0.025037906506793727_dp, 0.03971933879556791_dp, 0.06239260161295121_dp, &
             0.09711051373150156_dp, 0.14985265414969443_dp, 0.22940403474769006_dp, &
             0.34866306244184087_dp, 0.52670246342252_dp, 0.7924027422427473_dp, &
             1.1921179927454306_dp, 1.8101190551276467_dp, 2.8419380516825403_dp, &
             5.034434452504777_dp]

      CASE (854)

         aw(:) = & ! a
            [6.943811259087412e-10_dp, 7.638890745422535e-09_dp, 4.0429228507776893e-08_dp, &
             1.5604216136036537e-07_dp, 4.997070284701836e-07_dp, 1.4098344827888807e-06_dp, &
             3.623969482062147e-06_dp, 8.667405910501703e-06_dp, 1.9562902142372694e-05_dp, &
             4.209142709236206e-05_dp, 8.69789124673926e-05_dp, 0.00017361071242873183_dp, &
             0.0003362253794064382_dp, 0.0006340731574523437_dp, 0.0011678303227371034_dp, &
             0.0021057649207424454_dp, 0.0037249337238134963_dp, 0.006475311505526602_dp, &
             0.011078574882242322_dp, 0.018678793210534037_dp, 0.031070229621383835_dp, &
             0.051038817638201124_dp, 0.08287003927018764_dp, 0.13309885921493894_dp, &
             0.2116099978648675_dp, 0.33324397332534994_dp, 0.520135389350332_dp, &
             0.8051271507037135_dp, 1.2368297101804016_dp, 1.8874202255920585_dp, &
             2.8657495999327107_dp, 4.343203710677779_dp, 6.619798204398821_dp, &
             10.382740122400245_dp, &
             ! w
             2.2198007692752794e-09_dp, 1.4584487856974798e-08_dp, 5.97035871313473e-08_dp, &
             1.9408491042292773e-07_dp, 5.463999222944281e-07_dp, 1.3906185315580307e-06_dp, &
             3.2805653737773108e-06_dp, 7.2899494384881e-06_dp, 1.5429477070115167e-05_dp, &
             3.135551514537391e-05_dp, 6.155054986111361e-05_dp, 0.00011725546795021048_dp, &
             0.00021758343234217837_dp, 0.00039446765384570844_dp, 0.000700423081348753_dp, &
             0.0012205806683497074_dp, 0.0020911464726735816_dp, 0.0035274356929348564_dp, &
             0.0058660577993198005_dp, 0.009627854350868405_dp, 0.015611052488809464_dp, &
             0.025028123966485728_dp, 0.039705503519352585_dp, 0.062373345539213504_dp, &
             0.09708416244407876_dp, 0.14981724527046308_dp, 0.22935740198999327_dp, &
             0.34860301922190917_dp, 0.5266271133911862_dp, 0.7923109049864763_dp, &
             1.1920096286520587_dp, 1.8099953522781058_dp, 2.841800269675241_dp, &
             5.034276827593939_dp]

      CASE (855)

         aw(:) = & ! a
            [2.0404909110384475e-09_dp, 1.5151442097142887e-08_dp, 6.245416599662895e-08_dp, &
             2.0661940652827375e-07_dp, 5.959822274864856e-07_dp, 1.557575484071925e-06_dp, &
             3.7741601101992155e-06_dp, 8.60944555155634e-06_dp, 1.868879219385792e-05_dp, &
             3.8910961485681584e-05_dp, 7.81734938233369e-05_dp, 0.00015225985758064739_dp, &
             0.00028858964675804725_dp, 0.0005339159787935496_dp, 0.0009666276456836273_dp, &
             0.0017161644907638827_dp, 0.002993306589107769_dp, 0.005136925782329796_dp, &
             0.008685437210940068_dp, 0.014485001245983453_dp, 0.023851978787347662_dp, &
             0.03881489489843682_dp, 0.06247213087021271_dp, 0.09951701756574863_dp, &
             0.15700376412760972_dp, 0.2454584857259318_dp, 0.3804841923044579_dp, &
             0.5850764943121439_dp, 0.8929811589653015_dp, 1.3536502872809886_dp, &
             2.039888878054595_dp, 3.06078528102233_dp, 4.587461301561305_dp, &
             6.919354993331615_dp, 10.744151118313793_dp, &
             ! w
             5.671009581738294e-09_dp, 2.4055717463455767e-08_dp, 8.027675008113348e-08_dp, &
             2.3130933927897619e-07_dp, 5.99118177555492e-07_dp, 1.4326872059077528e-06_dp, &
             3.218491669573828e-06_dp, 6.873427000836394e-06_dp, 1.4074003413378896e-05_dp, &
             2.7806758956751627e-05_dp, 5.3272221379320055e-05_dp, 9.934598752612586e-05_dp, &
             0.00018090655818156425_dp, 0.00032249604517037945_dp, 0.0005640087632846268_dp, &
             0.0009694349082615356_dp, 0.0016401651235089072_dp, 0.0027350465332988154_dp, &
             0.004500354345088165_dp, 0.007314218975682474_dp, 0.011751982671632126_dp, &
             0.01868166624087445_dp, 0.029402505102421705_dp, 0.045844798655652684_dp, &
             0.07085679716737465_dp, 0.10861530420845496_dp, 0.1652139785801667_dp, &
             0.24951462076740005_dp, 0.3744144724200437_dp, 0.5588565709507807_dp, &
             0.8314194980761831_dp, 1.2379892279383173_dp, 1.8623478799739805_dp, &
             2.900038675886075_dp, 5.100932905035487_dp]

      CASE (856)

         aw(:) = & ! a
            [1.5552015829991145e-09_dp, 1.2165458305132021e-08_dp, 5.246790769760238e-08_dp, &
             1.7903697443025552e-07_dp, 5.278274428525224e-07_dp, 1.4021753681530081e-06_dp, &
             3.4413213768023774e-06_dp, 7.931839259075196e-06_dp, 1.7366505278388265e-05_dp, &
             3.642223298591174e-05_dp, 7.36341292184873e-05_dp, 0.00014420622070141634_dp, &
             0.000274649900170601_dp, 0.0005103207645559094_dp, 0.0009274940676298663_dp, &
             0.0016524656159344706_dp, 0.0028914126171122705_dp, 0.004976573092407527_dp, &
             0.008436949507025988_dp, 0.014105556864197068_dp, 0.023280697102297358_dp, &
             0.03796651503914784_dp, 0.06122909764046382_dp, 0.09771990332921691_dp, &
             0.15444018660992323_dp, 0.24185109094921042_dp, 0.37547892904451774_dp, &
             0.5782333621224738_dp, 0.8837708177359374_dp, 1.341461050138272_dp, &
             2.024048765020729_dp, 3.040601087855359_dp, 4.562267623789521_dp, &
             6.888542855611844_dp, 10.707056779390536_dp, &
             ! w
             4.387796674462411e-09_dp, 1.9959072281083754e-08_dp, 6.939677013157643e-08_dp, &
             2.0501552132463639e-07_dp, 5.404552447976642e-07_dp, 1.3098295095475104e-06_dp, &
             2.973970850137846e-06_dp, 6.406865977391905e-06_dp, 1.3215066049896975e-05_dp, &
             2.627365716243625e-05_dp, 5.06093080325915e-05_dp, 9.4831624379329e-05_dp, &
             0.00017341950865974504_dp, 0.00031032508213488913_dp, 0.000544586059463598_dp, &
             0.0009389693317150078_dp, 0.0015931472595080536_dp, 0.002663594024486951_dp, &
             0.004393365605889235_dp, 0.007156308081079714_dp, 0.01152218238536826_dp, &
             0.018351916051089393_dp, 0.028935995824406258_dp, 0.045194337267774165_dp, &
             0.06996350079953981_dp, 0.10740814493439677_dp, 0.1636109813522357_dp, &
             0.2474268182319067_dp, 0.37175387620169315_dp, 0.5555490237003874_dp, &
             0.827421543263676_dp, 1.2333038674610606_dp, 1.857025254461482_dp, &
             2.8941241139784153_dp, 5.094160649830687_dp]

      CASE (857)

         aw(:) = & ! a
            [9.459673535851904e-10_dp, 8.334293569930787e-09_dp, 3.917884706182252e-08_dp, &
             1.4122296908165727e-07_dp, 4.322980090687376e-07_dp, 1.1806338342062016e-06_dp, &
             2.960390093021729e-06_dp, 6.941898331244286e-06_dp, 1.5416820042415313e-05_dp, &
             3.272363662119428e-05_dp, 6.684179387016864e-05_dp, 0.00013208300653220852_dp, &
             0.00025355449893918686_dp, 0.0004744433496388714_dp, 0.0008677344348137625_dp, &
             0.0015548140641988004_dp, 0.0027346518092018373_dp, 0.004729070704264146_dp, &
             0.008052259415847064_dp, 0.013516497030495265_dp, 0.02239153661791747_dp, &
             0.036642900701831065_dp, 0.059285413846926246_dp, 0.09490393769073507_dp, &
             0.15041534012062396_dp, 0.23617702410022706_dp, 0.36759258852036963_dp, &
             0.5674338722755372_dp, 0.8692136769184071_dp, 1.3221689353918424_dp, &
             1.9989465693744168_dp, 3.0085785280197155_dp, 4.522258339234745_dp, &
             6.839571562391387_dp, 10.648063728448992_dp, &
             ! w
             2.7735062176295402e-09_dp, 1.4568310665755517e-08_dp, 5.446397060387528e-08_dp, &
             1.68002423961422e-07_dp, 4.5639610286526923e-07_dp, 1.1313606164769208e-06_dp, &
             2.614833864841551e-06_dp, 5.715318145586774e-06_dp, 1.1932023457972336e-05_dp, &
             2.3968219348236865e-05_dp, 4.658141851780609e-05_dp, 8.796787071664377e-05_dp, &
             0.00016198334441270982_dp, 0.000291657010094577_dp, 0.0005146826469277505_dp, &
             0.0008919026609983487_dp, 0.0015202793220082452_dp, 0.002552535131022295_dp, &
             0.004226624603766521_dp, 0.006909589259674551_dp, 0.011162306031160234_dp, &
             0.017834386703605473_dp, 0.028202329224935544_dp, 0.04416940427443703_dp, &
             0.06855337933855238_dp, 0.10549931378412311_dp, 0.16107214464250502_dp, &
             0.24411514375427973_dp, 0.36752769984961553_dp, 0.5502884646716867_dp, &
             0.8210557274560507_dp, 1.2258366023930047_dp, 1.8485367622980344_dp, &
             2.8846886380833974_dp, 5.083358231256422_dp]

      CASE (858)

         aw(:) = & ! a
            [7.273102982139781e-10_dp, 6.92144323944422e-09_dp, 3.407649049671692e-08_dp, &
             1.2625900830114456e-07_dp, 3.936654500762542e-07_dp, 1.0895684649343947e-06_dp, &
             2.7601558219033445e-06_dp, 6.52543820354918e-06_dp, 1.4589484764414247e-05_dp, &
             3.114260304069562e-05_dp, 6.391983656376198e-05_dp, 0.0001268388230454835_dp, &
             0.0002443843898432227_dp, 0.000458779248541801_dp, 0.0008415406084465976_dp, &
             0.0015118588711423079_dp, 0.00266547158729582_dp, 0.004619520499331146_dp, &
             0.007881521101534278_dp, 0.013254392156440174_dp, 0.02199497422207769_dp, &
             0.03605128830337178_dp, 0.0584148875534893_dp, 0.09364034750240999_dp, &
             0.14860609252418394_dp, 0.23362218152255373_dp, 0.3640361075094539_dp, &
             0.5625565704529129_dp, 0.8626304237072151_dp, 1.3134334337127707_dp, &
             1.9875672719429849_dp, 2.9940473014673312_dp, 4.504086900619768_dp, &
             6.8173135920763315_dp, 10.621235577151532_dp, &
             ! w
             2.192793031414204e-09_dp, 1.2521328564769824e-08_dp, 4.8548435607827576e-08_dp, &
             1.5297649793173104e-07_dp, 4.216837431485938e-07_dp, 1.0566964068481496e-06_dp, &
             2.4630156199409405e-06_dp, 5.420465198614438e-06_dp, 1.1381011734306003e-05_dp, &
             2.2971974106109578e-05_dp, 4.483142438962657e-05_dp, 8.49715438163735e-05_dp, &
             0.000156969743231988_dp, 0.0002834417190395827_dp, 0.0005014775802709292_dp, &
             0.0008710531515594637_dp, 0.0014879075446847592_dp, 0.002503066290644606_dp, &
             0.004152171578196498_dp, 0.006799174417995733_dp, 0.011000908768639673_dp, &
             0.017601826515960557_dp, 0.02787203366917738_dp, 0.0437071783022296_dp, &
             0.0679163991946226_dp, 0.10463572640173835_dp, 0.15992186392307833_dp, &
             0.24261266592466305_dp, 0.3656078912739175_dp, 0.547896008140713_dp, &
             0.818157663971773_dp, 1.2224342607686673_dp, 1.8446668174442742_dp, &
             2.8803857371110673_dp, 5.078432499169791_dp]

      CASE (859)

         aw(:) = & ! a
            [5.501377972845272e-10_dp, 5.751093865121371e-09_dp, 2.9728149442449127e-08_dp, &
             1.1325193515840639e-07_dp, 3.5961701638322006e-07_dp, 1.0084790431472421e-06_dp, &
             2.580420963636574e-06_dp, 6.1491842289532385e-06_dp, 1.3837993391706146e-05_dp, &
             2.969995165906444e-05_dp, 6.124314953114723e-05_dp, 0.0001220183601617238_dp, &
             0.0002359296853952235_dp, 0.0004442982069209724_dp, 0.0008172664042291088_dp, &
             0.0014719643281044014_dp, 0.0026010922800610695_dp, 0.004517386432482301_dp, &
             0.00772207362828217_dp, 0.013009240400590979_dp, 0.021623528561297456_dp, &
             0.03549640594646649_dp, 0.05759739083532943_dp, 0.09245235085315245_dp, &
             0.14690323107411135_dp, 0.2312151166379835_dp, 0.3606821436626231_dp, &
             0.5579528938458069_dp, 0.8564113398200852_dp, 1.305174822193762_dp, &
             1.9768016625798621_dp, 2.980291156210381_dp, 4.486875422479056_dp, &
             6.796222076734361_dp, 10.595804565593246_dp, &
             ! w
             1.72129509413978e-09_dp, 1.0788757961992678e-08_dp, 4.34033893993919e-08_dp, &
             1.3970375372857102e-07_dp, 3.906892431770502e-07_dp, 9.894818001539318e-07_dp, &
             2.325453493751884e-06_dp, 5.1518693164691434e-06_dp, 1.0876809771460424e-05_dp, &
             2.2056850075465586e-05_dp, 4.321854354441453e-05_dp, 8.22018408755955e-05_dp, &
             0.00015232319192638562_dp, 0.0002758099724183504_dp, 0.0004891844131686903_dp, &
             0.0008516059003545024_dp, 0.0014576595299728397_dp, 0.002456767642845342_dp, &
             0.0040823850792124005_dp, 0.0066955357450820185_dp, 0.01084921972511023_dp, &
             0.017382989899991905_dp, 0.027560875868666485_dp, 0.04327126948202192_dp, &
             0.06731508254199497_dp, 0.10381971847361003_dp, 0.15883398979585_dp, &
             0.24119051507594835_dp, 0.36378930949645155_dp, 0.5456280929355098_dp, &
             0.8154087470717531_dp, 1.2192053642258545_dp, 1.8409928150905468_dp, &
             2.8762999850320745_dp, 5.0737556591194934_dp]

      CASE (860)

         aw(:) = & ! a
            [4.795656899618547e-10_dp, 5.275703815294485e-09_dp, 2.7921936961144855e-08_dp, &
             1.0776855138181483e-07_dp, 3.4511636432440086e-07_dp, 9.736844316472588e-07_dp, &
             2.502848878810929e-06_dp, 5.986034679665068e-06_dp, 1.351087179459349e-05_dp, &
             2.9069913436937345e-05_dp, 6.0070889018443205e-05_dp, 0.00011990204924813175_dp, &
             0.00023220981941233054_dp, 0.0004379146334968274_dp, 0.0008065472901235645_dp, &
             0.0014543199897438439_dp, 0.0025725784880714616_dp, 0.004472092139150253_dp, &
             0.0076512775787345375_dp, 0.012900270912393746_dp, 0.021458253095558853_dp, &
             0.035249275775026304_dp, 0.057232977352526034_dp, 0.09192234367092901_dp, &
             0.14614293842620601_dp, 0.2301396354369227_dp, 0.35918257311636737_dp, &
             0.5558932713143581_dp, 0.8536273695258033_dp, 1.301475849667882_dp, &
             1.9719774360937354_dp, 2.9741241036848662_dp, 4.479156356463695_dp, &
             6.78675989973554_dp, 10.584392785622473_dp, &
             ! w
             1.5330775975217554e-09_dp, 1.0072592777311047e-08_dp, 4.1233529030227604e-08_dp, &
             1.340422980430436e-07_dp, 3.7736422726281444e-07_dp, 9.604131786140613e-07_dp, &
             2.265681137565567e-06_dp, 5.034711687200461e-06_dp, 1.0656173793936654e-05_dp, &
             2.1655291044486802e-05_dp, 4.2509110928099235e-05_dp, 8.098101071113425e-05_dp, &
             0.00015027125548183564_dp, 0.0002724341129320892_dp, 0.0004837383684753617_dp, &
             0.0008429786397978206_dp, 0.0014442239070924347_dp, 0.0024361788226602782_dp, &
             0.00405131814699903_dp, 0.006649353095299916_dp, 0.010781562935127904_dp, &
             0.017285299762391196_dp, 0.02742186100680197_dp, 0.043076372704118585_dp, &
             0.06704603983523175_dp, 0.10345437338343318_dp, 0.1583466170193326_dp, &
             0.2405530080379608_dp, 0.3629736465907005_dp, 0.5446103872659257_dp, &
             0.8141746527651287_dp, 1.217755263636201_dp, 1.8393423906044235_dp, &
             2.87446436738254_dp, 5.071654580814584_dp]

      CASE (861)

         aw(:) = & ! a
            [3.392583358853396e-10_dp, 3.705407847421689e-09_dp, 1.9547969316324468e-08_dp, &
             7.531481753745472e-08_dp, 2.4091140464501275e-07_dp, 6.791352064866371e-07_dp, &
             1.7446347371894621e-06_dp, 4.170585443286809e-06_dp, 9.409532747229403e-06_dp, &
             2.0238751058915135e-05_dp, 4.181005522936697e-05_dp, 8.343276424802206e-05_dp, &
             0.00016154635685945883_dp, 0.0003045953808677941_dp, 0.0005609055984931827_dp, &
             0.0010112379381757267_dp, 0.0017885524256270916_dp, 0.0031087711443333254_dp, &
             0.005318161337419406_dp, 0.008965610923402157_dp, 0.014911879199690583_dp, &
             0.024493347835706163_dp, 0.0397655254397142_dp, 0.06386247830017364_dp, &
             0.10152373304283478_dp, 0.15986182947659336_dp, 0.24947433688911422_dp, &
             0.3860484753741254_dp, 0.5926740547659806_dp, 0.9031945550767589_dp, &
             1.3671519011160778_dp, 2.0574165664603616_dp, 3.0830995364239744_dp, &
             4.6152917919308_dp, 6.953369872081639_dp, 10.785080428126326_dp, &
             ! w
             1.081197541465692e-09_dp, 7.057546012719769e-09_dp, 2.8822924800821273e-08_dp, &
             9.357227178628371e-08_dp, 2.631937344316969e-07_dp, 6.694025142445665e-07_dp, &
             1.5783645920007254e-06_dp, 3.505951732103351e-06_dp, 7.417989674212712e-06_dp, &
             1.5070419626413703e-05_dp, 2.9575843759692954e-05_dp, 5.633078152174802e-05_dp, &
             0.00010450977666290101_dp, 0.0001894392058605559_dp, 0.0003363207835330652_dp, &
             0.0005860042494920928_dp, 0.001003841266152317_dp, 0.0016931309203139233_dp, &
             0.0028153507775786333_dp, 0.004620337979483453_dp, 0.007490954836592828_dp, &
             0.012008696996148273_dp, 0.01904939166402658_dp, 0.029921884640777753_dp, &
             0.04656785882493066_dp, 0.07184834939142913_dp, 0.10995340151492985_dp, &
             0.16698854965561868_dp, 0.2518230788634322_dp, 0.3773529364199611_dp, &
             0.5625057841387796_dp, 0.835826435070735_dp, 1.2431500487196163_dp, &
             1.8682075366993838_dp, 2.906548354818295_dp, 5.108387324537728_dp]

      CASE (862)

         aw(:) = & ! a
            [3.329072871147675e-10_dp, 3.662314947938072e-09_dp, 1.9382993219528176e-08_dp, &
             7.481132499363417e-08_dp, 2.3957464161332234e-07_dp, 6.759172303023454e-07_dp, &
             1.7374404182342651e-06_dp, 4.155416159138349e-06_dp, 9.379046108211077e-06_dp, &
             2.0179901353788283e-05_dp, 4.170031748715146e-05_dp, 8.323421874749814e-05_dp, &
             0.00016119660119902853_dp, 0.00030399382120456324_dp, 0.0005598931258518388_dp, &
             0.0010095672965028727_dp, 0.0017858457088413715_dp, 0.0031044598168517607_dp, &
             0.005311402981355091_dp, 0.008955175650515658_dp, 0.014895997489399928_dp, &
             0.024469510769387342_dp, 0.039730228392519856_dp, 0.06381090092779189_dp, &
             0.10144935310642798_dp, 0.159755977485009_dp, 0.24932571510931534_dp, &
             0.3858426912109153_dp, 0.5923932567531252_dp, 0.902817307605135_dp, &
             1.3666534782846926_dp, 2.0567698495017077_dp, 3.0822765871630686_dp, &
             4.614265810844391_dp, 6.952116312486334_dp, 10.78357243640815_dp, &
             ! w
             1.064239538542959e-09_dp, 6.992243974998484e-09_dp, 2.8623702853486623e-08_dp, &
             9.305016783313152e-08_dp, 2.6196062493949314e-07_dp, 6.667045223515356e-07_dp, &
             1.572802116710582e-06_dp, 3.4950219250489134e-06_dp, 7.3973572937877945e-06_dp, &
             1.5032780928517235e-05_dp, 2.950919248637152e-05_dp, 5.621581255601728e-05_dp, &
             0.00010431606865939922_dp, 0.00018911970640661012_dp, 0.00033580397787619394_dp, &
             0.0005851832304937521_dp, 0.0010025587481569374_dp, 0.0016911590725387227_dp, &
             0.0028123646306223308_dp, 0.004615881147376204_dp, 0.007484396507001683_dp, &
             0.01199917973489485_dp, 0.01903577080114698_dp, 0.029902662228873705_dp, &
             0.04654111888927471_dp, 0.07181170702834291_dp, 0.10990398689942509_dp, &
             0.16692305916549058_dp, 0.25173793735039257_dp, 0.37724462035817535_dp, &
             0.5623713386265379_dp, 0.8356641474631866_dp, 1.2429600703936776_dp, &
             1.8679918909273818_dp, 2.906308818157737_dp, 5.10811301135789_dp]

      CASE (863)

         aw(:) = & ! a
            [2.7050727917365697e-10_dp, 2.813067805178994e-09_dp, 1.4504351493006907e-08_dp, &
             5.5177418752615494e-08_dp, 1.7504726861967963e-07_dp, 4.905635849651036e-07_dp, &
             1.2545879366100444e-06_dp, 2.9885144120138355e-06_dp, 6.723103566240445e-06_dp, &
             1.4425612830626782e-05_dp, 2.9739611597429572e-05_dp, 5.924009312529937e-05_dp, &
             0.00011452404284250141_dp, 0.00021563581813658367_dp, 0.00039659700822371413_dp, &
             0.0007142142731290889_dp, 0.0012619365805488006_dp, 0.002191411211738429_dp, &
             0.003745667097083974_dp, 0.0063097044048837135_dp, 0.010486927767345493_dp, &
             0.017213655832383212_dp, 0.027929326261874537_dp, 0.04482761898970188_dp, &
             0.07122440580773219_dp, 0.112093406541656_dp, 0.1748414232337484_dp, &
             0.2704246996399173_dp, 0.41495096922847297_dp, 0.6319777889621487_dp, &
             0.955830673316784_dp, 1.4364909250163393_dp, 2.147144751405847_dp, &
             3.1970058826101844_dp, 4.7570068157244645_dp, 7.126223965513759_dp, &
             10.99274096225511_dp, &
             ! w
             8.445518525777438e-10_dp, 5.267220940668875e-09_dp, 2.115025761353554e-08_dp, &
             6.800360859927778e-08_dp, 1.9003765150769885e-07_dp, 4.810434430050926e-07_dp, &
             1.1300681762979004e-06_dp, 2.5027497194110852e-06_dp, 5.2824410404067726e-06_dp, &
             1.0709658988930224e-05_dp, 2.098048164453259e-05_dp, 3.9898003499085404e-05_dp, &
             7.392117665509561e-05_dp, 0.00013382995052025227_dp, 0.00023733540463421102_dp, &
             0.00041312381816434416_dp, 0.0007070557331304373_dp, 0.0011915748379394996_dp, &
             0.0019798582465593113_dp, 0.0032469164023683655_dp, 0.005260805535715079_dp, &
             0.008428455313462943_dp, 0.013362485190068375_dp, 0.020977985759496356_dp, &
             0.03263185739311718_dp, 0.050322340971325895_dp, 0.07697351747735423_dp, &
             0.11684008476052864_dp, 0.17608462030417454_dp, 0.26361077305794905_dp, &
             0.39230462037391517_dp, 0.5810141285826121_dp, 0.8581145953532153_dp, &
             1.2691905053037102_dp, 1.8977256131017224_dp, 2.9393154023620687_dp, &
             5.145921832303291_dp]

      CASE (864)

         aw(:) = & ! a
            [2.3223809533593075e-10_dp, 2.5548525700026827e-09_dp, 1.3521690647374615e-08_dp, &
             5.218882238904843e-08_dp, 1.6712868535593794e-07_dp, 4.71523852400667e-07_dp, &
             1.2120486972284278e-06_dp, 2.8988428522425992e-06_dp, 6.542877947692505e-06_dp, &
             1.4077618336156324e-05_dp, 2.9090387681010915e-05_dp, 5.806468239012859e-05_dp, &
             0.00011245170060447553_dp, 0.0002120678841745571_dp, 0.0003905847495050863_dp, &
             0.0007042801048151832_dp, 0.001245816505615695_dp, 0.0021656894829751626_dp, &
             0.0037052660262028234_dp, 0.0062471831872836225_dp, 0.010391534845589415_dp, &
             0.017070071056798336_dp, 0.02771602434200755_dp, 0.044514788524076976_dp, &
             0.07077137499221725_dp, 0.11144556720721385_dp, 0.1739267230431123_dp, &
             0.2691499062351607_dp, 0.4131981196008556_dp, 0.6296015336960243_dp, &
             0.9526575858253767_dp, 1.4323221590650272_dp, 2.141763405285866_dp, &
             3.190189480361361_dp, 4.748542405937515_dp, 7.11591591673899_dp, &
             10.98037252208453_dp, &
             ! w
             7.424198019512169e-10_dp, 4.877830736506225e-09_dp, 1.9968064261070726e-08_dp, &
             6.491234680942004e-08_dp, 1.827452793063261e-07_dp, 4.650970123373595e-07_dp, &
             1.0971960445208527e-06_dp, 2.4381479322368006e-06_dp, 5.1604401244578374e-06_dp, &
             1.0486956727911022e-05_dp, 2.0585786887486293e-05_dp, 3.9216482693669525e-05_dp, &
             7.277150526564754e-05_dp, 0.00013193102348360233_dp, 0.00023425883692867235_dp, &
             0.00040822727494996004_dp, 0.0006993908971389594_dp, 0.00117976253639384_dp, &
             0.0019619220982421723_dp, 0.003220065622262208_dp, 0.005221157791429877_dp, &
             0.008370692603248566_dp, 0.013279440906297863_dp, 0.020860171424618917_dp, &
             0.03246695580861332_dp, 0.05009472244998444_dp, 0.07666388190681526_dp, &
             0.11642539810883232_dp, 0.1755385982113957_dp, 0.26290524870500614_dp, &
             0.39141216335330475_dp, 0.579912127924652_dp, 0.8567904481416502_dp, &
             1.2676462081814954_dp, 1.8959773047190693_dp, 2.937375826976212_dp, &
             5.143699493975404_dp]

      CASE (865)

         aw(:) = & ! a
            [2.2945118174358155e-10_dp, 2.236789221523896e-09_dp, 1.1158861937845354e-08_dp, &
             4.166303566457208e-08_dp, 1.3056072174388643e-07_dp, 3.6268035326635414e-07_dp, &
             9.213263312298933e-07_dp, 2.1829937398352367e-06_dp, 4.88958605943292e-06_dp, &
             1.0453197063540192e-05_dp, 2.1483026489780754e-05_dp, 4.267783321941021e-05_dp, &
             8.231026427586508e-05_dp, 0.0001546557105438077_dp, 0.0002839087187801501_dp, &
             0.0005104141762953134_dp, 0.000900460949269449_dp, 0.0015615026271285923_dp, &
             0.0026655683888016915_dp, 0.004484925717776435_dp, 0.0074459215148885895_dp, &
             0.012209588937764982_dp, 0.019791381285845417_dp, 0.0317377177518386_dp, &
             0.050384497973931804_dp, 0.07923318813331695_dp, 0.12349465225281009_dp, &
             0.1908712633967883_dp, 0.2926765806444099_dp, 0.44543365732944873_dp, &
             0.6731576869426142_dp, 1.0106406489859432_dp, 1.5082829523572383_dp, &
             2.2395645825450092_dp, 3.3137843396874542_dp, 4.901711167282969_dp, &
             7.302136973110393_dp, 11.203524953934489_dp, &
             ! w
             6.981670824547048e-10_dp, 4.086491860878355e-09_dp, 1.600596587105048e-08_dp, &
             5.073216769045445e-08_dp, 1.4040510764370505e-07_dp, 3.528823060596037e-07_dp, &
             8.244147487705258e-07_dp, 1.8176967643122893e-06_dp, 3.822385115608636e-06_dp, &
             7.725351436438007e-06_dp, 1.5093509940158535e-05_dp, 2.8635653696217524e-05_dp, &
             5.294508343880973e-05_dp, 9.567727491034868e-05_dp, 0.00016939399254351406_dp, &
             0.00029441781083090263_dp, 0.0005032039362582628_dp, 0.0008469703718650195_dp, &
             0.0014056617262180801_dp, 0.0023027961295353136_dp, 0.003727413362833333_dp, &
             0.005966280010262805_dp, 0.009450815808112583_dp, 0.014825022852009371_dp, &
             0.023043216169087073_dp, 0.035509837831885896_dp, 0.05427848561208271_dp, &
             0.0823341648692915_dp, 0.12399298590855426_dp, 0.18547015078704393_dp, &
             0.27569834144769756_dp, 0.4075483905474138_dp, 0.5997849192414254_dp, &
             0.8806145036673687_dp, 1.2953791544550293_dp, 1.9273324514130719_dp, &
             2.9721397505598137_dp, 5.18354241622047_dp]

      CASE (866)

         aw(:) = & ! a
            [1.627773533696555e-10_dp, 1.7907145058210283e-09_dp, 9.477449897827619e-09_dp, &
             3.657951939796529e-08_dp, 1.1714169193845674e-07_dp, 3.3049444220489384e-07_dp, &
             8.495336022857259e-07_dp, 2.0318196869811795e-06_dp, 4.585949937197469e-06_dp, &
             9.867103333977011e-06_dp, 2.0389660664556974e-05_dp, 4.069795088124818e-05_dp, &
             7.881820056406125e-05_dp, 0.00014863989535252538_dp, 0.0002737636415793902_dp, &
             0.00049363495690335_dp, 0.00087320168794787_dp, 0.0015179472257090194_dp, &
             0.0025970474096114683_dp, 0.004378695249504787_dp, 0.007283500687029226_dp, &
             0.011964533372297147_dp, 0.019426353646006755_dp, 0.031200709295417545_dp, &
             0.04960406591838591_dp, 0.07811261714993682_dp, 0.12190504606859975_dp, &
             0.1886437544988354_dp, 0.28959415083738266_dp, 0.44122352910489177_dp, &
             0.667485892728579_dp, 1.0031111489938538_dp, 1.498444290178079_dp, &
             2.226926890203937_dp, 3.297847256976004_dp, 4.881996677977977_dp, &
             7.278204550291025_dp, 11.174880353105213_dp, &
             ! w
             5.203673781182756e-10_dp, 3.418906540813733e-09_dp, 1.3995759270808395e-08_dp, &
             4.549752855488943e-08_dp, 1.2808747389876508e-07_dp, 3.2598982288820183e-07_dp, &
             7.690325540788448e-07_dp, 1.7089153181882928e-06_dp, 3.6169893733358534e-06_dp, &
             7.350382926787106e-06_dp, 1.4428725148402996e-05_dp, 2.748711295331599e-05_dp, &
             5.100606799728638e-05_dp, 9.24713969203283e-05_dp, 0.00016419369226197304_dp, &
             0.0002861294128959885_dp, 0.0004902080744631261_dp, 0.0008269039834466523_dp, &
             0.0013751251887025309_dp, 0.002256966889514848_dp, 0.003659546326632952_dp, &
             0.005867076248410409_dp, 0.00930764668530082_dp, 0.014621009486664985_dp, &
             0.022756188494488943_dp, 0.03511123956677575_dp, 0.05373235918963343_dp, &
             0.081596452794681_dp, 0.12301152855616211_dp, 0.1841859388630058_dp, &
             0.2740487504612439_dp, 0.40547315686061075_dp, 0.5972352306336853_dp, &
             0.8775642682301003_dp, 1.2918345350087896_dp, 1.923329709950198_dp, &
             2.967704352755607_dp, 5.178457714689406_dp]

      CASE (867)

         aw(:) = & ! a
            [2.0110245477708717e-10_dp, 1.8338324051049543e-09_dp, 8.807415909952976e-09_dp, &
             3.215940396296987e-08_dp, 9.929980776260292e-08_dp, 2.7290863658649594e-07_dp, &
             6.876284979298008e-07_dp, 1.6186873301191621e-06_dp, 3.6062907206598513e-06_dp, &
             7.6751849367455e-06_dp, 1.5713371678780415e-05_dp, 3.111224801348558e-05_dp, &
             5.982936132480508e-05_dp, 0.00011212459871159381_dp, 0.00020535557778846914_dp, &
             0.00036841925059189753_dp, 0.0006487242102097525_dp, 0.0011230143308221144_dp, &
             0.0019139989312549359_dp, 0.003215661316028958_dp, 0.005331432869723926_dp, &
             0.008731295357066737_dp, 0.01413653243150883_dp, 0.022644598474384287_dp, &
             0.03591182759727779_dp, 0.05641904104445589_dp, 0.08785531525625187_dp, &
             0.13566934692892502_dp, 0.20785760044585336_dp, 0.3160862927213594_dp, &
             0.4772848999702004_dp, 0.7159122693612_dp, 1.067207640356472_dp, &
             1.581967430173526_dp, 2.3339420796308366_dp, 3.432498353923494_dp, &
             5.048238919789414_dp, 7.479689259581741_dp, 11.415730590902372_dp, &
             ! w
             5.968418225139929e-10_dp, 3.256902745695496e-09_dp, 1.23857558738077e-08_dp, &
             3.8590143681169086e-08_dp, 1.0555800971710985e-07_dp, 2.630108793498219e-07_dp, &
             6.103173029981139e-07_dp, 1.3383222923915242e-06_dp, 2.801599169012276e-06_dp, &
             5.640559130663436e-06_dp, 1.0983914271100391e-05_dp, 2.0778719289679447e-05_dp, &
             3.832025901328514e-05_dp, 6.909117742429718e-05_dp, 0.00012207380160977687_dp, &
             0.00021177912777321258_dp, 0.00036135095050280117_dp, 0.0006072687863640266_dp, &
             0.0010064088604687794_dp, 0.0016465564417445658_dp, 0.002661933533266697_dp, &
             0.004255965622935348_dp, 0.006734430985166784_dp, 0.010553412411735606_dp, &
             0.0163882354602878_dp, 0.02523200972218895_dp, 0.038535745364557325_dp, &
             0.05840668195591196_dp, 0.08788809845020105_dp, 0.1313538016715104_dp, &
             0.19506688722482382_dp, 0.28798374295812257_dp, 0.4229550808489394_dp, &
             0.61865966279584_dp, 0.9031378946925505_dp, 1.3214995288270444_dp, &
             1.9567862623295684_dp, 3.004755479292111_dp, 5.220944579946335_dp]

      CASE (868)

         aw(:) = & ! a
            [1.3437407957628294e-10_dp, 1.394435117442241e-09_dp, 7.182416370397351e-09_dp, &
             2.730762635219069e-08_dp, 8.659943689850386e-08_dp, 2.426266359935003e-07_dp, &
             6.203769710828572e-07_dp, 1.4775414461536802e-06_dp, 3.3235077272525825e-06_dp, &
             7.130386890620804e-06_dp, 1.4698503575742955e-05_dp, 2.9276426895387725e-05_dp, &
             5.659367477926323e-05_dp, 0.00010655272455203315_dp, 0.00019596046011447957_dp, &
             0.00035287861780045976_dp, 0.0006234680691090676_dp, 0.0010826353365572625_dp, &
             0.0018504214257018725_dp, 0.00311698677585132_dp, 0.005180358845163511_dp, &
             0.008502982778956166_dp, 0.0137957746998753_dp, 0.022142129183443573_dp, &
             0.03517959919216362_dp, 0.055364325593348813_dp, 0.08635353841042134_dp, &
             0.133555692755207_dp, 0.20491765353690566_dp, 0.31204635865545577_dp, &
             0.47180320835663564_dp, 0.7085730265790277_dp, 1.0575207708426249_dp, &
             1.569377494464927_dp, 2.3178494973959336_dp, 3.4122931937413927_dp, &
             5.0233395086820165_dp, 7.44955770067443_dp, 11.379755680958926_dp, &
             ! w
             4.191664346120608e-10_dp, 2.6089588688151355e-09_dp, 1.0468130286223671e-08_dp, &
             3.3643036769489804e-08_dp, 9.398846452500873e-08_dp, 2.3786195133169826e-07_dp, &
             5.586918258276425e-07_dp, 1.2371613813655595e-06_dp, 2.6109285954306044e-06_dp, &
             5.2929147333749965e-06_dp, 1.0368104898601239e-05_dp, 1.9715340761791163e-05_dp, &
             3.652538653572135e-05_dp, 6.612338220154368e-05_dp, 0.00011725801191083363_dp, &
             0.00020409884978220548_dp, 0.00034929796569896756_dp, 0.0005886366895568365_dp, &
             0.0009780138452581346_dp, 0.0016038658744798612_dp, 0.002598580623374784_dp, &
             0.004163127844701338_dp, 0.006600052344705271_dp, 0.0103612575059776_dp, &
             0.016116780142495173_dp, 0.0248532042239162_dp, 0.038013738061316395_dp, &
             0.057696674716920054_dp, 0.086935627515981_dp, 0.1300949069929207_dp, &
             0.19342983663305913_dp, 0.2858931576619781_dp, 0.4203393077502191_dp, &
             0.6154617200199481_dp, 0.8993286990143969_dp, 1.3170885493613784_dp, &
             1.9518175383752772_dp, 2.9992559944657904_dp, 5.214636570200131_dp]

      CASE (869)

         aw(:) = & ! a
            [1.1461086022774257e-10_dp, 1.2608347250132962e-09_dp, 6.673033667984663e-09_dp, &
             2.575549013295909e-08_dp, 8.247898723430502e-08_dp, 2.3269978923779006e-07_dp, &
             5.981531480027921e-07_dp, 1.4305959676725715e-06_dp, 3.228948684387716e-06_dp, &
             6.947387310005722e-06_dp, 1.4356277138447397e-05_dp, 2.8655261720711888e-05_dp, &
             5.5495574585592494e-05_dp, 0.00010465674615477689_dp, 0.00019275586749572236_dp, &
             0.0003475663673951903_dp, 0.0006148177608579328_dp, 0.00106878047475534_dp, &
             0.0018285705285470502_dp, 0.0030830215211253426_dp, 0.005128283157424972_dp, &
             0.008424178921800203_dp, 0.013678014816836058_dp, 0.021968284790503695_dp, &
             0.03492598935918093_dp, 0.05499865095545739_dp, 0.08583236888122585_dp, &
             0.13282152092465668_dp, 0.20389560571516557_dp, 0.31064078687415264_dp, &
             0.46989458452296523_dp, 0.7060158287076141_dp, 1.0541433595112948_dp, &
             1.5649852096369112_dp, 2.3122320851617952_dp, 3.4052366718264238_dp, &
             5.014639770016525_dp, 7.439026076814212_dp, 11.367178106006026_dp, &
             ! w
             3.6638852279553266e-10_dp, 2.407238083730855e-09_dp, 9.854356896796465e-09_dp, &
             3.2034624171816796e-08_dp, 9.018586815469553e-08_dp, 2.295281062121795e-07_dp, &
             5.414726900926578e-07_dp, 1.2032403206360924e-06_dp, 2.5467075030109347e-06_dp, &
             5.175374725183649e-06_dp, 1.0159206712131733e-05_dp, 1.9353564498412823e-05_dp, &
             3.591316518515371e-05_dp, 6.510873482882477e-05_dp, 0.00011560811164678087_dp, &
             0.00020146255728214422_dp, 0.00034515351392672405_dp, 0.0005822197351342528_dp, &
             0.000968220054250909_dp, 0.0015891211893639553_dp, 0.00257667155972031_dp, &
             0.004130983911249265_dp, 0.006553473489839261_dp, 0.010294582215337335_dp, &
             0.016022495685632254_dp, 0.024721511373378826_dp, 0.037832100920601575_dp, &
             0.057449415326799494_dp, 0.08660366815696913_dp, 0.1296558226514676_dp, &
             0.19285845203915086_dp, 0.2851629875173099_dp, 0.4194251399966698_dp, &
             0.6143434617793996_dp, 0.8979960380691173_dp, 1.3155447308950585_dp, &
             1.950078022130876_dp, 2.9973304142716617_dp, 5.212428037833929_dp]

      CASE (870)

         aw(:) = & ! a
            [1.80034357509866e-10_dp, 1.5405013996706422e-09_dp, 7.103368535354762e-09_dp, &
             2.530280891820828e-08_dp, 7.683577248880414e-08_dp, 2.0861752148453446e-07_dp, &
             5.207433286367151e-07_dp, 1.216699994028169e-06_dp, 2.694061531798567e-06_dp, &
             5.704086825668886e-06_dp, 1.1626269985033553e-05_dp, 2.293131953098188e-05_dp, &
             4.394817784536967e-05_dp, 8.211470613775864e-05_dp, 0.00014998792027380388_dp, &
             0.0002684330537629704_dp, 0.0004716224577744553_dp, 0.0008147854703367764_dp, &
             0.001386101183773497_dp, 0.002324776683503002_dp, 0.0038482861854482455_dp, &
             0.006293075598961585_dp, 0.01017491953505094_dp, 0.01627776928678679_dp, &
             0.025783645557273145_dp, 0.040461310593182864_dp, 0.06293864916806174_dp, &
             0.09709364948569206_dp, 0.14861265890347927_dp, 0.2257837469788173_dp, &
             0.3406200422415268_dp, 0.5104474754575444_dp, 0.7601536649641217_dp, &
             1.1254053791908751_dp, 1.657372003368264_dp, 2.4300518688154322_dp, &
             3.5528639235298303_dp, 5.196243193932063_dp, 7.658467241843419_dp, &
             11.628871207180643_dp, &
             ! w
             5.226128671451475e-10_dp, 2.6546082845004817e-09_dp, 9.769882587329497e-09_dp, &
             2.985934795899477e-08_dp, 8.059979543357828e-08_dp, 1.9884881037203774e-07_dp, &
             4.5787085477116726e-07_dp, 9.97750720446966e-07_dp, 2.077775594598853e-06_dp, &
             4.164741167064495e-06_dp, 8.079041450382808e-06_dp, 1.5232341902667766e-05_dp, &
             2.8008486112910915e-05_dp, 5.036571962701152e-05_dp, 8.877711872629837e-05_dp, &
             0.00015368261208308713_dp, 0.00026170762634631685_dp, 0.0004390205403531246_dp, &
             0.0007263681152204182_dp, 0.0011865646089542917_dp, 0.0019155433926019802_dp, &
             0.003058546388584826_dp, 0.0048336765941428845_dp, 0.007565940102885534_dp, &
             0.011736148052913429_dp, 0.018050760286625812_dp, 0.02754110247998155_dp, &
             0.041703621225533005_dp, 0.06269733221320213_dp, 0.0936210214480219_dp, &
             0.13890243522706044_dp, 0.2048479169193073_dp, 0.3004324997835046_dp, &
             0.4384823823409449_dp, 0.6375886226729988_dp, 0.9256286967007789_dp, &
             1.3474906868449552_dp, 1.9860223285698502_dp, 3.0370935753224853_dp, &
             5.258049117224792_dp]

      CASE (871)

         aw(:) = & ! a
            [1.1458994531303259e-10_dp, 1.116463899865673e-09_dp, 5.568167531773443e-09_dp, &
             2.078595619395463e-08_dp, 6.513033407237547e-08_dp, 1.809089198308219e-07_dp, &
             4.595395122036253e-07_dp, 1.088781509339231e-06_dp, 2.438613808513792e-06_dp, &
             5.213214035322539e-06_dp, 1.0713700095419553e-05_dp, 2.1283136860042053e-05_dp, &
             4.104666176512367e-05_dp, 7.712256170413337e-05_dp, 0.00014157505436499074_dp, &
             0.0002545212186276719_dp, 0.0004490141548139169_dp, 0.0007786320645723325_dp, &
             0.0013291508421305036_dp, 0.0022363252683017592_dp, 0.0037127336305645057_dp, &
             0.006087967115884585_dp, 0.009868326679217646_dp, 0.01582484332892341_dp, &
             0.025122159864475007_dp, 0.03950600835943753_dp, 0.06157424130511713_dp, &
             0.09516638518906102_dp, 0.14592054779743022_dp, 0.2220657865284112_dp, &
             0.3355452449512651_dp, 0.5036051402007276_dp, 0.751047197659662_dp, &
             1.1134529186647788_dp, 1.6419177490725296_dp, 2.410391428838679_dp, &
             3.5282835138536948_dp, 5.166063146430546_dp, 7.62205675937331_dp, &
             11.585504470872786_dp, &
             ! w
             3.4859746803257895e-10_dp, 2.0392735350586325e-09_dp, 7.985636080747364e-09_dp, &
             2.5307826252775974e-08_dp, 7.003516072061651e-08_dp, 1.7600901424967307e-07_dp, &
             4.111770384039354e-07_dp, 9.06539741021209e-07_dp, 1.9062734141219702e-06_dp, &
             3.852623588770603e-06_dp, 7.526930208082628e-06_dp, 1.4279908151413794e-05_dp, &
             2.6401932127648204e-05_dp, 4.77102316600423e-05_dp, 8.446837321735595e-05_dp, &
             0.00014680952312298912_dp, 0.0002509162182496244_dp, 0.0004223261113245025_dp, &
             0.0007008998079551283_dp, 0.0011482233082181546_dp, 0.0018585509068544917_dp, &
             0.002974861829426026_dp, 0.004712255870787982_dp, 0.007391818275602717_dp, &
             0.011489334718914918_dp, 0.017704959303613124_dp, 0.027062305026851263_dp, &
             0.04104868349187665_dp, 0.06181274584595445_dp, 0.09244222631772768_dp, &
             0.13735421432130254_dp, 0.20284663484600096_dp, 0.29789112748955615_dp, &
             0.43531920405882435_dp, 0.6337398638085372_dp, 0.9210634008158828_dp, &
             1.3422220745264866_dp, 1.9801016088953018_dp, 3.030547498797203_dp, &
             5.2505365021420545_dp]

      CASE (872)

         aw(:) = & ! a
            [8.105036917128686e-11_dp, 8.916353918126276e-10_dp, 4.7190267069906185e-09_dp, &
             1.8213731835744166e-08_dp, 5.8327376876995756e-08_dp, 1.645603184165264e-07_dp, &
             4.2300112342242466e-07_dp, 1.0116868884019828e-06_dp, 2.283443477517136e-06_dp, &
             4.913043750153079e-06_dp, 1.0152452173548074e-05_dp, 2.0264388298285887e-05_dp, &
             3.92452837680488e-05_dp, 7.401101339962555e-05_dp, 0.00013631282837049745_dp, &
             0.00024579150332763356_dp, 0.0004347859730760208_dp, 0.0007558186939911443_dp, &
             0.0012931259643688805_dp, 0.0021802468594143472_dp, 0.0036266120961004223_dp, &
             0.005957398933814257_dp, 0.009672798752113888_dp, 0.015535498218662989_dp, &
             0.02469890141113428_dp, 0.038893826398058474_dp, 0.06069865207635582_dp, &
             0.09392793392500058_dp, 0.14418842113098004_dp, 0.21967076097336_dp, &
             0.3322724852250308_dp, 0.4991877864016212_dp, 0.7451622457727589_dp, &
             1.1057215271516696_dp, 1.6319125355768132_dp, 2.3976529602163463_dp, &
             3.5123459308547855_dp, 5.146482746883756_dp, 7.598422005925609_dp, &
             11.557342842902521_dp, &
             ! w
             2.5910215815768987e-10_dp, 1.7023473117535032e-09_dp, 6.968790345311862e-09_dp, &
             2.26542014335368e-08_dp, 6.377751905955557e-08_dp, 1.623173723922451e-07_dp, &
             3.829179119127959e-07_dp, 8.509058288835969e-07_dp, 1.8009770883024804e-06_dp, &
             3.659914315003767e-06_dp, 7.184373707254334e-06_dp, 1.3686427013509861e-05_dp, &
             2.5397022735876466e-05_dp, 4.6043505365669545e-05_dp, 8.175558450552733e-05_dp, &
             0.00014247001207718467_dp, 0.00024408518283574346_dp, 0.0004117333417667165_dp, &
             0.0006847045048475441_dp, 0.0011237924899204165_dp, 0.0018221669371960608_dp, &
             0.0029213431990782026_dp, 0.004634475275940993_dp, 0.007280104436267471_dp, &
             0.011330751054239988_dp, 0.017482466213982608_dp, 0.026753836995530602_dp, &
             0.04062621275651319_dp, 0.06124146760061116_dp, 0.09168009304196569_dp, &
             0.1363521718502062_dp, 0.20155005930086692_dp, 0.29624308367084384_dp, &
             0.4332661205863603_dp, 0.631239796098427_dp, 0.9180958077289131_dp, &
             1.3387953539315174_dp, 1.9762492265218348_dp, 3.0262874562406465_dp, &
             5.245647926948447_dp]

      CASE (873)

         aw(:) = & ! a
            [1.6364137384434621e-10_dp, 1.3210377486271154e-09_dp, 5.841176464767646e-09_dp, &
             2.026080632715249e-08_dp, 6.041472374937316e-08_dp, 1.6185001549675903e-07_dp, &
             3.998368441888749e-07_dp, 9.264595243070832e-07_dp, 2.0373470623000663e-06_dp, &
             4.288697454214027e-06_dp, 8.697987981261276e-06_dp, 1.708153989761005e-05_dp, &
             3.261243858267086e-05_dp, 6.0728323076307486e-05_dp, 0.00011058765397849812_dp, &
             0.0001973758610700513_dp, 0.0003459143773026472_dp, 0.0005962473693796777_dp, &
             0.0010122030565147162_dp, 0.0016943909235004747_dp, 0.0027997613670785186_dp, &
             0.004570801293535262_dp, 0.00737877934310612_dp, 0.011787340505097048_dp, &
             0.018645390474000836_dp, 0.029221888997446103_dp, 0.045400274230782384_dp, &
             0.06995729131769945_dp, 0.10696071821412645_dp, 0.16233388334639812_dp, &
             0.24465345780070938_dp, 0.3662732491751197_dp, 0.5449053129458524_dp, &
             0.8058510442237334_dp, 1.1851852851318976_dp, 1.7344281107172446_dp, &
             2.527804393083869_dp, 3.6747708749408012_dp, 5.345594588084227_dp, &
             7.838323572595179_dp, 11.84278077937327_dp, &
             ! w
             4.661586414112498e-10_dp, 2.2071904993484876e-09_dp, 7.842428587543773e-09_dp, &
             2.3472210508842365e-08_dp, 6.24437139345481e-08_dp, 1.5238245126579308e-07_dp, &
             3.478738057185164e-07_dp, 7.527694421132782e-07_dp, 1.5584826437792473e-06_dp, &
             3.1083643595302936e-06_dp, 6.003937668050791e-06_dp, 1.1277343727454584e-05_dp, &
             2.066715437902478e-05_dp, 3.705364026187104e-05_dp, 6.5137343685239e-05_dp, &
             0.00011248518204743692_dp, 0.0001911265907578534_dp, 0.0003199657632613632_dp, &
             0.0005283950291749178_dp, 0.0008616628070338599_dp, 0.0013887865161319691_dp, &
             0.0022141324149550163_dp, 0.003494245933736811_dp, 0.005462155552577028_dp, &
             0.008462255215462058_dp, 0.013000081745253118_dp, 0.019812962852473352_dp, &
             0.029969781075366728_dp, 0.04501121380589444_dp, 0.0671461362956841_dp, &
             0.09952607060488151_dp, 0.1466290177979314_dp, 0.2148001059484958_dp, &
             0.3130282725568901_dp, 0.4541112600230295_dp, 0.6565510790438718_dp, &
             0.9480658799901298_dp, 1.3733326062444926_dp, 2.0150222098293096_dp, &
             3.0691362783428544_dp, 5.294835469191273_dp]

      CASE (874)

         aw(:) = & ! a
            [1.0077830992332914e-10_dp, 9.20122346669601e-10_dp, 4.4223948088085445e-09_dp, &
             1.615509671021659e-08_dp, 4.989748896385042e-08_dp, 1.37164262461527e-07_dp, &
             3.4566007610125516e-07_dp, 8.13795909153356e-07_dp, 1.8132606938181964e-06_dp, &
             3.859471481118592e-06_dp, 7.902093035736414e-06_dp, 1.5647085569197518e-05_dp, &
             3.0091385355972e-05_dp, 5.639642458921698e-05_dp, 0.00010329460389139393_dp, &
             0.00018532410144612415_dp, 0.0003263371025718005_dp, 0.0005649460165880816_dp, &
             0.0009628915875550053_dp, 0.0016177781193824183_dp, 0.002682282981534022_dp, &
             0.004392891408715603_dp, 0.007112545407594812_dp, 0.011393481130361175_dp, &
             0.0180691725708096_dp, 0.028387987232039877_dp, 0.04420628084531695_dp, &
             0.06826574331723989_dp, 0.10458958450300211_dp, 0.159045638835404_dp, &
             0.24014318746889385_dp, 0.3601567220071993_dp, 0.5367086843262416_dp, &
             0.7950047759958014_dp, 1.1710258634465203_dp, 1.7162117331911668_dp, &
             2.504735979884491_dp, 3.6460477026464178_dp, 5.310453314963071_dp, &
             7.796053043477965_dp, 11.792552497938217_dp, &
             ! w
             2.992281355932222e-10_dp, 1.6350488259739786e-09_dp, 6.221617930663424e-09_dp, &
             1.939126520186215e-08_dp, 5.3054601381100064e-08_dp, 1.3221520583809728e-07_dp, &
             3.06847509466454e-07_dp, 6.729387945836895e-07_dp, 1.4088368052337008e-06_dp, &
             2.8366819017337755e-06_dp, 5.524268233810102e-06_dp, 1.0451096801831577e-05_dp, &
             1.9274984784513243e-05_dp, 3.475427961456303e-05_dp, 6.140818172447243e-05_dp, &
             0.00010653769479052191_dp, 0.00018178760349040973_dp, 0.0003055130021794588_dp, &
             0.0005063324762600125_dp, 0.0008284181385067849_dp, 0.0013393096200459633_dp, &
             0.002141371105079261_dp, 0.0033884733109008007_dp, 0.005310124314353085_dp, &
             0.008246159600509327_dp, 0.012696320823873695_dp, 0.019390724083776085_dp, &
             0.02938950687949788_dp, 0.04422308491329402_dp, 0.0660888141440765_dp, &
             0.09812609690570866_dp, 0.1448014744538381_dp, 0.21245136929109476_dp, &
             0.3100618666542363_dp, 0.4504377136815248_dp, 0.6521019010479792_dp, &
             0.9428096046855696_dp, 1.3672863455656539_dp, 2.0082430342211115_dp, &
             3.061648751241772_dp, 5.286237610420216_dp]

      CASE (875)

         aw(:) = & ! a
            [7.846157541054408e-11_dp, 7.737193081496072e-10_dp, 3.883615926892372e-09_dp, &
             1.4551039365540695e-08_dp, 4.5704749991175906e-08_dp, 1.2717353189330714e-07_dp, &
             3.234733879615845e-07_dp, 7.672141645629378e-07_dp, 1.7198709793056789e-06_dp, &
             3.6793781773241907e-06_dp, 7.56620688444088e-06_dp, 1.503862896814775e-05_dp, &
             2.901721079342104e-05_dp, 5.454327489954248e-05_dp, 0.000100163442658953_dp, &
             0.00018013295982322172_dp, 0.0003178793524299607_dp, 0.0005513863979727495_dp, &
             0.0009414764985133457_dp, 0.001584429453923439_dp, 0.0026310360839014793_dp, &
             0.0043151275598890355_dp, 0.006995958011963441_dp, 0.011220703217310593_dp, &
             0.017815982899270923_dp, 0.028021005869974868_dp, 0.043680066956110035_dp, &
             0.06751922484084998_dp, 0.10354179167794113_dp, 0.157590795617473_dp, &
             0.23814535618063415_dp, 0.35744441949108036_dp, 0.5330702113591295_dp, &
             0.7901854222813905_dp, 1.1647286011080535_dp, 1.7081032869109365_dp, &
             2.4944598079189606_dp, 3.633243612759346_dp, 5.2947787129555905_dp, &
             7.7771889702802985_dp, 11.770128154981425_dp, &
             ! w
             2.3980859641845776e-10_dp, 1.4200030799207322e-09_dp, 5.587868750138464e-09_dp, &
             1.7758965730621705e-08_dp, 4.923929088288768e-08_dp, 1.239210090031837e-07_dp, &
             2.8981208697283986e-07_dp, 6.395281683452343e-07_dp, 1.345789972458573e-06_dp, &
             2.721566525627505e-06_dp, 5.3200161923181364e-06_dp, 1.0097725892015597e-05_dp, &
             1.8677260675906158e-05_dp, 3.376360664441058e-05_dp, 5.979640826717305e-05_dp, &
             0.0001039597545595159_dp, 0.00017772896651963526_dp, 0.00029921676529703586_dp, &
             0.0004966995953831652_dp, 0.0008138728389760328_dp, 0.0013176205216000878_dp, &
             0.002109417274168953_dp, 0.0033419436587054977_dp, 0.005243139063836892_dp, &
             0.008150804885174239_dp, 0.012562093237366368_dp, 0.019203893202511212_dp, &
             0.029132423331587283_dp, 0.04387349335169384_dp, 0.0656192792247561_dp, &
             0.09750372057267062_dp, 0.14398817553994187_dp, 0.2114051014752916_dp, &
             0.30873922991086195_dp, 0.4487983729648066_dp, 0.6501148753728081_dp, &
             0.9404605202212373_dp, 1.364582712712996_dp, 2.00521050630963_dp, &
             3.0582987798040926_dp, 5.282391239948746_dp]

      CASE (876)

         aw(:) = & ! a
            [5.755879823092453e-11_dp, 6.332046703734606e-10_dp, 3.3512688144233827e-09_dp, &
             1.2934682373119975e-08_dp, 4.142182880836962e-08_dp, 1.1686432105031416e-07_dp, &
             3.003989037464654e-07_dp, 7.184605850141597e-07_dp, 1.6216125406255824e-06_dp, &
             3.489052162841711e-06_dp, 7.2098758262520215e-06_dp, 1.4390978724193739e-05_dp, &
             2.7870470743602508e-05_dp, 5.255973660346555e-05_dp, 9.680405706570152e-05_dp, &
             0.00017455154495484018_dp, 0.0003087680515499572_dp, 0.0005367529790402491_dp, &
             0.0009183276649055452_dp, 0.0015483263573175146_dp, 0.002575478587183788_dp, &
             0.004230712551323576_dp, 0.006869244581091624_dp, 0.011032704635727027_dp, &
             0.01754019379139732_dp, 0.02762086564460487_dp, 0.04310576231832612_dp, &
             0.0667037525487406_dp, 0.10239624892073004_dp, 0.1559989555950486_dp, &
             0.23595774211151196_dp, 0.3544723364163357_dp, 0.5290805530078792_dp, &
             0.7848975367559231_dp, 1.1578150010565404_dp, 1.6991963008781352_dp, &
             2.483165887734602_dp, 3.619165019970507_dp, 5.277537087570941_dp, &
             7.756432205734298_dp, 11.745447481727286_dp, &
             ! w
             1.8400423042461785e-10_dp, 1.2089406877943307e-09_dp, 4.948963339797113e-09_dp, &
             1.6088130595999037e-08_dp, 4.529230680715883e-08_dp, 1.1527146806489142e-07_dp, &
             2.7193337222538263e-07_dp, 6.042801494537686e-07_dp, 1.2789837281255483e-06_dp, &
             2.599128504377676e-06_dp, 5.102062200854228e-06_dp, 9.719566961180106e-06_dp, &
             1.8035975438585433e-05_dp, 3.2698302600811254e-05_dp, 5.805962945051483e-05_dp, &
             0.00010117664980280834_dp, 0.0001733397842304803_dp, 0.0002923969743745046_dp, &
             0.00048625045893160304_dp, 0.0007980736370510741_dp, 0.001294031948557977_dp, &
             0.0020746240483449562_dp, 0.003291223464490599_dp, 0.005170045245666498_dp, &
             0.008046652836119885_dp, 0.01241534670040915_dp, 0.01899945900262857_dp, &
             0.028850884568196365_dp, 0.043490346122490676_dp, 0.06510429181364769_dp, &
             0.09682061174367765_dp, 0.1430949114342032_dp, 0.21025522761150742_dp, &
             0.30728474394210875_dp, 0.44699460076419695_dp, 0.6479274285893785_dp, &
             0.9378733433677441_dp, 1.3616039772992576_dp, 2.0018685702482233_dp, &
             3.0546065942337584_dp, 5.278152208062264_dp]

      CASE (877)

         aw(:) = & ! a
            [1.504533796769453e-10_dp, 1.1531074953405321e-09_dp, 4.8888187124083735e-09_dp, &
             1.64913263438988e-08_dp, 4.82281745320224e-08_dp, 1.2735042553338537e-07_dp, &
             3.110894054663479e-07_dp, 7.143105683543449e-07_dp, 1.5590485153608082e-06_dp, &
             3.2610487264232e-06_dp, 6.57770699653839e-06_dp, 1.2856153509666872e-05_dp, &
             2.4442207132353652e-05_dp, 4.5344210115474104e-05_dp, 8.229565780832036e-05_dp, &
             0.00014643467321744517_dp, 0.0002559275716031921_dp, 0.00044002331987520266_dp, &
             0.000745257122854606_dp, 0.0012448547035166385_dp, 0.0020528658296695953_dp, &
             0.0033452339853937848_dp, 0.0053909681941535555_dp, 0.008597931626136578_dp, &
             0.013579648107021822_dp, 0.021252153578070875_dp, 0.032973558110725165_dp, &
             0.05074400507394785_dp, 0.07749061957506888_dp, 0.1174715178598124_dp, &
             0.17684597768695903_dp, 0.264475911062782_dp, 0.3930492819191733_dp, &
             0.5806538052951022_dp, 0.8529897882443226_dp, 1.2465211951108859_dp, &
             1.8130974497943952_dp, 2.62714991076857_dp, 3.7981600722550914_dp, &
             5.4962274554572_dp, 8.019188692235735_dp, 12.057386630438975_dp, &
             ! w
             4.2193209155725965e-10_dp, 1.868421442363326e-09_dp, 6.398083919571562e-09_dp, &
             1.8727899270213683e-08_dp, 4.90502922225399e-08_dp, 1.1829298380009044e-07_dp, &
             2.6753835248527113e-07_dp, 5.745234884851598e-07_dp, 1.181866972572199e-06_dp, &
             2.344371560782497e-06_dp, 4.50686817269553e-06_dp, 8.430264019191465e-06_dp, &
             1.5392695342439878e-05_dp, 2.7506328214873737e-05_dp, 4.8210326072618356e-05_dp, &
             8.302952009905674e-05_dp, 0.00014073015924529557_dp, 0.00023506402780935405_dp, &
             0.0003873774517226005_dp, 0.0006304822293962166_dp, 0.001014354946006773_dp, &
             0.0016144680116281528_dp, 0.0025438852570893893_dp, 0.003970711003739061_dp, &
             0.00614310995746551_dp, 0.009424977561012782_dp, 0.014346519338652794_dp, &
             0.021675605497769666_dp, 0.032517958983232106_dp, 0.048457237329562496_dp, &
             0.07175024148830268_dp, 0.10559849024163727_dp, 0.1545266611196524_dp, &
             0.2249144111603384_dp, 0.3257601636970398_dp, 0.46982968031426914_dp, &
             0.6755350077022726_dp, 0.9704388241513623_dp, 1.3990172699260266_dp, &
             2.0437808601951684_dp, 3.1008805126561834_dp, 5.331299844531794_dp]

      CASE (878)

         aw(:) = & ! a
            [9.044089458167161e-11_dp, 7.760490006718084e-10_dp, 3.5852241336987436e-09_dp, &
             1.2785918280557138e-08_dp, 3.885739038534123e-08_dp, 1.0556377548653211e-07_dp, &
             2.6362329365754025e-07_dp, 6.16169999839811e-07_dp, 1.3647525613704547e-06_dp, &
             2.890290524653775e-06_dp, 5.892358609652293e-06_dp, 1.1624091192301527e-05_dp, &
             2.2281389262796003e-05_dp, 4.1637611128927765e-05_dp, 7.60638010614533e-05_dp, &
             0.0001361473161713841_dp, 0.0002392292240702679_dp, 0.000413338322662384_dp, &
             0.0007032285563654285_dp, 0.0011795570256516283_dp, 0.0019527135441420882_dp, &
             0.0031934877115869895_dp, 0.00516371555401082_dp, 0.008261394409421483_dp, &
             0.013086641419359156_dp, 0.020537501144712905_dp, 0.0319482574310672_dp, &
             0.04928794762318627_dp, 0.075443721507337_dp, 0.11462323037774363_dp, &
             0.17292335791129965_dp, 0.2591307884929151_dp, 0.38584560228432824_dp, &
             0.5710570093866103_dp, 0.8403610648529733_dp, 1.23012045204557_dp, &
             1.792099359670144_dp, 2.6006763190123077_dp, 3.765327463511408_dp, &
             5.456196605212914_dp, 7.9711746431386885_dp, 12.00046365729151_dp, &
             ! w
             2.6278378503237663e-10_dp, 1.3391746092584678e-09_dp, 4.936308615909203e-09_dp, &
             1.5100553792094086e-08_dp, 4.0787113989337976e-08_dp, 1.0067433172943575e-07_dp, &
             2.3190014168695236e-07_dp, 5.054891717619687e-07_dp, 1.0529270453645942e-06_dp, &
             2.110965019070496e-06_dp, 4.095750860647717e-06_dp, 7.723443816473219e-06_dp, &
             1.4203534920755094e-05_dp, 2.5544515812331387e-05_dp, 4.503124360806736e-05_dp, &
             7.796204090378747e-05_dp, 0.00013277503138524942_dp, 0.0002227527089083657_dp, &
             0.0003685785445475256_dp, 0.0006021395740165651_dp, 0.0009721380957671119_dp, &
             0.0015523125515765094_dp, 0.002453397758842146_dp, 0.0038404122697334613_dp, &
             0.005957492042884414_dp, 0.009163357139122481_dp, 0.013981685679326982_dp, &
             0.021172290552966412_dp, 0.03183120668304537_dp, 0.04753082814504019_dp, &
             0.07051544704190335_dp, 0.10397360028499768_dp, 0.1524179408004863_dp, &
             0.22221937993089996_dp, 0.3223742400855906_dp, 0.4656570762873271_dp, &
             0.6705038371587703_dp, 0.9645180053399289_dp, 1.3922279294523348_dp, &
             2.0361850872427834_dp, 3.092499183883131_dp, 5.321670259310118_dp]

      CASE (879)

         aw(:) = & ! a
            [5.089521599084929e-11_dp, 5.181216769631e-10_dp, 2.6435859823586346e-09_dp, &
             9.997572176326138e-09_dp, 3.159475878675708e-08_dp, 8.82990666770166e-08_dp, &
             2.2534605843279803e-07_dp, 5.358965687113875e-07_dp, 1.2039375677991995e-06_dp, &
             2.580318023464704e-06_dp, 5.314370903218271e-06_dp, 1.0577098193041535e-05_dp, &
             2.043274762989286e-05_dp, 3.8447388286763005e-05_dp, 7.06710167383026e-05_dp, &
             0.0001272013039563542_dp, 0.00022464304939132193_dp, 0.0003899329563819428_dp, &
             0.0006662259327764216_dp, 0.0011218668215417723_dp, 0.0018639421876792204_dp, &
             0.003058578645844583_dp, 0.004961107398406696_dp, 0.007960559286633173_dp, &
             0.012644841325021102_dp, 0.01989557952346713_dp, 0.03102527234977699_dp, &
             0.04797446218368935_dp, 0.07359361194659655_dp, 0.11204397559573867_dp, &
             0.16936496816638244_dp, 0.2542738576039283_dp, 0.3792894741313159_dp, &
             0.5623097717260181_dp, 0.82883400272175_dp, 1.2151305440363507_dp, &
             1.772883907686348_dp, 2.5764228514217984_dp, 3.7352178290350966_dp, &
             5.419453455750257_dp, 7.92707165151411_dp, 11.948146926479781_dp, &
             ! w
             1.5753152478296264e-10_dp, 9.625783116042642e-10_dp, 3.834979234259651e-09_dp, &
             1.2275120803701542e-08_dp, 3.41990576126701e-08_dp, 8.63752632552421e-08_dp, &
             2.02562111731916e-07_dp, 4.479877210264443e-07_dp, 9.444582371991111e-07_dp, &
             1.912936169902662e-06_dp, 3.744348365349662e-06_dp, 7.115320493878184e-06_dp, &
             1.3174436965123362e-05_dp, 2.3837843202007873e-05_dp, 4.2252458510012674e-05_dp, &
             7.35134545875828e-05_dp, 0.00012576376409151433_dp, 0.00021186248607131292_dp, &
             0.00035189345954491947_dp, 0.0005769050486782259_dp, 0.0009344411284773096_dp, &
             0.0014966602341250804_dp, 0.002372170461358687_dp, 0.003723166662028694_dp, &
             0.005790090605055332_dp, 0.008926907103906643_dp, 0.013651284572048878_dp, &
             0.02071560222094273_dp, 0.03120693732150626_dp, 0.04668724475406355_dp, &
             0.0693891909163507_dp, 0.10248920425314961_dp, 0.15048866105954362_dp, &
             0.21975017441404748_dp, 0.31926787513071525_dp, 0.4618242065611505_dp, &
             0.6658770637201433_dp, 0.959067708983269_dp, 1.3859731414100134_dp, &
             2.0291834900622616_dp, 3.084771589112346_dp, 5.312793052529753_dp]

      CASE (880)

         aw(:) = & ! a
            [4.1042231238385694e-11_dp, 4.5150581518412125e-10_dp, 2.389618110441018e-09_dp, &
             9.223059339947427e-09_dp, 2.953578396074567e-08_dp, 8.33299598979284e-08_dp, &
             2.1419906731112746e-07_dp, 5.122974323031782e-07_dp, 1.1562888172343277e-06_dp, &
             2.4878643293756714e-06_dp, 5.140993037585987e-06_dp, 1.0261469569084476e-05_dp, &
             1.987300466262588e-05_dp, 3.747765510632244e-05_dp, 6.90260130050227e-05_dp, &
             0.00012446376291921877_dp, 0.0002201666766304586_dp, 0.000382731046607637_dp, &
             0.000654812403274749_dp, 0.001104032189261055_dp, 0.001836441810203125_dp, &
             0.0030167043221156747_dp, 0.004898106254849544_dp, 0.007866856039358602_dp, &
             0.012507012135573328_dp, 0.01969501891226128_dp, 0.030736490983514164_dp, &
             0.04756295601613861_dp, 0.07301325710891807_dp, 0.11123393592919985_dp, &
             0.16824616368318404_dp, 0.2527451458982139_dp, 0.3772238581214361_dp, &
             0.5595511779250323_dp, 0.825195469112096_dp, 1.2103949636647597_dp, &
             1.7668086422937717_dp, 2.5687492346830636_dp, 3.7256852398990254_dp, &
             5.407814226706766_dp, 7.913094520736236_dp, 11.931560553320608_dp, &
             ! w
             1.3120399239960082e-10_dp, 8.620336734661605e-10_dp, 3.5288522175428966e-09_dp, &
             1.1471621686348695e-08_dp, 3.229562346824973e-08_dp, 8.219417792281092e-08_dp, &
             1.9390175497733175e-07_dp, 4.3088121336615584e-07_dp, 9.119777652275903e-07_dp, &
             1.8533053638262234e-06_dp, 3.6380191370926036e-06_dp, 6.9305251879707836e-06_dp, &
             1.2860529951376536e-05_dp, 2.3315484169088386e-05_dp, 4.139934685353226e-05_dp, &
             7.214388477946586e-05_dp, 0.00012359971833064958_dp, 0.00020849330013087046_dp, &
             0.0003467202867342341_dp, 0.00056906541620143_dp, 0.0009227078704740659_dp, &
             0.0014793080787531686_dp, 0.0023468026986220897_dp, 0.003686493897354143_dp, &
             0.005737654035057934_dp, 0.008852740695821823_dp, 0.013547514995340426_dp, &
             0.020571993821374316_dp, 0.031010403890985017_dp, 0.04642137305143006_dp, &
             0.06903385602688432_dp, 0.10202040679502959_dp, 0.14987878113375322_dp, &
             0.21896890859689308_dp, 0.31828417219614324_dp, 0.4606094764361201_dp, &
             0.6644096689252987_dp, 0.9573380447451075_dp, 1.3839871612209713_dp, &
             2.026959604444003_dp, 3.0823167237718936_dp, 5.3099732398171104_dp]

      CASE (881)

         aw(:) = & ! a
            [3.10545537311889e-11_dp, 3.346340554085941e-10_dp, 1.7545763471630164e-09_dp, &
             6.737276684474854e-09_dp, 2.150360182657336e-08_dp, 6.052469332341586e-08_dp, &
             1.552984431174646e-07_dp, 3.708967673002915e-07_dp, 8.361653185378072e-07_dp, &
             1.7973400337252573e-06_dp, 3.7109985039504026e-06_dp, 7.401880146578872e-06_dp, &
             1.4325945593652393e-05_dp, 2.7001673439224997e-05_dp, 4.970674008905796e-05_dp, &
             8.958826230235682e-05_dp, 0.00015841037064703037_dp, 0.0002752739083577955_dp, &
             0.0004708048663513996_dp, 0.0007935422996163246_dp, 0.0013195929390722794_dp, &
             0.0021671001535556907_dp, 0.0035177567986392736_dp, 0.005648553754494596_dp, &
             0.008978306572985588_dp, 0.014135388686909328_dp, 0.022055720661463402_dp, &
             0.03412369112852952_dp, 0.052373681691766094_dp, 0.07977673101625049_dp, &
             0.12064628356553592_dp, 0.18120989022276213_dp, 0.2704116150070408_dp, &
             0.40103519608638083_dp, 0.5912754586331583_dp, 0.8669457852098937_dp, &
             1.2646196593875323_dp, 1.8362382787010891_dp, 2.656289385731902_dp, &
             3.8342594017837275_dp, 5.540199405785691_dp, 8.071887986996131_dp, &
             12.11982472014633_dp, &
             ! w
             9.840264038207425e-11_dp, 6.344570985208832e-10_dp, 2.5794668330224168e-09_dp, &
             8.352680359622475e-09_dp, 2.345345379836522e-08_dp, 5.957602882478861e-08_dp, &
             1.403358366707645e-07_dp, 3.1147804383129733e-07_dp, 6.586079729526731e-07_dp, &
             1.3373004962829441e-06_dp, 2.6232342304396444e-06_dp, 4.994225642311579e-06_dp, &
             9.262383645075728e-06_dp, 1.6784033106693948e-05_dp, 2.9788937507394094e-05_dp, &
             5.18906213431086e-05_dp, 8.886896205263378e-05_dp, 0.00014985846489258854_dp, &
             0.0002491359898728472_dp, 0.00040878738166126485_dp, 0.0006626533594396859_dp, &
             0.0010621246763700659_dp, 0.001684593335556114_dp, 0.0026456954355616224_dp, &
             0.004116935598120336_dp, 0.006350908057508755_dp, 0.009717186007342433_dp, &
             0.014753120253674189_dp, 0.02223538118512112_dp, 0.03328024790854573_dp, &
             0.049483618823955945_dp, 0.07311584793214533_dp, 0.10739246451482792_dp, &
             0.15685104574566022_dp, 0.22788050781156885_dp, 0.32948124607777635_dp, &
             0.47440913290516173_dp, 0.6810499766380471_dp, 0.9769220613937061_dp, &
             1.4064451222486212_dp, 2.0520860311054285_dp, 3.1100421959705855_dp, &
             5.3418276718834585_dp]

      CASE (882)

         aw(:) = & ! a
            [2.9379946937066885e-11_dp, 3.2320896344761557e-10_dp, 1.710600328606682e-09_dp, &
             6.602296956973786e-09_dp, 2.1143094678081747e-08_dp, 5.965148020884071e-08_dp, &
             1.5333370425464905e-07_dp, 3.667264473986085e-07_dp, 8.277255817544218e-07_dp, &
             1.7809295729577364e-06_dp, 3.6801631126905677e-06_dp, 7.345639550504187e-06_dp, &
             1.4226025622753398e-05_dp, 2.6828257264985585e-05_dp, 4.941204643947861e-05_dp, &
             8.909697901638683e-05_dp, 0.0001576055978224511_dp, 0.00027397677208900655_dp, &
             0.0004687453241805737_dp, 0.0007903178431903183_dp, 0.0013146108812577577_dp, &
             0.0021594979468122708_dp, 0.003506293363601258_dp, 0.005631463127937535_dp, &
             0.008953103391180694_dp, 0.014098613264398261_dp, 0.022002609997768464_dp, &
             0.03404776156560792_dp, 0.05226620993209978_dp, 0.07962612398356159_dp, &
             0.12043733588243713_dp, 0.18092294329834657_dp, 0.27002165696499053_dp, &
             0.40051098041258104_dp, 0.5905787738311084_dp, 0.8660310759118847_dp, &
             1.2634342679299708_dp, 1.8347236084714764_dp, 2.654383207143485_dp, &
             3.831899193378691_dp, 5.5373258050536185_dp, 8.068445375165187_dp, &
             12.115747170747774_dp, &
             ! w
             9.392194892318008e-11_dp, 6.170839924286718e-10_dp, 2.526117352831834e-09_dp, &
             8.211922994890131e-09_dp, 2.3118716811540165e-08_dp, 5.8838434394543414e-08_dp, &
             1.3880393939685158e-07_dp, 3.0844491247662714e-07_dp, 6.528363114262537e-07_dp, &
             1.3266826053076486e-06_dp, 2.6042641434195615e-06_dp, 4.961193869489435e-06_dp, &
             9.206168451436119e-06_dp, 1.6690313349969386e-05_dp, 2.9635587508434175e-05_dp, &
             5.1643964757712046e-05_dp, 8.847845543404601e-05_dp, 0.00014924924916106822_dp, &
             0.0002481985867932157_dp, 0.0004073636224097017_dp, 0.0006605174183376301_dp, &
             0.0010589578546577512_dp, 0.001679951018487681_dp, 0.002638964472664498_dp, &
             0.004107280296349304_dp, 0.006337203133073932_dp, 0.009697935375440784_dp, &
             0.014726361685292882_dp, 0.02219857897159231_dp, 0.03323017922433627_dp, &
             0.049416265081960814_dp, 0.07302631079514021_dp, 0.10727493796018868_dp, &
             0.15669889052534391_dp, 0.22768649056170318_dp, 0.3292380151173698_dp, &
             0.47410998998016085_dp, 0.6806899375074603_dp, 0.9764990293686424_dp, &
             1.4059606569400547_dp, 2.0515445017069798_dp, 3.109444895405208_dp, &
             5.341141253466358_dp]

      CASE (883)

         aw(:) = & ! a
            [2.5805537426128395e-11_dp, 2.6406325197349135e-10_dp, 1.3507894738968888e-09_dp, &
             5.115870470539107e-09_dp, 1.6182759856989415e-08_dp, 4.525738309601122e-08_dp, &
             1.1556022754932956e-07_dp, 2.749273709828951e-07_dp, 6.178556887429758e-07_dp, &
             1.3245813970072105e-06_dp, 2.728736755231757e-06_dp, 5.432086783030678e-06_dp, &
             1.0495573936508608e-05_dp, 1.9752246553631183e-05_dp, 3.631230245788907e-05_dp, &
             6.536730604008212e-05_dp, 0.00011545515448355912_dp, 0.00020042740637144532_dp, &
             0.0003424771841065342_dp, 0.0005767544971012292_dp, 0.0009583380771902763_dp, &
             0.0015726785852723665_dp, 0.002551118615796569_dp, 0.004093786973327022_dp, &
             0.006503135718149682_dp, 0.010232743990415958_dp, 0.01595789572043291_dp, &
             0.024677042459505517_dp, 0.037856848642687665_dp, 0.05763843655350069_dp, &
             0.08712917903177249_dp, 0.13081358543228738_dp, 0.1951294242999519_dp, &
             0.2892726485035215_dp, 0.42631936650166596_dp, 0.6247898385811417_dp, &
             0.9108391834696583_dp, 1.3213697343223358_dp, 1.9085957303934402_dp, &
             2.747169495915087_dp, 3.9465867173599785_dp, 5.676749574460742_dp, &
             8.235266633116058_dp, 12.313137637726658_dp, &
             ! w
             8.00399863396705e-11_dp, 4.915251541355609e-10_dp, 1.9620551367438805e-09_dp, &
             6.2871713631879725e-09_dp, 1.7529479476054223e-08_dp, 4.4297934733352e-08_dp, &
             1.0392926100669545e-07_dp, 2.2992971986952449e-07_dp, 4.848812709009576e-07_dp, &
             9.82330661925483e-07_dp, 1.9231954467389874e-06_dp, 3.6552753821897653e-06_dp, &
             6.769037631888964e-06_dp, 1.2249645092187482e-05_dp, 2.1715205753471587e-05_dp, &
             3.778582813092096e-05_dp, 6.464922259182427e-05_dp, 0.0001089190037601165_dp, &
             0.00018092528741374622_dp, 0.0002966388177395374_dp, 0.0004805168139765504_dp, &
             0.0007696806955460541_dp, 0.001220006019266378_dp, 0.001914941187212991_dp, &
             0.002978197840805819_dp, 0.0045919046894181475_dp, 0.007022431181136046_dp, &
             0.010656925964886156_dp, 0.016054755456341857_dp, 0.02401957575343736_dp, &
             0.03569987399641648_dp, 0.05272869049457537_dp, 0.07741723596715053_dp, &
             0.11302291966439043_dp, 0.16412137506311983_dp, 0.23712803558036213_dp, &
             0.3410472856916833_dp, 0.48860286424216137_dp, 0.698099292412088_dp, &
             0.9969198390552333_dp, 1.429315216662463_dp, 2.0776254656572872_dp, &
             3.1382001146497958_dp, 5.374195315582562_dp]

      CASE (884)

         aw(:) = & ! a
            [2.1111243580084996e-11_dp, 2.3224491017554419e-10_dp, 1.2291683218745666e-09_dp, &
             4.7441439887589486e-09_dp, 1.519257405943804e-08_dp, 4.286314488841236e-08_dp, &
             1.1017940807788809e-07_dp, 2.635148162029348e-07_dp, 5.9477017832161e-07_dp, &
             1.2797040745453973e-06_dp, 2.6444166021018683e-06_dp, 5.2782799523408055e-06_dp, &
             1.0222247542299618e-05_dp, 1.9277702300756025e-05_dp, 3.5505501229057255e-05_dp, &
             6.402149123184618e-05_dp, 0.00011324901820679112_dp, 0.0001968686447577509_dp, &
             0.00033682146117394897_dp, 0.0005678904875798317_dp, 0.0009446262924561243_dp, &
             0.0015517280179759845_dp, 0.0025194808110439865_dp, 0.0040465419548871145_dp, &
             0.006433338391767066_dp, 0.01013069352623149_dp, 0.015810184605045314_dp, &
             0.024465337502942924_dp, 0.03755635503141191_dp, 0.05721600089228407_dp, &
             0.08654100248424336_dp, 0.13000254970793015_dp, 0.1940220897840922_dp, &
             0.28777607587357007_dp, 0.4243180518620017_dp, 0.622143244212191_dp, &
             0.9073805817689972_dp, 1.3169073103665563_dp, 1.902916975492621_dp, &
             2.740049599784258_dp, 3.9378004595057625_dp, 5.666083276187741_dp, &
             8.222519349247909_dp, 12.298068641427866_dp, &
             ! w
             6.748852008911724e-11_dp, 4.4341163915523165e-10_dp, 1.8151659238252474e-09_dp, &
             5.900756259714016e-09_dp, 1.6612176342286474e-08_dp, 4.2278922987722326e-08_dp, &
             9.973890576048785e-08_dp, 2.216360586555885e-07_dp, 4.69101810871081e-07_dp, &
             9.533005466400577e-07_dp, 1.8713190490457361e-06_dp, 3.564913573353679e-06_dp, &
             6.615180888514306e-06_dp, 1.1992985189735323e-05_dp, 2.1294936446995888e-05_dp, &
             3.7109267600874355e-05_dp, 6.357704515763241e-05_dp, 0.0001072444834913886_dp, &
             0.00017834548173518552_dp, 0.00029271504882903205_dp, 0.00047462114318726244_dp, &
             0.0007609243484303307_dp, 0.0012071449484875507_dp, 0.0018962532470387734_dp, &
             0.0029513255368186966_dp, 0.004553657400690409_dp, 0.006968541513819855_dp, &
             0.010581757063146131_dp, 0.01595096052204758_dp, 0.023877718930558203_dp, &
             0.03550803481637499_dp, 0.05247209436887822_dp, 0.07707798312611479_dp, &
             0.11257992616613019_dp, 0.16355069094257252_dp, 0.236403757928437_dp, &
             0.34014331201786646_dp, 0.48749567521889686_dp, 0.6967717046242862_dp, &
             0.9953650608175667_dp, 1.4275393309821744_dp, 2.0756440017949287_dp, &
             3.1360163129443808_dp, 5.371684431915519_dp]

      CASE (885)

         aw(:) = & ! a
            [2.2372988225912986e-11_dp, 2.155311024643934e-10_dp, 1.0683399847572335e-09_dp, &
             3.9739825349021844e-09_dp, 1.2422863442524694e-08_dp, 3.444807931563984e-08_dp, &
             8.739122593186021e-08_dp, 2.068427418199086e-07_dp, 4.628897235545483e-07_dp, &
             9.888579907017114e-07_dp, 2.0309834216653173e-06_dp, 4.032513775733553e-06_dp, &
             7.773545358434298e-06_dp, 1.459978113798453e-05_dp, 2.6791302797117927e-05_dp, &
             4.814917379398309e-05_dp, 8.491722460683491e-05_dp, 0.00014721437400774806_dp, &
             0.00025123728604219104_dp, 0.0004226152253907819_dp, 0.0007014742221237098_dp, &
             0.0011500176701666695_dp, 0.0018637850253244044_dp, 0.0029882501950574264_dp, &
             0.004743122360075808_dp, 0.007457690327954169_dp, 0.01162191009540732_dp, &
             0.01795981321943177_dp, 0.0275343982411992_dp, 0.041896710661668196_dp, &
             0.0632966577684987_dp, 0.09497970184804179_dp, 0.1416025612739261_dp, &
             0.20981332955217188_dp, 0.30905839614943154_dp, 0.45270264706401014_dp, &
             0.6595855013522461_dp, 0.9561945344912952_dp, 1.379748852234404_dp, &
             1.982721994895184_dp, 2.839917905447953_dp, 4.060833137310887_dp, &
             5.815221529842535_dp, 8.400534530235255_dp, 12.508298773674282_dp, &
             ! w
             6.776665965861506e-11_dp, 3.918804188974133e-10_dp, 1.527368063806098e-09_dp, &
             4.827323088099226e-09_dp, 1.3334082786027613e-08_dp, 3.3464770762276443e-08_dp, &
             7.809435517474159e-08_dp, 1.7203020780136926e-07_dp, 3.6148795940862717e-07_dp, &
             7.301353394892479e-07_dp, 1.425736223288309e-06_dp, 2.703646134304637e-06_dp, &
             4.99673497200199e-06_dp, 9.026245725497744e-06_dp, 1.597535232451133e-05_dp, &
             2.775776001522263e-05_dp, 4.7429005640715064e-05_dp, 7.981012027905184e-05_dp, &
             0.00013242472618964552_dp, 0.0002168951901198007_dp, 0.0003510062684536178_dp, &
             0.0005617327479209903_dp, 0.0008896504066323469_dp, 0.0013953200440996291_dp, &
             0.0021684696795750535_dp, 0.003341123556732734_dp, 0.005106269458631146_dp, &
             0.007744259638564807_dp, 0.01165996096307984_dp, 0.017434781143235333_dp, &
             0.025899201421230506_dp, 0.038233483671874485_dp, 0.05610700360381818_dp, &
             0.08187054481901408_dp, 0.11882155063596944_dp, 0.17157128053823664_dp, &
             0.24655878355217412_dp, 0.35278941428064936_dp, 0.5029523565279985_dp, &
             0.7152701616532843_dp, 1.0169935591848016_dp, 1.4522110109881194_dp, &
             2.103146700225878_dp, 3.1663155716664577_dp, 5.406530821702442_dp]

      CASE (886)

         aw(:) = & ! a
            [1.5225259437665765e-11_dp, 1.6749313167827746e-10_dp, 8.864661145809686e-10_dp, &
             3.421437743950288e-09_dp, 1.0956760016736019e-08_dp, 3.0912549364976967e-08_dp, &
             7.94604874025738e-08_dp, 1.900447275345126e-07_dp, 4.289433800948182e-07_dp, &
             9.22912090194094e-07_dp, 1.9071315730773318e-06_dp, 3.8066522325071943e-06_dp, &
             7.372201167341749e-06_dp, 1.3902920987800809e-05_dp, 2.560627662512332e-05_dp, &
             4.617177488940133e-05_dp, 8.167426375702172e-05_dp, 0.00014198005265164286_dp, &
             0.00024291287557809692_dp, 0.0004095579607967174_dp, 0.0006812567302045216_dp, &
             0.0011190935095500695_dp, 0.0018170288756849953_dp, 0.0029183328232831466_dp, &
             0.004639670770038319_dp, 0.007306172756936884_dp, 0.011402174427105598_dp, &
             0.017644197214806537_dp, 0.027085322931629918_dp, 0.04126366785420287_dp, &
             0.062412514369447246_dp, 0.09375627578927048_dp, 0.13992548787529538_dp, &
             0.20753634890227643_dp, 0.305997370775741_dp, 0.44862988431163076_dp, &
             0.6542253160446062_dp, 0.9492214205096632_dp, 1.370790033591107_dp, &
             1.9713662396413763_dp, 2.8257317984924697_dp, 4.043383646883342_dp, &
             5.794098067299848_dp, 8.375349506181639_dp, 12.47858300048998_dp, &
             ! w
             4.867217284