!--------------------------------------------------------------------------------------------------!
!   CP2K: A general program to perform molecular dynamics simulations                              !
!   Copyright (C) 2000 - 2019  CP2K developers group                                               !
!--------------------------------------------------------------------------------------------------!

! **************************************************************************************************
!> \brief Contains routines for data compression. PLEASE DO NOT MODIFY.
!> \par History
!>      04.2008 created [Manuel Guidon]
!> \author Manuel Guidon
! **************************************************************************************************
MODULE hfx_compression_core_methods

   USE kinds,                           ONLY: int_8
#include "../base/base_uses.f90"

   IMPLICIT NONE
   PRIVATE

   ! masks the corresponding number of bits from the right
   INTEGER(kind=int_8), PARAMETER :: mask_right(0:63) = &
                              (/0_int_8, 1_int_8, 3_int_8, 7_int_8, 15_int_8, 31_int_8, 63_int_8, 127_int_8, 255_int_8, 511_int_8, &
                              1023_int_8, 2047_int_8, 4095_int_8, 8191_int_8, 16383_int_8, 32767_int_8, 65535_int_8, 131071_int_8, &
                           262143_int_8, 524287_int_8, 1048575_int_8, 2097151_int_8, 4194303_int_8, 8388607_int_8, 16777215_int_8, &
                              33554431_int_8, 67108863_int_8, 134217727_int_8, 268435455_int_8, 536870911_int_8, 1073741823_int_8, &
                                       2147483647_int_8, 4294967295_int_8, 8589934591_int_8, 17179869183_int_8, 34359738367_int_8, &
                               68719476735_int_8, 137438953471_int_8, 274877906943_int_8, 549755813887_int_8, 1099511627775_int_8, &
                                       2199023255551_int_8, 4398046511103_int_8, 8796093022207_int_8, 17592186044415_int_8, &
                                       35184372088831_int_8, 70368744177663_int_8, 140737488355327_int_8, 281474976710655_int_8, &
                                    562949953421311_int_8, 1125899906842623_int_8, 2251799813685247_int_8, 4503599627370495_int_8, &
                                9007199254740991_int_8, 18014398509481983_int_8, 36028797018963967_int_8, 72057594037927935_int_8, &
                                       144115188075855871_int_8, 288230376151711743_int_8, 576460752303423487_int_8, &
                                       1152921504606846975_int_8, 2305843009213693951_int_8, 4611686018427387903_int_8, &
                                       9223372036854775807_int_8/)

   ! masks the corresponding number of bits from the left
   ! use ishft to avoid explicitly writing -HUGE-1, and keep it out of the array a work-around for a bug in pgi 6.1-1
   INTEGER(kind=int_8), PARAMETER :: ugly_duck = ISHFT(1_int_8, 63)
   INTEGER(kind=int_8), PARAMETER :: mask_left(0:63) = &
                                     (/0_int_8, ugly_duck, -4611686018427387904_int_8, -2305843009213693952_int_8, &
                                       -1152921504606846976_int_8, -576460752303423488_int_8, -288230376151711744_int_8, &
                                       -144115188075855872_int_8, -72057594037927936_int_8, -36028797018963968_int_8, &
                              -18014398509481984_int_8, -9007199254740992_int_8, -4503599627370496_int_8, -2251799813685248_int_8, &
                                  -1125899906842624_int_8, -562949953421312_int_8, -281474976710656_int_8, -140737488355328_int_8, &
                                       -70368744177664_int_8, -35184372088832_int_8, -17592186044416_int_8, -8796093022208_int_8, &
                                       -4398046511104_int_8, -2199023255552_int_8, -1099511627776_int_8, -549755813888_int_8, &
                             -274877906944_int_8, -137438953472_int_8, -68719476736_int_8, -34359738368_int_8, -17179869184_int_8, &
                                     -8589934592_int_8, -4294967296_int_8, -2147483648_int_8, -1073741824_int_8, -536870912_int_8, &
                                       -268435456_int_8, -134217728_int_8, -67108864_int_8, -33554432_int_8, -16777216_int_8, &
                                     -8388608_int_8, -4194304_int_8, -2097152_int_8, -1048576_int_8, -524288_int_8, -262144_int_8, &
                                   -131072_int_8, -65536_int_8, -32768_int_8, -16384_int_8, -8192_int_8, -4096_int_8, -2048_int_8, &
                             -1024_int_8, -512_int_8, -256_int_8, -128_int_8, -64_int_8, -32_int_8, -16_int_8, -8_int_8, -4_int_8, &
                                       -2_int_8/)

   PUBLIC :: bits2ints_specific, ints2bits_specific

CONTAINS

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2ints(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      full_data(1:Ndata) = packed_data(1:Ndata)
   END SUBROUTINE

   ! Nbits         : number of relevant bits per int in the bit stream (this includes all bits)
   ! Ndata         : number of ints that need to be extracted from the bit stream
   ! packed_data   : the stream of bits
   ! full_data     : the extracted ints
! **************************************************************************************************
!> \brief ...
!> \param Nbits ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_generic(Nbits, Ndata, packed_data, full_data)

      INTEGER, INTENT(IN)                                :: Nbits, Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER                                            :: i_odd_bits, ibits_remaining, idata, ipack
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0

      ! number of data bits in the pack_tmp that should still be read
      ibits_remaining = 64
      ipack = 1
      pack_tmp = packed_data(ipack)

      ! give the compiler a hint that Nbits is strictly positive
      IF (Nbits < 1) CPABORT("This is a bug")
      ! we also limit the making number of bits
      IF (Nbits >= 64) CPABORT("This is a bug")

      DO
         ! we've unpacked all data
         IF (idata == Ndata) EXIT
         idata = idata + 1
         IF (ibits_remaining >= Nbits) THEN
            data_tmp = IAND(pack_tmp, mask_right(Nbits)) ! get the last Nbits
            full_data(idata) = data_tmp
            pack_tmp = ISHFT(pack_tmp, -Nbits) ! and shift right to get the bits in place for the next
            ibits_remaining = ibits_remaining - Nbits
         ELSE
            i_odd_bits = Nbits - ibits_remaining
            data_tmp = ISHFT(pack_tmp, i_odd_bits) ! use all remaining bits, shifted left to make place for the missing bits
            ipack = ipack + 1
            pack_tmp = packed_data(ipack) ! get new storage
            ibits_remaining = 64
            full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(i_odd_bits))) ! and use the missing bits to assemble the data
            pack_tmp = ISHFT(pack_tmp, -i_odd_bits) ! shift right to get the bits in place for the next
            ibits_remaining = 64 - i_odd_bits
         ENDIF
      ENDDO

   END SUBROUTINE bits2ints_generic

! **************************************************************************************************
!> \brief ...
!> \param Nbits ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_generic(Nbits, Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Nbits, Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER                                            :: i_odd_bits, ibits_remaining, idata, ipack
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      pack_tmp = 0

      ! number of data bits in the pack_tmp that should still be written
      ibits_remaining = 64

      ! give the compiler a hint that Nbits is strictly positive
      IF (Nbits < 1) CPABORT("This is a bug")
      ! we also limit the making number of bits
      IF (Nbits >= 64) CPABORT("This is a bug")

      DO
         ! we've packed all data
         IF (idata == Ndata) EXIT
         idata = idata + 1
         IF (ibits_remaining >= Nbits) THEN
            data_tmp = full_data(idata)
            data_tmp = ISHFT(data_tmp, 64 - Nbits) ! put bits on the left
            pack_tmp = IOR(pack_tmp, data_tmp) ! add to the packed data
            ibits_remaining = ibits_remaining - Nbits
            pack_tmp = ISHFT(pack_tmp, -MIN(Nbits, ibits_remaining)) ! and shift to the right to make place for the next
         ELSE
            i_odd_bits = ibits_remaining
            data_tmp = full_data(idata)
            data_tmp = ISHFT(data_tmp, 64 - Nbits) ! put bits on the left
            data_tmp = IAND(data_tmp, mask_left(i_odd_bits)) ! restrict to those bits for which we still have space
            pack_tmp = IOR(pack_tmp, data_tmp) ! add them to the packed bits
            ipack = ipack + 1
            packed_data(ipack) = pack_tmp ! store the full packed data away and start with a new one
            data_tmp = full_data(idata)
            pack_tmp = ISHFT(data_tmp, 64 - Nbits + i_odd_bits) ! put the missing bits on the left if pack_tmp
            ibits_remaining = 64 - Nbits + i_odd_bits
            pack_tmp = ISHFT(pack_tmp, -MIN(Nbits, ibits_remaining)) ! shift to make place, but not more than the number of available bits
         ENDIF
      ENDDO

      ! cleanup this unfinished packed data and store
      pack_tmp = ISHFT(pack_tmp, -MAX(0, ibits_remaining - Nbits))
      ipack = ipack + 1
      packed_data(ipack) = pack_tmp

   END SUBROUTINE ints2bits_generic

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_1(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 1

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 63)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_1

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_1(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 1

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_1

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_2(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 2

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 62)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_2

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_2(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 2

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_2

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_3(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 3

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 61)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_3

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_3(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 3

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_3

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_4(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 4

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 60)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_4

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_4(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 4

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_4

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_5(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 5

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 59)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_5

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_5(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 5

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_5

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_6(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 6

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 58)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_6

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_6(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 6

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_6

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_7(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 7

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 57)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_7

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_7(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 7

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_7

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_8(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 8

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 56)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_8

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_8(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 8

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_8

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_9(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 9

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 55)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_9

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_9(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 9

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_9

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_10(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 10

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 54)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_10

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_10(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 10

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_10

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_11(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 11

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 53)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_11

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_11(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 11

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_11

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_12(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 12

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 52)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_12

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_12(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 12

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_12

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_13(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 13

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 51)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_13

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_13(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 13

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_13

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_14(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 14

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 50)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_14

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_14(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 14

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_14

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_15(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 15

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 49)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_15

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_15(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 15

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_15

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_16(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 16

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 48)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_16

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_16(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 16

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_16

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_17(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 17

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 49)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(15))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 47)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_17

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_17(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 17

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 17)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(17)))
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_17

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_18(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 18

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 46)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_18

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_18(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 18

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_18

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_19(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 19

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 47)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 49)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(15))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(17))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 45)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_19

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_19(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 19

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 19)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(19)))
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 17)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(17)))
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_19

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_20(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 20

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 44)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_20

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_20(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 20

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_20

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_21(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 21

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 45)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 47)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 49)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(15))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(17))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(19))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 43)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_21

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_21(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 21

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 21)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(21)))
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 19)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(19)))
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 17)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(17)))
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_21

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_22(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 22

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 42)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_22

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_22(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 22

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_22

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_23(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 23

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 49)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(21))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 47)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(19))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 45)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(17))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 43)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(15))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 41)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_23

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_23(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 23

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 23)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(23)))
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 17)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(17)))
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 19)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(19)))
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 21)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(21)))
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_23

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_24(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 24

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 40)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_24

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_24(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 24

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_24

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_25(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 25

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(17))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 45)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(23))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(15))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 43)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(21))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 49)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 41)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(19))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 47)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 39)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_25

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_25(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 25

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 25)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(25)))
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 19)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(19)))
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 21)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(21)))
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 23)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(23)))
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 17)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(17)))
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_25

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_26(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 26

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 38)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 38)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_26

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_26(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 26

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 26)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(26)))
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 26)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(26)))
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_26

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_27(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 27

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 47)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(23))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 43)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(26))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(19))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 39)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 49)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(15))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(25))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 45)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 38)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(21))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 41)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         data_tmp = IAND(data_tmp, mask_left(17))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 37)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_27

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_27(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 27

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 27)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(27)))
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 17)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(17)))
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 21)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(21)))
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 25)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(25)))
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 19)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(19)))
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 26)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(26)))
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 23)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(23)))
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_27

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_28(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 28

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 36)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_28

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_28(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 28

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 28)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(28)))
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 28)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(28)))
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 28)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(28)))
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 28)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(28)))
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_28

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_29(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 29

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 41)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 47)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(19))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(25))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 37)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 43)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 49)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(26))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 38)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(15))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(21))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(27))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 39)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 45)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(28))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(17))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         data_tmp = IAND(data_tmp, mask_left(23))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 35)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_29

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_29(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 29

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 29)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(29)))
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 23)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(23)))
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 17)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(17)))
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 28)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(28)))
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 27)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(27)))
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 21)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(21)))
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 26)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(26)))
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 25)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(25)))
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 19)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(19)))
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_29

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_30(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 30

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 38)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(28))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(26))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 34)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 38)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(28))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         data_tmp = IAND(data_tmp, mask_left(26))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 34)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_30

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_30(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 30

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 30)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(30)))
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 26)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(26)))
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 28)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(28)))
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 30)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(30)))
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 26)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(26)))
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 28)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(28)))
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_30

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_31(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 31

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 35)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 37)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 39)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 41)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 43)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 45)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 47)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 49)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(26))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(28))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(30))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 34)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 38)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(15))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(17))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(19))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(21))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(23))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(25))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(27))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         data_tmp = IAND(data_tmp, mask_left(29))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 33)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_31

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_31(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 31

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 31)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(31)))
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 29)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(29)))
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 27)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(27)))
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 25)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(25)))
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 23)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(23)))
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 21)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(21)))
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 19)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(19)))
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 17)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(17)))
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 30)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(30)))
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 28)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(28)))
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 26)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(26)))
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_31

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_32(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 32

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 32)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_32

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_32(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 32

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_32

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_33(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 33

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(31))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(29))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(27))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(25))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(23))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(21))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(19))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(17))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(15))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(13))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(11))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(9))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(7))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 38)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(5))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(3))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 34)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(1))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(32))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 63)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(30))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 61)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(28))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 59)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(26))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 57)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 55)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 53)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 51)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 49)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 47)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 45)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 43)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 41)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 39)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 37)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 35)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 33)
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 31)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_33

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_33(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 33

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 33)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(33)))
         pack_tmp = ISHFT(pack_tmp, -33)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 2)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(2)))
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 6)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(6)))
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 10)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(10)))
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 14)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(14)))
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 18)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(18)))
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(20)))
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 22)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(22)))
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 24)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(24)))
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 26)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(26)))
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 28)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(28)))
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 30)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(30)))
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 32)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(32)))
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 1)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(1)))
         pack_tmp = ISHFT(pack_tmp, -1)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 3)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(3)))
         pack_tmp = ISHFT(pack_tmp, -3)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 5)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(5)))
         pack_tmp = ISHFT(pack_tmp, -5)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 7)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(7)))
         pack_tmp = ISHFT(pack_tmp, -7)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 9)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(9)))
         pack_tmp = ISHFT(pack_tmp, -9)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 11)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(11)))
         pack_tmp = ISHFT(pack_tmp, -11)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 13)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(13)))
         pack_tmp = ISHFT(pack_tmp, -13)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 15)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(15)))
         pack_tmp = ISHFT(pack_tmp, -15)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 17)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(17)))
         pack_tmp = ISHFT(pack_tmp, -17)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 19)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(19)))
         pack_tmp = ISHFT(pack_tmp, -19)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 21)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(21)))
         pack_tmp = ISHFT(pack_tmp, -21)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 23)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(23)))
         pack_tmp = ISHFT(pack_tmp, -23)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 25)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(25)))
         pack_tmp = ISHFT(pack_tmp, -25)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 27)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(27)))
         pack_tmp = ISHFT(pack_tmp, -27)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 29)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(29)))
         pack_tmp = ISHFT(pack_tmp, -29)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 31)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(31)))
         pack_tmp = ISHFT(pack_tmp, -31)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL bits2ints_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE bits2ints_33

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE ints2bits_34(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(OUT)                   :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(IN)                    :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 34

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      idata = 0
      ipack = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         pack_tmp = 0
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(30))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(26))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(32))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(28))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 38)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 34)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(0))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 30)
         pack_tmp = ISHFT(pack_tmp, -30)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(30))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 60)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -26)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(26))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 56)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -22)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(22))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 52)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -18)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(18))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 48)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -14)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(14))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 44)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -10)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(10))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 40)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -6)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(6))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 36)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -2)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(2))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 32)
         pack_tmp = ISHFT(pack_tmp, -32)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(32))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 62)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -28)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(28))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 58)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -24)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(24))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 54)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -20)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(20))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 50)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(16))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 46)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(12))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 42)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(8))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 38)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         data_tmp = IAND(data_tmp, mask_left(4))
         pack_tmp = IOR(pack_tmp, data_tmp)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
         data_tmp = full_data(idata)
         pack_tmp = ISHFT(data_tmp, 34)
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = full_data(idata)
         data_tmp = ISHFT(data_tmp, 30)
         pack_tmp = IOR(pack_tmp, data_tmp)
         pack_tmp = ISHFT(pack_tmp, 0)
         pack_tmp = ISHFT(pack_tmp, 0)
         ipack = ipack + 1
         packed_data(ipack) = pack_tmp
      ENDDO
      IF (Ndata_rep < Ndata) THEN
         CALL ints2bits_generic(Nbits, Ndata - Ndata_rep, packed_data(ipack + 1), full_data(Ndata_rep + 1))
      ENDIF
   END SUBROUTINE ints2bits_34

! **************************************************************************************************
!> \brief ...
!> \param Ndata ...
!> \param packed_data ...
!> \param full_data ...
! **************************************************************************************************
   SUBROUTINE bits2ints_34(Ndata, packed_data, full_data)
      INTEGER, INTENT(IN)                                :: Ndata
      INTEGER(KIND=int_8), INTENT(IN)                    :: packed_data(*)
      INTEGER(KIND=int_8), INTENT(OUT)                   :: full_data(*)

      INTEGER, PARAMETER                                 :: Nbits = 34

      INTEGER                                            :: idata, ipack, kdata, Ndata_rep
      INTEGER(KIND=int_8)                                :: data_tmp, pack_tmp

      ipack = 0
      idata = 0
      pack_tmp = 0
      Ndata_rep = (Ndata/64)*64
      DO kdata = 1, Ndata_rep, 64
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 34)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(34)))
         pack_tmp = ISHFT(pack_tmp, -34)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 4)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(4)))
         pack_tmp = ISHFT(pack_tmp, -4)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 8)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(8)))
         pack_tmp = ISHFT(pack_tmp, -8)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 12)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(12)))
         pack_tmp = ISHFT(pack_tmp, -12)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 16)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, mask_right(16)))
         pack_tmp = ISHFT(pack_tmp, -16)
         idata = idata + 1
         data_tmp = IAND(pack_tmp, mask_right(Nbits))
         full_data(idata) = data_tmp
         pack_tmp = ISHFT(pack_tmp, -Nbits)
         idata = idata + 1
         data_tmp = ISHFT(pack_tmp, 20)
         ipack = ipack + 1
         pack_tmp = packed_data(ipack)
         full_data(idata) = IOR(data_tmp, IAND(pack_tmp, 