/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

#ifndef __SOC_MEDIATEK_MT8196_INCLUDE_SOC_ADDRESSMAP_H__
#define __SOC_MEDIATEK_MT8196_INCLUDE_SOC_ADDRESSMAP_H__

enum {
	MCUSYS_BASE		= 0x0C000000,
	MCUPM_CFG_BASE		= 0x0C240000,
	IO_PHYS			= 0x10000000,
};

enum {
	MCUCFG_BASE		= MCUSYS_BASE,
};

enum {
	CKSYS_BASE		= IO_PHYS + 0x00000000,
	APMIXED_BASE		= IO_PHYS + 0x00000800,
	INFRACFG_AO_BASE	= IO_PHYS + 0x00001000,
	CKSYS_GP2_BASE		= IO_PHYS + 0x0000C000,
	APMIXEDSYS_GP2_BASE	= IO_PHYS + 0x0000C800,
	BCRM_INFRA_AO_BASE	= IO_PHYS + 0x00022000,
	BCRM_INFRA1_AO_BASE	= IO_PHYS + 0x0002A000,
	GPIO_BASE		= IO_PHYS + 0x0002D000,
	DRAMC_CHA_AO_BASE	= IO_PHYS + 0x00230000,
	EMI0_BASE		= IO_PHYS + 0x00469000,
	EMI0_MPU_BASE		= IO_PHYS + 0x00468000,
	EMI1_BASE		= IO_PHYS + 0x00569000,
	DPM_PM_SRAM_BASE	= IO_PHYS + 0x00900000,
	DPM_DM_SRAM_BASE	= IO_PHYS + 0x00920000,
	DPM_CFG_BASE		= IO_PHYS + 0x00940000,
	DPM_PM_SRAM_BASE2	= IO_PHYS + 0x00A00000,
	DPM_DM_SRAM_BASE2	= IO_PHYS + 0x00A20000,
	DPM_CFG_BASE2		= IO_PHYS + 0x00A40000,
	IOCFG_RT_BASE		= IO_PHYS + 0x02000000,
	IOCFG_RM1_BASE		= IO_PHYS + 0x02020000,
	IOCFG_RM2_BASE		= IO_PHYS + 0x02040000,
	IOCFG_RB_BASE		= IO_PHYS + 0x02060000,
	I2C5_BASE		= IO_PHYS + 0x020A0000,
	IOCFG_BM1_BASE		= IO_PHYS + 0x02820000,
	IOCFG_BM2_BASE		= IO_PHYS + 0x02840000,
	IOCFG_BM3_BASE		= IO_PHYS + 0x02860000,
	IOCFG_LT_BASE		= IO_PHYS + 0x03000000,
	IOCFG_LM1_BASE		= IO_PHYS + 0x03020000,
	IOCFG_LM2_BASE		= IO_PHYS + 0x03040000,
	MIPITX0_BASE		= IO_PHYS + 0x030b0000,
	IOCFG_LB1_BASE		= IO_PHYS + 0x030f0000,
	IOCFG_LB2_BASE		= IO_PHYS + 0x03110000,
	I2C0_BASE		= IO_PHYS + 0x03130000,
	I2C3_BASE		= IO_PHYS + 0x03150000,
	I2C6_BASE		= IO_PHYS + 0x03170000,
	I2C10_BASE		= IO_PHYS + 0x03190000,
	EFUSEC_BASE		= IO_PHYS + 0x03260000,
	IOCFG_TM1_BASE		= IO_PHYS + 0x03800000,
	IOCFG_TM2_BASE		= IO_PHYS + 0x03820000,
	IOCFG_TM3_BASE		= IO_PHYS + 0x03860000,
	I2C1_BASE		= IO_PHYS + 0x03930000,
	I2C2_BASE		= IO_PHYS + 0x039B0000,
	I2C4_BASE		= IO_PHYS + 0x03A30000,
	I2C7_BASE		= IO_PHYS + 0x03AB0000,
	I2C8_BASE		= IO_PHYS + 0x03B30000,
	I2C9_BASE		= IO_PHYS + 0x03BB0000,
	THERM_CTRL_BASE		= IO_PHYS + 0x04414000,
	UART0_BASE		= IO_PHYS + 0x06000000,
	SPI0_BASE		= IO_PHYS + 0x06110000,
	SPI1_BASE		= IO_PHYS + 0x06130000,
	SPI2_BASE		= IO_PHYS + 0x06150000,
	SPI3_BASE		= IO_PHYS + 0x06170000,
	SPI4_BASE		= IO_PHYS + 0x06190000,
	SPI5_BASE		= IO_PHYS + 0x061B0000,
	SPI6_BASE		= IO_PHYS + 0x0619D000,
	SPI7_BASE		= IO_PHYS + 0x061F0000,
	I2C11_BASE		= IO_PHYS + 0x06200000,
	I2C12_BASE		= IO_PHYS + 0x06240000,
	I2C13_BASE		= IO_PHYS + 0x06280000,
	I2C14_BASE		= IO_PHYS + 0x062C0000,
	SFLASH_REG_BASE         = IO_PHYS + 0x06340000,
	I2C0_DMA_BASE		= IO_PHYS + 0x06370000,
	I2C1_DMA_BASE		= IO_PHYS + 0x06380000,
	I2C2_DMA_BASE		= IO_PHYS + 0x06390000,
	I2C3_DMA_BASE		= IO_PHYS + 0x063C0000,
	I2C4_DMA_BASE		= IO_PHYS + 0x063D0000,
	I2C5_DMA_BASE		= IO_PHYS + 0x06400000,
	I2C6_DMA_BASE		= IO_PHYS + 0x06410000,
	I2C7_DMA_BASE		= IO_PHYS + 0x06420000,
	I2C8_DMA_BASE		= IO_PHYS + 0x06450000,
	I2C9_DMA_BASE		= IO_PHYS + 0x06480000,
	I2C10_DMA_BASE		= IO_PHYS + 0x064B0000,
	I2C11_DMA_BASE		= IO_PHYS + 0x064C0000,
	I2C12_DMA_BASE		= IO_PHYS + 0x064D0000,
	I2C13_DMA_BASE		= IO_PHYS + 0x064F0000,
	I2C14_DMA_BASE		= IO_PHYS + 0x06500000,
	PERICFG_AO_BASE		= IO_PHYS + 0x06640000,
	SSUSB_IPPC_BASE		= IO_PHYS + 0x06703E00,
	SSUSB_SIF_BASE		= IO_PHYS + 0x06730300,
	UFSHCI_BASE		= IO_PHYS + 0x06810000,
	SCP_BASE		= IO_PHYS + 0x0C004000,
	SCP_PBUS_BASE		= IO_PHYS + 0x0C00D000,
	RGU_BASE		= IO_PHYS + 0x0C010000,
	GPT_BASE		= IO_PHYS + 0x0C015000,
	PMIF_SPMI_P_BASE	= IO_PHYS + 0x0C018000,
	PMIF_SPMI_BASE		= IO_PHYS + 0x0C01A000,
	SPMI_MST_BASE		= IO_PHYS + 0x0C01C000,
	SPMI_MST_P_BASE		= IO_PHYS + 0x0C01C800,
	SYSTIMER_BASE		= IO_PHYS + 0x0C400000,
	EINT_BASE		= IO_PHYS + 0x0C54A000,
	DSI0_BASE		= IO_PHYS + 0x22490000,
	DISP_DVO0		= IO_PHYS + 0x224C0000,
	EDP_BASE		= IO_PHYS + 0x2EC40000,
};

#endif
