

// {{{
const string TD1 = """
{
  "created_at" : "Mon May 05 06:48:32 +0000 2014",
  "id" : 463208606784311296,
  "id_str" : "463208606784311296",
  "text" : "RT @BlackForestTeam: DIESELSTÖRMERS Kickstarter is live! - Go and check it out right now!... http://t.co/ZVmefc0w5e",
  "source" : "web",
  "truncated" : false,
  "in_reply_to_status_id" : null,
  "in_reply_to_status_id_str" : null,
  "in_reply_to_user_id" : null,
  "in_reply_to_user_id_str" : null,
  "in_reply_to_screen_name" : null,
  "user" : {
    "id" : 62574927,
    "id_str" : "62574927",
    "name" : "Frozenbyte",
    "screen_name" : "Frozenbyte",
    "location" : "Helsinki, Finland",
    "description" : "We're an independent game developer. Follow us on Twitter to get the latest news on our games! For support issues please get in touch via email.",
    "url" : "http://t.co/NlgW9k9ZXj",
    "entities" : {
      "url" : {
        "urls" : [
          {
            "url" : "http://t.co/NlgW9k9ZXj",
            "expanded_url" : "http://www.frozenbyte.com",
            "display_url" : "frozenbyte.com",
            "indices" : [
              0,
              22
            ]
          }
        ]
      },
      "description" : {
        "urls" : [
        ]
      }
    },
    "protected" : false,
    "followers_count" : 5682,
    "friends_count" : 137,
    "listed_count" : 242,
    "created_at" : "Mon Aug 03 17:52:07 +0000 2009",
    "favourites_count" : 233,
    "utc_offset" : 10800,
    "time_zone" : "Helsinki",
    "geo_enabled" : false,
    "verified" : false,
    "statuses_count" : 1042,
    "lang" : "en",
    "contributors_enabled" : false,
    "is_translator" : false,
    "is_translation_enabled" : false,
    "profile_background_color" : "000000",
    "profile_background_image_url" : "http://pbs.twimg.com/profile_background_images/378800000117103508/abe5a14a1f3b0b78e9038e73bf6b812d.jpeg",
    "profile_background_image_url_https" : "https://pbs.twimg.com/profile_background_images/378800000117103508/abe5a14a1f3b0b78e9038e73bf6b812d.jpeg",
    "profile_background_tile" : false,
    "profile_image_url" : "http://pbs.twimg.com/profile_images/1130292729/fb_newlogo_black480_normal.png",
    "profile_image_url_https" : "https://pbs.twimg.com/profile_images/1130292729/fb_newlogo_black480_normal.png",
    "profile_link_color" : "CBA051",
    "profile_sidebar_border_color" : "000000",
    "profile_sidebar_fill_color" : "D4802D",
    "profile_text_color" : "4A2500",
    "profile_use_background_image" : true,
    "default_profile" : false,
    "default_profile_image" : false,
    "following" : true,
    "follow_request_sent" : false,
    "notifications" : false
  },
  "geo" : null,
  "coordinates" : null,
  "place" : null,
  "contributors" : null,
  "retweeted_status" : {
    "created_at" : "Tue Apr 29 11:00:25 +0000 2014",
    "id" : 461097667775725569,
    "id_str" : "461097667775725569",
    "text" : "DIESELSTÖRMERS Kickstarter is live! - Go and check it out right now!... http://t.co/ZVmefc0w5e
#foobar",
    "source" : "<a href=\"http://www.tumblr.com/\" rel=\"nofollow\">Tumblr</a>",
    "truncated" : false,
    "in_reply_to_status_id" : null,
    "in_reply_to_status_id_str" : null,
    "in_reply_to_user_id" : null,
    "in_reply_to_user_id_str" : null,
    "in_reply_to_screen_name" : null,
    "user" : {
      "id" : 726763934,
      "id_str" : "726763934",
      "name" : "Black Forest Games",
      "screen_name" : "BlackForestTeam",
      "location" : "Offenburg",
      "description" : "South-german team that brought you Giana Sisters: Twisted Dreams",
      "url" : "http://t.co/BXuCnqlX50",
      "entities" : {
        "url" : {
          "urls" : [
            {
              "url" : "http://t.co/BXuCnqlX50",
              "expanded_url" : "http://gianasisterstwisteddreams.com",
              "display_url" : "gianasisterstwisteddreams.com",
              "indices" : [
                0,
                22
              ]
            }
          ]
        },
        "description" : {
          "urls" : [
          ]
        }
      },
      "protected" : false,
      "followers_count" : 1145,
      "friends_count" : 308,
      "listed_count" : 35,
      "created_at" : "Mon Jul 30 20:11:50 +0000 2012",
      "favourites_count" : 116,
      "utc_offset" : 7200,
      "time_zone" : "Amsterdam",
      "geo_enabled" : false,
      "verified" : false,
      "statuses_count" : 1475,
      "lang" : "en",
      "contributors_enabled" : false,
      "is_translator" : false,
      "is_translation_enabled" : false,
      "profile_background_color" : "C0DEED",
      "profile_background_image_url" : "http://abs.twimg.com/images/themes/theme1/bg.png",
      "profile_background_image_url_https" : "https://abs.twimg.com/images/themes/theme1/bg.png",
      "profile_background_tile" : false,
      "profile_image_url" : "http://pbs.twimg.com/profile_images/3694489354/ed399e59260bf71b10235dcd7eb56fe5_normal.png",
      "profile_image_url_https" : "https://pbs.twimg.com/profile_images/3694489354/ed399e59260bf71b10235dcd7eb56fe5_normal.png",
      "profile_banner_url" : "https://pbs.twimg.com/profile_banners/726763934/1369154494",
      "profile_link_color" : "0084B4",
      "profile_sidebar_border_color" : "C0DEED",
      "profile_sidebar_fill_color" : "DDEEF6",
      "profile_text_color" : "333333",
      "profile_use_background_image" : true,
      "default_profile" : true,
      "default_profile_image" : false,
      "following" : false,
      "follow_request_sent" : false,
      "notifications" : false
    },
    "geo" : null,
    "coordinates" : null,
    "place" : null,
    "contributors" : null,
    "retweet_count" : 6,
    "favorite_count" : 2,
    "entities" : {
      "hashtags" : [
      ],
      "symbols" : [
      ],
      "urls" : [
        {
          "url" : "http://t.co/ZVmefc0w5e",
          "expanded_url" : "http://tmblr.co/ZTqD4s1ERcDZg",
          "display_url" : "tmblr.co/ZTqD4s1ERcDZg",
          "indices" : [
            72,
            94
          ]
        }
      ],
      "user_mentions" : [
      ]
    },
    "favorited" : false,
    "retweeted" : false,
    "possibly_sensitive" : false,
    "lang" : "en"
  },
  "retweet_count" : 6,
  "favorite_count" : 0,
  "entities" : {
    "hashtags" : [
    ],
    "symbols" : [
    ],
    "urls" : [
      {
        "url" : "http://t.co/ZVmefc0w5e",
        "expanded_url" : "http://tmblr.co/ZTqD4s1ERcDZg",
        "display_url" : "tmblr.co/ZTqD4s1ERcDZg",
        "indices" : [
          93,
          115
        ]
      }
    ],
    "user_mentions" : [
      {
        "screen_name" : "BlackForestTeam",
        "name" : "Black Forest Games",
        "id" : 726763934,
        "id_str" : "726763934",
        "indices" : [
          3,
          19
        ]
      }
    ]
  },
  "favorited" : false,
  "retweeted" : false,
  "possibly_sensitive" : false,
  "lang" : "en"
}


""";
// """



// }}}

void matches () {
  var f = new Filter ("a+");
  assert (f.matches ("a"));
}

void matches_tweet () {
  var acc = new Account (12345, "foobar", "Foo Bar");
  var filter = new Filter ("a+");
  acc.add_filter (filter);
  var tweet = new Cb.Tweet ();
  var parser = new Json.Parser ();
  var now = new GLib.DateTime.now_local ();
  try {
    parser.load_from_data (TD1);
  } catch (GLib.Error e) {
    critical (e.message);
    return;
  }
  tweet.load_from_json (parser.get_root (), 0, now);
}

void same_user () {
  var acc = new Account (12345, "foobar", "Foo Bar");
  var filter = new Filter ("a+");
  acc.add_filter (filter);
  var tweet = new Cb.Tweet ();
  var parser = new Json.Parser ();
  var now = new GLib.DateTime.now_local ();
  try {
    parser.load_from_data (TD1);
  } catch (GLib.Error e) {
    critical (e.message);
    return;
  }
  tweet.load_from_json (parser.get_root (), 0, now);
  tweet.source_tweet.author.id = 12345;

  // Should always return false even if the filter(s) would match
  assert (!acc.filter_matches (tweet));
}



void links () {
  var acc = new Account (12345, "foobar", "Foo Bar");
  var filter = new Filter ("t\\.co");
  acc.add_filter (filter);
  var tweet = new Cb.Tweet ();
  var parser = new Json.Parser ();
  var now = new GLib.DateTime.now_local ();
  try {
    parser.load_from_data (TD1);
  } catch (GLib.Error e) {
    critical (e.message);
    return;
  }
  tweet.load_from_json (parser.get_root (), 0, now);

  // This should never match since we should be using the
  // 'real' url instead of the t.co shortened one.
  assert (!acc.filter_matches (tweet));

  // ... which is also why it should match now
  //message (tweet.get_real_text ());
  acc.add_filter (new Filter ("tmblr"));
  assert (acc.filter_matches (tweet));
}


void hashtags () {
  var acc = new Account (12345, "foobar", "Foo Bar");
  var filter = new Filter ("#foobar");
  acc.add_filter (filter);
  var tweet = new Cb.Tweet ();
  var parser = new Json.Parser ();
  var now = new GLib.DateTime.now_local ();
  try {
    parser.load_from_data (TD1);
  } catch (GLib.Error e) {
    critical (e.message);
    return;
  }
  tweet.load_from_json (parser.get_root (), 0, now);

  // This should never match since we should be using the
  // 'real' url instead of the t.co shortened one.
  assert (acc.filter_matches (tweet));
}


int main (string[] args) {
  GLib.Test.init (ref args);
  Settings.init ();
  Gtk.init (ref args);
  Twitter.get ().init ();
  Dirs.create_dirs ();
  Utils.init_soup_session ();
  GLib.Test.add_func ("/filters/matches", matches);
  GLib.Test.add_func ("/filters/matches-tweet", matches_tweet);
  GLib.Test.add_func ("/filters/same-user", same_user);
  GLib.Test.add_func ("/filters/links", links);
  GLib.Test.add_func ("/filters/hashtags", hashtags);

  return GLib.Test.run ();
}
