# -*- coding: utf-8 -*-
#
# Copyright 2013 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

from __future__ import absolute_import

import signal, subprocess

from testtools.matchers import Equals
from autopilot.matchers import Eventually
from unittest import skip

from cordova_ubuntu.tests import CordovaUbuntuTestCase
from unittest import skipIf

from time import sleep

class Alarm(Exception):
    pass

def alarm_handler(signum, frame):
    raise Alarm

ARCH = subprocess.check_output('uname -p', shell=True).lower()
TIMEOUT = 120

class TestMobileSpec(CordovaUbuntuTestCase):

    def run_mobilespec(self, test_page='all', junitxml_file=''):
        """ Executes Cordova to run a Mobile Spec Suite's automated test """
        sleep(1)
        if (junitxml_file):
            self.junitxml_remove(junitxml_file)
        web_view = self.get_webview()
        self.assertThat(web_view.loadProgress, Eventually(Equals(100)))
        # Click on "Automated tests" (index.html)
        web_view.slots.evalInPageUnsafe('document.getElementById("__automated").click();')
        self.assertThat(web_view.loadProgress, Eventually(Equals(100)))
        # Click on test (autotest/index.html)
        web_view.slots.evalInPageUnsafe('document.evaluate(\'//a[contains(@href, "%s.html")]\', document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue.click();' % test_page)
        self.assertThat(web_view.loadProgress, Eventually(Equals(100)))
        # Wait until finished (autotest/pages/all.html)
        web_view.slots.evalInPageUnsafe("document.addEventListener('junitxml-finished', function (e) { setTimeout(navigator.app.closeApp, 1000); }, false);")
        # Detect window closed
        signal.signal(signal.SIGALRM, alarm_handler)
        signal.alarm(TIMEOUT) # Setup timeout
        finished = False
        try:
            while (self.app.process.poll() is None):
                # Process still running, sleep a bit
                signal.alarm(0)
                finished = True
                if (junitxml_file):
                    self.assert_junitxml_failures(junitxml_file)
        except Alarm:
            # Timeout reached
            pass
        self.assertThat(finished, Equals(True))

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_accelerometer(self):
        self.run_mobilespec('accelerometer', 'TEST-Accelerometernavigatoraccelerometer.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_battery(self):
        self.run_mobilespec('battery', 'TEST-Batterynavigatorbattery.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_camera(self):
        self.run_mobilespec('camera', 'TEST-CameraConstantswindowCameranavigatorcamera.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_capture(self):
        self.run_mobilespec('capture', 'TEST-Capturenavigatordevicecapture.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_compass(self):
        self.run_mobilespec('compass', 'TEST-Compassnavigatorcompass.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_contacts(self):
        self.run_mobilespec('contacts', 'TEST-Contactsnavigatorcontacts.xml')

    def test_datauri(self):
        self.run_mobilespec('datauri', 'TEST-datauris.xml')

    def test_device(self):
        self.run_mobilespec('device', 'TEST-DeviceInformationwindowdevice.xml')

    def test_file(self):
        self.run_mobilespec('file', 'TEST-FileAPI.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_filetransfer(self):
        self.run_mobilespec('filetransfer', 'TEST-FileTransfer.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_geolocation(self):
        self.run_mobilespec('geolocation', 'TEST-Geolocationnavigatorgeolocation.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_globalization(self):
        self.run_mobilespec('globalization', 'TEST-Globalizationnavigatorglobalization.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_media(self):
        self.run_mobilespec('media', 'TEST-Media.xml')

    def test_network(self):
        self.run_mobilespec('network', 'TEST-Networknavigatorconnection.xml')

    def test_notification(self):
        self.run_mobilespec('notification', 'TEST-Notificationnavigatornotification.xml')

    def test_platform(self):
        self.run_mobilespec('platform', 'TEST-Platformcordova.xml')

    def test_storage(self):
        self.run_mobilespec('storage', 'TEST-SessionStorage.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_bridge(self):
        self.run_mobilespec('bridge', 'TEST-bridge.xml')

    def test_splashscreen(self):
        self.run_mobilespec('splashscreen', 'TEST-Splashscreencordova.xml')

    @skipIf('arm' in ARCH, 'This feature not yet supported on ARM.')
    def test_whitelist(self):
        self.run_mobilespec('whitelist', 'TEST-whitelist.xml')

