# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2013 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

""" Cordova Ubuntu Autopilot Test Base Class. """

import os
import os.path
import subprocess

from xml.dom import minidom
from testtools.matchers import Contains, Equals

from autopilot.input import Mouse, Touch, Pointer
from autopilot.matchers import Eventually
from autopilot.platform import model
from autopilot.testcase import AutopilotTestCase

class CordovaUbuntuTestCase(AutopilotTestCase):
    """ Base class for Cordova Ubuntu Test Cases """
    LOCAL_CORDOVA_CONTAINER_PATH = os.path.abspath("%s/%s" % (os.path.dirname(os.path.realpath(__file__)),
        '../../tools/qml/main-local.qml'))
    INSTALLED_CORDOVA_CONTAINER_PATH = '/usr/share/cordova-ubuntu-tests/autopilot-tests/qml/main.qml'
    arch = subprocess.check_output(["dpkg-architecture",
        "-qDEB_HOST_MULTIARCH"]).strip()
    QML_LAUNCHER = "/usr/lib/" + arch + "/qt5/bin/qmlscene"

    PERSISTENT_PATH= os.path.join(os.environ['HOME'], '.local/share/cordova-ubuntu/persistent/L3Vzci9zaGFyZS9jb3Jkb3ZhLXVidW50dS10ZXN0cy9jb3Jkb3ZhbW9iaWxlc3BlYy93d3c=/')
    LOCAL_PERSISTENT_PATH= os.path.join(os.environ['HOME'], '.local/share/cordova-ubuntu/persistent/L2hvbWUvdnJydWl6L3dlYmFwcHMvbHAvY29yZG92YS11YnVudHUtdGVzdHMvd3d3')

    def get_cordova_container_path(self):
        if (os.path.exists(self.LOCAL_CORDOVA_CONTAINER_PATH)):
            return self.LOCAL_CORDOVA_CONTAINER_PATH
        return self.INSTALLED_CORDOVA_CONTAINER_PATH

    def get_persistent_path(self):
        if (os.path.exists(self.LOCAL_CORDOVA_CONTAINER_PATH)):
            return self.LOCAL_PERSISTENT_PATH
        return self.PERSISTENT_PATH

    def setUp(self):
        params = [self.QML_LAUNCHER, self.get_cordova_container_path()]
        if (model() <> 'Desktop'):
            params.append('--desktop_file_hint=/usr/share/applications/cordova-ubuntu-tests.desktop')
        self.app = self.launch_test_application(
            *params,
            app_type='qt')
        print params
        super(CordovaUbuntuTestCase, self).setUp()

    def tearDown(self):
        super(CordovaUbuntuTestCase, self).tearDown()

    def pick_app_launcher(self, app_path):
        """ Force Qt app introspection """
        from autopilot.introspection.qt import QtApplicationLauncher
        return QtApplicationLauncher()

    def get_cordovaview(self):
        return self.app.select_single(objectName="cordovaView")

    def get_webview(self):
        return self.app.select_single(objectName="webView")

    def get_junitxml_path(self, junitxml_filename):
        """ Return the absolute path of a JUnit XML file """
        return os.path.join(self.get_persistent_path(), junitxml_filename)

    def junitxml_remove(self, junitxml_filename):
        """ Remove, if exists the JUnit XML file """
        file_path = self.get_junitxml_path(junitxml_filename)
        if (os.path.exists(file_path)):
            os.unlink(file_path)

    def assert_junitxml_failures(self, junitxml_filename):
        """ Open a JUnit XML file and search errors """
        file_path = self.get_junitxml_path(junitxml_filename)
        self.assertThat(os.path.exists(file_path), Equals(True))
        xml = minidom.parse(file_path)
        testsuites = xml.getElementsByTagName('testsuite')
        for testsuite in testsuites:
            failures = testsuite.attributes['failures']
            self.assertThat(failures.value, Equals('0'))
