---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# Windows Phone のアップグレード

このガイドは、Windows Phone プロジェクトでは、両方のバージョン 7 と 8 は、コルドバの旧バージョンからアップグレードするを変更する方法を示します。 これらの命令のほとんど、古いの前にあるコマンド ライン ツールのセットで作成されたプロジェクトに適用されます、 `cordova` CLI ユーティリティ。 CLI のバージョンを更新する方法については、コマンド ライン インターフェイス参照してください。 次のセクションは非 CLI プロジェクトからアップグレードする方法を示します。

## 2.9.0 から CLI (3.0.0) へのアップグレード

1.  コマンド ライン インターフェイスで説明されているようにコルドバ、CLI を使用して新しい Apache コルドバ 3.0.0 プロジェクトを作成します。

2.  あなたのプラットフォームの追加、cordova のプロジェクトします。`cordova
platform add wp7 wp8`.

3.  プロジェクトの内容をコピー `www` ディレクトリを `www` で作成したコルドバ プロジェクトのルート ディレクトリ。

4.  コピーまたは元のプロジェクトから任意のネイティブの資産を上書き ( `SplashScreen` 、 `ApplicationIcon` 、等)、確かに新しいファイルを追加する、 `.csproj` ファイル。 携帯電話の窓の内部プロジェクトのビルド、 `platforms\wp7` または `platforms\wp8` ディレクトリ。

5.  コルドバ CLI ツールを使用して、必要な任意のプラグインをインストールします。CLI 処理するすべてのコア Api のプラグインとして追加する必要がありますので注意してください。のみ 3.0.0 プラグインは CLI と互換性があります。

6.  ビルドおよびテストします。

## 2.9.0 から 3.0.0 （非 CLI） にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 WP8 3.0.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

4.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

5.  ビルドおよびテストします。

**注：**すべてのコア Api コルドバは、バージョン 3.0 から削除され、別のプラグインとしてインストールする必要があります。 非 CLI ワークフローでこれらの機能を再度有効にする方法の詳細については、管理プラグインを使用して Plugman を参照してください。

## 2.8.0 から 2.9.0 へのアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 WP8 2.9.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  名前を更新 `cordova.js` それはまだコルドバ VERSION.js （する必要がありますだけを使用している場合、HTML タグで`cordova.js`).

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクト、.csproj ファイルにも追加されることを確認します。

6.  ビルドおよびテストします。

## 2.8.0 へ 2.7.0 からのアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 WP8 2.8.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  あなたの HTML を使用して、新しい更新 `cordova.js` ファイル。(ファイル名にバージョン番号の欠如を注意してください)。

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

6.  ビルドおよびテストします。

## 2.6.0 からへ 2.7.0 をアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 WP8 2.7.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  あなたの HTML を使用して、新しい更新 `cordova-2.7.0.js` ファイル。

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

6.  ビルドおよびテストします。

## 2.5.0 から 2.6.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 WP8 2.6.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  あなたの HTML を使用して、新しい更新 `cordova-2.6.0.js` ファイル。

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

6.  ビルドおよびテストします。

## 2.4.0 から 2.5.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 WP8 2.5.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  あなたの HTML を使用して、新しい更新 `cordova-2.5.0.js` ファイル。

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

6.  ビルドおよびテストします。

## 2.3.0 から 2.4.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 WP8 2.4.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  あなたの HTML を使用して、新しい更新 `cordova-2.4.0.js` ファイル。

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

6.  ビルドおよびテストします。

## 2.2.0 から 2.3.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 2.3.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  あなたの HTML を使用して、新しい更新 `cordova-2.3.0.js` ファイル。

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

6.  ビルドおよびテストします。

## 2.1.0 から 2.2.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 2.2.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  あなたの HTML を使用して、新しい更新 `cordova-2.2.0.js` ファイル。

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

6.  ビルドおよびテストします。

## 2.0.0 から 2.1.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  作成新しい Apache コルドバ WP7 2.1.0 プロジェクトします。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  あなたの HTML を使用して、新しい更新 `cordova-2.1.0.js` ファイル。

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

6.  ビルドおよびテストします。

## 1.9.0 から 2.0.0 にアップグレードします。

されているこのアップグレードする少し複雑を Apache コルドバ 2.0.0 の WP7 のプロジェクト構造を大幅に変更、その他。 本質的にこれは、アップグレードが、新しいプロジェクトと既存のソース ファイルのコピーを作成します。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  新しい Apache コルドバ WP7 2.0 プロジェクトを作成します。

2.  内容をコピー、 `www` ディレクトリを新しいプロジェクトに VS プロジェクトにこれらの項目を追加してください。

3.  あなたの HTML を使用して、新しい更新 `cordova-2.0.0.js` ファイル。

4.  コピーし、スプラッシュ スクリーンまたはアイコン イメージを上書きします。

5.  任意のプラグイン経由でのコピー、 `plugins` ディレクトリを新しいプロジェクトし、VS プロジェクトにも追加されることを確認します。

6.  ビルドおよびテストします。

## 1.8.0 から 1.9.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注：**DLL のバージョンを表示するには、参照を右クリックし、**プロパティ**を選択して.

5.  コピー、新しい `cordova-1.9.0.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.9.0.js` ファイル。

## 1.7.0 から 1.8.0 へのアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注：**DLL のバージョンを表示するには、参照を右クリックし、**プロパティ**を選択して.

5.  コピー、新しい `cordova-1.8.0.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.8.0.js` ファイル。

## 1.6.0 から 1.7.0 へのアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注：**DLL のバージョンを表示するには、参照を右クリックし、**プロパティ**を選択して.

5.  コピー、新しい `cordova-1.7.0.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.7.0.js` ファイル。

## 1.6.0 から 1.6.1 へのアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注：**DLL のバージョンを表示するには、参照を右クリックし、**プロパティ**を選択して.

5.  コピー、新しい `cordova-1.6.1.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.6.1.js` ファイル。

## 1.5.0 から 1.6.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注：**DLL のバージョンを表示するには、参照を右クリックし、**プロパティ**を選択して.

5.  コピー、新しい `cordova-1.6.0.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.6.0.js` ファイル。

## 1.4.0 から 1.5.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注：**DLL のバージョンを表示するには、参照を右クリックし、**プロパティ**を選択して.

5.  コピー、新しい `cordova-1.5.0.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.5.0.js` ファイル。

## 1.3.0 から 1.4.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注：**DLL のバージョンを表示するには、参照を右クリックし、**プロパティ**を選択して.

5.  コピー、新しい `cordova-1.4.0.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.4.0.js` ファイル。

## 1.3.0 に 1.2.0 からアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注：**DLL のバージョンを表示するには、参照を右クリックし、**プロパティ**を選択して.

5.  コピー、新しい `cordova-1.3.0.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.3.0.js` ファイル。

## 1.1.0 から 1.2.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注：**DLL のバージョンを表示するには、参照を右クリックし、**プロパティ**を選択して.

5.  コピー、新しい `cordova-1.2.0.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.2.0.js` ファイル。

## 1.0.0 1.1.0 にアップグレードします。

Visual Studio のソリューション エクスプ ローラー ウィンドウで次

1.  削除 `GapLib/WP7CordovaClassLib.dll` プロジェクトから。

2.  参照を削除する `WP7CordovaClassLib` **参照**フォルダー。

3.  **参照**を右クリックし、 **[参照の追加**を選択します.

4.  新しいディストリビューションに移動し、ファイルを追加`WP7CordovaClassLib.dll`.
    
    *   **注:**は参照を右クリックし、**プロパティ**を選択することによって、DLL のバージョンを表示します。.

5.  コピー、新しい `cordova-1.1.0.js` プロジェクトに。(コンテンツとしてマークされていることを必ずしてください。)

6.  あなたの HTML を使用して、新しい更新 `cordova-1.1.0.js` ファイル。