---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# Local

Cet objet fournit un moyen d'obtenir des systèmes de fichiers racine.

## Méthodes

*   **requestFileSystem**: demande un système de fichiers. *(Fonction)*

*   **resolveLocalFileSystemURI**: récupérer un `DirectoryEntry` ou `FileEntry` à l'aide d'URI local. *(Fonction)*

## Constantes

*   `LocalFileSystem.PERSISTENT`: Utilisé pour le stockage, ce qui ne devrait pas être retiré par l'agent utilisateur sans autorisation d'application ou utilisateur.

*   `LocalFileSystem.TEMPORARY`: Utilisé pour le stockage sans garantie de persistance.

## Détails

Les `LocalFileSystem` méthodes de l'objet sont définis sur le `window` objet.

## Plates-formes prises en charge

*   Android
*   BlackBerry WebWorks (OS 5.0 et plus)
*   iOS
*   Windows Phone 7 et 8
*   Windows 8

## Demande de fichier système exemple rapide

    function onSuccess(fileSystem) {
        console.log(fileSystem.name);
    }
    
    // request the persistent file system
    window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, onSuccess, onError);
    

## Résoudre le système de fichiers Local URI petit exemple

    function onSuccess(fileEntry) {
        console.log(fileEntry.name);
    }
    
    window.resolveLocalFileSystemURI("file:///example.txt", onSuccess, onError);
    

## Exemple complet

    <!DOCTYPE html>
    <html>
      <head>
        <title>Local File System Example</title>
    
        <script type="text/javascript" charset="utf-8" src="cordova.js"></script>
        <script type="text/javascript" charset="utf-8">
    
        // Wait for device API libraries to load
        //
        document.addEventListener("deviceready", onDeviceReady, false);
    
        // device APIs are available
        //
        function onDeviceReady() {
            window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, onFileSystemSuccess, fail);
            window.resolveLocalFileSystemURI("file:///example.txt", onResolveSuccess, fail);
        }
    
        function onFileSystemSuccess(fileSystem) {
            console.log(fileSystem.name);
        }
    
        function onResolveSuccess(fileEntry) {
            console.log(fileEntry.name);
        }
    
        function fail(evt) {
            console.log(evt.target.error.code);
        }
    
        </script>
      </head>
      <body>
        <h1>Example</h1>
        <p>Local File System</p>
      </body>
    </html>
    

# requestFileSystem

> Demander un système de fichier dans lequel stocker les données d'application.

     window.requestFileSystem(type, size, successCallback, errorCallback)
    

*   **fenêtre**: référence à l'objet global window
*   **type**: local type de système de fichiers, voir local constantes
*   **taille**: indique la quantité d'espace stockage, en octets, l'application attend d'avoir besoin
*   **successCallback**: appelée avec un objet système de fichiers
*   **errorCallback**: invoquée si l'erreur produit de récupération système de fichiers

## Demande de fichier système exemple rapide

    function onSuccess(fileSystem) {
        console.log(fileSystem.name);
    }
    
    // request the persistent file system
    window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, onSuccess, onError);