# Contents of the UniMath library
The packages and files are listed here in logical order: each file depends only on files occurring earlier.
## Package [Foundations](Foundations/README)
   - [Init.v](Foundations/Init.v)
   - [Preamble.v](Foundations/Preamble.v)
   - [PartA.v](Foundations/PartA.v)
   - [PartB.v](Foundations/PartB.v)
   - [UnivalenceAxiom.v](Foundations/UnivalenceAxiom.v)
   - [PartC.v](Foundations/PartC.v)
   - [PartD.v](Foundations/PartD.v)
   - [UnivalenceAxiom2.v](Foundations/UnivalenceAxiom2.v)
   - [Propositions.v](Foundations/Propositions.v)
   - [Sets.v](Foundations/Sets.v)
   - [NaturalNumbers.v](Foundations/NaturalNumbers.v)
   - [Tests.v](Foundations/Tests.v)
   - [HLevels.v](Foundations/HLevels.v)
   - [All.v](Foundations/All.v)
## Package [MoreFoundations](MoreFoundations/README.md)
   - [Bool.v](MoreFoundations/Bool.v)
   - [Test.v](MoreFoundations/Test.v)
   - [WeakEquivalences.v](MoreFoundations/WeakEquivalences.v)
   - [Tactics.v](MoreFoundations/Tactics.v)
   - [PartA.v](MoreFoundations/PartA.v)
   - [PathsOver.v](MoreFoundations/PathsOver.v)
   - [Nat.v](MoreFoundations/Nat.v)
   - [Notations.v](MoreFoundations/Notations.v)
   - [AlternativeProofs.v](MoreFoundations/AlternativeProofs.v)
   - [Subposets.v](MoreFoundations/Subposets.v)
   - [DoubleNegation.v](MoreFoundations/DoubleNegation.v)
   - [DecidablePropositions.v](MoreFoundations/DecidablePropositions.v)
   - [Propositions.v](MoreFoundations/Propositions.v)
   - [NullHomotopies.v](MoreFoundations/NullHomotopies.v)
   - [Interval.v](MoreFoundations/Interval.v)
   - [NegativePropositions.v](MoreFoundations/NegativePropositions.v)
   - [Sets.v](MoreFoundations/Sets.v)
   - [Orders.v](MoreFoundations/Orders.v)
   - [Equivalences.v](MoreFoundations/Equivalences.v)
   - [MoreEquivalences.v](MoreFoundations/MoreEquivalences.v)
   - [QuotientSet.v](MoreFoundations/QuotientSet.v)
   - [Subtypes.v](MoreFoundations/Subtypes.v)
   - [AxiomOfChoice.v](MoreFoundations/AxiomOfChoice.v)
   - [StructureIdentity.v](MoreFoundations/StructureIdentity.v)
   - [Univalence.v](MoreFoundations/Univalence.v)
   - [NoInjectivePairing.v](MoreFoundations/NoInjectivePairing.v)
   - [PartD.v](MoreFoundations/PartD.v)
   - [All.v](MoreFoundations/All.v)
## Package [Combinatorics](Combinatorics/README.md)
   - [StandardFiniteSets.v](Combinatorics/StandardFiniteSets.v)
   - [Vectors.v](Combinatorics/Vectors.v)
   - [VectorsTests.v](Combinatorics/VectorsTests.v)
   - [Lists.v](Combinatorics/Lists.v)
   - [FiniteSets.v](Combinatorics/FiniteSets.v)
   - [KFiniteTypes.v](Combinatorics/KFiniteTypes.v)
   - [KFiniteSubtypes.v](Combinatorics/KFiniteSubtypes.v)
   - [Graph.v](Combinatorics/Graph.v)
   - [CGraph.v](Combinatorics/CGraph.v)
   - [GraphPaths.v](Combinatorics/GraphPaths.v)
   - [Equivalence_Relations.v](Combinatorics/Equivalence_Relations.v)
   - [OrderedSets.v](Combinatorics/OrderedSets.v)
   - [Posets/Basics.v](Combinatorics/Posets/Basics.v)
   - [Posets/MonotoneFunctions.v](Combinatorics/Posets/MonotoneFunctions.v)
   - [Posets/PointedPosets.v](Combinatorics/Posets/PointedPosets.v)
   - [Posets/QuotientPoset.v](Combinatorics/Posets/QuotientPoset.v)
   - [Posets.v](Combinatorics/Posets.v)
   - [WellFoundedRelations.v](Combinatorics/WellFoundedRelations.v)
   - [WellOrderedSets.v](Combinatorics/WellOrderedSets.v)
   - [ZFstructures.v](Combinatorics/ZFstructures.v)
   - [FiniteSequences.v](Combinatorics/FiniteSequences.v)
   - [BoundedSearch.v](Combinatorics/BoundedSearch.v)
   - [MetricTree.v](Combinatorics/MetricTree.v)
   - [Tests.v](Combinatorics/Tests.v)
   - [DecSet.v](Combinatorics/DecSet.v)
   - [Maybe.v](Combinatorics/Maybe.v)
   - [MoreLists.v](Combinatorics/MoreLists.v)
   - [All.v](Combinatorics/All.v)
## Package [Algebra](Algebra/README.md)
   - [Dcpo.v](Algebra/Dcpo.v)
   - [FixedPointTheorems.v](Algebra/FixedPointTheorems.v)
   - [BinaryOperations.v](Algebra/BinaryOperations.v)
   - [Monoids.v](Algebra/Monoids.v)
   - [Groups.v](Algebra/Groups.v)
   - [GroupAction.v](Algebra/GroupAction.v)
   - [RigsAndRings.v](Algebra/RigsAndRings.v)
   - [RigsAndRings/Ideals.v](Algebra/RigsAndRings/Ideals.v)
   - [Domains_and_Fields.v](Algebra/Domains_and_Fields.v)
   - [DivisionRig.v](Algebra/DivisionRig.v)
   - [Apartness.v](Algebra/Apartness.v)
   - [ConstructiveStructures.v](Algebra/ConstructiveStructures.v)
   - [Archimedean.v](Algebra/Archimedean.v)
   - [Lattice/Lattice.v](Algebra/Lattice/Lattice.v)
   - [Lattice/Bounded.v](Algebra/Lattice/Bounded.v)
   - [Lattice/Complement.v](Algebra/Lattice/Complement.v)
   - [Lattice/Distributive.v](Algebra/Lattice/Distributive.v)
   - [Lattice/Heyting.v](Algebra/Lattice/Heyting.v)
   - [Lattice/Boolean.v](Algebra/Lattice/Boolean.v)
   - [Lattice/Examples/Bool.v](Algebra/Lattice/Examples/Bool.v)
   - [Lattice/Examples/Subsets.v](Algebra/Lattice/Examples/Subsets.v)
   - [IteratedBinaryOperations.v](Algebra/IteratedBinaryOperations.v)
   - [Free_Monoids_and_Groups.v](Algebra/Free_Monoids_and_Groups.v)
   - [Tests.v](Algebra/Tests.v)
   - [Modules/Core.v](Algebra/Modules/Core.v)
   - [Modules/Submodule.v](Algebra/Modules/Submodule.v)
   - [Modules/Multimodules.v](Algebra/Modules/Multimodules.v)
   - [Modules/Examples.v](Algebra/Modules/Examples.v)
   - [Modules/Quotient.v](Algebra/Modules/Quotient.v)
   - [Modules.v](Algebra/Modules.v)
   - [Matrix.v](Algebra/Matrix.v)
   - [Universal/HVectors.v](Algebra/Universal/HVectors.v)
   - [Universal/SortedTypes.v](Algebra/Universal/SortedTypes.v)
   - [Universal/Signatures.v](Algebra/Universal/Signatures.v)
   - [Universal/Algebras.v](Algebra/Universal/Algebras.v)
   - [Universal/Terms.v](Algebra/Universal/Terms.v)
   - [Universal/TermAlgebras.v](Algebra/Universal/TermAlgebras.v)
   - [Universal/VTerms.v](Algebra/Universal/VTerms.v)
   - [Universal/FreeAlgebras.v](Algebra/Universal/FreeAlgebras.v)
   - [Universal/Equations.v](Algebra/Universal/Equations.v)
   - [Universal/EqAlgebras.v](Algebra/Universal/EqAlgebras.v)
   - [Universal/Examples/Nat.v](Algebra/Universal/Examples/Nat.v)
   - [Universal/Examples/Bool.v](Algebra/Universal/Examples/Bool.v)
   - [Universal/Examples/Monoid.v](Algebra/Universal/Examples/Monoid.v)
   - [Universal/Examples/Group.v](Algebra/Universal/Examples/Group.v)
   - [Universal/Examples/ListDataType.v](Algebra/Universal/Examples/ListDataType.v)
   - [Universal/Examples/Tests.v](Algebra/Universal/Examples/Tests.v)
   - [Universal.v](Algebra/Universal.v)
   - [GaussianElimination/Auxiliary.v](Algebra/GaussianElimination/Auxiliary.v)
   - [GaussianElimination/Vectors.v](Algebra/GaussianElimination/Vectors.v)
   - [GaussianElimination/Matrices.v](Algebra/GaussianElimination/Matrices.v)
   - [GaussianElimination/RowOps.v](Algebra/GaussianElimination/RowOps.v)
   - [GaussianElimination/Elimination.v](Algebra/GaussianElimination/Elimination.v)
   - [GaussianElimination/Corollaries.v](Algebra/GaussianElimination/Corollaries.v)
   - [GaussianElimination/Tests.v](Algebra/GaussianElimination/Tests.v)
   - [All.v](Algebra/All.v)
## Package Tactics
   - [EnsureStructuredProofs.v](Tactics/EnsureStructuredProofs.v)
   - [Utilities.v](Tactics/Utilities.v)
   - [Monoids_Tactics.v](Tactics/Monoids_Tactics.v)
   - [Abmonoids_Tactics.v](Tactics/Abmonoids_Tactics.v)
   - [Groups_Tactics.v](Tactics/Groups_Tactics.v)
   - [Nat_Tactics.v](Tactics/Nat_Tactics.v)
   - [All.v](Tactics/All.v)
## Package NumberSystems
   - [NaturalNumbersAlgebra.v](NumberSystems/NaturalNumbersAlgebra.v)
   - [NaturalNumbers_le_Inductive.v](NumberSystems/NaturalNumbers_le_Inductive.v)
   - [Integers.v](NumberSystems/Integers.v)
   - [RationalNumbers.v](NumberSystems/RationalNumbers.v)
   - [Tests.v](NumberSystems/Tests.v)
   - [All.v](NumberSystems/All.v)
## Package [SyntheticHomotopyTheory](SyntheticHomotopyTheory/README.md)
   - [Halfline.v](SyntheticHomotopyTheory/Halfline.v)
   - [AffineLine.v](SyntheticHomotopyTheory/AffineLine.v)
   - [Circle.v](SyntheticHomotopyTheory/Circle.v)
   - [Circle2.v](SyntheticHomotopyTheory/Circle2.v)
   - [Test.v](SyntheticHomotopyTheory/Test.v)
   - [All.v](SyntheticHomotopyTheory/All.v)
## Package [PAdics](PAdics/README.md)
   - [lemmas.v](PAdics/lemmas.v)
   - [fps.v](PAdics/fps.v)
   - [frac.v](PAdics/frac.v)
   - [z_mod_p.v](PAdics/z_mod_p.v)
   - [padics.v](PAdics/padics.v)
   - [All.v](PAdics/All.v)
## Package [CategoryTheory](CategoryTheory/README.md)
   - [Core/Categories.v](CategoryTheory/Core/Categories.v)
   - [Core/TwoCategories.v](CategoryTheory/Core/TwoCategories.v)
   - [Core/Isos.v](CategoryTheory/Core/Isos.v)
   - [Core/Univalence.v](CategoryTheory/Core/Univalence.v)
   - [Core/TransportMorphisms.v](CategoryTheory/Core/TransportMorphisms.v)
   - [Core/Functors.v](CategoryTheory/Core/Functors.v)
   - [Core/NaturalTransformations.v](CategoryTheory/Core/NaturalTransformations.v)
   - [Core/Setcategories.v](CategoryTheory/Core/Setcategories.v)
   - [Core/EssentiallyAlgebraic.v](CategoryTheory/Core/EssentiallyAlgebraic.v)
   - [Core/Prelude.v](CategoryTheory/Core/Prelude.v)
   - [FunctorCategory.v](CategoryTheory/FunctorCategory.v)
   - [whiskering.v](CategoryTheory/whiskering.v)
   - [BicatOfCatsElementary.v](CategoryTheory/BicatOfCatsElementary.v)
   - [DisplayedCats/Core.v](CategoryTheory/DisplayedCats/Core.v)
   - [DisplayedCats/Isos.v](CategoryTheory/DisplayedCats/Isos.v)
   - [DisplayedCats/Functors.v](CategoryTheory/DisplayedCats/Functors.v)
   - [DisplayedCats/NaturalTransformations.v](CategoryTheory/DisplayedCats/NaturalTransformations.v)
   - [DisplayedCats/Univalence.v](CategoryTheory/DisplayedCats/Univalence.v)
   - [DisplayedCats/Total.v](CategoryTheory/DisplayedCats/Total.v)
   - [DisplayedCats/Fiber.v](CategoryTheory/DisplayedCats/Fiber.v)
   - [categories/CategoryOfSetCategories.v](CategoryTheory/categories/CategoryOfSetCategories.v)
   - [opp_precat.v](CategoryTheory/opp_precat.v)
   - [OppositeCategory/Core.v](CategoryTheory/OppositeCategory/Core.v)
   - [Groupoids.v](CategoryTheory/Groupoids.v)
   - [ZigZag.v](CategoryTheory/ZigZag.v)
   - [ProductCategory.v](CategoryTheory/ProductCategory.v)
   - [PrecategoryBinProduct.v](CategoryTheory/PrecategoryBinProduct.v)
   - [categories/HSET/Core.v](CategoryTheory/categories/HSET/Core.v)
   - [CategorySum.v](CategoryTheory/CategorySum.v)
   - [Subcategory/Core.v](CategoryTheory/Subcategory/Core.v)
   - [Subcategory/Full.v](CategoryTheory/Subcategory/Full.v)
   - [Monics.v](CategoryTheory/Monics.v)
   - [Epis.v](CategoryTheory/Epis.v)
   - [SplitMonicsAndEpis.v](CategoryTheory/SplitMonicsAndEpis.v)
   - [HomotopicalCategory.v](CategoryTheory/HomotopicalCategory.v)
   - [Adjunctions/Core.v](CategoryTheory/Adjunctions/Core.v)
   - [Monads/RelativeMonads.v](CategoryTheory/Monads/RelativeMonads.v)
   - [Monads/RelMonads_Coreflection.v](CategoryTheory/Monads/RelMonads_Coreflection.v)
   - [Monads/RelativeModules.v](CategoryTheory/Monads/RelativeModules.v)
   - [Equivalences/Core.v](CategoryTheory/Equivalences/Core.v)
   - [Equivalences/CompositesAndInverses.v](CategoryTheory/Equivalences/CompositesAndInverses.v)
   - [Equivalences/FullyFaithful.v](CategoryTheory/Equivalences/FullyFaithful.v)
   - [Subcategory/FullEquivalences.v](CategoryTheory/Subcategory/FullEquivalences.v)
   - [categories/HSET/MonoEpiIso.v](CategoryTheory/categories/HSET/MonoEpiIso.v)
   - [categories/HSET/Univalence.v](CategoryTheory/categories/HSET/Univalence.v)
   - [Profunctors/Core.v](CategoryTheory/Profunctors/Core.v)
   - [CategoriesWithBinOps.v](CategoryTheory/CategoriesWithBinOps.v)
   - [PrecategoriesWithAbgrops.v](CategoryTheory/PrecategoriesWithAbgrops.v)
   - [covyoneda.v](CategoryTheory/covyoneda.v)
   - [limits/cones.v](CategoryTheory/limits/cones.v)
   - [limits/equalizers.v](CategoryTheory/limits/equalizers.v)
   - [limits/graphs/colimits.v](CategoryTheory/limits/graphs/colimits.v)
   - [limits/graphs/limits.v](CategoryTheory/limits/graphs/limits.v)
   - [limits/graphs/eqdiag.v](CategoryTheory/limits/graphs/eqdiag.v)
   - [limits/coproducts.v](CategoryTheory/limits/coproducts.v)
   - [limits/products.v](CategoryTheory/limits/products.v)
   - [limits/initial.v](CategoryTheory/limits/initial.v)
   - [limits/terminal.v](CategoryTheory/limits/terminal.v)
   - [limits/zero.v](CategoryTheory/limits/zero.v)
   - [limits/bincoproducts.v](CategoryTheory/limits/bincoproducts.v)
   - [limits/binproducts.v](CategoryTheory/limits/binproducts.v)
   - [limits/graphs/bincoproducts.v](CategoryTheory/limits/graphs/bincoproducts.v)
   - [limits/graphs/binproducts.v](CategoryTheory/limits/graphs/binproducts.v)
   - [limits/pullbacks.v](CategoryTheory/limits/pullbacks.v)
   - [limits/graphs/initial.v](CategoryTheory/limits/graphs/initial.v)
   - [limits/graphs/terminal.v](CategoryTheory/limits/graphs/terminal.v)
   - [limits/graphs/zero.v](CategoryTheory/limits/graphs/zero.v)
   - [limits/graphs/pullbacks.v](CategoryTheory/limits/graphs/pullbacks.v)
   - [limits/coequalizers.v](CategoryTheory/limits/coequalizers.v)
   - [limits/kernels.v](CategoryTheory/limits/kernels.v)
   - [limits/cokernels.v](CategoryTheory/limits/cokernels.v)
   - [PreAdditive.v](CategoryTheory/PreAdditive.v)
   - [limits/pushouts.v](CategoryTheory/limits/pushouts.v)
   - [limits/graphs/pushouts.v](CategoryTheory/limits/graphs/pushouts.v)
   - [limits/graphs/equalizers.v](CategoryTheory/limits/graphs/equalizers.v)
   - [limits/graphs/coequalizers.v](CategoryTheory/limits/graphs/coequalizers.v)
   - [limits/graphs/kernels.v](CategoryTheory/limits/graphs/kernels.v)
   - [limits/graphs/cokernels.v](CategoryTheory/limits/graphs/cokernels.v)
   - [limits/cats/limits.v](CategoryTheory/limits/cats/limits.v)
   - [limits/BinDirectSums.v](CategoryTheory/limits/BinDirectSums.v)
   - [limits/FinOrdProducts.v](CategoryTheory/limits/FinOrdProducts.v)
   - [limits/FinOrdCoproducts.v](CategoryTheory/limits/FinOrdCoproducts.v)
   - [limits/Opp.v](CategoryTheory/limits/Opp.v)
   - [limits/Preservation.v](CategoryTheory/limits/Preservation.v)
   - [limits/Ends.v](CategoryTheory/limits/Ends.v)
   - [DisplayedCats/Binproducts.v](CategoryTheory/DisplayedCats/Binproducts.v)
   - [limits/Examples/CategoryProductLimits.v](CategoryTheory/limits/Examples/CategoryProductLimits.v)
   - [limits/Examples/CategoryOfSetcategoriesLimits.v](CategoryTheory/limits/Examples/CategoryOfSetcategoriesLimits.v)
   - [limits/StandardDiagrams.v](CategoryTheory/limits/StandardDiagrams.v)
   - [limits/Filtered.v](CategoryTheory/limits/Filtered.v)
   - [IsoCommaCategory.v](CategoryTheory/IsoCommaCategory.v)
   - [limits/Examples/IsoCommaLimits.v](CategoryTheory/limits/Examples/IsoCommaLimits.v)
   - [CommaCategories.v](CategoryTheory/CommaCategories.v)
   - [NNO.v](CategoryTheory/NNO.v)
   - [Subcategory/Limits.v](CategoryTheory/Subcategory/Limits.v)
   - [EpiFacts.v](CategoryTheory/EpiFacts.v)
   - [categories/Type/Core.v](CategoryTheory/categories/Type/Core.v)
   - [categories/Type/MonoEpiIso.v](CategoryTheory/categories/Type/MonoEpiIso.v)
   - [SimplicialSets.v](CategoryTheory/SimplicialSets.v)
   - [yoneda.v](CategoryTheory/yoneda.v)
   - [Monads/Monads.v](CategoryTheory/Monads/Monads.v)
   - [Monads/KleisliCategory.v](CategoryTheory/Monads/KleisliCategory.v)
   - [Monads/LModules.v](CategoryTheory/Monads/LModules.v)
   - [FunctorCoalgebras.v](CategoryTheory/FunctorCoalgebras.v)
   - [precomp_fully_faithful.v](CategoryTheory/precomp_fully_faithful.v)
   - [precomp_ess_surj.v](CategoryTheory/precomp_ess_surj.v)
   - [PrecompEquivalence.v](CategoryTheory/PrecompEquivalence.v)
   - [rezk_completion.v](CategoryTheory/rezk_completion.v)
   - [RezkCompletion.v](CategoryTheory/RezkCompletion.v)
   - [UnitorsAndAssociatorsForEndofunctors.v](CategoryTheory/UnitorsAndAssociatorsForEndofunctors.v)
   - [PointedFunctors.v](CategoryTheory/PointedFunctors.v)
   - [HorizontalComposition.v](CategoryTheory/HorizontalComposition.v)
   - [PointedFunctorsComposition.v](CategoryTheory/PointedFunctorsComposition.v)
   - [ArrowCategory.v](CategoryTheory/ArrowCategory.v)
   - [RightKanExtension.v](CategoryTheory/RightKanExtension.v)
   - [coslicecat.v](CategoryTheory/coslicecat.v)
   - [catiso.v](CategoryTheory/catiso.v)
   - [CategoryEquality.v](CategoryTheory/CategoryEquality.v)
   - [exponentials.v](CategoryTheory/exponentials.v)
   - [slicecat.v](CategoryTheory/slicecat.v)
   - [limits/pullbacks_slice_products_equiv.v](CategoryTheory/limits/pullbacks_slice_products_equiv.v)
   - [Additive.v](CategoryTheory/Additive.v)
   - [Abelian.v](CategoryTheory/Abelian.v)
   - [category_binops.v](CategoryTheory/category_binops.v)
   - [AbelianToAdditive.v](CategoryTheory/AbelianToAdditive.v)
   - [Morphisms.v](CategoryTheory/Morphisms.v)
   - [ExactCategories/ExactCategories.v](CategoryTheory/ExactCategories/ExactCategories.v)
   - [ExactCategories/Tests.v](CategoryTheory/ExactCategories/Tests.v)
   - [ShortExactSequences.v](CategoryTheory/ShortExactSequences.v)
   - [AdditiveFunctors.v](CategoryTheory/AdditiveFunctors.v)
   - [LocalizingClass.v](CategoryTheory/LocalizingClass.v)
   - [UnderCategories.v](CategoryTheory/UnderCategories.v)
   - [Subobjects.v](CategoryTheory/Subobjects.v)
   - [SubobjectClassifier.v](CategoryTheory/SubobjectClassifier.v)
   - [Quotobjects.v](CategoryTheory/Quotobjects.v)
   - [AbelianPushoutPullback.v](CategoryTheory/AbelianPushoutPullback.v)
   - [PseudoElements.v](CategoryTheory/PseudoElements.v)
   - [FiveLemma.v](CategoryTheory/FiveLemma.v)
   - [LatticeObject.v](CategoryTheory/LatticeObject.v)
   - [Actions.v](CategoryTheory/Actions.v)
   - [PowerObject.v](CategoryTheory/PowerObject.v)
   - [ElementaryTopos.v](CategoryTheory/ElementaryTopos.v)
   - [Monads/KTriples.v](CategoryTheory/Monads/KTriples.v)
   - [Monads/Kleisli.v](CategoryTheory/Monads/Kleisli.v)
   - [Monads/KTriplesEquiv.v](CategoryTheory/Monads/KTriplesEquiv.v)
   - [Monads/Derivative.v](CategoryTheory/Monads/Derivative.v)
   - [Monads/MonadAlgebras.v](CategoryTheory/Monads/MonadAlgebras.v)
   - [Adjunctions/Restriction.v](CategoryTheory/Adjunctions/Restriction.v)
   - [Adjunctions/Examples.v](CategoryTheory/Adjunctions/Examples.v)
   - [Subcategory/Reflective.v](CategoryTheory/Subcategory/Reflective.v)
   - [categories/setwith2binops.v](CategoryTheory/categories/setwith2binops.v)
   - [categories/monoids.v](CategoryTheory/categories/monoids.v)
   - [categories/abmonoids.v](CategoryTheory/categories/abmonoids.v)
   - [categories/grs.v](CategoryTheory/categories/grs.v)
   - [categories/abgrs.v](CategoryTheory/categories/abgrs.v)
   - [categories/rigs.v](CategoryTheory/categories/rigs.v)
   - [categories/commrigs.v](CategoryTheory/categories/commrigs.v)
   - [categories/rings.v](CategoryTheory/categories/rings.v)
   - [categories/commrings.v](CategoryTheory/categories/commrings.v)
   - [categories/intdoms.v](CategoryTheory/categories/intdoms.v)
   - [categories/flds.v](CategoryTheory/categories/flds.v)
   - [categories/modules.v](CategoryTheory/categories/modules.v)
   - [categories/StandardCategories.v](CategoryTheory/categories/StandardCategories.v)
   - [categories/preorder_categories.v](CategoryTheory/categories/preorder_categories.v)
   - [limits/Examples/UnitCategoryLimits.v](CategoryTheory/limits/Examples/UnitCategoryLimits.v)
   - [categories/Type/Colimits.v](CategoryTheory/categories/Type/Colimits.v)
   - [categories/Type/Limits.v](CategoryTheory/categories/Type/Limits.v)
   - [categories/Type/Structures.v](CategoryTheory/categories/Type/Structures.v)
   - [categories/Type/Univalence.v](CategoryTheory/categories/Type/Univalence.v)
   - [categories/HSET/Limits.v](CategoryTheory/categories/HSET/Limits.v)
   - [categories/HSET/Colimits.v](CategoryTheory/categories/HSET/Colimits.v)
   - [categories/HSET/FilteredColimits.v](CategoryTheory/categories/HSET/FilteredColimits.v)
   - [categories/HSET/Slice.v](CategoryTheory/categories/HSET/Slice.v)
   - [categories/HSET/Structures.v](CategoryTheory/categories/HSET/Structures.v)
   - [categories/HSET/SliceFamEquiv.v](CategoryTheory/categories/HSET/SliceFamEquiv.v)
   - [categories/HSET/All.v](CategoryTheory/categories/HSET/All.v)
   - [SetValuedFunctors.v](CategoryTheory/SetValuedFunctors.v)
   - [categories/FinSet.v](CategoryTheory/categories/FinSet.v)
   - [categories/wosets.v](CategoryTheory/categories/wosets.v)
   - [categories/Graph.v](CategoryTheory/categories/Graph.v)
   - [categories/CGraph.v](CategoryTheory/categories/CGraph.v)
   - [GrothendieckTopos.v](CategoryTheory/GrothendieckTopos.v)
   - [Presheaf.v](CategoryTheory/Presheaf.v)
   - [ElementsOp.v](CategoryTheory/ElementsOp.v)
   - [elems_slice_equiv.v](CategoryTheory/elems_slice_equiv.v)
   - [YonedaBinproducts.v](CategoryTheory/YonedaBinproducts.v)
   - [ExponentiationLeftAdjoint.v](CategoryTheory/ExponentiationLeftAdjoint.v)
   - [Connected.v](CategoryTheory/Connected.v)
   - [LeftKanExtension.v](CategoryTheory/LeftKanExtension.v)
   - [categories/CartesianCubicalSets.v](CategoryTheory/categories/CartesianCubicalSets.v)
   - [OppositeCategory/OppositeAdjunction.v](CategoryTheory/OppositeCategory/OppositeAdjunction.v)
   - [OppositeCategory/OppositeOfFunctorCategory.v](CategoryTheory/OppositeCategory/OppositeOfFunctorCategory.v)
   - [Chains/Chains.v](CategoryTheory/Chains/Chains.v)
   - [Chains/Cochains.v](CategoryTheory/Chains/Cochains.v)
   - [DisplayedCats/Examples/Opposite.v](CategoryTheory/DisplayedCats/Examples/Opposite.v)
   - [DisplayedCats/Fibrations.v](CategoryTheory/DisplayedCats/Fibrations.v)
   - [DisplayedCats/Examples/Reindexing.v](CategoryTheory/DisplayedCats/Examples/Reindexing.v)
   - [DisplayedCats/Constructions.v](CategoryTheory/DisplayedCats/Constructions.v)
   - [FunctorAlgebras.v](CategoryTheory/FunctorAlgebras.v)
   - [Chains/Adamek.v](CategoryTheory/Chains/Adamek.v)
   - [Chains/CoAdamek.v](CategoryTheory/Chains/CoAdamek.v)
   - [Chains/OmegaCocontFunctors.v](CategoryTheory/Chains/OmegaCocontFunctors.v)
   - [OppositeCategory/LimitsAsColimits.v](CategoryTheory/OppositeCategory/LimitsAsColimits.v)
   - [Chains/OmegaContFunctors.v](CategoryTheory/Chains/OmegaContFunctors.v)
   - [Chains/All.v](CategoryTheory/Chains/All.v)
   - [Inductives/Lists.v](CategoryTheory/Inductives/Lists.v)
   - [Inductives/Trees.v](CategoryTheory/Inductives/Trees.v)
   - [Inductives/LambdaCalculus.v](CategoryTheory/Inductives/LambdaCalculus.v)
   - [Inductives/PropositionalLogic.v](CategoryTheory/Inductives/PropositionalLogic.v)
   - [CategoricalRecursionSchemes.v](CategoryTheory/CategoricalRecursionSchemes.v)
   - [DisplayedCats/Equivalences.v](CategoryTheory/DisplayedCats/Equivalences.v)
   - [DisplayedCats/Codomain.v](CategoryTheory/DisplayedCats/Codomain.v)
   - [DisplayedCats/Projection.v](CategoryTheory/DisplayedCats/Projection.v)
   - [DisplayedCats/SIP.v](CategoryTheory/DisplayedCats/SIP.v)
   - [DisplayedCats/Limits.v](CategoryTheory/DisplayedCats/Limits.v)
   - [DisplayedCats/Examples.v](CategoryTheory/DisplayedCats/Examples.v)
   - [DisplayedCats/Examples/UnitalBinop.v](CategoryTheory/DisplayedCats/Examples/UnitalBinop.v)
   - [DisplayedCats/Examples/CategoryOfPosets.v](CategoryTheory/DisplayedCats/Examples/CategoryOfPosets.v)
   - [DisplayedCats/Structures/CartesianStructure.v](CategoryTheory/DisplayedCats/Structures/CartesianStructure.v)
   - [DisplayedCats/Structures/StructureLimitsAndColimits.v](CategoryTheory/DisplayedCats/Structures/StructureLimitsAndColimits.v)
   - [DisplayedCats/Structures/StructuresSmashProduct.v](CategoryTheory/DisplayedCats/Structures/StructuresSmashProduct.v)
   - [DisplayedCats/Structures/ExamplesOfStructures.v](CategoryTheory/DisplayedCats/Structures/ExamplesOfStructures.v)
   - [DisplayedCats/FunctorCategory.v](CategoryTheory/DisplayedCats/FunctorCategory.v)
   - [DisplayedCats/Adjunctions.v](CategoryTheory/DisplayedCats/Adjunctions.v)
   - [DisplayedCats/ComprehensionC.v](CategoryTheory/DisplayedCats/ComprehensionC.v)
   - [DisplayedCats/StreetFibration.v](CategoryTheory/DisplayedCats/StreetFibration.v)
   - [DisplayedCats/StreetOpFibration.v](CategoryTheory/DisplayedCats/StreetOpFibration.v)
   - [DisplayedCats/TotalCategoryFacts.v](CategoryTheory/DisplayedCats/TotalCategoryFacts.v)
   - [DisplayedCats/TotalAdjunction.v](CategoryTheory/DisplayedCats/TotalAdjunction.v)
   - [categories/Dialgebras.v](CategoryTheory/categories/Dialgebras.v)
   - [categories/CatIsoInserter.v](CategoryTheory/categories/CatIsoInserter.v)
   - [categories/EilenbergMoore.v](CategoryTheory/categories/EilenbergMoore.v)
   - [categories/KleisliCategory.v](CategoryTheory/categories/KleisliCategory.v)
   - [limits/Examples/EilenbergMooreLimits.v](CategoryTheory/limits/Examples/EilenbergMooreLimits.v)
   - [Elements.v](CategoryTheory/Elements.v)
   - [Core.v](CategoryTheory/Core.v)
   - [categories/Universal_Algebra/Algebras.v](CategoryTheory/categories/Universal_Algebra/Algebras.v)
   - [categories/Universal_Algebra/EqAlgebras.v](CategoryTheory/categories/Universal_Algebra/EqAlgebras.v)
   - [categories/Relations.v](CategoryTheory/categories/Relations.v)
   - [Monoidal/WhiskeredBifunctors.v](CategoryTheory/Monoidal/WhiskeredBifunctors.v)
   - [Monoidal/Categories.v](CategoryTheory/Monoidal/Categories.v)
   - [Monoidal/StrongMonad.v](CategoryTheory/Monoidal/StrongMonad.v)
   - [Monoidal/Structure/Symmetric.v](CategoryTheory/Monoidal/Structure/Symmetric.v)
   - [Monoidal/Structure/Closed.v](CategoryTheory/Monoidal/Structure/Closed.v)
   - [Monoidal/Structure/Cartesian.v](CategoryTheory/Monoidal/Structure/Cartesian.v)
   - [Monoidal/Functors.v](CategoryTheory/Monoidal/Functors.v)
   - [Monoidal/CategoriesOfMonoids.v](CategoryTheory/Monoidal/CategoriesOfMonoids.v)
   - [Monoidal/Displayed/WhiskeredDisplayedBifunctors.v](CategoryTheory/Monoidal/Displayed/WhiskeredDisplayedBifunctors.v)
   - [Monoidal/Displayed/Monoidal.v](CategoryTheory/Monoidal/Displayed/Monoidal.v)
   - [Monoidal/Displayed/TotalMonoidal.v](CategoryTheory/Monoidal/Displayed/TotalMonoidal.v)
   - [Monoidal/Displayed/MonoidalSections.v](CategoryTheory/Monoidal/Displayed/MonoidalSections.v)
   - [Monoidal/Examples/SetCartesianMonoidal.v](CategoryTheory/Monoidal/Examples/SetCartesianMonoidal.v)
   - [Monoidal/Examples/CartesianMonoidal.v](CategoryTheory/Monoidal/Examples/CartesianMonoidal.v)
   - [Monoidal/Examples/DisplayedCartesianMonoidal.v](CategoryTheory/Monoidal/Examples/DisplayedCartesianMonoidal.v)
   - [Monoidal/Examples/PosetsMonoidal.v](CategoryTheory/Monoidal/Examples/PosetsMonoidal.v)
   - [Monoidal/Examples/StructuresMonoidal.v](CategoryTheory/Monoidal/Examples/StructuresMonoidal.v)
   - [Monoidal/Examples/EndofunctorsMonoidalElementary.v](CategoryTheory/Monoidal/Examples/EndofunctorsMonoidalElementary.v)
   - [Monoidal/Examples/MonadsAsMonoidsElementary.v](CategoryTheory/Monoidal/Examples/MonadsAsMonoidsElementary.v)
   - [Monoidal/Examples/MonoidalPointedObjects.v](CategoryTheory/Monoidal/Examples/MonoidalPointedObjects.v)
   - [Monoidal/Examples/MonoidalDialgebras.v](CategoryTheory/Monoidal/Examples/MonoidalDialgebras.v)
   - [Monoidal/Examples/PointedSetCartesianMonoidal.v](CategoryTheory/Monoidal/Examples/PointedSetCartesianMonoidal.v)
   - [Monoidal/Examples/BinopCartesianMonoidal.v](CategoryTheory/Monoidal/Examples/BinopCartesianMonoidal.v)
   - [Monoidal/Examples/SetWithSubset.v](CategoryTheory/Monoidal/Examples/SetWithSubset.v)
   - [Monoidal/Examples/SmashProductMonoidal.v](CategoryTheory/Monoidal/Examples/SmashProductMonoidal.v)
   - [Monoidal/AlternativeDefinitions/MonoidalCategoriesReordered.v](CategoryTheory/Monoidal/AlternativeDefinitions/MonoidalCategoriesReordered.v)
   - [Monoidal/AlternativeDefinitions/MonoidalCategoriesTensored.v](CategoryTheory/Monoidal/AlternativeDefinitions/MonoidalCategoriesTensored.v)
   - [Monoidal/AlternativeDefinitions/EquivalenceWhiskeredNonCurriedMonoidalCategories.v](CategoryTheory/Monoidal/AlternativeDefinitions/EquivalenceWhiskeredNonCurriedMonoidalCategories.v)
   - [Monoidal/AlternativeDefinitions/MonoidalCategoriesCurried.v](CategoryTheory/Monoidal/AlternativeDefinitions/MonoidalCategoriesCurried.v)
   - [Monoidal/AlternativeDefinitions/MonoidalFunctorsTensored.v](CategoryTheory/Monoidal/AlternativeDefinitions/MonoidalFunctorsTensored.v)
   - [Monoidal/AlternativeDefinitions/MonoidalFunctorsCurried.v](CategoryTheory/Monoidal/AlternativeDefinitions/MonoidalFunctorsCurried.v)
   - [Monoidal/AlternativeDefinitions/AugmentedSimplexCategory.v](CategoryTheory/Monoidal/AlternativeDefinitions/AugmentedSimplexCategory.v)
   - [Monoidal/AlternativeDefinitions/DisplayedMonoidalTensored.v](CategoryTheory/Monoidal/AlternativeDefinitions/DisplayedMonoidalTensored.v)
   - [Monoidal/AlternativeDefinitions/DisplayedMonoidalCurried.v](CategoryTheory/Monoidal/AlternativeDefinitions/DisplayedMonoidalCurried.v)
   - [Monoidal/AlternativeDefinitions/CategoriesOfMonoids.v](CategoryTheory/Monoidal/AlternativeDefinitions/CategoriesOfMonoids.v)
   - [Monoidal/AlternativeDefinitions/BraidedMonoidalCategories.v](CategoryTheory/Monoidal/AlternativeDefinitions/BraidedMonoidalCategories.v)
   - [Monoidal/AlternativeDefinitions/TotalDisplayedMonoidalCurried.v](CategoryTheory/Monoidal/AlternativeDefinitions/TotalDisplayedMonoidalCurried.v)
   - [Monoidal/AlternativeDefinitions/MonoidalFunctorCategory.v](CategoryTheory/Monoidal/AlternativeDefinitions/MonoidalFunctorCategory.v)
   - [Actegories/Actegories.v](CategoryTheory/Actegories/Actegories.v)
   - [Actegories/ConstructionOfActegories.v](CategoryTheory/Actegories/ConstructionOfActegories.v)
   - [Actegories/MorphismsOfActegories.v](CategoryTheory/Actegories/MorphismsOfActegories.v)
   - [Actegories/ProductActegory.v](CategoryTheory/Actegories/ProductActegory.v)
   - [Actegories/ProductsInActegories.v](CategoryTheory/Actegories/ProductsInActegories.v)
   - [Actegories/CoproductsInActegories.v](CategoryTheory/Actegories/CoproductsInActegories.v)
   - [Actegories/Examples/ActionOfEndomorphismsInCATElementary.v](CategoryTheory/Actegories/Examples/ActionOfEndomorphismsInCATElementary.v)
   - [Actegories/Examples/SelfActionInCATElementary.v](CategoryTheory/Actegories/Examples/SelfActionInCATElementary.v)
   - [Actegories/ConstructionOfActegoryMorphisms.v](CategoryTheory/Actegories/ConstructionOfActegoryMorphisms.v)
   - [Actegories/ActionBasedStrongMonads.v](CategoryTheory/Actegories/ActionBasedStrongMonads.v)
   - [DisplayedCats/MoreFibrations/Prefibrations.v](CategoryTheory/DisplayedCats/MoreFibrations/Prefibrations.v)
   - [DisplayedCats/MoreFibrations/CartesiannessOfComposites.v](CategoryTheory/DisplayedCats/MoreFibrations/CartesiannessOfComposites.v)
   - [DisplayedCats/MoreFibrations/FibrationsCharacterisation.v](CategoryTheory/DisplayedCats/MoreFibrations/FibrationsCharacterisation.v)
   - [DisplayedCats/MoreFibrations/DispCatsEquivFunctors.v](CategoryTheory/DisplayedCats/MoreFibrations/DispCatsEquivFunctors.v)
   - [DisplayedCats/MoreFibrations/DisplayedDisplayedCats.v](CategoryTheory/DisplayedCats/MoreFibrations/DisplayedDisplayedCats.v)
   - [SkewMonoidal/SkewMonoidalCategories.v](CategoryTheory/SkewMonoidal/SkewMonoidalCategories.v)
   - [SkewMonoidal/CategoriesOfMonoids.v](CategoryTheory/SkewMonoidal/CategoriesOfMonoids.v)
   - [EnrichedCats/Enrichment.v](CategoryTheory/EnrichedCats/Enrichment.v)
   - [EnrichedCats/EnrichmentFunctor.v](CategoryTheory/EnrichedCats/EnrichmentFunctor.v)
   - [EnrichedCats/EnrichmentTransformation.v](CategoryTheory/EnrichedCats/EnrichmentTransformation.v)
   - [EnrichedCats/EnrichmentMonad.v](CategoryTheory/EnrichedCats/EnrichmentMonad.v)
   - [EnrichedCats/Enriched/Enriched.v](CategoryTheory/EnrichedCats/Enriched/Enriched.v)
   - [EnrichedCats/Enriched/ChangeOfBase.v](CategoryTheory/EnrichedCats/Enriched/ChangeOfBase.v)
   - [EnrichedCats/Enriched/Opposite.v](CategoryTheory/EnrichedCats/Enriched/Opposite.v)
   - [EnrichedCats/Enriched/UnderlyingCategory.v](CategoryTheory/EnrichedCats/Enriched/UnderlyingCategory.v)
   - [EnrichedCats/Enriched/EnrichmentEquiv.v](CategoryTheory/EnrichedCats/Enriched/EnrichmentEquiv.v)
   - [EnrichedCats/Examples/SelfEnriched.v](CategoryTheory/EnrichedCats/Examples/SelfEnriched.v)
   - [EnrichedCats/Limits/EnrichedTerminal.v](CategoryTheory/EnrichedCats/Limits/EnrichedTerminal.v)
   - [EnrichedCats/Limits/EnrichedBinaryProducts.v](CategoryTheory/EnrichedCats/Limits/EnrichedBinaryProducts.v)
   - [EnrichedCats/Limits/EnrichedProducts.v](CategoryTheory/EnrichedCats/Limits/EnrichedProducts.v)
   - [EnrichedCats/Limits/EnrichedEqualizers.v](CategoryTheory/EnrichedCats/Limits/EnrichedEqualizers.v)
   - [EnrichedCats/Limits/EnrichedConicalLimits.v](CategoryTheory/EnrichedCats/Limits/EnrichedConicalLimits.v)
   - [EnrichedCats/Limits/EnrichedPowers.v](CategoryTheory/EnrichedCats/Limits/EnrichedPowers.v)
   - [EnrichedCats/Limits/EnrichedLimits.v](CategoryTheory/EnrichedCats/Limits/EnrichedLimits.v)
   - [EnrichedCats/Colimits/EnrichedInitial.v](CategoryTheory/EnrichedCats/Colimits/EnrichedInitial.v)
   - [EnrichedCats/Colimits/EnrichedBinaryCoproducts.v](CategoryTheory/EnrichedCats/Colimits/EnrichedBinaryCoproducts.v)
   - [EnrichedCats/Colimits/EnrichedCoproducts.v](CategoryTheory/EnrichedCats/Colimits/EnrichedCoproducts.v)
   - [EnrichedCats/Colimits/EnrichedCoequalizers.v](CategoryTheory/EnrichedCats/Colimits/EnrichedCoequalizers.v)
   - [EnrichedCats/Colimits/EnrichedConicalColimits.v](CategoryTheory/EnrichedCats/Colimits/EnrichedConicalColimits.v)
   - [EnrichedCats/Colimits/EnrichedCopowers.v](CategoryTheory/EnrichedCats/Colimits/EnrichedCopowers.v)
   - [EnrichedCats/Colimits/EnrichedColimits.v](CategoryTheory/EnrichedCats/Colimits/EnrichedColimits.v)
   - [EnrichedCats/Examples/SetEnriched.v](CategoryTheory/EnrichedCats/Examples/SetEnriched.v)
   - [EnrichedCats/Examples/PosetEnriched.v](CategoryTheory/EnrichedCats/Examples/PosetEnriched.v)
   - [EnrichedCats/Examples/StructureEnriched.v](CategoryTheory/EnrichedCats/Examples/StructureEnriched.v)
   - [EnrichedCats/Examples/HomFunctor.v](CategoryTheory/EnrichedCats/Examples/HomFunctor.v)
   - [EnrichedCats/Examples/FunctorCategory.v](CategoryTheory/EnrichedCats/Examples/FunctorCategory.v)
   - [EnrichedCats/Examples/OppositeEnriched.v](CategoryTheory/EnrichedCats/Examples/OppositeEnriched.v)
   - [EnrichedCats/Examples/EmptyEnriched.v](CategoryTheory/EnrichedCats/Examples/EmptyEnriched.v)
   - [EnrichedCats/Examples/UnitEnriched.v](CategoryTheory/EnrichedCats/Examples/UnitEnriched.v)
   - [EnrichedCats/Examples/FullSubEnriched.v](CategoryTheory/EnrichedCats/Examples/FullSubEnriched.v)
   - [EnrichedCats/Examples/ImageEnriched.v](CategoryTheory/EnrichedCats/Examples/ImageEnriched.v)
   - [EnrichedCats/Examples/DialgebraEnriched.v](CategoryTheory/EnrichedCats/Examples/DialgebraEnriched.v)
   - [EnrichedCats/Examples/SliceEnriched.v](CategoryTheory/EnrichedCats/Examples/SliceEnriched.v)
   - [EnrichedCats/Examples/EilenbergMooreEnriched.v](CategoryTheory/EnrichedCats/Examples/EilenbergMooreEnriched.v)
   - [EnrichedCats/Examples/ProductEnriched.v](CategoryTheory/EnrichedCats/Examples/ProductEnriched.v)
   - [EnrichedCats/Examples/ChangeOfBase.v](CategoryTheory/EnrichedCats/Examples/ChangeOfBase.v)
   - [EnrichedCats/Examples/KleisliEnriched.v](CategoryTheory/EnrichedCats/Examples/KleisliEnriched.v)
   - [EnrichedCats/Examples/UnivalentKleisliEnriched.v](CategoryTheory/EnrichedCats/Examples/UnivalentKleisliEnriched.v)
   - [EnrichedCats/Limits/Examples/OppositeEnrichedLimits.v](CategoryTheory/EnrichedCats/Limits/Examples/OppositeEnrichedLimits.v)
   - [EnrichedCats/Limits/Examples/PosetEnrichedLimits.v](CategoryTheory/EnrichedCats/Limits/Examples/PosetEnrichedLimits.v)
   - [EnrichedCats/Limits/Examples/StructureEnrichedLimits.v](CategoryTheory/EnrichedCats/Limits/Examples/StructureEnrichedLimits.v)
   - [EnrichedCats/Limits/Examples/SelfEnrichedLimits.v](CategoryTheory/EnrichedCats/Limits/Examples/SelfEnrichedLimits.v)
   - [EnrichedCats/Colimits/Examples/OppositeEnrichedColimits.v](CategoryTheory/EnrichedCats/Colimits/Examples/OppositeEnrichedColimits.v)
   - [EnrichedCats/Colimits/Examples/PosetEnrichedColimits.v](CategoryTheory/EnrichedCats/Colimits/Examples/PosetEnrichedColimits.v)
   - [EnrichedCats/Colimits/Examples/StructureEnrichedColimits.v](CategoryTheory/EnrichedCats/Colimits/Examples/StructureEnrichedColimits.v)
   - [EnrichedCats/Colimits/Examples/SelfEnrichedColimits.v](CategoryTheory/EnrichedCats/Colimits/Examples/SelfEnrichedColimits.v)
   - [GrothendieckConstruction/TotalCategory.v](CategoryTheory/GrothendieckConstruction/TotalCategory.v)
   - [GrothendieckConstruction/IsosInTotal.v](CategoryTheory/GrothendieckConstruction/IsosInTotal.v)
   - [GrothendieckConstruction/Projection.v](CategoryTheory/GrothendieckConstruction/Projection.v)
   - [GrothendieckConstruction/IsOpfibration.v](CategoryTheory/GrothendieckConstruction/IsOpfibration.v)
   - [GrothendieckConstruction/IsPullback.v](CategoryTheory/GrothendieckConstruction/IsPullback.v)
   - [TwoSidedDisplayedCats/TwoSidedDispCat.v](CategoryTheory/TwoSidedDisplayedCats/TwoSidedDispCat.v)
   - [TwoSidedDisplayedCats/Isos.v](CategoryTheory/TwoSidedDisplayedCats/Isos.v)
   - [TwoSidedDisplayedCats/Univalence.v](CategoryTheory/TwoSidedDisplayedCats/Univalence.v)
   - [TwoSidedDisplayedCats/Discrete.v](CategoryTheory/TwoSidedDisplayedCats/Discrete.v)
   - [TwoSidedDisplayedCats/Total.v](CategoryTheory/TwoSidedDisplayedCats/Total.v)
   - [TwoSidedDisplayedCats/TwoSidedFibration.v](CategoryTheory/TwoSidedDisplayedCats/TwoSidedFibration.v)
   - [TwoSidedDisplayedCats/Fiber.v](CategoryTheory/TwoSidedDisplayedCats/Fiber.v)
   - [TwoSidedDisplayedCats/DisplayedFunctor.v](CategoryTheory/TwoSidedDisplayedCats/DisplayedFunctor.v)
   - [TwoSidedDisplayedCats/DisplayedNatTrans.v](CategoryTheory/TwoSidedDisplayedCats/DisplayedNatTrans.v)
   - [TwoSidedDisplayedCats/Examples/Constant.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Constant.v)
   - [TwoSidedDisplayedCats/Examples/DispCatOnTwoSidedDispCat.v](CategoryTheory/TwoSidedDisplayedCats/Examples/DispCatOnTwoSidedDispCat.v)
   - [TwoSidedDisplayedCats/Examples/FiberwiseProduct.v](CategoryTheory/TwoSidedDisplayedCats/Examples/FiberwiseProduct.v)
   - [TwoSidedDisplayedCats/Examples/Arrow.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Arrow.v)
   - [TwoSidedDisplayedCats/Examples/Bimodules.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Bimodules.v)
   - [TwoSidedDisplayedCats/Examples/Comma.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Comma.v)
   - [TwoSidedDisplayedCats/Examples/IsoComma.v](CategoryTheory/TwoSidedDisplayedCats/Examples/IsoComma.v)
   - [TwoSidedDisplayedCats/Examples/Lenses.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Lenses.v)
   - [TwoSidedDisplayedCats/Examples/Product.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Product.v)
   - [TwoSidedDisplayedCats/Examples/Profunctor.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Profunctor.v)
   - [TwoSidedDisplayedCats/Examples/Reindex.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Reindex.v)
   - [TwoSidedDisplayedCats/Examples/Relations.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Relations.v)
   - [TwoSidedDisplayedCats/Examples/Spans.v](CategoryTheory/TwoSidedDisplayedCats/Examples/Spans.v)
   - [RepresentableFunctors/Precategories.v](CategoryTheory/RepresentableFunctors/Precategories.v)
   - [RepresentableFunctors/Bifunctor.v](CategoryTheory/RepresentableFunctors/Bifunctor.v)
   - [RepresentableFunctors/Representation.v](CategoryTheory/RepresentableFunctors/Representation.v)
   - [RepresentableFunctors/RawMatrix.v](CategoryTheory/RepresentableFunctors/RawMatrix.v)
   - [RepresentableFunctors/DirectSum.v](CategoryTheory/RepresentableFunctors/DirectSum.v)
   - [RepresentableFunctors/Test.v](CategoryTheory/RepresentableFunctors/Test.v)
   - [Monoidal/RezkCompletion/LiftedTensor.v](CategoryTheory/Monoidal/RezkCompletion/LiftedTensor.v)
   - [Monoidal/RezkCompletion/LiftedTensorUnit.v](CategoryTheory/Monoidal/RezkCompletion/LiftedTensorUnit.v)
   - [Monoidal/RezkCompletion/LiftedUnitors.v](CategoryTheory/Monoidal/RezkCompletion/LiftedUnitors.v)
   - [Monoidal/RezkCompletion/LiftedAssociator.v](CategoryTheory/Monoidal/RezkCompletion/LiftedAssociator.v)
   - [Monoidal/RezkCompletion/LiftedMonoidal.v](CategoryTheory/Monoidal/RezkCompletion/LiftedMonoidal.v)
   - [Monoidal/RezkCompletion/MonoidalRezkCompletion.v](CategoryTheory/Monoidal/RezkCompletion/MonoidalRezkCompletion.v)
   - [DaggerCategories/Categories.v](CategoryTheory/DaggerCategories/Categories.v)
   - [DaggerCategories/Unitary.v](CategoryTheory/DaggerCategories/Unitary.v)
   - [DaggerCategories/Univalence.v](CategoryTheory/DaggerCategories/Univalence.v)
   - [DaggerCategories/Functors.v](CategoryTheory/DaggerCategories/Functors.v)
   - [DaggerCategories/Transformations.v](CategoryTheory/DaggerCategories/Transformations.v)
   - [DaggerCategories/FunctorCategory.v](CategoryTheory/DaggerCategories/FunctorCategory.v)
   - [DaggerCategories/Examples/Groupoids.v](CategoryTheory/DaggerCategories/Examples/Groupoids.v)
   - [DaggerCategories/Examples/Relations.v](CategoryTheory/DaggerCategories/Examples/Relations.v)
   - [DaggerCategories/Examples/Fullsub.v](CategoryTheory/DaggerCategories/Examples/Fullsub.v)
   - [DaggerCategories/Functors/WeakEquivalences.v](CategoryTheory/DaggerCategories/Functors/WeakEquivalences.v)
   - [DaggerCategories/Functors/FullyFaithful.v](CategoryTheory/DaggerCategories/Functors/FullyFaithful.v)
   - [DaggerCategories/Functors/Factorization.v](CategoryTheory/DaggerCategories/Functors/Factorization.v)
   - [DaggerCategories/Functors/Precomp.v](CategoryTheory/DaggerCategories/Functors/Precomp.v)
   - [DaggerCategories/CatIso.v](CategoryTheory/DaggerCategories/CatIso.v)
   - [All.v](CategoryTheory/All.v)
## Package [Bicategories](Bicategories/README.md)
   - [Core/Bicat.v](Bicategories/Core/Bicat.v)
   - [Core/Invertible_2cells.v](Bicategories/Core/Invertible_2cells.v)
   - [Morphisms/Adjunctions.v](Bicategories/Morphisms/Adjunctions.v)
   - [Morphisms/FullyFaithful.v](Bicategories/Morphisms/FullyFaithful.v)
   - [Morphisms/DiscreteMorphisms.v](Bicategories/Morphisms/DiscreteMorphisms.v)
   - [Core/Examples/OpMorBicat.v](Bicategories/Core/Examples/OpMorBicat.v)
   - [Morphisms/Examples/MorphismsInOp1Bicat.v](Bicategories/Morphisms/Examples/MorphismsInOp1Bicat.v)
   - [Core/Examples/OpCellBicat.v](Bicategories/Core/Examples/OpCellBicat.v)
   - [Core/Unitors.v](Bicategories/Core/Unitors.v)
   - [Core/BicategoryLaws.v](Bicategories/Core/BicategoryLaws.v)
   - [Core/Univalence.v](Bicategories/Core/Univalence.v)
   - [Core/TransportLaws.v](Bicategories/Core/TransportLaws.v)
   - [Core/EquivToAdjequiv.v](Bicategories/Core/EquivToAdjequiv.v)
   - [Core/AdjointUnique.v](Bicategories/Core/AdjointUnique.v)
   - [Core/UnivalenceOp.v](Bicategories/Core/UnivalenceOp.v)
   - [Core/Discreteness.v](Bicategories/Core/Discreteness.v)
   - [Morphisms/InternalStreetFibration.v](Bicategories/Morphisms/InternalStreetFibration.v)
   - [Morphisms/InternalStreetOpFibration.v](Bicategories/Morphisms/InternalStreetOpFibration.v)
   - [Morphisms/Properties/ContainsAdjEquiv.v](Bicategories/Morphisms/Properties/ContainsAdjEquiv.v)
   - [Morphisms/Properties/Composition.v](Bicategories/Morphisms/Properties/Composition.v)
   - [Morphisms/Properties/ClosedUnderInvertibles.v](Bicategories/Morphisms/Properties/ClosedUnderInvertibles.v)
   - [Morphisms/Properties.v](Bicategories/Morphisms/Properties.v)
   - [Core/Examples/OneTypes.v](Bicategories/Core/Examples/OneTypes.v)
   - [Core/Examples/PointedOneTypesBicat.v](Bicategories/Core/Examples/PointedOneTypesBicat.v)
   - [Core/Examples/TwoType.v](Bicategories/Core/Examples/TwoType.v)
   - [Core/Examples/BicatOfUnivCats.v](Bicategories/Core/Examples/BicatOfUnivCats.v)
   - [Core/Examples/BicatOfCats.v](Bicategories/Core/Examples/BicatOfCats.v)
   - [Core/Strictness.v](Bicategories/Core/Strictness.v)
   - [Core/Examples/StrictCats.v](Bicategories/Core/Examples/StrictCats.v)
   - [Core/Examples/Initial.v](Bicategories/Core/Examples/Initial.v)
   - [Core/Examples/Final.v](Bicategories/Core/Examples/Final.v)
   - [Core/Examples/BicategoryFromMonoidal.v](Bicategories/Core/Examples/BicategoryFromMonoidal.v)
   - [Core/Examples/BicategoryFromWhiskeredMonoidal.v](Bicategories/Core/Examples/BicategoryFromWhiskeredMonoidal.v)
   - [Core/Examples/FibSlice.v](Bicategories/Core/Examples/FibSlice.v)
   - [Morphisms/Properties/AdjunctionsRepresentable.v](Bicategories/Morphisms/Properties/AdjunctionsRepresentable.v)
   - [Morphisms/Examples/MorphismsInBicatOfUnivCats.v](Bicategories/Morphisms/Examples/MorphismsInBicatOfUnivCats.v)
   - [Morphisms/Examples/FibrationsInBicatOfUnivCats.v](Bicategories/Morphisms/Examples/FibrationsInBicatOfUnivCats.v)
   - [Morphisms/Examples/FibrationsInStrictCats.v](Bicategories/Morphisms/Examples/FibrationsInStrictCats.v)
   - [Morphisms/Examples/MorphismsInOp2Bicat.v](Bicategories/Morphisms/Examples/MorphismsInOp2Bicat.v)
   - [DisplayedBicats/DispBicat.v](Bicategories/DisplayedBicats/DispBicat.v)
   - [DisplayedBicats/DispInvertibles.v](Bicategories/DisplayedBicats/DispInvertibles.v)
   - [DisplayedBicats/DispAdjunctions.v](Bicategories/DisplayedBicats/DispAdjunctions.v)
   - [DisplayedBicats/DispUnivalence.v](Bicategories/DisplayedBicats/DispUnivalence.v)
   - [DisplayedBicats/CleavingOfBicat.v](Bicategories/DisplayedBicats/CleavingOfBicat.v)
   - [DisplayedBicats/FiberCategory.v](Bicategories/DisplayedBicats/FiberCategory.v)
   - [DisplayedBicats/FiberBicategory/FiberBicategory1.v](Bicategories/DisplayedBicats/FiberBicategory/FiberBicategory1.v)
   - [DisplayedBicats/FiberBicategory/FiberBicategory2.v](Bicategories/DisplayedBicats/FiberBicategory/FiberBicategory2.v)
   - [DisplayedBicats/FiberBicategory.v](Bicategories/DisplayedBicats/FiberBicategory.v)
   - [DisplayedBicats/Examples/Sigma.v](Bicategories/DisplayedBicats/Examples/Sigma.v)
   - [DisplayedBicats/Examples/DisplayedCatToBicat.v](Bicategories/DisplayedBicats/Examples/DisplayedCatToBicat.v)
   - [DisplayedBicats/Examples/FullSub.v](Bicategories/DisplayedBicats/Examples/FullSub.v)
   - [DisplayedBicats/Examples/DispBicatOfDispCats.v](Bicategories/DisplayedBicats/Examples/DispBicatOfDispCats.v)
   - [DisplayedBicats/Examples/Slice.v](Bicategories/DisplayedBicats/Examples/Slice.v)
   - [DisplayedBicats/Examples/Sub1Cell.v](Bicategories/DisplayedBicats/Examples/Sub1Cell.v)
   - [DisplayedBicats/Examples/Prod.v](Bicategories/DisplayedBicats/Examples/Prod.v)
   - [DisplayedBicats/Examples/DispDepProd.v](Bicategories/DisplayedBicats/Examples/DispDepProd.v)
   - [DisplayedBicats/Examples/Trivial.v](Bicategories/DisplayedBicats/Examples/Trivial.v)
   - [DisplayedBicats/Examples/BicatOfInvertibles.v](Bicategories/DisplayedBicats/Examples/BicatOfInvertibles.v)
   - [DisplayedBicats/Examples/EndoMap.v](Bicategories/DisplayedBicats/Examples/EndoMap.v)
   - [Core/Examples/StructuredCategories.v](Bicategories/Core/Examples/StructuredCategories.v)
   - [MonoidalCategories/MonoidalFromBicategory.v](Bicategories/MonoidalCategories/MonoidalFromBicategory.v)
   - [MonoidalCategories/EndofunctorsMonoidal.v](Bicategories/MonoidalCategories/EndofunctorsMonoidal.v)
   - [MonoidalCategories/PointedFunctorsMonoidal.v](Bicategories/MonoidalCategories/PointedFunctorsMonoidal.v)
   - [MonoidalCategories/Actions.v](Bicategories/MonoidalCategories/Actions.v)
   - [MonoidalCategories/ConstructionOfActions.v](Bicategories/MonoidalCategories/ConstructionOfActions.v)
   - [MonoidalCategories/WhiskeredMonoidalFromBicategory.v](Bicategories/MonoidalCategories/WhiskeredMonoidalFromBicategory.v)
   - [MonoidalCategories/ActionOfEndomorphismsInBicatWhiskered.v](Bicategories/MonoidalCategories/ActionOfEndomorphismsInBicatWhiskered.v)
   - [MonoidalCategories/BicatOfWhiskeredMonCats.v](Bicategories/MonoidalCategories/BicatOfWhiskeredMonCats.v)
   - [MonoidalCategories/EndofunctorsWhiskeredMonoidal.v](Bicategories/MonoidalCategories/EndofunctorsWhiskeredMonoidal.v)
   - [MonoidalCategories/PointedFunctorsWhiskeredMonoidal.v](Bicategories/MonoidalCategories/PointedFunctorsWhiskeredMonoidal.v)
   - [MonoidalCategories/IdempotencePointedFunctorsWhiskeredMonoidal.v](Bicategories/MonoidalCategories/IdempotencePointedFunctorsWhiskeredMonoidal.v)
   - [MonoidalCategories/ActionBasedStrength.v](Bicategories/MonoidalCategories/ActionBasedStrength.v)
   - [MonoidalCategories/ActionBasedStrongFunctorsMonoidal.v](Bicategories/MonoidalCategories/ActionBasedStrongFunctorsMonoidal.v)
   - [MonoidalCategories/ActionOfEndomorphismsInBicat.v](Bicategories/MonoidalCategories/ActionOfEndomorphismsInBicat.v)
   - [MonoidalCategories/ActionBasedStrongFunctorCategory.v](Bicategories/MonoidalCategories/ActionBasedStrongFunctorCategory.v)
   - [MonoidalCategories/ActionsFormBicategory.v](Bicategories/MonoidalCategories/ActionsFormBicategory.v)
   - [MonoidalCategories/ActionBasedStrongFunctorsWhiskeredMonoidal.v](Bicategories/MonoidalCategories/ActionBasedStrongFunctorsWhiskeredMonoidal.v)
   - [MonoidalCategories/BicatOfActegories.v](Bicategories/MonoidalCategories/BicatOfActegories.v)
   - [MonoidalCategories/BicatOfActionsInBicat.v](Bicategories/MonoidalCategories/BicatOfActionsInBicat.v)
   - [MonoidalCategories/UnivalenceMonCat/CurriedMonoidalCategories.v](Bicategories/MonoidalCategories/UnivalenceMonCat/CurriedMonoidalCategories.v)
   - [MonoidalCategories/UnivalenceMonCat/EquivalenceWhiskeredCurried.v](Bicategories/MonoidalCategories/UnivalenceMonCat/EquivalenceWhiskeredCurried.v)
   - [MonoidalCategories/UnivalenceMonCat/UnitLayer.v](Bicategories/MonoidalCategories/UnivalenceMonCat/UnitLayer.v)
   - [MonoidalCategories/UnivalenceMonCat/TensorLayer.v](Bicategories/MonoidalCategories/UnivalenceMonCat/TensorLayer.v)
   - [MonoidalCategories/UnivalenceMonCat/TensorUnitLayer.v](Bicategories/MonoidalCategories/UnivalenceMonCat/TensorUnitLayer.v)
   - [MonoidalCategories/UnivalenceMonCat/AssociatorUnitorsLayer.v](Bicategories/MonoidalCategories/UnivalenceMonCat/AssociatorUnitorsLayer.v)
   - [MonoidalCategories/UnivalenceMonCat/FinalLayer.v](Bicategories/MonoidalCategories/UnivalenceMonCat/FinalLayer.v)
   - [MonoidalCategories/UnivalenceMonCat/EquivalenceMonCatCurried.v](Bicategories/MonoidalCategories/UnivalenceMonCat/EquivalenceMonCatCurried.v)
   - [MonoidalCategories/UnivalenceMonCat/EquivalenceMonCatNonCurried.v](Bicategories/MonoidalCategories/UnivalenceMonCat/EquivalenceMonCatNonCurried.v)
   - [Core/Examples/Groupoids.v](Bicategories/Core/Examples/Groupoids.v)
   - [PseudoFunctors/Display/Base.v](Bicategories/PseudoFunctors/Display/Base.v)
   - [PseudoFunctors/Display/Map1Cells.v](Bicategories/PseudoFunctors/Display/Map1Cells.v)
   - [PseudoFunctors/Display/Map2Cells.v](Bicategories/PseudoFunctors/Display/Map2Cells.v)
   - [PseudoFunctors/Display/Identitor.v](Bicategories/PseudoFunctors/Display/Identitor.v)
   - [PseudoFunctors/Display/Compositor.v](Bicategories/PseudoFunctors/Display/Compositor.v)
   - [PseudoFunctors/Display/PseudoFunctorBicat.v](Bicategories/PseudoFunctors/Display/PseudoFunctorBicat.v)
   - [PseudoFunctors/Display/StrictIdentitor.v](Bicategories/PseudoFunctors/Display/StrictIdentitor.v)
   - [PseudoFunctors/Display/StrictCompositor.v](Bicategories/PseudoFunctors/Display/StrictCompositor.v)
   - [PseudoFunctors/Display/StrictPseudoFunctorBicat.v](Bicategories/PseudoFunctors/Display/StrictPseudoFunctorBicat.v)
   - [PseudoFunctors/PseudoFunctor.v](Bicategories/PseudoFunctors/PseudoFunctor.v)
   - [PseudoFunctors/StrictPseudoFunctor.v](Bicategories/PseudoFunctors/StrictPseudoFunctor.v)
   - [PseudoFunctors/Examples/Identity.v](Bicategories/PseudoFunctors/Examples/Identity.v)
   - [PseudoFunctors/Examples/Composition.v](Bicategories/PseudoFunctors/Examples/Composition.v)
   - [PseudoFunctors/Examples/Constant.v](Bicategories/PseudoFunctors/Examples/Constant.v)
   - [PseudoFunctors/Examples/ApFunctor.v](Bicategories/PseudoFunctors/Examples/ApFunctor.v)
   - [PseudoFunctors/Examples/OpFunctor.v](Bicategories/PseudoFunctors/Examples/OpFunctor.v)
   - [PseudoFunctors/Examples/PseudofunctorFromMonoidal.v](Bicategories/PseudoFunctors/Examples/PseudofunctorFromMonoidal.v)
   - [PseudoFunctors/Examples/Op2OfPseudoFunctor.v](Bicategories/PseudoFunctors/Examples/Op2OfPseudoFunctor.v)
   - [Transformations/PseudoTransformation.v](Bicategories/Transformations/PseudoTransformation.v)
   - [Transformations/Examples/Whiskering.v](Bicategories/Transformations/Examples/Whiskering.v)
   - [Transformations/Examples/Unitality.v](Bicategories/Transformations/Examples/Unitality.v)
   - [Transformations/Examples/Associativity.v](Bicategories/Transformations/Examples/Associativity.v)
   - [Transformations/Examples/ApTransformation.v](Bicategories/Transformations/Examples/ApTransformation.v)
   - [Modifications/Modification.v](Bicategories/Modifications/Modification.v)
   - [Modifications/Examples/ApModification.v](Bicategories/Modifications/Examples/ApModification.v)
   - [Modifications/Examples/Unitality.v](Bicategories/Modifications/Examples/Unitality.v)
   - [Modifications/Examples/Associativity.v](Bicategories/Modifications/Examples/Associativity.v)
   - [PseudoFunctors/Representable.v](Bicategories/PseudoFunctors/Representable.v)
   - [PseudoFunctors/Yoneda.v](Bicategories/PseudoFunctors/Yoneda.v)
   - [PseudoFunctors/Biequivalence.v](Bicategories/PseudoFunctors/Biequivalence.v)
   - [PseudoFunctors/Examples/StrictToPseudo.v](Bicategories/PseudoFunctors/Examples/StrictToPseudo.v)
   - [PseudoFunctors/Examples/Projection.v](Bicategories/PseudoFunctors/Examples/Projection.v)
   - [MonoidalCategories/EquivalenceActegoriesAndActions.v](Bicategories/MonoidalCategories/EquivalenceActegoriesAndActions.v)
   - [PseudoFunctors/Biadjunction.v](Bicategories/PseudoFunctors/Biadjunction.v)
   - [PseudoFunctors/UniversalArrow.v](Bicategories/PseudoFunctors/UniversalArrow.v)
   - [DisplayedBicats/DispBicatSection.v](Bicategories/DisplayedBicats/DispBicatSection.v)
   - [DisplayedBicats/Examples/PointedOneTypes.v](Bicategories/DisplayedBicats/Examples/PointedOneTypes.v)
   - [DisplayedBicats/Examples/DisplayedInserter.v](Bicategories/DisplayedBicats/Examples/DisplayedInserter.v)
   - [DisplayedBicats/Examples/Displayed2Inserter.v](Bicategories/DisplayedBicats/Examples/Displayed2Inserter.v)
   - [DisplayedBicats/Examples/Algebras.v](Bicategories/DisplayedBicats/Examples/Algebras.v)
   - [DisplayedBicats/Examples/Add2Cell.v](Bicategories/DisplayedBicats/Examples/Add2Cell.v)
   - [DisplayedBicats/Examples/ContravariantFunctor.v](Bicategories/DisplayedBicats/Examples/ContravariantFunctor.v)
   - [DisplayedBicats/Examples/Cofunctormap.v](Bicategories/DisplayedBicats/Examples/Cofunctormap.v)
   - [DisplayedBicats/Examples/CwF.v](Bicategories/DisplayedBicats/Examples/CwF.v)
   - [DisplayedBicats/Examples/LaxSlice.v](Bicategories/DisplayedBicats/Examples/LaxSlice.v)
   - [DisplayedBicats/Examples/FunctorsIntoCat.v](Bicategories/DisplayedBicats/Examples/FunctorsIntoCat.v)
   - [DisplayedBicats/Examples/Codomain.v](Bicategories/DisplayedBicats/Examples/Codomain.v)
   - [DisplayedBicats/DispPseudofunctor.v](Bicategories/DisplayedBicats/DispPseudofunctor.v)
   - [Transformations/Examples/AlgebraMap.v](Bicategories/Transformations/Examples/AlgebraMap.v)
   - [DisplayedBicats/Examples/Monads.v](Bicategories/DisplayedBicats/Examples/Monads.v)
   - [DisplayedBicats/Examples/KleisliTriple.v](Bicategories/DisplayedBicats/Examples/KleisliTriple.v)
   - [DisplayedBicats/Examples/EnrichedCats.v](Bicategories/DisplayedBicats/Examples/EnrichedCats.v)
   - [DisplayedBicats/DispTransformation.v](Bicategories/DisplayedBicats/DispTransformation.v)
   - [DisplayedBicats/DispModification.v](Bicategories/DisplayedBicats/DispModification.v)
   - [DisplayedBicats/DispBiequivalence.v](Bicategories/DisplayedBicats/DispBiequivalence.v)
   - [PseudoFunctors/Examples/ChangeOfBaseEnriched.v](Bicategories/PseudoFunctors/Examples/ChangeOfBaseEnriched.v)
   - [DisplayedBicats/Examples/MonadsLax.v](Bicategories/DisplayedBicats/Examples/MonadsLax.v)
   - [PseudoFunctors/Examples/MonadInclusion.v](Bicategories/PseudoFunctors/Examples/MonadInclusion.v)
   - [PseudoFunctors/Examples/OpFunctorEnriched.v](Bicategories/PseudoFunctors/Examples/OpFunctorEnriched.v)
   - [Monads/Examples/AdjunctionToMonad.v](Bicategories/Monads/Examples/AdjunctionToMonad.v)
   - [Monads/Examples/ToMonadInCat.v](Bicategories/Monads/Examples/ToMonadInCat.v)
   - [Monads/Examples/MonadsInBicatOfUnivCats.v](Bicategories/Monads/Examples/MonadsInBicatOfUnivCats.v)
   - [Monads/Examples/MonadsInBicatOfCats.v](Bicategories/Monads/Examples/MonadsInBicatOfCats.v)
   - [Monads/Examples/MonadsInOp1Bicat.v](Bicategories/Monads/Examples/MonadsInOp1Bicat.v)
   - [Monads/Examples/MonadsInOp2Bicat.v](Bicategories/Monads/Examples/MonadsInOp2Bicat.v)
   - [Monads/Examples/MonadsInTotalBicat.v](Bicategories/Monads/Examples/MonadsInTotalBicat.v)
   - [Monads/Examples/MonadsInBicatOfEnrichedCats.v](Bicategories/Monads/Examples/MonadsInBicatOfEnrichedCats.v)
   - [Monads/DistributiveLaws.v](Bicategories/Monads/DistributiveLaws.v)
   - [Monads/MixedDistributiveLaws.v](Bicategories/Monads/MixedDistributiveLaws.v)
   - [Monads/Examples/MonadsInMonads.v](Bicategories/Monads/Examples/MonadsInMonads.v)
   - [Monads/Examples/Composition.v](Bicategories/Monads/Examples/Composition.v)
   - [Monads/Examples/PsfunctorOnMonad.v](Bicategories/Monads/Examples/PsfunctorOnMonad.v)
   - [Core/Examples/Image.v](Bicategories/Core/Examples/Image.v)
   - [PseudoFunctors/Examples/CorestrictImage.v](Bicategories/PseudoFunctors/Examples/CorestrictImage.v)
   - [Core/YonedaLemma.v](Bicategories/Core/YonedaLemma.v)
   - [Limits/Final.v](Bicategories/Limits/Final.v)
   - [Limits/Products.v](Bicategories/Limits/Products.v)
   - [Limits/Pullbacks.v](Bicategories/Limits/Pullbacks.v)
   - [Limits/CommaObjects.v](Bicategories/Limits/CommaObjects.v)
   - [Limits/Inserters.v](Bicategories/Limits/Inserters.v)
   - [Limits/IsoInserters.v](Bicategories/Limits/IsoInserters.v)
   - [Limits/Equifiers.v](Bicategories/Limits/Equifiers.v)
   - [Limits/EilenbergMooreObjects.v](Bicategories/Limits/EilenbergMooreObjects.v)
   - [Limits/EilenbergMooreComonad.v](Bicategories/Limits/EilenbergMooreComonad.v)
   - [Monads/ConstructionOfAlgebras.v](Bicategories/Monads/ConstructionOfAlgebras.v)
   - [Monads/MonadToAdjunction.v](Bicategories/Monads/MonadToAdjunction.v)
   - [Limits/Examples/OneTypesLimits.v](Bicategories/Limits/Examples/OneTypesLimits.v)
   - [Limits/Examples/BicatOfCatsLimits.v](Bicategories/Limits/Examples/BicatOfCatsLimits.v)
   - [Limits/Examples/BicatOfUnivCatsLimits.v](Bicategories/Limits/Examples/BicatOfUnivCatsLimits.v)
   - [Limits/Examples/BicatOfEnrichedCatsLimits.v](Bicategories/Limits/Examples/BicatOfEnrichedCatsLimits.v)
   - [Limits/Examples/OpCellBicatLimits.v](Bicategories/Limits/Examples/OpCellBicatLimits.v)
   - [Limits/Examples/UnivGroupoidsLimits.v](Bicategories/Limits/Examples/UnivGroupoidsLimits.v)
   - [Limits/Examples/SliceBicategoryLimits.v](Bicategories/Limits/Examples/SliceBicategoryLimits.v)
   - [Limits/Examples/TotalBicategoryLimits.v](Bicategories/Limits/Examples/TotalBicategoryLimits.v)
   - [Limits/Examples/DispConstructionsLimits.v](Bicategories/Limits/Examples/DispConstructionsLimits.v)
   - [Limits/Examples/SubbicatLimits.v](Bicategories/Limits/Examples/SubbicatLimits.v)
   - [Limits/Examples/LimitsStructuredCategories.v](Bicategories/Limits/Examples/LimitsStructuredCategories.v)
   - [MonoidalCategories/BicatOfWhiskeredMonCatsFinalObject.v](Bicategories/MonoidalCategories/BicatOfWhiskeredMonCatsFinalObject.v)
   - [Morphisms/Monadic.v](Bicategories/Morphisms/Monadic.v)
   - [MonoidalCategories/MonoidalDialgebrasInserters.v](Bicategories/MonoidalCategories/MonoidalDialgebrasInserters.v)
   - [MonoidalCategories/BicatOfActegoriesFinalObject.v](Bicategories/MonoidalCategories/BicatOfActegoriesFinalObject.v)
   - [MonoidalCategories/MonadsAsMonoidsWhiskered.v](Bicategories/MonoidalCategories/MonadsAsMonoidsWhiskered.v)
   - [Monads/Examples/MonadsInStructuredCategories.v](Bicategories/Monads/Examples/MonadsInStructuredCategories.v)
   - [Limits/ProductEquivalences.v](Bicategories/Limits/ProductEquivalences.v)
   - [Limits/PullbackFunctions.v](Bicategories/Limits/PullbackFunctions.v)
   - [Limits/PullbackEquivalences.v](Bicategories/Limits/PullbackEquivalences.v)
   - [Limits/InserterEquivalences.v](Bicategories/Limits/InserterEquivalences.v)
   - [Limits/EquifierEquivalences.v](Bicategories/Limits/EquifierEquivalences.v)
   - [Morphisms/Eso.v](Bicategories/Morphisms/Eso.v)
   - [Morphisms/Properties/Projections.v](Bicategories/Morphisms/Properties/Projections.v)
   - [Morphisms/Properties/ClosedUnderPullback.v](Bicategories/Morphisms/Properties/ClosedUnderPullback.v)
   - [Morphisms/Properties/EsoProperties.v](Bicategories/Morphisms/Properties/EsoProperties.v)
   - [Morphisms/Examples/MorphismsInOneTypes.v](Bicategories/Morphisms/Examples/MorphismsInOneTypes.v)
   - [Morphisms/Examples/EsosInBicatOfUnivCats.v](Bicategories/Morphisms/Examples/EsosInBicatOfUnivCats.v)
   - [Morphisms/Examples/MorphismsInSliceBicat.v](Bicategories/Morphisms/Examples/MorphismsInSliceBicat.v)
   - [Morphisms/Examples/MorphismsInStructuredCat.v](Bicategories/Morphisms/Examples/MorphismsInStructuredCat.v)
   - [Morphisms/Examples/MorphismsInBicatOfEnrichedCats.v](Bicategories/Morphisms/Examples/MorphismsInBicatOfEnrichedCats.v)
   - [Colimits/Initial.v](Bicategories/Colimits/Initial.v)
   - [Colimits/Coproducts.v](Bicategories/Colimits/Coproducts.v)
   - [Colimits/Extensive.v](Bicategories/Colimits/Extensive.v)
   - [Colimits/KleisliObjects.v](Bicategories/Colimits/KleisliObjects.v)
   - [Limits/Examples/OpMorBicatLimits.v](Bicategories/Limits/Examples/OpMorBicatLimits.v)
   - [Colimits/Examples/OpCellBicatColimits.v](Bicategories/Colimits/Examples/OpCellBicatColimits.v)
   - [Colimits/Examples/OneTypesColimits.v](Bicategories/Colimits/Examples/OneTypesColimits.v)
   - [Colimits/Examples/BicatOfCatsColimits.v](Bicategories/Colimits/Examples/BicatOfCatsColimits.v)
   - [Colimits/Examples/BicatOfUnivCatsColimits.v](Bicategories/Colimits/Examples/BicatOfUnivCatsColimits.v)
   - [Colimits/Examples/SliceBicategoryColimits.v](Bicategories/Colimits/Examples/SliceBicategoryColimits.v)
   - [Colimits/CoproductEquivalences.v](Bicategories/Colimits/CoproductEquivalences.v)
   - [Morphisms/Properties/FromInitial.v](Bicategories/Morphisms/Properties/FromInitial.v)
   - [Objects/CartesianObject.v](Bicategories/Objects/CartesianObject.v)
   - [Objects/CocartesianObject.v](Bicategories/Objects/CocartesianObject.v)
   - [Objects/Examples/BicatOfUnivCatsObjects.v](Bicategories/Objects/Examples/BicatOfUnivCatsObjects.v)
   - [PseudoFunctors/Examples/ConstProduct.v](Bicategories/PseudoFunctors/Examples/ConstProduct.v)
   - [PseudoFunctors/Examples/CurryingInBicatOfCats.v](Bicategories/PseudoFunctors/Examples/CurryingInBicatOfCats.v)
   - [PseudoFunctors/PseudoFunctorLimits.v](Bicategories/PseudoFunctors/PseudoFunctorLimits.v)
   - [DisplayedBicats/DispBiadjunction.v](Bicategories/DisplayedBicats/DispBiadjunction.v)
   - [PseudoFunctors/Examples/PathGroupoid.v](Bicategories/PseudoFunctors/Examples/PathGroupoid.v)
   - [DisplayedBicats/DispToFiberEquivalence.v](Bicategories/DisplayedBicats/DispToFiberEquivalence.v)
   - [DisplayedBicats/DispBuilders.v](Bicategories/DisplayedBicats/DispBuilders.v)
   - [DisplayedBicats/Examples/MonadKtripleBiequiv.v](Bicategories/DisplayedBicats/Examples/MonadKtripleBiequiv.v)
   - [DisplayedBicats/Examples/PointedGroupoid.v](Bicategories/DisplayedBicats/Examples/PointedGroupoid.v)
   - [PseudoFunctors/Examples/LiftingActegories.v](Bicategories/PseudoFunctors/Examples/LiftingActegories.v)
   - [WkCatEnrichment/prebicategory.v](Bicategories/WkCatEnrichment/prebicategory.v)
   - [WkCatEnrichment/Notations.v](Bicategories/WkCatEnrichment/Notations.v)
   - [WkCatEnrichment/whiskering.v](Bicategories/WkCatEnrichment/whiskering.v)
   - [WkCatEnrichment/Cat.v](Bicategories/WkCatEnrichment/Cat.v)
   - [WkCatEnrichment/internal_equivalence.v](Bicategories/WkCatEnrichment/internal_equivalence.v)
   - [WkCatEnrichment/bicategory.v](Bicategories/WkCatEnrichment/bicategory.v)
   - [WkCatEnrichment/hcomp_bicat.v](Bicategories/WkCatEnrichment/hcomp_bicat.v)
   - [PseudoFunctors/Examples/Strictify.v](Bicategories/PseudoFunctors/Examples/Strictify.v)
   - [PseudoFunctors/Preservation/Preservation.v](Bicategories/PseudoFunctors/Preservation/Preservation.v)
   - [PseudoFunctors/Preservation/BiadjunctionPreservation.v](Bicategories/PseudoFunctors/Preservation/BiadjunctionPreservation.v)
   - [PseudoFunctors/Preservation/BiadjunctionPreserveProducts.v](Bicategories/PseudoFunctors/Preservation/BiadjunctionPreserveProducts.v)
   - [PseudoFunctors/Preservation/BiadjunctionPreserveInserters.v](Bicategories/PseudoFunctors/Preservation/BiadjunctionPreserveInserters.v)
   - [PseudoFunctors/Preservation/BiadjunctionPreserveEquifiers.v](Bicategories/PseudoFunctors/Preservation/BiadjunctionPreserveEquifiers.v)
   - [PseudoFunctors/Preservation/BiadjunctionPreserveCoproducts.v](Bicategories/PseudoFunctors/Preservation/BiadjunctionPreserveCoproducts.v)
   - [PseudoFunctors/Preservation/ClosedUnderEquivalence.v](Bicategories/PseudoFunctors/Preservation/ClosedUnderEquivalence.v)
   - [BicategoryOfBicat.v](Bicategories/BicategoryOfBicat.v)
   - [BicatOfBicategory.v](Bicategories/BicatOfBicategory.v)
   - [DisplayedBicats/Cartesians.v](Bicategories/DisplayedBicats/Cartesians.v)
   - [DisplayedBicats/EquivalenceBetweenCartesians.v](Bicategories/DisplayedBicats/EquivalenceBetweenCartesians.v)
   - [DisplayedBicats/CleavingOfBicatIsAProp.v](Bicategories/DisplayedBicats/CleavingOfBicatIsAProp.v)
   - [DisplayedBicats/CartesianPseudoFunctor.v](Bicategories/DisplayedBicats/CartesianPseudoFunctor.v)
   - [DisplayedBicats/ExamplesOfCleavings/TrivialCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/TrivialCleaving.v)
   - [DisplayedBicats/ExamplesOfCleavings/SliceCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/SliceCleaving.v)
   - [DisplayedBicats/ExamplesOfCleavings/FunctorsIntoCatCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/FunctorsIntoCatCleaving.v)
   - [DisplayedBicats/ExamplesOfCleavings/CodomainCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/CodomainCleaving.v)
   - [DisplayedBicats/ExamplesOfCleavings/FibrationCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/FibrationCleaving.v)
   - [DisplayedBicats/ExamplesOfCleavings/OpFibrationCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/OpFibrationCleaving.v)
   - [DisplayedBicats/FiberBicategory/FunctorFromCleaving.v](Bicategories/DisplayedBicats/FiberBicategory/FunctorFromCleaving.v)
   - [PseudoFunctors/Examples/Reindexing.v](Bicategories/PseudoFunctors/Examples/Reindexing.v)
   - [Logic/DisplayMapBicat.v](Bicategories/Logic/DisplayMapBicat.v)
   - [DisplayedBicats/Examples/DisplayMapBicatToDispBicat.v](Bicategories/DisplayedBicats/Examples/DisplayMapBicatToDispBicat.v)
   - [DisplayedBicats/Examples/DisplayMapBicatSlice.v](Bicategories/DisplayedBicats/Examples/DisplayMapBicatSlice.v)
   - [DisplayedBicats/ExamplesOfCleavings/DisplayMapBicatCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/DisplayMapBicatCleaving.v)
   - [PseudoFunctors/Examples/PullbackFunctor.v](Bicategories/PseudoFunctors/Examples/PullbackFunctor.v)
   - [PseudoFunctors/Examples/CompositionPseudoFunctor.v](Bicategories/PseudoFunctors/Examples/CompositionPseudoFunctor.v)
   - [PseudoFunctors/Preservation/PullbackPreservation.v](Bicategories/PseudoFunctors/Preservation/PullbackPreservation.v)
   - [Limits/Examples/DisplayMapSliceLimits.v](Bicategories/Limits/Examples/DisplayMapSliceLimits.v)
   - [Colimits/Examples/DisplayMapSliceColimits.v](Bicategories/Colimits/Examples/DisplayMapSliceColimits.v)
   - [DisplayedBicats/FiberBicategory/TrivialFiber.v](Bicategories/DisplayedBicats/FiberBicategory/TrivialFiber.v)
   - [DisplayedBicats/FiberBicategory/CodomainFiber.v](Bicategories/DisplayedBicats/FiberBicategory/CodomainFiber.v)
   - [DisplayedBicats/FiberBicategory/SliceFiber.v](Bicategories/DisplayedBicats/FiberBicategory/SliceFiber.v)
   - [DisplayedBicats/FiberBicategory/DisplayMapFiber.v](Bicategories/DisplayedBicats/FiberBicategory/DisplayMapFiber.v)
   - [Logic/ComprehensionBicat.v](Bicategories/Logic/ComprehensionBicat.v)
   - [Logic/Examples/TrivialComprehensionBicat.v](Bicategories/Logic/Examples/TrivialComprehensionBicat.v)
   - [Logic/Examples/PullbackComprehensionBicat.v](Bicategories/Logic/Examples/PullbackComprehensionBicat.v)
   - [Logic/Examples/FibrationsComprehensionBicat.v](Bicategories/Logic/Examples/FibrationsComprehensionBicat.v)
   - [Logic/Examples/OpfibrationsComprehensionBicat.v](Bicategories/Logic/Examples/OpfibrationsComprehensionBicat.v)
   - [Logic/Examples/DisplayMapComprehensionBicat.v](Bicategories/Logic/Examples/DisplayMapComprehensionBicat.v)
   - [Logic/Examples/FunctorsIntoCatComprehensionBicat.v](Bicategories/Logic/Examples/FunctorsIntoCatComprehensionBicat.v)
   - [OtherStructure/DualityInvolution.v](Bicategories/OtherStructure/DualityInvolution.v)
   - [OtherStructure/ClassifyingDiscreteOpfib.v](Bicategories/OtherStructure/ClassifyingDiscreteOpfib.v)
   - [OtherStructure/Exponentials.v](Bicategories/OtherStructure/Exponentials.v)
   - [OtherStructure/Cores.v](Bicategories/OtherStructure/Cores.v)
   - [OtherStructure/Examples/StructureBicatOfUnivCats.v](Bicategories/OtherStructure/Examples/StructureBicatOfUnivCats.v)
   - [OtherStructure/Examples/StructureOneTypes.v](Bicategories/OtherStructure/Examples/StructureOneTypes.v)
   - [OtherStructure/Examples/StructureBicatOfEnrichedCats.v](Bicategories/OtherStructure/Examples/StructureBicatOfEnrichedCats.v)
   - [PseudoFunctors/DisplayedUniversalArrow.v](Bicategories/PseudoFunctors/DisplayedUniversalArrow.v)
   - [RezkCompletions/BicatToLocalUnivalentBicat.v](Bicategories/RezkCompletions/BicatToLocalUnivalentBicat.v)
   - [RezkCompletions/RezkCompletionOfBicategory.v](Bicategories/RezkCompletions/RezkCompletionOfBicategory.v)
   - [DaggerCategories/BicatOfDaggerCats.v](Bicategories/DaggerCategories/BicatOfDaggerCats.v)
   - [All.v](Bicategories/All.v)
## Package [Ktheory](Ktheory/README.md)
   - [GrothendieckGroup.v](Ktheory/GrothendieckGroup.v)
   - [All.v](Ktheory/All.v)
## Package Topology
   - [Prelim.v](Topology/Prelim.v)
   - [Filters.v](Topology/Filters.v)
   - [Topology.v](Topology/Topology.v)
   - [CategoryTop.v](Topology/CategoryTop.v)
   - [All.v](Topology/All.v)
## Package [RealNumbers](RealNumbers/README.md)
   - [Prelim.v](RealNumbers/Prelim.v)
   - [Fields.v](RealNumbers/Fields.v)
   - [Sets.v](RealNumbers/Sets.v)
   - [NonnegativeRationals.v](RealNumbers/NonnegativeRationals.v)
   - [NonnegativeReals.v](RealNumbers/NonnegativeReals.v)
   - [Reals.v](RealNumbers/Reals.v)
   - [DedekindCuts.v](RealNumbers/DedekindCuts.v)
   - [DecidableDedekindCuts.v](RealNumbers/DecidableDedekindCuts.v)
   - [All.v](RealNumbers/All.v)
## Package [SubstitutionSystems](SubstitutionSystems/README.md)
   - [Notation.v](SubstitutionSystems/Notation.v)
   - [Signatures.v](SubstitutionSystems/Signatures.v)
   - [BinSumOfSignatures.v](SubstitutionSystems/BinSumOfSignatures.v)
   - [SumOfSignatures.v](SubstitutionSystems/SumOfSignatures.v)
   - [BinProductOfSignatures.v](SubstitutionSystems/BinProductOfSignatures.v)
   - [SubstitutionSystems.v](SubstitutionSystems/SubstitutionSystems.v)
   - [SimplifiedHSS/SubstitutionSystems.v](SubstitutionSystems/SimplifiedHSS/SubstitutionSystems.v)
   - [SignaturesEquivRelativeStrength.v](SubstitutionSystems/SignaturesEquivRelativeStrength.v)
   - [GeneralizedSubstitutionSystems.v](SubstitutionSystems/GeneralizedSubstitutionSystems.v)
   - [MonadsFromSubstitutionSystems.v](SubstitutionSystems/MonadsFromSubstitutionSystems.v)
   - [SimplifiedHSS/MonadsFromSubstitutionSystems.v](SubstitutionSystems/SimplifiedHSS/MonadsFromSubstitutionSystems.v)
   - [GenMendlerIteration.v](SubstitutionSystems/GenMendlerIteration.v)
   - [GenMendlerIteration_alt.v](SubstitutionSystems/GenMendlerIteration_alt.v)
   - [ActionScenarioForGenMendlerIteration_alt.v](SubstitutionSystems/ActionScenarioForGenMendlerIteration_alt.v)
   - [ApplicationsGenMendlerIteration_alt.v](SubstitutionSystems/ApplicationsGenMendlerIteration_alt.v)
   - [LiftingInitial.v](SubstitutionSystems/LiftingInitial.v)
   - [SimplifiedHSS/LiftingInitial.v](SubstitutionSystems/SimplifiedHSS/LiftingInitial.v)
   - [LiftingInitial_alt.v](SubstitutionSystems/LiftingInitial_alt.v)
   - [SimplifiedHSS/LiftingInitial_alt.v](SubstitutionSystems/SimplifiedHSS/LiftingInitial_alt.v)
   - [ModulesFromSignatures.v](SubstitutionSystems/ModulesFromSignatures.v)
   - [SimplifiedHSS/ModulesFromSignatures.v](SubstitutionSystems/SimplifiedHSS/ModulesFromSignatures.v)
   - [LamSignature.v](SubstitutionSystems/LamSignature.v)
   - [Lam.v](SubstitutionSystems/Lam.v)
   - [SimplifiedHSS/Lam.v](SubstitutionSystems/SimplifiedHSS/Lam.v)
   - [SignatureExamples.v](SubstitutionSystems/SignatureExamples.v)
   - [SignatureCategory.v](SubstitutionSystems/SignatureCategory.v)
   - [SubstitutionSystems_Summary.v](SubstitutionSystems/SubstitutionSystems_Summary.v)
   - [SimplifiedHSS/SubstitutionSystems_Summary.v](SubstitutionSystems/SimplifiedHSS/SubstitutionSystems_Summary.v)
   - [LamHSET.v](SubstitutionSystems/LamHSET.v)
   - [SimplifiedHSS/LamHSET.v](SubstitutionSystems/SimplifiedHSS/LamHSET.v)
   - [BindingSigToMonad.v](SubstitutionSystems/BindingSigToMonad.v)
   - [SimplifiedHSS/BindingSigToMonad.v](SubstitutionSystems/SimplifiedHSS/BindingSigToMonad.v)
   - [LamFromBindingSig.v](SubstitutionSystems/LamFromBindingSig.v)
   - [SimplifiedHSS/LamFromBindingSig.v](SubstitutionSystems/SimplifiedHSS/LamFromBindingSig.v)
   - [MLTT79.v](SubstitutionSystems/MLTT79.v)
   - [SimplifiedHSS/MLTT79.v](SubstitutionSystems/SimplifiedHSS/MLTT79.v)
   - [FromBindingSigsToMonads_Summary.v](SubstitutionSystems/FromBindingSigsToMonads_Summary.v)
   - [SimplifiedHSS/FromBindingSigsToMonads_Summary.v](SubstitutionSystems/SimplifiedHSS/FromBindingSigsToMonads_Summary.v)
   - [MonadsMultiSorted.v](SubstitutionSystems/MonadsMultiSorted.v)
   - [MonadsMultiSorted_alt.v](SubstitutionSystems/MonadsMultiSorted_alt.v)
   - [MultiSorted.v](SubstitutionSystems/MultiSorted.v)
   - [MultiSortedMonadConstruction.v](SubstitutionSystems/MultiSortedMonadConstruction.v)
   - [SimplifiedHSS/MultiSortedMonadConstruction.v](SubstitutionSystems/SimplifiedHSS/MultiSortedMonadConstruction.v)
   - [MultiSorted_alt.v](SubstitutionSystems/MultiSorted_alt.v)
   - [MultiSortedMonadConstruction_alt.v](SubstitutionSystems/MultiSortedMonadConstruction_alt.v)
   - [SimplifiedHSS/MultiSortedMonadConstruction_alt.v](SubstitutionSystems/SimplifiedHSS/MultiSortedMonadConstruction_alt.v)
   - [MonadicSubstitution_alt.v](SubstitutionSystems/MonadicSubstitution_alt.v)
   - [SimplifiedHSS/MonadicSubstitution_alt.v](SubstitutionSystems/SimplifiedHSS/MonadicSubstitution_alt.v)
   - [STLC.v](SubstitutionSystems/STLC.v)
   - [SimplifiedHSS/STLC.v](SubstitutionSystems/SimplifiedHSS/STLC.v)
   - [STLC_alt.v](SubstitutionSystems/STLC_alt.v)
   - [SimplifiedHSS/STLC_alt.v](SubstitutionSystems/SimplifiedHSS/STLC_alt.v)
   - [CCS.v](SubstitutionSystems/CCS.v)
   - [SimplifiedHSS/CCS.v](SubstitutionSystems/SimplifiedHSS/CCS.v)
   - [CCS_alt.v](SubstitutionSystems/CCS_alt.v)
   - [SimplifiedHSS/CCS_alt.v](SubstitutionSystems/SimplifiedHSS/CCS_alt.v)
   - [PCF_alt.v](SubstitutionSystems/PCF_alt.v)
   - [SimplifiedHSS/PCF_alt.v](SubstitutionSystems/SimplifiedHSS/PCF_alt.v)
   - [ActionBasedStrengthOnHomsInBicat.v](SubstitutionSystems/ActionBasedStrengthOnHomsInBicat.v)
   - [EquivalenceSignaturesWithActegoryMorphisms.v](SubstitutionSystems/EquivalenceSignaturesWithActegoryMorphisms.v)
   - [EquivalenceLaxLineatorsHomogeneousCase.v](SubstitutionSystems/EquivalenceLaxLineatorsHomogeneousCase.v)
   - [SigmaMonoids.v](SubstitutionSystems/SigmaMonoids.v)
   - [ConstructionOfGHSS.v](SubstitutionSystems/ConstructionOfGHSS.v)
   - [BindingSigToMonad_actegorical.v](SubstitutionSystems/BindingSigToMonad_actegorical.v)
   - [ContinuitySignature/GeneralLemmas.v](SubstitutionSystems/ContinuitySignature/GeneralLemmas.v)
   - [ContinuitySignature/CommutingOfOmegaLimitsAndCoproducts.v](SubstitutionSystems/ContinuitySignature/CommutingOfOmegaLimitsAndCoproducts.v)
   - [ContinuitySignature/ContinuityOfMultiSortedSigToFunctor.v](SubstitutionSystems/ContinuitySignature/ContinuityOfMultiSortedSigToFunctor.v)
   - [ContinuitySignature/MultiSortedSignatureFunctorEquivalence.v](SubstitutionSystems/ContinuitySignature/MultiSortedSignatureFunctorEquivalence.v)
   - [ContinuitySignature/InstantiateHSET.v](SubstitutionSystems/ContinuitySignature/InstantiateHSET.v)
   - [MultiSorted_actegorical.v](SubstitutionSystems/MultiSorted_actegorical.v)
   - [MultiSortedMonadConstruction_actegorical.v](SubstitutionSystems/MultiSortedMonadConstruction_actegorical.v)
   - [MultiSortedMonadConstruction_coind_actegorical.v](SubstitutionSystems/MultiSortedMonadConstruction_coind_actegorical.v)
   - [MultiSortedEmbeddingIndCoindHSET.v](SubstitutionSystems/MultiSortedEmbeddingIndCoindHSET.v)
   - [All.v](SubstitutionSystems/All.v)
## Package [Folds](Folds/README.md)
   - [UnicodeNotations.v](Folds/UnicodeNotations.v)
   - [folds_precat.v](Folds/folds_precat.v)
   - [from_precats_to_folds_and_back.v](Folds/from_precats_to_folds_and_back.v)
   - [folds_isomorphism.v](Folds/folds_isomorphism.v)
   - [folds_pre_2_cat.v](Folds/folds_pre_2_cat.v)
   - [All.v](Folds/All.v)
## Package [HomologicalAlgebra](HomologicalAlgebra/README.md)
   - [Triangulated.v](HomologicalAlgebra/Triangulated.v)
   - [Complexes.v](HomologicalAlgebra/Complexes.v)
   - [KA.v](HomologicalAlgebra/KA.v)
   - [TranslationFunctors.v](HomologicalAlgebra/TranslationFunctors.v)
   - [MappingCone.v](HomologicalAlgebra/MappingCone.v)
   - [MappingCylinder.v](HomologicalAlgebra/MappingCylinder.v)
   - [KAPreTriangulated.v](HomologicalAlgebra/KAPreTriangulated.v)
   - [KATriangulated.v](HomologicalAlgebra/KATriangulated.v)
   - [CohomologyComplex.v](HomologicalAlgebra/CohomologyComplex.v)
   - [All.v](HomologicalAlgebra/All.v)
## Package [AlgebraicGeometry](AlgebraicGeometry/README.md)
   - [Topology.v](AlgebraicGeometry/Topology.v)
   - [SheavesOfRings.v](AlgebraicGeometry/SheavesOfRings.v)
   - [Spec.v](AlgebraicGeometry/Spec.v)
   - [All.v](AlgebraicGeometry/All.v)
## Package [Paradoxes](Paradoxes/README.md)
   - [GirardsParadox.v](Paradoxes/GirardsParadox.v)
   - [All.v](Paradoxes/All.v)
## Package [Induction](Induction/README.md)
   - [FunctorAlgebras_legacy.v](Induction/FunctorAlgebras_legacy.v)
   - [FunctorCoalgebras_legacy.v](Induction/FunctorCoalgebras_legacy.v)
   - [PolynomialFunctors.v](Induction/PolynomialFunctors.v)
   - [ImpredicativeInductiveSets.v](Induction/ImpredicativeInductiveSets.v)
   - [M/Core.v](Induction/M/Core.v)
   - [M/Limits.v](Induction/M/Limits.v)
   - [M/Uniqueness.v](Induction/M/Uniqueness.v)
   - [W/Core.v](Induction/W/Core.v)
   - [W/Fibered.v](Induction/W/Fibered.v)
   - [W/Naturals.v](Induction/W/Naturals.v)
   - [W/Uniqueness.v](Induction/W/Uniqueness.v)
   - [M/Chains.v](Induction/M/Chains.v)
   - [M/ComputationalM.v](Induction/M/ComputationalM.v)
   - [All.v](Induction/All.v)
## Package AlgebraicTheories
   - [FiniteSetSkeleton.v](AlgebraicTheories/FiniteSetSkeleton.v)
   - [AlgebraicBases.v](AlgebraicTheories/AlgebraicBases.v)
   - [AlgebraicTheories.v](AlgebraicTheories/AlgebraicTheories.v)
   - [AlgebraicTheoryMorphisms.v](AlgebraicTheories/AlgebraicTheoryMorphisms.v)
   - [AbstractClones/AbstractClones.v](AlgebraicTheories/AbstractClones/AbstractClones.v)
   - [AbstractClones/AbstractCloneMorphisms.v](AlgebraicTheories/AbstractClones/AbstractCloneMorphisms.v)
   - [AbstractClones/AbstractCloneAlgebras.v](AlgebraicTheories/AbstractClones/AbstractCloneAlgebras.v)
   - [AbstractClones/AbstractCloneCategory.v](AlgebraicTheories/AbstractClones/AbstractCloneCategory.v)
   - [AbstractCloneAlgebraicTheory.v](AlgebraicTheories/AbstractCloneAlgebraicTheory.v)
   - [Examples/OnePointTheory.v](AlgebraicTheories/Examples/OnePointTheory.v)
   - [Examples/ProjectionsTheory.v](AlgebraicTheories/Examples/ProjectionsTheory.v)
   - [Examples/EndomorphismTheory.v](AlgebraicTheories/Examples/EndomorphismTheory.v)
   - [Examples/FreeMonoidTheory.v](AlgebraicTheories/Examples/FreeMonoidTheory.v)
   - [AbstractCloneAlgebraEndomorphism.v](AlgebraicTheories/AbstractCloneAlgebraEndomorphism.v)
   - [All.v](AlgebraicTheories/All.v)
