# Contents of the UniMath library
The packages and files are listed here in logical order: each file depends only on files occurring earlier.
## Package [Foundations](Foundations/README)
   - [Init.v](Foundations/Init.v)
   - [Preamble.v](Foundations/Preamble.v)
   - [PartA.v](Foundations/PartA.v)
   - [PartB.v](Foundations/PartB.v)
   - [UnivalenceAxiom.v](Foundations/UnivalenceAxiom.v)
   - [PartC.v](Foundations/PartC.v)
   - [PartD.v](Foundations/PartD.v)
   - [UnivalenceAxiom2.v](Foundations/UnivalenceAxiom2.v)
   - [Propositions.v](Foundations/Propositions.v)
   - [Sets.v](Foundations/Sets.v)
   - [NaturalNumbers.v](Foundations/NaturalNumbers.v)
   - [Tests.v](Foundations/Tests.v)
   - [HLevels.v](Foundations/HLevels.v)
   - [All.v](Foundations/All.v)
## Package [MoreFoundations](MoreFoundations/README.md)
   - [Bool.v](MoreFoundations/Bool.v)
   - [Test.v](MoreFoundations/Test.v)
   - [WeakEquivalences.v](MoreFoundations/WeakEquivalences.v)
   - [Tactics.v](MoreFoundations/Tactics.v)
   - [PartA.v](MoreFoundations/PartA.v)
   - [PathsOver.v](MoreFoundations/PathsOver.v)
   - [Nat.v](MoreFoundations/Nat.v)
   - [Notations.v](MoreFoundations/Notations.v)
   - [AlternativeProofs.v](MoreFoundations/AlternativeProofs.v)
   - [Subposets.v](MoreFoundations/Subposets.v)
   - [DoubleNegation.v](MoreFoundations/DoubleNegation.v)
   - [DecidablePropositions.v](MoreFoundations/DecidablePropositions.v)
   - [Propositions.v](MoreFoundations/Propositions.v)
   - [NullHomotopies.v](MoreFoundations/NullHomotopies.v)
   - [Interval.v](MoreFoundations/Interval.v)
   - [NegativePropositions.v](MoreFoundations/NegativePropositions.v)
   - [Sets.v](MoreFoundations/Sets.v)
   - [Equivalences.v](MoreFoundations/Equivalences.v)
   - [MoreEquivalences.v](MoreFoundations/MoreEquivalences.v)
   - [QuotientSet.v](MoreFoundations/QuotientSet.v)
   - [Subtypes.v](MoreFoundations/Subtypes.v)
   - [AxiomOfChoice.v](MoreFoundations/AxiomOfChoice.v)
   - [StructureIdentity.v](MoreFoundations/StructureIdentity.v)
   - [Univalence.v](MoreFoundations/Univalence.v)
   - [NoInjectivePairing.v](MoreFoundations/NoInjectivePairing.v)
   - [PartD.v](MoreFoundations/PartD.v)
   - [All.v](MoreFoundations/All.v)
## Package [Combinatorics](Combinatorics/README.md)
   - [StandardFiniteSets.v](Combinatorics/StandardFiniteSets.v)
   - [Vectors.v](Combinatorics/Vectors.v)
   - [VectorsTests.v](Combinatorics/VectorsTests.v)
   - [Lists.v](Combinatorics/Lists.v)
   - [FiniteSets.v](Combinatorics/FiniteSets.v)
   - [Graph.v](Combinatorics/Graph.v)
   - [GraphPaths.v](Combinatorics/GraphPaths.v)
   - [Equivalence_Relations.v](Combinatorics/Equivalence_Relations.v)
   - [OrderedSets.v](Combinatorics/OrderedSets.v)
   - [WellFoundedRelations.v](Combinatorics/WellFoundedRelations.v)
   - [WellOrderedSets.v](Combinatorics/WellOrderedSets.v)
   - [ZFstructures.v](Combinatorics/ZFstructures.v)
   - [FiniteSequences.v](Combinatorics/FiniteSequences.v)
   - [BoundedSearch.v](Combinatorics/BoundedSearch.v)
   - [MetricTree.v](Combinatorics/MetricTree.v)
   - [Tests.v](Combinatorics/Tests.v)
   - [DecSet.v](Combinatorics/DecSet.v)
   - [Maybe.v](Combinatorics/Maybe.v)
   - [MoreLists.v](Combinatorics/MoreLists.v)
   - [All.v](Combinatorics/All.v)
## Package [Algebra](Algebra/README.md)
   - [Dcpo.v](Algebra/Dcpo.v)
   - [FixedPointTheorems.v](Algebra/FixedPointTheorems.v)
   - [BinaryOperations.v](Algebra/BinaryOperations.v)
   - [Monoids.v](Algebra/Monoids.v)
   - [Groups.v](Algebra/Groups.v)
   - [GroupAction.v](Algebra/GroupAction.v)
   - [RigsAndRings.v](Algebra/RigsAndRings.v)
   - [RigsAndRings/Ideals.v](Algebra/RigsAndRings/Ideals.v)
   - [Domains_and_Fields.v](Algebra/Domains_and_Fields.v)
   - [DivisionRig.v](Algebra/DivisionRig.v)
   - [Apartness.v](Algebra/Apartness.v)
   - [ConstructiveStructures.v](Algebra/ConstructiveStructures.v)
   - [Archimedean.v](Algebra/Archimedean.v)
   - [Lattice.v](Algebra/Lattice.v)
   - [IteratedBinaryOperations.v](Algebra/IteratedBinaryOperations.v)
   - [Free_Monoids_and_Groups.v](Algebra/Free_Monoids_and_Groups.v)
   - [Tests.v](Algebra/Tests.v)
   - [Modules/Core.v](Algebra/Modules/Core.v)
   - [Modules/Submodule.v](Algebra/Modules/Submodule.v)
   - [Modules/Multimodules.v](Algebra/Modules/Multimodules.v)
   - [Modules/Examples.v](Algebra/Modules/Examples.v)
   - [Modules/Quotient.v](Algebra/Modules/Quotient.v)
   - [Modules.v](Algebra/Modules.v)
   - [Matrix.v](Algebra/Matrix.v)
   - [Universal/HVectors.v](Algebra/Universal/HVectors.v)
   - [Universal/SortedTypes.v](Algebra/Universal/SortedTypes.v)
   - [Universal/Signatures.v](Algebra/Universal/Signatures.v)
   - [Universal/Algebras.v](Algebra/Universal/Algebras.v)
   - [Universal/Terms.v](Algebra/Universal/Terms.v)
   - [Universal/TermAlgebras.v](Algebra/Universal/TermAlgebras.v)
   - [Universal/VTerms.v](Algebra/Universal/VTerms.v)
   - [Universal/FreeAlgebras.v](Algebra/Universal/FreeAlgebras.v)
   - [Universal/Equations.v](Algebra/Universal/Equations.v)
   - [Universal/EqAlgebras.v](Algebra/Universal/EqAlgebras.v)
   - [Universal/Examples/Nat.v](Algebra/Universal/Examples/Nat.v)
   - [Universal/Examples/Bool.v](Algebra/Universal/Examples/Bool.v)
   - [Universal/Examples/Monoid.v](Algebra/Universal/Examples/Monoid.v)
   - [Universal/Examples/Group.v](Algebra/Universal/Examples/Group.v)
   - [Universal/Examples/ListDataType.v](Algebra/Universal/Examples/ListDataType.v)
   - [Universal/Examples/Tests.v](Algebra/Universal/Examples/Tests.v)
   - [Universal.v](Algebra/Universal.v)
   - [All.v](Algebra/All.v)
## Package NumberSystems
   - [NaturalNumbersAlgebra.v](NumberSystems/NaturalNumbersAlgebra.v)
   - [NaturalNumbers_le_Inductive.v](NumberSystems/NaturalNumbers_le_Inductive.v)
   - [Integers.v](NumberSystems/Integers.v)
   - [RationalNumbers.v](NumberSystems/RationalNumbers.v)
   - [Tests.v](NumberSystems/Tests.v)
   - [All.v](NumberSystems/All.v)
## Package [SyntheticHomotopyTheory](SyntheticHomotopyTheory/README.md)
   - [Halfline.v](SyntheticHomotopyTheory/Halfline.v)
   - [AffineLine.v](SyntheticHomotopyTheory/AffineLine.v)
   - [Circle.v](SyntheticHomotopyTheory/Circle.v)
   - [Circle2.v](SyntheticHomotopyTheory/Circle2.v)
   - [Test.v](SyntheticHomotopyTheory/Test.v)
   - [All.v](SyntheticHomotopyTheory/All.v)
## Package [PAdics](PAdics/README.md)
   - [lemmas.v](PAdics/lemmas.v)
   - [fps.v](PAdics/fps.v)
   - [frac.v](PAdics/frac.v)
   - [z_mod_p.v](PAdics/z_mod_p.v)
   - [padics.v](PAdics/padics.v)
   - [All.v](PAdics/All.v)
## Package [CategoryTheory](CategoryTheory/README.md)
   - [Core/Categories.v](CategoryTheory/Core/Categories.v)
   - [Core/TwoCategories.v](CategoryTheory/Core/TwoCategories.v)
   - [Core/Isos.v](CategoryTheory/Core/Isos.v)
   - [Core/Univalence.v](CategoryTheory/Core/Univalence.v)
   - [Core/TransportMorphisms.v](CategoryTheory/Core/TransportMorphisms.v)
   - [Core/Setcategories.v](CategoryTheory/Core/Setcategories.v)
   - [Core/EssentiallyAlgebraic.v](CategoryTheory/Core/EssentiallyAlgebraic.v)
   - [Core/Functors.v](CategoryTheory/Core/Functors.v)
   - [Core/NaturalTransformations.v](CategoryTheory/Core/NaturalTransformations.v)
   - [Core/Prelude.v](CategoryTheory/Core/Prelude.v)
   - [FunctorCategory.v](CategoryTheory/FunctorCategory.v)
   - [categories/HSET/Core.v](CategoryTheory/categories/HSET/Core.v)
   - [opp_precat.v](CategoryTheory/opp_precat.v)
   - [Groupoids.v](CategoryTheory/Groupoids.v)
   - [PrecategoryBinProduct.v](CategoryTheory/PrecategoryBinProduct.v)
   - [ProductCategory.v](CategoryTheory/ProductCategory.v)
   - [whiskering.v](CategoryTheory/whiskering.v)
   - [Subcategory/Core.v](CategoryTheory/Subcategory/Core.v)
   - [Subcategory/Full.v](CategoryTheory/Subcategory/Full.v)
   - [Monics.v](CategoryTheory/Monics.v)
   - [Epis.v](CategoryTheory/Epis.v)
   - [SplitMonicsAndEpis.v](CategoryTheory/SplitMonicsAndEpis.v)
   - [Adjunctions/Core.v](CategoryTheory/Adjunctions/Core.v)
   - [Monads/RelativeMonads.v](CategoryTheory/Monads/RelativeMonads.v)
   - [Monads/RelMonads_Coreflection.v](CategoryTheory/Monads/RelMonads_Coreflection.v)
   - [Monads/RelativeModules.v](CategoryTheory/Monads/RelativeModules.v)
   - [Equivalences/Core.v](CategoryTheory/Equivalences/Core.v)
   - [Equivalences/CompositesAndInverses.v](CategoryTheory/Equivalences/CompositesAndInverses.v)
   - [Equivalences/FullyFaithful.v](CategoryTheory/Equivalences/FullyFaithful.v)
   - [categories/HSET/MonoEpiIso.v](CategoryTheory/categories/HSET/MonoEpiIso.v)
   - [categories/HSET/Univalence.v](CategoryTheory/categories/HSET/Univalence.v)
   - [Profunctors/Core.v](CategoryTheory/Profunctors/Core.v)
   - [CategoriesWithBinOps.v](CategoryTheory/CategoriesWithBinOps.v)
   - [PrecategoriesWithAbgrops.v](CategoryTheory/PrecategoriesWithAbgrops.v)
   - [limits/cones.v](CategoryTheory/limits/cones.v)
   - [limits/equalizers.v](CategoryTheory/limits/equalizers.v)
   - [limits/graphs/colimits.v](CategoryTheory/limits/graphs/colimits.v)
   - [limits/graphs/limits.v](CategoryTheory/limits/graphs/limits.v)
   - [limits/graphs/eqdiag.v](CategoryTheory/limits/graphs/eqdiag.v)
   - [limits/coproducts.v](CategoryTheory/limits/coproducts.v)
   - [limits/products.v](CategoryTheory/limits/products.v)
   - [limits/initial.v](CategoryTheory/limits/initial.v)
   - [limits/terminal.v](CategoryTheory/limits/terminal.v)
   - [limits/zero.v](CategoryTheory/limits/zero.v)
   - [limits/bincoproducts.v](CategoryTheory/limits/bincoproducts.v)
   - [limits/binproducts.v](CategoryTheory/limits/binproducts.v)
   - [limits/graphs/bincoproducts.v](CategoryTheory/limits/graphs/bincoproducts.v)
   - [limits/graphs/binproducts.v](CategoryTheory/limits/graphs/binproducts.v)
   - [limits/pullbacks.v](CategoryTheory/limits/pullbacks.v)
   - [limits/graphs/initial.v](CategoryTheory/limits/graphs/initial.v)
   - [limits/graphs/terminal.v](CategoryTheory/limits/graphs/terminal.v)
   - [limits/graphs/zero.v](CategoryTheory/limits/graphs/zero.v)
   - [limits/graphs/pullbacks.v](CategoryTheory/limits/graphs/pullbacks.v)
   - [limits/coequalizers.v](CategoryTheory/limits/coequalizers.v)
   - [limits/kernels.v](CategoryTheory/limits/kernels.v)
   - [limits/cokernels.v](CategoryTheory/limits/cokernels.v)
   - [PreAdditive.v](CategoryTheory/PreAdditive.v)
   - [limits/pushouts.v](CategoryTheory/limits/pushouts.v)
   - [limits/graphs/pushouts.v](CategoryTheory/limits/graphs/pushouts.v)
   - [limits/graphs/equalizers.v](CategoryTheory/limits/graphs/equalizers.v)
   - [limits/graphs/coequalizers.v](CategoryTheory/limits/graphs/coequalizers.v)
   - [limits/graphs/kernels.v](CategoryTheory/limits/graphs/kernels.v)
   - [limits/graphs/cokernels.v](CategoryTheory/limits/graphs/cokernels.v)
   - [limits/cats/limits.v](CategoryTheory/limits/cats/limits.v)
   - [limits/BinDirectSums.v](CategoryTheory/limits/BinDirectSums.v)
   - [limits/FinOrdProducts.v](CategoryTheory/limits/FinOrdProducts.v)
   - [limits/FinOrdCoproducts.v](CategoryTheory/limits/FinOrdCoproducts.v)
   - [limits/Opp.v](CategoryTheory/limits/Opp.v)
   - [SubobjectClassifier.v](CategoryTheory/SubobjectClassifier.v)
   - [NNO.v](CategoryTheory/NNO.v)
   - [Subcategory/Limits.v](CategoryTheory/Subcategory/Limits.v)
   - [EpiFacts.v](CategoryTheory/EpiFacts.v)
   - [exponentials.v](CategoryTheory/exponentials.v)
   - [categories/Type/Core.v](CategoryTheory/categories/Type/Core.v)
   - [categories/Type/MonoEpiIso.v](CategoryTheory/categories/Type/MonoEpiIso.v)
   - [SimplicialSets.v](CategoryTheory/SimplicialSets.v)
   - [yoneda.v](CategoryTheory/yoneda.v)
   - [Monads/Monads.v](CategoryTheory/Monads/Monads.v)
   - [Monads/KleisliCategory.v](CategoryTheory/Monads/KleisliCategory.v)
   - [Monads/LModules.v](CategoryTheory/Monads/LModules.v)
   - [FunctorAlgebras.v](CategoryTheory/FunctorAlgebras.v)
   - [FunctorCoalgebras.v](CategoryTheory/FunctorCoalgebras.v)
   - [precomp_fully_faithful.v](CategoryTheory/precomp_fully_faithful.v)
   - [precomp_ess_surj.v](CategoryTheory/precomp_ess_surj.v)
   - [rezk_completion.v](CategoryTheory/rezk_completion.v)
   - [UnitorsAndAssociatorsForEndofunctors.v](CategoryTheory/UnitorsAndAssociatorsForEndofunctors.v)
   - [CategoricalRecursionSchemes.v](CategoryTheory/CategoricalRecursionSchemes.v)
   - [PointedFunctors.v](CategoryTheory/PointedFunctors.v)
   - [HorizontalComposition.v](CategoryTheory/HorizontalComposition.v)
   - [PointedFunctorsComposition.v](CategoryTheory/PointedFunctorsComposition.v)
   - [CommaCategories.v](CategoryTheory/CommaCategories.v)
   - [ArrowCategory.v](CategoryTheory/ArrowCategory.v)
   - [RightKanExtension.v](CategoryTheory/RightKanExtension.v)
   - [slicecat.v](CategoryTheory/slicecat.v)
   - [coslicecat.v](CategoryTheory/coslicecat.v)
   - [limits/pullbacks_slice_products_equiv.v](CategoryTheory/limits/pullbacks_slice_products_equiv.v)
   - [covyoneda.v](CategoryTheory/covyoneda.v)
   - [catiso.v](CategoryTheory/catiso.v)
   - [CategoryEquality.v](CategoryTheory/CategoryEquality.v)
   - [Additive.v](CategoryTheory/Additive.v)
   - [Abelian.v](CategoryTheory/Abelian.v)
   - [category_binops.v](CategoryTheory/category_binops.v)
   - [AbelianToAdditive.v](CategoryTheory/AbelianToAdditive.v)
   - [Morphisms.v](CategoryTheory/Morphisms.v)
   - [ExactCategories/ExactCategories.v](CategoryTheory/ExactCategories/ExactCategories.v)
   - [ExactCategories/Tests.v](CategoryTheory/ExactCategories/Tests.v)
   - [ShortExactSequences.v](CategoryTheory/ShortExactSequences.v)
   - [AdditiveFunctors.v](CategoryTheory/AdditiveFunctors.v)
   - [LocalizingClass.v](CategoryTheory/LocalizingClass.v)
   - [UnderCategories.v](CategoryTheory/UnderCategories.v)
   - [Subobjects.v](CategoryTheory/Subobjects.v)
   - [Quotobjects.v](CategoryTheory/Quotobjects.v)
   - [AbelianPushoutPullback.v](CategoryTheory/AbelianPushoutPullback.v)
   - [PseudoElements.v](CategoryTheory/PseudoElements.v)
   - [FiveLemma.v](CategoryTheory/FiveLemma.v)
   - [LatticeObject.v](CategoryTheory/LatticeObject.v)
   - [Elements.v](CategoryTheory/Elements.v)
   - [Monads/KTriples.v](CategoryTheory/Monads/KTriples.v)
   - [Monads/Kleisli.v](CategoryTheory/Monads/Kleisli.v)
   - [Monads/KTriplesEquiv.v](CategoryTheory/Monads/KTriplesEquiv.v)
   - [Monads/Derivative.v](CategoryTheory/Monads/Derivative.v)
   - [Monads/MonadAlgebras.v](CategoryTheory/Monads/MonadAlgebras.v)
   - [Adjunctions/Restriction.v](CategoryTheory/Adjunctions/Restriction.v)
   - [Adjunctions/Examples.v](CategoryTheory/Adjunctions/Examples.v)
   - [Subcategory/Reflective.v](CategoryTheory/Subcategory/Reflective.v)
   - [categories/setwith2binops.v](CategoryTheory/categories/setwith2binops.v)
   - [categories/monoids.v](CategoryTheory/categories/monoids.v)
   - [categories/abmonoids.v](CategoryTheory/categories/abmonoids.v)
   - [categories/grs.v](CategoryTheory/categories/grs.v)
   - [categories/abgrs.v](CategoryTheory/categories/abgrs.v)
   - [categories/rigs.v](CategoryTheory/categories/rigs.v)
   - [categories/commrigs.v](CategoryTheory/categories/commrigs.v)
   - [categories/rings.v](CategoryTheory/categories/rings.v)
   - [categories/commrings.v](CategoryTheory/categories/commrings.v)
   - [categories/intdoms.v](CategoryTheory/categories/intdoms.v)
   - [categories/flds.v](CategoryTheory/categories/flds.v)
   - [categories/modules.v](CategoryTheory/categories/modules.v)
   - [categories/StandardCategories.v](CategoryTheory/categories/StandardCategories.v)
   - [categories/Cats.v](CategoryTheory/categories/Cats.v)
   - [categories/preorder_categories.v](CategoryTheory/categories/preorder_categories.v)
   - [categories/Type/Colimits.v](CategoryTheory/categories/Type/Colimits.v)
   - [categories/Type/Limits.v](CategoryTheory/categories/Type/Limits.v)
   - [categories/Type/Structures.v](CategoryTheory/categories/Type/Structures.v)
   - [categories/Type/Univalence.v](CategoryTheory/categories/Type/Univalence.v)
   - [categories/HSET/Limits.v](CategoryTheory/categories/HSET/Limits.v)
   - [categories/HSET/Colimits.v](CategoryTheory/categories/HSET/Colimits.v)
   - [categories/HSET/Slice.v](CategoryTheory/categories/HSET/Slice.v)
   - [categories/HSET/Structures.v](CategoryTheory/categories/HSET/Structures.v)
   - [categories/HSET/SliceFamEquiv.v](CategoryTheory/categories/HSET/SliceFamEquiv.v)
   - [categories/HSET/All.v](CategoryTheory/categories/HSET/All.v)
   - [SetValuedFunctors.v](CategoryTheory/SetValuedFunctors.v)
   - [categories/FinSet.v](CategoryTheory/categories/FinSet.v)
   - [categories/wosets.v](CategoryTheory/categories/wosets.v)
   - [categories/Graph.v](CategoryTheory/categories/Graph.v)
   - [GrothendieckTopos.v](CategoryTheory/GrothendieckTopos.v)
   - [Presheaf.v](CategoryTheory/Presheaf.v)
   - [ElementsOp.v](CategoryTheory/ElementsOp.v)
   - [elems_slice_equiv.v](CategoryTheory/elems_slice_equiv.v)
   - [YonedaBinproducts.v](CategoryTheory/YonedaBinproducts.v)
   - [ExponentiationLeftAdjoint.v](CategoryTheory/ExponentiationLeftAdjoint.v)
   - [categories/CartesianCubicalSets.v](CategoryTheory/categories/CartesianCubicalSets.v)
   - [Chains/Chains.v](CategoryTheory/Chains/Chains.v)
   - [Chains/Cochains.v](CategoryTheory/Chains/Cochains.v)
   - [Chains/Adamek.v](CategoryTheory/Chains/Adamek.v)
   - [Chains/OmegaCocontFunctors.v](CategoryTheory/Chains/OmegaCocontFunctors.v)
   - [Chains/All.v](CategoryTheory/Chains/All.v)
   - [Inductives/Lists.v](CategoryTheory/Inductives/Lists.v)
   - [Inductives/Trees.v](CategoryTheory/Inductives/Trees.v)
   - [Inductives/LambdaCalculus.v](CategoryTheory/Inductives/LambdaCalculus.v)
   - [Inductives/PropositionalLogic.v](CategoryTheory/Inductives/PropositionalLogic.v)
   - [DisplayedCats/Auxiliary.v](CategoryTheory/DisplayedCats/Auxiliary.v)
   - [DisplayedCats/Core.v](CategoryTheory/DisplayedCats/Core.v)
   - [DisplayedCats/Isos.v](CategoryTheory/DisplayedCats/Isos.v)
   - [DisplayedCats/Functors.v](CategoryTheory/DisplayedCats/Functors.v)
   - [DisplayedCats/NaturalTransformations.v](CategoryTheory/DisplayedCats/NaturalTransformations.v)
   - [DisplayedCats/Univalence.v](CategoryTheory/DisplayedCats/Univalence.v)
   - [DisplayedCats/Total.v](CategoryTheory/DisplayedCats/Total.v)
   - [DisplayedCats/Fiber.v](CategoryTheory/DisplayedCats/Fiber.v)
   - [DisplayedCats/Examples/Opposite.v](CategoryTheory/DisplayedCats/Examples/Opposite.v)
   - [DisplayedCats/Fibrations.v](CategoryTheory/DisplayedCats/Fibrations.v)
   - [DisplayedCats/Examples/Reindexing.v](CategoryTheory/DisplayedCats/Examples/Reindexing.v)
   - [DisplayedCats/Constructions.v](CategoryTheory/DisplayedCats/Constructions.v)
   - [DisplayedCats/Equivalences.v](CategoryTheory/DisplayedCats/Equivalences.v)
   - [DisplayedCats/Codomain.v](CategoryTheory/DisplayedCats/Codomain.v)
   - [DisplayedCats/Projection.v](CategoryTheory/DisplayedCats/Projection.v)
   - [DisplayedCats/SIP.v](CategoryTheory/DisplayedCats/SIP.v)
   - [DisplayedCats/Limits.v](CategoryTheory/DisplayedCats/Limits.v)
   - [DisplayedCats/Examples.v](CategoryTheory/DisplayedCats/Examples.v)
   - [DisplayedCats/Examples/UnitalBinop.v](CategoryTheory/DisplayedCats/Examples/UnitalBinop.v)
   - [DisplayedCats/FunctorCategory.v](CategoryTheory/DisplayedCats/FunctorCategory.v)
   - [DisplayedCats/Adjunctions.v](CategoryTheory/DisplayedCats/Adjunctions.v)
   - [DisplayedCats/ComprehensionC.v](CategoryTheory/DisplayedCats/ComprehensionC.v)
   - [DisplayedCats/StreetFibration.v](CategoryTheory/DisplayedCats/StreetFibration.v)
   - [IsoCommaCategory.v](CategoryTheory/IsoCommaCategory.v)
   - [categories/Universal_Algebra/Algebras.v](CategoryTheory/categories/Universal_Algebra/Algebras.v)
   - [categories/Universal_Algebra/EqAlgebras.v](CategoryTheory/categories/Universal_Algebra/EqAlgebras.v)
   - [Monoidal/MonoidalCategories.v](CategoryTheory/Monoidal/MonoidalCategories.v)
   - [Monoidal/MonoidalFunctors.v](CategoryTheory/Monoidal/MonoidalFunctors.v)
   - [Monoidal/AugmentedSimplexCategory.v](CategoryTheory/Monoidal/AugmentedSimplexCategory.v)
   - [Monoidal/DisplayedMonoidal.v](CategoryTheory/Monoidal/DisplayedMonoidal.v)
   - [Monoidal/CategoriesOfMonoids.v](CategoryTheory/Monoidal/CategoriesOfMonoids.v)
   - [Monoidal/BraidedMonoidalCategories.v](CategoryTheory/Monoidal/BraidedMonoidalCategories.v)
   - [SkewMonoidal/SkewMonoidalCategories.v](CategoryTheory/SkewMonoidal/SkewMonoidalCategories.v)
   - [SkewMonoidal/CategoriesOfMonoids.v](CategoryTheory/SkewMonoidal/CategoriesOfMonoids.v)
   - [Enriched/Enriched.v](CategoryTheory/Enriched/Enriched.v)
   - [RepresentableFunctors/Precategories.v](CategoryTheory/RepresentableFunctors/Precategories.v)
   - [RepresentableFunctors/Bifunctor.v](CategoryTheory/RepresentableFunctors/Bifunctor.v)
   - [RepresentableFunctors/Representation.v](CategoryTheory/RepresentableFunctors/Representation.v)
   - [RepresentableFunctors/RawMatrix.v](CategoryTheory/RepresentableFunctors/RawMatrix.v)
   - [RepresentableFunctors/DirectSum.v](CategoryTheory/RepresentableFunctors/DirectSum.v)
   - [RepresentableFunctors/Test.v](CategoryTheory/RepresentableFunctors/Test.v)
   - [All.v](CategoryTheory/All.v)
## Package [Bicategories](Bicategories/README.md)
   - [Core/Bicat.v](Bicategories/Core/Bicat.v)
   - [Core/Invertible_2cells.v](Bicategories/Core/Invertible_2cells.v)
   - [Core/Adjunctions.v](Bicategories/Core/Adjunctions.v)
   - [Core/Examples/OpMorBicat.v](Bicategories/Core/Examples/OpMorBicat.v)
   - [Core/Examples/OpCellBicat.v](Bicategories/Core/Examples/OpCellBicat.v)
   - [Core/Unitors.v](Bicategories/Core/Unitors.v)
   - [Core/BicategoryLaws.v](Bicategories/Core/BicategoryLaws.v)
   - [Core/Univalence.v](Bicategories/Core/Univalence.v)
   - [Core/TransportLaws.v](Bicategories/Core/TransportLaws.v)
   - [Core/EquivToAdjequiv.v](Bicategories/Core/EquivToAdjequiv.v)
   - [Core/AdjointUnique.v](Bicategories/Core/AdjointUnique.v)
   - [Core/UnivalenceOp.v](Bicategories/Core/UnivalenceOp.v)
   - [Core/Examples/OneTypes.v](Bicategories/Core/Examples/OneTypes.v)
   - [Core/Examples/PointedOneTypesBicat.v](Bicategories/Core/Examples/PointedOneTypesBicat.v)
   - [Core/Examples/TwoType.v](Bicategories/Core/Examples/TwoType.v)
   - [Core/Examples/BicatOfUnivCats.v](Bicategories/Core/Examples/BicatOfUnivCats.v)
   - [Core/Examples/BicatOfCats.v](Bicategories/Core/Examples/BicatOfCats.v)
   - [Core/Strictness.v](Bicategories/Core/Strictness.v)
   - [Core/Examples/StrictCats.v](Bicategories/Core/Examples/StrictCats.v)
   - [Core/Examples/Initial.v](Bicategories/Core/Examples/Initial.v)
   - [Core/Examples/Final.v](Bicategories/Core/Examples/Final.v)
   - [Core/Examples/BicategoryFromMonoidal.v](Bicategories/Core/Examples/BicategoryFromMonoidal.v)
   - [Core/Examples/FibSlice.v](Bicategories/Core/Examples/FibSlice.v)
   - [Core/FullyFaithful.v](Bicategories/Core/FullyFaithful.v)
   - [DisplayedBicats/DispBicat.v](Bicategories/DisplayedBicats/DispBicat.v)
   - [DisplayedBicats/DispInvertibles.v](Bicategories/DisplayedBicats/DispInvertibles.v)
   - [DisplayedBicats/DispAdjunctions.v](Bicategories/DisplayedBicats/DispAdjunctions.v)
   - [DisplayedBicats/DispUnivalence.v](Bicategories/DisplayedBicats/DispUnivalence.v)
   - [DisplayedBicats/CleavingOfBicat.v](Bicategories/DisplayedBicats/CleavingOfBicat.v)
   - [DisplayedBicats/FiberCategory.v](Bicategories/DisplayedBicats/FiberCategory.v)
   - [DisplayedBicats/FiberBicategory/FiberBicategory1.v](Bicategories/DisplayedBicats/FiberBicategory/FiberBicategory1.v)
   - [DisplayedBicats/FiberBicategory/FiberBicategory2.v](Bicategories/DisplayedBicats/FiberBicategory/FiberBicategory2.v)
   - [DisplayedBicats/FiberBicategory.v](Bicategories/DisplayedBicats/FiberBicategory.v)
   - [DisplayedBicats/Examples/Sigma.v](Bicategories/DisplayedBicats/Examples/Sigma.v)
   - [DisplayedBicats/Examples/DisplayedCatToBicat.v](Bicategories/DisplayedBicats/Examples/DisplayedCatToBicat.v)
   - [DisplayedBicats/Examples/FullSub.v](Bicategories/DisplayedBicats/Examples/FullSub.v)
   - [DisplayedBicats/Examples/DispBicatOfDispCats.v](Bicategories/DisplayedBicats/Examples/DispBicatOfDispCats.v)
   - [DisplayedBicats/Examples/Slice.v](Bicategories/DisplayedBicats/Examples/Slice.v)
   - [DisplayedBicats/Examples/Sub1Cell.v](Bicategories/DisplayedBicats/Examples/Sub1Cell.v)
   - [DisplayedBicats/Examples/Prod.v](Bicategories/DisplayedBicats/Examples/Prod.v)
   - [DisplayedBicats/Examples/DispDepProd.v](Bicategories/DisplayedBicats/Examples/DispDepProd.v)
   - [DisplayedBicats/Examples/Trivial.v](Bicategories/DisplayedBicats/Examples/Trivial.v)
   - [MonoidalCategories/MonoidalFromBicategory.v](Bicategories/MonoidalCategories/MonoidalFromBicategory.v)
   - [MonoidalCategories/EndofunctorsMonoidal.v](Bicategories/MonoidalCategories/EndofunctorsMonoidal.v)
   - [MonoidalCategories/PointedFunctorsMonoidal.v](Bicategories/MonoidalCategories/PointedFunctorsMonoidal.v)
   - [MonoidalCategories/Actions.v](Bicategories/MonoidalCategories/Actions.v)
   - [MonoidalCategories/ConstructionOfActions.v](Bicategories/MonoidalCategories/ConstructionOfActions.v)
   - [MonoidalCategories/ActionBasedStrength.v](Bicategories/MonoidalCategories/ActionBasedStrength.v)
   - [MonoidalCategories/ActionBasedStrongFunctorsMonoidal.v](Bicategories/MonoidalCategories/ActionBasedStrongFunctorsMonoidal.v)
   - [MonoidalCategories/ActionOfEndomorphismsInBicat.v](Bicategories/MonoidalCategories/ActionOfEndomorphismsInBicat.v)
   - [MonoidalCategories/ActionBasedStrongFunctorCategory.v](Bicategories/MonoidalCategories/ActionBasedStrongFunctorCategory.v)
   - [MonoidalCategories/ActionsFormBicategory.v](Bicategories/MonoidalCategories/ActionsFormBicategory.v)
   - [Core/Examples/Groupoids.v](Bicategories/Core/Examples/Groupoids.v)
   - [PseudoFunctors/Display/Base.v](Bicategories/PseudoFunctors/Display/Base.v)
   - [PseudoFunctors/Display/Map1Cells.v](Bicategories/PseudoFunctors/Display/Map1Cells.v)
   - [PseudoFunctors/Display/Map2Cells.v](Bicategories/PseudoFunctors/Display/Map2Cells.v)
   - [PseudoFunctors/Display/Identitor.v](Bicategories/PseudoFunctors/Display/Identitor.v)
   - [PseudoFunctors/Display/Compositor.v](Bicategories/PseudoFunctors/Display/Compositor.v)
   - [PseudoFunctors/Display/PseudoFunctorBicat.v](Bicategories/PseudoFunctors/Display/PseudoFunctorBicat.v)
   - [PseudoFunctors/Display/StrictIdentitor.v](Bicategories/PseudoFunctors/Display/StrictIdentitor.v)
   - [PseudoFunctors/Display/StrictCompositor.v](Bicategories/PseudoFunctors/Display/StrictCompositor.v)
   - [PseudoFunctors/Display/StrictPseudoFunctorBicat.v](Bicategories/PseudoFunctors/Display/StrictPseudoFunctorBicat.v)
   - [PseudoFunctors/PseudoFunctor.v](Bicategories/PseudoFunctors/PseudoFunctor.v)
   - [PseudoFunctors/StrictPseudoFunctor.v](Bicategories/PseudoFunctors/StrictPseudoFunctor.v)
   - [PseudoFunctors/Examples/Identity.v](Bicategories/PseudoFunctors/Examples/Identity.v)
   - [PseudoFunctors/Examples/Composition.v](Bicategories/PseudoFunctors/Examples/Composition.v)
   - [PseudoFunctors/Examples/Constant.v](Bicategories/PseudoFunctors/Examples/Constant.v)
   - [PseudoFunctors/Examples/ApFunctor.v](Bicategories/PseudoFunctors/Examples/ApFunctor.v)
   - [PseudoFunctors/Examples/OpFunctor.v](Bicategories/PseudoFunctors/Examples/OpFunctor.v)
   - [PseudoFunctors/Examples/PseudofunctorFromMonoidal.v](Bicategories/PseudoFunctors/Examples/PseudofunctorFromMonoidal.v)
   - [Transformations/PseudoTransformation.v](Bicategories/Transformations/PseudoTransformation.v)
   - [Transformations/Examples/Whiskering.v](Bicategories/Transformations/Examples/Whiskering.v)
   - [Transformations/Examples/Unitality.v](Bicategories/Transformations/Examples/Unitality.v)
   - [Transformations/Examples/Associativity.v](Bicategories/Transformations/Examples/Associativity.v)
   - [Transformations/Examples/ApTransformation.v](Bicategories/Transformations/Examples/ApTransformation.v)
   - [Modifications/Modification.v](Bicategories/Modifications/Modification.v)
   - [Modifications/Examples/ApModification.v](Bicategories/Modifications/Examples/ApModification.v)
   - [Modifications/Examples/Unitality.v](Bicategories/Modifications/Examples/Unitality.v)
   - [Modifications/Examples/Associativity.v](Bicategories/Modifications/Examples/Associativity.v)
   - [PseudoFunctors/Representable.v](Bicategories/PseudoFunctors/Representable.v)
   - [PseudoFunctors/Yoneda.v](Bicategories/PseudoFunctors/Yoneda.v)
   - [PseudoFunctors/Biequivalence.v](Bicategories/PseudoFunctors/Biequivalence.v)
   - [PseudoFunctors/Examples/StrictToPseudo.v](Bicategories/PseudoFunctors/Examples/StrictToPseudo.v)
   - [PseudoFunctors/Examples/Projection.v](Bicategories/PseudoFunctors/Examples/Projection.v)
   - [DisplayedBicats/Examples/PointedOneTypes.v](Bicategories/DisplayedBicats/Examples/PointedOneTypes.v)
   - [DisplayedBicats/Examples/DisplayedInserter.v](Bicategories/DisplayedBicats/Examples/DisplayedInserter.v)
   - [DisplayedBicats/Examples/Displayed2Inserter.v](Bicategories/DisplayedBicats/Examples/Displayed2Inserter.v)
   - [DisplayedBicats/Examples/Algebras.v](Bicategories/DisplayedBicats/Examples/Algebras.v)
   - [DisplayedBicats/Examples/Add2Cell.v](Bicategories/DisplayedBicats/Examples/Add2Cell.v)
   - [DisplayedBicats/Examples/ContravariantFunctor.v](Bicategories/DisplayedBicats/Examples/ContravariantFunctor.v)
   - [DisplayedBicats/Examples/Cofunctormap.v](Bicategories/DisplayedBicats/Examples/Cofunctormap.v)
   - [DisplayedBicats/Examples/CwF.v](Bicategories/DisplayedBicats/Examples/CwF.v)
   - [DisplayedBicats/Examples/Domain.v](Bicategories/DisplayedBicats/Examples/Domain.v)
   - [DisplayedBicats/Examples/Codomain.v](Bicategories/DisplayedBicats/Examples/Codomain.v)
   - [DisplayedBicats/DispPseudofunctor.v](Bicategories/DisplayedBicats/DispPseudofunctor.v)
   - [Transformations/Examples/AlgebraMap.v](Bicategories/Transformations/Examples/AlgebraMap.v)
   - [DisplayedBicats/Examples/Monads.v](Bicategories/DisplayedBicats/Examples/Monads.v)
   - [DisplayedBicats/Examples/KleisliTriple.v](Bicategories/DisplayedBicats/Examples/KleisliTriple.v)
   - [DisplayedBicats/DispTransformation.v](Bicategories/DisplayedBicats/DispTransformation.v)
   - [DisplayedBicats/DispModification.v](Bicategories/DisplayedBicats/DispModification.v)
   - [DisplayedBicats/DispBiequivalence.v](Bicategories/DisplayedBicats/DispBiequivalence.v)
   - [Core/Examples/Image.v](Bicategories/Core/Examples/Image.v)
   - [PseudoFunctors/Examples/CorestrictImage.v](Bicategories/PseudoFunctors/Examples/CorestrictImage.v)
   - [Core/YonedaLemma.v](Bicategories/Core/YonedaLemma.v)
   - [Colimits/Initial.v](Bicategories/Colimits/Initial.v)
   - [Colimits/Final.v](Bicategories/Colimits/Final.v)
   - [Colimits/Products.v](Bicategories/Colimits/Products.v)
   - [Colimits/Pullback.v](Bicategories/Colimits/Pullback.v)
   - [Colimits/PullbackFunctions.v](Bicategories/Colimits/PullbackFunctions.v)
   - [PseudoFunctors/Biadjunction.v](Bicategories/PseudoFunctors/Biadjunction.v)
   - [PseudoFunctors/Examples/CurryingInBicatOfCats.v](Bicategories/PseudoFunctors/Examples/CurryingInBicatOfCats.v)
   - [PseudoFunctors/PseudoFunctorLimits.v](Bicategories/PseudoFunctors/PseudoFunctorLimits.v)
   - [DisplayedBicats/DispBiadjunction.v](Bicategories/DisplayedBicats/DispBiadjunction.v)
   - [PseudoFunctors/Examples/PathGroupoid.v](Bicategories/PseudoFunctors/Examples/PathGroupoid.v)
   - [DisplayedBicats/DispToFiberEquivalence.v](Bicategories/DisplayedBicats/DispToFiberEquivalence.v)
   - [DisplayedBicats/DispBuilders.v](Bicategories/DisplayedBicats/DispBuilders.v)
   - [DisplayedBicats/Examples/MonadKtripleBiequiv.v](Bicategories/DisplayedBicats/Examples/MonadKtripleBiequiv.v)
   - [DisplayedBicats/Examples/PointedGroupoid.v](Bicategories/DisplayedBicats/Examples/PointedGroupoid.v)
   - [WkCatEnrichment/prebicategory.v](Bicategories/WkCatEnrichment/prebicategory.v)
   - [WkCatEnrichment/Notations.v](Bicategories/WkCatEnrichment/Notations.v)
   - [WkCatEnrichment/whiskering.v](Bicategories/WkCatEnrichment/whiskering.v)
   - [WkCatEnrichment/Cat.v](Bicategories/WkCatEnrichment/Cat.v)
   - [WkCatEnrichment/internal_equivalence.v](Bicategories/WkCatEnrichment/internal_equivalence.v)
   - [WkCatEnrichment/bicategory.v](Bicategories/WkCatEnrichment/bicategory.v)
   - [WkCatEnrichment/hcomp_bicat.v](Bicategories/WkCatEnrichment/hcomp_bicat.v)
   - [PseudoFunctors/Examples/Strictify.v](Bicategories/PseudoFunctors/Examples/Strictify.v)
   - [Discreteness.v](Bicategories/Discreteness.v)
   - [BicategoryOfBicat.v](Bicategories/BicategoryOfBicat.v)
   - [BicatOfBicategory.v](Bicategories/BicatOfBicategory.v)
   - [Core/InternalStreetFibration.v](Bicategories/Core/InternalStreetFibration.v)
   - [Core/InternalStreetOpFibration.v](Bicategories/Core/InternalStreetOpFibration.v)
   - [DisplayedBicats/Cartesians.v](Bicategories/DisplayedBicats/Cartesians.v)
   - [DisplayedBicats/EquivalenceBetweenCartesians.v](Bicategories/DisplayedBicats/EquivalenceBetweenCartesians.v)
   - [DisplayedBicats/CartesianPseudoFunctor.v](Bicategories/DisplayedBicats/CartesianPseudoFunctor.v)
   - [DisplayedBicats/ExamplesOfCleavings/TrivialCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/TrivialCleaving.v)
   - [DisplayedBicats/ExamplesOfCleavings/DomainCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/DomainCleaving.v)
   - [DisplayedBicats/ExamplesOfCleavings/CodomainCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/CodomainCleaving.v)
   - [DisplayedBicats/ExamplesOfCleavings/FibrationCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/FibrationCleaving.v)
   - [DisplayedBicats/ExamplesOfCleavings/OpFibrationCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/OpFibrationCleaving.v)
   - [PseudoFunctors/Examples/Reindexing.v](Bicategories/PseudoFunctors/Examples/Reindexing.v)
   - [DisplayMapBicat.v](Bicategories/DisplayMapBicat.v)
   - [DisplayedBicats/Examples/DisplayMapBicatToDispBicat.v](Bicategories/DisplayedBicats/Examples/DisplayMapBicatToDispBicat.v)
   - [DisplayedBicats/Examples/DisplayMapBicatSlice.v](Bicategories/DisplayedBicats/Examples/DisplayMapBicatSlice.v)
   - [DisplayedBicats/ExamplesOfCleavings/DisplayMapBicatCleaving.v](Bicategories/DisplayedBicats/ExamplesOfCleavings/DisplayMapBicatCleaving.v)
   - [PseudoFunctors/Examples/PullbackFunctor.v](Bicategories/PseudoFunctors/Examples/PullbackFunctor.v)
   - [DisplayedBicats/FiberBicategory/TrivialFiber.v](Bicategories/DisplayedBicats/FiberBicategory/TrivialFiber.v)
   - [DisplayedBicats/FiberBicategory/CodomainFiber.v](Bicategories/DisplayedBicats/FiberBicategory/CodomainFiber.v)
   - [DisplayedBicats/FiberBicategory/DisplayMapFiber.v](Bicategories/DisplayedBicats/FiberBicategory/DisplayMapFiber.v)
   - [ComprehensionBicat.v](Bicategories/ComprehensionBicat.v)
   - [All.v](Bicategories/All.v)
## Package [Ktheory](Ktheory/README.md)
   - [GrothendieckGroup.v](Ktheory/GrothendieckGroup.v)
   - [All.v](Ktheory/All.v)
## Package Topology
   - [Prelim.v](Topology/Prelim.v)
   - [Filters.v](Topology/Filters.v)
   - [Topology.v](Topology/Topology.v)
   - [CategoryTop.v](Topology/CategoryTop.v)
   - [All.v](Topology/All.v)
## Package [RealNumbers](RealNumbers/README.md)
   - [Prelim.v](RealNumbers/Prelim.v)
   - [Fields.v](RealNumbers/Fields.v)
   - [Sets.v](RealNumbers/Sets.v)
   - [NonnegativeRationals.v](RealNumbers/NonnegativeRationals.v)
   - [NonnegativeReals.v](RealNumbers/NonnegativeReals.v)
   - [Reals.v](RealNumbers/Reals.v)
   - [DedekindCuts.v](RealNumbers/DedekindCuts.v)
   - [DecidableDedekindCuts.v](RealNumbers/DecidableDedekindCuts.v)
   - [All.v](RealNumbers/All.v)
## Package Tactics
   - [Utilities.v](Tactics/Utilities.v)
   - [Monoids_Tactics.v](Tactics/Monoids_Tactics.v)
   - [Abmonoids_Tactics.v](Tactics/Abmonoids_Tactics.v)
   - [Groups_Tactics.v](Tactics/Groups_Tactics.v)
   - [Nat_Tactics.v](Tactics/Nat_Tactics.v)
   - [All.v](Tactics/All.v)
## Package [SubstitutionSystems](SubstitutionSystems/README.md)
   - [Notation.v](SubstitutionSystems/Notation.v)
   - [Signatures.v](SubstitutionSystems/Signatures.v)
   - [BinSumOfSignatures.v](SubstitutionSystems/BinSumOfSignatures.v)
   - [SumOfSignatures.v](SubstitutionSystems/SumOfSignatures.v)
   - [BinProductOfSignatures.v](SubstitutionSystems/BinProductOfSignatures.v)
   - [SubstitutionSystems.v](SubstitutionSystems/SubstitutionSystems.v)
   - [MonadsFromSubstitutionSystems.v](SubstitutionSystems/MonadsFromSubstitutionSystems.v)
   - [GenMendlerIteration.v](SubstitutionSystems/GenMendlerIteration.v)
   - [GenMendlerIteration_alt.v](SubstitutionSystems/GenMendlerIteration_alt.v)
   - [LiftingInitial.v](SubstitutionSystems/LiftingInitial.v)
   - [LiftingInitial_alt.v](SubstitutionSystems/LiftingInitial_alt.v)
   - [ModulesFromSignatures.v](SubstitutionSystems/ModulesFromSignatures.v)
   - [LamSignature.v](SubstitutionSystems/LamSignature.v)
   - [Lam.v](SubstitutionSystems/Lam.v)
   - [SignatureExamples.v](SubstitutionSystems/SignatureExamples.v)
   - [SignatureCategory.v](SubstitutionSystems/SignatureCategory.v)
   - [SubstitutionSystems_Summary.v](SubstitutionSystems/SubstitutionSystems_Summary.v)
   - [LamHSET.v](SubstitutionSystems/LamHSET.v)
   - [BindingSigToMonad.v](SubstitutionSystems/BindingSigToMonad.v)
   - [LamFromBindingSig.v](SubstitutionSystems/LamFromBindingSig.v)
   - [MLTT79.v](SubstitutionSystems/MLTT79.v)
   - [FromBindingSigsToMonads_Summary.v](SubstitutionSystems/FromBindingSigsToMonads_Summary.v)
   - [MonadsMultiSorted.v](SubstitutionSystems/MonadsMultiSorted.v)
   - [MonadsMultiSorted_alt.v](SubstitutionSystems/MonadsMultiSorted_alt.v)
   - [MultiSorted.v](SubstitutionSystems/MultiSorted.v)
   - [MultiSorted_alt.v](SubstitutionSystems/MultiSorted_alt.v)
   - [MonadicSubstitution_alt.v](SubstitutionSystems/MonadicSubstitution_alt.v)
   - [STLC.v](SubstitutionSystems/STLC.v)
   - [STLC_alt.v](SubstitutionSystems/STLC_alt.v)
   - [CCS.v](SubstitutionSystems/CCS.v)
   - [CCS_alt.v](SubstitutionSystems/CCS_alt.v)
   - [PCF_alt.v](SubstitutionSystems/PCF_alt.v)
   - [ActionBasedStrengthOnHomsInBicat.v](SubstitutionSystems/ActionBasedStrengthOnHomsInBicat.v)
   - [All.v](SubstitutionSystems/All.v)
## Package [Folds](Folds/README.md)
   - [UnicodeNotations.v](Folds/UnicodeNotations.v)
   - [aux_lemmas.v](Folds/aux_lemmas.v)
   - [folds_precat.v](Folds/folds_precat.v)
   - [from_precats_to_folds_and_back.v](Folds/from_precats_to_folds_and_back.v)
   - [folds_isomorphism.v](Folds/folds_isomorphism.v)
   - [folds_pre_2_cat.v](Folds/folds_pre_2_cat.v)
   - [All.v](Folds/All.v)
## Package [HomologicalAlgebra](HomologicalAlgebra/README.md)
   - [Triangulated.v](HomologicalAlgebra/Triangulated.v)
   - [Complexes.v](HomologicalAlgebra/Complexes.v)
   - [KA.v](HomologicalAlgebra/KA.v)
   - [TranslationFunctors.v](HomologicalAlgebra/TranslationFunctors.v)
   - [MappingCone.v](HomologicalAlgebra/MappingCone.v)
   - [MappingCylinder.v](HomologicalAlgebra/MappingCylinder.v)
   - [KAPreTriangulated.v](HomologicalAlgebra/KAPreTriangulated.v)
   - [KATriangulated.v](HomologicalAlgebra/KATriangulated.v)
   - [CohomologyComplex.v](HomologicalAlgebra/CohomologyComplex.v)
   - [All.v](HomologicalAlgebra/All.v)
## Package [AlgebraicGeometry](AlgebraicGeometry/README.md)
   - [Topology.v](AlgebraicGeometry/Topology.v)
   - [SheavesOfRings.v](AlgebraicGeometry/SheavesOfRings.v)
   - [Spec.v](AlgebraicGeometry/Spec.v)
   - [All.v](AlgebraicGeometry/All.v)
## Package [Paradoxes](Paradoxes/README.md)
   - [GirardsParadox.v](Paradoxes/GirardsParadox.v)
   - [All.v](Paradoxes/All.v)
## Package [Induction](Induction/README.md)
   - [PolynomialFunctors.v](Induction/PolynomialFunctors.v)
   - [ImpredicativeInductiveSets.v](Induction/ImpredicativeInductiveSets.v)
   - [M/Core.v](Induction/M/Core.v)
   - [M/Limits.v](Induction/M/Limits.v)
   - [M/Uniqueness.v](Induction/M/Uniqueness.v)
   - [W/Core.v](Induction/W/Core.v)
   - [W/Fibered.v](Induction/W/Fibered.v)
   - [W/Naturals.v](Induction/W/Naturals.v)
   - [W/Uniqueness.v](Induction/W/Uniqueness.v)
   - [M/Chains.v](Induction/M/Chains.v)
   - [M/ComputationalM.v](Induction/M/ComputationalM.v)
   - [All.v](Induction/All.v)
