(* Generates a branch of the correctness proof for comparison functions
   generated by derive.eq.

   license: GNU Lesser General Public License Version 2.1 or later           
   ------------------------------------------------------------------------- *)
From elpi Require Export elpi.
From elpi.apps Require Export derive.bcongr derive.eq derive.isK.

Definition eq_axiom T eqb :=
  forall (x y : T), Bool.Bool.reflect (x = y) (eqb x y).

Definition eq_axiom_at T eqb (x : T) :=
  forall y, Bool.Bool.reflect (x = y) (eqb x y).

Definition eq_axiom_on T eqb (x y : T) :=
  Bool.Bool.reflect (x = y) (eqb x y).

Register eq_axiom    as elpi.derive.eq_axiom.
Register eq_axiom_at as elpi.derive.eq_axiom_at.
Register eq_axiom_on as elpi.derive.eq_axiom_on.

Lemma bool_discr : true = false -> forall T : Type, T.
Proof.
exact (fun h T =>
  eq_rect true (fun x => match x with false => T | _ => True end) I false h).
Qed.

Register bool_discr as elpi.bool_discr.

Elpi Db derive.eqK.db lp:{{

type eqK-db constructor -> term -> prop.

:name "eqK-db:fail"
eqK-db K _ :-
  M is "derive.eqK: can't find the eq.axiom for constructor " ^ {std.any->string K},
  stop M.

}}.

Elpi Command derive.eqK.
Elpi Accumulate Db derive.isK.db.
Elpi Accumulate File "elpi/discriminate.elpi".
Elpi Accumulate Db derive.bcongr.db.
Elpi Accumulate Db derive.eq.db.
Elpi Accumulate Db derive.eqK.db.
Elpi Accumulate File "elpi/eqK.elpi".
Elpi Accumulate lp:{{
  main [str I, str Prefix] :- !, coq.locate I (indt GR), derive.eqK.main GR Prefix _.
  main [str I] :- !, coq.locate I (indt GR), derive.eqK.main GR "eq_axiom_" _.
  main _ :- usage.

  usage :- coq.error "Usage: derive.eqK <inductive type name> [<prefix>]".
}}.
Elpi Typecheck.


