#!/usr/bin/env bash

set -e -x

WHEELHOUSE="$HOME/.wheelhouse"

function pip_with_cache() {
    # Pre-cache all dependencies as wheels in the cache dir
    pip wheel \
        --use-wheel \
        --wheel-dir="$WHEELHOUSE" \
        --find-links="file://$WHEELHOUSE" \
        "$@"

    # Install from the wheelhouse
    sudo pip install \
        --use-wheel \
        --find-links="file://$WHEELHOUSE" \
        "$@"
}

brew install qt5
sudo pip install --upgrade pip
sudo pip install wheel
pip_with_cache \
    dmgbuild \
    'pyobjc-framework-Quartz' \
    'pyobjc-framework-Cocoa'
