/*
    Copyright (c) 2017, Lukas Holecek <hluk@email.cz>

    This file is part of CopyQ.

    CopyQ is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CopyQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CopyQ.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "gui/configtabshortcuts.h"
#include "ui_configtabshortcuts.h"

#include "common/client_server.h"
#include "common/common.h"
#include "gui/iconfactory.h"
#include "gui/icons.h"

ConfigTabShortcuts::ConfigTabShortcuts(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::ConfigTabShortcuts)
{
    ui->setupUi(this);

    connect( ui->pushButtonOpenCommandDialog, SIGNAL(clicked()),
             this, SIGNAL(openCommandDialogRequest()) );
}

ConfigTabShortcuts::~ConfigTabShortcuts()
{
    delete ui;
}

void ConfigTabShortcuts::loadShortcuts(const QSettings &settings)
{
    ui->shortcutsWidgetGeneral->loadShortcuts(settings);

    const QIcon iconCommandDialog = getIcon("system-run", IconCog);
    ui->pushButtonOpenCommandDialog->setIcon(iconCommandDialog);
}

void ConfigTabShortcuts::saveShortcuts(QSettings *settings) const
{
    ui->shortcutsWidgetGeneral->saveShortcuts(settings);
}
