#!/usr/bin/env python
#
#   ConVirt   -  Copyright (c) 2008 Convirture Corp
#   ======
#
# ConVirt is a Xen management tool with a GTK based graphical interface
# that allows for performing the standard set of domain operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify certain aspects such as the creation of
# domains, as well as making the consoles available directly within the
# tool's user interface.
#
#
# This software is subject to the GNU Lesser General Public License (LGPL)
# and for details, please consult it at:
#
#    http://www.fsf.org/licensing/licenses/lgpl.txt
#

from ManagedNode import ManagedNode

class ServerGroup:
    def __init__(self, name, node_list = None):
        self.name = name
        self.n_list = {}   # dict()

        self.alloc_policy = SimpleAllocationPolicy(self) #TBD: parametrise!
        
        if node_list is not None:
            self.n_list = node_list


    def getNodeNames(self):
        return self.n_list.keys()
    
    def getNodeList(self):
        return self.n_list

    def getNode(self,name):
        return self.n_list.get(name)

    def getAllocationCandidate(self):
        return self.alloc_policy.getNext()

    # note does not update the store. Should not be called by client.
    def _addNode(self, node):
        if self.n_list.get(node.hostname) is None:
            self.n_list[node.hostname] = node
        else:
            raise Exception("Node %s already exists." %
                            (node.hostname,))


    def _removeNode(self, name):
        if name in self.getNodeNames():
            del self.n_list[name]
                    
    def __str__(self):
        return  self.name + "||" + str(self.n_list.keys())
        

class SimpleAllocationPolicy:
    """
    Policy for determining the best provisioning candidate
    amongst a group's members. A candidate is selected if
    it has the minimum:
        1. VM CPU utilisation
        2. VM Mem allocation
        3. number of VM's configured        
    in that order.
    """
    def __init__(self, group = None):
        self._group = group

    def setGroup(self, group):
        self._group = group

    def getNext(self):
        list = [(self._group.getNode(n).get_metrics()['VM_TOTAL_CPU(%)'],
                 self._group.getNode(n).get_metrics()['VM_TOTAL_MEM(%)'],
                 self._group.getNode(n).get_VM_count(),
                 self._group.getNode(n).hostname) \
                for n in self._group.getNodeNames()]
        if len(list) == 0:
            return None
        else:
            return self._group.getNode(min(list)[3])

        
    
