if not modules then modules = { } end modules ['char-def'] = {
    version   = 1.001,
    comment   = "companion to char-ini.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "PRAGMA ADE / ConTeXt Development Team",
    license   = "see context related readme files"
}

--[[
The first version of this table was generated from unicode tables
but after that was mostly updated manual using data present in
ConTeXt and elsewhere. I did my best to make this table as complete
as needed for proper use in ConTeXt MkIV. All errors are mine. If
you find an error or ommision, just let me know.
]]--

characters = characters or { }

characters.data={
 [0x0000]={
  category="cc",
  description="NULL",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0000,
 },
 {
  adobename="controlSTX",
  category="cc",
  description="START OF HEADING",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0001,
 },
 {
  adobename="controlSOT",
  category="cc",
  description="START OF TEXT",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0002,
 },
 {
  adobename="controlETX",
  category="cc",
  description="END OF TEXT",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0003,
 },
 {
  adobename="controlEOT",
  category="cc",
  description="END OF TRANSMISSION",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0004,
 },
 {
  adobename="controlENQ",
  category="cc",
  description="ENQUIRY",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0005,
 },
 {
  adobename="controlACK",
  category="cc",
  description="ACKNOWLEDGE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0006,
 },
 {
  adobename="controlBEL",
  category="cc",
  description="BELL",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0007,
 },
 {
  adobename="controlBS",
  category="cc",
  description="BACKSPACE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0008,
 },
 {
  adobename="controlHT",
  category="cc",
  description="CHARACTER TABULATION",
  direction="s",
  linebreak="ba",
  unicodeslot=0x0009,
 },
 {
  adobename="controlLF",
  category="cc",
  description="LINE FEED (LF)",
  direction="b",
  linebreak="lf",
  unicodeslot=0x000A,
 },
 {
  adobename="controlVT",
  category="cc",
  description="LINE TABULATION",
  direction="s",
  linebreak="bk",
  unicodeslot=0x000B,
 },
 {
  adobename="controlFF",
  category="cc",
  description="FORM FEED (FF)",
  direction="ws",
  linebreak="bk",
  unicodeslot=0x000C,
 },
 {
  adobename="controlCR",
  category="cc",
  description="CARRIAGE RETURN (CR)",
  direction="b",
  linebreak="cr",
  unicodeslot=0x000D,
 },
 {
  adobename="controlSO",
  category="cc",
  description="SHIFT OUT",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x000E,
 },
 {
  adobename="controlSI",
  category="cc",
  description="SHIFT IN",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x000F,
 },
 {
  adobename="controlDLE",
  category="cc",
  description="DATA LINK ESCAPE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0010,
 },
 {
  adobename="controlDC1",
  category="cc",
  description="DEVICE CONTROL ONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0011,
 },
 {
  adobename="controlDC2",
  category="cc",
  description="DEVICE CONTROL TWO",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0012,
 },
 {
  adobename="controlDC3",
  category="cc",
  description="DEVICE CONTROL THREE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0013,
 },
 {
  adobename="controlDC4",
  category="cc",
  description="DEVICE CONTROL FOUR",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0014,
 },
 {
  adobename="controlNAK",
  category="cc",
  description="NEGATIVE ACKNOWLEDGE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0015,
 },
 {
  adobename="controlSYN",
  category="cc",
  description="SYNCHRONOUS IDLE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0016,
 },
 {
  adobename="controlETB",
  category="cc",
  description="END OF TRANSMISSION BLOCK",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0017,
 },
 {
  adobename="controlCAN",
  category="cc",
  description="CANCEL",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0018,
 },
 {
  adobename="controlEM",
  category="cc",
  description="END OF MEDIUM",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0019,
 },
 {
  adobename="controlSUB",
  category="cc",
  description="SUBSTITUTE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x001A,
 },
 {
  adobename="controlESC",
  category="cc",
  description="ESCAPE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x001B,
 },
 {
  adobename="controlFS",
  category="cc",
  description="INFORMATION SEPARATOR FOUR",
  direction="b",
  linebreak="cm",
  unicodeslot=0x001C,
 },
 {
  adobename="controlGS",
  category="cc",
  description="INFORMATION SEPARATOR THREE",
  direction="b",
  linebreak="cm",
  unicodeslot=0x001D,
 },
 {
  adobename="controlRS",
  category="cc",
  description="INFORMATION SEPARATOR TWO",
  direction="b",
  linebreak="cm",
  unicodeslot=0x001E,
 },
 {
  adobename="controlUS",
  category="cc",
  description="INFORMATION SEPARATOR ONE",
  direction="s",
  linebreak="cm",
  unicodeslot=0x001F,
 },
 {
  adobename="space",
  category="zs",
  cjkwd="na",
  description="SPACE",
  direction="ws",
  linebreak="sp",
  unicodeslot=0x0020,
 },
 {
  adobename="exclam",
  category="po",
  cjkwd="na",
  description="EXCLAMATION MARK",
  direction="on",
  linebreak="ex",
  mathclass="close",
  unicodeslot=0x0021,
 },
 {
  adobename="quotedbl",
  category="po",
  cjkwd="na",
  contextname="quotedbl",
  description="QUOTATION MARK",
  direction="on",
  linebreak="qu",
  mathclass="default",
  unicodeslot=0x0022,
 },
 {
  adobename="numbersign",
  category="po",
  cjkwd="na",
  description="NUMBER SIGN",
  direction="et",
  linebreak="al",
  unicodeslot=0x0023,
 },
 {
  adobename="dollar",
  category="sc",
  cjkwd="na",
  contextname="textdollar",
  description="DOLLAR SIGN",
  direction="et",
  linebreak="pr",
  unicodeslot=0x0024,
 },
 {
  adobename="percent",
  category="po",
  cjkwd="na",
  contextname="percent",
  description="PERCENT SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x0025,
 },
 {
  adobename="ampersand",
  category="po",
  cjkwd="na",
  description="AMPERSAND",
  direction="on",
  linebreak="al",
  unicodeslot=0x0026,
 },
 {
  adobename="quotesingle",
  category="po",
  cjkwd="na",
  contextname="quotesingle",
  description="APOSTROPHE",
  direction="on",
  linebreak="qu",
  mathclass="default",
  unicodeslot=0x0027,
 },
 {
  adobename="parenleft",
  category="ps",
  cjkwd="na",
  description="LEFT PARENTHESIS",
  direction="on",
  linebreak="op",
  mathclass="open",
  mathname="lparent",
  mirror=0x0029,
  unicodeslot=0x0028,
 },
 {
  adobename="parenright",
  category="pe",
  cjkwd="na",
  description="RIGHT PARENTHESIS",
  direction="on",
  linebreak="cp",
  mathclass="close",
  mathname="rparent",
  mirror=0x0028,
  unicodeslot=0x0029,
 },
 {
  adobename="asterisk",
  category="po",
  cjkwd="na",
  description="ASTERISK",
  direction="on",
  linebreak="al",
  mathclass="binary",
  mathname="ast",
  mathsymbol=0x2217,
  unicodeslot=0x002A,
 },
 {
  adobename="plus",
  category="sm",
  cjkwd="na",
  description="PLUS SIGN",
  direction="es",
  linebreak="pr",
  mathclass="binary",
  unicodeslot=0x002B,
 },
 {
  adobename="comma",
  category="po",
  cjkwd="na",
  contextname="textcomma",
  description="COMMA",
  direction="cs",
  linebreak="is",
  mathclass="punctuation",
--mathspec={
-- {
--  class="punctuation",
-- },
-- {
--  class="ord",
--  name="mathcomma",
-- },
--},
  unicodeslot=0x002C,
 },
 {
  adobename="hyphen",
  category="pd",
  cjkwd="na",
  description="HYPHEN-MINUS",
  direction="es",
  linebreak="hy",
  mathsymbol=0x2212,
  unicodeslot=0x002D,
 },
 {
  adobename="period",
  category="po",
  cjkwd="na",
  contextname="textperiod",
  description="FULL STOP",
  direction="cs",
  linebreak="is",
  mathclass="ord",
  mathspec={
-- {
--  class="ord",
-- },
-- {
--  class="punctuation",
-- },
   {
    class="punctuation",
    name="ldotp",
   },
  },
  unicodeslot=0x002E,
 },
 {
  adobename="slash",
  category="po",
  cjkwd="na",
  contextname="textslash",
  description="SOLIDUS",
  direction="cs",
  linebreak="sy",
  mathclass="ord",
  mathsymbol=0x2044,
  unicodeslot=0x002F,
 },
 {
  adobename="zero",
  category="nd",
  cjkwd="na",
  description="DIGIT ZERO",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0030,
 },
 {
  adobename="one",
  category="nd",
  cjkwd="na",
  description="DIGIT ONE",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0031,
 },
 {
  adobename="two",
  category="nd",
  cjkwd="na",
  description="DIGIT TWO",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0032,
 },
 {
  adobename="three",
  category="nd",
  cjkwd="na",
  description="DIGIT THREE",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0033,
 },
 {
  adobename="four",
  category="nd",
  cjkwd="na",
  description="DIGIT FOUR",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0034,
 },
 {
  adobename="five",
  category="nd",
  cjkwd="na",
  description="DIGIT FIVE",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0035,
 },
 {
  adobename="six",
  category="nd",
  cjkwd="na",
  description="DIGIT SIX",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0036,
 },
 {
  adobename="seven",
  category="nd",
  cjkwd="na",
  description="DIGIT SEVEN",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0037,
 },
 {
  adobename="eight",
  category="nd",
  cjkwd="na",
  description="DIGIT EIGHT",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0038,
 },
 {
  adobename="nine",
  category="nd",
  cjkwd="na",
  description="DIGIT NINE",
  direction="en",
  linebreak="nu",
  mathclass="number",
  unicodeslot=0x0039,
 },
 {
  adobename="colon",
  category="po",
  cjkwd="na",
  comment="mathclass=punctuation,mathname=colon",
  description="COLON",
  direction="cs",
  linebreak="is",
  mathclass="relation",
  unicodeslot=0x003A,
 },
 {
  adobename="semicolon",
  category="po",
  cjkwd="na",
  description="SEMICOLON",
  direction="on",
  linebreak="is",
  mathclass="punctuation",
  unicodeslot=0x003B,
 },
 {
  adobename="less",
  category="sm",
  cjkwd="na",
  description="LESS-THAN SIGN",
  direction="on",
  linebreak="al",
  mathclass="relation",
  mathname="lt",
  mirror=0x003E,
  unicodeslot=0x003C,
 },
 {
  adobename="equal",
  category="sm",
  cjkwd="na",
  comment="mathclass=binary",
  description="EQUALS SIGN",
  direction="on",
  linebreak="al",
  mathspec={
    {
     class="relation",
     name="eq",
    },
    {
     class="relation",
     name="Relbar",
    },
  },
  unicodeslot=0x003D,
 },
 {
  adobename="greater",
  category="sm",
  cjkwd="na",
  description="GREATER-THAN SIGN",
  direction="on",
  linebreak="al",
  mathclass="relation",
  mathname="gt",
  mirror=0x003C,
  unicodeslot=0x003E,
 },
 {
  adobename="question",
  category="po",
  cjkwd="na",
  description="QUESTION MARK",
  direction="on",
  linebreak="ex",
  mathclass="close",
  unicodeslot=0x003F,
 },
 {
  adobename="at",
  category="po",
  cjkwd="na",
  contextname="textat",
  description="COMMERCIAL AT",
  direction="on",
  linebreak="al",
  unicodeslot=0x0040,
 },
 {
  adobename="A",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER A",
  direction="l",
  lccode=0x0061,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0041,
 },
 {
  adobename="B",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER B",
  direction="l",
  lccode=0x0062,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0042,
 },
 {
  adobename="C",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER C",
  direction="l",
  lccode=0x0063,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0043,
 },
 {
  adobename="D",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER D",
  direction="l",
  lccode=0x0064,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0044,
 },
 {
  adobename="E",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER E",
  direction="l",
  lccode=0x0065,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0045,
 },
 {
  adobename="F",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER F",
  direction="l",
  lccode=0x0066,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0046,
 },
 {
  adobename="G",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER G",
  direction="l",
  lccode=0x0067,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0047,
 },
 {
  adobename="H",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER H",
  direction="l",
  lccode=0x0068,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0048,
 },
 {
  adobename="I",
  category="lu",
  cjkwd="na",
  contextname="dotlessI",
  description="LATIN CAPITAL LETTER I",
  direction="l",
  lccode=0x0069,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0049,
 },
 {
  adobename="J",
  category="lu",
  cjkwd="na",
  contextname="dotlessJ",
  description="LATIN CAPITAL LETTER J",
  direction="l",
  lccode=0x006A,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x004A,
 },
 {
  adobename="K",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER K",
  direction="l",
  lccode=0x006B,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x004B,
 },
 {
  adobename="L",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER L",
  direction="l",
  lccode=0x006C,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x004C,
 },
 {
  adobename="M",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER M",
  direction="l",
  lccode=0x006D,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x004D,
 },
 {
  adobename="N",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER N",
  direction="l",
  lccode=0x006E,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x004E,
 },
 {
  adobename="O",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER O",
  direction="l",
  lccode=0x006F,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x004F,
 },
 {
  adobename="P",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER P",
  direction="l",
  lccode=0x0070,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0050,
 },
 {
  adobename="Q",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER Q",
  direction="l",
  lccode=0x0071,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0051,
 },
 {
  adobename="R",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER R",
  direction="l",
  lccode=0x0072,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0052,
 },
 {
  adobename="S",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER S",
  direction="l",
  lccode=0x0073,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0053,
 },
 {
  adobename="T",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER T",
  direction="l",
  lccode=0x0074,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0054,
 },
 {
  adobename="U",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER U",
  direction="l",
  lccode=0x0075,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0055,
 },
 {
  adobename="V",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER V",
  direction="l",
  lccode=0x0076,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0056,
 },
 {
  adobename="W",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER W",
  direction="l",
  lccode=0x0077,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0057,
 },
 {
  adobename="X",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER X",
  direction="l",
  lccode=0x0078,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0058,
 },
 {
  adobename="Y",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER Y",
  direction="l",
  lccode=0x0079,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x0059,
 },
 {
  adobename="Z",
  category="lu",
  cjkwd="na",
  description="LATIN CAPITAL LETTER Z",
  direction="l",
  lccode=0x007A,
  linebreak="al",
  mathclass="variable",
  unicodeslot=0x005A,
 },
 {
  adobename="bracketleft",
  category="ps",
  cjkwd="na",
  description="LEFT SQUARE BRACKET",
  direction="on",
  linebreak="op",
  mathclass="open",
  mathname="lbrack",
  mirror=0x005D,
  unicodeslot=0x005B,
 },
 {
  adobename="backslash",
  category="po",
  cjkwd="na",
  contextname="textbackslash",
  description="REVERSE SOLIDUS",
  direction="on",
  linebreak="pr",
  mathclass="nothing",
  mathname="backslash",
  unicodeslot=0x005C,
 },
 {
  adobename="bracketright",
  category="pe",
  cjkwd="na",
  description="RIGHT SQUARE BRACKET",
  direction="on",
  linebreak="cp",
  mathclass="close",
  mathname="rbrack",
  mirror=0x005B,
  unicodeslot=0x005D,
 },
 {
  adobename="asciicircum",
  category="sk",
  cjkwd="na",
  contextname="textasciicircum",
  description="CIRCUMFLEX ACCENT",
  direction="on",
  linebreak="al",
  mathclass="accent",
  unicodeslot=0x005E,
 },
 {
  adobename="underscore",
  category="pc",
  cjkwd="na",
  contextname="textunderscore",
  description="LOW LINE",
  direction="on",
  linebreak="al",
  unicodeslot=0x005F,
 },
 {
  adobename="grave",
  category="sk",
  cjkwd="na",
  contextname="textgrave",
  description="GRAVE ACCENT",
  direction="on",
  linebreak="al",
  mathclass="accent",
  mathname="grave",
  unicodeslot=0x0060,
 },
 {
  adobename="a",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER A",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0041,
  unicodeslot=0x0061,
 },
 {
  adobename="b",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER B",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0042,
  unicodeslot=0x0062,
 },
 {
  adobename="c",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER C",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0043,
  unicodeslot=0x0063,
 },
 {
  adobename="d",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER D",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0044,
  unicodeslot=0x0064,
 },
 {
  adobename="e",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER E",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0045,
  unicodeslot=0x0065,
 },
 {
  adobename="f",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER F",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0046,
  unicodeslot=0x0066,
 },
 {
  adobename="g",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER G",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0047,
  unicodeslot=0x0067,
 },
 {
  adobename="h",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER H",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0048,
  unicodeslot=0x0068,
 },
 {
  adobename="i",
  category="ll",
  cjkwd="na",
  contextname="idotaccent",
  description="LATIN SMALL LETTER I",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0049,
  unicodeslot=0x0069,
 },
 {
  adobename="j",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER J",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x004A,
  unicodeslot=0x006A,
 },
 {
  adobename="k",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER K",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x004B,
  unicodeslot=0x006B,
 },
 {
  adobename="l",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER L",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x004C,
  unicodeslot=0x006C,
 },
 {
  adobename="m",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER M",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x004D,
  unicodeslot=0x006D,
 },
 {
  adobename="n",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER N",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x004E,
  unicodeslot=0x006E,
 },
 {
  adobename="o",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER O",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x004F,
  unicodeslot=0x006F,
 },
 {
  adobename="p",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER P",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0050,
  unicodeslot=0x0070,
 },
 {
  adobename="q",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER Q",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0051,
  unicodeslot=0x0071,
 },
 {
  adobename="r",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER R",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0052,
  unicodeslot=0x0072,
 },
 {
  adobename="s",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER S",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0053,
  unicodeslot=0x0073,
 },
 {
  adobename="t",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER T",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0054,
  unicodeslot=0x0074,
 },
 {
  adobename="u",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER U",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0055,
  unicodeslot=0x0075,
 },
 {
  adobename="v",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER V",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0056,
  unicodeslot=0x0076,
 },
 {
  adobename="w",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER W",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0057,
  unicodeslot=0x0077,
 },
 {
  adobename="x",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER X",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0058,
  unicodeslot=0x0078,
 },
 {
  adobename="y",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER Y",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x0059,
  unicodeslot=0x0079,
 },
 {
  adobename="z",
  category="ll",
  cjkwd="na",
  description="LATIN SMALL LETTER Z",
  direction="l",
  linebreak="al",
  mathclass="variable",
  uccode=0x005A,
  unicodeslot=0x007A,
 },
 {
  adobename="braceleft",
  category="ps",
  cjkwd="na",
  contextname="textbraceleft",
  description="LEFT CURLY BRACKET",
  direction="on",
  linebreak="op",
  mathclass="open",
  mathname="lbrace",
  mirror=0x007D,
  unicodeslot=0x007B,
 },
 {
  adobename="verticalbar",
  category="sm",
  cjkwd="na",
  comment="mathclass=binary,mathname=bar",
  contextname="textbar",
  description="VERTICAL LINE",
  direction="on",
  linebreak="ba",
  mathspec={
   {
    class="nothing",
    name="arrowvert",
   },
   {
    class="delimiter",
    name="vert",
   },
   {
    class="open",
    name="lvert",
   },
   {
    class="close",
    name="rvert",
   },
   {
    class="relation",
    name="mid",
   },
  },
  unicodeslot=0x007C,
 },
 {
  adobename="braceright",
  category="pe",
  cjkwd="na",
  contextname="textbraceright",
  description="RIGHT CURLY BRACKET",
  direction="on",
  linebreak="cl",
  mathclass="close",
  mathname="rbrace",
  mirror=0x007B,
  unicodeslot=0x007D,
 },
 {
  adobename="asciitilde",
  category="sm",
  cjkwd="na",
  contextname="textasciitilde",
  description="TILDE",
  direction="on",
  linebreak="al",
  unicodeslot=0x007E,
 },
 {
  adobename="controlDEL",
  category="cc",
  description="DELETE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x007F,
 },
 {
  category="cc",
  description="NONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0080,
 },
 {
  category="cc",
  description="NONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0081,
 },
 {
  category="cc",
  description="BREAK PERMITTED HERE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0082,
 },
 {
  category="cc",
  description="NO BREAK HERE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0083,
 },
 {
  category="cc",
  description="NONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0084,
 },
 {
  category="cc",
  description="NEXT LINE (NEL)",
  direction="b",
  linebreak="nl",
  unicodeslot=0x0085,
 },
 {
  category="cc",
  description="START OF SELECTED AREA",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0086,
 },
 {
  category="cc",
  description="END OF SELECTED AREA",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0087,
 },
 {
  category="cc",
  description="CHARACTER TABULATION SET",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0088,
 },
 {
  category="cc",
  description="CHARACTER TABULATION WITH JUSTIFICATION",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0089,
 },
 {
  category="cc",
  description="LINE TABULATION SET",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x008A,
 },
 {
  category="cc",
  description="PARTIAL LINE FORWARD",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x008B,
 },
 {
  category="cc",
  description="PARTIAL LINE BACKWARD",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x008C,
 },
 {
  category="cc",
  description="REVERSE LINE FEED",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x008D,
 },
 {
  category="cc",
  description="SINGLE SHIFT TWO",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x008E,
 },
 {
  category="cc",
  description="SINGLE SHIFT THREE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x008F,
 },
 {
  category="cc",
  description="DEVICE CONTROL STRING",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0090,
 },
 {
  category="cc",
  description="PRIVATE USE ONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0091,
 },
 {
  category="cc",
  description="PRIVATE USE TWO",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0092,
 },
 {
  category="cc",
  description="SET TRANSMIT STATE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0093,
 },
 {
  category="cc",
  description="CANCEL CHARACTER",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0094,
 },
 {
  category="cc",
  description="MESSAGE WAITING",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0095,
 },
 {
  category="cc",
  description="START OF GUARDED AREA",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0096,
 },
 {
  category="cc",
  description="END OF GUARDED AREA",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0097,
 },
 {
  category="cc",
  description="START OF STRING",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0098,
 },
 {
  category="cc",
  description="NONE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x0099,
 },
 {
  category="cc",
  description="SINGLE CHARACTER INTRODUCER",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x009A,
 },
 {
  category="cc",
  description="CONTROL SEQUENCE INTRODUCER",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x009B,
 },
 {
  category="cc",
  description="STRING TERMINATOR",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x009C,
 },
 {
  category="cc",
  description="OPERATING SYSTEM COMMAND",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x009D,
 },
 {
  category="cc",
  description="PRIVACY MESSAGE",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x009E,
 },
 {
  category="cc",
  description="APPLICATION PROGRAM COMMAND",
  direction="bn",
  linebreak="cm",
  unicodeslot=0x009F,
 },
 {
  adobename="nonbreakingspace",
  category="zs",
  contextname="nobreakspace",
  description="NO-BREAK SPACE",
  direction="cs",
  linebreak="gl",
  specials={ "nobreak", 0x0020 },
  unicodeslot=0x00A0,
 },
 {
  adobename="exclamdown",
  category="po",
  cjkwd="a",
  contextname="exclamdown",
  description="INVERTED EXCLAMATION MARK",
  direction="on",
  linebreak="op",
  unicodeslot=0x00A1,
 },
 {
  adobename="cent",
  category="sc",
  cjkwd="na",
  contextname="textcent",
  description="CENT SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x00A2,
 },
 {
  adobename="sterling",
  category="sc",
  cjkwd="na",
  contextname="textsterling",
  description="POUND SIGN",
  direction="et",
  linebreak="pr",
  unicodeslot=0x00A3,
 },
 {
  adobename="currency",
  category="sc",
  cjkwd="a",
  contextname="textcurrency",
  description="CURRENCY SIGN",
  direction="et",
  linebreak="pr",
  unicodeslot=0x00A4,
 },
 {
  adobename="yen",
  category="sc",
  cjkwd="na",
  contextname="textyen",
  description="YEN SIGN",
  direction="et",
  linebreak="pr",
  mathclass="nothing",
  mathname="yen",
  unicodeslot=0x00A5,
 },
 {
  adobename="brokenbar",
  category="so",
  cjkwd="na",
  contextname="textbrokenbar",
  description="BROKEN BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x00A6,
 },
 {
  adobename="section",
  category="so",
  cjkwd="a",
  contextname="sectionmark",
  description="SECTION SIGN",
  direction="on",
  linebreak="ai",
  mathclass="box",
  mathname="S",
  unicodeslot=0x00A7,
 },
 {
  adobename="dieresis",
  category="sk",
  cjkwd="a",
  contextname="textdiaeresis",
  description="DIAERESIS",
  direction="on",
  linebreak="ai",
  mathclass="accent",
  mathname="ddot",
  specials={ "compat", 0x0020, 0x0308 },
  unicodeslot=0x00A8,
 },
 {
  adobename="copyright",
  category="so",
  contextname="copyright",
  description="COPYRIGHT SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x00A9,
 },
 {
  adobename="ordfeminine",
  category="ll",
  cjkwd="a",
  contextname="ordfeminine",
  description="FEMININE ORDINAL INDICATOR",
  direction="l",
  linebreak="ai",
  specials={ "super", 0x0061 },
  unicodeslot=0x00AA,
 },
 {
  adobename="guillemotleft",
  category="pi",
  contextname="leftguillemot",
  description="LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",
  direction="on",
  linebreak="qu",
  mirror=0x00BB,
  unicodeslot=0x00AB,
 },
 {
  adobename="logicalnot",
  category="sm",
  cjkwd="na",
  contextname="textlognot",
  description="NOT SIGN",
  direction="on",
  linebreak="al",
  mathspec={
   {
    class="ord",
    name="lnot",
   },
   {
    class="ord",
    name="neg",
   },
  },
  unicodeslot=0x00AC,
 },
 {
  adobename="softhyphen",
  category="cf",
  cjkwd="a",
  contextname="softhyphen",
  description="SOFT HYPHEN",
  direction="bn",
  linebreak="ba",
  unicodeslot=0x00AD,
 },
 {
  adobename="registered",
  category="so",
  cjkwd="a",
  contextname="registered",
  description="REGISTERED SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x00AE,
 },
 {
  adobename="macron",
  category="sk",
  cjkwd="na",
  contextname="textmacron",
  description="MACRON",
  direction="on",
  linebreak="al",
  mathclass="accent",
  mathname="bar",
  specials={ "compat", 0x0020, 0x0304 },
  unicodeslot=0x00AF,
 },
 {
  adobename="degree",
  category="so",
  cjkwd="a",
  contextname="textdegree",
  description="DEGREE SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x00B0,
 },
 {
  adobename="plusminus",
  category="sm",
  cjkwd="a",
  contextname="textpm",
  description="PLUS-MINUS SIGN",
  direction="et",
  linebreak="pr",
  mathclass="binary",
  mathname="pm",
  unicodeslot=0x00B1,
 },
 {
  adobename="twosuperior",
  category="no",
  cjkwd="a",
  contextname="twosuperior",
  description="SUPERSCRIPT TWO",
  direction="en",
  linebreak="ai",
  specials={ "super", 0x0032 },
  unicodeslot=0x00B2,
 },
 {
  adobename="threesuperior",
  category="no",
  cjkwd="a",
  contextname="threesuperior",
  description="SUPERSCRIPT THREE",
  direction="en",
  linebreak="ai",
  specials={ "super", 0x0033 },
  unicodeslot=0x00B3,
 },
 {
  adobename="acute",
  category="sk",
  cjkwd="a",
  contextname="textacute",
  description="ACUTE ACCENT",
  direction="on",
  linebreak="bb",
  mathclass="accent",
  mathname="acute",
  specials={ "compat", 0x0020, 0x0301 },
  unicodeslot=0x00B4,
 },
 {
  adobename="mu1",
  category="ll",
  contextname="textmu",
  description="MICRO SIGN",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x03BC },
  uccode=0x039C,
  unicodeslot=0x00B5,
 },
 {
  adobename="paragraph",
  category="so",
  cjkwd="a",
  contextname="paragraphmark",
  description="PILCROW SIGN",
  direction="on",
  linebreak="ai",
  mathclass="box",
  mathname="P",
  unicodeslot=0x00B6,
 },
 {
  adobename="periodcentered",
  category="po",
  cjkwd="a",
  contextname="periodcentered",
  description="MIDDLE DOT",
  direction="on",
  linebreak="ai",
  mathclass="binary",
  mathname="centerdot",
  unicodeslot=0x00B7,
 },
 {
  adobename="cedilla",
  category="sk",
  cjkwd="a",
  contextname="textcedilla",
  description="CEDILLA",
  direction="on",
  linebreak="ai",
  specials={ "compat", 0x0020, 0x0327 },
  unicodeslot=0x00B8,
 },
 {
  adobename="onesuperior",
  category="no",
  cjkwd="a",
  contextname="onesuperior",
  description="SUPERSCRIPT ONE",
  direction="en",
  linebreak="ai",
  specials={ "super", 0x0031 },
  unicodeslot=0x00B9,
 },
 {
  adobename="ordmasculine",
  category="ll",
  cjkwd="a",
  contextname="ordmasculine",
  description="MASCULINE ORDINAL INDICATOR",
  direction="l",
  linebreak="ai",
  specials={ "super", 0x006F },
  unicodeslot=0x00BA,
 },
 {
  adobename="guillemotright",
  category="pf",
  contextname="rightguillemot",
  description="RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK",
  direction="on",
  linebreak="qu",
  mirror=0x00AB,
  unicodeslot=0x00BB,
 },
 {
  adobename="onequarter",
  category="no",
  cjkwd="a",
  contextname="onequarter",
  description="VULGAR FRACTION ONE QUARTER",
  direction="on",
  linebreak="ai",
  specials={ "fraction", 0x0031, 0x2044, 0x0034 },
  unicodeslot=0x00BC,
 },
 {
  adobename="onehalf",
  category="no",
  cjkwd="a",
  contextname="onehalf",
  description="VULGAR FRACTION ONE HALF",
  direction="on",
  linebreak="ai",
  specials={ "fraction", 0x0031, 0x2044, 0x0032 },
  unicodeslot=0x00BD,
 },
 {
  adobename="threequarters",
  category="no",
  cjkwd="a",
  contextname="threequarter",
  description="VULGAR FRACTION THREE QUARTERS",
  direction="on",
  linebreak="ai",
  specials={ "fraction", 0x0033, 0x2044, 0x0034 },
  unicodeslot=0x00BE,
 },
 {
  adobename="questiondown",
  category="po",
  cjkwd="a",
  contextname="questiondown",
  description="INVERTED QUESTION MARK",
  direction="on",
  linebreak="op",
  unicodeslot=0x00BF,
 },
 {
  adobename="Agrave",
  category="lu",
  contextname="Agrave",
  description="LATIN CAPITAL LETTER A WITH GRAVE",
  direction="l",
  lccode=0x00E0,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0300 },
  unicodeslot=0x00C0,
 },
 {
  adobename="Aacute",
  category="lu",
  contextname="Aacute",
  description="LATIN CAPITAL LETTER A WITH ACUTE",
  direction="l",
  lccode=0x00E1,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0301 },
  unicodeslot=0x00C1,
 },
 {
  adobename="Acircumflex",
  category="lu",
  contextname="Acircumflex",
  description="LATIN CAPITAL LETTER A WITH CIRCUMFLEX",
  direction="l",
  lccode=0x00E2,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0302 },
  unicodeslot=0x00C2,
 },
 {
  adobename="Atilde",
  category="lu",
  contextname="Atilde",
  description="LATIN CAPITAL LETTER A WITH TILDE",
  direction="l",
  lccode=0x00E3,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0303 },
  unicodeslot=0x00C3,
 },
 {
  adobename="Adieresis",
  category="lu",
  contextname="Adiaeresis",
  description="LATIN CAPITAL LETTER A WITH DIAERESIS",
  direction="l",
  lccode=0x00E4,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0308 },
  unicodeslot=0x00C4,
 },
 {
  adobename="Aring",
  category="lu",
  contextname="Aring",
  description="LATIN CAPITAL LETTER A WITH RING ABOVE",
  direction="l",
  lccode=0x00E5,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x030A },
  unicodeslot=0x00C5,
 },
 {
  adobename="AE",
  category="lu",
  cjkwd="a",
  contextname="AEligature",
  description="LATIN CAPITAL LETTER AE",
  direction="l",
  lccode=0x00E6,
  linebreak="al",
  shcode={ 0x0041, 0x0045 },
  unicodeslot=0x00C6,
 },
 {
  adobename="Ccedilla",
  category="lu",
  contextname="Ccedilla",
  description="LATIN CAPITAL LETTER C WITH CEDILLA",
  direction="l",
  lccode=0x00E7,
  linebreak="al",
  shcode=0x0043,
  specials={ "char", 0x0043, 0x0327 },
  unicodeslot=0x00C7,
 },
 {
  adobename="Egrave",
  category="lu",
  contextname="Egrave",
  description="LATIN CAPITAL LETTER E WITH GRAVE",
  direction="l",
  lccode=0x00E8,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0300 },
  unicodeslot=0x00C8,
 },
 {
  adobename="Eacute",
  category="lu",
  contextname="Eacute",
  description="LATIN CAPITAL LETTER E WITH ACUTE",
  direction="l",
  lccode=0x00E9,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0301 },
  unicodeslot=0x00C9,
 },
 {
  adobename="Ecircumflex",
  category="lu",
  contextname="Ecircumflex",
  description="LATIN CAPITAL LETTER E WITH CIRCUMFLEX",
  direction="l",
  lccode=0x00EA,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0302 },
  unicodeslot=0x00CA,
 },
 {
  adobename="Edieresis",
  category="lu",
  contextname="Ediaeresis",
  description="LATIN CAPITAL LETTER E WITH DIAERESIS",
  direction="l",
  lccode=0x00EB,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0308 },
  unicodeslot=0x00CB,
 },
 {
  adobename="Igrave",
  category="lu",
  contextname="Igrave",
  description="LATIN CAPITAL LETTER I WITH GRAVE",
  direction="l",
  lccode=0x00EC,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0300 },
  unicodeslot=0x00CC,
 },
 {
  adobename="Iacute",
  category="lu",
  contextname="Iacute",
  description="LATIN CAPITAL LETTER I WITH ACUTE",
  direction="l",
  lccode=0x00ED,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0301 },
  unicodeslot=0x00CD,
 },
 {
  adobename="Icircumflex",
  category="lu",
  contextname="Icircumflex",
  description="LATIN CAPITAL LETTER I WITH CIRCUMFLEX",
  direction="l",
  lccode=0x00EE,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0302 },
  unicodeslot=0x00CE,
 },
 {
  adobename="Idieresis",
  category="lu",
  contextname="Idiaeresis",
  description="LATIN CAPITAL LETTER I WITH DIAERESIS",
  direction="l",
  lccode=0x00EF,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0308 },
  unicodeslot=0x00CF,
 },
 {
  adobename="Eth",
  category="lu",
  cjkwd="a",
  contextname="Eth",
  description="LATIN CAPITAL LETTER ETH",
  direction="l",
  lccode=0x00F0,
  linebreak="al",
  unicodeslot=0x00D0,
 },
 {
  adobename="Ntilde",
  category="lu",
  contextname="Ntilde",
  description="LATIN CAPITAL LETTER N WITH TILDE",
  direction="l",
  lccode=0x00F1,
  linebreak="al",
  shcode=0x004E,
  specials={ "char", 0x004E, 0x0303 },
  unicodeslot=0x00D1,
 },
 {
  adobename="Ograve",
  category="lu",
  contextname="Ograve",
  description="LATIN CAPITAL LETTER O WITH GRAVE",
  direction="l",
  lccode=0x00F2,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0300 },
  unicodeslot=0x00D2,
 },
 {
  adobename="Oacute",
  category="lu",
  contextname="Oacute",
  description="LATIN CAPITAL LETTER O WITH ACUTE",
  direction="l",
  lccode=0x00F3,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0301 },
  unicodeslot=0x00D3,
 },
 {
  adobename="Ocircumflex",
  category="lu",
  contextname="Ocircumflex",
  description="LATIN CAPITAL LETTER O WITH CIRCUMFLEX",
  direction="l",
  lccode=0x00F4,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0302 },
  unicodeslot=0x00D4,
 },
 {
  adobename="Otilde",
  category="lu",
  contextname="Otilde",
  description="LATIN CAPITAL LETTER O WITH TILDE",
  direction="l",
  lccode=0x00F5,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0303 },
  unicodeslot=0x00D5,
 },
 {
  adobename="Odieresis",
  category="lu",
  contextname="Odiaeresis",
  description="LATIN CAPITAL LETTER O WITH DIAERESIS",
  direction="l",
  lccode=0x00F6,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0308 },
  unicodeslot=0x00D6,
 },
 {
  adobename="multiply",
  category="sm",
  cjkwd="a",
  contextname="textmultiply",
  description="MULTIPLICATION SIGN",
  direction="on",
  linebreak="ai",
  mathclass="binary",
  mathname="times",
  unicodeslot=0x00D7,
 },
 {
  adobename="Oslash",
  category="lu",
  cjkwd="a",
  contextname="Ostroke",
  description="LATIN CAPITAL LETTER O WITH STROKE",
  direction="l",
  lccode=0x00F8,
  linebreak="al",
  shcode=0x004F,
  unicodeslot=0x00D8,
 },
 {
  adobename="Ugrave",
  category="lu",
  contextname="Ugrave",
  description="LATIN CAPITAL LETTER U WITH GRAVE",
  direction="l",
  lccode=0x00F9,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x0300 },
  unicodeslot=0x00D9,
 },
 {
  adobename="Uacute",
  category="lu",
  contextname="Uacute",
  description="LATIN CAPITAL LETTER U WITH ACUTE",
  direction="l",
  lccode=0x00FA,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x0301 },
  unicodeslot=0x00DA,
 },
 {
  adobename="Ucircumflex",
  category="lu",
  contextname="Ucircumflex",
  description="LATIN CAPITAL LETTER U WITH CIRCUMFLEX",
  direction="l",
  lccode=0x00FB,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x0302 },
  unicodeslot=0x00DB,
 },
 {
  adobename="Udieresis",
  category="lu",
  contextname="Udiaeresis",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS",
  direction="l",
  lccode=0x00FC,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x0308 },
  unicodeslot=0x00DC,
 },
 {
  adobename="Yacute",
  category="lu",
  contextname="Yacute",
  description="LATIN CAPITAL LETTER Y WITH ACUTE",
  direction="l",
  lccode=0x00FD,
  linebreak="al",
  shcode=0x0059,
  specials={ "char", 0x0059, 0x0301 },
  unicodeslot=0x00DD,
 },
 {
  adobename="Thorn",
  category="lu",
  cjkwd="a",
  contextname="Thorn",
  description="LATIN CAPITAL LETTER THORN",
  direction="l",
  lccode=0x00FE,
  linebreak="al",
  unicodeslot=0x00DE,
 },
 {
  adobename="germandbls",
  category="ll",
  cjkwd="a",
  contextname="ssharp",
  description="LATIN SMALL LETTER SHARP S",
  direction="l",
  linebreak="al",
  uccode={ 0x0053, 0x0053 },
  unicodeslot=0x00DF,
 },
 {
  adobename="agrave",
  category="ll",
  cjkwd="a",
  contextname="agrave",
  description="LATIN SMALL LETTER A WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0300 },
  uccode=0x00C0,
  unicodeslot=0x00E0,
 },
 {
  adobename="aacute",
  category="ll",
  cjkwd="a",
  contextname="aacute",
  description="LATIN SMALL LETTER A WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0301 },
  uccode=0x00C1,
  unicodeslot=0x00E1,
 },
 {
  adobename="acircumflex",
  category="ll",
  contextname="acircumflex",
  description="LATIN SMALL LETTER A WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0302 },
  uccode=0x00C2,
  unicodeslot=0x00E2,
 },
 {
  adobename="atilde",
  category="ll",
  contextname="atilde",
  description="LATIN SMALL LETTER A WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0303 },
  uccode=0x00C3,
  unicodeslot=0x00E3,
 },
 {
  adobename="adieresis",
  category="ll",
  contextname="adiaeresis",
  description="LATIN SMALL LETTER A WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0308 },
  uccode=0x00C4,
  unicodeslot=0x00E4,
 },
 {
  adobename="aring",
  category="ll",
  contextname="aring",
  description="LATIN SMALL LETTER A WITH RING ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x030A },
  uccode=0x00C5,
  unicodeslot=0x00E5,
 },
 {
  adobename="ae",
  category="ll",
  cjkwd="a",
  contextname="aeligature",
  description="LATIN SMALL LETTER AE",
  direction="l",
  linebreak="al",
  shcode={ 0x0061, 0x0065 },
  uccode=0x00C6,
  unicodeslot=0x00E6,
 },
 {
  adobename="ccedilla",
  category="ll",
  contextname="ccedilla",
  description="LATIN SMALL LETTER C WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x0063,
  specials={ "char", 0x0063, 0x0327 },
  uccode=0x00C7,
  unicodeslot=0x00E7,
 },
 {
  adobename="egrave",
  category="ll",
  cjkwd="a",
  contextname="egrave",
  description="LATIN SMALL LETTER E WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0300 },
  uccode=0x00C8,
  unicodeslot=0x00E8,
 },
 {
  adobename="eacute",
  category="ll",
  cjkwd="a",
  contextname="eacute",
  description="LATIN SMALL LETTER E WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0301 },
  uccode=0x00C9,
  unicodeslot=0x00E9,
 },
 {
  adobename="ecircumflex",
  category="ll",
  cjkwd="a",
  contextname="ecircumflex",
  description="LATIN SMALL LETTER E WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0302 },
  uccode=0x00CA,
  unicodeslot=0x00EA,
 },
 {
  adobename="edieresis",
  category="ll",
  contextname="ediaeresis",
  description="LATIN SMALL LETTER E WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0308 },
  uccode=0x00CB,
  unicodeslot=0x00EB,
 },
 {
  adobename="igrave",
  category="ll",
  cjkwd="a",
  contextname="igrave",
  description="LATIN SMALL LETTER I WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0300 },
  uccode=0x00CC,
  unicodeslot=0x00EC,
 },
 {
  adobename="iacute",
  category="ll",
  cjkwd="a",
  contextname="iacute",
  description="LATIN SMALL LETTER I WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0301 },
  uccode=0x00CD,
  unicodeslot=0x00ED,
 },
 {
  adobename="icircumflex",
  category="ll",
  contextname="icircumflex",
  description="LATIN SMALL LETTER I WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0302 },
  uccode=0x00CE,
  unicodeslot=0x00EE,
 },
 {
  adobename="idieresis",
  category="ll",
  contextname="idiaeresis",
  description="LATIN SMALL LETTER I WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0308 },
  uccode=0x00CF,
  unicodeslot=0x00EF,
 },
 {
  adobename="eth",
  category="ll",
  cjkwd="a",
  comment="contextname=eth",
  description="LATIN SMALL LETTER ETH",
  direction="l",
  linebreak="al",
  mathclass="ord",
  mathname="eth",
  uccode=0x00D0,
  unicodeslot=0x00F0,
 },
 {
  adobename="ntilde",
  category="ll",
  contextname="ntilde",
  description="LATIN SMALL LETTER N WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  specials={ "char", 0x006E, 0x0303 },
  uccode=0x00D1,
  unicodeslot=0x00F1,
 },
 {
  adobename="ograve",
  category="ll",
  cjkwd="a",
  contextname="ograve",
  description="LATIN SMALL LETTER O WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0300 },
  uccode=0x00D2,
  unicodeslot=0x00F2,
 },
 {
  adobename="oacute",
  category="ll",
  cjkwd="a",
  contextname="oacute",
  description="LATIN SMALL LETTER O WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0301 },
  uccode=0x00D3,
  unicodeslot=0x00F3,
 },
 {
  adobename="ocircumflex",
  category="ll",
  contextname="ocircumflex",
  description="LATIN SMALL LETTER O WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0302 },
  uccode=0x00D4,
  unicodeslot=0x00F4,
 },
 {
  adobename="otilde",
  category="ll",
  contextname="otilde",
  description="LATIN SMALL LETTER O WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0303 },
  uccode=0x00D5,
  unicodeslot=0x00F5,
 },
 {
  adobename="odieresis",
  category="ll",
  contextname="odiaeresis",
  description="LATIN SMALL LETTER O WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0308 },
  uccode=0x00D6,
  unicodeslot=0x00F6,
 },
 {
  adobename="divide",
  category="sm",
  cjkwd="a",
  contextname="textdiv",
  description="DIVISION SIGN",
  direction="on",
  linebreak="ai",
  mathclass="binary",
  mathname="div",
  unicodeslot=0x00F7,
 },
 {
  adobename="oslash",
  category="ll",
  cjkwd="a",
  contextname="ostroke",
  description="LATIN SMALL LETTER O WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  uccode=0x00D8,
  unicodeslot=0x00F8,
 },
 {
  adobename="ugrave",
  category="ll",
  cjkwd="a",
  contextname="ugrave",
  description="LATIN SMALL LETTER U WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x0300 },
  uccode=0x00D9,
  unicodeslot=0x00F9,
 },
 {
  adobename="uacute",
  category="ll",
  cjkwd="a",
  contextname="uacute",
  description="LATIN SMALL LETTER U WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x0301 },
  uccode=0x00DA,
  unicodeslot=0x00FA,
 },
 {
  adobename="ucircumflex",
  category="ll",
  contextname="ucircumflex",
  description="LATIN SMALL LETTER U WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x0302 },
  uccode=0x00DB,
  unicodeslot=0x00FB,
 },
 {
  adobename="udieresis",
  category="ll",
  cjkwd="a",
  contextname="udiaeresis",
  description="LATIN SMALL LETTER U WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x0308 },
  uccode=0x00DC,
  unicodeslot=0x00FC,
 },
 {
  adobename="yacute",
  category="ll",
  contextname="yacute",
  description="LATIN SMALL LETTER Y WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0079,
  specials={ "char", 0x0079, 0x0301 },
  uccode=0x00DD,
  unicodeslot=0x00FD,
 },
 {
  adobename="thorn",
  category="ll",
  cjkwd="a",
  contextname="thorn",
  description="LATIN SMALL LETTER THORN",
  direction="l",
  linebreak="al",
  uccode=0x00DE,
  unicodeslot=0x00FE,
 },
 {
  adobename="ydieresis",
  category="ll",
  contextname="ydiaeresis",
  description="LATIN SMALL LETTER Y WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0079,
  specials={ "char", 0x0079, 0x0308 },
  uccode=0x0178,
  unicodeslot=0x00FF,
 },
 {
  adobename="Amacron",
  category="lu",
  contextname="Amacron",
  description="LATIN CAPITAL LETTER A WITH MACRON",
  direction="l",
  lccode=0x0101,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0304 },
  unicodeslot=0x0100,
 },
 {
  adobename="amacron",
  category="ll",
  cjkwd="a",
  contextname="amacron",
  description="LATIN SMALL LETTER A WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0304 },
  uccode=0x0100,
  unicodeslot=0x0101,
 },
 {
  adobename="Abreve",
  category="lu",
  contextname="Abreve",
  description="LATIN CAPITAL LETTER A WITH BREVE",
  direction="l",
  lccode=0x0103,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0306 },
  unicodeslot=0x0102,
 },
 {
  adobename="abreve",
  category="ll",
  contextname="abreve",
  description="LATIN SMALL LETTER A WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0306 },
  uccode=0x0102,
  unicodeslot=0x0103,
 },
 {
  adobename="Aogonek",
  category="lu",
  contextname="Aogonek",
  description="LATIN CAPITAL LETTER A WITH OGONEK",
  direction="l",
  lccode=0x0105,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0328 },
  unicodeslot=0x0104,
 },
 {
  adobename="aogonek",
  category="ll",
  contextname="aogonek",
  description="LATIN SMALL LETTER A WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0328 },
  uccode=0x0104,
  unicodeslot=0x0105,
 },
 {
  adobename="Cacute",
  category="lu",
  contextname="Cacute",
  description="LATIN CAPITAL LETTER C WITH ACUTE",
  direction="l",
  lccode=0x0107,
  linebreak="al",
  shcode=0x0043,
  specials={ "char", 0x0043, 0x0301 },
  unicodeslot=0x0106,
 },
 {
  adobename="cacute",
  category="ll",
  contextname="cacute",
  description="LATIN SMALL LETTER C WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0063,
  specials={ "char", 0x0063, 0x0301 },
  uccode=0x0106,
  unicodeslot=0x0107,
 },
 {
  adobename="Ccircumflex",
  category="lu",
  contextname="Ccircumflex",
  description="LATIN CAPITAL LETTER C WITH CIRCUMFLEX",
  direction="l",
  lccode=0x0109,
  linebreak="al",
  shcode=0x0043,
  specials={ "char", 0x0043, 0x0302 },
  unicodeslot=0x0108,
 },
 {
  adobename="ccircumflex",
  category="ll",
  contextname="ccircumflex",
  description="LATIN SMALL LETTER C WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0063,
  specials={ "char", 0x0063, 0x0302 },
  uccode=0x0108,
  unicodeslot=0x0109,
 },
 {
  adobename="Cdotaccent",
  category="lu",
  contextname="Cdotaccent",
  description="LATIN CAPITAL LETTER C WITH DOT ABOVE",
  direction="l",
  lccode=0x010B,
  linebreak="al",
  shcode=0x0043,
  specials={ "char", 0x0043, 0x0307 },
  unicodeslot=0x010A,
 },
 {
  adobename="cdotaccent",
  category="ll",
  contextname="cdotaccent",
  description="LATIN SMALL LETTER C WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0063,
  specials={ "char", 0x0063, 0x0307 },
  uccode=0x010A,
  unicodeslot=0x010B,
 },
 {
  adobename="Ccaron",
  category="lu",
  contextname="Ccaron",
  description="LATIN CAPITAL LETTER C WITH CARON",
  direction="l",
  lccode=0x010D,
  linebreak="al",
  shcode=0x0043,
  specials={ "char", 0x0043, 0x030C },
  unicodeslot=0x010C,
 },
 {
  adobename="ccaron",
  category="ll",
  contextname="ccaron",
  description="LATIN SMALL LETTER C WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0063,
  specials={ "char", 0x0063, 0x030C },
  uccode=0x010C,
  unicodeslot=0x010D,
 },
 {
  adobename="Dcaron",
  category="lu",
  contextname="Dcaron",
  description="LATIN CAPITAL LETTER D WITH CARON",
  direction="l",
  lccode=0x010F,
  linebreak="al",
  shcode=0x0044,
  specials={ "char", 0x0044, 0x030C },
  unicodeslot=0x010E,
 },
 {
  adobename="dcaron",
  category="ll",
  contextname="dcaron",
  description="LATIN SMALL LETTER D WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  specials={ "char", 0x0064, 0x030C },
  uccode=0x010E,
  unicodeslot=0x010F,
 },
 {
  adobename="Dslash",
  category="lu",
  contextname="Dstroke",
  description="LATIN CAPITAL LETTER D WITH STROKE",
  direction="l",
  lccode=0x0111,
  linebreak="al",
  shcode=0x0044,
  unicodeslot=0x0110,
 },
 {
  adobename="dmacron",
  category="ll",
  cjkwd="a",
  contextname="dstroke",
  description="LATIN SMALL LETTER D WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  uccode=0x0110,
  unicodeslot=0x0111,
 },
 {
  adobename="Emacron",
  category="lu",
  contextname="Emacron",
  description="LATIN CAPITAL LETTER E WITH MACRON",
  direction="l",
  lccode=0x0113,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0304 },
  unicodeslot=0x0112,
 },
 {
  adobename="emacron",
  category="ll",
  cjkwd="a",
  contextname="emacron",
  description="LATIN SMALL LETTER E WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0304 },
  uccode=0x0112,
  unicodeslot=0x0113,
 },
 {
  adobename="Ebreve",
  category="lu",
  contextname="Ebreve",
  description="LATIN CAPITAL LETTER E WITH BREVE",
  direction="l",
  lccode=0x0115,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0306 },
  unicodeslot=0x0114,
 },
 {
  adobename="ebreve",
  category="ll",
  contextname="ebreve",
  description="LATIN SMALL LETTER E WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0306 },
  uccode=0x0114,
  unicodeslot=0x0115,
 },
 {
  adobename="Edotaccent",
  category="lu",
  contextname="Edotaccent",
  description="LATIN CAPITAL LETTER E WITH DOT ABOVE",
  direction="l",
  lccode=0x0117,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0307 },
  unicodeslot=0x0116,
 },
 {
  adobename="edotaccent",
  category="ll",
  contextname="edotaccent",
  description="LATIN SMALL LETTER E WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0307 },
  uccode=0x0116,
  unicodeslot=0x0117,
 },
 {
  adobename="Eogonek",
  category="lu",
  contextname="Eogonek",
  description="LATIN CAPITAL LETTER E WITH OGONEK",
  direction="l",
  lccode=0x0119,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0328 },
  unicodeslot=0x0118,
 },
 {
  adobename="eogonek",
  category="ll",
  contextname="eogonek",
  description="LATIN SMALL LETTER E WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0328 },
  uccode=0x0118,
  unicodeslot=0x0119,
 },
 {
  adobename="Ecaron",
  category="lu",
  contextname="Ecaron",
  description="LATIN CAPITAL LETTER E WITH CARON",
  direction="l",
  lccode=0x011B,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x030C },
  unicodeslot=0x011A,
 },
 {
  adobename="ecaron",
  category="ll",
  cjkwd="a",
  contextname="ecaron",
  description="LATIN SMALL LETTER E WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x030C },
  uccode=0x011A,
  unicodeslot=0x011B,
 },
 {
  adobename="Gcircumflex",
  category="lu",
  contextname="Gcircumflex",
  description="LATIN CAPITAL LETTER G WITH CIRCUMFLEX",
  direction="l",
  lccode=0x011D,
  linebreak="al",
  shcode=0x0047,
  specials={ "char", 0x0047, 0x0302 },
  unicodeslot=0x011C,
 },
 {
  adobename="gcircumflex",
  category="ll",
  contextname="gcircumflex",
  description="LATIN SMALL LETTER G WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  specials={ "char", 0x0067, 0x0302 },
  uccode=0x011C,
  unicodeslot=0x011D,
 },
 {
  adobename="Gbreve",
  category="lu",
  contextname="Gbreve",
  description="LATIN CAPITAL LETTER G WITH BREVE",
  direction="l",
  lccode=0x011F,
  linebreak="al",
  shcode=0x0047,
  specials={ "char", 0x0047, 0x0306 },
  unicodeslot=0x011E,
 },
 {
  adobename="gbreve",
  category="ll",
  contextname="gbreve",
  description="LATIN SMALL LETTER G WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  specials={ "char", 0x0067, 0x0306 },
  uccode=0x011E,
  unicodeslot=0x011F,
 },
 {
  adobename="Gdotaccent",
  category="lu",
  contextname="Gdotaccent",
  description="LATIN CAPITAL LETTER G WITH DOT ABOVE",
  direction="l",
  lccode=0x0121,
  linebreak="al",
  shcode=0x0047,
  specials={ "char", 0x0047, 0x0307 },
  unicodeslot=0x0120,
 },
 {
  adobename="gdotaccent",
  category="ll",
  contextname="gdotaccent",
  description="LATIN SMALL LETTER G WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  specials={ "char", 0x0067, 0x0307 },
  uccode=0x0120,
  unicodeslot=0x0121,
 },
 {
  adobename="Gcommaaccent",
  category="lu",
  contextname="Gcommaaccent",
  description="LATIN CAPITAL LETTER G WITH CEDILLA",
  direction="l",
  lccode=0x0123,
  linebreak="al",
  shcode=0x0047,
  specials={ "char", 0x0047, 0x0327 },
  unicodeslot=0x0122,
 },
 {
  adobename="gcommaaccent",
  category="ll",
  contextname="gcommaaccent",
  description="LATIN SMALL LETTER G WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  specials={ "char", 0x0067, 0x0327 },
  uccode=0x0122,
  unicodeslot=0x0123,
 },
 {
  adobename="Hcircumflex",
  category="lu",
  contextname="Hcircumflex",
  description="LATIN CAPITAL LETTER H WITH CIRCUMFLEX",
  direction="l",
  lccode=0x0125,
  linebreak="al",
  shcode=0x0048,
  specials={ "char", 0x0048, 0x0302 },
  unicodeslot=0x0124,
 },
 {
  adobename="hcircumflex",
  category="ll",
  contextname="hcircumflex",
  description="LATIN SMALL LETTER H WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0068,
  specials={ "char", 0x0068, 0x0302 },
  uccode=0x0124,
  unicodeslot=0x0125,
 },
 {
  adobename="Hbar",
  category="lu",
  cjkwd="a",
  contextname="Hstroke",
  description="LATIN CAPITAL LETTER H WITH STROKE",
  direction="l",
  lccode=0x0127,
  linebreak="al",
  shcode=0x0048,
  unicodeslot=0x0126,
 },
 {
  adobename="hbar",
  category="ll",
  cjkwd="a",
  contextname="hstroke",
  description="LATIN SMALL LETTER H WITH STROKE",
  direction="l",
  linebreak="al",
  mathclass="ord",
  mathname="hbar",
  shcode=0x0068,
  uccode=0x0126,
  unicodeslot=0x0127,
 },
 {
  adobename="Itilde",
  category="lu",
  contextname="Itilde",
  description="LATIN CAPITAL LETTER I WITH TILDE",
  direction="l",
  lccode=0x0129,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0303 },
  unicodeslot=0x0128,
 },
 {
  adobename="itilde",
  category="ll",
  contextname="itilde",
  description="LATIN SMALL LETTER I WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0303 },
  uccode=0x0128,
  unicodeslot=0x0129,
 },
 {
  adobename="Imacron",
  category="lu",
  contextname="Imacron",
  description="LATIN CAPITAL LETTER I WITH MACRON",
  direction="l",
  lccode=0x012B,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0304 },
  unicodeslot=0x012A,
 },
 {
  adobename="imacron",
  category="ll",
  cjkwd="a",
  contextname="imacron",
  description="LATIN SMALL LETTER I WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0304 },
  uccode=0x012A,
  unicodeslot=0x012B,
 },
 {
  adobename="Ibreve",
  category="lu",
  contextname="Ibreve",
  description="LATIN CAPITAL LETTER I WITH BREVE",
  direction="l",
  lccode=0x012D,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0306 },
  unicodeslot=0x012C,
 },
 {
  adobename="ibreve",
  category="ll",
  contextname="ibreve",
  description="LATIN SMALL LETTER I WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0306 },
  uccode=0x012C,
  unicodeslot=0x012D,
 },
 {
  adobename="Iogonek",
  category="lu",
  contextname="Iogonek",
  description="LATIN CAPITAL LETTER I WITH OGONEK",
  direction="l",
  lccode=0x012F,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0328 },
  unicodeslot=0x012E,
 },
 {
  adobename="iogonek",
  category="ll",
  contextname="iogonek",
  description="LATIN SMALL LETTER I WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0328 },
  uccode=0x012E,
  unicodeslot=0x012F,
 },
 {
  adobename="Idotaccent",
  category="lu",
  contextname="Idotaccent",
  description="LATIN CAPITAL LETTER I WITH DOT ABOVE",
  direction="l",
  lccode=0x0069,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0307 },
  unicodeslot=0x0130,
 },
 {
  adobename="dotlessi",
  category="ll",
  cjkwd="a",
  contextname="dotlessi",
  description="LATIN SMALL LETTER DOTLESS I",
  direction="l",
  linebreak="al",
  uccode=0x0049,
  unicodeslot=0x0131,
 },
 {
  adobename="IJ",
  category="lu",
  cjkwd="a",
  contextname="IJligature",
  description="LATIN CAPITAL LIGATURE IJ",
  direction="l",
  lccode=0x0133,
  linebreak="al",
  shcode={ 0x0049, 0x004A },
  specials={ "compat", 0x0049, 0x004A },
  unicodeslot=0x0132,
 },
 {
  adobename="ij",
  category="ll",
  cjkwd="a",
  contextname="ijligature",
  description="LATIN SMALL LIGATURE IJ",
  direction="l",
  linebreak="al",
  shcode={ 0x0069, 0x006A },
  specials={ "compat", 0x0069, 0x006A },
  uccode=0x0132,
  unicodeslot=0x0133,
 },
 {
  adobename="Jcircumflex",
  category="lu",
  contextname="Jcircumflex",
  description="LATIN CAPITAL LETTER J WITH CIRCUMFLEX",
  direction="l",
  lccode=0x0135,
  linebreak="al",
  shcode=0x004A,
  specials={ "char", 0x004A, 0x0302 },
  unicodeslot=0x0134,
 },
 {
  adobename="jcircumflex",
  category="ll",
  contextname="jcircumflex",
  description="LATIN SMALL LETTER J WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x006A,
  specials={ "char", 0x006A, 0x0302 },
  uccode=0x0134,
  unicodeslot=0x0135,
 },
 {
  adobename="Kcommaaccent",
  category="lu",
  contextname="Kcommaaccent",
  description="LATIN CAPITAL LETTER K WITH CEDILLA",
  direction="l",
  lccode=0x0137,
  linebreak="al",
  shcode=0x004B,
  specials={ "char", 0x004B, 0x0327 },
  unicodeslot=0x0136,
 },
 {
  adobename="kcommaaccent",
  category="ll",
  contextname="kcommaaccent",
  description="LATIN SMALL LETTER K WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x006B,
  specials={ "char", 0x006B, 0x0327 },
  uccode=0x0136,
  unicodeslot=0x0137,
 },
 {
  adobename="kgreenlandic",
  category="ll",
  cjkwd="a",
  contextname="kkra",
  description="LATIN SMALL LETTER KRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0138,
 },
 {
  adobename="Lacute",
  category="lu",
  contextname="Lacute",
  description="LATIN CAPITAL LETTER L WITH ACUTE",
  direction="l",
  lccode=0x013A,
  linebreak="al",
  shcode=0x004C,
  specials={ "char", 0x004C, 0x0301 },
  unicodeslot=0x0139,
 },
 {
  adobename="lacute",
  category="ll",
  contextname="lacute",
  description="LATIN SMALL LETTER L WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  specials={ "char", 0x006C, 0x0301 },
  uccode=0x0139,
  unicodeslot=0x013A,
 },
 {
  adobename="Lcommaaccent",
  category="lu",
  contextname="Lcommaaccent",
  description="LATIN CAPITAL LETTER L WITH CEDILLA",
  direction="l",
  lccode=0x013C,
  linebreak="al",
  shcode=0x004C,
  specials={ "char", 0x004C, 0x0327 },
  unicodeslot=0x013B,
 },
 {
  adobename="lcommaaccent",
  category="ll",
  contextname="lcommaaccent",
  description="LATIN SMALL LETTER L WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  specials={ "char", 0x006C, 0x0327 },
  uccode=0x013B,
  unicodeslot=0x013C,
 },
 {
  adobename="Lcaron",
  category="lu",
  contextname="Lcaron",
  description="LATIN CAPITAL LETTER L WITH CARON",
  direction="l",
  lccode=0x013E,
  linebreak="al",
  shcode=0x004C,
  specials={ "char", 0x004C, 0x030C },
  unicodeslot=0x013D,
 },
 {
  adobename="lcaron",
  category="ll",
  contextname="lcaron",
  description="LATIN SMALL LETTER L WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  specials={ "char", 0x006C, 0x030C },
  uccode=0x013D,
  unicodeslot=0x013E,
 },
 {
  adobename="Ldotaccent",
  category="lu",
  cjkwd="a",
  contextname="Ldotmiddle",
  description="LATIN CAPITAL LETTER L WITH MIDDLE DOT",
  direction="l",
  lccode=0x0140,
  linebreak="al",
  shcode=0x004C,
  specials={ "compat", 0x004C, 0x00B7 },
  unicodeslot=0x013F,
 },
 {
  adobename="ldotaccent",
  category="ll",
  cjkwd="a",
  contextname="ldotmiddle",
  description="LATIN SMALL LETTER L WITH MIDDLE DOT",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  specials={ "compat", 0x006C, 0x00B7 },
  uccode=0x013F,
  unicodeslot=0x0140,
 },
 {
  adobename="Lslash",
  category="lu",
  cjkwd="a",
  contextname="Lstroke",
  description="LATIN CAPITAL LETTER L WITH STROKE",
  direction="l",
  lccode=0x0142,
  linebreak="al",
  shcode=0x004C,
  unicodeslot=0x0141,
 },
 {
  adobename="lslash",
  category="ll",
  cjkwd="a",
  contextname="lstroke",
  description="LATIN SMALL LETTER L WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  uccode=0x0141,
  unicodeslot=0x0142,
 },
 {
  adobename="Nacute",
  category="lu",
  contextname="Nacute",
  description="LATIN CAPITAL LETTER N WITH ACUTE",
  direction="l",
  lccode=0x0144,
  linebreak="al",
  shcode=0x004E,
  specials={ "char", 0x004E, 0x0301 },
  unicodeslot=0x0143,
 },
 {
  adobename="nacute",
  category="ll",
  cjkwd="a",
  contextname="nacute",
  description="LATIN SMALL LETTER N WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  specials={ "char", 0x006E, 0x0301 },
  uccode=0x0143,
  unicodeslot=0x0144,
 },
 {
  adobename="Ncommaaccent",
  category="lu",
  contextname="Ncommaaccent",
  description="LATIN CAPITAL LETTER N WITH CEDILLA",
  direction="l",
  lccode=0x0146,
  linebreak="al",
  shcode=0x004E,
  specials={ "char", 0x004E, 0x0327 },
  unicodeslot=0x0145,
 },
 {
  adobename="ncommaaccent",
  category="ll",
  contextname="ncommaaccent",
  description="LATIN SMALL LETTER N WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  specials={ "char", 0x006E, 0x0327 },
  uccode=0x0145,
  unicodeslot=0x0146,
 },
 {
  adobename="Ncaron",
  category="lu",
  contextname="Ncaron",
  description="LATIN CAPITAL LETTER N WITH CARON",
  direction="l",
  lccode=0x0148,
  linebreak="al",
  shcode=0x004E,
  specials={ "char", 0x004E, 0x030C },
  unicodeslot=0x0147,
 },
 {
  adobename="ncaron",
  category="ll",
  cjkwd="a",
  contextname="ncaron",
  description="LATIN SMALL LETTER N WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  specials={ "char", 0x006E, 0x030C },
  uccode=0x0147,
  unicodeslot=0x0148,
 },
 {
  adobename="quoterightn",
  category="ll",
  cjkwd="a",
  contextname="napostrophe",
  description="LATIN SMALL LETTER N PRECEDED BY APOSTROPHE",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x02BC, 0x006E },
  unicodeslot=0x0149,
 },
 {
  adobename="Eng",
  category="lu",
  cjkwd="a",
  contextname="Neng",
  description="LATIN CAPITAL LETTER ENG",
  direction="l",
  lccode=0x014B,
  linebreak="al",
  unicodeslot=0x014A,
 },
 {
  adobename="eng",
  category="ll",
  cjkwd="a",
  contextname="neng",
  description="LATIN SMALL LETTER ENG",
  direction="l",
  linebreak="al",
  uccode=0x014A,
  unicodeslot=0x014B,
 },
 {
  adobename="Omacron",
  category="lu",
  contextname="Omacron",
  description="LATIN CAPITAL LETTER O WITH MACRON",
  direction="l",
  lccode=0x014D,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0304 },
  unicodeslot=0x014C,
 },
 {
  adobename="omacron",
  category="ll",
  cjkwd="a",
  contextname="omacron",
  description="LATIN SMALL LETTER O WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0304 },
  uccode=0x014C,
  unicodeslot=0x014D,
 },
 {
  adobename="Obreve",
  category="lu",
  contextname="Obreve",
  description="LATIN CAPITAL LETTER O WITH BREVE",
  direction="l",
  lccode=0x014F,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0306 },
  unicodeslot=0x014E,
 },
 {
  adobename="obreve",
  category="ll",
  contextname="obreve",
  description="LATIN SMALL LETTER O WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0306 },
  uccode=0x014E,
  unicodeslot=0x014F,
 },
 {
  adobename="Ohungarumlaut",
  category="lu",
  contextname="Ohungarumlaut",
  description="LATIN CAPITAL LETTER O WITH DOUBLE ACUTE",
  direction="l",
  lccode=0x0151,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x030B },
  unicodeslot=0x0150,
 },
 {
  adobename="ohungarumlaut",
  category="ll",
  contextname="ohungarumlaut",
  description="LATIN SMALL LETTER O WITH DOUBLE ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x030B },
  uccode=0x0150,
  unicodeslot=0x0151,
 },
 {
  adobename="OE",
  category="lu",
  cjkwd="a",
  contextname="OEligature",
  description="LATIN CAPITAL LIGATURE OE",
  direction="l",
  lccode=0x0153,
  linebreak="al",
  shcode={ 0x004F, 0x0045 },
  unicodeslot=0x0152,
 },
 {
  adobename="oe",
  category="ll",
  cjkwd="a",
  contextname="oeligature",
  description="LATIN SMALL LIGATURE OE",
  direction="l",
  linebreak="al",
  shcode={ 0x006F, 0x0065 },
  uccode=0x0152,
  unicodeslot=0x0153,
 },
 {
  adobename="Racute",
  category="lu",
  contextname="Racute",
  description="LATIN CAPITAL LETTER R WITH ACUTE",
  direction="l",
  lccode=0x0155,
  linebreak="al",
  shcode=0x0052,
  specials={ "char", 0x0052, 0x0301 },
  unicodeslot=0x0154,
 },
 {
  adobename="racute",
  category="ll",
  contextname="racute",
  description="LATIN SMALL LETTER R WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  specials={ "char", 0x0072, 0x0301 },
  uccode=0x0154,
  unicodeslot=0x0155,
 },
 {
  adobename="Rcommaaccent",
  category="lu",
  contextname="Rcommaaccent",
  description="LATIN CAPITAL LETTER R WITH CEDILLA",
  direction="l",
  lccode=0x0157,
  linebreak="al",
  shcode=0x0052,
  specials={ "char", 0x0052, 0x0327 },
  unicodeslot=0x0156,
 },
 {
  adobename="rcommaaccent",
  category="ll",
  contextname="rcommaaccent",
  description="LATIN SMALL LETTER R WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  specials={ "char", 0x0072, 0x0327 },
  uccode=0x0156,
  unicodeslot=0x0157,
 },
 {
  adobename="Rcaron",
  category="lu",
  contextname="Rcaron",
  description="LATIN CAPITAL LETTER R WITH CARON",
  direction="l",
  lccode=0x0159,
  linebreak="al",
  shcode=0x0052,
  specials={ "char", 0x0052, 0x030C },
  unicodeslot=0x0158,
 },
 {
  adobename="rcaron",
  category="ll",
  contextname="rcaron",
  description="LATIN SMALL LETTER R WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  specials={ "char", 0x0072, 0x030C },
  uccode=0x0158,
  unicodeslot=0x0159,
 },
 {
  adobename="Sacute",
  category="lu",
  contextname="Sacute",
  description="LATIN CAPITAL LETTER S WITH ACUTE",
  direction="l",
  lccode=0x015B,
  linebreak="al",
  shcode=0x0053,
  specials={ "char", 0x0053, 0x0301 },
  unicodeslot=0x015A,
 },
 {
  adobename="sacute",
  category="ll",
  contextname="sacute",
  description="LATIN SMALL LETTER S WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0073,
  specials={ "char", 0x0073, 0x0301 },
  uccode=0x015A,
  unicodeslot=0x015B,
 },
 {
  adobename="Scircumflex",
  category="lu",
  contextname="Scircumflex",
  description="LATIN CAPITAL LETTER S WITH CIRCUMFLEX",
  direction="l",
  lccode=0x015D,
  linebreak="al",
  shcode=0x0053,
  specials={ "char", 0x0053, 0x0302 },
  unicodeslot=0x015C,
 },
 {
  adobename="scircumflex",
  category="ll",
  contextname="scircumflex",
  description="LATIN SMALL LETTER S WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0073,
  specials={ "char", 0x0073, 0x0302 },
  uccode=0x015C,
  unicodeslot=0x015D,
 },
 {
  adobename="Scedilla",
  category="lu",
  contextname="Scedilla",
  description="LATIN CAPITAL LETTER S WITH CEDILLA",
  direction="l",
  lccode=0x015F,
  linebreak="al",
  shcode=0x0053,
  specials={ "char", 0x0053, 0x0327 },
  unicodeslot=0x015E,
 },
 {
  adobename="scedilla",
  category="ll",
  contextname="scedilla",
  description="LATIN SMALL LETTER S WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x0073,
  specials={ "char", 0x0073, 0x0327 },
  uccode=0x015E,
  unicodeslot=0x015F,
 },
 {
  adobename="Scaron",
  category="lu",
  contextname="Scaron",
  description="LATIN CAPITAL LETTER S WITH CARON",
  direction="l",
  lccode=0x0161,
  linebreak="al",
  shcode=0x0053,
  specials={ "char", 0x0053, 0x030C },
  unicodeslot=0x0160,
 },
 {
  adobename="scaron",
  category="ll",
  contextname="scaron",
  description="LATIN SMALL LETTER S WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0073,
  specials={ "char", 0x0073, 0x030C },
  uccode=0x0160,
  unicodeslot=0x0161,
 },
 {
  adobename="Tcommaaccent",
  category="lu",
  contextname="Tcedilla",
  description="LATIN CAPITAL LETTER T WITH CEDILLA",
  direction="l",
  lccode=0x0163,
  linebreak="al",
  shcode=0x0054,
  specials={ "char", 0x0054, 0x0327 },
  unicodeslot=0x0162,
 },
 {
  adobename="tcommaaccent",
  category="ll",
  contextname="tcedilla",
  description="LATIN SMALL LETTER T WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x0074,
  specials={ "char", 0x0074, 0x0327 },
  uccode=0x0162,
  unicodeslot=0x0163,
 },
 {
  adobename="Tcaron",
  category="lu",
  contextname="Tcaron",
  description="LATIN CAPITAL LETTER T WITH CARON",
  direction="l",
  lccode=0x0165,
  linebreak="al",
  shcode=0x0054,
  specials={ "char", 0x0054, 0x030C },
  unicodeslot=0x0164,
 },
 {
  adobename="tcaron",
  category="ll",
  contextname="tcaron",
  description="LATIN SMALL LETTER T WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0074,
  specials={ "char", 0x0074, 0x030C },
  uccode=0x0164,
  unicodeslot=0x0165,
 },
 {
  adobename="Tbar",
  category="lu",
  cjkwd="a",
  contextname="Tstroke",
  description="LATIN CAPITAL LETTER T WITH STROKE",
  direction="l",
  lccode=0x0167,
  linebreak="al",
  shcode=0x0054,
  unicodeslot=0x0166,
 },
 {
  adobename="tbar",
  category="ll",
  cjkwd="a",
  contextname="tstroke",
  description="LATIN SMALL LETTER T WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0074,
  uccode=0x0166,
  unicodeslot=0x0167,
 },
 {
  adobename="Utilde",
  category="lu",
  contextname="Utilde",
  description="LATIN CAPITAL LETTER U WITH TILDE",
  direction="l",
  lccode=0x0169,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x0303 },
  unicodeslot=0x0168,
 },
 {
  adobename="utilde",
  category="ll",
  contextname="utilde",
  description="LATIN SMALL LETTER U WITH TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x0303 },
  uccode=0x0168,
  unicodeslot=0x0169,
 },
 {
  adobename="Umacron",
  category="lu",
  contextname="Umacron",
  description="LATIN CAPITAL LETTER U WITH MACRON",
  direction="l",
  lccode=0x016B,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x0304 },
  unicodeslot=0x016A,
 },
 {
  adobename="umacron",
  category="ll",
  cjkwd="a",
  contextname="umacron",
  description="LATIN SMALL LETTER U WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x0304 },
  uccode=0x016A,
  unicodeslot=0x016B,
 },
 {
  adobename="Ubreve",
  category="lu",
  contextname="Ubreve",
  description="LATIN CAPITAL LETTER U WITH BREVE",
  direction="l",
  lccode=0x016D,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x0306 },
  unicodeslot=0x016C,
 },
 {
  adobename="ubreve",
  category="ll",
  contextname="ubreve",
  description="LATIN SMALL LETTER U WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x0306 },
  uccode=0x016C,
  unicodeslot=0x016D,
 },
 {
  adobename="Uring",
  category="lu",
  contextname="Uring",
  description="LATIN CAPITAL LETTER U WITH RING ABOVE",
  direction="l",
  lccode=0x016F,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x030A },
  unicodeslot=0x016E,
 },
 {
  adobename="uring",
  category="ll",
  contextname="uring",
  description="LATIN SMALL LETTER U WITH RING ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x030A },
  uccode=0x016E,
  unicodeslot=0x016F,
 },
 {
  adobename="Uhungarumlaut",
  category="lu",
  contextname="Uhungarumlaut",
  description="LATIN CAPITAL LETTER U WITH DOUBLE ACUTE",
  direction="l",
  lccode=0x0171,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x030B },
  unicodeslot=0x0170,
 },
 {
  adobename="uhungarumlaut",
  category="ll",
  contextname="uhungarumlaut",
  description="LATIN SMALL LETTER U WITH DOUBLE ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x030B },
  uccode=0x0170,
  unicodeslot=0x0171,
 },
 {
  adobename="Uogonek",
  category="lu",
  contextname="Uogonek",
  description="LATIN CAPITAL LETTER U WITH OGONEK",
  direction="l",
  lccode=0x0173,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x0328 },
  unicodeslot=0x0172,
 },
 {
  adobename="uogonek",
  category="ll",
  contextname="uogonek",
  description="LATIN SMALL LETTER U WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x0328 },
  uccode=0x0172,
  unicodeslot=0x0173,
 },
 {
  adobename="Wcircumflex",
  category="lu",
  contextname="Wcircumflex",
  description="LATIN CAPITAL LETTER W WITH CIRCUMFLEX",
  direction="l",
  lccode=0x0175,
  linebreak="al",
  shcode=0x0057,
  specials={ "char", 0x0057, 0x0302 },
  unicodeslot=0x0174,
 },
 {
  adobename="wcircumflex",
  category="ll",
  contextname="wcircumflex",
  description="LATIN SMALL LETTER W WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0077,
  specials={ "char", 0x0077, 0x0302 },
  uccode=0x0174,
  unicodeslot=0x0175,
 },
 {
  adobename="Ycircumflex",
  category="lu",
  contextname="Ycircumflex",
  description="LATIN CAPITAL LETTER Y WITH CIRCUMFLEX",
  direction="l",
  lccode=0x0177,
  linebreak="al",
  shcode=0x0059,
  specials={ "char", 0x0059, 0x0302 },
  unicodeslot=0x0176,
 },
 {
  adobename="ycircumflex",
  category="ll",
  contextname="ycircumflex",
  description="LATIN SMALL LETTER Y WITH CIRCUMFLEX",
  direction="l",
  linebreak="al",
  shcode=0x0079,
  specials={ "char", 0x0079, 0x0302 },
  uccode=0x0176,
  unicodeslot=0x0177,
 },
 {
  adobename="Ydieresis",
  category="lu",
  contextname="Ydiaeresis",
  description="LATIN CAPITAL LETTER Y WITH DIAERESIS",
  direction="l",
  lccode=0x00FF,
  linebreak="al",
  shcode=0x0059,
  specials={ "char", 0x0059, 0x0308 },
  unicodeslot=0x0178,
 },
 {
  adobename="Zacute",
  category="lu",
  contextname="Zacute",
  description="LATIN CAPITAL LETTER Z WITH ACUTE",
  direction="l",
  lccode=0x017A,
  linebreak="al",
  shcode=0x005A,
  specials={ "char", 0x005A, 0x0301 },
  unicodeslot=0x0179,
 },
 {
  adobename="zacute",
  category="ll",
  contextname="zacute",
  description="LATIN SMALL LETTER Z WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  specials={ "char", 0x007A, 0x0301 },
  uccode=0x0179,
  unicodeslot=0x017A,
 },
 {
  adobename="Zdotaccent",
  category="lu",
  contextname="Zdotaccent",
  description="LATIN CAPITAL LETTER Z WITH DOT ABOVE",
  direction="l",
  lccode=0x017C,
  linebreak="al",
  shcode=0x005A,
  specials={ "char", 0x005A, 0x0307 },
  unicodeslot=0x017B,
 },
 {
  adobename="zdotaccent",
  category="ll",
  contextname="zdotaccent",
  description="LATIN SMALL LETTER Z WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  specials={ "char", 0x007A, 0x0307 },
  uccode=0x017B,
  unicodeslot=0x017C,
 },
 {
  adobename="Zcaron",
  category="lu",
  contextname="Zcaron",
  description="LATIN CAPITAL LETTER Z WITH CARON",
  direction="l",
  lccode=0x017E,
  linebreak="al",
  shcode=0x005A,
  specials={ "char", 0x005A, 0x030C },
  unicodeslot=0x017D,
 },
 {
  adobename="zcaron",
  category="ll",
  contextname="zcaron",
  description="LATIN SMALL LETTER Z WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  specials={ "char", 0x007A, 0x030C },
  uccode=0x017D,
  unicodeslot=0x017E,
 },
 {
  adobename="slong",
  category="ll",
  contextname="slong",
  description="LATIN SMALL LETTER LONG S",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x0073 },
  uccode=0x0053,
  unicodeslot=0x017F,
 },
 {
  adobename="bstroke",
  category="ll",
  contextname="bstroke",
  description="LATIN SMALL LETTER B WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0062,
  uccode=0x0243,
  unicodeslot=0x0180,
 },
 {
  adobename="Bhook",
  category="lu",
  contextname="Bhook",
  description="LATIN CAPITAL LETTER B WITH HOOK",
  direction="l",
  lccode=0x0253,
  linebreak="al",
  shcode=0x0042,
  unicodeslot=0x0181,
 },
 {
  adobename="Btopbar",
  category="lu",
  description="LATIN CAPITAL LETTER B WITH TOPBAR",
  direction="l",
  lccode=0x0183,
  linebreak="al",
  shcode=0x0042,
  unicodeslot=0x0182,
 },
 {
  adobename="btopbar",
  category="ll",
  description="LATIN SMALL LETTER B WITH TOPBAR",
  direction="l",
  linebreak="al",
  shcode=0x0062,
  uccode=0x0182,
  unicodeslot=0x0183,
 },
 {
  adobename="Tonesix",
  category="lu",
  description="LATIN CAPITAL LETTER TONE SIX",
  direction="l",
  lccode=0x0185,
  linebreak="al",
  unicodeslot=0x0184,
 },
 {
  adobename="tonesix",
  category="ll",
  description="LATIN SMALL LETTER TONE SIX",
  direction="l",
  linebreak="al",
  uccode=0x0184,
  unicodeslot=0x0185,
 },
 {
  adobename="Oopen",
  category="lu",
  description="LATIN CAPITAL LETTER OPEN O",
  direction="l",
  lccode=0x0254,
  linebreak="al",
  unicodeslot=0x0186,
 },
 {
  adobename="Chook",
  category="lu",
  contextname="Chook",
  description="LATIN CAPITAL LETTER C WITH HOOK",
  direction="l",
  lccode=0x0188,
  linebreak="al",
  shcode=0x0043,
  unicodeslot=0x0187,
 },
 {
  adobename="chook",
  category="ll",
  contextname="chook",
  description="LATIN SMALL LETTER C WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0063,
  uccode=0x0187,
  unicodeslot=0x0188,
 },
 {
  adobename="Dafrican",
  category="lu",
  contextname="Dafrican",
  description="LATIN CAPITAL LETTER AFRICAN D",
  direction="l",
  lccode=0x0256,
  linebreak="al",
  unicodeslot=0x0189,
 },
 {
  adobename="Dhook",
  category="lu",
  contextname="Dhook",
  description="LATIN CAPITAL LETTER D WITH HOOK",
  direction="l",
  lccode=0x0257,
  linebreak="al",
  shcode=0x0044,
  unicodeslot=0x018A,
 },
 {
  adobename="Dtopbar",
  category="lu",
  description="LATIN CAPITAL LETTER D WITH TOPBAR",
  direction="l",
  lccode=0x018C,
  linebreak="al",
  shcode=0x0044,
  unicodeslot=0x018B,
 },
 {
  adobename="dtopbar",
  category="ll",
  description="LATIN SMALL LETTER D WITH TOPBAR",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  uccode=0x018B,
  unicodeslot=0x018C,
 },
 {
  adobename="deltaturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED DELTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x018D,
 },
 {
  adobename="Ereversed",
  category="lu",
  description="LATIN CAPITAL LETTER REVERSED E",
  direction="l",
  lccode=0x01DD,
  linebreak="al",
  unicodeslot=0x018E,
 },
 {
  adobename="Schwa",
  category="lu",
  contextname="Schwa",
  description="LATIN CAPITAL LETTER SCHWA",
  direction="l",
  lccode=0x0259,
  linebreak="al",
  unicodeslot=0x018F,
 },
 {
  adobename="Eopen",
  category="lu",
  description="LATIN CAPITAL LETTER OPEN E",
  direction="l",
  lccode=0x025B,
  linebreak="al",
  unicodeslot=0x0190,
 },
 {
  adobename="Fhook",
  category="lu",
  contextname="Fhook",
  description="LATIN CAPITAL LETTER F WITH HOOK",
  direction="l",
  lccode=0x0192,
  linebreak="al",
  shcode=0x0046,
  unicodeslot=0x0191,
 },
 {
  adobename="florin",
  category="ll",
  contextname="fhook",
  description="LATIN SMALL LETTER F WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0066,
  uccode=0x0191,
  unicodeslot=0x0192,
 },
 {
  adobename="Ghook",
  category="lu",
  contextname="Ghook",
  description="LATIN CAPITAL LETTER G WITH HOOK",
  direction="l",
  lccode=0x0260,
  linebreak="al",
  shcode=0x0047,
  unicodeslot=0x0193,
 },
 {
  adobename="Gammaafrican",
  category="lu",
  description="LATIN CAPITAL LETTER GAMMA",
  direction="l",
  lccode=0x0263,
  linebreak="al",
  unicodeslot=0x0194,
 },
 {
  adobename="hv",
  category="ll",
  description="LATIN SMALL LETTER HV",
  direction="l",
  linebreak="al",
  uccode=0x01F6,
  unicodeslot=0x0195,
 },
 {
  adobename="Iotaafrican",
  category="lu",
  description="LATIN CAPITAL LETTER IOTA",
  direction="l",
  lccode=0x0269,
  linebreak="al",
  unicodeslot=0x0196,
 },
 {
  adobename="Istroke",
  category="lu",
  contextname="Istroke",
  description="LATIN CAPITAL LETTER I WITH STROKE",
  direction="l",
  lccode=0x0268,
  linebreak="al",
  shcode=0x0049,
  unicodeslot=0x0197,
 },
 {
  adobename="Khook",
  category="lu",
  contextname="Khook",
  description="LATIN CAPITAL LETTER K WITH HOOK",
  direction="l",
  lccode=0x0199,
  linebreak="al",
  shcode=0x004B,
  unicodeslot=0x0198,
 },
 {
  adobename="khook",
  category="ll",
  contextname="khook",
  description="LATIN SMALL LETTER K WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x006B,
  uccode=0x0198,
  unicodeslot=0x0199,
 },
 {
  adobename="lbar",
  category="ll",
  contextname="lbar",
  description="LATIN SMALL LETTER L WITH BAR",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  uccode=0x023D,
  unicodeslot=0x019A,
 },
 {
  adobename="lambdastroke",
  category="ll",
  description="LATIN SMALL LETTER LAMBDA WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x019B,
 },
 {
  adobename="Mturned",
  category="lu",
  description="LATIN CAPITAL LETTER TURNED M",
  direction="l",
  lccode=0x026F,
  linebreak="al",
  unicodeslot=0x019C,
 },
 {
  adobename="Nhookleft",
  category="lu",
  description="LATIN CAPITAL LETTER N WITH LEFT HOOK",
  direction="l",
  lccode=0x0272,
  linebreak="al",
  shcode=0x004E,
  unicodeslot=0x019D,
 },
 {
  adobename="nlegrightlong",
  category="ll",
  description="LATIN SMALL LETTER N WITH LONG RIGHT LEG",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  uccode=0x0220,
  unicodeslot=0x019E,
 },
 {
  adobename="Ocenteredtilde",
  category="lu",
  description="LATIN CAPITAL LETTER O WITH MIDDLE TILDE",
  direction="l",
  lccode=0x0275,
  linebreak="al",
  shcode=0x004F,
  unicodeslot=0x019F,
 },
 {
  adobename="Ohorn",
  category="lu",
  contextname="Ohorn",
  description="LATIN CAPITAL LETTER O WITH HORN",
  direction="l",
  lccode=0x01A1,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x031B },
  unicodeslot=0x01A0,
 },
 {
  adobename="ohorn",
  category="ll",
  contextname="ohorn",
  description="LATIN SMALL LETTER O WITH HORN",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x031B },
  uccode=0x01A0,
  unicodeslot=0x01A1,
 },
 {
  adobename="Oi",
  category="lu",
  description="LATIN CAPITAL LETTER OI",
  direction="l",
  lccode=0x01A3,
  linebreak="al",
  unicodeslot=0x01A2,
 },
 {
  adobename="oi",
  category="ll",
  description="LATIN SMALL LETTER OI",
  direction="l",
  linebreak="al",
  uccode=0x01A2,
  unicodeslot=0x01A3,
 },
 {
  adobename="Phook",
  category="lu",
  contextname="Phook",
  description="LATIN CAPITAL LETTER P WITH HOOK",
  direction="l",
  lccode=0x01A5,
  linebreak="al",
  shcode=0x0050,
  unicodeslot=0x01A4,
 },
 {
  adobename="phook",
  category="ll",
  contextname="phook",
  description="LATIN SMALL LETTER P WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0070,
  uccode=0x01A4,
  unicodeslot=0x01A5,
 },
 {
  adobename="yr",
  category="lu",
  description="LATIN LETTER YR",
  direction="l",
  lccode=0x0280,
  linebreak="al",
  unicodeslot=0x01A6,
 },
 {
  adobename="Tonetwo",
  category="lu",
  description="LATIN CAPITAL LETTER TONE TWO",
  direction="l",
  lccode=0x01A8,
  linebreak="al",
  unicodeslot=0x01A7,
 },
 {
  adobename="tonetwo",
  category="ll",
  description="LATIN SMALL LETTER TONE TWO",
  direction="l",
  linebreak="al",
  uccode=0x01A7,
  unicodeslot=0x01A8,
 },
 {
  adobename="Esh",
  category="lu",
  description="LATIN CAPITAL LETTER ESH",
  direction="l",
  lccode=0x0283,
  linebreak="al",
  unicodeslot=0x01A9,
 },
 {
  adobename="eshreversedloop",
  category="ll",
  description="LATIN LETTER REVERSED ESH LOOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x01AA,
 },
 {
  adobename="tpalatalhook",
  category="ll",
  description="LATIN SMALL LETTER T WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0074,
  unicodeslot=0x01AB,
 },
 {
  adobename="Thook",
  category="lu",
  contextname="Thook",
  description="LATIN CAPITAL LETTER T WITH HOOK",
  direction="l",
  lccode=0x01AD,
  linebreak="al",
  shcode=0x0054,
  unicodeslot=0x01AC,
 },
 {
  adobename="thook",
  category="ll",
  contextname="thook",
  description="LATIN SMALL LETTER T WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0074,
  uccode=0x01AC,
  unicodeslot=0x01AD,
 },
 {
  adobename="Tretroflexhook",
  category="lu",
  description="LATIN CAPITAL LETTER T WITH RETROFLEX HOOK",
  direction="l",
  lccode=0x0288,
  linebreak="al",
  shcode=0x0054,
  unicodeslot=0x01AE,
 },
 {
  adobename="Uhorn",
  category="lu",
  contextname="Uhorn",
  description="LATIN CAPITAL LETTER U WITH HORN",
  direction="l",
  lccode=0x01B0,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x031B },
  unicodeslot=0x01AF,
 },
 {
  adobename="uhorn",
  category="ll",
  contextname="uhorn",
  description="LATIN SMALL LETTER U WITH HORN",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x031B },
  uccode=0x01AF,
  unicodeslot=0x01B0,
 },
 {
  adobename="Upsilonafrican",
  category="lu",
  description="LATIN CAPITAL LETTER UPSILON",
  direction="l",
  lccode=0x028A,
  linebreak="al",
  unicodeslot=0x01B1,
 },
 {
  adobename="Vhook",
  category="lu",
  contextname="Uhook",
  description="LATIN CAPITAL LETTER V WITH HOOK",
  direction="l",
  lccode=0x028B,
  linebreak="al",
  shcode=0x0056,
  unicodeslot=0x01B2,
 },
 {
  adobename="Yhook",
  category="lu",
  contextname="Yhook",
  description="LATIN CAPITAL LETTER Y WITH HOOK",
  direction="l",
  lccode=0x01B4,
  linebreak="al",
  shcode=0x0059,
  unicodeslot=0x01B3,
 },
 {
  adobename="yhook",
  category="ll",
  contextname="yhook",
  description="LATIN SMALL LETTER Y WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0079,
  uccode=0x01B3,
  unicodeslot=0x01B4,
 },
 {
  adobename="Zstroke",
  category="lu",
  contextname="Zstroke",
  description="LATIN CAPITAL LETTER Z WITH STROKE",
  direction="l",
  lccode=0x01B6,
  linebreak="al",
  shcode=0x005A,
  unicodeslot=0x01B5,
 },
 {
  adobename="zstroke",
  category="ll",
  contextname="zstroke",
  description="LATIN SMALL LETTER Z WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  uccode=0x01B5,
  unicodeslot=0x01B6,
 },
 {
  adobename="Ezh",
  category="lu",
  description="LATIN CAPITAL LETTER EZH",
  direction="l",
  lccode=0x0292,
  linebreak="al",
  unicodeslot=0x01B7,
 },
 {
  adobename="Ezhreversed",
  category="lu",
  description="LATIN CAPITAL LETTER EZH REVERSED",
  direction="l",
  lccode=0x01B9,
  linebreak="al",
  unicodeslot=0x01B8,
 },
 {
  adobename="ezhreversed",
  category="ll",
  description="LATIN SMALL LETTER EZH REVERSED",
  direction="l",
  linebreak="al",
  uccode=0x01B8,
  unicodeslot=0x01B9,
 },
 {
  adobename="ezhtail",
  category="ll",
  description="LATIN SMALL LETTER EZH WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x0292,
  unicodeslot=0x01BA,
 },
 {
  adobename="twostroke",
  category="lo",
  description="LATIN LETTER TWO WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x01BB,
 },
 {
  adobename="Tonefive",
  category="lu",
  description="LATIN CAPITAL LETTER TONE FIVE",
  direction="l",
  lccode=0x01BD,
  linebreak="al",
  unicodeslot=0x01BC,
 },
 {
  adobename="tonefive",
  category="ll",
  description="LATIN SMALL LETTER TONE FIVE",
  direction="l",
  linebreak="al",
  uccode=0x01BC,
  unicodeslot=0x01BD,
 },
 {
  adobename="glottalinvertedstroke",
  category="ll",
  description="LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x01BE,
 },
 {
  adobename="wynn",
  category="ll",
  description="LATIN LETTER WYNN",
  direction="l",
  linebreak="al",
  uccode=0x01F7,
  unicodeslot=0x01BF,
 },
 {
  adobename="clickdental",
  category="lo",
  description="LATIN LETTER DENTAL CLICK",
  direction="l",
  linebreak="al",
  unicodeslot=0x01C0,
 },
 {
  adobename="clicklateral",
  category="lo",
  description="LATIN LETTER LATERAL CLICK",
  direction="l",
  linebreak="al",
  unicodeslot=0x01C1,
 },
 {
  adobename="clickalveolar",
  category="lo",
  description="LATIN LETTER ALVEOLAR CLICK",
  direction="l",
  linebreak="al",
  unicodeslot=0x01C2,
 },
 {
  adobename="clickretroflex",
  category="lo",
  description="LATIN LETTER RETROFLEX CLICK",
  direction="l",
  linebreak="al",
  unicodeslot=0x01C3,
 },
 {
  adobename="DZcaron",
  category="lu",
  contextname="DZcaronligature",
  description="LATIN CAPITAL LETTER DZ WITH CARON",
  direction="l",
  lccode=0x01C6,
  linebreak="al",
  shcode=0x01F1,
  specials={ "compat", 0x0044, 0x017D },
  uccode=0x01C5,
  unicodeslot=0x01C4,
 },
 {
  adobename="Dzcaron",
  category="lt",
  contextname="Dzcaronligature",
  description="LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON",
  direction="l",
  lccode=0x01C6,
  linebreak="al",
  shcode=0x01F2,
  specials={ "compat", 0x0044, 0x017E },
  uccode=0x01C4,
  unicodeslot=0x01C5,
 },
 {
  adobename="dzcaron",
  category="ll",
  contextname="dzcaronligature",
  description="LATIN SMALL LETTER DZ WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x01F3,
  specials={ "compat", 0x0064, 0x017E },
  uccode=0x01C4,
  unicodeslot=0x01C6,
 },
 {
  adobename="LJ",
  category="lu",
  contextname="LJligature",
  description="LATIN CAPITAL LETTER LJ",
  direction="l",
  lccode=0x01C9,
  linebreak="al",
  shcode={ 0x004C, 0x004A },
  specials={ "compat", 0x004C, 0x004A },
  uccode=0x01C8,
  unicodeslot=0x01C7,
 },
 {
  adobename="Lj",
  category="lt",
  contextname="Ljligature",
  description="LATIN CAPITAL LETTER L WITH SMALL LETTER J",
  direction="l",
  lccode=0x01C9,
  linebreak="al",
  shcode={ 0x004C, 0x006A },
  specials={ "compat", 0x004C, 0x006A },
  uccode=0x01C7,
  unicodeslot=0x01C8,
 },
 {
  adobename="lj",
  category="ll",
  contextname="ljligature",
  description="LATIN SMALL LETTER LJ",
  direction="l",
  linebreak="al",
  shcode={ 0x006C, 0x006A },
  specials={ "compat", 0x006C, 0x006A },
  uccode=0x01C7,
  unicodeslot=0x01C9,
 },
 {
  adobename="NJ",
  category="lu",
  contextname="NJligature",
  description="LATIN CAPITAL LETTER NJ",
  direction="l",
  lccode=0x01CC,
  linebreak="al",
  shcode={ 0x004E, 0x004A },
  specials={ "compat", 0x004E, 0x004A },
  uccode=0x01CB,
  unicodeslot=0x01CA,
 },
 {
  adobename="Nj",
  category="lt",
  contextname="Njligature",
  description="LATIN CAPITAL LETTER N WITH SMALL LETTER J",
  direction="l",
  lccode=0x01CC,
  linebreak="al",
  shcode=0x004E,
  specials={ "compat", 0x004E, 0x006A },
  uccode=0x01CA,
  unicodeslot=0x01CB,
 },
 {
  adobename="nj",
  category="ll",
  contextname="njligature",
  description="LATIN SMALL LETTER NJ",
  direction="l",
  linebreak="al",
  shcode={ 0x006E, 0x006A },
  specials={ "compat", 0x006E, 0x006A },
  uccode=0x01CA,
  unicodeslot=0x01CC,
 },
 {
  adobename="Acaron",
  category="lu",
  contextname="Acaron",
  description="LATIN CAPITAL LETTER A WITH CARON",
  direction="l",
  lccode=0x01CE,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x030C },
  unicodeslot=0x01CD,
 },
 {
  adobename="acaron",
  category="ll",
  cjkwd="a",
  contextname="acaron",
  description="LATIN SMALL LETTER A WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x030C },
  uccode=0x01CD,
  unicodeslot=0x01CE,
 },
 {
  adobename="Icaron",
  category="lu",
  contextname="Icaron",
  description="LATIN CAPITAL LETTER I WITH CARON",
  direction="l",
  lccode=0x01D0,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x030C },
  unicodeslot=0x01CF,
 },
 {
  adobename="icaron",
  category="ll",
  cjkwd="a",
  contextname="icaron",
  description="LATIN SMALL LETTER I WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x030C },
  uccode=0x01CF,
  unicodeslot=0x01D0,
 },
 {
  adobename="Ocaron",
  category="lu",
  contextname="Ocaron",
  description="LATIN CAPITAL LETTER O WITH CARON",
  direction="l",
  lccode=0x01D2,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x030C },
  unicodeslot=0x01D1,
 },
 {
  adobename="ocaron",
  category="ll",
  cjkwd="a",
  contextname="ocaron",
  description="LATIN SMALL LETTER O WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x030C },
  uccode=0x01D1,
  unicodeslot=0x01D2,
 },
 {
  adobename="Ucaron",
  category="lu",
  contextname="Ucaron",
  description="LATIN CAPITAL LETTER U WITH CARON",
  direction="l",
  lccode=0x01D4,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x030C },
  unicodeslot=0x01D3,
 },
 {
  adobename="ucaron",
  category="ll",
  cjkwd="a",
  contextname="ucaron",
  description="LATIN SMALL LETTER U WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x030C },
  uccode=0x01D3,
  unicodeslot=0x01D4,
 },
 {
  adobename="Udieresismacron",
  category="lu",
  contextname="Udiaeresismacron",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON",
  direction="l",
  lccode=0x01D6,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x00DC, 0x0304 },
  unicodeslot=0x01D5,
 },
 {
  adobename="udieresismacron",
  category="ll",
  cjkwd="a",
  contextname="udiaeresismacron",
  description="LATIN SMALL LETTER U WITH DIAERESIS AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x00FC, 0x0304 },
  uccode=0x01D5,
  unicodeslot=0x01D6,
 },
 {
  adobename="Udieresisacute",
  category="lu",
  contextname="Udiaeresisacute",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE",
  direction="l",
  lccode=0x01D8,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x00DC, 0x0301 },
  unicodeslot=0x01D7,
 },
 {
  adobename="udieresisacute",
  category="ll",
  cjkwd="a",
  contextname="udiaeresisacute",
  description="LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x00FC, 0x0301 },
  uccode=0x01D7,
  unicodeslot=0x01D8,
 },
 {
  adobename="Udieresiscaron",
  category="lu",
  contextname="Udiaeresiscaron",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON",
  direction="l",
  lccode=0x01DA,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x00DC, 0x030C },
  unicodeslot=0x01D9,
 },
 {
  adobename="udieresiscaron",
  category="ll",
  cjkwd="a",
  contextname="udiaeresiscaron",
  description="LATIN SMALL LETTER U WITH DIAERESIS AND CARON",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x00FC, 0x030C },
  uccode=0x01D9,
  unicodeslot=0x01DA,
 },
 {
  adobename="Udieresisgrave",
  category="lu",
  contextname="Udiaeresisgrave",
  description="LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE",
  direction="l",
  lccode=0x01DC,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x00DC, 0x0300 },
  unicodeslot=0x01DB,
 },
 {
  adobename="udieresisgrave",
  category="ll",
  cjkwd="a",
  contextname="udiaeresisgrave",
  description="LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x00FC, 0x0300 },
  uccode=0x01DB,
  unicodeslot=0x01DC,
 },
 {
  adobename="eturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED E",
  direction="l",
  linebreak="al",
  uccode=0x018E,
  unicodeslot=0x01DD,
 },
 {
  adobename="Adieresismacron",
  category="lu",
  contextname="Adiaeresismacron",
  description="LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON",
  direction="l",
  lccode=0x01DF,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x00C4, 0x0304 },
  unicodeslot=0x01DE,
 },
 {
  adobename="adieresismacron",
  category="ll",
  contextname="adiaeresismacron",
  description="LATIN SMALL LETTER A WITH DIAERESIS AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x00E4, 0x0304 },
  uccode=0x01DE,
  unicodeslot=0x01DF,
 },
 {
  adobename="Adotmacron",
  category="lu",
  contextname="Adotaccentmacron",
  description="LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON",
  direction="l",
  lccode=0x01E1,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0226, 0x0304 },
  unicodeslot=0x01E0,
 },
 {
  adobename="adotmacron",
  category="ll",
  contextname="adotaccentmacron",
  description="LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0227, 0x0304 },
  uccode=0x01E0,
  unicodeslot=0x01E1,
 },
 {
  adobename="AEmacron",
  category="lu",
  contextname="AEmacron",
  description="LATIN CAPITAL LETTER AE WITH MACRON",
  direction="l",
  lccode=0x01E3,
  linebreak="al",
  shcode=0x00C6,
  specials={ "char", 0x00C6, 0x0304 },
  unicodeslot=0x01E2,
 },
 {
  adobename="aemacron",
  category="ll",
  contextname="aemacron",
  description="LATIN SMALL LETTER AE WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x00E6,
  specials={ "char", 0x00E6, 0x0304 },
  uccode=0x01E2,
  unicodeslot=0x01E3,
 },
 {
  adobename="Gstroke",
  category="lu",
  contextname="Gstroke",
  description="LATIN CAPITAL LETTER G WITH STROKE",
  direction="l",
  lccode=0x01E5,
  linebreak="al",
  shcode=0x0047,
  unicodeslot=0x01E4,
 },
 {
  adobename="gstroke",
  category="ll",
  contextname="gstroke",
  description="LATIN SMALL LETTER G WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  uccode=0x01E4,
  unicodeslot=0x01E5,
 },
 {
  adobename="Gcaron",
  category="lu",
  contextname="Gcaron",
  description="LATIN CAPITAL LETTER G WITH CARON",
  direction="l",
  lccode=0x01E7,
  linebreak="al",
  shcode=0x0047,
  specials={ "char", 0x0047, 0x030C },
  unicodeslot=0x01E6,
 },
 {
  adobename="gcaron",
  category="ll",
  contextname="gcaron",
  description="LATIN SMALL LETTER G WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  specials={ "char", 0x0067, 0x030C },
  uccode=0x01E6,
  unicodeslot=0x01E7,
 },
 {
  adobename="Kcaron",
  category="lu",
  contextname="Kcaron",
  description="LATIN CAPITAL LETTER K WITH CARON",
  direction="l",
  lccode=0x01E9,
  linebreak="al",
  shcode=0x004B,
  specials={ "char", 0x004B, 0x030C },
  unicodeslot=0x01E8,
 },
 {
  adobename="kcaron",
  category="ll",
  contextname="kcaron",
  description="LATIN SMALL LETTER K WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x006B,
  specials={ "char", 0x006B, 0x030C },
  uccode=0x01E8,
  unicodeslot=0x01E9,
 },
 {
  adobename="Oogonek",
  category="lu",
  contextname="Oogonek",
  description="LATIN CAPITAL LETTER O WITH OGONEK",
  direction="l",
  lccode=0x01EB,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0328 },
  unicodeslot=0x01EA,
 },
 {
  adobename="oogonek",
  category="ll",
  contextname="oogonek",
  description="LATIN SMALL LETTER O WITH OGONEK",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0328 },
  uccode=0x01EA,
  unicodeslot=0x01EB,
 },
 {
  adobename="Oogonekmacron",
  category="lu",
  contextname="Oogonekmacron",
  description="LATIN CAPITAL LETTER O WITH OGONEK AND MACRON",
  direction="l",
  lccode=0x01ED,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x01EA, 0x0304 },
  unicodeslot=0x01EC,
 },
 {
  adobename="oogonekmacron",
  category="ll",
  contextname="oogonekmacron",
  description="LATIN SMALL LETTER O WITH OGONEK AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x01EB, 0x0304 },
  uccode=0x01EC,
  unicodeslot=0x01ED,
 },
 {
  adobename="Ezhcaron",
  category="lu",
  description="LATIN CAPITAL LETTER EZH WITH CARON",
  direction="l",
  lccode=0x01EF,
  linebreak="al",
  shcode=0x01B7,
  specials={ "char", 0x01B7, 0x030C },
  unicodeslot=0x01EE,
 },
 {
  adobename="ezhcaron",
  category="ll",
  description="LATIN SMALL LETTER EZH WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0292,
  specials={ "char", 0x0292, 0x030C },
  uccode=0x01EE,
  unicodeslot=0x01EF,
 },
 {
  adobename="jcaron",
  category="ll",
  contextname="jcaron",
  description="LATIN SMALL LETTER J WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x006A,
  specials={ "char", 0x006A, 0x030C },
  unicodeslot=0x01F0,
 },
 {
  adobename="DZ",
  category="lu",
  contextname="DZligature",
  description="LATIN CAPITAL LETTER DZ",
  direction="l",
  lccode=0x01F3,
  linebreak="al",
  specials={ "compat", 0x0044, 0x005A },
  uccode=0x01F2,
  unicodeslot=0x01F1,
 },
 {
  adobename="Dz",
  category="lt",
  contextname="Dzligature",
  description="LATIN CAPITAL LETTER D WITH SMALL LETTER Z",
  direction="l",
  lccode=0x01F3,
  linebreak="al",
  shcode=0x0044,
  specials={ "compat", 0x0044, 0x007A },
  uccode=0x01F1,
  unicodeslot=0x01F2,
 },
 {
  adobename="dz",
  category="ll",
  contextname="dzligature",
  description="LATIN SMALL LETTER DZ",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x0064, 0x007A },
  uccode=0x01F1,
  unicodeslot=0x01F3,
 },
 {
  adobename="Gacute",
  category="lu",
  contextname="Gacute",
  description="LATIN CAPITAL LETTER G WITH ACUTE",
  direction="l",
  lccode=0x01F5,
  linebreak="al",
  shcode=0x0047,
  specials={ "char", 0x0047, 0x0301 },
  unicodeslot=0x01F4,
 },
 {
  adobename="gacute",
  category="ll",
  contextname="gacute",
  description="LATIN SMALL LETTER G WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  specials={ "char", 0x0067, 0x0301 },
  uccode=0x01F4,
  unicodeslot=0x01F5,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER HWAIR",
  direction="l",
  lccode=0x0195,
  linebreak="al",
  unicodeslot=0x01F6,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER WYNN",
  direction="l",
  lccode=0x01BF,
  linebreak="al",
  unicodeslot=0x01F7,
 },
 {
  category="lu",
  contextname="Ngrave",
  description="LATIN CAPITAL LETTER N WITH GRAVE",
  direction="l",
  lccode=0x01F9,
  linebreak="al",
  shcode=0x004E,
  specials={ "char", 0x004E, 0x0300 },
  unicodeslot=0x01F8,
 },
 {
  category="ll",
  contextname="ngrave",
  description="LATIN SMALL LETTER N WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  specials={ "char", 0x006E, 0x0300 },
  uccode=0x01F8,
  unicodeslot=0x01F9,
 },
 {
  adobename="Aringacute",
  category="lu",
  contextname="Aringacute",
  description="LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE",
  direction="l",
  lccode=0x01FB,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x00C5, 0x0301 },
  unicodeslot=0x01FA,
 },
 {
  adobename="aringacute",
  category="ll",
  contextname="aringacute",
  description="LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x00E5, 0x0301 },
  uccode=0x01FA,
  unicodeslot=0x01FB,
 },
 {
  adobename="AEacute",
  category="lu",
  contextname="AEacute",
  description="LATIN CAPITAL LETTER AE WITH ACUTE",
  direction="l",
  lccode=0x01FD,
  linebreak="al",
  shcode=0x00C6,
  specials={ "char", 0x00C6, 0x0301 },
  unicodeslot=0x01FC,
 },
 {
  adobename="aeacute",
  category="ll",
  contextname="aeacute",
  description="LATIN SMALL LETTER AE WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x00E6,
  specials={ "char", 0x00E6, 0x0301 },
  uccode=0x01FC,
  unicodeslot=0x01FD,
 },
 {
  adobename="Ostrokeacute",
  category="lu",
  contextname="Ostrokeacute",
  description="LATIN CAPITAL LETTER O WITH STROKE AND ACUTE",
  direction="l",
  lccode=0x01FF,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x00D8, 0x0301 },
  unicodeslot=0x01FE,
 },
 {
  adobename="ostrokeacute",
  category="ll",
  contextname="ostrokeacute",
  description="LATIN SMALL LETTER O WITH STROKE AND ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x00F8, 0x0301 },
  uccode=0x01FE,
  unicodeslot=0x01FF,
 },
 {
  adobename="Adblgrave",
  category="lu",
  contextname="Adoublegrave",
  description="LATIN CAPITAL LETTER A WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x0201,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x030F },
  unicodeslot=0x0200,
 },
 {
  adobename="adblgrave",
  category="ll",
  contextname="adoublegrave",
  description="LATIN SMALL LETTER A WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x030F },
  uccode=0x0200,
  unicodeslot=0x0201,
 },
 {
  adobename="Ainvertedbreve",
  category="lu",
  contextname="Ainvertedbreve",
  description="LATIN CAPITAL LETTER A WITH INVERTED BREVE",
  direction="l",
  lccode=0x0203,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0311 },
  unicodeslot=0x0202,
 },
 {
  adobename="ainvertedbreve",
  category="ll",
  contextname="ainvertedbreve",
  description="LATIN SMALL LETTER A WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0311 },
  uccode=0x0202,
  unicodeslot=0x0203,
 },
 {
  adobename="Edblgrave",
  category="lu",
  contextname="Edoublegrave",
  description="LATIN CAPITAL LETTER E WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x0205,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x030F },
  unicodeslot=0x0204,
 },
 {
  adobename="edblgrave",
  category="ll",
  contextname="edoublegrave",
  description="LATIN SMALL LETTER E WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x030F },
  uccode=0x0204,
  unicodeslot=0x0205,
 },
 {
  adobename="Einvertedbreve",
  category="lu",
  contextname="Einvertedbreve",
  description="LATIN CAPITAL LETTER E WITH INVERTED BREVE",
  direction="l",
  lccode=0x0207,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0311 },
  unicodeslot=0x0206,
 },
 {
  adobename="einvertedbreve",
  category="ll",
  contextname="einvertedbreve",
  description="LATIN SMALL LETTER E WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0311 },
  uccode=0x0206,
  unicodeslot=0x0207,
 },
 {
  adobename="Idblgrave",
  category="lu",
  contextname="Idoublegrave",
  description="LATIN CAPITAL LETTER I WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x0209,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x030F },
  unicodeslot=0x0208,
 },
 {
  adobename="idblgrave",
  category="ll",
  contextname="idoublegrave",
  description="LATIN SMALL LETTER I WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x030F },
  uccode=0x0208,
  unicodeslot=0x0209,
 },
 {
  adobename="Iinvertedbreve",
  category="lu",
  contextname="Iinvertedbreve",
  description="LATIN CAPITAL LETTER I WITH INVERTED BREVE",
  direction="l",
  lccode=0x020B,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0311 },
  unicodeslot=0x020A,
 },
 {
  adobename="iinvertedbreve",
  category="ll",
  contextname="iinvertedbreve",
  description="LATIN SMALL LETTER I WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0311 },
  uccode=0x020A,
  unicodeslot=0x020B,
 },
 {
  adobename="Odblgrave",
  category="lu",
  contextname="Odoublegrave",
  description="LATIN CAPITAL LETTER O WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x020D,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x030F },
  unicodeslot=0x020C,
 },
 {
  adobename="odblgrave",
  category="ll",
  contextname="odoublegrave",
  description="LATIN SMALL LETTER O WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x030F },
  uccode=0x020C,
  unicodeslot=0x020D,
 },
 {
  adobename="Oinvertedbreve",
  category="lu",
  contextname="Oinvertedbreve",
  description="LATIN CAPITAL LETTER O WITH INVERTED BREVE",
  direction="l",
  lccode=0x020F,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0311 },
  unicodeslot=0x020E,
 },
 {
  adobename="oinvertedbreve",
  category="ll",
  contextname="oinvertedbreve",
  description="LATIN SMALL LETTER O WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0311 },
  uccode=0x020E,
  unicodeslot=0x020F,
 },
 {
  adobename="Rdblgrave",
  category="lu",
  contextname="Rdoublegrave",
  description="LATIN CAPITAL LETTER R WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x0211,
  linebreak="al",
  shcode=0x0052,
  specials={ "char", 0x0052, 0x030F },
  unicodeslot=0x0210,
 },
 {
  adobename="rdblgrave",
  category="ll",
  contextname="rdoublegrave",
  description="LATIN SMALL LETTER R WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  specials={ "char", 0x0072, 0x030F },
  uccode=0x0210,
  unicodeslot=0x0211,
 },
 {
  adobename="Rinvertedbreve",
  category="lu",
  contextname="Rinvertedbreve",
  description="LATIN CAPITAL LETTER R WITH INVERTED BREVE",
  direction="l",
  lccode=0x0213,
  linebreak="al",
  shcode=0x0052,
  specials={ "char", 0x0052, 0x0311 },
  unicodeslot=0x0212,
 },
 {
  adobename="rinvertedbreve",
  category="ll",
  contextname="rinvertedbreve",
  description="LATIN SMALL LETTER R WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  specials={ "char", 0x0072, 0x0311 },
  uccode=0x0212,
  unicodeslot=0x0213,
 },
 {
  adobename="Udblgrave",
  category="lu",
  contextname="Udoublegrave",
  description="LATIN CAPITAL LETTER U WITH DOUBLE GRAVE",
  direction="l",
  lccode=0x0215,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x030F },
  unicodeslot=0x0214,
 },
 {
  adobename="udblgrave",
  category="ll",
  contextname="udoublegrave",
  description="LATIN SMALL LETTER U WITH DOUBLE GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x030F },
  uccode=0x0214,
  unicodeslot=0x0215,
 },
 {
  adobename="Uinvertedbreve",
  category="lu",
  contextname="Uinvertedbreve",
  description="LATIN CAPITAL LETTER U WITH INVERTED BREVE",
  direction="l",
  lccode=0x0217,
  linebreak="al",
  shcode=0x0055,
  specials={ "char", 0x0055, 0x0311 },
  unicodeslot=0x0216,
 },
 {
  adobename="uinvertedbreve",
  category="ll",
  contextname="uinvertedbreve",
  description="LATIN SMALL LETTER U WITH INVERTED BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  specials={ "char", 0x0075, 0x0311 },
  uccode=0x0216,
  unicodeslot=0x0217,
 },
 {
  adobename="Scommaaccent",
  category="lu",
  contextname="Scommaaccent",
  description="LATIN CAPITAL LETTER S WITH COMMA BELOW",
  direction="l",
  lccode=0x0219,
  linebreak="al",
  shcode=0x0053,
  specials={ "char", 0x0053, 0x0326 },
  unicodeslot=0x0218,
 },
 {
  adobename="scommaaccent",
  category="ll",
  contextname="scommaaccent",
  description="LATIN SMALL LETTER S WITH COMMA BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0073,
  specials={ "char", 0x0073, 0x0326 },
  uccode=0x0218,
  unicodeslot=0x0219,
 },
 {
  category="lu",
  contextname="Tcommaaccent",
  description="LATIN CAPITAL LETTER T WITH COMMA BELOW",
  direction="l",
  lccode=0x021B,
  linebreak="al",
  shcode=0x0054,
  specials={ "char", 0x0054, 0x0326 },
  unicodeslot=0x021A,
 },
 {
  category="ll",
  contextname="tcommaaccent",
  description="LATIN SMALL LETTER T WITH COMMA BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0074,
  specials={ "char", 0x0074, 0x0326 },
  uccode=0x021A,
  unicodeslot=0x021B,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER YOGH",
  direction="l",
  lccode=0x021D,
  linebreak="al",
  unicodeslot=0x021C,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER YOGH",
  direction="l",
  linebreak="al",
  uccode=0x021C,
  unicodeslot=0x021D,
 },
 {
  category="lu",
  contextname="Hcaron",
  description="LATIN CAPITAL LETTER H WITH CARON",
  direction="l",
  lccode=0x021F,
  linebreak="al",
  shcode=0x0048,
  specials={ "char", 0x0048, 0x030C },
  unicodeslot=0x021E,
 },
 {
  category="ll",
  contextname="hcaron",
  description="LATIN SMALL LETTER H WITH CARON",
  direction="l",
  linebreak="al",
  shcode=0x0068,
  specials={ "char", 0x0068, 0x030C },
  uccode=0x021E,
  unicodeslot=0x021F,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER N WITH LONG RIGHT LEG",
  direction="l",
  lccode=0x019E,
  linebreak="al",
  shcode=0x004E,
  unicodeslot=0x0220,
 },
 {
  category="ll",
  contextname="dcurl",
  description="LATIN SMALL LETTER D WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  unicodeslot=0x0221,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER OU",
  direction="l",
  lccode=0x0223,
  linebreak="al",
  unicodeslot=0x0222,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER OU",
  direction="l",
  linebreak="al",
  uccode=0x0222,
  unicodeslot=0x0223,
 },
 {
  category="lu",
  contextname="Zhook",
  description="LATIN CAPITAL LETTER Z WITH HOOK",
  direction="l",
  lccode=0x0225,
  linebreak="al",
  shcode=0x005A,
  unicodeslot=0x0224,
 },
 {
  category="ll",
  contextname="zhook",
  description="LATIN SMALL LETTER Z WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  uccode=0x0224,
  unicodeslot=0x0225,
 },
 {
  category="lu",
  contextname="Adotaccent",
  description="LATIN CAPITAL LETTER A WITH DOT ABOVE",
  direction="l",
  lccode=0x0227,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0307 },
  unicodeslot=0x0226,
 },
 {
  category="ll",
  contextname="adotaccent",
  description="LATIN SMALL LETTER A WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0307 },
  uccode=0x0226,
  unicodeslot=0x0227,
 },
 {
  category="lu",
  contextname="Ecedilla",
  description="LATIN CAPITAL LETTER E WITH CEDILLA",
  direction="l",
  lccode=0x0229,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0327 },
  unicodeslot=0x0228,
 },
 {
  category="ll",
  contextname="ecedilla",
  description="LATIN SMALL LETTER E WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0327 },
  uccode=0x0228,
  unicodeslot=0x0229,
 },
 {
  category="lu",
  contextname="Odiaeresismacron",
  description="LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON",
  direction="l",
  lccode=0x022B,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x00D6, 0x0304 },
  unicodeslot=0x022A,
 },
 {
  category="ll",
  contextname="odiaeresismacron",
  description="LATIN SMALL LETTER O WITH DIAERESIS AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x00F6, 0x0304 },
  uccode=0x022A,
  unicodeslot=0x022B,
 },
 {
  category="lu",
  contextname="Otildemacron",
  description="LATIN CAPITAL LETTER O WITH TILDE AND MACRON",
  direction="l",
  lccode=0x022D,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x00D5, 0x0304 },
  unicodeslot=0x022C,
 },
 {
  category="ll",
  contextname="otildemacron",
  description="LATIN SMALL LETTER O WITH TILDE AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x00F5, 0x0304 },
  uccode=0x022C,
  unicodeslot=0x022D,
 },
 {
  category="lu",
  contextname="Odotaccent",
  description="LATIN CAPITAL LETTER O WITH DOT ABOVE",
  direction="l",
  lccode=0x022F,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x004F, 0x0307 },
  unicodeslot=0x022E,
 },
 {
  category="ll",
  contextname="odotaccent",
  description="LATIN SMALL LETTER O WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x006F, 0x0307 },
  uccode=0x022E,
  unicodeslot=0x022F,
 },
 {
  category="lu",
  contextname="Odotaccentmacron",
  description="LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON",
  direction="l",
  lccode=0x0231,
  linebreak="al",
  shcode=0x004F,
  specials={ "char", 0x022E, 0x0304 },
  unicodeslot=0x0230,
 },
 {
  category="ll",
  contextname="odotaccentmacron",
  description="LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x006F,
  specials={ "char", 0x022F, 0x0304 },
  uccode=0x0230,
  unicodeslot=0x0231,
 },
 {
  category="lu",
  contextname="Ymacron",
  description="LATIN CAPITAL LETTER Y WITH MACRON",
  direction="l",
  lccode=0x0233,
  linebreak="al",
  shcode=0x0059,
  specials={ "char", 0x0059, 0x0304 },
  unicodeslot=0x0232,
 },
 {
  category="ll",
  contextname="ymacron",
  description="LATIN SMALL LETTER Y WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0079,
  specials={ "char", 0x0079, 0x0304 },
  uccode=0x0232,
  unicodeslot=0x0233,
 },
 {
  category="ll",
  contextname="lcurl",
  description="LATIN SMALL LETTER L WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  unicodeslot=0x0234,
 },
 {
  category="ll",
  contextname="ncurl",
  description="LATIN SMALL LETTER N WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  unicodeslot=0x0235,
 },
 {
  category="ll",
  contextname="tcurl",
  description="LATIN SMALL LETTER T WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x0074,
  unicodeslot=0x0236,
 },
 {
  category="ll",
  contextname="dotlessj",
  description="LATIN SMALL LETTER DOTLESS J",
  direction="l",
  linebreak="al",
  unicodeslot=0x0237,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER DB DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x0238,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER QP DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x0239,
 },
 {
  category="lu",
  contextname="Astroke",
  description="LATIN CAPITAL LETTER A WITH STROKE",
  direction="l",
  lccode=0x2C65,
  linebreak="al",
  shcode=0x0041,
  unicodeslot=0x023A,
 },
 {
  category="lu",
  contextname="Cstroke",
  description="LATIN CAPITAL LETTER C WITH STROKE",
  direction="l",
  lccode=0x023C,
  linebreak="al",
  shcode=0x0043,
  unicodeslot=0x023B,
 },
 {
  category="ll",
  contextname="cstroke",
  description="LATIN SMALL LETTER C WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0063,
  uccode=0x023B,
  unicodeslot=0x023C,
 },
 {
  category="lu",
  contextname="Lbar",
  description="LATIN CAPITAL LETTER L WITH BAR",
  direction="l",
  lccode=0x019A,
  linebreak="al",
  shcode=0x004C,
  unicodeslot=0x023D,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER T WITH DIAGONAL STROKE",
  direction="l",
  lccode=0x2C66,
  linebreak="al",
  shcode=0x0054,
  unicodeslot=0x023E,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER S WITH SWASH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x0073,
  unicodeslot=0x023F,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER Z WITH SWASH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  unicodeslot=0x0240,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER GLOTTAL STOP",
  direction="l",
  lccode=0x0242,
  linebreak="al",
  unicodeslot=0x0241,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER GLOTTAL STOP",
  direction="l",
  linebreak="al",
  uccode=0x0241,
  unicodeslot=0x0242,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER B WITH STROKE",
  direction="l",
  lccode=0x0180,
  linebreak="al",
  shcode=0x0042,
  unicodeslot=0x0243,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER U BAR",
  direction="l",
  lccode=0x0289,
  linebreak="al",
  unicodeslot=0x0244,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER TURNED V",
  direction="l",
  lccode=0x028C,
  linebreak="al",
  unicodeslot=0x0245,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER E WITH STROKE",
  direction="l",
  lccode=0x0247,
  linebreak="al",
  shcode=0x0045,
  unicodeslot=0x0246,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER E WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  uccode=0x0246,
  unicodeslot=0x0247,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER J WITH STROKE",
  direction="l",
  lccode=0x0249,
  linebreak="al",
  shcode=0x004A,
  unicodeslot=0x0248,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER J WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x006A,
  uccode=0x0248,
  unicodeslot=0x0249,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL",
  direction="l",
  lccode=0x024B,
  linebreak="al",
  unicodeslot=0x024A,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER Q WITH HOOK TAIL",
  direction="l",
  linebreak="al",
  shcode=0x0071,
  uccode=0x024A,
  unicodeslot=0x024B,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER R WITH STROKE",
  direction="l",
  lccode=0x024D,
  linebreak="al",
  shcode=0x0052,
  unicodeslot=0x024C,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER R WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  uccode=0x024C,
  unicodeslot=0x024D,
 },
 {
  category="lu",
  description="LATIN CAPITAL LETTER Y WITH STROKE",
  direction="l",
  lccode=0x024F,
  linebreak="al",
  shcode=0x0059,
  unicodeslot=0x024E,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER Y WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0079,
  uccode=0x024E,
  unicodeslot=0x024F,
 },
 {
  adobename="aturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0250,
 },
 {
  adobename="ascript",
  category="ll",
  cjkwd="a",
  description="LATIN SMALL LETTER ALPHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0251,
 },
 {
  adobename="ascriptturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED ALPHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0252,
 },
 {
  adobename="bhook",
  category="ll",
  contextname="bhook",
  description="LATIN SMALL LETTER B WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0062,
  uccode=0x0181,
  unicodeslot=0x0253,
 },
 {
  adobename="oopen",
  category="ll",
  description="LATIN SMALL LETTER OPEN O",
  direction="l",
  linebreak="al",
  uccode=0x0186,
  unicodeslot=0x0254,
 },
 {
  adobename="ccurl",
  category="ll",
  contextname="ccurl",
  description="LATIN SMALL LETTER C WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x0063,
  unicodeslot=0x0255,
 },
 {
  adobename="dtail",
  category="ll",
  contextname="dtail",
  description="LATIN SMALL LETTER D WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  uccode=0x0189,
  unicodeslot=0x0256,
 },
 {
  adobename="dhook",
  category="ll",
  contextname="dhook",
  description="LATIN SMALL LETTER D WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  uccode=0x018A,
  unicodeslot=0x0257,
 },
 {
  adobename="ereversed",
  category="ll",
  description="LATIN SMALL LETTER REVERSED E",
  direction="l",
  linebreak="al",
  unicodeslot=0x0258,
 },
 {
  adobename="schwa",
  category="ll",
  contextname="schwa",
  description="LATIN SMALL LETTER SCHWA",
  direction="l",
  linebreak="al",
  uccode=0x018F,
  unicodeslot=0x0259,
 },
 {
  adobename="schwahook",
  category="ll",
  contextname="schwahook",
  description="LATIN SMALL LETTER SCHWA WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0259,
  unicodeslot=0x025A,
 },
 {
  adobename="eopen",
  category="ll",
  description="LATIN SMALL LETTER OPEN E",
  direction="l",
  linebreak="al",
  uccode=0x0190,
  unicodeslot=0x025B,
 },
 {
  adobename="eopenreversed",
  category="ll",
  description="LATIN SMALL LETTER REVERSED OPEN E",
  direction="l",
  linebreak="al",
  unicodeslot=0x025C,
 },
 {
  adobename="eopenreversedhook",
  category="ll",
  description="LATIN SMALL LETTER REVERSED OPEN E WITH HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x025D,
 },
 {
  adobename="eopenreversedclosed",
  category="ll",
  description="LATIN SMALL LETTER CLOSED REVERSED OPEN E",
  direction="l",
  linebreak="al",
  unicodeslot=0x025E,
 },
 {
  adobename="jdotlessstroke",
  category="ll",
  contextname="dotlessjstroke",
  description="LATIN SMALL LETTER DOTLESS J WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x025F,
 },
 {
  adobename="ghook",
  category="ll",
  description="LATIN SMALL LETTER G WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  uccode=0x0193,
  unicodeslot=0x0260,
 },
 {
  adobename="gscript",
  category="ll",
  cjkwd="a",
  description="LATIN SMALL LETTER SCRIPT G",
  direction="l",
  linebreak="al",
  unicodeslot=0x0261,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL G",
  direction="l",
  linebreak="al",
  unicodeslot=0x0262,
 },
 {
  adobename="gammalatinsmall",
  category="ll",
  description="LATIN SMALL LETTER GAMMA",
  direction="l",
  linebreak="al",
  uccode=0x0194,
  unicodeslot=0x0263,
 },
 {
  adobename="ramshorn",
  category="ll",
  description="LATIN SMALL LETTER RAMS HORN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0264,
 },
 {
  adobename="hturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED H",
  direction="l",
  linebreak="al",
  unicodeslot=0x0265,
 },
 {
  adobename="hhook",
  category="ll",
  description="LATIN SMALL LETTER H WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0068,
  unicodeslot=0x0266,
 },
 {
  adobename="henghook",
  category="ll",
  description="LATIN SMALL LETTER HENG WITH HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x0267,
 },
 {
  adobename="istroke",
  category="ll",
  description="LATIN SMALL LETTER I WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  uccode=0x0197,
  unicodeslot=0x0268,
 },
 {
  adobename="iotalatin",
  category="ll",
  description="LATIN SMALL LETTER IOTA",
  direction="l",
  linebreak="al",
  uccode=0x0196,
  unicodeslot=0x0269,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL I",
  direction="l",
  linebreak="al",
  unicodeslot=0x026A,
 },
 {
  adobename="lmiddletilde",
  category="ll",
  description="LATIN SMALL LETTER L WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  uccode=0x2C62,
  unicodeslot=0x026B,
 },
 {
  adobename="lbelt",
  category="ll",
  description="LATIN SMALL LETTER L WITH BELT",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  unicodeslot=0x026C,
 },
 {
  adobename="lhookretroflex",
  category="ll",
  description="LATIN SMALL LETTER L WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  unicodeslot=0x026D,
 },
 {
  adobename="lezh",
  category="ll",
  description="LATIN SMALL LETTER LEZH",
  direction="l",
  linebreak="al",
  unicodeslot=0x026E,
 },
 {
  adobename="mturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED M",
  direction="l",
  linebreak="al",
  uccode=0x019C,
  unicodeslot=0x026F,
 },
 {
  adobename="mlonglegturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED M WITH LONG LEG",
  direction="l",
  linebreak="al",
  unicodeslot=0x0270,
 },
 {
  adobename="mhook",
  category="ll",
  description="LATIN SMALL LETTER M WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x006D,
  unicodeslot=0x0271,
 },
 {
  adobename="nhookleft",
  category="ll",
  description="LATIN SMALL LETTER N WITH LEFT HOOK",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  uccode=0x019D,
  unicodeslot=0x0272,
 },
 {
  adobename="nhookretroflex",
  category="ll",
  description="LATIN SMALL LETTER N WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  unicodeslot=0x0273,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL N",
  direction="l",
  linebreak="al",
  unicodeslot=0x0274,
 },
 {
  adobename="obarred",
  category="ll",
  description="LATIN SMALL LETTER BARRED O",
  direction="l",
  linebreak="al",
  uccode=0x019F,
  unicodeslot=0x0275,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0276,
 },
 {
  adobename="omegalatinclosed",
  category="ll",
  description="LATIN SMALL LETTER CLOSED OMEGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0277,
 },
 {
  adobename="philatin",
  category="ll",
  description="LATIN SMALL LETTER PHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0278,
 },
 {
  adobename="rturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED R",
  direction="l",
  linebreak="al",
  unicodeslot=0x0279,
 },
 {
  adobename="rlonglegturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED R WITH LONG LEG",
  direction="l",
  linebreak="al",
  unicodeslot=0x027A,
 },
 {
  adobename="rhookturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED R WITH HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x027B,
 },
 {
  adobename="rlongleg",
  category="ll",
  description="LATIN SMALL LETTER R WITH LONG LEG",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  unicodeslot=0x027C,
 },
 {
  adobename="rhook",
  category="ll",
  description="LATIN SMALL LETTER R WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  uccode=0x2C64,
  unicodeslot=0x027D,
 },
 {
  adobename="rfishhook",
  category="ll",
  description="LATIN SMALL LETTER R WITH FISHHOOK",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  unicodeslot=0x027E,
 },
 {
  adobename="rfishhookreversed",
  category="ll",
  description="LATIN SMALL LETTER REVERSED R WITH FISHHOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x027F,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL R",
  direction="l",
  linebreak="al",
  uccode=0x01A6,
  unicodeslot=0x0280,
 },
 {
  adobename="Rsmallinverted",
  category="ll",
  description="LATIN LETTER SMALL CAPITAL INVERTED R",
  direction="l",
  linebreak="al",
  unicodeslot=0x0281,
 },
 {
  adobename="shook",
  category="ll",
  description="LATIN SMALL LETTER S WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0073,
  unicodeslot=0x0282,
 },
 {
  adobename="esh",
  category="ll",
  description="LATIN SMALL LETTER ESH",
  direction="l",
  linebreak="al",
  uccode=0x01A9,
  unicodeslot=0x0283,
 },
 {
  adobename="dotlessjstrokehook",
  category="ll",
  description="LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x0284,
 },
 {
  adobename="eshsquatreversed",
  category="ll",
  description="LATIN SMALL LETTER SQUAT REVERSED ESH",
  direction="l",
  linebreak="al",
  unicodeslot=0x0285,
 },
 {
  adobename="eshcurl",
  category="ll",
  description="LATIN SMALL LETTER ESH WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x0283,
  unicodeslot=0x0286,
 },
 {
  adobename="tturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED T",
  direction="l",
  linebreak="al",
  unicodeslot=0x0287,
 },
 {
  adobename="tretroflexhook",
  category="ll",
  description="LATIN SMALL LETTER T WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0074,
  uccode=0x01AE,
  unicodeslot=0x0288,
 },
 {
  adobename="ubar",
  category="ll",
  description="LATIN SMALL LETTER U BAR",
  direction="l",
  linebreak="al",
  uccode=0x0244,
  unicodeslot=0x0289,
 },
 {
  adobename="upsilonlatin",
  category="ll",
  description="LATIN SMALL LETTER UPSILON",
  direction="l",
  linebreak="al",
  uccode=0x01B1,
  unicodeslot=0x028A,
 },
 {
  adobename="vhook",
  category="ll",
  description="LATIN SMALL LETTER V WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0076,
  uccode=0x01B2,
  unicodeslot=0x028B,
 },
 {
  adobename="vturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED V",
  direction="l",
  linebreak="al",
  uccode=0x0245,
  unicodeslot=0x028C,
 },
 {
  adobename="wturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED W",
  direction="l",
  linebreak="al",
  unicodeslot=0x028D,
 },
 {
  adobename="yturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x028E,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x028F,
 },
 {
  adobename="zretroflexhook",
  category="ll",
  description="LATIN SMALL LETTER Z WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  unicodeslot=0x0290,
 },
 {
  adobename="zcurl",
  category="ll",
  description="LATIN SMALL LETTER Z WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  unicodeslot=0x0291,
 },
 {
  adobename="ezh",
  category="ll",
  description="LATIN SMALL LETTER EZH",
  direction="l",
  linebreak="al",
  uccode=0x01B7,
  unicodeslot=0x0292,
 },
 {
  adobename="ezhcurl",
  category="ll",
  description="LATIN SMALL LETTER EZH WITH CURL",
  direction="l",
  linebreak="al",
  shcode=0x0292,
  unicodeslot=0x0293,
 },
 {
  adobename="glottalstop",
  category="lo",
  description="LATIN LETTER GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x0294,
 },
 {
  adobename="glottalstopreversed",
  category="ll",
  description="LATIN LETTER PHARYNGEAL VOICED FRICATIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0295,
 },
 {
  adobename="glottalstopinverted",
  category="ll",
  description="LATIN LETTER INVERTED GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x0296,
 },
 {
  adobename="cstretched",
  category="ll",
  description="LATIN LETTER STRETCHED C",
  direction="l",
  linebreak="al",
  unicodeslot=0x0297,
 },
 {
  adobename="bilabialclick",
  category="ll",
  description="LATIN LETTER BILABIAL CLICK",
  direction="l",
  linebreak="al",
  unicodeslot=0x0298,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL B",
  direction="l",
  linebreak="al",
  unicodeslot=0x0299,
 },
 {
  adobename="eopenclosed",
  category="ll",
  description="LATIN SMALL LETTER CLOSED OPEN E",
  direction="l",
  linebreak="al",
  unicodeslot=0x029A,
 },
 {
  adobename="Gsmallhook",
  category="ll",
  description="LATIN LETTER SMALL CAPITAL G WITH HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x029B,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL H",
  direction="l",
  linebreak="al",
  unicodeslot=0x029C,
 },
 {
  adobename="jcrossedtail",
  category="ll",
  description="LATIN SMALL LETTER J WITH CROSSED-TAIL",
  direction="l",
  linebreak="al",
  shcode=0x006A,
  unicodeslot=0x029D,
 },
 {
  adobename="kturned",
  category="ll",
  description="LATIN SMALL LETTER TURNED K",
  direction="l",
  linebreak="al",
  unicodeslot=0x029E,
 },
 {
  category="ll",
  description="LATIN LETTER SMALL CAPITAL L",
  direction="l",
  linebreak="al",
  unicodeslot=0x029F,
 },
 {
  adobename="qhook",
  category="ll",
  description="LATIN SMALL LETTER Q WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0071,
  unicodeslot=0x02A0,
 },
 {
  adobename="glottalstopstroke",
  category="ll",
  description="LATIN LETTER GLOTTAL STOP WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x02A1,
 },
 {
  adobename="glottalstopstrokereversed",
  category="ll",
  description="LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x02A2,
 },
 {
  adobename="dzaltone",
  category="ll",
  description="LATIN SMALL LETTER DZ DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x02A3,
 },
 {
  adobename="dezh",
  category="ll",
  description="LATIN SMALL LETTER DEZH DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x02A4,
 },
 {
  adobename="dzcurl",
  category="ll",
  description="LATIN SMALL LETTER DZ DIGRAPH WITH CURL",
  direction="l",
  linebreak="al",
  unicodeslot=0x02A5,
 },
 {
  adobename="ts",
  category="ll",
  description="LATIN SMALL LETTER TS DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x02A6,
 },
 {
  adobename="tesh",
  category="ll",
  description="LATIN SMALL LETTER TESH DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x02A7,
 },
 {
  adobename="tccurl",
  category="ll",
  description="LATIN SMALL LETTER TC DIGRAPH WITH CURL",
  direction="l",
  linebreak="al",
  unicodeslot=0x02A8,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER FENG DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x02A9,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER LS DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x02AA,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER LZ DIGRAPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x02AB,
 },
 {
  category="ll",
  description="LATIN LETTER BILABIAL PERCUSSIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x02AC,
 },
 {
  category="ll",
  description="LATIN LETTER BIDENTAL PERCUSSIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x02AD,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER TURNED H WITH FISHHOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x02AE,
 },
 {
  category="ll",
  description="LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x02AF,
 },
 {
  adobename="hsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL H",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0068 },
  unicodeslot=0x02B0,
 },
 {
  adobename="hhooksuperior",
  category="lm",
  description="MODIFIER LETTER SMALL H WITH HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0266 },
  unicodeslot=0x02B1,
 },
 {
  adobename="jsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL J",
  direction="l",
  linebreak="al",
  specials={ "super", 0x006A },
  unicodeslot=0x02B2,
 },
 {
  category="lm",
  description="MODIFIER LETTER SMALL R",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0072 },
  unicodeslot=0x02B3,
 },
 {
  adobename="rturnedsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL TURNED R",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0279 },
  unicodeslot=0x02B4,
 },
 {
  adobename="rhookturnedsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL TURNED R WITH HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x027B },
  unicodeslot=0x02B5,
 },
 {
  adobename="Rsmallinvertedsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL CAPITAL INVERTED R",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0281 },
  unicodeslot=0x02B6,
 },
 {
  adobename="wsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL W",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0077 },
  unicodeslot=0x02B7,
 },
 {
  adobename="ysuperior",
  category="lm",
  description="MODIFIER LETTER SMALL Y",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0079 },
  unicodeslot=0x02B8,
 },
 {
  adobename="primemod",
  category="lm",
  description="MODIFIER LETTER PRIME",
  direction="on",
  linebreak="al",
  unicodeslot=0x02B9,
 },
 {
  adobename="dblprimemod",
  category="lm",
  description="MODIFIER LETTER DOUBLE PRIME",
  direction="on",
  linebreak="al",
  unicodeslot=0x02BA,
 },
 {
  adobename="commaturnedmod",
  category="lm",
  description="MODIFIER LETTER TURNED COMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x02BB,
 },
 {
  adobename="apostrophemod",
  category="lm",
  description="MODIFIER LETTER APOSTROPHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x02BC,
 },
 {
  adobename="commareversedmod",
  category="lm",
  description="MODIFIER LETTER REVERSED COMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x02BD,
 },
 {
  adobename="ringhalfright",
  category="lm",
  description="MODIFIER LETTER RIGHT HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x02BE,
 },
 {
  adobename="ringhalfleft",
  category="lm",
  description="MODIFIER LETTER LEFT HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x02BF,
 },
 {
  adobename="glottalstopmod",
  category="lm",
  description="MODIFIER LETTER GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x02C0,
 },
 {
  adobename="glottalstopreversedmod",
  category="lm",
  description="MODIFIER LETTER REVERSED GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x02C1,
 },
 {
  adobename="arrowheadleftmod",
  category="sk",
  description="MODIFIER LETTER LEFT ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x02C2,
 },
 {
  adobename="arrowheadrightmod",
  category="sk",
  description="MODIFIER LETTER RIGHT ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x02C3,
 },
 {
  adobename="arrowheadupmod",
  category="sk",
  cjkwd="a",
  description="MODIFIER LETTER UP ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x02C4,
 },
 {
  adobename="arrowheaddownmod",
  category="sk",
  description="MODIFIER LETTER DOWN ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x02C5,
 },
 {
  adobename="circumflex",
  category="lm",
  comment="check special",
  contextname="textcircumflex",
  description="MODIFIER LETTER CIRCUMFLEX ACCENT",
  direction="on",
  linebreak="al",
  mathclass="accent",
  mathname="hat",
  specials={ "compat", 0x0020, 0x0302 },
  unicodeslot=0x02C6,
 },
 {
  adobename="caron",
  category="lm",
  cjkwd="a",
  comment="check special",
  contextname="textcaron",
  description="CARON",
  direction="on",
  linebreak="ai",
  mathclass="accent",
  mathname="check",
  specials={ "compat", 0x0020, 0x030C },
  unicodeslot=0x02C7,
 },
 {
  adobename="verticallinemod",
  category="lm",
  description="MODIFIER LETTER VERTICAL LINE",
  direction="on",
  linebreak="bb",
  unicodeslot=0x02C8,
 },
 {
  adobename="firsttonechinese",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER MACRON",
  direction="on",
  linebreak="ai",
  unicodeslot=0x02C9,
 },
 {
  adobename="secondtonechinese",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER ACUTE ACCENT",
  direction="on",
  linebreak="ai",
  unicodeslot=0x02CA,
 },
 {
  adobename="fourthtonechinese",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER GRAVE ACCENT",
  direction="on",
  linebreak="ai",
  unicodeslot=0x02CB,
 },
 {
  adobename="verticallinelowmod",
  category="lm",
  description="MODIFIER LETTER LOW VERTICAL LINE",
  direction="on",
  linebreak="bb",
  unicodeslot=0x02CC,
 },
 {
  adobename="macronlowmod",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER LOW MACRON",
  direction="on",
  linebreak="ai",
  unicodeslot=0x02CD,
 },
 {
  adobename="gravelowmod",
  category="lm",
  description="MODIFIER LETTER LOW GRAVE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x02CE,
 },
 {
  adobename="acutelowmod",
  category="lm",
  description="MODIFIER LETTER LOW ACUTE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x02CF,
 },
 {
  adobename="colontriangularmod",
  category="lm",
  cjkwd="a",
  description="MODIFIER LETTER TRIANGULAR COLON",
  direction="l",
  linebreak="ai",
  unicodeslot=0x02D0,
 },
 {
  adobename="colontriangularhalfmod",
  category="lm",
  description="MODIFIER LETTER HALF TRIANGULAR COLON",
  direction="l",
  linebreak="al",
  unicodeslot=0x02D1,
 },
 {
  adobename="ringhalfrightcentered",
  category="sk",
  description="MODIFIER LETTER CENTRED RIGHT HALF RING",
  direction="on",
  linebreak="al",
  unicodeslot=0x02D2,
 },
 {
  adobename="ringhalfleftcentered",
  category="sk",
  description="MODIFIER LETTER CENTRED LEFT HALF RING",
  direction="on",
  linebreak="al",
  unicodeslot=0x02D3,
 },
 {
  adobename="uptackmod",
  category="sk",
  description="MODIFIER LETTER UP TACK",
  direction="on",
  linebreak="al",
  unicodeslot=0x02D4,
 },
 {
  adobename="downtackmod",
  category="sk",
  description="MODIFIER LETTER DOWN TACK",
  direction="on",
  linebreak="al",
  unicodeslot=0x02D5,
 },
 {
  adobename="plusmod",
  category="sk",
  description="MODIFIER LETTER PLUS SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x02D6,
 },
 {
  adobename="minusmod",
  category="sk",
  description="MODIFIER LETTER MINUS SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x02D7,
 },
 {
  adobename="breve",
  category="sk",
  cjkwd="a",
  contextname="textbreve",
  description="BREVE",
  direction="on",
  linebreak="ai",
  mathclass="accent",
  mathname="breve",
  specials={ "compat", 0x0020, 0x0306 },
  unicodeslot=0x02D8,
 },
 {
  adobename="dotaccent",
  category="sk",
  cjkwd="a",
  contextname="textdotaccent",
  description="DOT ABOVE",
  direction="on",
  linebreak="ai",
  mathclass="accent",
  mathname="dot",
  specials={ "compat", 0x0020, 0x0307 },
  unicodeslot=0x02D9,
 },
 {
  adobename="ring",
  category="sk",
  cjkwd="a",
  contextname="textring",
  description="RING ABOVE",
  direction="on",
  linebreak="ai",
  mathclass="accent",
  mathname="mathring",
  specials={ "compat", 0x0020, 0x030A },
  unicodeslot=0x02DA,
 },
 {
  adobename="ogonek",
  category="sk",
  cjkwd="a",
  contextname="textogonek",
  description="OGONEK",
  direction="on",
  linebreak="ai",
  specials={ "compat", 0x0020, 0x0328 },
  unicodeslot=0x02DB,
 },
 {
  adobename="tilde",
  category="sk",
  contextname="texttilde",
  description="SMALL TILDE",
  direction="on",
  linebreak="al",
  mathclass="accent",
  mathname="tilde",
  specials={ "compat", 0x0020, 0x0303 },
  unicodeslot=0x02DC,
 },
 {
  adobename="hungarumlaut",
  category="sk",
  cjkwd="a",
  contextname="texthungarumlaut",
  description="DOUBLE ACUTE ACCENT",
  direction="on",
  linebreak="ai",
  specials={ "compat", 0x0020, 0x030B },
  unicodeslot=0x02DD,
 },
 {
  adobename="rhotichookmod",
  category="sk",
  description="MODIFIER LETTER RHOTIC HOOK",
  direction="on",
  linebreak="al",
  unicodeslot=0x02DE,
 },
 {
  category="sk",
  cjkwd="a",
  description="MODIFIER LETTER CROSS ACCENT",
  direction="on",
  linebreak="bb",
  unicodeslot=0x02DF,
 },
 {
  adobename="gammasuperior",
  category="lm",
  description="MODIFIER LETTER SMALL GAMMA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0263 },
  unicodeslot=0x02E0,
 },
 {
  category="lm",
  description="MODIFIER LETTER SMALL L",
  direction="l",
  linebreak="al",
  specials={ "super", 0x006C },
  unicodeslot=0x02E1,
 },
 {
  category="lm",
  description="MODIFIER LETTER SMALL S",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0073 },
  unicodeslot=0x02E2,
 },
 {
  adobename="xsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL X",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0078 },
  unicodeslot=0x02E3,
 },
 {
  adobename="glottalstopreversedsuperior",
  category="lm",
  description="MODIFIER LETTER SMALL REVERSED GLOTTAL STOP",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0295 },
  unicodeslot=0x02E4,
 },
 {
  adobename="tonebarextrahighmod",
  category="sk",
  description="MODIFIER LETTER EXTRA-HIGH TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x02E5,
 },
 {
  adobename="tonebarhighmod",
  category="sk",
  description="MODIFIER LETTER HIGH TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x02E6,
 },
 {
  adobename="tonebarmidmod",
  category="sk",
  description="MODIFIER LETTER MID TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x02E7,
 },
 {
  adobename="tonebarlowmod",
  category="sk",
  description="MODIFIER LETTER LOW TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x02E8,
 },
 {
  adobename="tonebarextralowmod",
  category="sk",
  description="MODIFIER LETTER EXTRA-LOW TONE BAR",
  direction="on",
  linebreak="al",
  unicodeslot=0x02E9,
 },
 {
  category="sk",
  description="MODIFIER LETTER YIN DEPARTING TONE MARK",
  direction="on",
  linebreak="al",
  unicodeslot=0x02EA,
 },
 {
  category="sk",
  description="MODIFIER LETTER YANG DEPARTING TONE MARK",
  direction="on",
  linebreak="al",
  unicodeslot=0x02EB,
 },
 {
  category="sk",
  description="MODIFIER LETTER VOICING",
  direction="on",
  linebreak="al",
  unicodeslot=0x02EC,
 },
 {
  category="sk",
  description="MODIFIER LETTER UNASPIRATED",
  direction="on",
  linebreak="al",
  unicodeslot=0x02ED,
 },
 {
  category="lm",
  description="MODIFIER LETTER DOUBLE APOSTROPHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x02EE,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW DOWN ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x02EF,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW UP ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F0,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW LEFT ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F1,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW RIGHT ARROWHEAD",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F2,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW RING",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F3,
 },
 {
  category="sk",
  description="MODIFIER LETTER MIDDLE GRAVE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F4,
 },
 {
  category="sk",
  description="MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F5,
 },
 {
  category="sk",
  description="MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F6,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW TILDE",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F7,
 },
 {
  category="sk",
  description="MODIFIER LETTER RAISED COLON",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F8,
 },
 {
  category="sk",
  description="MODIFIER LETTER BEGIN HIGH TONE",
  direction="on",
  linebreak="al",
  unicodeslot=0x02F9,
 },
 {
  category="sk",
  description="MODIFIER LETTER END HIGH TONE",
  direction="on",
  linebreak="al",
  unicodeslot=0x02FA,
 },
 {
  category="sk",
  description="MODIFIER LETTER BEGIN LOW TONE",
  direction="on",
  linebreak="al",
  unicodeslot=0x02FB,
 },
 {
  category="sk",
  description="MODIFIER LETTER END LOW TONE",
  direction="on",
  linebreak="al",
  unicodeslot=0x02FC,
 },
 {
  category="sk",
  description="MODIFIER LETTER SHELF",
  direction="on",
  linebreak="al",
  unicodeslot=0x02FD,
 },
 {
  category="sk",
  description="MODIFIER LETTER OPEN SHELF",
  direction="on",
  linebreak="al",
  unicodeslot=0x02FE,
 },
 {
  category="sk",
  description="MODIFIER LETTER LOW LEFT ARROW",
  direction="on",
  linebreak="al",
  unicodeslot=0x02FF,
 },
 {
  adobename="gravecomb",
  category="mn",
  cjkwd="a",
  description="COMBINING GRAVE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0300,
 },
 {
  adobename="acutecomb",
  category="mn",
  cjkwd="a",
  description="COMBINING ACUTE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0301,
 },
 {
  adobename="circumflexcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING CIRCUMFLEX ACCENT",
  direction="nsm",
  linebreak="cm",
  mathstretch="h",
  unicodeslot=0x0302,
 },
 {
  adobename="tildecomb",
  category="mn",
  cjkwd="a",
  description="COMBINING TILDE",
  direction="nsm",
  linebreak="cm",
  mathstretch="h",
  unicodeslot=0x0303,
 },
 {
  adobename="macroncmb",
  category="mn",
  cjkwd="a",
  description="COMBINING MACRON",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0304,
 },
 {
  adobename="overlinecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING OVERLINE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0305,
 },
 {
  adobename="brevecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING BREVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0306,
 },
 {
  adobename="dotaccentcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DOT ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0307,
 },
 {
  adobename="dieresiscmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DIAERESIS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0308,
 },
 {
  adobename="hookcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING HOOK ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0309,
 },
 {
  adobename="ringcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING RING ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x030A,
 },
 {
  adobename="hungarumlautcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE ACUTE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x030B,
 },
 {
  adobename="caroncmb",
  category="mn",
  cjkwd="a",
  description="COMBINING CARON",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x030C,
 },
 {
  adobename="verticallineabovecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING VERTICAL LINE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x030D,
 },
 {
  adobename="dblverticallineabovecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE VERTICAL LINE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x030E,
 },
 {
  adobename="dblgravecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE GRAVE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x030F,
 },
 {
  adobename="candrabinducmb",
  category="mn",
  cjkwd="a",
  description="COMBINING CANDRABINDU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0310,
 },
 {
  adobename="breveinvertedcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING INVERTED BREVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0311,
 },
 {
  adobename="commaturnedabovecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING TURNED COMMA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0312,
 },
 {
  adobename="commaabovecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING COMMA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0313,
 },
 {
  adobename="commareversedabovecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING REVERSED COMMA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0314,
 },
 {
  adobename="commaaboverightcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING COMMA ABOVE RIGHT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0315,
 },
 {
  adobename="gravebelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING GRAVE ACCENT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0316,
 },
 {
  adobename="acutebelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING ACUTE ACCENT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0317,
 },
 {
  adobename="lefttackbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING LEFT TACK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0318,
 },
 {
  adobename="righttackbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING RIGHT TACK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0319,
 },
 {
  adobename="leftangleabovecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING LEFT ANGLE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x031A,
 },
 {
  adobename="horncmb",
  category="mn",
  cjkwd="a",
  description="COMBINING HORN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x031B,
 },
 {
  adobename="ringhalfleftbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING LEFT HALF RING BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x031C,
 },
 {
  adobename="uptackbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING UP TACK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x031D,
 },
 {
  adobename="downtackbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DOWN TACK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x031E,
 },
 {
  adobename="plusbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING PLUS SIGN BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x031F,
 },
 {
  adobename="minusbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING MINUS SIGN BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0320,
 },
 {
  adobename="hookpalatalizedbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING PALATALIZED HOOK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0321,
 },
 {
  adobename="hookretroflexbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING RETROFLEX HOOK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0322,
 },
 {
  adobename="dotbelowcomb",
  category="mn",
  cjkwd="a",
  contextname="textbottomdot",
  description="COMBINING DOT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0323,
 },
 {
  adobename="dieresisbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DIAERESIS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0324,
 },
 {
  adobename="ringbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING RING BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0325,
 },
 {
  category="mn",
  cjkwd="a",
  contextname="textbottomcomma",
  description="COMBINING COMMA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0326,
 },
 {
  adobename="cedillacmb",
  category="mn",
  cjkwd="a",
  description="COMBINING CEDILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0327,
 },
 {
  adobename="ogonekcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING OGONEK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0328,
 },
 {
  adobename="verticallinebelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING VERTICAL LINE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0329,
 },
 {
  adobename="bridgebelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING BRIDGE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x032A,
 },
 {
  adobename="dblarchinvertedbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING INVERTED DOUBLE ARCH BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x032B,
 },
 {
  adobename="caronbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING CARON BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x032C,
 },
 {
  adobename="circumflexbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING CIRCUMFLEX ACCENT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x032D,
 },
 {
  adobename="brevebelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING BREVE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x032E,
 },
 {
  adobename="breveinvertedbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING INVERTED BREVE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x032F,
 },
 {
  adobename="tildebelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING TILDE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0330,
 },
 {
  adobename="macronbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING MACRON BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0331,
 },
 {
  adobename="lowlinecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING LOW LINE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0332,
 },
 {
  adobename="dbllowlinecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE LOW LINE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0333,
 },
 {
  adobename="tildeoverlaycmb",
  category="mn",
  cjkwd="a",
  description="COMBINING TILDE OVERLAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0334,
 },
 {
  adobename="strokeshortoverlaycmb",
  category="mn",
  cjkwd="a",
  description="COMBINING SHORT STROKE OVERLAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0335,
 },
 {
  adobename="strokelongoverlaycmb",
  category="mn",
  cjkwd="a",
  description="COMBINING LONG STROKE OVERLAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0336,
 },
 {
  adobename="solidusshortoverlaycmb",
  category="mn",
  cjkwd="a",
  description="COMBINING SHORT SOLIDUS OVERLAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0337,
 },
 {
  adobename="soliduslongoverlaycmb",
  category="mn",
  cjkwd="a",
  description="COMBINING LONG SOLIDUS OVERLAY",
  direction="nsm",
  linebreak="cm",
  mathclass="relation",
  mathname="not",
  unicodeslot=0x0338,
 },
 {
  adobename="ringhalfrightbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING RIGHT HALF RING BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0339,
 },
 {
  adobename="bridgeinvertedbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING INVERTED BRIDGE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x033A,
 },
 {
  adobename="squarebelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING SQUARE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x033B,
 },
 {
  adobename="seagullbelowcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING SEAGULL BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x033C,
 },
 {
  adobename="xabovecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING X ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x033D,
 },
 {
  adobename="tildeverticalcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING VERTICAL TILDE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x033E,
 },
 {
  adobename="dbloverlinecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE OVERLINE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x033F,
 },
 {
  adobename="gravetonecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING GRAVE TONE MARK",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0300 },
  unicodeslot=0x0340,
 },
 {
  adobename="acutetonecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING ACUTE TONE MARK",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0301 },
  unicodeslot=0x0341,
 },
 {
  adobename="perispomenigreekcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING GREEK PERISPOMENI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0342,
 },
 {
  adobename="koroniscmb",
  category="mn",
  cjkwd="a",
  description="COMBINING GREEK KORONIS",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0313 },
  unicodeslot=0x0343,
 },
 {
  adobename="dialytikatonoscmb",
  category="mn",
  cjkwd="a",
  description="COMBINING GREEK DIALYTIKA TONOS",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0308, 0x0301 },
  unicodeslot=0x0344,
 },
 {
  adobename="ypogegrammenigreekcmb",
  category="mn",
  cjkwd="a",
  description="COMBINING GREEK YPOGEGRAMMENI",
  direction="nsm",
  linebreak="cm",
  uccode=0x0399,
  unicodeslot=0x0345,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING BRIDGE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0346,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING EQUALS SIGN BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0347,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE VERTICAL LINE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0348,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LEFT ANGLE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0349,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING NOT TILDE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x034A,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING HOMOTHETIC ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x034B,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING ALMOST EQUAL TO ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x034C,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LEFT RIGHT ARROW BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x034D,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING UPWARDS ARROW BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x034E,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING GRAPHEME JOINER",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x034F,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING RIGHT ARROWHEAD ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0350,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LEFT HALF RING ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0351,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING FERMATA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0352,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING X BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0353,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LEFT ARROWHEAD BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0354,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING RIGHT ARROWHEAD BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0355,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0356,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING RIGHT HALF RING ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0357,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING DOT ABOVE RIGHT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0358,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING ASTERISK BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0359,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE RING BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x035A,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING ZIGZAG ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x035B,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE BREVE BELOW",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x035C,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE BREVE",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x035D,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE MACRON",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x035E,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE MACRON BELOW",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x035F,
 },
 {
  adobename="tildedoublecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE TILDE",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x0360,
 },
 {
  adobename="breveinverteddoublecmb",
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE INVERTED BREVE",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x0361,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING DOUBLE RIGHTWARDS ARROW BELOW",
  direction="nsm",
  linebreak="gl",
  unicodeslot=0x0362,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0363,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0364,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0365,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0366,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0367,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER C",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0368,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER D",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0369,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER H",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x036A,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER M",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x036B,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x036C,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER T",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x036D,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER V",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x036E,
 },
 {
  category="mn",
  cjkwd="a",
  description="COMBINING LATIN SMALL LETTER X",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x036F,
 },
 {
  category="lu",
  description="GREEK CAPITAL LETTER HETA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0370,
 },
 {
  category="ll",
  description="GREEK SMALL LETTER HETA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0371,
 },
 {
  category="lu",
  description="GREEK CAPITAL LETTER ARCHAIC SAMPI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0372,
 },
 {
  category="ll",
  description="GREEK SMALL LETTER ARCHAIC SAMPI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0373,
 },
 {
  adobename="numeralsigngreek",
  category="sk",
  description="GREEK NUMERAL SIGN",
  direction="on",
  linebreak="al",
  specials={ "char", 0x02B9 },
  unicodeslot=0x0374,
 },
 {
  adobename="numeralsignlowergreek",
  category="sk",
  description="GREEK LOWER NUMERAL SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x0375,
 },
 {
  category="lu",
  description="GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0376,
 },
 {
  category="ll",
  description="GREEK SMALL LETTER PAMPHYLIAN DIGAMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0377,
 },
 [0x037A]={
  adobename="ypogegrammeni",
  category="lm",
  description="GREEK YPOGEGRAMMENI",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x0020, 0x0345 },
  unicodeslot=0x037A,
 },
 [0x037B]={
  category="ll",
  description="GREEK SMALL REVERSED LUNATE SIGMA SYMBOL",
  direction="l",
  linebreak="al",
  uccode=0x03FD,
  unicodeslot=0x037B,
 },
 [0x037C]={
  category="ll",
  description="GREEK SMALL DOTTED LUNATE SIGMA SYMBOL",
  direction="l",
  linebreak="al",
  uccode=0x03FE,
  unicodeslot=0x037C,
 },
 [0x037D]={
  category="ll",
  description="GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL",
  direction="l",
  linebreak="al",
  uccode=0x03FF,
  unicodeslot=0x037D,
 },
 [0x037E]={
  adobename="questiongreek",
  category="po",
  description="GREEK QUESTION MARK",
  direction="on",
  linebreak="is",
  specials={ "char", 0x003B },
  unicodeslot=0x037E,
 },
 [0x0384]={
  adobename="tonos",
  category="sk",
  contextname="greektonos",
  description="GREEK TONOS",
  direction="on",
  linebreak="al",
  specials={ "compat", 0x0020, 0x0301 },
  unicodeslot=0x0384,
 },
 [0x0385]={
  adobename="dieresistonos",
  category="sk",
  contextname="greekdialytikatonos",
  description="GREEK DIALYTIKA TONOS",
  direction="on",
  linebreak="al",
  specials={ "char", 0x00A8, 0x0301 },
  unicodeslot=0x0385,
 },
 [0x0386]={
  adobename="Alphatonos",
  category="lu",
  contextname="greekAlphatonos",
  description="GREEK CAPITAL LETTER ALPHA WITH TONOS",
  direction="l",
  lccode=0x03AC,
  linebreak="al",
  shcode=0x0391,
  specials={ "char", 0x0391, 0x0301 },
  unicodeslot=0x0386,
 },
 [0x0387]={
  adobename="anoteleia",
  category="po",
  description="GREEK ANO TELEIA",
  direction="on",
  linebreak="al",
  specials={ "char", 0x00B7 },
  unicodeslot=0x0387,
 },
 [0x0388]={
  adobename="Epsilontonos",
  category="lu",
  contextname="greekEpsilontonos",
  description="GREEK CAPITAL LETTER EPSILON WITH TONOS",
  direction="l",
  lccode=0x03AD,
  linebreak="al",
  shcode=0x0395,
  specials={ "char", 0x0395, 0x0301 },
  unicodeslot=0x0388,
 },
 [0x0389]={
  adobename="Etatonos",
  category="lu",
  contextname="greekEtatonos",
  description="GREEK CAPITAL LETTER ETA WITH TONOS",
  direction="l",
  lccode=0x03AE,
  linebreak="al",
  shcode=0x0397,
  specials={ "char", 0x0397, 0x0301 },
  unicodeslot=0x0389,
 },
 [0x038A]={
  adobename="Iotatonos",
  category="lu",
  contextname="greekIotatonos",
  description="GREEK CAPITAL LETTER IOTA WITH TONOS",
  direction="l",
  lccode=0x03AF,
  linebreak="al",
  shcode=0x0399,
  specials={ "char", 0x0399, 0x0301 },
  unicodeslot=0x038A,
 },
 [0x038C]={
  adobename="Omicrontonos",
  category="lu",
  contextname="greekOmicrontonos",
  description="GREEK CAPITAL LETTER OMICRON WITH TONOS",
  direction="l",
  lccode=0x03CC,
  linebreak="al",
  shcode=0x039F,
  specials={ "char", 0x039F, 0x0301 },
  unicodeslot=0x038C,
 },
 [0x038E]={
  adobename="Upsilontonos",
  category="lu",
  contextname="greekUpsilontonos",
  description="GREEK CAPITAL LETTER UPSILON WITH TONOS",
  direction="l",
  lccode=0x03CD,
  linebreak="al",
  shcode=0x03A5,
  specials={ "char", 0x03A5, 0x0301 },
  unicodeslot=0x038E,
 },
 [0x038F]={
  adobename="Omegatonos",
  category="lu",
  contextname="greekOmegatonos",
  description="GREEK CAPITAL LETTER OMEGA WITH TONOS",
  direction="l",
  lccode=0x03CE,
  linebreak="al",
  shcode=0x03A9,
  specials={ "char", 0x03A9, 0x0301 },
  unicodeslot=0x038F,
 },
 [0x0390]={
  adobename="iotadieresistonos",
  category="ll",
  contextname="greekiotadialytikatonos",
  description="GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS",
  direction="l",
  linebreak="al",
  shcode=0x03B9,
  specials={ "char", 0x03CA, 0x0301 },
  unicodeslot=0x0390,
 },
 [0x0391]={
  adobename="Alpha",
  category="lu",
  cjkwd="a",
  contextname="greekAlpha",
  description="GREEK CAPITAL LETTER ALPHA",
  direction="l",
  lccode=0x03B1,
  linebreak="al",
  mathclass="variable",
  mathname="Alpha",
  unicodeslot=0x0391,
 },
 [0x0392]={
  adobename="Beta",
  category="lu",
  cjkwd="a",
  contextname="greekBeta",
  description="GREEK CAPITAL LETTER BETA",
  direction="l",
  lccode=0x03B2,
  linebreak="al",
  mathclass="variable",
  mathname="Beta",
  unicodeslot=0x0392,
 },
 [0x0393]={
  adobename="Gamma",
  category="lu",
  cjkwd="a",
  contextname="greekGamma",
  description="GREEK CAPITAL LETTER GAMMA",
  direction="l",
  lccode=0x03B3,
  linebreak="al",
  mathclass="variable",
  mathname="Gamma",
  unicodeslot=0x0393,
 },
 [0x0394]={
  adobename="Deltagreek",
  category="lu",
  cjkwd="a",
  contextname="greekDelta",
  description="GREEK CAPITAL LETTER DELTA",
  direction="l",
  lccode=0x03B4,
  linebreak="al",
  mathclass="variable",
  mathname="Delta",
  unicodeslot=0x0394,
 },
 [0x0395]={
  adobename="Epsilon",
  category="lu",
  cjkwd="a",
  contextname="greekEpsilon",
  description="GREEK CAPITAL LETTER EPSILON",
  direction="l",
  lccode=0x03B5,
  linebreak="al",
  mathclass="variable",
  mathname="Epsilon",
  unicodeslot=0x0395,
 },
 [0x0396]={
  adobename="Zeta",
  category="lu",
  cjkwd="a",
  contextname="greekZeta",
  description="GREEK CAPITAL LETTER ZETA",
  direction="l",
  lccode=0x03B6,
  linebreak="al",
  mathclass="variable",
  mathname="Zeta",
  unicodeslot=0x0396,
 },
 [0x0397]={
  adobename="Eta",
  category="lu",
  cjkwd="a",
  contextname="greekEta",
  description="GREEK CAPITAL LETTER ETA",
  direction="l",
  lccode=0x03B7,
  linebreak="al",
  mathclass="variable",
  mathname="Eta",
  unicodeslot=0x0397,
 },
 [0x0398]={
  adobename="Theta",
  category="lu",
  cjkwd="a",
  contextname="greekTheta",
  description="GREEK CAPITAL LETTER THETA",
  direction="l",
  lccode=0x03B8,
  linebreak="al",
  mathclass="variable",
  mathname="Theta",
  unicodeslot=0x0398,
 },
 [0x0399]={
  adobename="Iota",
  category="lu",
  cjkwd="a",
  contextname="greekIota",
  description="GREEK CAPITAL LETTER IOTA",
  direction="l",
  lccode=0x03B9,
  linebreak="al",
  mathclass="variable",
  mathname="Iota",
  unicodeslot=0x0399,
 },
 [0x039A]={
  adobename="Kappa",
  category="lu",
  cjkwd="a",
  contextname="greekKappa",
  description="GREEK CAPITAL LETTER KAPPA",
  direction="l",
  lccode=0x03BA,
  linebreak="al",
  mathclass="variable",
  mathname="Kappa",
  unicodeslot=0x039A,
 },
 [0x039B]={
  adobename="Lambda",
  category="lu",
  cjkwd="a",
  contextname="greekLambda",
  description="GREEK CAPITAL LETTER LAMDA",
  direction="l",
  lccode=0x03BB,
  linebreak="al",
  mathclass="variable",
  mathname="Lambda",
  unicodeslot=0x039B,
 },
 [0x039C]={
  adobename="Mu",
  category="lu",
  cjkwd="a",
  contextname="greekMu",
  description="GREEK CAPITAL LETTER MU",
  direction="l",
  lccode=0x03BC,
  linebreak="al",
  mathclass="variable",
  mathname="Mu",
  unicodeslot=0x039C,
 },
 [0x039D]={
  adobename="Nu",
  category="lu",
  cjkwd="a",
  contextname="greekNu",
  description="GREEK CAPITAL LETTER NU",
  direction="l",
  lccode=0x03BD,
  linebreak="al",
  mathclass="variable",
  mathname="Nu",
  unicodeslot=0x039D,
 },
 [0x039E]={
  adobename="Xi",
  category="lu",
  cjkwd="a",
  contextname="greekXi",
  description="GREEK CAPITAL LETTER XI",
  direction="l",
  lccode=0x03BE,
  linebreak="al",
  mathclass="variable",
  mathname="Xi",
  unicodeslot=0x039E,
 },
 [0x039F]={
  adobename="Omicron",
  category="lu",
  cjkwd="a",
  contextname="greekOmicron",
  description="GREEK CAPITAL LETTER OMICRON",
  direction="l",
  lccode=0x03BF,
  linebreak="al",
  mathclass="variable",
  mathname="Omicron",
  unicodeslot=0x039F,
 },
 [0x03A0]={
  adobename="Pi",
  category="lu",
  cjkwd="a",
  contextname="greekPi",
  description="GREEK CAPITAL LETTER PI",
  direction="l",
  lccode=0x03C0,
  linebreak="al",
  mathclass="variable",
  mathname="Pi",
  unicodeslot=0x03A0,
 },
 [0x03A1]={
  adobename="Rho",
  category="lu",
  cjkwd="a",
  contextname="greekRho",
  description="GREEK CAPITAL LETTER RHO",
  direction="l",
  lccode=0x03C1,
  linebreak="al",
  mathclass="variable",
  mathname="Rho",
  unicodeslot=0x03A1,
 },
 [0x03A3]={
  adobename="Sigma",
  category="lu",
  cjkwd="a",
  contextname="greekSigma",
  description="GREEK CAPITAL LETTER SIGMA",
  direction="l",
  lccode=0x03C3,
  linebreak="al",
  mathclass="variable",
  mathname="Sigma",
  unicodeslot=0x03A3,
 },
 [0x03A4]={
  adobename="Tau",
  category="lu",
  cjkwd="a",
  contextname="greekTau",
  description="GREEK CAPITAL LETTER TAU",
  direction="l",
  lccode=0x03C4,
  linebreak="al",
  mathclass="variable",
  mathname="Tau",
  unicodeslot=0x03A4,
 },
 [0x03A5]={
  adobename="Upsilon",
  category="lu",
  cjkwd="a",
  contextname="greekUpsilon",
  description="GREEK CAPITAL LETTER UPSILON",
  direction="l",
  lccode=0x03C5,
  linebreak="al",
  mathclass="variable",
  mathname="Upsilon",
  unicodeslot=0x03A5,
 },
 [0x03A6]={
  adobename="Phi",
  category="lu",
  cjkwd="a",
  contextname="greekPhi",
  description="GREEK CAPITAL LETTER PHI",
  direction="l",
  lccode=0x03C6,
  linebreak="al",
  mathclass="variable",
  mathname="Phi",
  unicodeslot=0x03A6,
 },
 [0x03A7]={
  adobename="Chi",
  category="lu",
  cjkwd="a",
  contextname="greekChi",
  description="GREEK CAPITAL LETTER CHI",
  direction="l",
  lccode=0x03C7,
  linebreak="al",
  mathclass="variable",
  mathname="Chi",
  unicodeslot=0x03A7,
 },
 [0x03A8]={
  adobename="Psi",
  category="lu",
  cjkwd="a",
  contextname="greekPsi",
  description="GREEK CAPITAL LETTER PSI",
  direction="l",
  lccode=0x03C8,
  linebreak="al",
  mathclass="variable",
  mathname="Psi",
  unicodeslot=0x03A8,
 },
 [0x03A9]={
  adobename="Omegagreek",
  category="lu",
  cjkwd="a",
  contextname="greekOmega",
  description="GREEK CAPITAL LETTER OMEGA",
  direction="l",
  lccode=0x03C9,
  linebreak="al",
  mathclass="variable",
  mathname="Omega",
  unicodeslot=0x03A9,
 },
 [0x03AA]={
  adobename="Iotadieresis",
  category="lu",
  contextname="greekIotadialytika",
  description="GREEK CAPITAL LETTER IOTA WITH DIALYTIKA",
  direction="l",
  lccode=0x03CA,
  linebreak="al",
  shcode=0x0399,
  specials={ "char", 0x0399, 0x0308 },
  unicodeslot=0x03AA,
 },
 [0x03AB]={
  adobename="Upsilondieresis",
  category="lu",
  contextname="greekUpsilondialytika",
  description="GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA",
  direction="l",
  lccode=0x03CB,
  linebreak="al",
  shcode=0x03A5,
  specials={ "char", 0x03A5, 0x0308 },
  unicodeslot=0x03AB,
 },
 [0x03AC]={
  adobename="alphatonos",
  category="ll",
  contextname="greekalphatonos",
  description="GREEK SMALL LETTER ALPHA WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x03B1,
  specials={ "char", 0x03B1, 0x0301 },
  uccode=0x0386,
  unicodeslot=0x03AC,
 },
 [0x03AD]={
  adobename="epsilontonos",
  category="ll",
  contextname="greekepsilontonos",
  description="GREEK SMALL LETTER EPSILON WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x03B5,
  specials={ "char", 0x03B5, 0x0301 },
  uccode=0x0388,
  unicodeslot=0x03AD,
 },
 [0x03AE]={
  adobename="etatonos",
  category="ll",
  contextname="greeketatonos",
  description="GREEK SMALL LETTER ETA WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x03B7,
  specials={ "char", 0x03B7, 0x0301 },
  uccode=0x0389,
  unicodeslot=0x03AE,
 },
 [0x03AF]={
  adobename="iotatonos",
  category="ll",
  contextname="greekiotatonos",
  description="GREEK SMALL LETTER IOTA WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x03B9,
  specials={ "char", 0x03B9, 0x0301 },
  uccode=0x038A,
  unicodeslot=0x03AF,
 },
 [0x03B0]={
  adobename="upsilondieresistonos",
  category="ll",
  contextname="greekupsilondialytikatonos",
  description="GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS",
  direction="l",
  linebreak="al",
  shcode=0x03C5,
  specials={ "char", 0x03CB, 0x0301 },
  unicodeslot=0x03B0,
 },
 [0x03B1]={
  adobename="alpha",
  category="ll",
  cjkwd="a",
  contextname="greekalpha",
  description="GREEK SMALL LETTER ALPHA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="alpha",
  uccode=0x0391,
  unicodeslot=0x03B1,
 },
 [0x03B2]={
  adobename="beta",
  category="ll",
  cjkwd="a",
  contextname="greekbeta",
  description="GREEK SMALL LETTER BETA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="beta",
  uccode=0x0392,
  unicodeslot=0x03B2,
 },
 [0x03B3]={
  adobename="gamma",
  category="ll",
  cjkwd="a",
  contextname="greekgamma",
  description="GREEK SMALL LETTER GAMMA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="gamma",
  uccode=0x0393,
  unicodeslot=0x03B3,
 },
 [0x03B4]={
  adobename="delta",
  category="ll",
  cjkwd="a",
  contextname="greekdelta",
  description="GREEK SMALL LETTER DELTA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="delta",
  uccode=0x0394,
  unicodeslot=0x03B4,
 },
 [0x03B5]={
  adobename="epsilon",
  category="ll",
  cjkwd="a",
  contextname="greekepsilon",
  description="GREEK SMALL LETTER EPSILON",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varepsilon",
  uccode=0x0395,
  unicodeslot=0x03B5,
 },
 [0x03B6]={
  adobename="zeta",
  category="ll",
  cjkwd="a",
  contextname="greekzeta",
  description="GREEK SMALL LETTER ZETA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="zeta",
  uccode=0x0396,
  unicodeslot=0x03B6,
 },
 [0x03B7]={
  adobename="eta",
  category="ll",
  cjkwd="a",
  contextname="greeketa",
  description="GREEK SMALL LETTER ETA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="eta",
  uccode=0x0397,
  unicodeslot=0x03B7,
 },
 [0x03B8]={
  adobename="theta",
  category="ll",
  cjkwd="a",
  contextname="greektheta",
  description="GREEK SMALL LETTER THETA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="theta",
  uccode=0x0398,
  unicodeslot=0x03B8,
 },
 [0x03B9]={
  adobename="iota",
  category="ll",
  cjkwd="a",
  contextname="greekiota",
  description="GREEK SMALL LETTER IOTA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="iota",
  uccode=0x0399,
  unicodeslot=0x03B9,
 },
 [0x03BA]={
  adobename="kappa",
  category="ll",
  cjkwd="a",
  contextname="greekkappa",
  description="GREEK SMALL LETTER KAPPA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="kappa",
  uccode=0x039A,
  unicodeslot=0x03BA,
 },
 [0x03BB]={
  adobename="lambda",
  category="ll",
  cjkwd="a",
  contextname="greeklambda",
  description="GREEK SMALL LETTER LAMDA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="lambda",
  uccode=0x039B,
  unicodeslot=0x03BB,
 },
 [0x03BC]={
  adobename="mugreek",
  category="ll",
  cjkwd="a",
  contextname="greekmu",
  description="GREEK SMALL LETTER MU",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="mu",
  uccode=0x039C,
  unicodeslot=0x03BC,
 },
 [0x03BD]={
  adobename="nu",
  category="ll",
  cjkwd="a",
  contextname="greeknu",
  description="GREEK SMALL LETTER NU",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="nu",
  uccode=0x039D,
  unicodeslot=0x03BD,
 },
 [0x03BE]={
  adobename="xi",
  category="ll",
  cjkwd="a",
  contextname="greekxi",
  description="GREEK SMALL LETTER XI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="xi",
  uccode=0x039E,
  unicodeslot=0x03BE,
 },
 [0x03BF]={
  adobename="omicron",
  category="ll",
  cjkwd="a",
  contextname="greekomicron",
  description="GREEK SMALL LETTER OMICRON",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="omicron",
  uccode=0x039F,
  unicodeslot=0x03BF,
 },
 [0x03C0]={
  adobename="pi",
  category="ll",
  cjkwd="a",
  contextname="greekpi",
  description="GREEK SMALL LETTER PI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="pi",
  uccode=0x03A0,
  unicodeslot=0x03C0,
 },
 [0x03C1]={
  adobename="rho",
  category="ll",
  cjkwd="a",
  contextname="greekrho",
  description="GREEK SMALL LETTER RHO",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="rho",
  uccode=0x03A1,
  unicodeslot=0x03C1,
 },
 [0x03C2]={
  adobename="sigmafinal",
  category="ll",
  contextname="greekfinalsigma",
  description="GREEK SMALL LETTER FINAL SIGMA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varsigma",
  uccode=0x03A3,
  unicodeslot=0x03C2,
 },
 [0x03C3]={
  adobename="sigma",
  category="ll",
  cjkwd="a",
  contextname="greeksigma",
  description="GREEK SMALL LETTER SIGMA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="sigma",
  uccode=0x03A3,
  unicodeslot=0x03C3,
 },
 [0x03C4]={
  adobename="tau",
  category="ll",
  cjkwd="a",
  contextname="greektau",
  description="GREEK SMALL LETTER TAU",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="tau",
  uccode=0x03A4,
  unicodeslot=0x03C4,
 },
 [0x03C5]={
  adobename="upsilon",
  category="ll",
  cjkwd="a",
  contextname="greekupsilon",
  description="GREEK SMALL LETTER UPSILON",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="upsilon",
  uccode=0x03A5,
  unicodeslot=0x03C5,
 },
 [0x03C6]={
  adobename="phi",
  category="ll",
  cjkwd="a",
  contextname="greekphi",
  description="GREEK SMALL LETTER PHI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varphi",
  uccode=0x03A6,
  unicodeslot=0x03C6,
 },
 [0x03C7]={
  adobename="chi",
  category="ll",
  cjkwd="a",
  contextname="greekchi",
  description="GREEK SMALL LETTER CHI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="chi",
  uccode=0x03A7,
  unicodeslot=0x03C7,
 },
 [0x03C8]={
  adobename="psi",
  category="ll",
  cjkwd="a",
  contextname="greekpsi",
  description="GREEK SMALL LETTER PSI",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="psi",
  uccode=0x03A8,
  unicodeslot=0x03C8,
 },
 [0x03C9]={
  adobename="omega",
  category="ll",
  cjkwd="a",
  contextname="greekomega",
  description="GREEK SMALL LETTER OMEGA",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="omega",
  uccode=0x03A9,
  unicodeslot=0x03C9,
 },
 [0x03CA]={
  adobename="iotadieresis",
  category="ll",
  contextname="greekiotadialytika",
  description="GREEK SMALL LETTER IOTA WITH DIALYTIKA",
  direction="l",
  linebreak="al",
  shcode=0x03B9,
  specials={ "char", 0x03B9, 0x0308 },
  uccode=0x03AA,
  unicodeslot=0x03CA,
 },
 [0x03CB]={
  adobename="upsilondieresis",
  category="ll",
  contextname="greekupsilondiaeresis",
  description="GREEK SMALL LETTER UPSILON WITH DIALYTIKA",
  direction="l",
  linebreak="al",
  shcode=0x03C5,
  specials={ "char", 0x03C5, 0x0308 },
  uccode=0x03AB,
  unicodeslot=0x03CB,
 },
 [0x03CC]={
  adobename="omicrontonos",
  category="ll",
  contextname="greekomicrontonos",
  description="GREEK SMALL LETTER OMICRON WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x03BF,
  specials={ "char", 0x03BF, 0x0301 },
  uccode=0x038C,
  unicodeslot=0x03CC,
 },
 [0x03CD]={
  adobename="upsilontonos",
  category="ll",
  contextname="greekupsilontonos",
  description="GREEK SMALL LETTER UPSILON WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x03C5,
  specials={ "char", 0x03C5, 0x0301 },
  uccode=0x038E,
  unicodeslot=0x03CD,
 },
 [0x03CE]={
  adobename="omegatonos",
  category="ll",
  contextname="greekomegatonos",
  description="GREEK SMALL LETTER OMEGA WITH TONOS",
  direction="l",
  linebreak="al",
  shcode=0x03C9,
  specials={ "char", 0x03C9, 0x0301 },
  uccode=0x038F,
  unicodeslot=0x03CE,
 },
 [0x03CF]={
  category="lu",
  description="GREEK CAPITAL KAI SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x03CF,
 },
 [0x03D0]={
  adobename="betasymbolgreek",
  category="ll",
  description="GREEK BETA SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x03B2 },
  uccode=0x0392,
  unicodeslot=0x03D0,
 },
 [0x03D1]={
  adobename="thetasymbolgreek",
  category="ll",
  contextname="greekthetaalt",
  description="GREEK THETA SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varTheta",
  specials={ "compat", 0x03B8 },
  uccode=0x0398,
  unicodeslot=0x03D1,
 },
 [0x03D2]={
  adobename="Upsilonhooksymbol",
  category="lu",
  description="GREEK UPSILON WITH HOOK SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x03A5 },
  unicodeslot=0x03D2,
 },
 [0x03D3]={
  adobename="Upsilonacutehooksymbolgreek",
  category="lu",
  description="GREEK UPSILON WITH ACUTE AND HOOK SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "char", 0x03D2, 0x0301 },
  unicodeslot=0x03D3,
 },
 [0x03D4]={
  adobename="Upsilondieresishooksymbolgreek",
  category="lu",
  description="GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "char", 0x03D2, 0x0308 },
  unicodeslot=0x03D4,
 },
 [0x03D5]={
  adobename="phisymbolgreek",
  category="ll",
  contextname="greekphialt",
  description="GREEK PHI SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="phi",
  specials={ "compat", 0x03C6 },
  uccode=0x03A6,
  unicodeslot=0x03D5,
 },
 [0x03D6]={
  adobename="pisymbolgreek",
  category="ll",
  contextname="greekpialt",
  description="GREEK PI SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="varpi",
  specials={ "compat", 0x03C0 },
  uccode=0x03A0,
  unicodeslot=0x03D6,
 },
 [0x03D7]={
  category="ll",
  description="GREEK KAI SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x03D7,
 },
 [0x03D8]={
  category="lu",
  description="GREEK LETTER ARCHAIC KOPPA",
  direction="l",
  lccode=0x03D9,
  linebreak="al",
  unicodeslot=0x03D8,
 },
 [0x03D9]={
  category="ll",
  contextname="greekkoppa",
  description="GREEK SMALL LETTER ARCHAIC KOPPA",
  direction="l",
  linebreak="al",
  uccode=0x03D8,
  unicodeslot=0x03D9,
 },
 [0x03DA]={
  adobename="Stigmagreek",
  category="lu",
  description="GREEK LETTER STIGMA",
  direction="l",
  lccode=0x03DB,
  linebreak="al",
  unicodeslot=0x03DA,
 },
 [0x03DB]={
  category="ll",
  contextname="greekstigma",
  description="GREEK SMALL LETTER STIGMA",
  direction="l",
  linebreak="al",
  uccode=0x03DA,
  unicodeslot=0x03DB,
 },
 [0x03DC]={
  adobename="Digammagreek",
  category="lu",
  description="GREEK LETTER DIGAMMA",
  direction="l",
  lccode=0x03DD,
  linebreak="al",
  mathclass="variable",
  mathname="digamma",
  unicodeslot=0x03DC,
 },
 [0x03DD]={
  category="ll",
  contextname="greekdigamma",
  description="GREEK SMALL LETTER DIGAMMA",
  direction="l",
  linebreak="al",
  uccode=0x03DC,
  unicodeslot=0x03DD,
 },
 [0x03DE]={
  adobename="Koppagreek",
  category="lu",
  description="GREEK LETTER KOPPA",
  direction="l",
  lccode=0x03DF,
  linebreak="al",
  unicodeslot=0x03DE,
 },
 [0x03DF]={
  category="ll",
  contextname="greeknumkoppa",
  description="GREEK SMALL LETTER KOPPA",
  direction="l",
  linebreak="al",
  uccode=0x03DE,
  unicodeslot=0x03DF,
 },
 [0x03E0]={
  adobename="Sampigreek",
  category="lu",
  description="GREEK LETTER SAMPI",
  direction="l",
  lccode=0x03E1,
  linebreak="al",
  unicodeslot=0x03E0,
 },
 [0x03E1]={
  category="ll",
  contextname="greeksampi",
  description="GREEK SMALL LETTER SAMPI",
  direction="l",
  linebreak="al",
  uccode=0x03E0,
  unicodeslot=0x03E1,
 },
 [0x03E2]={
  adobename="Sheicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER SHEI",
  direction="l",
  lccode=0x03E3,
  linebreak="al",
  unicodeslot=0x03E2,
 },
 [0x03E3]={
  adobename="sheicoptic",
  category="ll",
  description="COPTIC SMALL LETTER SHEI",
  direction="l",
  linebreak="al",
  uccode=0x03E2,
  unicodeslot=0x03E3,
 },
 [0x03E4]={
  adobename="Feicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER FEI",
  direction="l",
  lccode=0x03E5,
  linebreak="al",
  unicodeslot=0x03E4,
 },
 [0x03E5]={
  adobename="feicoptic",
  category="ll",
  description="COPTIC SMALL LETTER FEI",
  direction="l",
  linebreak="al",
  uccode=0x03E4,
  unicodeslot=0x03E5,
 },
 [0x03E6]={
  adobename="Kheicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER KHEI",
  direction="l",
  lccode=0x03E7,
  linebreak="al",
  unicodeslot=0x03E6,
 },
 [0x03E7]={
  adobename="kheicoptic",
  category="ll",
  description="COPTIC SMALL LETTER KHEI",
  direction="l",
  linebreak="al",
  uccode=0x03E6,
  unicodeslot=0x03E7,
 },
 [0x03E8]={
  adobename="Horicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER HORI",
  direction="l",
  lccode=0x03E9,
  linebreak="al",
  unicodeslot=0x03E8,
 },
 [0x03E9]={
  adobename="horicoptic",
  category="ll",
  description="COPTIC SMALL LETTER HORI",
  direction="l",
  linebreak="al",
  uccode=0x03E8,
  unicodeslot=0x03E9,
 },
 [0x03EA]={
  adobename="Gangiacoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER GANGIA",
  direction="l",
  lccode=0x03EB,
  linebreak="al",
  unicodeslot=0x03EA,
 },
 [0x03EB]={
  adobename="gangiacoptic",
  category="ll",
  description="COPTIC SMALL LETTER GANGIA",
  direction="l",
  linebreak="al",
  uccode=0x03EA,
  unicodeslot=0x03EB,
 },
 [0x03EC]={
  adobename="Shimacoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER SHIMA",
  direction="l",
  lccode=0x03ED,
  linebreak="al",
  unicodeslot=0x03EC,
 },
 [0x03ED]={
  adobename="shimacoptic",
  category="ll",
  description="COPTIC SMALL LETTER SHIMA",
  direction="l",
  linebreak="al",
  uccode=0x03EC,
  unicodeslot=0x03ED,
 },
 [0x03EE]={
  adobename="Deicoptic",
  category="lu",
  description="COPTIC CAPITAL LETTER DEI",
  direction="l",
  lccode=0x03EF,
  linebreak="al",
  unicodeslot=0x03EE,
 },
 [0x03EF]={
  adobename="deicoptic",
  category="ll",
  description="COPTIC SMALL LETTER DEI",
  direction="l",
  linebreak="al",
  uccode=0x03EE,
  unicodeslot=0x03EF,
 },
 [0x03F0]={
  adobename="kappasymbolgreek",
  category="ll",
  description="GREEK KAPPA SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="ord",
  mathname="varkappa",
  specials={ "compat", 0x03BA },
  uccode=0x039A,
  unicodeslot=0x03F0,
 },
 [0x03F1]={
  adobename="rhosymbolgreek",
  category="ll",
  contextname="greekrhoalt",
  description="GREEK RHO SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x03C1 },
  uccode=0x03A1,
  unicodeslot=0x03F1,
 },
 [0x03F2]={
  adobename="sigmalunatesymbolgreek",
  category="ll",
  contextname="greeksigmalunate",
  description="GREEK LUNATE SIGMA SYMBOL",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x03C2 },
  uccode=0x03F9,
  unicodeslot=0x03F2,
 },
 [0x03F3]={
  adobename="yotgreek",
  category="ll",
  description="GREEK LETTER YOT",
  direction="l",
  linebreak="al",
  unicodeslot=0x03F3,
 },
 [0x03F4]={
  category="lu",
  description="GREEK CAPITAL THETA SYMBOL",
  direction="l",
  lccode=0x03B8,
  linebreak="al",
  specials={ "compat", 0x0398 },
  unicodeslot=0x03F4,
 },
 [0x03F5]={
  category="ll",
  contextname="greekepsilonalt",
  description="GREEK LUNATE EPSILON SYMBOL",
  direction="l",
  linebreak="al",
  mathclass="variable",
  mathname="epsilon",
  specials={ "compat", 0x03B5 },
  uccode=0x0395,
  unicodeslot=0x03F5,
 },
 [0x03F6]={
  category="sm",
  description="GREEK REVERSED LUNATE EPSILON SYMBOL",
  direction="on",
  linebreak="al",
  mathclass="variable",
  mathname="backepsilon",
  unicodeslot=0x03F6,
 },
 [0x03F7]={
  category="lu",
  description="GREEK CAPITAL LETTER SHO",
  direction="l",
  lccode=0x03F8,
  linebreak="al",
  unicodeslot=0x03F7,
 },
 [0x03F8]={
  category="ll",
  description="GREEK SMALL LETTER SHO",
  direction="l",
  linebreak="al",
  uccode=0x03F7,
  unicodeslot=0x03F8,
 },
 [0x03F9]={
  category="lu",
  contextname="greekSigmalunate",
  description="GREEK CAPITAL LUNATE SIGMA SYMBOL",
  direction="l",
  lccode=0x03F2,
  linebreak="al",
  specials={ "compat", 0x03A3 },
  unicodeslot=0x03F9,
 },
 [0x03FA]={
  category="lu",
  description="GREEK CAPITAL LETTER SAN",
  direction="l",
  lccode=0x03FB,
  linebreak="al",
  unicodeslot=0x03FA,
 },
 [0x03FB]={
  category="ll",
  description="GREEK SMALL LETTER SAN",
  direction="l",
  linebreak="al",
  uccode=0x03FA,
  unicodeslot=0x03FB,
 },
 [0x03FC]={
  category="ll",
  description="GREEK RHO WITH STROKE SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x03FC,
 },
 [0x03FD]={
  category="lu",
  description="GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL",
  direction="l",
  lccode=0x037B,
  linebreak="al",
  unicodeslot=0x03FD,
 },
 [0x03FE]={
  category="lu",
  description="GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL",
  direction="l",
  lccode=0x037C,
  linebreak="al",
  unicodeslot=0x03FE,
 },
 [0x03FF]={
  category="lu",
  description="GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL",
  direction="l",
  lccode=0x037D,
  linebreak="al",
  unicodeslot=0x03FF,
 },
 [0x0400]={
  category="lu",
  contextname="cyrillicEgrave",
  description="CYRILLIC CAPITAL LETTER IE WITH GRAVE",
  direction="l",
  lccode=0x0450,
  linebreak="al",
  shcode=0x0415,
  specials={ "char", 0x0415, 0x0300 },
  unicodeslot=0x0400,
 },
 [0x0401]={
  adobename="afii10023",
  category="lu",
  cjkwd="a",
  contextname="cyrillicYO",
  description="CYRILLIC CAPITAL LETTER IO",
  direction="l",
  lccode=0x0451,
  linebreak="al",
  specials={ "char", 0x0415, 0x0308 },
  unicodeslot=0x0401,
 },
 [0x0402]={
  adobename="afii10051",
  category="lu",
  contextname="cyrillicDJE",
  description="CYRILLIC CAPITAL LETTER DJE",
  direction="l",
  lccode=0x0452,
  linebreak="al",
  unicodeslot=0x0402,
 },
 [0x0403]={
  adobename="afii10052",
  category="lu",
  contextname="cyrillicGJE",
  description="CYRILLIC CAPITAL LETTER GJE",
  direction="l",
  lccode=0x0453,
  linebreak="al",
  specials={ "char", 0x0413, 0x0301 },
  unicodeslot=0x0403,
 },
 [0x0404]={
  adobename="afii10053",
  category="lu",
  contextname="cyrillicIE",
  description="CYRILLIC CAPITAL LETTER UKRAINIAN IE",
  direction="l",
  lccode=0x0454,
  linebreak="al",
  unicodeslot=0x0404,
 },
 [0x0405]={
  adobename="afii10054",
  category="lu",
  contextname="cyrillicDZE",
  description="CYRILLIC CAPITAL LETTER DZE",
  direction="l",
  lccode=0x0455,
  linebreak="al",
  unicodeslot=0x0405,
 },
 [0x0406]={
  adobename="afii10055",
  category="lu",
  contextname="cyrillicII",
  description="CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I",
  direction="l",
  lccode=0x0456,
  linebreak="al",
  unicodeslot=0x0406,
 },
 [0x0407]={
  adobename="afii10056",
  category="lu",
  contextname="cyrillicYI",
  description="CYRILLIC CAPITAL LETTER YI",
  direction="l",
  lccode=0x0457,
  linebreak="al",
  specials={ "char", 0x0406, 0x0308 },
  unicodeslot=0x0407,
 },
 [0x0408]={
  adobename="afii10057",
  category="lu",
  contextname="cyrillicJE",
  description="CYRILLIC CAPITAL LETTER JE",
  direction="l",
  lccode=0x0458,
  linebreak="al",
  unicodeslot=0x0408,
 },
 [0x0409]={
  adobename="afii10058",
  category="lu",
  contextname="cyrillicLJE",
  description="CYRILLIC CAPITAL LETTER LJE",
  direction="l",
  lccode=0x0459,
  linebreak="al",
  unicodeslot=0x0409,
 },
 [0x040A]={
  adobename="afii10059",
  category="lu",
  contextname="cyrillicNJE",
  description="CYRILLIC CAPITAL LETTER NJE",
  direction="l",
  lccode=0x045A,
  linebreak="al",
  unicodeslot=0x040A,
 },
 [0x040B]={
  adobename="afii10060",
  category="lu",
  contextname="cyrillicTSHE",
  description="CYRILLIC CAPITAL LETTER TSHE",
  direction="l",
  lccode=0x045B,
  linebreak="al",
  unicodeslot=0x040B,
 },
 [0x040C]={
  adobename="afii10061",
  category="lu",
  contextname="cyrillicKJE",
  description="CYRILLIC CAPITAL LETTER KJE",
  direction="l",
  lccode=0x045C,
  linebreak="al",
  specials={ "char", 0x041A, 0x0301 },
  unicodeslot=0x040C,
 },
 [0x040D]={
  category="lu",
  contextname="cyrillicIgrave",
  description="CYRILLIC CAPITAL LETTER I WITH GRAVE",
  direction="l",
  lccode=0x045D,
  linebreak="al",
  shcode=0x0418,
  specials={ "char", 0x0418, 0x0300 },
  unicodeslot=0x040D,
 },
 [0x040E]={
  adobename="afii10062",
  category="lu",
  contextname="cyrillicUSHRT",
  description="CYRILLIC CAPITAL LETTER SHORT U",
  direction="l",
  lccode=0x045E,
  linebreak="al",
  specials={ "char", 0x0423, 0x0306 },
  unicodeslot=0x040E,
 },
 [0x040F]={
  adobename="afii10145",
  category="lu",
  contextname="cyrillicDZHE",
  description="CYRILLIC CAPITAL LETTER DZHE",
  direction="l",
  lccode=0x045F,
  linebreak="al",
  unicodeslot=0x040F,
 },
 [0x0410]={
  adobename="afii10017",
  category="lu",
  cjkwd="a",
  contextname="cyrillicA",
  description="CYRILLIC CAPITAL LETTER A",
  direction="l",
  lccode=0x0430,
  linebreak="al",
  unicodeslot=0x0410,
 },
 [0x0411]={
  adobename="afii10018",
  category="lu",
  cjkwd="a",
  contextname="cyrillicB",
  description="CYRILLIC CAPITAL LETTER BE",
  direction="l",
  lccode=0x0431,
  linebreak="al",
  unicodeslot=0x0411,
 },
 [0x0412]={
  adobename="afii10019",
  category="lu",
  cjkwd="a",
  contextname="cyrillicV",
  description="CYRILLIC CAPITAL LETTER VE",
  direction="l",
  lccode=0x0432,
  linebreak="al",
  unicodeslot=0x0412,
 },
 [0x0413]={
  adobename="afii10020",
  category="lu",
  cjkwd="a",
  contextname="cyrillicG",
  description="CYRILLIC CAPITAL LETTER GHE",
  direction="l",
  lccode=0x0433,
  linebreak="al",
  unicodeslot=0x0413,
 },
 [0x0414]={
  adobename="afii10021",
  category="lu",
  cjkwd="a",
  contextname="cyrillicD",
  description="CYRILLIC CAPITAL LETTER DE",
  direction="l",
  lccode=0x0434,
  linebreak="al",
  unicodeslot=0x0414,
 },
 [0x0415]={
  adobename="afii10022",
  category="lu",
  cjkwd="a",
  contextname="cyrillicE",
  description="CYRILLIC CAPITAL LETTER IE",
  direction="l",
  lccode=0x0435,
  linebreak="al",
  unicodeslot=0x0415,
 },
 [0x0416]={
  adobename="afii10024",
  category="lu",
  cjkwd="a",
  contextname="cyrillicZH",
  description="CYRILLIC CAPITAL LETTER ZHE",
  direction="l",
  lccode=0x0436,
  linebreak="al",
  unicodeslot=0x0416,
 },
 [0x0417]={
  adobename="afii10025",
  category="lu",
  cjkwd="a",
  contextname="cyrillicZ",
  description="CYRILLIC CAPITAL LETTER ZE",
  direction="l",
  lccode=0x0437,
  linebreak="al",
  unicodeslot=0x0417,
 },
 [0x0418]={
  adobename="afii10026",
  category="lu",
  cjkwd="a",
  contextname="cyrillicI",
  description="CYRILLIC CAPITAL LETTER I",
  direction="l",
  lccode=0x0438,
  linebreak="al",
  unicodeslot=0x0418,
 },
 [0x0419]={
  adobename="afii10027",
  category="lu",
  cjkwd="a",
  contextname="cyrillicISHRT",
  description="CYRILLIC CAPITAL LETTER SHORT I",
  direction="l",
  lccode=0x0439,
  linebreak="al",
  specials={ "char", 0x0418, 0x0306 },
  unicodeslot=0x0419,
 },
 [0x041A]={
  adobename="afii10028",
  category="lu",
  cjkwd="a",
  contextname="cyrillicK",
  description="CYRILLIC CAPITAL LETTER KA",
  direction="l",
  lccode=0x043A,
  linebreak="al",
  unicodeslot=0x041A,
 },
 [0x041B]={
  adobename="afii10029",
  category="lu",
  cjkwd="a",
  contextname="cyrillicL",
  description="CYRILLIC CAPITAL LETTER EL",
  direction="l",
  lccode=0x043B,
  linebreak="al",
  unicodeslot=0x041B,
 },
 [0x041C]={
  adobename="afii10030",
  category="lu",
  cjkwd="a",
  contextname="cyrillicM",
  description="CYRILLIC CAPITAL LETTER EM",
  direction="l",
  lccode=0x043C,
  linebreak="al",
  unicodeslot=0x041C,
 },
 [0x041D]={
  adobename="afii10031",
  category="lu",
  cjkwd="a",
  contextname="cyrillicN",
  description="CYRILLIC CAPITAL LETTER EN",
  direction="l",
  lccode=0x043D,
  linebreak="al",
  unicodeslot=0x041D,
 },
 [0x041E]={
  adobename="afii10032",
  category="lu",
  cjkwd="a",
  contextname="cyrillicO",
  description="CYRILLIC CAPITAL LETTER O",
  direction="l",
  lccode=0x043E,
  linebreak="al",
  unicodeslot=0x041E,
 },
 [0x041F]={
  adobename="afii10033",
  category="lu",
  cjkwd="a",
  contextname="cyrillicP",
  description="CYRILLIC CAPITAL LETTER PE",
  direction="l",
  lccode=0x043F,
  linebreak="al",
  unicodeslot=0x041F,
 },
 [0x0420]={
  adobename="afii10034",
  category="lu",
  cjkwd="a",
  contextname="cyrillicR",
  description="CYRILLIC CAPITAL LETTER ER",
  direction="l",
  lccode=0x0440,
  linebreak="al",
  unicodeslot=0x0420,
 },
 [0x0421]={
  adobename="afii10035",
  category="lu",
  cjkwd="a",
  contextname="cyrillicS",
  description="CYRILLIC CAPITAL LETTER ES",
  direction="l",
  lccode=0x0441,
  linebreak="al",
  unicodeslot=0x0421,
 },
 [0x0422]={
  adobename="afii10036",
  category="lu",
  cjkwd="a",
  contextname="cyrillicT",
  description="CYRILLIC CAPITAL LETTER TE",
  direction="l",
  lccode=0x0442,
  linebreak="al",
  unicodeslot=0x0422,
 },
 [0x0423]={
  adobename="afii10037",
  category="lu",
  cjkwd="a",
  contextname="cyrillicU",
  description="CYRILLIC CAPITAL LETTER U",
  direction="l",
  lccode=0x0443,
  linebreak="al",
  unicodeslot=0x0423,
 },
 [0x0424]={
  adobename="afii10038",
  category="lu",
  cjkwd="a",
  contextname="cyrillicF",
  description="CYRILLIC CAPITAL LETTER EF",
  direction="l",
  lccode=0x0444,
  linebreak="al",
  unicodeslot=0x0424,
 },
 [0x0425]={
  adobename="afii10039",
  category="lu",
  cjkwd="a",
  contextname="cyrillicH",
  description="CYRILLIC CAPITAL LETTER HA",
  direction="l",
  lccode=0x0445,
  linebreak="al",
  unicodeslot=0x0425,
 },
 [0x0426]={
  adobename="afii10040",
  category="lu",
  cjkwd="a",
  contextname="cyrillicC",
  description="CYRILLIC CAPITAL LETTER TSE",
  direction="l",
  lccode=0x0446,
  linebreak="al",
  unicodeslot=0x0426,
 },
 [0x0427]={
  adobename="afii10041",
  category="lu",
  cjkwd="a",
  contextname="cyrillicCH",
  description="CYRILLIC CAPITAL LETTER CHE",
  direction="l",
  lccode=0x0447,
  linebreak="al",
  unicodeslot=0x0427,
 },
 [0x0428]={
  adobename="afii10042",
  category="lu",
  cjkwd="a",
  contextname="cyrillicSH",
  description="CYRILLIC CAPITAL LETTER SHA",
  direction="l",
  lccode=0x0448,
  linebreak="al",
  unicodeslot=0x0428,
 },
 [0x0429]={
  adobename="afii10043",
  category="lu",
  cjkwd="a",
  contextname="cyrillicSHCH",
  description="CYRILLIC CAPITAL LETTER SHCHA",
  direction="l",
  lccode=0x0449,
  linebreak="al",
  unicodeslot=0x0429,
 },
 [0x042A]={
  adobename="afii10044",
  category="lu",
  cjkwd="a",
  contextname="cyrillicHRDSN",
  description="CYRILLIC CAPITAL LETTER HARD SIGN",
  direction="l",
  lccode=0x044A,
  linebreak="al",
  unicodeslot=0x042A,
 },
 [0x042B]={
  adobename="afii10045",
  category="lu",
  cjkwd="a",
  contextname="cyrillicERY",
  description="CYRILLIC CAPITAL LETTER YERU",
  direction="l",
  lccode=0x044B,
  linebreak="al",
  unicodeslot=0x042B,
 },
 [0x042C]={
  adobename="afii10046",
  category="lu",
  cjkwd="a",
  contextname="cyrillicSFTSN",
  description="CYRILLIC CAPITAL LETTER SOFT SIGN",
  direction="l",
  lccode=0x044C,
  linebreak="al",
  unicodeslot=0x042C,
 },
 [0x042D]={
  adobename="afii10047",
  category="lu",
  cjkwd="a",
  contextname="cyrillicEREV",
  description="CYRILLIC CAPITAL LETTER E",
  direction="l",
  lccode=0x044D,
  linebreak="al",
  unicodeslot=0x042D,
 },
 [0x042E]={
  adobename="afii10048",
  category="lu",
  cjkwd="a",
  contextname="cyrillicYU",
  description="CYRILLIC CAPITAL LETTER YU",
  direction="l",
  lccode=0x044E,
  linebreak="al",
  unicodeslot=0x042E,
 },
 [0x042F]={
  adobename="afii10049",
  category="lu",
  cjkwd="a",
  contextname="cyrillicYA",
  description="CYRILLIC CAPITAL LETTER YA",
  direction="l",
  lccode=0x044F,
  linebreak="al",
  unicodeslot=0x042F,
 },
 [0x0430]={
  adobename="afii10065",
  category="ll",
  cjkwd="a",
  contextname="cyrillica",
  description="CYRILLIC SMALL LETTER A",
  direction="l",
  linebreak="al",
  uccode=0x0410,
  unicodeslot=0x0430,
 },
 [0x0431]={
  adobename="becyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicb",
  description="CYRILLIC SMALL LETTER BE",
  direction="l",
  linebreak="al",
  uccode=0x0411,
  unicodeslot=0x0431,
 },
 [0x0432]={
  adobename="vecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicv",
  description="CYRILLIC SMALL LETTER VE",
  direction="l",
  linebreak="al",
  uccode=0x0412,
  unicodeslot=0x0432,
 },
 [0x0433]={
  adobename="gecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicg",
  description="CYRILLIC SMALL LETTER GHE",
  direction="l",
  linebreak="al",
  uccode=0x0413,
  unicodeslot=0x0433,
 },
 [0x0434]={
  adobename="decyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicd",
  description="CYRILLIC SMALL LETTER DE",
  direction="l",
  linebreak="al",
  uccode=0x0414,
  unicodeslot=0x0434,
 },
 [0x0435]={
  adobename="iecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillice",
  description="CYRILLIC SMALL LETTER IE",
  direction="l",
  linebreak="al",
  uccode=0x0415,
  unicodeslot=0x0435,
 },
 [0x0436]={
  adobename="zhecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrilliczh",
  description="CYRILLIC SMALL LETTER ZHE",
  direction="l",
  linebreak="al",
  uccode=0x0416,
  unicodeslot=0x0436,
 },
 [0x0437]={
  adobename="zecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicz",
  description="CYRILLIC SMALL LETTER ZE",
  direction="l",
  linebreak="al",
  uccode=0x0417,
  unicodeslot=0x0437,
 },
 [0x0438]={
  adobename="iicyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillici",
  description="CYRILLIC SMALL LETTER I",
  direction="l",
  linebreak="al",
  uccode=0x0418,
  unicodeslot=0x0438,
 },
 [0x0439]={
  adobename="iishortcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicishrt",
  description="CYRILLIC SMALL LETTER SHORT I",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0438, 0x0306 },
  uccode=0x0419,
  unicodeslot=0x0439,
 },
 [0x043A]={
  adobename="kacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillick",
  description="CYRILLIC SMALL LETTER KA",
  direction="l",
  linebreak="al",
  uccode=0x041A,
  unicodeslot=0x043A,
 },
 [0x043B]={
  adobename="elcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicl",
  description="CYRILLIC SMALL LETTER EL",
  direction="l",
  linebreak="al",
  uccode=0x041B,
  unicodeslot=0x043B,
 },
 [0x043C]={
  adobename="emcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicm",
  description="CYRILLIC SMALL LETTER EM",
  direction="l",
  linebreak="al",
  uccode=0x041C,
  unicodeslot=0x043C,
 },
 [0x043D]={
  adobename="encyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicn",
  description="CYRILLIC SMALL LETTER EN",
  direction="l",
  linebreak="al",
  uccode=0x041D,
  unicodeslot=0x043D,
 },
 [0x043E]={
  adobename="ocyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillico",
  description="CYRILLIC SMALL LETTER O",
  direction="l",
  linebreak="al",
  uccode=0x041E,
  unicodeslot=0x043E,
 },
 [0x043F]={
  adobename="pecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicp",
  description="CYRILLIC SMALL LETTER PE",
  direction="l",
  linebreak="al",
  uccode=0x041F,
  unicodeslot=0x043F,
 },
 [0x0440]={
  adobename="ercyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicr",
  description="CYRILLIC SMALL LETTER ER",
  direction="l",
  linebreak="al",
  uccode=0x0420,
  unicodeslot=0x0440,
 },
 [0x0441]={
  adobename="escyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillics",
  description="CYRILLIC SMALL LETTER ES",
  direction="l",
  linebreak="al",
  uccode=0x0421,
  unicodeslot=0x0441,
 },
 [0x0442]={
  adobename="tecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillict",
  description="CYRILLIC SMALL LETTER TE",
  direction="l",
  linebreak="al",
  uccode=0x0422,
  unicodeslot=0x0442,
 },
 [0x0443]={
  adobename="ucyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicu",
  description="CYRILLIC SMALL LETTER U",
  direction="l",
  linebreak="al",
  uccode=0x0423,
  unicodeslot=0x0443,
 },
 [0x0444]={
  adobename="efcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicf",
  description="CYRILLIC SMALL LETTER EF",
  direction="l",
  linebreak="al",
  uccode=0x0424,
  unicodeslot=0x0444,
 },
 [0x0445]={
  adobename="khacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillich",
  description="CYRILLIC SMALL LETTER HA",
  direction="l",
  linebreak="al",
  uccode=0x0425,
  unicodeslot=0x0445,
 },
 [0x0446]={
  adobename="tsecyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicc",
  description="CYRILLIC SMALL LETTER TSE",
  direction="l",
  linebreak="al",
  uccode=0x0426,
  unicodeslot=0x0446,
 },
 [0x0447]={
  adobename="checyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicch",
  description="CYRILLIC SMALL LETTER CHE",
  direction="l",
  linebreak="al",
  uccode=0x0427,
  unicodeslot=0x0447,
 },
 [0x0448]={
  adobename="shacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicsh",
  description="CYRILLIC SMALL LETTER SHA",
  direction="l",
  linebreak="al",
  uccode=0x0428,
  unicodeslot=0x0448,
 },
 [0x0449]={
  adobename="shchacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicshch",
  description="CYRILLIC SMALL LETTER SHCHA",
  direction="l",
  linebreak="al",
  uccode=0x0429,
  unicodeslot=0x0449,
 },
 [0x044A]={
  adobename="hardsigncyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillichrdsn",
  description="CYRILLIC SMALL LETTER HARD SIGN",
  direction="l",
  linebreak="al",
  uccode=0x042A,
  unicodeslot=0x044A,
 },
 [0x044B]={
  adobename="yericyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicery",
  description="CYRILLIC SMALL LETTER YERU",
  direction="l",
  linebreak="al",
  uccode=0x042B,
  unicodeslot=0x044B,
 },
 [0x044C]={
  adobename="softsigncyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicsftsn",
  description="CYRILLIC SMALL LETTER SOFT SIGN",
  direction="l",
  linebreak="al",
  uccode=0x042C,
  unicodeslot=0x044C,
 },
 [0x044D]={
  adobename="ereversedcyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicerev",
  description="CYRILLIC SMALL LETTER E",
  direction="l",
  linebreak="al",
  uccode=0x042D,
  unicodeslot=0x044D,
 },
 [0x044E]={
  adobename="iucyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicyu",
  description="CYRILLIC SMALL LETTER YU",
  direction="l",
  linebreak="al",
  uccode=0x042E,
  unicodeslot=0x044E,
 },
 [0x044F]={
  adobename="iacyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicya",
  description="CYRILLIC SMALL LETTER YA",
  direction="l",
  linebreak="al",
  uccode=0x042F,
  unicodeslot=0x044F,
 },
 [0x0450]={
  category="ll",
  contextname="cyrillicegrave",
  description="CYRILLIC SMALL LETTER IE WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0435,
  specials={ "char", 0x0435, 0x0300 },
  uccode=0x0400,
  unicodeslot=0x0450,
 },
 [0x0451]={
  adobename="iocyrillic",
  category="ll",
  cjkwd="a",
  contextname="cyrillicyo",
  description="CYRILLIC SMALL LETTER IO",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0435, 0x0308 },
  uccode=0x0401,
  unicodeslot=0x0451,
 },
 [0x0452]={
  adobename="djecyrillic",
  category="ll",
  contextname="cyrillicdje",
  description="CYRILLIC SMALL LETTER DJE",
  direction="l",
  linebreak="al",
  uccode=0x0402,
  unicodeslot=0x0452,
 },
 [0x0453]={
  adobename="gjecyrillic",
  category="ll",
  contextname="cyrillicgje",
  description="CYRILLIC SMALL LETTER GJE",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0433, 0x0301 },
  uccode=0x0403,
  unicodeslot=0x0453,
 },
 [0x0454]={
  adobename="ecyrillic",
  category="ll",
  contextname="cyrillicie",
  description="CYRILLIC SMALL LETTER UKRAINIAN IE",
  direction="l",
  linebreak="al",
  uccode=0x0404,
  unicodeslot=0x0454,
 },
 [0x0455]={
  adobename="dzecyrillic",
  category="ll",
  contextname="cyrillicdze",
  description="CYRILLIC SMALL LETTER DZE",
  direction="l",
  linebreak="al",
  uccode=0x0405,
  unicodeslot=0x0455,
 },
 [0x0456]={
  adobename="icyrillic",
  category="ll",
  contextname="cyrillicii",
  description="CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I",
  direction="l",
  linebreak="al",
  uccode=0x0406,
  unicodeslot=0x0456,
 },
 [0x0457]={
  adobename="yicyrillic",
  category="ll",
  contextname="cyrillicyi",
  description="CYRILLIC SMALL LETTER YI",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0456, 0x0308 },
  uccode=0x0407,
  unicodeslot=0x0457,
 },
 [0x0458]={
  adobename="jecyrillic",
  category="ll",
  contextname="cyrillicje",
  description="CYRILLIC SMALL LETTER JE",
  direction="l",
  linebreak="al",
  uccode=0x0408,
  unicodeslot=0x0458,
 },
 [0x0459]={
  adobename="ljecyrillic",
  category="ll",
  contextname="cyrilliclje",
  description="CYRILLIC SMALL LETTER LJE",
  direction="l",
  linebreak="al",
  uccode=0x0409,
  unicodeslot=0x0459,
 },
 [0x045A]={
  adobename="njecyrillic",
  category="ll",
  contextname="cyrillicnje",
  description="CYRILLIC SMALL LETTER NJE",
  direction="l",
  linebreak="al",
  uccode=0x040A,
  unicodeslot=0x045A,
 },
 [0x045B]={
  adobename="tshecyrillic",
  category="ll",
  contextname="cyrillictshe",
  description="CYRILLIC SMALL LETTER TSHE",
  direction="l",
  linebreak="al",
  uccode=0x040B,
  unicodeslot=0x045B,
 },
 [0x045C]={
  adobename="kjecyrillic",
  category="ll",
  contextname="cyrillickje",
  description="CYRILLIC SMALL LETTER KJE",
  direction="l",
  linebreak="al",
  specials={ "char", 0x043A, 0x0301 },
  uccode=0x040C,
  unicodeslot=0x045C,
 },
 [0x045D]={
  category="ll",
  contextname="cyrillicigrave",
  description="CYRILLIC SMALL LETTER I WITH GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0438,
  specials={ "char", 0x0438, 0x0300 },
  uccode=0x040D,
  unicodeslot=0x045D,
 },
 [0x045E]={
  adobename="ushortcyrillic",
  category="ll",
  contextname="cyrillicushrt",
  description="CYRILLIC SMALL LETTER SHORT U",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0443, 0x0306 },
  uccode=0x040E,
  unicodeslot=0x045E,
 },
 [0x045F]={
  adobename="dzhecyrillic",
  category="ll",
  contextname="cyrillicdzhe",
  description="CYRILLIC SMALL LETTER DZHE",
  direction="l",
  linebreak="al",
  uccode=0x040F,
  unicodeslot=0x045F,
 },
 [0x0460]={
  adobename="Omegacyrillic",
  category="lu",
  contextname="cyrillicOMEGA",
  description="CYRILLIC CAPITAL LETTER OMEGA",
  direction="l",
  lccode=0x0461,
  linebreak="al",
  unicodeslot=0x0460,
 },
 [0x0461]={
  adobename="omegacyrillic",
  category="ll",
  contextname="cyrillicomega",
  description="CYRILLIC SMALL LETTER OMEGA",
  direction="l",
  linebreak="al",
  uccode=0x0460,
  unicodeslot=0x0461,
 },
 [0x0462]={
  adobename="afii10146",
  category="lu",
  contextname="cyrillicYAT",
  description="CYRILLIC CAPITAL LETTER YAT",
  direction="l",
  lccode=0x0463,
  linebreak="al",
  unicodeslot=0x0462,
 },
 [0x0463]={
  adobename="yatcyrillic",
  category="ll",
  contextname="cyrillicyat",
  description="CYRILLIC SMALL LETTER YAT",
  direction="l",
  linebreak="al",
  uccode=0x0462,
  unicodeslot=0x0463,
 },
 [0x0464]={
  adobename="Eiotifiedcyrillic",
  category="lu",
  contextname="cyrillicEiotified",
  description="CYRILLIC CAPITAL LETTER IOTIFIED E",
  direction="l",
  lccode=0x0465,
  linebreak="al",
  unicodeslot=0x0464,
 },
 [0x0465]={
  adobename="eiotifiedcyrillic",
  category="ll",
  contextname="cyrilliceiotified",
  description="CYRILLIC SMALL LETTER IOTIFIED E",
  direction="l",
  linebreak="al",
  uccode=0x0464,
  unicodeslot=0x0465,
 },
 [0x0466]={
  adobename="Yuslittlecyrillic",
  category="lu",
  contextname="cyrillicLITTLEYUS",
  description="CYRILLIC CAPITAL LETTER LITTLE YUS",
  direction="l",
  lccode=0x0467,
  linebreak="al",
  unicodeslot=0x0466,
 },
 [0x0467]={
  adobename="yuslittlecyrillic",
  category="ll",
  contextname="cyrilliclittleyus",
  description="CYRILLIC SMALL LETTER LITTLE YUS",
  direction="l",
  linebreak="al",
  uccode=0x0466,
  unicodeslot=0x0467,
 },
 [0x0468]={
  adobename="Yuslittleiotifiedcyrillic",
  category="lu",
  contextname="cyrillicLITTLEYUSiotified",
  description="CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS",
  direction="l",
  lccode=0x0469,
  linebreak="al",
  unicodeslot=0x0468,
 },
 [0x0469]={
  adobename="yuslittleiotifiedcyrillic",
  category="ll",
  contextname="cyrilliclittleyusiotified",
  description="CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS",
  direction="l",
  linebreak="al",
  uccode=0x0468,
  unicodeslot=0x0469,
 },
 [0x046A]={
  adobename="Yusbigcyrillic",
  category="lu",
  contextname="cyrillicBIGYUS",
  description="CYRILLIC CAPITAL LETTER BIG YUS",
  direction="l",
  lccode=0x046B,
  linebreak="al",
  unicodeslot=0x046A,
 },
 [0x046B]={
  adobename="yusbigcyrillic",
  category="ll",
  contextname="cyrillicbigyus",
  description="CYRILLIC SMALL LETTER BIG YUS",
  direction="l",
  linebreak="al",
  uccode=0x046A,
  unicodeslot=0x046B,
 },
 [0x046C]={
  adobename="Yusbigiotifiedcyrillic",
  category="lu",
  contextname="cyrillicBIGYUSiotified",
  description="CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS",
  direction="l",
  lccode=0x046D,
  linebreak="al",
  unicodeslot=0x046C,
 },
 [0x046D]={
  adobename="yusbigiotifiedcyrillic",
  category="ll",
  contextname="cyrillicbigyusiotified",
  description="CYRILLIC SMALL LETTER IOTIFIED BIG YUS",
  direction="l",
  linebreak="al",
  uccode=0x046C,
  unicodeslot=0x046D,
 },
 [0x046E]={
  adobename="Ksicyrillic",
  category="lu",
  contextname="cyrillicKSI",
  description="CYRILLIC CAPITAL LETTER KSI",
  direction="l",
  lccode=0x046F,
  linebreak="al",
  unicodeslot=0x046E,
 },
 [0x046F]={
  adobename="ksicyrillic",
  category="ll",
  contextname="cyrillicksi",
  description="CYRILLIC SMALL LETTER KSI",
  direction="l",
  linebreak="al",
  uccode=0x046E,
  unicodeslot=0x046F,
 },
 [0x0470]={
  adobename="Psicyrillic",
  category="lu",
  contextname="cyrillicPSI",
  description="CYRILLIC CAPITAL LETTER PSI",
  direction="l",
  lccode=0x0471,
  linebreak="al",
  unicodeslot=0x0470,
 },
 [0x0471]={
  adobename="psicyrillic",
  category="ll",
  contextname="cyrillicpsi",
  description="CYRILLIC SMALL LETTER PSI",
  direction="l",
  linebreak="al",
  uccode=0x0470,
  unicodeslot=0x0471,
 },
 [0x0472]={
  adobename="afii10147",
  category="lu",
  contextname="cyrillicFITA",
  description="CYRILLIC CAPITAL LETTER FITA",
  direction="l",
  lccode=0x0473,
  linebreak="al",
  unicodeslot=0x0472,
 },
 [0x0473]={
  adobename="fitacyrillic",
  category="ll",
  contextname="cyrillicfita",
  description="CYRILLIC SMALL LETTER FITA",
  direction="l",
  linebreak="al",
  uccode=0x0472,
  unicodeslot=0x0473,
 },
 [0x0474]={
  adobename="afii10148",
  category="lu",
  contextname="cyrillicIZHITSA",
  description="CYRILLIC CAPITAL LETTER IZHITSA",
  direction="l",
  lccode=0x0475,
  linebreak="al",
  unicodeslot=0x0474,
 },
 [0x0475]={
  adobename="izhitsacyrillic",
  category="ll",
  contextname="cyrillicizhitsa",
  description="CYRILLIC SMALL LETTER IZHITSA",
  direction="l",
  linebreak="al",
  uccode=0x0474,
  unicodeslot=0x0475,
 },
 [0x0476]={
  adobename="Izhitsadblgravecyrillic",
  category="lu",
  contextname="cyrillicIZHITSAdoublegrave",
  description="CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
  direction="l",
  lccode=0x0477,
  linebreak="al",
  shcode=0x0474,
  specials={ "char", 0x0474, 0x030F },
  unicodeslot=0x0476,
 },
 [0x0477]={
  adobename="izhitsadblgravecyrillic",
  category="ll",
  contextname="cyrillicizhitsadoublegrave",
  description="CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
  direction="l",
  linebreak="al",
  shcode=0x0475,
  specials={ "char", 0x0475, 0x030F },
  uccode=0x0476,
  unicodeslot=0x0477,
 },
 [0x0478]={
  adobename="Ukcyrillic",
  category="lu",
  contextname="cyrillicUK",
  description="CYRILLIC CAPITAL LETTER UK",
  direction="l",
  lccode=0x0479,
  linebreak="al",
  unicodeslot=0x0478,
 },
 [0x0479]={
  adobename="ukcyrillic",
  category="ll",
  contextname="cyrillicuk",
  description="CYRILLIC SMALL LETTER UK",
  direction="l",
  linebreak="al",
  uccode=0x0478,
  unicodeslot=0x0479,
 },
 [0x047A]={
  adobename="Omegaroundcyrillic",
  category="lu",
  contextname="cyrillicOMEGAround",
  description="CYRILLIC CAPITAL LETTER ROUND OMEGA",
  direction="l",
  lccode=0x047B,
  linebreak="al",
  unicodeslot=0x047A,
 },
 [0x047B]={
  adobename="omegaroundcyrillic",
  category="ll",
  contextname="cyrillicomegaround",
  description="CYRILLIC SMALL LETTER ROUND OMEGA",
  direction="l",
  linebreak="al",
  uccode=0x047A,
  unicodeslot=0x047B,
 },
 [0x047C]={
  adobename="Omegatitlocyrillic",
  category="lu",
  contextname="cyrillicOMEGAtitlo",
  description="CYRILLIC CAPITAL LETTER OMEGA WITH TITLO",
  direction="l",
  lccode=0x047D,
  linebreak="al",
  shcode=0x0460,
  unicodeslot=0x047C,
 },
 [0x047D]={
  adobename="omegatitlocyrillic",
  category="ll",
  contextname="cyrillicomegatitlo",
  description="CYRILLIC SMALL LETTER OMEGA WITH TITLO",
  direction="l",
  linebreak="al",
  shcode=0x0461,
  uccode=0x047C,
  unicodeslot=0x047D,
 },
 [0x047E]={
  adobename="Otcyrillic",
  category="lu",
  contextname="cyrillicOT",
  description="CYRILLIC CAPITAL LETTER OT",
  direction="l",
  lccode=0x047F,
  linebreak="al",
  unicodeslot=0x047E,
 },
 [0x047F]={
  adobename="otcyrillic",
  category="ll",
  contextname="cyrillicot",
  description="CYRILLIC SMALL LETTER OT",
  direction="l",
  linebreak="al",
  uccode=0x047E,
  unicodeslot=0x047F,
 },
 [0x0480]={
  adobename="Koppacyrillic",
  category="lu",
  contextname="cyrillicKOPPA",
  description="CYRILLIC CAPITAL LETTER KOPPA",
  direction="l",
  lccode=0x0481,
  linebreak="al",
  unicodeslot=0x0480,
 },
 [0x0481]={
  adobename="koppacyrillic",
  category="ll",
  contextname="cyrillickoppa",
  description="CYRILLIC SMALL LETTER KOPPA",
  direction="l",
  linebreak="al",
  uccode=0x0480,
  unicodeslot=0x0481,
 },
 [0x0482]={
  adobename="thousandcyrillic",
  category="so",
  description="CYRILLIC THOUSANDS SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0482,
 },
 [0x0483]={
  adobename="titlocyrilliccmb",
  category="mn",
  contextname="cyrillicTITLO",
  description="COMBINING CYRILLIC TITLO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0483,
 },
 [0x0484]={
  adobename="palatalizationcyrilliccmb",
  category="mn",
  contextname="cyrillicPALATALIZATION",
  description="COMBINING CYRILLIC PALATALIZATION",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0484,
 },
 [0x0485]={
  adobename="dasiapneumatacyrilliccmb",
  category="mn",
  contextname="cyrillicDASIAPNEUMATA",
  description="COMBINING CYRILLIC DASIA PNEUMATA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0485,
 },
 [0x0486]={
  adobename="psilipneumatacyrilliccmb",
  category="mn",
  contextname="cyrillicPSILIPNEUMATA",
  description="COMBINING CYRILLIC PSILI PNEUMATA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0486,
 },
 [0x0487]={
  category="mn",
  description="COMBINING CYRILLIC POKRYTIE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0487,
 },
 [0x0488]={
  category="me",
  description="COMBINING CYRILLIC HUNDRED THOUSANDS SIGN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0488,
 },
 [0x0489]={
  category="me",
  description="COMBINING CYRILLIC MILLIONS SIGN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0489,
 },
 [0x048A]={
  category="lu",
  contextname="cyrillicISHRTtail",
  description="CYRILLIC CAPITAL LETTER SHORT I WITH TAIL",
  direction="l",
  lccode=0x048B,
  linebreak="al",
  unicodeslot=0x048A,
 },
 [0x048B]={
  category="ll",
  contextname="cyrillicishrttail",
  description="CYRILLIC SMALL LETTER SHORT I WITH TAIL",
  direction="l",
  linebreak="al",
  uccode=0x048A,
  unicodeslot=0x048B,
 },
 [0x048C]={
  category="lu",
  contextname="cyrillicSEMISOFT",
  description="CYRILLIC CAPITAL LETTER SEMISOFT SIGN",
  direction="l",
  lccode=0x048D,
  linebreak="al",
  unicodeslot=0x048C,
 },
 [0x048D]={
  category="ll",
  contextname="cyrillicsemisoft",
  description="CYRILLIC SMALL LETTER SEMISOFT SIGN",
  direction="l",
  linebreak="al",
  uccode=0x048C,
  unicodeslot=0x048D,
 },
 [0x048E]={
  category="lu",
  contextname="cyrillicERtick",
  description="CYRILLIC CAPITAL LETTER ER WITH TICK",
  direction="l",
  lccode=0x048F,
  linebreak="al",
  shcode=0x0420,
  unicodeslot=0x048E,
 },
 [0x048F]={
  category="ll",
  contextname="cyrillicertick",
  description="CYRILLIC SMALL LETTER ER WITH TICK",
  direction="l",
  linebreak="al",
  shcode=0x0440,
  uccode=0x048E,
  unicodeslot=0x048F,
 },
 [0x0490]={
  adobename="afii10050",
  category="lu",
  contextname="cyrillicGHEupturn",
  description="CYRILLIC CAPITAL LETTER GHE WITH UPTURN",
  direction="l",
  lccode=0x0491,
  linebreak="al",
  shcode=0x0413,
  unicodeslot=0x0490,
 },
 [0x0491]={
  adobename="gheupturncyrillic",
  category="ll",
  contextname="cyrillicgheupturn",
  description="CYRILLIC SMALL LETTER GHE WITH UPTURN",
  direction="l",
  linebreak="al",
  shcode=0x0433,
  uccode=0x0490,
  unicodeslot=0x0491,
 },
 [0x0492]={
  adobename="Ghestrokecyrillic",
  category="lu",
  contextname="cyrillicGHEstroke",
  description="CYRILLIC CAPITAL LETTER GHE WITH STROKE",
  direction="l",
  lccode=0x0493,
  linebreak="al",
  shcode=0x0413,
  unicodeslot=0x0492,
 },
 [0x0493]={
  adobename="ghestrokecyrillic",
  category="ll",
  contextname="cyrillicghestroke",
  description="CYRILLIC SMALL LETTER GHE WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0433,
  uccode=0x0492,
  unicodeslot=0x0493,
 },
 [0x0494]={
  adobename="Ghemiddlehookcyrillic",
  category="lu",
  contextname="cyrillicGHEmidhook",
  description="CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK",
  direction="l",
  lccode=0x0495,
  linebreak="al",
  shcode=0x0413,
  unicodeslot=0x0494,
 },
 [0x0495]={
  adobename="ghemiddlehookcyrillic",
  category="ll",
  contextname="cyrillicghemidhook",
  description="CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0433,
  uccode=0x0494,
  unicodeslot=0x0495,
 },
 [0x0496]={
  adobename="Zhedescendercyrillic",
  category="lu",
  contextname="cyrillicZHEdescender",
  description="CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER",
  direction="l",
  lccode=0x0497,
  linebreak="al",
  shcode=0x0416,
  unicodeslot=0x0496,
 },
 [0x0497]={
  adobename="zhedescendercyrillic",
  category="ll",
  contextname="cyrilliczhedescender",
  description="CYRILLIC SMALL LETTER ZHE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x0436,
  uccode=0x0496,
  unicodeslot=0x0497,
 },
 [0x0498]={
  adobename="Zedescendercyrillic",
  category="lu",
  contextname="cyrillicZDSC",
  description="CYRILLIC CAPITAL LETTER ZE WITH DESCENDER",
  direction="l",
  lccode=0x0499,
  linebreak="al",
  shcode=0x0417,
  unicodeslot=0x0498,
 },
 [0x0499]={
  adobename="zedescendercyrillic",
  category="ll",
  contextname="cyrilliczdsc",
  description="CYRILLIC SMALL LETTER ZE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x0437,
  uccode=0x0498,
  unicodeslot=0x0499,
 },
 [0x049A]={
  adobename="Kadescendercyrillic",
  category="lu",
  contextname="cyrillicKADC",
  description="CYRILLIC CAPITAL LETTER KA WITH DESCENDER",
  direction="l",
  lccode=0x049B,
  linebreak="al",
  shcode=0x041A,
  unicodeslot=0x049A,
 },
 [0x049B]={
  adobename="kadescendercyrillic",
  category="ll",
  contextname="cyrillickadc",
  description="CYRILLIC SMALL LETTER KA WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x043A,
  uccode=0x049A,
  unicodeslot=0x049B,
 },
 [0x049C]={
  adobename="Kaverticalstrokecyrillic",
  category="lu",
  contextname="cyrillicKAvertstroke",
  description="CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE",
  direction="l",
  lccode=0x049D,
  linebreak="al",
  shcode=0x041A,
  unicodeslot=0x049C,
 },
 [0x049D]={
  adobename="kaverticalstrokecyrillic",
  category="ll",
  contextname="cyrillickavertstroke",
  description="CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE",
  direction="l",
  linebreak="al",
  shcode=0x043A,
  uccode=0x049C,
  unicodeslot=0x049D,
 },
 [0x049E]={
  adobename="Kastrokecyrillic",
  category="lu",
  contextname="cyrillicKAstroke",
  description="CYRILLIC CAPITAL LETTER KA WITH STROKE",
  direction="l",
  lccode=0x049F,
  linebreak="al",
  shcode=0x041A,
  unicodeslot=0x049E,
 },
 [0x049F]={
  adobename="kastrokecyrillic",
  category="ll",
  contextname="cyrillickastroke",
  description="CYRILLIC SMALL LETTER KA WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x043A,
  uccode=0x049E,
  unicodeslot=0x049F,
 },
 [0x04A0]={
  adobename="Kabashkircyrillic",
  category="lu",
  contextname="cyrillicKAbashkir",
  description="CYRILLIC CAPITAL LETTER BASHKIR KA",
  direction="l",
  lccode=0x04A1,
  linebreak="al",
  unicodeslot=0x04A0,
 },
 [0x04A1]={
  adobename="kabashkircyrillic",
  category="ll",
  contextname="cyrillickabashkir",
  description="CYRILLIC SMALL LETTER BASHKIR KA",
  direction="l",
  linebreak="al",
  uccode=0x04A0,
  unicodeslot=0x04A1,
 },
 [0x04A2]={
  adobename="Endescendercyrillic",
  category="lu",
  contextname="cyrillicENDC",
  description="CYRILLIC CAPITAL LETTER EN WITH DESCENDER",
  direction="l",
  lccode=0x04A3,
  linebreak="al",
  shcode=0x041D,
  unicodeslot=0x04A2,
 },
 [0x04A3]={
  adobename="endescendercyrillic",
  category="ll",
  contextname="cyrillicendc",
  description="CYRILLIC SMALL LETTER EN WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x043D,
  uccode=0x04A2,
  unicodeslot=0x04A3,
 },
 [0x04A4]={
  adobename="Enghecyrillic",
  category="lu",
  contextname="cyrillicENGHE",
  description="CYRILLIC CAPITAL LIGATURE EN GHE",
  direction="l",
  lccode=0x04A5,
  linebreak="al",
  unicodeslot=0x04A4,
 },
 [0x04A5]={
  adobename="enghecyrillic",
  category="ll",
  contextname="cyrillicenghe",
  description="CYRILLIC SMALL LIGATURE EN GHE",
  direction="l",
  linebreak="al",
  uccode=0x04A4,
  unicodeslot=0x04A5,
 },
 [0x04A6]={
  adobename="Pemiddlehookcyrillic",
  category="lu",
  contextname="cyrillicPEmidhook",
  description="CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK",
  direction="l",
  lccode=0x04A7,
  linebreak="al",
  shcode=0x041F,
  unicodeslot=0x04A6,
 },
 [0x04A7]={
  adobename="pemiddlehookcyrillic",
  category="ll",
  contextname="cyrillicpemidhook",
  description="CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  shcode=0x043F,
  uccode=0x04A6,
  unicodeslot=0x04A7,
 },
 [0x04A8]={
  adobename="Haabkhasiancyrillic",
  category="lu",
  contextname="cyrillicHA",
  description="CYRILLIC CAPITAL LETTER ABKHASIAN HA",
  direction="l",
  lccode=0x04A9,
  linebreak="al",
  unicodeslot=0x04A8,
 },
 [0x04A9]={
  adobename="haabkhasiancyrillic",
  category="ll",
  contextname="cyrillicha",
  description="CYRILLIC SMALL LETTER ABKHASIAN HA",
  direction="l",
  linebreak="al",
  uccode=0x04A8,
  unicodeslot=0x04A9,
 },
 [0x04AA]={
  adobename="Esdescendercyrillic",
  category="lu",
  contextname="cyrillicSDSC",
  description="CYRILLIC CAPITAL LETTER ES WITH DESCENDER",
  direction="l",
  lccode=0x04AB,
  linebreak="al",
  shcode=0x0421,
  unicodeslot=0x04AA,
 },
 [0x04AB]={
  adobename="esdescendercyrillic",
  category="ll",
  contextname="cyrillicsdsc",
  description="CYRILLIC SMALL LETTER ES WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x0441,
  uccode=0x04AA,
  unicodeslot=0x04AB,
 },
 [0x04AC]={
  adobename="Tedescendercyrillic",
  category="lu",
  contextname="cyrillicTEDC",
  description="CYRILLIC CAPITAL LETTER TE WITH DESCENDER",
  direction="l",
  lccode=0x04AD,
  linebreak="al",
  shcode=0x0422,
  unicodeslot=0x04AC,
 },
 [0x04AD]={
  adobename="tedescendercyrillic",
  category="ll",
  contextname="cyrillictedc",
  description="CYRILLIC SMALL LETTER TE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x0442,
  uccode=0x04AC,
  unicodeslot=0x04AD,
 },
 [0x04AE]={
  adobename="Ustraightcyrillic",
  category="lu",
  contextname="cyrillicYstr",
  description="CYRILLIC CAPITAL LETTER STRAIGHT U",
  direction="l",
  lccode=0x04AF,
  linebreak="al",
  unicodeslot=0x04AE,
 },
 [0x04AF]={
  adobename="ustraightcyrillic",
  category="ll",
  contextname="cyrillicystr",
  description="CYRILLIC SMALL LETTER STRAIGHT U",
  direction="l",
  linebreak="al",
  uccode=0x04AE,
  unicodeslot=0x04AF,
 },
 [0x04B0]={
  adobename="Ustraightstrokecyrillic",
  category="lu",
  contextname="cyrillicYstrstroke",
  description="CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE",
  direction="l",
  lccode=0x04B1,
  linebreak="al",
  unicodeslot=0x04B0,
 },
 [0x04B1]={
  adobename="ustraightstrokecyrillic",
  category="ll",
  contextname="cyrillicystrstroke",
  description="CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE",
  direction="l",
  linebreak="al",
  uccode=0x04B0,
  unicodeslot=0x04B1,
 },
 [0x04B2]={
  adobename="Hadescendercyrillic",
  category="lu",
  contextname="cyrillicHADC",
  description="CYRILLIC CAPITAL LETTER HA WITH DESCENDER",
  direction="l",
  lccode=0x04B3,
  linebreak="al",
  shcode=0x0425,
  unicodeslot=0x04B2,
 },
 [0x04B3]={
  adobename="hadescendercyrillic",
  category="ll",
  contextname="cyrillichadc",
  description="CYRILLIC SMALL LETTER HA WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x0445,
  uccode=0x04B2,
  unicodeslot=0x04B3,
 },
 [0x04B4]={
  adobename="Tetsecyrillic",
  category="lu",
  contextname="cyrillicTETSE",
  description="CYRILLIC CAPITAL LIGATURE TE TSE",
  direction="l",
  lccode=0x04B5,
  linebreak="al",
  unicodeslot=0x04B4,
 },
 [0x04B5]={
  adobename="tetsecyrillic",
  category="ll",
  contextname="cyrillictetse",
  description="CYRILLIC SMALL LIGATURE TE TSE",
  direction="l",
  linebreak="al",
  uccode=0x04B4,
  unicodeslot=0x04B5,
 },
 [0x04B6]={
  adobename="Chedescendercyrillic",
  category="lu",
  contextname="cyrillicCHEDC",
  description="CYRILLIC CAPITAL LETTER CHE WITH DESCENDER",
  direction="l",
  lccode=0x04B7,
  linebreak="al",
  shcode=0x0427,
  unicodeslot=0x04B6,
 },
 [0x04B7]={
  adobename="chedescendercyrillic",
  category="ll",
  contextname="cyrillicchedc",
  description="CYRILLIC SMALL LETTER CHE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x0447,
  uccode=0x04B6,
  unicodeslot=0x04B7,
 },
 [0x04B8]={
  adobename="Cheverticalstrokecyrillic",
  category="lu",
  contextname="cyrillicCHEvertstroke",
  description="CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE",
  direction="l",
  lccode=0x04B9,
  linebreak="al",
  shcode=0x0427,
  unicodeslot=0x04B8,
 },
 [0x04B9]={
  adobename="cheverticalstrokecyrillic",
  category="ll",
  contextname="cyrillicchevertstroke",
  description="CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0447,
  uccode=0x04B8,
  unicodeslot=0x04B9,
 },
 [0x04BA]={
  adobename="Shhacyrillic",
  category="lu",
  contextname="cyrillicSHHA",
  description="CYRILLIC CAPITAL LETTER SHHA",
  direction="l",
  lccode=0x04BB,
  linebreak="al",
  unicodeslot=0x04BA,
 },
 [0x04BB]={
  adobename="shhacyrillic",
  category="ll",
  contextname="cyrillicshha",
  description="CYRILLIC SMALL LETTER SHHA",
  direction="l",
  linebreak="al",
  uccode=0x04BA,
  unicodeslot=0x04BB,
 },
 [0x04BC]={
  adobename="Cheabkhasiancyrillic",
  category="lu",
  contextname="cyrillicCHEabkhasian",
  description="CYRILLIC CAPITAL LETTER ABKHASIAN CHE",
  direction="l",
  lccode=0x04BD,
  linebreak="al",
  unicodeslot=0x04BC,
 },
 [0x04BD]={
  adobename="cheabkhasiancyrillic",
  category="ll",
  contextname="cyrilliccheabkhasian",
  description="CYRILLIC SMALL LETTER ABKHASIAN CHE",
  direction="l",
  linebreak="al",
  uccode=0x04BC,
  unicodeslot=0x04BD,
 },
 [0x04BE]={
  adobename="Chedescenderabkhasiancyrillic",
  category="lu",
  contextname="cyrillicCHEDCabkhasian",
  description="CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER",
  direction="l",
  lccode=0x04BF,
  linebreak="al",
  unicodeslot=0x04BE,
 },
 [0x04BF]={
  adobename="chedescenderabkhasiancyrillic",
  category="ll",
  contextname="cyrillicchedcabkhasian",
  description="CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER",
  direction="l",
  linebreak="al",
  uccode=0x04BE,
  unicodeslot=0x04BF,
 },
 [0x04C0]={
  adobename="palochkacyrillic",
  category="lu",
  contextname="cyrillicPALOCHKA",
  description="CYRILLIC LETTER PALOCHKA",
  direction="l",
  lccode=0x04CF,
  linebreak="al",
  unicodeslot=0x04C0,
 },
 [0x04C1]={
  adobename="Zhebrevecyrillic",
  category="lu",
  contextname="cyrillicZHEbreve",
  description="CYRILLIC CAPITAL LETTER ZHE WITH BREVE",
  direction="l",
  lccode=0x04C2,
  linebreak="al",
  shcode=0x0416,
  specials={ "char", 0x0416, 0x0306 },
  unicodeslot=0x04C1,
 },
 [0x04C2]={
  adobename="zhebrevecyrillic",
  category="ll",
  contextname="cyrilliczhebreve",
  description="CYRILLIC SMALL LETTER ZHE WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0436,
  specials={ "char", 0x0436, 0x0306 },
  uccode=0x04C1,
  unicodeslot=0x04C2,
 },
 [0x04C3]={
  adobename="Kahookcyrillic",
  category="lu",
  contextname="cyrillicKAhook",
  description="CYRILLIC CAPITAL LETTER KA WITH HOOK",
  direction="l",
  lccode=0x04C4,
  linebreak="al",
  shcode=0x041A,
  unicodeslot=0x04C3,
 },
 [0x04C4]={
  adobename="kahookcyrillic",
  category="ll",
  contextname="cyrillickahook",
  description="CYRILLIC SMALL LETTER KA WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x043A,
  uccode=0x04C3,
  unicodeslot=0x04C4,
 },
 [0x04C5]={
  category="lu",
  contextname="cyrillicELtail",
  description="CYRILLIC CAPITAL LETTER EL WITH TAIL",
  direction="l",
  lccode=0x04C6,
  linebreak="al",
  shcode=0x041B,
  unicodeslot=0x04C5,
 },
 [0x04C6]={
  category="ll",
  contextname="cyrilliceltail",
  description="CYRILLIC SMALL LETTER EL WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x043B,
  uccode=0x04C5,
  unicodeslot=0x04C6,
 },
 [0x04C7]={
  adobename="Enhookcyrillic",
  category="lu",
  contextname="cyrillicENhook",
  description="CYRILLIC CAPITAL LETTER EN WITH HOOK",
  direction="l",
  lccode=0x04C8,
  linebreak="al",
  shcode=0x041D,
  unicodeslot=0x04C7,
 },
 [0x04C8]={
  adobename="enhookcyrillic",
  category="ll",
  contextname="cyrillicenhook",
  description="CYRILLIC SMALL LETTER EN WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x043D,
  uccode=0x04C7,
  unicodeslot=0x04C8,
 },
 [0x04C9]={
  category="lu",
  contextname="cyrillicENtail",
  description="CYRILLIC CAPITAL LETTER EN WITH TAIL",
  direction="l",
  lccode=0x04CA,
  linebreak="al",
  shcode=0x041D,
  unicodeslot=0x04C9,
 },
 [0x04CA]={
  category="ll",
  contextname="cyrillicentail",
  description="CYRILLIC SMALL LETTER EN WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x043D,
  uccode=0x04C9,
  unicodeslot=0x04CA,
 },
 [0x04CB]={
  adobename="Chekhakassiancyrillic",
  category="lu",
  contextname="cyrillicCHEkhakassian",
  description="CYRILLIC CAPITAL LETTER KHAKASSIAN CHE",
  direction="l",
  lccode=0x04CC,
  linebreak="al",
  unicodeslot=0x04CB,
 },
 [0x04CC]={
  adobename="chekhakassiancyrillic",
  category="ll",
  contextname="cyrillicchekhakassian",
  description="CYRILLIC SMALL LETTER KHAKASSIAN CHE",
  direction="l",
  linebreak="al",
  uccode=0x04CB,
  unicodeslot=0x04CC,
 },
 [0x04CD]={
  category="lu",
  contextname="cyrillicEMtail",
  description="CYRILLIC CAPITAL LETTER EM WITH TAIL",
  direction="l",
  lccode=0x04CE,
  linebreak="al",
  shcode=0x041C,
  unicodeslot=0x04CD,
 },
 [0x04CE]={
  category="ll",
  contextname="cyrillicemtail",
  description="CYRILLIC SMALL LETTER EM WITH TAIL",
  direction="l",
  linebreak="al",
  shcode=0x043C,
  uccode=0x04CD,
  unicodeslot=0x04CE,
 },
 [0x04CF]={
  category="ll",
  description="CYRILLIC SMALL LETTER PALOCHKA",
  direction="l",
  linebreak="al",
  uccode=0x04C0,
  unicodeslot=0x04CF,
 },
 [0x04D0]={
  adobename="Abrevecyrillic",
  category="lu",
  contextname="cyrillicAbreve",
  description="CYRILLIC CAPITAL LETTER A WITH BREVE",
  direction="l",
  lccode=0x04D1,
  linebreak="al",
  shcode=0x0410,
  specials={ "char", 0x0410, 0x0306 },
  unicodeslot=0x04D0,
 },
 [0x04D1]={
  adobename="abrevecyrillic",
  category="ll",
  contextname="cyrillicabreve",
  description="CYRILLIC SMALL LETTER A WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0430,
  specials={ "char", 0x0430, 0x0306 },
  uccode=0x04D0,
  unicodeslot=0x04D1,
 },
 [0x04D2]={
  adobename="Adieresiscyrillic",
  category="lu",
  contextname="cyrillicAdiaeresis",
  description="CYRILLIC CAPITAL LETTER A WITH DIAERESIS",
  direction="l",
  lccode=0x04D3,
  linebreak="al",
  shcode=0x0410,
  specials={ "char", 0x0410, 0x0308 },
  unicodeslot=0x04D2,
 },
 [0x04D3]={
  adobename="adieresiscyrillic",
  category="ll",
  contextname="cyrillicadiaeresis",
  description="CYRILLIC SMALL LETTER A WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0430,
  specials={ "char", 0x0430, 0x0308 },
  uccode=0x04D2,
  unicodeslot=0x04D3,
 },
 [0x04D4]={
  adobename="Aiecyrillic",
  category="lu",
  contextname="cyrillicAE",
  description="CYRILLIC CAPITAL LIGATURE A IE",
  direction="l",
  lccode=0x04D5,
  linebreak="al",
  unicodeslot=0x04D4,
 },
 [0x04D5]={
  adobename="aiecyrillic",
  category="ll",
  contextname="cyrillicae",
  description="CYRILLIC SMALL LIGATURE A IE",
  direction="l",
  linebreak="al",
  uccode=0x04D4,
  unicodeslot=0x04D5,
 },
 [0x04D6]={
  adobename="Iebrevecyrillic",
  category="lu",
  contextname="cyrillicEbreve",
  description="CYRILLIC CAPITAL LETTER IE WITH BREVE",
  direction="l",
  lccode=0x04D7,
  linebreak="al",
  shcode=0x0415,
  specials={ "char", 0x0415, 0x0306 },
  unicodeslot=0x04D6,
 },
 [0x04D7]={
  adobename="iebrevecyrillic",
  category="ll",
  contextname="cyrillicebreve",
  description="CYRILLIC SMALL LETTER IE WITH BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0435,
  specials={ "char", 0x0435, 0x0306 },
  uccode=0x04D6,
  unicodeslot=0x04D7,
 },
 [0x04D8]={
  adobename="Schwacyrillic",
  category="lu",
  contextname="cyrillicSCHWA",
  description="CYRILLIC CAPITAL LETTER SCHWA",
  direction="l",
  lccode=0x04D9,
  linebreak="al",
  unicodeslot=0x04D8,
 },
 [0x04D9]={
  adobename="schwacyrillic",
  category="ll",
  contextname="cyrillicschwa",
  description="CYRILLIC SMALL LETTER SCHWA",
  direction="l",
  linebreak="al",
  uccode=0x04D8,
  unicodeslot=0x04D9,
 },
 [0x04DA]={
  adobename="Schwadieresiscyrillic",
  category="lu",
  contextname="cyrillicSCHWAdiaeresis",
  description="CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS",
  direction="l",
  lccode=0x04DB,
  linebreak="al",
  shcode=0x04D8,
  specials={ "char", 0x04D8, 0x0308 },
  unicodeslot=0x04DA,
 },
 [0x04DB]={
  adobename="schwadieresiscyrillic",
  category="ll",
  contextname="cyrillicschwadiaeresis",
  description="CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x04D9,
  specials={ "char", 0x04D9, 0x0308 },
  uccode=0x04DA,
  unicodeslot=0x04DB,
 },
 [0x04DC]={
  adobename="Zhedieresiscyrillic",
  category="lu",
  contextname="cyrillicZHEdiaeresis",
  description="CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS",
  direction="l",
  lccode=0x04DD,
  linebreak="al",
  shcode=0x0416,
  specials={ "char", 0x0416, 0x0308 },
  unicodeslot=0x04DC,
 },
 [0x04DD]={
  adobename="zhedieresiscyrillic",
  category="ll",
  contextname="cyrilliczhediaeresis",
  description="CYRILLIC SMALL LETTER ZHE WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0436,
  specials={ "char", 0x0436, 0x0308 },
  uccode=0x04DC,
  unicodeslot=0x04DD,
 },
 [0x04DE]={
  adobename="Zedieresiscyrillic",
  category="lu",
  contextname="cyrillicZEdiaeresis",
  description="CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS",
  direction="l",
  lccode=0x04DF,
  linebreak="al",
  shcode=0x0417,
  specials={ "char", 0x0417, 0x0308 },
  unicodeslot=0x04DE,
 },
 [0x04DF]={
  adobename="zedieresiscyrillic",
  category="ll",
  contextname="cyrilliczediaeresis",
  description="CYRILLIC SMALL LETTER ZE WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0437,
  specials={ "char", 0x0437, 0x0308 },
  uccode=0x04DE,
  unicodeslot=0x04DF,
 },
 [0x04E0]={
  adobename="Dzeabkhasiancyrillic",
  category="lu",
  contextname="cyrillicDZEabkhasian",
  description="CYRILLIC CAPITAL LETTER ABKHASIAN DZE",
  direction="l",
  lccode=0x04E1,
  linebreak="al",
  unicodeslot=0x04E0,
 },
 [0x04E1]={
  adobename="dzeabkhasiancyrillic",
  category="ll",
  contextname="cyrillicdzeabkhasian",
  description="CYRILLIC SMALL LETTER ABKHASIAN DZE",
  direction="l",
  linebreak="al",
  uccode=0x04E0,
  unicodeslot=0x04E1,
 },
 [0x04E2]={
  adobename="Imacroncyrillic",
  category="lu",
  contextname="cyrillicImacron",
  description="CYRILLIC CAPITAL LETTER I WITH MACRON",
  direction="l",
  lccode=0x04E3,
  linebreak="al",
  shcode=0x0418,
  specials={ "char", 0x0418, 0x0304 },
  unicodeslot=0x04E2,
 },
 [0x04E3]={
  adobename="imacroncyrillic",
  category="ll",
  contextname="cyrillicimacron",
  description="CYRILLIC SMALL LETTER I WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0438,
  specials={ "char", 0x0438, 0x0304 },
  uccode=0x04E2,
  unicodeslot=0x04E3,
 },
 [0x04E4]={
  adobename="Idieresiscyrillic",
  category="lu",
  contextname="cyrillicIdiaeresis",
  description="CYRILLIC CAPITAL LETTER I WITH DIAERESIS",
  direction="l",
  lccode=0x04E5,
  linebreak="al",
  shcode=0x0418,
  specials={ "char", 0x0418, 0x0308 },
  unicodeslot=0x04E4,
 },
 [0x04E5]={
  adobename="idieresiscyrillic",
  category="ll",
  contextname="cyrillicidiaeresis",
  description="CYRILLIC SMALL LETTER I WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0438,
  specials={ "char", 0x0438, 0x0308 },
  uccode=0x04E4,
  unicodeslot=0x04E5,
 },
 [0x04E6]={
  adobename="Odieresiscyrillic",
  category="lu",
  contextname="cyrillicOdiaeresis",
  description="CYRILLIC CAPITAL LETTER O WITH DIAERESIS",
  direction="l",
  lccode=0x04E7,
  linebreak="al",
  shcode=0x041E,
  specials={ "char", 0x041E, 0x0308 },
  unicodeslot=0x04E6,
 },
 [0x04E7]={
  adobename="odieresiscyrillic",
  category="ll",
  contextname="cyrillicodiaeresis",
  description="CYRILLIC SMALL LETTER O WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x043E,
  specials={ "char", 0x043E, 0x0308 },
  uccode=0x04E6,
  unicodeslot=0x04E7,
 },
 [0x04E8]={
  adobename="Obarredcyrillic",
  category="lu",
  contextname="cyrillicObarred",
  description="CYRILLIC CAPITAL LETTER BARRED O",
  direction="l",
  lccode=0x04E9,
  linebreak="al",
  unicodeslot=0x04E8,
 },
 [0x04E9]={
  adobename="obarredcyrillic",
  category="ll",
  contextname="cyrillicobarred",
  description="CYRILLIC SMALL LETTER BARRED O",
  direction="l",
  linebreak="al",
  uccode=0x04E8,
  unicodeslot=0x04E9,
 },
 [0x04EA]={
  adobename="Obarreddieresiscyrillic",
  category="lu",
  contextname="cyrillicObarreddiaeresis",
  description="CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS",
  direction="l",
  lccode=0x04EB,
  linebreak="al",
  specials={ "char", 0x04E8, 0x0308 },
  unicodeslot=0x04EA,
 },
 [0x04EB]={
  adobename="obarreddieresiscyrillic",
  category="ll",
  contextname="cyrillicobarreddiaeresis",
  description="CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS",
  direction="l",
  linebreak="al",
  specials={ "char", 0x04E9, 0x0308 },
  uccode=0x04EA,
  unicodeslot=0x04EB,
 },
 [0x04EC]={
  category="lu",
  contextname="cyrillicEdiaeresis",
  description="CYRILLIC CAPITAL LETTER E WITH DIAERESIS",
  direction="l",
  lccode=0x04ED,
  linebreak="al",
  shcode=0x042D,
  specials={ "char", 0x042D, 0x0308 },
  unicodeslot=0x04EC,
 },
 [0x04ED]={
  category="ll",
  contextname="cyrillicediaeresis",
  description="CYRILLIC SMALL LETTER E WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x044D,
  specials={ "char", 0x044D, 0x0308 },
  uccode=0x04EC,
  unicodeslot=0x04ED,
 },
 [0x04EE]={
  adobename="Umacroncyrillic",
  category="lu",
  contextname="cyrillicUmacron",
  description="CYRILLIC CAPITAL LETTER U WITH MACRON",
  direction="l",
  lccode=0x04EF,
  linebreak="al",
  shcode=0x0423,
  specials={ "char", 0x0423, 0x0304 },
  unicodeslot=0x04EE,
 },
 [0x04EF]={
  adobename="umacroncyrillic",
  category="ll",
  contextname="cyrillicumacron",
  description="CYRILLIC SMALL LETTER U WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0443,
  specials={ "char", 0x0443, 0x0304 },
  uccode=0x04EE,
  unicodeslot=0x04EF,
 },
 [0x04F0]={
  adobename="Udieresiscyrillic",
  category="lu",
  contextname="cyrillicUdiaeresis",
  description="CYRILLIC CAPITAL LETTER U WITH DIAERESIS",
  direction="l",
  lccode=0x04F1,
  linebreak="al",
  shcode=0x0423,
  specials={ "char", 0x0423, 0x0308 },
  unicodeslot=0x04F0,
 },
 [0x04F1]={
  adobename="udieresiscyrillic",
  category="ll",
  contextname="cyrillicudiaeresis",
  description="CYRILLIC SMALL LETTER U WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0443,
  specials={ "char", 0x0443, 0x0308 },
  uccode=0x04F0,
  unicodeslot=0x04F1,
 },
 [0x04F2]={
  adobename="Uhungarumlautcyrillic",
  category="lu",
  contextname="cyrillicUdoubleacute",
  description="CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE",
  direction="l",
  lccode=0x04F3,
  linebreak="al",
  shcode=0x0423,
  specials={ "char", 0x0423, 0x030B },
  unicodeslot=0x04F2,
 },
 [0x04F3]={
  adobename="uhungarumlautcyrillic",
  category="ll",
  contextname="cyrillicudoubleacute",
  description="CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0443,
  specials={ "char", 0x0443, 0x030B },
  uccode=0x04F2,
  unicodeslot=0x04F3,
 },
 [0x04F4]={
  adobename="Chedieresiscyrillic",
  category="lu",
  contextname="cyrillicCHEdiaeresis",
  description="CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS",
  direction="l",
  lccode=0x04F5,
  linebreak="al",
  shcode=0x0427,
  specials={ "char", 0x0427, 0x0308 },
  unicodeslot=0x04F4,
 },
 [0x04F5]={
  adobename="chedieresiscyrillic",
  category="ll",
  contextname="cyrillicchediaeresis",
  description="CYRILLIC SMALL LETTER CHE WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0447,
  specials={ "char", 0x0447, 0x0308 },
  uccode=0x04F4,
  unicodeslot=0x04F5,
 },
 [0x04F6]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER GHE WITH DESCENDER",
  direction="l",
  lccode=0x04F7,
  linebreak="al",
  shcode=0x0413,
  unicodeslot=0x04F6,
 },
 [0x04F7]={
  category="ll",
  description="CYRILLIC SMALL LETTER GHE WITH DESCENDER",
  direction="l",
  linebreak="al",
  shcode=0x0433,
  uccode=0x04F6,
  unicodeslot=0x04F7,
 },
 [0x04F8]={
  adobename="Yerudieresiscyrillic",
  category="lu",
  contextname="cyrillicYERUdiaeresis",
  description="CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS",
  direction="l",
  lccode=0x04F9,
  linebreak="al",
  shcode=0x042B,
  specials={ "char", 0x042B, 0x0308 },
  unicodeslot=0x04F8,
 },
 [0x04F9]={
  adobename="yerudieresiscyrillic",
  category="ll",
  contextname="cyrillicyerudiaeresis",
  description="CYRILLIC SMALL LETTER YERU WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x044B,
  specials={ "char", 0x044B, 0x0308 },
  uccode=0x04F8,
  unicodeslot=0x04F9,
 },
 [0x04FA]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK",
  direction="l",
  lccode=0x04FB,
  linebreak="al",
  shcode=0x0413,
  unicodeslot=0x04FA,
 },
 [0x04FB]={
  category="ll",
  description="CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0433,
  uccode=0x04FA,
  unicodeslot=0x04FB,
 },
 [0x04FC]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER HA WITH HOOK",
  direction="l",
  lccode=0x04FD,
  linebreak="al",
  shcode=0x0425,
  unicodeslot=0x04FC,
 },
 [0x04FD]={
  category="ll",
  description="CYRILLIC SMALL LETTER HA WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0445,
  uccode=0x04FC,
  unicodeslot=0x04FD,
 },
 [0x04FE]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER HA WITH STROKE",
  direction="l",
  lccode=0x04FF,
  linebreak="al",
  shcode=0x0425,
  unicodeslot=0x04FE,
 },
 [0x04FF]={
  category="ll",
  description="CYRILLIC SMALL LETTER HA WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0445,
  uccode=0x04FE,
  unicodeslot=0x04FF,
 },
 [0x0500]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI DE",
  direction="l",
  lccode=0x0501,
  linebreak="al",
  unicodeslot=0x0500,
 },
 [0x0501]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI DE",
  direction="l",
  linebreak="al",
  uccode=0x0500,
  unicodeslot=0x0501,
 },
 [0x0502]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI DJE",
  direction="l",
  lccode=0x0503,
  linebreak="al",
  unicodeslot=0x0502,
 },
 [0x0503]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI DJE",
  direction="l",
  linebreak="al",
  uccode=0x0502,
  unicodeslot=0x0503,
 },
 [0x0504]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI ZJE",
  direction="l",
  lccode=0x0505,
  linebreak="al",
  unicodeslot=0x0504,
 },
 [0x0505]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI ZJE",
  direction="l",
  linebreak="al",
  uccode=0x0504,
  unicodeslot=0x0505,
 },
 [0x0506]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI DZJE",
  direction="l",
  lccode=0x0507,
  linebreak="al",
  unicodeslot=0x0506,
 },
 [0x0507]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI DZJE",
  direction="l",
  linebreak="al",
  uccode=0x0506,
  unicodeslot=0x0507,
 },
 [0x0508]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI LJE",
  direction="l",
  lccode=0x0509,
  linebreak="al",
  unicodeslot=0x0508,
 },
 [0x0509]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI LJE",
  direction="l",
  linebreak="al",
  uccode=0x0508,
  unicodeslot=0x0509,
 },
 [0x050A]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI NJE",
  direction="l",
  lccode=0x050B,
  linebreak="al",
  unicodeslot=0x050A,
 },
 [0x050B]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI NJE",
  direction="l",
  linebreak="al",
  uccode=0x050A,
  unicodeslot=0x050B,
 },
 [0x050C]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI SJE",
  direction="l",
  lccode=0x050D,
  linebreak="al",
  unicodeslot=0x050C,
 },
 [0x050D]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI SJE",
  direction="l",
  linebreak="al",
  uccode=0x050C,
  unicodeslot=0x050D,
 },
 [0x050E]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER KOMI TJE",
  direction="l",
  lccode=0x050F,
  linebreak="al",
  unicodeslot=0x050E,
 },
 [0x050F]={
  category="ll",
  description="CYRILLIC SMALL LETTER KOMI TJE",
  direction="l",
  linebreak="al",
  uccode=0x050E,
  unicodeslot=0x050F,
 },
 [0x0510]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER REVERSED ZE",
  direction="l",
  lccode=0x0511,
  linebreak="al",
  unicodeslot=0x0510,
 },
 [0x0511]={
  category="ll",
  description="CYRILLIC SMALL LETTER REVERSED ZE",
  direction="l",
  linebreak="al",
  uccode=0x0510,
  unicodeslot=0x0511,
 },
 [0x0512]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER EL WITH HOOK",
  direction="l",
  lccode=0x0513,
  linebreak="al",
  shcode=0x041B,
  unicodeslot=0x0512,
 },
 [0x0513]={
  category="ll",
  description="CYRILLIC SMALL LETTER EL WITH HOOK",
  direction="l",
  linebreak="al",
  shcode=0x043B,
  uccode=0x0512,
  unicodeslot=0x0513,
 },
 [0x0514]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0514,
 },
 [0x0515]={
  category="ll",
  description="CYRILLIC SMALL LETTER LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0515,
 },
 [0x0516]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER RHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0516,
 },
 [0x0517]={
  category="ll",
  description="CYRILLIC SMALL LETTER RHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0517,
 },
 [0x0518]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER YAE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0518,
 },
 [0x0519]={
  category="ll",
  description="CYRILLIC SMALL LETTER YAE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0519,
 },
 [0x051A]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x051A,
 },
 [0x051B]={
  category="ll",
  description="CYRILLIC SMALL LETTER QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x051B,
 },
 [0x051C]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x051C,
 },
 [0x051D]={
  category="ll",
  description="CYRILLIC SMALL LETTER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x051D,
 },
 [0x051E]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER ALEUT KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x051E,
 },
 [0x051F]={
  category="ll",
  description="CYRILLIC SMALL LETTER ALEUT KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x051F,
 },
 [0x0520]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x0520,
 },
 [0x0521]={
  category="ll",
  description="CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x0521,
 },
 [0x0522]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x0522,
 },
 [0x0523]={
  category="ll",
  description="CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x0523,
 },
 [0x0524]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER PE WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x0524,
 },
 [0x0525]={
  category="ll",
  description="CYRILLIC SMALL LETTER PE WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x0525,
 },
 [0x0526]={
  category="lu",
  description="CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x0526,
 },
 [0x0527]={
  category="ll",
  description="CYRILLIC SMALL LETTER SHHA WITH DESCENDER",
  direction="l",
  linebreak="al",
  unicodeslot=0x0527,
 },
 [0x0531]={
  adobename="Aybarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER AYB",
  direction="l",
  lccode=0x0561,
  linebreak="al",
  unicodeslot=0x0531,
 },
 [0x0532]={
  adobename="Benarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER BEN",
  direction="l",
  lccode=0x0562,
  linebreak="al",
  unicodeslot=0x0532,
 },
 [0x0533]={
  adobename="Gimarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER GIM",
  direction="l",
  lccode=0x0563,
  linebreak="al",
  unicodeslot=0x0533,
 },
 [0x0534]={
  adobename="Daarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER DA",
  direction="l",
  lccode=0x0564,
  linebreak="al",
  unicodeslot=0x0534,
 },
 [0x0535]={
  adobename="Echarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER ECH",
  direction="l",
  lccode=0x0565,
  linebreak="al",
  unicodeslot=0x0535,
 },
 [0x0536]={
  adobename="Zaarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER ZA",
  direction="l",
  lccode=0x0566,
  linebreak="al",
  unicodeslot=0x0536,
 },
 [0x0537]={
  adobename="Eharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER EH",
  direction="l",
  lccode=0x0567,
  linebreak="al",
  unicodeslot=0x0537,
 },
 [0x0538]={
  adobename="Etarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER ET",
  direction="l",
  lccode=0x0568,
  linebreak="al",
  unicodeslot=0x0538,
 },
 [0x0539]={
  adobename="Toarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER TO",
  direction="l",
  lccode=0x0569,
  linebreak="al",
  unicodeslot=0x0539,
 },
 [0x053A]={
  adobename="Zhearmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER ZHE",
  direction="l",
  lccode=0x056A,
  linebreak="al",
  unicodeslot=0x053A,
 },
 [0x053B]={
  adobename="Iniarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER INI",
  direction="l",
  lccode=0x056B,
  linebreak="al",
  unicodeslot=0x053B,
 },
 [0x053C]={
  adobename="Liwnarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER LIWN",
  direction="l",
  lccode=0x056C,
  linebreak="al",
  unicodeslot=0x053C,
 },
 [0x053D]={
  adobename="Xeharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER XEH",
  direction="l",
  lccode=0x056D,
  linebreak="al",
  unicodeslot=0x053D,
 },
 [0x053E]={
  adobename="Caarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER CA",
  direction="l",
  lccode=0x056E,
  linebreak="al",
  unicodeslot=0x053E,
 },
 [0x053F]={
  adobename="Kenarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER KEN",
  direction="l",
  lccode=0x056F,
  linebreak="al",
  unicodeslot=0x053F,
 },
 [0x0540]={
  adobename="Hoarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER HO",
  direction="l",
  lccode=0x0570,
  linebreak="al",
  unicodeslot=0x0540,
 },
 [0x0541]={
  adobename="Jaarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER JA",
  direction="l",
  lccode=0x0571,
  linebreak="al",
  unicodeslot=0x0541,
 },
 [0x0542]={
  adobename="Ghadarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER GHAD",
  direction="l",
  lccode=0x0572,
  linebreak="al",
  unicodeslot=0x0542,
 },
 [0x0543]={
  adobename="Cheharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER CHEH",
  direction="l",
  lccode=0x0573,
  linebreak="al",
  unicodeslot=0x0543,
 },
 [0x0544]={
  adobename="Menarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER MEN",
  direction="l",
  lccode=0x0574,
  linebreak="al",
  unicodeslot=0x0544,
 },
 [0x0545]={
  adobename="Yiarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER YI",
  direction="l",
  lccode=0x0575,
  linebreak="al",
  unicodeslot=0x0545,
 },
 [0x0546]={
  adobename="Nowarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER NOW",
  direction="l",
  lccode=0x0576,
  linebreak="al",
  unicodeslot=0x0546,
 },
 [0x0547]={
  adobename="Shaarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER SHA",
  direction="l",
  lccode=0x0577,
  linebreak="al",
  unicodeslot=0x0547,
 },
 [0x0548]={
  adobename="Voarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER VO",
  direction="l",
  lccode=0x0578,
  linebreak="al",
  unicodeslot=0x0548,
 },
 [0x0549]={
  adobename="Chaarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER CHA",
  direction="l",
  lccode=0x0579,
  linebreak="al",
  unicodeslot=0x0549,
 },
 [0x054A]={
  adobename="Peharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER PEH",
  direction="l",
  lccode=0x057A,
  linebreak="al",
  unicodeslot=0x054A,
 },
 [0x054B]={
  adobename="Jheharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER JHEH",
  direction="l",
  lccode=0x057B,
  linebreak="al",
  unicodeslot=0x054B,
 },
 [0x054C]={
  adobename="Raarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER RA",
  direction="l",
  lccode=0x057C,
  linebreak="al",
  unicodeslot=0x054C,
 },
 [0x054D]={
  adobename="Seharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER SEH",
  direction="l",
  lccode=0x057D,
  linebreak="al",
  unicodeslot=0x054D,
 },
 [0x054E]={
  adobename="Vewarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER VEW",
  direction="l",
  lccode=0x057E,
  linebreak="al",
  unicodeslot=0x054E,
 },
 [0x054F]={
  adobename="Tiwnarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER TIWN",
  direction="l",
  lccode=0x057F,
  linebreak="al",
  unicodeslot=0x054F,
 },
 [0x0550]={
  adobename="Reharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER REH",
  direction="l",
  lccode=0x0580,
  linebreak="al",
  unicodeslot=0x0550,
 },
 [0x0551]={
  adobename="Coarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER CO",
  direction="l",
  lccode=0x0581,
  linebreak="al",
  unicodeslot=0x0551,
 },
 [0x0552]={
  adobename="Yiwnarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER YIWN",
  direction="l",
  lccode=0x0582,
  linebreak="al",
  unicodeslot=0x0552,
 },
 [0x0553]={
  adobename="Piwrarmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER PIWR",
  direction="l",
  lccode=0x0583,
  linebreak="al",
  unicodeslot=0x0553,
 },
 [0x0554]={
  adobename="Keharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER KEH",
  direction="l",
  lccode=0x0584,
  linebreak="al",
  unicodeslot=0x0554,
 },
 [0x0555]={
  adobename="Oharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER OH",
  direction="l",
  lccode=0x0585,
  linebreak="al",
  unicodeslot=0x0555,
 },
 [0x0556]={
  adobename="Feharmenian",
  category="lu",
  description="ARMENIAN CAPITAL LETTER FEH",
  direction="l",
  lccode=0x0586,
  linebreak="al",
  unicodeslot=0x0556,
 },
 [0x0559]={
  adobename="ringhalfleftarmenian",
  category="lm",
  description="ARMENIAN MODIFIER LETTER LEFT HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x0559,
 },
 [0x055A]={
  adobename="apostrophearmenian",
  category="po",
  description="ARMENIAN APOSTROPHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x055A,
 },
 [0x055B]={
  adobename="emphasismarkarmenian",
  category="po",
  description="ARMENIAN EMPHASIS MARK",
  direction="l",
  linebreak="al",
  unicodeslot=0x055B,
 },
 [0x055C]={
  adobename="exclamarmenian",
  category="po",
  description="ARMENIAN EXCLAMATION MARK",
  direction="l",
  linebreak="al",
  unicodeslot=0x055C,
 },
 [0x055D]={
  adobename="commaarmenian",
  category="po",
  description="ARMENIAN COMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x055D,
 },
 [0x055E]={
  adobename="questionarmenian",
  category="po",
  description="ARMENIAN QUESTION MARK",
  direction="l",
  linebreak="al",
  unicodeslot=0x055E,
 },
 [0x055F]={
  adobename="abbreviationmarkarmenian",
  category="po",
  description="ARMENIAN ABBREVIATION MARK",
  direction="l",
  linebreak="al",
  unicodeslot=0x055F,
 },
 [0x0561]={
  adobename="aybarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER AYB",
  direction="l",
  linebreak="al",
  uccode=0x0531,
  unicodeslot=0x0561,
 },
 [0x0562]={
  adobename="benarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER BEN",
  direction="l",
  linebreak="al",
  uccode=0x0532,
  unicodeslot=0x0562,
 },
 [0x0563]={
  adobename="gimarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER GIM",
  direction="l",
  linebreak="al",
  uccode=0x0533,
  unicodeslot=0x0563,
 },
 [0x0564]={
  adobename="daarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER DA",
  direction="l",
  linebreak="al",
  uccode=0x0534,
  unicodeslot=0x0564,
 },
 [0x0565]={
  adobename="echarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER ECH",
  direction="l",
  linebreak="al",
  uccode=0x0535,
  unicodeslot=0x0565,
 },
 [0x0566]={
  adobename="zaarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER ZA",
  direction="l",
  linebreak="al",
  uccode=0x0536,
  unicodeslot=0x0566,
 },
 [0x0567]={
  adobename="eharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER EH",
  direction="l",
  linebreak="al",
  uccode=0x0537,
  unicodeslot=0x0567,
 },
 [0x0568]={
  adobename="etarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER ET",
  direction="l",
  linebreak="al",
  uccode=0x0538,
  unicodeslot=0x0568,
 },
 [0x0569]={
  adobename="toarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER TO",
  direction="l",
  linebreak="al",
  uccode=0x0539,
  unicodeslot=0x0569,
 },
 [0x056A]={
  adobename="zhearmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER ZHE",
  direction="l",
  linebreak="al",
  uccode=0x053A,
  unicodeslot=0x056A,
 },
 [0x056B]={
  adobename="iniarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER INI",
  direction="l",
  linebreak="al",
  uccode=0x053B,
  unicodeslot=0x056B,
 },
 [0x056C]={
  adobename="liwnarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER LIWN",
  direction="l",
  linebreak="al",
  uccode=0x053C,
  unicodeslot=0x056C,
 },
 [0x056D]={
  adobename="xeharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER XEH",
  direction="l",
  linebreak="al",
  uccode=0x053D,
  unicodeslot=0x056D,
 },
 [0x056E]={
  adobename="caarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER CA",
  direction="l",
  linebreak="al",
  uccode=0x053E,
  unicodeslot=0x056E,
 },
 [0x056F]={
  adobename="kenarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER KEN",
  direction="l",
  linebreak="al",
  uccode=0x053F,
  unicodeslot=0x056F,
 },
 [0x0570]={
  adobename="hoarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER HO",
  direction="l",
  linebreak="al",
  uccode=0x0540,
  unicodeslot=0x0570,
 },
 [0x0571]={
  adobename="jaarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER JA",
  direction="l",
  linebreak="al",
  uccode=0x0541,
  unicodeslot=0x0571,
 },
 [0x0572]={
  adobename="ghadarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER GHAD",
  direction="l",
  linebreak="al",
  uccode=0x0542,
  unicodeslot=0x0572,
 },
 [0x0573]={
  adobename="cheharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER CHEH",
  direction="l",
  linebreak="al",
  uccode=0x0543,
  unicodeslot=0x0573,
 },
 [0x0574]={
  adobename="menarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER MEN",
  direction="l",
  linebreak="al",
  uccode=0x0544,
  unicodeslot=0x0574,
 },
 [0x0575]={
  adobename="yiarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER YI",
  direction="l",
  linebreak="al",
  uccode=0x0545,
  unicodeslot=0x0575,
 },
 [0x0576]={
  adobename="nowarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER NOW",
  direction="l",
  linebreak="al",
  uccode=0x0546,
  unicodeslot=0x0576,
 },
 [0x0577]={
  adobename="shaarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER SHA",
  direction="l",
  linebreak="al",
  uccode=0x0547,
  unicodeslot=0x0577,
 },
 [0x0578]={
  adobename="voarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER VO",
  direction="l",
  linebreak="al",
  uccode=0x0548,
  unicodeslot=0x0578,
 },
 [0x0579]={
  adobename="chaarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER CHA",
  direction="l",
  linebreak="al",
  uccode=0x0549,
  unicodeslot=0x0579,
 },
 [0x057A]={
  adobename="peharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER PEH",
  direction="l",
  linebreak="al",
  uccode=0x054A,
  unicodeslot=0x057A,
 },
 [0x057B]={
  adobename="jheharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER JHEH",
  direction="l",
  linebreak="al",
  uccode=0x054B,
  unicodeslot=0x057B,
 },
 [0x057C]={
  adobename="raarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER RA",
  direction="l",
  linebreak="al",
  uccode=0x054C,
  unicodeslot=0x057C,
 },
 [0x057D]={
  adobename="seharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER SEH",
  direction="l",
  linebreak="al",
  uccode=0x054D,
  unicodeslot=0x057D,
 },
 [0x057E]={
  adobename="vewarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER VEW",
  direction="l",
  linebreak="al",
  uccode=0x054E,
  unicodeslot=0x057E,
 },
 [0x057F]={
  adobename="tiwnarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER TIWN",
  direction="l",
  linebreak="al",
  uccode=0x054F,
  unicodeslot=0x057F,
 },
 [0x0580]={
  adobename="reharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER REH",
  direction="l",
  linebreak="al",
  uccode=0x0550,
  unicodeslot=0x0580,
 },
 [0x0581]={
  adobename="coarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER CO",
  direction="l",
  linebreak="al",
  uccode=0x0551,
  unicodeslot=0x0581,
 },
 [0x0582]={
  adobename="yiwnarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER YIWN",
  direction="l",
  linebreak="al",
  uccode=0x0552,
  unicodeslot=0x0582,
 },
 [0x0583]={
  adobename="piwrarmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER PIWR",
  direction="l",
  linebreak="al",
  uccode=0x0553,
  unicodeslot=0x0583,
 },
 [0x0584]={
  adobename="keharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER KEH",
  direction="l",
  linebreak="al",
  uccode=0x0554,
  unicodeslot=0x0584,
 },
 [0x0585]={
  adobename="oharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER OH",
  direction="l",
  linebreak="al",
  uccode=0x0555,
  unicodeslot=0x0585,
 },
 [0x0586]={
  adobename="feharmenian",
  category="ll",
  description="ARMENIAN SMALL LETTER FEH",
  direction="l",
  linebreak="al",
  uccode=0x0556,
  unicodeslot=0x0586,
 },
 [0x0587]={
  adobename="echyiwnarmenian",
  category="ll",
  description="ARMENIAN SMALL LIGATURE ECH YIWN",
  direction="l",
  linebreak="al",
  specials={ "compat", 0x0565, 0x0582 },
  unicodeslot=0x0587,
 },
 [0x0589]={
  adobename="periodarmenian",
  category="po",
  description="ARMENIAN FULL STOP",
  direction="l",
  linebreak="is",
  unicodeslot=0x0589,
 },
 [0x058A]={
  category="pd",
  description="ARMENIAN HYPHEN",
  direction="on",
  linebreak="ba",
  unicodeslot=0x058A,
 },
 [0x0591]={
  adobename="etnahtalefthebrew",
  category="mn",
  description="HEBREW ACCENT ETNAHTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0591,
 },
 [0x0592]={
  adobename="segoltahebrew",
  category="mn",
  description="HEBREW ACCENT SEGOL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0592,
 },
 [0x0593]={
  adobename="shalshelethebrew",
  category="mn",
  description="HEBREW ACCENT SHALSHELET",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0593,
 },
 [0x0594]={
  adobename="zaqefqatanhebrew",
  category="mn",
  description="HEBREW ACCENT ZAQEF QATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0594,
 },
 [0x0595]={
  adobename="zaqefgadolhebrew",
  category="mn",
  description="HEBREW ACCENT ZAQEF GADOL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0595,
 },
 [0x0596]={
  adobename="tipehalefthebrew",
  category="mn",
  description="HEBREW ACCENT TIPEHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0596,
 },
 [0x0597]={
  adobename="reviamugrashhebrew",
  category="mn",
  description="HEBREW ACCENT REVIA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0597,
 },
 [0x0598]={
  adobename="zarqahebrew",
  category="mn",
  description="HEBREW ACCENT ZARQA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0598,
 },
 [0x0599]={
  adobename="pashtahebrew",
  category="mn",
  description="HEBREW ACCENT PASHTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0599,
 },
 [0x059A]={
  adobename="yetivhebrew",
  category="mn",
  description="HEBREW ACCENT YETIV",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x059A,
 },
 [0x059B]={
  adobename="tevirlefthebrew",
  category="mn",
  description="HEBREW ACCENT TEVIR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x059B,
 },
 [0x059C]={
  adobename="gereshaccenthebrew",
  category="mn",
  description="HEBREW ACCENT GERESH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x059C,
 },
 [0x059D]={
  adobename="gereshmuqdamhebrew",
  category="mn",
  description="HEBREW ACCENT GERESH MUQDAM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x059D,
 },
 [0x059E]={
  adobename="gershayimaccenthebrew",
  category="mn",
  description="HEBREW ACCENT GERSHAYIM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x059E,
 },
 [0x059F]={
  adobename="qarneyparahebrew",
  category="mn",
  description="HEBREW ACCENT QARNEY PARA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x059F,
 },
 [0x05A0]={
  adobename="telishagedolahebrew",
  category="mn",
  description="HEBREW ACCENT TELISHA GEDOLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A0,
 },
 [0x05A1]={
  adobename="pazerhebrew",
  category="mn",
  description="HEBREW ACCENT PAZER",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A1,
 },
 [0x05A2]={
  category="mn",
  description="HEBREW ACCENT ATNAH HAFUKH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A2,
 },
 [0x05A3]={
  adobename="munahlefthebrew",
  category="mn",
  description="HEBREW ACCENT MUNAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A3,
 },
 [0x05A4]={
  adobename="mahapakhlefthebrew",
  category="mn",
  description="HEBREW ACCENT MAHAPAKH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A4,
 },
 [0x05A5]={
  adobename="merkhalefthebrew",
  category="mn",
  description="HEBREW ACCENT MERKHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A5,
 },
 [0x05A6]={
  adobename="merkhakefulalefthebrew",
  category="mn",
  description="HEBREW ACCENT MERKHA KEFULA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A6,
 },
 [0x05A7]={
  adobename="dargalefthebrew",
  category="mn",
  description="HEBREW ACCENT DARGA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A7,
 },
 [0x05A8]={
  adobename="qadmahebrew",
  category="mn",
  description="HEBREW ACCENT QADMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A8,
 },
 [0x05A9]={
  adobename="telishaqetanahebrew",
  category="mn",
  description="HEBREW ACCENT TELISHA QETANA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05A9,
 },
 [0x05AA]={
  adobename="yerahbenyomolefthebrew",
  category="mn",
  description="HEBREW ACCENT YERAH BEN YOMO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05AA,
 },
 [0x05AB]={
  adobename="olehebrew",
  category="mn",
  description="HEBREW ACCENT OLE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05AB,
 },
 [0x05AC]={
  adobename="iluyhebrew",
  category="mn",
  description="HEBREW ACCENT ILUY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05AC,
 },
 [0x05AD]={
  adobename="dehihebrew",
  category="mn",
  description="HEBREW ACCENT DEHI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05AD,
 },
 [0x05AE]={
  adobename="zinorhebrew",
  category="mn",
  description="HEBREW ACCENT ZINOR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05AE,
 },
 [0x05AF]={
  adobename="masoracirclehebrew",
  category="mn",
  description="HEBREW MARK MASORA CIRCLE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05AF,
 },
 [0x05B0]={
  adobename="shevawidehebrew",
  category="mn",
  description="HEBREW POINT SHEVA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B0,
 },
 [0x05B1]={
  adobename="hatafsegolwidehebrew",
  category="mn",
  description="HEBREW POINT HATAF SEGOL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B1,
 },
 [0x05B2]={
  adobename="hatafpatahwidehebrew",
  category="mn",
  description="HEBREW POINT HATAF PATAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B2,
 },
 [0x05B3]={
  adobename="hatafqamatswidehebrew",
  category="mn",
  description="HEBREW POINT HATAF QAMATS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B3,
 },
 [0x05B4]={
  adobename="hiriqwidehebrew",
  category="mn",
  description="HEBREW POINT HIRIQ",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B4,
 },
 [0x05B5]={
  adobename="tserewidehebrew",
  category="mn",
  description="HEBREW POINT TSERE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B5,
 },
 [0x05B6]={
  adobename="segolwidehebrew",
  category="mn",
  description="HEBREW POINT SEGOL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B6,
 },
 [0x05B7]={
  adobename="patahwidehebrew",
  category="mn",
  description="HEBREW POINT PATAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B7,
 },
 [0x05B8]={
  adobename="qamatswidehebrew",
  category="mn",
  description="HEBREW POINT QAMATS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B8,
 },
 [0x05B9]={
  adobename="holamwidehebrew",
  category="mn",
  description="HEBREW POINT HOLAM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05B9,
 },
 [0x05BA]={
  category="mn",
  description="HEBREW POINT HOLAM HASER FOR VAV",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05BA,
 },
 [0x05BB]={
  adobename="qubutswidehebrew",
  category="mn",
  description="HEBREW POINT QUBUTS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05BB,
 },
 [0x05BC]={
  adobename="dageshhebrew",
  category="mn",
  description="HEBREW POINT DAGESH OR MAPIQ",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05BC,
 },
 [0x05BD]={
  adobename="siluqlefthebrew",
  category="mn",
  description="HEBREW POINT METEG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05BD,
 },
 [0x05BE]={
  adobename="maqafhebrew",
  category="po",
  description="HEBREW PUNCTUATION MAQAF",
  direction="r",
  linebreak="ba",
  unicodeslot=0x05BE,
 },
 [0x05BF]={
  adobename="rafehebrew",
  category="mn",
  description="HEBREW POINT RAFE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05BF,
 },
 [0x05C0]={
  adobename="paseqhebrew",
  category="po",
  description="HEBREW PUNCTUATION PASEQ",
  direction="r",
  linebreak="al",
  unicodeslot=0x05C0,
 },
 [0x05C1]={
  adobename="shindothebrew",
  category="mn",
  description="HEBREW POINT SHIN DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05C1,
 },
 [0x05C2]={
  adobename="sindothebrew",
  category="mn",
  description="HEBREW POINT SIN DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05C2,
 },
 [0x05C3]={
  adobename="sofpasuqhebrew",
  category="po",
  description="HEBREW PUNCTUATION SOF PASUQ",
  direction="r",
  linebreak="al",
  unicodeslot=0x05C3,
 },
 [0x05C4]={
  adobename="upperdothebrew",
  category="mn",
  description="HEBREW MARK UPPER DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05C4,
 },
 [0x05C5]={
  category="mn",
  description="HEBREW MARK LOWER DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05C5,
 },
 [0x05C6]={
  category="po",
  description="HEBREW PUNCTUATION NUN HAFUKHA",
  direction="r",
  linebreak="ex",
  unicodeslot=0x05C6,
 },
 [0x05C7]={
  category="mn",
  description="HEBREW POINT QAMATS QATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x05C7,
 },
 [0x05D0]={
  adobename="alefhebrew",
  category="lo",
  contextname="hebrewAlef",
  description="HEBREW LETTER ALEF",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D0,
 },
 [0x05D1]={
  adobename="bethebrew",
  category="lo",
  contextname="hebrewBet",
  description="HEBREW LETTER BET",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D1,
 },
 [0x05D2]={
  adobename="gimelhebrew",
  category="lo",
  contextname="hebrewGimel",
  description="HEBREW LETTER GIMEL",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D2,
 },
 [0x05D3]={
  adobename="dalettserehebrew",
  category="lo",
  contextname="hebrewDalet",
  description="HEBREW LETTER DALET",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D3,
 },
 [0x05D4]={
  adobename="hehebrew",
  category="lo",
  contextname="hebrewHe",
  description="HEBREW LETTER HE",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D4,
 },
 [0x05D5]={
  adobename="vavhebrew",
  category="lo",
  contextname="hebrewVav",
  description="HEBREW LETTER VAV",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D5,
 },
 [0x05D6]={
  adobename="zayinhebrew",
  category="lo",
  contextname="hebrewZayin",
  description="HEBREW LETTER ZAYIN",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D6,
 },
 [0x05D7]={
  adobename="hethebrew",
  category="lo",
  contextname="hebrewHet",
  description="HEBREW LETTER HET",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D7,
 },
 [0x05D8]={
  adobename="tethebrew",
  category="lo",
  contextname="hebrewTet",
  description="HEBREW LETTER TET",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D8,
 },
 [0x05D9]={
  adobename="yodhebrew",
  category="lo",
  contextname="hebrewYod",
  description="HEBREW LETTER YOD",
  direction="r",
  linebreak="al",
  unicodeslot=0x05D9,
 },
 [0x05DA]={
  adobename="finalkafshevahebrew",
  category="lo",
  contextname="hebrewKaffinal",
  description="HEBREW LETTER FINAL KAF",
  direction="r",
  linebreak="al",
  unicodeslot=0x05DA,
 },
 [0x05DB]={
  adobename="kafhebrew",
  category="lo",
  contextname="hebrewKaf",
  description="HEBREW LETTER KAF",
  direction="r",
  linebreak="al",
  unicodeslot=0x05DB,
 },
 [0x05DC]={
  adobename="lamedholamhebrew",
  category="lo",
  contextname="hebrewLamed",
  description="HEBREW LETTER LAMED",
  direction="r",
  linebreak="al",
  unicodeslot=0x05DC,
 },
 [0x05DD]={
  adobename="finalmemhebrew",
  category="lo",
  contextname="hebrewMemfinal",
  description="HEBREW LETTER FINAL MEM",
  direction="r",
  linebreak="al",
  unicodeslot=0x05DD,
 },
 [0x05DE]={
  adobename="memhebrew",
  category="lo",
  contextname="hebrewMem",
  description="HEBREW LETTER MEM",
  direction="r",
  linebreak="al",
  unicodeslot=0x05DE,
 },
 [0x05DF]={
  adobename="finalnunhebrew",
  category="lo",
  contextname="hebrewNunfinal",
  description="HEBREW LETTER FINAL NUN",
  direction="r",
  linebreak="al",
  unicodeslot=0x05DF,
 },
 [0x05E0]={
  adobename="nunhebrew",
  category="lo",
  contextname="hebrewNun",
  description="HEBREW LETTER NUN",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E0,
 },
 [0x05E1]={
  adobename="samekhhebrew",
  category="lo",
  contextname="hebrewSamekh",
  description="HEBREW LETTER SAMEKH",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E1,
 },
 [0x05E2]={
  adobename="ayinhebrew",
  category="lo",
  contextname="hebrewAyin",
  description="HEBREW LETTER AYIN",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E2,
 },
 [0x05E3]={
  adobename="finalpehebrew",
  category="lo",
  contextname="hebrewPefinal",
  description="HEBREW LETTER FINAL PE",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E3,
 },
 [0x05E4]={
  adobename="pehebrew",
  category="lo",
  contextname="hebrewPe",
  description="HEBREW LETTER PE",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E4,
 },
 [0x05E5]={
  adobename="finaltsadihebrew",
  category="lo",
  contextname="hebrewTsadifinal",
  description="HEBREW LETTER FINAL TSADI",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E5,
 },
 [0x05E6]={
  adobename="tsadihebrew",
  category="lo",
  contextname="hebrewTsadi",
  description="HEBREW LETTER TSADI",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E6,
 },
 [0x05E7]={
  adobename="qoftserehebrew",
  category="lo",
  contextname="hebrewQof",
  description="HEBREW LETTER QOF",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E7,
 },
 [0x05E8]={
  adobename="reshtserehebrew",
  category="lo",
  contextname="hebrewResh",
  description="HEBREW LETTER RESH",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E8,
 },
 [0x05E9]={
  adobename="shinhebrew",
  category="lo",
  contextname="hebrewShin",
  description="HEBREW LETTER SHIN",
  direction="r",
  linebreak="al",
  unicodeslot=0x05E9,
 },
 [0x05EA]={
  adobename="tavhebrew",
  category="lo",
  contextname="hebrewTav",
  description="HEBREW LETTER TAV",
  direction="r",
  linebreak="al",
  unicodeslot=0x05EA,
 },
 [0x05F0]={
  adobename="vavvavhebrew",
  category="lo",
  description="HEBREW LIGATURE YIDDISH DOUBLE VAV",
  direction="r",
  linebreak="al",
  unicodeslot=0x05F0,
 },
 [0x05F1]={
  adobename="vavyodhebrew",
  category="lo",
  description="HEBREW LIGATURE YIDDISH VAV YOD",
  direction="r",
  linebreak="al",
  unicodeslot=0x05F1,
 },
 [0x05F2]={
  adobename="yodyodhebrew",
  category="lo",
  description="HEBREW LIGATURE YIDDISH DOUBLE YOD",
  direction="r",
  linebreak="al",
  unicodeslot=0x05F2,
 },
 [0x05F3]={
  adobename="gereshhebrew",
  category="po",
  description="HEBREW PUNCTUATION GERESH",
  direction="r",
  linebreak="al",
  unicodeslot=0x05F3,
 },
 [0x05F4]={
  adobename="gershayimhebrew",
  category="po",
  description="HEBREW PUNCTUATION GERSHAYIM",
  direction="r",
  linebreak="al",
  unicodeslot=0x05F4,
 },
 [0x0600]={
  category="cf",
  description="ARABIC NUMBER SIGN",
  direction="an",
  linebreak="al",
  unicodeslot=0x0600,
  visible="yes",
 },
 [0x0601]={
  category="cf",
  description="ARABIC SIGN SANAH",
  direction="an",
  linebreak="al",
  unicodeslot=0x0601,
  visible="yes",
 },
 [0x0602]={
  category="cf",
  description="ARABIC FOOTNOTE MARKER",
  direction="an",
  linebreak="al",
  unicodeslot=0x0602,
  visible="yes",
 },
 [0x0603]={
  category="cf",
  description="ARABIC SIGN SAFHA",
  direction="an",
  linebreak="al",
  unicodeslot=0x0603,
  visible="yes",
 },
 [0x0606]={
  category="sm",
  description="ARABIC-INDIC CUBE ROOT",
  direction="on",
  linebreak="al",
  unicodeslot=0x0606,
 },
 [0x0607]={
  category="sm",
  description="ARABIC-INDIC FOURTH ROOT",
  direction="on",
  linebreak="al",
  unicodeslot=0x0607,
 },
 [0x0608]={
  category="sm",
  description="ARABIC RAY",
  direction="al",
  linebreak="al",
  unicodeslot=0x0608,
 },
 [0x0609]={
  category="po",
  description="ARABIC-INDIC PER MILLE SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x0609,
 },
 [0x060A]={
  category="po",
  description="ARABIC-INDIC PER TEN THOUSAND SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x060A,
 },
 [0x060B]={
  category="sc",
  description="AFGHANI SIGN",
  direction="al",
  linebreak="po",
  unicodeslot=0x060B,
 },
 [0x060C]={
  adobename="commaarabic",
  category="po",
  description="ARABIC COMMA",
  direction="cs",
  linebreak="is",
  unicodeslot=0x060C,
 },
 [0x060D]={
  category="po",
  description="ARABIC DATE SEPARATOR",
  direction="al",
  linebreak="is",
  unicodeslot=0x060D,
 },
 [0x060E]={
  category="so",
  description="ARABIC POETIC VERSE SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x060E,
 },
 [0x060F]={
  category="so",
  description="ARABIC SIGN MISRA",
  direction="on",
  linebreak="al",
  unicodeslot=0x060F,
 },
 [0x0610]={
  category="mn",
  description="ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0610,
 },
 [0x0611]={
  category="mn",
  description="ARABIC SIGN ALAYHE ASSALLAM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0611,
 },
 [0x0612]={
  category="mn",
  description="ARABIC SIGN RAHMATULLAH ALAYHE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0612,
 },
 [0x0613]={
  category="mn",
  description="ARABIC SIGN RADI ALLAHOU ANHU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0613,
 },
 [0x0614]={
  category="mn",
  description="ARABIC SIGN TAKHALLUS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0614,
 },
 [0x0615]={
  category="mn",
  description="ARABIC SMALL HIGH TAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0615,
 },
 [0x0616]={
  category="mn",
  description="ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0616,
 },
 [0x0617]={
  category="mn",
  description="ARABIC SMALL HIGH ZAIN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0617,
 },
 [0x0618]={
  category="mn",
  description="ARABIC SMALL FATHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0618,
 },
 [0x0619]={
  category="mn",
  description="ARABIC SMALL DAMMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0619,
 },
 [0x061A]={
  category="mn",
  description="ARABIC SMALL KASRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x061A,
 },
 [0x061B]={
  adobename="semicolonarabic",
  category="po",
  description="ARABIC SEMICOLON",
  direction="al",
  linebreak="ex",
  unicodeslot=0x061B,
 },
 [0x061E]={
  category="po",
  description="ARABIC TRIPLE DOT PUNCTUATION MARK",
  direction="al",
  linebreak="ex",
  unicodeslot=0x061E,
 },
 [0x061F]={
  adobename="questionarabic",
  category="po",
  description="ARABIC QUESTION MARK",
  direction="al",
  linebreak="ex",
  unicodeslot=0x061F,
 },
 [0x0620]={
  category="lo",
  description="ARABIC LETTER KASHMIRI YEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0620,
 },
 [0x0621]={
  adobename="hamzasukunarabic",
  category="lo",
  description="ARABIC LETTER HAMZA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0621,
 },
 [0x0622]={
  adobename="alefmaddaabovearabic",
  category="lo",
  description="ARABIC LETTER ALEF WITH MADDA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0627,
  specials={ "char", 0x0627, 0x0653 },
  unicodeslot=0x0622,
 },
 [0x0623]={
  adobename="alefhamzaabovearabic",
  category="lo",
  description="ARABIC LETTER ALEF WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0627,
  specials={ "char", 0x0627, 0x0654 },
  unicodeslot=0x0623,
 },
 [0x0624]={
  adobename="wawhamzaabovearabic",
  category="lo",
  description="ARABIC LETTER WAW WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0648,
  specials={ "char", 0x0648, 0x0654 },
  unicodeslot=0x0624,
 },
 [0x0625]={
  adobename="alefhamzabelowarabic",
  category="lo",
  description="ARABIC LETTER ALEF WITH HAMZA BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0627,
  specials={ "char", 0x0627, 0x0655 },
  unicodeslot=0x0625,
 },
 [0x0626]={
  adobename="yehhamzaabovearabic",
  category="lo",
  description="ARABIC LETTER YEH WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x064A,
  specials={ "char", 0x064A, 0x0654 },
  unicodeslot=0x0626,
 },
 [0x0627]={
  adobename="alefarabic",
  category="lo",
  description="ARABIC LETTER ALEF",
  direction="al",
  linebreak="al",
  unicodeslot=0x0627,
 },
 [0x0628]={
  adobename="beharabic",
  category="lo",
  description="ARABIC LETTER BEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0628,
 },
 [0x0629]={
  adobename="tehmarbutaarabic",
  category="lo",
  description="ARABIC LETTER TEH MARBUTA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0629,
 },
 [0x062A]={
  adobename="teharabic",
  category="lo",
  description="ARABIC LETTER TEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x062A,
 },
 [0x062B]={
  adobename="theharabic",
  category="lo",
  description="ARABIC LETTER THEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x062B,
 },
 [0x062C]={
  adobename="jeemarabic",
  category="lo",
  description="ARABIC LETTER JEEM",
  direction="al",
  linebreak="al",
  unicodeslot=0x062C,
 },
 [0x062D]={
  adobename="haharabic",
  category="lo",
  description="ARABIC LETTER HAH",
  direction="al",
  linebreak="al",
  unicodeslot=0x062D,
 },
 [0x062E]={
  adobename="khaharabic",
  category="lo",
  description="ARABIC LETTER KHAH",
  direction="al",
  linebreak="al",
  unicodeslot=0x062E,
 },
 [0x062F]={
  adobename="dalarabic",
  category="lo",
  description="ARABIC LETTER DAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x062F,
 },
 [0x0630]={
  adobename="thalarabic",
  category="lo",
  description="ARABIC LETTER THAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x0630,
 },
 [0x0631]={
  adobename="rehyehaleflamarabic",
  category="lo",
  description="ARABIC LETTER REH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0631,
 },
 [0x0632]={
  adobename="zainarabic",
  category="lo",
  description="ARABIC LETTER ZAIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x0632,
 },
 [0x0633]={
  adobename="seenarabic",
  category="lo",
  description="ARABIC LETTER SEEN",
  direction="al",
  linebreak="al",
  unicodeslot=0x0633,
 },
 [0x0634]={
  adobename="sheenarabic",
  category="lo",
  description="ARABIC LETTER SHEEN",
  direction="al",
  linebreak="al",
  unicodeslot=0x0634,
 },
 [0x0635]={
  adobename="sadarabic",
  category="lo",
  description="ARABIC LETTER SAD",
  direction="al",
  linebreak="al",
  unicodeslot=0x0635,
 },
 [0x0636]={
  adobename="dadarabic",
  category="lo",
  description="ARABIC LETTER DAD",
  direction="al",
  linebreak="al",
  unicodeslot=0x0636,
 },
 [0x0637]={
  adobename="taharabic",
  category="lo",
  description="ARABIC LETTER TAH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0637,
 },
 [0x0638]={
  adobename="zaharabic",
  category="lo",
  description="ARABIC LETTER ZAH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0638,
 },
 [0x0639]={
  adobename="ainarabic",
  category="lo",
  description="ARABIC LETTER AIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x0639,
 },
 [0x063A]={
  adobename="ghainarabic",
  category="lo",
  description="ARABIC LETTER GHAIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x063A,
 },
 [0x063B]={
  category="lo",
  description="ARABIC LETTER KEHEH WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x063B,
 },
 [0x063C]={
  category="lo",
  description="ARABIC LETTER KEHEH WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x063C,
 },
 [0x063D]={
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH INVERTED V",
  direction="al",
  linebreak="al",
  unicodeslot=0x063D,
 },
 [0x063E]={
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x063E,
 },
 [0x063F]={
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x063F,
 },
 [0x0640]={
  adobename="tatweelarabic",
  category="lm",
  description="ARABIC TATWEEL",
  direction="al",
  linebreak="al",
  unicodeslot=0x0640,
 },
 [0x0641]={
  adobename="feharabic",
  category="lo",
  description="ARABIC LETTER FEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0641,
 },
 [0x0642]={
  adobename="qafarabic",
  category="lo",
  description="ARABIC LETTER QAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x0642,
 },
 [0x0643]={
  adobename="kafarabic",
  category="lo",
  description="ARABIC LETTER KAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x0643,
 },
 [0x0644]={
  adobename="lamarabic",
  category="lo",
  description="ARABIC LETTER LAM",
  direction="al",
  linebreak="al",
  unicodeslot=0x0644,
 },
 [0x0645]={
  adobename="meemarabic",
  category="lo",
  description="ARABIC LETTER MEEM",
  direction="al",
  linebreak="al",
  unicodeslot=0x0645,
 },
 [0x0646]={
  adobename="noonarabic",
  category="lo",
  description="ARABIC LETTER NOON",
  direction="al",
  linebreak="al",
  unicodeslot=0x0646,
 },
 [0x0647]={
  adobename="heharabic",
  category="lo",
  description="ARABIC LETTER HEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0647,
 },
 [0x0648]={
  adobename="wawarabic",
  category="lo",
  description="ARABIC LETTER WAW",
  direction="al",
  linebreak="al",
  unicodeslot=0x0648,
 },
 [0x0649]={
  adobename="alefmaksuraarabic",
  category="lo",
  description="ARABIC LETTER ALEF MAKSURA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0649,
 },
 [0x064A]={
  adobename="yeharabic",
  category="lo",
  description="ARABIC LETTER YEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x064A,
 },
 [0x064B]={
  adobename="fathatanarabic",
  category="mn",
  description="ARABIC FATHATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x064B,
 },
 [0x064C]={
  adobename="dammatanarabic",
  category="mn",
  description="ARABIC DAMMATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x064C,
 },
 [0x064D]={
  adobename="kasratanarabic",
  category="mn",
  description="ARABIC KASRATAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x064D,
 },
 [0x064E]={
  adobename="fathalowarabic",
  category="mn",
  description="ARABIC FATHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x064E,
 },
 [0x064F]={
  adobename="dammalowarabic",
  category="mn",
  description="ARABIC DAMMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x064F,
 },
 [0x0650]={
  adobename="kasraarabic",
  category="mn",
  description="ARABIC KASRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0650,
 },
 [0x0651]={
  adobename="shaddafathatanarabic",
  category="mn",
  description="ARABIC SHADDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0651,
 },
 [0x0652]={
  adobename="sukunarabic",
  category="mn",
  description="ARABIC SUKUN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0652,
 },
 [0x0653]={
  category="mn",
  description="ARABIC MADDAH ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0653,
 },
 [0x0654]={
  category="mn",
  description="ARABIC HAMZA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0654,
 },
 [0x0655]={
  category="mn",
  description="ARABIC HAMZA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0655,
 },
 [0x0656]={
  category="mn",
  description="ARABIC SUBSCRIPT ALEF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0656,
 },
 [0x0657]={
  category="mn",
  description="ARABIC INVERTED DAMMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0657,
 },
 [0x0658]={
  category="mn",
  description="ARABIC MARK NOON GHUNNA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0658,
 },
 [0x0659]={
  category="mn",
  description="ARABIC ZWARAKAY",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0659,
 },
 [0x065A]={
  category="mn",
  description="ARABIC VOWEL SIGN SMALL V ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x065A,
 },
 [0x065B]={
  category="mn",
  description="ARABIC VOWEL SIGN INVERTED SMALL V ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x065B,
 },
 [0x065C]={
  category="mn",
  description="ARABIC VOWEL SIGN DOT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x065C,
 },
 [0x065D]={
  category="mn",
  description="ARABIC REVERSED DAMMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x065D,
 },
 [0x065E]={
  category="mn",
  description="ARABIC FATHA WITH TWO DOTS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x065E,
 },
 [0x065F]={
  category="mn",
  description="ARABIC WAVY HAMZA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x065F,
 },
 [0x0660]={
  adobename="zerohackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT ZERO",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0660,
 },
 [0x0661]={
  adobename="onehackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT ONE",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0661,
 },
 [0x0662]={
  adobename="twohackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT TWO",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0662,
 },
 [0x0663]={
  adobename="threehackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT THREE",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0663,
 },
 [0x0664]={
  adobename="fourhackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT FOUR",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0664,
 },
 [0x0665]={
  adobename="fivehackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT FIVE",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0665,
 },
 [0x0666]={
  adobename="sixhackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT SIX",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0666,
 },
 [0x0667]={
  adobename="sevenhackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT SEVEN",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0667,
 },
 [0x0668]={
  adobename="eighthackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT EIGHT",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0668,
 },
 [0x0669]={
  adobename="ninehackarabic",
  category="nd",
  description="ARABIC-INDIC DIGIT NINE",
  direction="an",
  linebreak="nu",
  unicodeslot=0x0669,
 },
 [0x066A]={
  adobename="percentarabic",
  category="po",
  description="ARABIC PERCENT SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x066A,
 },
 [0x066B]={
  adobename="decimalseparatorpersian",
  category="po",
  description="ARABIC DECIMAL SEPARATOR",
  direction="an",
  linebreak="nu",
  unicodeslot=0x066B,
 },
 [0x066C]={
  adobename="thousandsseparatorpersian",
  category="po",
  description="ARABIC THOUSANDS SEPARATOR",
  direction="an",
  linebreak="nu",
  unicodeslot=0x066C,
 },
 [0x066D]={
  adobename="asteriskarabic",
  category="po",
  description="ARABIC FIVE POINTED STAR",
  direction="al",
  linebreak="al",
  unicodeslot=0x066D,
 },
 [0x066E]={
  category="lo",
  description="ARABIC LETTER DOTLESS BEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x066E,
 },
 [0x066F]={
  category="lo",
  description="ARABIC LETTER DOTLESS QAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x066F,
 },
 [0x0670]={
  category="mn",
  description="ARABIC LETTER SUPERSCRIPT ALEF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0670,
 },
 [0x0671]={
  category="lo",
  description="ARABIC LETTER ALEF WASLA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0671,
 },
 [0x0672]={
  category="lo",
  description="ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0627,
  unicodeslot=0x0672,
 },
 [0x0673]={
  category="lo",
  description="ARABIC LETTER ALEF WITH WAVY HAMZA BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0627,
  unicodeslot=0x0673,
 },
 [0x0674]={
  category="lo",
  description="ARABIC LETTER HIGH HAMZA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0674,
 },
 [0x0675]={
  category="lo",
  description="ARABIC LETTER HIGH HAMZA ALEF",
  direction="al",
  linebreak="al",
  specials={ "compat", 0x0627, 0x0674 },
  unicodeslot=0x0675,
 },
 [0x0676]={
  category="lo",
  description="ARABIC LETTER HIGH HAMZA WAW",
  direction="al",
  linebreak="al",
  specials={ "compat", 0x0648, 0x0674 },
  unicodeslot=0x0676,
 },
 [0x0677]={
  category="lo",
  description="ARABIC LETTER U WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x06C7,
  specials={ "compat", 0x06C7, 0x0674 },
  unicodeslot=0x0677,
 },
 [0x0678]={
  category="lo",
  description="ARABIC LETTER HIGH HAMZA YEH",
  direction="al",
  linebreak="al",
  specials={ "compat", 0x064A, 0x0674 },
  unicodeslot=0x0678,
 },
 [0x0679]={
  adobename="tteharabic",
  category="lo",
  description="ARABIC LETTER TTEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0679,
 },
 [0x067A]={
  category="lo",
  description="ARABIC LETTER TTEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x067A,
 },
 [0x067B]={
  category="lo",
  description="ARABIC LETTER BEEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x067B,
 },
 [0x067C]={
  category="lo",
  description="ARABIC LETTER TEH WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x062A,
  unicodeslot=0x067C,
 },
 [0x067D]={
  category="lo",
  description="ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS",
  direction="al",
  linebreak="al",
  shcode=0x062A,
  unicodeslot=0x067D,
 },
 [0x067E]={
  adobename="peharabic",
  category="lo",
  description="ARABIC LETTER PEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x067E,
 },
 [0x067F]={
  category="lo",
  description="ARABIC LETTER TEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x067F,
 },
 [0x0680]={
  category="lo",
  description="ARABIC LETTER BEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0680,
 },
 [0x0681]={
  category="lo",
  description="ARABIC LETTER HAH WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x062D,
  unicodeslot=0x0681,
 },
 [0x0682]={
  category="lo",
  description="ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x062D,
  unicodeslot=0x0682,
 },
 [0x0683]={
  category="lo",
  description="ARABIC LETTER NYEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0683,
 },
 [0x0684]={
  category="lo",
  description="ARABIC LETTER DYEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0684,
 },
 [0x0685]={
  category="lo",
  description="ARABIC LETTER HAH WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x062D,
  unicodeslot=0x0685,
 },
 [0x0686]={
  adobename="tcheharabic",
  category="lo",
  description="ARABIC LETTER TCHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0686,
 },
 [0x0687]={
  category="lo",
  description="ARABIC LETTER TCHEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0687,
 },
 [0x0688]={
  adobename="ddalarabic",
  category="lo",
  description="ARABIC LETTER DDAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x0688,
 },
 [0x0689]={
  category="lo",
  description="ARABIC LETTER DAL WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x062F,
  unicodeslot=0x0689,
 },
 [0x068A]={
  category="lo",
  description="ARABIC LETTER DAL WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x062F,
  unicodeslot=0x068A,
 },
 [0x068B]={
  category="lo",
  description="ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH",
  direction="al",
  linebreak="al",
  shcode=0x062F,
  unicodeslot=0x068B,
 },
 [0x068C]={
  category="lo",
  description="ARABIC LETTER DAHAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x068C,
 },
 [0x068D]={
  category="lo",
  description="ARABIC LETTER DDAHAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x068D,
 },
 [0x068E]={
  category="lo",
  description="ARABIC LETTER DUL",
  direction="al",
  linebreak="al",
  unicodeslot=0x068E,
 },
 [0x068F]={
  category="lo",
  description="ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS",
  direction="al",
  linebreak="al",
  shcode=0x062F,
  unicodeslot=0x068F,
 },
 [0x0690]={
  category="lo",
  description="ARABIC LETTER DAL WITH FOUR DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x062F,
  unicodeslot=0x0690,
 },
 [0x0691]={
  adobename="rreharabic",
  category="lo",
  description="ARABIC LETTER RREH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0691,
 },
 [0x0692]={
  category="lo",
  description="ARABIC LETTER REH WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x0692,
 },
 [0x0693]={
  category="lo",
  description="ARABIC LETTER REH WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x0693,
 },
 [0x0694]={
  category="lo",
  description="ARABIC LETTER REH WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x0694,
 },
 [0x0695]={
  category="lo",
  description="ARABIC LETTER REH WITH SMALL V BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x0695,
 },
 [0x0696]={
  category="lo",
  description="ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x0696,
 },
 [0x0697]={
  category="lo",
  description="ARABIC LETTER REH WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x0697,
 },
 [0x0698]={
  adobename="jeharabic",
  category="lo",
  description="ARABIC LETTER JEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0698,
 },
 [0x0699]={
  category="lo",
  description="ARABIC LETTER REH WITH FOUR DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x0699,
 },
 [0x069A]={
  category="lo",
  description="ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0633,
  unicodeslot=0x069A,
 },
 [0x069B]={
  category="lo",
  description="ARABIC LETTER SEEN WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0633,
  unicodeslot=0x069B,
 },
 [0x069C]={
  category="lo",
  description="ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0633,
  unicodeslot=0x069C,
 },
 [0x069D]={
  category="lo",
  description="ARABIC LETTER SAD WITH TWO DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0635,
  unicodeslot=0x069D,
 },
 [0x069E]={
  category="lo",
  description="ARABIC LETTER SAD WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0635,
  unicodeslot=0x069E,
 },
 [0x069F]={
  category="lo",
  description="ARABIC LETTER TAH WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0637,
  unicodeslot=0x069F,
 },
 [0x06A0]={
  category="lo",
  description="ARABIC LETTER AIN WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0639,
  unicodeslot=0x06A0,
 },
 [0x06A1]={
  category="lo",
  description="ARABIC LETTER DOTLESS FEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x06A1,
 },
 [0x06A2]={
  category="lo",
  description="ARABIC LETTER FEH WITH DOT MOVED BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0641,
  unicodeslot=0x06A2,
 },
 [0x06A3]={
  category="lo",
  description="ARABIC LETTER FEH WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0641,
  unicodeslot=0x06A3,
 },
 [0x06A4]={
  adobename="veharabic",
  category="lo",
  description="ARABIC LETTER VEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x06A4,
 },
 [0x06A5]={
  category="lo",
  description="ARABIC LETTER FEH WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0641,
  unicodeslot=0x06A5,
 },
 [0x06A6]={
  category="lo",
  description="ARABIC LETTER PEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x06A6,
 },
 [0x06A7]={
  category="lo",
  description="ARABIC LETTER QAF WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0642,
  unicodeslot=0x06A7,
 },
 [0x06A8]={
  category="lo",
  description="ARABIC LETTER QAF WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0642,
  unicodeslot=0x06A8,
 },
 [0x06A9]={
  category="lo",
  description="ARABIC LETTER KEHEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x06A9,
 },
 [0x06AA]={
  category="lo",
  description="ARABIC LETTER SWASH KAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x06AA,
 },
 [0x06AB]={
  category="lo",
  description="ARABIC LETTER KAF WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x0643,
  unicodeslot=0x06AB,
 },
 [0x06AC]={
  category="lo",
  description="ARABIC LETTER KAF WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0643,
  unicodeslot=0x06AC,
 },
 [0x06AD]={
  category="lo",
  description="ARABIC LETTER NG",
  direction="al",
  linebreak="al",
  unicodeslot=0x06AD,
 },
 [0x06AE]={
  category="lo",
  description="ARABIC LETTER KAF WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0643,
  unicodeslot=0x06AE,
 },
 [0x06AF]={
  adobename="gafarabic",
  category="lo",
  description="ARABIC LETTER GAF",
  direction="al",
  linebreak="al",
  unicodeslot=0x06AF,
 },
 [0x06B0]={
  category="lo",
  description="ARABIC LETTER GAF WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x06AF,
  unicodeslot=0x06B0,
 },
 [0x06B1]={
  category="lo",
  description="ARABIC LETTER NGOEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x06B1,
 },
 [0x06B2]={
  category="lo",
  description="ARABIC LETTER GAF WITH TWO DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x06AF,
  unicodeslot=0x06B2,
 },
 [0x06B3]={
  category="lo",
  description="ARABIC LETTER GUEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x06B3,
 },
 [0x06B4]={
  category="lo",
  description="ARABIC LETTER GAF WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x06AF,
  unicodeslot=0x06B4,
 },
 [0x06B5]={
  category="lo",
  description="ARABIC LETTER LAM WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x0644,
  unicodeslot=0x06B5,
 },
 [0x06B6]={
  category="lo",
  description="ARABIC LETTER LAM WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0644,
  unicodeslot=0x06B6,
 },
 [0x06B7]={
  category="lo",
  description="ARABIC LETTER LAM WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0644,
  unicodeslot=0x06B7,
 },
 [0x06B8]={
  category="lo",
  description="ARABIC LETTER LAM WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0644,
  unicodeslot=0x06B8,
 },
 [0x06B9]={
  category="lo",
  description="ARABIC LETTER NOON WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0646,
  unicodeslot=0x06B9,
 },
 [0x06BA]={
  adobename="noonghunnaarabic",
  category="lo",
  description="ARABIC LETTER NOON GHUNNA",
  direction="al",
  linebreak="al",
  unicodeslot=0x06BA,
 },
 [0x06BB]={
  category="lo",
  description="ARABIC LETTER RNOON",
  direction="al",
  linebreak="al",
  unicodeslot=0x06BB,
 },
 [0x06BC]={
  category="lo",
  description="ARABIC LETTER NOON WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x0646,
  unicodeslot=0x06BC,
 },
 [0x06BD]={
  category="lo",
  description="ARABIC LETTER NOON WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0646,
  unicodeslot=0x06BD,
 },
 [0x06BE]={
  category="lo",
  description="ARABIC LETTER HEH DOACHASHMEE",
  direction="al",
  linebreak="al",
  unicodeslot=0x06BE,
 },
 [0x06BF]={
  category="lo",
  description="ARABIC LETTER TCHEH WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0686,
  unicodeslot=0x06BF,
 },
 [0x06C0]={
  category="lo",
  description="ARABIC LETTER HEH WITH YEH ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0647,
  specials={ "char", 0x06D5, 0x0654 },
  unicodeslot=0x06C0,
 },
 [0x06C1]={
  adobename="hehaltonearabic",
  category="lo",
  description="ARABIC LETTER HEH GOAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x06C1,
 },
 [0x06C2]={
  category="lo",
  description="ARABIC LETTER HEH GOAL WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  specials={ "char", 0x06C1, 0x0654 },
  unicodeslot=0x06C2,
 },
 [0x06C3]={
  category="lo",
  description="ARABIC LETTER TEH MARBUTA GOAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x06C3,
 },
 [0x06C4]={
  category="lo",
  description="ARABIC LETTER WAW WITH RING",
  direction="al",
  linebreak="al",
  shcode=0x0648,
  unicodeslot=0x06C4,
 },
 [0x06C5]={
  category="lo",
  description="ARABIC LETTER KIRGHIZ OE",
  direction="al",
  linebreak="al",
  unicodeslot=0x06C5,
 },
 [0x06C6]={
  category="lo",
  description="ARABIC LETTER OE",
  direction="al",
  linebreak="al",
  unicodeslot=0x06C6,
 },
 [0x06C7]={
  category="lo",
  description="ARABIC LETTER U",
  direction="al",
  linebreak="al",
  unicodeslot=0x06C7,
 },
 [0x06C8]={
  category="lo",
  description="ARABIC LETTER YU",
  direction="al",
  linebreak="al",
  unicodeslot=0x06C8,
 },
 [0x06C9]={
  category="lo",
  description="ARABIC LETTER KIRGHIZ YU",
  direction="al",
  linebreak="al",
  unicodeslot=0x06C9,
 },
 [0x06CA]={
  category="lo",
  description="ARABIC LETTER WAW WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0648,
  unicodeslot=0x06CA,
 },
 [0x06CB]={
  category="lo",
  description="ARABIC LETTER VE",
  direction="al",
  linebreak="al",
  unicodeslot=0x06CB,
 },
 [0x06CC]={
  category="lo",
  description="ARABIC LETTER FARSI YEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x06CC,
 },
 [0x06CD]={
  category="lo",
  description="ARABIC LETTER YEH WITH TAIL",
  direction="al",
  linebreak="al",
  shcode=0x064A,
  unicodeslot=0x06CD,
 },
 [0x06CE]={
  category="lo",
  description="ARABIC LETTER YEH WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x064A,
  unicodeslot=0x06CE,
 },
 [0x06CF]={
  category="lo",
  description="ARABIC LETTER WAW WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0648,
  unicodeslot=0x06CF,
 },
 [0x06D0]={
  category="lo",
  description="ARABIC LETTER E",
  direction="al",
  linebreak="al",
  unicodeslot=0x06D0,
 },
 [0x06D1]={
  adobename="yehthreedotsbelowarabic",
  category="lo",
  description="ARABIC LETTER YEH WITH THREE DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x064A,
  unicodeslot=0x06D1,
 },
 [0x06D2]={
  adobename="yehbarreearabic",
  category="lo",
  description="ARABIC LETTER YEH BARREE",
  direction="al",
  linebreak="al",
  unicodeslot=0x06D2,
 },
 [0x06D3]={
  category="lo",
  description="ARABIC LETTER YEH BARREE WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  specials={ "char", 0x06D2, 0x0654 },
  unicodeslot=0x06D3,
 },
 [0x06D4]={
  category="po",
  description="ARABIC FULL STOP",
  direction="al",
  linebreak="ex",
  unicodeslot=0x06D4,
 },
 [0x06D5]={
  adobename="afii57534",
  category="lo",
  description="ARABIC LETTER AE",
  direction="al",
  linebreak="al",
  unicodeslot=0x06D5,
 },
 [0x06D6]={
  category="mn",
  description="ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06D6,
 },
 [0x06D7]={
  category="mn",
  description="ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06D7,
 },
 [0x06D8]={
  category="mn",
  description="ARABIC SMALL HIGH MEEM INITIAL FORM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06D8,
 },
 [0x06D9]={
  category="mn",
  description="ARABIC SMALL HIGH LAM ALEF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06D9,
 },
 [0x06DA]={
  category="mn",
  description="ARABIC SMALL HIGH JEEM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06DA,
 },
 [0x06DB]={
  category="mn",
  description="ARABIC SMALL HIGH THREE DOTS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06DB,
 },
 [0x06DC]={
  category="mn",
  description="ARABIC SMALL HIGH SEEN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06DC,
 },
 [0x06DD]={
  category="cf",
  description="ARABIC END OF AYAH",
  direction="an",
  linebreak="al",
  unicodeslot=0x06DD,
  visible="yes",
 },
 [0x06DE]={
  category="me",
  description="ARABIC START OF RUB EL HIZB",
  direction="on",
  linebreak="al",
  unicodeslot=0x06DE,
 },
 [0x06DF]={
  category="mn",
  description="ARABIC SMALL HIGH ROUNDED ZERO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06DF,
 },
 [0x06E0]={
  category="mn",
  description="ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06E0,
 },
 [0x06E1]={
  category="mn",
  description="ARABIC SMALL HIGH DOTLESS HEAD OF KHAH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06E1,
 },
 [0x06E2]={
  category="mn",
  description="ARABIC SMALL HIGH MEEM ISOLATED FORM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06E2,
 },
 [0x06E3]={
  category="mn",
  description="ARABIC SMALL LOW SEEN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06E3,
 },
 [0x06E4]={
  category="mn",
  description="ARABIC SMALL HIGH MADDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06E4,
 },
 [0x06E5]={
  category="lm",
  description="ARABIC SMALL WAW",
  direction="al",
  linebreak="al",
  unicodeslot=0x06E5,
 },
 [0x06E6]={
  category="lm",
  description="ARABIC SMALL YEH",
  direction="al",
  linebreak="al",
  unicodeslot=0x06E6,
 },
 [0x06E7]={
  category="mn",
  description="ARABIC SMALL HIGH YEH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06E7,
 },
 [0x06E8]={
  category="mn",
  description="ARABIC SMALL HIGH NOON",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06E8,
 },
 [0x06E9]={
  category="so",
  description="ARABIC PLACE OF SAJDAH",
  direction="on",
  linebreak="al",
  unicodeslot=0x06E9,
 },
 [0x06EA]={
  category="mn",
  description="ARABIC EMPTY CENTRE LOW STOP",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06EA,
 },
 [0x06EB]={
  category="mn",
  description="ARABIC EMPTY CENTRE HIGH STOP",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06EB,
 },
 [0x06EC]={
  category="mn",
  description="ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06EC,
 },
 [0x06ED]={
  category="mn",
  description="ARABIC SMALL LOW MEEM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x06ED,
 },
 [0x06EE]={
  category="lo",
  description="ARABIC LETTER DAL WITH INVERTED V",
  direction="al",
  linebreak="al",
  shcode=0x062F,
  unicodeslot=0x06EE,
 },
 [0x06EF]={
  category="lo",
  description="ARABIC LETTER REH WITH INVERTED V",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x06EF,
 },
 [0x06F0]={
  adobename="zeropersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT ZERO",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F0,
 },
 [0x06F1]={
  adobename="onepersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT ONE",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F1,
 },
 [0x06F2]={
  adobename="twopersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT TWO",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F2,
 },
 [0x06F3]={
  adobename="threepersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT THREE",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F3,
 },
 [0x06F4]={
  adobename="fourpersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT FOUR",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F4,
 },
 [0x06F5]={
  adobename="fivepersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT FIVE",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F5,
 },
 [0x06F6]={
  adobename="sixpersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT SIX",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F6,
 },
 [0x06F7]={
  adobename="sevenpersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT SEVEN",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F7,
 },
 [0x06F8]={
  adobename="eightpersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT EIGHT",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F8,
 },
 [0x06F9]={
  adobename="ninepersian",
  category="nd",
  description="EXTENDED ARABIC-INDIC DIGIT NINE",
  direction="en",
  linebreak="nu",
  unicodeslot=0x06F9,
 },
 [0x06FA]={
  category="lo",
  description="ARABIC LETTER SHEEN WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0634,
  unicodeslot=0x06FA,
 },
 [0x06FB]={
  category="lo",
  description="ARABIC LETTER DAD WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0636,
  unicodeslot=0x06FB,
 },
 [0x06FC]={
  category="lo",
  description="ARABIC LETTER GHAIN WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x063A,
  unicodeslot=0x06FC,
 },
 [0x06FD]={
  category="so",
  description="ARABIC SIGN SINDHI AMPERSAND",
  direction="al",
  linebreak="al",
  unicodeslot=0x06FD,
 },
 [0x06FE]={
  category="so",
  description="ARABIC SIGN SINDHI POSTPOSITION MEN",
  direction="al",
  linebreak="al",
  unicodeslot=0x06FE,
 },
 [0x06FF]={
  category="lo",
  description="ARABIC LETTER HEH WITH INVERTED V",
  direction="al",
  linebreak="al",
  shcode=0x0647,
  unicodeslot=0x06FF,
 },
 [0x0700]={
  category="po",
  description="SYRIAC END OF PARAGRAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0700,
 },
 [0x0701]={
  category="po",
  description="SYRIAC SUPRALINEAR FULL STOP",
  direction="al",
  linebreak="al",
  unicodeslot=0x0701,
 },
 [0x0702]={
  category="po",
  description="SYRIAC SUBLINEAR FULL STOP",
  direction="al",
  linebreak="al",
  unicodeslot=0x0702,
 },
 [0x0703]={
  category="po",
  description="SYRIAC SUPRALINEAR COLON",
  direction="al",
  linebreak="al",
  unicodeslot=0x0703,
 },
 [0x0704]={
  category="po",
  description="SYRIAC SUBLINEAR COLON",
  direction="al",
  linebreak="al",
  unicodeslot=0x0704,
 },
 [0x0705]={
  category="po",
  description="SYRIAC HORIZONTAL COLON",
  direction="al",
  linebreak="al",
  unicodeslot=0x0705,
 },
 [0x0706]={
  category="po",
  description="SYRIAC COLON SKEWED LEFT",
  direction="al",
  linebreak="al",
  unicodeslot=0x0706,
 },
 [0x0707]={
  category="po",
  description="SYRIAC COLON SKEWED RIGHT",
  direction="al",
  linebreak="al",
  unicodeslot=0x0707,
 },
 [0x0708]={
  category="po",
  description="SYRIAC SUPRALINEAR COLON SKEWED LEFT",
  direction="al",
  linebreak="al",
  unicodeslot=0x0708,
 },
 [0x0709]={
  category="po",
  description="SYRIAC SUBLINEAR COLON SKEWED RIGHT",
  direction="al",
  linebreak="al",
  unicodeslot=0x0709,
 },
 [0x070A]={
  category="po",
  description="SYRIAC CONTRACTION",
  direction="al",
  linebreak="al",
  unicodeslot=0x070A,
 },
 [0x070B]={
  category="po",
  description="SYRIAC HARKLEAN OBELUS",
  direction="al",
  linebreak="al",
  unicodeslot=0x070B,
 },
 [0x070C]={
  category="po",
  description="SYRIAC HARKLEAN METOBELUS",
  direction="al",
  linebreak="al",
  unicodeslot=0x070C,
 },
 [0x070D]={
  category="po",
  description="SYRIAC HARKLEAN ASTERISCUS",
  direction="al",
  linebreak="al",
  unicodeslot=0x070D,
 },
 [0x070F]={
  category="cf",
  description="SYRIAC ABBREVIATION MARK",
  direction="an",
  linebreak="al",
  unicodeslot=0x070F,
  visible="yes",
 },
 [0x0710]={
  category="lo",
  description="SYRIAC LETTER ALAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0710,
 },
 [0x0711]={
  category="mn",
  description="SYRIAC LETTER SUPERSCRIPT ALAPH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0711,
 },
 [0x0712]={
  category="lo",
  description="SYRIAC LETTER BETH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0712,
 },
 [0x0713]={
  category="lo",
  description="SYRIAC LETTER GAMAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x0713,
 },
 [0x0714]={
  category="lo",
  description="SYRIAC LETTER GAMAL GARSHUNI",
  direction="al",
  linebreak="al",
  unicodeslot=0x0714,
 },
 [0x0715]={
  category="lo",
  description="SYRIAC LETTER DALATH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0715,
 },
 [0x0716]={
  category="lo",
  description="SYRIAC LETTER DOTLESS DALATH RISH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0716,
 },
 [0x0717]={
  category="lo",
  description="SYRIAC LETTER HE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0717,
 },
 [0x0718]={
  category="lo",
  description="SYRIAC LETTER WAW",
  direction="al",
  linebreak="al",
  unicodeslot=0x0718,
 },
 [0x0719]={
  category="lo",
  description="SYRIAC LETTER ZAIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x0719,
 },
 [0x071A]={
  category="lo",
  description="SYRIAC LETTER HETH",
  direction="al",
  linebreak="al",
  unicodeslot=0x071A,
 },
 [0x071B]={
  category="lo",
  description="SYRIAC LETTER TETH",
  direction="al",
  linebreak="al",
  unicodeslot=0x071B,
 },
 [0x071C]={
  category="lo",
  description="SYRIAC LETTER TETH GARSHUNI",
  direction="al",
  linebreak="al",
  unicodeslot=0x071C,
 },
 [0x071D]={
  category="lo",
  description="SYRIAC LETTER YUDH",
  direction="al",
  linebreak="al",
  unicodeslot=0x071D,
 },
 [0x071E]={
  category="lo",
  description="SYRIAC LETTER YUDH HE",
  direction="al",
  linebreak="al",
  unicodeslot=0x071E,
 },
 [0x071F]={
  category="lo",
  description="SYRIAC LETTER KAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x071F,
 },
 [0x0720]={
  category="lo",
  description="SYRIAC LETTER LAMADH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0720,
 },
 [0x0721]={
  category="lo",
  description="SYRIAC LETTER MIM",
  direction="al",
  linebreak="al",
  unicodeslot=0x0721,
 },
 [0x0722]={
  category="lo",
  description="SYRIAC LETTER NUN",
  direction="al",
  linebreak="al",
  unicodeslot=0x0722,
 },
 [0x0723]={
  category="lo",
  description="SYRIAC LETTER SEMKATH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0723,
 },
 [0x0724]={
  category="lo",
  description="SYRIAC LETTER FINAL SEMKATH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0724,
 },
 [0x0725]={
  category="lo",
  description="SYRIAC LETTER E",
  direction="al",
  linebreak="al",
  unicodeslot=0x0725,
 },
 [0x0726]={
  category="lo",
  description="SYRIAC LETTER PE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0726,
 },
 [0x0727]={
  category="lo",
  description="SYRIAC LETTER REVERSED PE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0727,
 },
 [0x0728]={
  category="lo",
  description="SYRIAC LETTER SADHE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0728,
 },
 [0x0729]={
  category="lo",
  description="SYRIAC LETTER QAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x0729,
 },
 [0x072A]={
  category="lo",
  description="SYRIAC LETTER RISH",
  direction="al",
  linebreak="al",
  unicodeslot=0x072A,
 },
 [0x072B]={
  category="lo",
  description="SYRIAC LETTER SHIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x072B,
 },
 [0x072C]={
  category="lo",
  description="SYRIAC LETTER TAW",
  direction="al",
  linebreak="al",
  unicodeslot=0x072C,
 },
 [0x072D]={
  category="lo",
  description="SYRIAC LETTER PERSIAN BHETH",
  direction="al",
  linebreak="al",
  unicodeslot=0x072D,
 },
 [0x072E]={
  category="lo",
  description="SYRIAC LETTER PERSIAN GHAMAL",
  direction="al",
  linebreak="al",
  unicodeslot=0x072E,
 },
 [0x072F]={
  category="lo",
  description="SYRIAC LETTER PERSIAN DHALATH",
  direction="al",
  linebreak="al",
  unicodeslot=0x072F,
 },
 [0x0730]={
  category="mn",
  description="SYRIAC PTHAHA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0730,
 },
 [0x0731]={
  category="mn",
  description="SYRIAC PTHAHA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0731,
 },
 [0x0732]={
  category="mn",
  description="SYRIAC PTHAHA DOTTED",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0732,
 },
 [0x0733]={
  category="mn",
  description="SYRIAC ZQAPHA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0733,
 },
 [0x0734]={
  category="mn",
  description="SYRIAC ZQAPHA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0734,
 },
 [0x0735]={
  category="mn",
  description="SYRIAC ZQAPHA DOTTED",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0735,
 },
 [0x0736]={
  category="mn",
  description="SYRIAC RBASA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0736,
 },
 [0x0737]={
  category="mn",
  description="SYRIAC RBASA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0737,
 },
 [0x0738]={
  category="mn",
  description="SYRIAC DOTTED ZLAMA HORIZONTAL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0738,
 },
 [0x0739]={
  category="mn",
  description="SYRIAC DOTTED ZLAMA ANGULAR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0739,
 },
 [0x073A]={
  category="mn",
  description="SYRIAC HBASA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x073A,
 },
 [0x073B]={
  category="mn",
  description="SYRIAC HBASA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x073B,
 },
 [0x073C]={
  category="mn",
  description="SYRIAC HBASA-ESASA DOTTED",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x073C,
 },
 [0x073D]={
  category="mn",
  description="SYRIAC ESASA ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x073D,
 },
 [0x073E]={
  category="mn",
  description="SYRIAC ESASA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x073E,
 },
 [0x073F]={
  category="mn",
  description="SYRIAC RWAHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x073F,
 },
 [0x0740]={
  category="mn",
  description="SYRIAC FEMININE DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0740,
 },
 [0x0741]={
  category="mn",
  description="SYRIAC QUSHSHAYA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0741,
 },
 [0x0742]={
  category="mn",
  description="SYRIAC RUKKAKHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0742,
 },
 [0x0743]={
  category="mn",
  description="SYRIAC TWO VERTICAL DOTS ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0743,
 },
 [0x0744]={
  category="mn",
  description="SYRIAC TWO VERTICAL DOTS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0744,
 },
 [0x0745]={
  category="mn",
  description="SYRIAC THREE DOTS ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0745,
 },
 [0x0746]={
  category="mn",
  description="SYRIAC THREE DOTS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0746,
 },
 [0x0747]={
  category="mn",
  description="SYRIAC OBLIQUE LINE ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0747,
 },
 [0x0748]={
  category="mn",
  description="SYRIAC OBLIQUE LINE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0748,
 },
 [0x0749]={
  category="mn",
  description="SYRIAC MUSIC",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0749,
 },
 [0x074A]={
  category="mn",
  description="SYRIAC BARREKH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x074A,
 },
 [0x074D]={
  category="lo",
  description="SYRIAC LETTER SOGDIAN ZHAIN",
  direction="al",
  linebreak="al",
  unicodeslot=0x074D,
 },
 [0x074E]={
  category="lo",
  description="SYRIAC LETTER SOGDIAN KHAPH",
  direction="al",
  linebreak="al",
  unicodeslot=0x074E,
 },
 [0x074F]={
  category="lo",
  description="SYRIAC LETTER SOGDIAN FE",
  direction="al",
  linebreak="al",
  unicodeslot=0x074F,
 },
 [0x0750]={
  category="lo",
  description="ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0628,
  unicodeslot=0x0750,
 },
 [0x0751]={
  category="lo",
  description="ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0628,
  unicodeslot=0x0751,
 },
 [0x0752]={
  category="lo",
  description="ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0628,
  unicodeslot=0x0752,
 },
 [0x0753]={
  category="lo",
  description="ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0628,
  unicodeslot=0x0753,
 },
 [0x0754]={
  category="lo",
  description="ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0628,
  unicodeslot=0x0754,
 },
 [0x0755]={
  category="lo",
  description="ARABIC LETTER BEH WITH INVERTED SMALL V BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0628,
  unicodeslot=0x0755,
 },
 [0x0756]={
  category="lo",
  description="ARABIC LETTER BEH WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x0628,
  unicodeslot=0x0756,
 },
 [0x0757]={
  category="lo",
  description="ARABIC LETTER HAH WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x062D,
  unicodeslot=0x0757,
 },
 [0x0758]={
  category="lo",
  description="ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x062D,
  unicodeslot=0x0758,
 },
 [0x0759]={
  category="lo",
  description="ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH",
  direction="al",
  linebreak="al",
  shcode=0x062F,
  unicodeslot=0x0759,
 },
 [0x075A]={
  category="lo",
  description="ARABIC LETTER DAL WITH INVERTED SMALL V BELOW",
  direction="al",
  linebreak="al",
  shcode=0x062F,
  unicodeslot=0x075A,
 },
 [0x075B]={
  category="lo",
  description="ARABIC LETTER REH WITH STROKE",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x075B,
 },
 [0x075C]={
  category="lo",
  description="ARABIC LETTER SEEN WITH FOUR DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0633,
  unicodeslot=0x075C,
 },
 [0x075D]={
  category="lo",
  description="ARABIC LETTER AIN WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0639,
  unicodeslot=0x075D,
 },
 [0x075E]={
  category="lo",
  description="ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0639,
  unicodeslot=0x075E,
 },
 [0x075F]={
  category="lo",
  description="ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0639,
  unicodeslot=0x075F,
 },
 [0x0760]={
  category="lo",
  description="ARABIC LETTER FEH WITH TWO DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0641,
  unicodeslot=0x0760,
 },
 [0x0761]={
  category="lo",
  description="ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0641,
  unicodeslot=0x0761,
 },
 [0x0762]={
  category="lo",
  description="ARABIC LETTER KEHEH WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x06A9,
  unicodeslot=0x0762,
 },
 [0x0763]={
  category="lo",
  description="ARABIC LETTER KEHEH WITH THREE DOTS ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x06A9,
  unicodeslot=0x0763,
 },
 [0x0764]={
  category="lo",
  description="ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x06A9,
  unicodeslot=0x0764,
 },
 [0x0765]={
  category="lo",
  description="ARABIC LETTER MEEM WITH DOT ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0645,
  unicodeslot=0x0765,
 },
 [0x0766]={
  category="lo",
  description="ARABIC LETTER MEEM WITH DOT BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0645,
  unicodeslot=0x0766,
 },
 [0x0767]={
  category="lo",
  description="ARABIC LETTER NOON WITH TWO DOTS BELOW",
  direction="al",
  linebreak="al",
  shcode=0x0646,
  unicodeslot=0x0767,
 },
 [0x0768]={
  category="lo",
  description="ARABIC LETTER NOON WITH SMALL TAH",
  direction="al",
  linebreak="al",
  shcode=0x0646,
  unicodeslot=0x0768,
 },
 [0x0769]={
  category="lo",
  description="ARABIC LETTER NOON WITH SMALL V",
  direction="al",
  linebreak="al",
  shcode=0x0646,
  unicodeslot=0x0769,
 },
 [0x076A]={
  category="lo",
  description="ARABIC LETTER LAM WITH BAR",
  direction="al",
  linebreak="al",
  shcode=0x0644,
  unicodeslot=0x076A,
 },
 [0x076B]={
  category="lo",
  description="ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x076B,
 },
 [0x076C]={
  category="lo",
  description="ARABIC LETTER REH WITH HAMZA ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0631,
  unicodeslot=0x076C,
 },
 [0x076D]={
  category="lo",
  description="ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE",
  direction="al",
  linebreak="al",
  shcode=0x0633,
  unicodeslot=0x076D,
 },
 [0x076E]={
  category="lo",
  description="ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x076E,
 },
 [0x076F]={
  category="lo",
  description="ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
  direction="al",
  linebreak="al",
  unicodeslot=0x076F,
 },
 [0x0770]={
  category="lo",
  description="ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
  direction="al",
  linebreak="al",
  unicodeslot=0x0770,
 },
 [0x0771]={
  category="lo",
  description="ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
  direction="al",
  linebreak="al",
  unicodeslot=0x0771,
 },
 [0x0772]={
  category="lo",
  description="ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0772,
 },
 [0x0773]={
  category="lo",
  description="ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0773,
 },
 [0x0774]={
  category="lo",
  description="ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0774,
 },
 [0x0775]={
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0775,
 },
 [0x0776]={
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0776,
 },
 [0x0777]={
  category="lo",
  description="ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x0777,
 },
 [0x0778]={
  category="lo",
  description="ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0778,
 },
 [0x0779]={
  category="lo",
  description="ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x0779,
 },
 [0x077A]={
  category="lo",
  description="ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x077A,
 },
 [0x077B]={
  category="lo",
  description="ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x077B,
 },
 [0x077C]={
  category="lo",
  description="ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
  direction="al",
  linebreak="al",
  unicodeslot=0x077C,
 },
 [0x077D]={
  category="lo",
  description="ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x077D,
 },
 [0x077E]={
  category="lo",
  description="ARABIC LETTER SEEN WITH INVERTED V",
  direction="al",
  linebreak="al",
  unicodeslot=0x077E,
 },
 [0x077F]={
  category="lo",
  description="ARABIC LETTER KAF WITH TWO DOTS ABOVE",
  direction="al",
  linebreak="al",
  unicodeslot=0x077F,
 },
 [0x0780]={
  category="lo",
  description="THAANA LETTER HAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0780,
 },
 [0x0781]={
  category="lo",
  description="THAANA LETTER SHAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x0781,
 },
 [0x0782]={
  category="lo",
  description="THAANA LETTER NOONU",
  direction="al",
  linebreak="al",
  unicodeslot=0x0782,
 },
 [0x0783]={
  category="lo",
  description="THAANA LETTER RAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0783,
 },
 [0x0784]={
  category="lo",
  description="THAANA LETTER BAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0784,
 },
 [0x0785]={
  category="lo",
  description="THAANA LETTER LHAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x0785,
 },
 [0x0786]={
  category="lo",
  description="THAANA LETTER KAAFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x0786,
 },
 [0x0787]={
  category="lo",
  description="THAANA LETTER ALIFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x0787,
 },
 [0x0788]={
  category="lo",
  description="THAANA LETTER VAAVU",
  direction="al",
  linebreak="al",
  unicodeslot=0x0788,
 },
 [0x0789]={
  category="lo",
  description="THAANA LETTER MEEMU",
  direction="al",
  linebreak="al",
  unicodeslot=0x0789,
 },
 [0x078A]={
  category="lo",
  description="THAANA LETTER FAAFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x078A,
 },
 [0x078B]={
  category="lo",
  description="THAANA LETTER DHAALU",
  direction="al",
  linebreak="al",
  unicodeslot=0x078B,
 },
 [0x078C]={
  category="lo",
  description="THAANA LETTER THAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x078C,
 },
 [0x078D]={
  category="lo",
  description="THAANA LETTER LAAMU",
  direction="al",
  linebreak="al",
  unicodeslot=0x078D,
 },
 [0x078E]={
  category="lo",
  description="THAANA LETTER GAAFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x078E,
 },
 [0x078F]={
  category="lo",
  description="THAANA LETTER GNAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x078F,
 },
 [0x0790]={
  category="lo",
  description="THAANA LETTER SEENU",
  direction="al",
  linebreak="al",
  unicodeslot=0x0790,
 },
 [0x0791]={
  category="lo",
  description="THAANA LETTER DAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x0791,
 },
 [0x0792]={
  category="lo",
  description="THAANA LETTER ZAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x0792,
 },
 [0x0793]={
  category="lo",
  description="THAANA LETTER TAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x0793,
 },
 [0x0794]={
  category="lo",
  description="THAANA LETTER YAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0794,
 },
 [0x0795]={
  category="lo",
  description="THAANA LETTER PAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x0795,
 },
 [0x0796]={
  category="lo",
  description="THAANA LETTER JAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x0796,
 },
 [0x0797]={
  category="lo",
  description="THAANA LETTER CHAVIYANI",
  direction="al",
  linebreak="al",
  unicodeslot=0x0797,
 },
 [0x0798]={
  category="lo",
  description="THAANA LETTER TTAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0798,
 },
 [0x0799]={
  category="lo",
  description="THAANA LETTER HHAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x0799,
 },
 [0x079A]={
  category="lo",
  description="THAANA LETTER KHAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x079A,
 },
 [0x079B]={
  category="lo",
  description="THAANA LETTER THAALU",
  direction="al",
  linebreak="al",
  unicodeslot=0x079B,
 },
 [0x079C]={
  category="lo",
  description="THAANA LETTER ZAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x079C,
 },
 [0x079D]={
  category="lo",
  description="THAANA LETTER SHEENU",
  direction="al",
  linebreak="al",
  unicodeslot=0x079D,
 },
 [0x079E]={
  category="lo",
  description="THAANA LETTER SAADHU",
  direction="al",
  linebreak="al",
  unicodeslot=0x079E,
 },
 [0x079F]={
  category="lo",
  description="THAANA LETTER DAADHU",
  direction="al",
  linebreak="al",
  unicodeslot=0x079F,
 },
 [0x07A0]={
  category="lo",
  description="THAANA LETTER TO",
  direction="al",
  linebreak="al",
  unicodeslot=0x07A0,
 },
 [0x07A1]={
  category="lo",
  description="THAANA LETTER ZO",
  direction="al",
  linebreak="al",
  unicodeslot=0x07A1,
 },
 [0x07A2]={
  category="lo",
  description="THAANA LETTER AINU",
  direction="al",
  linebreak="al",
  unicodeslot=0x07A2,
 },
 [0x07A3]={
  category="lo",
  description="THAANA LETTER GHAINU",
  direction="al",
  linebreak="al",
  unicodeslot=0x07A3,
 },
 [0x07A4]={
  category="lo",
  description="THAANA LETTER QAAFU",
  direction="al",
  linebreak="al",
  unicodeslot=0x07A4,
 },
 [0x07A5]={
  category="lo",
  description="THAANA LETTER WAAVU",
  direction="al",
  linebreak="al",
  unicodeslot=0x07A5,
 },
 [0x07A6]={
  category="mn",
  description="THAANA ABAFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07A6,
 },
 [0x07A7]={
  category="mn",
  description="THAANA AABAAFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07A7,
 },
 [0x07A8]={
  category="mn",
  description="THAANA IBIFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07A8,
 },
 [0x07A9]={
  category="mn",
  description="THAANA EEBEEFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07A9,
 },
 [0x07AA]={
  category="mn",
  description="THAANA UBUFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07AA,
 },
 [0x07AB]={
  category="mn",
  description="THAANA OOBOOFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07AB,
 },
 [0x07AC]={
  category="mn",
  description="THAANA EBEFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07AC,
 },
 [0x07AD]={
  category="mn",
  description="THAANA EYBEYFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07AD,
 },
 [0x07AE]={
  category="mn",
  description="THAANA OBOFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07AE,
 },
 [0x07AF]={
  category="mn",
  description="THAANA OABOAFILI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07AF,
 },
 [0x07B0]={
  category="mn",
  description="THAANA SUKUN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07B0,
 },
 [0x07B1]={
  category="lo",
  description="THAANA LETTER NAA",
  direction="al",
  linebreak="al",
  unicodeslot=0x07B1,
 },
 [0x07C0]={
  category="nd",
  description="NKO DIGIT ZERO",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C0,
 },
 [0x07C1]={
  category="nd",
  description="NKO DIGIT ONE",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C1,
 },
 [0x07C2]={
  category="nd",
  description="NKO DIGIT TWO",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C2,
 },
 [0x07C3]={
  category="nd",
  description="NKO DIGIT THREE",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C3,
 },
 [0x07C4]={
  category="nd",
  description="NKO DIGIT FOUR",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C4,
 },
 [0x07C5]={
  category="nd",
  description="NKO DIGIT FIVE",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C5,
 },
 [0x07C6]={
  category="nd",
  description="NKO DIGIT SIX",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C6,
 },
 [0x07C7]={
  category="nd",
  description="NKO DIGIT SEVEN",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C7,
 },
 [0x07C8]={
  category="nd",
  description="NKO DIGIT EIGHT",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C8,
 },
 [0x07C9]={
  category="nd",
  description="NKO DIGIT NINE",
  direction="r",
  linebreak="nu",
  unicodeslot=0x07C9,
 },
 [0x07CA]={
  category="lo",
  description="NKO LETTER A",
  direction="r",
  linebreak="al",
  unicodeslot=0x07CA,
 },
 [0x07CB]={
  category="lo",
  description="NKO LETTER EE",
  direction="r",
  linebreak="al",
  unicodeslot=0x07CB,
 },
 [0x07CC]={
  category="lo",
  description="NKO LETTER I",
  direction="r",
  linebreak="al",
  unicodeslot=0x07CC,
 },
 [0x07CD]={
  category="lo",
  description="NKO LETTER E",
  direction="r",
  linebreak="al",
  unicodeslot=0x07CD,
 },
 [0x07CE]={
  category="lo",
  description="NKO LETTER U",
  direction="r",
  linebreak="al",
  unicodeslot=0x07CE,
 },
 [0x07CF]={
  category="lo",
  description="NKO LETTER OO",
  direction="r",
  linebreak="al",
  unicodeslot=0x07CF,
 },
 [0x07D0]={
  category="lo",
  description="NKO LETTER O",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D0,
 },
 [0x07D1]={
  category="lo",
  description="NKO LETTER DAGBASINNA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D1,
 },
 [0x07D2]={
  category="lo",
  description="NKO LETTER N",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D2,
 },
 [0x07D3]={
  category="lo",
  description="NKO LETTER BA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D3,
 },
 [0x07D4]={
  category="lo",
  description="NKO LETTER PA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D4,
 },
 [0x07D5]={
  category="lo",
  description="NKO LETTER TA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D5,
 },
 [0x07D6]={
  category="lo",
  description="NKO LETTER JA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D6,
 },
 [0x07D7]={
  category="lo",
  description="NKO LETTER CHA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D7,
 },
 [0x07D8]={
  category="lo",
  description="NKO LETTER DA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D8,
 },
 [0x07D9]={
  category="lo",
  description="NKO LETTER RA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07D9,
 },
 [0x07DA]={
  category="lo",
  description="NKO LETTER RRA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07DA,
 },
 [0x07DB]={
  category="lo",
  description="NKO LETTER SA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07DB,
 },
 [0x07DC]={
  category="lo",
  description="NKO LETTER GBA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07DC,
 },
 [0x07DD]={
  category="lo",
  description="NKO LETTER FA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07DD,
 },
 [0x07DE]={
  category="lo",
  description="NKO LETTER KA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07DE,
 },
 [0x07DF]={
  category="lo",
  description="NKO LETTER LA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07DF,
 },
 [0x07E0]={
  category="lo",
  description="NKO LETTER NA WOLOSO",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E0,
 },
 [0x07E1]={
  category="lo",
  description="NKO LETTER MA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E1,
 },
 [0x07E2]={
  category="lo",
  description="NKO LETTER NYA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E2,
 },
 [0x07E3]={
  category="lo",
  description="NKO LETTER NA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E3,
 },
 [0x07E4]={
  category="lo",
  description="NKO LETTER HA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E4,
 },
 [0x07E5]={
  category="lo",
  description="NKO LETTER WA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E5,
 },
 [0x07E6]={
  category="lo",
  description="NKO LETTER YA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E6,
 },
 [0x07E7]={
  category="lo",
  description="NKO LETTER NYA WOLOSO",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E7,
 },
 [0x07E8]={
  category="lo",
  description="NKO LETTER JONA JA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E8,
 },
 [0x07E9]={
  category="lo",
  description="NKO LETTER JONA CHA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07E9,
 },
 [0x07EA]={
  category="lo",
  description="NKO LETTER JONA RA",
  direction="r",
  linebreak="al",
  unicodeslot=0x07EA,
 },
 [0x07EB]={
  category="mn",
  description="NKO COMBINING SHORT HIGH TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07EB,
 },
 [0x07EC]={
  category="mn",
  description="NKO COMBINING SHORT LOW TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07EC,
 },
 [0x07ED]={
  category="mn",
  description="NKO COMBINING SHORT RISING TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07ED,
 },
 [0x07EE]={
  category="mn",
  description="NKO COMBINING LONG DESCENDING TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07EE,
 },
 [0x07EF]={
  category="mn",
  description="NKO COMBINING LONG HIGH TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07EF,
 },
 [0x07F0]={
  category="mn",
  description="NKO COMBINING LONG LOW TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07F0,
 },
 [0x07F1]={
  category="mn",
  description="NKO COMBINING LONG RISING TONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07F1,
 },
 [0x07F2]={
  category="mn",
  description="NKO COMBINING NASALIZATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07F2,
 },
 [0x07F3]={
  category="mn",
  description="NKO COMBINING DOUBLE DOT ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x07F3,
 },
 [0x07F4]={
  category="lm",
  description="NKO HIGH TONE APOSTROPHE",
  direction="r",
  linebreak="al",
  unicodeslot=0x07F4,
 },
 [0x07F5]={
  category="lm",
  description="NKO LOW TONE APOSTROPHE",
  direction="r",
  linebreak="al",
  unicodeslot=0x07F5,
 },
 [0x07F6]={
  category="so",
  description="NKO SYMBOL OO DENNEN",
  direction="on",
  linebreak="al",
  unicodeslot=0x07F6,
 },
 [0x07F7]={
  category="po",
  description="NKO SYMBOL GBAKURUNEN",
  direction="on",
  linebreak="al",
  unicodeslot=0x07F7,
 },
 [0x07F8]={
  category="po",
  description="NKO COMMA",
  direction="on",
  linebreak="is",
  unicodeslot=0x07F8,
 },
 [0x07F9]={
  category="po",
  description="NKO EXCLAMATION MARK",
  direction="on",
  linebreak="ex",
  unicodeslot=0x07F9,
 },
 [0x07FA]={
  category="lm",
  description="NKO LAJANYALAN",
  direction="r",
  linebreak="al",
  unicodeslot=0x07FA,
 },
 [0x0800]={
  category="lo",
  description="SAMARITAN LETTER ALAF",
  direction="r",
  linebreak="al",
  unicodeslot=0x0800,
 },
 [0x0801]={
  category="lo",
  description="SAMARITAN LETTER BIT",
  direction="r",
  linebreak="al",
  unicodeslot=0x0801,
 },
 [0x0802]={
  category="lo",
  description="SAMARITAN LETTER GAMAN",
  direction="r",
  linebreak="al",
  unicodeslot=0x0802,
 },
 [0x0803]={
  category="lo",
  description="SAMARITAN LETTER DALAT",
  direction="r",
  linebreak="al",
  unicodeslot=0x0803,
 },
 [0x0804]={
  category="lo",
  description="SAMARITAN LETTER IY",
  direction="r",
  linebreak="al",
  unicodeslot=0x0804,
 },
 [0x0805]={
  category="lo",
  description="SAMARITAN LETTER BAA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0805,
 },
 [0x0806]={
  category="lo",
  description="SAMARITAN LETTER ZEN",
  direction="r",
  linebreak="al",
  unicodeslot=0x0806,
 },
 [0x0807]={
  category="lo",
  description="SAMARITAN LETTER IT",
  direction="r",
  linebreak="al",
  unicodeslot=0x0807,
 },
 [0x0808]={
  category="lo",
  description="SAMARITAN LETTER TIT",
  direction="r",
  linebreak="al",
  unicodeslot=0x0808,
 },
 [0x0809]={
  category="lo",
  description="SAMARITAN LETTER YUT",
  direction="r",
  linebreak="al",
  unicodeslot=0x0809,
 },
 [0x080A]={
  category="lo",
  description="SAMARITAN LETTER KAAF",
  direction="r",
  linebreak="al",
  unicodeslot=0x080A,
 },
 [0x080B]={
  category="lo",
  description="SAMARITAN LETTER LABAT",
  direction="r",
  linebreak="al",
  unicodeslot=0x080B,
 },
 [0x080C]={
  category="lo",
  description="SAMARITAN LETTER MIM",
  direction="r",
  linebreak="al",
  unicodeslot=0x080C,
 },
 [0x080D]={
  category="lo",
  description="SAMARITAN LETTER NUN",
  direction="r",
  linebreak="al",
  unicodeslot=0x080D,
 },
 [0x080E]={
  category="lo",
  description="SAMARITAN LETTER SINGAAT",
  direction="r",
  linebreak="al",
  unicodeslot=0x080E,
 },
 [0x080F]={
  category="lo",
  description="SAMARITAN LETTER IN",
  direction="r",
  linebreak="al",
  unicodeslot=0x080F,
 },
 [0x0810]={
  category="lo",
  description="SAMARITAN LETTER FI",
  direction="r",
  linebreak="al",
  unicodeslot=0x0810,
 },
 [0x0811]={
  category="lo",
  description="SAMARITAN LETTER TSAADIY",
  direction="r",
  linebreak="al",
  unicodeslot=0x0811,
 },
 [0x0812]={
  category="lo",
  description="SAMARITAN LETTER QUF",
  direction="r",
  linebreak="al",
  unicodeslot=0x0812,
 },
 [0x0813]={
  category="lo",
  description="SAMARITAN LETTER RISH",
  direction="r",
  linebreak="al",
  unicodeslot=0x0813,
 },
 [0x0814]={
  category="lo",
  description="SAMARITAN LETTER SHAN",
  direction="r",
  linebreak="al",
  unicodeslot=0x0814,
 },
 [0x0815]={
  category="lo",
  description="SAMARITAN LETTER TAAF",
  direction="r",
  linebreak="al",
  unicodeslot=0x0815,
 },
 [0x0816]={
  category="mn",
  description="SAMARITAN MARK IN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0816,
 },
 [0x0817]={
  category="mn",
  description="SAMARITAN MARK IN-ALAF",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0817,
 },
 [0x0818]={
  category="mn",
  description="SAMARITAN MARK OCCLUSION",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0818,
 },
 [0x0819]={
  category="mn",
  description="SAMARITAN MARK DAGESH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0819,
 },
 [0x081A]={
  category="lm",
  description="SAMARITAN MODIFIER LETTER EPENTHETIC YUT",
  direction="r",
  linebreak="al",
  unicodeslot=0x081A,
 },
 [0x081B]={
  category="mn",
  description="SAMARITAN MARK EPENTHETIC YUT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x081B,
 },
 [0x081C]={
  category="mn",
  description="SAMARITAN VOWEL SIGN LONG E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x081C,
 },
 [0x081D]={
  category="mn",
  description="SAMARITAN VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x081D,
 },
 [0x081E]={
  category="mn",
  description="SAMARITAN VOWEL SIGN OVERLONG AA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x081E,
 },
 [0x081F]={
  category="mn",
  description="SAMARITAN VOWEL SIGN LONG AA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x081F,
 },
 [0x0820]={
  category="mn",
  description="SAMARITAN VOWEL SIGN AA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0820,
 },
 [0x0821]={
  category="mn",
  description="SAMARITAN VOWEL SIGN OVERLONG A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0821,
 },
 [0x0822]={
  category="mn",
  description="SAMARITAN VOWEL SIGN LONG A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0822,
 },
 [0x0823]={
  category="mn",
  description="SAMARITAN VOWEL SIGN A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0823,
 },
 [0x0824]={
  category="lm",
  description="SAMARITAN MODIFIER LETTER SHORT A",
  direction="r",
  linebreak="al",
  unicodeslot=0x0824,
 },
 [0x0825]={
  category="mn",
  description="SAMARITAN VOWEL SIGN SHORT A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0825,
 },
 [0x0826]={
  category="mn",
  description="SAMARITAN VOWEL SIGN LONG U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0826,
 },
 [0x0827]={
  category="mn",
  description="SAMARITAN VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0827,
 },
 [0x0828]={
  category="lm",
  description="SAMARITAN MODIFIER LETTER I",
  direction="r",
  linebreak="al",
  unicodeslot=0x0828,
 },
 [0x0829]={
  category="mn",
  description="SAMARITAN VOWEL SIGN LONG I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0829,
 },
 [0x082A]={
  category="mn",
  description="SAMARITAN VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x082A,
 },
 [0x082B]={
  category="mn",
  description="SAMARITAN VOWEL SIGN O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x082B,
 },
 [0x082C]={
  category="mn",
  description="SAMARITAN VOWEL SIGN SUKUN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x082C,
 },
 [0x082D]={
  category="mn",
  description="SAMARITAN MARK NEQUDAA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x082D,
 },
 [0x0830]={
  category="po",
  description="SAMARITAN PUNCTUATION NEQUDAA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0830,
 },
 [0x0831]={
  category="po",
  description="SAMARITAN PUNCTUATION AFSAAQ",
  direction="r",
  linebreak="al",
  unicodeslot=0x0831,
 },
 [0x0832]={
  category="po",
  description="SAMARITAN PUNCTUATION ANGED",
  direction="r",
  linebreak="al",
  unicodeslot=0x0832,
 },
 [0x0833]={
  category="po",
  description="SAMARITAN PUNCTUATION BAU",
  direction="r",
  linebreak="al",
  unicodeslot=0x0833,
 },
 [0x0834]={
  category="po",
  description="SAMARITAN PUNCTUATION ATMAAU",
  direction="r",
  linebreak="al",
  unicodeslot=0x0834,
 },
 [0x0835]={
  category="po",
  description="SAMARITAN PUNCTUATION SHIYYAALAA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0835,
 },
 [0x0836]={
  category="po",
  description="SAMARITAN ABBREVIATION MARK",
  direction="r",
  linebreak="al",
  unicodeslot=0x0836,
 },
 [0x0837]={
  category="po",
  description="SAMARITAN PUNCTUATION MELODIC QITSA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0837,
 },
 [0x0838]={
  category="po",
  description="SAMARITAN PUNCTUATION ZIQAA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0838,
 },
 [0x0839]={
  category="po",
  description="SAMARITAN PUNCTUATION QITSA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0839,
 },
 [0x083A]={
  category="po",
  description="SAMARITAN PUNCTUATION ZAEF",
  direction="r",
  linebreak="al",
  unicodeslot=0x083A,
 },
 [0x083B]={
  category="po",
  description="SAMARITAN PUNCTUATION TURU",
  direction="r",
  linebreak="al",
  unicodeslot=0x083B,
 },
 [0x083C]={
  category="po",
  description="SAMARITAN PUNCTUATION ARKAANU",
  direction="r",
  linebreak="al",
  unicodeslot=0x083C,
 },
 [0x083D]={
  category="po",
  description="SAMARITAN PUNCTUATION SOF MASHFAAT",
  direction="r",
  linebreak="al",
  unicodeslot=0x083D,
 },
 [0x083E]={
  category="po",
  description="SAMARITAN PUNCTUATION ANNAAU",
  direction="r",
  linebreak="al",
  unicodeslot=0x083E,
 },
 [0x0840]={
  category="lo",
  description="MANDAIC LETTER HALQA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0840,
 },
 [0x0841]={
  category="lo",
  description="MANDAIC LETTER AB",
  direction="r",
  linebreak="al",
  unicodeslot=0x0841,
 },
 [0x0842]={
  category="lo",
  description="MANDAIC LETTER AG",
  direction="r",
  linebreak="al",
  unicodeslot=0x0842,
 },
 [0x0843]={
  category="lo",
  description="MANDAIC LETTER AD",
  direction="r",
  linebreak="al",
  unicodeslot=0x0843,
 },
 [0x0844]={
  category="lo",
  description="MANDAIC LETTER AH",
  direction="r",
  linebreak="al",
  unicodeslot=0x0844,
 },
 [0x0845]={
  category="lo",
  description="MANDAIC LETTER USHENNA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0845,
 },
 [0x0846]={
  category="lo",
  description="MANDAIC LETTER AZ",
  direction="r",
  linebreak="al",
  unicodeslot=0x0846,
 },
 [0x0847]={
  category="lo",
  description="MANDAIC LETTER IT",
  direction="r",
  linebreak="al",
  unicodeslot=0x0847,
 },
 [0x0848]={
  category="lo",
  description="MANDAIC LETTER ATT",
  direction="r",
  linebreak="al",
  unicodeslot=0x0848,
 },
 [0x0849]={
  category="lo",
  description="MANDAIC LETTER AKSA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0849,
 },
 [0x084A]={
  category="lo",
  description="MANDAIC LETTER AK",
  direction="r",
  linebreak="al",
  unicodeslot=0x084A,
 },
 [0x084B]={
  category="lo",
  description="MANDAIC LETTER AL",
  direction="r",
  linebreak="al",
  unicodeslot=0x084B,
 },
 [0x084C]={
  category="lo",
  description="MANDAIC LETTER AM",
  direction="r",
  linebreak="al",
  unicodeslot=0x084C,
 },
 [0x084D]={
  category="lo",
  description="MANDAIC LETTER AN",
  direction="r",
  linebreak="al",
  unicodeslot=0x084D,
 },
 [0x084E]={
  category="lo",
  description="MANDAIC LETTER AS",
  direction="r",
  linebreak="al",
  unicodeslot=0x084E,
 },
 [0x084F]={
  category="lo",
  description="MANDAIC LETTER IN",
  direction="r",
  linebreak="al",
  unicodeslot=0x084F,
 },
 [0x0850]={
  category="lo",
  description="MANDAIC LETTER AP",
  direction="r",
  linebreak="al",
  unicodeslot=0x0850,
 },
 [0x0851]={
  category="lo",
  description="MANDAIC LETTER ASZ",
  direction="r",
  linebreak="al",
  unicodeslot=0x0851,
 },
 [0x0852]={
  category="lo",
  description="MANDAIC LETTER AQ",
  direction="r",
  linebreak="al",
  unicodeslot=0x0852,
 },
 [0x0853]={
  category="lo",
  description="MANDAIC LETTER AR",
  direction="r",
  linebreak="al",
  unicodeslot=0x0853,
 },
 [0x0854]={
  category="lo",
  description="MANDAIC LETTER ASH",
  direction="r",
  linebreak="al",
  unicodeslot=0x0854,
 },
 [0x0855]={
  category="lo",
  description="MANDAIC LETTER AT",
  direction="r",
  linebreak="al",
  unicodeslot=0x0855,
 },
 [0x0856]={
  category="lo",
  description="MANDAIC LETTER DUSHENNA",
  direction="r",
  linebreak="al",
  unicodeslot=0x0856,
 },
 [0x0857]={
  category="lo",
  description="MANDAIC LETTER KAD",
  direction="r",
  linebreak="al",
  unicodeslot=0x0857,
 },
 [0x0858]={
  category="lo",
  description="MANDAIC LETTER AIN",
  direction="r",
  linebreak="al",
  unicodeslot=0x0858,
 },
 [0x0859]={
  category="mn",
  description="MANDAIC AFFRICATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0859,
 },
 [0x085A]={
  category="mn",
  description="MANDAIC VOCALIZATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x085A,
 },
 [0x085B]={
  category="mn",
  description="MANDAIC GEMINATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x085B,
 },
 [0x085E]={
  category="po",
  description="MANDAIC PUNCTUATION",
  direction="r",
  linebreak="al",
  unicodeslot=0x085E,
 },
 [0x0900]={
  category="mn",
  description="DEVANAGARI SIGN INVERTED CANDRABINDU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0900,
 },
 [0x0901]={
  adobename="candrabindudeva",
  category="mn",
  description="DEVANAGARI SIGN CANDRABINDU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0901,
 },
 [0x0902]={
  adobename="anusvaradeva",
  category="mn",
  description="DEVANAGARI SIGN ANUSVARA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0902,
 },
 [0x0903]={
  adobename="visargadeva",
  category="mc",
  description="DEVANAGARI SIGN VISARGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0903,
 },
 [0x0904]={
  category="lo",
  description="DEVANAGARI LETTER SHORT A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0904,
 },
 [0x0905]={
  adobename="adeva",
  category="lo",
  description="DEVANAGARI LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0905,
 },
 [0x0906]={
  adobename="aadeva",
  category="lo",
  description="DEVANAGARI LETTER AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0906,
 },
 [0x0907]={
  adobename="ideva",
  category="lo",
  description="DEVANAGARI LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x0907,
 },
 [0x0908]={
  adobename="iideva",
  category="lo",
  description="DEVANAGARI LETTER II",
  direction="l",
  linebreak="al",
  unicodeslot=0x0908,
 },
 [0x0909]={
  adobename="udeva",
  category="lo",
  description="DEVANAGARI LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0909,
 },
 [0x090A]={
  adobename="uudeva",
  category="lo",
  description="DEVANAGARI LETTER UU",
  direction="l",
  linebreak="al",
  unicodeslot=0x090A,
 },
 [0x090B]={
  adobename="rvocalicdeva",
  category="lo",
  description="DEVANAGARI LETTER VOCALIC R",
  direction="l",
  linebreak="al",
  unicodeslot=0x090B,
 },
 [0x090C]={
  adobename="lvocalicdeva",
  category="lo",
  description="DEVANAGARI LETTER VOCALIC L",
  direction="l",
  linebreak="al",
  unicodeslot=0x090C,
 },
 [0x090D]={
  adobename="ecandradeva",
  category="lo",
  description="DEVANAGARI LETTER CANDRA E",
  direction="l",
  linebreak="al",
  unicodeslot=0x090D,
 },
 [0x090E]={
  adobename="eshortdeva",
  category="lo",
  description="DEVANAGARI LETTER SHORT E",
  direction="l",
  linebreak="al",
  unicodeslot=0x090E,
 },
 [0x090F]={
  adobename="edeva",
  category="lo",
  description="DEVANAGARI LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x090F,
 },
 [0x0910]={
  adobename="aideva",
  category="lo",
  description="DEVANAGARI LETTER AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0910,
 },
 [0x0911]={
  adobename="ocandradeva",
  category="lo",
  description="DEVANAGARI LETTER CANDRA O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0911,
 },
 [0x0912]={
  adobename="oshortdeva",
  category="lo",
  description="DEVANAGARI LETTER SHORT O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0912,
 },
 [0x0913]={
  adobename="odeva",
  category="lo",
  description="DEVANAGARI LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0913,
 },
 [0x0914]={
  adobename="audeva",
  category="lo",
  description="DEVANAGARI LETTER AU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0914,
 },
 [0x0915]={
  adobename="kadeva",
  category="lo",
  description="DEVANAGARI LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0915,
 },
 [0x0916]={
  adobename="khadeva",
  category="lo",
  description="DEVANAGARI LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0916,
 },
 [0x0917]={
  adobename="gadeva",
  category="lo",
  description="DEVANAGARI LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0917,
 },
 [0x0918]={
  adobename="ghadeva",
  category="lo",
  description="DEVANAGARI LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0918,
 },
 [0x0919]={
  adobename="ngadeva",
  category="lo",
  description="DEVANAGARI LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0919,
 },
 [0x091A]={
  adobename="cadeva",
  category="lo",
  description="DEVANAGARI LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x091A,
 },
 [0x091B]={
  adobename="chadeva",
  category="lo",
  description="DEVANAGARI LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x091B,
 },
 [0x091C]={
  adobename="jadeva",
  category="lo",
  description="DEVANAGARI LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x091C,
 },
 [0x091D]={
  adobename="jhadeva",
  category="lo",
  description="DEVANAGARI LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x091D,
 },
 [0x091E]={
  adobename="nyadeva",
  category="lo",
  description="DEVANAGARI LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x091E,
 },
 [0x091F]={
  adobename="ttadeva",
  category="lo",
  description="DEVANAGARI LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x091F,
 },
 [0x0920]={
  adobename="tthadeva",
  category="lo",
  description="DEVANAGARI LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0920,
 },
 [0x0921]={
  adobename="ddadeva",
  category="lo",
  description="DEVANAGARI LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0921,
 },
 [0x0922]={
  adobename="ddhadeva",
  category="lo",
  description="DEVANAGARI LETTER DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0922,
 },
 [0x0923]={
  adobename="nnadeva",
  category="lo",
  description="DEVANAGARI LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0923,
 },
 [0x0924]={
  adobename="tadeva",
  category="lo",
  description="DEVANAGARI LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0924,
 },
 [0x0925]={
  adobename="thadeva",
  category="lo",
  description="DEVANAGARI LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0925,
 },
 [0x0926]={
  adobename="dadeva",
  category="lo",
  description="DEVANAGARI LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0926,
 },
 [0x0927]={
  adobename="dhadeva",
  category="lo",
  description="DEVANAGARI LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0927,
 },
 [0x0928]={
  adobename="nadeva",
  category="lo",
  description="DEVANAGARI LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0928,
 },
 [0x0929]={
  adobename="nnnadeva",
  category="lo",
  description="DEVANAGARI LETTER NNNA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0928, 0x093C },
  unicodeslot=0x0929,
 },
 [0x092A]={
  adobename="padeva",
  category="lo",
  description="DEVANAGARI LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x092A,
 },
 [0x092B]={
  adobename="phadeva",
  category="lo",
  description="DEVANAGARI LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x092B,
 },
 [0x092C]={
  adobename="badeva",
  category="lo",
  description="DEVANAGARI LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x092C,
 },
 [0x092D]={
  adobename="bhadeva",
  category="lo",
  description="DEVANAGARI LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x092D,
 },
 [0x092E]={
  adobename="madeva",
  category="lo",
  description="DEVANAGARI LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x092E,
 },
 [0x092F]={
  adobename="yadeva",
  category="lo",
  description="DEVANAGARI LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x092F,
 },
 [0x0930]={
  adobename="radeva",
  category="lo",
  description="DEVANAGARI LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0930,
 },
 [0x0931]={
  adobename="rradeva",
  category="lo",
  description="DEVANAGARI LETTER RRA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0930, 0x093C },
  unicodeslot=0x0931,
 },
 [0x0932]={
  adobename="ladeva",
  category="lo",
  description="DEVANAGARI LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0932,
 },
 [0x0933]={
  adobename="lladeva",
  category="lo",
  description="DEVANAGARI LETTER LLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0933,
 },
 [0x0934]={
  adobename="llladeva",
  category="lo",
  description="DEVANAGARI LETTER LLLA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0933, 0x093C },
  unicodeslot=0x0934,
 },
 [0x0935]={
  adobename="vadeva",
  category="lo",
  description="DEVANAGARI LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0935,
 },
 [0x0936]={
  adobename="shadeva",
  category="lo",
  description="DEVANAGARI LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0936,
 },
 [0x0937]={
  adobename="ssadeva",
  category="lo",
  description="DEVANAGARI LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0937,
 },
 [0x0938]={
  adobename="sadeva",
  category="lo",
  description="DEVANAGARI LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0938,
 },
 [0x0939]={
  adobename="hadeva",
  category="lo",
  description="DEVANAGARI LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0939,
 },
 [0x093A]={
  category="mn",
  description="DEVANAGARI VOWEL SIGN OE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x093A,
 },
 [0x093B]={
  category="mc",
  description="DEVANAGARI VOWEL SIGN OOE",
  direction="l",
  linebreak="cm",
  unicodeslot=0x093B,
 },
 [0x093C]={
  adobename="nuktadeva",
  category="mn",
  description="DEVANAGARI SIGN NUKTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x093C,
 },
 [0x093D]={
  adobename="avagrahadeva",
  category="lo",
  description="DEVANAGARI SIGN AVAGRAHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x093D,
 },
 [0x093E]={
  adobename="aavowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x093E,
 },
 [0x093F]={
  adobename="ivowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x093F,
 },
 [0x0940]={
  adobename="iivowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN II",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0940,
 },
 [0x0941]={
  adobename="uvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0941,
 },
 [0x0942]={
  adobename="uuvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN UU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0942,
 },
 [0x0943]={
  adobename="rvocalicvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN VOCALIC R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0943,
 },
 [0x0944]={
  adobename="rrvocalicvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN VOCALIC RR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0944,
 },
 [0x0945]={
  adobename="ecandravowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN CANDRA E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0945,
 },
 [0x0946]={
  adobename="eshortvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN SHORT E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0946,
 },
 [0x0947]={
  adobename="evowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0947,
 },
 [0x0948]={
  adobename="aivowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN AI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0948,
 },
 [0x0949]={
  adobename="ocandravowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN CANDRA O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0949,
 },
 [0x094A]={
  adobename="oshortvowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN SHORT O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x094A,
 },
 [0x094B]={
  adobename="ovowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x094B,
 },
 [0x094C]={
  adobename="auvowelsigndeva",
  category="mc",
  description="DEVANAGARI VOWEL SIGN AU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x094C,
 },
 [0x094D]={
  adobename="viramadeva",
  category="mn",
  description="DEVANAGARI SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x094D,
 },
 [0x094E]={
  category="mc",
  description="DEVANAGARI VOWEL SIGN PRISHTHAMATRA E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x094E,
 },
 [0x094F]={
  category="mc",
  description="DEVANAGARI VOWEL SIGN AW",
  direction="l",
  linebreak="cm",
  unicodeslot=0x094F,
 },
 [0x0950]={
  adobename="omdeva",
  category="lo",
  description="DEVANAGARI OM",
  direction="l",
  linebreak="al",
  unicodeslot=0x0950,
 },
 [0x0951]={
  adobename="udattadeva",
  category="mn",
  description="DEVANAGARI STRESS SIGN UDATTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0951,
 },
 [0x0952]={
  adobename="anudattadeva",
  category="mn",
  description="DEVANAGARI STRESS SIGN ANUDATTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0952,
 },
 [0x0953]={
  adobename="gravedeva",
  category="mn",
  description="DEVANAGARI GRAVE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0953,
 },
 [0x0954]={
  adobename="acutedeva",
  category="mn",
  description="DEVANAGARI ACUTE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0954,
 },
 [0x0955]={
  category="mn",
  description="DEVANAGARI VOWEL SIGN CANDRA LONG E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0955,
 },
 [0x0956]={
  category="mn",
  description="DEVANAGARI VOWEL SIGN UE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0956,
 },
 [0x0957]={
  category="mn",
  description="DEVANAGARI VOWEL SIGN UUE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0957,
 },
 [0x0958]={
  adobename="qadeva",
  category="lo",
  description="DEVANAGARI LETTER QA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0915, 0x093C },
  unicodeslot=0x0958,
 },
 [0x0959]={
  adobename="khhadeva",
  category="lo",
  description="DEVANAGARI LETTER KHHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0916, 0x093C },
  unicodeslot=0x0959,
 },
 [0x095A]={
  adobename="ghhadeva",
  category="lo",
  description="DEVANAGARI LETTER GHHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0917, 0x093C },
  unicodeslot=0x095A,
 },
 [0x095B]={
  adobename="zadeva",
  category="lo",
  description="DEVANAGARI LETTER ZA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x091C, 0x093C },
  unicodeslot=0x095B,
 },
 [0x095C]={
  adobename="dddhadeva",
  category="lo",
  description="DEVANAGARI LETTER DDDHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0921, 0x093C },
  unicodeslot=0x095C,
 },
 [0x095D]={
  adobename="rhadeva",
  category="lo",
  description="DEVANAGARI LETTER RHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0922, 0x093C },
  unicodeslot=0x095D,
 },
 [0x095E]={
  adobename="fadeva",
  category="lo",
  description="DEVANAGARI LETTER FA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x092B, 0x093C },
  unicodeslot=0x095E,
 },
 [0x095F]={
  adobename="yyadeva",
  category="lo",
  description="DEVANAGARI LETTER YYA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x092F, 0x093C },
  unicodeslot=0x095F,
 },
 [0x0960]={
  adobename="rrvocalicdeva",
  category="lo",
  description="DEVANAGARI LETTER VOCALIC RR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0960,
 },
 [0x0961]={
  adobename="llvocalicdeva",
  category="lo",
  description="DEVANAGARI LETTER VOCALIC LL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0961,
 },
 [0x0962]={
  adobename="lvocalicvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0962,
 },
 [0x0963]={
  adobename="llvocalicvowelsigndeva",
  category="mn",
  description="DEVANAGARI VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0963,
 },
 [0x0964]={
  adobename="danda",
  category="po",
  description="DEVANAGARI DANDA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0964,
 },
 [0x0965]={
  adobename="dbldanda",
  category="po",
  description="DEVANAGARI DOUBLE DANDA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0965,
 },
 [0x0966]={
  adobename="zerodeva",
  category="nd",
  description="DEVANAGARI DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0966,
 },
 [0x0967]={
  adobename="onedeva",
  category="nd",
  description="DEVANAGARI DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0967,
 },
 [0x0968]={
  adobename="twodeva",
  category="nd",
  description="DEVANAGARI DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0968,
 },
 [0x0969]={
  adobename="threedeva",
  category="nd",
  description="DEVANAGARI DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0969,
 },
 [0x096A]={
  adobename="fourdeva",
  category="nd",
  description="DEVANAGARI DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x096A,
 },
 [0x096B]={
  adobename="fivedeva",
  category="nd",
  description="DEVANAGARI DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x096B,
 },
 [0x096C]={
  adobename="sixdeva",
  category="nd",
  description="DEVANAGARI DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x096C,
 },
 [0x096D]={
  adobename="sevendeva",
  category="nd",
  description="DEVANAGARI DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x096D,
 },
 [0x096E]={
  adobename="eightdeva",
  category="nd",
  description="DEVANAGARI DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x096E,
 },
 [0x096F]={
  adobename="ninedeva",
  category="nd",
  description="DEVANAGARI DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x096F,
 },
 [0x0970]={
  adobename="abbreviationsigndeva",
  category="po",
  description="DEVANAGARI ABBREVIATION SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0970,
 },
 [0x0971]={
  category="lm",
  description="DEVANAGARI SIGN HIGH SPACING DOT",
  direction="l",
  linebreak="al",
  unicodeslot=0x0971,
 },
 [0x0972]={
  category="lo",
  description="DEVANAGARI LETTER CANDRA A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0972,
 },
 [0x0973]={
  category="lo",
  description="DEVANAGARI LETTER OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0973,
 },
 [0x0974]={
  category="lo",
  description="DEVANAGARI LETTER OOE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0974,
 },
 [0x0975]={
  category="lo",
  description="DEVANAGARI LETTER AW",
  direction="l",
  linebreak="al",
  unicodeslot=0x0975,
 },
 [0x0976]={
  category="lo",
  description="DEVANAGARI LETTER UE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0976,
 },
 [0x0977]={
  category="lo",
  description="DEVANAGARI LETTER UUE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0977,
 },
 [0x0979]={
  category="lo",
  description="DEVANAGARI LETTER ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0979,
 },
 [0x097A]={
  category="lo",
  description="DEVANAGARI LETTER HEAVY YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x097A,
 },
 [0x097B]={
  category="lo",
  description="DEVANAGARI LETTER GGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x097B,
 },
 [0x097C]={
  category="lo",
  description="DEVANAGARI LETTER JJA",
  direction="l",
  linebreak="al",
  unicodeslot=0x097C,
 },
 [0x097D]={
  category="lo",
  description="DEVANAGARI LETTER GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x097D,
 },
 [0x097E]={
  category="lo",
  description="DEVANAGARI LETTER DDDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x097E,
 },
 [0x097F]={
  category="lo",
  description="DEVANAGARI LETTER BBA",
  direction="l",
  linebreak="al",
  unicodeslot=0x097F,
 },
 [0x0981]={
  adobename="candrabindubengali",
  category="mn",
  description="BENGALI SIGN CANDRABINDU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0981,
 },
 [0x0982]={
  adobename="anusvarabengali",
  category="mc",
  description="BENGALI SIGN ANUSVARA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0982,
 },
 [0x0983]={
  adobename="visargabengali",
  category="mc",
  description="BENGALI SIGN VISARGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0983,
 },
 [0x0985]={
  adobename="abengali",
  category="lo",
  description="BENGALI LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0985,
 },
 [0x0986]={
  adobename="aabengali",
  category="lo",
  description="BENGALI LETTER AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0986,
 },
 [0x0987]={
  adobename="ibengali",
  category="lo",
  description="BENGALI LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x0987,
 },
 [0x0988]={
  adobename="iibengali",
  category="lo",
  description="BENGALI LETTER II",
  direction="l",
  linebreak="al",
  unicodeslot=0x0988,
 },
 [0x0989]={
  adobename="ubengali",
  category="lo",
  description="BENGALI LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0989,
 },
 [0x098A]={
  adobename="uubengali",
  category="lo",
  description="BENGALI LETTER UU",
  direction="l",
  linebreak="al",
  unicodeslot=0x098A,
 },
 [0x098B]={
  adobename="rvocalicbengali",
  category="lo",
  description="BENGALI LETTER VOCALIC R",
  direction="l",
  linebreak="al",
  unicodeslot=0x098B,
 },
 [0x098C]={
  adobename="lvocalicbengali",
  category="lo",
  description="BENGALI LETTER VOCALIC L",
  direction="l",
  linebreak="al",
  unicodeslot=0x098C,
 },
 [0x098F]={
  adobename="ebengali",
  category="lo",
  description="BENGALI LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x098F,
 },
 [0x0990]={
  adobename="aibengali",
  category="lo",
  description="BENGALI LETTER AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0990,
 },
 [0x0993]={
  adobename="obengali",
  category="lo",
  description="BENGALI LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0993,
 },
 [0x0994]={
  adobename="aubengali",
  category="lo",
  description="BENGALI LETTER AU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0994,
 },
 [0x0995]={
  adobename="kabengali",
  category="lo",
  description="BENGALI LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0995,
 },
 [0x0996]={
  adobename="khabengali",
  category="lo",
  description="BENGALI LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0996,
 },
 [0x0997]={
  adobename="gabengali",
  category="lo",
  description="BENGALI LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0997,
 },
 [0x0998]={
  adobename="ghabengali",
  category="lo",
  description="BENGALI LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0998,
 },
 [0x0999]={
  adobename="ngabengali",
  category="lo",
  description="BENGALI LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0999,
 },
 [0x099A]={
  adobename="cabengali",
  category="lo",
  description="BENGALI LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x099A,
 },
 [0x099B]={
  adobename="chabengali",
  category="lo",
  description="BENGALI LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x099B,
 },
 [0x099C]={
  adobename="jabengali",
  category="lo",
  description="BENGALI LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x099C,
 },
 [0x099D]={
  adobename="jhabengali",
  category="lo",
  description="BENGALI LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x099D,
 },
 [0x099E]={
  adobename="nyabengali",
  category="lo",
  description="BENGALI LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x099E,
 },
 [0x099F]={
  adobename="ttabengali",
  category="lo",
  description="BENGALI LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x099F,
 },
 [0x09A0]={
  adobename="tthabengali",
  category="lo",
  description="BENGALI LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09A0,
 },
 [0x09A1]={
  adobename="ddabengali",
  category="lo",
  description="BENGALI LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09A1,
 },
 [0x09A2]={
  adobename="ddhabengali",
  category="lo",
  description="BENGALI LETTER DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09A2,
 },
 [0x09A3]={
  adobename="nnabengali",
  category="lo",
  description="BENGALI LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09A3,
 },
 [0x09A4]={
  adobename="tabengali",
  category="lo",
  description="BENGALI LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09A4,
 },
 [0x09A5]={
  adobename="thabengali",
  category="lo",
  description="BENGALI LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09A5,
 },
 [0x09A6]={
  adobename="dabengali",
  category="lo",
  description="BENGALI LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09A6,
 },
 [0x09A7]={
  adobename="dhabengali",
  category="lo",
  description="BENGALI LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09A7,
 },
 [0x09A8]={
  adobename="nabengali",
  category="lo",
  description="BENGALI LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09A8,
 },
 [0x09AA]={
  adobename="pabengali",
  category="lo",
  description="BENGALI LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09AA,
 },
 [0x09AB]={
  adobename="phabengali",
  category="lo",
  description="BENGALI LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09AB,
 },
 [0x09AC]={
  adobename="babengali",
  category="lo",
  description="BENGALI LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09AC,
 },
 [0x09AD]={
  adobename="bhabengali",
  category="lo",
  description="BENGALI LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09AD,
 },
 [0x09AE]={
  adobename="mabengali",
  category="lo",
  description="BENGALI LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09AE,
 },
 [0x09AF]={
  adobename="yabengali",
  category="lo",
  description="BENGALI LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09AF,
 },
 [0x09B0]={
  adobename="rabengali",
  category="lo",
  description="BENGALI LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09B0,
 },
 [0x09B2]={
  adobename="labengali",
  category="lo",
  description="BENGALI LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09B2,
 },
 [0x09B6]={
  adobename="shabengali",
  category="lo",
  description="BENGALI LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09B6,
 },
 [0x09B7]={
  adobename="ssabengali",
  category="lo",
  description="BENGALI LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09B7,
 },
 [0x09B8]={
  adobename="sabengali",
  category="lo",
  description="BENGALI LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09B8,
 },
 [0x09B9]={
  adobename="habengali",
  category="lo",
  description="BENGALI LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09B9,
 },
 [0x09BC]={
  adobename="nuktabengali",
  category="mn",
  description="BENGALI SIGN NUKTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x09BC,
 },
 [0x09BD]={
  category="lo",
  description="BENGALI SIGN AVAGRAHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09BD,
 },
 [0x09BE]={
  adobename="aavowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x09BE,
 },
 [0x09BF]={
  adobename="ivowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x09BF,
 },
 [0x09C0]={
  adobename="iivowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN II",
  direction="l",
  linebreak="cm",
  unicodeslot=0x09C0,
 },
 [0x09C1]={
  adobename="uvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x09C1,
 },
 [0x09C2]={
  adobename="uuvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN UU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x09C2,
 },
 [0x09C3]={
  adobename="rvocalicvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN VOCALIC R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x09C3,
 },
 [0x09C4]={
  adobename="rrvocalicvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN VOCALIC RR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x09C4,
 },
 [0x09C7]={
  adobename="evowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x09C7,
 },
 [0x09C8]={
  adobename="aivowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN AI",
  direction="l",
  linebreak="cm",
  unicodeslot=0x09C8,
 },
 [0x09CB]={
  adobename="ovowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x09C7, 0x09BE },
  unicodeslot=0x09CB,
 },
 [0x09CC]={
  adobename="auvowelsignbengali",
  category="mc",
  description="BENGALI VOWEL SIGN AU",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x09C7, 0x09D7 },
  unicodeslot=0x09CC,
 },
 [0x09CD]={
  adobename="viramabengali",
  category="mn",
  description="BENGALI SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x09CD,
 },
 [0x09CE]={
  category="lo",
  description="BENGALI LETTER KHANDA TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x09CE,
 },
 [0x09D7]={
  adobename="aulengthmarkbengali",
  category="mc",
  description="BENGALI AU LENGTH MARK",
  direction="l",
  linebreak="cm",
  unicodeslot=0x09D7,
 },
 [0x09DC]={
  adobename="rrabengali",
  category="lo",
  description="BENGALI LETTER RRA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x09A1, 0x09BC },
  unicodeslot=0x09DC,
 },
 [0x09DD]={
  adobename="rhabengali",
  category="lo",
  description="BENGALI LETTER RHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x09A2, 0x09BC },
  unicodeslot=0x09DD,
 },
 [0x09DF]={
  adobename="yyabengali",
  category="lo",
  description="BENGALI LETTER YYA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x09AF, 0x09BC },
  unicodeslot=0x09DF,
 },
 [0x09E0]={
  adobename="rrvocalicbengali",
  category="lo",
  description="BENGALI LETTER VOCALIC RR",
  direction="l",
  linebreak="al",
  unicodeslot=0x09E0,
 },
 [0x09E1]={
  adobename="llvocalicbengali",
  category="lo",
  description="BENGALI LETTER VOCALIC LL",
  direction="l",
  linebreak="al",
  unicodeslot=0x09E1,
 },
 [0x09E2]={
  adobename="lvocalicvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x09E2,
 },
 [0x09E3]={
  adobename="llvocalicvowelsignbengali",
  category="mn",
  description="BENGALI VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x09E3,
 },
 [0x09E6]={
  adobename="zerobengali",
  category="nd",
  description="BENGALI DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09E6,
 },
 [0x09E7]={
  adobename="onebengali",
  category="nd",
  description="BENGALI DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09E7,
 },
 [0x09E8]={
  adobename="twobengali",
  category="nd",
  description="BENGALI DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09E8,
 },
 [0x09E9]={
  adobename="threebengali",
  category="nd",
  description="BENGALI DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09E9,
 },
 [0x09EA]={
  adobename="fourbengali",
  category="nd",
  description="BENGALI DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09EA,
 },
 [0x09EB]={
  adobename="fivebengali",
  category="nd",
  description="BENGALI DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09EB,
 },
 [0x09EC]={
  adobename="sixbengali",
  category="nd",
  description="BENGALI DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09EC,
 },
 [0x09ED]={
  adobename="sevenbengali",
  category="nd",
  description="BENGALI DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09ED,
 },
 [0x09EE]={
  adobename="eightbengali",
  category="nd",
  description="BENGALI DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09EE,
 },
 [0x09EF]={
  adobename="ninebengali",
  category="nd",
  description="BENGALI DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x09EF,
 },
 [0x09F0]={
  adobename="ramiddlediagonalbengali",
  category="lo",
  description="BENGALI LETTER RA WITH MIDDLE DIAGONAL",
  direction="l",
  linebreak="al",
  shcode=0x09B0,
  unicodeslot=0x09F0,
 },
 [0x09F1]={
  adobename="ralowerdiagonalbengali",
  category="lo",
  description="BENGALI LETTER RA WITH LOWER DIAGONAL",
  direction="l",
  linebreak="al",
  shcode=0x09B0,
  unicodeslot=0x09F1,
 },
 [0x09F2]={
  adobename="rupeemarkbengali",
  category="sc",
  description="BENGALI RUPEE MARK",
  direction="et",
  linebreak="po",
  unicodeslot=0x09F2,
 },
 [0x09F3]={
  adobename="rupeesignbengali",
  category="sc",
  description="BENGALI RUPEE SIGN",
  direction="et",
  linebreak="po",
  unicodeslot=0x09F3,
 },
 [0x09F4]={
  adobename="onenumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR ONE",
  direction="l",
  linebreak="al",
  unicodeslot=0x09F4,
 },
 [0x09F5]={
  adobename="twonumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR TWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x09F5,
 },
 [0x09F6]={
  adobename="threenumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR THREE",
  direction="l",
  linebreak="al",
  unicodeslot=0x09F6,
 },
 [0x09F7]={
  adobename="fournumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR FOUR",
  direction="l",
  linebreak="al",
  unicodeslot=0x09F7,
 },
 [0x09F8]={
  adobename="denominatorminusonenumeratorbengali",
  category="no",
  description="BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR",
  direction="l",
  linebreak="al",
  unicodeslot=0x09F8,
 },
 [0x09F9]={
  adobename="sixteencurrencydenominatorbengali",
  category="no",
  description="BENGALI CURRENCY DENOMINATOR SIXTEEN",
  direction="l",
  linebreak="po",
  unicodeslot=0x09F9,
 },
 [0x09FA]={
  adobename="issharbengali",
  category="so",
  description="BENGALI ISSHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x09FA,
 },
 [0x09FB]={
  category="sc",
  description="BENGALI GANDA MARK",
  direction="et",
  linebreak="pr",
  unicodeslot=0x09FB,
 },
 [0x0A01]={
  category="mn",
  description="GURMUKHI SIGN ADAK BINDI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A01,
 },
 [0x0A02]={
  adobename="bindigurmukhi",
  category="mn",
  description="GURMUKHI SIGN BINDI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A02,
 },
 [0x0A03]={
  category="mc",
  description="GURMUKHI SIGN VISARGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0A03,
 },
 [0x0A05]={
  adobename="agurmukhi",
  category="lo",
  description="GURMUKHI LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A05,
 },
 [0x0A06]={
  adobename="aagurmukhi",
  category="lo",
  description="GURMUKHI LETTER AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A06,
 },
 [0x0A07]={
  adobename="igurmukhi",
  category="lo",
  description="GURMUKHI LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A07,
 },
 [0x0A08]={
  adobename="iigurmukhi",
  category="lo",
  description="GURMUKHI LETTER II",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A08,
 },
 [0x0A09]={
  adobename="ugurmukhi",
  category="lo",
  description="GURMUKHI LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A09,
 },
 [0x0A0A]={
  adobename="uugurmukhi",
  category="lo",
  description="GURMUKHI LETTER UU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A0A,
 },
 [0x0A0F]={
  adobename="eegurmukhi",
  category="lo",
  description="GURMUKHI LETTER EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A0F,
 },
 [0x0A10]={
  adobename="aigurmukhi",
  category="lo",
  description="GURMUKHI LETTER AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A10,
 },
 [0x0A13]={
  adobename="oogurmukhi",
  category="lo",
  description="GURMUKHI LETTER OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A13,
 },
 [0x0A14]={
  adobename="augurmukhi",
  category="lo",
  description="GURMUKHI LETTER AU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A14,
 },
 [0x0A15]={
  adobename="kagurmukhi",
  category="lo",
  description="GURMUKHI LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A15,
 },
 [0x0A16]={
  adobename="khagurmukhi",
  category="lo",
  description="GURMUKHI LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A16,
 },
 [0x0A17]={
  adobename="gagurmukhi",
  category="lo",
  description="GURMUKHI LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A17,
 },
 [0x0A18]={
  adobename="ghagurmukhi",
  category="lo",
  description="GURMUKHI LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A18,
 },
 [0x0A19]={
  adobename="ngagurmukhi",
  category="lo",
  description="GURMUKHI LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A19,
 },
 [0x0A1A]={
  adobename="cagurmukhi",
  category="lo",
  description="GURMUKHI LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A1A,
 },
 [0x0A1B]={
  adobename="chagurmukhi",
  category="lo",
  description="GURMUKHI LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A1B,
 },
 [0x0A1C]={
  adobename="jagurmukhi",
  category="lo",
  description="GURMUKHI LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A1C,
 },
 [0x0A1D]={
  adobename="jhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A1D,
 },
 [0x0A1E]={
  adobename="nyagurmukhi",
  category="lo",
  description="GURMUKHI LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A1E,
 },
 [0x0A1F]={
  adobename="ttagurmukhi",
  category="lo",
  description="GURMUKHI LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A1F,
 },
 [0x0A20]={
  adobename="tthagurmukhi",
  category="lo",
  description="GURMUKHI LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A20,
 },
 [0x0A21]={
  adobename="ddagurmukhi",
  category="lo",
  description="GURMUKHI LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A21,
 },
 [0x0A22]={
  adobename="ddhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A22,
 },
 [0x0A23]={
  adobename="nnagurmukhi",
  category="lo",
  description="GURMUKHI LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A23,
 },
 [0x0A24]={
  adobename="tagurmukhi",
  category="lo",
  description="GURMUKHI LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A24,
 },
 [0x0A25]={
  adobename="thagurmukhi",
  category="lo",
  description="GURMUKHI LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A25,
 },
 [0x0A26]={
  adobename="dagurmukhi",
  category="lo",
  description="GURMUKHI LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A26,
 },
 [0x0A27]={
  adobename="dhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A27,
 },
 [0x0A28]={
  adobename="nagurmukhi",
  category="lo",
  description="GURMUKHI LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A28,
 },
 [0x0A2A]={
  adobename="pagurmukhi",
  category="lo",
  description="GURMUKHI LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A2A,
 },
 [0x0A2B]={
  adobename="phagurmukhi",
  category="lo",
  description="GURMUKHI LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A2B,
 },
 [0x0A2C]={
  adobename="bagurmukhi",
  category="lo",
  description="GURMUKHI LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A2C,
 },
 [0x0A2D]={
  adobename="bhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A2D,
 },
 [0x0A2E]={
  adobename="magurmukhi",
  category="lo",
  description="GURMUKHI LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A2E,
 },
 [0x0A2F]={
  adobename="yagurmukhi",
  category="lo",
  description="GURMUKHI LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A2F,
 },
 [0x0A30]={
  adobename="ragurmukhi",
  category="lo",
  description="GURMUKHI LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A30,
 },
 [0x0A32]={
  adobename="lagurmukhi",
  category="lo",
  description="GURMUKHI LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A32,
 },
 [0x0A33]={
  category="lo",
  description="GURMUKHI LETTER LLA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0A32, 0x0A3C },
  unicodeslot=0x0A33,
 },
 [0x0A35]={
  adobename="vagurmukhi",
  category="lo",
  description="GURMUKHI LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A35,
 },
 [0x0A36]={
  adobename="shagurmukhi",
  category="lo",
  description="GURMUKHI LETTER SHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0A38, 0x0A3C },
  unicodeslot=0x0A36,
 },
 [0x0A38]={
  adobename="sagurmukhi",
  category="lo",
  description="GURMUKHI LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A38,
 },
 [0x0A39]={
  adobename="hagurmukhi",
  category="lo",
  description="GURMUKHI LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A39,
 },
 [0x0A3C]={
  adobename="nuktagurmukhi",
  category="mn",
  description="GURMUKHI SIGN NUKTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A3C,
 },
 [0x0A3E]={
  adobename="aamatragurmukhi",
  category="mc",
  description="GURMUKHI VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0A3E,
 },
 [0x0A3F]={
  adobename="imatragurmukhi",
  category="mc",
  description="GURMUKHI VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0A3F,
 },
 [0x0A40]={
  adobename="iimatragurmukhi",
  category="mc",
  description="GURMUKHI VOWEL SIGN II",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0A40,
 },
 [0x0A41]={
  adobename="umatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A41,
 },
 [0x0A42]={
  adobename="uumatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN UU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A42,
 },
 [0x0A47]={
  adobename="eematragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN EE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A47,
 },
 [0x0A48]={
  adobename="aimatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN AI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A48,
 },
 [0x0A4B]={
  adobename="oomatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN OO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A4B,
 },
 [0x0A4C]={
  adobename="aumatragurmukhi",
  category="mn",
  description="GURMUKHI VOWEL SIGN AU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A4C,
 },
 [0x0A4D]={
  adobename="halantgurmukhi",
  category="mn",
  description="GURMUKHI SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A4D,
 },
 [0x0A51]={
  category="mn",
  description="GURMUKHI SIGN UDAAT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A51,
 },
 [0x0A59]={
  adobename="khhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER KHHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0A16, 0x0A3C },
  unicodeslot=0x0A59,
 },
 [0x0A5A]={
  adobename="ghhagurmukhi",
  category="lo",
  description="GURMUKHI LETTER GHHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0A17, 0x0A3C },
  unicodeslot=0x0A5A,
 },
 [0x0A5B]={
  adobename="zagurmukhi",
  category="lo",
  description="GURMUKHI LETTER ZA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0A1C, 0x0A3C },
  unicodeslot=0x0A5B,
 },
 [0x0A5C]={
  adobename="rragurmukhi",
  category="lo",
  description="GURMUKHI LETTER RRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A5C,
 },
 [0x0A5E]={
  adobename="fagurmukhi",
  category="lo",
  description="GURMUKHI LETTER FA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0A2B, 0x0A3C },
  unicodeslot=0x0A5E,
 },
 [0x0A66]={
  adobename="zerogurmukhi",
  category="nd",
  description="GURMUKHI DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A66,
 },
 [0x0A67]={
  adobename="onegurmukhi",
  category="nd",
  description="GURMUKHI DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A67,
 },
 [0x0A68]={
  adobename="twogurmukhi",
  category="nd",
  description="GURMUKHI DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A68,
 },
 [0x0A69]={
  adobename="threegurmukhi",
  category="nd",
  description="GURMUKHI DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A69,
 },
 [0x0A6A]={
  adobename="fourgurmukhi",
  category="nd",
  description="GURMUKHI DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A6A,
 },
 [0x0A6B]={
  adobename="fivegurmukhi",
  category="nd",
  description="GURMUKHI DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A6B,
 },
 [0x0A6C]={
  adobename="sixgurmukhi",
  category="nd",
  description="GURMUKHI DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A6C,
 },
 [0x0A6D]={
  adobename="sevengurmukhi",
  category="nd",
  description="GURMUKHI DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A6D,
 },
 [0x0A6E]={
  adobename="eightgurmukhi",
  category="nd",
  description="GURMUKHI DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A6E,
 },
 [0x0A6F]={
  adobename="ninegurmukhi",
  category="nd",
  description="GURMUKHI DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0A6F,
 },
 [0x0A70]={
  adobename="tippigurmukhi",
  category="mn",
  description="GURMUKHI TIPPI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A70,
 },
 [0x0A71]={
  adobename="addakgurmukhi",
  category="mn",
  description="GURMUKHI ADDAK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A71,
 },
 [0x0A72]={
  adobename="irigurmukhi",
  category="lo",
  description="GURMUKHI IRI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A72,
 },
 [0x0A73]={
  adobename="uragurmukhi",
  category="lo",
  description="GURMUKHI URA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A73,
 },
 [0x0A74]={
  adobename="ekonkargurmukhi",
  category="lo",
  description="GURMUKHI EK ONKAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A74,
 },
 [0x0A75]={
  category="mn",
  description="GURMUKHI SIGN YAKASH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A75,
 },
 [0x0A81]={
  adobename="candrabindugujarati",
  category="mn",
  description="GUJARATI SIGN CANDRABINDU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A81,
 },
 [0x0A82]={
  adobename="anusvaragujarati",
  category="mn",
  description="GUJARATI SIGN ANUSVARA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0A82,
 },
 [0x0A83]={
  adobename="visargagujarati",
  category="mc",
  description="GUJARATI SIGN VISARGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0A83,
 },
 [0x0A85]={
  adobename="agujarati",
  category="lo",
  description="GUJARATI LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A85,
 },
 [0x0A86]={
  adobename="aagujarati",
  category="lo",
  description="GUJARATI LETTER AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A86,
 },
 [0x0A87]={
  adobename="igujarati",
  category="lo",
  description="GUJARATI LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A87,
 },
 [0x0A88]={
  adobename="iigujarati",
  category="lo",
  description="GUJARATI LETTER II",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A88,
 },
 [0x0A89]={
  adobename="ugujarati",
  category="lo",
  description="GUJARATI LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A89,
 },
 [0x0A8A]={
  adobename="uugujarati",
  category="lo",
  description="GUJARATI LETTER UU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A8A,
 },
 [0x0A8B]={
  adobename="rvocalicgujarati",
  category="lo",
  description="GUJARATI LETTER VOCALIC R",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A8B,
 },
 [0x0A8C]={
  category="lo",
  description="GUJARATI LETTER VOCALIC L",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A8C,
 },
 [0x0A8D]={
  adobename="ecandragujarati",
  category="lo",
  description="GUJARATI VOWEL CANDRA E",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A8D,
 },
 [0x0A8F]={
  adobename="egujarati",
  category="lo",
  description="GUJARATI LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A8F,
 },
 [0x0A90]={
  adobename="aigujarati",
  category="lo",
  description="GUJARATI LETTER AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A90,
 },
 [0x0A91]={
  adobename="ocandragujarati",
  category="lo",
  description="GUJARATI VOWEL CANDRA O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A91,
 },
 [0x0A93]={
  adobename="ogujarati",
  category="lo",
  description="GUJARATI LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A93,
 },
 [0x0A94]={
  adobename="augujarati",
  category="lo",
  description="GUJARATI LETTER AU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A94,
 },
 [0x0A95]={
  adobename="kagujarati",
  category="lo",
  description="GUJARATI LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A95,
 },
 [0x0A96]={
  adobename="khagujarati",
  category="lo",
  description="GUJARATI LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A96,
 },
 [0x0A97]={
  adobename="gagujarati",
  category="lo",
  description="GUJARATI LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A97,
 },
 [0x0A98]={
  adobename="ghagujarati",
  category="lo",
  description="GUJARATI LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A98,
 },
 [0x0A99]={
  adobename="ngagujarati",
  category="lo",
  description="GUJARATI LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A99,
 },
 [0x0A9A]={
  adobename="cagujarati",
  category="lo",
  description="GUJARATI LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A9A,
 },
 [0x0A9B]={
  adobename="chagujarati",
  category="lo",
  description="GUJARATI LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A9B,
 },
 [0x0A9C]={
  adobename="jagujarati",
  category="lo",
  description="GUJARATI LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A9C,
 },
 [0x0A9D]={
  adobename="jhagujarati",
  category="lo",
  description="GUJARATI LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A9D,
 },
 [0x0A9E]={
  adobename="nyagujarati",
  category="lo",
  description="GUJARATI LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A9E,
 },
 [0x0A9F]={
  adobename="ttagujarati",
  category="lo",
  description="GUJARATI LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0A9F,
 },
 [0x0AA0]={
  adobename="tthagujarati",
  category="lo",
  description="GUJARATI LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AA0,
 },
 [0x0AA1]={
  adobename="ddagujarati",
  category="lo",
  description="GUJARATI LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AA1,
 },
 [0x0AA2]={
  adobename="ddhagujarati",
  category="lo",
  description="GUJARATI LETTER DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AA2,
 },
 [0x0AA3]={
  adobename="nnagujarati",
  category="lo",
  description="GUJARATI LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AA3,
 },
 [0x0AA4]={
  adobename="tagujarati",
  category="lo",
  description="GUJARATI LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AA4,
 },
 [0x0AA5]={
  adobename="thagujarati",
  category="lo",
  description="GUJARATI LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AA5,
 },
 [0x0AA6]={
  adobename="dagujarati",
  category="lo",
  description="GUJARATI LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AA6,
 },
 [0x0AA7]={
  adobename="dhagujarati",
  category="lo",
  description="GUJARATI LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AA7,
 },
 [0x0AA8]={
  adobename="nagujarati",
  category="lo",
  description="GUJARATI LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AA8,
 },
 [0x0AAA]={
  adobename="pagujarati",
  category="lo",
  description="GUJARATI LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AAA,
 },
 [0x0AAB]={
  adobename="phagujarati",
  category="lo",
  description="GUJARATI LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AAB,
 },
 [0x0AAC]={
  adobename="bagujarati",
  category="lo",
  description="GUJARATI LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AAC,
 },
 [0x0AAD]={
  adobename="bhagujarati",
  category="lo",
  description="GUJARATI LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AAD,
 },
 [0x0AAE]={
  adobename="magujarati",
  category="lo",
  description="GUJARATI LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AAE,
 },
 [0x0AAF]={
  adobename="yagujarati",
  category="lo",
  description="GUJARATI LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AAF,
 },
 [0x0AB0]={
  adobename="ragujarati",
  category="lo",
  description="GUJARATI LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AB0,
 },
 [0x0AB2]={
  adobename="lagujarati",
  category="lo",
  description="GUJARATI LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AB2,
 },
 [0x0AB3]={
  adobename="llagujarati",
  category="lo",
  description="GUJARATI LETTER LLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AB3,
 },
 [0x0AB5]={
  adobename="vagujarati",
  category="lo",
  description="GUJARATI LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AB5,
 },
 [0x0AB6]={
  adobename="shagujarati",
  category="lo",
  description="GUJARATI LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AB6,
 },
 [0x0AB7]={
  adobename="ssagujarati",
  category="lo",
  description="GUJARATI LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AB7,
 },
 [0x0AB8]={
  adobename="sagujarati",
  category="lo",
  description="GUJARATI LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AB8,
 },
 [0x0AB9]={
  adobename="hagujarati",
  category="lo",
  description="GUJARATI LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AB9,
 },
 [0x0ABC]={
  adobename="nuktagujarati",
  category="mn",
  description="GUJARATI SIGN NUKTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0ABC,
 },
 [0x0ABD]={
  category="lo",
  description="GUJARATI SIGN AVAGRAHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0ABD,
 },
 [0x0ABE]={
  adobename="aavowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0ABE,
 },
 [0x0ABF]={
  adobename="ivowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0ABF,
 },
 [0x0AC0]={
  adobename="iivowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN II",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0AC0,
 },
 [0x0AC1]={
  adobename="uvowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0AC1,
 },
 [0x0AC2]={
  adobename="uuvowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN UU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0AC2,
 },
 [0x0AC3]={
  adobename="rvocalicvowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN VOCALIC R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0AC3,
 },
 [0x0AC4]={
  adobename="rrvocalicvowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN VOCALIC RR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0AC4,
 },
 [0x0AC5]={
  adobename="ecandravowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN CANDRA E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0AC5,
 },
 [0x0AC7]={
  adobename="evowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0AC7,
 },
 [0x0AC8]={
  adobename="aivowelsigngujarati",
  category="mn",
  description="GUJARATI VOWEL SIGN AI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0AC8,
 },
 [0x0AC9]={
  adobename="ocandravowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN CANDRA O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0AC9,
 },
 [0x0ACB]={
  adobename="ovowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0ACB,
 },
 [0x0ACC]={
  adobename="auvowelsigngujarati",
  category="mc",
  description="GUJARATI VOWEL SIGN AU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0ACC,
 },
 [0x0ACD]={
  adobename="viramagujarati",
  category="mn",
  description="GUJARATI SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0ACD,
 },
 [0x0AD0]={
  adobename="omgujarati",
  category="lo",
  description="GUJARATI OM",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AD0,
 },
 [0x0AE0]={
  adobename="rrvocalicgujarati",
  category="lo",
  description="GUJARATI LETTER VOCALIC RR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AE0,
 },
 [0x0AE1]={
  category="lo",
  description="GUJARATI LETTER VOCALIC LL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0AE1,
 },
 [0x0AE2]={
  category="mn",
  description="GUJARATI VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0AE2,
 },
 [0x0AE3]={
  category="mn",
  description="GUJARATI VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0AE3,
 },
 [0x0AE6]={
  adobename="zerogujarati",
  category="nd",
  description="GUJARATI DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AE6,
 },
 [0x0AE7]={
  adobename="onegujarati",
  category="nd",
  description="GUJARATI DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AE7,
 },
 [0x0AE8]={
  adobename="twogujarati",
  category="nd",
  description="GUJARATI DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AE8,
 },
 [0x0AE9]={
  adobename="threegujarati",
  category="nd",
  description="GUJARATI DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AE9,
 },
 [0x0AEA]={
  adobename="fourgujarati",
  category="nd",
  description="GUJARATI DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AEA,
 },
 [0x0AEB]={
  adobename="fivegujarati",
  category="nd",
  description="GUJARATI DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AEB,
 },
 [0x0AEC]={
  adobename="sixgujarati",
  category="nd",
  description="GUJARATI DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AEC,
 },
 [0x0AED]={
  adobename="sevengujarati",
  category="nd",
  description="GUJARATI DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AED,
 },
 [0x0AEE]={
  adobename="eightgujarati",
  category="nd",
  description="GUJARATI DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AEE,
 },
 [0x0AEF]={
  adobename="ninegujarati",
  category="nd",
  description="GUJARATI DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0AEF,
 },
 [0x0AF1]={
  category="sc",
  description="GUJARATI RUPEE SIGN",
  direction="et",
  linebreak="pr",
  unicodeslot=0x0AF1,
 },
 [0x0B01]={
  category="mn",
  description="ORIYA SIGN CANDRABINDU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B01,
 },
 [0x0B02]={
  category="mc",
  description="ORIYA SIGN ANUSVARA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0B02,
 },
 [0x0B03]={
  category="mc",
  description="ORIYA SIGN VISARGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0B03,
 },
 [0x0B05]={
  category="lo",
  description="ORIYA LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B05,
 },
 [0x0B06]={
  category="lo",
  description="ORIYA LETTER AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B06,
 },
 [0x0B07]={
  category="lo",
  description="ORIYA LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B07,
 },
 [0x0B08]={
  category="lo",
  description="ORIYA LETTER II",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B08,
 },
 [0x0B09]={
  category="lo",
  description="ORIYA LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B09,
 },
 [0x0B0A]={
  category="lo",
  description="ORIYA LETTER UU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B0A,
 },
 [0x0B0B]={
  category="lo",
  description="ORIYA LETTER VOCALIC R",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B0B,
 },
 [0x0B0C]={
  category="lo",
  description="ORIYA LETTER VOCALIC L",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B0C,
 },
 [0x0B0F]={
  category="lo",
  description="ORIYA LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B0F,
 },
 [0x0B10]={
  category="lo",
  description="ORIYA LETTER AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B10,
 },
 [0x0B13]={
  category="lo",
  description="ORIYA LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B13,
 },
 [0x0B14]={
  category="lo",
  description="ORIYA LETTER AU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B14,
 },
 [0x0B15]={
  category="lo",
  description="ORIYA LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B15,
 },
 [0x0B16]={
  category="lo",
  description="ORIYA LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B16,
 },
 [0x0B17]={
  category="lo",
  description="ORIYA LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B17,
 },
 [0x0B18]={
  category="lo",
  description="ORIYA LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B18,
 },
 [0x0B19]={
  category="lo",
  description="ORIYA LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B19,
 },
 [0x0B1A]={
  category="lo",
  description="ORIYA LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B1A,
 },
 [0x0B1B]={
  category="lo",
  description="ORIYA LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B1B,
 },
 [0x0B1C]={
  category="lo",
  description="ORIYA LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B1C,
 },
 [0x0B1D]={
  category="lo",
  description="ORIYA LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B1D,
 },
 [0x0B1E]={
  category="lo",
  description="ORIYA LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B1E,
 },
 [0x0B1F]={
  category="lo",
  description="ORIYA LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B1F,
 },
 [0x0B20]={
  category="lo",
  description="ORIYA LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B20,
 },
 [0x0B21]={
  category="lo",
  description="ORIYA LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B21,
 },
 [0x0B22]={
  category="lo",
  description="ORIYA LETTER DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B22,
 },
 [0x0B23]={
  category="lo",
  description="ORIYA LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B23,
 },
 [0x0B24]={
  category="lo",
  description="ORIYA LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B24,
 },
 [0x0B25]={
  category="lo",
  description="ORIYA LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B25,
 },
 [0x0B26]={
  category="lo",
  description="ORIYA LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B26,
 },
 [0x0B27]={
  category="lo",
  description="ORIYA LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B27,
 },
 [0x0B28]={
  category="lo",
  description="ORIYA LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B28,
 },
 [0x0B2A]={
  category="lo",
  description="ORIYA LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B2A,
 },
 [0x0B2B]={
  category="lo",
  description="ORIYA LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B2B,
 },
 [0x0B2C]={
  category="lo",
  description="ORIYA LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B2C,
 },
 [0x0B2D]={
  category="lo",
  description="ORIYA LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B2D,
 },
 [0x0B2E]={
  category="lo",
  description="ORIYA LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B2E,
 },
 [0x0B2F]={
  category="lo",
  description="ORIYA LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B2F,
 },
 [0x0B30]={
  category="lo",
  description="ORIYA LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B30,
 },
 [0x0B32]={
  category="lo",
  description="ORIYA LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B32,
 },
 [0x0B33]={
  category="lo",
  description="ORIYA LETTER LLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B33,
 },
 [0x0B35]={
  category="lo",
  description="ORIYA LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B35,
 },
 [0x0B36]={
  category="lo",
  description="ORIYA LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B36,
 },
 [0x0B37]={
  category="lo",
  description="ORIYA LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B37,
 },
 [0x0B38]={
  category="lo",
  description="ORIYA LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B38,
 },
 [0x0B39]={
  category="lo",
  description="ORIYA LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B39,
 },
 [0x0B3C]={
  category="mn",
  description="ORIYA SIGN NUKTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B3C,
 },
 [0x0B3D]={
  category="lo",
  description="ORIYA SIGN AVAGRAHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B3D,
 },
 [0x0B3E]={
  category="mc",
  description="ORIYA VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0B3E,
 },
 [0x0B3F]={
  category="mn",
  description="ORIYA VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B3F,
 },
 [0x0B40]={
  category="mc",
  description="ORIYA VOWEL SIGN II",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0B40,
 },
 [0x0B41]={
  category="mn",
  description="ORIYA VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B41,
 },
 [0x0B42]={
  category="mn",
  description="ORIYA VOWEL SIGN UU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B42,
 },
 [0x0B43]={
  category="mn",
  description="ORIYA VOWEL SIGN VOCALIC R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B43,
 },
 [0x0B44]={
  category="mn",
  description="ORIYA VOWEL SIGN VOCALIC RR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B44,
 },
 [0x0B47]={
  category="mc",
  description="ORIYA VOWEL SIGN E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0B47,
 },
 [0x0B48]={
  category="mc",
  description="ORIYA VOWEL SIGN AI",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0B47, 0x0B56 },
  unicodeslot=0x0B48,
 },
 [0x0B4B]={
  category="mc",
  description="ORIYA VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0B47, 0x0B3E },
  unicodeslot=0x0B4B,
 },
 [0x0B4C]={
  category="mc",
  description="ORIYA VOWEL SIGN AU",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0B47, 0x0B57 },
  unicodeslot=0x0B4C,
 },
 [0x0B4D]={
  category="mn",
  description="ORIYA SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B4D,
 },
 [0x0B56]={
  category="mn",
  description="ORIYA AI LENGTH MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B56,
 },
 [0x0B57]={
  category="mc",
  description="ORIYA AU LENGTH MARK",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0B57,
 },
 [0x0B5C]={
  category="lo",
  description="ORIYA LETTER RRA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0B21, 0x0B3C },
  unicodeslot=0x0B5C,
 },
 [0x0B5D]={
  category="lo",
  description="ORIYA LETTER RHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0B22, 0x0B3C },
  unicodeslot=0x0B5D,
 },
 [0x0B5F]={
  category="lo",
  description="ORIYA LETTER YYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B5F,
 },
 [0x0B60]={
  category="lo",
  description="ORIYA LETTER VOCALIC RR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B60,
 },
 [0x0B61]={
  category="lo",
  description="ORIYA LETTER VOCALIC LL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B61,
 },
 [0x0B62]={
  category="mn",
  description="ORIYA VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B62,
 },
 [0x0B63]={
  category="mn",
  description="ORIYA VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B63,
 },
 [0x0B66]={
  category="nd",
  description="ORIYA DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B66,
 },
 [0x0B67]={
  category="nd",
  description="ORIYA DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B67,
 },
 [0x0B68]={
  category="nd",
  description="ORIYA DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B68,
 },
 [0x0B69]={
  category="nd",
  description="ORIYA DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B69,
 },
 [0x0B6A]={
  category="nd",
  description="ORIYA DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B6A,
 },
 [0x0B6B]={
  category="nd",
  description="ORIYA DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B6B,
 },
 [0x0B6C]={
  category="nd",
  description="ORIYA DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B6C,
 },
 [0x0B6D]={
  category="nd",
  description="ORIYA DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B6D,
 },
 [0x0B6E]={
  category="nd",
  description="ORIYA DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B6E,
 },
 [0x0B6F]={
  category="nd",
  description="ORIYA DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0B6F,
 },
 [0x0B70]={
  category="so",
  description="ORIYA ISSHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B70,
 },
 [0x0B71]={
  category="lo",
  description="ORIYA LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B71,
 },
 [0x0B72]={
  category="no",
  description="ORIYA FRACTION ONE QUARTER",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B72,
 },
 [0x0B73]={
  category="no",
  description="ORIYA FRACTION ONE HALF",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B73,
 },
 [0x0B74]={
  category="no",
  description="ORIYA FRACTION THREE QUARTERS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B74,
 },
 [0x0B75]={
  category="no",
  description="ORIYA FRACTION ONE SIXTEENTH",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B75,
 },
 [0x0B76]={
  category="no",
  description="ORIYA FRACTION ONE EIGHTH",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B76,
 },
 [0x0B77]={
  category="no",
  description="ORIYA FRACTION THREE SIXTEENTHS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B77,
 },
 [0x0B82]={
  category="mn",
  description="TAMIL SIGN ANUSVARA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0B82,
 },
 [0x0B83]={
  category="lo",
  description="TAMIL SIGN VISARGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B83,
 },
 [0x0B85]={
  category="lo",
  description="TAMIL LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B85,
 },
 [0x0B86]={
  category="lo",
  description="TAMIL LETTER AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B86,
 },
 [0x0B87]={
  category="lo",
  description="TAMIL LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B87,
 },
 [0x0B88]={
  category="lo",
  description="TAMIL LETTER II",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B88,
 },
 [0x0B89]={
  category="lo",
  description="TAMIL LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B89,
 },
 [0x0B8A]={
  category="lo",
  description="TAMIL LETTER UU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B8A,
 },
 [0x0B8E]={
  category="lo",
  description="TAMIL LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B8E,
 },
 [0x0B8F]={
  category="lo",
  description="TAMIL LETTER EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B8F,
 },
 [0x0B90]={
  category="lo",
  description="TAMIL LETTER AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B90,
 },
 [0x0B92]={
  category="lo",
  description="TAMIL LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B92,
 },
 [0x0B93]={
  category="lo",
  description="TAMIL LETTER OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B93,
 },
 [0x0B94]={
  category="lo",
  description="TAMIL LETTER AU",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0B92, 0x0BD7 },
  unicodeslot=0x0B94,
 },
 [0x0B95]={
  category="lo",
  description="TAMIL LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B95,
 },
 [0x0B99]={
  category="lo",
  description="TAMIL LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B99,
 },
 [0x0B9A]={
  category="lo",
  description="TAMIL LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B9A,
 },
 [0x0B9C]={
  category="lo",
  description="TAMIL LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B9C,
 },
 [0x0B9E]={
  category="lo",
  description="TAMIL LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B9E,
 },
 [0x0B9F]={
  category="lo",
  description="TAMIL LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0B9F,
 },
 [0x0BA3]={
  category="lo",
  description="TAMIL LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BA3,
 },
 [0x0BA4]={
  category="lo",
  description="TAMIL LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BA4,
 },
 [0x0BA8]={
  category="lo",
  description="TAMIL LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BA8,
 },
 [0x0BA9]={
  category="lo",
  description="TAMIL LETTER NNNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BA9,
 },
 [0x0BAA]={
  category="lo",
  description="TAMIL LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BAA,
 },
 [0x0BAE]={
  category="lo",
  description="TAMIL LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BAE,
 },
 [0x0BAF]={
  category="lo",
  description="TAMIL LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BAF,
 },
 [0x0BB0]={
  category="lo",
  description="TAMIL LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB0,
 },
 [0x0BB1]={
  category="lo",
  description="TAMIL LETTER RRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB1,
 },
 [0x0BB2]={
  category="lo",
  description="TAMIL LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB2,
 },
 [0x0BB3]={
  category="lo",
  description="TAMIL LETTER LLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB3,
 },
 [0x0BB4]={
  category="lo",
  description="TAMIL LETTER LLLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB4,
 },
 [0x0BB5]={
  category="lo",
  description="TAMIL LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB5,
 },
 [0x0BB6]={
  category="lo",
  description="TAMIL LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB6,
 },
 [0x0BB7]={
  category="lo",
  description="TAMIL LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB7,
 },
 [0x0BB8]={
  category="lo",
  description="TAMIL LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB8,
 },
 [0x0BB9]={
  category="lo",
  description="TAMIL LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BB9,
 },
 [0x0BBE]={
  category="mc",
  description="TAMIL VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0BBE,
 },
 [0x0BBF]={
  category="mc",
  description="TAMIL VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0BBF,
 },
 [0x0BC0]={
  category="mn",
  description="TAMIL VOWEL SIGN II",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0BC0,
 },
 [0x0BC1]={
  category="mc",
  description="TAMIL VOWEL SIGN U",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0BC1,
 },
 [0x0BC2]={
  category="mc",
  description="TAMIL VOWEL SIGN UU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0BC2,
 },
 [0x0BC6]={
  category="mc",
  description="TAMIL VOWEL SIGN E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0BC6,
 },
 [0x0BC7]={
  category="mc",
  description="TAMIL VOWEL SIGN EE",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0BC7,
 },
 [0x0BC8]={
  category="mc",
  description="TAMIL VOWEL SIGN AI",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0BC8,
 },
 [0x0BCA]={
  category="mc",
  description="TAMIL VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0BC6, 0x0BBE },
  unicodeslot=0x0BCA,
 },
 [0x0BCB]={
  category="mc",
  description="TAMIL VOWEL SIGN OO",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0BC7, 0x0BBE },
  unicodeslot=0x0BCB,
 },
 [0x0BCC]={
  category="mc",
  description="TAMIL VOWEL SIGN AU",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0BC6, 0x0BD7 },
  unicodeslot=0x0BCC,
 },
 [0x0BCD]={
  category="mn",
  description="TAMIL SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0BCD,
 },
 [0x0BD0]={
  category="lo",
  description="TAMIL OM",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BD0,
 },
 [0x0BD7]={
  category="mc",
  description="TAMIL AU LENGTH MARK",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0BD7,
 },
 [0x0BE6]={
  category="nd",
  description="TAMIL DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BE6,
 },
 [0x0BE7]={
  category="nd",
  description="TAMIL DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BE7,
 },
 [0x0BE8]={
  category="nd",
  description="TAMIL DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BE8,
 },
 [0x0BE9]={
  category="nd",
  description="TAMIL DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BE9,
 },
 [0x0BEA]={
  category="nd",
  description="TAMIL DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BEA,
 },
 [0x0BEB]={
  category="nd",
  description="TAMIL DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BEB,
 },
 [0x0BEC]={
  category="nd",
  description="TAMIL DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BEC,
 },
 [0x0BED]={
  category="nd",
  description="TAMIL DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BED,
 },
 [0x0BEE]={
  category="nd",
  description="TAMIL DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BEE,
 },
 [0x0BEF]={
  category="nd",
  description="TAMIL DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0BEF,
 },
 [0x0BF0]={
  category="no",
  description="TAMIL NUMBER TEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BF0,
 },
 [0x0BF1]={
  category="no",
  description="TAMIL NUMBER ONE HUNDRED",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BF1,
 },
 [0x0BF2]={
  category="no",
  description="TAMIL NUMBER ONE THOUSAND",
  direction="l",
  linebreak="al",
  unicodeslot=0x0BF2,
 },
 [0x0BF3]={
  category="so",
  description="TAMIL DAY SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x0BF3,
 },
 [0x0BF4]={
  category="so",
  description="TAMIL MONTH SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x0BF4,
 },
 [0x0BF5]={
  category="so",
  description="TAMIL YEAR SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x0BF5,
 },
 [0x0BF6]={
  category="so",
  description="TAMIL DEBIT SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x0BF6,
 },
 [0x0BF7]={
  category="so",
  description="TAMIL CREDIT SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x0BF7,
 },
 [0x0BF8]={
  category="so",
  description="TAMIL AS ABOVE SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x0BF8,
 },
 [0x0BF9]={
  category="sc",
  description="TAMIL RUPEE SIGN",
  direction="et",
  linebreak="pr",
  unicodeslot=0x0BF9,
 },
 [0x0BFA]={
  category="so",
  description="TAMIL NUMBER SIGN",
  direction="on",
  linebreak="al",
  unicodeslot=0x0BFA,
 },
 [0x0C01]={
  category="mc",
  description="TELUGU SIGN CANDRABINDU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0C01,
 },
 [0x0C02]={
  category="mc",
  description="TELUGU SIGN ANUSVARA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0C02,
 },
 [0x0C03]={
  category="mc",
  description="TELUGU SIGN VISARGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0C03,
 },
 [0x0C05]={
  category="lo",
  description="TELUGU LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C05,
 },
 [0x0C06]={
  category="lo",
  description="TELUGU LETTER AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C06,
 },
 [0x0C07]={
  category="lo",
  description="TELUGU LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C07,
 },
 [0x0C08]={
  category="lo",
  description="TELUGU LETTER II",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C08,
 },
 [0x0C09]={
  category="lo",
  description="TELUGU LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C09,
 },
 [0x0C0A]={
  category="lo",
  description="TELUGU LETTER UU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C0A,
 },
 [0x0C0B]={
  category="lo",
  description="TELUGU LETTER VOCALIC R",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C0B,
 },
 [0x0C0C]={
  category="lo",
  description="TELUGU LETTER VOCALIC L",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C0C,
 },
 [0x0C0E]={
  category="lo",
  description="TELUGU LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C0E,
 },
 [0x0C0F]={
  category="lo",
  description="TELUGU LETTER EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C0F,
 },
 [0x0C10]={
  category="lo",
  description="TELUGU LETTER AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C10,
 },
 [0x0C12]={
  category="lo",
  description="TELUGU LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C12,
 },
 [0x0C13]={
  category="lo",
  description="TELUGU LETTER OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C13,
 },
 [0x0C14]={
  category="lo",
  description="TELUGU LETTER AU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C14,
 },
 [0x0C15]={
  category="lo",
  description="TELUGU LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C15,
 },
 [0x0C16]={
  category="lo",
  description="TELUGU LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C16,
 },
 [0x0C17]={
  category="lo",
  description="TELUGU LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C17,
 },
 [0x0C18]={
  category="lo",
  description="TELUGU LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C18,
 },
 [0x0C19]={
  category="lo",
  description="TELUGU LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C19,
 },
 [0x0C1A]={
  category="lo",
  description="TELUGU LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C1A,
 },
 [0x0C1B]={
  category="lo",
  description="TELUGU LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C1B,
 },
 [0x0C1C]={
  category="lo",
  description="TELUGU LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C1C,
 },
 [0x0C1D]={
  category="lo",
  description="TELUGU LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C1D,
 },
 [0x0C1E]={
  category="lo",
  description="TELUGU LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C1E,
 },
 [0x0C1F]={
  category="lo",
  description="TELUGU LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C1F,
 },
 [0x0C20]={
  category="lo",
  description="TELUGU LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C20,
 },
 [0x0C21]={
  category="lo",
  description="TELUGU LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C21,
 },
 [0x0C22]={
  category="lo",
  description="TELUGU LETTER DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C22,
 },
 [0x0C23]={
  category="lo",
  description="TELUGU LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C23,
 },
 [0x0C24]={
  category="lo",
  description="TELUGU LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C24,
 },
 [0x0C25]={
  category="lo",
  description="TELUGU LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C25,
 },
 [0x0C26]={
  category="lo",
  description="TELUGU LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C26,
 },
 [0x0C27]={
  category="lo",
  description="TELUGU LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C27,
 },
 [0x0C28]={
  category="lo",
  description="TELUGU LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C28,
 },
 [0x0C2A]={
  category="lo",
  description="TELUGU LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C2A,
 },
 [0x0C2B]={
  category="lo",
  description="TELUGU LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C2B,
 },
 [0x0C2C]={
  category="lo",
  description="TELUGU LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C2C,
 },
 [0x0C2D]={
  category="lo",
  description="TELUGU LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C2D,
 },
 [0x0C2E]={
  category="lo",
  description="TELUGU LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C2E,
 },
 [0x0C2F]={
  category="lo",
  description="TELUGU LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C2F,
 },
 [0x0C30]={
  category="lo",
  description="TELUGU LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C30,
 },
 [0x0C31]={
  category="lo",
  description="TELUGU LETTER RRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C31,
 },
 [0x0C32]={
  category="lo",
  description="TELUGU LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C32,
 },
 [0x0C33]={
  category="lo",
  description="TELUGU LETTER LLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C33,
 },
 [0x0C35]={
  category="lo",
  description="TELUGU LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C35,
 },
 [0x0C36]={
  category="lo",
  description="TELUGU LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C36,
 },
 [0x0C37]={
  category="lo",
  description="TELUGU LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C37,
 },
 [0x0C38]={
  category="lo",
  description="TELUGU LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C38,
 },
 [0x0C39]={
  category="lo",
  description="TELUGU LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C39,
 },
 [0x0C3D]={
  category="lo",
  description="TELUGU SIGN AVAGRAHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C3D,
 },
 [0x0C3E]={
  category="mn",
  description="TELUGU VOWEL SIGN AA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C3E,
 },
 [0x0C3F]={
  category="mn",
  description="TELUGU VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C3F,
 },
 [0x0C40]={
  category="mn",
  description="TELUGU VOWEL SIGN II",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C40,
 },
 [0x0C41]={
  category="mc",
  description="TELUGU VOWEL SIGN U",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0C41,
 },
 [0x0C42]={
  category="mc",
  description="TELUGU VOWEL SIGN UU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0C42,
 },
 [0x0C43]={
  category="mc",
  description="TELUGU VOWEL SIGN VOCALIC R",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0C43,
 },
 [0x0C44]={
  category="mc",
  description="TELUGU VOWEL SIGN VOCALIC RR",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0C44,
 },
 [0x0C46]={
  category="mn",
  description="TELUGU VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C46,
 },
 [0x0C47]={
  category="mn",
  description="TELUGU VOWEL SIGN EE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C47,
 },
 [0x0C48]={
  category="mn",
  description="TELUGU VOWEL SIGN AI",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0C46, 0x0C56 },
  unicodeslot=0x0C48,
 },
 [0x0C4A]={
  category="mn",
  description="TELUGU VOWEL SIGN O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C4A,
 },
 [0x0C4B]={
  category="mn",
  description="TELUGU VOWEL SIGN OO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C4B,
 },
 [0x0C4C]={
  category="mn",
  description="TELUGU VOWEL SIGN AU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C4C,
 },
 [0x0C4D]={
  category="mn",
  description="TELUGU SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C4D,
 },
 [0x0C55]={
  category="mn",
  description="TELUGU LENGTH MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C55,
 },
 [0x0C56]={
  category="mn",
  description="TELUGU AI LENGTH MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C56,
 },
 [0x0C58]={
  category="lo",
  description="TELUGU LETTER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C58,
 },
 [0x0C59]={
  category="lo",
  description="TELUGU LETTER DZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C59,
 },
 [0x0C60]={
  category="lo",
  description="TELUGU LETTER VOCALIC RR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C60,
 },
 [0x0C61]={
  category="lo",
  description="TELUGU LETTER VOCALIC LL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C61,
 },
 [0x0C62]={
  category="mn",
  description="TELUGU VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C62,
 },
 [0x0C63]={
  category="mn",
  description="TELUGU VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0C63,
 },
 [0x0C66]={
  category="nd",
  description="TELUGU DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C66,
 },
 [0x0C67]={
  category="nd",
  description="TELUGU DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C67,
 },
 [0x0C68]={
  category="nd",
  description="TELUGU DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C68,
 },
 [0x0C69]={
  category="nd",
  description="TELUGU DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C69,
 },
 [0x0C6A]={
  category="nd",
  description="TELUGU DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C6A,
 },
 [0x0C6B]={
  category="nd",
  description="TELUGU DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C6B,
 },
 [0x0C6C]={
  category="nd",
  description="TELUGU DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C6C,
 },
 [0x0C6D]={
  category="nd",
  description="TELUGU DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C6D,
 },
 [0x0C6E]={
  category="nd",
  description="TELUGU DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C6E,
 },
 [0x0C6F]={
  category="nd",
  description="TELUGU DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0C6F,
 },
 [0x0C78]={
  category="no",
  description="TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR",
  direction="on",
  linebreak="al",
  unicodeslot=0x0C78,
 },
 [0x0C79]={
  category="no",
  description="TELUGU FRACTION DIGIT ONE FOR ODD POWERS OF FOUR",
  direction="on",
  linebreak="al",
  unicodeslot=0x0C79,
 },
 [0x0C7A]={
  category="no",
  description="TELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOUR",
  direction="on",
  linebreak="al",
  unicodeslot=0x0C7A,
 },
 [0x0C7B]={
  category="no",
  description="TELUGU FRACTION DIGIT THREE FOR ODD POWERS OF FOUR",
  direction="on",
  linebreak="al",
  unicodeslot=0x0C7B,
 },
 [0x0C7C]={
  category="no",
  description="TELUGU FRACTION DIGIT ONE FOR EVEN POWERS OF FOUR",
  direction="on",
  linebreak="al",
  unicodeslot=0x0C7C,
 },
 [0x0C7D]={
  category="no",
  description="TELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOUR",
  direction="on",
  linebreak="al",
  unicodeslot=0x0C7D,
 },
 [0x0C7E]={
  category="no",
  description="TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR",
  direction="on",
  linebreak="al",
  unicodeslot=0x0C7E,
 },
 [0x0C7F]={
  category="so",
  description="TELUGU SIGN TUUMU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C7F,
 },
 [0x0C82]={
  category="mc",
  description="KANNADA SIGN ANUSVARA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0C82,
 },
 [0x0C83]={
  category="mc",
  description="KANNADA SIGN VISARGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0C83,
 },
 [0x0C85]={
  category="lo",
  description="KANNADA LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C85,
 },
 [0x0C86]={
  category="lo",
  description="KANNADA LETTER AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C86,
 },
 [0x0C87]={
  category="lo",
  description="KANNADA LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C87,
 },
 [0x0C88]={
  category="lo",
  description="KANNADA LETTER II",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C88,
 },
 [0x0C89]={
  category="lo",
  description="KANNADA LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C89,
 },
 [0x0C8A]={
  category="lo",
  description="KANNADA LETTER UU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C8A,
 },
 [0x0C8B]={
  category="lo",
  description="KANNADA LETTER VOCALIC R",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C8B,
 },
 [0x0C8C]={
  category="lo",
  description="KANNADA LETTER VOCALIC L",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C8C,
 },
 [0x0C8E]={
  category="lo",
  description="KANNADA LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C8E,
 },
 [0x0C8F]={
  category="lo",
  description="KANNADA LETTER EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C8F,
 },
 [0x0C90]={
  category="lo",
  description="KANNADA LETTER AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C90,
 },
 [0x0C92]={
  category="lo",
  description="KANNADA LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C92,
 },
 [0x0C93]={
  category="lo",
  description="KANNADA LETTER OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C93,
 },
 [0x0C94]={
  category="lo",
  description="KANNADA LETTER AU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C94,
 },
 [0x0C95]={
  category="lo",
  description="KANNADA LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C95,
 },
 [0x0C96]={
  category="lo",
  description="KANNADA LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C96,
 },
 [0x0C97]={
  category="lo",
  description="KANNADA LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C97,
 },
 [0x0C98]={
  category="lo",
  description="KANNADA LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C98,
 },
 [0x0C99]={
  category="lo",
  description="KANNADA LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C99,
 },
 [0x0C9A]={
  category="lo",
  description="KANNADA LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C9A,
 },
 [0x0C9B]={
  category="lo",
  description="KANNADA LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C9B,
 },
 [0x0C9C]={
  category="lo",
  description="KANNADA LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C9C,
 },
 [0x0C9D]={
  category="lo",
  description="KANNADA LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C9D,
 },
 [0x0C9E]={
  category="lo",
  description="KANNADA LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C9E,
 },
 [0x0C9F]={
  category="lo",
  description="KANNADA LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0C9F,
 },
 [0x0CA0]={
  category="lo",
  description="KANNADA LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CA0,
 },
 [0x0CA1]={
  category="lo",
  description="KANNADA LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CA1,
 },
 [0x0CA2]={
  category="lo",
  description="KANNADA LETTER DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CA2,
 },
 [0x0CA3]={
  category="lo",
  description="KANNADA LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CA3,
 },
 [0x0CA4]={
  category="lo",
  description="KANNADA LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CA4,
 },
 [0x0CA5]={
  category="lo",
  description="KANNADA LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CA5,
 },
 [0x0CA6]={
  category="lo",
  description="KANNADA LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CA6,
 },
 [0x0CA7]={
  category="lo",
  description="KANNADA LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CA7,
 },
 [0x0CA8]={
  category="lo",
  description="KANNADA LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CA8,
 },
 [0x0CAA]={
  category="lo",
  description="KANNADA LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CAA,
 },
 [0x0CAB]={
  category="lo",
  description="KANNADA LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CAB,
 },
 [0x0CAC]={
  category="lo",
  description="KANNADA LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CAC,
 },
 [0x0CAD]={
  category="lo",
  description="KANNADA LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CAD,
 },
 [0x0CAE]={
  category="lo",
  description="KANNADA LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CAE,
 },
 [0x0CAF]={
  category="lo",
  description="KANNADA LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CAF,
 },
 [0x0CB0]={
  category="lo",
  description="KANNADA LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CB0,
 },
 [0x0CB1]={
  category="lo",
  description="KANNADA LETTER RRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CB1,
 },
 [0x0CB2]={
  category="lo",
  description="KANNADA LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CB2,
 },
 [0x0CB3]={
  category="lo",
  description="KANNADA LETTER LLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CB3,
 },
 [0x0CB5]={
  category="lo",
  description="KANNADA LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CB5,
 },
 [0x0CB6]={
  category="lo",
  description="KANNADA LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CB6,
 },
 [0x0CB7]={
  category="lo",
  description="KANNADA LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CB7,
 },
 [0x0CB8]={
  category="lo",
  description="KANNADA LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CB8,
 },
 [0x0CB9]={
  category="lo",
  description="KANNADA LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CB9,
 },
 [0x0CBC]={
  category="mn",
  description="KANNADA SIGN NUKTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0CBC,
 },
 [0x0CBD]={
  category="lo",
  description="KANNADA SIGN AVAGRAHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CBD,
 },
 [0x0CBE]={
  category="mc",
  description="KANNADA VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0CBE,
 },
 [0x0CBF]={
  category="mn",
  description="KANNADA VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0CBF,
 },
 [0x0CC0]={
  category="mc",
  description="KANNADA VOWEL SIGN II",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0CBF, 0x0CD5 },
  unicodeslot=0x0CC0,
 },
 [0x0CC1]={
  category="mc",
  description="KANNADA VOWEL SIGN U",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0CC1,
 },
 [0x0CC2]={
  category="mc",
  description="KANNADA VOWEL SIGN UU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0CC2,
 },
 [0x0CC3]={
  category="mc",
  description="KANNADA VOWEL SIGN VOCALIC R",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0CC3,
 },
 [0x0CC4]={
  category="mc",
  description="KANNADA VOWEL SIGN VOCALIC RR",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0CC4,
 },
 [0x0CC6]={
  category="mn",
  description="KANNADA VOWEL SIGN E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0CC6,
 },
 [0x0CC7]={
  category="mc",
  description="KANNADA VOWEL SIGN EE",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0CC6, 0x0CD5 },
  unicodeslot=0x0CC7,
 },
 [0x0CC8]={
  category="mc",
  description="KANNADA VOWEL SIGN AI",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0CC6, 0x0CD6 },
  unicodeslot=0x0CC8,
 },
 [0x0CCA]={
  category="mc",
  description="KANNADA VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0CC6, 0x0CC2 },
  unicodeslot=0x0CCA,
 },
 [0x0CCB]={
  category="mc",
  description="KANNADA VOWEL SIGN OO",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0CCA, 0x0CD5 },
  unicodeslot=0x0CCB,
 },
 [0x0CCC]={
  category="mn",
  description="KANNADA VOWEL SIGN AU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0CCC,
 },
 [0x0CCD]={
  category="mn",
  description="KANNADA SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0CCD,
 },
 [0x0CD5]={
  category="mc",
  description="KANNADA LENGTH MARK",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0CD5,
 },
 [0x0CD6]={
  category="mc",
  description="KANNADA AI LENGTH MARK",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0CD6,
 },
 [0x0CDE]={
  category="lo",
  description="KANNADA LETTER FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CDE,
 },
 [0x0CE0]={
  category="lo",
  description="KANNADA LETTER VOCALIC RR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CE0,
 },
 [0x0CE1]={
  category="lo",
  description="KANNADA LETTER VOCALIC LL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CE1,
 },
 [0x0CE2]={
  category="mn",
  description="KANNADA VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0CE2,
 },
 [0x0CE3]={
  category="mn",
  description="KANNADA VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0CE3,
 },
 [0x0CE6]={
  category="nd",
  description="KANNADA DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CE6,
 },
 [0x0CE7]={
  category="nd",
  description="KANNADA DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CE7,
 },
 [0x0CE8]={
  category="nd",
  description="KANNADA DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CE8,
 },
 [0x0CE9]={
  category="nd",
  description="KANNADA DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CE9,
 },
 [0x0CEA]={
  category="nd",
  description="KANNADA DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CEA,
 },
 [0x0CEB]={
  category="nd",
  description="KANNADA DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CEB,
 },
 [0x0CEC]={
  category="nd",
  description="KANNADA DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CEC,
 },
 [0x0CED]={
  category="nd",
  description="KANNADA DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CED,
 },
 [0x0CEE]={
  category="nd",
  description="KANNADA DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CEE,
 },
 [0x0CEF]={
  category="nd",
  description="KANNADA DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0CEF,
 },
 [0x0CF1]={
  category="so",
  description="KANNADA SIGN JIHVAMULIYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CF1,
 },
 [0x0CF2]={
  category="so",
  description="KANNADA SIGN UPADHMANIYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0CF2,
 },
 [0x0D02]={
  category="mc",
  description="MALAYALAM SIGN ANUSVARA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D02,
 },
 [0x0D03]={
  category="mc",
  description="MALAYALAM SIGN VISARGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D03,
 },
 [0x0D05]={
  category="lo",
  description="MALAYALAM LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D05,
 },
 [0x0D06]={
  category="lo",
  description="MALAYALAM LETTER AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D06,
 },
 [0x0D07]={
  category="lo",
  description="MALAYALAM LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D07,
 },
 [0x0D08]={
  category="lo",
  description="MALAYALAM LETTER II",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D08,
 },
 [0x0D09]={
  category="lo",
  description="MALAYALAM LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D09,
 },
 [0x0D0A]={
  category="lo",
  description="MALAYALAM LETTER UU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D0A,
 },
 [0x0D0B]={
  category="lo",
  description="MALAYALAM LETTER VOCALIC R",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D0B,
 },
 [0x0D0C]={
  category="lo",
  description="MALAYALAM LETTER VOCALIC L",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D0C,
 },
 [0x0D0E]={
  category="lo",
  description="MALAYALAM LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D0E,
 },
 [0x0D0F]={
  category="lo",
  description="MALAYALAM LETTER EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D0F,
 },
 [0x0D10]={
  category="lo",
  description="MALAYALAM LETTER AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D10,
 },
 [0x0D12]={
  category="lo",
  description="MALAYALAM LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D12,
 },
 [0x0D13]={
  category="lo",
  description="MALAYALAM LETTER OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D13,
 },
 [0x0D14]={
  category="lo",
  description="MALAYALAM LETTER AU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D14,
 },
 [0x0D15]={
  category="lo",
  description="MALAYALAM LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D15,
 },
 [0x0D16]={
  category="lo",
  description="MALAYALAM LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D16,
 },
 [0x0D17]={
  category="lo",
  description="MALAYALAM LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D17,
 },
 [0x0D18]={
  category="lo",
  description="MALAYALAM LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D18,
 },
 [0x0D19]={
  category="lo",
  description="MALAYALAM LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D19,
 },
 [0x0D1A]={
  category="lo",
  description="MALAYALAM LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D1A,
 },
 [0x0D1B]={
  category="lo",
  description="MALAYALAM LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D1B,
 },
 [0x0D1C]={
  category="lo",
  description="MALAYALAM LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D1C,
 },
 [0x0D1D]={
  category="lo",
  description="MALAYALAM LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D1D,
 },
 [0x0D1E]={
  category="lo",
  description="MALAYALAM LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D1E,
 },
 [0x0D1F]={
  category="lo",
  description="MALAYALAM LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D1F,
 },
 [0x0D20]={
  category="lo",
  description="MALAYALAM LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D20,
 },
 [0x0D21]={
  category="lo",
  description="MALAYALAM LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D21,
 },
 [0x0D22]={
  category="lo",
  description="MALAYALAM LETTER DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D22,
 },
 [0x0D23]={
  category="lo",
  description="MALAYALAM LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D23,
 },
 [0x0D24]={
  category="lo",
  description="MALAYALAM LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D24,
 },
 [0x0D25]={
  category="lo",
  description="MALAYALAM LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D25,
 },
 [0x0D26]={
  category="lo",
  description="MALAYALAM LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D26,
 },
 [0x0D27]={
  category="lo",
  description="MALAYALAM LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D27,
 },
 [0x0D28]={
  category="lo",
  description="MALAYALAM LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D28,
 },
 [0x0D29]={
  category="lo",
  description="MALAYALAM LETTER NNNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D29,
 },
 [0x0D2A]={
  category="lo",
  description="MALAYALAM LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D2A,
 },
 [0x0D2B]={
  category="lo",
  description="MALAYALAM LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D2B,
 },
 [0x0D2C]={
  category="lo",
  description="MALAYALAM LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D2C,
 },
 [0x0D2D]={
  category="lo",
  description="MALAYALAM LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D2D,
 },
 [0x0D2E]={
  category="lo",
  description="MALAYALAM LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D2E,
 },
 [0x0D2F]={
  category="lo",
  description="MALAYALAM LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D2F,
 },
 [0x0D30]={
  category="lo",
  description="MALAYALAM LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D30,
 },
 [0x0D31]={
  category="lo",
  description="MALAYALAM LETTER RRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D31,
 },
 [0x0D32]={
  category="lo",
  description="MALAYALAM LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D32,
 },
 [0x0D33]={
  category="lo",
  description="MALAYALAM LETTER LLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D33,
 },
 [0x0D34]={
  category="lo",
  description="MALAYALAM LETTER LLLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D34,
 },
 [0x0D35]={
  category="lo",
  description="MALAYALAM LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D35,
 },
 [0x0D36]={
  category="lo",
  description="MALAYALAM LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D36,
 },
 [0x0D37]={
  category="lo",
  description="MALAYALAM LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D37,
 },
 [0x0D38]={
  category="lo",
  description="MALAYALAM LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D38,
 },
 [0x0D39]={
  category="lo",
  description="MALAYALAM LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D39,
 },
 [0x0D3A]={
  category="lo",
  description="MALAYALAM LETTER TTTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D3A,
 },
 [0x0D3D]={
  category="lo",
  description="MALAYALAM SIGN AVAGRAHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D3D,
 },
 [0x0D3E]={
  category="mc",
  description="MALAYALAM VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D3E,
 },
 [0x0D3F]={
  category="mc",
  description="MALAYALAM VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D3F,
 },
 [0x0D40]={
  category="mc",
  description="MALAYALAM VOWEL SIGN II",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D40,
 },
 [0x0D41]={
  category="mn",
  description="MALAYALAM VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0D41,
 },
 [0x0D42]={
  category="mn",
  description="MALAYALAM VOWEL SIGN UU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0D42,
 },
 [0x0D43]={
  category="mn",
  description="MALAYALAM VOWEL SIGN VOCALIC R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0D43,
 },
 [0x0D44]={
  category="mn",
  description="MALAYALAM VOWEL SIGN VOCALIC RR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0D44,
 },
 [0x0D46]={
  category="mc",
  description="MALAYALAM VOWEL SIGN E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D46,
 },
 [0x0D47]={
  category="mc",
  description="MALAYALAM VOWEL SIGN EE",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D47,
 },
 [0x0D48]={
  category="mc",
  description="MALAYALAM VOWEL SIGN AI",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D48,
 },
 [0x0D4A]={
  category="mc",
  description="MALAYALAM VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0D46, 0x0D3E },
  unicodeslot=0x0D4A,
 },
 [0x0D4B]={
  category="mc",
  description="MALAYALAM VOWEL SIGN OO",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0D47, 0x0D3E },
  unicodeslot=0x0D4B,
 },
 [0x0D4C]={
  category="mc",
  description="MALAYALAM VOWEL SIGN AU",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0D46, 0x0D57 },
  unicodeslot=0x0D4C,
 },
 [0x0D4D]={
  category="mn",
  description="MALAYALAM SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0D4D,
 },
 [0x0D4E]={
  category="lo",
  description="MALAYALAM LETTER DOT REPH",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D4E,
 },
 [0x0D57]={
  category="mc",
  description="MALAYALAM AU LENGTH MARK",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D57,
 },
 [0x0D60]={
  category="lo",
  description="MALAYALAM LETTER VOCALIC RR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D60,
 },
 [0x0D61]={
  category="lo",
  description="MALAYALAM LETTER VOCALIC LL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D61,
 },
 [0x0D62]={
  category="mn",
  description="MALAYALAM VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0D62,
 },
 [0x0D63]={
  category="mn",
  description="MALAYALAM VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0D63,
 },
 [0x0D66]={
  category="nd",
  description="MALAYALAM DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D66,
 },
 [0x0D67]={
  category="nd",
  description="MALAYALAM DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D67,
 },
 [0x0D68]={
  category="nd",
  description="MALAYALAM DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D68,
 },
 [0x0D69]={
  category="nd",
  description="MALAYALAM DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D69,
 },
 [0x0D6A]={
  category="nd",
  description="MALAYALAM DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D6A,
 },
 [0x0D6B]={
  category="nd",
  description="MALAYALAM DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D6B,
 },
 [0x0D6C]={
  category="nd",
  description="MALAYALAM DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D6C,
 },
 [0x0D6D]={
  category="nd",
  description="MALAYALAM DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D6D,
 },
 [0x0D6E]={
  category="nd",
  description="MALAYALAM DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D6E,
 },
 [0x0D6F]={
  category="nd",
  description="MALAYALAM DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0D6F,
 },
 [0x0D70]={
  category="no",
  description="MALAYALAM NUMBER TEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D70,
 },
 [0x0D71]={
  category="no",
  description="MALAYALAM NUMBER ONE HUNDRED",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D71,
 },
 [0x0D72]={
  category="no",
  description="MALAYALAM NUMBER ONE THOUSAND",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D72,
 },
 [0x0D73]={
  category="no",
  description="MALAYALAM FRACTION ONE QUARTER",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D73,
 },
 [0x0D74]={
  category="no",
  description="MALAYALAM FRACTION ONE HALF",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D74,
 },
 [0x0D75]={
  category="no",
  description="MALAYALAM FRACTION THREE QUARTERS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D75,
 },
 [0x0D79]={
  category="so",
  description="MALAYALAM DATE MARK",
  direction="l",
  linebreak="po",
  unicodeslot=0x0D79,
 },
 [0x0D7A]={
  category="lo",
  description="MALAYALAM LETTER CHILLU NN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D7A,
 },
 [0x0D7B]={
  category="lo",
  description="MALAYALAM LETTER CHILLU N",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D7B,
 },
 [0x0D7C]={
  category="lo",
  description="MALAYALAM LETTER CHILLU RR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D7C,
 },
 [0x0D7D]={
  category="lo",
  description="MALAYALAM LETTER CHILLU L",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D7D,
 },
 [0x0D7E]={
  category="lo",
  description="MALAYALAM LETTER CHILLU LL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D7E,
 },
 [0x0D7F]={
  category="lo",
  description="MALAYALAM LETTER CHILLU K",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D7F,
 },
 [0x0D82]={
  category="mc",
  description="SINHALA SIGN ANUSVARAYA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D82,
 },
 [0x0D83]={
  category="mc",
  description="SINHALA SIGN VISARGAYA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0D83,
 },
 [0x0D85]={
  category="lo",
  description="SINHALA LETTER AYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D85,
 },
 [0x0D86]={
  category="lo",
  description="SINHALA LETTER AAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D86,
 },
 [0x0D87]={
  category="lo",
  description="SINHALA LETTER AEYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D87,
 },
 [0x0D88]={
  category="lo",
  description="SINHALA LETTER AEEYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D88,
 },
 [0x0D89]={
  category="lo",
  description="SINHALA LETTER IYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D89,
 },
 [0x0D8A]={
  category="lo",
  description="SINHALA LETTER IIYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D8A,
 },
 [0x0D8B]={
  category="lo",
  description="SINHALA LETTER UYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D8B,
 },
 [0x0D8C]={
  category="lo",
  description="SINHALA LETTER UUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D8C,
 },
 [0x0D8D]={
  category="lo",
  description="SINHALA LETTER IRUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D8D,
 },
 [0x0D8E]={
  category="lo",
  description="SINHALA LETTER IRUUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D8E,
 },
 [0x0D8F]={
  category="lo",
  description="SINHALA LETTER ILUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D8F,
 },
 [0x0D90]={
  category="lo",
  description="SINHALA LETTER ILUUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D90,
 },
 [0x0D91]={
  category="lo",
  description="SINHALA LETTER EYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D91,
 },
 [0x0D92]={
  category="lo",
  description="SINHALA LETTER EEYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D92,
 },
 [0x0D93]={
  category="lo",
  description="SINHALA LETTER AIYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D93,
 },
 [0x0D94]={
  category="lo",
  description="SINHALA LETTER OYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D94,
 },
 [0x0D95]={
  category="lo",
  description="SINHALA LETTER OOYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D95,
 },
 [0x0D96]={
  category="lo",
  description="SINHALA LETTER AUYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D96,
 },
 [0x0D9A]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA KAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D9A,
 },
 [0x0D9B]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA KAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D9B,
 },
 [0x0D9C]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA GAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D9C,
 },
 [0x0D9D]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA GAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D9D,
 },
 [0x0D9E]={
  category="lo",
  description="SINHALA LETTER KANTAJA NAASIKYAYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D9E,
 },
 [0x0D9F]={
  category="lo",
  description="SINHALA LETTER SANYAKA GAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0D9F,
 },
 [0x0DA0]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA CAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA0,
 },
 [0x0DA1]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA CAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA1,
 },
 [0x0DA2]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA JAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA2,
 },
 [0x0DA3]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA JAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA3,
 },
 [0x0DA4]={
  category="lo",
  description="SINHALA LETTER TAALUJA NAASIKYAYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA4,
 },
 [0x0DA5]={
  category="lo",
  description="SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA5,
 },
 [0x0DA6]={
  category="lo",
  description="SINHALA LETTER SANYAKA JAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA6,
 },
 [0x0DA7]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA TTAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA7,
 },
 [0x0DA8]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA TTAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA8,
 },
 [0x0DA9]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA DDAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DA9,
 },
 [0x0DAA]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA DDAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DAA,
 },
 [0x0DAB]={
  category="lo",
  description="SINHALA LETTER MUURDHAJA NAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DAB,
 },
 [0x0DAC]={
  category="lo",
  description="SINHALA LETTER SANYAKA DDAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DAC,
 },
 [0x0DAD]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA TAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DAD,
 },
 [0x0DAE]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA TAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DAE,
 },
 [0x0DAF]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA DAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DAF,
 },
 [0x0DB0]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA DAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DB0,
 },
 [0x0DB1]={
  category="lo",
  description="SINHALA LETTER DANTAJA NAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DB1,
 },
 [0x0DB3]={
  category="lo",
  description="SINHALA LETTER SANYAKA DAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DB3,
 },
 [0x0DB4]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA PAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DB4,
 },
 [0x0DB5]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA PAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DB5,
 },
 [0x0DB6]={
  category="lo",
  description="SINHALA LETTER ALPAPRAANA BAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DB6,
 },
 [0x0DB7]={
  category="lo",
  description="SINHALA LETTER MAHAAPRAANA BAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DB7,
 },
 [0x0DB8]={
  category="lo",
  description="SINHALA LETTER MAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DB8,
 },
 [0x0DB9]={
  category="lo",
  description="SINHALA LETTER AMBA BAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DB9,
 },
 [0x0DBA]={
  category="lo",
  description="SINHALA LETTER YAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DBA,
 },
 [0x0DBB]={
  category="lo",
  description="SINHALA LETTER RAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DBB,
 },
 [0x0DBD]={
  category="lo",
  description="SINHALA LETTER DANTAJA LAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DBD,
 },
 [0x0DC0]={
  category="lo",
  description="SINHALA LETTER VAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DC0,
 },
 [0x0DC1]={
  category="lo",
  description="SINHALA LETTER TAALUJA SAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DC1,
 },
 [0x0DC2]={
  category="lo",
  description="SINHALA LETTER MUURDHAJA SAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DC2,
 },
 [0x0DC3]={
  category="lo",
  description="SINHALA LETTER DANTAJA SAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DC3,
 },
 [0x0DC4]={
  category="lo",
  description="SINHALA LETTER HAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DC4,
 },
 [0x0DC5]={
  category="lo",
  description="SINHALA LETTER MUURDHAJA LAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DC5,
 },
 [0x0DC6]={
  category="lo",
  description="SINHALA LETTER FAYANNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DC6,
 },
 [0x0DCA]={
  category="mn",
  description="SINHALA SIGN AL-LAKUNA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0DCA,
 },
 [0x0DCF]={
  category="mc",
  description="SINHALA VOWEL SIGN AELA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0DCF,
 },
 [0x0DD0]={
  category="mc",
  description="SINHALA VOWEL SIGN KETTI AEDA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0DD0,
 },
 [0x0DD1]={
  category="mc",
  description="SINHALA VOWEL SIGN DIGA AEDA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0DD1,
 },
 [0x0DD2]={
  category="mn",
  description="SINHALA VOWEL SIGN KETTI IS-PILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0DD2,
 },
 [0x0DD3]={
  category="mn",
  description="SINHALA VOWEL SIGN DIGA IS-PILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0DD3,
 },
 [0x0DD4]={
  category="mn",
  description="SINHALA VOWEL SIGN KETTI PAA-PILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0DD4,
 },
 [0x0DD6]={
  category="mn",
  description="SINHALA VOWEL SIGN DIGA PAA-PILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0DD6,
 },
 [0x0DD8]={
  category="mc",
  description="SINHALA VOWEL SIGN GAETTA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0DD8,
 },
 [0x0DD9]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBUVA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0DD9,
 },
 [0x0DDA]={
  category="mc",
  description="SINHALA VOWEL SIGN DIGA KOMBUVA",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0DD9, 0x0DCA },
  unicodeslot=0x0DDA,
 },
 [0x0DDB]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBU DEKA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0DDB,
 },
 [0x0DDC]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0DD9, 0x0DCF },
  unicodeslot=0x0DDC,
 },
 [0x0DDD]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0DDC, 0x0DCA },
  unicodeslot=0x0DDD,
 },
 [0x0DDE]={
  category="mc",
  description="SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x0DD9, 0x0DDF },
  unicodeslot=0x0DDE,
 },
 [0x0DDF]={
  category="mc",
  description="SINHALA VOWEL SIGN GAYANUKITTA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0DDF,
 },
 [0x0DF2]={
  category="mc",
  description="SINHALA VOWEL SIGN DIGA GAETTA-PILLA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0DF2,
 },
 [0x0DF3]={
  category="mc",
  description="SINHALA VOWEL SIGN DIGA GAYANUKITTA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0DF3,
 },
 [0x0DF4]={
  category="po",
  description="SINHALA PUNCTUATION KUNDDALIYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0DF4,
 },
 [0x0E01]={
  adobename="kokaithai",
  category="lo",
  description="THAI CHARACTER KO KAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E01,
 },
 [0x0E02]={
  adobename="khokhaithai",
  category="lo",
  description="THAI CHARACTER KHO KHAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E02,
 },
 [0x0E03]={
  adobename="khokhuatthai",
  category="lo",
  description="THAI CHARACTER KHO KHUAT",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E03,
 },
 [0x0E04]={
  adobename="khokhwaithai",
  category="lo",
  description="THAI CHARACTER KHO KHWAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E04,
 },
 [0x0E05]={
  adobename="khokhonthai",
  category="lo",
  description="THAI CHARACTER KHO KHON",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E05,
 },
 [0x0E06]={
  adobename="khorakhangthai",
  category="lo",
  description="THAI CHARACTER KHO RAKHANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E06,
 },
 [0x0E07]={
  adobename="ngonguthai",
  category="lo",
  description="THAI CHARACTER NGO NGU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E07,
 },
 [0x0E08]={
  adobename="chochanthai",
  category="lo",
  description="THAI CHARACTER CHO CHAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E08,
 },
 [0x0E09]={
  adobename="chochingthai",
  category="lo",
  description="THAI CHARACTER CHO CHING",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E09,
 },
 [0x0E0A]={
  adobename="chochangthai",
  category="lo",
  description="THAI CHARACTER CHO CHANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E0A,
 },
 [0x0E0B]={
  adobename="sosothai",
  category="lo",
  description="THAI CHARACTER SO SO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E0B,
 },
 [0x0E0C]={
  adobename="chochoethai",
  category="lo",
  description="THAI CHARACTER CHO CHOE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E0C,
 },
 [0x0E0D]={
  adobename="yoyingthai",
  category="lo",
  description="THAI CHARACTER YO YING",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E0D,
 },
 [0x0E0E]={
  adobename="dochadathai",
  category="lo",
  description="THAI CHARACTER DO CHADA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E0E,
 },
 [0x0E0F]={
  adobename="topatakthai",
  category="lo",
  description="THAI CHARACTER TO PATAK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E0F,
 },
 [0x0E10]={
  adobename="thothanthai",
  category="lo",
  description="THAI CHARACTER THO THAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E10,
 },
 [0x0E11]={
  adobename="thonangmonthothai",
  category="lo",
  description="THAI CHARACTER THO NANGMONTHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E11,
 },
 [0x0E12]={
  adobename="thophuthaothai",
  category="lo",
  description="THAI CHARACTER THO PHUTHAO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E12,
 },
 [0x0E13]={
  adobename="nonenthai",
  category="lo",
  description="THAI CHARACTER NO NEN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E13,
 },
 [0x0E14]={
  adobename="dodekthai",
  category="lo",
  description="THAI CHARACTER DO DEK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E14,
 },
 [0x0E15]={
  adobename="totaothai",
  category="lo",
  description="THAI CHARACTER TO TAO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E15,
 },
 [0x0E16]={
  adobename="thothungthai",
  category="lo",
  description="THAI CHARACTER THO THUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E16,
 },
 [0x0E17]={
  adobename="thothahanthai",
  category="lo",
  description="THAI CHARACTER THO THAHAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E17,
 },
 [0x0E18]={
  adobename="thothongthai",
  category="lo",
  description="THAI CHARACTER THO THONG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E18,
 },
 [0x0E19]={
  adobename="nonuthai",
  category="lo",
  description="THAI CHARACTER NO NU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E19,
 },
 [0x0E1A]={
  adobename="bobaimaithai",
  category="lo",
  description="THAI CHARACTER BO BAIMAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E1A,
 },
 [0x0E1B]={
  adobename="poplathai",
  category="lo",
  description="THAI CHARACTER PO PLA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E1B,
 },
 [0x0E1C]={
  adobename="phophungthai",
  category="lo",
  description="THAI CHARACTER PHO PHUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E1C,
 },
 [0x0E1D]={
  adobename="fofathai",
  category="lo",
  description="THAI CHARACTER FO FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E1D,
 },
 [0x0E1E]={
  adobename="phophanthai",
  category="lo",
  description="THAI CHARACTER PHO PHAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E1E,
 },
 [0x0E1F]={
  adobename="fofanthai",
  category="lo",
  description="THAI CHARACTER FO FAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E1F,
 },
 [0x0E20]={
  adobename="phosamphaothai",
  category="lo",
  description="THAI CHARACTER PHO SAMPHAO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E20,
 },
 [0x0E21]={
  adobename="momathai",
  category="lo",
  description="THAI CHARACTER MO MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E21,
 },
 [0x0E22]={
  adobename="yoyakthai",
  category="lo",
  description="THAI CHARACTER YO YAK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E22,
 },
 [0x0E23]={
  adobename="roruathai",
  category="lo",
  description="THAI CHARACTER RO RUA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E23,
 },
 [0x0E24]={
  adobename="ruthai",
  category="lo",
  description="THAI CHARACTER RU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E24,
 },
 [0x0E25]={
  adobename="lolingthai",
  category="lo",
  description="THAI CHARACTER LO LING",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E25,
 },
 [0x0E26]={
  adobename="luthai",
  category="lo",
  description="THAI CHARACTER LU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E26,
 },
 [0x0E27]={
  adobename="wowaenthai",
  category="lo",
  description="THAI CHARACTER WO WAEN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E27,
 },
 [0x0E28]={
  adobename="sosalathai",
  category="lo",
  description="THAI CHARACTER SO SALA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E28,
 },
 [0x0E29]={
  adobename="sorusithai",
  category="lo",
  description="THAI CHARACTER SO RUSI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E29,
 },
 [0x0E2A]={
  adobename="sosuathai",
  category="lo",
  description="THAI CHARACTER SO SUA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E2A,
 },
 [0x0E2B]={
  adobename="hohipthai",
  category="lo",
  description="THAI CHARACTER HO HIP",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E2B,
 },
 [0x0E2C]={
  adobename="lochulathai",
  category="lo",
  description="THAI CHARACTER LO CHULA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E2C,
 },
 [0x0E2D]={
  adobename="oangthai",
  category="lo",
  description="THAI CHARACTER O ANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E2D,
 },
 [0x0E2E]={
  adobename="honokhukthai",
  category="lo",
  description="THAI CHARACTER HO NOKHUK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E2E,
 },
 [0x0E2F]={
  adobename="paiyannoithai",
  category="lo",
  description="THAI CHARACTER PAIYANNOI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E2F,
 },
 [0x0E30]={
  adobename="saraathai",
  category="lo",
  description="THAI CHARACTER SARA A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E30,
 },
 [0x0E31]={
  adobename="maihanakatthai",
  category="mn",
  description="THAI CHARACTER MAI HAN-AKAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E31,
 },
 [0x0E32]={
  adobename="saraaathai",
  category="lo",
  description="THAI CHARACTER SARA AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E32,
 },
 [0x0E33]={
  adobename="saraamthai",
  category="lo",
  description="THAI CHARACTER SARA AM",
  direction="l",
  linebreak="sa",
  specials={ "compat", 0x0E4D, 0x0E32 },
  unicodeslot=0x0E33,
 },
 [0x0E34]={
  adobename="saraithai",
  category="mn",
  description="THAI CHARACTER SARA I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E34,
 },
 [0x0E35]={
  adobename="saraiithai",
  category="mn",
  description="THAI CHARACTER SARA II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E35,
 },
 [0x0E36]={
  adobename="sarauethai",
  category="mn",
  description="THAI CHARACTER SARA UE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E36,
 },
 [0x0E37]={
  adobename="saraueethai",
  category="mn",
  description="THAI CHARACTER SARA UEE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E37,
 },
 [0x0E38]={
  adobename="sarauthai",
  category="mn",
  description="THAI CHARACTER SARA U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E38,
 },
 [0x0E39]={
  adobename="sarauuthai",
  category="mn",
  description="THAI CHARACTER SARA UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E39,
 },
 [0x0E3A]={
  adobename="phinthuthai",
  category="mn",
  description="THAI CHARACTER PHINTHU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E3A,
 },
 [0x0E3F]={
  adobename="bahtthai",
  category="sc",
  description="THAI CURRENCY SYMBOL BAHT",
  direction="et",
  linebreak="pr",
  unicodeslot=0x0E3F,
 },
 [0x0E40]={
  adobename="saraethai",
  category="lo",
  description="THAI CHARACTER SARA E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E40,
 },
 [0x0E41]={
  adobename="saraaethai",
  category="lo",
  description="THAI CHARACTER SARA AE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E41,
 },
 [0x0E42]={
  adobename="saraothai",
  category="lo",
  description="THAI CHARACTER SARA O",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E42,
 },
 [0x0E43]={
  adobename="saraaimaimuanthai",
  category="lo",
  description="THAI CHARACTER SARA AI MAIMUAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E43,
 },
 [0x0E44]={
  adobename="saraaimaimalaithai",
  category="lo",
  description="THAI CHARACTER SARA AI MAIMALAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E44,
 },
 [0x0E45]={
  adobename="lakkhangyaothai",
  category="lo",
  description="THAI CHARACTER LAKKHANGYAO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E45,
 },
 [0x0E46]={
  adobename="maiyamokthai",
  category="lm",
  description="THAI CHARACTER MAIYAMOK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E46,
 },
 [0x0E47]={
  adobename="maitaikhuthai",
  category="mn",
  description="THAI CHARACTER MAITAIKHU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E47,
 },
 [0x0E48]={
  adobename="maiekthai",
  category="mn",
  description="THAI CHARACTER MAI EK",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E48,
 },
 [0x0E49]={
  adobename="maithothai",
  category="mn",
  description="THAI CHARACTER MAI THO",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E49,
 },
 [0x0E4A]={
  adobename="maitrithai",
  category="mn",
  description="THAI CHARACTER MAI TRI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E4A,
 },
 [0x0E4B]={
  adobename="maichattawathai",
  category="mn",
  description="THAI CHARACTER MAI CHATTAWA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E4B,
 },
 [0x0E4C]={
  adobename="thanthakhatthai",
  category="mn",
  description="THAI CHARACTER THANTHAKHAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E4C,
 },
 [0x0E4D]={
  adobename="nikhahitthai",
  category="mn",
  description="THAI CHARACTER NIKHAHIT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E4D,
 },
 [0x0E4E]={
  adobename="yamakkanthai",
  category="mn",
  description="THAI CHARACTER YAMAKKAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0E4E,
 },
 [0x0E4F]={
  adobename="fongmanthai",
  category="po",
  description="THAI CHARACTER FONGMAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0E4F,
 },
 [0x0E50]={
  adobename="zerothai",
  category="nd",
  description="THAI DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E50,
 },
 [0x0E51]={
  adobename="onethai",
  category="nd",
  description="THAI DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E51,
 },
 [0x0E52]={
  adobename="twothai",
  category="nd",
  description="THAI DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E52,
 },
 [0x0E53]={
  adobename="threethai",
  category="nd",
  description="THAI DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E53,
 },
 [0x0E54]={
  adobename="fourthai",
  category="nd",
  description="THAI DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E54,
 },
 [0x0E55]={
  adobename="fivethai",
  category="nd",
  description="THAI DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E55,
 },
 [0x0E56]={
  adobename="sixthai",
  category="nd",
  description="THAI DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E56,
 },
 [0x0E57]={
  adobename="seventhai",
  category="nd",
  description="THAI DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E57,
 },
 [0x0E58]={
  adobename="eightthai",
  category="nd",
  description="THAI DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E58,
 },
 [0x0E59]={
  adobename="ninethai",
  category="nd",
  description="THAI DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0E59,
 },
 [0x0E5A]={
  adobename="angkhankhuthai",
  category="po",
  description="THAI CHARACTER ANGKHANKHU",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0E5A,
 },
 [0x0E5B]={
  adobename="khomutthai",
  category="po",
  description="THAI CHARACTER KHOMUT",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0E5B,
 },
 [0x0E81]={
  category="lo",
  description="LAO LETTER KO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E81,
 },
 [0x0E82]={
  category="lo",
  description="LAO LETTER KHO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E82,
 },
 [0x0E84]={
  category="lo",
  description="LAO LETTER KHO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E84,
 },
 [0x0E87]={
  category="lo",
  description="LAO LETTER NGO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E87,
 },
 [0x0E88]={
  category="lo",
  description="LAO LETTER CO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E88,
 },
 [0x0E8A]={
  category="lo",
  description="LAO LETTER SO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E8A,
 },
 [0x0E8D]={
  category="lo",
  description="LAO LETTER NYO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E8D,
 },
 [0x0E94]={
  category="lo",
  description="LAO LETTER DO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E94,
 },
 [0x0E95]={
  category="lo",
  description="LAO LETTER TO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E95,
 },
 [0x0E96]={
  category="lo",
  description="LAO LETTER THO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E96,
 },
 [0x0E97]={
  category="lo",
  description="LAO LETTER THO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E97,
 },
 [0x0E99]={
  category="lo",
  description="LAO LETTER NO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E99,
 },
 [0x0E9A]={
  category="lo",
  description="LAO LETTER BO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E9A,
 },
 [0x0E9B]={
  category="lo",
  description="LAO LETTER PO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E9B,
 },
 [0x0E9C]={
  category="lo",
  description="LAO LETTER PHO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E9C,
 },
 [0x0E9D]={
  category="lo",
  description="LAO LETTER FO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E9D,
 },
 [0x0E9E]={
  category="lo",
  description="LAO LETTER PHO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E9E,
 },
 [0x0E9F]={
  category="lo",
  description="LAO LETTER FO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0E9F,
 },
 [0x0EA1]={
  category="lo",
  description="LAO LETTER MO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EA1,
 },
 [0x0EA2]={
  category="lo",
  description="LAO LETTER YO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EA2,
 },
 [0x0EA3]={
  category="lo",
  description="LAO LETTER LO LING",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EA3,
 },
 [0x0EA5]={
  category="lo",
  description="LAO LETTER LO LOOT",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EA5,
 },
 [0x0EA7]={
  category="lo",
  description="LAO LETTER WO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EA7,
 },
 [0x0EAA]={
  category="lo",
  description="LAO LETTER SO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EAA,
 },
 [0x0EAB]={
  category="lo",
  description="LAO LETTER HO SUNG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EAB,
 },
 [0x0EAD]={
  category="lo",
  description="LAO LETTER O",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EAD,
 },
 [0x0EAE]={
  category="lo",
  description="LAO LETTER HO TAM",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EAE,
 },
 [0x0EAF]={
  category="lo",
  description="LAO ELLIPSIS",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EAF,
 },
 [0x0EB0]={
  category="lo",
  description="LAO VOWEL SIGN A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EB0,
 },
 [0x0EB1]={
  category="mn",
  description="LAO VOWEL SIGN MAI KAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EB1,
 },
 [0x0EB2]={
  category="lo",
  description="LAO VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EB2,
 },
 [0x0EB3]={
  category="lo",
  description="LAO VOWEL SIGN AM",
  direction="l",
  linebreak="sa",
  specials={ "compat", 0x0ECD, 0x0EB2 },
  unicodeslot=0x0EB3,
 },
 [0x0EB4]={
  category="mn",
  description="LAO VOWEL SIGN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EB4,
 },
 [0x0EB5]={
  category="mn",
  description="LAO VOWEL SIGN II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EB5,
 },
 [0x0EB6]={
  category="mn",
  description="LAO VOWEL SIGN Y",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EB6,
 },
 [0x0EB7]={
  category="mn",
  description="LAO VOWEL SIGN YY",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EB7,
 },
 [0x0EB8]={
  category="mn",
  description="LAO VOWEL SIGN U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EB8,
 },
 [0x0EB9]={
  category="mn",
  description="LAO VOWEL SIGN UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EB9,
 },
 [0x0EBB]={
  category="mn",
  description="LAO VOWEL SIGN MAI KON",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EBB,
 },
 [0x0EBC]={
  category="mn",
  description="LAO SEMIVOWEL SIGN LO",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EBC,
 },
 [0x0EBD]={
  category="lo",
  description="LAO SEMIVOWEL SIGN NYO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EBD,
 },
 [0x0EC0]={
  category="lo",
  description="LAO VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EC0,
 },
 [0x0EC1]={
  category="lo",
  description="LAO VOWEL SIGN EI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EC1,
 },
 [0x0EC2]={
  category="lo",
  description="LAO VOWEL SIGN O",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EC2,
 },
 [0x0EC3]={
  category="lo",
  description="LAO VOWEL SIGN AY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EC3,
 },
 [0x0EC4]={
  category="lo",
  description="LAO VOWEL SIGN AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EC4,
 },
 [0x0EC6]={
  category="lm",
  description="LAO KO LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x0EC6,
 },
 [0x0EC8]={
  category="mn",
  description="LAO TONE MAI EK",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EC8,
 },
 [0x0EC9]={
  category="mn",
  description="LAO TONE MAI THO",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0EC9,
 },
 [0x0ECA]={
  category="mn",
  description="LAO TONE MAI TI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0ECA,
 },
 [0x0ECB]={
  category="mn",
  description="LAO TONE MAI CATAWA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0ECB,
 },
 [0x0ECC]={
  category="mn",
  description="LAO CANCELLATION MARK",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0ECC,
 },
 [0x0ECD]={
  category="mn",
  description="LAO NIGGAHITA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x0ECD,
 },
 [0x0ED0]={
  category="nd",
  description="LAO DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED0,
 },
 [0x0ED1]={
  category="nd",
  description="LAO DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED1,
 },
 [0x0ED2]={
  category="nd",
  description="LAO DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED2,
 },
 [0x0ED3]={
  category="nd",
  description="LAO DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED3,
 },
 [0x0ED4]={
  category="nd",
  description="LAO DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED4,
 },
 [0x0ED5]={
  category="nd",
  description="LAO DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED5,
 },
 [0x0ED6]={
  category="nd",
  description="LAO DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED6,
 },
 [0x0ED7]={
  category="nd",
  description="LAO DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED7,
 },
 [0x0ED8]={
  category="nd",
  description="LAO DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED8,
 },
 [0x0ED9]={
  category="nd",
  description="LAO DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0ED9,
 },
 [0x0EDC]={
  category="lo",
  description="LAO HO NO",
  direction="l",
  linebreak="sa",
  specials={ "compat", 0x0EAB, 0x0E99 },
  unicodeslot=0x0EDC,
 },
 [0x0EDD]={
  category="lo",
  description="LAO HO MO",
  direction="l",
  linebreak="sa",
  specials={ "compat", 0x0EAB, 0x0EA1 },
  unicodeslot=0x0EDD,
 },
 [0x0F00]={
  category="lo",
  description="TIBETAN SYLLABLE OM",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F00,
 },
 [0x0F01]={
  category="so",
  description="TIBETAN MARK GTER YIG MGO TRUNCATED A",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0F01,
 },
 [0x0F02]={
  category="so",
  description="TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0F02,
 },
 [0x0F03]={
  category="so",
  description="TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0F03,
 },
 [0x0F04]={
  category="po",
  description="TIBETAN MARK INITIAL YIG MGO MDUN MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0F04,
 },
 [0x0F05]={
  category="po",
  description="TIBETAN MARK CLOSING YIG MGO SGAB MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F05,
 },
 [0x0F06]={
  category="po",
  description="TIBETAN MARK CARET YIG MGO PHUR SHAD MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0F06,
 },
 [0x0F07]={
  category="po",
  description="TIBETAN MARK YIG MGO TSHEG SHAD MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0F07,
 },
 [0x0F08]={
  category="po",
  description="TIBETAN MARK SBRUL SHAD",
  direction="l",
  linebreak="gl",
  unicodeslot=0x0F08,
 },
 [0x0F09]={
  category="po",
  description="TIBETAN MARK BSKUR YIG MGO",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0F09,
 },
 [0x0F0A]={
  category="po",
  description="TIBETAN MARK BKA- SHOG YIG MGO",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0F0A,
 },
 [0x0F0B]={
  category="po",
  description="TIBETAN MARK INTERSYLLABIC TSHEG",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0F0B,
 },
 [0x0F0C]={
  category="po",
  description="TIBETAN MARK DELIMITER TSHEG BSTAR",
  direction="l",
  linebreak="gl",
  specials={ "nobreak", 0x0F0B },
  unicodeslot=0x0F0C,
 },
 [0x0F0D]={
  category="po",
  description="TIBETAN MARK SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0x0F0D,
 },
 [0x0F0E]={
  category="po",
  description="TIBETAN MARK NYIS SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0x0F0E,
 },
 [0x0F0F]={
  category="po",
  description="TIBETAN MARK TSHEG SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0x0F0F,
 },
 [0x0F10]={
  category="po",
  description="TIBETAN MARK NYIS TSHEG SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0x0F10,
 },
 [0x0F11]={
  category="po",
  description="TIBETAN MARK RIN CHEN SPUNGS SHAD",
  direction="l",
  linebreak="ex",
  unicodeslot=0x0F11,
 },
 [0x0F12]={
  category="po",
  description="TIBETAN MARK RGYA GRAM SHAD",
  direction="l",
  linebreak="gl",
  unicodeslot=0x0F12,
 },
 [0x0F13]={
  category="so",
  description="TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F13,
 },
 [0x0F14]={
  category="so",
  description="TIBETAN MARK GTER TSHEG",
  direction="l",
  linebreak="ex",
  unicodeslot=0x0F14,
 },
 [0x0F15]={
  category="so",
  description="TIBETAN LOGOTYPE SIGN CHAD RTAGS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F15,
 },
 [0x0F16]={
  category="so",
  description="TIBETAN LOGOTYPE SIGN LHAG RTAGS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F16,
 },
 [0x0F17]={
  category="so",
  description="TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F17,
 },
 [0x0F18]={
  category="mn",
  description="TIBETAN ASTROLOGICAL SIGN -KHYUD PA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F18,
 },
 [0x0F19]={
  category="mn",
  description="TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F19,
 },
 [0x0F1A]={
  category="so",
  description="TIBETAN SIGN RDEL DKAR GCIG",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F1A,
 },
 [0x0F1B]={
  category="so",
  description="TIBETAN SIGN RDEL DKAR GNYIS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F1B,
 },
 [0x0F1C]={
  category="so",
  description="TIBETAN SIGN RDEL DKAR GSUM",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F1C,
 },
 [0x0F1D]={
  category="so",
  description="TIBETAN SIGN RDEL NAG GCIG",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F1D,
 },
 [0x0F1E]={
  category="so",
  description="TIBETAN SIGN RDEL NAG GNYIS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F1E,
 },
 [0x0F1F]={
  category="so",
  description="TIBETAN SIGN RDEL DKAR RDEL NAG",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F1F,
 },
 [0x0F20]={
  category="nd",
  description="TIBETAN DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F20,
 },
 [0x0F21]={
  category="nd",
  description="TIBETAN DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F21,
 },
 [0x0F22]={
  category="nd",
  description="TIBETAN DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F22,
 },
 [0x0F23]={
  category="nd",
  description="TIBETAN DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F23,
 },
 [0x0F24]={
  category="nd",
  description="TIBETAN DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F24,
 },
 [0x0F25]={
  category="nd",
  description="TIBETAN DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F25,
 },
 [0x0F26]={
  category="nd",
  description="TIBETAN DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F26,
 },
 [0x0F27]={
  category="nd",
  description="TIBETAN DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F27,
 },
 [0x0F28]={
  category="nd",
  description="TIBETAN DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F28,
 },
 [0x0F29]={
  category="nd",
  description="TIBETAN DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x0F29,
 },
 [0x0F2A]={
  category="no",
  description="TIBETAN DIGIT HALF ONE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F2A,
 },
 [0x0F2B]={
  category="no",
  description="TIBETAN DIGIT HALF TWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F2B,
 },
 [0x0F2C]={
  category="no",
  description="TIBETAN DIGIT HALF THREE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F2C,
 },
 [0x0F2D]={
  category="no",
  description="TIBETAN DIGIT HALF FOUR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F2D,
 },
 [0x0F2E]={
  category="no",
  description="TIBETAN DIGIT HALF FIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F2E,
 },
 [0x0F2F]={
  category="no",
  description="TIBETAN DIGIT HALF SIX",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F2F,
 },
 [0x0F30]={
  category="no",
  description="TIBETAN DIGIT HALF SEVEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F30,
 },
 [0x0F31]={
  category="no",
  description="TIBETAN DIGIT HALF EIGHT",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F31,
 },
 [0x0F32]={
  category="no",
  description="TIBETAN DIGIT HALF NINE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F32,
 },
 [0x0F33]={
  category="no",
  description="TIBETAN DIGIT HALF ZERO",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F33,
 },
 [0x0F34]={
  category="so",
  description="TIBETAN MARK BSDUS RTAGS",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0F34,
 },
 [0x0F35]={
  category="mn",
  description="TIBETAN MARK NGAS BZUNG NYI ZLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F35,
 },
 [0x0F36]={
  category="so",
  description="TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F36,
 },
 [0x0F37]={
  category="mn",
  description="TIBETAN MARK NGAS BZUNG SGOR RTAGS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F37,
 },
 [0x0F38]={
  category="so",
  description="TIBETAN MARK CHE MGO",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F38,
 },
 [0x0F39]={
  category="mn",
  description="TIBETAN MARK TSA -PHRU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F39,
 },
 [0x0F3A]={
  category="ps",
  description="TIBETAN MARK GUG RTAGS GYON",
  direction="on",
  linebreak="op",
  mirror=0x0F3B,
  unicodeslot=0x0F3A,
 },
 [0x0F3B]={
  category="pe",
  description="TIBETAN MARK GUG RTAGS GYAS",
  direction="on",
  linebreak="cl",
  mirror=0x0F3A,
  unicodeslot=0x0F3B,
 },
 [0x0F3C]={
  category="ps",
  description="TIBETAN MARK ANG KHANG GYON",
  direction="on",
  linebreak="op",
  mirror=0x0F3D,
  unicodeslot=0x0F3C,
 },
 [0x0F3D]={
  category="pe",
  description="TIBETAN MARK ANG KHANG GYAS",
  direction="on",
  linebreak="cl",
  mirror=0x0F3C,
  unicodeslot=0x0F3D,
 },
 [0x0F3E]={
  category="mc",
  description="TIBETAN SIGN YAR TSHES",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0F3E,
 },
 [0x0F3F]={
  category="mc",
  description="TIBETAN SIGN MAR TSHES",
  direction="l",
  linebreak="cm",
  unicodeslot=0x0F3F,
 },
 [0x0F40]={
  category="lo",
  description="TIBETAN LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F40,
 },
 [0x0F41]={
  category="lo",
  description="TIBETAN LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F41,
 },
 [0x0F42]={
  category="lo",
  description="TIBETAN LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F42,
 },
 [0x0F43]={
  category="lo",
  description="TIBETAN LETTER GHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0F42, 0x0FB7 },
  unicodeslot=0x0F43,
 },
 [0x0F44]={
  category="lo",
  description="TIBETAN LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F44,
 },
 [0x0F45]={
  category="lo",
  description="TIBETAN LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F45,
 },
 [0x0F46]={
  category="lo",
  description="TIBETAN LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F46,
 },
 [0x0F47]={
  category="lo",
  description="TIBETAN LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F47,
 },
 [0x0F49]={
  category="lo",
  description="TIBETAN LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F49,
 },
 [0x0F4A]={
  category="lo",
  description="TIBETAN LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F4A,
 },
 [0x0F4B]={
  category="lo",
  description="TIBETAN LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F4B,
 },
 [0x0F4C]={
  category="lo",
  description="TIBETAN LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F4C,
 },
 [0x0F4D]={
  category="lo",
  description="TIBETAN LETTER DDHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0F4C, 0x0FB7 },
  unicodeslot=0x0F4D,
 },
 [0x0F4E]={
  category="lo",
  description="TIBETAN LETTER NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F4E,
 },
 [0x0F4F]={
  category="lo",
  description="TIBETAN LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F4F,
 },
 [0x0F50]={
  category="lo",
  description="TIBETAN LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F50,
 },
 [0x0F51]={
  category="lo",
  description="TIBETAN LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F51,
 },
 [0x0F52]={
  category="lo",
  description="TIBETAN LETTER DHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0F51, 0x0FB7 },
  unicodeslot=0x0F52,
 },
 [0x0F53]={
  category="lo",
  description="TIBETAN LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F53,
 },
 [0x0F54]={
  category="lo",
  description="TIBETAN LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F54,
 },
 [0x0F55]={
  category="lo",
  description="TIBETAN LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F55,
 },
 [0x0F56]={
  category="lo",
  description="TIBETAN LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F56,
 },
 [0x0F57]={
  category="lo",
  description="TIBETAN LETTER BHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0F56, 0x0FB7 },
  unicodeslot=0x0F57,
 },
 [0x0F58]={
  category="lo",
  description="TIBETAN LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F58,
 },
 [0x0F59]={
  category="lo",
  description="TIBETAN LETTER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F59,
 },
 [0x0F5A]={
  category="lo",
  description="TIBETAN LETTER TSHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F5A,
 },
 [0x0F5B]={
  category="lo",
  description="TIBETAN LETTER DZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F5B,
 },
 [0x0F5C]={
  category="lo",
  description="TIBETAN LETTER DZHA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0F5B, 0x0FB7 },
  unicodeslot=0x0F5C,
 },
 [0x0F5D]={
  category="lo",
  description="TIBETAN LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F5D,
 },
 [0x0F5E]={
  category="lo",
  description="TIBETAN LETTER ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F5E,
 },
 [0x0F5F]={
  category="lo",
  description="TIBETAN LETTER ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F5F,
 },
 [0x0F60]={
  category="lo",
  description="TIBETAN LETTER -A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F60,
 },
 [0x0F61]={
  category="lo",
  description="TIBETAN LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F61,
 },
 [0x0F62]={
  category="lo",
  description="TIBETAN LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F62,
 },
 [0x0F63]={
  category="lo",
  description="TIBETAN LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F63,
 },
 [0x0F64]={
  category="lo",
  description="TIBETAN LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F64,
 },
 [0x0F65]={
  category="lo",
  description="TIBETAN LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F65,
 },
 [0x0F66]={
  category="lo",
  description="TIBETAN LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F66,
 },
 [0x0F67]={
  category="lo",
  description="TIBETAN LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F67,
 },
 [0x0F68]={
  category="lo",
  description="TIBETAN LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F68,
 },
 [0x0F69]={
  category="lo",
  description="TIBETAN LETTER KSSA",
  direction="l",
  linebreak="al",
  specials={ "char", 0x0F40, 0x0FB5 },
  unicodeslot=0x0F69,
 },
 [0x0F6A]={
  category="lo",
  description="TIBETAN LETTER FIXED-FORM RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F6A,
 },
 [0x0F6B]={
  category="lo",
  description="TIBETAN LETTER KKA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F6B,
 },
 [0x0F6C]={
  category="lo",
  description="TIBETAN LETTER RRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F6C,
 },
 [0x0F71]={
  category="mn",
  description="TIBETAN VOWEL SIGN AA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F71,
 },
 [0x0F72]={
  category="mn",
  description="TIBETAN VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F72,
 },
 [0x0F73]={
  category="mn",
  description="TIBETAN VOWEL SIGN II",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0F71, 0x0F72 },
  unicodeslot=0x0F73,
 },
 [0x0F74]={
  category="mn",
  description="TIBETAN VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F74,
 },
 [0x0F75]={
  category="mn",
  description="TIBETAN VOWEL SIGN UU",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0F71, 0x0F74 },
  unicodeslot=0x0F75,
 },
 [0x0F76]={
  category="mn",
  description="TIBETAN VOWEL SIGN VOCALIC R",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0FB2, 0x0F80 },
  unicodeslot=0x0F76,
 },
 [0x0F77]={
  category="mn",
  description="TIBETAN VOWEL SIGN VOCALIC RR",
  direction="nsm",
  linebreak="cm",
  specials={ "compat", 0x0FB2, 0x0F81 },
  unicodeslot=0x0F77,
 },
 [0x0F78]={
  category="mn",
  description="TIBETAN VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0FB3, 0x0F80 },
  unicodeslot=0x0F78,
 },
 [0x0F79]={
  category="mn",
  description="TIBETAN VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="cm",
  specials={ "compat", 0x0FB3, 0x0F81 },
  unicodeslot=0x0F79,
 },
 [0x0F7A]={
  category="mn",
  description="TIBETAN VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F7A,
 },
 [0x0F7B]={
  category="mn",
  description="TIBETAN VOWEL SIGN EE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F7B,
 },
 [0x0F7C]={
  category="mn",
  description="TIBETAN VOWEL SIGN O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F7C,
 },
 [0x0F7D]={
  category="mn",
  description="TIBETAN VOWEL SIGN OO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F7D,
 },
 [0x0F7E]={
  category="mn",
  description="TIBETAN SIGN RJES SU NGA RO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F7E,
 },
 [0x0F7F]={
  category="mc",
  description="TIBETAN SIGN RNAM BCAD",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0F7F,
 },
 [0x0F80]={
  category="mn",
  description="TIBETAN VOWEL SIGN REVERSED I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F80,
 },
 [0x0F81]={
  category="mn",
  description="TIBETAN VOWEL SIGN REVERSED II",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0F71, 0x0F80 },
  unicodeslot=0x0F81,
 },
 [0x0F82]={
  category="mn",
  description="TIBETAN SIGN NYI ZLA NAA DA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F82,
 },
 [0x0F83]={
  category="mn",
  description="TIBETAN SIGN SNA LDAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F83,
 },
 [0x0F84]={
  category="mn",
  description="TIBETAN MARK HALANTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F84,
 },
 [0x0F85]={
  category="po",
  description="TIBETAN MARK PALUTA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0F85,
 },
 [0x0F86]={
  category="mn",
  description="TIBETAN SIGN LCI RTAGS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F86,
 },
 [0x0F87]={
  category="mn",
  description="TIBETAN SIGN YANG RTAGS",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F87,
 },
 [0x0F88]={
  category="lo",
  description="TIBETAN SIGN LCE TSA CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F88,
 },
 [0x0F89]={
  category="lo",
  description="TIBETAN SIGN MCHU CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F89,
 },
 [0x0F8A]={
  category="lo",
  description="TIBETAN SIGN GRU CAN RGYINGS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F8A,
 },
 [0x0F8B]={
  category="lo",
  description="TIBETAN SIGN GRU MED RGYINGS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F8B,
 },
 [0x0F8C]={
  category="lo",
  description="TIBETAN SIGN INVERTED MCHU CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0F8C,
 },
 [0x0F8D]={
  category="mn",
  description="TIBETAN SUBJOINED SIGN LCE TSA CAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F8D,
 },
 [0x0F8E]={
  category="mn",
  description="TIBETAN SUBJOINED SIGN MCHU CAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F8E,
 },
 [0x0F8F]={
  category="mn",
  description="TIBETAN SUBJOINED SIGN INVERTED MCHU CAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F8F,
 },
 [0x0F90]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER KA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F90,
 },
 [0x0F91]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER KHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F91,
 },
 [0x0F92]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER GA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F92,
 },
 [0x0F93]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER GHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0F92, 0x0FB7 },
  unicodeslot=0x0F93,
 },
 [0x0F94]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER NGA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F94,
 },
 [0x0F95]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER CA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F95,
 },
 [0x0F96]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER CHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F96,
 },
 [0x0F97]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER JA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F97,
 },
 [0x0F99]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER NYA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F99,
 },
 [0x0F9A]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F9A,
 },
 [0x0F9B]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TTHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F9B,
 },
 [0x0F9C]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F9C,
 },
 [0x0F9D]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DDHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0F9C, 0x0FB7 },
  unicodeslot=0x0F9D,
 },
 [0x0F9E]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER NNA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F9E,
 },
 [0x0F9F]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0F9F,
 },
 [0x0FA0]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER THA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FA0,
 },
 [0x0FA1]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FA1,
 },
 [0x0FA2]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0FA1, 0x0FB7 },
  unicodeslot=0x0FA2,
 },
 [0x0FA3]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER NA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FA3,
 },
 [0x0FA4]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER PA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FA4,
 },
 [0x0FA5]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER PHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FA5,
 },
 [0x0FA6]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER BA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FA6,
 },
 [0x0FA7]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER BHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0FA6, 0x0FB7 },
  unicodeslot=0x0FA7,
 },
 [0x0FA8]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER MA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FA8,
 },
 [0x0FA9]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TSA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FA9,
 },
 [0x0FAA]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER TSHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FAA,
 },
 [0x0FAB]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DZA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FAB,
 },
 [0x0FAC]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER DZHA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0FAB, 0x0FB7 },
  unicodeslot=0x0FAC,
 },
 [0x0FAD]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER WA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FAD,
 },
 [0x0FAE]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER ZHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FAE,
 },
 [0x0FAF]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER ZA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FAF,
 },
 [0x0FB0]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER -A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FB0,
 },
 [0x0FB1]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER YA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FB1,
 },
 [0x0FB2]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER RA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FB2,
 },
 [0x0FB3]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER LA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FB3,
 },
 [0x0FB4]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER SHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FB4,
 },
 [0x0FB5]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER SSA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FB5,
 },
 [0x0FB6]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER SA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FB6,
 },
 [0x0FB7]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER HA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FB7,
 },
 [0x0FB8]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FB8,
 },
 [0x0FB9]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER KSSA",
  direction="nsm",
  linebreak="cm",
  specials={ "char", 0x0F90, 0x0FB5 },
  unicodeslot=0x0FB9,
 },
 [0x0FBA]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER FIXED-FORM WA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FBA,
 },
 [0x0FBB]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER FIXED-FORM YA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FBB,
 },
 [0x0FBC]={
  category="mn",
  description="TIBETAN SUBJOINED LETTER FIXED-FORM RA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FBC,
 },
 [0x0FBE]={
  category="so",
  description="TIBETAN KU RU KHA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0FBE,
 },
 [0x0FBF]={
  category="so",
  description="TIBETAN KU RU KHA BZHI MIG CAN",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0FBF,
 },
 [0x0FC0]={
  category="so",
  description="TIBETAN CANTILLATION SIGN HEAVY BEAT",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FC0,
 },
 [0x0FC1]={
  category="so",
  description="TIBETAN CANTILLATION SIGN LIGHT BEAT",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FC1,
 },
 [0x0FC2]={
  category="so",
  description="TIBETAN CANTILLATION SIGN CANG TE-U",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FC2,
 },
 [0x0FC3]={
  category="so",
  description="TIBETAN CANTILLATION SIGN SBUB -CHAL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FC3,
 },
 [0x0FC4]={
  category="so",
  description="TIBETAN SYMBOL DRIL BU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FC4,
 },
 [0x0FC5]={
  category="so",
  description="TIBETAN SYMBOL RDO RJE",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FC5,
 },
 [0x0FC6]={
  category="mn",
  description="TIBETAN SYMBOL PADMA GDAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x0FC6,
 },
 [0x0FC7]={
  category="so",
  description="TIBETAN SYMBOL RDO RJE RGYA GRAM",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FC7,
 },
 [0x0FC8]={
  category="so",
  description="TIBETAN SYMBOL PHUR PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FC8,
 },
 [0x0FC9]={
  category="so",
  description="TIBETAN SYMBOL NOR BU",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FC9,
 },
 [0x0FCA]={
  category="so",
  description="TIBETAN SYMBOL NOR BU NYIS -KHYIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FCA,
 },
 [0x0FCB]={
  category="so",
  description="TIBETAN SYMBOL NOR BU GSUM -KHYIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FCB,
 },
 [0x0FCC]={
  category="so",
  description="TIBETAN SYMBOL NOR BU BZHI -KHYIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FCC,
 },
 [0x0FCE]={
  category="so",
  description="TIBETAN SIGN RDEL NAG RDEL DKAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FCE,
 },
 [0x0FCF]={
  category="so",
  description="TIBETAN SIGN RDEL NAG GSUM",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FCF,
 },
 [0x0FD0]={
  category="po",
  description="TIBETAN MARK BSKA- SHOG GI MGO RGYAN",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0FD0,
 },
 [0x0FD1]={
  category="po",
  description="TIBETAN MARK MNYAM YIG GI MGO RGYAN",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0FD1,
 },
 [0x0FD2]={
  category="po",
  description="TIBETAN MARK NYIS TSHEG",
  direction="l",
  linebreak="ba",
  unicodeslot=0x0FD2,
 },
 [0x0FD3]={
  category="po",
  description="TIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MA",
  direction="l",
  linebreak="bb",
  unicodeslot=0x0FD3,
 },
 [0x0FD4]={
  category="po",
  description="TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FD4,
 },
 [0x0FD5]={
  category="so",
  description="RIGHT-FACING SVASTI SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FD5,
 },
 [0x0FD6]={
  category="so",
  description="LEFT-FACING SVASTI SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FD6,
 },
 [0x0FD7]={
  category="so",
  description="RIGHT-FACING SVASTI SIGN WITH DOTS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FD7,
 },
 [0x0FD8]={
  category="so",
  description="LEFT-FACING SVASTI SIGN WITH DOTS",
  direction="l",
  linebreak="al",
  unicodeslot=0x0FD8,
 },
 [0x0FD9]={
  category="po",
  description="TIBETAN MARK LEADING MCHAN RTAGS",
  direction="l",
  linebreak="gl",
  unicodeslot=0x0FD9,
 },
 [0x0FDA]={
  category="po",
  description="TIBETAN MARK TRAILING MCHAN RTAGS",
  direction="l",
  linebreak="gl",
  unicodeslot=0x0FDA,
 },
 [0x1000]={
  category="lo",
  description="MYANMAR LETTER KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1000,
 },
 [0x1001]={
  category="lo",
  description="MYANMAR LETTER KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1001,
 },
 [0x1002]={
  category="lo",
  description="MYANMAR LETTER GA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1002,
 },
 [0x1003]={
  category="lo",
  description="MYANMAR LETTER GHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1003,
 },
 [0x1004]={
  category="lo",
  description="MYANMAR LETTER NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1004,
 },
 [0x1005]={
  category="lo",
  description="MYANMAR LETTER CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1005,
 },
 [0x1006]={
  category="lo",
  description="MYANMAR LETTER CHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1006,
 },
 [0x1007]={
  category="lo",
  description="MYANMAR LETTER JA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1007,
 },
 [0x1008]={
  category="lo",
  description="MYANMAR LETTER JHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1008,
 },
 [0x1009]={
  category="lo",
  description="MYANMAR LETTER NYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1009,
 },
 [0x100A]={
  category="lo",
  description="MYANMAR LETTER NNYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100A,
 },
 [0x100B]={
  category="lo",
  description="MYANMAR LETTER TTA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100B,
 },
 [0x100C]={
  category="lo",
  description="MYANMAR LETTER TTHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100C,
 },
 [0x100D]={
  category="lo",
  description="MYANMAR LETTER DDA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100D,
 },
 [0x100E]={
  category="lo",
  description="MYANMAR LETTER DDHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100E,
 },
 [0x100F]={
  category="lo",
  description="MYANMAR LETTER NNA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x100F,
 },
 [0x1010]={
  category="lo",
  description="MYANMAR LETTER TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1010,
 },
 [0x1011]={
  category="lo",
  description="MYANMAR LETTER THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1011,
 },
 [0x1012]={
  category="lo",
  description="MYANMAR LETTER DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1012,
 },
 [0x1013]={
  category="lo",
  description="MYANMAR LETTER DHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1013,
 },
 [0x1014]={
  category="lo",
  description="MYANMAR LETTER NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1014,
 },
 [0x1015]={
  category="lo",
  description="MYANMAR LETTER PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1015,
 },
 [0x1016]={
  category="lo",
  description="MYANMAR LETTER PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1016,
 },
 [0x1017]={
  category="lo",
  description="MYANMAR LETTER BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1017,
 },
 [0x1018]={
  category="lo",
  description="MYANMAR LETTER BHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1018,
 },
 [0x1019]={
  category="lo",
  description="MYANMAR LETTER MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1019,
 },
 [0x101A]={
  category="lo",
  description="MYANMAR LETTER YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101A,
 },
 [0x101B]={
  category="lo",
  description="MYANMAR LETTER RA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101B,
 },
 [0x101C]={
  category="lo",
  description="MYANMAR LETTER LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101C,
 },
 [0x101D]={
  category="lo",
  description="MYANMAR LETTER WA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101D,
 },
 [0x101E]={
  category="lo",
  description="MYANMAR LETTER SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101E,
 },
 [0x101F]={
  category="lo",
  description="MYANMAR LETTER HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x101F,
 },
 [0x1020]={
  category="lo",
  description="MYANMAR LETTER LLA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1020,
 },
 [0x1021]={
  category="lo",
  description="MYANMAR LETTER A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1021,
 },
 [0x1022]={
  category="lo",
  description="MYANMAR LETTER SHAN A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1022,
 },
 [0x1023]={
  category="lo",
  description="MYANMAR LETTER I",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1023,
 },
 [0x1024]={
  category="lo",
  description="MYANMAR LETTER II",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1024,
 },
 [0x1025]={
  category="lo",
  description="MYANMAR LETTER U",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1025,
 },
 [0x1026]={
  category="lo",
  description="MYANMAR LETTER UU",
  direction="l",
  linebreak="sa",
  specials={ "char", 0x1025, 0x102E },
  unicodeslot=0x1026,
 },
 [0x1027]={
  category="lo",
  description="MYANMAR LETTER E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1027,
 },
 [0x1028]={
  category="lo",
  description="MYANMAR LETTER MON E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1028,
 },
 [0x1029]={
  category="lo",
  description="MYANMAR LETTER O",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1029,
 },
 [0x102A]={
  category="lo",
  description="MYANMAR LETTER AU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x102A,
 },
 [0x102B]={
  category="mc",
  description="MYANMAR VOWEL SIGN TALL AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x102B,
 },
 [0x102C]={
  category="mc",
  description="MYANMAR VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x102C,
 },
 [0x102D]={
  category="mn",
  description="MYANMAR VOWEL SIGN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x102D,
 },
 [0x102E]={
  category="mn",
  description="MYANMAR VOWEL SIGN II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x102E,
 },
 [0x102F]={
  category="mn",
  description="MYANMAR VOWEL SIGN U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x102F,
 },
 [0x1030]={
  category="mn",
  description="MYANMAR VOWEL SIGN UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1030,
 },
 [0x1031]={
  category="mc",
  description="MYANMAR VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1031,
 },
 [0x1032]={
  category="mn",
  description="MYANMAR VOWEL SIGN AI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1032,
 },
 [0x1033]={
  category="mn",
  description="MYANMAR VOWEL SIGN MON II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1033,
 },
 [0x1034]={
  category="mn",
  description="MYANMAR VOWEL SIGN MON O",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1034,
 },
 [0x1035]={
  category="mn",
  description="MYANMAR VOWEL SIGN E ABOVE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1035,
 },
 [0x1036]={
  category="mn",
  description="MYANMAR SIGN ANUSVARA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1036,
 },
 [0x1037]={
  category="mn",
  description="MYANMAR SIGN DOT BELOW",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1037,
 },
 [0x1038]={
  category="mc",
  description="MYANMAR SIGN VISARGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1038,
 },
 [0x1039]={
  category="mn",
  description="MYANMAR SIGN VIRAMA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1039,
 },
 [0x103A]={
  category="mn",
  description="MYANMAR SIGN ASAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x103A,
 },
 [0x103B]={
  category="mc",
  description="MYANMAR CONSONANT SIGN MEDIAL YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x103B,
 },
 [0x103C]={
  category="mc",
  description="MYANMAR CONSONANT SIGN MEDIAL RA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x103C,
 },
 [0x103D]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MEDIAL WA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x103D,
 },
 [0x103E]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MEDIAL HA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x103E,
 },
 [0x103F]={
  category="lo",
  description="MYANMAR LETTER GREAT SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x103F,
 },
 [0x1040]={
  category="nd",
  description="MYANMAR DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1040,
 },
 [0x1041]={
  category="nd",
  description="MYANMAR DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1041,
 },
 [0x1042]={
  category="nd",
  description="MYANMAR DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1042,
 },
 [0x1043]={
  category="nd",
  description="MYANMAR DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1043,
 },
 [0x1044]={
  category="nd",
  description="MYANMAR DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1044,
 },
 [0x1045]={
  category="nd",
  description="MYANMAR DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1045,
 },
 [0x1046]={
  category="nd",
  description="MYANMAR DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1046,
 },
 [0x1047]={
  category="nd",
  description="MYANMAR DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1047,
 },
 [0x1048]={
  category="nd",
  description="MYANMAR DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1048,
 },
 [0x1049]={
  category="nd",
  description="MYANMAR DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1049,
 },
 [0x104A]={
  category="po",
  description="MYANMAR SIGN LITTLE SECTION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x104A,
 },
 [0x104B]={
  category="po",
  description="MYANMAR SIGN SECTION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x104B,
 },
 [0x104C]={
  category="po",
  description="MYANMAR SYMBOL LOCATIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x104C,
 },
 [0x104D]={
  category="po",
  description="MYANMAR SYMBOL COMPLETED",
  direction="l",
  linebreak="al",
  unicodeslot=0x104D,
 },
 [0x104E]={
  category="po",
  description="MYANMAR SYMBOL AFOREMENTIONED",
  direction="l",
  linebreak="al",
  unicodeslot=0x104E,
 },
 [0x104F]={
  category="po",
  description="MYANMAR SYMBOL GENITIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x104F,
 },
 [0x1050]={
  category="lo",
  description="MYANMAR LETTER SHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1050,
 },
 [0x1051]={
  category="lo",
  description="MYANMAR LETTER SSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1051,
 },
 [0x1052]={
  category="lo",
  description="MYANMAR LETTER VOCALIC R",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1052,
 },
 [0x1053]={
  category="lo",
  description="MYANMAR LETTER VOCALIC RR",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1053,
 },
 [0x1054]={
  category="lo",
  description="MYANMAR LETTER VOCALIC L",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1054,
 },
 [0x1055]={
  category="lo",
  description="MYANMAR LETTER VOCALIC LL",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1055,
 },
 [0x1056]={
  category="mc",
  description="MYANMAR VOWEL SIGN VOCALIC R",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1056,
 },
 [0x1057]={
  category="mc",
  description="MYANMAR VOWEL SIGN VOCALIC RR",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1057,
 },
 [0x1058]={
  category="mn",
  description="MYANMAR VOWEL SIGN VOCALIC L",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1058,
 },
 [0x1059]={
  category="mn",
  description="MYANMAR VOWEL SIGN VOCALIC LL",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1059,
 },
 [0x105A]={
  category="lo",
  description="MYANMAR LETTER MON NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x105A,
 },
 [0x105B]={
  category="lo",
  description="MYANMAR LETTER MON JHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x105B,
 },
 [0x105C]={
  category="lo",
  description="MYANMAR LETTER MON BBA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x105C,
 },
 [0x105D]={
  category="lo",
  description="MYANMAR LETTER MON BBE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x105D,
 },
 [0x105E]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MON MEDIAL NA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x105E,
 },
 [0x105F]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MON MEDIAL MA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x105F,
 },
 [0x1060]={
  category="mn",
  description="MYANMAR CONSONANT SIGN MON MEDIAL LA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1060,
 },
 [0x1061]={
  category="lo",
  description="MYANMAR LETTER SGAW KAREN SHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1061,
 },
 [0x1062]={
  category="mc",
  description="MYANMAR VOWEL SIGN SGAW KAREN EU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1062,
 },
 [0x1063]={
  category="mc",
  description="MYANMAR TONE MARK SGAW KAREN HATHI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1063,
 },
 [0x1064]={
  category="mc",
  description="MYANMAR TONE MARK SGAW KAREN KE PHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1064,
 },
 [0x1065]={
  category="lo",
  description="MYANMAR LETTER WESTERN PWO KAREN THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1065,
 },
 [0x1066]={
  category="lo",
  description="MYANMAR LETTER WESTERN PWO KAREN PWA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1066,
 },
 [0x1067]={
  category="mc",
  description="MYANMAR VOWEL SIGN WESTERN PWO KAREN EU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1067,
 },
 [0x1068]={
  category="mc",
  description="MYANMAR VOWEL SIGN WESTERN PWO KAREN UE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1068,
 },
 [0x1069]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-1",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1069,
 },
 [0x106A]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-2",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106A,
 },
 [0x106B]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-3",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106B,
 },
 [0x106C]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-4",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106C,
 },
 [0x106D]={
  category="mc",
  description="MYANMAR SIGN WESTERN PWO KAREN TONE-5",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106D,
 },
 [0x106E]={
  category="lo",
  description="MYANMAR LETTER EASTERN PWO KAREN NNA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106E,
 },
 [0x106F]={
  category="lo",
  description="MYANMAR LETTER EASTERN PWO KAREN YWA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x106F,
 },
 [0x1070]={
  category="lo",
  description="MYANMAR LETTER EASTERN PWO KAREN GHWA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1070,
 },
 [0x1071]={
  category="mn",
  description="MYANMAR VOWEL SIGN GEBA KAREN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1071,
 },
 [0x1072]={
  category="mn",
  description="MYANMAR VOWEL SIGN KAYAH OE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1072,
 },
 [0x1073]={
  category="mn",
  description="MYANMAR VOWEL SIGN KAYAH U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1073,
 },
 [0x1074]={
  category="mn",
  description="MYANMAR VOWEL SIGN KAYAH EE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1074,
 },
 [0x1075]={
  category="lo",
  description="MYANMAR LETTER SHAN KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1075,
 },
 [0x1076]={
  category="lo",
  description="MYANMAR LETTER SHAN KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1076,
 },
 [0x1077]={
  category="lo",
  description="MYANMAR LETTER SHAN GA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1077,
 },
 [0x1078]={
  category="lo",
  description="MYANMAR LETTER SHAN CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1078,
 },
 [0x1079]={
  category="lo",
  description="MYANMAR LETTER SHAN ZA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1079,
 },
 [0x107A]={
  category="lo",
  description="MYANMAR LETTER SHAN NYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107A,
 },
 [0x107B]={
  category="lo",
  description="MYANMAR LETTER SHAN DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107B,
 },
 [0x107C]={
  category="lo",
  description="MYANMAR LETTER SHAN NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107C,
 },
 [0x107D]={
  category="lo",
  description="MYANMAR LETTER SHAN PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107D,
 },
 [0x107E]={
  category="lo",
  description="MYANMAR LETTER SHAN FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107E,
 },
 [0x107F]={
  category="lo",
  description="MYANMAR LETTER SHAN BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x107F,
 },
 [0x1080]={
  category="lo",
  description="MYANMAR LETTER SHAN THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1080,
 },
 [0x1081]={
  category="lo",
  description="MYANMAR LETTER SHAN HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1081,
 },
 [0x1082]={
  category="mn",
  description="MYANMAR CONSONANT SIGN SHAN MEDIAL WA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1082,
 },
 [0x1083]={
  category="mc",
  description="MYANMAR VOWEL SIGN SHAN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1083,
 },
 [0x1084]={
  category="mc",
  description="MYANMAR VOWEL SIGN SHAN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1084,
 },
 [0x1085]={
  category="mn",
  description="MYANMAR VOWEL SIGN SHAN E ABOVE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1085,
 },
 [0x1086]={
  category="mn",
  description="MYANMAR VOWEL SIGN SHAN FINAL Y",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1086,
 },
 [0x1087]={
  category="mc",
  description="MYANMAR SIGN SHAN TONE-2",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1087,
 },
 [0x1088]={
  category="mc",
  description="MYANMAR SIGN SHAN TONE-3",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1088,
 },
 [0x1089]={
  category="mc",
  description="MYANMAR SIGN SHAN TONE-5",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1089,
 },
 [0x108A]={
  category="mc",
  description="MYANMAR SIGN SHAN TONE-6",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108A,
 },
 [0x108B]={
  category="mc",
  description="MYANMAR SIGN SHAN COUNCIL TONE-2",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108B,
 },
 [0x108C]={
  category="mc",
  description="MYANMAR SIGN SHAN COUNCIL TONE-3",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108C,
 },
 [0x108D]={
  category="mn",
  description="MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x108D,
 },
 [0x108E]={
  category="lo",
  description="MYANMAR LETTER RUMAI PALAUNG FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108E,
 },
 [0x108F]={
  category="mc",
  description="MYANMAR SIGN RUMAI PALAUNG TONE-5",
  direction="l",
  linebreak="sa",
  unicodeslot=0x108F,
 },
 [0x1090]={
  category="nd",
  description="MYANMAR SHAN DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1090,
 },
 [0x1091]={
  category="nd",
  description="MYANMAR SHAN DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1091,
 },
 [0x1092]={
  category="nd",
  description="MYANMAR SHAN DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1092,
 },
 [0x1093]={
  category="nd",
  description="MYANMAR SHAN DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1093,
 },
 [0x1094]={
  category="nd",
  description="MYANMAR SHAN DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1094,
 },
 [0x1095]={
  category="nd",
  description="MYANMAR SHAN DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1095,
 },
 [0x1096]={
  category="nd",
  description="MYANMAR SHAN DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1096,
 },
 [0x1097]={
  category="nd",
  description="MYANMAR SHAN DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1097,
 },
 [0x1098]={
  category="nd",
  description="MYANMAR SHAN DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1098,
 },
 [0x1099]={
  category="nd",
  description="MYANMAR SHAN DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1099,
 },
 [0x109A]={
  category="mc",
  description="MYANMAR SIGN KHAMTI TONE-1",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109A,
 },
 [0x109B]={
  category="mc",
  description="MYANMAR SIGN KHAMTI TONE-3",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109B,
 },
 [0x109C]={
  category="mc",
  description="MYANMAR VOWEL SIGN AITON A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109C,
 },
 [0x109D]={
  category="mn",
  description="MYANMAR VOWEL SIGN AITON AI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x109D,
 },
 [0x109E]={
  category="so",
  description="MYANMAR SYMBOL SHAN ONE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109E,
 },
 [0x109F]={
  category="so",
  description="MYANMAR SYMBOL SHAN EXCLAMATION",
  direction="l",
  linebreak="sa",
  unicodeslot=0x109F,
 },
 [0x10A0]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER AN",
  direction="l",
  lccode=0x2D00,
  linebreak="al",
  unicodeslot=0x10A0,
 },
 [0x10A1]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER BAN",
  direction="l",
  lccode=0x2D01,
  linebreak="al",
  unicodeslot=0x10A1,
 },
 [0x10A2]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER GAN",
  direction="l",
  lccode=0x2D02,
  linebreak="al",
  unicodeslot=0x10A2,
 },
 [0x10A3]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER DON",
  direction="l",
  lccode=0x2D03,
  linebreak="al",
  unicodeslot=0x10A3,
 },
 [0x10A4]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER EN",
  direction="l",
  lccode=0x2D04,
  linebreak="al",
  unicodeslot=0x10A4,
 },
 [0x10A5]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER VIN",
  direction="l",
  lccode=0x2D05,
  linebreak="al",
  unicodeslot=0x10A5,
 },
 [0x10A6]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER ZEN",
  direction="l",
  lccode=0x2D06,
  linebreak="al",
  unicodeslot=0x10A6,
 },
 [0x10A7]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER TAN",
  direction="l",
  lccode=0x2D07,
  linebreak="al",
  unicodeslot=0x10A7,
 },
 [0x10A8]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER IN",
  direction="l",
  lccode=0x2D08,
  linebreak="al",
  unicodeslot=0x10A8,
 },
 [0x10A9]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER KAN",
  direction="l",
  lccode=0x2D09,
  linebreak="al",
  unicodeslot=0x10A9,
 },
 [0x10AA]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER LAS",
  direction="l",
  lccode=0x2D0A,
  linebreak="al",
  unicodeslot=0x10AA,
 },
 [0x10AB]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER MAN",
  direction="l",
  lccode=0x2D0B,
  linebreak="al",
  unicodeslot=0x10AB,
 },
 [0x10AC]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER NAR",
  direction="l",
  lccode=0x2D0C,
  linebreak="al",
  unicodeslot=0x10AC,
 },
 [0x10AD]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER ON",
  direction="l",
  lccode=0x2D0D,
  linebreak="al",
  unicodeslot=0x10AD,
 },
 [0x10AE]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER PAR",
  direction="l",
  lccode=0x2D0E,
  linebreak="al",
  unicodeslot=0x10AE,
 },
 [0x10AF]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER ZHAR",
  direction="l",
  lccode=0x2D0F,
  linebreak="al",
  unicodeslot=0x10AF,
 },
 [0x10B0]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER RAE",
  direction="l",
  lccode=0x2D10,
  linebreak="al",
  unicodeslot=0x10B0,
 },
 [0x10B1]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER SAN",
  direction="l",
  lccode=0x2D11,
  linebreak="al",
  unicodeslot=0x10B1,
 },
 [0x10B2]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER TAR",
  direction="l",
  lccode=0x2D12,
  linebreak="al",
  unicodeslot=0x10B2,
 },
 [0x10B3]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER UN",
  direction="l",
  lccode=0x2D13,
  linebreak="al",
  unicodeslot=0x10B3,
 },
 [0x10B4]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER PHAR",
  direction="l",
  lccode=0x2D14,
  linebreak="al",
  unicodeslot=0x10B4,
 },
 [0x10B5]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER KHAR",
  direction="l",
  lccode=0x2D15,
  linebreak="al",
  unicodeslot=0x10B5,
 },
 [0x10B6]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER GHAN",
  direction="l",
  lccode=0x2D16,
  linebreak="al",
  unicodeslot=0x10B6,
 },
 [0x10B7]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER QAR",
  direction="l",
  lccode=0x2D17,
  linebreak="al",
  unicodeslot=0x10B7,
 },
 [0x10B8]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER SHIN",
  direction="l",
  lccode=0x2D18,
  linebreak="al",
  unicodeslot=0x10B8,
 },
 [0x10B9]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER CHIN",
  direction="l",
  lccode=0x2D19,
  linebreak="al",
  unicodeslot=0x10B9,
 },
 [0x10BA]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER CAN",
  direction="l",
  lccode=0x2D1A,
  linebreak="al",
  unicodeslot=0x10BA,
 },
 [0x10BB]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER JIL",
  direction="l",
  lccode=0x2D1B,
  linebreak="al",
  unicodeslot=0x10BB,
 },
 [0x10BC]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER CIL",
  direction="l",
  lccode=0x2D1C,
  linebreak="al",
  unicodeslot=0x10BC,
 },
 [0x10BD]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER CHAR",
  direction="l",
  lccode=0x2D1D,
  linebreak="al",
  unicodeslot=0x10BD,
 },
 [0x10BE]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER XAN",
  direction="l",
  lccode=0x2D1E,
  linebreak="al",
  unicodeslot=0x10BE,
 },
 [0x10BF]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER JHAN",
  direction="l",
  lccode=0x2D1F,
  linebreak="al",
  unicodeslot=0x10BF,
 },
 [0x10C0]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HAE",
  direction="l",
  lccode=0x2D20,
  linebreak="al",
  unicodeslot=0x10C0,
 },
 [0x10C1]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HE",
  direction="l",
  lccode=0x2D21,
  linebreak="al",
  unicodeslot=0x10C1,
 },
 [0x10C2]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HIE",
  direction="l",
  lccode=0x2D22,
  linebreak="al",
  unicodeslot=0x10C2,
 },
 [0x10C3]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER WE",
  direction="l",
  lccode=0x2D23,
  linebreak="al",
  unicodeslot=0x10C3,
 },
 [0x10C4]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HAR",
  direction="l",
  lccode=0x2D24,
  linebreak="al",
  unicodeslot=0x10C4,
 },
 [0x10C5]={
  category="lu",
  description="GEORGIAN CAPITAL LETTER HOE",
  direction="l",
  lccode=0x2D25,
  linebreak="al",
  unicodeslot=0x10C5,
 },
 [0x10D0]={
  category="lo",
  description="GEORGIAN LETTER AN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D0,
 },
 [0x10D1]={
  category="lo",
  description="GEORGIAN LETTER BAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D1,
 },
 [0x10D2]={
  category="lo",
  description="GEORGIAN LETTER GAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D2,
 },
 [0x10D3]={
  category="lo",
  description="GEORGIAN LETTER DON",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D3,
 },
 [0x10D4]={
  category="lo",
  description="GEORGIAN LETTER EN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D4,
 },
 [0x10D5]={
  category="lo",
  description="GEORGIAN LETTER VIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D5,
 },
 [0x10D6]={
  category="lo",
  description="GEORGIAN LETTER ZEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D6,
 },
 [0x10D7]={
  category="lo",
  description="GEORGIAN LETTER TAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D7,
 },
 [0x10D8]={
  category="lo",
  description="GEORGIAN LETTER IN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D8,
 },
 [0x10D9]={
  category="lo",
  description="GEORGIAN LETTER KAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10D9,
 },
 [0x10DA]={
  category="lo",
  description="GEORGIAN LETTER LAS",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DA,
 },
 [0x10DB]={
  category="lo",
  description="GEORGIAN LETTER MAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DB,
 },
 [0x10DC]={
  category="lo",
  description="GEORGIAN LETTER NAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DC,
 },
 [0x10DD]={
  category="lo",
  description="GEORGIAN LETTER ON",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DD,
 },
 [0x10DE]={
  category="lo",
  description="GEORGIAN LETTER PAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DE,
 },
 [0x10DF]={
  category="lo",
  description="GEORGIAN LETTER ZHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10DF,
 },
 [0x10E0]={
  category="lo",
  description="GEORGIAN LETTER RAE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E0,
 },
 [0x10E1]={
  category="lo",
  description="GEORGIAN LETTER SAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E1,
 },
 [0x10E2]={
  category="lo",
  description="GEORGIAN LETTER TAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E2,
 },
 [0x10E3]={
  category="lo",
  description="GEORGIAN LETTER UN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E3,
 },
 [0x10E4]={
  category="lo",
  description="GEORGIAN LETTER PHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E4,
 },
 [0x10E5]={
  category="lo",
  description="GEORGIAN LETTER KHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E5,
 },
 [0x10E6]={
  category="lo",
  description="GEORGIAN LETTER GHAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E6,
 },
 [0x10E7]={
  category="lo",
  description="GEORGIAN LETTER QAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E7,
 },
 [0x10E8]={
  category="lo",
  description="GEORGIAN LETTER SHIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E8,
 },
 [0x10E9]={
  category="lo",
  description="GEORGIAN LETTER CHIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10E9,
 },
 [0x10EA]={
  category="lo",
  description="GEORGIAN LETTER CAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EA,
 },
 [0x10EB]={
  category="lo",
  description="GEORGIAN LETTER JIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EB,
 },
 [0x10EC]={
  category="lo",
  description="GEORGIAN LETTER CIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EC,
 },
 [0x10ED]={
  category="lo",
  description="GEORGIAN LETTER CHAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10ED,
 },
 [0x10EE]={
  category="lo",
  description="GEORGIAN LETTER XAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EE,
 },
 [0x10EF]={
  category="lo",
  description="GEORGIAN LETTER JHAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10EF,
 },
 [0x10F0]={
  category="lo",
  description="GEORGIAN LETTER HAE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F0,
 },
 [0x10F1]={
  category="lo",
  description="GEORGIAN LETTER HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F1,
 },
 [0x10F2]={
  category="lo",
  description="GEORGIAN LETTER HIE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F2,
 },
 [0x10F3]={
  category="lo",
  description="GEORGIAN LETTER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F3,
 },
 [0x10F4]={
  category="lo",
  description="GEORGIAN LETTER HAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F4,
 },
 [0x10F5]={
  category="lo",
  description="GEORGIAN LETTER HOE",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F5,
 },
 [0x10F6]={
  category="lo",
  description="GEORGIAN LETTER FI",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F6,
 },
 [0x10F7]={
  category="lo",
  description="GEORGIAN LETTER YN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F7,
 },
 [0x10F8]={
  category="lo",
  description="GEORGIAN LETTER ELIFI",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F8,
 },
 [0x10F9]={
  category="lo",
  description="GEORGIAN LETTER TURNED GAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10F9,
 },
 [0x10FA]={
  category="lo",
  description="GEORGIAN LETTER AIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x10FA,
 },
 [0x10FB]={
  category="po",
  description="GEORGIAN PARAGRAPH SEPARATOR",
  direction="l",
  linebreak="al",
  unicodeslot=0x10FB,
 },
 [0x10FC]={
  category="lm",
  description="MODIFIER LETTER GEORGIAN NAR",
  direction="l",
  linebreak="al",
  specials={ "super", 0x10DC },
  unicodeslot=0x10FC,
 },
 [0x1100]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1100,
 },
 [0x1101]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGKIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1101,
 },
 [0x1102]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1102,
 },
 [0x1103]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1103,
 },
 [0x1104]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGTIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1104,
 },
 [0x1105]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG RIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1105,
 },
 [0x1106]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG MIEUM",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1106,
 },
 [0x1107]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1107,
 },
 [0x1108]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGPIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1108,
 },
 [0x1109]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1109,
 },
 [0x110A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110A,
 },
 [0x110B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110B,
 },
 [0x110C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110C,
 },
 [0x110D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110D,
 },
 [0x110E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110E,
 },
 [0x110F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KHIEUKH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x110F,
 },
 [0x1110]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG THIEUTH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1110,
 },
 [0x1111]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1111,
 },
 [0x1112]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1112,
 },
 [0x1113]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1113,
 },
 [0x1114]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGNIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1114,
 },
 [0x1115]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1115,
 },
 [0x1116]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1116,
 },
 [0x1117]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG TIKEUT-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1117,
 },
 [0x1118]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG RIEUL-NIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1118,
 },
 [0x1119]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGRIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1119,
 },
 [0x111A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG RIEUL-HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111A,
 },
 [0x111B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNRIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111B,
 },
 [0x111C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG MIEUM-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111C,
 },
 [0x111D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNMIEUM",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111D,
 },
 [0x111E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111E,
 },
 [0x111F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-NIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x111F,
 },
 [0x1120]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1120,
 },
 [0x1121]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1121,
 },
 [0x1122]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1122,
 },
 [0x1123]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1123,
 },
 [0x1124]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1124,
 },
 [0x1125]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1125,
 },
 [0x1126]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-SIOS-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1126,
 },
 [0x1127]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1127,
 },
 [0x1128]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-CHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1128,
 },
 [0x1129]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-THIEUTH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1129,
 },
 [0x112A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PIEUP-PHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112A,
 },
 [0x112B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNPIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112B,
 },
 [0x112C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNSSANGPIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112C,
 },
 [0x112D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112D,
 },
 [0x112E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-NIEUN",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112E,
 },
 [0x112F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x112F,
 },
 [0x1130]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-RIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1130,
 },
 [0x1131]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-MIEUM",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1131,
 },
 [0x1132]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1132,
 },
 [0x1133]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-PIEUP-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1133,
 },
 [0x1134]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-SSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1134,
 },
 [0x1135]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-IEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1135,
 },
 [0x1136]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1136,
 },
 [0x1137]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-CHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1137,
 },
 [0x1138]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-KHIEUKH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1138,
 },
 [0x1139]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-THIEUTH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1139,
 },
 [0x113A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-PHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113A,
 },
 [0x113B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SIOS-HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113B,
 },
 [0x113C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113C,
 },
 [0x113D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMSSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113D,
 },
 [0x113E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113E,
 },
 [0x113F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x113F,
 },
 [0x1140]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PANSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1140,
 },
 [0x1141]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-KIYEOK",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1141,
 },
 [0x1142]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1142,
 },
 [0x1143]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-MIEUM",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1143,
 },
 [0x1144]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1144,
 },
 [0x1145]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-SIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1145,
 },
 [0x1146]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-PANSIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1146,
 },
 [0x1147]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGIEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1147,
 },
 [0x1148]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1148,
 },
 [0x1149]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-CHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1149,
 },
 [0x114A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-THIEUTH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114A,
 },
 [0x114B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG IEUNG-PHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114B,
 },
 [0x114C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG YESIEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114C,
 },
 [0x114D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CIEUC-IEUNG",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114D,
 },
 [0x114E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114E,
 },
 [0x114F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMSSANGCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x114F,
 },
 [0x1150]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1150,
 },
 [0x1151]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1151,
 },
 [0x1152]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHIEUCH-KHIEUKH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1152,
 },
 [0x1153]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHIEUCH-HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1153,
 },
 [0x1154]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CHITUEUMCHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1154,
 },
 [0x1155]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG CEONGCHIEUMCHIEUCH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1155,
 },
 [0x1156]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG PHIEUPH-PIEUP",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1156,
 },
 [0x1157]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KAPYEOUNPHIEUPH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1157,
 },
 [0x1158]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG SSANGHIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1158,
 },
 [0x1159]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG YEORINHIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x1159,
 },
 [0x115A]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG KIYEOK-TIKEUT",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115A,
 },
 [0x115B]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-SIOS",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115B,
 },
 [0x115C]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-CIEUC",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115C,
 },
 [0x115D]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG NIEUN-HIEUH",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115D,
 },
 [0x115E]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG TIKEUT-RIEUL",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115E,
 },
 [0x115F]={
  category="lo",
  cjkwd="w",
  description="HANGUL CHOSEONG FILLER",
  direction="l",
  linebreak="jl",
  unicodeslot=0x115F,
 },
 [0x1160]={
  category="lo",
  description="HANGUL JUNGSEONG FILLER",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1160,
 },
 [0x1161]={
  category="lo",
  description="HANGUL JUNGSEONG A",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1161,
 },
 [0x1162]={
  category="lo",
  description="HANGUL JUNGSEONG AE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1162,
 },
 [0x1163]={
  category="lo",
  description="HANGUL JUNGSEONG YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1163,
 },
 [0x1164]={
  category="lo",
  description="HANGUL JUNGSEONG YAE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1164,
 },
 [0x1165]={
  category="lo",
  description="HANGUL JUNGSEONG EO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1165,
 },
 [0x1166]={
  category="lo",
  description="HANGUL JUNGSEONG E",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1166,
 },
 [0x1167]={
  category="lo",
  description="HANGUL JUNGSEONG YEO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1167,
 },
 [0x1168]={
  category="lo",
  description="HANGUL JUNGSEONG YE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1168,
 },
 [0x1169]={
  category="lo",
  description="HANGUL JUNGSEONG O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1169,
 },
 [0x116A]={
  category="lo",
  description="HANGUL JUNGSEONG WA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116A,
 },
 [0x116B]={
  category="lo",
  description="HANGUL JUNGSEONG WAE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116B,
 },
 [0x116C]={
  category="lo",
  description="HANGUL JUNGSEONG OE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116C,
 },
 [0x116D]={
  category="lo",
  description="HANGUL JUNGSEONG YO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116D,
 },
 [0x116E]={
  category="lo",
  description="HANGUL JUNGSEONG U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116E,
 },
 [0x116F]={
  category="lo",
  description="HANGUL JUNGSEONG WEO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x116F,
 },
 [0x1170]={
  category="lo",
  description="HANGUL JUNGSEONG WE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1170,
 },
 [0x1171]={
  category="lo",
  description="HANGUL JUNGSEONG WI",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1171,
 },
 [0x1172]={
  category="lo",
  description="HANGUL JUNGSEONG YU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1172,
 },
 [0x1173]={
  category="lo",
  description="HANGUL JUNGSEONG EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1173,
 },
 [0x1174]={
  category="lo",
  description="HANGUL JUNGSEONG YI",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1174,
 },
 [0x1175]={
  category="lo",
  description="HANGUL JUNGSEONG I",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1175,
 },
 [0x1176]={
  category="lo",
  description="HANGUL JUNGSEONG A-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1176,
 },
 [0x1177]={
  category="lo",
  description="HANGUL JUNGSEONG A-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1177,
 },
 [0x1178]={
  category="lo",
  description="HANGUL JUNGSEONG YA-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1178,
 },
 [0x1179]={
  category="lo",
  description="HANGUL JUNGSEONG YA-YO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1179,
 },
 [0x117A]={
  category="lo",
  description="HANGUL JUNGSEONG EO-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117A,
 },
 [0x117B]={
  category="lo",
  description="HANGUL JUNGSEONG EO-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117B,
 },
 [0x117C]={
  category="lo",
  description="HANGUL JUNGSEONG EO-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117C,
 },
 [0x117D]={
  category="lo",
  description="HANGUL JUNGSEONG YEO-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117D,
 },
 [0x117E]={
  category="lo",
  description="HANGUL JUNGSEONG YEO-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117E,
 },
 [0x117F]={
  category="lo",
  description="HANGUL JUNGSEONG O-EO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x117F,
 },
 [0x1180]={
  category="lo",
  description="HANGUL JUNGSEONG O-E",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1180,
 },
 [0x1181]={
  category="lo",
  description="HANGUL JUNGSEONG O-YE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1181,
 },
 [0x1182]={
  category="lo",
  description="HANGUL JUNGSEONG O-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1182,
 },
 [0x1183]={
  category="lo",
  description="HANGUL JUNGSEONG O-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1183,
 },
 [0x1184]={
  category="lo",
  description="HANGUL JUNGSEONG YO-YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1184,
 },
 [0x1185]={
  category="lo",
  description="HANGUL JUNGSEONG YO-YAE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1185,
 },
 [0x1186]={
  category="lo",
  description="HANGUL JUNGSEONG YO-YEO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1186,
 },
 [0x1187]={
  category="lo",
  description="HANGUL JUNGSEONG YO-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1187,
 },
 [0x1188]={
  category="lo",
  description="HANGUL JUNGSEONG YO-I",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1188,
 },
 [0x1189]={
  category="lo",
  description="HANGUL JUNGSEONG U-A",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1189,
 },
 [0x118A]={
  category="lo",
  description="HANGUL JUNGSEONG U-AE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118A,
 },
 [0x118B]={
  category="lo",
  description="HANGUL JUNGSEONG U-EO-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118B,
 },
 [0x118C]={
  category="lo",
  description="HANGUL JUNGSEONG U-YE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118C,
 },
 [0x118D]={
  category="lo",
  description="HANGUL JUNGSEONG U-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118D,
 },
 [0x118E]={
  category="lo",
  description="HANGUL JUNGSEONG YU-A",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118E,
 },
 [0x118F]={
  category="lo",
  description="HANGUL JUNGSEONG YU-EO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x118F,
 },
 [0x1190]={
  category="lo",
  description="HANGUL JUNGSEONG YU-E",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1190,
 },
 [0x1191]={
  category="lo",
  description="HANGUL JUNGSEONG YU-YEO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1191,
 },
 [0x1192]={
  category="lo",
  description="HANGUL JUNGSEONG YU-YE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1192,
 },
 [0x1193]={
  category="lo",
  description="HANGUL JUNGSEONG YU-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1193,
 },
 [0x1194]={
  category="lo",
  description="HANGUL JUNGSEONG YU-I",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1194,
 },
 [0x1195]={
  category="lo",
  description="HANGUL JUNGSEONG EU-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1195,
 },
 [0x1196]={
  category="lo",
  description="HANGUL JUNGSEONG EU-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1196,
 },
 [0x1197]={
  category="lo",
  description="HANGUL JUNGSEONG YI-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1197,
 },
 [0x1198]={
  category="lo",
  description="HANGUL JUNGSEONG I-A",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1198,
 },
 [0x1199]={
  category="lo",
  description="HANGUL JUNGSEONG I-YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x1199,
 },
 [0x119A]={
  category="lo",
  description="HANGUL JUNGSEONG I-O",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119A,
 },
 [0x119B]={
  category="lo",
  description="HANGUL JUNGSEONG I-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119B,
 },
 [0x119C]={
  category="lo",
  description="HANGUL JUNGSEONG I-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119C,
 },
 [0x119D]={
  category="lo",
  description="HANGUL JUNGSEONG I-ARAEA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119D,
 },
 [0x119E]={
  category="lo",
  description="HANGUL JUNGSEONG ARAEA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119E,
 },
 [0x119F]={
  category="lo",
  description="HANGUL JUNGSEONG ARAEA-EO",
  direction="l",
  linebreak="jv",
  unicodeslot=0x119F,
 },
 [0x11A0]={
  category="lo",
  description="HANGUL JUNGSEONG ARAEA-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A0,
 },
 [0x11A1]={
  category="lo",
  description="HANGUL JUNGSEONG ARAEA-I",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A1,
 },
 [0x11A2]={
  category="lo",
  description="HANGUL JUNGSEONG SSANGARAEA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A2,
 },
 [0x11A3]={
  category="lo",
  cjkwd="w",
  description="HANGUL JUNGSEONG A-EU",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A3,
 },
 [0x11A4]={
  category="lo",
  cjkwd="w",
  description="HANGUL JUNGSEONG YA-U",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A4,
 },
 [0x11A5]={
  category="lo",
  cjkwd="w",
  description="HANGUL JUNGSEONG YEO-YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A5,
 },
 [0x11A6]={
  category="lo",
  cjkwd="w",
  description="HANGUL JUNGSEONG O-YA",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A6,
 },
 [0x11A7]={
  category="lo",
  cjkwd="w",
  description="HANGUL JUNGSEONG O-YAE",
  direction="l",
  linebreak="jv",
  unicodeslot=0x11A7,
 },
 [0x11A8]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11A8,
 },
 [0x11A9]={
  category="lo",
  description="HANGUL JONGSEONG SSANGKIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11A9,
 },
 [0x11AA]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AA,
 },
 [0x11AB]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AB,
 },
 [0x11AC]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-CIEUC",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AC,
 },
 [0x11AD]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AD,
 },
 [0x11AE]={
  category="lo",
  description="HANGUL JONGSEONG TIKEUT",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AE,
 },
 [0x11AF]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11AF,
 },
 [0x11B0]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B0,
 },
 [0x11B1]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-MIEUM",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B1,
 },
 [0x11B2]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B2,
 },
 [0x11B3]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B3,
 },
 [0x11B4]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-THIEUTH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B4,
 },
 [0x11B5]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PHIEUPH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B5,
 },
 [0x11B6]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B6,
 },
 [0x11B7]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B7,
 },
 [0x11B8]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B8,
 },
 [0x11B9]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11B9,
 },
 [0x11BA]={
  category="lo",
  description="HANGUL JONGSEONG SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BA,
 },
 [0x11BB]={
  category="lo",
  description="HANGUL JONGSEONG SSANGSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BB,
 },
 [0x11BC]={
  category="lo",
  description="HANGUL JONGSEONG IEUNG",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BC,
 },
 [0x11BD]={
  category="lo",
  description="HANGUL JONGSEONG CIEUC",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BD,
 },
 [0x11BE]={
  category="lo",
  description="HANGUL JONGSEONG CHIEUCH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BE,
 },
 [0x11BF]={
  category="lo",
  description="HANGUL JONGSEONG KHIEUKH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11BF,
 },
 [0x11C0]={
  category="lo",
  description="HANGUL JONGSEONG THIEUTH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C0,
 },
 [0x11C1]={
  category="lo",
  description="HANGUL JONGSEONG PHIEUPH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C1,
 },
 [0x11C2]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C2,
 },
 [0x11C3]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C3,
 },
 [0x11C4]={
  category="lo",
  description="HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C4,
 },
 [0x11C5]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C5,
 },
 [0x11C6]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-TIKEUT",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C6,
 },
 [0x11C7]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C7,
 },
 [0x11C8]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C8,
 },
 [0x11C9]={
  category="lo",
  description="HANGUL JONGSEONG NIEUN-THIEUTH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11C9,
 },
 [0x11CA]={
  category="lo",
  description="HANGUL JONGSEONG TIKEUT-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CA,
 },
 [0x11CB]={
  category="lo",
  description="HANGUL JONGSEONG TIKEUT-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CB,
 },
 [0x11CC]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-KIYEOK-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CC,
 },
 [0x11CD]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-NIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CD,
 },
 [0x11CE]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-TIKEUT",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CE,
 },
 [0x11CF]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11CF,
 },
 [0x11D0]={
  category="lo",
  description="HANGUL JONGSEONG SSANGRIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D0,
 },
 [0x11D1]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D1,
 },
 [0x11D2]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-MIEUM-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D2,
 },
 [0x11D3]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PIEUP-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D3,
 },
 [0x11D4]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PIEUP-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D4,
 },
 [0x11D5]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D5,
 },
 [0x11D6]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-SSANGSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D6,
 },
 [0x11D7]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D7,
 },
 [0x11D8]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-KHIEUKH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D8,
 },
 [0x11D9]={
  category="lo",
  description="HANGUL JONGSEONG RIEUL-YEORINHIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11D9,
 },
 [0x11DA]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DA,
 },
 [0x11DB]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DB,
 },
 [0x11DC]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DC,
 },
 [0x11DD]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DD,
 },
 [0x11DE]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-SSANGSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DE,
 },
 [0x11DF]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11DF,
 },
 [0x11E0]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-CHIEUCH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E0,
 },
 [0x11E1]={
  category="lo",
  description="HANGUL JONGSEONG MIEUM-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E1,
 },
 [0x11E2]={
  category="lo",
  description="HANGUL JONGSEONG KAPYEOUNMIEUM",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E2,
 },
 [0x11E3]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E3,
 },
 [0x11E4]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP-PHIEUPH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E4,
 },
 [0x11E5]={
  category="lo",
  description="HANGUL JONGSEONG PIEUP-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E5,
 },
 [0x11E6]={
  category="lo",
  description="HANGUL JONGSEONG KAPYEOUNPIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E6,
 },
 [0x11E7]={
  category="lo",
  description="HANGUL JONGSEONG SIOS-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E7,
 },
 [0x11E8]={
  category="lo",
  description="HANGUL JONGSEONG SIOS-TIKEUT",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E8,
 },
 [0x11E9]={
  category="lo",
  description="HANGUL JONGSEONG SIOS-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11E9,
 },
 [0x11EA]={
  category="lo",
  description="HANGUL JONGSEONG SIOS-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EA,
 },
 [0x11EB]={
  category="lo",
  description="HANGUL JONGSEONG PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EB,
 },
 [0x11EC]={
  category="lo",
  description="HANGUL JONGSEONG IEUNG-KIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EC,
 },
 [0x11ED]={
  category="lo",
  description="HANGUL JONGSEONG IEUNG-SSANGKIYEOK",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11ED,
 },
 [0x11EE]={
  category="lo",
  description="HANGUL JONGSEONG SSANGIEUNG",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EE,
 },
 [0x11EF]={
  category="lo",
  description="HANGUL JONGSEONG IEUNG-KHIEUKH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11EF,
 },
 [0x11F0]={
  category="lo",
  description="HANGUL JONGSEONG YESIEUNG",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F0,
 },
 [0x11F1]={
  category="lo",
  description="HANGUL JONGSEONG YESIEUNG-SIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F1,
 },
 [0x11F2]={
  category="lo",
  description="HANGUL JONGSEONG YESIEUNG-PANSIOS",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F2,
 },
 [0x11F3]={
  category="lo",
  description="HANGUL JONGSEONG PHIEUPH-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F3,
 },
 [0x11F4]={
  category="lo",
  description="HANGUL JONGSEONG KAPYEOUNPHIEUPH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F4,
 },
 [0x11F5]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH-NIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F5,
 },
 [0x11F6]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH-RIEUL",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F6,
 },
 [0x11F7]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH-MIEUM",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F7,
 },
 [0x11F8]={
  category="lo",
  description="HANGUL JONGSEONG HIEUH-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F8,
 },
 [0x11F9]={
  category="lo",
  description="HANGUL JONGSEONG YEORINHIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11F9,
 },
 [0x11FA]={
  category="lo",
  cjkwd="w",
  description="HANGUL JONGSEONG KIYEOK-NIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FA,
 },
 [0x11FB]={
  category="lo",
  cjkwd="w",
  description="HANGUL JONGSEONG KIYEOK-PIEUP",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FB,
 },
 [0x11FC]={
  category="lo",
  cjkwd="w",
  description="HANGUL JONGSEONG KIYEOK-CHIEUCH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FC,
 },
 [0x11FD]={
  category="lo",
  cjkwd="w",
  description="HANGUL JONGSEONG KIYEOK-KHIEUKH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FD,
 },
 [0x11FE]={
  category="lo",
  cjkwd="w",
  description="HANGUL JONGSEONG KIYEOK-HIEUH",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FE,
 },
 [0x11FF]={
  category="lo",
  cjkwd="w",
  description="HANGUL JONGSEONG SSANGNIEUN",
  direction="l",
  linebreak="jt",
  unicodeslot=0x11FF,
 },
 [0x1200]={
  category="lo",
  description="ETHIOPIC SYLLABLE HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1200,
 },
 [0x1201]={
  category="lo",
  description="ETHIOPIC SYLLABLE HU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1201,
 },
 [0x1202]={
  category="lo",
  description="ETHIOPIC SYLLABLE HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1202,
 },
 [0x1203]={
  category="lo",
  description="ETHIOPIC SYLLABLE HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1203,
 },
 [0x1204]={
  category="lo",
  description="ETHIOPIC SYLLABLE HEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1204,
 },
 [0x1205]={
  category="lo",
  description="ETHIOPIC SYLLABLE HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1205,
 },
 [0x1206]={
  category="lo",
  description="ETHIOPIC SYLLABLE HO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1206,
 },
 [0x1207]={
  category="lo",
  description="ETHIOPIC SYLLABLE HOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1207,
 },
 [0x1208]={
  category="lo",
  description="ETHIOPIC SYLLABLE LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1208,
 },
 [0x1209]={
  category="lo",
  description="ETHIOPIC SYLLABLE LU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1209,
 },
 [0x120A]={
  category="lo",
  description="ETHIOPIC SYLLABLE LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x120A,
 },
 [0x120B]={
  category="lo",
  description="ETHIOPIC SYLLABLE LAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x120B,
 },
 [0x120C]={
  category="lo",
  description="ETHIOPIC SYLLABLE LEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x120C,
 },
 [0x120D]={
  category="lo",
  description="ETHIOPIC SYLLABLE LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x120D,
 },
 [0x120E]={
  category="lo",
  description="ETHIOPIC SYLLABLE LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x120E,
 },
 [0x120F]={
  category="lo",
  description="ETHIOPIC SYLLABLE LWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x120F,
 },
 [0x1210]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1210,
 },
 [0x1211]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1211,
 },
 [0x1212]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1212,
 },
 [0x1213]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1213,
 },
 [0x1214]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1214,
 },
 [0x1215]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1215,
 },
 [0x1216]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1216,
 },
 [0x1217]={
  category="lo",
  description="ETHIOPIC SYLLABLE HHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1217,
 },
 [0x1218]={
  category="lo",
  description="ETHIOPIC SYLLABLE MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1218,
 },
 [0x1219]={
  category="lo",
  description="ETHIOPIC SYLLABLE MU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1219,
 },
 [0x121A]={
  category="lo",
  description="ETHIOPIC SYLLABLE MI",
  direction="l",
  linebreak="al",
  unicodeslot=0x121A,
 },
 [0x121B]={
  category="lo",
  description="ETHIOPIC SYLLABLE MAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x121B,
 },
 [0x121C]={
  category="lo",
  description="ETHIOPIC SYLLABLE MEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x121C,
 },
 [0x121D]={
  category="lo",
  description="ETHIOPIC SYLLABLE ME",
  direction="l",
  linebreak="al",
  unicodeslot=0x121D,
 },
 [0x121E]={
  category="lo",
  description="ETHIOPIC SYLLABLE MO",
  direction="l",
  linebreak="al",
  unicodeslot=0x121E,
 },
 [0x121F]={
  category="lo",
  description="ETHIOPIC SYLLABLE MWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x121F,
 },
 [0x1220]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1220,
 },
 [0x1221]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1221,
 },
 [0x1222]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1222,
 },
 [0x1223]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1223,
 },
 [0x1224]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1224,
 },
 [0x1225]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1225,
 },
 [0x1226]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1226,
 },
 [0x1227]={
  category="lo",
  description="ETHIOPIC SYLLABLE SZWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1227,
 },
 [0x1228]={
  category="lo",
  description="ETHIOPIC SYLLABLE RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1228,
 },
 [0x1229]={
  category="lo",
  description="ETHIOPIC SYLLABLE RU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1229,
 },
 [0x122A]={
  category="lo",
  description="ETHIOPIC SYLLABLE RI",
  direction="l",
  linebreak="al",
  unicodeslot=0x122A,
 },
 [0x122B]={
  category="lo",
  description="ETHIOPIC SYLLABLE RAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x122B,
 },
 [0x122C]={
  category="lo",
  description="ETHIOPIC SYLLABLE REE",
  direction="l",
  linebreak="al",
  unicodeslot=0x122C,
 },
 [0x122D]={
  category="lo",
  description="ETHIOPIC SYLLABLE RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x122D,
 },
 [0x122E]={
  category="lo",
  description="ETHIOPIC SYLLABLE RO",
  direction="l",
  linebreak="al",
  unicodeslot=0x122E,
 },
 [0x122F]={
  category="lo",
  description="ETHIOPIC SYLLABLE RWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x122F,
 },
 [0x1230]={
  category="lo",
  description="ETHIOPIC SYLLABLE SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1230,
 },
 [0x1231]={
  category="lo",
  description="ETHIOPIC SYLLABLE SU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1231,
 },
 [0x1232]={
  category="lo",
  description="ETHIOPIC SYLLABLE SI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1232,
 },
 [0x1233]={
  category="lo",
  description="ETHIOPIC SYLLABLE SAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1233,
 },
 [0x1234]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1234,
 },
 [0x1235]={
  category="lo",
  description="ETHIOPIC SYLLABLE SE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1235,
 },
 [0x1236]={
  category="lo",
  description="ETHIOPIC SYLLABLE SO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1236,
 },
 [0x1237]={
  category="lo",
  description="ETHIOPIC SYLLABLE SWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1237,
 },
 [0x1238]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1238,
 },
 [0x1239]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1239,
 },
 [0x123A]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x123A,
 },
 [0x123B]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x123B,
 },
 [0x123C]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x123C,
 },
 [0x123D]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x123D,
 },
 [0x123E]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x123E,
 },
 [0x123F]={
  category="lo",
  description="ETHIOPIC SYLLABLE SHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x123F,
 },
 [0x1240]={
  category="lo",
  description="ETHIOPIC SYLLABLE QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1240,
 },
 [0x1241]={
  category="lo",
  description="ETHIOPIC SYLLABLE QU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1241,
 },
 [0x1242]={
  category="lo",
  description="ETHIOPIC SYLLABLE QI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1242,
 },
 [0x1243]={
  category="lo",
  description="ETHIOPIC SYLLABLE QAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1243,
 },
 [0x1244]={
  category="lo",
  description="ETHIOPIC SYLLABLE QEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1244,
 },
 [0x1245]={
  category="lo",
  description="ETHIOPIC SYLLABLE QE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1245,
 },
 [0x1246]={
  category="lo",
  description="ETHIOPIC SYLLABLE QO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1246,
 },
 [0x1247]={
  category="lo",
  description="ETHIOPIC SYLLABLE QOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1247,
 },
 [0x1248]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1248,
 },
 [0x124A]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x124A,
 },
 [0x124B]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x124B,
 },
 [0x124C]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x124C,
 },
 [0x124D]={
  category="lo",
  description="ETHIOPIC SYLLABLE QWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x124D,
 },
 [0x1250]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1250,
 },
 [0x1251]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1251,
 },
 [0x1252]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1252,
 },
 [0x1253]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1253,
 },
 [0x1254]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1254,
 },
 [0x1255]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1255,
 },
 [0x1256]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1256,
 },
 [0x1258]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1258,
 },
 [0x125A]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x125A,
 },
 [0x125B]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x125B,
 },
 [0x125C]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x125C,
 },
 [0x125D]={
  category="lo",
  description="ETHIOPIC SYLLABLE QHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x125D,
 },
 [0x1260]={
  category="lo",
  description="ETHIOPIC SYLLABLE BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1260,
 },
 [0x1261]={
  category="lo",
  description="ETHIOPIC SYLLABLE BU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1261,
 },
 [0x1262]={
  category="lo",
  description="ETHIOPIC SYLLABLE BI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1262,
 },
 [0x1263]={
  category="lo",
  description="ETHIOPIC SYLLABLE BAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1263,
 },
 [0x1264]={
  category="lo",
  description="ETHIOPIC SYLLABLE BEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1264,
 },
 [0x1265]={
  category="lo",
  description="ETHIOPIC SYLLABLE BE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1265,
 },
 [0x1266]={
  category="lo",
  description="ETHIOPIC SYLLABLE BO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1266,
 },
 [0x1267]={
  category="lo",
  description="ETHIOPIC SYLLABLE BWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1267,
 },
 [0x1268]={
  category="lo",
  description="ETHIOPIC SYLLABLE VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1268,
 },
 [0x1269]={
  category="lo",
  description="ETHIOPIC SYLLABLE VU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1269,
 },
 [0x126A]={
  category="lo",
  description="ETHIOPIC SYLLABLE VI",
  direction="l",
  linebreak="al",
  unicodeslot=0x126A,
 },
 [0x126B]={
  category="lo",
  description="ETHIOPIC SYLLABLE VAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x126B,
 },
 [0x126C]={
  category="lo",
  description="ETHIOPIC SYLLABLE VEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x126C,
 },
 [0x126D]={
  category="lo",
  description="ETHIOPIC SYLLABLE VE",
  direction="l",
  linebreak="al",
  unicodeslot=0x126D,
 },
 [0x126E]={
  category="lo",
  description="ETHIOPIC SYLLABLE VO",
  direction="l",
  linebreak="al",
  unicodeslot=0x126E,
 },
 [0x126F]={
  category="lo",
  description="ETHIOPIC SYLLABLE VWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x126F,
 },
 [0x1270]={
  category="lo",
  description="ETHIOPIC SYLLABLE TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1270,
 },
 [0x1271]={
  category="lo",
  description="ETHIOPIC SYLLABLE TU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1271,
 },
 [0x1272]={
  category="lo",
  description="ETHIOPIC SYLLABLE TI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1272,
 },
 [0x1273]={
  category="lo",
  description="ETHIOPIC SYLLABLE TAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1273,
 },
 [0x1274]={
  category="lo",
  description="ETHIOPIC SYLLABLE TEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1274,
 },
 [0x1275]={
  category="lo",
  description="ETHIOPIC SYLLABLE TE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1275,
 },
 [0x1276]={
  category="lo",
  description="ETHIOPIC SYLLABLE TO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1276,
 },
 [0x1277]={
  category="lo",
  description="ETHIOPIC SYLLABLE TWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1277,
 },
 [0x1278]={
  category="lo",
  description="ETHIOPIC SYLLABLE CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1278,
 },
 [0x1279]={
  category="lo",
  description="ETHIOPIC SYLLABLE CU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1279,
 },
 [0x127A]={
  category="lo",
  description="ETHIOPIC SYLLABLE CI",
  direction="l",
  linebreak="al",
  unicodeslot=0x127A,
 },
 [0x127B]={
  category="lo",
  description="ETHIOPIC SYLLABLE CAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x127B,
 },
 [0x127C]={
  category="lo",
  description="ETHIOPIC SYLLABLE CEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x127C,
 },
 [0x127D]={
  category="lo",
  description="ETHIOPIC SYLLABLE CE",
  direction="l",
  linebreak="al",
  unicodeslot=0x127D,
 },
 [0x127E]={
  category="lo",
  description="ETHIOPIC SYLLABLE CO",
  direction="l",
  linebreak="al",
  unicodeslot=0x127E,
 },
 [0x127F]={
  category="lo",
  description="ETHIOPIC SYLLABLE CWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x127F,
 },
 [0x1280]={
  category="lo",
  description="ETHIOPIC SYLLABLE XA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1280,
 },
 [0x1281]={
  category="lo",
  description="ETHIOPIC SYLLABLE XU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1281,
 },
 [0x1282]={
  category="lo",
  description="ETHIOPIC SYLLABLE XI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1282,
 },
 [0x1283]={
  category="lo",
  description="ETHIOPIC SYLLABLE XAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1283,
 },
 [0x1284]={
  category="lo",
  description="ETHIOPIC SYLLABLE XEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1284,
 },
 [0x1285]={
  category="lo",
  description="ETHIOPIC SYLLABLE XE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1285,
 },
 [0x1286]={
  category="lo",
  description="ETHIOPIC SYLLABLE XO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1286,
 },
 [0x1287]={
  category="lo",
  description="ETHIOPIC SYLLABLE XOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1287,
 },
 [0x1288]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1288,
 },
 [0x128A]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x128A,
 },
 [0x128B]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x128B,
 },
 [0x128C]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x128C,
 },
 [0x128D]={
  category="lo",
  description="ETHIOPIC SYLLABLE XWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x128D,
 },
 [0x1290]={
  category="lo",
  description="ETHIOPIC SYLLABLE NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1290,
 },
 [0x1291]={
  category="lo",
  description="ETHIOPIC SYLLABLE NU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1291,
 },
 [0x1292]={
  category="lo",
  description="ETHIOPIC SYLLABLE NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1292,
 },
 [0x1293]={
  category="lo",
  description="ETHIOPIC SYLLABLE NAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1293,
 },
 [0x1294]={
  category="lo",
  description="ETHIOPIC SYLLABLE NEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1294,
 },
 [0x1295]={
  category="lo",
  description="ETHIOPIC SYLLABLE NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1295,
 },
 [0x1296]={
  category="lo",
  description="ETHIOPIC SYLLABLE NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1296,
 },
 [0x1297]={
  category="lo",
  description="ETHIOPIC SYLLABLE NWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1297,
 },
 [0x1298]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1298,
 },
 [0x1299]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1299,
 },
 [0x129A]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYI",
  direction="l",
  linebreak="al",
  unicodeslot=0x129A,
 },
 [0x129B]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x129B,
 },
 [0x129C]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x129C,
 },
 [0x129D]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYE",
  direction="l",
  linebreak="al",
  unicodeslot=0x129D,
 },
 [0x129E]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYO",
  direction="l",
  linebreak="al",
  unicodeslot=0x129E,
 },
 [0x129F]={
  category="lo",
  description="ETHIOPIC SYLLABLE NYWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x129F,
 },
 [0x12A0]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL A",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A0,
 },
 [0x12A1]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL U",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A1,
 },
 [0x12A2]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL I",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A2,
 },
 [0x12A3]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A3,
 },
 [0x12A4]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A4,
 },
 [0x12A5]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL E",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A5,
 },
 [0x12A6]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL O",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A6,
 },
 [0x12A7]={
  category="lo",
  description="ETHIOPIC SYLLABLE GLOTTAL WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A7,
 },
 [0x12A8]={
  category="lo",
  description="ETHIOPIC SYLLABLE KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A8,
 },
 [0x12A9]={
  category="lo",
  description="ETHIOPIC SYLLABLE KU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12A9,
 },
 [0x12AA]={
  category="lo",
  description="ETHIOPIC SYLLABLE KI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AA,
 },
 [0x12AB]={
  category="lo",
  description="ETHIOPIC SYLLABLE KAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AB,
 },
 [0x12AC]={
  category="lo",
  description="ETHIOPIC SYLLABLE KEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AC,
 },
 [0x12AD]={
  category="lo",
  description="ETHIOPIC SYLLABLE KE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AD,
 },
 [0x12AE]={
  category="lo",
  description="ETHIOPIC SYLLABLE KO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AE,
 },
 [0x12AF]={
  category="lo",
  description="ETHIOPIC SYLLABLE KOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12AF,
 },
 [0x12B0]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B0,
 },
 [0x12B2]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B2,
 },
 [0x12B3]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B3,
 },
 [0x12B4]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B4,
 },
 [0x12B5]={
  category="lo",
  description="ETHIOPIC SYLLABLE KWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B5,
 },
 [0x12B8]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B8,
 },
 [0x12B9]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12B9,
 },
 [0x12BA]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BA,
 },
 [0x12BB]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BB,
 },
 [0x12BC]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BC,
 },
 [0x12BD]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BD,
 },
 [0x12BE]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12BE,
 },
 [0x12C0]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C0,
 },
 [0x12C2]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C2,
 },
 [0x12C3]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C3,
 },
 [0x12C4]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C4,
 },
 [0x12C5]={
  category="lo",
  description="ETHIOPIC SYLLABLE KXWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C5,
 },
 [0x12C8]={
  category="lo",
  description="ETHIOPIC SYLLABLE WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C8,
 },
 [0x12C9]={
  category="lo",
  description="ETHIOPIC SYLLABLE WU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12C9,
 },
 [0x12CA]={
  category="lo",
  description="ETHIOPIC SYLLABLE WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CA,
 },
 [0x12CB]={
  category="lo",
  description="ETHIOPIC SYLLABLE WAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CB,
 },
 [0x12CC]={
  category="lo",
  description="ETHIOPIC SYLLABLE WEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CC,
 },
 [0x12CD]={
  category="lo",
  description="ETHIOPIC SYLLABLE WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CD,
 },
 [0x12CE]={
  category="lo",
  description="ETHIOPIC SYLLABLE WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CE,
 },
 [0x12CF]={
  category="lo",
  description="ETHIOPIC SYLLABLE WOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12CF,
 },
 [0x12D0]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL A",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D0,
 },
 [0x12D1]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL U",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D1,
 },
 [0x12D2]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL I",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D2,
 },
 [0x12D3]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D3,
 },
 [0x12D4]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D4,
 },
 [0x12D5]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL E",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D5,
 },
 [0x12D6]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHARYNGEAL O",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D6,
 },
 [0x12D8]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D8,
 },
 [0x12D9]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12D9,
 },
 [0x12DA]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DA,
 },
 [0x12DB]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DB,
 },
 [0x12DC]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DC,
 },
 [0x12DD]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DD,
 },
 [0x12DE]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DE,
 },
 [0x12DF]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12DF,
 },
 [0x12E0]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E0,
 },
 [0x12E1]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E1,
 },
 [0x12E2]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E2,
 },
 [0x12E3]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E3,
 },
 [0x12E4]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E4,
 },
 [0x12E5]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E5,
 },
 [0x12E6]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E6,
 },
 [0x12E7]={
  category="lo",
  description="ETHIOPIC SYLLABLE ZHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E7,
 },
 [0x12E8]={
  category="lo",
  description="ETHIOPIC SYLLABLE YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E8,
 },
 [0x12E9]={
  category="lo",
  description="ETHIOPIC SYLLABLE YU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12E9,
 },
 [0x12EA]={
  category="lo",
  description="ETHIOPIC SYLLABLE YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EA,
 },
 [0x12EB]={
  category="lo",
  description="ETHIOPIC SYLLABLE YAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EB,
 },
 [0x12EC]={
  category="lo",
  description="ETHIOPIC SYLLABLE YEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EC,
 },
 [0x12ED]={
  category="lo",
  description="ETHIOPIC SYLLABLE YE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12ED,
 },
 [0x12EE]={
  category="lo",
  description="ETHIOPIC SYLLABLE YO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EE,
 },
 [0x12EF]={
  category="lo",
  description="ETHIOPIC SYLLABLE YOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12EF,
 },
 [0x12F0]={
  category="lo",
  description="ETHIOPIC SYLLABLE DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F0,
 },
 [0x12F1]={
  category="lo",
  description="ETHIOPIC SYLLABLE DU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F1,
 },
 [0x12F2]={
  category="lo",
  description="ETHIOPIC SYLLABLE DI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F2,
 },
 [0x12F3]={
  category="lo",
  description="ETHIOPIC SYLLABLE DAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F3,
 },
 [0x12F4]={
  category="lo",
  description="ETHIOPIC SYLLABLE DEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F4,
 },
 [0x12F5]={
  category="lo",
  description="ETHIOPIC SYLLABLE DE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F5,
 },
 [0x12F6]={
  category="lo",
  description="ETHIOPIC SYLLABLE DO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F6,
 },
 [0x12F7]={
  category="lo",
  description="ETHIOPIC SYLLABLE DWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F7,
 },
 [0x12F8]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F8,
 },
 [0x12F9]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDU",
  direction="l",
  linebreak="al",
  unicodeslot=0x12F9,
 },
 [0x12FA]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDI",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FA,
 },
 [0x12FB]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FB,
 },
 [0x12FC]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FC,
 },
 [0x12FD]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDE",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FD,
 },
 [0x12FE]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDO",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FE,
 },
 [0x12FF]={
  category="lo",
  description="ETHIOPIC SYLLABLE DDWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x12FF,
 },
 [0x1300]={
  category="lo",
  description="ETHIOPIC SYLLABLE JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1300,
 },
 [0x1301]={
  category="lo",
  description="ETHIOPIC SYLLABLE JU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1301,
 },
 [0x1302]={
  category="lo",
  description="ETHIOPIC SYLLABLE JI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1302,
 },
 [0x1303]={
  category="lo",
  description="ETHIOPIC SYLLABLE JAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1303,
 },
 [0x1304]={
  category="lo",
  description="ETHIOPIC SYLLABLE JEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1304,
 },
 [0x1305]={
  category="lo",
  description="ETHIOPIC SYLLABLE JE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1305,
 },
 [0x1306]={
  category="lo",
  description="ETHIOPIC SYLLABLE JO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1306,
 },
 [0x1307]={
  category="lo",
  description="ETHIOPIC SYLLABLE JWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1307,
 },
 [0x1308]={
  category="lo",
  description="ETHIOPIC SYLLABLE GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1308,
 },
 [0x1309]={
  category="lo",
  description="ETHIOPIC SYLLABLE GU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1309,
 },
 [0x130A]={
  category="lo",
  description="ETHIOPIC SYLLABLE GI",
  direction="l",
  linebreak="al",
  unicodeslot=0x130A,
 },
 [0x130B]={
  category="lo",
  description="ETHIOPIC SYLLABLE GAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x130B,
 },
 [0x130C]={
  category="lo",
  description="ETHIOPIC SYLLABLE GEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x130C,
 },
 [0x130D]={
  category="lo",
  description="ETHIOPIC SYLLABLE GE",
  direction="l",
  linebreak="al",
  unicodeslot=0x130D,
 },
 [0x130E]={
  category="lo",
  description="ETHIOPIC SYLLABLE GO",
  direction="l",
  linebreak="al",
  unicodeslot=0x130E,
 },
 [0x130F]={
  category="lo",
  description="ETHIOPIC SYLLABLE GOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x130F,
 },
 [0x1310]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1310,
 },
 [0x1312]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1312,
 },
 [0x1313]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1313,
 },
 [0x1314]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1314,
 },
 [0x1315]={
  category="lo",
  description="ETHIOPIC SYLLABLE GWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1315,
 },
 [0x1318]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1318,
 },
 [0x1319]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1319,
 },
 [0x131A]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGI",
  direction="l",
  linebreak="al",
  unicodeslot=0x131A,
 },
 [0x131B]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x131B,
 },
 [0x131C]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x131C,
 },
 [0x131D]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGE",
  direction="l",
  linebreak="al",
  unicodeslot=0x131D,
 },
 [0x131E]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGO",
  direction="l",
  linebreak="al",
  unicodeslot=0x131E,
 },
 [0x131F]={
  category="lo",
  description="ETHIOPIC SYLLABLE GGWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x131F,
 },
 [0x1320]={
  category="lo",
  description="ETHIOPIC SYLLABLE THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1320,
 },
 [0x1321]={
  category="lo",
  description="ETHIOPIC SYLLABLE THU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1321,
 },
 [0x1322]={
  category="lo",
  description="ETHIOPIC SYLLABLE THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1322,
 },
 [0x1323]={
  category="lo",
  description="ETHIOPIC SYLLABLE THAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1323,
 },
 [0x1324]={
  category="lo",
  description="ETHIOPIC SYLLABLE THEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1324,
 },
 [0x1325]={
  category="lo",
  description="ETHIOPIC SYLLABLE THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1325,
 },
 [0x1326]={
  category="lo",
  description="ETHIOPIC SYLLABLE THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1326,
 },
 [0x1327]={
  category="lo",
  description="ETHIOPIC SYLLABLE THWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1327,
 },
 [0x1328]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1328,
 },
 [0x1329]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1329,
 },
 [0x132A]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x132A,
 },
 [0x132B]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x132B,
 },
 [0x132C]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x132C,
 },
 [0x132D]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x132D,
 },
 [0x132E]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x132E,
 },
 [0x132F]={
  category="lo",
  description="ETHIOPIC SYLLABLE CHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x132F,
 },
 [0x1330]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1330,
 },
 [0x1331]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1331,
 },
 [0x1332]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1332,
 },
 [0x1333]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1333,
 },
 [0x1334]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1334,
 },
 [0x1335]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1335,
 },
 [0x1336]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1336,
 },
 [0x1337]={
  category="lo",
  description="ETHIOPIC SYLLABLE PHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1337,
 },
 [0x1338]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1338,
 },
 [0x1339]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1339,
 },
 [0x133A]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSI",
  direction="l",
  linebreak="al",
  unicodeslot=0x133A,
 },
 [0x133B]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x133B,
 },
 [0x133C]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x133C,
 },
 [0x133D]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSE",
  direction="l",
  linebreak="al",
  unicodeslot=0x133D,
 },
 [0x133E]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSO",
  direction="l",
  linebreak="al",
  unicodeslot=0x133E,
 },
 [0x133F]={
  category="lo",
  description="ETHIOPIC SYLLABLE TSWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x133F,
 },
 [0x1340]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1340,
 },
 [0x1341]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1341,
 },
 [0x1342]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1342,
 },
 [0x1343]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1343,
 },
 [0x1344]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1344,
 },
 [0x1345]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1345,
 },
 [0x1346]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1346,
 },
 [0x1347]={
  category="lo",
  description="ETHIOPIC SYLLABLE TZOA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1347,
 },
 [0x1348]={
  category="lo",
  description="ETHIOPIC SYLLABLE FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1348,
 },
 [0x1349]={
  category="lo",
  description="ETHIOPIC SYLLABLE FU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1349,
 },
 [0x134A]={
  category="lo",
  description="ETHIOPIC SYLLABLE FI",
  direction="l",
  linebreak="al",
  unicodeslot=0x134A,
 },
 [0x134B]={
  category="lo",
  description="ETHIOPIC SYLLABLE FAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x134B,
 },
 [0x134C]={
  category="lo",
  description="ETHIOPIC SYLLABLE FEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x134C,
 },
 [0x134D]={
  category="lo",
  description="ETHIOPIC SYLLABLE FE",
  direction="l",
  linebreak="al",
  unicodeslot=0x134D,
 },
 [0x134E]={
  category="lo",
  description="ETHIOPIC SYLLABLE FO",
  direction="l",
  linebreak="al",
  unicodeslot=0x134E,
 },
 [0x134F]={
  category="lo",
  description="ETHIOPIC SYLLABLE FWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x134F,
 },
 [0x1350]={
  category="lo",
  description="ETHIOPIC SYLLABLE PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1350,
 },
 [0x1351]={
  category="lo",
  description="ETHIOPIC SYLLABLE PU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1351,
 },
 [0x1352]={
  category="lo",
  description="ETHIOPIC SYLLABLE PI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1352,
 },
 [0x1353]={
  category="lo",
  description="ETHIOPIC SYLLABLE PAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1353,
 },
 [0x1354]={
  category="lo",
  description="ETHIOPIC SYLLABLE PEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1354,
 },
 [0x1355]={
  category="lo",
  description="ETHIOPIC SYLLABLE PE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1355,
 },
 [0x1356]={
  category="lo",
  description="ETHIOPIC SYLLABLE PO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1356,
 },
 [0x1357]={
  category="lo",
  description="ETHIOPIC SYLLABLE PWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1357,
 },
 [0x1358]={
  category="lo",
  description="ETHIOPIC SYLLABLE RYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1358,
 },
 [0x1359]={
  category="lo",
  description="ETHIOPIC SYLLABLE MYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1359,
 },
 [0x135A]={
  category="lo",
  description="ETHIOPIC SYLLABLE FYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x135A,
 },
 [0x135D]={
  category="mn",
  description="ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x135D,
 },
 [0x135E]={
  category="mn",
  description="ETHIOPIC COMBINING VOWEL LENGTH MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x135E,
 },
 [0x135F]={
  category="mn",
  description="ETHIOPIC COMBINING GEMINATION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x135F,
 },
 [0x1360]={
  category="so",
  description="ETHIOPIC SECTION MARK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1360,
 },
 [0x1361]={
  category="po",
  description="ETHIOPIC WORDSPACE",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1361,
 },
 [0x1362]={
  category="po",
  description="ETHIOPIC FULL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x1362,
 },
 [0x1363]={
  category="po",
  description="ETHIOPIC COMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1363,
 },
 [0x1364]={
  category="po",
  description="ETHIOPIC SEMICOLON",
  direction="l",
  linebreak="al",
  unicodeslot=0x1364,
 },
 [0x1365]={
  category="po",
  description="ETHIOPIC COLON",
  direction="l",
  linebreak="al",
  unicodeslot=0x1365,
 },
 [0x1366]={
  category="po",
  description="ETHIOPIC PREFACE COLON",
  direction="l",
  linebreak="al",
  unicodeslot=0x1366,
 },
 [0x1367]={
  category="po",
  description="ETHIOPIC QUESTION MARK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1367,
 },
 [0x1368]={
  category="po",
  description="ETHIOPIC PARAGRAPH SEPARATOR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1368,
 },
 [0x1369]={
  category="no",
  description="ETHIOPIC DIGIT ONE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1369,
 },
 [0x136A]={
  category="no",
  description="ETHIOPIC DIGIT TWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x136A,
 },
 [0x136B]={
  category="no",
  description="ETHIOPIC DIGIT THREE",
  direction="l",
  linebreak="al",
  unicodeslot=0x136B,
 },
 [0x136C]={
  category="no",
  description="ETHIOPIC DIGIT FOUR",
  direction="l",
  linebreak="al",
  unicodeslot=0x136C,
 },
 [0x136D]={
  category="no",
  description="ETHIOPIC DIGIT FIVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x136D,
 },
 [0x136E]={
  category="no",
  description="ETHIOPIC DIGIT SIX",
  direction="l",
  linebreak="al",
  unicodeslot=0x136E,
 },
 [0x136F]={
  category="no",
  description="ETHIOPIC DIGIT SEVEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x136F,
 },
 [0x1370]={
  category="no",
  description="ETHIOPIC DIGIT EIGHT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1370,
 },
 [0x1371]={
  category="no",
  description="ETHIOPIC DIGIT NINE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1371,
 },
 [0x1372]={
  category="no",
  description="ETHIOPIC NUMBER TEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1372,
 },
 [0x1373]={
  category="no",
  description="ETHIOPIC NUMBER TWENTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1373,
 },
 [0x1374]={
  category="no",
  description="ETHIOPIC NUMBER THIRTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1374,
 },
 [0x1375]={
  category="no",
  description="ETHIOPIC NUMBER FORTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1375,
 },
 [0x1376]={
  category="no",
  description="ETHIOPIC NUMBER FIFTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1376,
 },
 [0x1377]={
  category="no",
  description="ETHIOPIC NUMBER SIXTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1377,
 },
 [0x1378]={
  category="no",
  description="ETHIOPIC NUMBER SEVENTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1378,
 },
 [0x1379]={
  category="no",
  description="ETHIOPIC NUMBER EIGHTY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1379,
 },
 [0x137A]={
  category="no",
  description="ETHIOPIC NUMBER NINETY",
  direction="l",
  linebreak="al",
  unicodeslot=0x137A,
 },
 [0x137B]={
  category="no",
  description="ETHIOPIC NUMBER HUNDRED",
  direction="l",
  linebreak="al",
  unicodeslot=0x137B,
 },
 [0x137C]={
  category="no",
  description="ETHIOPIC NUMBER TEN THOUSAND",
  direction="l",
  linebreak="al",
  unicodeslot=0x137C,
 },
 [0x1380]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEBATBEIT MWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1380,
 },
 [0x1381]={
  category="lo",
  description="ETHIOPIC SYLLABLE MWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1381,
 },
 [0x1382]={
  category="lo",
  description="ETHIOPIC SYLLABLE MWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1382,
 },
 [0x1383]={
  category="lo",
  description="ETHIOPIC SYLLABLE MWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1383,
 },
 [0x1384]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEBATBEIT BWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1384,
 },
 [0x1385]={
  category="lo",
  description="ETHIOPIC SYLLABLE BWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1385,
 },
 [0x1386]={
  category="lo",
  description="ETHIOPIC SYLLABLE BWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1386,
 },
 [0x1387]={
  category="lo",
  description="ETHIOPIC SYLLABLE BWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1387,
 },
 [0x1388]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEBATBEIT FWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1388,
 },
 [0x1389]={
  category="lo",
  description="ETHIOPIC SYLLABLE FWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1389,
 },
 [0x138A]={
  category="lo",
  description="ETHIOPIC SYLLABLE FWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x138A,
 },
 [0x138B]={
  category="lo",
  description="ETHIOPIC SYLLABLE FWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x138B,
 },
 [0x138C]={
  category="lo",
  description="ETHIOPIC SYLLABLE SEBATBEIT PWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x138C,
 },
 [0x138D]={
  category="lo",
  description="ETHIOPIC SYLLABLE PWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x138D,
 },
 [0x138E]={
  category="lo",
  description="ETHIOPIC SYLLABLE PWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x138E,
 },
 [0x138F]={
  category="lo",
  description="ETHIOPIC SYLLABLE PWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x138F,
 },
 [0x1390]={
  category="so",
  description="ETHIOPIC TONAL MARK YIZET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1390,
 },
 [0x1391]={
  category="so",
  description="ETHIOPIC TONAL MARK DERET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1391,
 },
 [0x1392]={
  category="so",
  description="ETHIOPIC TONAL MARK RIKRIK",
  direction="on",
  linebreak="al",
  unicodeslot=0x1392,
 },
 [0x1393]={
  category="so",
  description="ETHIOPIC TONAL MARK SHORT RIKRIK",
  direction="on",
  linebreak="al",
  unicodeslot=0x1393,
 },
 [0x1394]={
  category="so",
  description="ETHIOPIC TONAL MARK DIFAT",
  direction="on",
  linebreak="al",
  unicodeslot=0x1394,
 },
 [0x1395]={
  category="so",
  description="ETHIOPIC TONAL MARK KENAT",
  direction="on",
  linebreak="al",
  unicodeslot=0x1395,
 },
 [0x1396]={
  category="so",
  description="ETHIOPIC TONAL MARK CHIRET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1396,
 },
 [0x1397]={
  category="so",
  description="ETHIOPIC TONAL MARK HIDET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1397,
 },
 [0x1398]={
  category="so",
  description="ETHIOPIC TONAL MARK DERET-HIDET",
  direction="on",
  linebreak="al",
  unicodeslot=0x1398,
 },
 [0x1399]={
  category="so",
  description="ETHIOPIC TONAL MARK KURT",
  direction="on",
  linebreak="al",
  unicodeslot=0x1399,
 },
 [0x13A0]={
  category="lo",
  description="CHEROKEE LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A0,
 },
 [0x13A1]={
  category="lo",
  description="CHEROKEE LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A1,
 },
 [0x13A2]={
  category="lo",
  description="CHEROKEE LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A2,
 },
 [0x13A3]={
  category="lo",
  description="CHEROKEE LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A3,
 },
 [0x13A4]={
  category="lo",
  description="CHEROKEE LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A4,
 },
 [0x13A5]={
  category="lo",
  description="CHEROKEE LETTER V",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A5,
 },
 [0x13A6]={
  category="lo",
  description="CHEROKEE LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A6,
 },
 [0x13A7]={
  category="lo",
  description="CHEROKEE LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A7,
 },
 [0x13A8]={
  category="lo",
  description="CHEROKEE LETTER GE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A8,
 },
 [0x13A9]={
  category="lo",
  description="CHEROKEE LETTER GI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13A9,
 },
 [0x13AA]={
  category="lo",
  description="CHEROKEE LETTER GO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AA,
 },
 [0x13AB]={
  category="lo",
  description="CHEROKEE LETTER GU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AB,
 },
 [0x13AC]={
  category="lo",
  description="CHEROKEE LETTER GV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AC,
 },
 [0x13AD]={
  category="lo",
  description="CHEROKEE LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AD,
 },
 [0x13AE]={
  category="lo",
  description="CHEROKEE LETTER HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AE,
 },
 [0x13AF]={
  category="lo",
  description="CHEROKEE LETTER HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13AF,
 },
 [0x13B0]={
  category="lo",
  description="CHEROKEE LETTER HO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B0,
 },
 [0x13B1]={
  category="lo",
  description="CHEROKEE LETTER HU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B1,
 },
 [0x13B2]={
  category="lo",
  description="CHEROKEE LETTER HV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B2,
 },
 [0x13B3]={
  category="lo",
  description="CHEROKEE LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B3,
 },
 [0x13B4]={
  category="lo",
  description="CHEROKEE LETTER LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B4,
 },
 [0x13B5]={
  category="lo",
  description="CHEROKEE LETTER LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B5,
 },
 [0x13B6]={
  category="lo",
  description="CHEROKEE LETTER LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B6,
 },
 [0x13B7]={
  category="lo",
  description="CHEROKEE LETTER LU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B7,
 },
 [0x13B8]={
  category="lo",
  description="CHEROKEE LETTER LV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B8,
 },
 [0x13B9]={
  category="lo",
  description="CHEROKEE LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13B9,
 },
 [0x13BA]={
  category="lo",
  description="CHEROKEE LETTER ME",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BA,
 },
 [0x13BB]={
  category="lo",
  description="CHEROKEE LETTER MI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BB,
 },
 [0x13BC]={
  category="lo",
  description="CHEROKEE LETTER MO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BC,
 },
 [0x13BD]={
  category="lo",
  description="CHEROKEE LETTER MU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BD,
 },
 [0x13BE]={
  category="lo",
  description="CHEROKEE LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BE,
 },
 [0x13BF]={
  category="lo",
  description="CHEROKEE LETTER HNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13BF,
 },
 [0x13C0]={
  category="lo",
  description="CHEROKEE LETTER NAH",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C0,
 },
 [0x13C1]={
  category="lo",
  description="CHEROKEE LETTER NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C1,
 },
 [0x13C2]={
  category="lo",
  description="CHEROKEE LETTER NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C2,
 },
 [0x13C3]={
  category="lo",
  description="CHEROKEE LETTER NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C3,
 },
 [0x13C4]={
  category="lo",
  description="CHEROKEE LETTER NU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C4,
 },
 [0x13C5]={
  category="lo",
  description="CHEROKEE LETTER NV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C5,
 },
 [0x13C6]={
  category="lo",
  description="CHEROKEE LETTER QUA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C6,
 },
 [0x13C7]={
  category="lo",
  description="CHEROKEE LETTER QUE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C7,
 },
 [0x13C8]={
  category="lo",
  description="CHEROKEE LETTER QUI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C8,
 },
 [0x13C9]={
  category="lo",
  description="CHEROKEE LETTER QUO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13C9,
 },
 [0x13CA]={
  category="lo",
  description="CHEROKEE LETTER QUU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CA,
 },
 [0x13CB]={
  category="lo",
  description="CHEROKEE LETTER QUV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CB,
 },
 [0x13CC]={
  category="lo",
  description="CHEROKEE LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CC,
 },
 [0x13CD]={
  category="lo",
  description="CHEROKEE LETTER S",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CD,
 },
 [0x13CE]={
  category="lo",
  description="CHEROKEE LETTER SE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CE,
 },
 [0x13CF]={
  category="lo",
  description="CHEROKEE LETTER SI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13CF,
 },
 [0x13D0]={
  category="lo",
  description="CHEROKEE LETTER SO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D0,
 },
 [0x13D1]={
  category="lo",
  description="CHEROKEE LETTER SU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D1,
 },
 [0x13D2]={
  category="lo",
  description="CHEROKEE LETTER SV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D2,
 },
 [0x13D3]={
  category="lo",
  description="CHEROKEE LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D3,
 },
 [0x13D4]={
  category="lo",
  description="CHEROKEE LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D4,
 },
 [0x13D5]={
  category="lo",
  description="CHEROKEE LETTER DE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D5,
 },
 [0x13D6]={
  category="lo",
  description="CHEROKEE LETTER TE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D6,
 },
 [0x13D7]={
  category="lo",
  description="CHEROKEE LETTER DI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D7,
 },
 [0x13D8]={
  category="lo",
  description="CHEROKEE LETTER TI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D8,
 },
 [0x13D9]={
  category="lo",
  description="CHEROKEE LETTER DO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13D9,
 },
 [0x13DA]={
  category="lo",
  description="CHEROKEE LETTER DU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DA,
 },
 [0x13DB]={
  category="lo",
  description="CHEROKEE LETTER DV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DB,
 },
 [0x13DC]={
  category="lo",
  description="CHEROKEE LETTER DLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DC,
 },
 [0x13DD]={
  category="lo",
  description="CHEROKEE LETTER TLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DD,
 },
 [0x13DE]={
  category="lo",
  description="CHEROKEE LETTER TLE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DE,
 },
 [0x13DF]={
  category="lo",
  description="CHEROKEE LETTER TLI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13DF,
 },
 [0x13E0]={
  category="lo",
  description="CHEROKEE LETTER TLO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E0,
 },
 [0x13E1]={
  category="lo",
  description="CHEROKEE LETTER TLU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E1,
 },
 [0x13E2]={
  category="lo",
  description="CHEROKEE LETTER TLV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E2,
 },
 [0x13E3]={
  category="lo",
  description="CHEROKEE LETTER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E3,
 },
 [0x13E4]={
  category="lo",
  description="CHEROKEE LETTER TSE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E4,
 },
 [0x13E5]={
  category="lo",
  description="CHEROKEE LETTER TSI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E5,
 },
 [0x13E6]={
  category="lo",
  description="CHEROKEE LETTER TSO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E6,
 },
 [0x13E7]={
  category="lo",
  description="CHEROKEE LETTER TSU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E7,
 },
 [0x13E8]={
  category="lo",
  description="CHEROKEE LETTER TSV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E8,
 },
 [0x13E9]={
  category="lo",
  description="CHEROKEE LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13E9,
 },
 [0x13EA]={
  category="lo",
  description="CHEROKEE LETTER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EA,
 },
 [0x13EB]={
  category="lo",
  description="CHEROKEE LETTER WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EB,
 },
 [0x13EC]={
  category="lo",
  description="CHEROKEE LETTER WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EC,
 },
 [0x13ED]={
  category="lo",
  description="CHEROKEE LETTER WU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13ED,
 },
 [0x13EE]={
  category="lo",
  description="CHEROKEE LETTER WV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EE,
 },
 [0x13EF]={
  category="lo",
  description="CHEROKEE LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x13EF,
 },
 [0x13F0]={
  category="lo",
  description="CHEROKEE LETTER YE",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F0,
 },
 [0x13F1]={
  category="lo",
  description="CHEROKEE LETTER YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F1,
 },
 [0x13F2]={
  category="lo",
  description="CHEROKEE LETTER YO",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F2,
 },
 [0x13F3]={
  category="lo",
  description="CHEROKEE LETTER YU",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F3,
 },
 [0x13F4]={
  category="lo",
  description="CHEROKEE LETTER YV",
  direction="l",
  linebreak="al",
  unicodeslot=0x13F4,
 },
 [0x1400]={
  category="pd",
  description="CANADIAN SYLLABICS HYPHEN",
  direction="on",
  linebreak="ba",
  unicodeslot=0x1400,
 },
 [0x1401]={
  category="lo",
  description="CANADIAN SYLLABICS E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1401,
 },
 [0x1402]={
  category="lo",
  description="CANADIAN SYLLABICS AAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1402,
 },
 [0x1403]={
  category="lo",
  description="CANADIAN SYLLABICS I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1403,
 },
 [0x1404]={
  category="lo",
  description="CANADIAN SYLLABICS II",
  direction="l",
  linebreak="al",
  unicodeslot=0x1404,
 },
 [0x1405]={
  category="lo",
  description="CANADIAN SYLLABICS O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1405,
 },
 [0x1406]={
  category="lo",
  description="CANADIAN SYLLABICS OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1406,
 },
 [0x1407]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE OO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1407,
 },
 [0x1408]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1408,
 },
 [0x1409]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1409,
 },
 [0x140A]={
  category="lo",
  description="CANADIAN SYLLABICS A",
  direction="l",
  linebreak="al",
  unicodeslot=0x140A,
 },
 [0x140B]={
  category="lo",
  description="CANADIAN SYLLABICS AA",
  direction="l",
  linebreak="al",
  unicodeslot=0x140B,
 },
 [0x140C]={
  category="lo",
  description="CANADIAN SYLLABICS WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x140C,
 },
 [0x140D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x140D,
 },
 [0x140E]={
  category="lo",
  description="CANADIAN SYLLABICS WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x140E,
 },
 [0x140F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x140F,
 },
 [0x1410]={
  category="lo",
  description="CANADIAN SYLLABICS WII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1410,
 },
 [0x1411]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1411,
 },
 [0x1412]={
  category="lo",
  description="CANADIAN SYLLABICS WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1412,
 },
 [0x1413]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1413,
 },
 [0x1414]={
  category="lo",
  description="CANADIAN SYLLABICS WOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1414,
 },
 [0x1415]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1415,
 },
 [0x1416]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI WOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1416,
 },
 [0x1417]={
  category="lo",
  description="CANADIAN SYLLABICS WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1417,
 },
 [0x1418]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1418,
 },
 [0x1419]={
  category="lo",
  description="CANADIAN SYLLABICS WAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1419,
 },
 [0x141A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE WAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x141A,
 },
 [0x141B]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI WAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x141B,
 },
 [0x141C]={
  category="lo",
  description="CANADIAN SYLLABICS AI",
  direction="l",
  linebreak="al",
  unicodeslot=0x141C,
 },
 [0x141D]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE W",
  direction="l",
  linebreak="al",
  unicodeslot=0x141D,
 },
 [0x141E]={
  category="lo",
  description="CANADIAN SYLLABICS GLOTTAL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x141E,
 },
 [0x141F]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL ACUTE",
  direction="l",
  linebreak="al",
  unicodeslot=0x141F,
 },
 [0x1420]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL GRAVE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1420,
 },
 [0x1421]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL BOTTOM HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1421,
 },
 [0x1422]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL TOP HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1422,
 },
 [0x1423]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL RIGHT HALF RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1423,
 },
 [0x1424]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1424,
 },
 [0x1425]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL DOUBLE ACUTE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1425,
 },
 [0x1426]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES",
  direction="l",
  linebreak="al",
  unicodeslot=0x1426,
 },
 [0x1427]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL MIDDLE DOT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1427,
 },
 [0x1428]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1428,
 },
 [0x1429]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL PLUS",
  direction="l",
  linebreak="al",
  unicodeslot=0x1429,
 },
 [0x142A]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL DOWN TACK",
  direction="l",
  linebreak="al",
  unicodeslot=0x142A,
 },
 [0x142B]={
  category="lo",
  description="CANADIAN SYLLABICS EN",
  direction="l",
  linebreak="al",
  unicodeslot=0x142B,
 },
 [0x142C]={
  category="lo",
  description="CANADIAN SYLLABICS IN",
  direction="l",
  linebreak="al",
  unicodeslot=0x142C,
 },
 [0x142D]={
  category="lo",
  description="CANADIAN SYLLABICS ON",
  direction="l",
  linebreak="al",
  unicodeslot=0x142D,
 },
 [0x142E]={
  category="lo",
  description="CANADIAN SYLLABICS AN",
  direction="l",
  linebreak="al",
  unicodeslot=0x142E,
 },
 [0x142F]={
  category="lo",
  description="CANADIAN SYLLABICS PE",
  direction="l",
  linebreak="al",
  unicodeslot=0x142F,
 },
 [0x1430]={
  category="lo",
  description="CANADIAN SYLLABICS PAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1430,
 },
 [0x1431]={
  category="lo",
  description="CANADIAN SYLLABICS PI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1431,
 },
 [0x1432]={
  category="lo",
  description="CANADIAN SYLLABICS PII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1432,
 },
 [0x1433]={
  category="lo",
  description="CANADIAN SYLLABICS PO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1433,
 },
 [0x1434]={
  category="lo",
  description="CANADIAN SYLLABICS POO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1434,
 },
 [0x1435]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE POO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1435,
 },
 [0x1436]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1436,
 },
 [0x1437]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1437,
 },
 [0x1438]={
  category="lo",
  description="CANADIAN SYLLABICS PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1438,
 },
 [0x1439]={
  category="lo",
  description="CANADIAN SYLLABICS PAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1439,
 },
 [0x143A]={
  category="lo",
  description="CANADIAN SYLLABICS PWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x143A,
 },
 [0x143B]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x143B,
 },
 [0x143C]={
  category="lo",
  description="CANADIAN SYLLABICS PWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x143C,
 },
 [0x143D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x143D,
 },
 [0x143E]={
  category="lo",
  description="CANADIAN SYLLABICS PWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x143E,
 },
 [0x143F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x143F,
 },
 [0x1440]={
  category="lo",
  description="CANADIAN SYLLABICS PWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1440,
 },
 [0x1441]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1441,
 },
 [0x1442]={
  category="lo",
  description="CANADIAN SYLLABICS PWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1442,
 },
 [0x1443]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1443,
 },
 [0x1444]={
  category="lo",
  description="CANADIAN SYLLABICS PWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1444,
 },
 [0x1445]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1445,
 },
 [0x1446]={
  category="lo",
  description="CANADIAN SYLLABICS PWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1446,
 },
 [0x1447]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE PWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1447,
 },
 [0x1448]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE PWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1448,
 },
 [0x1449]={
  category="lo",
  description="CANADIAN SYLLABICS P",
  direction="l",
  linebreak="al",
  unicodeslot=0x1449,
 },
 [0x144A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE P",
  direction="l",
  linebreak="al",
  unicodeslot=0x144A,
 },
 [0x144B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER H",
  direction="l",
  linebreak="al",
  unicodeslot=0x144B,
 },
 [0x144C]={
  category="lo",
  description="CANADIAN SYLLABICS TE",
  direction="l",
  linebreak="al",
  unicodeslot=0x144C,
 },
 [0x144D]={
  category="lo",
  description="CANADIAN SYLLABICS TAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x144D,
 },
 [0x144E]={
  category="lo",
  description="CANADIAN SYLLABICS TI",
  direction="l",
  linebreak="al",
  unicodeslot=0x144E,
 },
 [0x144F]={
  category="lo",
  description="CANADIAN SYLLABICS TII",
  direction="l",
  linebreak="al",
  unicodeslot=0x144F,
 },
 [0x1450]={
  category="lo",
  description="CANADIAN SYLLABICS TO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1450,
 },
 [0x1451]={
  category="lo",
  description="CANADIAN SYLLABICS TOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1451,
 },
 [0x1452]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE TOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1452,
 },
 [0x1453]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1453,
 },
 [0x1454]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1454,
 },
 [0x1455]={
  category="lo",
  description="CANADIAN SYLLABICS TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1455,
 },
 [0x1456]={
  category="lo",
  description="CANADIAN SYLLABICS TAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1456,
 },
 [0x1457]={
  category="lo",
  description="CANADIAN SYLLABICS TWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1457,
 },
 [0x1458]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1458,
 },
 [0x1459]={
  category="lo",
  description="CANADIAN SYLLABICS TWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1459,
 },
 [0x145A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x145A,
 },
 [0x145B]={
  category="lo",
  description="CANADIAN SYLLABICS TWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x145B,
 },
 [0x145C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x145C,
 },
 [0x145D]={
  category="lo",
  description="CANADIAN SYLLABICS TWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x145D,
 },
 [0x145E]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x145E,
 },
 [0x145F]={
  category="lo",
  description="CANADIAN SYLLABICS TWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x145F,
 },
 [0x1460]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1460,
 },
 [0x1461]={
  category="lo",
  description="CANADIAN SYLLABICS TWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1461,
 },
 [0x1462]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1462,
 },
 [0x1463]={
  category="lo",
  description="CANADIAN SYLLABICS TWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1463,
 },
 [0x1464]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE TWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1464,
 },
 [0x1465]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI TWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1465,
 },
 [0x1466]={
  category="lo",
  description="CANADIAN SYLLABICS T",
  direction="l",
  linebreak="al",
  unicodeslot=0x1466,
 },
 [0x1467]={
  category="lo",
  description="CANADIAN SYLLABICS TTE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1467,
 },
 [0x1468]={
  category="lo",
  description="CANADIAN SYLLABICS TTI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1468,
 },
 [0x1469]={
  category="lo",
  description="CANADIAN SYLLABICS TTO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1469,
 },
 [0x146A]={
  category="lo",
  description="CANADIAN SYLLABICS TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x146A,
 },
 [0x146B]={
  category="lo",
  description="CANADIAN SYLLABICS KE",
  direction="l",
  linebreak="al",
  unicodeslot=0x146B,
 },
 [0x146C]={
  category="lo",
  description="CANADIAN SYLLABICS KAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x146C,
 },
 [0x146D]={
  category="lo",
  description="CANADIAN SYLLABICS KI",
  direction="l",
  linebreak="al",
  unicodeslot=0x146D,
 },
 [0x146E]={
  category="lo",
  description="CANADIAN SYLLABICS KII",
  direction="l",
  linebreak="al",
  unicodeslot=0x146E,
 },
 [0x146F]={
  category="lo",
  description="CANADIAN SYLLABICS KO",
  direction="l",
  linebreak="al",
  unicodeslot=0x146F,
 },
 [0x1470]={
  category="lo",
  description="CANADIAN SYLLABICS KOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1470,
 },
 [0x1471]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE KOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1471,
 },
 [0x1472]={
  category="lo",
  description="CANADIAN SYLLABICS KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1472,
 },
 [0x1473]={
  category="lo",
  description="CANADIAN SYLLABICS KAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1473,
 },
 [0x1474]={
  category="lo",
  description="CANADIAN SYLLABICS KWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1474,
 },
 [0x1475]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1475,
 },
 [0x1476]={
  category="lo",
  description="CANADIAN SYLLABICS KWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1476,
 },
 [0x1477]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1477,
 },
 [0x1478]={
  category="lo",
  description="CANADIAN SYLLABICS KWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1478,
 },
 [0x1479]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1479,
 },
 [0x147A]={
  category="lo",
  description="CANADIAN SYLLABICS KWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x147A,
 },
 [0x147B]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x147B,
 },
 [0x147C]={
  category="lo",
  description="CANADIAN SYLLABICS KWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x147C,
 },
 [0x147D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x147D,
 },
 [0x147E]={
  category="lo",
  description="CANADIAN SYLLABICS KWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x147E,
 },
 [0x147F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x147F,
 },
 [0x1480]={
  category="lo",
  description="CANADIAN SYLLABICS KWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1480,
 },
 [0x1481]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE KWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1481,
 },
 [0x1482]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI KWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1482,
 },
 [0x1483]={
  category="lo",
  description="CANADIAN SYLLABICS K",
  direction="l",
  linebreak="al",
  unicodeslot=0x1483,
 },
 [0x1484]={
  category="lo",
  description="CANADIAN SYLLABICS KW",
  direction="l",
  linebreak="al",
  unicodeslot=0x1484,
 },
 [0x1485]={
  category="lo",
  description="CANADIAN SYLLABICS SOUTH-SLAVEY KEH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1485,
 },
 [0x1486]={
  category="lo",
  description="CANADIAN SYLLABICS SOUTH-SLAVEY KIH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1486,
 },
 [0x1487]={
  category="lo",
  description="CANADIAN SYLLABICS SOUTH-SLAVEY KOH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1487,
 },
 [0x1488]={
  category="lo",
  description="CANADIAN SYLLABICS SOUTH-SLAVEY KAH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1488,
 },
 [0x1489]={
  category="lo",
  description="CANADIAN SYLLABICS CE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1489,
 },
 [0x148A]={
  category="lo",
  description="CANADIAN SYLLABICS CAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x148A,
 },
 [0x148B]={
  category="lo",
  description="CANADIAN SYLLABICS CI",
  direction="l",
  linebreak="al",
  unicodeslot=0x148B,
 },
 [0x148C]={
  category="lo",
  description="CANADIAN SYLLABICS CII",
  direction="l",
  linebreak="al",
  unicodeslot=0x148C,
 },
 [0x148D]={
  category="lo",
  description="CANADIAN SYLLABICS CO",
  direction="l",
  linebreak="al",
  unicodeslot=0x148D,
 },
 [0x148E]={
  category="lo",
  description="CANADIAN SYLLABICS COO",
  direction="l",
  linebreak="al",
  unicodeslot=0x148E,
 },
 [0x148F]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE COO",
  direction="l",
  linebreak="al",
  unicodeslot=0x148F,
 },
 [0x1490]={
  category="lo",
  description="CANADIAN SYLLABICS CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1490,
 },
 [0x1491]={
  category="lo",
  description="CANADIAN SYLLABICS CAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1491,
 },
 [0x1492]={
  category="lo",
  description="CANADIAN SYLLABICS CWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1492,
 },
 [0x1493]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1493,
 },
 [0x1494]={
  category="lo",
  description="CANADIAN SYLLABICS CWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1494,
 },
 [0x1495]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1495,
 },
 [0x1496]={
  category="lo",
  description="CANADIAN SYLLABICS CWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1496,
 },
 [0x1497]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1497,
 },
 [0x1498]={
  category="lo",
  description="CANADIAN SYLLABICS CWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1498,
 },
 [0x1499]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1499,
 },
 [0x149A]={
  category="lo",
  description="CANADIAN SYLLABICS CWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x149A,
 },
 [0x149B]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x149B,
 },
 [0x149C]={
  category="lo",
  description="CANADIAN SYLLABICS CWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x149C,
 },
 [0x149D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x149D,
 },
 [0x149E]={
  category="lo",
  description="CANADIAN SYLLABICS CWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x149E,
 },
 [0x149F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE CWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x149F,
 },
 [0x14A0]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI CWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A0,
 },
 [0x14A1]={
  category="lo",
  description="CANADIAN SYLLABICS C",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A1,
 },
 [0x14A2]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A2,
 },
 [0x14A3]={
  category="lo",
  description="CANADIAN SYLLABICS ME",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A3,
 },
 [0x14A4]={
  category="lo",
  description="CANADIAN SYLLABICS MAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A4,
 },
 [0x14A5]={
  category="lo",
  description="CANADIAN SYLLABICS MI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A5,
 },
 [0x14A6]={
  category="lo",
  description="CANADIAN SYLLABICS MII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A6,
 },
 [0x14A7]={
  category="lo",
  description="CANADIAN SYLLABICS MO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A7,
 },
 [0x14A8]={
  category="lo",
  description="CANADIAN SYLLABICS MOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A8,
 },
 [0x14A9]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE MOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14A9,
 },
 [0x14AA]={
  category="lo",
  description="CANADIAN SYLLABICS MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AA,
 },
 [0x14AB]={
  category="lo",
  description="CANADIAN SYLLABICS MAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AB,
 },
 [0x14AC]={
  category="lo",
  description="CANADIAN SYLLABICS MWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AC,
 },
 [0x14AD]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AD,
 },
 [0x14AE]={
  category="lo",
  description="CANADIAN SYLLABICS MWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AE,
 },
 [0x14AF]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14AF,
 },
 [0x14B0]={
  category="lo",
  description="CANADIAN SYLLABICS MWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B0,
 },
 [0x14B1]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B1,
 },
 [0x14B2]={
  category="lo",
  description="CANADIAN SYLLABICS MWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B2,
 },
 [0x14B3]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B3,
 },
 [0x14B4]={
  category="lo",
  description="CANADIAN SYLLABICS MWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B4,
 },
 [0x14B5]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B5,
 },
 [0x14B6]={
  category="lo",
  description="CANADIAN SYLLABICS MWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B6,
 },
 [0x14B7]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B7,
 },
 [0x14B8]={
  category="lo",
  description="CANADIAN SYLLABICS MWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B8,
 },
 [0x14B9]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE MWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14B9,
 },
 [0x14BA]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI MWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BA,
 },
 [0x14BB]={
  category="lo",
  description="CANADIAN SYLLABICS M",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BB,
 },
 [0x14BC]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE M",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BC,
 },
 [0x14BD]={
  category="lo",
  description="CANADIAN SYLLABICS MH",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BD,
 },
 [0x14BE]={
  category="lo",
  description="CANADIAN SYLLABICS ATHAPASCAN M",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BE,
 },
 [0x14BF]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI M",
  direction="l",
  linebreak="al",
  unicodeslot=0x14BF,
 },
 [0x14C0]={
  category="lo",
  description="CANADIAN SYLLABICS NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C0,
 },
 [0x14C1]={
  category="lo",
  description="CANADIAN SYLLABICS NAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C1,
 },
 [0x14C2]={
  category="lo",
  description="CANADIAN SYLLABICS NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C2,
 },
 [0x14C3]={
  category="lo",
  description="CANADIAN SYLLABICS NII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C3,
 },
 [0x14C4]={
  category="lo",
  description="CANADIAN SYLLABICS NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C4,
 },
 [0x14C5]={
  category="lo",
  description="CANADIAN SYLLABICS NOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C5,
 },
 [0x14C6]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE NOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C6,
 },
 [0x14C7]={
  category="lo",
  description="CANADIAN SYLLABICS NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C7,
 },
 [0x14C8]={
  category="lo",
  description="CANADIAN SYLLABICS NAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C8,
 },
 [0x14C9]={
  category="lo",
  description="CANADIAN SYLLABICS NWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14C9,
 },
 [0x14CA]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE NWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CA,
 },
 [0x14CB]={
  category="lo",
  description="CANADIAN SYLLABICS NWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CB,
 },
 [0x14CC]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE NWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CC,
 },
 [0x14CD]={
  category="lo",
  description="CANADIAN SYLLABICS NWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CD,
 },
 [0x14CE]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE NWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CE,
 },
 [0x14CF]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI NWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14CF,
 },
 [0x14D0]={
  category="lo",
  description="CANADIAN SYLLABICS N",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D0,
 },
 [0x14D1]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NG",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D1,
 },
 [0x14D2]={
  category="lo",
  description="CANADIAN SYLLABICS NH",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D2,
 },
 [0x14D3]={
  category="lo",
  description="CANADIAN SYLLABICS LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D3,
 },
 [0x14D4]={
  category="lo",
  description="CANADIAN SYLLABICS LAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D4,
 },
 [0x14D5]={
  category="lo",
  description="CANADIAN SYLLABICS LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D5,
 },
 [0x14D6]={
  category="lo",
  description="CANADIAN SYLLABICS LII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D6,
 },
 [0x14D7]={
  category="lo",
  description="CANADIAN SYLLABICS LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D7,
 },
 [0x14D8]={
  category="lo",
  description="CANADIAN SYLLABICS LOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D8,
 },
 [0x14D9]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE LOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14D9,
 },
 [0x14DA]={
  category="lo",
  description="CANADIAN SYLLABICS LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DA,
 },
 [0x14DB]={
  category="lo",
  description="CANADIAN SYLLABICS LAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DB,
 },
 [0x14DC]={
  category="lo",
  description="CANADIAN SYLLABICS LWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DC,
 },
 [0x14DD]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DD,
 },
 [0x14DE]={
  category="lo",
  description="CANADIAN SYLLABICS LWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DE,
 },
 [0x14DF]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14DF,
 },
 [0x14E0]={
  category="lo",
  description="CANADIAN SYLLABICS LWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E0,
 },
 [0x14E1]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E1,
 },
 [0x14E2]={
  category="lo",
  description="CANADIAN SYLLABICS LWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E2,
 },
 [0x14E3]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E3,
 },
 [0x14E4]={
  category="lo",
  description="CANADIAN SYLLABICS LWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E4,
 },
 [0x14E5]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E5,
 },
 [0x14E6]={
  category="lo",
  description="CANADIAN SYLLABICS LWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E6,
 },
 [0x14E7]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E7,
 },
 [0x14E8]={
  category="lo",
  description="CANADIAN SYLLABICS LWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E8,
 },
 [0x14E9]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14E9,
 },
 [0x14EA]={
  category="lo",
  description="CANADIAN SYLLABICS L",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EA,
 },
 [0x14EB]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE L",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EB,
 },
 [0x14EC]={
  category="lo",
  description="CANADIAN SYLLABICS MEDIAL L",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EC,
 },
 [0x14ED]={
  category="lo",
  description="CANADIAN SYLLABICS SE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14ED,
 },
 [0x14EE]={
  category="lo",
  description="CANADIAN SYLLABICS SAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EE,
 },
 [0x14EF]={
  category="lo",
  description="CANADIAN SYLLABICS SI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14EF,
 },
 [0x14F0]={
  category="lo",
  description="CANADIAN SYLLABICS SII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F0,
 },
 [0x14F1]={
  category="lo",
  description="CANADIAN SYLLABICS SO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F1,
 },
 [0x14F2]={
  category="lo",
  description="CANADIAN SYLLABICS SOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F2,
 },
 [0x14F3]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE SOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F3,
 },
 [0x14F4]={
  category="lo",
  description="CANADIAN SYLLABICS SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F4,
 },
 [0x14F5]={
  category="lo",
  description="CANADIAN SYLLABICS SAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F5,
 },
 [0x14F6]={
  category="lo",
  description="CANADIAN SYLLABICS SWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F6,
 },
 [0x14F7]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F7,
 },
 [0x14F8]={
  category="lo",
  description="CANADIAN SYLLABICS SWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F8,
 },
 [0x14F9]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x14F9,
 },
 [0x14FA]={
  category="lo",
  description="CANADIAN SYLLABICS SWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FA,
 },
 [0x14FB]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FB,
 },
 [0x14FC]={
  category="lo",
  description="CANADIAN SYLLABICS SWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FC,
 },
 [0x14FD]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FD,
 },
 [0x14FE]={
  category="lo",
  description="CANADIAN SYLLABICS SWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FE,
 },
 [0x14FF]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x14FF,
 },
 [0x1500]={
  category="lo",
  description="CANADIAN SYLLABICS SWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1500,
 },
 [0x1501]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1501,
 },
 [0x1502]={
  category="lo",
  description="CANADIAN SYLLABICS SWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1502,
 },
 [0x1503]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1503,
 },
 [0x1504]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1504,
 },
 [0x1505]={
  category="lo",
  description="CANADIAN SYLLABICS S",
  direction="l",
  linebreak="al",
  unicodeslot=0x1505,
 },
 [0x1506]={
  category="lo",
  description="CANADIAN SYLLABICS ATHAPASCAN S",
  direction="l",
  linebreak="al",
  unicodeslot=0x1506,
 },
 [0x1507]={
  category="lo",
  description="CANADIAN SYLLABICS SW",
  direction="l",
  linebreak="al",
  unicodeslot=0x1507,
 },
 [0x1508]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT S",
  direction="l",
  linebreak="al",
  unicodeslot=0x1508,
 },
 [0x1509]={
  category="lo",
  description="CANADIAN SYLLABICS MOOSE-CREE SK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1509,
 },
 [0x150A]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SKW",
  direction="l",
  linebreak="al",
  unicodeslot=0x150A,
 },
 [0x150B]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI S-W",
  direction="l",
  linebreak="al",
  unicodeslot=0x150B,
 },
 [0x150C]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SPWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x150C,
 },
 [0x150D]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI STWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x150D,
 },
 [0x150E]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SKWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x150E,
 },
 [0x150F]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI SCWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x150F,
 },
 [0x1510]={
  category="lo",
  description="CANADIAN SYLLABICS SHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1510,
 },
 [0x1511]={
  category="lo",
  description="CANADIAN SYLLABICS SHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1511,
 },
 [0x1512]={
  category="lo",
  description="CANADIAN SYLLABICS SHII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1512,
 },
 [0x1513]={
  category="lo",
  description="CANADIAN SYLLABICS SHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1513,
 },
 [0x1514]={
  category="lo",
  description="CANADIAN SYLLABICS SHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1514,
 },
 [0x1515]={
  category="lo",
  description="CANADIAN SYLLABICS SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1515,
 },
 [0x1516]={
  category="lo",
  description="CANADIAN SYLLABICS SHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1516,
 },
 [0x1517]={
  category="lo",
  description="CANADIAN SYLLABICS SHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1517,
 },
 [0x1518]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1518,
 },
 [0x1519]={
  category="lo",
  description="CANADIAN SYLLABICS SHWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1519,
 },
 [0x151A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x151A,
 },
 [0x151B]={
  category="lo",
  description="CANADIAN SYLLABICS SHWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x151B,
 },
 [0x151C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x151C,
 },
 [0x151D]={
  category="lo",
  description="CANADIAN SYLLABICS SHWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x151D,
 },
 [0x151E]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x151E,
 },
 [0x151F]={
  category="lo",
  description="CANADIAN SYLLABICS SHWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x151F,
 },
 [0x1520]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1520,
 },
 [0x1521]={
  category="lo",
  description="CANADIAN SYLLABICS SHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1521,
 },
 [0x1522]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1522,
 },
 [0x1523]={
  category="lo",
  description="CANADIAN SYLLABICS SHWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1523,
 },
 [0x1524]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE SHWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1524,
 },
 [0x1525]={
  category="lo",
  description="CANADIAN SYLLABICS SH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1525,
 },
 [0x1526]={
  category="lo",
  description="CANADIAN SYLLABICS YE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1526,
 },
 [0x1527]={
  category="lo",
  description="CANADIAN SYLLABICS YAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1527,
 },
 [0x1528]={
  category="lo",
  description="CANADIAN SYLLABICS YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1528,
 },
 [0x1529]={
  category="lo",
  description="CANADIAN SYLLABICS YII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1529,
 },
 [0x152A]={
  category="lo",
  description="CANADIAN SYLLABICS YO",
  direction="l",
  linebreak="al",
  unicodeslot=0x152A,
 },
 [0x152B]={
  category="lo",
  description="CANADIAN SYLLABICS YOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x152B,
 },
 [0x152C]={
  category="lo",
  description="CANADIAN SYLLABICS Y-CREE YOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x152C,
 },
 [0x152D]={
  category="lo",
  description="CANADIAN SYLLABICS YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x152D,
 },
 [0x152E]={
  category="lo",
  description="CANADIAN SYLLABICS YAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x152E,
 },
 [0x152F]={
  category="lo",
  description="CANADIAN SYLLABICS YWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x152F,
 },
 [0x1530]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1530,
 },
 [0x1531]={
  category="lo",
  description="CANADIAN SYLLABICS YWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1531,
 },
 [0x1532]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1532,
 },
 [0x1533]={
  category="lo",
  description="CANADIAN SYLLABICS YWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1533,
 },
 [0x1534]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1534,
 },
 [0x1535]={
  category="lo",
  description="CANADIAN SYLLABICS YWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1535,
 },
 [0x1536]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1536,
 },
 [0x1537]={
  category="lo",
  description="CANADIAN SYLLABICS YWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1537,
 },
 [0x1538]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1538,
 },
 [0x1539]={
  category="lo",
  description="CANADIAN SYLLABICS YWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1539,
 },
 [0x153A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x153A,
 },
 [0x153B]={
  category="lo",
  description="CANADIAN SYLLABICS YWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x153B,
 },
 [0x153C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE YWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x153C,
 },
 [0x153D]={
  category="lo",
  description="CANADIAN SYLLABICS NASKAPI YWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x153D,
 },
 [0x153E]={
  category="lo",
  description="CANADIAN SYLLABICS Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x153E,
 },
 [0x153F]={
  category="lo",
  description="CANADIAN SYLLABICS BIBLE-CREE Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x153F,
 },
 [0x1540]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x1540,
 },
 [0x1541]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1541,
 },
 [0x1542]={
  category="lo",
  description="CANADIAN SYLLABICS RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1542,
 },
 [0x1543]={
  category="lo",
  description="CANADIAN SYLLABICS R-CREE RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1543,
 },
 [0x1544]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1544,
 },
 [0x1545]={
  category="lo",
  description="CANADIAN SYLLABICS RAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1545,
 },
 [0x1546]={
  category="lo",
  description="CANADIAN SYLLABICS RI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1546,
 },
 [0x1547]={
  category="lo",
  description="CANADIAN SYLLABICS RII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1547,
 },
 [0x1548]={
  category="lo",
  description="CANADIAN SYLLABICS RO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1548,
 },
 [0x1549]={
  category="lo",
  description="CANADIAN SYLLABICS ROO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1549,
 },
 [0x154A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x154A,
 },
 [0x154B]={
  category="lo",
  description="CANADIAN SYLLABICS RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154B,
 },
 [0x154C]={
  category="lo",
  description="CANADIAN SYLLABICS RAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154C,
 },
 [0x154D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154D,
 },
 [0x154E]={
  category="lo",
  description="CANADIAN SYLLABICS RWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154E,
 },
 [0x154F]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x154F,
 },
 [0x1550]={
  category="lo",
  description="CANADIAN SYLLABICS R",
  direction="l",
  linebreak="al",
  unicodeslot=0x1550,
 },
 [0x1551]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE R",
  direction="l",
  linebreak="al",
  unicodeslot=0x1551,
 },
 [0x1552]={
  category="lo",
  description="CANADIAN SYLLABICS MEDIAL R",
  direction="l",
  linebreak="al",
  unicodeslot=0x1552,
 },
 [0x1553]={
  category="lo",
  description="CANADIAN SYLLABICS FE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1553,
 },
 [0x1554]={
  category="lo",
  description="CANADIAN SYLLABICS FAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1554,
 },
 [0x1555]={
  category="lo",
  description="CANADIAN SYLLABICS FI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1555,
 },
 [0x1556]={
  category="lo",
  description="CANADIAN SYLLABICS FII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1556,
 },
 [0x1557]={
  category="lo",
  description="CANADIAN SYLLABICS FO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1557,
 },
 [0x1558]={
  category="lo",
  description="CANADIAN SYLLABICS FOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1558,
 },
 [0x1559]={
  category="lo",
  description="CANADIAN SYLLABICS FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1559,
 },
 [0x155A]={
  category="lo",
  description="CANADIAN SYLLABICS FAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x155A,
 },
 [0x155B]={
  category="lo",
  description="CANADIAN SYLLABICS FWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x155B,
 },
 [0x155C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE FWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x155C,
 },
 [0x155D]={
  category="lo",
  description="CANADIAN SYLLABICS F",
  direction="l",
  linebreak="al",
  unicodeslot=0x155D,
 },
 [0x155E]={
  category="lo",
  description="CANADIAN SYLLABICS THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x155E,
 },
 [0x155F]={
  category="lo",
  description="CANADIAN SYLLABICS N-CREE THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x155F,
 },
 [0x1560]={
  category="lo",
  description="CANADIAN SYLLABICS THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1560,
 },
 [0x1561]={
  category="lo",
  description="CANADIAN SYLLABICS N-CREE THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1561,
 },
 [0x1562]={
  category="lo",
  description="CANADIAN SYLLABICS THII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1562,
 },
 [0x1563]={
  category="lo",
  description="CANADIAN SYLLABICS N-CREE THII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1563,
 },
 [0x1564]={
  category="lo",
  description="CANADIAN SYLLABICS THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1564,
 },
 [0x1565]={
  category="lo",
  description="CANADIAN SYLLABICS THOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1565,
 },
 [0x1566]={
  category="lo",
  description="CANADIAN SYLLABICS THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1566,
 },
 [0x1567]={
  category="lo",
  description="CANADIAN SYLLABICS THAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1567,
 },
 [0x1568]={
  category="lo",
  description="CANADIAN SYLLABICS THWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1568,
 },
 [0x1569]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE THWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1569,
 },
 [0x156A]={
  category="lo",
  description="CANADIAN SYLLABICS TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x156A,
 },
 [0x156B]={
  category="lo",
  description="CANADIAN SYLLABICS TTHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x156B,
 },
 [0x156C]={
  category="lo",
  description="CANADIAN SYLLABICS TTHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x156C,
 },
 [0x156D]={
  category="lo",
  description="CANADIAN SYLLABICS TTHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x156D,
 },
 [0x156E]={
  category="lo",
  description="CANADIAN SYLLABICS TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x156E,
 },
 [0x156F]={
  category="lo",
  description="CANADIAN SYLLABICS TTH",
  direction="l",
  linebreak="al",
  unicodeslot=0x156F,
 },
 [0x1570]={
  category="lo",
  description="CANADIAN SYLLABICS TYE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1570,
 },
 [0x1571]={
  category="lo",
  description="CANADIAN SYLLABICS TYI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1571,
 },
 [0x1572]={
  category="lo",
  description="CANADIAN SYLLABICS TYO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1572,
 },
 [0x1573]={
  category="lo",
  description="CANADIAN SYLLABICS TYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1573,
 },
 [0x1574]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1574,
 },
 [0x1575]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1575,
 },
 [0x1576]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1576,
 },
 [0x1577]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1577,
 },
 [0x1578]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1578,
 },
 [0x1579]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1579,
 },
 [0x157A]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x157A,
 },
 [0x157B]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVIK H",
  direction="l",
  linebreak="al",
  unicodeslot=0x157B,
 },
 [0x157C]={
  category="lo",
  description="CANADIAN SYLLABICS NUNAVUT H",
  direction="l",
  linebreak="al",
  unicodeslot=0x157C,
 },
 [0x157D]={
  category="lo",
  description="CANADIAN SYLLABICS HK",
  direction="l",
  linebreak="al",
  unicodeslot=0x157D,
 },
 [0x157E]={
  category="lo",
  description="CANADIAN SYLLABICS QAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x157E,
 },
 [0x157F]={
  category="lo",
  description="CANADIAN SYLLABICS QI",
  direction="l",
  linebreak="al",
  unicodeslot=0x157F,
 },
 [0x1580]={
  category="lo",
  description="CANADIAN SYLLABICS QII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1580,
 },
 [0x1581]={
  category="lo",
  description="CANADIAN SYLLABICS QO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1581,
 },
 [0x1582]={
  category="lo",
  description="CANADIAN SYLLABICS QOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1582,
 },
 [0x1583]={
  category="lo",
  description="CANADIAN SYLLABICS QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1583,
 },
 [0x1584]={
  category="lo",
  description="CANADIAN SYLLABICS QAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1584,
 },
 [0x1585]={
  category="lo",
  description="CANADIAN SYLLABICS Q",
  direction="l",
  linebreak="al",
  unicodeslot=0x1585,
 },
 [0x1586]={
  category="lo",
  description="CANADIAN SYLLABICS TLHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1586,
 },
 [0x1587]={
  category="lo",
  description="CANADIAN SYLLABICS TLHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1587,
 },
 [0x1588]={
  category="lo",
  description="CANADIAN SYLLABICS TLHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1588,
 },
 [0x1589]={
  category="lo",
  description="CANADIAN SYLLABICS TLHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1589,
 },
 [0x158A]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x158A,
 },
 [0x158B]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RI",
  direction="l",
  linebreak="al",
  unicodeslot=0x158B,
 },
 [0x158C]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RO",
  direction="l",
  linebreak="al",
  unicodeslot=0x158C,
 },
 [0x158D]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x158D,
 },
 [0x158E]={
  category="lo",
  description="CANADIAN SYLLABICS NGAAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x158E,
 },
 [0x158F]={
  category="lo",
  description="CANADIAN SYLLABICS NGI",
  direction="l",
  linebreak="al",
  unicodeslot=0x158F,
 },
 [0x1590]={
  category="lo",
  description="CANADIAN SYLLABICS NGII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1590,
 },
 [0x1591]={
  category="lo",
  description="CANADIAN SYLLABICS NGO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1591,
 },
 [0x1592]={
  category="lo",
  description="CANADIAN SYLLABICS NGOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1592,
 },
 [0x1593]={
  category="lo",
  description="CANADIAN SYLLABICS NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1593,
 },
 [0x1594]={
  category="lo",
  description="CANADIAN SYLLABICS NGAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1594,
 },
 [0x1595]={
  category="lo",
  description="CANADIAN SYLLABICS NG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1595,
 },
 [0x1596]={
  category="lo",
  description="CANADIAN SYLLABICS NNG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1596,
 },
 [0x1597]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1597,
 },
 [0x1598]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1598,
 },
 [0x1599]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1599,
 },
 [0x159A]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x159A,
 },
 [0x159B]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x159B,
 },
 [0x159C]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x159C,
 },
 [0x159D]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x159D,
 },
 [0x159E]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x159E,
 },
 [0x159F]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x159F,
 },
 [0x15A0]={
  category="lo",
  description="CANADIAN SYLLABICS LHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A0,
 },
 [0x15A1]={
  category="lo",
  description="CANADIAN SYLLABICS LHII",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A1,
 },
 [0x15A2]={
  category="lo",
  description="CANADIAN SYLLABICS LHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A2,
 },
 [0x15A3]={
  category="lo",
  description="CANADIAN SYLLABICS LHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A3,
 },
 [0x15A4]={
  category="lo",
  description="CANADIAN SYLLABICS LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A4,
 },
 [0x15A5]={
  category="lo",
  description="CANADIAN SYLLABICS LHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A5,
 },
 [0x15A6]={
  category="lo",
  description="CANADIAN SYLLABICS LH",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A6,
 },
 [0x15A7]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A7,
 },
 [0x15A8]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A8,
 },
 [0x15A9]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THII",
  direction="l",
  linebreak="al",
  unicodeslot=0x15A9,
 },
 [0x15AA]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AA,
 },
 [0x15AB]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AB,
 },
 [0x15AC]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AC,
 },
 [0x15AD]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE THAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AD,
 },
 [0x15AE]={
  category="lo",
  description="CANADIAN SYLLABICS TH-CREE TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AE,
 },
 [0x15AF]={
  category="lo",
  description="CANADIAN SYLLABICS AIVILIK B",
  direction="l",
  linebreak="al",
  unicodeslot=0x15AF,
 },
 [0x15B0]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT E",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B0,
 },
 [0x15B1]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT I",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B1,
 },
 [0x15B2]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT O",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B2,
 },
 [0x15B3]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT A",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B3,
 },
 [0x15B4]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B4,
 },
 [0x15B5]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B5,
 },
 [0x15B6]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B6,
 },
 [0x15B7]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B7,
 },
 [0x15B8]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B8,
 },
 [0x15B9]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15B9,
 },
 [0x15BA]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BA,
 },
 [0x15BB]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BB,
 },
 [0x15BC]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT KE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BC,
 },
 [0x15BD]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT KI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BD,
 },
 [0x15BE]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT KO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BE,
 },
 [0x15BF]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15BF,
 },
 [0x15C0]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C0,
 },
 [0x15C1]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C1,
 },
 [0x15C2]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C2,
 },
 [0x15C3]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C3,
 },
 [0x15C4]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C4,
 },
 [0x15C5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C5,
 },
 [0x15C6]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C6,
 },
 [0x15C7]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C7,
 },
 [0x15C8]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C8,
 },
 [0x15C9]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15C9,
 },
 [0x15CA]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CA,
 },
 [0x15CB]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CB,
 },
 [0x15CC]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CC,
 },
 [0x15CD]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER REE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CD,
 },
 [0x15CE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CE,
 },
 [0x15CF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15CF,
 },
 [0x15D0]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D0,
 },
 [0x15D1]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D1,
 },
 [0x15D2]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D2,
 },
 [0x15D3]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D3,
 },
 [0x15D4]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D4,
 },
 [0x15D5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D5,
 },
 [0x15D6]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D6,
 },
 [0x15D7]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D7,
 },
 [0x15D8]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D8,
 },
 [0x15D9]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15D9,
 },
 [0x15DA]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DA,
 },
 [0x15DB]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER HWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DB,
 },
 [0x15DC]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DC,
 },
 [0x15DD]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DD,
 },
 [0x15DE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DE,
 },
 [0x15DF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15DF,
 },
 [0x15E0]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E0,
 },
 [0x15E1]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E1,
 },
 [0x15E2]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E2,
 },
 [0x15E3]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E3,
 },
 [0x15E4]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E4,
 },
 [0x15E5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E5,
 },
 [0x15E6]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E6,
 },
 [0x15E7]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E7,
 },
 [0x15E8]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E8,
 },
 [0x15E9]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15E9,
 },
 [0x15EA]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EA,
 },
 [0x15EB]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EB,
 },
 [0x15EC]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EC,
 },
 [0x15ED]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15ED,
 },
 [0x15EE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER P",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EE,
 },
 [0x15EF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15EF,
 },
 [0x15F0]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F0,
 },
 [0x15F1]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F1,
 },
 [0x15F2]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F2,
 },
 [0x15F3]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F3,
 },
 [0x15F4]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F4,
 },
 [0x15F5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F5,
 },
 [0x15F6]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F6,
 },
 [0x15F7]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F7,
 },
 [0x15F8]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F8,
 },
 [0x15F9]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15F9,
 },
 [0x15FA]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FA,
 },
 [0x15FB]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKU",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FB,
 },
 [0x15FC]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKO",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FC,
 },
 [0x15FD]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FD,
 },
 [0x15FE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FE,
 },
 [0x15FF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKI",
  direction="l",
  linebreak="al",
  unicodeslot=0x15FF,
 },
 [0x1600]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KKA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1600,
 },
 [0x1601]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER KK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1601,
 },
 [0x1602]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1602,
 },
 [0x1603]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1603,
 },
 [0x1604]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1604,
 },
 [0x1605]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1605,
 },
 [0x1606]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1606,
 },
 [0x1607]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1607,
 },
 [0x1608]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1608,
 },
 [0x1609]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1609,
 },
 [0x160A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ME",
  direction="l",
  linebreak="al",
  unicodeslot=0x160A,
 },
 [0x160B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x160B,
 },
 [0x160C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MI",
  direction="l",
  linebreak="al",
  unicodeslot=0x160C,
 },
 [0x160D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x160D,
 },
 [0x160E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YU",
  direction="l",
  linebreak="al",
  unicodeslot=0x160E,
 },
 [0x160F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YO",
  direction="l",
  linebreak="al",
  unicodeslot=0x160F,
 },
 [0x1610]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1610,
 },
 [0x1611]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1611,
 },
 [0x1612]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1612,
 },
 [0x1613]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1613,
 },
 [0x1614]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1614,
 },
 [0x1615]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI JU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1615,
 },
 [0x1616]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1616,
 },
 [0x1617]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1617,
 },
 [0x1618]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1618,
 },
 [0x1619]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1619,
 },
 [0x161A]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI JI",
  direction="l",
  linebreak="al",
  unicodeslot=0x161A,
 },
 [0x161B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x161B,
 },
 [0x161C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJU",
  direction="l",
  linebreak="al",
  unicodeslot=0x161C,
 },
 [0x161D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJO",
  direction="l",
  linebreak="al",
  unicodeslot=0x161D,
 },
 [0x161E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJE",
  direction="l",
  linebreak="al",
  unicodeslot=0x161E,
 },
 [0x161F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x161F,
 },
 [0x1620]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1620,
 },
 [0x1621]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JJA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1621,
 },
 [0x1622]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1622,
 },
 [0x1623]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1623,
 },
 [0x1624]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1624,
 },
 [0x1625]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1625,
 },
 [0x1626]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1626,
 },
 [0x1627]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1627,
 },
 [0x1628]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1628,
 },
 [0x1629]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1629,
 },
 [0x162A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLE",
  direction="l",
  linebreak="al",
  unicodeslot=0x162A,
 },
 [0x162B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x162B,
 },
 [0x162C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLI",
  direction="l",
  linebreak="al",
  unicodeslot=0x162C,
 },
 [0x162D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x162D,
 },
 [0x162E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x162E,
 },
 [0x162F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x162F,
 },
 [0x1630]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1630,
 },
 [0x1631]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1631,
 },
 [0x1632]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1632,
 },
 [0x1633]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1633,
 },
 [0x1634]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1634,
 },
 [0x1635]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1635,
 },
 [0x1636]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1636,
 },
 [0x1637]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1637,
 },
 [0x1638]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1638,
 },
 [0x1639]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1639,
 },
 [0x163A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLU",
  direction="l",
  linebreak="al",
  unicodeslot=0x163A,
 },
 [0x163B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLO",
  direction="l",
  linebreak="al",
  unicodeslot=0x163B,
 },
 [0x163C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLE",
  direction="l",
  linebreak="al",
  unicodeslot=0x163C,
 },
 [0x163D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x163D,
 },
 [0x163E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLI",
  direction="l",
  linebreak="al",
  unicodeslot=0x163E,
 },
 [0x163F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x163F,
 },
 [0x1640]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1640,
 },
 [0x1641]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1641,
 },
 [0x1642]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1642,
 },
 [0x1643]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1643,
 },
 [0x1644]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1644,
 },
 [0x1645]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1645,
 },
 [0x1646]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER Z",
  direction="l",
  linebreak="al",
  unicodeslot=0x1646,
 },
 [0x1647]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER INITIAL Z",
  direction="l",
  linebreak="al",
  unicodeslot=0x1647,
 },
 [0x1648]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1648,
 },
 [0x1649]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1649,
 },
 [0x164A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZE",
  direction="l",
  linebreak="al",
  unicodeslot=0x164A,
 },
 [0x164B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x164B,
 },
 [0x164C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZI",
  direction="l",
  linebreak="al",
  unicodeslot=0x164C,
 },
 [0x164D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x164D,
 },
 [0x164E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SU",
  direction="l",
  linebreak="al",
  unicodeslot=0x164E,
 },
 [0x164F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SO",
  direction="l",
  linebreak="al",
  unicodeslot=0x164F,
 },
 [0x1650]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1650,
 },
 [0x1651]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1651,
 },
 [0x1652]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1652,
 },
 [0x1653]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1653,
 },
 [0x1654]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1654,
 },
 [0x1655]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1655,
 },
 [0x1656]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1656,
 },
 [0x1657]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1657,
 },
 [0x1658]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1658,
 },
 [0x1659]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1659,
 },
 [0x165A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER SH",
  direction="l",
  linebreak="al",
  unicodeslot=0x165A,
 },
 [0x165B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSU",
  direction="l",
  linebreak="al",
  unicodeslot=0x165B,
 },
 [0x165C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSO",
  direction="l",
  linebreak="al",
  unicodeslot=0x165C,
 },
 [0x165D]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSE",
  direction="l",
  linebreak="al",
  unicodeslot=0x165D,
 },
 [0x165E]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x165E,
 },
 [0x165F]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSI",
  direction="l",
  linebreak="al",
  unicodeslot=0x165F,
 },
 [0x1660]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1660,
 },
 [0x1661]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1661,
 },
 [0x1662]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1662,
 },
 [0x1663]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1663,
 },
 [0x1664]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1664,
 },
 [0x1665]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1665,
 },
 [0x1666]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1666,
 },
 [0x1667]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1667,
 },
 [0x1668]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1668,
 },
 [0x1669]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1669,
 },
 [0x166A]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x166A,
 },
 [0x166B]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSI",
  direction="l",
  linebreak="al",
  unicodeslot=0x166B,
 },
 [0x166C]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER TTSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x166C,
 },
 [0x166D]={
  category="po",
  description="CANADIAN SYLLABICS CHI SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x166D,
 },
 [0x166E]={
  category="po",
  description="CANADIAN SYLLABICS FULL STOP",
  direction="l",
  linebreak="al",
  unicodeslot=0x166E,
 },
 [0x166F]={
  category="lo",
  description="CANADIAN SYLLABICS QAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x166F,
 },
 [0x1670]={
  category="lo",
  description="CANADIAN SYLLABICS NGAI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1670,
 },
 [0x1671]={
  category="lo",
  description="CANADIAN SYLLABICS NNGI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1671,
 },
 [0x1672]={
  category="lo",
  description="CANADIAN SYLLABICS NNGII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1672,
 },
 [0x1673]={
  category="lo",
  description="CANADIAN SYLLABICS NNGO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1673,
 },
 [0x1674]={
  category="lo",
  description="CANADIAN SYLLABICS NNGOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1674,
 },
 [0x1675]={
  category="lo",
  description="CANADIAN SYLLABICS NNGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1675,
 },
 [0x1676]={
  category="lo",
  description="CANADIAN SYLLABICS NNGAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1676,
 },
 [0x1677]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1677,
 },
 [0x1678]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1678,
 },
 [0x1679]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x1679,
 },
 [0x167A]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x167A,
 },
 [0x167B]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x167B,
 },
 [0x167C]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x167C,
 },
 [0x167D]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE THWAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x167D,
 },
 [0x167E]={
  category="lo",
  description="CANADIAN SYLLABICS WOODS-CREE FINAL TH",
  direction="l",
  linebreak="al",
  unicodeslot=0x167E,
 },
 [0x167F]={
  category="lo",
  description="CANADIAN SYLLABICS BLACKFOOT W",
  direction="l",
  linebreak="al",
  unicodeslot=0x167F,
 },
 [0x1680]={
  category="zs",
  description="OGHAM SPACE MARK",
  direction="ws",
  linebreak="ba",
  unicodeslot=0x1680,
 },
 [0x1681]={
  category="lo",
  description="OGHAM LETTER BEITH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1681,
 },
 [0x1682]={
  category="lo",
  description="OGHAM LETTER LUIS",
  direction="l",
  linebreak="al",
  unicodeslot=0x1682,
 },
 [0x1683]={
  category="lo",
  description="OGHAM LETTER FEARN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1683,
 },
 [0x1684]={
  category="lo",
  description="OGHAM LETTER SAIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1684,
 },
 [0x1685]={
  category="lo",
  description="OGHAM LETTER NION",
  direction="l",
  linebreak="al",
  unicodeslot=0x1685,
 },
 [0x1686]={
  category="lo",
  description="OGHAM LETTER UATH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1686,
 },
 [0x1687]={
  category="lo",
  description="OGHAM LETTER DAIR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1687,
 },
 [0x1688]={
  category="lo",
  description="OGHAM LETTER TINNE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1688,
 },
 [0x1689]={
  category="lo",
  description="OGHAM LETTER COLL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1689,
 },
 [0x168A]={
  category="lo",
  description="OGHAM LETTER CEIRT",
  direction="l",
  linebreak="al",
  unicodeslot=0x168A,
 },
 [0x168B]={
  category="lo",
  description="OGHAM LETTER MUIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x168B,
 },
 [0x168C]={
  category="lo",
  description="OGHAM LETTER GORT",
  direction="l",
  linebreak="al",
  unicodeslot=0x168C,
 },
 [0x168D]={
  category="lo",
  description="OGHAM LETTER NGEADAL",
  direction="l",
  linebreak="al",
  unicodeslot=0x168D,
 },
 [0x168E]={
  category="lo",
  description="OGHAM LETTER STRAIF",
  direction="l",
  linebreak="al",
  unicodeslot=0x168E,
 },
 [0x168F]={
  category="lo",
  description="OGHAM LETTER RUIS",
  direction="l",
  linebreak="al",
  unicodeslot=0x168F,
 },
 [0x1690]={
  category="lo",
  description="OGHAM LETTER AILM",
  direction="l",
  linebreak="al",
  unicodeslot=0x1690,
 },
 [0x1691]={
  category="lo",
  description="OGHAM LETTER ONN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1691,
 },
 [0x1692]={
  category="lo",
  description="OGHAM LETTER UR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1692,
 },
 [0x1693]={
  category="lo",
  description="OGHAM LETTER EADHADH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1693,
 },
 [0x1694]={
  category="lo",
  description="OGHAM LETTER IODHADH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1694,
 },
 [0x1695]={
  category="lo",
  description="OGHAM LETTER EABHADH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1695,
 },
 [0x1696]={
  category="lo",
  description="OGHAM LETTER OR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1696,
 },
 [0x1697]={
  category="lo",
  description="OGHAM LETTER UILLEANN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1697,
 },
 [0x1698]={
  category="lo",
  description="OGHAM LETTER IFIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1698,
 },
 [0x1699]={
  category="lo",
  description="OGHAM LETTER EAMHANCHOLL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1699,
 },
 [0x169A]={
  category="lo",
  description="OGHAM LETTER PEITH",
  direction="l",
  linebreak="al",
  unicodeslot=0x169A,
 },
 [0x169B]={
  category="ps",
  description="OGHAM FEATHER MARK",
  direction="on",
  linebreak="op",
  mirror=0x169C,
  unicodeslot=0x169B,
 },
 [0x169C]={
  category="pe",
  description="OGHAM REVERSED FEATHER MARK",
  direction="on",
  linebreak="cl",
  mirror=0x169B,
  unicodeslot=0x169C,
 },
 [0x16A0]={
  category="lo",
  description="RUNIC LETTER FEHU FEOH FE F",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A0,
 },
 [0x16A1]={
  category="lo",
  description="RUNIC LETTER V",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A1,
 },
 [0x16A2]={
  category="lo",
  description="RUNIC LETTER URUZ UR U",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A2,
 },
 [0x16A3]={
  category="lo",
  description="RUNIC LETTER YR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A3,
 },
 [0x16A4]={
  category="lo",
  description="RUNIC LETTER Y",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A4,
 },
 [0x16A5]={
  category="lo",
  description="RUNIC LETTER W",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A5,
 },
 [0x16A6]={
  category="lo",
  description="RUNIC LETTER THURISAZ THURS THORN",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A6,
 },
 [0x16A7]={
  category="lo",
  description="RUNIC LETTER ETH",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A7,
 },
 [0x16A8]={
  category="lo",
  description="RUNIC LETTER ANSUZ A",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A8,
 },
 [0x16A9]={
  category="lo",
  description="RUNIC LETTER OS O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16A9,
 },
 [0x16AA]={
  category="lo",
  description="RUNIC LETTER AC A",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AA,
 },
 [0x16AB]={
  category="lo",
  description="RUNIC LETTER AESC",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AB,
 },
 [0x16AC]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-OSS O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AC,
 },
 [0x16AD]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-OSS O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AD,
 },
 [0x16AE]={
  category="lo",
  description="RUNIC LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AE,
 },
 [0x16AF]={
  category="lo",
  description="RUNIC LETTER OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x16AF,
 },
 [0x16B0]={
  category="lo",
  description="RUNIC LETTER ON",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B0,
 },
 [0x16B1]={
  category="lo",
  description="RUNIC LETTER RAIDO RAD REID R",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B1,
 },
 [0x16B2]={
  category="lo",
  description="RUNIC LETTER KAUNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B2,
 },
 [0x16B3]={
  category="lo",
  description="RUNIC LETTER CEN",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B3,
 },
 [0x16B4]={
  category="lo",
  description="RUNIC LETTER KAUN K",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B4,
 },
 [0x16B5]={
  category="lo",
  description="RUNIC LETTER G",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B5,
 },
 [0x16B6]={
  category="lo",
  description="RUNIC LETTER ENG",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B6,
 },
 [0x16B7]={
  category="lo",
  description="RUNIC LETTER GEBO GYFU G",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B7,
 },
 [0x16B8]={
  category="lo",
  description="RUNIC LETTER GAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B8,
 },
 [0x16B9]={
  category="lo",
  description="RUNIC LETTER WUNJO WYNN W",
  direction="l",
  linebreak="al",
  unicodeslot=0x16B9,
 },
 [0x16BA]={
  category="lo",
  description="RUNIC LETTER HAGLAZ H",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BA,
 },
 [0x16BB]={
  category="lo",
  description="RUNIC LETTER HAEGL H",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BB,
 },
 [0x16BC]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-HAGALL H",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BC,
 },
 [0x16BD]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-HAGALL H",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BD,
 },
 [0x16BE]={
  category="lo",
  description="RUNIC LETTER NAUDIZ NYD NAUD N",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BE,
 },
 [0x16BF]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-NAUD N",
  direction="l",
  linebreak="al",
  unicodeslot=0x16BF,
 },
 [0x16C0]={
  category="lo",
  description="RUNIC LETTER DOTTED-N",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C0,
 },
 [0x16C1]={
  category="lo",
  description="RUNIC LETTER ISAZ IS ISS I",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C1,
 },
 [0x16C2]={
  category="lo",
  description="RUNIC LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C2,
 },
 [0x16C3]={
  category="lo",
  description="RUNIC LETTER JERAN J",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C3,
 },
 [0x16C4]={
  category="lo",
  description="RUNIC LETTER GER",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C4,
 },
 [0x16C5]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-AR AE",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C5,
 },
 [0x16C6]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-AR A",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C6,
 },
 [0x16C7]={
  category="lo",
  description="RUNIC LETTER IWAZ EOH",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C7,
 },
 [0x16C8]={
  category="lo",
  description="RUNIC LETTER PERTHO PEORTH P",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C8,
 },
 [0x16C9]={
  category="lo",
  description="RUNIC LETTER ALGIZ EOLHX",
  direction="l",
  linebreak="al",
  unicodeslot=0x16C9,
 },
 [0x16CA]={
  category="lo",
  description="RUNIC LETTER SOWILO S",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CA,
 },
 [0x16CB]={
  category="lo",
  description="RUNIC LETTER SIGEL LONG-BRANCH-SOL S",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CB,
 },
 [0x16CC]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-SOL S",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CC,
 },
 [0x16CD]={
  category="lo",
  description="RUNIC LETTER C",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CD,
 },
 [0x16CE]={
  category="lo",
  description="RUNIC LETTER Z",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CE,
 },
 [0x16CF]={
  category="lo",
  description="RUNIC LETTER TIWAZ TIR TYR T",
  direction="l",
  linebreak="al",
  unicodeslot=0x16CF,
 },
 [0x16D0]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-TYR T",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D0,
 },
 [0x16D1]={
  category="lo",
  description="RUNIC LETTER D",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D1,
 },
 [0x16D2]={
  category="lo",
  description="RUNIC LETTER BERKANAN BEORC BJARKAN B",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D2,
 },
 [0x16D3]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-BJARKAN B",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D3,
 },
 [0x16D4]={
  category="lo",
  description="RUNIC LETTER DOTTED-P",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D4,
 },
 [0x16D5]={
  category="lo",
  description="RUNIC LETTER OPEN-P",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D5,
 },
 [0x16D6]={
  category="lo",
  description="RUNIC LETTER EHWAZ EH E",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D6,
 },
 [0x16D7]={
  category="lo",
  description="RUNIC LETTER MANNAZ MAN M",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D7,
 },
 [0x16D8]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-MADR M",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D8,
 },
 [0x16D9]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-MADR M",
  direction="l",
  linebreak="al",
  unicodeslot=0x16D9,
 },
 [0x16DA]={
  category="lo",
  description="RUNIC LETTER LAUKAZ LAGU LOGR L",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DA,
 },
 [0x16DB]={
  category="lo",
  description="RUNIC LETTER DOTTED-L",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DB,
 },
 [0x16DC]={
  category="lo",
  description="RUNIC LETTER INGWAZ",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DC,
 },
 [0x16DD]={
  category="lo",
  description="RUNIC LETTER ING",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DD,
 },
 [0x16DE]={
  category="lo",
  description="RUNIC LETTER DAGAZ DAEG D",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DE,
 },
 [0x16DF]={
  category="lo",
  description="RUNIC LETTER OTHALAN ETHEL O",
  direction="l",
  linebreak="al",
  unicodeslot=0x16DF,
 },
 [0x16E0]={
  category="lo",
  description="RUNIC LETTER EAR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E0,
 },
 [0x16E1]={
  category="lo",
  description="RUNIC LETTER IOR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E1,
 },
 [0x16E2]={
  category="lo",
  description="RUNIC LETTER CWEORTH",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E2,
 },
 [0x16E3]={
  category="lo",
  description="RUNIC LETTER CALC",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E3,
 },
 [0x16E4]={
  category="lo",
  description="RUNIC LETTER CEALC",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E4,
 },
 [0x16E5]={
  category="lo",
  description="RUNIC LETTER STAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E5,
 },
 [0x16E6]={
  category="lo",
  description="RUNIC LETTER LONG-BRANCH-YR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E6,
 },
 [0x16E7]={
  category="lo",
  description="RUNIC LETTER SHORT-TWIG-YR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E7,
 },
 [0x16E8]={
  category="lo",
  description="RUNIC LETTER ICELANDIC-YR",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E8,
 },
 [0x16E9]={
  category="lo",
  description="RUNIC LETTER Q",
  direction="l",
  linebreak="al",
  unicodeslot=0x16E9,
 },
 [0x16EA]={
  category="lo",
  description="RUNIC LETTER X",
  direction="l",
  linebreak="al",
  unicodeslot=0x16EA,
 },
 [0x16EB]={
  category="po",
  description="RUNIC SINGLE PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x16EB,
 },
 [0x16EC]={
  category="po",
  description="RUNIC MULTIPLE PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x16EC,
 },
 [0x16ED]={
  category="po",
  description="RUNIC CROSS PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x16ED,
 },
 [0x16EE]={
  category="nl",
  description="RUNIC ARLAUG SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x16EE,
 },
 [0x16EF]={
  category="nl",
  description="RUNIC TVIMADUR SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x16EF,
 },
 [0x16F0]={
  category="nl",
  description="RUNIC BELGTHOR SYMBOL",
  direction="l",
  linebreak="al",
  unicodeslot=0x16F0,
 },
 [0x1700]={
  category="lo",
  description="TAGALOG LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1700,
 },
 [0x1701]={
  category="lo",
  description="TAGALOG LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1701,
 },
 [0x1702]={
  category="lo",
  description="TAGALOG LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1702,
 },
 [0x1703]={
  category="lo",
  description="TAGALOG LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1703,
 },
 [0x1704]={
  category="lo",
  description="TAGALOG LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1704,
 },
 [0x1705]={
  category="lo",
  description="TAGALOG LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1705,
 },
 [0x1706]={
  category="lo",
  description="TAGALOG LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1706,
 },
 [0x1707]={
  category="lo",
  description="TAGALOG LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1707,
 },
 [0x1708]={
  category="lo",
  description="TAGALOG LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1708,
 },
 [0x1709]={
  category="lo",
  description="TAGALOG LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1709,
 },
 [0x170A]={
  category="lo",
  description="TAGALOG LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170A,
 },
 [0x170B]={
  category="lo",
  description="TAGALOG LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170B,
 },
 [0x170C]={
  category="lo",
  description="TAGALOG LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170C,
 },
 [0x170E]={
  category="lo",
  description="TAGALOG LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170E,
 },
 [0x170F]={
  category="lo",
  description="TAGALOG LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x170F,
 },
 [0x1710]={
  category="lo",
  description="TAGALOG LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1710,
 },
 [0x1711]={
  category="lo",
  description="TAGALOG LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1711,
 },
 [0x1712]={
  category="mn",
  description="TAGALOG VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1712,
 },
 [0x1713]={
  category="mn",
  description="TAGALOG VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1713,
 },
 [0x1714]={
  category="mn",
  description="TAGALOG SIGN VIRAMA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1714,
 },
 [0x1720]={
  category="lo",
  description="HANUNOO LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1720,
 },
 [0x1721]={
  category="lo",
  description="HANUNOO LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1721,
 },
 [0x1722]={
  category="lo",
  description="HANUNOO LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1722,
 },
 [0x1723]={
  category="lo",
  description="HANUNOO LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1723,
 },
 [0x1724]={
  category="lo",
  description="HANUNOO LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1724,
 },
 [0x1725]={
  category="lo",
  description="HANUNOO LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1725,
 },
 [0x1726]={
  category="lo",
  description="HANUNOO LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1726,
 },
 [0x1727]={
  category="lo",
  description="HANUNOO LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1727,
 },
 [0x1728]={
  category="lo",
  description="HANUNOO LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1728,
 },
 [0x1729]={
  category="lo",
  description="HANUNOO LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1729,
 },
 [0x172A]={
  category="lo",
  description="HANUNOO LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172A,
 },
 [0x172B]={
  category="lo",
  description="HANUNOO LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172B,
 },
 [0x172C]={
  category="lo",
  description="HANUNOO LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172C,
 },
 [0x172D]={
  category="lo",
  description="HANUNOO LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172D,
 },
 [0x172E]={
  category="lo",
  description="HANUNOO LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172E,
 },
 [0x172F]={
  category="lo",
  description="HANUNOO LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x172F,
 },
 [0x1730]={
  category="lo",
  description="HANUNOO LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1730,
 },
 [0x1731]={
  category="lo",
  description="HANUNOO LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1731,
 },
 [0x1732]={
  category="mn",
  description="HANUNOO VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1732,
 },
 [0x1733]={
  category="mn",
  description="HANUNOO VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1733,
 },
 [0x1734]={
  category="mn",
  description="HANUNOO SIGN PAMUDPOD",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1734,
 },
 [0x1735]={
  category="po",
  description="PHILIPPINE SINGLE PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1735,
 },
 [0x1736]={
  category="po",
  description="PHILIPPINE DOUBLE PUNCTUATION",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1736,
 },
 [0x1740]={
  category="lo",
  description="BUHID LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1740,
 },
 [0x1741]={
  category="lo",
  description="BUHID LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1741,
 },
 [0x1742]={
  category="lo",
  description="BUHID LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1742,
 },
 [0x1743]={
  category="lo",
  description="BUHID LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1743,
 },
 [0x1744]={
  category="lo",
  description="BUHID LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1744,
 },
 [0x1745]={
  category="lo",
  description="BUHID LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1745,
 },
 [0x1746]={
  category="lo",
  description="BUHID LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1746,
 },
 [0x1747]={
  category="lo",
  description="BUHID LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1747,
 },
 [0x1748]={
  category="lo",
  description="BUHID LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1748,
 },
 [0x1749]={
  category="lo",
  description="BUHID LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1749,
 },
 [0x174A]={
  category="lo",
  description="BUHID LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174A,
 },
 [0x174B]={
  category="lo",
  description="BUHID LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174B,
 },
 [0x174C]={
  category="lo",
  description="BUHID LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174C,
 },
 [0x174D]={
  category="lo",
  description="BUHID LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174D,
 },
 [0x174E]={
  category="lo",
  description="BUHID LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174E,
 },
 [0x174F]={
  category="lo",
  description="BUHID LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x174F,
 },
 [0x1750]={
  category="lo",
  description="BUHID LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1750,
 },
 [0x1751]={
  category="lo",
  description="BUHID LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1751,
 },
 [0x1752]={
  category="mn",
  description="BUHID VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1752,
 },
 [0x1753]={
  category="mn",
  description="BUHID VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1753,
 },
 [0x1760]={
  category="lo",
  description="TAGBANWA LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1760,
 },
 [0x1761]={
  category="lo",
  description="TAGBANWA LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1761,
 },
 [0x1762]={
  category="lo",
  description="TAGBANWA LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1762,
 },
 [0x1763]={
  category="lo",
  description="TAGBANWA LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1763,
 },
 [0x1764]={
  category="lo",
  description="TAGBANWA LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1764,
 },
 [0x1765]={
  category="lo",
  description="TAGBANWA LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1765,
 },
 [0x1766]={
  category="lo",
  description="TAGBANWA LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1766,
 },
 [0x1767]={
  category="lo",
  description="TAGBANWA LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1767,
 },
 [0x1768]={
  category="lo",
  description="TAGBANWA LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1768,
 },
 [0x1769]={
  category="lo",
  description="TAGBANWA LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1769,
 },
 [0x176A]={
  category="lo",
  description="TAGBANWA LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176A,
 },
 [0x176B]={
  category="lo",
  description="TAGBANWA LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176B,
 },
 [0x176C]={
  category="lo",
  description="TAGBANWA LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176C,
 },
 [0x176E]={
  category="lo",
  description="TAGBANWA LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176E,
 },
 [0x176F]={
  category="lo",
  description="TAGBANWA LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x176F,
 },
 [0x1770]={
  category="lo",
  description="TAGBANWA LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1770,
 },
 [0x1772]={
  category="mn",
  description="TAGBANWA VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1772,
 },
 [0x1773]={
  category="mn",
  description="TAGBANWA VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1773,
 },
 [0x1780]={
  category="lo",
  description="KHMER LETTER KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1780,
 },
 [0x1781]={
  category="lo",
  description="KHMER LETTER KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1781,
 },
 [0x1782]={
  category="lo",
  description="KHMER LETTER KO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1782,
 },
 [0x1783]={
  category="lo",
  description="KHMER LETTER KHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1783,
 },
 [0x1784]={
  category="lo",
  description="KHMER LETTER NGO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1784,
 },
 [0x1785]={
  category="lo",
  description="KHMER LETTER CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1785,
 },
 [0x1786]={
  category="lo",
  description="KHMER LETTER CHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1786,
 },
 [0x1787]={
  category="lo",
  description="KHMER LETTER CO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1787,
 },
 [0x1788]={
  category="lo",
  description="KHMER LETTER CHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1788,
 },
 [0x1789]={
  category="lo",
  description="KHMER LETTER NYO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1789,
 },
 [0x178A]={
  category="lo",
  description="KHMER LETTER DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178A,
 },
 [0x178B]={
  category="lo",
  description="KHMER LETTER TTHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178B,
 },
 [0x178C]={
  category="lo",
  description="KHMER LETTER DO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178C,
 },
 [0x178D]={
  category="lo",
  description="KHMER LETTER TTHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178D,
 },
 [0x178E]={
  category="lo",
  description="KHMER LETTER NNO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178E,
 },
 [0x178F]={
  category="lo",
  description="KHMER LETTER TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x178F,
 },
 [0x1790]={
  category="lo",
  description="KHMER LETTER THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1790,
 },
 [0x1791]={
  category="lo",
  description="KHMER LETTER TO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1791,
 },
 [0x1792]={
  category="lo",
  description="KHMER LETTER THO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1792,
 },
 [0x1793]={
  category="lo",
  description="KHMER LETTER NO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1793,
 },
 [0x1794]={
  category="lo",
  description="KHMER LETTER BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1794,
 },
 [0x1795]={
  category="lo",
  description="KHMER LETTER PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1795,
 },
 [0x1796]={
  category="lo",
  description="KHMER LETTER PO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1796,
 },
 [0x1797]={
  category="lo",
  description="KHMER LETTER PHO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1797,
 },
 [0x1798]={
  category="lo",
  description="KHMER LETTER MO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1798,
 },
 [0x1799]={
  category="lo",
  description="KHMER LETTER YO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1799,
 },
 [0x179A]={
  category="lo",
  description="KHMER LETTER RO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179A,
 },
 [0x179B]={
  category="lo",
  description="KHMER LETTER LO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179B,
 },
 [0x179C]={
  category="lo",
  description="KHMER LETTER VO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179C,
 },
 [0x179D]={
  category="lo",
  description="KHMER LETTER SHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179D,
 },
 [0x179E]={
  category="lo",
  description="KHMER LETTER SSO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179E,
 },
 [0x179F]={
  category="lo",
  description="KHMER LETTER SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x179F,
 },
 [0x17A0]={
  category="lo",
  description="KHMER LETTER HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A0,
 },
 [0x17A1]={
  category="lo",
  description="KHMER LETTER LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A1,
 },
 [0x17A2]={
  category="lo",
  description="KHMER LETTER QA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A2,
 },
 [0x17A3]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QAQ",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A3,
 },
 [0x17A4]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QAA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A4,
 },
 [0x17A5]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A5,
 },
 [0x17A6]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QII",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A6,
 },
 [0x17A7]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A7,
 },
 [0x17A8]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QUK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A8,
 },
 [0x17A9]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QUU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17A9,
 },
 [0x17AA]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QUUV",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AA,
 },
 [0x17AB]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL RY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AB,
 },
 [0x17AC]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL RYY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AC,
 },
 [0x17AD]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL LY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AD,
 },
 [0x17AE]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL LYY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AE,
 },
 [0x17AF]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17AF,
 },
 [0x17B0]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B0,
 },
 [0x17B1]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QOO TYPE ONE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B1,
 },
 [0x17B2]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QOO TYPE TWO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B2,
 },
 [0x17B3]={
  category="lo",
  description="KHMER INDEPENDENT VOWEL QAU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B3,
 },
 [0x17B4]={
  category="cf",
  description="KHMER VOWEL INHERENT AQ",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B4,
 },
 [0x17B5]={
  category="cf",
  description="KHMER VOWEL INHERENT AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B5,
 },
 [0x17B6]={
  category="mc",
  description="KHMER VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17B6,
 },
 [0x17B7]={
  category="mn",
  description="KHMER VOWEL SIGN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17B7,
 },
 [0x17B8]={
  category="mn",
  description="KHMER VOWEL SIGN II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17B8,
 },
 [0x17B9]={
  category="mn",
  description="KHMER VOWEL SIGN Y",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17B9,
 },
 [0x17BA]={
  category="mn",
  description="KHMER VOWEL SIGN YY",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17BA,
 },
 [0x17BB]={
  category="mn",
  description="KHMER VOWEL SIGN U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17BB,
 },
 [0x17BC]={
  category="mn",
  description="KHMER VOWEL SIGN UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17BC,
 },
 [0x17BD]={
  category="mn",
  description="KHMER VOWEL SIGN UA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17BD,
 },
 [0x17BE]={
  category="mc",
  description="KHMER VOWEL SIGN OE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17BE,
 },
 [0x17BF]={
  category="mc",
  description="KHMER VOWEL SIGN YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17BF,
 },
 [0x17C0]={
  category="mc",
  description="KHMER VOWEL SIGN IE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C0,
 },
 [0x17C1]={
  category="mc",
  description="KHMER VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C1,
 },
 [0x17C2]={
  category="mc",
  description="KHMER VOWEL SIGN AE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C2,
 },
 [0x17C3]={
  category="mc",
  description="KHMER VOWEL SIGN AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C3,
 },
 [0x17C4]={
  category="mc",
  description="KHMER VOWEL SIGN OO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C4,
 },
 [0x17C5]={
  category="mc",
  description="KHMER VOWEL SIGN AU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C5,
 },
 [0x17C6]={
  category="mn",
  description="KHMER SIGN NIKAHIT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17C6,
 },
 [0x17C7]={
  category="mc",
  description="KHMER SIGN REAHMUK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C7,
 },
 [0x17C8]={
  category="mc",
  description="KHMER SIGN YUUKALEAPINTU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17C8,
 },
 [0x17C9]={
  category="mn",
  description="KHMER SIGN MUUSIKATOAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17C9,
 },
 [0x17CA]={
  category="mn",
  description="KHMER SIGN TRIISAP",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CA,
 },
 [0x17CB]={
  category="mn",
  description="KHMER SIGN BANTOC",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CB,
 },
 [0x17CC]={
  category="mn",
  description="KHMER SIGN ROBAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CC,
 },
 [0x17CD]={
  category="mn",
  description="KHMER SIGN TOANDAKHIAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CD,
 },
 [0x17CE]={
  category="mn",
  description="KHMER SIGN KAKABAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CE,
 },
 [0x17CF]={
  category="mn",
  description="KHMER SIGN AHSDA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17CF,
 },
 [0x17D0]={
  category="mn",
  description="KHMER SIGN SAMYOK SANNYA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17D0,
 },
 [0x17D1]={
  category="mn",
  description="KHMER SIGN VIRIAM",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17D1,
 },
 [0x17D2]={
  category="mn",
  description="KHMER SIGN COENG",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17D2,
 },
 [0x17D3]={
  category="mn",
  description="KHMER SIGN BATHAMASAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17D3,
 },
 [0x17D4]={
  category="po",
  description="KHMER SIGN KHAN",
  direction="l",
  linebreak="ba",
  unicodeslot=0x17D4,
 },
 [0x17D5]={
  category="po",
  description="KHMER SIGN BARIYOOSAN",
  direction="l",
  linebreak="ba",
  unicodeslot=0x17D5,
 },
 [0x17D6]={
  category="po",
  description="KHMER SIGN CAMNUC PII KUUH",
  direction="l",
  linebreak="ns",
  unicodeslot=0x17D6,
 },
 [0x17D7]={
  category="lm",
  description="KHMER SIGN LEK TOO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17D7,
 },
 [0x17D8]={
  category="po",
  description="KHMER SIGN BEYYAL",
  direction="l",
  linebreak="ba",
  unicodeslot=0x17D8,
 },
 [0x17D9]={
  category="po",
  description="KHMER SIGN PHNAEK MUAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x17D9,
 },
 [0x17DA]={
  category="po",
  description="KHMER SIGN KOOMUUT",
  direction="l",
  linebreak="ba",
  unicodeslot=0x17DA,
 },
 [0x17DB]={
  category="sc",
  description="KHMER CURRENCY SYMBOL RIEL",
  direction="et",
  linebreak="pr",
  unicodeslot=0x17DB,
 },
 [0x17DC]={
  category="lo",
  description="KHMER SIGN AVAKRAHASANYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x17DC,
 },
 [0x17DD]={
  category="mn",
  description="KHMER SIGN ATTHACAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x17DD,
 },
 [0x17E0]={
  category="nd",
  description="KHMER DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E0,
 },
 [0x17E1]={
  category="nd",
  description="KHMER DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E1,
 },
 [0x17E2]={
  category="nd",
  description="KHMER DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E2,
 },
 [0x17E3]={
  category="nd",
  description="KHMER DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E3,
 },
 [0x17E4]={
  category="nd",
  description="KHMER DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E4,
 },
 [0x17E5]={
  category="nd",
  description="KHMER DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E5,
 },
 [0x17E6]={
  category="nd",
  description="KHMER DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E6,
 },
 [0x17E7]={
  category="nd",
  description="KHMER DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E7,
 },
 [0x17E8]={
  category="nd",
  description="KHMER DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E8,
 },
 [0x17E9]={
  category="nd",
  description="KHMER DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x17E9,
 },
 [0x17F0]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK SON",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F0,
 },
 [0x17F1]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK MUOY",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F1,
 },
 [0x17F2]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PII",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F2,
 },
 [0x17F3]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK BEI",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F3,
 },
 [0x17F4]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK BUON",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F4,
 },
 [0x17F5]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F5,
 },
 [0x17F6]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM-MUOY",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F6,
 },
 [0x17F7]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM-PII",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F7,
 },
 [0x17F8]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM-BEI",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F8,
 },
 [0x17F9]={
  category="no",
  description="KHMER SYMBOL LEK ATTAK PRAM-BUON",
  direction="on",
  linebreak="al",
  unicodeslot=0x17F9,
 },
 [0x1800]={
  category="po",
  description="MONGOLIAN BIRGA",
  direction="on",
  linebreak="al",
  unicodeslot=0x1800,
 },
 [0x1801]={
  category="po",
  description="MONGOLIAN ELLIPSIS",
  direction="on",
  linebreak="al",
  unicodeslot=0x1801,
 },
 [0x1802]={
  category="po",
  description="MONGOLIAN COMMA",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1802,
 },
 [0x1803]={
  category="po",
  description="MONGOLIAN FULL STOP",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1803,
 },
 [0x1804]={
  category="po",
  description="MONGOLIAN COLON",
  direction="on",
  linebreak="ba",
  unicodeslot=0x1804,
 },
 [0x1805]={
  category="po",
  description="MONGOLIAN FOUR DOTS",
  direction="on",
  linebreak="ba",
  unicodeslot=0x1805,
 },
 [0x1806]={
  category="pd",
  description="MONGOLIAN TODO SOFT HYPHEN",
  direction="on",
  linebreak="bb",
  unicodeslot=0x1806,
 },
 [0x1807]={
  category="po",
  description="MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER",
  direction="on",
  linebreak="al",
  unicodeslot=0x1807,
 },
 [0x1808]={
  category="po",
  description="MONGOLIAN MANCHU COMMA",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1808,
 },
 [0x1809]={
  category="po",
  description="MONGOLIAN MANCHU FULL STOP",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1809,
 },
 [0x180A]={
  category="po",
  description="MONGOLIAN NIRUGU",
  direction="on",
  linebreak="al",
  unicodeslot=0x180A,
 },
 [0x180B]={
  category="mn",
  description="MONGOLIAN FREE VARIATION SELECTOR ONE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x180B,
 },
 [0x180C]={
  category="mn",
  description="MONGOLIAN FREE VARIATION SELECTOR TWO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x180C,
 },
 [0x180D]={
  category="mn",
  description="MONGOLIAN FREE VARIATION SELECTOR THREE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x180D,
 },
 [0x180E]={
  category="zs",
  description="MONGOLIAN VOWEL SEPARATOR",
  direction="ws",
  linebreak="gl",
  unicodeslot=0x180E,
 },
 [0x1810]={
  category="nd",
  description="MONGOLIAN DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1810,
 },
 [0x1811]={
  category="nd",
  description="MONGOLIAN DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1811,
 },
 [0x1812]={
  category="nd",
  description="MONGOLIAN DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1812,
 },
 [0x1813]={
  category="nd",
  description="MONGOLIAN DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1813,
 },
 [0x1814]={
  category="nd",
  description="MONGOLIAN DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1814,
 },
 [0x1815]={
  category="nd",
  description="MONGOLIAN DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1815,
 },
 [0x1816]={
  category="nd",
  description="MONGOLIAN DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1816,
 },
 [0x1817]={
  category="nd",
  description="MONGOLIAN DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1817,
 },
 [0x1818]={
  category="nd",
  description="MONGOLIAN DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1818,
 },
 [0x1819]={
  category="nd",
  description="MONGOLIAN DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1819,
 },
 [0x1820]={
  category="lo",
  description="MONGOLIAN LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1820,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1821]={
  category="lo",
  description="MONGOLIAN LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1821,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1822]={
  category="lo",
  description="MONGOLIAN LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1822,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1823]={
  category="lo",
  description="MONGOLIAN LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1823,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1824]={
  category="lo",
  description="MONGOLIAN LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1824,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1825]={
  category="lo",
  description="MONGOLIAN LETTER OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1825,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1826]={
  category="lo",
  description="MONGOLIAN LETTER UE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1826,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1827]={
  category="lo",
  description="MONGOLIAN LETTER EE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1827,
 },
 [0x1828]={
  category="lo",
  description="MONGOLIAN LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1828,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="separate form",
  },
 },
 [0x1829]={
  category="lo",
  description="MONGOLIAN LETTER ANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1829,
 },
 [0x182A]={
  category="lo",
  description="MONGOLIAN LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182A,
  variants={
   [0x180B]="alternative form",
  },
 },
 [0x182B]={
  category="lo",
  description="MONGOLIAN LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182B,
 },
 [0x182C]={
  category="lo",
  description="MONGOLIAN LETTER QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182C,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="fourth form",
  },
 },
 [0x182D]={
  category="lo",
  description="MONGOLIAN LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182D,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="feminine form",
  },
 },
 [0x182E]={
  category="lo",
  description="MONGOLIAN LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182E,
 },
 [0x182F]={
  category="lo",
  description="MONGOLIAN LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x182F,
 },
 [0x1830]={
  category="lo",
  description="MONGOLIAN LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1830,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1831]={
  category="lo",
  description="MONGOLIAN LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1831,
 },
 [0x1832]={
  category="lo",
  description="MONGOLIAN LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1832,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1833]={
  category="lo",
  description="MONGOLIAN LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1833,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1834]={
  category="lo",
  description="MONGOLIAN LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1834,
 },
 [0x1835]={
  category="lo",
  description="MONGOLIAN LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1835,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1836]={
  category="lo",
  description="MONGOLIAN LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1836,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1837]={
  category="lo",
  description="MONGOLIAN LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1837,
 },
 [0x1838]={
  category="lo",
  description="MONGOLIAN LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1838,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1839]={
  category="lo",
  description="MONGOLIAN LETTER FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1839,
 },
 [0x183A]={
  category="lo",
  description="MONGOLIAN LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183A,
 },
 [0x183B]={
  category="lo",
  description="MONGOLIAN LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183B,
 },
 [0x183C]={
  category="lo",
  description="MONGOLIAN LETTER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183C,
 },
 [0x183D]={
  category="lo",
  description="MONGOLIAN LETTER ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183D,
 },
 [0x183E]={
  category="lo",
  description="MONGOLIAN LETTER HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183E,
 },
 [0x183F]={
  category="lo",
  description="MONGOLIAN LETTER ZRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x183F,
 },
 [0x1840]={
  category="lo",
  description="MONGOLIAN LETTER LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1840,
 },
 [0x1841]={
  category="lo",
  description="MONGOLIAN LETTER ZHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1841,
 },
 [0x1842]={
  category="lo",
  description="MONGOLIAN LETTER CHI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1842,
 },
 [0x1843]={
  category="lm",
  description="MONGOLIAN LETTER TODO LONG VOWEL SIGN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1843,
 },
 [0x1844]={
  category="lo",
  description="MONGOLIAN LETTER TODO E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1844,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1845]={
  category="lo",
  description="MONGOLIAN LETTER TODO I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1845,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1846]={
  category="lo",
  description="MONGOLIAN LETTER TODO O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1846,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1847]={
  category="lo",
  description="MONGOLIAN LETTER TODO U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1847,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1848]={
  category="lo",
  description="MONGOLIAN LETTER TODO OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1848,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1849]={
  category="lo",
  description="MONGOLIAN LETTER TODO UE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1849,
  variants={
   [0x180B]="second form",
  },
 },
 [0x184A]={
  category="lo",
  description="MONGOLIAN LETTER TODO ANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x184A,
 },
 [0x184B]={
  category="lo",
  description="MONGOLIAN LETTER TODO BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184B,
 },
 [0x184C]={
  category="lo",
  description="MONGOLIAN LETTER TODO PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184C,
 },
 [0x184D]={
  category="lo",
  description="MONGOLIAN LETTER TODO QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184D,
  variants={
   [0x180B]="feminine form",
  },
 },
 [0x184E]={
  category="lo",
  description="MONGOLIAN LETTER TODO GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184E,
  variants={
   [0x180B]="second form",
  },
 },
 [0x184F]={
  category="lo",
  description="MONGOLIAN LETTER TODO MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x184F,
 },
 [0x1850]={
  category="lo",
  description="MONGOLIAN LETTER TODO TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1850,
 },
 [0x1851]={
  category="lo",
  description="MONGOLIAN LETTER TODO DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1851,
 },
 [0x1852]={
  category="lo",
  description="MONGOLIAN LETTER TODO CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1852,
 },
 [0x1853]={
  category="lo",
  description="MONGOLIAN LETTER TODO JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1853,
 },
 [0x1854]={
  category="lo",
  description="MONGOLIAN LETTER TODO TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1854,
 },
 [0x1855]={
  category="lo",
  description="MONGOLIAN LETTER TODO YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1855,
 },
 [0x1856]={
  category="lo",
  description="MONGOLIAN LETTER TODO WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1856,
 },
 [0x1857]={
  category="lo",
  description="MONGOLIAN LETTER TODO KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1857,
 },
 [0x1858]={
  category="lo",
  description="MONGOLIAN LETTER TODO GAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1858,
 },
 [0x1859]={
  category="lo",
  description="MONGOLIAN LETTER TODO HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1859,
 },
 [0x185A]={
  category="lo",
  description="MONGOLIAN LETTER TODO JIA",
  direction="l",
  linebreak="al",
  unicodeslot=0x185A,
 },
 [0x185B]={
  category="lo",
  description="MONGOLIAN LETTER TODO NIA",
  direction="l",
  linebreak="al",
  unicodeslot=0x185B,
 },
 [0x185C]={
  category="lo",
  description="MONGOLIAN LETTER TODO DZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x185C,
 },
 [0x185D]={
  category="lo",
  description="MONGOLIAN LETTER SIBE E",
  direction="l",
  linebreak="al",
  unicodeslot=0x185D,
  variants={
   [0x180B]="second form",
  },
 },
 [0x185E]={
  category="lo",
  description="MONGOLIAN LETTER SIBE I",
  direction="l",
  linebreak="al",
  unicodeslot=0x185E,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x185F]={
  category="lo",
  description="MONGOLIAN LETTER SIBE IY",
  direction="l",
  linebreak="al",
  unicodeslot=0x185F,
 },
 [0x1860]={
  category="lo",
  description="MONGOLIAN LETTER SIBE UE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1860,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1861]={
  category="lo",
  description="MONGOLIAN LETTER SIBE U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1861,
 },
 [0x1862]={
  category="lo",
  description="MONGOLIAN LETTER SIBE ANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1862,
 },
 [0x1863]={
  category="lo",
  description="MONGOLIAN LETTER SIBE KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1863,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1864]={
  category="lo",
  description="MONGOLIAN LETTER SIBE GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1864,
 },
 [0x1865]={
  category="lo",
  description="MONGOLIAN LETTER SIBE HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1865,
 },
 [0x1866]={
  category="lo",
  description="MONGOLIAN LETTER SIBE PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1866,
 },
 [0x1867]={
  category="lo",
  description="MONGOLIAN LETTER SIBE SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1867,
 },
 [0x1868]={
  category="lo",
  description="MONGOLIAN LETTER SIBE TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1868,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
  },
 },
 [0x1869]={
  category="lo",
  description="MONGOLIAN LETTER SIBE DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1869,
  variants={
   [0x180B]="second form",
  },
 },
 [0x186A]={
  category="lo",
  description="MONGOLIAN LETTER SIBE JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186A,
 },
 [0x186B]={
  category="lo",
  description="MONGOLIAN LETTER SIBE FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186B,
 },
 [0x186C]={
  category="lo",
  description="MONGOLIAN LETTER SIBE GAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186C,
 },
 [0x186D]={
  category="lo",
  description="MONGOLIAN LETTER SIBE HAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186D,
 },
 [0x186E]={
  category="lo",
  description="MONGOLIAN LETTER SIBE TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186E,
 },
 [0x186F]={
  category="lo",
  description="MONGOLIAN LETTER SIBE ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x186F,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1870]={
  category="lo",
  description="MONGOLIAN LETTER SIBE RAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1870,
 },
 [0x1871]={
  category="lo",
  description="MONGOLIAN LETTER SIBE CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1871,
 },
 [0x1872]={
  category="lo",
  description="MONGOLIAN LETTER SIBE ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1872,
 },
 [0x1873]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1873,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="fourth form",
  },
 },
 [0x1874]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1874,
  variants={
   [0x180B]="second form",
   [0x180C]="feminine first medial form",
   [0x180D]="feminine second medial form",
  },
 },
 [0x1875]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1875,
 },
 [0x1876]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1876,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1877]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1877,
 },
 [0x1880]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI ANUSVARA ONE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1880,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1881]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI VISARGA ONE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1881,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1882]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI DAMARU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1882,
 },
 [0x1883]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI UBADAMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1883,
 },
 [0x1884]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI INVERTED UBADAMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1884,
 },
 [0x1885]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI BALUDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1885,
 },
 [0x1886]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI THREE BALUDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1886,
 },
 [0x1887]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1887,
  variants={
   [0x180B]="second form",
   [0x180C]="third form",
   [0x180D]="fourth form",
  },
 },
 [0x1888]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1888,
  variants={
   [0x180B]="second form",
  },
 },
 [0x1889]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1889,
 },
 [0x188A]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188A,
  variants={
   [0x180B]="second form",
  },
 },
 [0x188B]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188B,
 },
 [0x188C]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188C,
 },
 [0x188D]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188D,
 },
 [0x188E]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188E,
 },
 [0x188F]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI NNA",
  direction="l",
  linebreak="al",
  unicodeslot=0x188F,
 },
 [0x1890]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1890,
 },
 [0x1891]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1891,
 },
 [0x1892]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1892,
 },
 [0x1893]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1893,
 },
 [0x1894]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1894,
 },
 [0x1895]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1895,
 },
 [0x1896]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1896,
 },
 [0x1897]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI AH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1897,
 },
 [0x1898]={
  category="lo",
  description="MONGOLIAN LETTER TODO ALI GALI TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1898,
 },
 [0x1899]={
  category="lo",
  description="MONGOLIAN LETTER TODO ALI GALI ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1899,
 },
 [0x189A]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189A,
 },
 [0x189B]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189B,
 },
 [0x189C]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189C,
 },
 [0x189D]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189D,
 },
 [0x189E]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189E,
 },
 [0x189F]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI DDHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x189F,
 },
 [0x18A0]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A0,
 },
 [0x18A1]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A1,
 },
 [0x18A2]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A2,
 },
 [0x18A3]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI CYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A3,
 },
 [0x18A4]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI ZHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A4,
 },
 [0x18A5]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A5,
 },
 [0x18A6]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI HALF U",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A6,
 },
 [0x18A7]={
  category="lo",
  description="MONGOLIAN LETTER ALI GALI HALF YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A7,
 },
 [0x18A8]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18A8,
 },
 [0x18A9]={
  category="mn",
  description="MONGOLIAN LETTER ALI GALI DAGALGA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x18A9,
 },
 [0x18AA]={
  category="lo",
  description="MONGOLIAN LETTER MANCHU ALI GALI LHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18AA,
 },
 [0x18B0]={
  category="lo",
  description="CANADIAN SYLLABICS OY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B0,
 },
 [0x18B1]={
  category="lo",
  description="CANADIAN SYLLABICS AY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B1,
 },
 [0x18B2]={
  category="lo",
  description="CANADIAN SYLLABICS AAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B2,
 },
 [0x18B3]={
  category="lo",
  description="CANADIAN SYLLABICS WAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B3,
 },
 [0x18B4]={
  category="lo",
  description="CANADIAN SYLLABICS POY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B4,
 },
 [0x18B5]={
  category="lo",
  description="CANADIAN SYLLABICS PAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B5,
 },
 [0x18B6]={
  category="lo",
  description="CANADIAN SYLLABICS PWOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B6,
 },
 [0x18B7]={
  category="lo",
  description="CANADIAN SYLLABICS TAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B7,
 },
 [0x18B8]={
  category="lo",
  description="CANADIAN SYLLABICS KAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B8,
 },
 [0x18B9]={
  category="lo",
  description="CANADIAN SYLLABICS KWAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18B9,
 },
 [0x18BA]={
  category="lo",
  description="CANADIAN SYLLABICS MAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BA,
 },
 [0x18BB]={
  category="lo",
  description="CANADIAN SYLLABICS NOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BB,
 },
 [0x18BC]={
  category="lo",
  description="CANADIAN SYLLABICS NAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BC,
 },
 [0x18BD]={
  category="lo",
  description="CANADIAN SYLLABICS LAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BD,
 },
 [0x18BE]={
  category="lo",
  description="CANADIAN SYLLABICS SOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BE,
 },
 [0x18BF]={
  category="lo",
  description="CANADIAN SYLLABICS SAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18BF,
 },
 [0x18C0]={
  category="lo",
  description="CANADIAN SYLLABICS SHOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C0,
 },
 [0x18C1]={
  category="lo",
  description="CANADIAN SYLLABICS SHAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C1,
 },
 [0x18C2]={
  category="lo",
  description="CANADIAN SYLLABICS SHWOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C2,
 },
 [0x18C3]={
  category="lo",
  description="CANADIAN SYLLABICS YOY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C3,
 },
 [0x18C4]={
  category="lo",
  description="CANADIAN SYLLABICS YAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C4,
 },
 [0x18C5]={
  category="lo",
  description="CANADIAN SYLLABICS RAY",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C5,
 },
 [0x18C6]={
  category="lo",
  description="CANADIAN SYLLABICS NWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C6,
 },
 [0x18C7]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY NWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C7,
 },
 [0x18C8]={
  category="lo",
  description="CANADIAN SYLLABICS NWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C8,
 },
 [0x18C9]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY NWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x18C9,
 },
 [0x18CA]={
  category="lo",
  description="CANADIAN SYLLABICS NWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CA,
 },
 [0x18CB]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY NWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CB,
 },
 [0x18CC]={
  category="lo",
  description="CANADIAN SYLLABICS NWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CC,
 },
 [0x18CD]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY NWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CD,
 },
 [0x18CE]={
  category="lo",
  description="CANADIAN SYLLABICS RWEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CE,
 },
 [0x18CF]={
  category="lo",
  description="CANADIAN SYLLABICS RWI",
  direction="l",
  linebreak="al",
  unicodeslot=0x18CF,
 },
 [0x18D0]={
  category="lo",
  description="CANADIAN SYLLABICS RWII",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D0,
 },
 [0x18D1]={
  category="lo",
  description="CANADIAN SYLLABICS RWO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D1,
 },
 [0x18D2]={
  category="lo",
  description="CANADIAN SYLLABICS RWOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D2,
 },
 [0x18D3]={
  category="lo",
  description="CANADIAN SYLLABICS RWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D3,
 },
 [0x18D4]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY P",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D4,
 },
 [0x18D5]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY T",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D5,
 },
 [0x18D6]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY K",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D6,
 },
 [0x18D7]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY C",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D7,
 },
 [0x18D8]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY M",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D8,
 },
 [0x18D9]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY N",
  direction="l",
  linebreak="al",
  unicodeslot=0x18D9,
 },
 [0x18DA]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY S",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DA,
 },
 [0x18DB]={
  category="lo",
  description="CANADIAN SYLLABICS OJIBWAY SH",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DB,
 },
 [0x18DC]={
  category="lo",
  description="CANADIAN SYLLABICS EASTERN W",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DC,
 },
 [0x18DD]={
  category="lo",
  description="CANADIAN SYLLABICS WESTERN W",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DD,
 },
 [0x18DE]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL SMALL RING",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DE,
 },
 [0x18DF]={
  category="lo",
  description="CANADIAN SYLLABICS FINAL RAISED DOT",
  direction="l",
  linebreak="al",
  unicodeslot=0x18DF,
 },
 [0x18E0]={
  category="lo",
  description="CANADIAN SYLLABICS R-CREE RWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E0,
 },
 [0x18E1]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E1,
 },
 [0x18E2]={
  category="lo",
  description="CANADIAN SYLLABICS WEST-CREE LAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E2,
 },
 [0x18E3]={
  category="lo",
  description="CANADIAN SYLLABICS THWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E3,
 },
 [0x18E4]={
  category="lo",
  description="CANADIAN SYLLABICS THWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E4,
 },
 [0x18E5]={
  category="lo",
  description="CANADIAN SYLLABICS TTHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E5,
 },
 [0x18E6]={
  category="lo",
  description="CANADIAN SYLLABICS TTHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E6,
 },
 [0x18E7]={
  category="lo",
  description="CANADIAN SYLLABICS TTHAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E7,
 },
 [0x18E8]={
  category="lo",
  description="CANADIAN SYLLABICS TLHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E8,
 },
 [0x18E9]={
  category="lo",
  description="CANADIAN SYLLABICS TLHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18E9,
 },
 [0x18EA]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHWE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EA,
 },
 [0x18EB]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI SHOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EB,
 },
 [0x18EC]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI HOO",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EC,
 },
 [0x18ED]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GWU",
  direction="l",
  linebreak="al",
  unicodeslot=0x18ED,
 },
 [0x18EE]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DENE GEE",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EE,
 },
 [0x18EF]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18EF,
 },
 [0x18F0]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER GWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F0,
 },
 [0x18F1]={
  category="lo",
  description="CANADIAN SYLLABICS SAYISI JUU",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F1,
 },
 [0x18F2]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER JWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F2,
 },
 [0x18F3]={
  category="lo",
  description="CANADIAN SYLLABICS BEAVER DENE L",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F3,
 },
 [0x18F4]={
  category="lo",
  description="CANADIAN SYLLABICS BEAVER DENE R",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F4,
 },
 [0x18F5]={
  category="lo",
  description="CANADIAN SYLLABICS CARRIER DENTAL S",
  direction="l",
  linebreak="al",
  unicodeslot=0x18F5,
 },
 [0x1900]={
  category="lo",
  description="LIMBU VOWEL-CARRIER LETTER",
  direction="l",
  linebreak="al",
  unicodeslot=0x1900,
 },
 [0x1901]={
  category="lo",
  description="LIMBU LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1901,
 },
 [0x1902]={
  category="lo",
  description="LIMBU LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1902,
 },
 [0x1903]={
  category="lo",
  description="LIMBU LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1903,
 },
 [0x1904]={
  category="lo",
  description="LIMBU LETTER GHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1904,
 },
 [0x1905]={
  category="lo",
  description="LIMBU LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1905,
 },
 [0x1906]={
  category="lo",
  description="LIMBU LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1906,
 },
 [0x1907]={
  category="lo",
  description="LIMBU LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1907,
 },
 [0x1908]={
  category="lo",
  description="LIMBU LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1908,
 },
 [0x1909]={
  category="lo",
  description="LIMBU LETTER JHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1909,
 },
 [0x190A]={
  category="lo",
  description="LIMBU LETTER YAN",
  direction="l",
  linebreak="al",
  unicodeslot=0x190A,
 },
 [0x190B]={
  category="lo",
  description="LIMBU LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190B,
 },
 [0x190C]={
  category="lo",
  description="LIMBU LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190C,
 },
 [0x190D]={
  category="lo",
  description="LIMBU LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190D,
 },
 [0x190E]={
  category="lo",
  description="LIMBU LETTER DHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190E,
 },
 [0x190F]={
  category="lo",
  description="LIMBU LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x190F,
 },
 [0x1910]={
  category="lo",
  description="LIMBU LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1910,
 },
 [0x1911]={
  category="lo",
  description="LIMBU LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1911,
 },
 [0x1912]={
  category="lo",
  description="LIMBU LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1912,
 },
 [0x1913]={
  category="lo",
  description="LIMBU LETTER BHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1913,
 },
 [0x1914]={
  category="lo",
  description="LIMBU LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1914,
 },
 [0x1915]={
  category="lo",
  description="LIMBU LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1915,
 },
 [0x1916]={
  category="lo",
  description="LIMBU LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1916,
 },
 [0x1917]={
  category="lo",
  description="LIMBU LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1917,
 },
 [0x1918]={
  category="lo",
  description="LIMBU LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1918,
 },
 [0x1919]={
  category="lo",
  description="LIMBU LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1919,
 },
 [0x191A]={
  category="lo",
  description="LIMBU LETTER SSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x191A,
 },
 [0x191B]={
  category="lo",
  description="LIMBU LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x191B,
 },
 [0x191C]={
  category="lo",
  description="LIMBU LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x191C,
 },
 [0x1920]={
  category="mn",
  description="LIMBU VOWEL SIGN A",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1920,
 },
 [0x1921]={
  category="mn",
  description="LIMBU VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1921,
 },
 [0x1922]={
  category="mn",
  description="LIMBU VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1922,
 },
 [0x1923]={
  category="mc",
  description="LIMBU VOWEL SIGN EE",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1923,
 },
 [0x1924]={
  category="mc",
  description="LIMBU VOWEL SIGN AI",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1924,
 },
 [0x1925]={
  category="mc",
  description="LIMBU VOWEL SIGN OO",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1925,
 },
 [0x1926]={
  category="mc",
  description="LIMBU VOWEL SIGN AU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1926,
 },
 [0x1927]={
  category="mn",
  description="LIMBU VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1927,
 },
 [0x1928]={
  category="mn",
  description="LIMBU VOWEL SIGN O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1928,
 },
 [0x1929]={
  category="mc",
  description="LIMBU SUBJOINED LETTER YA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1929,
 },
 [0x192A]={
  category="mc",
  description="LIMBU SUBJOINED LETTER RA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x192A,
 },
 [0x192B]={
  category="mc",
  description="LIMBU SUBJOINED LETTER WA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x192B,
 },
 [0x1930]={
  category="mc",
  description="LIMBU SMALL LETTER KA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1930,
 },
 [0x1931]={
  category="mc",
  description="LIMBU SMALL LETTER NGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1931,
 },
 [0x1932]={
  category="mn",
  description="LIMBU SMALL LETTER ANUSVARA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1932,
 },
 [0x1933]={
  category="mc",
  description="LIMBU SMALL LETTER TA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1933,
 },
 [0x1934]={
  category="mc",
  description="LIMBU SMALL LETTER NA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1934,
 },
 [0x1935]={
  category="mc",
  description="LIMBU SMALL LETTER PA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1935,
 },
 [0x1936]={
  category="mc",
  description="LIMBU SMALL LETTER MA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1936,
 },
 [0x1937]={
  category="mc",
  description="LIMBU SMALL LETTER RA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1937,
 },
 [0x1938]={
  category="mc",
  description="LIMBU SMALL LETTER LA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1938,
 },
 [0x1939]={
  category="mn",
  description="LIMBU SIGN MUKPHRENG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1939,
 },
 [0x193A]={
  category="mn",
  description="LIMBU SIGN KEMPHRENG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x193A,
 },
 [0x193B]={
  category="mn",
  description="LIMBU SIGN SA-I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x193B,
 },
 [0x1940]={
  category="so",
  description="LIMBU SIGN LOO",
  direction="on",
  linebreak="al",
  unicodeslot=0x1940,
 },
 [0x1944]={
  category="po",
  description="LIMBU EXCLAMATION MARK",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1944,
 },
 [0x1945]={
  category="po",
  description="LIMBU QUESTION MARK",
  direction="on",
  linebreak="ex",
  unicodeslot=0x1945,
 },
 [0x1946]={
  category="nd",
  description="LIMBU DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1946,
 },
 [0x1947]={
  category="nd",
  description="LIMBU DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1947,
 },
 [0x1948]={
  category="nd",
  description="LIMBU DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1948,
 },
 [0x1949]={
  category="nd",
  description="LIMBU DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1949,
 },
 [0x194A]={
  category="nd",
  description="LIMBU DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194A,
 },
 [0x194B]={
  category="nd",
  description="LIMBU DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194B,
 },
 [0x194C]={
  category="nd",
  description="LIMBU DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194C,
 },
 [0x194D]={
  category="nd",
  description="LIMBU DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194D,
 },
 [0x194E]={
  category="nd",
  description="LIMBU DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194E,
 },
 [0x194F]={
  category="nd",
  description="LIMBU DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x194F,
 },
 [0x1950]={
  category="lo",
  description="TAI LE LETTER KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1950,
 },
 [0x1951]={
  category="lo",
  description="TAI LE LETTER XA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1951,
 },
 [0x1952]={
  category="lo",
  description="TAI LE LETTER NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1952,
 },
 [0x1953]={
  category="lo",
  description="TAI LE LETTER TSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1953,
 },
 [0x1954]={
  category="lo",
  description="TAI LE LETTER SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1954,
 },
 [0x1955]={
  category="lo",
  description="TAI LE LETTER YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1955,
 },
 [0x1956]={
  category="lo",
  description="TAI LE LETTER TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1956,
 },
 [0x1957]={
  category="lo",
  description="TAI LE LETTER THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1957,
 },
 [0x1958]={
  category="lo",
  description="TAI LE LETTER LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1958,
 },
 [0x1959]={
  category="lo",
  description="TAI LE LETTER PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1959,
 },
 [0x195A]={
  category="lo",
  description="TAI LE LETTER PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195A,
 },
 [0x195B]={
  category="lo",
  description="TAI LE LETTER MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195B,
 },
 [0x195C]={
  category="lo",
  description="TAI LE LETTER FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195C,
 },
 [0x195D]={
  category="lo",
  description="TAI LE LETTER VA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195D,
 },
 [0x195E]={
  category="lo",
  description="TAI LE LETTER HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195E,
 },
 [0x195F]={
  category="lo",
  description="TAI LE LETTER QA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x195F,
 },
 [0x1960]={
  category="lo",
  description="TAI LE LETTER KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1960,
 },
 [0x1961]={
  category="lo",
  description="TAI LE LETTER TSHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1961,
 },
 [0x1962]={
  category="lo",
  description="TAI LE LETTER NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1962,
 },
 [0x1963]={
  category="lo",
  description="TAI LE LETTER A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1963,
 },
 [0x1964]={
  category="lo",
  description="TAI LE LETTER I",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1964,
 },
 [0x1965]={
  category="lo",
  description="TAI LE LETTER EE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1965,
 },
 [0x1966]={
  category="lo",
  description="TAI LE LETTER EH",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1966,
 },
 [0x1967]={
  category="lo",
  description="TAI LE LETTER U",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1967,
 },
 [0x1968]={
  category="lo",
  description="TAI LE LETTER OO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1968,
 },
 [0x1969]={
  category="lo",
  description="TAI LE LETTER O",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1969,
 },
 [0x196A]={
  category="lo",
  description="TAI LE LETTER UE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x196A,
 },
 [0x196B]={
  category="lo",
  description="TAI LE LETTER E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x196B,
 },
 [0x196C]={
  category="lo",
  description="TAI LE LETTER AUE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x196C,
 },
 [0x196D]={
  category="lo",
  description="TAI LE LETTER AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x196D,
 },
 [0x1970]={
  category="lo",
  description="TAI LE LETTER TONE-0x0002",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1970,
 },
 [0x1971]={
  category="lo",
  description="TAI LE LETTER TONE-0x0003",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1971,
 },
 [0x1972]={
  category="lo",
  description="TAI LE LETTER TONE-0x0004",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1972,
 },
 [0x1973]={
  category="lo",
  description="TAI LE LETTER TONE-0x0005",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1973,
 },
 [0x1974]={
  category="lo",
  description="TAI LE LETTER TONE-0x0006",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1974,
 },
 [0x1980]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH QA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1980,
 },
 [0x1981]={
  category="lo",
  description="NEW TAI LUE LETTER LOW QA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1981,
 },
 [0x1982]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1982,
 },
 [0x1983]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH XA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1983,
 },
 [0x1984]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1984,
 },
 [0x1985]={
  category="lo",
  description="NEW TAI LUE LETTER LOW KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1985,
 },
 [0x1986]={
  category="lo",
  description="NEW TAI LUE LETTER LOW XA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1986,
 },
 [0x1987]={
  category="lo",
  description="NEW TAI LUE LETTER LOW NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1987,
 },
 [0x1988]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH TSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1988,
 },
 [0x1989]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1989,
 },
 [0x198A]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198A,
 },
 [0x198B]={
  category="lo",
  description="NEW TAI LUE LETTER LOW TSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198B,
 },
 [0x198C]={
  category="lo",
  description="NEW TAI LUE LETTER LOW SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198C,
 },
 [0x198D]={
  category="lo",
  description="NEW TAI LUE LETTER LOW YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198D,
 },
 [0x198E]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198E,
 },
 [0x198F]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x198F,
 },
 [0x1990]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1990,
 },
 [0x1991]={
  category="lo",
  description="NEW TAI LUE LETTER LOW TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1991,
 },
 [0x1992]={
  category="lo",
  description="NEW TAI LUE LETTER LOW THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1992,
 },
 [0x1993]={
  category="lo",
  description="NEW TAI LUE LETTER LOW NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1993,
 },
 [0x1994]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1994,
 },
 [0x1995]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1995,
 },
 [0x1996]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1996,
 },
 [0x1997]={
  category="lo",
  description="NEW TAI LUE LETTER LOW PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1997,
 },
 [0x1998]={
  category="lo",
  description="NEW TAI LUE LETTER LOW PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1998,
 },
 [0x1999]={
  category="lo",
  description="NEW TAI LUE LETTER LOW MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1999,
 },
 [0x199A]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199A,
 },
 [0x199B]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH VA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199B,
 },
 [0x199C]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199C,
 },
 [0x199D]={
  category="lo",
  description="NEW TAI LUE LETTER LOW FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199D,
 },
 [0x199E]={
  category="lo",
  description="NEW TAI LUE LETTER LOW VA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199E,
 },
 [0x199F]={
  category="lo",
  description="NEW TAI LUE LETTER LOW LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x199F,
 },
 [0x19A0]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A0,
 },
 [0x19A1]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A1,
 },
 [0x19A2]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A2,
 },
 [0x19A3]={
  category="lo",
  description="NEW TAI LUE LETTER LOW HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A3,
 },
 [0x19A4]={
  category="lo",
  description="NEW TAI LUE LETTER LOW DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A4,
 },
 [0x19A5]={
  category="lo",
  description="NEW TAI LUE LETTER LOW BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A5,
 },
 [0x19A6]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH KVA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A6,
 },
 [0x19A7]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH XVA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A7,
 },
 [0x19A8]={
  category="lo",
  description="NEW TAI LUE LETTER LOW KVA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A8,
 },
 [0x19A9]={
  category="lo",
  description="NEW TAI LUE LETTER LOW XVA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19A9,
 },
 [0x19AA]={
  category="lo",
  description="NEW TAI LUE LETTER HIGH SUA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19AA,
 },
 [0x19AB]={
  category="lo",
  description="NEW TAI LUE LETTER LOW SUA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19AB,
 },
 [0x19B0]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN VOWEL SHORTENER",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B0,
 },
 [0x19B1]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B1,
 },
 [0x19B2]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN II",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B2,
 },
 [0x19B3]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN U",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B3,
 },
 [0x19B4]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN UU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B4,
 },
 [0x19B5]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B5,
 },
 [0x19B6]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN AE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B6,
 },
 [0x19B7]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN O",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B7,
 },
 [0x19B8]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN OA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B8,
 },
 [0x19B9]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN UE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19B9,
 },
 [0x19BA]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN AY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BA,
 },
 [0x19BB]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN AAY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BB,
 },
 [0x19BC]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN UY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BC,
 },
 [0x19BD]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN OY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BD,
 },
 [0x19BE]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN OAY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BE,
 },
 [0x19BF]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN UEY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19BF,
 },
 [0x19C0]={
  category="mc",
  description="NEW TAI LUE VOWEL SIGN IY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C0,
 },
 [0x19C1]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL V",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C1,
 },
 [0x19C2]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL NG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C2,
 },
 [0x19C3]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL N",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C3,
 },
 [0x19C4]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL M",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C4,
 },
 [0x19C5]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL K",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C5,
 },
 [0x19C6]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL D",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C6,
 },
 [0x19C7]={
  category="lo",
  description="NEW TAI LUE LETTER FINAL B",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C7,
 },
 [0x19C8]={
  category="mc",
  description="NEW TAI LUE TONE MARK-0x0001",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C8,
 },
 [0x19C9]={
  category="mc",
  description="NEW TAI LUE TONE MARK-0x0002",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19C9,
 },
 [0x19D0]={
  category="nd",
  description="NEW TAI LUE DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D0,
 },
 [0x19D1]={
  category="nd",
  description="NEW TAI LUE DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D1,
 },
 [0x19D2]={
  category="nd",
  description="NEW TAI LUE DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D2,
 },
 [0x19D3]={
  category="nd",
  description="NEW TAI LUE DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D3,
 },
 [0x19D4]={
  category="nd",
  description="NEW TAI LUE DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D4,
 },
 [0x19D5]={
  category="nd",
  description="NEW TAI LUE DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D5,
 },
 [0x19D6]={
  category="nd",
  description="NEW TAI LUE DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D6,
 },
 [0x19D7]={
  category="nd",
  description="NEW TAI LUE DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D7,
 },
 [0x19D8]={
  category="nd",
  description="NEW TAI LUE DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D8,
 },
 [0x19D9]={
  category="nd",
  description="NEW TAI LUE DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x19D9,
 },
 [0x19DA]={
  category="no",
  description="NEW TAI LUE THAM DIGIT ONE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x19DA,
 },
 [0x19DE]={
  category="po",
  description="NEW TAI LUE SIGN LAE",
  direction="on",
  linebreak="sa",
  unicodeslot=0x19DE,
 },
 [0x19DF]={
  category="po",
  description="NEW TAI LUE SIGN LAEV",
  direction="on",
  linebreak="sa",
  unicodeslot=0x19DF,
 },
 [0x19E0]={
  category="so",
  description="KHMER SYMBOL PATHAMASAT",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E0,
 },
 [0x19E1]={
  category="so",
  description="KHMER SYMBOL MUOY KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E1,
 },
 [0x19E2]={
  category="so",
  description="KHMER SYMBOL PII KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E2,
 },
 [0x19E3]={
  category="so",
  description="KHMER SYMBOL BEI KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E3,
 },
 [0x19E4]={
  category="so",
  description="KHMER SYMBOL BUON KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E4,
 },
 [0x19E5]={
  category="so",
  description="KHMER SYMBOL PRAM KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E5,
 },
 [0x19E6]={
  category="so",
  description="KHMER SYMBOL PRAM-MUOY KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E6,
 },
 [0x19E7]={
  category="so",
  description="KHMER SYMBOL PRAM-PII KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E7,
 },
 [0x19E8]={
  category="so",
  description="KHMER SYMBOL PRAM-BEI KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E8,
 },
 [0x19E9]={
  category="so",
  description="KHMER SYMBOL PRAM-BUON KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19E9,
 },
 [0x19EA]={
  category="so",
  description="KHMER SYMBOL DAP KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EA,
 },
 [0x19EB]={
  category="so",
  description="KHMER SYMBOL DAP-MUOY KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EB,
 },
 [0x19EC]={
  category="so",
  description="KHMER SYMBOL DAP-PII KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EC,
 },
 [0x19ED]={
  category="so",
  description="KHMER SYMBOL DAP-BEI KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19ED,
 },
 [0x19EE]={
  category="so",
  description="KHMER SYMBOL DAP-BUON KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EE,
 },
 [0x19EF]={
  category="so",
  description="KHMER SYMBOL DAP-PRAM KOET",
  direction="on",
  linebreak="al",
  unicodeslot=0x19EF,
 },
 [0x19F0]={
  category="so",
  description="KHMER SYMBOL TUTEYASAT",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F0,
 },
 [0x19F1]={
  category="so",
  description="KHMER SYMBOL MUOY ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F1,
 },
 [0x19F2]={
  category="so",
  description="KHMER SYMBOL PII ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F2,
 },
 [0x19F3]={
  category="so",
  description="KHMER SYMBOL BEI ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F3,
 },
 [0x19F4]={
  category="so",
  description="KHMER SYMBOL BUON ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F4,
 },
 [0x19F5]={
  category="so",
  description="KHMER SYMBOL PRAM ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F5,
 },
 [0x19F6]={
  category="so",
  description="KHMER SYMBOL PRAM-MUOY ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F6,
 },
 [0x19F7]={
  category="so",
  description="KHMER SYMBOL PRAM-PII ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F7,
 },
 [0x19F8]={
  category="so",
  description="KHMER SYMBOL PRAM-BEI ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F8,
 },
 [0x19F9]={
  category="so",
  description="KHMER SYMBOL PRAM-BUON ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19F9,
 },
 [0x19FA]={
  category="so",
  description="KHMER SYMBOL DAP ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FA,
 },
 [0x19FB]={
  category="so",
  description="KHMER SYMBOL DAP-MUOY ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FB,
 },
 [0x19FC]={
  category="so",
  description="KHMER SYMBOL DAP-PII ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FC,
 },
 [0x19FD]={
  category="so",
  description="KHMER SYMBOL DAP-BEI ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FD,
 },
 [0x19FE]={
  category="so",
  description="KHMER SYMBOL DAP-BUON ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FE,
 },
 [0x19FF]={
  category="so",
  description="KHMER SYMBOL DAP-PRAM ROC",
  direction="on",
  linebreak="al",
  unicodeslot=0x19FF,
 },
 [0x1A00]={
  category="lo",
  description="BUGINESE LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A00,
 },
 [0x1A01]={
  category="lo",
  description="BUGINESE LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A01,
 },
 [0x1A02]={
  category="lo",
  description="BUGINESE LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A02,
 },
 [0x1A03]={
  category="lo",
  description="BUGINESE LETTER NGKA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A03,
 },
 [0x1A04]={
  category="lo",
  description="BUGINESE LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A04,
 },
 [0x1A05]={
  category="lo",
  description="BUGINESE LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A05,
 },
 [0x1A06]={
  category="lo",
  description="BUGINESE LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A06,
 },
 [0x1A07]={
  category="lo",
  description="BUGINESE LETTER MPA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A07,
 },
 [0x1A08]={
  category="lo",
  description="BUGINESE LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A08,
 },
 [0x1A09]={
  category="lo",
  description="BUGINESE LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A09,
 },
 [0x1A0A]={
  category="lo",
  description="BUGINESE LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0A,
 },
 [0x1A0B]={
  category="lo",
  description="BUGINESE LETTER NRA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0B,
 },
 [0x1A0C]={
  category="lo",
  description="BUGINESE LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0C,
 },
 [0x1A0D]={
  category="lo",
  description="BUGINESE LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0D,
 },
 [0x1A0E]={
  category="lo",
  description="BUGINESE LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0E,
 },
 [0x1A0F]={
  category="lo",
  description="BUGINESE LETTER NYCA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A0F,
 },
 [0x1A10]={
  category="lo",
  description="BUGINESE LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A10,
 },
 [0x1A11]={
  category="lo",
  description="BUGINESE LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A11,
 },
 [0x1A12]={
  category="lo",
  description="BUGINESE LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A12,
 },
 [0x1A13]={
  category="lo",
  description="BUGINESE LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A13,
 },
 [0x1A14]={
  category="lo",
  description="BUGINESE LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A14,
 },
 [0x1A15]={
  category="lo",
  description="BUGINESE LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A15,
 },
 [0x1A16]={
  category="lo",
  description="BUGINESE LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A16,
 },
 [0x1A17]={
  category="mn",
  description="BUGINESE VOWEL SIGN I",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1A17,
 },
 [0x1A18]={
  category="mn",
  description="BUGINESE VOWEL SIGN U",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1A18,
 },
 [0x1A19]={
  category="mc",
  description="BUGINESE VOWEL SIGN E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1A19,
 },
 [0x1A1A]={
  category="mc",
  description="BUGINESE VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1A1A,
 },
 [0x1A1B]={
  category="mc",
  description="BUGINESE VOWEL SIGN AE",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1A1B,
 },
 [0x1A1E]={
  category="po",
  description="BUGINESE PALLAWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A1E,
 },
 [0x1A1F]={
  category="po",
  description="BUGINESE END OF SECTION",
  direction="l",
  linebreak="al",
  unicodeslot=0x1A1F,
 },
 [0x1A20]={
  category="lo",
  description="TAI THAM LETTER HIGH KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A20,
 },
 [0x1A21]={
  category="lo",
  description="TAI THAM LETTER HIGH KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A21,
 },
 [0x1A22]={
  category="lo",
  description="TAI THAM LETTER HIGH KXA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A22,
 },
 [0x1A23]={
  category="lo",
  description="TAI THAM LETTER LOW KA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A23,
 },
 [0x1A24]={
  category="lo",
  description="TAI THAM LETTER LOW KXA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A24,
 },
 [0x1A25]={
  category="lo",
  description="TAI THAM LETTER LOW KHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A25,
 },
 [0x1A26]={
  category="lo",
  description="TAI THAM LETTER NGA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A26,
 },
 [0x1A27]={
  category="lo",
  description="TAI THAM LETTER HIGH CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A27,
 },
 [0x1A28]={
  category="lo",
  description="TAI THAM LETTER HIGH CHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A28,
 },
 [0x1A29]={
  category="lo",
  description="TAI THAM LETTER LOW CA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A29,
 },
 [0x1A2A]={
  category="lo",
  description="TAI THAM LETTER LOW SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2A,
 },
 [0x1A2B]={
  category="lo",
  description="TAI THAM LETTER LOW CHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2B,
 },
 [0x1A2C]={
  category="lo",
  description="TAI THAM LETTER NYA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2C,
 },
 [0x1A2D]={
  category="lo",
  description="TAI THAM LETTER RATA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2D,
 },
 [0x1A2E]={
  category="lo",
  description="TAI THAM LETTER HIGH RATHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2E,
 },
 [0x1A2F]={
  category="lo",
  description="TAI THAM LETTER DA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A2F,
 },
 [0x1A30]={
  category="lo",
  description="TAI THAM LETTER LOW RATHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A30,
 },
 [0x1A31]={
  category="lo",
  description="TAI THAM LETTER RANA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A31,
 },
 [0x1A32]={
  category="lo",
  description="TAI THAM LETTER HIGH TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A32,
 },
 [0x1A33]={
  category="lo",
  description="TAI THAM LETTER HIGH THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A33,
 },
 [0x1A34]={
  category="lo",
  description="TAI THAM LETTER LOW TA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A34,
 },
 [0x1A35]={
  category="lo",
  description="TAI THAM LETTER LOW THA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A35,
 },
 [0x1A36]={
  category="lo",
  description="TAI THAM LETTER NA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A36,
 },
 [0x1A37]={
  category="lo",
  description="TAI THAM LETTER BA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A37,
 },
 [0x1A38]={
  category="lo",
  description="TAI THAM LETTER HIGH PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A38,
 },
 [0x1A39]={
  category="lo",
  description="TAI THAM LETTER HIGH PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A39,
 },
 [0x1A3A]={
  category="lo",
  description="TAI THAM LETTER HIGH FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3A,
 },
 [0x1A3B]={
  category="lo",
  description="TAI THAM LETTER LOW PA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3B,
 },
 [0x1A3C]={
  category="lo",
  description="TAI THAM LETTER LOW FA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3C,
 },
 [0x1A3D]={
  category="lo",
  description="TAI THAM LETTER LOW PHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3D,
 },
 [0x1A3E]={
  category="lo",
  description="TAI THAM LETTER MA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3E,
 },
 [0x1A3F]={
  category="lo",
  description="TAI THAM LETTER LOW YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A3F,
 },
 [0x1A40]={
  category="lo",
  description="TAI THAM LETTER HIGH YA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A40,
 },
 [0x1A41]={
  category="lo",
  description="TAI THAM LETTER RA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A41,
 },
 [0x1A42]={
  category="lo",
  description="TAI THAM LETTER RUE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A42,
 },
 [0x1A43]={
  category="lo",
  description="TAI THAM LETTER LA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A43,
 },
 [0x1A44]={
  category="lo",
  description="TAI THAM LETTER LUE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A44,
 },
 [0x1A45]={
  category="lo",
  description="TAI THAM LETTER WA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A45,
 },
 [0x1A46]={
  category="lo",
  description="TAI THAM LETTER HIGH SHA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A46,
 },
 [0x1A47]={
  category="lo",
  description="TAI THAM LETTER HIGH SSA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A47,
 },
 [0x1A48]={
  category="lo",
  description="TAI THAM LETTER HIGH SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A48,
 },
 [0x1A49]={
  category="lo",
  description="TAI THAM LETTER HIGH HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A49,
 },
 [0x1A4A]={
  category="lo",
  description="TAI THAM LETTER LLA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4A,
 },
 [0x1A4B]={
  category="lo",
  description="TAI THAM LETTER A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4B,
 },
 [0x1A4C]={
  category="lo",
  description="TAI THAM LETTER LOW HA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4C,
 },
 [0x1A4D]={
  category="lo",
  description="TAI THAM LETTER I",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4D,
 },
 [0x1A4E]={
  category="lo",
  description="TAI THAM LETTER II",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4E,
 },
 [0x1A4F]={
  category="lo",
  description="TAI THAM LETTER U",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A4F,
 },
 [0x1A50]={
  category="lo",
  description="TAI THAM LETTER UU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A50,
 },
 [0x1A51]={
  category="lo",
  description="TAI THAM LETTER EE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A51,
 },
 [0x1A52]={
  category="lo",
  description="TAI THAM LETTER OO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A52,
 },
 [0x1A53]={
  category="lo",
  description="TAI THAM LETTER LAE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A53,
 },
 [0x1A54]={
  category="lo",
  description="TAI THAM LETTER GREAT SA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A54,
 },
 [0x1A55]={
  category="mc",
  description="TAI THAM CONSONANT SIGN MEDIAL RA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A55,
 },
 [0x1A56]={
  category="mn",
  description="TAI THAM CONSONANT SIGN MEDIAL LA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A56,
 },
 [0x1A57]={
  category="mc",
  description="TAI THAM CONSONANT SIGN LA TANG LAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A57,
 },
 [0x1A58]={
  category="mn",
  description="TAI THAM SIGN MAI KANG LAI",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A58,
 },
 [0x1A59]={
  category="mn",
  description="TAI THAM CONSONANT SIGN FINAL NGA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A59,
 },
 [0x1A5A]={
  category="mn",
  description="TAI THAM CONSONANT SIGN LOW PA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5A,
 },
 [0x1A5B]={
  category="mn",
  description="TAI THAM CONSONANT SIGN HIGH RATHA OR LOW PA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5B,
 },
 [0x1A5C]={
  category="mn",
  description="TAI THAM CONSONANT SIGN MA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5C,
 },
 [0x1A5D]={
  category="mn",
  description="TAI THAM CONSONANT SIGN BA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5D,
 },
 [0x1A5E]={
  category="mn",
  description="TAI THAM CONSONANT SIGN SA",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A5E,
 },
 [0x1A60]={
  category="mn",
  description="TAI THAM SIGN SAKOT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A60,
 },
 [0x1A61]={
  category="mc",
  description="TAI THAM VOWEL SIGN A",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A61,
 },
 [0x1A62]={
  category="mn",
  description="TAI THAM VOWEL SIGN MAI SAT",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A62,
 },
 [0x1A63]={
  category="mc",
  description="TAI THAM VOWEL SIGN AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A63,
 },
 [0x1A64]={
  category="mc",
  description="TAI THAM VOWEL SIGN TALL AA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A64,
 },
 [0x1A65]={
  category="mn",
  description="TAI THAM VOWEL SIGN I",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A65,
 },
 [0x1A66]={
  category="mn",
  description="TAI THAM VOWEL SIGN II",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A66,
 },
 [0x1A67]={
  category="mn",
  description="TAI THAM VOWEL SIGN UE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A67,
 },
 [0x1A68]={
  category="mn",
  description="TAI THAM VOWEL SIGN UUE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A68,
 },
 [0x1A69]={
  category="mn",
  description="TAI THAM VOWEL SIGN U",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A69,
 },
 [0x1A6A]={
  category="mn",
  description="TAI THAM VOWEL SIGN UU",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A6A,
 },
 [0x1A6B]={
  category="mn",
  description="TAI THAM VOWEL SIGN O",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A6B,
 },
 [0x1A6C]={
  category="mn",
  description="TAI THAM VOWEL SIGN OA BELOW",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A6C,
 },
 [0x1A6D]={
  category="mc",
  description="TAI THAM VOWEL SIGN OY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A6D,
 },
 [0x1A6E]={
  category="mc",
  description="TAI THAM VOWEL SIGN E",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A6E,
 },
 [0x1A6F]={
  category="mc",
  description="TAI THAM VOWEL SIGN AE",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A6F,
 },
 [0x1A70]={
  category="mc",
  description="TAI THAM VOWEL SIGN OO",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A70,
 },
 [0x1A71]={
  category="mc",
  description="TAI THAM VOWEL SIGN AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A71,
 },
 [0x1A72]={
  category="mc",
  description="TAI THAM VOWEL SIGN THAM AI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1A72,
 },
 [0x1A73]={
  category="mn",
  description="TAI THAM VOWEL SIGN OA ABOVE",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A73,
 },
 [0x1A74]={
  category="mn",
  description="TAI THAM SIGN MAI KANG",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A74,
 },
 [0x1A75]={
  category="mn",
  description="TAI THAM SIGN TONE-1",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A75,
 },
 [0x1A76]={
  category="mn",
  description="TAI THAM SIGN TONE-2",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A76,
 },
 [0x1A77]={
  category="mn",
  description="TAI THAM SIGN KHUEN TONE-3",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A77,
 },
 [0x1A78]={
  category="mn",
  description="TAI THAM SIGN KHUEN TONE-4",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A78,
 },
 [0x1A79]={
  category="mn",
  description="TAI THAM SIGN KHUEN TONE-5",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A79,
 },
 [0x1A7A]={
  category="mn",
  description="TAI THAM SIGN RA HAAM",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A7A,
 },
 [0x1A7B]={
  category="mn",
  description="TAI THAM SIGN MAI SAM",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A7B,
 },
 [0x1A7C]={
  category="mn",
  description="TAI THAM SIGN KHUEN-LUE KARAN",
  direction="nsm",
  linebreak="sa",
  unicodeslot=0x1A7C,
 },
 [0x1A7F]={
  category="mn",
  description="TAI THAM COMBINING CRYPTOGRAMMIC DOT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1A7F,
 },
 [0x1A80]={
  category="nd",
  description="TAI THAM HORA DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A80,
 },
 [0x1A81]={
  category="nd",
  description="TAI THAM HORA DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A81,
 },
 [0x1A82]={
  category="nd",
  description="TAI THAM HORA DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A82,
 },
 [0x1A83]={
  category="nd",
  description="TAI THAM HORA DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A83,
 },
 [0x1A84]={
  category="nd",
  description="TAI THAM HORA DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A84,
 },
 [0x1A85]={
  category="nd",
  description="TAI THAM HORA DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A85,
 },
 [0x1A86]={
  category="nd",
  description="TAI THAM HORA DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A86,
 },
 [0x1A87]={
  category="nd",
  description="TAI THAM HORA DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A87,
 },
 [0x1A88]={
  category="nd",
  description="TAI THAM HORA DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A88,
 },
 [0x1A89]={
  category="nd",
  description="TAI THAM HORA DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A89,
 },
 [0x1A90]={
  category="nd",
  description="TAI THAM THAM DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A90,
 },
 [0x1A91]={
  category="nd",
  description="TAI THAM THAM DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A91,
 },
 [0x1A92]={
  category="nd",
  description="TAI THAM THAM DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A92,
 },
 [0x1A93]={
  category="nd",
  description="TAI THAM THAM DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A93,
 },
 [0x1A94]={
  category="nd",
  description="TAI THAM THAM DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A94,
 },
 [0x1A95]={
  category="nd",
  description="TAI THAM THAM DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A95,
 },
 [0x1A96]={
  category="nd",
  description="TAI THAM THAM DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A96,
 },
 [0x1A97]={
  category="nd",
  description="TAI THAM THAM DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A97,
 },
 [0x1A98]={
  category="nd",
  description="TAI THAM THAM DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A98,
 },
 [0x1A99]={
  category="nd",
  description="TAI THAM THAM DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1A99,
 },
 [0x1AA0]={
  category="po",
  description="TAI THAM SIGN WIANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA0,
 },
 [0x1AA1]={
  category="po",
  description="TAI THAM SIGN WIANGWAAK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA1,
 },
 [0x1AA2]={
  category="po",
  description="TAI THAM SIGN SAWAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA2,
 },
 [0x1AA3]={
  category="po",
  description="TAI THAM SIGN KEOW",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA3,
 },
 [0x1AA4]={
  category="po",
  description="TAI THAM SIGN HOY",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA4,
 },
 [0x1AA5]={
  category="po",
  description="TAI THAM SIGN DOKMAI",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA5,
 },
 [0x1AA6]={
  category="po",
  description="TAI THAM SIGN REVERSED ROTATED RANA",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA6,
 },
 [0x1AA7]={
  category="lm",
  description="TAI THAM SIGN MAI YAMOK",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA7,
 },
 [0x1AA8]={
  category="po",
  description="TAI THAM SIGN KAAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA8,
 },
 [0x1AA9]={
  category="po",
  description="TAI THAM SIGN KAANKUU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AA9,
 },
 [0x1AAA]={
  category="po",
  description="TAI THAM SIGN SATKAAN",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AAA,
 },
 [0x1AAB]={
  category="po",
  description="TAI THAM SIGN SATKAANKUU",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AAB,
 },
 [0x1AAC]={
  category="po",
  description="TAI THAM SIGN HANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AAC,
 },
 [0x1AAD]={
  category="po",
  description="TAI THAM SIGN CAANG",
  direction="l",
  linebreak="sa",
  unicodeslot=0x1AAD,
 },
 [0x1B00]={
  category="mn",
  description="BALINESE SIGN ULU RICEM",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B00,
 },
 [0x1B01]={
  category="mn",
  description="BALINESE SIGN ULU CANDRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B01,
 },
 [0x1B02]={
  category="mn",
  description="BALINESE SIGN CECEK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B02,
 },
 [0x1B03]={
  category="mn",
  description="BALINESE SIGN SURANG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B03,
 },
 [0x1B04]={
  category="mc",
  description="BALINESE SIGN BISAH",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B04,
 },
 [0x1B05]={
  category="lo",
  description="BALINESE LETTER AKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B05,
 },
 [0x1B06]={
  category="lo",
  description="BALINESE LETTER AKARA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B05, 0x1B35 },
  unicodeslot=0x1B06,
 },
 [0x1B07]={
  category="lo",
  description="BALINESE LETTER IKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B07,
 },
 [0x1B08]={
  category="lo",
  description="BALINESE LETTER IKARA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B07, 0x1B35 },
  unicodeslot=0x1B08,
 },
 [0x1B09]={
  category="lo",
  description="BALINESE LETTER UKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B09,
 },
 [0x1B0A]={
  category="lo",
  description="BALINESE LETTER UKARA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B09, 0x1B35 },
  unicodeslot=0x1B0A,
 },
 [0x1B0B]={
  category="lo",
  description="BALINESE LETTER RA REPA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B0B,
 },
 [0x1B0C]={
  category="lo",
  description="BALINESE LETTER RA REPA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B0B, 0x1B35 },
  unicodeslot=0x1B0C,
 },
 [0x1B0D]={
  category="lo",
  description="BALINESE LETTER LA LENGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B0D,
 },
 [0x1B0E]={
  category="lo",
  description="BALINESE LETTER LA LENGA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B0D, 0x1B35 },
  unicodeslot=0x1B0E,
 },
 [0x1B0F]={
  category="lo",
  description="BALINESE LETTER EKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B0F,
 },
 [0x1B10]={
  category="lo",
  description="BALINESE LETTER AIKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B10,
 },
 [0x1B11]={
  category="lo",
  description="BALINESE LETTER OKARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B11,
 },
 [0x1B12]={
  category="lo",
  description="BALINESE LETTER OKARA TEDUNG",
  direction="l",
  linebreak="al",
  specials={ "char", 0x1B11, 0x1B35 },
  unicodeslot=0x1B12,
 },
 [0x1B13]={
  category="lo",
  description="BALINESE LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B13,
 },
 [0x1B14]={
  category="lo",
  description="BALINESE LETTER KA MAHAPRANA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B14,
 },
 [0x1B15]={
  category="lo",
  description="BALINESE LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B15,
 },
 [0x1B16]={
  category="lo",
  description="BALINESE LETTER GA GORA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B16,
 },
 [0x1B17]={
  category="lo",
  description="BALINESE LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B17,
 },
 [0x1B18]={
  category="lo",
  description="BALINESE LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B18,
 },
 [0x1B19]={
  category="lo",
  description="BALINESE LETTER CA LACA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B19,
 },
 [0x1B1A]={
  category="lo",
  description="BALINESE LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1A,
 },
 [0x1B1B]={
  category="lo",
  description="BALINESE LETTER JA JERA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1B,
 },
 [0x1B1C]={
  category="lo",
  description="BALINESE LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1C,
 },
 [0x1B1D]={
  category="lo",
  description="BALINESE LETTER TA LATIK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1D,
 },
 [0x1B1E]={
  category="lo",
  description="BALINESE LETTER TA MURDA MAHAPRANA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1E,
 },
 [0x1B1F]={
  category="lo",
  description="BALINESE LETTER DA MURDA ALPAPRANA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B1F,
 },
 [0x1B20]={
  category="lo",
  description="BALINESE LETTER DA MURDA MAHAPRANA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B20,
 },
 [0x1B21]={
  category="lo",
  description="BALINESE LETTER NA RAMBAT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B21,
 },
 [0x1B22]={
  category="lo",
  description="BALINESE LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B22,
 },
 [0x1B23]={
  category="lo",
  description="BALINESE LETTER TA TAWA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B23,
 },
 [0x1B24]={
  category="lo",
  description="BALINESE LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B24,
 },
 [0x1B25]={
  category="lo",
  description="BALINESE LETTER DA MADU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B25,
 },
 [0x1B26]={
  category="lo",
  description="BALINESE LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B26,
 },
 [0x1B27]={
  category="lo",
  description="BALINESE LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B27,
 },
 [0x1B28]={
  category="lo",
  description="BALINESE LETTER PA KAPAL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B28,
 },
 [0x1B29]={
  category="lo",
  description="BALINESE LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B29,
 },
 [0x1B2A]={
  category="lo",
  description="BALINESE LETTER BA KEMBANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2A,
 },
 [0x1B2B]={
  category="lo",
  description="BALINESE LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2B,
 },
 [0x1B2C]={
  category="lo",
  description="BALINESE LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2C,
 },
 [0x1B2D]={
  category="lo",
  description="BALINESE LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2D,
 },
 [0x1B2E]={
  category="lo",
  description="BALINESE LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2E,
 },
 [0x1B2F]={
  category="lo",
  description="BALINESE LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B2F,
 },
 [0x1B30]={
  category="lo",
  description="BALINESE LETTER SA SAGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B30,
 },
 [0x1B31]={
  category="lo",
  description="BALINESE LETTER SA SAPA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B31,
 },
 [0x1B32]={
  category="lo",
  description="BALINESE LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B32,
 },
 [0x1B33]={
  category="lo",
  description="BALINESE LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B33,
 },
 [0x1B34]={
  category="mn",
  description="BALINESE SIGN REREKAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B34,
 },
 [0x1B35]={
  category="mc",
  description="BALINESE VOWEL SIGN TEDUNG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B35,
 },
 [0x1B36]={
  category="mn",
  description="BALINESE VOWEL SIGN ULU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B36,
 },
 [0x1B37]={
  category="mn",
  description="BALINESE VOWEL SIGN ULU SARI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B37,
 },
 [0x1B38]={
  category="mn",
  description="BALINESE VOWEL SIGN SUKU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B38,
 },
 [0x1B39]={
  category="mn",
  description="BALINESE VOWEL SIGN SUKU ILUT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B39,
 },
 [0x1B3A]={
  category="mn",
  description="BALINESE VOWEL SIGN RA REPA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B3A,
 },
 [0x1B3B]={
  category="mc",
  description="BALINESE VOWEL SIGN RA REPA TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B3A, 0x1B35 },
  unicodeslot=0x1B3B,
 },
 [0x1B3C]={
  category="mn",
  description="BALINESE VOWEL SIGN LA LENGA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B3C,
 },
 [0x1B3D]={
  category="mc",
  description="BALINESE VOWEL SIGN LA LENGA TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B3C, 0x1B35 },
  unicodeslot=0x1B3D,
 },
 [0x1B3E]={
  category="mc",
  description="BALINESE VOWEL SIGN TALING",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B3E,
 },
 [0x1B3F]={
  category="mc",
  description="BALINESE VOWEL SIGN TALING REPA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B3F,
 },
 [0x1B40]={
  category="mc",
  description="BALINESE VOWEL SIGN TALING TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B3E, 0x1B35 },
  unicodeslot=0x1B40,
 },
 [0x1B41]={
  category="mc",
  description="BALINESE VOWEL SIGN TALING REPA TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B3F, 0x1B35 },
  unicodeslot=0x1B41,
 },
 [0x1B42]={
  category="mn",
  description="BALINESE VOWEL SIGN PEPET",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B42,
 },
 [0x1B43]={
  category="mc",
  description="BALINESE VOWEL SIGN PEPET TEDUNG",
  direction="l",
  linebreak="cm",
  specials={ "char", 0x1B42, 0x1B35 },
  unicodeslot=0x1B43,
 },
 [0x1B44]={
  category="mc",
  description="BALINESE ADEG ADEG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B44,
 },
 [0x1B45]={
  category="lo",
  description="BALINESE LETTER KAF SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B45,
 },
 [0x1B46]={
  category="lo",
  description="BALINESE LETTER KHOT SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B46,
 },
 [0x1B47]={
  category="lo",
  description="BALINESE LETTER TZIR SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B47,
 },
 [0x1B48]={
  category="lo",
  description="BALINESE LETTER EF SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B48,
 },
 [0x1B49]={
  category="lo",
  description="BALINESE LETTER VE SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B49,
 },
 [0x1B4A]={
  category="lo",
  description="BALINESE LETTER ZAL SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B4A,
 },
 [0x1B4B]={
  category="lo",
  description="BALINESE LETTER ASYURA SASAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B4B,
 },
 [0x1B50]={
  category="nd",
  description="BALINESE DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B50,
 },
 [0x1B51]={
  category="nd",
  description="BALINESE DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B51,
 },
 [0x1B52]={
  category="nd",
  description="BALINESE DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B52,
 },
 [0x1B53]={
  category="nd",
  description="BALINESE DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B53,
 },
 [0x1B54]={
  category="nd",
  description="BALINESE DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B54,
 },
 [0x1B55]={
  category="nd",
  description="BALINESE DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B55,
 },
 [0x1B56]={
  category="nd",
  description="BALINESE DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B56,
 },
 [0x1B57]={
  category="nd",
  description="BALINESE DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B57,
 },
 [0x1B58]={
  category="nd",
  description="BALINESE DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B58,
 },
 [0x1B59]={
  category="nd",
  description="BALINESE DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1B59,
 },
 [0x1B5A]={
  category="po",
  description="BALINESE PANTI",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5A,
 },
 [0x1B5B]={
  category="po",
  description="BALINESE PAMADA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5B,
 },
 [0x1B5C]={
  category="po",
  description="BALINESE WINDU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B5C,
 },
 [0x1B5D]={
  category="po",
  description="BALINESE CARIK PAMUNGKAH",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5D,
 },
 [0x1B5E]={
  category="po",
  description="BALINESE CARIK SIKI",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5E,
 },
 [0x1B5F]={
  category="po",
  description="BALINESE CARIK PAREREN",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B5F,
 },
 [0x1B60]={
  category="po",
  description="BALINESE PAMENENG",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1B60,
 },
 [0x1B61]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DONG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B61,
 },
 [0x1B62]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DENG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B62,
 },
 [0x1B63]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DUNG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B63,
 },
 [0x1B64]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B64,
 },
 [0x1B65]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DANG SURANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B65,
 },
 [0x1B66]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B66,
 },
 [0x1B67]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DAENG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B67,
 },
 [0x1B68]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DEUNG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B68,
 },
 [0x1B69]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DAING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B69,
 },
 [0x1B6A]={
  category="so",
  description="BALINESE MUSICAL SYMBOL DANG GEDE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B6A,
 },
 [0x1B6B]={
  category="mn",
  description="BALINESE MUSICAL SYMBOL COMBINING TEGEH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6B,
 },
 [0x1B6C]={
  category="mn",
  description="BALINESE MUSICAL SYMBOL COMBINING ENDEP",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6C,
 },
 [0x1B6D]={
  category="mn",
  description="BALINESE MUSICAL SYMBOL COMBINING KEMPUL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6D,
 },
 [0x1B6E]={
  category="mn",
  description="BALINESE MUSICAL SYMBOL COMBINING KEMPLI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6E,
 },
 [0x1B6F]={
  category="mn",
  description="BALINESE MUSICAL SYMBOL COMBINING JEGOGAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B6F,
 },
 [0x1B70]={
  category="mn",
  description="BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B70,
 },
 [0x1B71]={
  category="mn",
  description="BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B71,
 },
 [0x1B72]={
  category="mn",
  description="BALINESE MUSICAL SYMBOL COMBINING BENDE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B72,
 },
 [0x1B73]={
  category="mn",
  description="BALINESE MUSICAL SYMBOL COMBINING GONG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B73,
 },
 [0x1B74]={
  category="so",
  description="BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B74,
 },
 [0x1B75]={
  category="so",
  description="BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B75,
 },
 [0x1B76]={
  category="so",
  description="BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B76,
 },
 [0x1B77]={
  category="so",
  description="BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B77,
 },
 [0x1B78]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B78,
 },
 [0x1B79]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B79,
 },
 [0x1B7A]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B7A,
 },
 [0x1B7B]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B7B,
 },
 [0x1B7C]={
  category="so",
  description="BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B7C,
 },
 [0x1B80]={
  category="mn",
  description="SUNDANESE SIGN PANYECEK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B80,
 },
 [0x1B81]={
  category="mn",
  description="SUNDANESE SIGN PANGLAYAR",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1B81,
 },
 [0x1B82]={
  category="mc",
  description="SUNDANESE SIGN PANGWISAD",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1B82,
 },
 [0x1B83]={
  category="lo",
  description="SUNDANESE LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B83,
 },
 [0x1B84]={
  category="lo",
  description="SUNDANESE LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B84,
 },
 [0x1B85]={
  category="lo",
  description="SUNDANESE LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B85,
 },
 [0x1B86]={
  category="lo",
  description="SUNDANESE LETTER AE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B86,
 },
 [0x1B87]={
  category="lo",
  description="SUNDANESE LETTER O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B87,
 },
 [0x1B88]={
  category="lo",
  description="SUNDANESE LETTER E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B88,
 },
 [0x1B89]={
  category="lo",
  description="SUNDANESE LETTER EU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B89,
 },
 [0x1B8A]={
  category="lo",
  description="SUNDANESE LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8A,
 },
 [0x1B8B]={
  category="lo",
  description="SUNDANESE LETTER QA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8B,
 },
 [0x1B8C]={
  category="lo",
  description="SUNDANESE LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8C,
 },
 [0x1B8D]={
  category="lo",
  description="SUNDANESE LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8D,
 },
 [0x1B8E]={
  category="lo",
  description="SUNDANESE LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8E,
 },
 [0x1B8F]={
  category="lo",
  description="SUNDANESE LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B8F,
 },
 [0x1B90]={
  category="lo",
  description="SUNDANESE LETTER ZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B90,
 },
 [0x1B91]={
  category="lo",
  description="SUNDANESE LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B91,
 },
 [0x1B92]={
  category="lo",
  description="SUNDANESE LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B92,
 },
 [0x1B93]={
  category="lo",
  description="SUNDANESE LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B93,
 },
 [0x1B94]={
  category="lo",
  description="SUNDANESE LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B94,
 },
 [0x1B95]={
  category="lo",
  description="SUNDANESE LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B95,
 },
 [0x1B96]={
  category="lo",
  description="SUNDANESE LETTER FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B96,
 },
 [0x1B97]={
  category="lo",
  description="SUNDANESE LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B97,
 },
 [0x1B98]={
  category="lo",
  description="SUNDANESE LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B98,
 },
 [0x1B99]={
  category="lo",
  description="SUNDANESE LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B99,
 },
 [0x1B9A]={
  category="lo",
  description="SUNDANESE LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9A,
 },
 [0x1B9B]={
  category="lo",
  description="SUNDANESE LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9B,
 },
 [0x1B9C]={
  category="lo",
  description="SUNDANESE LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9C,
 },
 [0x1B9D]={
  category="lo",
  description="SUNDANESE LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9D,
 },
 [0x1B9E]={
  category="lo",
  description="SUNDANESE LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9E,
 },
 [0x1B9F]={
  category="lo",
  description="SUNDANESE LETTER XA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1B9F,
 },
 [0x1BA0]={
  category="lo",
  description="SUNDANESE LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BA0,
 },
 [0x1BA1]={
  category="mc",
  description="SUNDANESE CONSONANT SIGN PAMINGKAL",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BA1,
 },
 [0x1BA2]={
  category="mn",
  description="SUNDANESE CONSONANT SIGN PANYAKRA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA2,
 },
 [0x1BA3]={
  category="mn",
  description="SUNDANESE CONSONANT SIGN PANYIKU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA3,
 },
 [0x1BA4]={
  category="mn",
  description="SUNDANESE VOWEL SIGN PANGHULU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA4,
 },
 [0x1BA5]={
  category="mn",
  description="SUNDANESE VOWEL SIGN PANYUKU",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA5,
 },
 [0x1BA6]={
  category="mc",
  description="SUNDANESE VOWEL SIGN PANAELAENG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BA6,
 },
 [0x1BA7]={
  category="mc",
  description="SUNDANESE VOWEL SIGN PANOLONG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BA7,
 },
 [0x1BA8]={
  category="mn",
  description="SUNDANESE VOWEL SIGN PAMEPET",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA8,
 },
 [0x1BA9]={
  category="mn",
  description="SUNDANESE VOWEL SIGN PANEULEUNG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BA9,
 },
 [0x1BAA]={
  category="mc",
  description="SUNDANESE SIGN PAMAAEH",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BAA,
 },
 [0x1BAE]={
  category="lo",
  description="SUNDANESE LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BAE,
 },
 [0x1BAF]={
  category="lo",
  description="SUNDANESE LETTER SYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BAF,
 },
 [0x1BB0]={
  category="nd",
  description="SUNDANESE DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB0,
 },
 [0x1BB1]={
  category="nd",
  description="SUNDANESE DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB1,
 },
 [0x1BB2]={
  category="nd",
  description="SUNDANESE DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB2,
 },
 [0x1BB3]={
  category="nd",
  description="SUNDANESE DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB3,
 },
 [0x1BB4]={
  category="nd",
  description="SUNDANESE DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB4,
 },
 [0x1BB5]={
  category="nd",
  description="SUNDANESE DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB5,
 },
 [0x1BB6]={
  category="nd",
  description="SUNDANESE DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB6,
 },
 [0x1BB7]={
  category="nd",
  description="SUNDANESE DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB7,
 },
 [0x1BB8]={
  category="nd",
  description="SUNDANESE DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB8,
 },
 [0x1BB9]={
  category="nd",
  description="SUNDANESE DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1BB9,
 },
 [0x1BC0]={
  category="lo",
  description="BATAK LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC0,
 },
 [0x1BC1]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC1,
 },
 [0x1BC2]={
  category="lo",
  description="BATAK LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC2,
 },
 [0x1BC3]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC3,
 },
 [0x1BC4]={
  category="lo",
  description="BATAK LETTER MANDAILING HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC4,
 },
 [0x1BC5]={
  category="lo",
  description="BATAK LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC5,
 },
 [0x1BC6]={
  category="lo",
  description="BATAK LETTER KARO BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC6,
 },
 [0x1BC7]={
  category="lo",
  description="BATAK LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC7,
 },
 [0x1BC8]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC8,
 },
 [0x1BC9]={
  category="lo",
  description="BATAK LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BC9,
 },
 [0x1BCA]={
  category="lo",
  description="BATAK LETTER MANDAILING NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCA,
 },
 [0x1BCB]={
  category="lo",
  description="BATAK LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCB,
 },
 [0x1BCC]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCC,
 },
 [0x1BCD]={
  category="lo",
  description="BATAK LETTER PAKPAK WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCD,
 },
 [0x1BCE]={
  category="lo",
  description="BATAK LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCE,
 },
 [0x1BCF]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BCF,
 },
 [0x1BD0]={
  category="lo",
  description="BATAK LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD0,
 },
 [0x1BD1]={
  category="lo",
  description="BATAK LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD1,
 },
 [0x1BD2]={
  category="lo",
  description="BATAK LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD2,
 },
 [0x1BD3]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD3,
 },
 [0x1BD4]={
  category="lo",
  description="BATAK LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD4,
 },
 [0x1BD5]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD5,
 },
 [0x1BD6]={
  category="lo",
  description="BATAK LETTER SOUTHERN TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD6,
 },
 [0x1BD7]={
  category="lo",
  description="BATAK LETTER NORTHERN TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD7,
 },
 [0x1BD8]={
  category="lo",
  description="BATAK LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD8,
 },
 [0x1BD9]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BD9,
 },
 [0x1BDA]={
  category="lo",
  description="BATAK LETTER MANDAILING SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDA,
 },
 [0x1BDB]={
  category="lo",
  description="BATAK LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDB,
 },
 [0x1BDC]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDC,
 },
 [0x1BDD]={
  category="lo",
  description="BATAK LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDD,
 },
 [0x1BDE]={
  category="lo",
  description="BATAK LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDE,
 },
 [0x1BDF]={
  category="lo",
  description="BATAK LETTER SIMALUNGUN LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BDF,
 },
 [0x1BE0]={
  category="lo",
  description="BATAK LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE0,
 },
 [0x1BE1]={
  category="lo",
  description="BATAK LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE1,
 },
 [0x1BE2]={
  category="lo",
  description="BATAK LETTER NDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE2,
 },
 [0x1BE3]={
  category="lo",
  description="BATAK LETTER MBA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE3,
 },
 [0x1BE4]={
  category="lo",
  description="BATAK LETTER I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE4,
 },
 [0x1BE5]={
  category="lo",
  description="BATAK LETTER U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BE5,
 },
 [0x1BE6]={
  category="mn",
  description="BATAK SIGN TOMPI",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BE6,
 },
 [0x1BE7]={
  category="mc",
  description="BATAK VOWEL SIGN E",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BE7,
 },
 [0x1BE8]={
  category="mn",
  description="BATAK VOWEL SIGN PAKPAK E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BE8,
 },
 [0x1BE9]={
  category="mn",
  description="BATAK VOWEL SIGN EE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BE9,
 },
 [0x1BEA]={
  category="mc",
  description="BATAK VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BEA,
 },
 [0x1BEB]={
  category="mc",
  description="BATAK VOWEL SIGN KARO I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BEB,
 },
 [0x1BEC]={
  category="mc",
  description="BATAK VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BEC,
 },
 [0x1BED]={
  category="mn",
  description="BATAK VOWEL SIGN KARO O",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BED,
 },
 [0x1BEE]={
  category="mc",
  description="BATAK VOWEL SIGN U",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BEE,
 },
 [0x1BEF]={
  category="mn",
  description="BATAK VOWEL SIGN U FOR SIMALUNGUN SA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BEF,
 },
 [0x1BF0]={
  category="mn",
  description="BATAK CONSONANT SIGN NG",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BF0,
 },
 [0x1BF1]={
  category="mn",
  description="BATAK CONSONANT SIGN H",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1BF1,
 },
 [0x1BF2]={
  category="mc",
  description="BATAK PANGOLAT",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BF2,
 },
 [0x1BF3]={
  category="mc",
  description="BATAK PANONGONAN",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1BF3,
 },
 [0x1BFC]={
  category="po",
  description="BATAK SYMBOL BINDU NA METEK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BFC,
 },
 [0x1BFD]={
  category="po",
  description="BATAK SYMBOL BINDU PINARBORAS",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BFD,
 },
 [0x1BFE]={
  category="po",
  description="BATAK SYMBOL BINDU JUDUL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BFE,
 },
 [0x1BFF]={
  category="po",
  description="BATAK SYMBOL BINDU PANGOLAT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1BFF,
 },
 [0x1C00]={
  category="lo",
  description="LEPCHA LETTER KA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C00,
 },
 [0x1C01]={
  category="lo",
  description="LEPCHA LETTER KLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C01,
 },
 [0x1C02]={
  category="lo",
  description="LEPCHA LETTER KHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C02,
 },
 [0x1C03]={
  category="lo",
  description="LEPCHA LETTER GA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C03,
 },
 [0x1C04]={
  category="lo",
  description="LEPCHA LETTER GLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C04,
 },
 [0x1C05]={
  category="lo",
  description="LEPCHA LETTER NGA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C05,
 },
 [0x1C06]={
  category="lo",
  description="LEPCHA LETTER CA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C06,
 },
 [0x1C07]={
  category="lo",
  description="LEPCHA LETTER CHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C07,
 },
 [0x1C08]={
  category="lo",
  description="LEPCHA LETTER JA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C08,
 },
 [0x1C09]={
  category="lo",
  description="LEPCHA LETTER NYA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C09,
 },
 [0x1C0A]={
  category="lo",
  description="LEPCHA LETTER TA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0A,
 },
 [0x1C0B]={
  category="lo",
  description="LEPCHA LETTER THA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0B,
 },
 [0x1C0C]={
  category="lo",
  description="LEPCHA LETTER DA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0C,
 },
 [0x1C0D]={
  category="lo",
  description="LEPCHA LETTER NA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0D,
 },
 [0x1C0E]={
  category="lo",
  description="LEPCHA LETTER PA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0E,
 },
 [0x1C0F]={
  category="lo",
  description="LEPCHA LETTER PLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C0F,
 },
 [0x1C10]={
  category="lo",
  description="LEPCHA LETTER PHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C10,
 },
 [0x1C11]={
  category="lo",
  description="LEPCHA LETTER FA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C11,
 },
 [0x1C12]={
  category="lo",
  description="LEPCHA LETTER FLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C12,
 },
 [0x1C13]={
  category="lo",
  description="LEPCHA LETTER BA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C13,
 },
 [0x1C14]={
  category="lo",
  description="LEPCHA LETTER BLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C14,
 },
 [0x1C15]={
  category="lo",
  description="LEPCHA LETTER MA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C15,
 },
 [0x1C16]={
  category="lo",
  description="LEPCHA LETTER MLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C16,
 },
 [0x1C17]={
  category="lo",
  description="LEPCHA LETTER TSA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C17,
 },
 [0x1C18]={
  category="lo",
  description="LEPCHA LETTER TSHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C18,
 },
 [0x1C19]={
  category="lo",
  description="LEPCHA LETTER DZA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C19,
 },
 [0x1C1A]={
  category="lo",
  description="LEPCHA LETTER YA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1A,
 },
 [0x1C1B]={
  category="lo",
  description="LEPCHA LETTER RA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1B,
 },
 [0x1C1C]={
  category="lo",
  description="LEPCHA LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1C,
 },
 [0x1C1D]={
  category="lo",
  description="LEPCHA LETTER HA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1D,
 },
 [0x1C1E]={
  category="lo",
  description="LEPCHA LETTER HLA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1E,
 },
 [0x1C1F]={
  category="lo",
  description="LEPCHA LETTER VA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C1F,
 },
 [0x1C20]={
  category="lo",
  description="LEPCHA LETTER SA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C20,
 },
 [0x1C21]={
  category="lo",
  description="LEPCHA LETTER SHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C21,
 },
 [0x1C22]={
  category="lo",
  description="LEPCHA LETTER WA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C22,
 },
 [0x1C23]={
  category="lo",
  description="LEPCHA LETTER A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C23,
 },
 [0x1C24]={
  category="mc",
  description="LEPCHA SUBJOINED LETTER YA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C24,
 },
 [0x1C25]={
  category="mc",
  description="LEPCHA SUBJOINED LETTER RA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C25,
 },
 [0x1C26]={
  category="mc",
  description="LEPCHA VOWEL SIGN AA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C26,
 },
 [0x1C27]={
  category="mc",
  description="LEPCHA VOWEL SIGN I",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C27,
 },
 [0x1C28]={
  category="mc",
  description="LEPCHA VOWEL SIGN O",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C28,
 },
 [0x1C29]={
  category="mc",
  description="LEPCHA VOWEL SIGN OO",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C29,
 },
 [0x1C2A]={
  category="mc",
  description="LEPCHA VOWEL SIGN U",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C2A,
 },
 [0x1C2B]={
  category="mc",
  description="LEPCHA VOWEL SIGN UU",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C2B,
 },
 [0x1C2C]={
  category="mn",
  description="LEPCHA VOWEL SIGN E",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C2C,
 },
 [0x1C2D]={
  category="mn",
  description="LEPCHA CONSONANT SIGN K",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C2D,
 },
 [0x1C2E]={
  category="mn",
  description="LEPCHA CONSONANT SIGN M",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C2E,
 },
 [0x1C2F]={
  category="mn",
  description="LEPCHA CONSONANT SIGN L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C2F,
 },
 [0x1C30]={
  category="mn",
  description="LEPCHA CONSONANT SIGN N",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C30,
 },
 [0x1C31]={
  category="mn",
  description="LEPCHA CONSONANT SIGN P",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C31,
 },
 [0x1C32]={
  category="mn",
  description="LEPCHA CONSONANT SIGN R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C32,
 },
 [0x1C33]={
  category="mn",
  description="LEPCHA CONSONANT SIGN T",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C33,
 },
 [0x1C34]={
  category="mc",
  description="LEPCHA CONSONANT SIGN NYIN-DO",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C34,
 },
 [0x1C35]={
  category="mc",
  description="LEPCHA CONSONANT SIGN KANG",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1C35,
 },
 [0x1C36]={
  category="mn",
  description="LEPCHA SIGN RAN",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C36,
 },
 [0x1C37]={
  category="mn",
  description="LEPCHA SIGN NUKTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1C37,
 },
 [0x1C3B]={
  category="po",
  description="LEPCHA PUNCTUATION TA-ROL",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3B,
 },
 [0x1C3C]={
  category="po",
  description="LEPCHA PUNCTUATION NYET THYOOM TA-ROL",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3C,
 },
 [0x1C3D]={
  category="po",
  description="LEPCHA PUNCTUATION CER-WA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3D,
 },
 [0x1C3E]={
  category="po",
  description="LEPCHA PUNCTUATION TSHOOK CER-WA",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3E,
 },
 [0x1C3F]={
  category="po",
  description="LEPCHA PUNCTUATION TSHOOK",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C3F,
 },
 [0x1C40]={
  category="nd",
  description="LEPCHA DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C40,
 },
 [0x1C41]={
  category="nd",
  description="LEPCHA DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C41,
 },
 [0x1C42]={
  category="nd",
  description="LEPCHA DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C42,
 },
 [0x1C43]={
  category="nd",
  description="LEPCHA DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C43,
 },
 [0x1C44]={
  category="nd",
  description="LEPCHA DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C44,
 },
 [0x1C45]={
  category="nd",
  description="LEPCHA DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C45,
 },
 [0x1C46]={
  category="nd",
  description="LEPCHA DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C46,
 },
 [0x1C47]={
  category="nd",
  description="LEPCHA DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C47,
 },
 [0x1C48]={
  category="nd",
  description="LEPCHA DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C48,
 },
 [0x1C49]={
  category="nd",
  description="LEPCHA DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C49,
 },
 [0x1C4D]={
  category="lo",
  description="LEPCHA LETTER TTA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C4D,
 },
 [0x1C4E]={
  category="lo",
  description="LEPCHA LETTER TTHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C4E,
 },
 [0x1C4F]={
  category="lo",
  description="LEPCHA LETTER DDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C4F,
 },
 [0x1C50]={
  category="nd",
  description="OL CHIKI DIGIT ZERO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C50,
 },
 [0x1C51]={
  category="nd",
  description="OL CHIKI DIGIT ONE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C51,
 },
 [0x1C52]={
  category="nd",
  description="OL CHIKI DIGIT TWO",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C52,
 },
 [0x1C53]={
  category="nd",
  description="OL CHIKI DIGIT THREE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C53,
 },
 [0x1C54]={
  category="nd",
  description="OL CHIKI DIGIT FOUR",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C54,
 },
 [0x1C55]={
  category="nd",
  description="OL CHIKI DIGIT FIVE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C55,
 },
 [0x1C56]={
  category="nd",
  description="OL CHIKI DIGIT SIX",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C56,
 },
 [0x1C57]={
  category="nd",
  description="OL CHIKI DIGIT SEVEN",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C57,
 },
 [0x1C58]={
  category="nd",
  description="OL CHIKI DIGIT EIGHT",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C58,
 },
 [0x1C59]={
  category="nd",
  description="OL CHIKI DIGIT NINE",
  direction="l",
  linebreak="nu",
  unicodeslot=0x1C59,
 },
 [0x1C5A]={
  category="lo",
  description="OL CHIKI LETTER LA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5A,
 },
 [0x1C5B]={
  category="lo",
  description="OL CHIKI LETTER AT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5B,
 },
 [0x1C5C]={
  category="lo",
  description="OL CHIKI LETTER AG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5C,
 },
 [0x1C5D]={
  category="lo",
  description="OL CHIKI LETTER ANG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5D,
 },
 [0x1C5E]={
  category="lo",
  description="OL CHIKI LETTER AL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5E,
 },
 [0x1C5F]={
  category="lo",
  description="OL CHIKI LETTER LAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C5F,
 },
 [0x1C60]={
  category="lo",
  description="OL CHIKI LETTER AAK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C60,
 },
 [0x1C61]={
  category="lo",
  description="OL CHIKI LETTER AAJ",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C61,
 },
 [0x1C62]={
  category="lo",
  description="OL CHIKI LETTER AAM",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C62,
 },
 [0x1C63]={
  category="lo",
  description="OL CHIKI LETTER AAW",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C63,
 },
 [0x1C64]={
  category="lo",
  description="OL CHIKI LETTER LI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C64,
 },
 [0x1C65]={
  category="lo",
  description="OL CHIKI LETTER IS",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C65,
 },
 [0x1C66]={
  category="lo",
  description="OL CHIKI LETTER IH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C66,
 },
 [0x1C67]={
  category="lo",
  description="OL CHIKI LETTER INY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C67,
 },
 [0x1C68]={
  category="lo",
  description="OL CHIKI LETTER IR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C68,
 },
 [0x1C69]={
  category="lo",
  description="OL CHIKI LETTER LU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C69,
 },
 [0x1C6A]={
  category="lo",
  description="OL CHIKI LETTER UC",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6A,
 },
 [0x1C6B]={
  category="lo",
  description="OL CHIKI LETTER UD",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6B,
 },
 [0x1C6C]={
  category="lo",
  description="OL CHIKI LETTER UNN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6C,
 },
 [0x1C6D]={
  category="lo",
  description="OL CHIKI LETTER UY",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6D,
 },
 [0x1C6E]={
  category="lo",
  description="OL CHIKI LETTER LE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6E,
 },
 [0x1C6F]={
  category="lo",
  description="OL CHIKI LETTER EP",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C6F,
 },
 [0x1C70]={
  category="lo",
  description="OL CHIKI LETTER EDD",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C70,
 },
 [0x1C71]={
  category="lo",
  description="OL CHIKI LETTER EN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C71,
 },
 [0x1C72]={
  category="lo",
  description="OL CHIKI LETTER ERR",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C72,
 },
 [0x1C73]={
  category="lo",
  description="OL CHIKI LETTER LO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C73,
 },
 [0x1C74]={
  category="lo",
  description="OL CHIKI LETTER OTT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C74,
 },
 [0x1C75]={
  category="lo",
  description="OL CHIKI LETTER OB",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C75,
 },
 [0x1C76]={
  category="lo",
  description="OL CHIKI LETTER OV",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C76,
 },
 [0x1C77]={
  category="lo",
  description="OL CHIKI LETTER OH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C77,
 },
 [0x1C78]={
  category="lm",
  description="OL CHIKI MU TTUDDAG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C78,
 },
 [0x1C79]={
  category="lm",
  description="OL CHIKI GAAHLAA TTUDDAAG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C79,
 },
 [0x1C7A]={
  category="lm",
  description="OL CHIKI MU-GAAHLAA TTUDDAAG",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C7A,
 },
 [0x1C7B]={
  category="lm",
  description="OL CHIKI RELAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C7B,
 },
 [0x1C7C]={
  category="lm",
  description="OL CHIKI PHAARKAA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C7C,
 },
 [0x1C7D]={
  category="lm",
  description="OL CHIKI AHAD",
  direction="l",
  linebreak="al",
  unicodeslot=0x1C7D,
 },
 [0x1C7E]={
  category="po",
  description="OL CHIKI PUNCTUATION MUCAAD",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C7E,
 },
 [0x1C7F]={
  category="po",
  description="OL CHIKI PUNCTUATION DOUBLE MUCAAD",
  direction="l",
  linebreak="ba",
  unicodeslot=0x1C7F,
 },
 [0x1CD0]={
  category="mn",
  description="VEDIC TONE KARSHANA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CD0,
 },
 [0x1CD1]={
  category="mn",
  description="VEDIC TONE SHARA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CD1,
 },
 [0x1CD2]={
  category="mn",
  description="VEDIC TONE PRENKHA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CD2,
 },
 [0x1CD3]={
  category="po",
  description="VEDIC SIGN NIHSHVASA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1CD3,
 },
 [0x1CD4]={
  category="mn",
  description="VEDIC SIGN YAJURVEDIC MIDLINE SVARITA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CD4,
 },
 [0x1CD5]={
  category="mn",
  description="VEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARITA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CD5,
 },
 [0x1CD6]={
  category="mn",
  description="VEDIC TONE YAJURVEDIC INDEPENDENT SVARITA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CD6,
 },
 [0x1CD7]={
  category="mn",
  description="VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CD7,
 },
 [0x1CD8]={
  category="mn",
  description="VEDIC TONE CANDRA BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CD8,
 },
 [0x1CD9]={
  category="mn",
  description="VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDER",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CD9,
 },
 [0x1CDA]={
  category="mn",
  description="VEDIC TONE DOUBLE SVARITA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CDA,
 },
 [0x1CDB]={
  category="mn",
  description="VEDIC TONE TRIPLE SVARITA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CDB,
 },
 [0x1CDC]={
  category="mn",
  description="VEDIC TONE KATHAKA ANUDATTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CDC,
 },
 [0x1CDD]={
  category="mn",
  description="VEDIC TONE DOT BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CDD,
 },
 [0x1CDE]={
  category="mn",
  description="VEDIC TONE TWO DOTS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CDE,
 },
 [0x1CDF]={
  category="mn",
  description="VEDIC TONE THREE DOTS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CDF,
 },
 [0x1CE0]={
  category="mn",
  description="VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CE0,
 },
 [0x1CE1]={
  category="mc",
  description="VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1CE1,
 },
 [0x1CE2]={
  category="mn",
  description="VEDIC SIGN VISARGA SVARITA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CE2,
 },
 [0x1CE3]={
  category="mn",
  description="VEDIC SIGN VISARGA UDATTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CE3,
 },
 [0x1CE4]={
  category="mn",
  description="VEDIC SIGN REVERSED VISARGA UDATTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CE4,
 },
 [0x1CE5]={
  category="mn",
  description="VEDIC SIGN VISARGA ANUDATTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CE5,
 },
 [0x1CE6]={
  category="mn",
  description="VEDIC SIGN REVERSED VISARGA ANUDATTA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CE6,
 },
 [0x1CE7]={
  category="mn",
  description="VEDIC SIGN VISARGA UDATTA WITH TAIL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CE7,
 },
 [0x1CE8]={
  category="mn",
  description="VEDIC SIGN VISARGA ANUDATTA WITH TAIL",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CE8,
 },
 [0x1CE9]={
  category="lo",
  description="VEDIC SIGN ANUSVARA ANTARGOMUKHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1CE9,
 },
 [0x1CEA]={
  category="lo",
  description="VEDIC SIGN ANUSVARA BAHIRGOMUKHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1CEA,
 },
 [0x1CEB]={
  category="lo",
  description="VEDIC SIGN ANUSVARA VAMAGOMUKHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1CEB,
 },
 [0x1CEC]={
  category="lo",
  description="VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1CEC,
 },
 [0x1CED]={
  category="mn",
  description="VEDIC SIGN TIRYAK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1CED,
 },
 [0x1CEE]={
  category="lo",
  description="VEDIC SIGN HEXIFORM LONG ANUSVARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1CEE,
 },
 [0x1CEF]={
  category="lo",
  description="VEDIC SIGN LONG ANUSVARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1CEF,
 },
 [0x1CF0]={
  category="lo",
  description="VEDIC SIGN RTHANG LONG ANUSVARA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1CF0,
 },
 [0x1CF1]={
  category="lo",
  description="VEDIC SIGN ANUSVARA UBHAYATO MUKHA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1CF1,
 },
 [0x1CF2]={
  category="mc",
  description="VEDIC SIGN ARDHAVISARGA",
  direction="l",
  linebreak="cm",
  unicodeslot=0x1CF2,
 },
 [0x1D00]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL A",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D00,
 },
 [0x1D01]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL AE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D01,
 },
 [0x1D02]={
  category="ll",
  description="LATIN SMALL LETTER TURNED AE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D02,
 },
 [0x1D03]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL BARRED B",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D03,
 },
 [0x1D04]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL C",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D04,
 },
 [0x1D05]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL D",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D05,
 },
 [0x1D06]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL ETH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D06,
 },
 [0x1D07]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D07,
 },
 [0x1D08]={
  category="ll",
  description="LATIN SMALL LETTER TURNED OPEN E",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D08,
 },
 [0x1D09]={
  category="ll",
  description="LATIN SMALL LETTER TURNED I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D09,
 },
 [0x1D0A]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL J",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D0A,
 },
 [0x1D0B]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL K",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D0B,
 },
 [0x1D0C]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL L WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D0C,
 },
 [0x1D0D]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL M",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D0D,
 },
 [0x1D0E]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL REVERSED N",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D0E,
 },
 [0x1D0F]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D0F,
 },
 [0x1D10]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL OPEN O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D10,
 },
 [0x1D11]={
  category="ll",
  description="LATIN SMALL LETTER SIDEWAYS O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D11,
 },
 [0x1D12]={
  category="ll",
  description="LATIN SMALL LETTER SIDEWAYS OPEN O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D12,
 },
 [0x1D13]={
  category="ll",
  description="LATIN SMALL LETTER SIDEWAYS O WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D13,
 },
 [0x1D14]={
  category="ll",
  description="LATIN SMALL LETTER TURNED OE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D14,
 },
 [0x1D15]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL OU",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D15,
 },
 [0x1D16]={
  category="ll",
  description="LATIN SMALL LETTER TOP HALF O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D16,
 },
 [0x1D17]={
  category="ll",
  description="LATIN SMALL LETTER BOTTOM HALF O",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D17,
 },
 [0x1D18]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL P",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D18,
 },
 [0x1D19]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL REVERSED R",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D19,
 },
 [0x1D1A]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL TURNED R",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D1A,
 },
 [0x1D1B]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL T",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D1B,
 },
 [0x1D1C]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D1C,
 },
 [0x1D1D]={
  category="ll",
  description="LATIN SMALL LETTER SIDEWAYS U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D1D,
 },
 [0x1D1E]={
  category="ll",
  description="LATIN SMALL LETTER SIDEWAYS DIAERESIZED U",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D1E,
 },
 [0x1D1F]={
  category="ll",
  description="LATIN SMALL LETTER SIDEWAYS TURNED M",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D1F,
 },
 [0x1D20]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL V",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D20,
 },
 [0x1D21]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL W",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D21,
 },
 [0x1D22]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL Z",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D22,
 },
 [0x1D23]={
  category="ll",
  description="LATIN LETTER SMALL CAPITAL EZH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D23,
 },
 [0x1D24]={
  category="ll",
  description="LATIN LETTER VOICED LARYNGEAL SPIRANT",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D24,
 },
 [0x1D25]={
  category="ll",
  description="LATIN LETTER AIN",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D25,
 },
 [0x1D26]={
  category="ll",
  description="GREEK LETTER SMALL CAPITAL GAMMA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D26,
 },
 [0x1D27]={
  category="ll",
  description="GREEK LETTER SMALL CAPITAL LAMDA",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D27,
 },
 [0x1D28]={
  category="ll",
  description="GREEK LETTER SMALL CAPITAL PI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D28,
 },
 [0x1D29]={
  category="ll",
  description="GREEK LETTER SMALL CAPITAL RHO",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D29,
 },
 [0x1D2A]={
  category="ll",
  description="GREEK LETTER SMALL CAPITAL PSI",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D2A,
 },
 [0x1D2B]={
  category="ll",
  description="CYRILLIC LETTER SMALL CAPITAL EL",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D2B,
 },
 [0x1D2C]={
  category="lm",
  description="MODIFIER LETTER CAPITAL A",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0041 },
  unicodeslot=0x1D2C,
 },
 [0x1D2D]={
  category="lm",
  description="MODIFIER LETTER CAPITAL AE",
  direction="l",
  linebreak="al",
  specials={ "super", 0x00C6 },
  unicodeslot=0x1D2D,
 },
 [0x1D2E]={
  category="lm",
  description="MODIFIER LETTER CAPITAL B",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0042 },
  unicodeslot=0x1D2E,
 },
 [0x1D2F]={
  category="lm",
  description="MODIFIER LETTER CAPITAL BARRED B",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D2F,
 },
 [0x1D30]={
  category="lm",
  description="MODIFIER LETTER CAPITAL D",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0044 },
  unicodeslot=0x1D30,
 },
 [0x1D31]={
  category="lm",
  description="MODIFIER LETTER CAPITAL E",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0045 },
  unicodeslot=0x1D31,
 },
 [0x1D32]={
  category="lm",
  description="MODIFIER LETTER CAPITAL REVERSED E",
  direction="l",
  linebreak="al",
  specials={ "super", 0x018E },
  unicodeslot=0x1D32,
 },
 [0x1D33]={
  category="lm",
  description="MODIFIER LETTER CAPITAL G",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0047 },
  unicodeslot=0x1D33,
 },
 [0x1D34]={
  category="lm",
  description="MODIFIER LETTER CAPITAL H",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0048 },
  unicodeslot=0x1D34,
 },
 [0x1D35]={
  category="lm",
  description="MODIFIER LETTER CAPITAL I",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0049 },
  unicodeslot=0x1D35,
 },
 [0x1D36]={
  category="lm",
  description="MODIFIER LETTER CAPITAL J",
  direction="l",
  linebreak="al",
  specials={ "super", 0x004A },
  unicodeslot=0x1D36,
 },
 [0x1D37]={
  category="lm",
  description="MODIFIER LETTER CAPITAL K",
  direction="l",
  linebreak="al",
  specials={ "super", 0x004B },
  unicodeslot=0x1D37,
 },
 [0x1D38]={
  category="lm",
  description="MODIFIER LETTER CAPITAL L",
  direction="l",
  linebreak="al",
  specials={ "super", 0x004C },
  unicodeslot=0x1D38,
 },
 [0x1D39]={
  category="lm",
  description="MODIFIER LETTER CAPITAL M",
  direction="l",
  linebreak="al",
  specials={ "super", 0x004D },
  unicodeslot=0x1D39,
 },
 [0x1D3A]={
  category="lm",
  description="MODIFIER LETTER CAPITAL N",
  direction="l",
  linebreak="al",
  specials={ "super", 0x004E },
  unicodeslot=0x1D3A,
 },
 [0x1D3B]={
  category="lm",
  description="MODIFIER LETTER CAPITAL REVERSED N",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D3B,
 },
 [0x1D3C]={
  category="lm",
  description="MODIFIER LETTER CAPITAL O",
  direction="l",
  linebreak="al",
  specials={ "super", 0x004F },
  unicodeslot=0x1D3C,
 },
 [0x1D3D]={
  category="lm",
  description="MODIFIER LETTER CAPITAL OU",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0222 },
  unicodeslot=0x1D3D,
 },
 [0x1D3E]={
  category="lm",
  description="MODIFIER LETTER CAPITAL P",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0050 },
  unicodeslot=0x1D3E,
 },
 [0x1D3F]={
  category="lm",
  description="MODIFIER LETTER CAPITAL R",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0052 },
  unicodeslot=0x1D3F,
 },
 [0x1D40]={
  category="lm",
  description="MODIFIER LETTER CAPITAL T",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0054 },
  unicodeslot=0x1D40,
 },
 [0x1D41]={
  category="lm",
  description="MODIFIER LETTER CAPITAL U",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0055 },
  unicodeslot=0x1D41,
 },
 [0x1D42]={
  category="lm",
  description="MODIFIER LETTER CAPITAL W",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0057 },
  unicodeslot=0x1D42,
 },
 [0x1D43]={
  category="lm",
  description="MODIFIER LETTER SMALL A",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0061 },
  unicodeslot=0x1D43,
 },
 [0x1D44]={
  category="lm",
  description="MODIFIER LETTER SMALL TURNED A",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0250 },
  unicodeslot=0x1D44,
 },
 [0x1D45]={
  category="lm",
  description="MODIFIER LETTER SMALL ALPHA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0251 },
  unicodeslot=0x1D45,
 },
 [0x1D46]={
  category="lm",
  description="MODIFIER LETTER SMALL TURNED AE",
  direction="l",
  linebreak="al",
  specials={ "super", 0x1D02 },
  unicodeslot=0x1D46,
 },
 [0x1D47]={
  category="lm",
  description="MODIFIER LETTER SMALL B",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0062 },
  unicodeslot=0x1D47,
 },
 [0x1D48]={
  category="lm",
  description="MODIFIER LETTER SMALL D",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0064 },
  unicodeslot=0x1D48,
 },
 [0x1D49]={
  category="lm",
  description="MODIFIER LETTER SMALL E",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0065 },
  unicodeslot=0x1D49,
 },
 [0x1D4A]={
  category="lm",
  description="MODIFIER LETTER SMALL SCHWA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0259 },
  unicodeslot=0x1D4A,
 },
 [0x1D4B]={
  category="lm",
  description="MODIFIER LETTER SMALL OPEN E",
  direction="l",
  linebreak="al",
  specials={ "super", 0x025B },
  unicodeslot=0x1D4B,
 },
 [0x1D4C]={
  category="lm",
  description="MODIFIER LETTER SMALL TURNED OPEN E",
  direction="l",
  linebreak="al",
  specials={ "super", 0x025C },
  unicodeslot=0x1D4C,
 },
 [0x1D4D]={
  category="lm",
  description="MODIFIER LETTER SMALL G",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0067 },
  unicodeslot=0x1D4D,
 },
 [0x1D4E]={
  category="lm",
  description="MODIFIER LETTER SMALL TURNED I",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D4E,
 },
 [0x1D4F]={
  category="lm",
  description="MODIFIER LETTER SMALL K",
  direction="l",
  linebreak="al",
  specials={ "super", 0x006B },
  unicodeslot=0x1D4F,
 },
 [0x1D50]={
  category="lm",
  description="MODIFIER LETTER SMALL M",
  direction="l",
  linebreak="al",
  specials={ "super", 0x006D },
  unicodeslot=0x1D50,
 },
 [0x1D51]={
  category="lm",
  description="MODIFIER LETTER SMALL ENG",
  direction="l",
  linebreak="al",
  specials={ "super", 0x014B },
  unicodeslot=0x1D51,
 },
 [0x1D52]={
  category="lm",
  description="MODIFIER LETTER SMALL O",
  direction="l",
  linebreak="al",
  specials={ "super", 0x006F },
  unicodeslot=0x1D52,
 },
 [0x1D53]={
  category="lm",
  description="MODIFIER LETTER SMALL OPEN O",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0254 },
  unicodeslot=0x1D53,
 },
 [0x1D54]={
  category="lm",
  description="MODIFIER LETTER SMALL TOP HALF O",
  direction="l",
  linebreak="al",
  specials={ "super", 0x1D16 },
  unicodeslot=0x1D54,
 },
 [0x1D55]={
  category="lm",
  description="MODIFIER LETTER SMALL BOTTOM HALF O",
  direction="l",
  linebreak="al",
  specials={ "super", 0x1D17 },
  unicodeslot=0x1D55,
 },
 [0x1D56]={
  category="lm",
  description="MODIFIER LETTER SMALL P",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0070 },
  unicodeslot=0x1D56,
 },
 [0x1D57]={
  category="lm",
  description="MODIFIER LETTER SMALL T",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0074 },
  unicodeslot=0x1D57,
 },
 [0x1D58]={
  category="lm",
  description="MODIFIER LETTER SMALL U",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0075 },
  unicodeslot=0x1D58,
 },
 [0x1D59]={
  category="lm",
  description="MODIFIER LETTER SMALL SIDEWAYS U",
  direction="l",
  linebreak="al",
  specials={ "super", 0x1D1D },
  unicodeslot=0x1D59,
 },
 [0x1D5A]={
  category="lm",
  description="MODIFIER LETTER SMALL TURNED M",
  direction="l",
  linebreak="al",
  specials={ "super", 0x026F },
  unicodeslot=0x1D5A,
 },
 [0x1D5B]={
  category="lm",
  description="MODIFIER LETTER SMALL V",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0076 },
  unicodeslot=0x1D5B,
 },
 [0x1D5C]={
  category="lm",
  description="MODIFIER LETTER SMALL AIN",
  direction="l",
  linebreak="al",
  specials={ "super", 0x1D25 },
  unicodeslot=0x1D5C,
 },
 [0x1D5D]={
  category="lm",
  description="MODIFIER LETTER SMALL BETA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x03B2 },
  unicodeslot=0x1D5D,
 },
 [0x1D5E]={
  category="lm",
  description="MODIFIER LETTER SMALL GREEK GAMMA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x03B3 },
  unicodeslot=0x1D5E,
 },
 [0x1D5F]={
  category="lm",
  description="MODIFIER LETTER SMALL DELTA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x03B4 },
  unicodeslot=0x1D5F,
 },
 [0x1D60]={
  category="lm",
  description="MODIFIER LETTER SMALL GREEK PHI",
  direction="l",
  linebreak="al",
  specials={ "super", 0x03C6 },
  unicodeslot=0x1D60,
 },
 [0x1D61]={
  category="lm",
  description="MODIFIER LETTER SMALL CHI",
  direction="l",
  linebreak="al",
  specials={ "super", 0x03C7 },
  unicodeslot=0x1D61,
 },
 [0x1D62]={
  category="ll",
  description="LATIN SUBSCRIPT SMALL LETTER I",
  direction="l",
  linebreak="al",
  specials={ "sub", 0x0069 },
  unicodeslot=0x1D62,
 },
 [0x1D63]={
  category="ll",
  description="LATIN SUBSCRIPT SMALL LETTER R",
  direction="l",
  linebreak="al",
  specials={ "sub", 0x0072 },
  unicodeslot=0x1D63,
 },
 [0x1D64]={
  category="ll",
  description="LATIN SUBSCRIPT SMALL LETTER U",
  direction="l",
  linebreak="al",
  specials={ "sub", 0x0075 },
  unicodeslot=0x1D64,
 },
 [0x1D65]={
  category="ll",
  description="LATIN SUBSCRIPT SMALL LETTER V",
  direction="l",
  linebreak="al",
  specials={ "sub", 0x0076 },
  unicodeslot=0x1D65,
 },
 [0x1D66]={
  category="ll",
  description="GREEK SUBSCRIPT SMALL LETTER BETA",
  direction="l",
  linebreak="al",
  specials={ "sub", 0x03B2 },
  unicodeslot=0x1D66,
 },
 [0x1D67]={
  category="ll",
  description="GREEK SUBSCRIPT SMALL LETTER GAMMA",
  direction="l",
  linebreak="al",
  specials={ "sub", 0x03B3 },
  unicodeslot=0x1D67,
 },
 [0x1D68]={
  category="ll",
  description="GREEK SUBSCRIPT SMALL LETTER RHO",
  direction="l",
  linebreak="al",
  specials={ "sub", 0x03C1 },
  unicodeslot=0x1D68,
 },
 [0x1D69]={
  category="ll",
  description="GREEK SUBSCRIPT SMALL LETTER PHI",
  direction="l",
  linebreak="al",
  specials={ "sub", 0x03C6 },
  unicodeslot=0x1D69,
 },
 [0x1D6A]={
  category="ll",
  description="GREEK SUBSCRIPT SMALL LETTER CHI",
  direction="l",
  linebreak="al",
  specials={ "sub", 0x03C7 },
  unicodeslot=0x1D6A,
 },
 [0x1D6B]={
  category="ll",
  description="LATIN SMALL LETTER UE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D6B,
 },
 [0x1D6C]={
  category="ll",
  description="LATIN SMALL LETTER B WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0062,
  unicodeslot=0x1D6C,
 },
 [0x1D6D]={
  category="ll",
  description="LATIN SMALL LETTER D WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  unicodeslot=0x1D6D,
 },
 [0x1D6E]={
  category="ll",
  description="LATIN SMALL LETTER F WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0066,
  unicodeslot=0x1D6E,
 },
 [0x1D6F]={
  category="ll",
  description="LATIN SMALL LETTER M WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x006D,
  unicodeslot=0x1D6F,
 },
 [0x1D70]={
  category="ll",
  description="LATIN SMALL LETTER N WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  unicodeslot=0x1D70,
 },
 [0x1D71]={
  category="ll",
  description="LATIN SMALL LETTER P WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0070,
  unicodeslot=0x1D71,
 },
 [0x1D72]={
  category="ll",
  description="LATIN SMALL LETTER R WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  unicodeslot=0x1D72,
 },
 [0x1D73]={
  category="ll",
  description="LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  unicodeslot=0x1D73,
 },
 [0x1D74]={
  category="ll",
  description="LATIN SMALL LETTER S WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0073,
  unicodeslot=0x1D74,
 },
 [0x1D75]={
  category="ll",
  description="LATIN SMALL LETTER T WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x0074,
  unicodeslot=0x1D75,
 },
 [0x1D76]={
  category="ll",
  description="LATIN SMALL LETTER Z WITH MIDDLE TILDE",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  unicodeslot=0x1D76,
 },
 [0x1D77]={
  category="ll",
  description="LATIN SMALL LETTER TURNED G",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D77,
 },
 [0x1D78]={
  category="lm",
  description="MODIFIER LETTER CYRILLIC EN",
  direction="l",
  linebreak="al",
  specials={ "super", 0x043D },
  unicodeslot=0x1D78,
 },
 [0x1D79]={
  category="ll",
  description="LATIN SMALL LETTER INSULAR G",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D79,
 },
 [0x1D7A]={
  category="ll",
  description="LATIN SMALL LETTER TH WITH STRIKETHROUGH",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D7A,
 },
 [0x1D7B]={
  category="ll",
  description="LATIN SMALL CAPITAL LETTER I WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D7B,
 },
 [0x1D7C]={
  category="ll",
  description="LATIN SMALL LETTER IOTA WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0269,
  unicodeslot=0x1D7C,
 },
 [0x1D7D]={
  category="ll",
  description="LATIN SMALL LETTER P WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x0070,
  uccode=0x2C63,
  unicodeslot=0x1D7D,
 },
 [0x1D7E]={
  category="ll",
  description="LATIN SMALL CAPITAL LETTER U WITH STROKE",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D7E,
 },
 [0x1D7F]={
  category="ll",
  description="LATIN SMALL LETTER UPSILON WITH STROKE",
  direction="l",
  linebreak="al",
  shcode=0x028A,
  unicodeslot=0x1D7F,
 },
 [0x1D80]={
  category="ll",
  description="LATIN SMALL LETTER B WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0062,
  unicodeslot=0x1D80,
 },
 [0x1D81]={
  category="ll",
  description="LATIN SMALL LETTER D WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  unicodeslot=0x1D81,
 },
 [0x1D82]={
  category="ll",
  description="LATIN SMALL LETTER F WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0066,
  unicodeslot=0x1D82,
 },
 [0x1D83]={
  category="ll",
  description="LATIN SMALL LETTER G WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  unicodeslot=0x1D83,
 },
 [0x1D84]={
  category="ll",
  description="LATIN SMALL LETTER K WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x006B,
  unicodeslot=0x1D84,
 },
 [0x1D85]={
  category="ll",
  description="LATIN SMALL LETTER L WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  unicodeslot=0x1D85,
 },
 [0x1D86]={
  category="ll",
  description="LATIN SMALL LETTER M WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x006D,
  unicodeslot=0x1D86,
 },
 [0x1D87]={
  category="ll",
  description="LATIN SMALL LETTER N WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x006E,
  unicodeslot=0x1D87,
 },
 [0x1D88]={
  category="ll",
  description="LATIN SMALL LETTER P WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0070,
  unicodeslot=0x1D88,
 },
 [0x1D89]={
  category="ll",
  description="LATIN SMALL LETTER R WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0072,
  unicodeslot=0x1D89,
 },
 [0x1D8A]={
  category="ll",
  description="LATIN SMALL LETTER S WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0073,
  unicodeslot=0x1D8A,
 },
 [0x1D8B]={
  category="ll",
  description="LATIN SMALL LETTER ESH WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0283,
  unicodeslot=0x1D8B,
 },
 [0x1D8C]={
  category="ll",
  description="LATIN SMALL LETTER V WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0076,
  unicodeslot=0x1D8C,
 },
 [0x1D8D]={
  category="ll",
  description="LATIN SMALL LETTER X WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0078,
  unicodeslot=0x1D8D,
 },
 [0x1D8E]={
  category="ll",
  description="LATIN SMALL LETTER Z WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  shcode=0x007A,
  unicodeslot=0x1D8E,
 },
 [0x1D8F]={
  category="ll",
  description="LATIN SMALL LETTER A WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  unicodeslot=0x1D8F,
 },
 [0x1D90]={
  category="ll",
  description="LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0251,
  unicodeslot=0x1D90,
 },
 [0x1D91]={
  category="ll",
  description="LATIN SMALL LETTER D WITH HOOK AND TAIL",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  unicodeslot=0x1D91,
 },
 [0x1D92]={
  category="ll",
  description="LATIN SMALL LETTER E WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  unicodeslot=0x1D92,
 },
 [0x1D93]={
  category="ll",
  description="LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D93,
 },
 [0x1D94]={
  category="ll",
  description="LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D94,
 },
 [0x1D95]={
  category="ll",
  description="LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0259,
  unicodeslot=0x1D95,
 },
 [0x1D96]={
  category="ll",
  description="LATIN SMALL LETTER I WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  unicodeslot=0x1D96,
 },
 [0x1D97]={
  category="ll",
  description="LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  unicodeslot=0x1D97,
 },
 [0x1D98]={
  category="ll",
  description="LATIN SMALL LETTER ESH WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0283,
  unicodeslot=0x1D98,
 },
 [0x1D99]={
  category="ll",
  description="LATIN SMALL LETTER U WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0075,
  unicodeslot=0x1D99,
 },
 [0x1D9A]={
  category="ll",
  description="LATIN SMALL LETTER EZH WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  shcode=0x0292,
  unicodeslot=0x1D9A,
 },
 [0x1D9B]={
  category="lm",
  description="MODIFIER LETTER SMALL TURNED ALPHA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0252 },
  unicodeslot=0x1D9B,
 },
 [0x1D9C]={
  category="lm",
  description="MODIFIER LETTER SMALL C",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0063 },
  unicodeslot=0x1D9C,
 },
 [0x1D9D]={
  category="lm",
  description="MODIFIER LETTER SMALL C WITH CURL",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0255 },
  unicodeslot=0x1D9D,
 },
 [0x1D9E]={
  category="lm",
  description="MODIFIER LETTER SMALL ETH",
  direction="l",
  linebreak="al",
  specials={ "super", 0x00F0 },
  unicodeslot=0x1D9E,
 },
 [0x1D9F]={
  category="lm",
  description="MODIFIER LETTER SMALL REVERSED OPEN E",
  direction="l",
  linebreak="al",
  specials={ "super", 0x025C },
  unicodeslot=0x1D9F,
 },
 [0x1DA0]={
  category="lm",
  description="MODIFIER LETTER SMALL F",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0066 },
  unicodeslot=0x1DA0,
 },
 [0x1DA1]={
  category="lm",
  description="MODIFIER LETTER SMALL DOTLESS J WITH STROKE",
  direction="l",
  linebreak="al",
  specials={ "super", 0x025F },
  unicodeslot=0x1DA1,
 },
 [0x1DA2]={
  category="lm",
  description="MODIFIER LETTER SMALL SCRIPT G",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0261 },
  unicodeslot=0x1DA2,
 },
 [0x1DA3]={
  category="lm",
  description="MODIFIER LETTER SMALL TURNED H",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0265 },
  unicodeslot=0x1DA3,
 },
 [0x1DA4]={
  category="lm",
  description="MODIFIER LETTER SMALL I WITH STROKE",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0268 },
  unicodeslot=0x1DA4,
 },
 [0x1DA5]={
  category="lm",
  description="MODIFIER LETTER SMALL IOTA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0269 },
  unicodeslot=0x1DA5,
 },
 [0x1DA6]={
  category="lm",
  description="MODIFIER LETTER SMALL CAPITAL I",
  direction="l",
  linebreak="al",
  specials={ "super", 0x026A },
  unicodeslot=0x1DA6,
 },
 [0x1DA7]={
  category="lm",
  description="MODIFIER LETTER SMALL CAPITAL I WITH STROKE",
  direction="l",
  linebreak="al",
  specials={ "super", 0x1D7B },
  unicodeslot=0x1DA7,
 },
 [0x1DA8]={
  category="lm",
  description="MODIFIER LETTER SMALL J WITH CROSSED-TAIL",
  direction="l",
  linebreak="al",
  specials={ "super", 0x029D },
  unicodeslot=0x1DA8,
 },
 [0x1DA9]={
  category="lm",
  description="MODIFIER LETTER SMALL L WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x026D },
  unicodeslot=0x1DA9,
 },
 [0x1DAA]={
  category="lm",
  description="MODIFIER LETTER SMALL L WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x1D85 },
  unicodeslot=0x1DAA,
 },
 [0x1DAB]={
  category="lm",
  description="MODIFIER LETTER SMALL CAPITAL L",
  direction="l",
  linebreak="al",
  specials={ "super", 0x029F },
  unicodeslot=0x1DAB,
 },
 [0x1DAC]={
  category="lm",
  description="MODIFIER LETTER SMALL M WITH HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0271 },
  unicodeslot=0x1DAC,
 },
 [0x1DAD]={
  category="lm",
  description="MODIFIER LETTER SMALL TURNED M WITH LONG LEG",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0270 },
  unicodeslot=0x1DAD,
 },
 [0x1DAE]={
  category="lm",
  description="MODIFIER LETTER SMALL N WITH LEFT HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0272 },
  unicodeslot=0x1DAE,
 },
 [0x1DAF]={
  category="lm",
  description="MODIFIER LETTER SMALL N WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0273 },
  unicodeslot=0x1DAF,
 },
 [0x1DB0]={
  category="lm",
  description="MODIFIER LETTER SMALL CAPITAL N",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0274 },
  unicodeslot=0x1DB0,
 },
 [0x1DB1]={
  category="lm",
  description="MODIFIER LETTER SMALL BARRED O",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0275 },
  unicodeslot=0x1DB1,
 },
 [0x1DB2]={
  category="lm",
  description="MODIFIER LETTER SMALL PHI",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0278 },
  unicodeslot=0x1DB2,
 },
 [0x1DB3]={
  category="lm",
  description="MODIFIER LETTER SMALL S WITH HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0282 },
  unicodeslot=0x1DB3,
 },
 [0x1DB4]={
  category="lm",
  description="MODIFIER LETTER SMALL ESH",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0283 },
  unicodeslot=0x1DB4,
 },
 [0x1DB5]={
  category="lm",
  description="MODIFIER LETTER SMALL T WITH PALATAL HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x01AB },
  unicodeslot=0x1DB5,
 },
 [0x1DB6]={
  category="lm",
  description="MODIFIER LETTER SMALL U BAR",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0289 },
  unicodeslot=0x1DB6,
 },
 [0x1DB7]={
  category="lm",
  description="MODIFIER LETTER SMALL UPSILON",
  direction="l",
  linebreak="al",
  specials={ "super", 0x028A },
  unicodeslot=0x1DB7,
 },
 [0x1DB8]={
  category="lm",
  description="MODIFIER LETTER SMALL CAPITAL U",
  direction="l",
  linebreak="al",
  specials={ "super", 0x1D1C },
  unicodeslot=0x1DB8,
 },
 [0x1DB9]={
  category="lm",
  description="MODIFIER LETTER SMALL V WITH HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x028B },
  unicodeslot=0x1DB9,
 },
 [0x1DBA]={
  category="lm",
  description="MODIFIER LETTER SMALL TURNED V",
  direction="l",
  linebreak="al",
  specials={ "super", 0x028C },
  unicodeslot=0x1DBA,
 },
 [0x1DBB]={
  category="lm",
  description="MODIFIER LETTER SMALL Z",
  direction="l",
  linebreak="al",
  specials={ "super", 0x007A },
  unicodeslot=0x1DBB,
 },
 [0x1DBC]={
  category="lm",
  description="MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0290 },
  unicodeslot=0x1DBC,
 },
 [0x1DBD]={
  category="lm",
  description="MODIFIER LETTER SMALL Z WITH CURL",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0291 },
  unicodeslot=0x1DBD,
 },
 [0x1DBE]={
  category="lm",
  description="MODIFIER LETTER SMALL EZH",
  direction="l",
  linebreak="al",
  specials={ "super", 0x0292 },
  unicodeslot=0x1DBE,
 },
 [0x1DBF]={
  category="lm",
  description="MODIFIER LETTER SMALL THETA",
  direction="l",
  linebreak="al",
  specials={ "super", 0x03B8 },
  unicodeslot=0x1DBF,
 },
 [0x1DC0]={
  category="mn",
  description="COMBINING DOTTED GRAVE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC0,
 },
 [0x1DC1]={
  category="mn",
  description="COMBINING DOTTED ACUTE ACCENT",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC1,
 },
 [0x1DC2]={
  category="mn",
  description="COMBINING SNAKE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC2,
 },
 [0x1DC3]={
  category="mn",
  description="COMBINING SUSPENSION MARK",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC3,
 },
 [0x1DC4]={
  category="mn",
  description="COMBINING MACRON-ACUTE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC4,
 },
 [0x1DC5]={
  category="mn",
  description="COMBINING GRAVE-MACRON",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC5,
 },
 [0x1DC6]={
  category="mn",
  description="COMBINING MACRON-GRAVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC6,
 },
 [0x1DC7]={
  category="mn",
  description="COMBINING ACUTE-MACRON",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC7,
 },
 [0x1DC8]={
  category="mn",
  description="COMBINING GRAVE-ACUTE-GRAVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC8,
 },
 [0x1DC9]={
  category="mn",
  description="COMBINING ACUTE-GRAVE-ACUTE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DC9,
 },
 [0x1DCA]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER R BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DCA,
 },
 [0x1DCB]={
  category="mn",
  description="COMBINING BREVE-MACRON",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DCB,
 },
 [0x1DCC]={
  category="mn",
  description="COMBINING MACRON-BREVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DCC,
 },
 [0x1DCD]={
  category="mn",
  description="COMBINING DOUBLE CIRCUMFLEX ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DCD,
 },
 [0x1DCE]={
  category="mn",
  description="COMBINING OGONEK ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DCE,
 },
 [0x1DCF]={
  category="mn",
  description="COMBINING ZIGZAG BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DCF,
 },
 [0x1DD0]={
  category="mn",
  description="COMBINING IS BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD0,
 },
 [0x1DD1]={
  category="mn",
  description="COMBINING UR ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD1,
 },
 [0x1DD2]={
  category="mn",
  description="COMBINING US ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD2,
 },
 [0x1DD3]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD3,
 },
 [0x1DD4]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER AE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD4,
 },
 [0x1DD5]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER AO",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD5,
 },
 [0x1DD6]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER AV",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD6,
 },
 [0x1DD7]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER C CEDILLA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD7,
 },
 [0x1DD8]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER INSULAR D",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD8,
 },
 [0x1DD9]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER ETH",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DD9,
 },
 [0x1DDA]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER G",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DDA,
 },
 [0x1DDB]={
  category="mn",
  description="COMBINING LATIN LETTER SMALL CAPITAL G",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DDB,
 },
 [0x1DDC]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER K",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DDC,
 },
 [0x1DDD]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DDD,
 },
 [0x1DDE]={
  category="mn",
  description="COMBINING LATIN LETTER SMALL CAPITAL L",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DDE,
 },
 [0x1DDF]={
  category="mn",
  description="COMBINING LATIN LETTER SMALL CAPITAL M",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DDF,
 },
 [0x1DE0]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER N",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DE0,
 },
 [0x1DE1]={
  category="mn",
  description="COMBINING LATIN LETTER SMALL CAPITAL N",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DE1,
 },
 [0x1DE2]={
  category="mn",
  description="COMBINING LATIN LETTER SMALL CAPITAL R",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DE2,
 },
 [0x1DE3]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER R ROTUNDA",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DE3,
 },
 [0x1DE4]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER S",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DE4,
 },
 [0x1DE5]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER LONG S",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DE5,
 },
 [0x1DE6]={
  category="mn",
  description="COMBINING LATIN SMALL LETTER Z",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DE6,
 },
 [0x1DFC]={
  category="mn",
  description="COMBINING DOUBLE INVERTED BREVE BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DFC,
 },
 [0x1DFD]={
  category="mn",
  description="COMBINING ALMOST EQUAL TO BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DFD,
 },
 [0x1DFE]={
  category="mn",
  description="COMBINING LEFT ARROWHEAD ABOVE",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DFE,
 },
 [0x1DFF]={
  category="mn",
  description="COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW",
  direction="nsm",
  linebreak="cm",
  unicodeslot=0x1DFF,
 },
 [0x1E00]={
  adobename="Aringbelow",
  category="lu",
  description="LATIN CAPITAL LETTER A WITH RING BELOW",
  direction="l",
  lccode=0x1E01,
  linebreak="al",
  shcode=0x0041,
  specials={ "char", 0x0041, 0x0325 },
  unicodeslot=0x1E00,
 },
 [0x1E01]={
  adobename="aringbelow",
  category="ll",
  description="LATIN SMALL LETTER A WITH RING BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0061,
  specials={ "char", 0x0061, 0x0325 },
  uccode=0x1E00,
  unicodeslot=0x1E01,
 },
 [0x1E02]={
  adobename="Bdotaccent",
  category="lu",
  description="LATIN CAPITAL LETTER B WITH DOT ABOVE",
  direction="l",
  lccode=0x1E03,
  linebreak="al",
  shcode=0x0042,
  specials={ "char", 0x0042, 0x0307 },
  unicodeslot=0x1E02,
 },
 [0x1E03]={
  adobename="bdotaccent",
  category="ll",
  description="LATIN SMALL LETTER B WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0062,
  specials={ "char", 0x0062, 0x0307 },
  uccode=0x1E02,
  unicodeslot=0x1E03,
 },
 [0x1E04]={
  adobename="Bdotbelow",
  category="lu",
  description="LATIN CAPITAL LETTER B WITH DOT BELOW",
  direction="l",
  lccode=0x1E05,
  linebreak="al",
  shcode=0x0042,
  specials={ "char", 0x0042, 0x0323 },
  unicodeslot=0x1E04,
 },
 [0x1E05]={
  adobename="bdotbelow",
  category="ll",
  description="LATIN SMALL LETTER B WITH DOT BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0062,
  specials={ "char", 0x0062, 0x0323 },
  uccode=0x1E04,
  unicodeslot=0x1E05,
 },
 [0x1E06]={
  adobename="Blinebelow",
  category="lu",
  description="LATIN CAPITAL LETTER B WITH LINE BELOW",
  direction="l",
  lccode=0x1E07,
  linebreak="al",
  shcode=0x0042,
  specials={ "char", 0x0042, 0x0331 },
  unicodeslot=0x1E06,
 },
 [0x1E07]={
  adobename="blinebelow",
  category="ll",
  description="LATIN SMALL LETTER B WITH LINE BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0062,
  specials={ "char", 0x0062, 0x0331 },
  uccode=0x1E06,
  unicodeslot=0x1E07,
 },
 [0x1E08]={
  adobename="Ccedillaacute",
  category="lu",
  description="LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE",
  direction="l",
  lccode=0x1E09,
  linebreak="al",
  shcode=0x0043,
  specials={ "char", 0x00C7, 0x0301 },
  unicodeslot=0x1E08,
 },
 [0x1E09]={
  adobename="ccedillaacute",
  category="ll",
  description="LATIN SMALL LETTER C WITH CEDILLA AND ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0063,
  specials={ "char", 0x00E7, 0x0301 },
  uccode=0x1E08,
  unicodeslot=0x1E09,
 },
 [0x1E0A]={
  adobename="Ddotaccent",
  category="lu",
  description="LATIN CAPITAL LETTER D WITH DOT ABOVE",
  direction="l",
  lccode=0x1E0B,
  linebreak="al",
  shcode=0x0044,
  specials={ "char", 0x0044, 0x0307 },
  unicodeslot=0x1E0A,
 },
 [0x1E0B]={
  adobename="ddotaccent",
  category="ll",
  description="LATIN SMALL LETTER D WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  specials={ "char", 0x0064, 0x0307 },
  uccode=0x1E0A,
  unicodeslot=0x1E0B,
 },
 [0x1E0C]={
  adobename="Ddotbelow",
  category="lu",
  description="LATIN CAPITAL LETTER D WITH DOT BELOW",
  direction="l",
  lccode=0x1E0D,
  linebreak="al",
  shcode=0x0044,
  specials={ "char", 0x0044, 0x0323 },
  unicodeslot=0x1E0C,
 },
 [0x1E0D]={
  adobename="ddotbelow",
  category="ll",
  description="LATIN SMALL LETTER D WITH DOT BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  specials={ "char", 0x0064, 0x0323 },
  uccode=0x1E0C,
  unicodeslot=0x1E0D,
 },
 [0x1E0E]={
  adobename="Dlinebelow",
  category="lu",
  description="LATIN CAPITAL LETTER D WITH LINE BELOW",
  direction="l",
  lccode=0x1E0F,
  linebreak="al",
  shcode=0x0044,
  specials={ "char", 0x0044, 0x0331 },
  unicodeslot=0x1E0E,
 },
 [0x1E0F]={
  adobename="dlinebelow",
  category="ll",
  description="LATIN SMALL LETTER D WITH LINE BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  specials={ "char", 0x0064, 0x0331 },
  uccode=0x1E0E,
  unicodeslot=0x1E0F,
 },
 [0x1E10]={
  adobename="Dcedilla",
  category="lu",
  description="LATIN CAPITAL LETTER D WITH CEDILLA",
  direction="l",
  lccode=0x1E11,
  linebreak="al",
  shcode=0x0044,
  specials={ "char", 0x0044, 0x0327 },
  unicodeslot=0x1E10,
 },
 [0x1E11]={
  adobename="dcedilla",
  category="ll",
  description="LATIN SMALL LETTER D WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  specials={ "char", 0x0064, 0x0327 },
  uccode=0x1E10,
  unicodeslot=0x1E11,
 },
 [0x1E12]={
  adobename="Dcircumflexbelow",
  category="lu",
  description="LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW",
  direction="l",
  lccode=0x1E13,
  linebreak="al",
  shcode=0x0044,
  specials={ "char", 0x0044, 0x032D },
  unicodeslot=0x1E12,
 },
 [0x1E13]={
  adobename="dcircumflexbelow",
  category="ll",
  description="LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0064,
  specials={ "char", 0x0064, 0x032D },
  uccode=0x1E12,
  unicodeslot=0x1E13,
 },
 [0x1E14]={
  adobename="Emacrongrave",
  category="lu",
  description="LATIN CAPITAL LETTER E WITH MACRON AND GRAVE",
  direction="l",
  lccode=0x1E15,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0112, 0x0300 },
  unicodeslot=0x1E14,
 },
 [0x1E15]={
  adobename="emacrongrave",
  category="ll",
  description="LATIN SMALL LETTER E WITH MACRON AND GRAVE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0113, 0x0300 },
  uccode=0x1E14,
  unicodeslot=0x1E15,
 },
 [0x1E16]={
  adobename="Emacronacute",
  category="lu",
  description="LATIN CAPITAL LETTER E WITH MACRON AND ACUTE",
  direction="l",
  lccode=0x1E17,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0112, 0x0301 },
  unicodeslot=0x1E16,
 },
 [0x1E17]={
  adobename="emacronacute",
  category="ll",
  description="LATIN SMALL LETTER E WITH MACRON AND ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0113, 0x0301 },
  uccode=0x1E16,
  unicodeslot=0x1E17,
 },
 [0x1E18]={
  adobename="Ecircumflexbelow",
  category="lu",
  description="LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW",
  direction="l",
  lccode=0x1E19,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x032D },
  unicodeslot=0x1E18,
 },
 [0x1E19]={
  adobename="ecircumflexbelow",
  category="ll",
  description="LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x032D },
  uccode=0x1E18,
  unicodeslot=0x1E19,
 },
 [0x1E1A]={
  adobename="Etildebelow",
  category="lu",
  description="LATIN CAPITAL LETTER E WITH TILDE BELOW",
  direction="l",
  lccode=0x1E1B,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0045, 0x0330 },
  unicodeslot=0x1E1A,
 },
 [0x1E1B]={
  adobename="etildebelow",
  category="ll",
  description="LATIN SMALL LETTER E WITH TILDE BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0065, 0x0330 },
  uccode=0x1E1A,
  unicodeslot=0x1E1B,
 },
 [0x1E1C]={
  adobename="Ecedillabreve",
  category="lu",
  description="LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE",
  direction="l",
  lccode=0x1E1D,
  linebreak="al",
  shcode=0x0045,
  specials={ "char", 0x0228, 0x0306 },
  unicodeslot=0x1E1C,
 },
 [0x1E1D]={
  adobename="ecedillabreve",
  category="ll",
  description="LATIN SMALL LETTER E WITH CEDILLA AND BREVE",
  direction="l",
  linebreak="al",
  shcode=0x0065,
  specials={ "char", 0x0229, 0x0306 },
  uccode=0x1E1C,
  unicodeslot=0x1E1D,
 },
 [0x1E1E]={
  adobename="Fdotaccent",
  category="lu",
  description="LATIN CAPITAL LETTER F WITH DOT ABOVE",
  direction="l",
  lccode=0x1E1F,
  linebreak="al",
  shcode=0x0046,
  specials={ "char", 0x0046, 0x0307 },
  unicodeslot=0x1E1E,
 },
 [0x1E1F]={
  adobename="fdotaccent",
  category="ll",
  description="LATIN SMALL LETTER F WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0066,
  specials={ "char", 0x0066, 0x0307 },
  uccode=0x1E1E,
  unicodeslot=0x1E1F,
 },
 [0x1E20]={
  adobename="Gmacron",
  category="lu",
  description="LATIN CAPITAL LETTER G WITH MACRON",
  direction="l",
  lccode=0x1E21,
  linebreak="al",
  shcode=0x0047,
  specials={ "char", 0x0047, 0x0304 },
  unicodeslot=0x1E20,
 },
 [0x1E21]={
  adobename="gmacron",
  category="ll",
  description="LATIN SMALL LETTER G WITH MACRON",
  direction="l",
  linebreak="al",
  shcode=0x0067,
  specials={ "char", 0x0067, 0x0304 },
  uccode=0x1E20,
  unicodeslot=0x1E21,
 },
 [0x1E22]={
  adobename="Hdotaccent",
  category="lu",
  description="LATIN CAPITAL LETTER H WITH DOT ABOVE",
  direction="l",
  lccode=0x1E23,
  linebreak="al",
  shcode=0x0048,
  specials={ "char", 0x0048, 0x0307 },
  unicodeslot=0x1E22,
 },
 [0x1E23]={
  adobename="hdotaccent",
  category="ll",
  description="LATIN SMALL LETTER H WITH DOT ABOVE",
  direction="l",
  linebreak="al",
  shcode=0x0068,
  specials={ "char", 0x0068, 0x0307 },
  uccode=0x1E22,
  unicodeslot=0x1E23,
 },
 [0x1E24]={
  adobename="Hdotbelow",
  category="lu",
  description="LATIN CAPITAL LETTER H WITH DOT BELOW",
  direction="l",
  lccode=0x1E25,
  linebreak="al",
  shcode=0x0048,
  specials={ "char", 0x0048, 0x0323 },
  unicodeslot=0x1E24,
 },
 [0x1E25]={
  adobename="hdotbelow",
  category="ll",
  description="LATIN SMALL LETTER H WITH DOT BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0068,
  specials={ "char", 0x0068, 0x0323 },
  uccode=0x1E24,
  unicodeslot=0x1E25,
 },
 [0x1E26]={
  adobename="Hdieresis",
  category="lu",
  description="LATIN CAPITAL LETTER H WITH DIAERESIS",
  direction="l",
  lccode=0x1E27,
  linebreak="al",
  shcode=0x0048,
  specials={ "char", 0x0048, 0x0308 },
  unicodeslot=0x1E26,
 },
 [0x1E27]={
  adobename="hdieresis",
  category="ll",
  description="LATIN SMALL LETTER H WITH DIAERESIS",
  direction="l",
  linebreak="al",
  shcode=0x0068,
  specials={ "char", 0x0068, 0x0308 },
  uccode=0x1E26,
  unicodeslot=0x1E27,
 },
 [0x1E28]={
  adobename="Hcedilla",
  category="lu",
  description="LATIN CAPITAL LETTER H WITH CEDILLA",
  direction="l",
  lccode=0x1E29,
  linebreak="al",
  shcode=0x0048,
  specials={ "char", 0x0048, 0x0327 },
  unicodeslot=0x1E28,
 },
 [0x1E29]={
  adobename="hcedilla",
  category="ll",
  description="LATIN SMALL LETTER H WITH CEDILLA",
  direction="l",
  linebreak="al",
  shcode=0x0068,
  specials={ "char", 0x0068, 0x0327 },
  uccode=0x1E28,
  unicodeslot=0x1E29,
 },
 [0x1E2A]={
  adobename="Hbrevebelow",
  category="lu",
  description="LATIN CAPITAL LETTER H WITH BREVE BELOW",
  direction="l",
  lccode=0x1E2B,
  linebreak="al",
  shcode=0x0048,
  specials={ "char", 0x0048, 0x032E },
  unicodeslot=0x1E2A,
 },
 [0x1E2B]={
  adobename="hbrevebelow",
  category="ll",
  description="LATIN SMALL LETTER H WITH BREVE BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0068,
  specials={ "char", 0x0068, 0x032E },
  uccode=0x1E2A,
  unicodeslot=0x1E2B,
 },
 [0x1E2C]={
  adobename="Itildebelow",
  category="lu",
  description="LATIN CAPITAL LETTER I WITH TILDE BELOW",
  direction="l",
  lccode=0x1E2D,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x0049, 0x0330 },
  unicodeslot=0x1E2C,
 },
 [0x1E2D]={
  adobename="itildebelow",
  category="ll",
  description="LATIN SMALL LETTER I WITH TILDE BELOW",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x0069, 0x0330 },
  uccode=0x1E2C,
  unicodeslot=0x1E2D,
 },
 [0x1E2E]={
  adobename="Idieresisacute",
  category="lu",
  description="LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE",
  direction="l",
  lccode=0x1E2F,
  linebreak="al",
  shcode=0x0049,
  specials={ "char", 0x00CF, 0x0301 },
  unicodeslot=0x1E2E,
 },
 [0x1E2F]={
  adobename="idieresisacute",
  category="ll",
  description="LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x0069,
  specials={ "char", 0x00EF, 0x0301 },
  uccode=0x1E2E,
  unicodeslot=0x1E2F,
 },
 [0x1E30]={
  adobename="Kacute",
  category="lu",
  description="LATIN CAPITAL LETTER K WITH ACUTE",
  direction="l",
  lccode=0x1E31,
  linebreak="al",
  shcode=0x004B,
  specials={ "char", 0x004B, 0x0301 },
  unicodeslot=0x1E30,
 },
 [0x1E31]={
  adobename="kacute",
  category="ll",
  description="LATIN SMALL LETTER K WITH ACUTE",
  direction="l",
  linebreak="al",
  shcode=0x006B,
  specials={ "char", 0x006B, 0x0301 },
  uccode=0x1E30,
  unicodeslot=0x1E31,
 },
 [0x1E32]={
  adobename="Kdotbelow",
  category="lu",
  description="LATIN CAPITAL LETTER K WITH DOT BELOW",
  direction="l",
  lccode=0x1E33,
  linebreak="al",
  shcode=0x004B,
  specials={ "char", 0x004B, 0x0323 },
  unicodeslot=0x1E32,
 },
 [0x1E33]={
  adobename="kdotbelow",
  category="ll",
  description="LATIN SMALL LETTER K WITH DOT BELOW",
  direction="l",
  linebreak="al",
  shcode=0x006B,
  specials={ "char", 0x006B, 0x0323 },
  uccode=0x1E32,
  unicodeslot=0x1E33,
 },
 [0x1E34]={
  adobename="Klinebelow",
  category="lu",
  description="LATIN CAPITAL LETTER K WITH LINE BELOW",
  direction="l",
  lccode=0x1E35,
  linebreak="al",
  shcode=0x004B,
  specials={ "char", 0x004B, 0x0331 },
  unicodeslot=0x1E34,
 },
 [0x1E35]={
  adobename="klinebelow",
  category="ll",
  description="LATIN SMALL LETTER K WITH LINE BELOW",
  direction="l",
  linebreak="al",
  shcode=0x006B,
  specials={ "char", 0x006B, 0x0331 },
  uccode=0x1E34,
  unicodeslot=0x1E35,
 },
 [0x1E36]={
  adobename="Ldotbelow",
  category="lu",
  description="LATIN CAPITAL LETTER L WITH DOT BELOW",
  direction="l",
  lccode=0x1E37,
  linebreak="al",
  shcode=0x004C,
  specials={ "char", 0x004C, 0x0323 },
  unicodeslot=0x1E36,
 },
 [0x1E37]={
  adobename="ldotbelow",
  category="ll",
  description="LATIN SMALL LETTER L WITH DOT BELOW",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  specials={ "char", 0x006C, 0x0323 },
  uccode=0x1E36,
  unicodeslot=0x1E37,
 },
 [0x1E38]={
  adobename="Ldotbelowmacron",
  category="lu",
  description="LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON",
  direction="l",
  lccode=0x1E39,
  linebreak="al",
  shcode=0x004C,
  specials={ "char", 0x1E36, 0x0304 },
  unicodeslot=0x1E38,
 },
 [0x1E39]={
  adobename="ldotbelowmacron",
  category="ll",
  description="LATIN SMALL LETTER L WITH DOT BELOW AND MACRON",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  specials={ "char", 0x1E37, 0x0304 },
  uccode=0x1E38,
  unicodeslot=0x1E39,
 },
 [0x1E3A]={
  adobename="Llinebelow",
  category="lu",
  description="LATIN CAPITAL LETTER L WITH LINE BELOW",
  direction="l",
  lccode=0x1E3B,
  linebreak="al",
  shcode=0x004C,
  specials={ "char", 0x004C, 0x0331 },
  unicodeslot=0x1E3A,
 },
 [0x1E3B]={
  adobename="llinebelow",
  category="ll",
  description="LATIN SMALL LETTER L WITH LINE BELOW",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  specials={ "char", 0x006C, 0x0331 },
  uccode=0x1E3A,
  unicodeslot=0x1E3B,
 },
 [0x1E3C]={
  adobename="Lcircumflexbelow",
  category="lu",
  description="LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW",
  direction="l",
  lccode=0x1E3D,
  linebreak="al",
  shcode=0x004C,
  specials={ "char", 0x004C, 0x032D },
  unicodeslot=0x1E3C,
 },
 [0x1E3D]={
  adobename="lcircumflexbelow",
  category="ll",
  description="LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW",
  direction="l",
  linebreak="al",
  shcode=0x006C,
  specials={ "char", 0x006C, 0x032D },
  uccode=0x1E3C,
  unicodeslot=0x1E3D,
 },
 [0x1E3E]={
  adobename="Macute",
  category="lu",
  description="LATIN CAPITAL LETTER M WITH ACUTE",
  direction="l",
  lccode=0x1E3F,
  linebreak="al",
  shcode=0x004D,
  specials={ "char", 0x004D, 0x0301 },
  unicodeslot=