/*
 * Copyright 2013 Canonical Ltd.
 * Copyright 2022 UBports Foundation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

pragma Singleton

import QtQml 2.12
import QtQuick 2.12
import Lomiri.Content 1.3 as LomiriContent

Item {
    readonly property var finishedImports: LomiriContent.ContentHub.finishedImports
    readonly property var hasPending: LomiriContent.ContentHub.hasPending

    function restoreImports() {
        return LomiriContent.ContentHub.restoreImports();
    }

    function importContent(...args) {
        return LomiriContent.ContentHub.importContent(...args);
    }

    function exportContent(...args) {
        return LomiriContent.ContentHub.exportContent(...args);
    }

    function shareContent(...args) {
        return LomiriContent.ContentHub.shareContent(...args);
    }

    signal importRequested(LomiriContent.ContentTransfer transfer)
    signal exportRequested(LomiriContent.ContentTransfer transfer)
    signal shareRequested(LomiriContent.ContentTransfer transfer)

    Connections {
        target: LomiriContent.ContentHub

        onImportRequested: importRequested(transfer)
        onExportRequested: exportRequested(transfer)
        onShareRequested: shareRequested(transfer)
    }

    LoggingCategory {
        id: lcDeprecation
        name: "lomiri.deprecations"
        defaultLogLevel: LoggingCategory.Warning
    }

    Component.onCompleted: {
        console.debug(lcDeprecation,
            "Ubuntu.Content is deprecated and is provided for compatibility. " +
            "Please use Lomiri.Content when possible"
        );
    }
}
