/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/

// qt specific
#include <qpopmenu.h>
// kde specific
#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>
// menu specific
#include "lazyfillmenu.h"
#include "immenufiller.h"

static const int IMBaseId = 1000;

void IMMenuFiller::createEntry( const KABC::Addressee Contact, QPopupMenu *Menu )
{
    const QString IMAddress = Contact.custom( "KADDRESSBOOK" , "X-IMAddress" );
    if( !IMAddress.isEmpty() )
    {
        LazyFillMenu *SubMenu = new LazyFillMenu( new IMMenuFiller(Contact.uid()), true, Menu );
        Menu->insertItem( SmallIconSet("chat"), i18n("&Instant messaging"), SubMenu  );
    }
}


IMMenuFiller::IMMenuFiller( const QString U )
: UID( U ), IMProxy( ::KIMProxy::instance(KApplication::dcopClient()) )
{
}


void IMMenuFiller::fill( QPopupMenu *Menu )
{
    bool Success = IMProxy->initialize();

    connect( Menu, SIGNAL(activated(int)), this, SLOT(browse(int)) );

    int id = Menu->insertItem( Success ? IMProxy->presenceIcon(UID):QPixmap(),
                               Success ? protectAmpersand(IMProxy->presenceString(UID)):i18n("No instant messaging program available."),
                               IMBaseId );

    if( !Success || !IMProxy->isPresent(UID) )
        Menu->setItemEnabled( id, false );
}


void IMMenuFiller::browse( int id )
{
    if( id >= IMBaseId )
    {
        IMProxy->chatWithContact( UID );
    }
}

#include "immenufiller.moc"
