/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
//#include <qmap.h>
// kde specific
#include <kapplication.h>
#include <kiconloader.h>
// menu specific
#include "addresseelistspan.h"
#include "contactsmenu.h"



//static QStringList getCategories( const KABC::AddresseeList &Addresses );


ContactsMenu::ContactsMenu( QWidget *Parent, const char *Name, const QStringList &/*args*/ )
  : KPanelMenu( Parent, Name ), Filler()
{
    AddressBook *Book = StdAddressBook::self();

    // TODO: make sure slotClear can be also called if the menu is open...
    connect( Book, SIGNAL( addressBookChanged(AddressBook*) ),
             this, SLOT  ( slotClear() ) );
}


void ContactsMenu::initialize()
{
    insertItem( SmallIconSet("kaddressbook"), i18n("Address book"),
                this, SLOT(launchAddressbook()) );

    insertSeparator();

    AddressBook *Book = StdAddressBook::self();

    AddressList = Book->allAddressees();
    AddressList.sortBy( KABC::FormattedName );

    if( AddressList.isEmpty() )
    {
        int id = insertItem( i18n("No Entries"), 0 );
        setItemEnabled( id, false );
    }
    else
    {
        Filler.fill( this, AddressList );
    }

    setInitialized( true );
}


void ContactsMenu::slotClear()
{

    KPanelMenu::slotClear();
    Filler.clear();
    AddressList.clear();
}


void ContactsMenu::slotExec( int /*id*/ )
{
}

void ContactsMenu::launchAddressbook()
{
    KApplication::startServiceByDesktopName( "kaddressbook", QStringList(), 0, 0, 0, "", true );
}

// TODO: Eintrag editieren, anrufen, anschreiben, anchatten, etc...


/*
static QStringList getCategories( const KABC::AddresseeList &AddressList )
{
    // the result list
    typedef QMap<QString,int> NameList;
    NameList AllCategoriesMap;

    KABC::AddresseeList::ConstIterator ALIt = AddressList.begin();
    KABC::AddresseeList::ConstIterator ALEnd = AddressList.end();

    // get the categories of all contacts
    for ( ; ALIt != ALEnd; ++ALIt )
    {
        const QStringList Categories( (*ALIt).categories() );
        QStringList::ConstIterator end = Categories.end();

        for ( QStringList::ConstIterator it = Categories.begin(); it != end; ++it )
            AllCategoriesMap.insert( *it, 0 );
    }

    QStringList AllCategories( AllCategoriesMap.keys() );
    AllCategories.sort();

    return AllCategories;
}
*/

ContactsMenu::~ContactsMenu()
{
  // disconnect from addressbook changes
  disconnect( this, SLOT( slotClear() ) );
}

#include "contactsmenu.moc"
