// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: proto/pbservice/service.proto

package pbservice

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	github_com_hashicorp_consul_agent_structs "github.com/hashicorp/consul/agent/structs"
	pbcommon "github.com/hashicorp/consul/proto/pbcommon"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// ConnectProxyConfig describes the configuration needed for any proxy managed
// or unmanaged. It describes a single logical service's listener and optionally
// upstreams and sidecar-related config for a single instance. To describe a
// centralized proxy that routed traffic for multiple services, a different one
// of these would be needed for each, sharing the same LogicalProxyID.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ConnectProxyConfig
// output=service.gen.go
// name=Structs
type ConnectProxyConfig struct {
	// DestinationServiceName is required and is the name of the service to accept
	// traffic for.
	DestinationServiceName string `protobuf:"bytes,1,opt,name=DestinationServiceName,proto3" json:"DestinationServiceName,omitempty"`
	// DestinationServiceID is optional and should only be specified for
	// "side-car" style proxies where the proxy is in front of just a single
	// instance of the service. It should be set to the service ID of the instance
	// being represented which must be registered to the same agent. It's valid to
	// provide a service ID that does not yet exist to avoid timing issues when
	// bootstrapping a service with a proxy.
	DestinationServiceID string `protobuf:"bytes,2,opt,name=DestinationServiceID,proto3" json:"DestinationServiceID,omitempty"`
	// LocalServiceAddress is the address of the local service instance. It is
	// optional and should only be specified for "side-car" style proxies. It will
	// default to 127.0.0.1 if the proxy is a "side-car" (DestinationServiceID is
	// set) but otherwise will be ignored.
	LocalServiceAddress string `protobuf:"bytes,3,opt,name=LocalServiceAddress,proto3" json:"LocalServiceAddress,omitempty"`
	// LocalServicePort is the port of the local service instance. It is optional
	// and should only be specified for "side-car" style proxies. It will default
	// to the registered port for the instance if the proxy is a "side-car"
	// (DestinationServiceID is set) but otherwise will be ignored.
	// mog: func-to=int func-from=int32
	LocalServicePort int32 `protobuf:"varint,4,opt,name=LocalServicePort,proto3" json:"LocalServicePort,omitempty"`
	// Config is the arbitrary configuration data provided with the proxy
	// registration.
	// mog: func-to=ProtobufTypesStructToMapStringInterface func-from=MapStringInterfaceToProtobufTypesStruct
	Config *types.Struct `protobuf:"bytes,5,opt,name=Config,proto3" json:"Config,omitempty"`
	// Upstreams describes any upstream dependencies the proxy instance should
	// setup.
	// mog: func-to=UpstreamsToStructs func-from=NewUpstreamsFromStructs
	Upstreams []Upstream `protobuf:"bytes,6,rep,name=Upstreams,proto3" json:"Upstreams"`
	// MeshGateway defines the mesh gateway configuration for this upstream
	MeshGateway MeshGatewayConfig `protobuf:"bytes,7,opt,name=MeshGateway,proto3" json:"MeshGateway"`
	// Expose defines whether checks or paths are exposed through the proxy
	Expose ExposeConfig `protobuf:"bytes,8,opt,name=Expose,proto3" json:"Expose"`
}

func (m *ConnectProxyConfig) Reset()         { *m = ConnectProxyConfig{} }
func (m *ConnectProxyConfig) String() string { return proto.CompactTextString(m) }
func (*ConnectProxyConfig) ProtoMessage()    {}
func (*ConnectProxyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cbb99233b75fb80b, []int{0}
}
func (m *ConnectProxyConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectProxyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectProxyConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectProxyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectProxyConfig.Merge(m, src)
}
func (m *ConnectProxyConfig) XXX_Size() int {
	return m.Size()
}
func (m *ConnectProxyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectProxyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectProxyConfig proto.InternalMessageInfo

// Upstream represents a single upstream dependency for a service or proxy. It
// describes the mechanism used to discover instances to communicate with (the
// Target) as well as any potential client configuration that may be useful such
// as load balancer options, timeouts etc.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.Upstream
// output=service.gen.go
// name=Structs
// ignore-fields=IngressHosts
type Upstream struct {
	// Destination fields are the required ones for determining what this upstream
	// points to. Depending on DestinationType some other fields below might
	// further restrict the set of instances allowable.
	//
	// DestinationType would be better as an int constant but even with custom
	// JSON marshallers it causes havoc with all the mapstructure mangling we do
	// on service definitions in various places.
	DestinationType      string `protobuf:"bytes,1,opt,name=DestinationType,proto3" json:"DestinationType,omitempty"`
	DestinationNamespace string `protobuf:"bytes,2,opt,name=DestinationNamespace,proto3" json:"DestinationNamespace,omitempty"`
	DestinationName      string `protobuf:"bytes,3,opt,name=DestinationName,proto3" json:"DestinationName,omitempty"`
	// Datacenter that the service discovery request should be run against. Note
	// for prepared queries, the actual results might be from a different
	// datacenter.
	Datacenter string `protobuf:"bytes,4,opt,name=Datacenter,proto3" json:"Datacenter,omitempty"`
	// LocalBindAddress is the ip address a side-car proxy should listen on for
	// traffic destined for this upstream service. Default if empty is 127.0.0.1.
	LocalBindAddress string `protobuf:"bytes,5,opt,name=LocalBindAddress,proto3" json:"LocalBindAddress,omitempty"`
	// LocalBindPort is the ip address a side-car proxy should listen on for
	// traffic destined for this upstream service. Required.
	// mog: func-to=int func-from=int32
	LocalBindPort int32 `protobuf:"varint,6,opt,name=LocalBindPort,proto3" json:"LocalBindPort,omitempty"`
	// Config is an opaque config that is specific to the proxy process being run.
	// It can be used to pass arbitrary configuration for this specific upstream
	// to the proxy.
	// mog: func-to=ProtobufTypesStructToMapStringInterface func-from=MapStringInterfaceToProtobufTypesStruct
	Config *types.Struct `protobuf:"bytes,7,opt,name=Config,proto3" json:"Config,omitempty"`
	// MeshGateway is the configuration for mesh gateway usage of this upstream
	MeshGateway MeshGatewayConfig `protobuf:"bytes,8,opt,name=MeshGateway,proto3" json:"MeshGateway"`
}

func (m *Upstream) Reset()         { *m = Upstream{} }
func (m *Upstream) String() string { return proto.CompactTextString(m) }
func (*Upstream) ProtoMessage()    {}
func (*Upstream) Descriptor() ([]byte, []int) {
	return fileDescriptor_cbb99233b75fb80b, []int{1}
}
func (m *Upstream) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Upstream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Upstream.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Upstream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Upstream.Merge(m, src)
}
func (m *Upstream) XXX_Size() int {
	return m.Size()
}
func (m *Upstream) XXX_DiscardUnknown() {
	xxx_messageInfo_Upstream.DiscardUnknown(m)
}

var xxx_messageInfo_Upstream proto.InternalMessageInfo

// ServiceConnect are the shared Connect settings between all service
// definitions from the agent to the state store.
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceConnect
// output=service.gen.go
// name=Structs
type ServiceConnect struct {
	// Native is true when this service can natively understand Connect.
	Native bool `protobuf:"varint,1,opt,name=Native,proto3" json:"Native,omitempty"`
	// SidecarService is a nested Service Definition to register at the same time.
	// It's purely a convenience mechanism to allow specifying a sidecar service
	// along with the application service definition. It's nested nature allows
	// all of the fields to be defaulted which can reduce the amount of
	// boilerplate needed to register a sidecar service separately, but the end
	// result is identical to just making a second service registration via any
	// other means.
	// mog: func-to=ServiceDefinitionPtrToStructs func-from=NewServiceDefinitionPtrFromStructs
	SidecarService *ServiceDefinition `protobuf:"bytes,3,opt,name=SidecarService,proto3" json:"SidecarService,omitempty"`
}

func (m *ServiceConnect) Reset()         { *m = ServiceConnect{} }
func (m *ServiceConnect) String() string { return proto.CompactTextString(m) }
func (*ServiceConnect) ProtoMessage()    {}
func (*ServiceConnect) Descriptor() ([]byte, []int) {
	return fileDescriptor_cbb99233b75fb80b, []int{2}
}
func (m *ServiceConnect) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceConnect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceConnect.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceConnect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceConnect.Merge(m, src)
}
func (m *ServiceConnect) XXX_Size() int {
	return m.Size()
}
func (m *ServiceConnect) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceConnect.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceConnect proto.InternalMessageInfo

// ExposeConfig describes HTTP paths to expose through Envoy outside of Connect.
// Users can expose individual paths and/or all HTTP/GRPC paths for checks.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ExposeConfig
// output=service.gen.go
// name=Structs
type ExposeConfig struct {
	// Checks defines whether paths associated with Consul checks will be exposed.
	// This flag triggers exposing all HTTP and GRPC check paths registered for the service.
	Checks bool `protobuf:"varint,1,opt,name=Checks,proto3" json:"Checks,omitempty"`
	// Paths is the list of paths exposed through the proxy.
	// mog: func-to=ExposePathSliceToStructs func-from=NewExposePathSliceFromStructs
	Paths []ExposePath `protobuf:"bytes,2,rep,name=Paths,proto3" json:"Paths"`
}

func (m *ExposeConfig) Reset()         { *m = ExposeConfig{} }
func (m *ExposeConfig) String() string { return proto.CompactTextString(m) }
func (*ExposeConfig) ProtoMessage()    {}
func (*ExposeConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cbb99233b75fb80b, []int{3}
}
func (m *ExposeConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExposeConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExposeConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExposeConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExposeConfig.Merge(m, src)
}
func (m *ExposeConfig) XXX_Size() int {
	return m.Size()
}
func (m *ExposeConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExposeConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExposeConfig proto.InternalMessageInfo

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ExposePath
// output=service.gen.go
// name=Structs
type ExposePath struct {
	// ListenerPort defines the port of the proxy's listener for exposed paths.
	// mog: func-to=int func-from=int32
	ListenerPort int32 `protobuf:"varint,1,opt,name=ListenerPort,proto3" json:"ListenerPort,omitempty"`
	// ExposePath is the path to expose through the proxy, ie. "/metrics."
	Path string `protobuf:"bytes,2,opt,name=Path,proto3" json:"Path,omitempty"`
	// LocalPathPort is the port that the service is listening on for the given path.
	// mog: func-to=int func-from=int32
	LocalPathPort int32 `protobuf:"varint,3,opt,name=LocalPathPort,proto3" json:"LocalPathPort,omitempty"`
	// Protocol describes the upstream's service protocol.
	// Valid values are "http" and "http2", defaults to "http"
	Protocol string `protobuf:"bytes,4,opt,name=Protocol,proto3" json:"Protocol,omitempty"`
	// ParsedFromCheck is set if this path was parsed from a registered check
	ParsedFromCheck bool `protobuf:"varint,5,opt,name=ParsedFromCheck,proto3" json:"ParsedFromCheck,omitempty"`
}

func (m *ExposePath) Reset()         { *m = ExposePath{} }
func (m *ExposePath) String() string { return proto.CompactTextString(m) }
func (*ExposePath) ProtoMessage()    {}
func (*ExposePath) Descriptor() ([]byte, []int) {
	return fileDescriptor_cbb99233b75fb80b, []int{4}
}
func (m *ExposePath) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExposePath) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExposePath.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExposePath) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExposePath.Merge(m, src)
}
func (m *ExposePath) XXX_Size() int {
	return m.Size()
}
func (m *ExposePath) XXX_DiscardUnknown() {
	xxx_messageInfo_ExposePath.DiscardUnknown(m)
}

var xxx_messageInfo_ExposePath proto.InternalMessageInfo

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.MeshGatewayConfig
// output=service.gen.go
// name=Structs
type MeshGatewayConfig struct {
	Mode github_com_hashicorp_consul_agent_structs.MeshGatewayMode `protobuf:"bytes,1,opt,name=Mode,proto3,casttype=github.com/hashicorp/consul/agent/structs.MeshGatewayMode" json:"Mode,omitempty"`
}

func (m *MeshGatewayConfig) Reset()         { *m = MeshGatewayConfig{} }
func (m *MeshGatewayConfig) String() string { return proto.CompactTextString(m) }
func (*MeshGatewayConfig) ProtoMessage()    {}
func (*MeshGatewayConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cbb99233b75fb80b, []int{5}
}
func (m *MeshGatewayConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MeshGatewayConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MeshGatewayConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MeshGatewayConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MeshGatewayConfig.Merge(m, src)
}
func (m *MeshGatewayConfig) XXX_Size() int {
	return m.Size()
}
func (m *MeshGatewayConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MeshGatewayConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MeshGatewayConfig proto.InternalMessageInfo

// ServiceDefinition is used to JSON decode the Service definitions. For
// documentation on specific fields see NodeService which is better documented.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceDefinition
// output=service.gen.go
// name=Structs
type ServiceDefinition struct {
	Kind    github_com_hashicorp_consul_agent_structs.ServiceKind `protobuf:"bytes,1,opt,name=Kind,proto3,casttype=github.com/hashicorp/consul/agent/structs.ServiceKind" json:"Kind,omitempty"`
	ID      string                                                `protobuf:"bytes,2,opt,name=ID,proto3" json:"ID,omitempty"`
	Name    string                                                `protobuf:"bytes,3,opt,name=Name,proto3" json:"Name,omitempty"`
	Tags    []string                                              `protobuf:"bytes,4,rep,name=Tags,proto3" json:"Tags,omitempty"`
	Address string                                                `protobuf:"bytes,5,opt,name=Address,proto3" json:"Address,omitempty"`
	// mog: func-to=MapStringServiceAddressToStructs func-from=NewMapStringServiceAddressFromStructs
	TaggedAddresses map[string]ServiceAddress `protobuf:"bytes,16,rep,name=TaggedAddresses,proto3" json:"TaggedAddresses" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Meta            map[string]string         `protobuf:"bytes,6,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// mog: func-to=int func-from=int32
	Port  int32     `protobuf:"varint,7,opt,name=Port,proto3" json:"Port,omitempty"`
	Check CheckType `protobuf:"bytes,8,opt,name=Check,proto3" json:"Check"`
	// mog: func-to=CheckTypesToStructs func-from=NewCheckTypesFromStructs
	Checks []*CheckType `protobuf:"bytes,9,rep,name=Checks,proto3" json:"Checks,omitempty"`
	// mog: func-to=WeightsPtrToStructs func-from=NewWeightsPtrFromStructs
	Weights           *Weights `protobuf:"bytes,10,opt,name=Weights,proto3" json:"Weights,omitempty"`
	Token             string   `protobuf:"bytes,11,opt,name=Token,proto3" json:"Token,omitempty"`
	EnableTagOverride bool     `protobuf:"varint,12,opt,name=EnableTagOverride,proto3" json:"EnableTagOverride,omitempty"`
	// Proxy is the configuration set for Kind = connect-proxy. It is mandatory in
	// that case and an error to be set for any other kind. This config is part of
	// a proxy service definition and is distinct from but shares some fields with
	// the Connect.Proxy which configures a managed proxy as part of the actual
	// service's definition. This duplication is ugly but seemed better than the
	// alternative which was to re-use the same struct fields for both cases even
	// though the semantics are different and the non-shared fields make no sense
	// in the other case. ProxyConfig may be a more natural name here, but it's
	// confusing for the UX because one of the fields in ConnectProxyConfig is
	// also called just "Config"
	// mog: func-to=ConnectProxyConfigPtrToStructs func-from=NewConnectProxyConfigPtrFromStructs
	Proxy *ConnectProxyConfig `protobuf:"bytes,14,opt,name=Proxy,proto3" json:"Proxy,omitempty"`
	// mog: func-to=EnterpriseMetaToStructs func-from=NewEnterpriseMetaFromStructs
	EnterpriseMeta pbcommon.EnterpriseMeta `protobuf:"bytes,17,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta"`
	// mog: func-to=ServiceConnectPtrToStructs func-from=NewServiceConnectPtrFromStructs
	Connect *ServiceConnect `protobuf:"bytes,15,opt,name=Connect,proto3" json:"Connect,omitempty"`
}

func (m *ServiceDefinition) Reset()         { *m = ServiceDefinition{} }
func (m *ServiceDefinition) String() string { return proto.CompactTextString(m) }
func (*ServiceDefinition) ProtoMessage()    {}
func (*ServiceDefinition) Descriptor() ([]byte, []int) {
	return fileDescriptor_cbb99233b75fb80b, []int{6}
}
func (m *ServiceDefinition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceDefinition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceDefinition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceDefinition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceDefinition.Merge(m, src)
}
func (m *ServiceDefinition) XXX_Size() int {
	return m.Size()
}
func (m *ServiceDefinition) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceDefinition.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceDefinition proto.InternalMessageInfo

// Type to hold an address and port of a service
type ServiceAddress struct {
	Address string `protobuf:"bytes,1,opt,name=Address,proto3" json:"Address,omitempty"`
	// mog: func-to=int func-from=int32
	Port int32 `protobuf:"varint,2,opt,name=Port,proto3" json:"Port,omitempty"`
}

func (m *ServiceAddress) Reset()         { *m = ServiceAddress{} }
func (m *ServiceAddress) String() string { return proto.CompactTextString(m) }
func (*ServiceAddress) ProtoMessage()    {}
func (*ServiceAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_cbb99233b75fb80b, []int{7}
}
func (m *ServiceAddress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceAddress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAddress.Merge(m, src)
}
func (m *ServiceAddress) XXX_Size() int {
	return m.Size()
}
func (m *ServiceAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAddress.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAddress proto.InternalMessageInfo

// Weights represent the weight used by DNS for a given status
type Weights struct {
	// mog: func-to=int func-from=int32
	Passing int32 `protobuf:"varint,1,opt,name=Passing,proto3" json:"Passing,omitempty"`
	// mog: func-to=int func-from=int32
	Warning int32 `protobuf:"varint,2,opt,name=Warning,proto3" json:"Warning,omitempty"`
}

func (m *Weights) Reset()         { *m = Weights{} }
func (m *Weights) String() string { return proto.CompactTextString(m) }
func (*Weights) ProtoMessage()    {}
func (*Weights) Descriptor() ([]byte, []int) {
	return fileDescriptor_cbb99233b75fb80b, []int{8}
}
func (m *Weights) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Weights) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Weights.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Weights) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Weights.Merge(m, src)
}
func (m *Weights) XXX_Size() int {
	return m.Size()
}
func (m *Weights) XXX_DiscardUnknown() {
	xxx_messageInfo_Weights.DiscardUnknown(m)
}

var xxx_messageInfo_Weights proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ConnectProxyConfig)(nil), "pbservice.ConnectProxyConfig")
	proto.RegisterType((*Upstream)(nil), "pbservice.Upstream")
	proto.RegisterType((*ServiceConnect)(nil), "pbservice.ServiceConnect")
	proto.RegisterType((*ExposeConfig)(nil), "pbservice.ExposeConfig")
	proto.RegisterType((*ExposePath)(nil), "pbservice.ExposePath")
	proto.RegisterType((*MeshGatewayConfig)(nil), "pbservice.MeshGatewayConfig")
	proto.RegisterType((*ServiceDefinition)(nil), "pbservice.ServiceDefinition")
	proto.RegisterMapType((map[string]string)(nil), "pbservice.ServiceDefinition.MetaEntry")
	proto.RegisterMapType((map[string]ServiceAddress)(nil), "pbservice.ServiceDefinition.TaggedAddressesEntry")
	proto.RegisterType((*ServiceAddress)(nil), "pbservice.ServiceAddress")
	proto.RegisterType((*Weights)(nil), "pbservice.Weights")
}

func init() { proto.RegisterFile("proto/pbservice/service.proto", fileDescriptor_cbb99233b75fb80b) }

var fileDescriptor_cbb99233b75fb80b = []byte{
	// 1048 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xf6, 0xfa, 0x27, 0xb6, 0x4f, 0x42, 0x7e, 0xa6, 0x26, 0x2c, 0xa1, 0x75, 0xcc, 0x0a, 0x21,
	0x0b, 0x22, 0xbb, 0x4d, 0x54, 0x4a, 0x2b, 0x15, 0x89, 0xc4, 0x01, 0x55, 0xd4, 0xc5, 0x6c, 0x8c,
	0x2a, 0x90, 0xb8, 0x18, 0xaf, 0x27, 0xeb, 0x55, 0xec, 0x1d, 0x6b, 0x67, 0x1c, 0xea, 0xcb, 0xbe,
	0x01, 0x97, 0x3c, 0x06, 0x8f, 0x11, 0x89, 0x9b, 0x5e, 0x72, 0x15, 0x41, 0xf2, 0x16, 0xbd, 0x42,
	0x73, 0x76, 0x76, 0xb3, 0xde, 0x35, 0x11, 0x70, 0xe5, 0x99, 0xf3, 0x9d, 0xf3, 0x9d, 0xdd, 0xf3,
	0x7d, 0x33, 0x6b, 0xb8, 0x37, 0x0d, 0xb8, 0xe4, 0xed, 0xe9, 0x40, 0xb0, 0xe0, 0xdc, 0x73, 0x58,
	0x5b, 0xff, 0xb6, 0x30, 0x4e, 0xaa, 0x31, 0xb0, 0x73, 0xd7, 0xe5, 0xdc, 0x1d, 0xb3, 0x36, 0x02,
	0x83, 0xd9, 0x69, 0x5b, 0xc8, 0x60, 0xe6, 0xc8, 0x30, 0x71, 0xe7, 0x83, 0x88, 0xc7, 0xe1, 0x93,
	0x09, 0xf7, 0xdb, 0xe1, 0x8f, 0x06, 0x3f, 0x4c, 0x37, 0x19, 0x31, 0x3a, 0x96, 0x23, 0x67, 0xc4,
	0x9c, 0x33, 0x9d, 0x52, 0x73, 0xb9, 0xcb, 0xc3, 0x34, 0xb5, 0x0a, 0xa3, 0xd6, 0xef, 0x05, 0x20,
	0x47, 0xdc, 0xf7, 0x99, 0x23, 0x7b, 0x01, 0x7f, 0x35, 0x3f, 0xe2, 0xfe, 0xa9, 0xe7, 0x92, 0xcf,
	0x60, 0xbb, 0xc3, 0x84, 0xf4, 0x7c, 0x2a, 0x3d, 0xee, 0x9f, 0x84, 0xa4, 0x2f, 0xe8, 0x84, 0x99,
	0x46, 0xc3, 0x68, 0x56, 0xed, 0x7f, 0x40, 0xc9, 0x3e, 0xd4, 0xb2, 0xc8, 0xb3, 0x8e, 0x99, 0xc7,
	0xaa, 0xa5, 0x18, 0xb9, 0x0f, 0x77, 0x9e, 0x73, 0x87, 0x8e, 0x75, 0xe4, 0xcb, 0xe1, 0x30, 0x60,
	0x42, 0x98, 0x05, 0x2c, 0x59, 0x06, 0x91, 0x4f, 0x60, 0x33, 0x19, 0xee, 0xf1, 0x40, 0x9a, 0xc5,
	0x86, 0xd1, 0x2c, 0xd9, 0x99, 0x38, 0x79, 0x08, 0x2b, 0xe1, 0x3b, 0x99, 0xa5, 0x86, 0xd1, 0x5c,
	0xdd, 0x7f, 0xaf, 0x15, 0x4e, 0xb9, 0x15, 0x4d, 0xb9, 0x75, 0x82, 0x53, 0x3e, 0x2c, 0x5e, 0x5c,
	0xee, 0x1a, 0xb6, 0x4e, 0x26, 0x8f, 0xa0, 0xfa, 0xfd, 0x54, 0xc8, 0x80, 0xd1, 0x89, 0x30, 0x57,
	0x1a, 0x85, 0xe6, 0xea, 0xfe, 0x9d, 0x56, 0x3c, 0xde, 0x56, 0x84, 0x61, 0x55, 0xce, 0xbe, 0xc9,
	0x25, 0x1d, 0x58, 0xed, 0x32, 0x31, 0xfa, 0x9a, 0x4a, 0xf6, 0x33, 0x9d, 0x9b, 0x65, 0x6c, 0x7a,
	0x37, 0x51, 0x9a, 0x40, 0xc3, 0x5e, 0x9a, 0x23, 0x59, 0xa6, 0x9e, 0xfa, 0xf8, 0xd5, 0x94, 0x0b,
	0x66, 0x56, 0xf4, 0x53, 0xdf, 0x10, 0x84, 0xc0, 0x42, 0xad, 0x4e, 0xb6, 0x5e, 0x17, 0xa0, 0x12,
	0x3d, 0x0a, 0x69, 0xc2, 0x46, 0x62, 0xde, 0xfd, 0xf9, 0x34, 0x12, 0x2f, 0x1d, 0x4e, 0xa9, 0xa6,
	0x84, 0x14, 0x53, 0xea, 0xb0, 0x25, 0xaa, 0xc5, 0x58, 0x8a, 0x1d, 0xad, 0x51, 0xc8, 0xb0, 0xa3,
	0x27, 0xea, 0x00, 0x1d, 0x2a, 0xa9, 0xc3, 0x7c, 0xc9, 0x02, 0xd4, 0xa9, 0x6a, 0x27, 0x22, 0xb1,
	0x9a, 0x87, 0x9e, 0x3f, 0x8c, 0xc4, 0x2f, 0x61, 0x56, 0x26, 0x4e, 0x3e, 0x82, 0x77, 0xe2, 0x18,
	0xca, 0xbe, 0x82, 0xb2, 0x2f, 0x06, 0x13, 0x9a, 0x97, 0xff, 0x8b, 0xe6, 0x29, 0xe9, 0x2a, 0xff,
	0x4b, 0x3a, 0xcb, 0x87, 0x75, 0xed, 0x3f, 0x7d, 0xae, 0xc8, 0x36, 0xac, 0xbc, 0xa0, 0xd2, 0x3b,
	0x0f, 0xe7, 0x5f, 0xb1, 0xf5, 0x8e, 0x74, 0x60, 0xfd, 0xc4, 0x1b, 0x32, 0x87, 0x06, 0xba, 0x00,
	0x27, 0xb8, 0xd8, 0x52, 0x23, 0x1d, 0x76, 0xea, 0xf9, 0x9e, 0x1a, 0xa9, 0x9d, 0xaa, 0xb1, 0x7e,
	0x80, 0xb5, 0xa4, 0x23, 0x54, 0xb7, 0x23, 0x75, 0xec, 0x45, 0xd4, 0x2d, 0xdc, 0x91, 0x07, 0x50,
	0xea, 0x51, 0x39, 0x12, 0x66, 0x1e, 0xdd, 0xfc, 0x6e, 0xc6, 0x51, 0x0a, 0xd5, 0x2f, 0x14, 0x66,
	0x5a, 0xbf, 0x19, 0x00, 0x37, 0x18, 0xb1, 0x60, 0xed, 0xb9, 0x27, 0x24, 0xf3, 0x59, 0x80, 0xb3,
	0x37, 0x70, 0xf6, 0x0b, 0x31, 0x42, 0xa0, 0xa8, 0x72, 0xb5, 0x75, 0x70, 0x1d, 0x8b, 0xa6, 0x36,
	0x58, 0x58, 0x48, 0x88, 0x16, 0x05, 0xc9, 0x0e, 0x54, 0x7a, 0x4a, 0x1e, 0x87, 0x8f, 0xb5, 0x49,
	0xe2, 0xbd, 0x32, 0x5b, 0x8f, 0x06, 0x82, 0x0d, 0xbf, 0x0a, 0xf8, 0x04, 0xdf, 0x07, 0x1d, 0x52,
	0xb1, 0xd3, 0x61, 0xeb, 0x14, 0xb6, 0x32, 0x2a, 0x91, 0xef, 0xa0, 0xd8, 0xe5, 0x43, 0x6d, 0xff,
	0xc3, 0xa7, 0x6f, 0x2f, 0x77, 0x1f, 0xbb, 0x9e, 0x1c, 0xcd, 0x06, 0x2d, 0x87, 0x4f, 0xda, 0x23,
	0x2a, 0x46, 0x9e, 0xc3, 0x83, 0x69, 0xdb, 0xe1, 0xbe, 0x98, 0x8d, 0xdb, 0xd4, 0x65, 0xbe, 0xd4,
	0x97, 0xaf, 0x48, 0x8a, 0xae, 0x48, 0x6c, 0xa4, 0xb2, 0x5e, 0x97, 0x61, 0x2b, 0xa3, 0x0d, 0xe9,
	0x42, 0xf1, 0x1b, 0xcf, 0x1f, 0xea, 0x46, 0x8f, 0xdf, 0x5e, 0xee, 0x3e, 0xfc, 0xf7, 0x8d, 0x34,
	0x9d, 0x22, 0xb0, 0x91, 0x86, 0xac, 0x43, 0x3e, 0xbe, 0x3b, 0xf3, 0xcf, 0x3a, 0x6a, 0xb8, 0x89,
	0x83, 0x86, 0x6b, 0x15, 0xeb, 0x53, 0x57, 0x98, 0xc5, 0x46, 0x41, 0xc5, 0xd4, 0x9a, 0x98, 0x50,
	0x5e, 0x3c, 0x48, 0xd1, 0x96, 0x50, 0xd8, 0xe8, 0x53, 0xd7, 0x65, 0xd1, 0x81, 0x62, 0xc2, 0xdc,
	0x44, 0x3b, 0x3c, 0xb8, 0xcd, 0x73, 0xad, 0x54, 0xcd, 0xb1, 0x2f, 0x83, 0xb9, 0xb6, 0x4a, 0x9a,
	0x8f, 0x3c, 0x81, 0x62, 0x97, 0x49, 0xaa, 0x2f, 0xcd, 0x8f, 0x6f, 0xe5, 0x55, 0x89, 0x48, 0x66,
	0x63, 0x0d, 0xba, 0x47, 0x19, 0xa4, 0x8c, 0x06, 0xc1, 0x35, 0xb9, 0x0f, 0xa5, 0x50, 0xf1, 0xf0,
	0x3c, 0xd6, 0x12, 0x84, 0x18, 0x57, 0x37, 0x58, 0x64, 0x5b, 0x0c, 0x90, 0xbd, 0xf8, 0x04, 0x54,
	0xf1, 0x19, 0x96, 0x96, 0xc4, 0xe7, 0x62, 0x0f, 0xca, 0x2f, 0x99, 0xe7, 0x8e, 0xa4, 0x30, 0x01,
	0x3b, 0x90, 0x44, 0xba, 0x46, 0xec, 0x28, 0x85, 0xd4, 0xa0, 0xd4, 0xe7, 0x67, 0xcc, 0x37, 0x57,
	0x71, 0xb0, 0xe1, 0x86, 0xec, 0xc1, 0xd6, 0xb1, 0x4f, 0x07, 0x63, 0xd6, 0xa7, 0xee, 0xb7, 0xe7,
	0x2c, 0x08, 0xbc, 0x21, 0x33, 0xd7, 0xd0, 0xa1, 0x59, 0x80, 0x1c, 0x40, 0x09, 0xbf, 0xb5, 0xe6,
	0x3a, 0xf6, 0xbb, 0x97, 0x7c, 0xbc, 0xcc, 0xa7, 0xd8, 0x0e, 0x73, 0xd5, 0x65, 0x71, 0xac, 0xae,
	0xcb, 0x69, 0xe0, 0x09, 0x86, 0x03, 0xde, 0xc2, 0xea, 0xed, 0x96, 0xfe, 0x23, 0xb0, 0x88, 0xea,
	0x89, 0xa4, 0x6a, 0xc8, 0x01, 0x94, 0x75, 0x0b, 0x73, 0x03, 0xcb, 0xdf, 0xcf, 0xea, 0xa3, 0x13,
	0xec, 0x28, 0x73, 0xe7, 0x27, 0xa8, 0x2d, 0x33, 0x00, 0xd9, 0x84, 0xc2, 0x19, 0x9b, 0xeb, 0x8f,
	0x8a, 0x5a, 0x92, 0x36, 0x94, 0xce, 0xe9, 0x78, 0x16, 0x7e, 0x39, 0x96, 0x92, 0x6b, 0x0a, 0x3b,
	0xcc, 0x7b, 0x92, 0xff, 0xdc, 0xd8, 0x79, 0x04, 0xd5, 0xd8, 0x07, 0x4b, 0x38, 0x6b, 0x49, 0xce,
	0x6a, 0xa2, 0xd0, 0xfa, 0x22, 0xbe, 0x69, 0x23, 0x7b, 0x27, 0x8c, 0x6f, 0x2c, 0x1a, 0x3f, 0x72,
	0x56, 0xfe, 0xc6, 0x59, 0xd6, 0xd3, 0x58, 0x79, 0x55, 0xd8, 0xa3, 0x42, 0x78, 0xbe, 0xab, 0x6f,
	0xb5, 0x68, 0xab, 0x90, 0x97, 0x34, 0xf0, 0x15, 0x12, 0xd6, 0x46, 0xdb, 0xc3, 0xee, 0xc5, 0x5f,
	0xf5, 0xdc, 0xc5, 0x55, 0xdd, 0x78, 0x73, 0x55, 0x37, 0xfe, 0xbc, 0xaa, 0x1b, 0xbf, 0x5c, 0xd7,
	0x73, 0xbf, 0x5e, 0xd7, 0x73, 0x6f, 0xae, 0xeb, 0xb9, 0x3f, 0xae, 0xeb, 0xb9, 0x1f, 0x3f, 0xbd,
	0xed, 0xf0, 0xa7, 0xfe, 0xb1, 0x0d, 0x56, 0x30, 0x70, 0xf0, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x62, 0x98, 0x42, 0xf5, 0x30, 0x0a, 0x00, 0x00,
}

func (m *ConnectProxyConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectProxyConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectProxyConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Expose.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintService(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	{
		size, err := m.MeshGateway.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintService(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x3a
	if len(m.Upstreams) > 0 {
		for iNdEx := len(m.Upstreams) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Upstreams[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.LocalServicePort != 0 {
		i = encodeVarintService(dAtA, i, uint64(m.LocalServicePort))
		i--
		dAtA[i] = 0x20
	}
	if len(m.LocalServiceAddress) > 0 {
		i -= len(m.LocalServiceAddress)
		copy(dAtA[i:], m.LocalServiceAddress)
		i = encodeVarintService(dAtA, i, uint64(len(m.LocalServiceAddress)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DestinationServiceID) > 0 {
		i -= len(m.DestinationServiceID)
		copy(dAtA[i:], m.DestinationServiceID)
		i = encodeVarintService(dAtA, i, uint64(len(m.DestinationServiceID)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DestinationServiceName) > 0 {
		i -= len(m.DestinationServiceName)
		copy(dAtA[i:], m.DestinationServiceName)
		i = encodeVarintService(dAtA, i, uint64(len(m.DestinationServiceName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Upstream) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Upstream) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Upstream) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.MeshGateway.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintService(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.LocalBindPort != 0 {
		i = encodeVarintService(dAtA, i, uint64(m.LocalBindPort))
		i--
		dAtA[i] = 0x30
	}
	if len(m.LocalBindAddress) > 0 {
		i -= len(m.LocalBindAddress)
		copy(dAtA[i:], m.LocalBindAddress)
		i = encodeVarintService(dAtA, i, uint64(len(m.LocalBindAddress)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Datacenter) > 0 {
		i -= len(m.Datacenter)
		copy(dAtA[i:], m.Datacenter)
		i = encodeVarintService(dAtA, i, uint64(len(m.Datacenter)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.DestinationName) > 0 {
		i -= len(m.DestinationName)
		copy(dAtA[i:], m.DestinationName)
		i = encodeVarintService(dAtA, i, uint64(len(m.DestinationName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DestinationNamespace) > 0 {
		i -= len(m.DestinationNamespace)
		copy(dAtA[i:], m.DestinationNamespace)
		i = encodeVarintService(dAtA, i, uint64(len(m.DestinationNamespace)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DestinationType) > 0 {
		i -= len(m.DestinationType)
		copy(dAtA[i:], m.DestinationType)
		i = encodeVarintService(dAtA, i, uint64(len(m.DestinationType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceConnect) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceConnect) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceConnect) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SidecarService != nil {
		{
			size, err := m.SidecarService.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Native {
		i--
		if m.Native {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ExposeConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExposeConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExposeConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Paths) > 0 {
		for iNdEx := len(m.Paths) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Paths[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Checks {
		i--
		if m.Checks {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ExposePath) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExposePath) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExposePath) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ParsedFromCheck {
		i--
		if m.ParsedFromCheck {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintService(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0x22
	}
	if m.LocalPathPort != 0 {
		i = encodeVarintService(dAtA, i, uint64(m.LocalPathPort))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintService(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0x12
	}
	if m.ListenerPort != 0 {
		i = encodeVarintService(dAtA, i, uint64(m.ListenerPort))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MeshGatewayConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshGatewayConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MeshGatewayConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Mode) > 0 {
		i -= len(m.Mode)
		copy(dAtA[i:], m.Mode)
		i = encodeVarintService(dAtA, i, uint64(len(m.Mode)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceDefinition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceDefinition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceDefinition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.EnterpriseMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintService(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0x8a
	if len(m.TaggedAddresses) > 0 {
		for k := range m.TaggedAddresses {
			v := m.TaggedAddresses[k]
			baseI := i
			{
				size, err := (&v).MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x82
		}
	}
	if m.Connect != nil {
		{
			size, err := m.Connect.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	if m.Proxy != nil {
		{
			size, err := m.Proxy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if m.EnableTagOverride {
		i--
		if m.EnableTagOverride {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintService(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0x5a
	}
	if m.Weights != nil {
		{
			size, err := m.Weights.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.Checks) > 0 {
		for iNdEx := len(m.Checks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Checks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	{
		size, err := m.Check.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintService(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	if m.Port != 0 {
		i = encodeVarintService(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x38
	}
	if len(m.Meta) > 0 {
		for k := range m.Meta {
			v := m.Meta[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintService(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintService(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintService(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintService(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceAddress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceAddress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Port != 0 {
		i = encodeVarintService(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Address) > 0 {
		i -= len(m.Address)
		copy(dAtA[i:], m.Address)
		i = encodeVarintService(dAtA, i, uint64(len(m.Address)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Weights) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Weights) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Weights) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Warning != 0 {
		i = encodeVarintService(dAtA, i, uint64(m.Warning))
		i--
		dAtA[i] = 0x10
	}
	if m.Passing != 0 {
		i = encodeVarintService(dAtA, i, uint64(m.Passing))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintService(dAtA []byte, offset int, v uint64) int {
	offset -= sovService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ConnectProxyConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DestinationServiceName)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	l = len(m.DestinationServiceID)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	l = len(m.LocalServiceAddress)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.LocalServicePort != 0 {
		n += 1 + sovService(uint64(m.LocalServicePort))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovService(uint64(l))
	}
	if len(m.Upstreams) > 0 {
		for _, e := range m.Upstreams {
			l = e.Size()
			n += 1 + l + sovService(uint64(l))
		}
	}
	l = m.MeshGateway.Size()
	n += 1 + l + sovService(uint64(l))
	l = m.Expose.Size()
	n += 1 + l + sovService(uint64(l))
	return n
}

func (m *Upstream) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DestinationType)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	l = len(m.DestinationNamespace)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	l = len(m.DestinationName)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	l = len(m.Datacenter)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	l = len(m.LocalBindAddress)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.LocalBindPort != 0 {
		n += 1 + sovService(uint64(m.LocalBindPort))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovService(uint64(l))
	}
	l = m.MeshGateway.Size()
	n += 1 + l + sovService(uint64(l))
	return n
}

func (m *ServiceConnect) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Native {
		n += 2
	}
	if m.SidecarService != nil {
		l = m.SidecarService.Size()
		n += 1 + l + sovService(uint64(l))
	}
	return n
}

func (m *ExposeConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Checks {
		n += 2
	}
	if len(m.Paths) > 0 {
		for _, e := range m.Paths {
			l = e.Size()
			n += 1 + l + sovService(uint64(l))
		}
	}
	return n
}

func (m *ExposePath) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ListenerPort != 0 {
		n += 1 + sovService(uint64(m.ListenerPort))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.LocalPathPort != 0 {
		n += 1 + sovService(uint64(m.LocalPathPort))
	}
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.ParsedFromCheck {
		n += 2
	}
	return n
}

func (m *MeshGatewayConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Mode)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	return n
}

func (m *ServiceDefinition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovService(uint64(l))
		}
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if len(m.Meta) > 0 {
		for k, v := range m.Meta {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovService(uint64(len(k))) + 1 + len(v) + sovService(uint64(len(v)))
			n += mapEntrySize + 1 + sovService(uint64(mapEntrySize))
		}
	}
	if m.Port != 0 {
		n += 1 + sovService(uint64(m.Port))
	}
	l = m.Check.Size()
	n += 1 + l + sovService(uint64(l))
	if len(m.Checks) > 0 {
		for _, e := range m.Checks {
			l = e.Size()
			n += 1 + l + sovService(uint64(l))
		}
	}
	if m.Weights != nil {
		l = m.Weights.Size()
		n += 1 + l + sovService(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.EnableTagOverride {
		n += 2
	}
	if m.Proxy != nil {
		l = m.Proxy.Size()
		n += 1 + l + sovService(uint64(l))
	}
	if m.Connect != nil {
		l = m.Connect.Size()
		n += 1 + l + sovService(uint64(l))
	}
	if len(m.TaggedAddresses) > 0 {
		for k, v := range m.TaggedAddresses {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovService(uint64(len(k))) + 1 + l + sovService(uint64(l))
			n += mapEntrySize + 2 + sovService(uint64(mapEntrySize))
		}
	}
	l = m.EnterpriseMeta.Size()
	n += 2 + l + sovService(uint64(l))
	return n
}

func (m *ServiceAddress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovService(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovService(uint64(m.Port))
	}
	return n
}

func (m *Weights) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Passing != 0 {
		n += 1 + sovService(uint64(m.Passing))
	}
	if m.Warning != 0 {
		n += 1 + sovService(uint64(m.Warning))
	}
	return n
}

func sovService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozService(x uint64) (n int) {
	return sovService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ConnectProxyConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectProxyConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectProxyConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalServiceAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalServiceAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalServicePort", wireType)
			}
			m.LocalServicePort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LocalServicePort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &types.Struct{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Upstreams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Upstreams = append(m.Upstreams, Upstream{})
			if err := m.Upstreams[len(m.Upstreams)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MeshGateway", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MeshGateway.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expose", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Expose.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Upstream) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Upstream: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Upstream: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Datacenter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Datacenter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalBindAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalBindAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalBindPort", wireType)
			}
			m.LocalBindPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LocalBindPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &types.Struct{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MeshGateway", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MeshGateway.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceConnect) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceConnect: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceConnect: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Native", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Native = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SidecarService", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SidecarService == nil {
				m.SidecarService = &ServiceDefinition{}
			}
			if err := m.SidecarService.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExposeConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExposeConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExposeConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checks", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Checks = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Paths", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Paths = append(m.Paths, ExposePath{})
			if err := m.Paths[len(m.Paths)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExposePath) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExposePath: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExposePath: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenerPort", wireType)
			}
			m.ListenerPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ListenerPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalPathPort", wireType)
			}
			m.LocalPathPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LocalPathPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParsedFromCheck", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ParsedFromCheck = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshGatewayConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MeshGatewayConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MeshGatewayConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mode = github_com_hashicorp_consul_agent_structs.MeshGatewayMode(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceDefinition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceDefinition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceDefinition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = github_com_hashicorp_consul_agent_structs.ServiceKind(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Meta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Meta == nil {
				m.Meta = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Meta[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Check", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Check.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checks = append(m.Checks, &CheckType{})
			if err := m.Checks[len(m.Checks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weights", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Weights == nil {
				m.Weights = &Weights{}
			}
			if err := m.Weights.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableTagOverride", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableTagOverride = bool(v != 0)
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proxy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Proxy == nil {
				m.Proxy = &ConnectProxyConfig{}
			}
			if err := m.Proxy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connect", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Connect == nil {
				m.Connect = &ServiceConnect{}
			}
			if err := m.Connect.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaggedAddresses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaggedAddresses == nil {
				m.TaggedAddresses = make(map[string]ServiceAddress)
			}
			var mapkey string
			mapvalue := &ServiceAddress{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ServiceAddress{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TaggedAddresses[mapkey] = *mapvalue
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnterpriseMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EnterpriseMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Weights) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Weights: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Weights: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Passing", wireType)
			}
			m.Passing = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Passing |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warning", wireType)
			}
			m.Warning = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Warning |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupService = fmt.Errorf("proto: unexpected end of group")
)
