// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: proto/pbcommon/common.proto

package pbcommon

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// RaftIndex is used to track the index used while creating
// or modifying a given struct type.
type RaftIndex struct {
	CreateIndex uint64 `protobuf:"varint,1,opt,name=CreateIndex,proto3" json:"CreateIndex,omitempty" bexpr:"-"`
	ModifyIndex uint64 `protobuf:"varint,2,opt,name=ModifyIndex,proto3" json:"ModifyIndex,omitempty" bexpr:"-"`
}

func (m *RaftIndex) Reset()         { *m = RaftIndex{} }
func (m *RaftIndex) String() string { return proto.CompactTextString(m) }
func (*RaftIndex) ProtoMessage()    {}
func (*RaftIndex) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6f5ac44994d718c, []int{0}
}
func (m *RaftIndex) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RaftIndex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RaftIndex.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RaftIndex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaftIndex.Merge(m, src)
}
func (m *RaftIndex) XXX_Size() int {
	return m.Size()
}
func (m *RaftIndex) XXX_DiscardUnknown() {
	xxx_messageInfo_RaftIndex.DiscardUnknown(m)
}

var xxx_messageInfo_RaftIndex proto.InternalMessageInfo

// TargetDatacenter is intended to be used within other messages used for RPC routing
// amongst the various Consul datacenters
type TargetDatacenter struct {
	Datacenter string `protobuf:"bytes,1,opt,name=Datacenter,proto3" json:"Datacenter,omitempty"`
}

func (m *TargetDatacenter) Reset()         { *m = TargetDatacenter{} }
func (m *TargetDatacenter) String() string { return proto.CompactTextString(m) }
func (*TargetDatacenter) ProtoMessage()    {}
func (*TargetDatacenter) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6f5ac44994d718c, []int{1}
}
func (m *TargetDatacenter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TargetDatacenter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TargetDatacenter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TargetDatacenter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetDatacenter.Merge(m, src)
}
func (m *TargetDatacenter) XXX_Size() int {
	return m.Size()
}
func (m *TargetDatacenter) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetDatacenter.DiscardUnknown(m)
}

var xxx_messageInfo_TargetDatacenter proto.InternalMessageInfo

type WriteRequest struct {
	// Token is the ACL token ID. If not provided, the 'anonymous'
	// token is assumed for backwards compatibility.
	Token string `protobuf:"bytes,1,opt,name=Token,proto3" json:"Token,omitempty"`
}

func (m *WriteRequest) Reset()         { *m = WriteRequest{} }
func (m *WriteRequest) String() string { return proto.CompactTextString(m) }
func (*WriteRequest) ProtoMessage()    {}
func (*WriteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6f5ac44994d718c, []int{2}
}
func (m *WriteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WriteRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WriteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteRequest.Merge(m, src)
}
func (m *WriteRequest) XXX_Size() int {
	return m.Size()
}
func (m *WriteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteRequest proto.InternalMessageInfo

func (m *WriteRequest) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

// QueryOptions is used to specify various flags for read queries
type QueryOptions struct {
	// Token is the ACL token ID. If not provided, the 'anonymous'
	// token is assumed for backwards compatibility.
	Token string `protobuf:"bytes,1,opt,name=Token,proto3" json:"Token,omitempty"`
	// If set, wait until query exceeds given index. Must be provided
	// with MaxQueryTime.
	MinQueryIndex uint64 `protobuf:"varint,2,opt,name=MinQueryIndex,proto3" json:"MinQueryIndex,omitempty"`
	// Provided with MinQueryIndex to wait for change.
	MaxQueryTime time.Duration `protobuf:"bytes,3,opt,name=MaxQueryTime,proto3,stdduration" json:"MaxQueryTime"`
	// If set, any follower can service the request. Results
	// may be arbitrarily stale.
	AllowStale bool `protobuf:"varint,4,opt,name=AllowStale,proto3" json:"AllowStale,omitempty"`
	// If set, the leader must verify leadership prior to
	// servicing the request. Prevents a stale read.
	RequireConsistent bool `protobuf:"varint,5,opt,name=RequireConsistent,proto3" json:"RequireConsistent,omitempty"`
	// If set, the local agent may respond with an arbitrarily stale locally
	// cached response. The semantics differ from AllowStale since the agent may
	// be entirely partitioned from the servers and still considered "healthy" by
	// operators. Stale responses from Servers are also arbitrarily stale, but can
	// provide additional bounds on the last contact time from the leader. It's
	// expected that servers that are partitioned are noticed and replaced in a
	// timely way by operators while the same may not be true for client agents.
	UseCache bool `protobuf:"varint,6,opt,name=UseCache,proto3" json:"UseCache,omitempty"`
	// If set and AllowStale is true, will try first a stale
	// read, and then will perform a consistent read if stale
	// read is older than value.
	MaxStaleDuration time.Duration `protobuf:"bytes,7,opt,name=MaxStaleDuration,proto3,stdduration" json:"MaxStaleDuration"`
	// MaxAge limits how old a cached value will be returned if UseCache is true.
	// If there is a cached response that is older than the MaxAge, it is treated
	// as a cache miss and a new fetch invoked. If the fetch fails, the error is
	// returned. Clients that wish to allow for stale results on error can set
	// StaleIfError to a longer duration to change this behavior. It is ignored
	// if the endpoint supports background refresh caching. See
	// https://www.consul.io/api/index.html#agent-caching for more details.
	MaxAge time.Duration `protobuf:"bytes,8,opt,name=MaxAge,proto3,stdduration" json:"MaxAge"`
	// MustRevalidate forces the agent to fetch a fresh version of a cached
	// resource or at least validate that the cached version is still fresh. It is
	// implied by either max-age=0 or must-revalidate Cache-Control headers. It
	// only makes sense when UseCache is true. We store it since MaxAge = 0 is the
	// default unset value.
	MustRevalidate bool `protobuf:"varint,9,opt,name=MustRevalidate,proto3" json:"MustRevalidate,omitempty"`
	// StaleIfError specifies how stale the client will accept a cached response
	// if the servers are unavailable to fetch a fresh one. Only makes sense when
	// UseCache is true and MaxAge is set to a lower, non-zero value. It is
	// ignored if the endpoint supports background refresh caching. See
	// https://www.consul.io/api/index.html#agent-caching for more details.
	StaleIfError time.Duration `protobuf:"bytes,10,opt,name=StaleIfError,proto3,stdduration" json:"StaleIfError"`
	// Filter specifies the go-bexpr filter expression to be used for
	// filtering the data prior to returning a response
	Filter string `protobuf:"bytes,11,opt,name=Filter,proto3" json:"Filter,omitempty"`
}

func (m *QueryOptions) Reset()         { *m = QueryOptions{} }
func (m *QueryOptions) String() string { return proto.CompactTextString(m) }
func (*QueryOptions) ProtoMessage()    {}
func (*QueryOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6f5ac44994d718c, []int{3}
}
func (m *QueryOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryOptions.Merge(m, src)
}
func (m *QueryOptions) XXX_Size() int {
	return m.Size()
}
func (m *QueryOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryOptions.DiscardUnknown(m)
}

var xxx_messageInfo_QueryOptions proto.InternalMessageInfo

func (m *QueryOptions) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *QueryOptions) GetMinQueryIndex() uint64 {
	if m != nil {
		return m.MinQueryIndex
	}
	return 0
}

func (m *QueryOptions) GetMaxQueryTime() time.Duration {
	if m != nil {
		return m.MaxQueryTime
	}
	return 0
}

func (m *QueryOptions) GetAllowStale() bool {
	if m != nil {
		return m.AllowStale
	}
	return false
}

func (m *QueryOptions) GetRequireConsistent() bool {
	if m != nil {
		return m.RequireConsistent
	}
	return false
}

func (m *QueryOptions) GetUseCache() bool {
	if m != nil {
		return m.UseCache
	}
	return false
}

func (m *QueryOptions) GetMaxStaleDuration() time.Duration {
	if m != nil {
		return m.MaxStaleDuration
	}
	return 0
}

func (m *QueryOptions) GetMaxAge() time.Duration {
	if m != nil {
		return m.MaxAge
	}
	return 0
}

func (m *QueryOptions) GetMustRevalidate() bool {
	if m != nil {
		return m.MustRevalidate
	}
	return false
}

func (m *QueryOptions) GetStaleIfError() time.Duration {
	if m != nil {
		return m.StaleIfError
	}
	return 0
}

func (m *QueryOptions) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// QueryMeta allows a query response to include potentially
// useful metadata about a query
type QueryMeta struct {
	// This is the index associated with the read
	Index uint64 `protobuf:"varint,1,opt,name=Index,proto3" json:"Index,omitempty"`
	// If AllowStale is used, this is time elapsed since
	// last contact between the follower and leader. This
	// can be used to gauge staleness.
	LastContact time.Duration `protobuf:"bytes,2,opt,name=LastContact,proto3,stdduration" json:"LastContact"`
	// Used to indicate if there is a known leader node
	KnownLeader bool `protobuf:"varint,3,opt,name=KnownLeader,proto3" json:"KnownLeader,omitempty"`
	// Consistencylevel returns the consistency used to serve the query
	// Having `discovery_max_stale` on the agent can affect whether
	// the request was served by a leader.
	ConsistencyLevel string `protobuf:"bytes,4,opt,name=ConsistencyLevel,proto3" json:"ConsistencyLevel,omitempty"`
}

func (m *QueryMeta) Reset()         { *m = QueryMeta{} }
func (m *QueryMeta) String() string { return proto.CompactTextString(m) }
func (*QueryMeta) ProtoMessage()    {}
func (*QueryMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6f5ac44994d718c, []int{4}
}
func (m *QueryMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryMeta.Merge(m, src)
}
func (m *QueryMeta) XXX_Size() int {
	return m.Size()
}
func (m *QueryMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryMeta.DiscardUnknown(m)
}

var xxx_messageInfo_QueryMeta proto.InternalMessageInfo

func (m *QueryMeta) GetIndex() uint64 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *QueryMeta) GetLastContact() time.Duration {
	if m != nil {
		return m.LastContact
	}
	return 0
}

func (m *QueryMeta) GetKnownLeader() bool {
	if m != nil {
		return m.KnownLeader
	}
	return false
}

func (m *QueryMeta) GetConsistencyLevel() string {
	if m != nil {
		return m.ConsistencyLevel
	}
	return ""
}

// EnterpriseMeta contains metadata that is only used by the Enterprise version
// of Consul.
type EnterpriseMeta struct {
	// Namespace in which the entity exists.
	Namespace string `protobuf:"bytes,1,opt,name=Namespace,proto3" json:"Namespace,omitempty"`
}

func (m *EnterpriseMeta) Reset()         { *m = EnterpriseMeta{} }
func (m *EnterpriseMeta) String() string { return proto.CompactTextString(m) }
func (*EnterpriseMeta) ProtoMessage()    {}
func (*EnterpriseMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_a6f5ac44994d718c, []int{5}
}
func (m *EnterpriseMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnterpriseMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnterpriseMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnterpriseMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnterpriseMeta.Merge(m, src)
}
func (m *EnterpriseMeta) XXX_Size() int {
	return m.Size()
}
func (m *EnterpriseMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_EnterpriseMeta.DiscardUnknown(m)
}

var xxx_messageInfo_EnterpriseMeta proto.InternalMessageInfo

func init() {
	proto.RegisterType((*RaftIndex)(nil), "common.RaftIndex")
	proto.RegisterType((*TargetDatacenter)(nil), "common.TargetDatacenter")
	proto.RegisterType((*WriteRequest)(nil), "common.WriteRequest")
	proto.RegisterType((*QueryOptions)(nil), "common.QueryOptions")
	proto.RegisterType((*QueryMeta)(nil), "common.QueryMeta")
	proto.RegisterType((*EnterpriseMeta)(nil), "common.EnterpriseMeta")
}

func init() { proto.RegisterFile("proto/pbcommon/common.proto", fileDescriptor_a6f5ac44994d718c) }

var fileDescriptor_a6f5ac44994d718c = []byte{
	// 594 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xcf, 0x4e, 0xd4, 0x40,
	0x1c, 0x6e, 0x75, 0x59, 0xb7, 0xbf, 0x05, 0x82, 0x13, 0x62, 0x2a, 0x9a, 0xee, 0xa6, 0x31, 0x86,
	0x10, 0x6d, 0x13, 0xbc, 0xe1, 0x09, 0x16, 0x34, 0xc4, 0xad, 0xc4, 0x8a, 0x31, 0xf1, 0x36, 0xdb,
	0xfd, 0x6d, 0x77, 0x62, 0xdb, 0xa9, 0xd3, 0x29, 0x2c, 0x6f, 0xe0, 0xd1, 0x23, 0xf1, 0xe4, 0x83,
	0xf8, 0x00, 0x1c, 0x39, 0x7a, 0x42, 0x65, 0xdf, 0xc0, 0x27, 0x30, 0x9d, 0x16, 0x28, 0xc2, 0x01,
	0x4f, 0xbb, 0xdf, 0xd7, 0xef, 0x9b, 0xf9, 0xfd, 0xf9, 0x5a, 0x78, 0x90, 0x0a, 0x2e, 0xb9, 0x9b,
	0x0e, 0x02, 0x1e, 0xc7, 0x3c, 0x71, 0xcb, 0x1f, 0x47, 0xb1, 0xa4, 0x59, 0xa2, 0x25, 0x2b, 0xe4,
	0x3c, 0x8c, 0xd0, 0x55, 0xec, 0x20, 0x1f, 0xb9, 0xc3, 0x5c, 0x50, 0xc9, 0xce, 0x74, 0x4b, 0x8b,
	0x21, 0x0f, 0x79, 0x79, 0x50, 0xf1, 0xaf, 0x64, 0xed, 0x18, 0x0c, 0x9f, 0x8e, 0xe4, 0x76, 0x32,
	0xc4, 0x09, 0x71, 0xa1, 0xdd, 0x13, 0x48, 0x25, 0x2a, 0x68, 0xea, 0x5d, 0x7d, 0xb9, 0xb1, 0x31,
	0xf7, 0xe7, 0xa4, 0x63, 0x0c, 0x70, 0x92, 0x8a, 0x35, 0xfb, 0xa9, 0xed, 0xd7, 0x15, 0x85, 0xc1,
	0xe3, 0x43, 0x36, 0x3a, 0x28, 0x0d, 0xb7, 0xae, 0x35, 0xd4, 0x14, 0xf6, 0x2a, 0x2c, 0xec, 0x52,
	0x11, 0xa2, 0xdc, 0xa4, 0x92, 0x06, 0x98, 0x48, 0x14, 0xc4, 0x02, 0xb8, 0x40, 0xea, 0x52, 0xc3,
	0xaf, 0x31, 0xf6, 0x0a, 0xcc, 0xbe, 0x17, 0x4c, 0xa2, 0x8f, 0x9f, 0x72, 0xcc, 0x24, 0x59, 0x84,
	0x99, 0x5d, 0xfe, 0x11, 0x93, 0x4a, 0x5a, 0x82, 0xb5, 0xc6, 0xe7, 0x6f, 0x1d, 0xdd, 0xfe, 0xda,
	0x80, 0xd9, 0x37, 0x39, 0x8a, 0x83, 0x9d, 0xb4, 0x68, 0x3d, 0xbb, 0x5e, 0x4c, 0x1e, 0xc1, 0x9c,
	0xc7, 0x12, 0x25, 0xac, 0x55, 0xee, 0x5f, 0x26, 0xc9, 0x4b, 0x98, 0xf5, 0xe8, 0x44, 0x11, 0xbb,
	0x2c, 0x46, 0xf3, 0x76, 0x57, 0x5f, 0x6e, 0xaf, 0xde, 0x77, 0xca, 0x41, 0x3b, 0x67, 0x83, 0x76,
	0x36, 0xab, 0x41, 0x6f, 0xb4, 0x8e, 0x4e, 0x3a, 0xda, 0xe1, 0xcf, 0x8e, 0xee, 0x5f, 0x32, 0x16,
	0x1d, 0xae, 0x47, 0x11, 0xdf, 0x7f, 0x2b, 0x69, 0x84, 0x66, 0xa3, 0xab, 0x2f, 0xb7, 0xfc, 0x1a,
	0x43, 0x9e, 0xc0, 0xdd, 0xa2, 0x39, 0x26, 0xb0, 0xc7, 0x93, 0x8c, 0x65, 0x12, 0x13, 0x69, 0xce,
	0x28, 0xd9, 0xd5, 0x07, 0x64, 0x09, 0x5a, 0xef, 0x32, 0xec, 0xd1, 0x60, 0x8c, 0x66, 0x53, 0x89,
	0xce, 0x31, 0xd9, 0x81, 0x05, 0x8f, 0x4e, 0xd4, 0xa9, 0x67, 0x55, 0x99, 0x77, 0x6e, 0x5e, 0xf6,
	0x15, 0x33, 0x79, 0x0e, 0x4d, 0x8f, 0x4e, 0xd6, 0x43, 0x34, 0x5b, 0x37, 0x3f, 0xa6, 0xb2, 0x90,
	0xc7, 0x30, 0xef, 0xe5, 0x99, 0xf4, 0x71, 0x8f, 0x46, 0x6c, 0x48, 0x25, 0x9a, 0x86, 0xaa, 0xf7,
	0x1f, 0xb6, 0x18, 0xb4, 0xba, 0x75, 0x7b, 0xb4, 0x25, 0x04, 0x17, 0x26, 0xfc, 0xc7, 0xa0, 0xeb,
	0x46, 0x72, 0x0f, 0x9a, 0x2f, 0x58, 0x54, 0xc4, 0xa8, 0xad, 0xd6, 0x5d, 0xa1, 0x2a, 0x1c, 0xdf,
	0x75, 0x30, 0xd4, 0x52, 0x3c, 0x94, 0xb4, 0x48, 0x46, 0x2d, 0xe6, 0x7e, 0x09, 0xc8, 0x16, 0xb4,
	0xfb, 0x34, 0x93, 0x3d, 0x9e, 0x48, 0x1a, 0x48, 0x95, 0x8b, 0x1b, 0x56, 0x52, 0xf7, 0x91, 0x2e,
	0xb4, 0x5f, 0x25, 0x7c, 0x3f, 0xe9, 0x23, 0x1d, 0xa2, 0x50, 0xc9, 0x69, 0xf9, 0x75, 0x8a, 0xac,
	0xc0, 0xc2, 0xf9, 0x4e, 0x83, 0x83, 0x3e, 0xee, 0x61, 0xa4, 0x92, 0x61, 0xf8, 0x57, 0xf8, 0xaa,
	0x7c, 0x07, 0xe6, 0xb7, 0x8a, 0x17, 0x22, 0x15, 0x2c, 0x43, 0xd5, 0xc2, 0x43, 0x30, 0x5e, 0xd3,
	0x18, 0xb3, 0x94, 0x06, 0x58, 0x05, 0xfc, 0x82, 0xd8, 0xe8, 0x1f, 0xfd, 0xb6, 0xb4, 0xa3, 0x53,
	0x4b, 0x3f, 0x3e, 0xb5, 0xf4, 0x5f, 0xa7, 0x96, 0xfe, 0x65, 0x6a, 0x69, 0x87, 0x53, 0x4b, 0x3b,
	0x9e, 0x5a, 0xda, 0x8f, 0xa9, 0xa5, 0x7d, 0x58, 0x09, 0x99, 0x1c, 0xe7, 0x03, 0x27, 0xe0, 0xb1,
	0x3b, 0xa6, 0xd9, 0x98, 0x05, 0x5c, 0xa4, 0x6e, 0xc0, 0x93, 0x2c, 0x8f, 0xdc, 0xcb, 0xdf, 0x9c,
	0x41, 0x53, 0xe1, 0x67, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0xee, 0xfb, 0xa8, 0x19, 0x8c, 0x04,
	0x00, 0x00,
}

func (m *RaftIndex) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftIndex) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RaftIndex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ModifyIndex != 0 {
		i = encodeVarintCommon(dAtA, i, uint64(m.ModifyIndex))
		i--
		dAtA[i] = 0x10
	}
	if m.CreateIndex != 0 {
		i = encodeVarintCommon(dAtA, i, uint64(m.CreateIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TargetDatacenter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TargetDatacenter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TargetDatacenter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Datacenter) > 0 {
		i -= len(m.Datacenter)
		copy(dAtA[i:], m.Datacenter)
		i = encodeVarintCommon(dAtA, i, uint64(len(m.Datacenter)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WriteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WriteRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintCommon(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryOptions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryOptions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Filter) > 0 {
		i -= len(m.Filter)
		copy(dAtA[i:], m.Filter)
		i = encodeVarintCommon(dAtA, i, uint64(len(m.Filter)))
		i--
		dAtA[i] = 0x5a
	}
	n1, err1 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.StaleIfError, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.StaleIfError):])
	if err1 != nil {
		return 0, err1
	}
	i -= n1
	i = encodeVarintCommon(dAtA, i, uint64(n1))
	i--
	dAtA[i] = 0x52
	if m.MustRevalidate {
		i--
		if m.MustRevalidate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	n2, err2 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.MaxAge, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.MaxAge):])
	if err2 != nil {
		return 0, err2
	}
	i -= n2
	i = encodeVarintCommon(dAtA, i, uint64(n2))
	i--
	dAtA[i] = 0x42
	n3, err3 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.MaxStaleDuration, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.MaxStaleDuration):])
	if err3 != nil {
		return 0, err3
	}
	i -= n3
	i = encodeVarintCommon(dAtA, i, uint64(n3))
	i--
	dAtA[i] = 0x3a
	if m.UseCache {
		i--
		if m.UseCache {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.RequireConsistent {
		i--
		if m.RequireConsistent {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.AllowStale {
		i--
		if m.AllowStale {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	n4, err4 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.MaxQueryTime, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.MaxQueryTime):])
	if err4 != nil {
		return 0, err4
	}
	i -= n4
	i = encodeVarintCommon(dAtA, i, uint64(n4))
	i--
	dAtA[i] = 0x1a
	if m.MinQueryIndex != 0 {
		i = encodeVarintCommon(dAtA, i, uint64(m.MinQueryIndex))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintCommon(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryMeta) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryMeta) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ConsistencyLevel) > 0 {
		i -= len(m.ConsistencyLevel)
		copy(dAtA[i:], m.ConsistencyLevel)
		i = encodeVarintCommon(dAtA, i, uint64(len(m.ConsistencyLevel)))
		i--
		dAtA[i] = 0x22
	}
	if m.KnownLeader {
		i--
		if m.KnownLeader {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	n5, err5 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.LastContact, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.LastContact):])
	if err5 != nil {
		return 0, err5
	}
	i -= n5
	i = encodeVarintCommon(dAtA, i, uint64(n5))
	i--
	dAtA[i] = 0x12
	if m.Index != 0 {
		i = encodeVarintCommon(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EnterpriseMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnterpriseMeta) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnterpriseMeta) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintCommon(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintCommon(dAtA []byte, offset int, v uint64) int {
	offset -= sovCommon(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *RaftIndex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CreateIndex != 0 {
		n += 1 + sovCommon(uint64(m.CreateIndex))
	}
	if m.ModifyIndex != 0 {
		n += 1 + sovCommon(uint64(m.ModifyIndex))
	}
	return n
}

func (m *TargetDatacenter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Datacenter)
	if l > 0 {
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}

func (m *WriteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}

func (m *QueryOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovCommon(uint64(l))
	}
	if m.MinQueryIndex != 0 {
		n += 1 + sovCommon(uint64(m.MinQueryIndex))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.MaxQueryTime)
	n += 1 + l + sovCommon(uint64(l))
	if m.AllowStale {
		n += 2
	}
	if m.RequireConsistent {
		n += 2
	}
	if m.UseCache {
		n += 2
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.MaxStaleDuration)
	n += 1 + l + sovCommon(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.MaxAge)
	n += 1 + l + sovCommon(uint64(l))
	if m.MustRevalidate {
		n += 2
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.StaleIfError)
	n += 1 + l + sovCommon(uint64(l))
	l = len(m.Filter)
	if l > 0 {
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}

func (m *QueryMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovCommon(uint64(m.Index))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.LastContact)
	n += 1 + l + sovCommon(uint64(l))
	if m.KnownLeader {
		n += 2
	}
	l = len(m.ConsistencyLevel)
	if l > 0 {
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}

func (m *EnterpriseMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovCommon(uint64(l))
	}
	return n
}

func sovCommon(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCommon(x uint64) (n int) {
	return sovCommon(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *RaftIndex) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftIndex: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftIndex: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreateIndex", wireType)
			}
			m.CreateIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreateIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModifyIndex", wireType)
			}
			m.ModifyIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ModifyIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TargetDatacenter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TargetDatacenter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TargetDatacenter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Datacenter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Datacenter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinQueryIndex", wireType)
			}
			m.MinQueryIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinQueryIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxQueryTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.MaxQueryTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowStale", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowStale = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireConsistent", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequireConsistent = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseCache", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseCache = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxStaleDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.MaxStaleDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.MaxAge, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MustRevalidate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MustRevalidate = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaleIfError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.StaleIfError, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastContact", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.LastContact, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KnownLeader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.KnownLeader = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsistencyLevel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConsistencyLevel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnterpriseMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnterpriseMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnterpriseMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCommon
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCommon(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCommon
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCommon
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCommon
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupCommon
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthCommon
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthCommon        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCommon          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupCommon = fmt.Errorf("proto: unexpected end of group")
)
