// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/route/route.proto

package route

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"
	time "time"

	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"

	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	_type "github.com/envoyproxy/go-control-plane/envoy/type"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type VirtualHost_TlsRequirementType int32

const (
	// No TLS requirement for the virtual host.
	VirtualHost_NONE VirtualHost_TlsRequirementType = 0
	// External requests must use TLS. If a request is external and it is not
	// using TLS, a 301 redirect will be sent telling the client to use HTTPS.
	VirtualHost_EXTERNAL_ONLY VirtualHost_TlsRequirementType = 1
	// All requests must use TLS. If a request is not using TLS, a 301 redirect
	// will be sent telling the client to use HTTPS.
	VirtualHost_ALL VirtualHost_TlsRequirementType = 2
)

var VirtualHost_TlsRequirementType_name = map[int32]string{
	0: "NONE",
	1: "EXTERNAL_ONLY",
	2: "ALL",
}

var VirtualHost_TlsRequirementType_value = map[string]int32{
	"NONE":          0,
	"EXTERNAL_ONLY": 1,
	"ALL":           2,
}

func (x VirtualHost_TlsRequirementType) String() string {
	return proto.EnumName(VirtualHost_TlsRequirementType_name, int32(x))
}

func (VirtualHost_TlsRequirementType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{0, 0}
}

type RouteAction_ClusterNotFoundResponseCode int32

const (
	// HTTP status code - 503 Service Unavailable.
	RouteAction_SERVICE_UNAVAILABLE RouteAction_ClusterNotFoundResponseCode = 0
	// HTTP status code - 404 Not Found.
	RouteAction_NOT_FOUND RouteAction_ClusterNotFoundResponseCode = 1
)

var RouteAction_ClusterNotFoundResponseCode_name = map[int32]string{
	0: "SERVICE_UNAVAILABLE",
	1: "NOT_FOUND",
}

var RouteAction_ClusterNotFoundResponseCode_value = map[string]int32{
	"SERVICE_UNAVAILABLE": 0,
	"NOT_FOUND":           1,
}

func (x RouteAction_ClusterNotFoundResponseCode) String() string {
	return proto.EnumName(RouteAction_ClusterNotFoundResponseCode_name, int32(x))
}

func (RouteAction_ClusterNotFoundResponseCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{5, 0}
}

// Configures :ref:`internal redirect <arch_overview_internal_redirects>` behavior.
type RouteAction_InternalRedirectAction int32

const (
	RouteAction_PASS_THROUGH_INTERNAL_REDIRECT RouteAction_InternalRedirectAction = 0
	RouteAction_HANDLE_INTERNAL_REDIRECT       RouteAction_InternalRedirectAction = 1
)

var RouteAction_InternalRedirectAction_name = map[int32]string{
	0: "PASS_THROUGH_INTERNAL_REDIRECT",
	1: "HANDLE_INTERNAL_REDIRECT",
}

var RouteAction_InternalRedirectAction_value = map[string]int32{
	"PASS_THROUGH_INTERNAL_REDIRECT": 0,
	"HANDLE_INTERNAL_REDIRECT":       1,
}

func (x RouteAction_InternalRedirectAction) String() string {
	return proto.EnumName(RouteAction_InternalRedirectAction_name, int32(x))
}

func (RouteAction_InternalRedirectAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{5, 1}
}

type RedirectAction_RedirectResponseCode int32

const (
	// Moved Permanently HTTP Status Code - 301.
	RedirectAction_MOVED_PERMANENTLY RedirectAction_RedirectResponseCode = 0
	// Found HTTP Status Code - 302.
	RedirectAction_FOUND RedirectAction_RedirectResponseCode = 1
	// See Other HTTP Status Code - 303.
	RedirectAction_SEE_OTHER RedirectAction_RedirectResponseCode = 2
	// Temporary Redirect HTTP Status Code - 307.
	RedirectAction_TEMPORARY_REDIRECT RedirectAction_RedirectResponseCode = 3
	// Permanent Redirect HTTP Status Code - 308.
	RedirectAction_PERMANENT_REDIRECT RedirectAction_RedirectResponseCode = 4
)

var RedirectAction_RedirectResponseCode_name = map[int32]string{
	0: "MOVED_PERMANENTLY",
	1: "FOUND",
	2: "SEE_OTHER",
	3: "TEMPORARY_REDIRECT",
	4: "PERMANENT_REDIRECT",
}

var RedirectAction_RedirectResponseCode_value = map[string]int32{
	"MOVED_PERMANENTLY":  0,
	"FOUND":              1,
	"SEE_OTHER":          2,
	"TEMPORARY_REDIRECT": 3,
	"PERMANENT_REDIRECT": 4,
}

func (x RedirectAction_RedirectResponseCode) String() string {
	return proto.EnumName(RedirectAction_RedirectResponseCode_name, int32(x))
}

func (RedirectAction_RedirectResponseCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{8, 0}
}

// The top level element in the routing configuration is a virtual host. Each virtual host has
// a logical name as well as a set of domains that get routed to it based on the incoming request's
// host header. This allows a single listener to service multiple top level domain path trees. Once
// a virtual host is selected based on the domain, the routes are processed in order to see which
// upstream cluster to route to or whether to perform a redirect.
// [#comment:next free field: 17]
type VirtualHost struct {
	// The logical name of the virtual host. This is used when emitting certain
	// statistics but is not relevant for routing.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of domains (host/authority header) that will be matched to this
	// virtual host. Wildcard hosts are supported in the suffix or prefix form.
	//
	// Domain search order:
	//  1. Exact domain names: ``www.foo.com``.
	//  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
	//  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
	//  4. Special wildcard ``*`` matching any domain.
	//
	// .. note::
	//
	//   The wildcard will not match the empty string.
	//   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
	//   The longest wildcards match first.
	//   Only a single virtual host in the entire route configuration can match on ``*``. A domain
	//   must be unique across all virtual hosts or the config will fail to load.
	Domains []string `protobuf:"bytes,2,rep,name=domains,proto3" json:"domains,omitempty"`
	// The list of routes that will be matched, in order, for incoming requests.
	// The first route that matches will be used.
	Routes []Route `protobuf:"bytes,3,rep,name=routes,proto3" json:"routes"`
	// Specifies the type of TLS enforcement the virtual host expects. If this option is not
	// specified, there is no TLS requirement for the virtual host.
	RequireTls VirtualHost_TlsRequirementType `protobuf:"varint,4,opt,name=require_tls,json=requireTls,proto3,enum=envoy.api.v2.route.VirtualHost_TlsRequirementType" json:"require_tls,omitempty"`
	// A list of virtual clusters defined for this virtual host. Virtual clusters
	// are used for additional statistics gathering.
	VirtualClusters []*VirtualCluster `protobuf:"bytes,5,rep,name=virtual_clusters,json=virtualClusters,proto3" json:"virtual_clusters,omitempty"`
	// Specifies a set of rate limit configurations that will be applied to the
	// virtual host.
	RateLimits []*RateLimit `protobuf:"bytes,6,rep,name=rate_limits,json=rateLimits,proto3" json:"rate_limits,omitempty"`
	// Specifies a list of HTTP headers that should be added to each request
	// handled by this virtual host. Headers specified at this level are applied
	// after headers from enclosed :ref:`envoy_api_msg_route.Route` and before headers from the
	// enclosing :ref:`envoy_api_msg_RouteConfiguration`. For more information, including
	// details on header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	RequestHeadersToAdd []*core.HeaderValueOption `protobuf:"bytes,7,rep,name=request_headers_to_add,json=requestHeadersToAdd,proto3" json:"request_headers_to_add,omitempty"`
	// Specifies a list of HTTP headers that should be removed from each request
	// handled by this virtual host.
	RequestHeadersToRemove []string `protobuf:"bytes,13,rep,name=request_headers_to_remove,json=requestHeadersToRemove,proto3" json:"request_headers_to_remove,omitempty"`
	// Specifies a list of HTTP headers that should be added to each response
	// handled by this virtual host. Headers specified at this level are applied
	// after headers from enclosed :ref:`envoy_api_msg_route.Route` and before headers from the
	// enclosing :ref:`envoy_api_msg_RouteConfiguration`. For more information, including
	// details on header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	ResponseHeadersToAdd []*core.HeaderValueOption `protobuf:"bytes,10,rep,name=response_headers_to_add,json=responseHeadersToAdd,proto3" json:"response_headers_to_add,omitempty"`
	// Specifies a list of HTTP headers that should be removed from each response
	// handled by this virtual host.
	ResponseHeadersToRemove []string `protobuf:"bytes,11,rep,name=response_headers_to_remove,json=responseHeadersToRemove,proto3" json:"response_headers_to_remove,omitempty"`
	// Indicates that the virtual host has a CORS policy.
	Cors *CorsPolicy `protobuf:"bytes,8,opt,name=cors,proto3" json:"cors,omitempty"`
	// The per_filter_config field can be used to provide virtual host-specific
	// configurations for filters. The key should match the filter name, such as
	// *envoy.buffer* for the HTTP buffer filter. Use of this field is filter
	// specific; see the :ref:`HTTP filter documentation <config_http_filters>`
	// for if and how it is utilized.
	PerFilterConfig map[string]*types.Struct `protobuf:"bytes,12,rep,name=per_filter_config,json=perFilterConfig,proto3" json:"per_filter_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The per_filter_config field can be used to provide virtual host-specific
	// configurations for filters. The key should match the filter name, such as
	// *envoy.buffer* for the HTTP buffer filter. Use of this field is filter
	// specific; see the :ref:`HTTP filter documentation <config_http_filters>`
	// for if and how it is utilized.
	TypedPerFilterConfig map[string]*types.Any `protobuf:"bytes,15,rep,name=typed_per_filter_config,json=typedPerFilterConfig,proto3" json:"typed_per_filter_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Decides whether the :ref:`x-envoy-attempt-count
	// <config_http_filters_router_x-envoy-attempt-count>` header should be included
	// in the upstream request. Setting this option will cause it to override any existing header
	// value, so in the case of two Envoys on the request path with this option enabled, the upstream
	// will see the attempt count as perceived by the second Envoy. Defaults to false.
	// This header is unaffected by the
	// :ref:`suppress_envoy_headers
	// <envoy_api_field_config.filter.http.router.v2.Router.suppress_envoy_headers>` flag.
	IncludeRequestAttemptCount bool `protobuf:"varint,14,opt,name=include_request_attempt_count,json=includeRequestAttemptCount,proto3" json:"include_request_attempt_count,omitempty"`
	// Indicates the retry policy for all routes in this virtual host. Note that setting a
	// route level entry will take precedence over this config and it'll be treated
	// independently (e.g.: values are not inherited).
	RetryPolicy *RetryPolicy `protobuf:"bytes,16,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
	// Indicates the hedge policy for all routes in this virtual host. Note that setting a
	// route level entry will take precedence over this config and it'll be treated
	// independently (e.g.: values are not inherited).
	// [#not-implemented-hide:]
	HedgePolicy          *HedgePolicy `protobuf:"bytes,17,opt,name=hedge_policy,json=hedgePolicy,proto3" json:"hedge_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *VirtualHost) Reset()         { *m = VirtualHost{} }
func (m *VirtualHost) String() string { return proto.CompactTextString(m) }
func (*VirtualHost) ProtoMessage()    {}
func (*VirtualHost) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{0}
}
func (m *VirtualHost) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VirtualHost) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *VirtualHost) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VirtualHost.Merge(m, src)
}
func (m *VirtualHost) XXX_Size() int {
	return m.Size()
}
func (m *VirtualHost) XXX_DiscardUnknown() {
	xxx_messageInfo_VirtualHost.DiscardUnknown(m)
}

var xxx_messageInfo_VirtualHost proto.InternalMessageInfo

func (m *VirtualHost) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VirtualHost) GetDomains() []string {
	if m != nil {
		return m.Domains
	}
	return nil
}

func (m *VirtualHost) GetRoutes() []Route {
	if m != nil {
		return m.Routes
	}
	return nil
}

func (m *VirtualHost) GetRequireTls() VirtualHost_TlsRequirementType {
	if m != nil {
		return m.RequireTls
	}
	return VirtualHost_NONE
}

func (m *VirtualHost) GetVirtualClusters() []*VirtualCluster {
	if m != nil {
		return m.VirtualClusters
	}
	return nil
}

func (m *VirtualHost) GetRateLimits() []*RateLimit {
	if m != nil {
		return m.RateLimits
	}
	return nil
}

func (m *VirtualHost) GetRequestHeadersToAdd() []*core.HeaderValueOption {
	if m != nil {
		return m.RequestHeadersToAdd
	}
	return nil
}

func (m *VirtualHost) GetRequestHeadersToRemove() []string {
	if m != nil {
		return m.RequestHeadersToRemove
	}
	return nil
}

func (m *VirtualHost) GetResponseHeadersToAdd() []*core.HeaderValueOption {
	if m != nil {
		return m.ResponseHeadersToAdd
	}
	return nil
}

func (m *VirtualHost) GetResponseHeadersToRemove() []string {
	if m != nil {
		return m.ResponseHeadersToRemove
	}
	return nil
}

func (m *VirtualHost) GetCors() *CorsPolicy {
	if m != nil {
		return m.Cors
	}
	return nil
}

func (m *VirtualHost) GetPerFilterConfig() map[string]*types.Struct {
	if m != nil {
		return m.PerFilterConfig
	}
	return nil
}

func (m *VirtualHost) GetTypedPerFilterConfig() map[string]*types.Any {
	if m != nil {
		return m.TypedPerFilterConfig
	}
	return nil
}

func (m *VirtualHost) GetIncludeRequestAttemptCount() bool {
	if m != nil {
		return m.IncludeRequestAttemptCount
	}
	return false
}

func (m *VirtualHost) GetRetryPolicy() *RetryPolicy {
	if m != nil {
		return m.RetryPolicy
	}
	return nil
}

func (m *VirtualHost) GetHedgePolicy() *HedgePolicy {
	if m != nil {
		return m.HedgePolicy
	}
	return nil
}

// A route is both a specification of how to match a request as well as an indication of what to do
// next (e.g., redirect, forward, rewrite, etc.).
//
// .. attention::
//
//   Envoy supports routing on HTTP method via :ref:`header matching
//   <envoy_api_msg_route.HeaderMatcher>`.
// [#comment:next free field: 14]
type Route struct {
	// Route matching parameters.
	Match RouteMatch `protobuf:"bytes,1,opt,name=match,proto3" json:"match"`
	// Types that are valid to be assigned to Action:
	//	*Route_Route
	//	*Route_Redirect
	//	*Route_DirectResponse
	Action isRoute_Action `protobuf_oneof:"action"`
	// The Metadata field can be used to provide additional information
	// about the route. It can be used for configuration, stats, and logging.
	// The metadata should go under the filter namespace that will need it.
	// For instance, if the metadata is intended for the Router filter,
	// the filter name should be specified as *envoy.router*.
	Metadata *core.Metadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Decorator for the matched route.
	Decorator *Decorator `protobuf:"bytes,5,opt,name=decorator,proto3" json:"decorator,omitempty"`
	// The per_filter_config field can be used to provide route-specific
	// configurations for filters. The key should match the filter name, such as
	// *envoy.buffer* for the HTTP buffer filter. Use of this field is filter
	// specific; see the :ref:`HTTP filter documentation <config_http_filters>` for
	// if and how it is utilized.
	PerFilterConfig map[string]*types.Struct `protobuf:"bytes,8,rep,name=per_filter_config,json=perFilterConfig,proto3" json:"per_filter_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The per_filter_config field can be used to provide route-specific
	// configurations for filters. The key should match the filter name, such as
	// *envoy.buffer* for the HTTP buffer filter. Use of this field is filter
	// specific; see the :ref:`HTTP filter documentation <config_http_filters>` for
	// if and how it is utilized.
	TypedPerFilterConfig map[string]*types.Any `protobuf:"bytes,13,rep,name=typed_per_filter_config,json=typedPerFilterConfig,proto3" json:"typed_per_filter_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specifies a set of headers that will be added to requests matching this
	// route. Headers specified at this level are applied before headers from the
	// enclosing :ref:`envoy_api_msg_route.VirtualHost` and
	// :ref:`envoy_api_msg_RouteConfiguration`. For more information, including details on
	// header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	RequestHeadersToAdd []*core.HeaderValueOption `protobuf:"bytes,9,rep,name=request_headers_to_add,json=requestHeadersToAdd,proto3" json:"request_headers_to_add,omitempty"`
	// Specifies a list of HTTP headers that should be removed from each request
	// matching this route.
	RequestHeadersToRemove []string `protobuf:"bytes,12,rep,name=request_headers_to_remove,json=requestHeadersToRemove,proto3" json:"request_headers_to_remove,omitempty"`
	// Specifies a set of headers that will be added to responses to requests
	// matching this route. Headers specified at this level are applied before
	// headers from the enclosing :ref:`envoy_api_msg_route.VirtualHost` and
	// :ref:`envoy_api_msg_RouteConfiguration`. For more information, including
	// details on header value syntax, see the documentation on
	// :ref:`custom request headers <config_http_conn_man_headers_custom_request_headers>`.
	ResponseHeadersToAdd []*core.HeaderValueOption `protobuf:"bytes,10,rep,name=response_headers_to_add,json=responseHeadersToAdd,proto3" json:"response_headers_to_add,omitempty"`
	// Specifies a list of HTTP headers that should be removed from each response
	// to requests matching this route.
	ResponseHeadersToRemove []string `protobuf:"bytes,11,rep,name=response_headers_to_remove,json=responseHeadersToRemove,proto3" json:"response_headers_to_remove,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *Route) Reset()         { *m = Route{} }
func (m *Route) String() string { return proto.CompactTextString(m) }
func (*Route) ProtoMessage()    {}
func (*Route) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{1}
}
func (m *Route) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Route) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Route) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Route.Merge(m, src)
}
func (m *Route) XXX_Size() int {
	return m.Size()
}
func (m *Route) XXX_DiscardUnknown() {
	xxx_messageInfo_Route.DiscardUnknown(m)
}

var xxx_messageInfo_Route proto.InternalMessageInfo

type isRoute_Action interface {
	isRoute_Action()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Route_Route struct {
	Route *RouteAction `protobuf:"bytes,2,opt,name=route,proto3,oneof"`
}
type Route_Redirect struct {
	Redirect *RedirectAction `protobuf:"bytes,3,opt,name=redirect,proto3,oneof"`
}
type Route_DirectResponse struct {
	DirectResponse *DirectResponseAction `protobuf:"bytes,7,opt,name=direct_response,json=directResponse,proto3,oneof"`
}

func (*Route_Route) isRoute_Action()          {}
func (*Route_Redirect) isRoute_Action()       {}
func (*Route_DirectResponse) isRoute_Action() {}

func (m *Route) GetAction() isRoute_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *Route) GetMatch() RouteMatch {
	if m != nil {
		return m.Match
	}
	return RouteMatch{}
}

func (m *Route) GetRoute() *RouteAction {
	if x, ok := m.GetAction().(*Route_Route); ok {
		return x.Route
	}
	return nil
}

func (m *Route) GetRedirect() *RedirectAction {
	if x, ok := m.GetAction().(*Route_Redirect); ok {
		return x.Redirect
	}
	return nil
}

func (m *Route) GetDirectResponse() *DirectResponseAction {
	if x, ok := m.GetAction().(*Route_DirectResponse); ok {
		return x.DirectResponse
	}
	return nil
}

func (m *Route) GetMetadata() *core.Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Route) GetDecorator() *Decorator {
	if m != nil {
		return m.Decorator
	}
	return nil
}

func (m *Route) GetPerFilterConfig() map[string]*types.Struct {
	if m != nil {
		return m.PerFilterConfig
	}
	return nil
}

func (m *Route) GetTypedPerFilterConfig() map[string]*types.Any {
	if m != nil {
		return m.TypedPerFilterConfig
	}
	return nil
}

func (m *Route) GetRequestHeadersToAdd() []*core.HeaderValueOption {
	if m != nil {
		return m.RequestHeadersToAdd
	}
	return nil
}

func (m *Route) GetRequestHeadersToRemove() []string {
	if m != nil {
		return m.RequestHeadersToRemove
	}
	return nil
}

func (m *Route) GetResponseHeadersToAdd() []*core.HeaderValueOption {
	if m != nil {
		return m.ResponseHeadersToAdd
	}
	return nil
}

func (m *Route) GetResponseHeadersToRemove() []string {
	if m != nil {
		return m.ResponseHeadersToRemove
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Route) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Route_OneofMarshaler, _Route_OneofUnmarshaler, _Route_OneofSizer, []interface{}{
		(*Route_Route)(nil),
		(*Route_Redirect)(nil),
		(*Route_DirectResponse)(nil),
	}
}

func _Route_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Route)
	// action
	switch x := m.Action.(type) {
	case *Route_Route:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Route); err != nil {
			return err
		}
	case *Route_Redirect:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Redirect); err != nil {
			return err
		}
	case *Route_DirectResponse:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DirectResponse); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Route.Action has unexpected type %T", x)
	}
	return nil
}

func _Route_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Route)
	switch tag {
	case 2: // action.route
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RouteAction)
		err := b.DecodeMessage(msg)
		m.Action = &Route_Route{msg}
		return true, err
	case 3: // action.redirect
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RedirectAction)
		err := b.DecodeMessage(msg)
		m.Action = &Route_Redirect{msg}
		return true, err
	case 7: // action.direct_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DirectResponseAction)
		err := b.DecodeMessage(msg)
		m.Action = &Route_DirectResponse{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Route_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Route)
	// action
	switch x := m.Action.(type) {
	case *Route_Route:
		s := proto.Size(x.Route)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Route_Redirect:
		s := proto.Size(x.Redirect)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Route_DirectResponse:
		s := proto.Size(x.DirectResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Compared to the :ref:`cluster <envoy_api_field_route.RouteAction.cluster>` field that specifies a
// single upstream cluster as the target of a request, the :ref:`weighted_clusters
// <envoy_api_field_route.RouteAction.weighted_clusters>` option allows for specification of
// multiple upstream clusters along with weights that indicate the percentage of
// traffic to be forwarded to each cluster. The router selects an upstream cluster based on the
// weights.
// [#comment:next free field: 11]
type WeightedCluster struct {
	// Specifies one or more upstream clusters associated with the route.
	Clusters []*WeightedCluster_ClusterWeight `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// Specifies the total weight across all clusters. The sum of all cluster weights must equal this
	// value, which must be greater than 0. Defaults to 100.
	TotalWeight *types.UInt32Value `protobuf:"bytes,3,opt,name=total_weight,json=totalWeight,proto3" json:"total_weight,omitempty"`
	// Specifies the runtime key prefix that should be used to construct the
	// runtime keys associated with each cluster. When the *runtime_key_prefix* is
	// specified, the router will look for weights associated with each upstream
	// cluster under the key *runtime_key_prefix* + "." + *cluster[i].name* where
	// *cluster[i]* denotes an entry in the clusters array field. If the runtime
	// key for the cluster does not exist, the value specified in the
	// configuration file will be used as the default weight. See the :ref:`runtime documentation
	// <operations_runtime>` for how key names map to the underlying implementation.
	RuntimeKeyPrefix     string   `protobuf:"bytes,2,opt,name=runtime_key_prefix,json=runtimeKeyPrefix,proto3" json:"runtime_key_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WeightedCluster) Reset()         { *m = WeightedCluster{} }
func (m *WeightedCluster) String() string { return proto.CompactTextString(m) }
func (*WeightedCluster) ProtoMessage()    {}
func (*WeightedCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{2}
}
func (m *WeightedCluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WeightedCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *WeightedCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WeightedCluster.Merge(m, src)
}
func (m *WeightedCluster) XXX_Size() int {
	return m.Size()
}
func (m *WeightedCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_WeightedCluster.DiscardUnknown(m)
}

var xxx_messageInfo_WeightedCluster proto.InternalMessageInfo

func (m *WeightedCluster) GetClusters() []*WeightedCluster_ClusterWeight {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *WeightedCluster) GetTotalWeight() *types.UInt32Value {
	if m != nil {
		return m.TotalWeight
	}
	return nil
}

func (m *WeightedCluster) GetRuntimeKeyPrefix() string {
	if m != nil {
		return m.RuntimeKeyPrefix
	}
	return ""
}

type WeightedCluster_ClusterWeight struct {
	// Name of the upstream cluster. The cluster must exist in the
	// :ref:`cluster manager configuration <config_cluster_manager>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An integer between 0 and :ref:`total_weight
	// <envoy_api_field_route.WeightedCluster.total_weight>`. When a request matches the route,
	// the choice of an upstream cluster is determined by its weight. The sum of weights across all
	// entries in the clusters array must add up to the total_weight, which defaults to 100.
	Weight *types.UInt32Value `protobuf:"bytes,2,opt,name=weight,proto3" json:"weight,omitempty"`
	// Optional endpoint metadata match criteria used by the subset load balancer. Only endpoints in
	// the upstream cluster with metadata matching what is set in this field will be considered for
	// load balancing. Note that this will be merged with what's provided in :ref:
	// `RouteAction.MetadataMatch <envoy_api_field_route.RouteAction.metadata_match>`, with values
	// here taking precedence. The filter name should be specified as *envoy.lb*.
	MetadataMatch *core.Metadata `protobuf:"bytes,3,opt,name=metadata_match,json=metadataMatch,proto3" json:"metadata_match,omitempty"`
	// Specifies a list of headers to be added to requests when this cluster is selected
	// through the enclosing :ref:`envoy_api_msg_route.RouteAction`.
	// Headers specified at this level are applied before headers from the enclosing
	// :ref:`envoy_api_msg_route.Route`, :ref:`envoy_api_msg_route.VirtualHost`, and
	// :ref:`envoy_api_msg_RouteConfiguration`. For more information, including details on
	// header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	RequestHeadersToAdd []*core.HeaderValueOption `protobuf:"bytes,4,rep,name=request_headers_to_add,json=requestHeadersToAdd,proto3" json:"request_headers_to_add,omitempty"`
	// Specifies a list of HTTP headers that should be removed from each request when
	// this cluster is selected through the enclosing :ref:`envoy_api_msg_route.RouteAction`.
	RequestHeadersToRemove []string `protobuf:"bytes,9,rep,name=request_headers_to_remove,json=requestHeadersToRemove,proto3" json:"request_headers_to_remove,omitempty"`
	// Specifies a list of headers to be added to responses when this cluster is selected
	// through the enclosing :ref:`envoy_api_msg_route.RouteAction`.
	// Headers specified at this level are applied before headers from the enclosing
	// :ref:`envoy_api_msg_route.Route`, :ref:`envoy_api_msg_route.VirtualHost`, and
	// :ref:`envoy_api_msg_RouteConfiguration`. For more information, including details on
	// header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	ResponseHeadersToAdd []*core.HeaderValueOption `protobuf:"bytes,5,rep,name=response_headers_to_add,json=responseHeadersToAdd,proto3" json:"response_headers_to_add,omitempty"`
	// Specifies a list of headers to be removed from responses when this cluster is selected
	// through the enclosing :ref:`envoy_api_msg_route.RouteAction`.
	ResponseHeadersToRemove []string `protobuf:"bytes,6,rep,name=response_headers_to_remove,json=responseHeadersToRemove,proto3" json:"response_headers_to_remove,omitempty"`
	// The per_filter_config field can be used to provide weighted cluster-specific
	// configurations for filters. The key should match the filter name, such as
	// *envoy.buffer* for the HTTP buffer filter. Use of this field is filter
	// specific; see the :ref:`HTTP filter documentation <config_http_filters>`
	// for if and how it is utilized.
	PerFilterConfig map[string]*types.Struct `protobuf:"bytes,8,rep,name=per_filter_config,json=perFilterConfig,proto3" json:"per_filter_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The per_filter_config field can be used to provide weighted cluster-specific
	// configurations for filters. The key should match the filter name, such as
	// *envoy.buffer* for the HTTP buffer filter. Use of this field is filter
	// specific; see the :ref:`HTTP filter documentation <config_http_filters>`
	// for if and how it is utilized.
	TypedPerFilterConfig map[string]*types.Any `protobuf:"bytes,10,rep,name=typed_per_filter_config,json=typedPerFilterConfig,proto3" json:"typed_per_filter_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *WeightedCluster_ClusterWeight) Reset()         { *m = WeightedCluster_ClusterWeight{} }
func (m *WeightedCluster_ClusterWeight) String() string { return proto.CompactTextString(m) }
func (*WeightedCluster_ClusterWeight) ProtoMessage()    {}
func (*WeightedCluster_ClusterWeight) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{2, 0}
}
func (m *WeightedCluster_ClusterWeight) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WeightedCluster_ClusterWeight) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *WeightedCluster_ClusterWeight) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WeightedCluster_ClusterWeight.Merge(m, src)
}
func (m *WeightedCluster_ClusterWeight) XXX_Size() int {
	return m.Size()
}
func (m *WeightedCluster_ClusterWeight) XXX_DiscardUnknown() {
	xxx_messageInfo_WeightedCluster_ClusterWeight.DiscardUnknown(m)
}

var xxx_messageInfo_WeightedCluster_ClusterWeight proto.InternalMessageInfo

func (m *WeightedCluster_ClusterWeight) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WeightedCluster_ClusterWeight) GetWeight() *types.UInt32Value {
	if m != nil {
		return m.Weight
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetMetadataMatch() *core.Metadata {
	if m != nil {
		return m.MetadataMatch
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetRequestHeadersToAdd() []*core.HeaderValueOption {
	if m != nil {
		return m.RequestHeadersToAdd
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetRequestHeadersToRemove() []string {
	if m != nil {
		return m.RequestHeadersToRemove
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetResponseHeadersToAdd() []*core.HeaderValueOption {
	if m != nil {
		return m.ResponseHeadersToAdd
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetResponseHeadersToRemove() []string {
	if m != nil {
		return m.ResponseHeadersToRemove
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetPerFilterConfig() map[string]*types.Struct {
	if m != nil {
		return m.PerFilterConfig
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetTypedPerFilterConfig() map[string]*types.Any {
	if m != nil {
		return m.TypedPerFilterConfig
	}
	return nil
}

type RouteMatch struct {
	// Types that are valid to be assigned to PathSpecifier:
	//	*RouteMatch_Prefix
	//	*RouteMatch_Path
	//	*RouteMatch_Regex
	PathSpecifier isRouteMatch_PathSpecifier `protobuf_oneof:"path_specifier"`
	// Indicates that prefix/path matching should be case insensitive. The default
	// is true.
	CaseSensitive *types.BoolValue `protobuf:"bytes,4,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
	// Indicates that the route should additionally match on a runtime key. Every time the route
	// is considered for a match, it must also fall under the percentage of matches indicated by
	// this field. For some fraction N/D, a random number in the range [0,D) is selected. If the
	// number is <= the value of the numerator N, or if the key is not present, the default
	// value, the router continues to evaluate the remaining match criteria. A runtime_fraction
	// route configuration can be used to roll out route changes in a gradual manner without full
	// code/config deploys. Refer to the :ref:`traffic shifting
	// <config_http_conn_man_route_table_traffic_splitting_shift>` docs for additional documentation.
	//
	// .. note::
	//
	//    Parsing this field is implemented such that the runtime key's data may be represented
	//    as a FractionalPercent proto represented as JSON/YAML and may also be represented as an
	//    integer with the assumption that the value is an integral percentage out of 100. For
	//    instance, a runtime key lookup returning the value "42" would parse as a FractionalPercent
	//    whose numerator is 42 and denominator is HUNDRED. This preserves legacy semantics.
	RuntimeFraction *core.RuntimeFractionalPercent `protobuf:"bytes,9,opt,name=runtime_fraction,json=runtimeFraction,proto3" json:"runtime_fraction,omitempty"`
	// Specifies a set of headers that the route should match on. The router will
	// check the request’s headers against all the specified headers in the route
	// config. A match will happen if all the headers in the route are present in
	// the request with the same values (or based on presence if the value field
	// is not in the config).
	Headers []*HeaderMatcher `protobuf:"bytes,6,rep,name=headers,proto3" json:"headers,omitempty"`
	// Specifies a set of URL query parameters on which the route should
	// match. The router will check the query string from the *path* header
	// against all the specified query parameters. If the number of specified
	// query parameters is nonzero, they all must match the *path* header's
	// query string for a match to occur.
	QueryParameters []*QueryParameterMatcher `protobuf:"bytes,7,rep,name=query_parameters,json=queryParameters,proto3" json:"query_parameters,omitempty"`
	// If specified, only gRPC requests will be matched. The router will check
	// that the content-type header has a application/grpc or one of the various
	// application/grpc+ values.
	Grpc                 *RouteMatch_GrpcRouteMatchOptions `protobuf:"bytes,8,opt,name=grpc,proto3" json:"grpc,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *RouteMatch) Reset()         { *m = RouteMatch{} }
func (m *RouteMatch) String() string { return proto.CompactTextString(m) }
func (*RouteMatch) ProtoMessage()    {}
func (*RouteMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{3}
}
func (m *RouteMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RouteMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteMatch.Merge(m, src)
}
func (m *RouteMatch) XXX_Size() int {
	return m.Size()
}
func (m *RouteMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteMatch.DiscardUnknown(m)
}

var xxx_messageInfo_RouteMatch proto.InternalMessageInfo

type isRouteMatch_PathSpecifier interface {
	isRouteMatch_PathSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RouteMatch_Prefix struct {
	Prefix string `protobuf:"bytes,1,opt,name=prefix,proto3,oneof"`
}
type RouteMatch_Path struct {
	Path string `protobuf:"bytes,2,opt,name=path,proto3,oneof"`
}
type RouteMatch_Regex struct {
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

func (*RouteMatch_Prefix) isRouteMatch_PathSpecifier() {}
func (*RouteMatch_Path) isRouteMatch_PathSpecifier()   {}
func (*RouteMatch_Regex) isRouteMatch_PathSpecifier()  {}

func (m *RouteMatch) GetPathSpecifier() isRouteMatch_PathSpecifier {
	if m != nil {
		return m.PathSpecifier
	}
	return nil
}

func (m *RouteMatch) GetPrefix() string {
	if x, ok := m.GetPathSpecifier().(*RouteMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (m *RouteMatch) GetPath() string {
	if x, ok := m.GetPathSpecifier().(*RouteMatch_Path); ok {
		return x.Path
	}
	return ""
}

func (m *RouteMatch) GetRegex() string {
	if x, ok := m.GetPathSpecifier().(*RouteMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

func (m *RouteMatch) GetCaseSensitive() *types.BoolValue {
	if m != nil {
		return m.CaseSensitive
	}
	return nil
}

func (m *RouteMatch) GetRuntimeFraction() *core.RuntimeFractionalPercent {
	if m != nil {
		return m.RuntimeFraction
	}
	return nil
}

func (m *RouteMatch) GetHeaders() []*HeaderMatcher {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *RouteMatch) GetQueryParameters() []*QueryParameterMatcher {
	if m != nil {
		return m.QueryParameters
	}
	return nil
}

func (m *RouteMatch) GetGrpc() *RouteMatch_GrpcRouteMatchOptions {
	if m != nil {
		return m.Grpc
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RouteMatch) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RouteMatch_OneofMarshaler, _RouteMatch_OneofUnmarshaler, _RouteMatch_OneofSizer, []interface{}{
		(*RouteMatch_Prefix)(nil),
		(*RouteMatch_Path)(nil),
		(*RouteMatch_Regex)(nil),
	}
}

func _RouteMatch_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RouteMatch)
	// path_specifier
	switch x := m.PathSpecifier.(type) {
	case *RouteMatch_Prefix:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Prefix)
	case *RouteMatch_Path:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Path)
	case *RouteMatch_Regex:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Regex)
	case nil:
	default:
		return fmt.Errorf("RouteMatch.PathSpecifier has unexpected type %T", x)
	}
	return nil
}

func _RouteMatch_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RouteMatch)
	switch tag {
	case 1: // path_specifier.prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathSpecifier = &RouteMatch_Prefix{x}
		return true, err
	case 2: // path_specifier.path
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathSpecifier = &RouteMatch_Path{x}
		return true, err
	case 3: // path_specifier.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathSpecifier = &RouteMatch_Regex{x}
		return true, err
	default:
		return false, nil
	}
}

func _RouteMatch_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RouteMatch)
	// path_specifier
	switch x := m.PathSpecifier.(type) {
	case *RouteMatch_Prefix:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Prefix)))
		n += len(x.Prefix)
	case *RouteMatch_Path:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Path)))
		n += len(x.Path)
	case *RouteMatch_Regex:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Regex)))
		n += len(x.Regex)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type RouteMatch_GrpcRouteMatchOptions struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RouteMatch_GrpcRouteMatchOptions) Reset()         { *m = RouteMatch_GrpcRouteMatchOptions{} }
func (m *RouteMatch_GrpcRouteMatchOptions) String() string { return proto.CompactTextString(m) }
func (*RouteMatch_GrpcRouteMatchOptions) ProtoMessage()    {}
func (*RouteMatch_GrpcRouteMatchOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{3, 0}
}
func (m *RouteMatch_GrpcRouteMatchOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteMatch_GrpcRouteMatchOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RouteMatch_GrpcRouteMatchOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteMatch_GrpcRouteMatchOptions.Merge(m, src)
}
func (m *RouteMatch_GrpcRouteMatchOptions) XXX_Size() int {
	return m.Size()
}
func (m *RouteMatch_GrpcRouteMatchOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteMatch_GrpcRouteMatchOptions.DiscardUnknown(m)
}

var xxx_messageInfo_RouteMatch_GrpcRouteMatchOptions proto.InternalMessageInfo

// [#comment:next free field: 11]
type CorsPolicy struct {
	// Specifies the origins that will be allowed to do CORS requests.
	//
	// An origin is allowed if either allow_origin or allow_origin_regex match.
	AllowOrigin []string `protobuf:"bytes,1,rep,name=allow_origin,json=allowOrigin,proto3" json:"allow_origin,omitempty"`
	// Specifies regex patterns that match allowed origins.
	//
	// An origin is allowed if either allow_origin or allow_origin_regex match.
	AllowOriginRegex []string `protobuf:"bytes,8,rep,name=allow_origin_regex,json=allowOriginRegex,proto3" json:"allow_origin_regex,omitempty"`
	// Specifies the content for the *access-control-allow-methods* header.
	AllowMethods string `protobuf:"bytes,2,opt,name=allow_methods,json=allowMethods,proto3" json:"allow_methods,omitempty"`
	// Specifies the content for the *access-control-allow-headers* header.
	AllowHeaders string `protobuf:"bytes,3,opt,name=allow_headers,json=allowHeaders,proto3" json:"allow_headers,omitempty"`
	// Specifies the content for the *access-control-expose-headers* header.
	ExposeHeaders string `protobuf:"bytes,4,opt,name=expose_headers,json=exposeHeaders,proto3" json:"expose_headers,omitempty"`
	// Specifies the content for the *access-control-max-age* header.
	MaxAge string `protobuf:"bytes,5,opt,name=max_age,json=maxAge,proto3" json:"max_age,omitempty"`
	// Specifies whether the resource allows credentials.
	AllowCredentials *types.BoolValue `protobuf:"bytes,6,opt,name=allow_credentials,json=allowCredentials,proto3" json:"allow_credentials,omitempty"`
	// Types that are valid to be assigned to EnabledSpecifier:
	//	*CorsPolicy_Enabled
	//	*CorsPolicy_FilterEnabled
	EnabledSpecifier isCorsPolicy_EnabledSpecifier `protobuf_oneof:"enabled_specifier"`
	// Specifies if CORS policies are evaluated and tracked when filter is off but
	// does not enforce any policies.
	//
	// More information on how this can be controlled via runtime can be found
	// :ref:`here <cors-runtime>`.
	//
	// .. note::
	//
	//   This field defaults to 100/:ref:`HUNDRED
	//   <envoy_api_enum_type.FractionalPercent.DenominatorType>`.
	ShadowEnabled        *core.RuntimeFractionalPercent `protobuf:"bytes,10,opt,name=shadow_enabled,json=shadowEnabled,proto3" json:"shadow_enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *CorsPolicy) Reset()         { *m = CorsPolicy{} }
func (m *CorsPolicy) String() string { return proto.CompactTextString(m) }
func (*CorsPolicy) ProtoMessage()    {}
func (*CorsPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{4}
}
func (m *CorsPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CorsPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *CorsPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CorsPolicy.Merge(m, src)
}
func (m *CorsPolicy) XXX_Size() int {
	return m.Size()
}
func (m *CorsPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_CorsPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_CorsPolicy proto.InternalMessageInfo

type isCorsPolicy_EnabledSpecifier interface {
	isCorsPolicy_EnabledSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type CorsPolicy_Enabled struct {
	Enabled *types.BoolValue `protobuf:"bytes,7,opt,name=enabled,proto3,oneof"`
}
type CorsPolicy_FilterEnabled struct {
	FilterEnabled *core.RuntimeFractionalPercent `protobuf:"bytes,9,opt,name=filter_enabled,json=filterEnabled,proto3,oneof"`
}

func (*CorsPolicy_Enabled) isCorsPolicy_EnabledSpecifier()       {}
func (*CorsPolicy_FilterEnabled) isCorsPolicy_EnabledSpecifier() {}

func (m *CorsPolicy) GetEnabledSpecifier() isCorsPolicy_EnabledSpecifier {
	if m != nil {
		return m.EnabledSpecifier
	}
	return nil
}

func (m *CorsPolicy) GetAllowOrigin() []string {
	if m != nil {
		return m.AllowOrigin
	}
	return nil
}

func (m *CorsPolicy) GetAllowOriginRegex() []string {
	if m != nil {
		return m.AllowOriginRegex
	}
	return nil
}

func (m *CorsPolicy) GetAllowMethods() string {
	if m != nil {
		return m.AllowMethods
	}
	return ""
}

func (m *CorsPolicy) GetAllowHeaders() string {
	if m != nil {
		return m.AllowHeaders
	}
	return ""
}

func (m *CorsPolicy) GetExposeHeaders() string {
	if m != nil {
		return m.ExposeHeaders
	}
	return ""
}

func (m *CorsPolicy) GetMaxAge() string {
	if m != nil {
		return m.MaxAge
	}
	return ""
}

func (m *CorsPolicy) GetAllowCredentials() *types.BoolValue {
	if m != nil {
		return m.AllowCredentials
	}
	return nil
}

// Deprecated: Do not use.
func (m *CorsPolicy) GetEnabled() *types.BoolValue {
	if x, ok := m.GetEnabledSpecifier().(*CorsPolicy_Enabled); ok {
		return x.Enabled
	}
	return nil
}

func (m *CorsPolicy) GetFilterEnabled() *core.RuntimeFractionalPercent {
	if x, ok := m.GetEnabledSpecifier().(*CorsPolicy_FilterEnabled); ok {
		return x.FilterEnabled
	}
	return nil
}

func (m *CorsPolicy) GetShadowEnabled() *core.RuntimeFractionalPercent {
	if m != nil {
		return m.ShadowEnabled
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CorsPolicy) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CorsPolicy_OneofMarshaler, _CorsPolicy_OneofUnmarshaler, _CorsPolicy_OneofSizer, []interface{}{
		(*CorsPolicy_Enabled)(nil),
		(*CorsPolicy_FilterEnabled)(nil),
	}
}

func _CorsPolicy_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CorsPolicy)
	// enabled_specifier
	switch x := m.EnabledSpecifier.(type) {
	case *CorsPolicy_Enabled:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Enabled); err != nil {
			return err
		}
	case *CorsPolicy_FilterEnabled:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FilterEnabled); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CorsPolicy.EnabledSpecifier has unexpected type %T", x)
	}
	return nil
}

func _CorsPolicy_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CorsPolicy)
	switch tag {
	case 7: // enabled_specifier.enabled
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.BoolValue)
		err := b.DecodeMessage(msg)
		m.EnabledSpecifier = &CorsPolicy_Enabled{msg}
		return true, err
	case 9: // enabled_specifier.filter_enabled
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(core.RuntimeFractionalPercent)
		err := b.DecodeMessage(msg)
		m.EnabledSpecifier = &CorsPolicy_FilterEnabled{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CorsPolicy_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CorsPolicy)
	// enabled_specifier
	switch x := m.EnabledSpecifier.(type) {
	case *CorsPolicy_Enabled:
		s := proto.Size(x.Enabled)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CorsPolicy_FilterEnabled:
		s := proto.Size(x.FilterEnabled)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// [#comment:next free field: 27]
type RouteAction struct {
	// Types that are valid to be assigned to ClusterSpecifier:
	//	*RouteAction_Cluster
	//	*RouteAction_ClusterHeader
	//	*RouteAction_WeightedClusters
	ClusterSpecifier isRouteAction_ClusterSpecifier `protobuf_oneof:"cluster_specifier"`
	// The HTTP status code to use when configured cluster is not found.
	// The default response code is 503 Service Unavailable.
	ClusterNotFoundResponseCode RouteAction_ClusterNotFoundResponseCode `protobuf:"varint,20,opt,name=cluster_not_found_response_code,json=clusterNotFoundResponseCode,proto3,enum=envoy.api.v2.route.RouteAction_ClusterNotFoundResponseCode" json:"cluster_not_found_response_code,omitempty"`
	// Optional endpoint metadata match criteria used by the subset load balancer. Only endpoints
	// in the upstream cluster with metadata matching what's set in this field will be considered
	// for load balancing. If using :ref:`weighted_clusters
	// <envoy_api_field_route.RouteAction.weighted_clusters>`, metadata will be merged, with values
	// provided there taking precedence. The filter name should be specified as *envoy.lb*.
	MetadataMatch *core.Metadata `protobuf:"bytes,4,opt,name=metadata_match,json=metadataMatch,proto3" json:"metadata_match,omitempty"`
	// Indicates that during forwarding, the matched prefix (or path) should be
	// swapped with this value. This option allows application URLs to be rooted
	// at a different path from those exposed at the reverse proxy layer. The router filter will
	// place the original path before rewrite into the :ref:`x-envoy-original-path
	// <config_http_filters_router_x-envoy-original-path>` header.
	//
	// .. attention::
	//
	//   Pay careful attention to the use of trailing slashes in the
	//   :ref:`route's match <envoy_api_field_route.Route.match>` prefix value.
	//   Stripping a prefix from a path requires multiple Routes to handle all cases. For example,
	//   rewriting */prefix* to */* and */prefix/etc* to */etc* cannot be done in a single
	//   :ref:`Route <envoy_api_msg_route.Route>`, as shown by the below config entries:
	//
	//   .. code-block:: yaml
	//
	//     - match:
	//         prefix: "/prefix/"
	//       route:
	//         prefix_rewrite: "/"
	//     - match:
	//         prefix: "/prefix"
	//       route:
	//         prefix_rewrite: "/"
	//
	//   Having above entries in the config, requests to */prefix* will be stripped to */*, while
	//   requests to */prefix/etc* will be stripped to */etc*.
	PrefixRewrite string `protobuf:"bytes,5,opt,name=prefix_rewrite,json=prefixRewrite,proto3" json:"prefix_rewrite,omitempty"`
	// Types that are valid to be assigned to HostRewriteSpecifier:
	//	*RouteAction_HostRewrite
	//	*RouteAction_AutoHostRewrite
	HostRewriteSpecifier isRouteAction_HostRewriteSpecifier `protobuf_oneof:"host_rewrite_specifier"`
	// Specifies the upstream timeout for the route. If not specified, the default is 15s. This
	// spans between the point at which the entire downstream request (i.e. end-of-stream) has been
	// processed and when the upstream response has been completely processed.
	//
	// .. note::
	//
	//   This timeout includes all retries. See also
	//   :ref:`config_http_filters_router_x-envoy-upstream-rq-timeout-ms`,
	//   :ref:`config_http_filters_router_x-envoy-upstream-rq-per-try-timeout-ms`, and the
	//   :ref:`retry overview <arch_overview_http_routing_retry>`.
	Timeout *time.Duration `protobuf:"bytes,8,opt,name=timeout,proto3,stdduration" json:"timeout,omitempty"`
	// Specifies the idle timeout for the route. If not specified, there is no per-route idle timeout,
	// although the connection manager wide :ref:`stream_idle_timeout
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.stream_idle_timeout>`
	// will still apply. A value of 0 will completely disable the route's idle timeout, even if a
	// connection manager stream idle timeout is configured.
	//
	// The idle timeout is distinct to :ref:`timeout
	// <envoy_api_field_route.RouteAction.timeout>`, which provides an upper bound
	// on the upstream response time; :ref:`idle_timeout
	// <envoy_api_field_route.RouteAction.idle_timeout>` instead bounds the amount
	// of time the request's stream may be idle.
	//
	// After header decoding, the idle timeout will apply on downstream and
	// upstream request events. Each time an encode/decode event for headers or
	// data is processed for the stream, the timer will be reset. If the timeout
	// fires, the stream is terminated with a 408 Request Timeout error code if no
	// upstream response header has been received, otherwise a stream reset
	// occurs.
	IdleTimeout *time.Duration `protobuf:"bytes,24,opt,name=idle_timeout,json=idleTimeout,proto3,stdduration" json:"idle_timeout,omitempty"`
	// Indicates that the route has a retry policy. Note that if this is set,
	// it'll take precedence over the virtual host level retry policy entirely
	// (e.g.: policies are not merged, most internal one becomes the enforced policy).
	RetryPolicy *RetryPolicy `protobuf:"bytes,9,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
	// Indicates that the route has a request mirroring policy.
	RequestMirrorPolicy *RouteAction_RequestMirrorPolicy `protobuf:"bytes,10,opt,name=request_mirror_policy,json=requestMirrorPolicy,proto3" json:"request_mirror_policy,omitempty"`
	// Optionally specifies the :ref:`routing priority <arch_overview_http_routing_priority>`.
	// [#comment:TODO(htuch): add (validate.rules).enum.defined_only = true once
	// https://github.com/lyft/protoc-gen-validate/issues/42 is resolved.]
	Priority core.RoutingPriority `protobuf:"varint,11,opt,name=priority,proto3,enum=envoy.api.v2.core.RoutingPriority" json:"priority,omitempty"`
	// Specifies a set of rate limit configurations that could be applied to the
	// route.
	RateLimits []*RateLimit `protobuf:"bytes,13,rep,name=rate_limits,json=rateLimits,proto3" json:"rate_limits,omitempty"`
	// Specifies if the rate limit filter should include the virtual host rate
	// limits. By default, if the route configured rate limits, the virtual host
	// :ref:`rate_limits <envoy_api_field_route.VirtualHost.rate_limits>` are not applied to the
	// request.
	IncludeVhRateLimits *types.BoolValue `protobuf:"bytes,14,opt,name=include_vh_rate_limits,json=includeVhRateLimits,proto3" json:"include_vh_rate_limits,omitempty"`
	// Specifies a list of hash policies to use for ring hash load balancing. Each
	// hash policy is evaluated individually and the combined result is used to
	// route the request. The method of combination is deterministic such that
	// identical lists of hash policies will produce the same hash. Since a hash
	// policy examines specific parts of a request, it can fail to produce a hash
	// (i.e. if the hashed header is not present). If (and only if) all configured
	// hash policies fail to generate a hash, no hash will be produced for
	// the route. In this case, the behavior is the same as if no hash policies
	// were specified (i.e. the ring hash load balancer will choose a random
	// backend). If a hash policy has the "terminal" attribute set to true, and
	// there is already a hash generated, the hash is returned immediately,
	// ignoring the rest of the hash policy list.
	HashPolicy []*RouteAction_HashPolicy `protobuf:"bytes,15,rep,name=hash_policy,json=hashPolicy,proto3" json:"hash_policy,omitempty"`
	// Indicates that the route has a CORS policy.
	Cors *CorsPolicy `protobuf:"bytes,17,opt,name=cors,proto3" json:"cors,omitempty"`
	// If present, and the request is a gRPC request, use the
	// `grpc-timeout header <https://github.com/grpc/grpc/blob/master/doc/PROTOCOL-HTTP2.md>`_,
	// or its default value (infinity) instead of
	// :ref:`timeout <envoy_api_field_route.RouteAction.timeout>`, but limit the applied timeout
	// to the maximum value specified here. If configured as 0, the maximum allowed timeout for
	// gRPC requests is infinity. If not configured at all, the `grpc-timeout` header is not used
	// and gRPC requests time out like any other requests using
	// :ref:`timeout <envoy_api_field_route.RouteAction.timeout>` or its default.
	// This can be used to prevent unexpected upstream request timeouts due to potentially long
	// time gaps between gRPC request and response in gRPC streaming mode.
	MaxGrpcTimeout *time.Duration `protobuf:"bytes,23,opt,name=max_grpc_timeout,json=maxGrpcTimeout,proto3,stdduration" json:"max_grpc_timeout,omitempty"`
	// If present, Envoy will adjust the timeout provided by the `grpc-timeout` header by subtracting
	// the provided duration from the header. This is useful in allowing Envoy to set its global
	// timeout to be less than that of the deadline imposed by the calling client, which makes it more
	// likely that Envoy will handle the timeout instead of having the call canceled by the client.
	// The offset will only be applied if the provided grpc_timeout is greater than the offset. This
	// ensures that the offset will only ever decrease the timeout and never set it to 0 (meaning
	// infinity).
	GrpcTimeoutOffset      *time.Duration                     `protobuf:"bytes,28,opt,name=grpc_timeout_offset,json=grpcTimeoutOffset,proto3,stdduration" json:"grpc_timeout_offset,omitempty"`
	UpgradeConfigs         []*RouteAction_UpgradeConfig       `protobuf:"bytes,25,rep,name=upgrade_configs,json=upgradeConfigs,proto3" json:"upgrade_configs,omitempty"`
	InternalRedirectAction RouteAction_InternalRedirectAction `protobuf:"varint,26,opt,name=internal_redirect_action,json=internalRedirectAction,proto3,enum=envoy.api.v2.route.RouteAction_InternalRedirectAction" json:"internal_redirect_action,omitempty"`
	// Indicates that the route has a hedge policy. Note that if this is set,
	// it'll take precedence over the virtual host level hedge policy entirely
	// (e.g.: policies are not merged, most internal one becomes the enforced policy).
	// [#not-implemented-hide:]
	HedgePolicy          *HedgePolicy `protobuf:"bytes,27,opt,name=hedge_policy,json=hedgePolicy,proto3" json:"hedge_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *RouteAction) Reset()         { *m = RouteAction{} }
func (m *RouteAction) String() string { return proto.CompactTextString(m) }
func (*RouteAction) ProtoMessage()    {}
func (*RouteAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{5}
}
func (m *RouteAction) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RouteAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteAction.Merge(m, src)
}
func (m *RouteAction) XXX_Size() int {
	return m.Size()
}
func (m *RouteAction) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteAction.DiscardUnknown(m)
}

var xxx_messageInfo_RouteAction proto.InternalMessageInfo

type isRouteAction_ClusterSpecifier interface {
	isRouteAction_ClusterSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}
type isRouteAction_HostRewriteSpecifier interface {
	isRouteAction_HostRewriteSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RouteAction_Cluster struct {
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3,oneof"`
}
type RouteAction_ClusterHeader struct {
	ClusterHeader string `protobuf:"bytes,2,opt,name=cluster_header,json=clusterHeader,proto3,oneof"`
}
type RouteAction_WeightedClusters struct {
	WeightedClusters *WeightedCluster `protobuf:"bytes,3,opt,name=weighted_clusters,json=weightedClusters,proto3,oneof"`
}
type RouteAction_HostRewrite struct {
	HostRewrite string `protobuf:"bytes,6,opt,name=host_rewrite,json=hostRewrite,proto3,oneof"`
}
type RouteAction_AutoHostRewrite struct {
	AutoHostRewrite *types.BoolValue `protobuf:"bytes,7,opt,name=auto_host_rewrite,json=autoHostRewrite,proto3,oneof"`
}

func (*RouteAction_Cluster) isRouteAction_ClusterSpecifier()             {}
func (*RouteAction_ClusterHeader) isRouteAction_ClusterSpecifier()       {}
func (*RouteAction_WeightedClusters) isRouteAction_ClusterSpecifier()    {}
func (*RouteAction_HostRewrite) isRouteAction_HostRewriteSpecifier()     {}
func (*RouteAction_AutoHostRewrite) isRouteAction_HostRewriteSpecifier() {}

func (m *RouteAction) GetClusterSpecifier() isRouteAction_ClusterSpecifier {
	if m != nil {
		return m.ClusterSpecifier
	}
	return nil
}
func (m *RouteAction) GetHostRewriteSpecifier() isRouteAction_HostRewriteSpecifier {
	if m != nil {
		return m.HostRewriteSpecifier
	}
	return nil
}

func (m *RouteAction) GetCluster() string {
	if x, ok := m.GetClusterSpecifier().(*RouteAction_Cluster); ok {
		return x.Cluster
	}
	return ""
}

func (m *RouteAction) GetClusterHeader() string {
	if x, ok := m.GetClusterSpecifier().(*RouteAction_ClusterHeader); ok {
		return x.ClusterHeader
	}
	return ""
}

func (m *RouteAction) GetWeightedClusters() *WeightedCluster {
	if x, ok := m.GetClusterSpecifier().(*RouteAction_WeightedClusters); ok {
		return x.WeightedClusters
	}
	return nil
}

func (m *RouteAction) GetClusterNotFoundResponseCode() RouteAction_ClusterNotFoundResponseCode {
	if m != nil {
		return m.ClusterNotFoundResponseCode
	}
	return RouteAction_SERVICE_UNAVAILABLE
}

func (m *RouteAction) GetMetadataMatch() *core.Metadata {
	if m != nil {
		return m.MetadataMatch
	}
	return nil
}

func (m *RouteAction) GetPrefixRewrite() string {
	if m != nil {
		return m.PrefixRewrite
	}
	return ""
}

func (m *RouteAction) GetHostRewrite() string {
	if x, ok := m.GetHostRewriteSpecifier().(*RouteAction_HostRewrite); ok {
		return x.HostRewrite
	}
	return ""
}

func (m *RouteAction) GetAutoHostRewrite() *types.BoolValue {
	if x, ok := m.GetHostRewriteSpecifier().(*RouteAction_AutoHostRewrite); ok {
		return x.AutoHostRewrite
	}
	return nil
}

func (m *RouteAction) GetTimeout() *time.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *RouteAction) GetIdleTimeout() *time.Duration {
	if m != nil {
		return m.IdleTimeout
	}
	return nil
}

func (m *RouteAction) GetRetryPolicy() *RetryPolicy {
	if m != nil {
		return m.RetryPolicy
	}
	return nil
}

func (m *RouteAction) GetRequestMirrorPolicy() *RouteAction_RequestMirrorPolicy {
	if m != nil {
		return m.RequestMirrorPolicy
	}
	return nil
}

func (m *RouteAction) GetPriority() core.RoutingPriority {
	if m != nil {
		return m.Priority
	}
	return core.RoutingPriority_DEFAULT
}

func (m *RouteAction) GetRateLimits() []*RateLimit {
	if m != nil {
		return m.RateLimits
	}
	return nil
}

func (m *RouteAction) GetIncludeVhRateLimits() *types.BoolValue {
	if m != nil {
		return m.IncludeVhRateLimits
	}
	return nil
}

func (m *RouteAction) GetHashPolicy() []*RouteAction_HashPolicy {
	if m != nil {
		return m.HashPolicy
	}
	return nil
}

func (m *RouteAction) GetCors() *CorsPolicy {
	if m != nil {
		return m.Cors
	}
	return nil
}

func (m *RouteAction) GetMaxGrpcTimeout() *time.Duration {
	if m != nil {
		return m.MaxGrpcTimeout
	}
	return nil
}

func (m *RouteAction) GetGrpcTimeoutOffset() *time.Duration {
	if m != nil {
		return m.GrpcTimeoutOffset
	}
	return nil
}

func (m *RouteAction) GetUpgradeConfigs() []*RouteAction_UpgradeConfig {
	if m != nil {
		return m.UpgradeConfigs
	}
	return nil
}

func (m *RouteAction) GetInternalRedirectAction() RouteAction_InternalRedirectAction {
	if m != nil {
		return m.InternalRedirectAction
	}
	return RouteAction_PASS_THROUGH_INTERNAL_REDIRECT
}

func (m *RouteAction) GetHedgePolicy() *HedgePolicy {
	if m != nil {
		return m.HedgePolicy
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RouteAction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RouteAction_OneofMarshaler, _RouteAction_OneofUnmarshaler, _RouteAction_OneofSizer, []interface{}{
		(*RouteAction_Cluster)(nil),
		(*RouteAction_ClusterHeader)(nil),
		(*RouteAction_WeightedClusters)(nil),
		(*RouteAction_HostRewrite)(nil),
		(*RouteAction_AutoHostRewrite)(nil),
	}
}

func _RouteAction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RouteAction)
	// cluster_specifier
	switch x := m.ClusterSpecifier.(type) {
	case *RouteAction_Cluster:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Cluster)
	case *RouteAction_ClusterHeader:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ClusterHeader)
	case *RouteAction_WeightedClusters:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WeightedClusters); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RouteAction.ClusterSpecifier has unexpected type %T", x)
	}
	// host_rewrite_specifier
	switch x := m.HostRewriteSpecifier.(type) {
	case *RouteAction_HostRewrite:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.HostRewrite)
	case *RouteAction_AutoHostRewrite:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AutoHostRewrite); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RouteAction.HostRewriteSpecifier has unexpected type %T", x)
	}
	return nil
}

func _RouteAction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RouteAction)
	switch tag {
	case 1: // cluster_specifier.cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ClusterSpecifier = &RouteAction_Cluster{x}
		return true, err
	case 2: // cluster_specifier.cluster_header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ClusterSpecifier = &RouteAction_ClusterHeader{x}
		return true, err
	case 3: // cluster_specifier.weighted_clusters
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WeightedCluster)
		err := b.DecodeMessage(msg)
		m.ClusterSpecifier = &RouteAction_WeightedClusters{msg}
		return true, err
	case 6: // host_rewrite_specifier.host_rewrite
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.HostRewriteSpecifier = &RouteAction_HostRewrite{x}
		return true, err
	case 7: // host_rewrite_specifier.auto_host_rewrite
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.BoolValue)
		err := b.DecodeMessage(msg)
		m.HostRewriteSpecifier = &RouteAction_AutoHostRewrite{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RouteAction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RouteAction)
	// cluster_specifier
	switch x := m.ClusterSpecifier.(type) {
	case *RouteAction_Cluster:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Cluster)))
		n += len(x.Cluster)
	case *RouteAction_ClusterHeader:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ClusterHeader)))
		n += len(x.ClusterHeader)
	case *RouteAction_WeightedClusters:
		s := proto.Size(x.WeightedClusters)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// host_rewrite_specifier
	switch x := m.HostRewriteSpecifier.(type) {
	case *RouteAction_HostRewrite:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.HostRewrite)))
		n += len(x.HostRewrite)
	case *RouteAction_AutoHostRewrite:
		s := proto.Size(x.AutoHostRewrite)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The router is capable of shadowing traffic from one cluster to another. The current
// implementation is "fire and forget," meaning Envoy will not wait for the shadow cluster to
// respond before returning the response from the primary cluster. All normal statistics are
// collected for the shadow cluster making this feature useful for testing.
//
// During shadowing, the host/authority header is altered such that *-shadow* is appended. This is
// useful for logging. For example, *cluster1* becomes *cluster1-shadow*.
type RouteAction_RequestMirrorPolicy struct {
	// Specifies the cluster that requests will be mirrored to. The cluster must
	// exist in the cluster manager configuration.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// If not specified, all requests to the target cluster will be mirrored. If
	// specified, Envoy will lookup the runtime key to get the % of requests to
	// mirror. Valid values are from 0 to 10000, allowing for increments of
	// 0.01% of requests to be mirrored. If the runtime key is specified in the
	// configuration but not present in runtime, 0 is the default and thus 0% of
	// requests will be mirrored.
	//
	// .. attention::
	//
	//   **This field is deprecated**. Set the
	//   :ref:`runtime_fraction
	//   <envoy_api_field_route.RouteAction.RequestMirrorPolicy.runtime_fraction>` field instead.
	RuntimeKey string `protobuf:"bytes,2,opt,name=runtime_key,json=runtimeKey,proto3" json:"runtime_key,omitempty"` // Deprecated: Do not use.
	// If both :ref:`runtime_key
	// <envoy_api_field_route.RouteAction.RequestMirrorPolicy.runtime_key>` and this field are not
	// specified, all requests to the target cluster will be mirrored.
	//
	// If specified, this field takes precedence over the `runtime_key` field and requests must also
	// fall under the percentage of matches indicated by this field.
	//
	// For some fraction N/D, a random number in the range [0,D) is selected. If the
	// number is <= the value of the numerator N, or if the key is not present, the default
	// value, the request will be mirrored.
	//
	// .. note::
	//
	//   Parsing this field is implemented such that the runtime key's data may be represented
	//   as a :ref:`FractionalPercent <envoy_api_msg_type.FractionalPercent>` proto represented
	//   as JSON/YAML and may also be represented as an integer with the assumption that the value
	//   is an integral percentage out of 100. For instance, a runtime key lookup returning the
	//   value "42" would parse as a `FractionalPercent` whose numerator is 42 and denominator is
	//   HUNDRED. This is behaviour is different to that of the deprecated `runtime_key` field,
	//   where the implicit denominator is 10000.
	RuntimeFraction      *core.RuntimeFractionalPercent `protobuf:"bytes,3,opt,name=runtime_fraction,json=runtimeFraction,proto3" json:"runtime_fraction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *RouteAction_RequestMirrorPolicy) Reset()         { *m = RouteAction_RequestMirrorPolicy{} }
func (m *RouteAction_RequestMirrorPolicy) String() string { return proto.CompactTextString(m) }
func (*RouteAction_RequestMirrorPolicy) ProtoMessage()    {}
func (*RouteAction_RequestMirrorPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{5, 0}
}
func (m *RouteAction_RequestMirrorPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteAction_RequestMirrorPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RouteAction_RequestMirrorPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteAction_RequestMirrorPolicy.Merge(m, src)
}
func (m *RouteAction_RequestMirrorPolicy) XXX_Size() int {
	return m.Size()
}
func (m *RouteAction_RequestMirrorPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteAction_RequestMirrorPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_RouteAction_RequestMirrorPolicy proto.InternalMessageInfo

func (m *RouteAction_RequestMirrorPolicy) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

// Deprecated: Do not use.
func (m *RouteAction_RequestMirrorPolicy) GetRuntimeKey() string {
	if m != nil {
		return m.RuntimeKey
	}
	return ""
}

func (m *RouteAction_RequestMirrorPolicy) GetRuntimeFraction() *core.RuntimeFractionalPercent {
	if m != nil {
		return m.RuntimeFraction
	}
	return nil
}

// Specifies the route's hashing policy if the upstream cluster uses a hashing :ref:`load balancer
// <arch_overview_load_balancing_types>`.
type RouteAction_HashPolicy struct {
	// Types that are valid to be assigned to PolicySpecifier:
	//	*RouteAction_HashPolicy_Header_
	//	*RouteAction_HashPolicy_Cookie_
	//	*RouteAction_HashPolicy_ConnectionProperties_
	PolicySpecifier isRouteAction_HashPolicy_PolicySpecifier `protobuf_oneof:"policy_specifier"`
	// The flag that shortcircuits the hash computing. This field provides a
	// 'fallback' style of configuration: "if a terminal policy doesn't work,
	// fallback to rest of the policy list", it saves time when the terminal
	// policy works.
	//
	// If true, and there is already a hash computed, ignore rest of the
	// list of hash polices.
	// For example, if the following hash methods are configured:
	//
	//  ========= ========
	//  specifier terminal
	//  ========= ========
	//  Header A  true
	//  Header B  false
	//  Header C  false
	//  ========= ========
	//
	// The generateHash process ends if policy "header A" generates a hash, as
	// it's a terminal policy.
	Terminal             bool     `protobuf:"varint,4,opt,name=terminal,proto3" json:"terminal,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RouteAction_HashPolicy) Reset()         { *m = RouteAction_HashPolicy{} }
func (m *RouteAction_HashPolicy) String() string { return proto.CompactTextString(m) }
func (*RouteAction_HashPolicy) ProtoMessage()    {}
func (*RouteAction_HashPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{5, 1}
}
func (m *RouteAction_HashPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteAction_HashPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RouteAction_HashPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteAction_HashPolicy.Merge(m, src)
}
func (m *RouteAction_HashPolicy) XXX_Size() int {
	return m.Size()
}
func (m *RouteAction_HashPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteAction_HashPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_RouteAction_HashPolicy proto.InternalMessageInfo

type isRouteAction_HashPolicy_PolicySpecifier interface {
	isRouteAction_HashPolicy_PolicySpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RouteAction_HashPolicy_Header_ struct {
	Header *RouteAction_HashPolicy_Header `protobuf:"bytes,1,opt,name=header,proto3,oneof"`
}
type RouteAction_HashPolicy_Cookie_ struct {
	Cookie *RouteAction_HashPolicy_Cookie `protobuf:"bytes,2,opt,name=cookie,proto3,oneof"`
}
type RouteAction_HashPolicy_ConnectionProperties_ struct {
	ConnectionProperties *RouteAction_HashPolicy_ConnectionProperties `protobuf:"bytes,3,opt,name=connection_properties,json=connectionProperties,proto3,oneof"`
}

func (*RouteAction_HashPolicy_Header_) isRouteAction_HashPolicy_PolicySpecifier()               {}
func (*RouteAction_HashPolicy_Cookie_) isRouteAction_HashPolicy_PolicySpecifier()               {}
func (*RouteAction_HashPolicy_ConnectionProperties_) isRouteAction_HashPolicy_PolicySpecifier() {}

func (m *RouteAction_HashPolicy) GetPolicySpecifier() isRouteAction_HashPolicy_PolicySpecifier {
	if m != nil {
		return m.PolicySpecifier
	}
	return nil
}

func (m *RouteAction_HashPolicy) GetHeader() *RouteAction_HashPolicy_Header {
	if x, ok := m.GetPolicySpecifier().(*RouteAction_HashPolicy_Header_); ok {
		return x.Header
	}
	return nil
}

func (m *RouteAction_HashPolicy) GetCookie() *RouteAction_HashPolicy_Cookie {
	if x, ok := m.GetPolicySpecifier().(*RouteAction_HashPolicy_Cookie_); ok {
		return x.Cookie
	}
	return nil
}

func (m *RouteAction_HashPolicy) GetConnectionProperties() *RouteAction_HashPolicy_ConnectionProperties {
	if x, ok := m.GetPolicySpecifier().(*RouteAction_HashPolicy_ConnectionProperties_); ok {
		return x.ConnectionProperties
	}
	return nil
}

func (m *RouteAction_HashPolicy) GetTerminal() bool {
	if m != nil {
		return m.Terminal
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RouteAction_HashPolicy) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RouteAction_HashPolicy_OneofMarshaler, _RouteAction_HashPolicy_OneofUnmarshaler, _RouteAction_HashPolicy_OneofSizer, []interface{}{
		(*RouteAction_HashPolicy_Header_)(nil),
		(*RouteAction_HashPolicy_Cookie_)(nil),
		(*RouteAction_HashPolicy_ConnectionProperties_)(nil),
	}
}

func _RouteAction_HashPolicy_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RouteAction_HashPolicy)
	// policy_specifier
	switch x := m.PolicySpecifier.(type) {
	case *RouteAction_HashPolicy_Header_:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Header); err != nil {
			return err
		}
	case *RouteAction_HashPolicy_Cookie_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Cookie); err != nil {
			return err
		}
	case *RouteAction_HashPolicy_ConnectionProperties_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConnectionProperties); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RouteAction_HashPolicy.PolicySpecifier has unexpected type %T", x)
	}
	return nil
}

func _RouteAction_HashPolicy_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RouteAction_HashPolicy)
	switch tag {
	case 1: // policy_specifier.header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RouteAction_HashPolicy_Header)
		err := b.DecodeMessage(msg)
		m.PolicySpecifier = &RouteAction_HashPolicy_Header_{msg}
		return true, err
	case 2: // policy_specifier.cookie
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RouteAction_HashPolicy_Cookie)
		err := b.DecodeMessage(msg)
		m.PolicySpecifier = &RouteAction_HashPolicy_Cookie_{msg}
		return true, err
	case 3: // policy_specifier.connection_properties
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RouteAction_HashPolicy_ConnectionProperties)
		err := b.DecodeMessage(msg)
		m.PolicySpecifier = &RouteAction_HashPolicy_ConnectionProperties_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RouteAction_HashPolicy_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RouteAction_HashPolicy)
	// policy_specifier
	switch x := m.PolicySpecifier.(type) {
	case *RouteAction_HashPolicy_Header_:
		s := proto.Size(x.Header)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RouteAction_HashPolicy_Cookie_:
		s := proto.Size(x.Cookie)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RouteAction_HashPolicy_ConnectionProperties_:
		s := proto.Size(x.ConnectionProperties)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type RouteAction_HashPolicy_Header struct {
	// The name of the request header that will be used to obtain the hash
	// key. If the request header is not present, no hash will be produced.
	HeaderName           string   `protobuf:"bytes,1,opt,name=header_name,json=headerName,proto3" json:"header_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RouteAction_HashPolicy_Header) Reset()         { *m = RouteAction_HashPolicy_Header{} }
func (m *RouteAction_HashPolicy_Header) String() string { return proto.CompactTextString(m) }
func (*RouteAction_HashPolicy_Header) ProtoMessage()    {}
func (*RouteAction_HashPolicy_Header) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{5, 1, 0}
}
func (m *RouteAction_HashPolicy_Header) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteAction_HashPolicy_Header) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RouteAction_HashPolicy_Header) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteAction_HashPolicy_Header.Merge(m, src)
}
func (m *RouteAction_HashPolicy_Header) XXX_Size() int {
	return m.Size()
}
func (m *RouteAction_HashPolicy_Header) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteAction_HashPolicy_Header.DiscardUnknown(m)
}

var xxx_messageInfo_RouteAction_HashPolicy_Header proto.InternalMessageInfo

func (m *RouteAction_HashPolicy_Header) GetHeaderName() string {
	if m != nil {
		return m.HeaderName
	}
	return ""
}

// Envoy supports two types of cookie affinity:
//
// 1. Passive. Envoy takes a cookie that's present in the cookies header and
//    hashes on its value.
//
// 2. Generated. Envoy generates and sets a cookie with an expiration (TTL)
//    on the first request from the client in its response to the client,
//    based on the endpoint the request gets sent to. The client then
//    presents this on the next and all subsequent requests. The hash of
//    this is sufficient to ensure these requests get sent to the same
//    endpoint. The cookie is generated by hashing the source and
//    destination ports and addresses so that multiple independent HTTP2
//    streams on the same connection will independently receive the same
//    cookie, even if they arrive at the Envoy simultaneously.
type RouteAction_HashPolicy_Cookie struct {
	// The name of the cookie that will be used to obtain the hash key. If the
	// cookie is not present and ttl below is not set, no hash will be
	// produced.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If specified, a cookie with the TTL will be generated if the cookie is
	// not present. If the TTL is present and zero, the generated cookie will
	// be a session cookie.
	Ttl *time.Duration `protobuf:"bytes,2,opt,name=ttl,proto3,stdduration" json:"ttl,omitempty"`
	// The name of the path for the cookie. If no path is specified here, no path
	// will be set for the cookie.
	Path                 string   `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RouteAction_HashPolicy_Cookie) Reset()         { *m = RouteAction_HashPolicy_Cookie{} }
func (m *RouteAction_HashPolicy_Cookie) String() string { return proto.CompactTextString(m) }
func (*RouteAction_HashPolicy_Cookie) ProtoMessage()    {}
func (*RouteAction_HashPolicy_Cookie) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{5, 1, 1}
}
func (m *RouteAction_HashPolicy_Cookie) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteAction_HashPolicy_Cookie) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RouteAction_HashPolicy_Cookie) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteAction_HashPolicy_Cookie.Merge(m, src)
}
func (m *RouteAction_HashPolicy_Cookie) XXX_Size() int {
	return m.Size()
}
func (m *RouteAction_HashPolicy_Cookie) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteAction_HashPolicy_Cookie.DiscardUnknown(m)
}

var xxx_messageInfo_RouteAction_HashPolicy_Cookie proto.InternalMessageInfo

func (m *RouteAction_HashPolicy_Cookie) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RouteAction_HashPolicy_Cookie) GetTtl() *time.Duration {
	if m != nil {
		return m.Ttl
	}
	return nil
}

func (m *RouteAction_HashPolicy_Cookie) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

type RouteAction_HashPolicy_ConnectionProperties struct {
	// Hash on source IP address.
	SourceIp             bool     `protobuf:"varint,1,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RouteAction_HashPolicy_ConnectionProperties) Reset() {
	*m = RouteAction_HashPolicy_ConnectionProperties{}
}
func (m *RouteAction_HashPolicy_ConnectionProperties) String() string {
	return proto.CompactTextString(m)
}
func (*RouteAction_HashPolicy_ConnectionProperties) ProtoMessage() {}
func (*RouteAction_HashPolicy_ConnectionProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{5, 1, 2}
}
func (m *RouteAction_HashPolicy_ConnectionProperties) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteAction_HashPolicy_ConnectionProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RouteAction_HashPolicy_ConnectionProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteAction_HashPolicy_ConnectionProperties.Merge(m, src)
}
func (m *RouteAction_HashPolicy_ConnectionProperties) XXX_Size() int {
	return m.Size()
}
func (m *RouteAction_HashPolicy_ConnectionProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteAction_HashPolicy_ConnectionProperties.DiscardUnknown(m)
}

var xxx_messageInfo_RouteAction_HashPolicy_ConnectionProperties proto.InternalMessageInfo

func (m *RouteAction_HashPolicy_ConnectionProperties) GetSourceIp() bool {
	if m != nil {
		return m.SourceIp
	}
	return false
}

// Allows enabling and disabling upgrades on a per-route basis.
// This overrides any enabled/disabled upgrade filter chain specified in the
// HttpConnectionManager
// :ref:upgrade_configs`
// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.upgrade_configs>`
// but does not affect any custom filter chain specified there.
type RouteAction_UpgradeConfig struct {
	// The case-insensitive name of this upgrade, e.g. "websocket".
	// For each upgrade type present in upgrade_configs, requests with
	// Upgrade: [upgrade_type] will be proxied upstream.
	UpgradeType string `protobuf:"bytes,1,opt,name=upgrade_type,json=upgradeType,proto3" json:"upgrade_type,omitempty"`
	// Determines if upgrades are available on this route. Defaults to true.
	Enabled              *types.BoolValue `protobuf:"bytes,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *RouteAction_UpgradeConfig) Reset()         { *m = RouteAction_UpgradeConfig{} }
func (m *RouteAction_UpgradeConfig) String() string { return proto.CompactTextString(m) }
func (*RouteAction_UpgradeConfig) ProtoMessage()    {}
func (*RouteAction_UpgradeConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{5, 2}
}
func (m *RouteAction_UpgradeConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteAction_UpgradeConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RouteAction_UpgradeConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteAction_UpgradeConfig.Merge(m, src)
}
func (m *RouteAction_UpgradeConfig) XXX_Size() int {
	return m.Size()
}
func (m *RouteAction_UpgradeConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteAction_UpgradeConfig.DiscardUnknown(m)
}

var xxx_messageInfo_RouteAction_UpgradeConfig proto.InternalMessageInfo

func (m *RouteAction_UpgradeConfig) GetUpgradeType() string {
	if m != nil {
		return m.UpgradeType
	}
	return ""
}

func (m *RouteAction_UpgradeConfig) GetEnabled() *types.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

// HTTP retry :ref:`architecture overview <arch_overview_http_routing_retry>`.
// [#comment:next free field: 9]
type RetryPolicy struct {
	// Specifies the conditions under which retry takes place. These are the same
	// conditions documented for :ref:`config_http_filters_router_x-envoy-retry-on` and
	// :ref:`config_http_filters_router_x-envoy-retry-grpc-on`.
	RetryOn string `protobuf:"bytes,1,opt,name=retry_on,json=retryOn,proto3" json:"retry_on,omitempty"`
	// Specifies the allowed number of retries. This parameter is optional and
	// defaults to 1. These are the same conditions documented for
	// :ref:`config_http_filters_router_x-envoy-max-retries`.
	NumRetries *types.UInt32Value `protobuf:"bytes,2,opt,name=num_retries,json=numRetries,proto3" json:"num_retries,omitempty"`
	// Specifies a non-zero upstream timeout per retry attempt. This parameter is optional. The
	// same conditions documented for
	// :ref:`config_http_filters_router_x-envoy-upstream-rq-per-try-timeout-ms` apply.
	//
	// .. note::
	//
	//   If left unspecified, Envoy will use the global
	//   :ref:`route timeout <envoy_api_field_route.RouteAction.timeout>` for the request.
	//   Consequently, when using a :ref:`5xx <config_http_filters_router_x-envoy-retry-on>` based
	//   retry policy, a request that times out will not be retried as the total timeout budget
	//   would have been exhausted.
	PerTryTimeout *time.Duration `protobuf:"bytes,3,opt,name=per_try_timeout,json=perTryTimeout,proto3,stdduration" json:"per_try_timeout,omitempty"`
	// Specifies an implementation of a RetryPriority which is used to determine the
	// distribution of load across priorities used for retries. Refer to
	// :ref:`retry plugin configuration <arch_overview_http_retry_plugins>` for more details.
	RetryPriority *RetryPolicy_RetryPriority `protobuf:"bytes,4,opt,name=retry_priority,json=retryPriority,proto3" json:"retry_priority,omitempty"`
	// Specifies a collection of RetryHostPredicates that will be consulted when selecting a host
	// for retries. If any of the predicates reject the host, host selection will be reattempted.
	// Refer to :ref:`retry plugin configuration <arch_overview_http_retry_plugins>` for more
	// details.
	RetryHostPredicate []*RetryPolicy_RetryHostPredicate `protobuf:"bytes,5,rep,name=retry_host_predicate,json=retryHostPredicate,proto3" json:"retry_host_predicate,omitempty"`
	// The maximum number of times host selection will be reattempted before giving up, at which
	// point the host that was last selected will be routed to. If unspecified, this will default to
	// retrying once.
	HostSelectionRetryMaxAttempts int64 `protobuf:"varint,6,opt,name=host_selection_retry_max_attempts,json=hostSelectionRetryMaxAttempts,proto3" json:"host_selection_retry_max_attempts,omitempty"`
	// HTTP status codes that should trigger a retry in addition to those specified by retry_on.
	RetriableStatusCodes []uint32 `protobuf:"varint,7,rep,packed,name=retriable_status_codes,json=retriableStatusCodes,proto3" json:"retriable_status_codes,omitempty"`
	// Specifies parameters that control retry back off. This parameter is optional, in which case the
	// default base interval is 25 milliseconds or, if set, the current value of the
	// `upstream.base_retry_backoff_ms` runtime parameter. The default maximum interval is 10 times
	// the base interval. The documentation for :ref:`config_http_filters_router_x-envoy-max-retries`
	// describes Envoy's back-off algorithm.
	RetryBackOff         *RetryPolicy_RetryBackOff `protobuf:"bytes,8,opt,name=retry_back_off,json=retryBackOff,proto3" json:"retry_back_off,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *RetryPolicy) Reset()         { *m = RetryPolicy{} }
func (m *RetryPolicy) String() string { return proto.CompactTextString(m) }
func (*RetryPolicy) ProtoMessage()    {}
func (*RetryPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{6}
}
func (m *RetryPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RetryPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RetryPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetryPolicy.Merge(m, src)
}
func (m *RetryPolicy) XXX_Size() int {
	return m.Size()
}
func (m *RetryPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_RetryPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_RetryPolicy proto.InternalMessageInfo

func (m *RetryPolicy) GetRetryOn() string {
	if m != nil {
		return m.RetryOn
	}
	return ""
}

func (m *RetryPolicy) GetNumRetries() *types.UInt32Value {
	if m != nil {
		return m.NumRetries
	}
	return nil
}

func (m *RetryPolicy) GetPerTryTimeout() *time.Duration {
	if m != nil {
		return m.PerTryTimeout
	}
	return nil
}

func (m *RetryPolicy) GetRetryPriority() *RetryPolicy_RetryPriority {
	if m != nil {
		return m.RetryPriority
	}
	return nil
}

func (m *RetryPolicy) GetRetryHostPredicate() []*RetryPolicy_RetryHostPredicate {
	if m != nil {
		return m.RetryHostPredicate
	}
	return nil
}

func (m *RetryPolicy) GetHostSelectionRetryMaxAttempts() int64 {
	if m != nil {
		return m.HostSelectionRetryMaxAttempts
	}
	return 0
}

func (m *RetryPolicy) GetRetriableStatusCodes() []uint32 {
	if m != nil {
		return m.RetriableStatusCodes
	}
	return nil
}

func (m *RetryPolicy) GetRetryBackOff() *RetryPolicy_RetryBackOff {
	if m != nil {
		return m.RetryBackOff
	}
	return nil
}

type RetryPolicy_RetryPriority struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to ConfigType:
	//	*RetryPolicy_RetryPriority_Config
	//	*RetryPolicy_RetryPriority_TypedConfig
	ConfigType           isRetryPolicy_RetryPriority_ConfigType `protobuf_oneof:"config_type"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *RetryPolicy_RetryPriority) Reset()         { *m = RetryPolicy_RetryPriority{} }
func (m *RetryPolicy_RetryPriority) String() string { return proto.CompactTextString(m) }
func (*RetryPolicy_RetryPriority) ProtoMessage()    {}
func (*RetryPolicy_RetryPriority) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{6, 0}
}
func (m *RetryPolicy_RetryPriority) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RetryPolicy_RetryPriority) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RetryPolicy_RetryPriority) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetryPolicy_RetryPriority.Merge(m, src)
}
func (m *RetryPolicy_RetryPriority) XXX_Size() int {
	return m.Size()
}
func (m *RetryPolicy_RetryPriority) XXX_DiscardUnknown() {
	xxx_messageInfo_RetryPolicy_RetryPriority.DiscardUnknown(m)
}

var xxx_messageInfo_RetryPolicy_RetryPriority proto.InternalMessageInfo

type isRetryPolicy_RetryPriority_ConfigType interface {
	isRetryPolicy_RetryPriority_ConfigType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RetryPolicy_RetryPriority_Config struct {
	Config *types.Struct `protobuf:"bytes,2,opt,name=config,proto3,oneof"`
}
type RetryPolicy_RetryPriority_TypedConfig struct {
	TypedConfig *types.Any `protobuf:"bytes,3,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

func (*RetryPolicy_RetryPriority_Config) isRetryPolicy_RetryPriority_ConfigType()      {}
func (*RetryPolicy_RetryPriority_TypedConfig) isRetryPolicy_RetryPriority_ConfigType() {}

func (m *RetryPolicy_RetryPriority) GetConfigType() isRetryPolicy_RetryPriority_ConfigType {
	if m != nil {
		return m.ConfigType
	}
	return nil
}

func (m *RetryPolicy_RetryPriority) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RetryPolicy_RetryPriority) GetConfig() *types.Struct {
	if x, ok := m.GetConfigType().(*RetryPolicy_RetryPriority_Config); ok {
		return x.Config
	}
	return nil
}

func (m *RetryPolicy_RetryPriority) GetTypedConfig() *types.Any {
	if x, ok := m.GetConfigType().(*RetryPolicy_RetryPriority_TypedConfig); ok {
		return x.TypedConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RetryPolicy_RetryPriority) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RetryPolicy_RetryPriority_OneofMarshaler, _RetryPolicy_RetryPriority_OneofUnmarshaler, _RetryPolicy_RetryPriority_OneofSizer, []interface{}{
		(*RetryPolicy_RetryPriority_Config)(nil),
		(*RetryPolicy_RetryPriority_TypedConfig)(nil),
	}
}

func _RetryPolicy_RetryPriority_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RetryPolicy_RetryPriority)
	// config_type
	switch x := m.ConfigType.(type) {
	case *RetryPolicy_RetryPriority_Config:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Config); err != nil {
			return err
		}
	case *RetryPolicy_RetryPriority_TypedConfig:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TypedConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RetryPolicy_RetryPriority.ConfigType has unexpected type %T", x)
	}
	return nil
}

func _RetryPolicy_RetryPriority_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RetryPolicy_RetryPriority)
	switch tag {
	case 2: // config_type.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Struct)
		err := b.DecodeMessage(msg)
		m.ConfigType = &RetryPolicy_RetryPriority_Config{msg}
		return true, err
	case 3: // config_type.typed_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Any)
		err := b.DecodeMessage(msg)
		m.ConfigType = &RetryPolicy_RetryPriority_TypedConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RetryPolicy_RetryPriority_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RetryPolicy_RetryPriority)
	// config_type
	switch x := m.ConfigType.(type) {
	case *RetryPolicy_RetryPriority_Config:
		s := proto.Size(x.Config)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RetryPolicy_RetryPriority_TypedConfig:
		s := proto.Size(x.TypedConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type RetryPolicy_RetryHostPredicate struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to ConfigType:
	//	*RetryPolicy_RetryHostPredicate_Config
	//	*RetryPolicy_RetryHostPredicate_TypedConfig
	ConfigType           isRetryPolicy_RetryHostPredicate_ConfigType `protobuf_oneof:"config_type"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *RetryPolicy_RetryHostPredicate) Reset()         { *m = RetryPolicy_RetryHostPredicate{} }
func (m *RetryPolicy_RetryHostPredicate) String() string { return proto.CompactTextString(m) }
func (*RetryPolicy_RetryHostPredicate) ProtoMessage()    {}
func (*RetryPolicy_RetryHostPredicate) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{6, 1}
}
func (m *RetryPolicy_RetryHostPredicate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RetryPolicy_RetryHostPredicate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RetryPolicy_RetryHostPredicate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetryPolicy_RetryHostPredicate.Merge(m, src)
}
func (m *RetryPolicy_RetryHostPredicate) XXX_Size() int {
	return m.Size()
}
func (m *RetryPolicy_RetryHostPredicate) XXX_DiscardUnknown() {
	xxx_messageInfo_RetryPolicy_RetryHostPredicate.DiscardUnknown(m)
}

var xxx_messageInfo_RetryPolicy_RetryHostPredicate proto.InternalMessageInfo

type isRetryPolicy_RetryHostPredicate_ConfigType interface {
	isRetryPolicy_RetryHostPredicate_ConfigType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RetryPolicy_RetryHostPredicate_Config struct {
	Config *types.Struct `protobuf:"bytes,2,opt,name=config,proto3,oneof"`
}
type RetryPolicy_RetryHostPredicate_TypedConfig struct {
	TypedConfig *types.Any `protobuf:"bytes,3,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

func (*RetryPolicy_RetryHostPredicate_Config) isRetryPolicy_RetryHostPredicate_ConfigType()      {}
func (*RetryPolicy_RetryHostPredicate_TypedConfig) isRetryPolicy_RetryHostPredicate_ConfigType() {}

func (m *RetryPolicy_RetryHostPredicate) GetConfigType() isRetryPolicy_RetryHostPredicate_ConfigType {
	if m != nil {
		return m.ConfigType
	}
	return nil
}

func (m *RetryPolicy_RetryHostPredicate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RetryPolicy_RetryHostPredicate) GetConfig() *types.Struct {
	if x, ok := m.GetConfigType().(*RetryPolicy_RetryHostPredicate_Config); ok {
		return x.Config
	}
	return nil
}

func (m *RetryPolicy_RetryHostPredicate) GetTypedConfig() *types.Any {
	if x, ok := m.GetConfigType().(*RetryPolicy_RetryHostPredicate_TypedConfig); ok {
		return x.TypedConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RetryPolicy_RetryHostPredicate) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RetryPolicy_RetryHostPredicate_OneofMarshaler, _RetryPolicy_RetryHostPredicate_OneofUnmarshaler, _RetryPolicy_RetryHostPredicate_OneofSizer, []interface{}{
		(*RetryPolicy_RetryHostPredicate_Config)(nil),
		(*RetryPolicy_RetryHostPredicate_TypedConfig)(nil),
	}
}

func _RetryPolicy_RetryHostPredicate_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RetryPolicy_RetryHostPredicate)
	// config_type
	switch x := m.ConfigType.(type) {
	case *RetryPolicy_RetryHostPredicate_Config:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Config); err != nil {
			return err
		}
	case *RetryPolicy_RetryHostPredicate_TypedConfig:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TypedConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RetryPolicy_RetryHostPredicate.ConfigType has unexpected type %T", x)
	}
	return nil
}

func _RetryPolicy_RetryHostPredicate_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RetryPolicy_RetryHostPredicate)
	switch tag {
	case 2: // config_type.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Struct)
		err := b.DecodeMessage(msg)
		m.ConfigType = &RetryPolicy_RetryHostPredicate_Config{msg}
		return true, err
	case 3: // config_type.typed_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Any)
		err := b.DecodeMessage(msg)
		m.ConfigType = &RetryPolicy_RetryHostPredicate_TypedConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RetryPolicy_RetryHostPredicate_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RetryPolicy_RetryHostPredicate)
	// config_type
	switch x := m.ConfigType.(type) {
	case *RetryPolicy_RetryHostPredicate_Config:
		s := proto.Size(x.Config)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RetryPolicy_RetryHostPredicate_TypedConfig:
		s := proto.Size(x.TypedConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type RetryPolicy_RetryBackOff struct {
	// Specifies the base interval between retries. This parameter is required and must be greater
	// than zero. Values less than 1 ms are rounded up to 1 ms.
	// See :ref:`config_http_filters_router_x-envoy-max-retries` for a discussion of Envoy's
	// back-off algorithm.
	BaseInterval *time.Duration `protobuf:"bytes,1,opt,name=base_interval,json=baseInterval,proto3,stdduration" json:"base_interval,omitempty"`
	// Specifies the maximum interval between retries. This parameter is optional, but must be
	// greater than or equal to the `base_interval` if set. The default is 10 times the
	// `base_interval`. See :ref:`config_http_filters_router_x-envoy-max-retries` for a discussion
	// of Envoy's back-off algorithm.
	MaxInterval          *time.Duration `protobuf:"bytes,2,opt,name=max_interval,json=maxInterval,proto3,stdduration" json:"max_interval,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RetryPolicy_RetryBackOff) Reset()         { *m = RetryPolicy_RetryBackOff{} }
func (m *RetryPolicy_RetryBackOff) String() string { return proto.CompactTextString(m) }
func (*RetryPolicy_RetryBackOff) ProtoMessage()    {}
func (*RetryPolicy_RetryBackOff) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{6, 2}
}
func (m *RetryPolicy_RetryBackOff) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RetryPolicy_RetryBackOff) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RetryPolicy_RetryBackOff) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetryPolicy_RetryBackOff.Merge(m, src)
}
func (m *RetryPolicy_RetryBackOff) XXX_Size() int {
	return m.Size()
}
func (m *RetryPolicy_RetryBackOff) XXX_DiscardUnknown() {
	xxx_messageInfo_RetryPolicy_RetryBackOff.DiscardUnknown(m)
}

var xxx_messageInfo_RetryPolicy_RetryBackOff proto.InternalMessageInfo

func (m *RetryPolicy_RetryBackOff) GetBaseInterval() *time.Duration {
	if m != nil {
		return m.BaseInterval
	}
	return nil
}

func (m *RetryPolicy_RetryBackOff) GetMaxInterval() *time.Duration {
	if m != nil {
		return m.MaxInterval
	}
	return nil
}

// HTTP request hedging TODO(mpuncel) docs
// [#not-implemented-hide:]
type HedgePolicy struct {
	// Specifies the number of initial requests that should be sent upstream.
	// Must be at least 1.
	// Defaults to 1.
	InitialRequests *types.UInt32Value `protobuf:"bytes,1,opt,name=initial_requests,json=initialRequests,proto3" json:"initial_requests,omitempty"`
	// Specifies a probability that an additional upstream request should be sent
	// on top of what is specified by initial_requests.
	// Defaults to 0.
	AdditionalRequestChance *_type.FractionalPercent `protobuf:"bytes,2,opt,name=additional_request_chance,json=additionalRequestChance,proto3" json:"additional_request_chance,omitempty"`
	// Indicates that a hedged request should be sent when the per-try timeout
	// is hit. This will only occur if the retry policy also indicates that a
	// timed out request should be retried. Defaults to false.
	HedgeOnPerTryTimeout bool     `protobuf:"varint,3,opt,name=hedge_on_per_try_timeout,json=hedgeOnPerTryTimeout,proto3" json:"hedge_on_per_try_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HedgePolicy) Reset()         { *m = HedgePolicy{} }
func (m *HedgePolicy) String() string { return proto.CompactTextString(m) }
func (*HedgePolicy) ProtoMessage()    {}
func (*HedgePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{7}
}
func (m *HedgePolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HedgePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *HedgePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HedgePolicy.Merge(m, src)
}
func (m *HedgePolicy) XXX_Size() int {
	return m.Size()
}
func (m *HedgePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_HedgePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_HedgePolicy proto.InternalMessageInfo

func (m *HedgePolicy) GetInitialRequests() *types.UInt32Value {
	if m != nil {
		return m.InitialRequests
	}
	return nil
}

func (m *HedgePolicy) GetAdditionalRequestChance() *_type.FractionalPercent {
	if m != nil {
		return m.AdditionalRequestChance
	}
	return nil
}

func (m *HedgePolicy) GetHedgeOnPerTryTimeout() bool {
	if m != nil {
		return m.HedgeOnPerTryTimeout
	}
	return false
}

type RedirectAction struct {
	// When the scheme redirection take place, the following rules apply:
	//  1. If the source URI scheme is `http` and the port is explicitly
	//     set to `:80`, the port will be removed after the redirection
	//  2. If the source URI scheme is `https` and the port is explicitly
	//     set to `:443`, the port will be removed after the redirection
	//
	// Types that are valid to be assigned to SchemeRewriteSpecifier:
	//	*RedirectAction_HttpsRedirect
	//	*RedirectAction_SchemeRedirect
	SchemeRewriteSpecifier isRedirectAction_SchemeRewriteSpecifier `protobuf_oneof:"scheme_rewrite_specifier"`
	// The host portion of the URL will be swapped with this value.
	HostRedirect string `protobuf:"bytes,1,opt,name=host_redirect,json=hostRedirect,proto3" json:"host_redirect,omitempty"`
	// The port value of the URL will be swapped with this value.
	PortRedirect uint32 `protobuf:"varint,8,opt,name=port_redirect,json=portRedirect,proto3" json:"port_redirect,omitempty"`
	// Types that are valid to be assigned to PathRewriteSpecifier:
	//	*RedirectAction_PathRedirect
	//	*RedirectAction_PrefixRewrite
	PathRewriteSpecifier isRedirectAction_PathRewriteSpecifier `protobuf_oneof:"path_rewrite_specifier"`
	// The HTTP status code to use in the redirect response. The default response
	// code is MOVED_PERMANENTLY (301).
	ResponseCode RedirectAction_RedirectResponseCode `protobuf:"varint,3,opt,name=response_code,json=responseCode,proto3,enum=envoy.api.v2.route.RedirectAction_RedirectResponseCode" json:"response_code,omitempty"`
	// Indicates that during redirection, the query portion of the URL will
	// be removed. Default value is false.
	StripQuery           bool     `protobuf:"varint,6,opt,name=strip_query,json=stripQuery,proto3" json:"strip_query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RedirectAction) Reset()         { *m = RedirectAction{} }
func (m *RedirectAction) String() string { return proto.CompactTextString(m) }
func (*RedirectAction) ProtoMessage()    {}
func (*RedirectAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{8}
}
func (m *RedirectAction) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RedirectAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RedirectAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RedirectAction.Merge(m, src)
}
func (m *RedirectAction) XXX_Size() int {
	return m.Size()
}
func (m *RedirectAction) XXX_DiscardUnknown() {
	xxx_messageInfo_RedirectAction.DiscardUnknown(m)
}

var xxx_messageInfo_RedirectAction proto.InternalMessageInfo

type isRedirectAction_SchemeRewriteSpecifier interface {
	isRedirectAction_SchemeRewriteSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}
type isRedirectAction_PathRewriteSpecifier interface {
	isRedirectAction_PathRewriteSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RedirectAction_HttpsRedirect struct {
	HttpsRedirect bool `protobuf:"varint,4,opt,name=https_redirect,json=httpsRedirect,proto3,oneof"`
}
type RedirectAction_SchemeRedirect struct {
	SchemeRedirect string `protobuf:"bytes,7,opt,name=scheme_redirect,json=schemeRedirect,proto3,oneof"`
}
type RedirectAction_PathRedirect struct {
	PathRedirect string `protobuf:"bytes,2,opt,name=path_redirect,json=pathRedirect,proto3,oneof"`
}
type RedirectAction_PrefixRewrite struct {
	PrefixRewrite string `protobuf:"bytes,5,opt,name=prefix_rewrite,json=prefixRewrite,proto3,oneof"`
}

func (*RedirectAction_HttpsRedirect) isRedirectAction_SchemeRewriteSpecifier()  {}
func (*RedirectAction_SchemeRedirect) isRedirectAction_SchemeRewriteSpecifier() {}
func (*RedirectAction_PathRedirect) isRedirectAction_PathRewriteSpecifier()     {}
func (*RedirectAction_PrefixRewrite) isRedirectAction_PathRewriteSpecifier()    {}

func (m *RedirectAction) GetSchemeRewriteSpecifier() isRedirectAction_SchemeRewriteSpecifier {
	if m != nil {
		return m.SchemeRewriteSpecifier
	}
	return nil
}
func (m *RedirectAction) GetPathRewriteSpecifier() isRedirectAction_PathRewriteSpecifier {
	if m != nil {
		return m.PathRewriteSpecifier
	}
	return nil
}

func (m *RedirectAction) GetHttpsRedirect() bool {
	if x, ok := m.GetSchemeRewriteSpecifier().(*RedirectAction_HttpsRedirect); ok {
		return x.HttpsRedirect
	}
	return false
}

func (m *RedirectAction) GetSchemeRedirect() string {
	if x, ok := m.GetSchemeRewriteSpecifier().(*RedirectAction_SchemeRedirect); ok {
		return x.SchemeRedirect
	}
	return ""
}

func (m *RedirectAction) GetHostRedirect() string {
	if m != nil {
		return m.HostRedirect
	}
	return ""
}

func (m *RedirectAction) GetPortRedirect() uint32 {
	if m != nil {
		return m.PortRedirect
	}
	return 0
}

func (m *RedirectAction) GetPathRedirect() string {
	if x, ok := m.GetPathRewriteSpecifier().(*RedirectAction_PathRedirect); ok {
		return x.PathRedirect
	}
	return ""
}

func (m *RedirectAction) GetPrefixRewrite() string {
	if x, ok := m.GetPathRewriteSpecifier().(*RedirectAction_PrefixRewrite); ok {
		return x.PrefixRewrite
	}
	return ""
}

func (m *RedirectAction) GetResponseCode() RedirectAction_RedirectResponseCode {
	if m != nil {
		return m.ResponseCode
	}
	return RedirectAction_MOVED_PERMANENTLY
}

func (m *RedirectAction) GetStripQuery() bool {
	if m != nil {
		return m.StripQuery
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RedirectAction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RedirectAction_OneofMarshaler, _RedirectAction_OneofUnmarshaler, _RedirectAction_OneofSizer, []interface{}{
		(*RedirectAction_HttpsRedirect)(nil),
		(*RedirectAction_SchemeRedirect)(nil),
		(*RedirectAction_PathRedirect)(nil),
		(*RedirectAction_PrefixRewrite)(nil),
	}
}

func _RedirectAction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RedirectAction)
	// scheme_rewrite_specifier
	switch x := m.SchemeRewriteSpecifier.(type) {
	case *RedirectAction_HttpsRedirect:
		t := uint64(0)
		if x.HttpsRedirect {
			t = 1
		}
		_ = b.EncodeVarint(4<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *RedirectAction_SchemeRedirect:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.SchemeRedirect)
	case nil:
	default:
		return fmt.Errorf("RedirectAction.SchemeRewriteSpecifier has unexpected type %T", x)
	}
	// path_rewrite_specifier
	switch x := m.PathRewriteSpecifier.(type) {
	case *RedirectAction_PathRedirect:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.PathRedirect)
	case *RedirectAction_PrefixRewrite:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.PrefixRewrite)
	case nil:
	default:
		return fmt.Errorf("RedirectAction.PathRewriteSpecifier has unexpected type %T", x)
	}
	return nil
}

func _RedirectAction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RedirectAction)
	switch tag {
	case 4: // scheme_rewrite_specifier.https_redirect
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.SchemeRewriteSpecifier = &RedirectAction_HttpsRedirect{x != 0}
		return true, err
	case 7: // scheme_rewrite_specifier.scheme_redirect
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.SchemeRewriteSpecifier = &RedirectAction_SchemeRedirect{x}
		return true, err
	case 2: // path_rewrite_specifier.path_redirect
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathRewriteSpecifier = &RedirectAction_PathRedirect{x}
		return true, err
	case 5: // path_rewrite_specifier.prefix_rewrite
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathRewriteSpecifier = &RedirectAction_PrefixRewrite{x}
		return true, err
	default:
		return false, nil
	}
}

func _RedirectAction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RedirectAction)
	// scheme_rewrite_specifier
	switch x := m.SchemeRewriteSpecifier.(type) {
	case *RedirectAction_HttpsRedirect:
		n += 1 // tag and wire
		n += 1
	case *RedirectAction_SchemeRedirect:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.SchemeRedirect)))
		n += len(x.SchemeRedirect)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// path_rewrite_specifier
	switch x := m.PathRewriteSpecifier.(type) {
	case *RedirectAction_PathRedirect:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.PathRedirect)))
		n += len(x.PathRedirect)
	case *RedirectAction_PrefixRewrite:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.PrefixRewrite)))
		n += len(x.PrefixRewrite)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type DirectResponseAction struct {
	// Specifies the HTTP response status to be returned.
	Status uint32 `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	// Specifies the content of the response body. If this setting is omitted,
	// no body is included in the generated response.
	//
	// .. note::
	//
	//   Headers can be specified using *response_headers_to_add* in the enclosing
	//   :ref:`envoy_api_msg_route.Route`, :ref:`envoy_api_msg_RouteConfiguration` or
	//   :ref:`envoy_api_msg_route.VirtualHost`.
	Body                 *core.DataSource `protobuf:"bytes,2,opt,name=body,proto3" json:"body,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *DirectResponseAction) Reset()         { *m = DirectResponseAction{} }
func (m *DirectResponseAction) String() string { return proto.CompactTextString(m) }
func (*DirectResponseAction) ProtoMessage()    {}
func (*DirectResponseAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{9}
}
func (m *DirectResponseAction) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DirectResponseAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *DirectResponseAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DirectResponseAction.Merge(m, src)
}
func (m *DirectResponseAction) XXX_Size() int {
	return m.Size()
}
func (m *DirectResponseAction) XXX_DiscardUnknown() {
	xxx_messageInfo_DirectResponseAction.DiscardUnknown(m)
}

var xxx_messageInfo_DirectResponseAction proto.InternalMessageInfo

func (m *DirectResponseAction) GetStatus() uint32 {
	if m != nil {
		return m.Status
	}
	return 0
}

func (m *DirectResponseAction) GetBody() *core.DataSource {
	if m != nil {
		return m.Body
	}
	return nil
}

type Decorator struct {
	// The operation name associated with the request matched to this route. If tracing is
	// enabled, this information will be used as the span name reported for this request.
	//
	// .. note::
	//
	//   For ingress (inbound) requests, or egress (outbound) responses, this value may be overridden
	//   by the :ref:`x-envoy-decorator-operation
	//   <config_http_filters_router_x-envoy-decorator-operation>` header.
	Operation            string   `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Decorator) Reset()         { *m = Decorator{} }
func (m *Decorator) String() string { return proto.CompactTextString(m) }
func (*Decorator) ProtoMessage()    {}
func (*Decorator) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{10}
}
func (m *Decorator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Decorator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Decorator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decorator.Merge(m, src)
}
func (m *Decorator) XXX_Size() int {
	return m.Size()
}
func (m *Decorator) XXX_DiscardUnknown() {
	xxx_messageInfo_Decorator.DiscardUnknown(m)
}

var xxx_messageInfo_Decorator proto.InternalMessageInfo

func (m *Decorator) GetOperation() string {
	if m != nil {
		return m.Operation
	}
	return ""
}

// A virtual cluster is a way of specifying a regex matching rule against
// certain important endpoints such that statistics are generated explicitly for
// the matched requests. The reason this is useful is that when doing
// prefix/path matching Envoy does not always know what the application
// considers to be an endpoint. Thus, it’s impossible for Envoy to generically
// emit per endpoint statistics. However, often systems have highly critical
// endpoints that they wish to get “perfect” statistics on. Virtual cluster
// statistics are perfect in the sense that they are emitted on the downstream
// side such that they include network level failures.
//
// Documentation for :ref:`virtual cluster statistics <config_http_filters_router_stats>`.
//
// .. note::
//
//    Virtual clusters are a useful tool, but we do not recommend setting up a virtual cluster for
//    every application endpoint. This is both not easily maintainable and as well the matching and
//    statistics output are not free.
type VirtualCluster struct {
	// Specifies a regex pattern to use for matching requests. The entire path of the request
	// must match the regex. The regex grammar used is defined `here
	// <https://en.cppreference.com/w/cpp/regex/ecmascript>`_.
	//
	// Examples:
	//
	// * The regex */rides/\d+* matches the path */rides/0*
	// * The regex */rides/\d+* matches the path */rides/123*
	// * The regex */rides/\d+* does not match the path */rides/123/456*
	Pattern string `protobuf:"bytes,1,opt,name=pattern,proto3" json:"pattern,omitempty"`
	//  Specifies the name of the virtual cluster. The virtual cluster name as well
	// as the virtual host name are used when emitting statistics. The statistics are emitted by the
	// router filter and are documented :ref:`here <config_http_filters_router_stats>`.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Optionally specifies the HTTP method to match on. For example GET, PUT,
	// etc.
	// [#comment:TODO(htuch): add (validate.rules).enum.defined_only = true once
	// https://github.com/lyft/protoc-gen-validate/issues/42 is resolved.]
	Method               core.RequestMethod `protobuf:"varint,3,opt,name=method,proto3,enum=envoy.api.v2.core.RequestMethod" json:"method,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VirtualCluster) Reset()         { *m = VirtualCluster{} }
func (m *VirtualCluster) String() string { return proto.CompactTextString(m) }
func (*VirtualCluster) ProtoMessage()    {}
func (*VirtualCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{11}
}
func (m *VirtualCluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VirtualCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *VirtualCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VirtualCluster.Merge(m, src)
}
func (m *VirtualCluster) XXX_Size() int {
	return m.Size()
}
func (m *VirtualCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_VirtualCluster.DiscardUnknown(m)
}

var xxx_messageInfo_VirtualCluster proto.InternalMessageInfo

func (m *VirtualCluster) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

func (m *VirtualCluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VirtualCluster) GetMethod() core.RequestMethod {
	if m != nil {
		return m.Method
	}
	return core.METHOD_UNSPECIFIED
}

// Global rate limiting :ref:`architecture overview <arch_overview_rate_limit>`.
type RateLimit struct {
	// Refers to the stage set in the filter. The rate limit configuration only
	// applies to filters with the same stage number. The default stage number is
	// 0.
	//
	// .. note::
	//
	//   The filter supports a range of 0 - 10 inclusively for stage numbers.
	Stage *types.UInt32Value `protobuf:"bytes,1,opt,name=stage,proto3" json:"stage,omitempty"`
	// The key to be set in runtime to disable this rate limit configuration.
	DisableKey string `protobuf:"bytes,2,opt,name=disable_key,json=disableKey,proto3" json:"disable_key,omitempty"`
	// A list of actions that are to be applied for this rate limit configuration.
	// Order matters as the actions are processed sequentially and the descriptor
	// is composed by appending descriptor entries in that sequence. If an action
	// cannot append a descriptor entry, no descriptor is generated for the
	// configuration. See :ref:`composing actions
	// <config_http_filters_rate_limit_composing_actions>` for additional documentation.
	Actions              []*RateLimit_Action `protobuf:"bytes,3,rep,name=actions,proto3" json:"actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *RateLimit) Reset()         { *m = RateLimit{} }
func (m *RateLimit) String() string { return proto.CompactTextString(m) }
func (*RateLimit) ProtoMessage()    {}
func (*RateLimit) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{12}
}
func (m *RateLimit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RateLimit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RateLimit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RateLimit.Merge(m, src)
}
func (m *RateLimit) XXX_Size() int {
	return m.Size()
}
func (m *RateLimit) XXX_DiscardUnknown() {
	xxx_messageInfo_RateLimit.DiscardUnknown(m)
}

var xxx_messageInfo_RateLimit proto.InternalMessageInfo

func (m *RateLimit) GetStage() *types.UInt32Value {
	if m != nil {
		return m.Stage
	}
	return nil
}

func (m *RateLimit) GetDisableKey() string {
	if m != nil {
		return m.DisableKey
	}
	return ""
}

func (m *RateLimit) GetActions() []*RateLimit_Action {
	if m != nil {
		return m.Actions
	}
	return nil
}

type RateLimit_Action struct {
	// Types that are valid to be assigned to ActionSpecifier:
	//	*RateLimit_Action_SourceCluster_
	//	*RateLimit_Action_DestinationCluster_
	//	*RateLimit_Action_RequestHeaders_
	//	*RateLimit_Action_RemoteAddress_
	//	*RateLimit_Action_GenericKey_
	//	*RateLimit_Action_HeaderValueMatch_
	ActionSpecifier      isRateLimit_Action_ActionSpecifier `protobuf_oneof:"action_specifier"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *RateLimit_Action) Reset()         { *m = RateLimit_Action{} }
func (m *RateLimit_Action) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action) ProtoMessage()    {}
func (*RateLimit_Action) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{12, 0}
}
func (m *RateLimit_Action) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RateLimit_Action) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RateLimit_Action) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RateLimit_Action.Merge(m, src)
}
func (m *RateLimit_Action) XXX_Size() int {
	return m.Size()
}
func (m *RateLimit_Action) XXX_DiscardUnknown() {
	xxx_messageInfo_RateLimit_Action.DiscardUnknown(m)
}

var xxx_messageInfo_RateLimit_Action proto.InternalMessageInfo

type isRateLimit_Action_ActionSpecifier interface {
	isRateLimit_Action_ActionSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RateLimit_Action_SourceCluster_ struct {
	SourceCluster *RateLimit_Action_SourceCluster `protobuf:"bytes,1,opt,name=source_cluster,json=sourceCluster,proto3,oneof"`
}
type RateLimit_Action_DestinationCluster_ struct {
	DestinationCluster *RateLimit_Action_DestinationCluster `protobuf:"bytes,2,opt,name=destination_cluster,json=destinationCluster,proto3,oneof"`
}
type RateLimit_Action_RequestHeaders_ struct {
	RequestHeaders *RateLimit_Action_RequestHeaders `protobuf:"bytes,3,opt,name=request_headers,json=requestHeaders,proto3,oneof"`
}
type RateLimit_Action_RemoteAddress_ struct {
	RemoteAddress *RateLimit_Action_RemoteAddress `protobuf:"bytes,4,opt,name=remote_address,json=remoteAddress,proto3,oneof"`
}
type RateLimit_Action_GenericKey_ struct {
	GenericKey *RateLimit_Action_GenericKey `protobuf:"bytes,5,opt,name=generic_key,json=genericKey,proto3,oneof"`
}
type RateLimit_Action_HeaderValueMatch_ struct {
	HeaderValueMatch *RateLimit_Action_HeaderValueMatch `protobuf:"bytes,6,opt,name=header_value_match,json=headerValueMatch,proto3,oneof"`
}

func (*RateLimit_Action_SourceCluster_) isRateLimit_Action_ActionSpecifier()      {}
func (*RateLimit_Action_DestinationCluster_) isRateLimit_Action_ActionSpecifier() {}
func (*RateLimit_Action_RequestHeaders_) isRateLimit_Action_ActionSpecifier()     {}
func (*RateLimit_Action_RemoteAddress_) isRateLimit_Action_ActionSpecifier()      {}
func (*RateLimit_Action_GenericKey_) isRateLimit_Action_ActionSpecifier()         {}
func (*RateLimit_Action_HeaderValueMatch_) isRateLimit_Action_ActionSpecifier()   {}

func (m *RateLimit_Action) GetActionSpecifier() isRateLimit_Action_ActionSpecifier {
	if m != nil {
		return m.ActionSpecifier
	}
	return nil
}

func (m *RateLimit_Action) GetSourceCluster() *RateLimit_Action_SourceCluster {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_SourceCluster_); ok {
		return x.SourceCluster
	}
	return nil
}

func (m *RateLimit_Action) GetDestinationCluster() *RateLimit_Action_DestinationCluster {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_DestinationCluster_); ok {
		return x.DestinationCluster
	}
	return nil
}

func (m *RateLimit_Action) GetRequestHeaders() *RateLimit_Action_RequestHeaders {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_RequestHeaders_); ok {
		return x.RequestHeaders
	}
	return nil
}

func (m *RateLimit_Action) GetRemoteAddress() *RateLimit_Action_RemoteAddress {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_RemoteAddress_); ok {
		return x.RemoteAddress
	}
	return nil
}

func (m *RateLimit_Action) GetGenericKey() *RateLimit_Action_GenericKey {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_GenericKey_); ok {
		return x.GenericKey
	}
	return nil
}

func (m *RateLimit_Action) GetHeaderValueMatch() *RateLimit_Action_HeaderValueMatch {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_HeaderValueMatch_); ok {
		return x.HeaderValueMatch
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RateLimit_Action) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RateLimit_Action_OneofMarshaler, _RateLimit_Action_OneofUnmarshaler, _RateLimit_Action_OneofSizer, []interface{}{
		(*RateLimit_Action_SourceCluster_)(nil),
		(*RateLimit_Action_DestinationCluster_)(nil),
		(*RateLimit_Action_RequestHeaders_)(nil),
		(*RateLimit_Action_RemoteAddress_)(nil),
		(*RateLimit_Action_GenericKey_)(nil),
		(*RateLimit_Action_HeaderValueMatch_)(nil),
	}
}

func _RateLimit_Action_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RateLimit_Action)
	// action_specifier
	switch x := m.ActionSpecifier.(type) {
	case *RateLimit_Action_SourceCluster_:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SourceCluster); err != nil {
			return err
		}
	case *RateLimit_Action_DestinationCluster_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DestinationCluster); err != nil {
			return err
		}
	case *RateLimit_Action_RequestHeaders_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RequestHeaders); err != nil {
			return err
		}
	case *RateLimit_Action_RemoteAddress_:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RemoteAddress); err != nil {
			return err
		}
	case *RateLimit_Action_GenericKey_:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GenericKey); err != nil {
			return err
		}
	case *RateLimit_Action_HeaderValueMatch_:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HeaderValueMatch); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RateLimit_Action.ActionSpecifier has unexpected type %T", x)
	}
	return nil
}

func _RateLimit_Action_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RateLimit_Action)
	switch tag {
	case 1: // action_specifier.source_cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_SourceCluster)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_SourceCluster_{msg}
		return true, err
	case 2: // action_specifier.destination_cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_DestinationCluster)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_DestinationCluster_{msg}
		return true, err
	case 3: // action_specifier.request_headers
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_RequestHeaders)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_RequestHeaders_{msg}
		return true, err
	case 4: // action_specifier.remote_address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_RemoteAddress)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_RemoteAddress_{msg}
		return true, err
	case 5: // action_specifier.generic_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_GenericKey)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_GenericKey_{msg}
		return true, err
	case 6: // action_specifier.header_value_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_HeaderValueMatch)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_HeaderValueMatch_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RateLimit_Action_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RateLimit_Action)
	// action_specifier
	switch x := m.ActionSpecifier.(type) {
	case *RateLimit_Action_SourceCluster_:
		s := proto.Size(x.SourceCluster)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_DestinationCluster_:
		s := proto.Size(x.DestinationCluster)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_RequestHeaders_:
		s := proto.Size(x.RequestHeaders)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_RemoteAddress_:
		s := proto.Size(x.RemoteAddress)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_GenericKey_:
		s := proto.Size(x.GenericKey)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_HeaderValueMatch_:
		s := proto.Size(x.HeaderValueMatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//   ("source_cluster", "<local service cluster>")
//
// <local service cluster> is derived from the :option:`--service-cluster` option.
type RateLimit_Action_SourceCluster struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RateLimit_Action_SourceCluster) Reset()         { *m = RateLimit_Action_SourceCluster{} }
func (m *RateLimit_Action_SourceCluster) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_SourceCluster) ProtoMessage()    {}
func (*RateLimit_Action_SourceCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{12, 0, 0}
}
func (m *RateLimit_Action_SourceCluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RateLimit_Action_SourceCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RateLimit_Action_SourceCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RateLimit_Action_SourceCluster.Merge(m, src)
}
func (m *RateLimit_Action_SourceCluster) XXX_Size() int {
	return m.Size()
}
func (m *RateLimit_Action_SourceCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_RateLimit_Action_SourceCluster.DiscardUnknown(m)
}

var xxx_messageInfo_RateLimit_Action_SourceCluster proto.InternalMessageInfo

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//   ("destination_cluster", "<routed target cluster>")
//
// Once a request matches against a route table rule, a routed cluster is determined by one of
// the following :ref:`route table configuration <envoy_api_msg_RouteConfiguration>`
// settings:
//
// * :ref:`cluster <envoy_api_field_route.RouteAction.cluster>` indicates the upstream cluster
//   to route to.
// * :ref:`weighted_clusters <envoy_api_field_route.RouteAction.weighted_clusters>`
//   chooses a cluster randomly from a set of clusters with attributed weight.
// * :ref:`cluster_header <envoy_api_field_route.RouteAction.cluster_header>` indicates which
//   header in the request contains the target cluster.
type RateLimit_Action_DestinationCluster struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RateLimit_Action_DestinationCluster) Reset()         { *m = RateLimit_Action_DestinationCluster{} }
func (m *RateLimit_Action_DestinationCluster) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_DestinationCluster) ProtoMessage()    {}
func (*RateLimit_Action_DestinationCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{12, 0, 1}
}
func (m *RateLimit_Action_DestinationCluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RateLimit_Action_DestinationCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RateLimit_Action_DestinationCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RateLimit_Action_DestinationCluster.Merge(m, src)
}
func (m *RateLimit_Action_DestinationCluster) XXX_Size() int {
	return m.Size()
}
func (m *RateLimit_Action_DestinationCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_RateLimit_Action_DestinationCluster.DiscardUnknown(m)
}

var xxx_messageInfo_RateLimit_Action_DestinationCluster proto.InternalMessageInfo

// The following descriptor entry is appended when a header contains a key that matches the
// *header_name*:
//
// .. code-block:: cpp
//
//   ("<descriptor_key>", "<header_value_queried_from_header>")
type RateLimit_Action_RequestHeaders struct {
	// The header name to be queried from the request headers. The header’s
	// value is used to populate the value of the descriptor entry for the
	// descriptor_key.
	HeaderName string `protobuf:"bytes,1,opt,name=header_name,json=headerName,proto3" json:"header_name,omitempty"`
	// The key to use in the descriptor entry.
	DescriptorKey        string   `protobuf:"bytes,2,opt,name=descriptor_key,json=descriptorKey,proto3" json:"descriptor_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RateLimit_Action_RequestHeaders) Reset()         { *m = RateLimit_Action_RequestHeaders{} }
func (m *RateLimit_Action_RequestHeaders) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_RequestHeaders) ProtoMessage()    {}
func (*RateLimit_Action_RequestHeaders) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{12, 0, 2}
}
func (m *RateLimit_Action_RequestHeaders) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RateLimit_Action_RequestHeaders) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RateLimit_Action_RequestHeaders) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RateLimit_Action_RequestHeaders.Merge(m, src)
}
func (m *RateLimit_Action_RequestHeaders) XXX_Size() int {
	return m.Size()
}
func (m *RateLimit_Action_RequestHeaders) XXX_DiscardUnknown() {
	xxx_messageInfo_RateLimit_Action_RequestHeaders.DiscardUnknown(m)
}

var xxx_messageInfo_RateLimit_Action_RequestHeaders proto.InternalMessageInfo

func (m *RateLimit_Action_RequestHeaders) GetHeaderName() string {
	if m != nil {
		return m.HeaderName
	}
	return ""
}

func (m *RateLimit_Action_RequestHeaders) GetDescriptorKey() string {
	if m != nil {
		return m.DescriptorKey
	}
	return ""
}

// The following descriptor entry is appended to the descriptor and is populated using the
// trusted address from :ref:`x-forwarded-for <config_http_conn_man_headers_x-forwarded-for>`:
//
// .. code-block:: cpp
//
//   ("remote_address", "<trusted address from x-forwarded-for>")
type RateLimit_Action_RemoteAddress struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RateLimit_Action_RemoteAddress) Reset()         { *m = RateLimit_Action_RemoteAddress{} }
func (m *RateLimit_Action_RemoteAddress) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_RemoteAddress) ProtoMessage()    {}
func (*RateLimit_Action_RemoteAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{12, 0, 3}
}
func (m *RateLimit_Action_RemoteAddress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RateLimit_Action_RemoteAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RateLimit_Action_RemoteAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RateLimit_Action_RemoteAddress.Merge(m, src)
}
func (m *RateLimit_Action_RemoteAddress) XXX_Size() int {
	return m.Size()
}
func (m *RateLimit_Action_RemoteAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_RateLimit_Action_RemoteAddress.DiscardUnknown(m)
}

var xxx_messageInfo_RateLimit_Action_RemoteAddress proto.InternalMessageInfo

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//   ("generic_key", "<descriptor_value>")
type RateLimit_Action_GenericKey struct {
	// The value to use in the descriptor entry.
	DescriptorValue      string   `protobuf:"bytes,1,opt,name=descriptor_value,json=descriptorValue,proto3" json:"descriptor_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RateLimit_Action_GenericKey) Reset()         { *m = RateLimit_Action_GenericKey{} }
func (m *RateLimit_Action_GenericKey) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_GenericKey) ProtoMessage()    {}
func (*RateLimit_Action_GenericKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{12, 0, 4}
}
func (m *RateLimit_Action_GenericKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RateLimit_Action_GenericKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RateLimit_Action_GenericKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RateLimit_Action_GenericKey.Merge(m, src)
}
func (m *RateLimit_Action_GenericKey) XXX_Size() int {
	return m.Size()
}
func (m *RateLimit_Action_GenericKey) XXX_DiscardUnknown() {
	xxx_messageInfo_RateLimit_Action_GenericKey.DiscardUnknown(m)
}

var xxx_messageInfo_RateLimit_Action_GenericKey proto.InternalMessageInfo

func (m *RateLimit_Action_GenericKey) GetDescriptorValue() string {
	if m != nil {
		return m.DescriptorValue
	}
	return ""
}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//   ("header_match", "<descriptor_value>")
type RateLimit_Action_HeaderValueMatch struct {
	// The value to use in the descriptor entry.
	DescriptorValue string `protobuf:"bytes,1,opt,name=descriptor_value,json=descriptorValue,proto3" json:"descriptor_value,omitempty"`
	// If set to true, the action will append a descriptor entry when the
	// request matches the headers. If set to false, the action will append a
	// descriptor entry when the request does not match the headers. The
	// default value is true.
	ExpectMatch *types.BoolValue `protobuf:"bytes,2,opt,name=expect_match,json=expectMatch,proto3" json:"expect_match,omitempty"`
	// Specifies a set of headers that the rate limit action should match
	// on. The action will check the request’s headers against all the
	// specified headers in the config. A match will happen if all the
	// headers in the config are present in the request with the same values
	// (or based on presence if the value field is not in the config).
	Headers              []*HeaderMatcher `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *RateLimit_Action_HeaderValueMatch) Reset()         { *m = RateLimit_Action_HeaderValueMatch{} }
func (m *RateLimit_Action_HeaderValueMatch) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_HeaderValueMatch) ProtoMessage()    {}
func (*RateLimit_Action_HeaderValueMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{12, 0, 5}
}
func (m *RateLimit_Action_HeaderValueMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RateLimit_Action_HeaderValueMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *RateLimit_Action_HeaderValueMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RateLimit_Action_HeaderValueMatch.Merge(m, src)
}
func (m *RateLimit_Action_HeaderValueMatch) XXX_Size() int {
	return m.Size()
}
func (m *RateLimit_Action_HeaderValueMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_RateLimit_Action_HeaderValueMatch.DiscardUnknown(m)
}

var xxx_messageInfo_RateLimit_Action_HeaderValueMatch proto.InternalMessageInfo

func (m *RateLimit_Action_HeaderValueMatch) GetDescriptorValue() string {
	if m != nil {
		return m.DescriptorValue
	}
	return ""
}

func (m *RateLimit_Action_HeaderValueMatch) GetExpectMatch() *types.BoolValue {
	if m != nil {
		return m.ExpectMatch
	}
	return nil
}

func (m *RateLimit_Action_HeaderValueMatch) GetHeaders() []*HeaderMatcher {
	if m != nil {
		return m.Headers
	}
	return nil
}

// .. attention::
//
//   Internally, Envoy always uses the HTTP/2 *:authority* header to represent the HTTP/1 *Host*
//   header. Thus, if attempting to match on *Host*, match on *:authority* instead.
//
// .. attention::
//
//   To route on HTTP method, use the special HTTP/2 *:method* header. This works for both
//   HTTP/1 and HTTP/2 as Envoy normalizes headers. E.g.,
//
//   .. code-block:: json
//
//     {
//       "name": ":method",
//       "exact_match": "POST"
//     }
//
// .. attention::
//   In the absence of any header match specifier, match will default to :ref:`present_match
//   <envoy_api_field_route.HeaderMatcher.present_match>`. i.e, a request that has the :ref:`name
//   <envoy_api_field_route.HeaderMatcher.name>` header will match, regardless of the header's
//   value.
//
type HeaderMatcher struct {
	// Specifies the name of the header in the request.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies how the header match will be performed to route the request.
	//
	// Types that are valid to be assigned to HeaderMatchSpecifier:
	//	*HeaderMatcher_ExactMatch
	//	*HeaderMatcher_RegexMatch
	//	*HeaderMatcher_RangeMatch
	//	*HeaderMatcher_PresentMatch
	//	*HeaderMatcher_PrefixMatch
	//	*HeaderMatcher_SuffixMatch
	HeaderMatchSpecifier isHeaderMatcher_HeaderMatchSpecifier `protobuf_oneof:"header_match_specifier"`
	// If specified, the match result will be inverted before checking. Defaults to false.
	//
	// Examples:
	//
	// * The regex *\d{3}* does not match the value *1234*, so it will match when inverted.
	// * The range [-10,0) will match the value -1, so it will not match when inverted.
	InvertMatch          bool     `protobuf:"varint,8,opt,name=invert_match,json=invertMatch,proto3" json:"invert_match,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HeaderMatcher) Reset()         { *m = HeaderMatcher{} }
func (m *HeaderMatcher) String() string { return proto.CompactTextString(m) }
func (*HeaderMatcher) ProtoMessage()    {}
func (*HeaderMatcher) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{13}
}
func (m *HeaderMatcher) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeaderMatcher) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *HeaderMatcher) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeaderMatcher.Merge(m, src)
}
func (m *HeaderMatcher) XXX_Size() int {
	return m.Size()
}
func (m *HeaderMatcher) XXX_DiscardUnknown() {
	xxx_messageInfo_HeaderMatcher.DiscardUnknown(m)
}

var xxx_messageInfo_HeaderMatcher proto.InternalMessageInfo

type isHeaderMatcher_HeaderMatchSpecifier interface {
	isHeaderMatcher_HeaderMatchSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type HeaderMatcher_ExactMatch struct {
	ExactMatch string `protobuf:"bytes,4,opt,name=exact_match,json=exactMatch,proto3,oneof"`
}
type HeaderMatcher_RegexMatch struct {
	RegexMatch string `protobuf:"bytes,5,opt,name=regex_match,json=regexMatch,proto3,oneof"`
}
type HeaderMatcher_RangeMatch struct {
	RangeMatch *_type.Int64Range `protobuf:"bytes,6,opt,name=range_match,json=rangeMatch,proto3,oneof"`
}
type HeaderMatcher_PresentMatch struct {
	PresentMatch bool `protobuf:"varint,7,opt,name=present_match,json=presentMatch,proto3,oneof"`
}
type HeaderMatcher_PrefixMatch struct {
	PrefixMatch string `protobuf:"bytes,9,opt,name=prefix_match,json=prefixMatch,proto3,oneof"`
}
type HeaderMatcher_SuffixMatch struct {
	SuffixMatch string `protobuf:"bytes,10,opt,name=suffix_match,json=suffixMatch,proto3,oneof"`
}

func (*HeaderMatcher_ExactMatch) isHeaderMatcher_HeaderMatchSpecifier()   {}
func (*HeaderMatcher_RegexMatch) isHeaderMatcher_HeaderMatchSpecifier()   {}
func (*HeaderMatcher_RangeMatch) isHeaderMatcher_HeaderMatchSpecifier()   {}
func (*HeaderMatcher_PresentMatch) isHeaderMatcher_HeaderMatchSpecifier() {}
func (*HeaderMatcher_PrefixMatch) isHeaderMatcher_HeaderMatchSpecifier()  {}
func (*HeaderMatcher_SuffixMatch) isHeaderMatcher_HeaderMatchSpecifier()  {}

func (m *HeaderMatcher) GetHeaderMatchSpecifier() isHeaderMatcher_HeaderMatchSpecifier {
	if m != nil {
		return m.HeaderMatchSpecifier
	}
	return nil
}

func (m *HeaderMatcher) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HeaderMatcher) GetExactMatch() string {
	if x, ok := m.GetHeaderMatchSpecifier().(*HeaderMatcher_ExactMatch); ok {
		return x.ExactMatch
	}
	return ""
}

func (m *HeaderMatcher) GetRegexMatch() string {
	if x, ok := m.GetHeaderMatchSpecifier().(*HeaderMatcher_RegexMatch); ok {
		return x.RegexMatch
	}
	return ""
}

func (m *HeaderMatcher) GetRangeMatch() *_type.Int64Range {
	if x, ok := m.GetHeaderMatchSpecifier().(*HeaderMatcher_RangeMatch); ok {
		return x.RangeMatch
	}
	return nil
}

func (m *HeaderMatcher) GetPresentMatch() bool {
	if x, ok := m.GetHeaderMatchSpecifier().(*HeaderMatcher_PresentMatch); ok {
		return x.PresentMatch
	}
	return false
}

func (m *HeaderMatcher) GetPrefixMatch() string {
	if x, ok := m.GetHeaderMatchSpecifier().(*HeaderMatcher_PrefixMatch); ok {
		return x.PrefixMatch
	}
	return ""
}

func (m *HeaderMatcher) GetSuffixMatch() string {
	if x, ok := m.GetHeaderMatchSpecifier().(*HeaderMatcher_SuffixMatch); ok {
		return x.SuffixMatch
	}
	return ""
}

func (m *HeaderMatcher) GetInvertMatch() bool {
	if m != nil {
		return m.InvertMatch
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HeaderMatcher) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HeaderMatcher_OneofMarshaler, _HeaderMatcher_OneofUnmarshaler, _HeaderMatcher_OneofSizer, []interface{}{
		(*HeaderMatcher_ExactMatch)(nil),
		(*HeaderMatcher_RegexMatch)(nil),
		(*HeaderMatcher_RangeMatch)(nil),
		(*HeaderMatcher_PresentMatch)(nil),
		(*HeaderMatcher_PrefixMatch)(nil),
		(*HeaderMatcher_SuffixMatch)(nil),
	}
}

func _HeaderMatcher_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HeaderMatcher)
	// header_match_specifier
	switch x := m.HeaderMatchSpecifier.(type) {
	case *HeaderMatcher_ExactMatch:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ExactMatch)
	case *HeaderMatcher_RegexMatch:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.RegexMatch)
	case *HeaderMatcher_RangeMatch:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangeMatch); err != nil {
			return err
		}
	case *HeaderMatcher_PresentMatch:
		t := uint64(0)
		if x.PresentMatch {
			t = 1
		}
		_ = b.EncodeVarint(7<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *HeaderMatcher_PrefixMatch:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.PrefixMatch)
	case *HeaderMatcher_SuffixMatch:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.SuffixMatch)
	case nil:
	default:
		return fmt.Errorf("HeaderMatcher.HeaderMatchSpecifier has unexpected type %T", x)
	}
	return nil
}

func _HeaderMatcher_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HeaderMatcher)
	switch tag {
	case 4: // header_match_specifier.exact_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.HeaderMatchSpecifier = &HeaderMatcher_ExactMatch{x}
		return true, err
	case 5: // header_match_specifier.regex_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.HeaderMatchSpecifier = &HeaderMatcher_RegexMatch{x}
		return true, err
	case 6: // header_match_specifier.range_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(_type.Int64Range)
		err := b.DecodeMessage(msg)
		m.HeaderMatchSpecifier = &HeaderMatcher_RangeMatch{msg}
		return true, err
	case 7: // header_match_specifier.present_match
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.HeaderMatchSpecifier = &HeaderMatcher_PresentMatch{x != 0}
		return true, err
	case 9: // header_match_specifier.prefix_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.HeaderMatchSpecifier = &HeaderMatcher_PrefixMatch{x}
		return true, err
	case 10: // header_match_specifier.suffix_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.HeaderMatchSpecifier = &HeaderMatcher_SuffixMatch{x}
		return true, err
	default:
		return false, nil
	}
}

func _HeaderMatcher_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HeaderMatcher)
	// header_match_specifier
	switch x := m.HeaderMatchSpecifier.(type) {
	case *HeaderMatcher_ExactMatch:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ExactMatch)))
		n += len(x.ExactMatch)
	case *HeaderMatcher_RegexMatch:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.RegexMatch)))
		n += len(x.RegexMatch)
	case *HeaderMatcher_RangeMatch:
		s := proto.Size(x.RangeMatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HeaderMatcher_PresentMatch:
		n += 1 // tag and wire
		n += 1
	case *HeaderMatcher_PrefixMatch:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.PrefixMatch)))
		n += len(x.PrefixMatch)
	case *HeaderMatcher_SuffixMatch:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.SuffixMatch)))
		n += len(x.SuffixMatch)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Query parameter matching treats the query string of a request's :path header
// as an ampersand-separated list of keys and/or key=value elements.
type QueryParameterMatcher struct {
	// Specifies the name of a key that must be present in the requested
	// *path*'s query string.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the value of the key. If the value is absent, a request
	// that contains the key in its query string will match, whether the
	// key appears with a value (e.g., "?debug=true") or not (e.g., "?debug")
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// Specifies whether the query parameter value is a regular expression.
	// Defaults to false. The entire query parameter value (i.e., the part to
	// the right of the equals sign in "key=value") must match the regex.
	// E.g., the regex "\d+$" will match "123" but not "a123" or "123a".
	Regex                *types.BoolValue `protobuf:"bytes,4,opt,name=regex,proto3" json:"regex,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *QueryParameterMatcher) Reset()         { *m = QueryParameterMatcher{} }
func (m *QueryParameterMatcher) String() string { return proto.CompactTextString(m) }
func (*QueryParameterMatcher) ProtoMessage()    {}
func (*QueryParameterMatcher) Descriptor() ([]byte, []int) {
	return fileDescriptor_7dc2895fb75d9d41, []int{14}
}
func (m *QueryParameterMatcher) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryParameterMatcher) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *QueryParameterMatcher) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryParameterMatcher.Merge(m, src)
}
func (m *QueryParameterMatcher) XXX_Size() int {
	return m.Size()
}
func (m *QueryParameterMatcher) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryParameterMatcher.DiscardUnknown(m)
}

var xxx_messageInfo_QueryParameterMatcher proto.InternalMessageInfo

func (m *QueryParameterMatcher) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *QueryParameterMatcher) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *QueryParameterMatcher) GetRegex() *types.BoolValue {
	if m != nil {
		return m.Regex
	}
	return nil
}

func init() {
	proto.RegisterEnum("envoy.api.v2.route.VirtualHost_TlsRequirementType", VirtualHost_TlsRequirementType_name, VirtualHost_TlsRequirementType_value)
	proto.RegisterEnum("envoy.api.v2.route.RouteAction_ClusterNotFoundResponseCode", RouteAction_ClusterNotFoundResponseCode_name, RouteAction_ClusterNotFoundResponseCode_value)
	proto.RegisterEnum("envoy.api.v2.route.RouteAction_InternalRedirectAction", RouteAction_InternalRedirectAction_name, RouteAction_InternalRedirectAction_value)
	proto.RegisterEnum("envoy.api.v2.route.RedirectAction_RedirectResponseCode", RedirectAction_RedirectResponseCode_name, RedirectAction_RedirectResponseCode_value)
	proto.RegisterType((*VirtualHost)(nil), "envoy.api.v2.route.VirtualHost")
	proto.RegisterMapType((map[string]*types.Struct)(nil), "envoy.api.v2.route.VirtualHost.PerFilterConfigEntry")
	proto.RegisterMapType((map[string]*types.Any)(nil), "envoy.api.v2.route.VirtualHost.TypedPerFilterConfigEntry")
	proto.RegisterType((*Route)(nil), "envoy.api.v2.route.Route")
	proto.RegisterMapType((map[string]*types.Struct)(nil), "envoy.api.v2.route.Route.PerFilterConfigEntry")
	proto.RegisterMapType((map[string]*types.Any)(nil), "envoy.api.v2.route.Route.TypedPerFilterConfigEntry")
	proto.RegisterType((*WeightedCluster)(nil), "envoy.api.v2.route.WeightedCluster")
	proto.RegisterType((*WeightedCluster_ClusterWeight)(nil), "envoy.api.v2.route.WeightedCluster.ClusterWeight")
	proto.RegisterMapType((map[string]*types.Struct)(nil), "envoy.api.v2.route.WeightedCluster.ClusterWeight.PerFilterConfigEntry")
	proto.RegisterMapType((map[string]*types.Any)(nil), "envoy.api.v2.route.WeightedCluster.ClusterWeight.TypedPerFilterConfigEntry")
	proto.RegisterType((*RouteMatch)(nil), "envoy.api.v2.route.RouteMatch")
	proto.RegisterType((*RouteMatch_GrpcRouteMatchOptions)(nil), "envoy.api.v2.route.RouteMatch.GrpcRouteMatchOptions")
	proto.RegisterType((*CorsPolicy)(nil), "envoy.api.v2.route.CorsPolicy")
	proto.RegisterType((*RouteAction)(nil), "envoy.api.v2.route.RouteAction")
	proto.RegisterType((*RouteAction_RequestMirrorPolicy)(nil), "envoy.api.v2.route.RouteAction.RequestMirrorPolicy")
	proto.RegisterType((*RouteAction_HashPolicy)(nil), "envoy.api.v2.route.RouteAction.HashPolicy")
	proto.RegisterType((*RouteAction_HashPolicy_Header)(nil), "envoy.api.v2.route.RouteAction.HashPolicy.Header")
	proto.RegisterType((*RouteAction_HashPolicy_Cookie)(nil), "envoy.api.v2.route.RouteAction.HashPolicy.Cookie")
	proto.RegisterType((*RouteAction_HashPolicy_ConnectionProperties)(nil), "envoy.api.v2.route.RouteAction.HashPolicy.ConnectionProperties")
	proto.RegisterType((*RouteAction_UpgradeConfig)(nil), "envoy.api.v2.route.RouteAction.UpgradeConfig")
	proto.RegisterType((*RetryPolicy)(nil), "envoy.api.v2.route.RetryPolicy")
	proto.RegisterType((*RetryPolicy_RetryPriority)(nil), "envoy.api.v2.route.RetryPolicy.RetryPriority")
	proto.RegisterType((*RetryPolicy_RetryHostPredicate)(nil), "envoy.api.v2.route.RetryPolicy.RetryHostPredicate")
	proto.RegisterType((*RetryPolicy_RetryBackOff)(nil), "envoy.api.v2.route.RetryPolicy.RetryBackOff")
	proto.RegisterType((*HedgePolicy)(nil), "envoy.api.v2.route.HedgePolicy")
	proto.RegisterType((*RedirectAction)(nil), "envoy.api.v2.route.RedirectAction")
	proto.RegisterType((*DirectResponseAction)(nil), "envoy.api.v2.route.DirectResponseAction")
	proto.RegisterType((*Decorator)(nil), "envoy.api.v2.route.Decorator")
	proto.RegisterType((*VirtualCluster)(nil), "envoy.api.v2.route.VirtualCluster")
	proto.RegisterType((*RateLimit)(nil), "envoy.api.v2.route.RateLimit")
	proto.RegisterType((*RateLimit_Action)(nil), "envoy.api.v2.route.RateLimit.Action")
	proto.RegisterType((*RateLimit_Action_SourceCluster)(nil), "envoy.api.v2.route.RateLimit.Action.SourceCluster")
	proto.RegisterType((*RateLimit_Action_DestinationCluster)(nil), "envoy.api.v2.route.RateLimit.Action.DestinationCluster")
	proto.RegisterType((*RateLimit_Action_RequestHeaders)(nil), "envoy.api.v2.route.RateLimit.Action.RequestHeaders")
	proto.RegisterType((*RateLimit_Action_RemoteAddress)(nil), "envoy.api.v2.route.RateLimit.Action.RemoteAddress")
	proto.RegisterType((*RateLimit_Action_GenericKey)(nil), "envoy.api.v2.route.RateLimit.Action.GenericKey")
	proto.RegisterType((*RateLimit_Action_HeaderValueMatch)(nil), "envoy.api.v2.route.RateLimit.Action.HeaderValueMatch")
	proto.RegisterType((*HeaderMatcher)(nil), "envoy.api.v2.route.HeaderMatcher")
	proto.RegisterType((*QueryParameterMatcher)(nil), "envoy.api.v2.route.QueryParameterMatcher")
}

func init() { proto.RegisterFile("envoy/api/v2/route/route.proto", fileDescriptor_7dc2895fb75d9d41) }

var fileDescriptor_7dc2895fb75d9d41 = []byte{
	// 3722 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x5a, 0x4d, 0x70, 0xdb, 0x48,
	0x76, 0x16, 0x44, 0x8a, 0x04, 0x1f, 0x48, 0x0a, 0x6a, 0xc9, 0x12, 0x45, 0x7b, 0x64, 0x99, 0x9e,
	0xc9, 0x68, 0x9d, 0x1d, 0x6a, 0x47, 0x56, 0xc6, 0xeb, 0x99, 0x9a, 0x4d, 0x48, 0x89, 0x36, 0x25,
	0xeb, 0x2f, 0x2d, 0xd9, 0x89, 0x67, 0x2b, 0x41, 0x60, 0xa2, 0x45, 0x62, 0x4d, 0x02, 0x98, 0x06,
	0x28, 0x4b, 0xb7, 0xcd, 0x9e, 0x52, 0x9b, 0x4a, 0x55, 0x32, 0x87, 0x54, 0xce, 0xc9, 0x25, 0xb5,
	0xa9, 0xa4, 0xf6, 0x96, 0xad, 0x54, 0x0e, 0x7b, 0xdc, 0xe3, 0x56, 0x4e, 0x7b, 0xc9, 0x4f, 0xf9,
	0x94, 0xbd, 0xe7, 0x90, 0x63, 0xaa, 0x7f, 0x00, 0x90, 0x22, 0x24, 0x52, 0x4e, 0xd5, 0x54, 0x26,
	0x17, 0x09, 0xe8, 0xfe, 0xde, 0xeb, 0x46, 0xf7, 0xeb, 0xf7, 0xbe, 0xf7, 0x9a, 0xb0, 0x42, 0x9c,
	0x33, 0xf7, 0x62, 0xdd, 0xf4, 0xec, 0xf5, 0xb3, 0x8d, 0x75, 0xea, 0xf6, 0x03, 0x22, 0xfe, 0x56,
	0x3d, 0xea, 0x06, 0x2e, 0x42, 0xbc, 0xbf, 0x6a, 0x7a, 0x76, 0xf5, 0x6c, 0xa3, 0xca, 0x7b, 0xca,
	0x77, 0x86, 0x64, 0x5a, 0x2e, 0x25, 0xeb, 0xaf, 0x4c, 0x5f, 0x4a, 0x94, 0x4b, 0xa2, 0x37, 0xb8,
	0xf0, 0xc8, 0xba, 0x47, 0x68, 0x8b, 0x38, 0x81, 0xec, 0x59, 0x1c, 0xe8, 0xa1, 0xa6, 0xd3, 0x0e,
	0x25, 0x96, 0xdb, 0xae, 0xdb, 0xee, 0x92, 0x75, 0xfe, 0xf6, 0xaa, 0x7f, 0xba, 0x6e, 0x3a, 0x17,
	0xb2, 0x6b, 0xe5, 0x72, 0x97, 0xd5, 0xa7, 0x66, 0x60, 0xbb, 0x8e, 0xec, 0xbf, 0x73, 0xb9, 0xdf,
	0x0f, 0x68, 0xbf, 0x15, 0x5c, 0x25, 0xfd, 0x86, 0x9a, 0x9e, 0x47, 0xa8, 0x2f, 0xfb, 0x97, 0xce,
	0xcc, 0xae, 0x6d, 0x99, 0x01, 0x59, 0x0f, 0x1f, 0x64, 0xc7, 0x42, 0xdb, 0x6d, 0xbb, 0xfc, 0x71,
	0x9d, 0x3d, 0x89, 0xd6, 0xca, 0x8f, 0x35, 0xd0, 0x5e, 0xd8, 0x34, 0xe8, 0x9b, 0xdd, 0xa6, 0xeb,
	0x07, 0xe8, 0x3d, 0x48, 0x3b, 0x66, 0x8f, 0x94, 0x94, 0x55, 0x65, 0x2d, 0x57, 0xcf, 0xfd, 0xd3,
	0xaf, 0x7f, 0x9e, 0x4a, 0xd3, 0xe9, 0x55, 0x05, 0xf3, 0x66, 0xf4, 0x3e, 0x64, 0x2d, 0xb7, 0x67,
	0xda, 0x8e, 0x5f, 0x9a, 0x5e, 0x4d, 0xad, 0xe5, 0xea, 0xc0, 0x10, 0x33, 0x5f, 0x29, 0xd3, 0xaa,
	0x82, 0xc3, 0x2e, 0xf4, 0x08, 0x32, 0x7c, 0x55, 0xfd, 0x52, 0x6a, 0x35, 0xb5, 0xa6, 0x6d, 0x2c,
	0x57, 0x47, 0x57, 0xbc, 0x8a, 0xd9, 0xdf, 0x7a, 0xfa, 0x17, 0xff, 0x76, 0x77, 0x0a, 0x4b, 0x38,
	0x3a, 0x06, 0x8d, 0x92, 0x2f, 0xfb, 0x36, 0x25, 0x46, 0xd0, 0xf5, 0x4b, 0xe9, 0x55, 0x65, 0xad,
	0xb8, 0xb1, 0x91, 0x24, 0x3d, 0x30, 0xe7, 0xea, 0x49, 0xd7, 0xc7, 0x42, 0xaa, 0x47, 0x9c, 0xe0,
	0xe4, 0xc2, 0x23, 0x18, 0xa4, 0x9a, 0x93, 0xae, 0x8f, 0xf6, 0x41, 0x3f, 0x13, 0x68, 0xa3, 0xd5,
	0xed, 0xfb, 0x01, 0xa1, 0x7e, 0x69, 0x86, 0xcf, 0xab, 0x72, 0x8d, 0xe6, 0x2d, 0x01, 0xc5, 0xb3,
	0x67, 0x43, 0xef, 0x3e, 0xfa, 0x1e, 0x68, 0xd4, 0x0c, 0x88, 0xd1, 0xb5, 0x7b, 0x76, 0xe0, 0x97,
	0x32, 0x5c, 0xd3, 0x7b, 0x89, 0x5f, 0x68, 0x06, 0x64, 0x8f, 0xa1, 0x30, 0xd0, 0xf0, 0xd1, 0x47,
	0xa7, 0xb0, 0xc8, 0x26, 0x47, 0xfc, 0xc0, 0xe8, 0x10, 0xd3, 0x22, 0xd4, 0x37, 0x02, 0xd7, 0x30,
	0x2d, 0xab, 0x94, 0xe5, 0xaa, 0xde, 0x1f, 0x56, 0xc5, 0x4c, 0xb1, 0xda, 0xe4, 0xc0, 0x17, 0x66,
	0xb7, 0x4f, 0x0e, 0x3d, 0x66, 0x2a, 0x75, 0x8d, 0xad, 0x7b, 0xe6, 0x2b, 0x25, 0xa5, 0xff, 0x67,
	0x16, 0xcf, 0x4b, 0x85, 0x02, 0xe6, 0x9f, 0xb8, 0x35, 0xcb, 0x42, 0x8f, 0x61, 0x39, 0x61, 0x1c,
	0x4a, 0x7a, 0xee, 0x19, 0x29, 0x15, 0xd8, 0xe6, 0xe1, 0xc5, 0xcb, 0x72, 0x98, 0xf7, 0xa2, 0x0e,
	0x2c, 0x51, 0xe2, 0x7b, 0xae, 0xe3, 0x93, 0xcb, 0x73, 0x84, 0x77, 0x9d, 0xe3, 0x42, 0xa8, 0x71,
	0x68, 0x92, 0x9f, 0x41, 0x39, 0x69, 0x24, 0x39, 0x4b, 0x8d, 0xcf, 0x72, 0x69, 0x44, 0x52, 0x4e,
	0x73, 0x03, 0xd2, 0x2d, 0x97, 0xfa, 0x25, 0x75, 0x55, 0x59, 0xd3, 0x36, 0x56, 0x92, 0xb6, 0x60,
	0xcb, 0xa5, 0xfe, 0x91, 0xdb, 0xb5, 0x5b, 0x17, 0x98, 0x63, 0xd1, 0x1f, 0xc1, 0x9c, 0x47, 0xa8,
	0x71, 0x6a, 0x77, 0x03, 0x42, 0x8d, 0x96, 0xeb, 0x9c, 0xda, 0xed, 0x52, 0x9e, 0x7f, 0xd4, 0xe6,
	0x38, 0x3b, 0x3b, 0x22, 0xf4, 0x09, 0x97, 0xdb, 0xe2, 0x62, 0x0d, 0x27, 0xa0, 0x17, 0x78, 0xd6,
	0x1b, 0x6e, 0x45, 0x1e, 0x2c, 0x31, 0x6f, 0x60, 0x19, 0xa3, 0xe3, 0xcc, 0xf2, 0x71, 0x1e, 0x8f,
	0xb5, 0x67, 0x26, 0x9e, 0x38, 0xd8, 0x42, 0x90, 0xd0, 0x85, 0x6a, 0xf0, 0x9e, 0xed, 0xb4, 0xba,
	0x7d, 0x8b, 0x18, 0xe1, 0x8e, 0x9b, 0x41, 0x40, 0x7a, 0x5e, 0x60, 0xb4, 0xdc, 0xbe, 0x13, 0x94,
	0x8a, 0xab, 0xca, 0x9a, 0x8a, 0xcb, 0x12, 0x84, 0x05, 0xa6, 0x26, 0x20, 0x5b, 0x0c, 0x81, 0xea,
	0x90, 0xa7, 0x24, 0xa0, 0x17, 0x86, 0xc7, 0x17, 0xab, 0xa4, 0xf3, 0x25, 0xbd, 0x9b, 0x68, 0xd5,
	0x0c, 0x27, 0xd7, 0x54, 0xa3, 0xf1, 0x0b, 0xd3, 0xd1, 0x21, 0x56, 0x9b, 0x84, 0x3a, 0xe6, 0xae,
	0xd6, 0xd1, 0x64, 0xb8, 0x50, 0x47, 0x27, 0x7e, 0x29, 0x7f, 0x1f, 0x16, 0x92, 0x3e, 0x1c, 0xe9,
	0x90, 0x7a, 0x4d, 0x2e, 0x84, 0x57, 0xc2, 0xec, 0x11, 0x7d, 0x04, 0x33, 0x67, 0xcc, 0xd6, 0x4a,
	0xd3, 0x7c, 0x98, 0xa5, 0xaa, 0xf0, 0x8b, 0xd5, 0xd0, 0x2f, 0x56, 0x8f, 0xb9, 0xd7, 0xc4, 0x02,
	0xf5, 0xe9, 0xf4, 0x77, 0x95, 0xf2, 0x1f, 0xc0, 0xf2, 0x95, 0x4b, 0x9b, 0x30, 0xc2, 0x83, 0xe1,
	0x11, 0x16, 0x46, 0x46, 0xa8, 0x39, 0x17, 0x03, 0xea, 0x2b, 0x9f, 0x02, 0x1a, 0xf5, 0x44, 0x48,
	0x85, 0xf4, 0xc1, 0xe1, 0x41, 0x43, 0x9f, 0x42, 0x73, 0x50, 0x68, 0xfc, 0xfe, 0x49, 0x03, 0x1f,
	0xd4, 0xf6, 0x8c, 0xc3, 0x83, 0xbd, 0x97, 0xba, 0x82, 0xb2, 0x90, 0xaa, 0xed, 0xed, 0xe9, 0xd3,
	0xbb, 0x69, 0x35, 0xa7, 0x43, 0xe5, 0xbf, 0x55, 0x98, 0xe1, 0x6e, 0x11, 0x6d, 0xc3, 0x4c, 0xcf,
	0x0c, 0x5a, 0x1d, 0x3e, 0x9f, 0x2b, 0x6c, 0x9b, 0x23, 0xf7, 0x19, 0xaa, 0x5e, 0x64, 0x5e, 0x94,
	0x7b, 0xe2, 0x1f, 0x2b, 0xd3, 0xba, 0x82, 0x85, 0x30, 0x7a, 0x04, 0x33, 0x1c, 0x2a, 0xbf, 0xe0,
	0xee, 0x95, 0x5a, 0x6a, 0x2d, 0x76, 0x60, 0x9b, 0x53, 0x58, 0xe0, 0xd1, 0xef, 0x80, 0x4a, 0x89,
	0x65, 0x53, 0xd2, 0x0a, 0x4a, 0x29, 0x2e, 0x5b, 0x49, 0x36, 0x05, 0x81, 0x89, 0xc4, 0x23, 0x29,
	0x74, 0x0c, 0xb3, 0xe2, 0xc9, 0x08, 0x4f, 0x6f, 0x29, 0xcb, 0x15, 0xad, 0x25, 0x29, 0xda, 0xe6,
	0x50, 0x2c, 0x91, 0x91, 0xba, 0xa2, 0x35, 0xd4, 0x8e, 0x1e, 0x81, 0xda, 0x23, 0x81, 0x69, 0x99,
	0x81, 0xc9, 0x63, 0x83, 0xb6, 0x71, 0x3b, 0xc1, 0x11, 0xed, 0x4b, 0x08, 0x8e, 0xc0, 0xe8, 0x33,
	0xc8, 0x59, 0xa4, 0xe5, 0x52, 0x33, 0x70, 0x69, 0x69, 0x86, 0x4b, 0x26, 0x7a, 0xec, 0xed, 0x10,
	0x84, 0x63, 0x3c, 0xfa, 0x22, 0xc9, 0x65, 0xa8, 0xfc, 0x28, 0x57, 0xaf, 0x5c, 0xd1, 0x09, 0x9d,
	0xc5, 0x0f, 0xae, 0x76, 0x16, 0x05, 0x3e, 0xc2, 0xc3, 0xab, 0x47, 0xb8, 0xa9, 0x9b, 0xb8, 0x3a,
	0xf0, 0xe4, 0xbe, 0xbe, 0xc0, 0x93, 0xff, 0x7f, 0x10, 0x78, 0xbe, 0xc9, 0x5e, 0xaa, 0x3e, 0x0b,
	0x19, 0x93, 0x9f, 0x2f, 0x34, 0xf3, 0xb3, 0x5f, 0xff, 0x3c, 0xa5, 0xec, 0xa6, 0xd5, 0x8c, 0x9e,
	0xad, 0xfc, 0x65, 0x0e, 0x66, 0x7f, 0x8f, 0xd8, 0xed, 0x4e, 0x40, 0x2c, 0x49, 0x75, 0xd0, 0x4b,
	0x50, 0x23, 0xc2, 0xa4, 0xf0, 0xe5, 0xff, 0x38, 0xc9, 0x1a, 0x2f, 0x89, 0x55, 0xe5, 0x7f, 0xd1,
	0x3c, 0x44, 0x10, 0x23, 0x75, 0x68, 0x17, 0xf2, 0x81, 0x1b, 0x98, 0x5d, 0xe3, 0x0d, 0x47, 0x49,
	0x27, 0x73, 0x67, 0x64, 0xf2, 0xcf, 0x77, 0x9c, 0xe0, 0xe1, 0x06, 0xdf, 0x5b, 0x49, 0x46, 0x1f,
	0x4c, 0xaf, 0x29, 0x58, 0xe3, 0xc2, 0x62, 0x04, 0xf4, 0x6d, 0x40, 0xb4, 0xef, 0x04, 0x76, 0x8f,
	0x18, 0xaf, 0xc9, 0x85, 0xe1, 0x51, 0x72, 0x6a, 0x9f, 0xf3, 0xe5, 0xc8, 0x61, 0x5d, 0xf6, 0x3c,
	0x23, 0x17, 0x47, 0xbc, 0xbd, 0xfc, 0xf7, 0x59, 0x28, 0x0c, 0xcd, 0x70, 0x1c, 0xe5, 0xdd, 0x84,
	0x8c, 0x9c, 0xe4, 0xf4, 0xf8, 0x49, 0x62, 0x89, 0x45, 0x75, 0x28, 0x86, 0xde, 0xc7, 0x10, 0x9e,
	0x3c, 0x35, 0xde, 0x61, 0x15, 0x42, 0x11, 0xee, 0xd5, 0xaf, 0x39, 0xb0, 0xe9, 0xaf, 0xef, 0xc0,
	0xe6, 0xde, 0xf5, 0xc0, 0xce, 0x7c, 0x9d, 0x07, 0x36, 0x73, 0x3d, 0x53, 0xa4, 0x57, 0xbb, 0xf0,
	0x27, 0x37, 0x36, 0xe9, 0x09, 0x5d, 0xfb, 0x8f, 0x94, 0xab, 0x7d, 0xbb, 0x70, 0x66, 0xcf, 0x6e,
	0x3e, 0xf4, 0x0d, 0x7d, 0xfe, 0x37, 0xd9, 0x53, 0xed, 0xa6, 0xd5, 0xac, 0xae, 0x56, 0xfe, 0x3c,
	0x0d, 0x10, 0x33, 0x1d, 0x54, 0x82, 0x8c, 0x3c, 0xe0, 0x5c, 0x73, 0x73, 0x0a, 0xcb, 0x77, 0xb4,
	0x00, 0x69, 0xcf, 0x0c, 0x3a, 0xe2, 0xe0, 0x37, 0xa7, 0x30, 0x7f, 0x43, 0x15, 0x98, 0xa1, 0xa4,
	0x4d, 0xce, 0xf9, 0xf1, 0x0b, 0xd3, 0x55, 0x9a, 0x5a, 0xfb, 0xa1, 0xca, 0xd9, 0x0e, 0xeb, 0x42,
	0x35, 0x28, 0xb6, 0x4c, 0x9f, 0x18, 0x3e, 0x71, 0x7c, 0x3b, 0xb0, 0xcf, 0x88, 0x24, 0x17, 0xe5,
	0x91, 0x19, 0xd6, 0x5d, 0xb7, 0x2b, 0xce, 0x79, 0x81, 0x49, 0x1c, 0x87, 0x02, 0xe8, 0x05, 0x84,
	0x9e, 0xc6, 0x38, 0xa5, 0xc2, 0xbf, 0x96, 0x72, 0x5c, 0xc9, 0x6f, 0x26, 0x1c, 0x00, 0x2c, 0xa0,
	0x4f, 0x24, 0xd2, 0xec, 0x1e, 0x89, 0x9a, 0x02, 0x9e, 0xa5, 0xc3, 0x3d, 0xe8, 0x33, 0xc8, 0x4a,
	0x63, 0x97, 0x89, 0xe6, 0xbd, 0x64, 0x3a, 0xcd, 0x20, 0x7c, 0x81, 0x08, 0xc5, 0xa1, 0x04, 0x3a,
	0x01, 0xfd, 0xcb, 0x3e, 0x61, 0xa4, 0xde, 0xa4, 0x66, 0x8f, 0x70, 0x3f, 0x2e, 0x72, 0xcc, 0x6f,
	0x25, 0x69, 0xf9, 0x5d, 0x86, 0x3d, 0x0a, 0xa1, 0xa1, 0xb6, 0xd9, 0x2f, 0x87, 0x9a, 0x7d, 0xd4,
	0x84, 0x74, 0x9b, 0x7a, 0x2d, 0x99, 0x75, 0x6d, 0x5e, 0xcf, 0x4c, 0xab, 0x4f, 0xa9, 0xd7, 0x8a,
	0x5f, 0xc5, 0x71, 0xf7, 0x31, 0xd7, 0x50, 0x5e, 0x82, 0x5b, 0x89, 0xdd, 0xf5, 0x25, 0x28, 0xb2,
	0xcd, 0x33, 0x7c, 0x8f, 0xb4, 0xec, 0x53, 0x9b, 0xd0, 0x38, 0x56, 0xcd, 0xe8, 0x99, 0xca, 0x3f,
	0xa7, 0x01, 0xe2, 0xc4, 0x0e, 0xdd, 0x83, 0xbc, 0xd9, 0xed, 0xba, 0x6f, 0x0c, 0x97, 0xda, 0x6d,
	0xdb, 0xe1, 0xa1, 0x2a, 0x87, 0x35, 0xde, 0x76, 0xc8, 0x9b, 0xd0, 0xe7, 0x80, 0x06, 0x21, 0x86,
	0x30, 0x09, 0x95, 0x57, 0x30, 0x66, 0x99, 0x49, 0xc0, 0x57, 0x4a, 0xb6, 0x22, 0xec, 0x02, 0xeb,
	0x03, 0x92, 0x98, 0x1b, 0xc8, 0x7d, 0x28, 0x08, 0xf1, 0x1e, 0x09, 0x3a, 0xae, 0xe5, 0xcb, 0xe0,
	0x22, 0x86, 0xdd, 0x17, 0x6d, 0x31, 0x28, 0xdc, 0xb0, 0xd4, 0x00, 0x48, 0x3a, 0x24, 0xf4, 0x01,
	0x14, 0xc9, 0xb9, 0xe7, 0xc6, 0x3e, 0x8c, 0x9b, 0x5a, 0x0e, 0x17, 0x44, 0x6b, 0x08, 0x5b, 0x82,
	0x6c, 0xcf, 0x3c, 0x37, 0xcc, 0x36, 0xe1, 0x6c, 0x35, 0x87, 0x33, 0x3d, 0xf3, 0xbc, 0xd6, 0x26,
	0xe8, 0x29, 0xcc, 0x89, 0x41, 0x5a, 0x94, 0x58, 0xc4, 0x09, 0x6c, 0xb3, 0xcb, 0x2c, 0x63, 0x9c,
	0xb5, 0x8a, 0x4f, 0xda, 0x8a, 0x65, 0xd0, 0xa7, 0x90, 0x25, 0x8e, 0xf9, 0xaa, 0x4b, 0x2c, 0xc9,
	0xcb, 0xaf, 0x11, 0xaf, 0x4f, 0x97, 0x94, 0xe6, 0x14, 0x0e, 0x05, 0xd0, 0x09, 0x14, 0xa5, 0x3b,
	0x0b, 0x55, 0xdc, 0xdc, 0xd4, 0x9b, 0x53, 0xb8, 0x20, 0x94, 0x34, 0xa4, 0x56, 0x0c, 0x45, 0xbf,
	0x63, 0x5a, 0xee, 0x9b, 0x48, 0x2b, 0xdc, 0xfc, 0x00, 0x15, 0x84, 0x0a, 0xa9, 0xb3, 0x3e, 0x0f,
	0x73, 0x52, 0x59, 0x6c, 0x4b, 0x95, 0xbf, 0xbe, 0x05, 0xda, 0x40, 0xd6, 0x83, 0x3e, 0x80, 0xac,
	0xe4, 0x25, 0x23, 0x14, 0x80, 0x7d, 0xb5, 0xec, 0x43, 0x1b, 0x50, 0x94, 0x8f, 0x72, 0xef, 0x84,
	0x15, 0x0c, 0xa3, 0x0b, 0x12, 0x22, 0x36, 0x12, 0x61, 0x98, 0x7b, 0x23, 0xfd, 0x79, 0x5c, 0x7b,
	0x12, 0x44, 0xe0, 0xfe, 0x04, 0xce, 0xbf, 0x39, 0x85, 0xf5, 0x37, 0xc3, 0x4d, 0x3e, 0xfa, 0x33,
	0x05, 0xee, 0x86, 0x13, 0x71, 0xdc, 0xc0, 0x38, 0x75, 0xfb, 0x8e, 0x15, 0x65, 0x59, 0x46, 0xcb,
	0xb5, 0x48, 0x69, 0x81, 0x17, 0xce, 0x3e, 0x1b, 0x93, 0xef, 0x85, 0xb1, 0xe5, 0xc0, 0x0d, 0x9e,
	0x30, 0x25, 0x61, 0x9e, 0xb5, 0xe5, 0x5a, 0x44, 0x7a, 0xca, 0x1f, 0xf1, 0x74, 0xf2, 0x76, 0xeb,
	0x6a, 0x60, 0x02, 0xd3, 0x49, 0xdf, 0x98, 0xe9, 0x7c, 0x00, 0x45, 0xe1, 0xc5, 0x0d, 0x4a, 0xde,
	0x50, 0x3b, 0x08, 0xcd, 0xbe, 0x20, 0x5a, 0xb1, 0x68, 0x44, 0xf7, 0x21, 0xdf, 0x71, 0xfd, 0x20,
	0x02, 0x65, 0xb8, 0xab, 0x57, 0xb0, 0xc6, 0x5a, 0x43, 0x50, 0x13, 0xe6, 0xcc, 0x7e, 0xe0, 0x1a,
	0x43, 0xc8, 0xb1, 0x36, 0xde, 0x54, 0xf0, 0x2c, 0x13, 0x6b, 0x0e, 0x68, 0x7a, 0x0c, 0x59, 0x66,
	0x65, 0x6e, 0x3f, 0x90, 0xce, 0x6e, 0x79, 0x44, 0x7e, 0x5b, 0x96, 0x6e, 0xeb, 0xe9, 0xbf, 0xfa,
	0xf7, 0xbb, 0x0a, 0x0e, 0xf1, 0xa8, 0x0e, 0x79, 0xdb, 0xea, 0x12, 0x23, 0x94, 0x2f, 0x4d, 0x26,
	0xaf, 0x31, 0xa1, 0x93, 0x58, 0xc7, 0x50, 0x4d, 0x26, 0xf7, 0x0e, 0x35, 0x99, 0x36, 0xdc, 0x0a,
	0xa9, 0x5d, 0xcf, 0xa6, 0xd4, 0xa5, 0xa1, 0x32, 0x71, 0xb6, 0x1e, 0x8e, 0xb3, 0x10, 0x59, 0x2b,
	0xda, 0xe7, 0xb2, 0x72, 0x80, 0x90, 0x43, 0x0e, 0x36, 0xa2, 0xef, 0x81, 0xea, 0x51, 0xdb, 0xa5,
	0x76, 0x70, 0x51, 0xd2, 0xb8, 0xf5, 0x55, 0x92, 0xce, 0xad, 0xdb, 0x0f, 0x6c, 0xa7, 0x7d, 0x24,
	0x91, 0x38, 0x92, 0xb9, 0x5c, 0x55, 0x2d, 0xdc, 0xb4, 0xaa, 0x7a, 0x08, 0x8b, 0x61, 0x0d, 0xec,
	0xac, 0x63, 0x0c, 0xaa, 0x2a, 0x8e, 0xf5, 0x8e, 0xf3, 0x52, 0xf2, 0x45, 0x07, 0xc7, 0x0a, 0x9f,
	0x81, 0xd6, 0x31, 0xfd, 0x4e, 0xb8, 0x5e, 0xa2, 0x74, 0xf7, 0x60, 0xdc, 0x7a, 0x35, 0x4d, 0xbf,
	0x23, 0x97, 0x09, 0x3a, 0xd1, 0x73, 0x54, 0xa9, 0x9c, 0xbb, 0x41, 0xa5, 0x72, 0x07, 0x74, 0x16,
	0x03, 0x58, 0xa4, 0x8c, 0xcc, 0x68, 0x69, 0x32, 0x33, 0x2a, 0xf6, 0xcc, 0x73, 0x16, 0x59, 0x43,
	0x4b, 0x3a, 0x84, 0xf9, 0x41, 0x35, 0x86, 0x7b, 0x7a, 0xea, 0x93, 0xa0, 0x74, 0x67, 0x32, 0x6d,
	0x73, 0xed, 0x58, 0xd5, 0x21, 0x97, 0x44, 0x2f, 0x60, 0xb6, 0xef, 0xb5, 0xa9, 0x69, 0x11, 0xc9,
	0x68, 0xfd, 0xd2, 0x32, 0x5f, 0xa0, 0x8f, 0xc6, 0x2d, 0xd0, 0x73, 0x21, 0x26, 0x98, 0x22, 0x2e,
	0xf6, 0x07, 0x5f, 0x7d, 0xe4, 0x41, 0xc9, 0x76, 0x02, 0x42, 0x1d, 0xb3, 0x6b, 0x84, 0xa5, 0x24,
	0x43, 0xd2, 0xa9, 0x32, 0xb7, 0xaa, 0x4f, 0xc6, 0x0d, 0xb0, 0x23, 0xe5, 0x87, 0x6b, 0x53, 0x78,
	0xd1, 0x4e, 0x6c, 0x1f, 0x29, 0x5a, 0xde, 0x7e, 0x87, 0xa2, 0xe5, 0x3f, 0x2a, 0x30, 0x9f, 0x70,
	0x50, 0xd0, 0xfd, 0xab, 0x03, 0x4b, 0x1c, 0x56, 0xee, 0x83, 0x36, 0x90, 0xbd, 0xca, 0x98, 0x32,
	0x5d, 0x52, 0x30, 0xc4, 0xa9, 0x6b, 0x22, 0xbd, 0x4c, 0xfd, 0xef, 0xe9, 0x65, 0xf9, 0xa7, 0x69,
	0x80, 0xd8, 0x64, 0xd1, 0x33, 0xc8, 0xc8, 0xd0, 0x26, 0xca, 0x8e, 0x1f, 0x4f, 0x6e, 0xee, 0x92,
	0x83, 0x32, 0x3e, 0x2e, 0x54, 0x30, 0x65, 0x2d, 0xd7, 0x7d, 0x6d, 0x87, 0x7c, 0xff, 0x26, 0xca,
	0xb6, 0xb8, 0x20, 0x53, 0x26, 0x54, 0xa0, 0x33, 0xb8, 0xd5, 0x72, 0x1d, 0x87, 0x70, 0xa4, 0xe1,
	0x51, 0xd7, 0x23, 0x34, 0xb0, 0x49, 0x18, 0x4c, 0x7f, 0xfb, 0x46, 0xba, 0x43, 0x3d, 0x47, 0x91,
	0x9a, 0xe6, 0x14, 0x5e, 0x68, 0x25, 0xb4, 0xa3, 0x32, 0xa8, 0x01, 0xa1, 0x3d, 0xdb, 0x31, 0xbb,
	0x3c, 0xac, 0xa9, 0x38, 0x7a, 0x2f, 0x6f, 0x42, 0x46, 0x86, 0xf9, 0x07, 0xa0, 0x89, 0x8f, 0x36,
	0x92, 0x0b, 0x09, 0x20, 0x7a, 0x0f, 0xcc, 0x1e, 0x29, 0x3b, 0x90, 0x11, 0x5f, 0x37, 0xae, 0xee,
	0xf0, 0x31, 0xa4, 0x82, 0xa0, 0x2b, 0x17, 0x6f, 0xec, 0x21, 0x65, 0x58, 0x84, 0x64, 0x0a, 0x24,
	0x98, 0x27, 0x7f, 0x2e, 0x3f, 0x84, 0x85, 0xa4, 0x2f, 0x46, 0xb7, 0x21, 0xe7, 0xbb, 0x7d, 0xda,
	0x22, 0x86, 0xed, 0xf1, 0x29, 0xa8, 0x58, 0x15, 0x0d, 0x3b, 0x5e, 0x7d, 0x19, 0x74, 0x71, 0x1e,
	0x46, 0x28, 0x78, 0xb9, 0x03, 0x85, 0xa1, 0x33, 0xcc, 0xe8, 0x77, 0xe8, 0x0b, 0x58, 0x0a, 0x2a,
	0x33, 0x3e, 0x4d, 0xb6, 0xf1, 0x1a, 0xf8, 0x66, 0x4c, 0x36, 0xa7, 0xc7, 0x7a, 0xe3, 0x10, 0x5a,
	0x69, 0xc0, 0xed, 0x6b, 0x08, 0x0a, 0x5a, 0x82, 0xf9, 0xe3, 0x06, 0x7e, 0xb1, 0xb3, 0xd5, 0x30,
	0x9e, 0x1f, 0xd4, 0x5e, 0xd4, 0x76, 0xf6, 0x6a, 0xf5, 0xbd, 0x86, 0x3e, 0x85, 0x0a, 0x90, 0x3b,
	0x38, 0x3c, 0x31, 0x9e, 0x1c, 0x3e, 0x3f, 0xd8, 0xd6, 0x95, 0xca, 0x17, 0xb0, 0x98, 0xec, 0x13,
	0x50, 0x05, 0x56, 0x8e, 0x6a, 0xc7, 0xc7, 0xc6, 0x49, 0x13, 0x1f, 0x3e, 0x7f, 0xda, 0x34, 0x76,
	0x0e, 0x64, 0x75, 0x1e, 0x37, 0xb6, 0x77, 0x70, 0x63, 0xeb, 0x44, 0x9f, 0x42, 0x77, 0xa0, 0xd4,
	0xac, 0x1d, 0x6c, 0xef, 0x35, 0x12, 0x7a, 0x95, 0x7a, 0x19, 0xe6, 0x42, 0x2a, 0x76, 0x79, 0xa1,
	0xea, 0x25, 0x58, 0x1c, 0xa4, 0x20, 0x31, 0x60, 0x37, 0xad, 0xe6, 0xf5, 0xc2, 0x6e, 0x5a, 0x45,
	0xfa, 0xfc, 0x6e, 0x5a, 0x9d, 0xd7, 0x17, 0x76, 0xd3, 0xaa, 0xae, 0xcf, 0xed, 0xa6, 0xd5, 0x45,
	0x7d, 0x69, 0x37, 0xad, 0xde, 0xd2, 0x17, 0x2b, 0xff, 0xa2, 0x82, 0x36, 0x10, 0xd5, 0xd1, 0x32,
	0xa8, 0x82, 0x0c, 0xb8, 0x8e, 0x5c, 0xe1, 0x2c, 0x7f, 0x3f, 0x64, 0xc9, 0x8d, 0xe6, 0xf4, 0x7b,
	0x06, 0x7b, 0x65, 0x27, 0x62, 0x92, 0x2a, 0x15, 0x38, 0xfd, 0x1e, 0x16, 0x78, 0xf4, 0x14, 0x66,
	0x3d, 0x42, 0x0d, 0xa6, 0x3b, 0x0c, 0x33, 0xa9, 0xc9, 0x6c, 0xae, 0xe0, 0x11, 0x7a, 0x42, 0x2f,
	0xc2, 0x28, 0x73, 0x02, 0x45, 0xc9, 0x57, 0x42, 0x22, 0x20, 0x88, 0xe0, 0x47, 0x63, 0x18, 0x8b,
	0x7c, 0x0e, 0x39, 0x41, 0x81, 0x0e, 0xbe, 0x22, 0x0b, 0x16, 0x84, 0x56, 0xbe, 0x98, 0x1e, 0x8b,
	0x0a, 0x2d, 0x93, 0x13, 0x44, 0x16, 0x6f, 0x36, 0x26, 0xd2, 0xcd, 0x48, 0xdd, 0x51, 0x28, 0x89,
	0x11, 0x1d, 0x69, 0x43, 0x4d, 0xb8, 0xc7, 0xf5, 0xfb, 0xa4, 0x2b, 0x7d, 0x8c, 0x18, 0x94, 0x67,
	0x61, 0xe2, 0xa2, 0x4c, 0xe4, 0x59, 0x29, 0xfc, 0x1e, 0x03, 0x1e, 0x87, 0x38, 0xae, 0x7f, 0xdf,
	0x3c, 0x97, 0xb7, 0x69, 0x3e, 0xda, 0x84, 0x45, 0xbe, 0x13, 0xcc, 0x86, 0x0d, 0x3f, 0x30, 0x83,
	0xbe, 0xcf, 0x39, 0xb9, 0x48, 0xbd, 0x0b, 0x78, 0x21, 0xea, 0x3d, 0xe6, 0x9d, 0xcc, 0x96, 0x7d,
	0x96, 0xfc, 0x88, 0x01, 0x5f, 0x99, 0xad, 0xd7, 0x2c, 0x3e, 0x4b, 0xc6, 0xf9, 0xed, 0x89, 0xbe,
	0xaf, 0x6e, 0xb6, 0x5e, 0x1f, 0x9e, 0x9e, 0x62, 0xc1, 0x17, 0xe5, 0x5b, 0xf9, 0xef, 0x14, 0x28,
	0x0c, 0x2d, 0xed, 0x78, 0x8f, 0x93, 0x91, 0xf5, 0xa9, 0xeb, 0x6b, 0x40, 0xc2, 0x2f, 0xf3, 0xc3,
	0xff, 0x18, 0xf2, 0xa2, 0xc6, 0x25, 0x05, 0x53, 0x57, 0x97, 0x76, 0x9a, 0x53, 0x58, 0xe3, 0x58,
	0xe1, 0x37, 0xea, 0x05, 0xd0, 0x84, 0x10, 0x77, 0x1b, 0xe5, 0x9f, 0x2a, 0x80, 0x46, 0x37, 0xeb,
	0xff, 0xf4, 0x94, 0xff, 0x41, 0x81, 0xfc, 0xe0, 0xfa, 0xa3, 0x23, 0x28, 0xbc, 0x32, 0x7d, 0x62,
	0x70, 0xae, 0x71, 0x66, 0x76, 0x65, 0x18, 0xbd, 0xe6, 0x20, 0xe9, 0xec, 0x20, 0xb1, 0x8f, 0xca,
	0xfe, 0x44, 0x49, 0xab, 0xca, 0x83, 0x29, 0x9c, 0x67, 0x1a, 0x76, 0xa4, 0x02, 0xb4, 0x07, 0x79,
	0x66, 0x82, 0x91, 0xc2, 0xb1, 0xd1, 0xa0, 0x18, 0x2a, 0x9c, 0xf9, 0x89, 0x32, 0xfd, 0x60, 0x0a,
	0x6b, 0x3d, 0xf3, 0x3c, 0xd4, 0x56, 0xf9, 0x2f, 0x05, 0xb4, 0x01, 0x16, 0x83, 0x30, 0xe8, 0xb6,
	0x63, 0x07, 0x36, 0x67, 0x5b, 0x9c, 0xbf, 0xf8, 0x72, 0xca, 0x13, 0x57, 0xe2, 0x67, 0xa5, 0x02,
	0xc9, 0x7f, 0x7c, 0xf4, 0x12, 0x96, 0x4d, 0xcb, 0xb2, 0x05, 0xf1, 0x88, 0xee, 0xa3, 0x5b, 0x1d,
	0xd3, 0x69, 0x85, 0x4c, 0x20, 0xa4, 0xf5, 0x6c, 0x11, 0xab, 0xa3, 0x2c, 0x65, 0x29, 0x96, 0x97,
	0x5a, 0xb7, 0xb8, 0x34, 0xfa, 0x04, 0x4a, 0x82, 0xab, 0x31, 0x0a, 0x90, 0xe0, 0xb2, 0x54, 0xbc,
	0xc0, 0xfb, 0x0f, 0x9d, 0xa3, 0x41, 0xc7, 0x54, 0xf9, 0x59, 0x1a, 0x8a, 0x97, 0x5c, 0xff, 0x87,
	0x50, 0xec, 0x04, 0x81, 0xe7, 0x47, 0x2c, 0x53, 0x44, 0x77, 0x96, 0xc1, 0xf3, 0xf6, 0x10, 0x8e,
	0xbe, 0x05, 0xb3, 0x7e, 0xab, 0x43, 0x7a, 0x24, 0x46, 0x66, 0x65, 0x81, 0xb1, 0x28, 0x3a, 0x22,
	0xe8, 0x7d, 0x28, 0x48, 0x87, 0x2f, 0x81, 0xc2, 0x4f, 0xe7, 0x45, 0x72, 0x1a, 0x83, 0x3c, 0x97,
	0x0e, 0x80, 0xd8, 0x39, 0x2f, 0xe0, 0x3c, 0x6b, 0x8c, 0x40, 0x1f, 0x40, 0x81, 0xd7, 0xbf, 0x22,
	0xd0, 0xb4, 0x4c, 0x74, 0xf3, 0xac, 0x39, 0x82, 0x7d, 0x98, 0x9c, 0x35, 0x37, 0x95, 0xcb, 0x79,
	0x73, 0x07, 0x0a, 0xc3, 0xf5, 0x81, 0x14, 0xe7, 0xd2, 0x8f, 0xc6, 0xdf, 0xe9, 0x46, 0xaf, 0x57,
	0xd6, 0x06, 0xf2, 0x74, 0x30, 0x28, 0xdf, 0x05, 0xcd, 0x0f, 0xa8, 0xed, 0x19, 0xbc, 0x6a, 0xc8,
	0x3d, 0xa6, 0x8a, 0x81, 0x37, 0xf1, 0xf2, 0x62, 0xe5, 0x0d, 0x2c, 0x24, 0xa9, 0x44, 0xb7, 0x60,
	0x6e, 0xff, 0xf0, 0x45, 0x63, 0xdb, 0x38, 0x6a, 0xe0, 0xfd, 0xda, 0x41, 0xe3, 0xe0, 0x64, 0xef,
	0xa5, 0x3e, 0x85, 0x72, 0x30, 0x23, 0xe3, 0x38, 0x0b, 0xeb, 0xc7, 0x8d, 0x86, 0x71, 0x78, 0xd2,
	0x6c, 0x60, 0x7d, 0x1a, 0x2d, 0x02, 0x3a, 0x69, 0xec, 0x1f, 0x1d, 0xe2, 0x1a, 0x7e, 0x19, 0x87,
	0xe4, 0x14, 0x6b, 0x8f, 0x54, 0xc4, 0xed, 0xe9, 0x7a, 0x19, 0x4a, 0xd1, 0x46, 0x5e, 0x0a, 0xc8,
	0x2c, 0x54, 0xcb, 0xf5, 0xbe, 0xd4, 0x53, 0x71, 0x61, 0x21, 0xe9, 0x6e, 0x1a, 0xbd, 0x0f, 0x19,
	0xe1, 0xdb, 0xf9, 0x26, 0x17, 0xea, 0x79, 0x7e, 0x86, 0x1f, 0xcc, 0xe8, 0xbf, 0x4a, 0xaf, 0x59,
	0x58, 0xf6, 0xa1, 0x8f, 0x21, 0xfd, 0xca, 0xb5, 0x2e, 0x2e, 0x99, 0xfd, 0x20, 0x55, 0xdf, 0x36,
	0x03, 0xf3, 0x98, 0xb3, 0x2e, 0xcc, 0xa1, 0x95, 0x4d, 0xc8, 0x45, 0x97, 0xd0, 0xe8, 0x43, 0xc8,
	0x31, 0xbe, 0xc6, 0x4f, 0xf6, 0xa8, 0x07, 0x8c, 0xfb, 0x2a, 0x7f, 0xa1, 0x40, 0x71, 0xf8, 0x77,
	0x4b, 0xe8, 0x37, 0x20, 0xeb, 0xb1, 0xc8, 0x45, 0x43, 0x49, 0x31, 0x45, 0xca, 0x4c, 0xe4, 0x87,
	0x2a, 0x0e, 0x3b, 0x23, 0x07, 0x3b, 0x9d, 0xec, 0x60, 0xbf, 0x0b, 0x19, 0x51, 0xf4, 0x94, 0x36,
	0xb3, 0x9a, 0x94, 0x6f, 0xc8, 0xdc, 0x87, 0xe3, 0xb0, 0xc4, 0x57, 0xfe, 0x35, 0x07, 0xb9, 0x28,
	0x9f, 0x46, 0x9f, 0xc3, 0x8c, 0x1f, 0x98, 0x6d, 0x72, 0x23, 0xff, 0x52, 0x02, 0x2c, 0xa4, 0x98,
	0x5d, 0x59, 0xb6, 0xcf, 0x63, 0x6a, 0x94, 0x25, 0x61, 0x90, 0x4d, 0x2c, 0x43, 0xda, 0x85, 0xac,
	0xf0, 0x23, 0xe1, 0x6f, 0xce, 0xde, 0xbf, 0xb6, 0x76, 0x50, 0x15, 0xfb, 0x38, 0xfc, 0xf3, 0x35,
	0xa9, 0xa0, 0xfc, 0x37, 0x2a, 0x64, 0xe4, 0x3e, 0x7f, 0x1f, 0x8a, 0x92, 0x25, 0x0f, 0x66, 0x72,
	0x57, 0xf1, 0x8e, 0x4b, 0xda, 0xab, 0x62, 0x67, 0xe3, 0x62, 0x5e, 0xc1, 0x1f, 0x6c, 0x40, 0x3f,
	0x80, 0x79, 0x8b, 0xf8, 0x81, 0xed, 0xf0, 0x4d, 0x8c, 0x46, 0x10, 0xd6, 0xf2, 0x68, 0xa2, 0x11,
	0xb6, 0x63, 0xf9, 0x78, 0x18, 0x64, 0x8d, 0xb4, 0xa2, 0x3f, 0x84, 0xd9, 0x4b, 0x77, 0x7c, 0x32,
	0xf0, 0x3d, 0x9c, 0x68, 0x1c, 0x3c, 0x74, 0xfd, 0xc7, 0x9c, 0xdf, 0xf0, 0x85, 0x20, 0x5b, 0x28,
	0x4a, 0x7a, 0x6e, 0x40, 0x0c, 0xd3, 0xb2, 0x28, 0xf1, 0x7d, 0x49, 0xfe, 0x36, 0x26, 0x54, 0xcf,
	0x44, 0x6b, 0x42, 0x92, 0x2d, 0x14, 0x1d, 0x6c, 0x40, 0x18, 0xb4, 0x36, 0x71, 0x08, 0xb5, 0x5b,
	0x7c, 0xf7, 0xc5, 0x0f, 0x38, 0xd6, 0x27, 0xd2, 0xfc, 0x54, 0xc8, 0x3d, 0x23, 0x2c, 0x98, 0x43,
	0x3b, 0x7a, 0x43, 0x04, 0x90, 0xcc, 0xd9, 0xf8, 0x8d, 0x93, 0x2c, 0x5d, 0x8a, 0x52, 0xfa, 0x6f,
	0x4d, 0xa4, 0x7a, 0xe0, 0x1a, 0x93, 0x57, 0x31, 0x9b, 0x53, 0x58, 0xef, 0x5c, 0x6a, 0x2b, 0xcf,
	0x42, 0x61, 0xc8, 0x0a, 0xca, 0x0b, 0x80, 0x46, 0x37, 0xad, 0xec, 0xb0, 0x08, 0x35, 0xb4, 0xa0,
	0x37, 0xc8, 0x29, 0xd1, 0x77, 0xa0, 0x68, 0x11, 0xbf, 0x45, 0x6d, 0x2f, 0x70, 0xe9, 0x40, 0x19,
	0x61, 0x00, 0x5e, 0x88, 0x01, 0xcf, 0xc8, 0x05, 0x9b, 0xd6, 0xd0, 0x9a, 0x97, 0xeb, 0x00, 0xf1,
	0x52, 0xa1, 0x4d, 0xd0, 0x07, 0x14, 0x8a, 0x5b, 0xbb, 0x91, 0x19, 0xcc, 0xc6, 0x10, 0xfe, 0xc1,
	0xe5, 0x5f, 0x2a, 0xa0, 0x5f, 0x5e, 0x94, 0x77, 0x53, 0x85, 0x3e, 0x87, 0x3c, 0x39, 0xf7, 0x48,
	0x2b, 0x90, 0xfb, 0x32, 0x3e, 0x6d, 0xd4, 0x04, 0x5e, 0x0c, 0xfa, 0x34, 0xbe, 0x36, 0x4b, 0x4d,
	0x78, 0x6d, 0x36, 0xec, 0x0a, 0xa4, 0x34, 0x4b, 0x84, 0x85, 0x57, 0x18, 0xc9, 0xef, 0x2a, 0x7f,
	0x9a, 0x82, 0xc2, 0x90, 0x86, 0x71, 0x5c, 0xf5, 0x1e, 0x68, 0xe4, 0xdc, 0x8c, 0x3e, 0x29, 0x2d,
	0x69, 0x04, 0xf0, 0x46, 0x31, 0xef, 0x8f, 0x40, 0xe3, 0x57, 0x53, 0x12, 0x32, 0x93, 0x70, 0x67,
	0x09, 0x1c, 0x20, 0xe0, 0x8f, 0x41, 0xe3, 0xbf, 0x39, 0x1e, 0x32, 0xde, 0xc5, 0x41, 0x76, 0xb5,
	0xe3, 0x04, 0x9f, 0x6c, 0x62, 0x86, 0xe1, 0xa2, 0xec, 0x21, 0xac, 0xb8, 0x33, 0x8e, 0xe0, 0x13,
	0x27, 0x9c, 0x4e, 0x56, 0xf2, 0x9f, 0xbc, 0x6c, 0x16, 0xb0, 0x2a, 0xe4, 0x25, 0xc5, 0x10, 0xa8,
	0xdc, 0xe8, 0x95, 0x87, 0x26, 0x00, 0x11, 0xde, 0xef, 0x9f, 0xc6, 0x78, 0x48, 0xc0, 0x0b, 0x80,
	0xc0, 0xdf, 0x83, 0xbc, 0xed, 0x9c, 0x11, 0x1a, 0xce, 0x42, 0xe5, 0x84, 0x41, 0x13, 0x6d, 0xe2,
	0xb7, 0x6d, 0x2c, 0x8f, 0x16, 0x07, 0x81, 0x43, 0x86, 0xf2, 0xe8, 0x69, 0x3d, 0xb5, 0x9b, 0x56,
	0x53, 0x7a, 0xba, 0xf2, 0xc7, 0x0a, 0xdc, 0x4a, 0xbc, 0xc0, 0x44, 0xab, 0x43, 0xbb, 0x32, 0x1c,
	0x05, 0xc5, 0xc6, 0x2c, 0x84, 0x17, 0xd3, 0xa2, 0x6e, 0x22, 0x5e, 0xd0, 0x77, 0xc2, 0x9b, 0xe3,
	0xf1, 0x97, 0xc1, 0x02, 0x58, 0x3f, 0xf8, 0xdb, 0xb7, 0x2b, 0xca, 0x2f, 0xde, 0xae, 0x28, 0xbf,
	0x7c, 0xbb, 0xa2, 0xfc, 0xea, 0xed, 0x8a, 0xf2, 0x1f, 0x6f, 0x57, 0x14, 0x58, 0xb5, 0x5d, 0xb1,
	0x23, 0x1e, 0x75, 0xcf, 0x2f, 0x12, 0xec, 0xb0, 0x2e, 0xee, 0xb7, 0x8f, 0x98, 0xde, 0x23, 0xe5,
	0x0b, 0xf1, 0x13, 0xbc, 0x3f, 0x51, 0x94, 0x57, 0x19, 0x3e, 0xd4, 0xc3, 0xff, 0x09, 0x00, 0x00,
	0xff, 0xff, 0x3f, 0xad, 0xa9, 0xc1, 0xd0, 0x2e, 0x00, 0x00,
}

func (this *VirtualHost) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VirtualHost)
	if !ok {
		that2, ok := that.(VirtualHost)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Domains) != len(that1.Domains) {
		return false
	}
	for i := range this.Domains {
		if this.Domains[i] != that1.Domains[i] {
			return false
		}
	}
	if len(this.Routes) != len(that1.Routes) {
		return false
	}
	for i := range this.Routes {
		if !this.Routes[i].Equal(&that1.Routes[i]) {
			return false
		}
	}
	if this.RequireTls != that1.RequireTls {
		return false
	}
	if len(this.VirtualClusters) != len(that1.VirtualClusters) {
		return false
	}
	for i := range this.VirtualClusters {
		if !this.VirtualClusters[i].Equal(that1.VirtualClusters[i]) {
			return false
		}
	}
	if len(this.RateLimits) != len(that1.RateLimits) {
		return false
	}
	for i := range this.RateLimits {
		if !this.RateLimits[i].Equal(that1.RateLimits[i]) {
			return false
		}
	}
	if len(this.RequestHeadersToAdd) != len(that1.RequestHeadersToAdd) {
		return false
	}
	for i := range this.RequestHeadersToAdd {
		if !this.RequestHeadersToAdd[i].Equal(that1.RequestHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.RequestHeadersToRemove) != len(that1.RequestHeadersToRemove) {
		return false
	}
	for i := range this.RequestHeadersToRemove {
		if this.RequestHeadersToRemove[i] != that1.RequestHeadersToRemove[i] {
			return false
		}
	}
	if len(this.ResponseHeadersToAdd) != len(that1.ResponseHeadersToAdd) {
		return false
	}
	for i := range this.ResponseHeadersToAdd {
		if !this.ResponseHeadersToAdd[i].Equal(that1.ResponseHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.ResponseHeadersToRemove) != len(that1.ResponseHeadersToRemove) {
		return false
	}
	for i := range this.ResponseHeadersToRemove {
		if this.ResponseHeadersToRemove[i] != that1.ResponseHeadersToRemove[i] {
			return false
		}
	}
	if !this.Cors.Equal(that1.Cors) {
		return false
	}
	if len(this.PerFilterConfig) != len(that1.PerFilterConfig) {
		return false
	}
	for i := range this.PerFilterConfig {
		if !this.PerFilterConfig[i].Equal(that1.PerFilterConfig[i]) {
			return false
		}
	}
	if len(this.TypedPerFilterConfig) != len(that1.TypedPerFilterConfig) {
		return false
	}
	for i := range this.TypedPerFilterConfig {
		if !this.TypedPerFilterConfig[i].Equal(that1.TypedPerFilterConfig[i]) {
			return false
		}
	}
	if this.IncludeRequestAttemptCount != that1.IncludeRequestAttemptCount {
		return false
	}
	if !this.RetryPolicy.Equal(that1.RetryPolicy) {
		return false
	}
	if !this.HedgePolicy.Equal(that1.HedgePolicy) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Route) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Route)
	if !ok {
		that2, ok := that.(Route)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Match.Equal(&that1.Match) {
		return false
	}
	if that1.Action == nil {
		if this.Action != nil {
			return false
		}
	} else if this.Action == nil {
		return false
	} else if !this.Action.Equal(that1.Action) {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Decorator.Equal(that1.Decorator) {
		return false
	}
	if len(this.PerFilterConfig) != len(that1.PerFilterConfig) {
		return false
	}
	for i := range this.PerFilterConfig {
		if !this.PerFilterConfig[i].Equal(that1.PerFilterConfig[i]) {
			return false
		}
	}
	if len(this.TypedPerFilterConfig) != len(that1.TypedPerFilterConfig) {
		return false
	}
	for i := range this.TypedPerFilterConfig {
		if !this.TypedPerFilterConfig[i].Equal(that1.TypedPerFilterConfig[i]) {
			return false
		}
	}
	if len(this.RequestHeadersToAdd) != len(that1.RequestHeadersToAdd) {
		return false
	}
	for i := range this.RequestHeadersToAdd {
		if !this.RequestHeadersToAdd[i].Equal(that1.RequestHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.RequestHeadersToRemove) != len(that1.RequestHeadersToRemove) {
		return false
	}
	for i := range this.RequestHeadersToRemove {
		if this.RequestHeadersToRemove[i] != that1.RequestHeadersToRemove[i] {
			return false
		}
	}
	if len(this.ResponseHeadersToAdd) != len(that1.ResponseHeadersToAdd) {
		return false
	}
	for i := range this.ResponseHeadersToAdd {
		if !this.ResponseHeadersToAdd[i].Equal(that1.ResponseHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.ResponseHeadersToRemove) != len(that1.ResponseHeadersToRemove) {
		return false
	}
	for i := range this.ResponseHeadersToRemove {
		if this.ResponseHeadersToRemove[i] != that1.ResponseHeadersToRemove[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Route_Route) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Route_Route)
	if !ok {
		that2, ok := that.(Route_Route)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Route.Equal(that1.Route) {
		return false
	}
	return true
}
func (this *Route_Redirect) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Route_Redirect)
	if !ok {
		that2, ok := that.(Route_Redirect)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Redirect.Equal(that1.Redirect) {
		return false
	}
	return true
}
func (this *Route_DirectResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Route_DirectResponse)
	if !ok {
		that2, ok := that.(Route_DirectResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.DirectResponse.Equal(that1.DirectResponse) {
		return false
	}
	return true
}
func (this *WeightedCluster) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WeightedCluster)
	if !ok {
		that2, ok := that.(WeightedCluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Clusters) != len(that1.Clusters) {
		return false
	}
	for i := range this.Clusters {
		if !this.Clusters[i].Equal(that1.Clusters[i]) {
			return false
		}
	}
	if !this.TotalWeight.Equal(that1.TotalWeight) {
		return false
	}
	if this.RuntimeKeyPrefix != that1.RuntimeKeyPrefix {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *WeightedCluster_ClusterWeight) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WeightedCluster_ClusterWeight)
	if !ok {
		that2, ok := that.(WeightedCluster_ClusterWeight)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Weight.Equal(that1.Weight) {
		return false
	}
	if !this.MetadataMatch.Equal(that1.MetadataMatch) {
		return false
	}
	if len(this.RequestHeadersToAdd) != len(that1.RequestHeadersToAdd) {
		return false
	}
	for i := range this.RequestHeadersToAdd {
		if !this.RequestHeadersToAdd[i].Equal(that1.RequestHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.RequestHeadersToRemove) != len(that1.RequestHeadersToRemove) {
		return false
	}
	for i := range this.RequestHeadersToRemove {
		if this.RequestHeadersToRemove[i] != that1.RequestHeadersToRemove[i] {
			return false
		}
	}
	if len(this.ResponseHeadersToAdd) != len(that1.ResponseHeadersToAdd) {
		return false
	}
	for i := range this.ResponseHeadersToAdd {
		if !this.ResponseHeadersToAdd[i].Equal(that1.ResponseHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.ResponseHeadersToRemove) != len(that1.ResponseHeadersToRemove) {
		return false
	}
	for i := range this.ResponseHeadersToRemove {
		if this.ResponseHeadersToRemove[i] != that1.ResponseHeadersToRemove[i] {
			return false
		}
	}
	if len(this.PerFilterConfig) != len(that1.PerFilterConfig) {
		return false
	}
	for i := range this.PerFilterConfig {
		if !this.PerFilterConfig[i].Equal(that1.PerFilterConfig[i]) {
			return false
		}
	}
	if len(this.TypedPerFilterConfig) != len(that1.TypedPerFilterConfig) {
		return false
	}
	for i := range this.TypedPerFilterConfig {
		if !this.TypedPerFilterConfig[i].Equal(that1.TypedPerFilterConfig[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RouteMatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteMatch)
	if !ok {
		that2, ok := that.(RouteMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.PathSpecifier == nil {
		if this.PathSpecifier != nil {
			return false
		}
	} else if this.PathSpecifier == nil {
		return false
	} else if !this.PathSpecifier.Equal(that1.PathSpecifier) {
		return false
	}
	if !this.CaseSensitive.Equal(that1.CaseSensitive) {
		return false
	}
	if !this.RuntimeFraction.Equal(that1.RuntimeFraction) {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	if len(this.QueryParameters) != len(that1.QueryParameters) {
		return false
	}
	for i := range this.QueryParameters {
		if !this.QueryParameters[i].Equal(that1.QueryParameters[i]) {
			return false
		}
	}
	if !this.Grpc.Equal(that1.Grpc) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RouteMatch_Prefix) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteMatch_Prefix)
	if !ok {
		that2, ok := that.(RouteMatch_Prefix)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Prefix != that1.Prefix {
		return false
	}
	return true
}
func (this *RouteMatch_Path) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteMatch_Path)
	if !ok {
		that2, ok := that.(RouteMatch_Path)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *RouteMatch_Regex) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteMatch_Regex)
	if !ok {
		that2, ok := that.(RouteMatch_Regex)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Regex != that1.Regex {
		return false
	}
	return true
}
func (this *RouteMatch_GrpcRouteMatchOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteMatch_GrpcRouteMatchOptions)
	if !ok {
		that2, ok := that.(RouteMatch_GrpcRouteMatchOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CorsPolicy) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CorsPolicy)
	if !ok {
		that2, ok := that.(CorsPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.AllowOrigin) != len(that1.AllowOrigin) {
		return false
	}
	for i := range this.AllowOrigin {
		if this.AllowOrigin[i] != that1.AllowOrigin[i] {
			return false
		}
	}
	if len(this.AllowOriginRegex) != len(that1.AllowOriginRegex) {
		return false
	}
	for i := range this.AllowOriginRegex {
		if this.AllowOriginRegex[i] != that1.AllowOriginRegex[i] {
			return false
		}
	}
	if this.AllowMethods != that1.AllowMethods {
		return false
	}
	if this.AllowHeaders != that1.AllowHeaders {
		return false
	}
	if this.ExposeHeaders != that1.ExposeHeaders {
		return false
	}
	if this.MaxAge != that1.MaxAge {
		return false
	}
	if !this.AllowCredentials.Equal(that1.AllowCredentials) {
		return false
	}
	if that1.EnabledSpecifier == nil {
		if this.EnabledSpecifier != nil {
			return false
		}
	} else if this.EnabledSpecifier == nil {
		return false
	} else if !this.EnabledSpecifier.Equal(that1.EnabledSpecifier) {
		return false
	}
	if !this.ShadowEnabled.Equal(that1.ShadowEnabled) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CorsPolicy_Enabled) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CorsPolicy_Enabled)
	if !ok {
		that2, ok := that.(CorsPolicy_Enabled)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Enabled.Equal(that1.Enabled) {
		return false
	}
	return true
}
func (this *CorsPolicy_FilterEnabled) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CorsPolicy_FilterEnabled)
	if !ok {
		that2, ok := that.(CorsPolicy_FilterEnabled)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.FilterEnabled.Equal(that1.FilterEnabled) {
		return false
	}
	return true
}
func (this *RouteAction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction)
	if !ok {
		that2, ok := that.(RouteAction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.ClusterSpecifier == nil {
		if this.ClusterSpecifier != nil {
			return false
		}
	} else if this.ClusterSpecifier == nil {
		return false
	} else if !this.ClusterSpecifier.Equal(that1.ClusterSpecifier) {
		return false
	}
	if this.ClusterNotFoundResponseCode != that1.ClusterNotFoundResponseCode {
		return false
	}
	if !this.MetadataMatch.Equal(that1.MetadataMatch) {
		return false
	}
	if this.PrefixRewrite != that1.PrefixRewrite {
		return false
	}
	if that1.HostRewriteSpecifier == nil {
		if this.HostRewriteSpecifier != nil {
			return false
		}
	} else if this.HostRewriteSpecifier == nil {
		return false
	} else if !this.HostRewriteSpecifier.Equal(that1.HostRewriteSpecifier) {
		return false
	}
	if this.Timeout != nil && that1.Timeout != nil {
		if *this.Timeout != *that1.Timeout {
			return false
		}
	} else if this.Timeout != nil {
		return false
	} else if that1.Timeout != nil {
		return false
	}
	if this.IdleTimeout != nil && that1.IdleTimeout != nil {
		if *this.IdleTimeout != *that1.IdleTimeout {
			return false
		}
	} else if this.IdleTimeout != nil {
		return false
	} else if that1.IdleTimeout != nil {
		return false
	}
	if !this.RetryPolicy.Equal(that1.RetryPolicy) {
		return false
	}
	if !this.RequestMirrorPolicy.Equal(that1.RequestMirrorPolicy) {
		return false
	}
	if this.Priority != that1.Priority {
		return false
	}
	if len(this.RateLimits) != len(that1.RateLimits) {
		return false
	}
	for i := range this.RateLimits {
		if !this.RateLimits[i].Equal(that1.RateLimits[i]) {
			return false
		}
	}
	if !this.IncludeVhRateLimits.Equal(that1.IncludeVhRateLimits) {
		return false
	}
	if len(this.HashPolicy) != len(that1.HashPolicy) {
		return false
	}
	for i := range this.HashPolicy {
		if !this.HashPolicy[i].Equal(that1.HashPolicy[i]) {
			return false
		}
	}
	if !this.Cors.Equal(that1.Cors) {
		return false
	}
	if this.MaxGrpcTimeout != nil && that1.MaxGrpcTimeout != nil {
		if *this.MaxGrpcTimeout != *that1.MaxGrpcTimeout {
			return false
		}
	} else if this.MaxGrpcTimeout != nil {
		return false
	} else if that1.MaxGrpcTimeout != nil {
		return false
	}
	if this.GrpcTimeoutOffset != nil && that1.GrpcTimeoutOffset != nil {
		if *this.GrpcTimeoutOffset != *that1.GrpcTimeoutOffset {
			return false
		}
	} else if this.GrpcTimeoutOffset != nil {
		return false
	} else if that1.GrpcTimeoutOffset != nil {
		return false
	}
	if len(this.UpgradeConfigs) != len(that1.UpgradeConfigs) {
		return false
	}
	for i := range this.UpgradeConfigs {
		if !this.UpgradeConfigs[i].Equal(that1.UpgradeConfigs[i]) {
			return false
		}
	}
	if this.InternalRedirectAction != that1.InternalRedirectAction {
		return false
	}
	if !this.HedgePolicy.Equal(that1.HedgePolicy) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RouteAction_Cluster) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_Cluster)
	if !ok {
		that2, ok := that.(RouteAction_Cluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Cluster != that1.Cluster {
		return false
	}
	return true
}
func (this *RouteAction_ClusterHeader) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_ClusterHeader)
	if !ok {
		that2, ok := that.(RouteAction_ClusterHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClusterHeader != that1.ClusterHeader {
		return false
	}
	return true
}
func (this *RouteAction_WeightedClusters) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_WeightedClusters)
	if !ok {
		that2, ok := that.(RouteAction_WeightedClusters)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.WeightedClusters.Equal(that1.WeightedClusters) {
		return false
	}
	return true
}
func (this *RouteAction_HostRewrite) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_HostRewrite)
	if !ok {
		that2, ok := that.(RouteAction_HostRewrite)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HostRewrite != that1.HostRewrite {
		return false
	}
	return true
}
func (this *RouteAction_AutoHostRewrite) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_AutoHostRewrite)
	if !ok {
		that2, ok := that.(RouteAction_AutoHostRewrite)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.AutoHostRewrite.Equal(that1.AutoHostRewrite) {
		return false
	}
	return true
}
func (this *RouteAction_RequestMirrorPolicy) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_RequestMirrorPolicy)
	if !ok {
		that2, ok := that.(RouteAction_RequestMirrorPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Cluster != that1.Cluster {
		return false
	}
	if this.RuntimeKey != that1.RuntimeKey {
		return false
	}
	if !this.RuntimeFraction.Equal(that1.RuntimeFraction) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_HashPolicy)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.PolicySpecifier == nil {
		if this.PolicySpecifier != nil {
			return false
		}
	} else if this.PolicySpecifier == nil {
		return false
	} else if !this.PolicySpecifier.Equal(that1.PolicySpecifier) {
		return false
	}
	if this.Terminal != that1.Terminal {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_Header_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_HashPolicy_Header_)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_Header_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Header.Equal(that1.Header) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_Cookie_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_HashPolicy_Cookie_)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_Cookie_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Cookie.Equal(that1.Cookie) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_ConnectionProperties_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_HashPolicy_ConnectionProperties_)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_ConnectionProperties_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ConnectionProperties.Equal(that1.ConnectionProperties) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_Header) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_HashPolicy_Header)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_Header)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HeaderName != that1.HeaderName {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_Cookie) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_HashPolicy_Cookie)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_Cookie)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Ttl != nil && that1.Ttl != nil {
		if *this.Ttl != *that1.Ttl {
			return false
		}
	} else if this.Ttl != nil {
		return false
	} else if that1.Ttl != nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_ConnectionProperties) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_HashPolicy_ConnectionProperties)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_ConnectionProperties)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SourceIp != that1.SourceIp {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RouteAction_UpgradeConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RouteAction_UpgradeConfig)
	if !ok {
		that2, ok := that.(RouteAction_UpgradeConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.UpgradeType != that1.UpgradeType {
		return false
	}
	if !this.Enabled.Equal(that1.Enabled) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RetryPolicy) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RetryPolicy)
	if !ok {
		that2, ok := that.(RetryPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RetryOn != that1.RetryOn {
		return false
	}
	if !this.NumRetries.Equal(that1.NumRetries) {
		return false
	}
	if this.PerTryTimeout != nil && that1.PerTryTimeout != nil {
		if *this.PerTryTimeout != *that1.PerTryTimeout {
			return false
		}
	} else if this.PerTryTimeout != nil {
		return false
	} else if that1.PerTryTimeout != nil {
		return false
	}
	if !this.RetryPriority.Equal(that1.RetryPriority) {
		return false
	}
	if len(this.RetryHostPredicate) != len(that1.RetryHostPredicate) {
		return false
	}
	for i := range this.RetryHostPredicate {
		if !this.RetryHostPredicate[i].Equal(that1.RetryHostPredicate[i]) {
			return false
		}
	}
	if this.HostSelectionRetryMaxAttempts != that1.HostSelectionRetryMaxAttempts {
		return false
	}
	if len(this.RetriableStatusCodes) != len(that1.RetriableStatusCodes) {
		return false
	}
	for i := range this.RetriableStatusCodes {
		if this.RetriableStatusCodes[i] != that1.RetriableStatusCodes[i] {
			return false
		}
	}
	if !this.RetryBackOff.Equal(that1.RetryBackOff) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RetryPolicy_RetryPriority) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RetryPolicy_RetryPriority)
	if !ok {
		that2, ok := that.(RetryPolicy_RetryPriority)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.ConfigType == nil {
		if this.ConfigType != nil {
			return false
		}
	} else if this.ConfigType == nil {
		return false
	} else if !this.ConfigType.Equal(that1.ConfigType) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RetryPolicy_RetryPriority_Config) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RetryPolicy_RetryPriority_Config)
	if !ok {
		that2, ok := that.(RetryPolicy_RetryPriority_Config)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (this *RetryPolicy_RetryPriority_TypedConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RetryPolicy_RetryPriority_TypedConfig)
	if !ok {
		that2, ok := that.(RetryPolicy_RetryPriority_TypedConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TypedConfig.Equal(that1.TypedConfig) {
		return false
	}
	return true
}
func (this *RetryPolicy_RetryHostPredicate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RetryPolicy_RetryHostPredicate)
	if !ok {
		that2, ok := that.(RetryPolicy_RetryHostPredicate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.ConfigType == nil {
		if this.ConfigType != nil {
			return false
		}
	} else if this.ConfigType == nil {
		return false
	} else if !this.ConfigType.Equal(that1.ConfigType) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RetryPolicy_RetryHostPredicate_Config) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RetryPolicy_RetryHostPredicate_Config)
	if !ok {
		that2, ok := that.(RetryPolicy_RetryHostPredicate_Config)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (this *RetryPolicy_RetryHostPredicate_TypedConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RetryPolicy_RetryHostPredicate_TypedConfig)
	if !ok {
		that2, ok := that.(RetryPolicy_RetryHostPredicate_TypedConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TypedConfig.Equal(that1.TypedConfig) {
		return false
	}
	return true
}
func (this *RetryPolicy_RetryBackOff) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RetryPolicy_RetryBackOff)
	if !ok {
		that2, ok := that.(RetryPolicy_RetryBackOff)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BaseInterval != nil && that1.BaseInterval != nil {
		if *this.BaseInterval != *that1.BaseInterval {
			return false
		}
	} else if this.BaseInterval != nil {
		return false
	} else if that1.BaseInterval != nil {
		return false
	}
	if this.MaxInterval != nil && that1.MaxInterval != nil {
		if *this.MaxInterval != *that1.MaxInterval {
			return false
		}
	} else if this.MaxInterval != nil {
		return false
	} else if that1.MaxInterval != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HedgePolicy) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HedgePolicy)
	if !ok {
		that2, ok := that.(HedgePolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.InitialRequests.Equal(that1.InitialRequests) {
		return false
	}
	if !this.AdditionalRequestChance.Equal(that1.AdditionalRequestChance) {
		return false
	}
	if this.HedgeOnPerTryTimeout != that1.HedgeOnPerTryTimeout {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RedirectAction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RedirectAction)
	if !ok {
		that2, ok := that.(RedirectAction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.SchemeRewriteSpecifier == nil {
		if this.SchemeRewriteSpecifier != nil {
			return false
		}
	} else if this.SchemeRewriteSpecifier == nil {
		return false
	} else if !this.SchemeRewriteSpecifier.Equal(that1.SchemeRewriteSpecifier) {
		return false
	}
	if this.HostRedirect != that1.HostRedirect {
		return false
	}
	if this.PortRedirect != that1.PortRedirect {
		return false
	}
	if that1.PathRewriteSpecifier == nil {
		if this.PathRewriteSpecifier != nil {
			return false
		}
	} else if this.PathRewriteSpecifier == nil {
		return false
	} else if !this.PathRewriteSpecifier.Equal(that1.PathRewriteSpecifier) {
		return false
	}
	if this.ResponseCode != that1.ResponseCode {
		return false
	}
	if this.StripQuery != that1.StripQuery {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RedirectAction_HttpsRedirect) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RedirectAction_HttpsRedirect)
	if !ok {
		that2, ok := that.(RedirectAction_HttpsRedirect)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HttpsRedirect != that1.HttpsRedirect {
		return false
	}
	return true
}
func (this *RedirectAction_SchemeRedirect) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RedirectAction_SchemeRedirect)
	if !ok {
		that2, ok := that.(RedirectAction_SchemeRedirect)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SchemeRedirect != that1.SchemeRedirect {
		return false
	}
	return true
}
func (this *RedirectAction_PathRedirect) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RedirectAction_PathRedirect)
	if !ok {
		that2, ok := that.(RedirectAction_PathRedirect)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PathRedirect != that1.PathRedirect {
		return false
	}
	return true
}
func (this *RedirectAction_PrefixRewrite) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RedirectAction_PrefixRewrite)
	if !ok {
		that2, ok := that.(RedirectAction_PrefixRewrite)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PrefixRewrite != that1.PrefixRewrite {
		return false
	}
	return true
}
func (this *DirectResponseAction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DirectResponseAction)
	if !ok {
		that2, ok := that.(DirectResponseAction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.Body.Equal(that1.Body) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Decorator) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Decorator)
	if !ok {
		that2, ok := that.(Decorator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Operation != that1.Operation {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *VirtualCluster) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*VirtualCluster)
	if !ok {
		that2, ok := that.(VirtualCluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Pattern != that1.Pattern {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Method != that1.Method {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit)
	if !ok {
		that2, ok := that.(RateLimit)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Stage.Equal(that1.Stage) {
		return false
	}
	if this.DisableKey != that1.DisableKey {
		return false
	}
	if len(this.Actions) != len(that1.Actions) {
		return false
	}
	for i := range this.Actions {
		if !this.Actions[i].Equal(that1.Actions[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit_Action) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action)
	if !ok {
		that2, ok := that.(RateLimit_Action)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.ActionSpecifier == nil {
		if this.ActionSpecifier != nil {
			return false
		}
	} else if this.ActionSpecifier == nil {
		return false
	} else if !this.ActionSpecifier.Equal(that1.ActionSpecifier) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit_Action_SourceCluster_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_SourceCluster_)
	if !ok {
		that2, ok := that.(RateLimit_Action_SourceCluster_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SourceCluster.Equal(that1.SourceCluster) {
		return false
	}
	return true
}
func (this *RateLimit_Action_DestinationCluster_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_DestinationCluster_)
	if !ok {
		that2, ok := that.(RateLimit_Action_DestinationCluster_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.DestinationCluster.Equal(that1.DestinationCluster) {
		return false
	}
	return true
}
func (this *RateLimit_Action_RequestHeaders_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_RequestHeaders_)
	if !ok {
		that2, ok := that.(RateLimit_Action_RequestHeaders_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeaders.Equal(that1.RequestHeaders) {
		return false
	}
	return true
}
func (this *RateLimit_Action_RemoteAddress_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_RemoteAddress_)
	if !ok {
		that2, ok := that.(RateLimit_Action_RemoteAddress_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RemoteAddress.Equal(that1.RemoteAddress) {
		return false
	}
	return true
}
func (this *RateLimit_Action_GenericKey_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_GenericKey_)
	if !ok {
		that2, ok := that.(RateLimit_Action_GenericKey_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.GenericKey.Equal(that1.GenericKey) {
		return false
	}
	return true
}
func (this *RateLimit_Action_HeaderValueMatch_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_HeaderValueMatch_)
	if !ok {
		that2, ok := that.(RateLimit_Action_HeaderValueMatch_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HeaderValueMatch.Equal(that1.HeaderValueMatch) {
		return false
	}
	return true
}
func (this *RateLimit_Action_SourceCluster) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_SourceCluster)
	if !ok {
		that2, ok := that.(RateLimit_Action_SourceCluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit_Action_DestinationCluster) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_DestinationCluster)
	if !ok {
		that2, ok := that.(RateLimit_Action_DestinationCluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit_Action_RequestHeaders) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_RequestHeaders)
	if !ok {
		that2, ok := that.(RateLimit_Action_RequestHeaders)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.HeaderName != that1.HeaderName {
		return false
	}
	if this.DescriptorKey != that1.DescriptorKey {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit_Action_RemoteAddress) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_RemoteAddress)
	if !ok {
		that2, ok := that.(RateLimit_Action_RemoteAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit_Action_GenericKey) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_GenericKey)
	if !ok {
		that2, ok := that.(RateLimit_Action_GenericKey)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.DescriptorValue != that1.DescriptorValue {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit_Action_HeaderValueMatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimit_Action_HeaderValueMatch)
	if !ok {
		that2, ok := that.(RateLimit_Action_HeaderValueMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.DescriptorValue != that1.DescriptorValue {
		return false
	}
	if !this.ExpectMatch.Equal(that1.ExpectMatch) {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HeaderMatcher) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeaderMatcher)
	if !ok {
		that2, ok := that.(HeaderMatcher)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.HeaderMatchSpecifier == nil {
		if this.HeaderMatchSpecifier != nil {
			return false
		}
	} else if this.HeaderMatchSpecifier == nil {
		return false
	} else if !this.HeaderMatchSpecifier.Equal(that1.HeaderMatchSpecifier) {
		return false
	}
	if this.InvertMatch != that1.InvertMatch {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HeaderMatcher_ExactMatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeaderMatcher_ExactMatch)
	if !ok {
		that2, ok := that.(HeaderMatcher_ExactMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ExactMatch != that1.ExactMatch {
		return false
	}
	return true
}
func (this *HeaderMatcher_RegexMatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeaderMatcher_RegexMatch)
	if !ok {
		that2, ok := that.(HeaderMatcher_RegexMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RegexMatch != that1.RegexMatch {
		return false
	}
	return true
}
func (this *HeaderMatcher_RangeMatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeaderMatcher_RangeMatch)
	if !ok {
		that2, ok := that.(HeaderMatcher_RangeMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RangeMatch.Equal(that1.RangeMatch) {
		return false
	}
	return true
}
func (this *HeaderMatcher_PresentMatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeaderMatcher_PresentMatch)
	if !ok {
		that2, ok := that.(HeaderMatcher_PresentMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PresentMatch != that1.PresentMatch {
		return false
	}
	return true
}
func (this *HeaderMatcher_PrefixMatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeaderMatcher_PrefixMatch)
	if !ok {
		that2, ok := that.(HeaderMatcher_PrefixMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PrefixMatch != that1.PrefixMatch {
		return false
	}
	return true
}
func (this *HeaderMatcher_SuffixMatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeaderMatcher_SuffixMatch)
	if !ok {
		that2, ok := that.(HeaderMatcher_SuffixMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SuffixMatch != that1.SuffixMatch {
		return false
	}
	return true
}
func (this *QueryParameterMatcher) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryParameterMatcher)
	if !ok {
		that2, ok := that.(QueryParameterMatcher)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if !this.Regex.Equal(that1.Regex) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (m *VirtualHost) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualHost) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Domains) > 0 {
		for _, s := range m.Domains {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Routes) > 0 {
		for _, msg := range m.Routes {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.RequireTls != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RequireTls))
	}
	if len(m.VirtualClusters) > 0 {
		for _, msg := range m.VirtualClusters {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RateLimits) > 0 {
		for _, msg := range m.RateLimits {
			dAtA[i] = 0x32
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, msg := range m.RequestHeadersToAdd {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Cors != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Cors.Size()))
		n1, err := m.Cors.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, msg := range m.ResponseHeadersToAdd {
			dAtA[i] = 0x52
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			dAtA[i] = 0x5a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.PerFilterConfig) > 0 {
		keysForPerFilterConfig := make([]string, 0, len(m.PerFilterConfig))
		for k, _ := range m.PerFilterConfig {
			keysForPerFilterConfig = append(keysForPerFilterConfig, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForPerFilterConfig)
		for _, k := range keysForPerFilterConfig {
			dAtA[i] = 0x62
			i++
			v := m.PerFilterConfig[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRoute(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRoute(uint64(len(k))) + msgSize
			i = encodeVarintRoute(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRoute(dAtA, i, uint64(v.Size()))
				n2, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n2
			}
		}
	}
	if len(m.RequestHeadersToRemove) > 0 {
		for _, s := range m.RequestHeadersToRemove {
			dAtA[i] = 0x6a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.IncludeRequestAttemptCount {
		dAtA[i] = 0x70
		i++
		if m.IncludeRequestAttemptCount {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.TypedPerFilterConfig) > 0 {
		keysForTypedPerFilterConfig := make([]string, 0, len(m.TypedPerFilterConfig))
		for k, _ := range m.TypedPerFilterConfig {
			keysForTypedPerFilterConfig = append(keysForTypedPerFilterConfig, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForTypedPerFilterConfig)
		for _, k := range keysForTypedPerFilterConfig {
			dAtA[i] = 0x7a
			i++
			v := m.TypedPerFilterConfig[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRoute(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRoute(uint64(len(k))) + msgSize
			i = encodeVarintRoute(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRoute(dAtA, i, uint64(v.Size()))
				n3, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n3
			}
		}
	}
	if m.RetryPolicy != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RetryPolicy.Size()))
		n4, err := m.RetryPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.HedgePolicy != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.HedgePolicy.Size()))
		n5, err := m.HedgePolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Route) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Route) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintRoute(dAtA, i, uint64(m.Match.Size()))
	n6, err := m.Match.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if m.Action != nil {
		nn7, err := m.Action.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn7
	}
	if m.Metadata != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Metadata.Size()))
		n8, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Decorator != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Decorator.Size()))
		n9, err := m.Decorator.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if len(m.PerFilterConfig) > 0 {
		keysForPerFilterConfig := make([]string, 0, len(m.PerFilterConfig))
		for k, _ := range m.PerFilterConfig {
			keysForPerFilterConfig = append(keysForPerFilterConfig, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForPerFilterConfig)
		for _, k := range keysForPerFilterConfig {
			dAtA[i] = 0x42
			i++
			v := m.PerFilterConfig[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRoute(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRoute(uint64(len(k))) + msgSize
			i = encodeVarintRoute(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRoute(dAtA, i, uint64(v.Size()))
				n10, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n10
			}
		}
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, msg := range m.RequestHeadersToAdd {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, msg := range m.ResponseHeadersToAdd {
			dAtA[i] = 0x52
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			dAtA[i] = 0x5a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.RequestHeadersToRemove) > 0 {
		for _, s := range m.RequestHeadersToRemove {
			dAtA[i] = 0x62
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.TypedPerFilterConfig) > 0 {
		keysForTypedPerFilterConfig := make([]string, 0, len(m.TypedPerFilterConfig))
		for k, _ := range m.TypedPerFilterConfig {
			keysForTypedPerFilterConfig = append(keysForTypedPerFilterConfig, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForTypedPerFilterConfig)
		for _, k := range keysForTypedPerFilterConfig {
			dAtA[i] = 0x6a
			i++
			v := m.TypedPerFilterConfig[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRoute(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRoute(uint64(len(k))) + msgSize
			i = encodeVarintRoute(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRoute(dAtA, i, uint64(v.Size()))
				n11, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n11
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Route_Route) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Route != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Route.Size()))
		n12, err := m.Route.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *Route_Redirect) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Redirect != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Redirect.Size()))
		n13, err := m.Redirect.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *Route_DirectResponse) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DirectResponse != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.DirectResponse.Size()))
		n14, err := m.DirectResponse.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *WeightedCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WeightedCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for _, msg := range m.Clusters {
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RuntimeKeyPrefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.RuntimeKeyPrefix)))
		i += copy(dAtA[i:], m.RuntimeKeyPrefix)
	}
	if m.TotalWeight != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.TotalWeight.Size()))
		n15, err := m.TotalWeight.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *WeightedCluster_ClusterWeight) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WeightedCluster_ClusterWeight) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Weight != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Weight.Size()))
		n16, err := m.Weight.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.MetadataMatch != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.MetadataMatch.Size()))
		n17, err := m.MetadataMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, msg := range m.RequestHeadersToAdd {
			dAtA[i] = 0x22
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, msg := range m.ResponseHeadersToAdd {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.PerFilterConfig) > 0 {
		keysForPerFilterConfig := make([]string, 0, len(m.PerFilterConfig))
		for k, _ := range m.PerFilterConfig {
			keysForPerFilterConfig = append(keysForPerFilterConfig, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForPerFilterConfig)
		for _, k := range keysForPerFilterConfig {
			dAtA[i] = 0x42
			i++
			v := m.PerFilterConfig[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRoute(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRoute(uint64(len(k))) + msgSize
			i = encodeVarintRoute(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRoute(dAtA, i, uint64(v.Size()))
				n18, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n18
			}
		}
	}
	if len(m.RequestHeadersToRemove) > 0 {
		for _, s := range m.RequestHeadersToRemove {
			dAtA[i] = 0x4a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.TypedPerFilterConfig) > 0 {
		keysForTypedPerFilterConfig := make([]string, 0, len(m.TypedPerFilterConfig))
		for k, _ := range m.TypedPerFilterConfig {
			keysForTypedPerFilterConfig = append(keysForTypedPerFilterConfig, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForTypedPerFilterConfig)
		for _, k := range keysForTypedPerFilterConfig {
			dAtA[i] = 0x52
			i++
			v := m.TypedPerFilterConfig[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRoute(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRoute(uint64(len(k))) + msgSize
			i = encodeVarintRoute(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRoute(dAtA, i, uint64(v.Size()))
				n19, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n19
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RouteMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PathSpecifier != nil {
		nn20, err := m.PathSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn20
	}
	if m.CaseSensitive != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.CaseSensitive.Size()))
		n21, err := m.CaseSensitive.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if len(m.Headers) > 0 {
		for _, msg := range m.Headers {
			dAtA[i] = 0x32
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.QueryParameters) > 0 {
		for _, msg := range m.QueryParameters {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Grpc != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Grpc.Size()))
		n22, err := m.Grpc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.RuntimeFraction != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RuntimeFraction.Size()))
		n23, err := m.RuntimeFraction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RouteMatch_Prefix) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.Prefix)))
	i += copy(dAtA[i:], m.Prefix)
	return i, nil
}
func (m *RouteMatch_Path) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	return i, nil
}
func (m *RouteMatch_Regex) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.Regex)))
	i += copy(dAtA[i:], m.Regex)
	return i, nil
}
func (m *RouteMatch_GrpcRouteMatchOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteMatch_GrpcRouteMatchOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CorsPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CorsPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AllowOrigin) > 0 {
		for _, s := range m.AllowOrigin {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.AllowMethods) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.AllowMethods)))
		i += copy(dAtA[i:], m.AllowMethods)
	}
	if len(m.AllowHeaders) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.AllowHeaders)))
		i += copy(dAtA[i:], m.AllowHeaders)
	}
	if len(m.ExposeHeaders) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.ExposeHeaders)))
		i += copy(dAtA[i:], m.ExposeHeaders)
	}
	if len(m.MaxAge) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.MaxAge)))
		i += copy(dAtA[i:], m.MaxAge)
	}
	if m.AllowCredentials != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.AllowCredentials.Size()))
		n24, err := m.AllowCredentials.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.EnabledSpecifier != nil {
		nn25, err := m.EnabledSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn25
	}
	if len(m.AllowOriginRegex) > 0 {
		for _, s := range m.AllowOriginRegex {
			dAtA[i] = 0x42
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.ShadowEnabled != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.ShadowEnabled.Size()))
		n26, err := m.ShadowEnabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CorsPolicy_Enabled) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Enabled != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Enabled.Size()))
		n27, err := m.Enabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	return i, nil
}
func (m *CorsPolicy_FilterEnabled) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.FilterEnabled != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.FilterEnabled.Size()))
		n28, err := m.FilterEnabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	return i, nil
}
func (m *RouteAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ClusterSpecifier != nil {
		nn29, err := m.ClusterSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn29
	}
	if m.MetadataMatch != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.MetadataMatch.Size()))
		n30, err := m.MetadataMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if len(m.PrefixRewrite) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.PrefixRewrite)))
		i += copy(dAtA[i:], m.PrefixRewrite)
	}
	if m.HostRewriteSpecifier != nil {
		nn31, err := m.HostRewriteSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn31
	}
	if m.Timeout != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Timeout)))
		n32, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Timeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.RetryPolicy != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RetryPolicy.Size()))
		n33, err := m.RetryPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.RequestMirrorPolicy != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RequestMirrorPolicy.Size()))
		n34, err := m.RequestMirrorPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.Priority != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Priority))
	}
	if len(m.RateLimits) > 0 {
		for _, msg := range m.RateLimits {
			dAtA[i] = 0x6a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.IncludeVhRateLimits != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.IncludeVhRateLimits.Size()))
		n35, err := m.IncludeVhRateLimits.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if len(m.HashPolicy) > 0 {
		for _, msg := range m.HashPolicy {
			dAtA[i] = 0x7a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Cors != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Cors.Size()))
		n36, err := m.Cors.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if m.ClusterNotFoundResponseCode != 0 {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.ClusterNotFoundResponseCode))
	}
	if m.MaxGrpcTimeout != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.MaxGrpcTimeout)))
		n37, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.MaxGrpcTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	if m.IdleTimeout != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.IdleTimeout)))
		n38, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.IdleTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	if len(m.UpgradeConfigs) > 0 {
		for _, msg := range m.UpgradeConfigs {
			dAtA[i] = 0xca
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.InternalRedirectAction != 0 {
		dAtA[i] = 0xd0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.InternalRedirectAction))
	}
	if m.HedgePolicy != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.HedgePolicy.Size()))
		n39, err := m.HedgePolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	if m.GrpcTimeoutOffset != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.GrpcTimeoutOffset)))
		n40, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.GrpcTimeoutOffset, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RouteAction_Cluster) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.Cluster)))
	i += copy(dAtA[i:], m.Cluster)
	return i, nil
}
func (m *RouteAction_ClusterHeader) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.ClusterHeader)))
	i += copy(dAtA[i:], m.ClusterHeader)
	return i, nil
}
func (m *RouteAction_WeightedClusters) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.WeightedClusters != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.WeightedClusters.Size()))
		n41, err := m.WeightedClusters.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	return i, nil
}
func (m *RouteAction_HostRewrite) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x32
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.HostRewrite)))
	i += copy(dAtA[i:], m.HostRewrite)
	return i, nil
}
func (m *RouteAction_AutoHostRewrite) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AutoHostRewrite != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.AutoHostRewrite.Size()))
		n42, err := m.AutoHostRewrite.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	return i, nil
}
func (m *RouteAction_RequestMirrorPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_RequestMirrorPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Cluster) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Cluster)))
		i += copy(dAtA[i:], m.Cluster)
	}
	if len(m.RuntimeKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.RuntimeKey)))
		i += copy(dAtA[i:], m.RuntimeKey)
	}
	if m.RuntimeFraction != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RuntimeFraction.Size()))
		n43, err := m.RuntimeFraction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RouteAction_HashPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_HashPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PolicySpecifier != nil {
		nn44, err := m.PolicySpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn44
	}
	if m.Terminal {
		dAtA[i] = 0x20
		i++
		if m.Terminal {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RouteAction_HashPolicy_Header_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Header != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Header.Size()))
		n45, err := m.Header.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	return i, nil
}
func (m *RouteAction_HashPolicy_Cookie_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Cookie != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Cookie.Size()))
		n46, err := m.Cookie.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	return i, nil
}
func (m *RouteAction_HashPolicy_ConnectionProperties_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ConnectionProperties != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.ConnectionProperties.Size()))
		n47, err := m.ConnectionProperties.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	return i, nil
}
func (m *RouteAction_HashPolicy_Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_HashPolicy_Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HeaderName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.HeaderName)))
		i += copy(dAtA[i:], m.HeaderName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RouteAction_HashPolicy_Cookie) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_HashPolicy_Cookie) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Ttl != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Ttl)))
		n48, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Ttl, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n48
	}
	if len(m.Path) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RouteAction_HashPolicy_ConnectionProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_HashPolicy_ConnectionProperties) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SourceIp {
		dAtA[i] = 0x8
		i++
		if m.SourceIp {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RouteAction_UpgradeConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_UpgradeConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UpgradeType) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.UpgradeType)))
		i += copy(dAtA[i:], m.UpgradeType)
	}
	if m.Enabled != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Enabled.Size()))
		n49, err := m.Enabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n49
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RetryPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RetryPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RetryOn) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.RetryOn)))
		i += copy(dAtA[i:], m.RetryOn)
	}
	if m.NumRetries != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.NumRetries.Size()))
		n50, err := m.NumRetries.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n50
	}
	if m.PerTryTimeout != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.PerTryTimeout)))
		n51, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.PerTryTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	if m.RetryPriority != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RetryPriority.Size()))
		n52, err := m.RetryPriority.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n52
	}
	if len(m.RetryHostPredicate) > 0 {
		for _, msg := range m.RetryHostPredicate {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.HostSelectionRetryMaxAttempts != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.HostSelectionRetryMaxAttempts))
	}
	if len(m.RetriableStatusCodes) > 0 {
		dAtA54 := make([]byte, len(m.RetriableStatusCodes)*10)
		var j53 int
		for _, num := range m.RetriableStatusCodes {
			for num >= 1<<7 {
				dAtA54[j53] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j53++
			}
			dAtA54[j53] = uint8(num)
			j53++
		}
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(j53))
		i += copy(dAtA[i:], dAtA54[:j53])
	}
	if m.RetryBackOff != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RetryBackOff.Size()))
		n55, err := m.RetryBackOff.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n55
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RetryPolicy_RetryPriority) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RetryPolicy_RetryPriority) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.ConfigType != nil {
		nn56, err := m.ConfigType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn56
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RetryPolicy_RetryPriority_Config) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Config.Size()))
		n57, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n57
	}
	return i, nil
}
func (m *RetryPolicy_RetryPriority_TypedConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TypedConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.TypedConfig.Size()))
		n58, err := m.TypedConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n58
	}
	return i, nil
}
func (m *RetryPolicy_RetryHostPredicate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RetryPolicy_RetryHostPredicate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.ConfigType != nil {
		nn59, err := m.ConfigType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn59
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RetryPolicy_RetryHostPredicate_Config) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Config.Size()))
		n60, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n60
	}
	return i, nil
}
func (m *RetryPolicy_RetryHostPredicate_TypedConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TypedConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.TypedConfig.Size()))
		n61, err := m.TypedConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n61
	}
	return i, nil
}
func (m *RetryPolicy_RetryBackOff) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RetryPolicy_RetryBackOff) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.BaseInterval != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.BaseInterval)))
		n62, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.BaseInterval, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n62
	}
	if m.MaxInterval != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.MaxInterval)))
		n63, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.MaxInterval, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n63
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HedgePolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HedgePolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.InitialRequests != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.InitialRequests.Size()))
		n64, err := m.InitialRequests.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n64
	}
	if m.AdditionalRequestChance != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.AdditionalRequestChance.Size()))
		n65, err := m.AdditionalRequestChance.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n65
	}
	if m.HedgeOnPerTryTimeout {
		dAtA[i] = 0x18
		i++
		if m.HedgeOnPerTryTimeout {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RedirectAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedirectAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HostRedirect) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.HostRedirect)))
		i += copy(dAtA[i:], m.HostRedirect)
	}
	if m.PathRewriteSpecifier != nil {
		nn66, err := m.PathRewriteSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn66
	}
	if m.ResponseCode != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.ResponseCode))
	}
	if m.SchemeRewriteSpecifier != nil {
		nn67, err := m.SchemeRewriteSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn67
	}
	if m.StripQuery {
		dAtA[i] = 0x30
		i++
		if m.StripQuery {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.PortRedirect != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.PortRedirect))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RedirectAction_PathRedirect) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.PathRedirect)))
	i += copy(dAtA[i:], m.PathRedirect)
	return i, nil
}
func (m *RedirectAction_HttpsRedirect) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x20
	i++
	if m.HttpsRedirect {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *RedirectAction_PrefixRewrite) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x2a
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.PrefixRewrite)))
	i += copy(dAtA[i:], m.PrefixRewrite)
	return i, nil
}
func (m *RedirectAction_SchemeRedirect) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x3a
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.SchemeRedirect)))
	i += copy(dAtA[i:], m.SchemeRedirect)
	return i, nil
}
func (m *DirectResponseAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DirectResponseAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Status))
	}
	if m.Body != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Body.Size()))
		n68, err := m.Body.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n68
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Decorator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Decorator) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Operation) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Operation)))
		i += copy(dAtA[i:], m.Operation)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VirtualCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Pattern) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Pattern)))
		i += copy(dAtA[i:], m.Pattern)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Method != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Method))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Stage != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Stage.Size()))
		n69, err := m.Stage.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n69
	}
	if len(m.DisableKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.DisableKey)))
		i += copy(dAtA[i:], m.DisableKey)
	}
	if len(m.Actions) > 0 {
		for _, msg := range m.Actions {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit_Action) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ActionSpecifier != nil {
		nn70, err := m.ActionSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn70
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit_Action_SourceCluster_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SourceCluster != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.SourceCluster.Size()))
		n71, err := m.SourceCluster.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n71
	}
	return i, nil
}
func (m *RateLimit_Action_DestinationCluster_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DestinationCluster != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.DestinationCluster.Size()))
		n72, err := m.DestinationCluster.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n72
	}
	return i, nil
}
func (m *RateLimit_Action_RequestHeaders_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RequestHeaders != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RequestHeaders.Size()))
		n73, err := m.RequestHeaders.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n73
	}
	return i, nil
}
func (m *RateLimit_Action_RemoteAddress_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RemoteAddress != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RemoteAddress.Size()))
		n74, err := m.RemoteAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n74
	}
	return i, nil
}
func (m *RateLimit_Action_GenericKey_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.GenericKey != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.GenericKey.Size()))
		n75, err := m.GenericKey.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n75
	}
	return i, nil
}
func (m *RateLimit_Action_HeaderValueMatch_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HeaderValueMatch != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.HeaderValueMatch.Size()))
		n76, err := m.HeaderValueMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n76
	}
	return i, nil
}
func (m *RateLimit_Action_SourceCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_SourceCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit_Action_DestinationCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_DestinationCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit_Action_RequestHeaders) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_RequestHeaders) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HeaderName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.HeaderName)))
		i += copy(dAtA[i:], m.HeaderName)
	}
	if len(m.DescriptorKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.DescriptorKey)))
		i += copy(dAtA[i:], m.DescriptorKey)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit_Action_RemoteAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_RemoteAddress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit_Action_GenericKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_GenericKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DescriptorValue) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.DescriptorValue)))
		i += copy(dAtA[i:], m.DescriptorValue)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit_Action_HeaderValueMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_HeaderValueMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DescriptorValue) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.DescriptorValue)))
		i += copy(dAtA[i:], m.DescriptorValue)
	}
	if m.ExpectMatch != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.ExpectMatch.Size()))
		n77, err := m.ExpectMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n77
	}
	if len(m.Headers) > 0 {
		for _, msg := range m.Headers {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HeaderMatcher) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderMatcher) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.HeaderMatchSpecifier != nil {
		nn78, err := m.HeaderMatchSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn78
	}
	if m.InvertMatch {
		dAtA[i] = 0x40
		i++
		if m.InvertMatch {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HeaderMatcher_ExactMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x22
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.ExactMatch)))
	i += copy(dAtA[i:], m.ExactMatch)
	return i, nil
}
func (m *HeaderMatcher_RegexMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x2a
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.RegexMatch)))
	i += copy(dAtA[i:], m.RegexMatch)
	return i, nil
}
func (m *HeaderMatcher_RangeMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangeMatch != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RangeMatch.Size()))
		n79, err := m.RangeMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n79
	}
	return i, nil
}
func (m *HeaderMatcher_PresentMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x38
	i++
	if m.PresentMatch {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *HeaderMatcher_PrefixMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x4a
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.PrefixMatch)))
	i += copy(dAtA[i:], m.PrefixMatch)
	return i, nil
}
func (m *HeaderMatcher_SuffixMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x52
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.SuffixMatch)))
	i += copy(dAtA[i:], m.SuffixMatch)
	return i, nil
}
func (m *QueryParameterMatcher) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryParameterMatcher) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if m.Regex != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Regex.Size()))
		n80, err := m.Regex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n80
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintRoute(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *VirtualHost) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.Domains) > 0 {
		for _, s := range m.Domains {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.RequireTls != 0 {
		n += 1 + sovRoute(uint64(m.RequireTls))
	}
	if len(m.VirtualClusters) > 0 {
		for _, e := range m.VirtualClusters {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.RateLimits) > 0 {
		for _, e := range m.RateLimits {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, e := range m.RequestHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.Cors != nil {
		l = m.Cors.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, e := range m.ResponseHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.PerFilterConfig) > 0 {
		for k, v := range m.PerFilterConfig {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRoute(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRoute(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRoute(uint64(mapEntrySize))
		}
	}
	if len(m.RequestHeadersToRemove) > 0 {
		for _, s := range m.RequestHeadersToRemove {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.IncludeRequestAttemptCount {
		n += 2
	}
	if len(m.TypedPerFilterConfig) > 0 {
		for k, v := range m.TypedPerFilterConfig {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRoute(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRoute(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRoute(uint64(mapEntrySize))
		}
	}
	if m.RetryPolicy != nil {
		l = m.RetryPolicy.Size()
		n += 2 + l + sovRoute(uint64(l))
	}
	if m.HedgePolicy != nil {
		l = m.HedgePolicy.Size()
		n += 2 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Route) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Match.Size()
	n += 1 + l + sovRoute(uint64(l))
	if m.Action != nil {
		n += m.Action.Size()
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Decorator != nil {
		l = m.Decorator.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.PerFilterConfig) > 0 {
		for k, v := range m.PerFilterConfig {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRoute(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRoute(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRoute(uint64(mapEntrySize))
		}
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, e := range m.RequestHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, e := range m.ResponseHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.RequestHeadersToRemove) > 0 {
		for _, s := range m.RequestHeadersToRemove {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.TypedPerFilterConfig) > 0 {
		for k, v := range m.TypedPerFilterConfig {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRoute(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRoute(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRoute(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Route_Route) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Route != nil {
		l = m.Route.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *Route_Redirect) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Redirect != nil {
		l = m.Redirect.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *Route_DirectResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DirectResponse != nil {
		l = m.DirectResponse.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *WeightedCluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for _, e := range m.Clusters {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	l = len(m.RuntimeKeyPrefix)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.TotalWeight != nil {
		l = m.TotalWeight.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WeightedCluster_ClusterWeight) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Weight != nil {
		l = m.Weight.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.MetadataMatch != nil {
		l = m.MetadataMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, e := range m.RequestHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, e := range m.ResponseHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.PerFilterConfig) > 0 {
		for k, v := range m.PerFilterConfig {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRoute(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRoute(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRoute(uint64(mapEntrySize))
		}
	}
	if len(m.RequestHeadersToRemove) > 0 {
		for _, s := range m.RequestHeadersToRemove {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.TypedPerFilterConfig) > 0 {
		for k, v := range m.TypedPerFilterConfig {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRoute(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRoute(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRoute(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RouteMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PathSpecifier != nil {
		n += m.PathSpecifier.Size()
	}
	if m.CaseSensitive != nil {
		l = m.CaseSensitive.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.QueryParameters) > 0 {
		for _, e := range m.QueryParameters {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.Grpc != nil {
		l = m.Grpc.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.RuntimeFraction != nil {
		l = m.RuntimeFraction.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RouteMatch_Prefix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Prefix)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteMatch_Path) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteMatch_Regex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Regex)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteMatch_GrpcRouteMatchOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CorsPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.AllowOrigin) > 0 {
		for _, s := range m.AllowOrigin {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	l = len(m.AllowMethods)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.AllowHeaders)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.ExposeHeaders)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.MaxAge)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.AllowCredentials != nil {
		l = m.AllowCredentials.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.EnabledSpecifier != nil {
		n += m.EnabledSpecifier.Size()
	}
	if len(m.AllowOriginRegex) > 0 {
		for _, s := range m.AllowOriginRegex {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.ShadowEnabled != nil {
		l = m.ShadowEnabled.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CorsPolicy_Enabled) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Enabled != nil {
		l = m.Enabled.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *CorsPolicy_FilterEnabled) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FilterEnabled != nil {
		l = m.FilterEnabled.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterSpecifier != nil {
		n += m.ClusterSpecifier.Size()
	}
	if m.MetadataMatch != nil {
		l = m.MetadataMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.PrefixRewrite)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.HostRewriteSpecifier != nil {
		n += m.HostRewriteSpecifier.Size()
	}
	if m.Timeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Timeout)
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.RetryPolicy != nil {
		l = m.RetryPolicy.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.RequestMirrorPolicy != nil {
		l = m.RequestMirrorPolicy.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Priority != 0 {
		n += 1 + sovRoute(uint64(m.Priority))
	}
	if len(m.RateLimits) > 0 {
		for _, e := range m.RateLimits {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.IncludeVhRateLimits != nil {
		l = m.IncludeVhRateLimits.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.HashPolicy) > 0 {
		for _, e := range m.HashPolicy {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.Cors != nil {
		l = m.Cors.Size()
		n += 2 + l + sovRoute(uint64(l))
	}
	if m.ClusterNotFoundResponseCode != 0 {
		n += 2 + sovRoute(uint64(m.ClusterNotFoundResponseCode))
	}
	if m.MaxGrpcTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.MaxGrpcTimeout)
		n += 2 + l + sovRoute(uint64(l))
	}
	if m.IdleTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.IdleTimeout)
		n += 2 + l + sovRoute(uint64(l))
	}
	if len(m.UpgradeConfigs) > 0 {
		for _, e := range m.UpgradeConfigs {
			l = e.Size()
			n += 2 + l + sovRoute(uint64(l))
		}
	}
	if m.InternalRedirectAction != 0 {
		n += 2 + sovRoute(uint64(m.InternalRedirectAction))
	}
	if m.HedgePolicy != nil {
		l = m.HedgePolicy.Size()
		n += 2 + l + sovRoute(uint64(l))
	}
	if m.GrpcTimeoutOffset != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.GrpcTimeoutOffset)
		n += 2 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RouteAction_Cluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cluster)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteAction_ClusterHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterHeader)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteAction_WeightedClusters) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WeightedClusters != nil {
		l = m.WeightedClusters.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_HostRewrite) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostRewrite)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteAction_AutoHostRewrite) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AutoHostRewrite != nil {
		l = m.AutoHostRewrite.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_RequestMirrorPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.RuntimeKey)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.RuntimeFraction != nil {
		l = m.RuntimeFraction.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RouteAction_HashPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PolicySpecifier != nil {
		n += m.PolicySpecifier.Size()
	}
	if m.Terminal {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RouteAction_HashPolicy_Header_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_HashPolicy_Cookie_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cookie != nil {
		l = m.Cookie.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_HashPolicy_ConnectionProperties_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConnectionProperties != nil {
		l = m.ConnectionProperties.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_HashPolicy_Header) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HeaderName)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RouteAction_HashPolicy_Cookie) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Ttl != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Ttl)
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RouteAction_HashPolicy_ConnectionProperties) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SourceIp {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RouteAction_UpgradeConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UpgradeType)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Enabled != nil {
		l = m.Enabled.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RetryPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RetryOn)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.NumRetries != nil {
		l = m.NumRetries.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.PerTryTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.PerTryTimeout)
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.RetryPriority != nil {
		l = m.RetryPriority.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.RetryHostPredicate) > 0 {
		for _, e := range m.RetryHostPredicate {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.HostSelectionRetryMaxAttempts != 0 {
		n += 1 + sovRoute(uint64(m.HostSelectionRetryMaxAttempts))
	}
	if len(m.RetriableStatusCodes) > 0 {
		l = 0
		for _, e := range m.RetriableStatusCodes {
			l += sovRoute(uint64(e))
		}
		n += 1 + sovRoute(uint64(l)) + l
	}
	if m.RetryBackOff != nil {
		l = m.RetryBackOff.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RetryPolicy_RetryPriority) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.ConfigType != nil {
		n += m.ConfigType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RetryPolicy_RetryPriority_Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RetryPolicy_RetryPriority_TypedConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TypedConfig != nil {
		l = m.TypedConfig.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RetryPolicy_RetryHostPredicate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.ConfigType != nil {
		n += m.ConfigType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RetryPolicy_RetryHostPredicate_Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RetryPolicy_RetryHostPredicate_TypedConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TypedConfig != nil {
		l = m.TypedConfig.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RetryPolicy_RetryBackOff) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BaseInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.BaseInterval)
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.MaxInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.MaxInterval)
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HedgePolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.InitialRequests != nil {
		l = m.InitialRequests.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.AdditionalRequestChance != nil {
		l = m.AdditionalRequestChance.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.HedgeOnPerTryTimeout {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RedirectAction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostRedirect)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.PathRewriteSpecifier != nil {
		n += m.PathRewriteSpecifier.Size()
	}
	if m.ResponseCode != 0 {
		n += 1 + sovRoute(uint64(m.ResponseCode))
	}
	if m.SchemeRewriteSpecifier != nil {
		n += m.SchemeRewriteSpecifier.Size()
	}
	if m.StripQuery {
		n += 2
	}
	if m.PortRedirect != 0 {
		n += 1 + sovRoute(uint64(m.PortRedirect))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RedirectAction_PathRedirect) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PathRedirect)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RedirectAction_HttpsRedirect) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *RedirectAction_PrefixRewrite) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PrefixRewrite)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RedirectAction_SchemeRedirect) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SchemeRedirect)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *DirectResponseAction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovRoute(uint64(m.Status))
	}
	if m.Body != nil {
		l = m.Body.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Decorator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Operation)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VirtualCluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Pattern)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Method != 0 {
		n += 1 + sovRoute(uint64(m.Method))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stage != nil {
		l = m.Stage.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.DisableKey)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.Actions) > 0 {
		for _, e := range m.Actions {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit_Action) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ActionSpecifier != nil {
		n += m.ActionSpecifier.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit_Action_SourceCluster_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SourceCluster != nil {
		l = m.SourceCluster.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_DestinationCluster_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DestinationCluster != nil {
		l = m.DestinationCluster.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_RequestHeaders_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestHeaders != nil {
		l = m.RequestHeaders.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_RemoteAddress_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RemoteAddress != nil {
		l = m.RemoteAddress.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_GenericKey_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.GenericKey != nil {
		l = m.GenericKey.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_HeaderValueMatch_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HeaderValueMatch != nil {
		l = m.HeaderValueMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_SourceCluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit_Action_DestinationCluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit_Action_RequestHeaders) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HeaderName)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.DescriptorKey)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit_Action_RemoteAddress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit_Action_GenericKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DescriptorValue)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit_Action_HeaderValueMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DescriptorValue)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.ExpectMatch != nil {
		l = m.ExpectMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HeaderMatcher) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.HeaderMatchSpecifier != nil {
		n += m.HeaderMatchSpecifier.Size()
	}
	if m.InvertMatch {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HeaderMatcher_ExactMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ExactMatch)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *HeaderMatcher_RegexMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RegexMatch)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *HeaderMatcher_RangeMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RangeMatch != nil {
		l = m.RangeMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *HeaderMatcher_PresentMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *HeaderMatcher_PrefixMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PrefixMatch)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *HeaderMatcher_SuffixMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SuffixMatch)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *QueryParameterMatcher) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Regex != nil {
		l = m.Regex.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovRoute(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRoute(x uint64) (n int) {
	return sovRoute(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *VirtualHost) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualHost: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualHost: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Domains", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Domains = append(m.Domains, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Routes = append(m.Routes, Route{})
			if err := m.Routes[len(m.Routes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireTls", wireType)
			}
			m.RequireTls = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequireTls |= VirtualHost_TlsRequirementType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VirtualClusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VirtualClusters = append(m.VirtualClusters, &VirtualCluster{})
			if err := m.VirtualClusters[len(m.VirtualClusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RateLimits = append(m.RateLimits, &RateLimit{})
			if err := m.RateLimits[len(m.RateLimits)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToAdd = append(m.RequestHeadersToAdd, &core.HeaderValueOption{})
			if err := m.RequestHeadersToAdd[len(m.RequestHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cors == nil {
				m.Cors = &CorsPolicy{}
			}
			if err := m.Cors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToAdd = append(m.ResponseHeadersToAdd, &core.HeaderValueOption{})
			if err := m.ResponseHeadersToAdd[len(m.ResponseHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToRemove = append(m.ResponseHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerFilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerFilterConfig == nil {
				m.PerFilterConfig = make(map[string]*types.Struct)
			}
			var mapkey string
			var mapvalue *types.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRoute
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoute(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRoute
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.PerFilterConfig[mapkey] = mapvalue
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToRemove = append(m.RequestHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeRequestAttemptCount", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeRequestAttemptCount = bool(v != 0)
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedPerFilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TypedPerFilterConfig == nil {
				m.TypedPerFilterConfig = make(map[string]*types.Any)
			}
			var mapkey string
			var mapvalue *types.Any
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRoute
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Any{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoute(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRoute
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TypedPerFilterConfig[mapkey] = mapvalue
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryPolicy == nil {
				m.RetryPolicy = &RetryPolicy{}
			}
			if err := m.RetryPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HedgePolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HedgePolicy == nil {
				m.HedgePolicy = &HedgePolicy{}
			}
			if err := m.HedgePolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Route) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Route: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Route: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Match.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Route", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RouteAction{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Action = &Route_Route{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Redirect", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RedirectAction{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Action = &Route_Redirect{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &core.Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Decorator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Decorator == nil {
				m.Decorator = &Decorator{}
			}
			if err := m.Decorator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DirectResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DirectResponseAction{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Action = &Route_DirectResponse{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerFilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerFilterConfig == nil {
				m.PerFilterConfig = make(map[string]*types.Struct)
			}
			var mapkey string
			var mapvalue *types.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRoute
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoute(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRoute
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.PerFilterConfig[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToAdd = append(m.RequestHeadersToAdd, &core.HeaderValueOption{})
			if err := m.RequestHeadersToAdd[len(m.RequestHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToAdd = append(m.ResponseHeadersToAdd, &core.HeaderValueOption{})
			if err := m.ResponseHeadersToAdd[len(m.ResponseHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToRemove = append(m.ResponseHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToRemove = append(m.RequestHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedPerFilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TypedPerFilterConfig == nil {
				m.TypedPerFilterConfig = make(map[string]*types.Any)
			}
			var mapkey string
			var mapvalue *types.Any
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRoute
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Any{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoute(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRoute
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TypedPerFilterConfig[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WeightedCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WeightedCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WeightedCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clusters = append(m.Clusters, &WeightedCluster_ClusterWeight{})
			if err := m.Clusters[len(m.Clusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeKeyPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeKeyPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalWeight", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TotalWeight == nil {
				m.TotalWeight = &types.UInt32Value{}
			}
			if err := m.TotalWeight.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WeightedCluster_ClusterWeight) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterWeight: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterWeight: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Weight == nil {
				m.Weight = &types.UInt32Value{}
			}
			if err := m.Weight.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetadataMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetadataMatch == nil {
				m.MetadataMatch = &core.Metadata{}
			}
			if err := m.MetadataMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToAdd = append(m.RequestHeadersToAdd, &core.HeaderValueOption{})
			if err := m.RequestHeadersToAdd[len(m.RequestHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToAdd = append(m.ResponseHeadersToAdd, &core.HeaderValueOption{})
			if err := m.ResponseHeadersToAdd[len(m.ResponseHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToRemove = append(m.ResponseHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerFilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerFilterConfig == nil {
				m.PerFilterConfig = make(map[string]*types.Struct)
			}
			var mapkey string
			var mapvalue *types.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRoute
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoute(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRoute
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.PerFilterConfig[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToRemove = append(m.RequestHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedPerFilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TypedPerFilterConfig == nil {
				m.TypedPerFilterConfig = make(map[string]*types.Any)
			}
			var mapkey string
			var mapvalue *types.Any
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthRoute
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Any{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoute(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRoute
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TypedPerFilterConfig[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathSpecifier = &RouteMatch_Prefix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathSpecifier = &RouteMatch_Path{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathSpecifier = &RouteMatch_Regex{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaseSensitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CaseSensitive == nil {
				m.CaseSensitive = &types.BoolValue{}
			}
			if err := m.CaseSensitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &HeaderMatcher{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryParameters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QueryParameters = append(m.QueryParameters, &QueryParameterMatcher{})
			if err := m.QueryParameters[len(m.QueryParameters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Grpc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Grpc == nil {
				m.Grpc = &RouteMatch_GrpcRouteMatchOptions{}
			}
			if err := m.Grpc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeFraction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RuntimeFraction == nil {
				m.RuntimeFraction = &core.RuntimeFractionalPercent{}
			}
			if err := m.RuntimeFraction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteMatch_GrpcRouteMatchOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GrpcRouteMatchOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GrpcRouteMatchOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CorsPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CorsPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CorsPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowOrigin", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowOrigin = append(m.AllowOrigin, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowMethods", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowMethods = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowHeaders = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExposeHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExposeHeaders = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAge", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MaxAge = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowCredentials", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AllowCredentials == nil {
				m.AllowCredentials = &types.BoolValue{}
			}
			if err := m.AllowCredentials.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.BoolValue{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.EnabledSpecifier = &CorsPolicy_Enabled{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowOriginRegex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowOriginRegex = append(m.AllowOriginRegex, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterEnabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &core.RuntimeFractionalPercent{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.EnabledSpecifier = &CorsPolicy_FilterEnabled{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShadowEnabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ShadowEnabled == nil {
				m.ShadowEnabled = &core.RuntimeFractionalPercent{}
			}
			if err := m.ShadowEnabled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterSpecifier = &RouteAction_Cluster{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterHeader", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterSpecifier = &RouteAction_ClusterHeader{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WeightedClusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WeightedCluster{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ClusterSpecifier = &RouteAction_WeightedClusters{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetadataMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetadataMatch == nil {
				m.MetadataMatch = &core.Metadata{}
			}
			if err := m.MetadataMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixRewrite", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrefixRewrite = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostRewrite", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostRewriteSpecifier = &RouteAction_HostRewrite{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AutoHostRewrite", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.BoolValue{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HostRewriteSpecifier = &RouteAction_AutoHostRewrite{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Timeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryPolicy == nil {
				m.RetryPolicy = &RetryPolicy{}
			}
			if err := m.RetryPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestMirrorPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestMirrorPolicy == nil {
				m.RequestMirrorPolicy = &RouteAction_RequestMirrorPolicy{}
			}
			if err := m.RequestMirrorPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= core.RoutingPriority(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RateLimits = append(m.RateLimits, &RateLimit{})
			if err := m.RateLimits[len(m.RateLimits)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeVhRateLimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IncludeVhRateLimits == nil {
				m.IncludeVhRateLimits = &types.BoolValue{}
			}
			if err := m.IncludeVhRateLimits.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HashPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HashPolicy = append(m.HashPolicy, &RouteAction_HashPolicy{})
			if err := m.HashPolicy[len(m.HashPolicy)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cors == nil {
				m.Cors = &CorsPolicy{}
			}
			if err := m.Cors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterNotFoundResponseCode", wireType)
			}
			m.ClusterNotFoundResponseCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterNotFoundResponseCode |= RouteAction_ClusterNotFoundResponseCode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxGrpcTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxGrpcTimeout == nil {
				m.MaxGrpcTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.MaxGrpcTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IdleTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IdleTimeout == nil {
				m.IdleTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.IdleTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpgradeConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpgradeConfigs = append(m.UpgradeConfigs, &RouteAction_UpgradeConfig{})
			if err := m.UpgradeConfigs[len(m.UpgradeConfigs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InternalRedirectAction", wireType)
			}
			m.InternalRedirectAction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InternalRedirectAction |= RouteAction_InternalRedirectAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HedgePolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HedgePolicy == nil {
				m.HedgePolicy = &HedgePolicy{}
			}
			if err := m.HedgePolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrpcTimeoutOffset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GrpcTimeoutOffset == nil {
				m.GrpcTimeoutOffset = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.GrpcTimeoutOffset, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_RequestMirrorPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestMirrorPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestMirrorPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeFraction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RuntimeFraction == nil {
				m.RuntimeFraction = &core.RuntimeFractionalPercent{}
			}
			if err := m.RuntimeFraction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_HashPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HashPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HashPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RouteAction_HashPolicy_Header{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.PolicySpecifier = &RouteAction_HashPolicy_Header_{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cookie", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RouteAction_HashPolicy_Cookie{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.PolicySpecifier = &RouteAction_HashPolicy_Cookie_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectionProperties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RouteAction_HashPolicy_ConnectionProperties{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.PolicySpecifier = &RouteAction_HashPolicy_ConnectionProperties_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Terminal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Terminal = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_HashPolicy_Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeaderName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_HashPolicy_Cookie) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Cookie: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Cookie: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ttl == nil {
				m.Ttl = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Ttl, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_HashPolicy_ConnectionProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectionProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectionProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIp", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SourceIp = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_UpgradeConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpgradeConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpgradeConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpgradeType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpgradeType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Enabled == nil {
				m.Enabled = &types.BoolValue{}
			}
			if err := m.Enabled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RetryPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RetryPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RetryPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryOn", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryOn = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumRetries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NumRetries == nil {
				m.NumRetries = &types.UInt32Value{}
			}
			if err := m.NumRetries.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerTryTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerTryTimeout == nil {
				m.PerTryTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.PerTryTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryPriority", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryPriority == nil {
				m.RetryPriority = &RetryPolicy_RetryPriority{}
			}
			if err := m.RetryPriority.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryHostPredicate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryHostPredicate = append(m.RetryHostPredicate, &RetryPolicy_RetryHostPredicate{})
			if err := m.RetryHostPredicate[len(m.RetryHostPredicate)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostSelectionRetryMaxAttempts", wireType)
			}
			m.HostSelectionRetryMaxAttempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HostSelectionRetryMaxAttempts |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RetriableStatusCodes = append(m.RetriableStatusCodes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRoute
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthRoute
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.RetriableStatusCodes) == 0 {
					m.RetriableStatusCodes = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RetriableStatusCodes = append(m.RetriableStatusCodes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RetriableStatusCodes", wireType)
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryBackOff", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryBackOff == nil {
				m.RetryBackOff = &RetryPolicy_RetryBackOff{}
			}
			if err := m.RetryBackOff.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RetryPolicy_RetryPriority) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RetryPriority: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RetryPriority: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Struct{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &RetryPolicy_RetryPriority_Config{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &RetryPolicy_RetryPriority_TypedConfig{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RetryPolicy_RetryHostPredicate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RetryHostPredicate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RetryHostPredicate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Struct{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &RetryPolicy_RetryHostPredicate_Config{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &RetryPolicy_RetryHostPredicate_TypedConfig{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RetryPolicy_RetryBackOff) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RetryBackOff: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RetryBackOff: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BaseInterval == nil {
				m.BaseInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.BaseInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxInterval == nil {
				m.MaxInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.MaxInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HedgePolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HedgePolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HedgePolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialRequests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InitialRequests == nil {
				m.InitialRequests = &types.UInt32Value{}
			}
			if err := m.InitialRequests.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalRequestChance", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdditionalRequestChance == nil {
				m.AdditionalRequestChance = &_type.FractionalPercent{}
			}
			if err := m.AdditionalRequestChance.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HedgeOnPerTryTimeout", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HedgeOnPerTryTimeout = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RedirectAction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RedirectAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RedirectAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostRedirect", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostRedirect = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PathRedirect", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathRewriteSpecifier = &RedirectAction_PathRedirect{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseCode", wireType)
			}
			m.ResponseCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseCode |= RedirectAction_RedirectResponseCode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpsRedirect", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.SchemeRewriteSpecifier = &RedirectAction_HttpsRedirect{b}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixRewrite", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathRewriteSpecifier = &RedirectAction_PrefixRewrite{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StripQuery", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StripQuery = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemeRedirect", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemeRewriteSpecifier = &RedirectAction_SchemeRedirect{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortRedirect", wireType)
			}
			m.PortRedirect = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PortRedirect |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DirectResponseAction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DirectResponseAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DirectResponseAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Body == nil {
				m.Body = &core.DataSource{}
			}
			if err := m.Body.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Decorator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Decorator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Decorator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Operation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VirtualCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pattern", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= core.RequestMethod(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RateLimit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RateLimit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stage == nil {
				m.Stage = &types.UInt32Value{}
			}
			if err := m.Stage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DisableKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Actions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Actions = append(m.Actions, &RateLimit_Action{})
			if err := m.Actions[len(m.Actions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Action: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Action: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_SourceCluster{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_SourceCluster_{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationCluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_DestinationCluster{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_DestinationCluster_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_RequestHeaders{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_RequestHeaders_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_RemoteAddress{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_RemoteAddress_{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GenericKey", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_GenericKey{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_GenericKey_{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeaderValueMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_HeaderValueMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_HeaderValueMatch_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_SourceCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SourceCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SourceCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_DestinationCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DestinationCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DestinationCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_RequestHeaders) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestHeaders: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestHeaders: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeaderName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DescriptorKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_RemoteAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoteAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoteAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_GenericKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GenericKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GenericKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DescriptorValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_HeaderValueMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderValueMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderValueMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DescriptorValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpectMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpectMatch == nil {
				m.ExpectMatch = &types.BoolValue{}
			}
			if err := m.ExpectMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &HeaderMatcher{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderMatcher) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderMatcher: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderMatcher: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExactMatch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderMatchSpecifier = &HeaderMatcher_ExactMatch{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegexMatch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderMatchSpecifier = &HeaderMatcher_RegexMatch{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &_type.Int64Range{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HeaderMatchSpecifier = &HeaderMatcher_RangeMatch{v}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PresentMatch", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.HeaderMatchSpecifier = &HeaderMatcher_PresentMatch{b}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InvertMatch", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InvertMatch = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixMatch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderMatchSpecifier = &HeaderMatcher_PrefixMatch{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuffixMatch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderMatchSpecifier = &HeaderMatcher_SuffixMatch{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryParameterMatcher) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryParameterMatcher: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryParameterMatcher: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoute
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Regex == nil {
				m.Regex = &types.BoolValue{}
			}
			if err := m.Regex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRoute(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRoute
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthRoute
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRoute(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthRoute
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRoute = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRoute   = fmt.Errorf("proto: integer overflow")
)
