---
layout: "docs"
page_title: "Guides"
sidebar_current: "docs-guides"
description: |-
  This section provides various guides for common actions. Due to the nature of
  Consul, some of these procedures can be complex, so our goal is to provide
  guidance to do them safely.
---

# Consul Guides

~> The Consul guides have moved to the [HashiCorp Learn platform](https://learn.hashicorp.com/consul?utm_source=consul.io&utm_medium=docs&utm_content=guide-index).

[Guides](https://learn.hashicorp.com/consul?utm_source=consul.io&utm_medium=docs&utm_content=guide-index) are step by step command-line
walkthroughs that demonstrate how to perform common operations using Consul, and
complement the feature-focused Consul documentation.

Guide content begins with getting-started tracks to help new users learn the
basics of Consul, and continues through production-playbook tracks that cover
topics like Day 1 and Day 2 operations, production considerations, and
recommendations for securing your Consul cluster.

You can work through the guides sequentially using the tracks, or just refer to
the material that is most relevant to you.

Tracks include:

- Getting Started
- Getting Started with Kubernetes
- Setup a Secure Development Environment
- Day 1: Deploying Your First Datacenter
- Day 1: Security and Network Operations
- Day 1: Kubernetes Production Deployment
- Maintenance and Monitoring Operations
- Service Discovery and Consul DNS
- Service Segmentation and Consul Connect
- Service Configuration and Consul KV
- Cloud and Load Balancer Integrations

[**Explore the Learn platform**](https://learn.hashicorp.com/consul?utm_source=consul.io&utm_medium=docs&utm_content=guide-index)
