// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/filter/accesslog/v2/accesslog.proto

package v2

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import route "github.com/envoyproxy/go-control-plane/envoy/api/v2/route"
import _type "github.com/envoyproxy/go-control-plane/envoy/type"
import types "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type ComparisonFilter_Op int32

const (
	// =
	ComparisonFilter_EQ ComparisonFilter_Op = 0
	// >=
	ComparisonFilter_GE ComparisonFilter_Op = 1
	// <=
	ComparisonFilter_LE ComparisonFilter_Op = 2
)

var ComparisonFilter_Op_name = map[int32]string{
	0: "EQ",
	1: "GE",
	2: "LE",
}
var ComparisonFilter_Op_value = map[string]int32{
	"EQ": 0,
	"GE": 1,
	"LE": 2,
}

func (x ComparisonFilter_Op) String() string {
	return proto.EnumName(ComparisonFilter_Op_name, int32(x))
}
func (ComparisonFilter_Op) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{2, 0}
}

type AccessLog struct {
	// The name of the access log implementation to instantiate. The name must
	// match a statically registered access log. Current built-in loggers include:
	//
	// #. "envoy.file_access_log"
	// #. "envoy.http_grpc_access_log"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filter which is used to determine if the access log needs to be written.
	Filter *AccessLogFilter `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Custom configuration that depends on the access log being instantiated. Built-in configurations
	// include:
	//
	// #. "envoy.file_access_log": :ref:`FileAccessLog
	//    <envoy_api_msg_config.accesslog.v2.FileAccessLog>`
	// #. "envoy.http_grpc_access_log": :ref:`HttpGrpcAccessLogConfig
	//    <envoy_api_msg_config.accesslog.v2.HttpGrpcAccessLogConfig>`
	Config               *types.Struct `protobuf:"bytes,3,opt,name=config" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AccessLog) Reset()         { *m = AccessLog{} }
func (m *AccessLog) String() string { return proto.CompactTextString(m) }
func (*AccessLog) ProtoMessage()    {}
func (*AccessLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{0}
}
func (m *AccessLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AccessLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccessLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *AccessLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessLog.Merge(dst, src)
}
func (m *AccessLog) XXX_Size() int {
	return m.Size()
}
func (m *AccessLog) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessLog.DiscardUnknown(m)
}

var xxx_messageInfo_AccessLog proto.InternalMessageInfo

func (m *AccessLog) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AccessLog) GetFilter() *AccessLogFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *AccessLog) GetConfig() *types.Struct {
	if m != nil {
		return m.Config
	}
	return nil
}

type AccessLogFilter struct {
	// Types that are valid to be assigned to FilterSpecifier:
	//	*AccessLogFilter_StatusCodeFilter
	//	*AccessLogFilter_DurationFilter
	//	*AccessLogFilter_NotHealthCheckFilter
	//	*AccessLogFilter_TraceableFilter
	//	*AccessLogFilter_RuntimeFilter
	//	*AccessLogFilter_AndFilter
	//	*AccessLogFilter_OrFilter
	//	*AccessLogFilter_HeaderFilter
	//	*AccessLogFilter_ResponseFlagFilter
	FilterSpecifier      isAccessLogFilter_FilterSpecifier `protobuf_oneof:"filter_specifier"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *AccessLogFilter) Reset()         { *m = AccessLogFilter{} }
func (m *AccessLogFilter) String() string { return proto.CompactTextString(m) }
func (*AccessLogFilter) ProtoMessage()    {}
func (*AccessLogFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{1}
}
func (m *AccessLogFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AccessLogFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AccessLogFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *AccessLogFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessLogFilter.Merge(dst, src)
}
func (m *AccessLogFilter) XXX_Size() int {
	return m.Size()
}
func (m *AccessLogFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessLogFilter.DiscardUnknown(m)
}

var xxx_messageInfo_AccessLogFilter proto.InternalMessageInfo

type isAccessLogFilter_FilterSpecifier interface {
	isAccessLogFilter_FilterSpecifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type AccessLogFilter_StatusCodeFilter struct {
	StatusCodeFilter *StatusCodeFilter `protobuf:"bytes,1,opt,name=status_code_filter,json=statusCodeFilter,oneof"`
}
type AccessLogFilter_DurationFilter struct {
	DurationFilter *DurationFilter `protobuf:"bytes,2,opt,name=duration_filter,json=durationFilter,oneof"`
}
type AccessLogFilter_NotHealthCheckFilter struct {
	NotHealthCheckFilter *NotHealthCheckFilter `protobuf:"bytes,3,opt,name=not_health_check_filter,json=notHealthCheckFilter,oneof"`
}
type AccessLogFilter_TraceableFilter struct {
	TraceableFilter *TraceableFilter `protobuf:"bytes,4,opt,name=traceable_filter,json=traceableFilter,oneof"`
}
type AccessLogFilter_RuntimeFilter struct {
	RuntimeFilter *RuntimeFilter `protobuf:"bytes,5,opt,name=runtime_filter,json=runtimeFilter,oneof"`
}
type AccessLogFilter_AndFilter struct {
	AndFilter *AndFilter `protobuf:"bytes,6,opt,name=and_filter,json=andFilter,oneof"`
}
type AccessLogFilter_OrFilter struct {
	OrFilter *OrFilter `protobuf:"bytes,7,opt,name=or_filter,json=orFilter,oneof"`
}
type AccessLogFilter_HeaderFilter struct {
	HeaderFilter *HeaderFilter `protobuf:"bytes,8,opt,name=header_filter,json=headerFilter,oneof"`
}
type AccessLogFilter_ResponseFlagFilter struct {
	ResponseFlagFilter *ResponseFlagFilter `protobuf:"bytes,9,opt,name=response_flag_filter,json=responseFlagFilter,oneof"`
}

func (*AccessLogFilter_StatusCodeFilter) isAccessLogFilter_FilterSpecifier()     {}
func (*AccessLogFilter_DurationFilter) isAccessLogFilter_FilterSpecifier()       {}
func (*AccessLogFilter_NotHealthCheckFilter) isAccessLogFilter_FilterSpecifier() {}
func (*AccessLogFilter_TraceableFilter) isAccessLogFilter_FilterSpecifier()      {}
func (*AccessLogFilter_RuntimeFilter) isAccessLogFilter_FilterSpecifier()        {}
func (*AccessLogFilter_AndFilter) isAccessLogFilter_FilterSpecifier()            {}
func (*AccessLogFilter_OrFilter) isAccessLogFilter_FilterSpecifier()             {}
func (*AccessLogFilter_HeaderFilter) isAccessLogFilter_FilterSpecifier()         {}
func (*AccessLogFilter_ResponseFlagFilter) isAccessLogFilter_FilterSpecifier()   {}

func (m *AccessLogFilter) GetFilterSpecifier() isAccessLogFilter_FilterSpecifier {
	if m != nil {
		return m.FilterSpecifier
	}
	return nil
}

func (m *AccessLogFilter) GetStatusCodeFilter() *StatusCodeFilter {
	if x, ok := m.GetFilterSpecifier().(*AccessLogFilter_StatusCodeFilter); ok {
		return x.StatusCodeFilter
	}
	return nil
}

func (m *AccessLogFilter) GetDurationFilter() *DurationFilter {
	if x, ok := m.GetFilterSpecifier().(*AccessLogFilter_DurationFilter); ok {
		return x.DurationFilter
	}
	return nil
}

func (m *AccessLogFilter) GetNotHealthCheckFilter() *NotHealthCheckFilter {
	if x, ok := m.GetFilterSpecifier().(*AccessLogFilter_NotHealthCheckFilter); ok {
		return x.NotHealthCheckFilter
	}
	return nil
}

func (m *AccessLogFilter) GetTraceableFilter() *TraceableFilter {
	if x, ok := m.GetFilterSpecifier().(*AccessLogFilter_TraceableFilter); ok {
		return x.TraceableFilter
	}
	return nil
}

func (m *AccessLogFilter) GetRuntimeFilter() *RuntimeFilter {
	if x, ok := m.GetFilterSpecifier().(*AccessLogFilter_RuntimeFilter); ok {
		return x.RuntimeFilter
	}
	return nil
}

func (m *AccessLogFilter) GetAndFilter() *AndFilter {
	if x, ok := m.GetFilterSpecifier().(*AccessLogFilter_AndFilter); ok {
		return x.AndFilter
	}
	return nil
}

func (m *AccessLogFilter) GetOrFilter() *OrFilter {
	if x, ok := m.GetFilterSpecifier().(*AccessLogFilter_OrFilter); ok {
		return x.OrFilter
	}
	return nil
}

func (m *AccessLogFilter) GetHeaderFilter() *HeaderFilter {
	if x, ok := m.GetFilterSpecifier().(*AccessLogFilter_HeaderFilter); ok {
		return x.HeaderFilter
	}
	return nil
}

func (m *AccessLogFilter) GetResponseFlagFilter() *ResponseFlagFilter {
	if x, ok := m.GetFilterSpecifier().(*AccessLogFilter_ResponseFlagFilter); ok {
		return x.ResponseFlagFilter
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AccessLogFilter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AccessLogFilter_OneofMarshaler, _AccessLogFilter_OneofUnmarshaler, _AccessLogFilter_OneofSizer, []interface{}{
		(*AccessLogFilter_StatusCodeFilter)(nil),
		(*AccessLogFilter_DurationFilter)(nil),
		(*AccessLogFilter_NotHealthCheckFilter)(nil),
		(*AccessLogFilter_TraceableFilter)(nil),
		(*AccessLogFilter_RuntimeFilter)(nil),
		(*AccessLogFilter_AndFilter)(nil),
		(*AccessLogFilter_OrFilter)(nil),
		(*AccessLogFilter_HeaderFilter)(nil),
		(*AccessLogFilter_ResponseFlagFilter)(nil),
	}
}

func _AccessLogFilter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AccessLogFilter)
	// filter_specifier
	switch x := m.FilterSpecifier.(type) {
	case *AccessLogFilter_StatusCodeFilter:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StatusCodeFilter); err != nil {
			return err
		}
	case *AccessLogFilter_DurationFilter:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DurationFilter); err != nil {
			return err
		}
	case *AccessLogFilter_NotHealthCheckFilter:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NotHealthCheckFilter); err != nil {
			return err
		}
	case *AccessLogFilter_TraceableFilter:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TraceableFilter); err != nil {
			return err
		}
	case *AccessLogFilter_RuntimeFilter:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RuntimeFilter); err != nil {
			return err
		}
	case *AccessLogFilter_AndFilter:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AndFilter); err != nil {
			return err
		}
	case *AccessLogFilter_OrFilter:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OrFilter); err != nil {
			return err
		}
	case *AccessLogFilter_HeaderFilter:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HeaderFilter); err != nil {
			return err
		}
	case *AccessLogFilter_ResponseFlagFilter:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResponseFlagFilter); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("AccessLogFilter.FilterSpecifier has unexpected type %T", x)
	}
	return nil
}

func _AccessLogFilter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AccessLogFilter)
	switch tag {
	case 1: // filter_specifier.status_code_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StatusCodeFilter)
		err := b.DecodeMessage(msg)
		m.FilterSpecifier = &AccessLogFilter_StatusCodeFilter{msg}
		return true, err
	case 2: // filter_specifier.duration_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DurationFilter)
		err := b.DecodeMessage(msg)
		m.FilterSpecifier = &AccessLogFilter_DurationFilter{msg}
		return true, err
	case 3: // filter_specifier.not_health_check_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NotHealthCheckFilter)
		err := b.DecodeMessage(msg)
		m.FilterSpecifier = &AccessLogFilter_NotHealthCheckFilter{msg}
		return true, err
	case 4: // filter_specifier.traceable_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TraceableFilter)
		err := b.DecodeMessage(msg)
		m.FilterSpecifier = &AccessLogFilter_TraceableFilter{msg}
		return true, err
	case 5: // filter_specifier.runtime_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RuntimeFilter)
		err := b.DecodeMessage(msg)
		m.FilterSpecifier = &AccessLogFilter_RuntimeFilter{msg}
		return true, err
	case 6: // filter_specifier.and_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AndFilter)
		err := b.DecodeMessage(msg)
		m.FilterSpecifier = &AccessLogFilter_AndFilter{msg}
		return true, err
	case 7: // filter_specifier.or_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(OrFilter)
		err := b.DecodeMessage(msg)
		m.FilterSpecifier = &AccessLogFilter_OrFilter{msg}
		return true, err
	case 8: // filter_specifier.header_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HeaderFilter)
		err := b.DecodeMessage(msg)
		m.FilterSpecifier = &AccessLogFilter_HeaderFilter{msg}
		return true, err
	case 9: // filter_specifier.response_flag_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ResponseFlagFilter)
		err := b.DecodeMessage(msg)
		m.FilterSpecifier = &AccessLogFilter_ResponseFlagFilter{msg}
		return true, err
	default:
		return false, nil
	}
}

func _AccessLogFilter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AccessLogFilter)
	// filter_specifier
	switch x := m.FilterSpecifier.(type) {
	case *AccessLogFilter_StatusCodeFilter:
		s := proto.Size(x.StatusCodeFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AccessLogFilter_DurationFilter:
		s := proto.Size(x.DurationFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AccessLogFilter_NotHealthCheckFilter:
		s := proto.Size(x.NotHealthCheckFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AccessLogFilter_TraceableFilter:
		s := proto.Size(x.TraceableFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AccessLogFilter_RuntimeFilter:
		s := proto.Size(x.RuntimeFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AccessLogFilter_AndFilter:
		s := proto.Size(x.AndFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AccessLogFilter_OrFilter:
		s := proto.Size(x.OrFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AccessLogFilter_HeaderFilter:
		s := proto.Size(x.HeaderFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AccessLogFilter_ResponseFlagFilter:
		s := proto.Size(x.ResponseFlagFilter)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Filter on an integer comparison.
type ComparisonFilter struct {
	// Comparison operator.
	Op ComparisonFilter_Op `protobuf:"varint,1,opt,name=op,proto3,enum=envoy.config.filter.accesslog.v2.ComparisonFilter_Op" json:"op,omitempty"`
	// Value to compare against.
	Value                *core.RuntimeUInt32 `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ComparisonFilter) Reset()         { *m = ComparisonFilter{} }
func (m *ComparisonFilter) String() string { return proto.CompactTextString(m) }
func (*ComparisonFilter) ProtoMessage()    {}
func (*ComparisonFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{2}
}
func (m *ComparisonFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComparisonFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComparisonFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ComparisonFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComparisonFilter.Merge(dst, src)
}
func (m *ComparisonFilter) XXX_Size() int {
	return m.Size()
}
func (m *ComparisonFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ComparisonFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ComparisonFilter proto.InternalMessageInfo

func (m *ComparisonFilter) GetOp() ComparisonFilter_Op {
	if m != nil {
		return m.Op
	}
	return ComparisonFilter_EQ
}

func (m *ComparisonFilter) GetValue() *core.RuntimeUInt32 {
	if m != nil {
		return m.Value
	}
	return nil
}

// Filters on HTTP response/status code.
type StatusCodeFilter struct {
	// Comparison.
	Comparison           *ComparisonFilter `protobuf:"bytes,1,opt,name=comparison" json:"comparison,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *StatusCodeFilter) Reset()         { *m = StatusCodeFilter{} }
func (m *StatusCodeFilter) String() string { return proto.CompactTextString(m) }
func (*StatusCodeFilter) ProtoMessage()    {}
func (*StatusCodeFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{3}
}
func (m *StatusCodeFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatusCodeFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatusCodeFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *StatusCodeFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusCodeFilter.Merge(dst, src)
}
func (m *StatusCodeFilter) XXX_Size() int {
	return m.Size()
}
func (m *StatusCodeFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusCodeFilter.DiscardUnknown(m)
}

var xxx_messageInfo_StatusCodeFilter proto.InternalMessageInfo

func (m *StatusCodeFilter) GetComparison() *ComparisonFilter {
	if m != nil {
		return m.Comparison
	}
	return nil
}

// Filters on total request duration in milliseconds.
type DurationFilter struct {
	// Comparison.
	Comparison           *ComparisonFilter `protobuf:"bytes,1,opt,name=comparison" json:"comparison,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *DurationFilter) Reset()         { *m = DurationFilter{} }
func (m *DurationFilter) String() string { return proto.CompactTextString(m) }
func (*DurationFilter) ProtoMessage()    {}
func (*DurationFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{4}
}
func (m *DurationFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DurationFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DurationFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *DurationFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DurationFilter.Merge(dst, src)
}
func (m *DurationFilter) XXX_Size() int {
	return m.Size()
}
func (m *DurationFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_DurationFilter.DiscardUnknown(m)
}

var xxx_messageInfo_DurationFilter proto.InternalMessageInfo

func (m *DurationFilter) GetComparison() *ComparisonFilter {
	if m != nil {
		return m.Comparison
	}
	return nil
}

// Filters for requests that are not health check requests. A health check
// request is marked by the health check filter.
type NotHealthCheckFilter struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NotHealthCheckFilter) Reset()         { *m = NotHealthCheckFilter{} }
func (m *NotHealthCheckFilter) String() string { return proto.CompactTextString(m) }
func (*NotHealthCheckFilter) ProtoMessage()    {}
func (*NotHealthCheckFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{5}
}
func (m *NotHealthCheckFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NotHealthCheckFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NotHealthCheckFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *NotHealthCheckFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NotHealthCheckFilter.Merge(dst, src)
}
func (m *NotHealthCheckFilter) XXX_Size() int {
	return m.Size()
}
func (m *NotHealthCheckFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_NotHealthCheckFilter.DiscardUnknown(m)
}

var xxx_messageInfo_NotHealthCheckFilter proto.InternalMessageInfo

// Filters for requests that are traceable. See the tracing overview for more
// information on how a request becomes traceable.
type TraceableFilter struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TraceableFilter) Reset()         { *m = TraceableFilter{} }
func (m *TraceableFilter) String() string { return proto.CompactTextString(m) }
func (*TraceableFilter) ProtoMessage()    {}
func (*TraceableFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{6}
}
func (m *TraceableFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TraceableFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TraceableFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *TraceableFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TraceableFilter.Merge(dst, src)
}
func (m *TraceableFilter) XXX_Size() int {
	return m.Size()
}
func (m *TraceableFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_TraceableFilter.DiscardUnknown(m)
}

var xxx_messageInfo_TraceableFilter proto.InternalMessageInfo

// Filters for random sampling of requests.
type RuntimeFilter struct {
	// Runtime key to get an optional overridden numerator for use in the *percent_sampled* field.
	// If found in runtime, this value will replace the default numerator.
	RuntimeKey string `protobuf:"bytes,1,opt,name=runtime_key,json=runtimeKey,proto3" json:"runtime_key,omitempty"`
	// The default sampling percentage. If not specified, defaults to 0% with denominator of 100.
	PercentSampled *_type.FractionalPercent `protobuf:"bytes,2,opt,name=percent_sampled,json=percentSampled" json:"percent_sampled,omitempty"`
	// By default, sampling pivots on the header
	// :ref:`x-request-id<config_http_conn_man_headers_x-request-id>` being present. If
	// :ref:`x-request-id<config_http_conn_man_headers_x-request-id>` is present, the filter will
	// consistently sample across multiple hosts based on the runtime key value and the value
	// extracted from :ref:`x-request-id<config_http_conn_man_headers_x-request-id>`. If it is
	// missing, or *use_independent_randomness* is set to true, the filter will randomly sample based
	// on the runtime key value alone. *use_independent_randomness* can be used for logging kill
	// switches within complex nested :ref:`AndFilter
	// <envoy_api_msg_config.filter.accesslog.v2.AndFilter>` and :ref:`OrFilter
	// <envoy_api_msg_config.filter.accesslog.v2.OrFilter>` blocks that are easier to reason about
	// from a probability perspective (i.e., setting to true will cause the filter to behave like
	// an independent random variable when composed within logical operator filters).
	UseIndependentRandomness bool     `protobuf:"varint,3,opt,name=use_independent_randomness,json=useIndependentRandomness,proto3" json:"use_independent_randomness,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *RuntimeFilter) Reset()         { *m = RuntimeFilter{} }
func (m *RuntimeFilter) String() string { return proto.CompactTextString(m) }
func (*RuntimeFilter) ProtoMessage()    {}
func (*RuntimeFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{7}
}
func (m *RuntimeFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RuntimeFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeFilter.Merge(dst, src)
}
func (m *RuntimeFilter) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeFilter.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeFilter proto.InternalMessageInfo

func (m *RuntimeFilter) GetRuntimeKey() string {
	if m != nil {
		return m.RuntimeKey
	}
	return ""
}

func (m *RuntimeFilter) GetPercentSampled() *_type.FractionalPercent {
	if m != nil {
		return m.PercentSampled
	}
	return nil
}

func (m *RuntimeFilter) GetUseIndependentRandomness() bool {
	if m != nil {
		return m.UseIndependentRandomness
	}
	return false
}

// Performs a logical “and” operation on the result of each filter in filters.
// Filters are evaluated sequentially and if one of them returns false, the
// filter returns false immediately.
type AndFilter struct {
	Filters              []*AccessLogFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *AndFilter) Reset()         { *m = AndFilter{} }
func (m *AndFilter) String() string { return proto.CompactTextString(m) }
func (*AndFilter) ProtoMessage()    {}
func (*AndFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{8}
}
func (m *AndFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AndFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AndFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *AndFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AndFilter.Merge(dst, src)
}
func (m *AndFilter) XXX_Size() int {
	return m.Size()
}
func (m *AndFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_AndFilter.DiscardUnknown(m)
}

var xxx_messageInfo_AndFilter proto.InternalMessageInfo

func (m *AndFilter) GetFilters() []*AccessLogFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// Performs a logical “or” operation on the result of each individual filter.
// Filters are evaluated sequentially and if one of them returns true, the
// filter returns true immediately.
type OrFilter struct {
	Filters              []*AccessLogFilter `protobuf:"bytes,2,rep,name=filters" json:"filters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *OrFilter) Reset()         { *m = OrFilter{} }
func (m *OrFilter) String() string { return proto.CompactTextString(m) }
func (*OrFilter) ProtoMessage()    {}
func (*OrFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{9}
}
func (m *OrFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *OrFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrFilter.Merge(dst, src)
}
func (m *OrFilter) XXX_Size() int {
	return m.Size()
}
func (m *OrFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_OrFilter.DiscardUnknown(m)
}

var xxx_messageInfo_OrFilter proto.InternalMessageInfo

func (m *OrFilter) GetFilters() []*AccessLogFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// Filters requests based on the presence or value of a request header.
type HeaderFilter struct {
	// Only requests with a header which matches the specified HeaderMatcher will pass the filter
	// check.
	Header               *route.HeaderMatcher `protobuf:"bytes,1,opt,name=header" json:"header,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *HeaderFilter) Reset()         { *m = HeaderFilter{} }
func (m *HeaderFilter) String() string { return proto.CompactTextString(m) }
func (*HeaderFilter) ProtoMessage()    {}
func (*HeaderFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{10}
}
func (m *HeaderFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeaderFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HeaderFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *HeaderFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeaderFilter.Merge(dst, src)
}
func (m *HeaderFilter) XXX_Size() int {
	return m.Size()
}
func (m *HeaderFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_HeaderFilter.DiscardUnknown(m)
}

var xxx_messageInfo_HeaderFilter proto.InternalMessageInfo

func (m *HeaderFilter) GetHeader() *route.HeaderMatcher {
	if m != nil {
		return m.Header
	}
	return nil
}

// Filters requests that received responses with an Envoy response flag set.
// A list of the response flags can be found
// in the access log formatter :ref:`documentation<config_access_log_format_response_flags>`.
type ResponseFlagFilter struct {
	// Only responses with the any of the flags listed in this field will be logged.
	// This field is optional. If it is not specified, then any response flag will pass
	// the filter check.
	Flags                []string `protobuf:"bytes,1,rep,name=flags" json:"flags,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResponseFlagFilter) Reset()         { *m = ResponseFlagFilter{} }
func (m *ResponseFlagFilter) String() string { return proto.CompactTextString(m) }
func (*ResponseFlagFilter) ProtoMessage()    {}
func (*ResponseFlagFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_accesslog_227c9aa0019a1c53, []int{11}
}
func (m *ResponseFlagFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResponseFlagFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResponseFlagFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ResponseFlagFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseFlagFilter.Merge(dst, src)
}
func (m *ResponseFlagFilter) XXX_Size() int {
	return m.Size()
}
func (m *ResponseFlagFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseFlagFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseFlagFilter proto.InternalMessageInfo

func (m *ResponseFlagFilter) GetFlags() []string {
	if m != nil {
		return m.Flags
	}
	return nil
}

func init() {
	proto.RegisterType((*AccessLog)(nil), "envoy.config.filter.accesslog.v2.AccessLog")
	proto.RegisterType((*AccessLogFilter)(nil), "envoy.config.filter.accesslog.v2.AccessLogFilter")
	proto.RegisterType((*ComparisonFilter)(nil), "envoy.config.filter.accesslog.v2.ComparisonFilter")
	proto.RegisterType((*StatusCodeFilter)(nil), "envoy.config.filter.accesslog.v2.StatusCodeFilter")
	proto.RegisterType((*DurationFilter)(nil), "envoy.config.filter.accesslog.v2.DurationFilter")
	proto.RegisterType((*NotHealthCheckFilter)(nil), "envoy.config.filter.accesslog.v2.NotHealthCheckFilter")
	proto.RegisterType((*TraceableFilter)(nil), "envoy.config.filter.accesslog.v2.TraceableFilter")
	proto.RegisterType((*RuntimeFilter)(nil), "envoy.config.filter.accesslog.v2.RuntimeFilter")
	proto.RegisterType((*AndFilter)(nil), "envoy.config.filter.accesslog.v2.AndFilter")
	proto.RegisterType((*OrFilter)(nil), "envoy.config.filter.accesslog.v2.OrFilter")
	proto.RegisterType((*HeaderFilter)(nil), "envoy.config.filter.accesslog.v2.HeaderFilter")
	proto.RegisterType((*ResponseFlagFilter)(nil), "envoy.config.filter.accesslog.v2.ResponseFlagFilter")
	proto.RegisterEnum("envoy.config.filter.accesslog.v2.ComparisonFilter_Op", ComparisonFilter_Op_name, ComparisonFilter_Op_value)
}
func (m *AccessLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccessLog) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Filter != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Filter.Size()))
		n1, err := m.Filter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Config != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Config.Size()))
		n2, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AccessLogFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccessLogFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FilterSpecifier != nil {
		nn3, err := m.FilterSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AccessLogFilter_StatusCodeFilter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StatusCodeFilter != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.StatusCodeFilter.Size()))
		n4, err := m.StatusCodeFilter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *AccessLogFilter_DurationFilter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DurationFilter != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.DurationFilter.Size()))
		n5, err := m.DurationFilter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *AccessLogFilter_NotHealthCheckFilter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NotHealthCheckFilter != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.NotHealthCheckFilter.Size()))
		n6, err := m.NotHealthCheckFilter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *AccessLogFilter_TraceableFilter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TraceableFilter != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.TraceableFilter.Size()))
		n7, err := m.TraceableFilter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *AccessLogFilter_RuntimeFilter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RuntimeFilter != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.RuntimeFilter.Size()))
		n8, err := m.RuntimeFilter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *AccessLogFilter_AndFilter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AndFilter != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.AndFilter.Size()))
		n9, err := m.AndFilter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *AccessLogFilter_OrFilter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.OrFilter != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.OrFilter.Size()))
		n10, err := m.OrFilter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *AccessLogFilter_HeaderFilter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HeaderFilter != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.HeaderFilter.Size()))
		n11, err := m.HeaderFilter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *AccessLogFilter_ResponseFlagFilter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResponseFlagFilter != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.ResponseFlagFilter.Size()))
		n12, err := m.ResponseFlagFilter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *ComparisonFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComparisonFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Op != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Op))
	}
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Value.Size()))
		n13, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StatusCodeFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatusCodeFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Comparison != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Comparison.Size()))
		n14, err := m.Comparison.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DurationFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DurationFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Comparison != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Comparison.Size()))
		n15, err := m.Comparison.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NotHealthCheckFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NotHealthCheckFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TraceableFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TraceableFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RuntimeFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RuntimeKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.RuntimeKey)))
		i += copy(dAtA[i:], m.RuntimeKey)
	}
	if m.PercentSampled != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.PercentSampled.Size()))
		n16, err := m.PercentSampled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.UseIndependentRandomness {
		dAtA[i] = 0x18
		i++
		if m.UseIndependentRandomness {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AndFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AndFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Filters) > 0 {
		for _, msg := range m.Filters {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAccesslog(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OrFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Filters) > 0 {
		for _, msg := range m.Filters {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAccesslog(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HeaderFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Header != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Header.Size()))
		n17, err := m.Header.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResponseFlagFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseFlagFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Flags) > 0 {
		for _, s := range m.Flags {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintAccesslog(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *AccessLog) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.Filter != nil {
		l = m.Filter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccessLogFilter) Size() (n int) {
	var l int
	_ = l
	if m.FilterSpecifier != nil {
		n += m.FilterSpecifier.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccessLogFilter_StatusCodeFilter) Size() (n int) {
	var l int
	_ = l
	if m.StatusCodeFilter != nil {
		l = m.StatusCodeFilter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	return n
}
func (m *AccessLogFilter_DurationFilter) Size() (n int) {
	var l int
	_ = l
	if m.DurationFilter != nil {
		l = m.DurationFilter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	return n
}
func (m *AccessLogFilter_NotHealthCheckFilter) Size() (n int) {
	var l int
	_ = l
	if m.NotHealthCheckFilter != nil {
		l = m.NotHealthCheckFilter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	return n
}
func (m *AccessLogFilter_TraceableFilter) Size() (n int) {
	var l int
	_ = l
	if m.TraceableFilter != nil {
		l = m.TraceableFilter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	return n
}
func (m *AccessLogFilter_RuntimeFilter) Size() (n int) {
	var l int
	_ = l
	if m.RuntimeFilter != nil {
		l = m.RuntimeFilter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	return n
}
func (m *AccessLogFilter_AndFilter) Size() (n int) {
	var l int
	_ = l
	if m.AndFilter != nil {
		l = m.AndFilter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	return n
}
func (m *AccessLogFilter_OrFilter) Size() (n int) {
	var l int
	_ = l
	if m.OrFilter != nil {
		l = m.OrFilter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	return n
}
func (m *AccessLogFilter_HeaderFilter) Size() (n int) {
	var l int
	_ = l
	if m.HeaderFilter != nil {
		l = m.HeaderFilter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	return n
}
func (m *AccessLogFilter_ResponseFlagFilter) Size() (n int) {
	var l int
	_ = l
	if m.ResponseFlagFilter != nil {
		l = m.ResponseFlagFilter.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	return n
}
func (m *ComparisonFilter) Size() (n int) {
	var l int
	_ = l
	if m.Op != 0 {
		n += 1 + sovAccesslog(uint64(m.Op))
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StatusCodeFilter) Size() (n int) {
	var l int
	_ = l
	if m.Comparison != nil {
		l = m.Comparison.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DurationFilter) Size() (n int) {
	var l int
	_ = l
	if m.Comparison != nil {
		l = m.Comparison.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NotHealthCheckFilter) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TraceableFilter) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RuntimeFilter) Size() (n int) {
	var l int
	_ = l
	l = len(m.RuntimeKey)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.PercentSampled != nil {
		l = m.PercentSampled.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.UseIndependentRandomness {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AndFilter) Size() (n int) {
	var l int
	_ = l
	if len(m.Filters) > 0 {
		for _, e := range m.Filters {
			l = e.Size()
			n += 1 + l + sovAccesslog(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrFilter) Size() (n int) {
	var l int
	_ = l
	if len(m.Filters) > 0 {
		for _, e := range m.Filters {
			l = e.Size()
			n += 1 + l + sovAccesslog(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HeaderFilter) Size() (n int) {
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResponseFlagFilter) Size() (n int) {
	var l int
	_ = l
	if len(m.Flags) > 0 {
		for _, s := range m.Flags {
			l = len(s)
			n += 1 + l + sovAccesslog(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAccesslog(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAccesslog(x uint64) (n int) {
	return sovAccesslog(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *AccessLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccessLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccessLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Filter == nil {
				m.Filter = &AccessLogFilter{}
			}
			if err := m.Filter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &types.Struct{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AccessLogFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccessLogFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccessLogFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusCodeFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &StatusCodeFilter{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.FilterSpecifier = &AccessLogFilter_StatusCodeFilter{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DurationFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DurationFilter{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.FilterSpecifier = &AccessLogFilter_DurationFilter{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotHealthCheckFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NotHealthCheckFilter{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.FilterSpecifier = &AccessLogFilter_NotHealthCheckFilter{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceableFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TraceableFilter{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.FilterSpecifier = &AccessLogFilter_TraceableFilter{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RuntimeFilter{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.FilterSpecifier = &AccessLogFilter_RuntimeFilter{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AndFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AndFilter{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.FilterSpecifier = &AccessLogFilter_AndFilter{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OrFilter{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.FilterSpecifier = &AccessLogFilter_OrFilter{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeaderFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HeaderFilter{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.FilterSpecifier = &AccessLogFilter_HeaderFilter{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseFlagFilter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ResponseFlagFilter{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.FilterSpecifier = &AccessLogFilter_ResponseFlagFilter{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComparisonFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComparisonFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComparisonFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			m.Op = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Op |= (ComparisonFilter_Op(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &core.RuntimeUInt32{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatusCodeFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatusCodeFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatusCodeFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Comparison", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Comparison == nil {
				m.Comparison = &ComparisonFilter{}
			}
			if err := m.Comparison.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DurationFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DurationFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DurationFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Comparison", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Comparison == nil {
				m.Comparison = &ComparisonFilter{}
			}
			if err := m.Comparison.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NotHealthCheckFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NotHealthCheckFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NotHealthCheckFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TraceableFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TraceableFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TraceableFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuntimeFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuntimeFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PercentSampled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PercentSampled == nil {
				m.PercentSampled = &_type.FractionalPercent{}
			}
			if err := m.PercentSampled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseIndependentRandomness", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseIndependentRandomness = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AndFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AndFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AndFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, &AccessLogFilter{})
			if err := m.Filters[len(m.Filters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, &AccessLogFilter{})
			if err := m.Filters[len(m.Filters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &route.HeaderMatcher{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseFlagFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseFlagFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseFlagFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Flags = append(m.Flags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAccesslog(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAccesslog
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAccesslog
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAccesslog(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAccesslog = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAccesslog   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("envoy/config/filter/accesslog/v2/accesslog.proto", fileDescriptor_accesslog_227c9aa0019a1c53)
}

var fileDescriptor_accesslog_227c9aa0019a1c53 = []byte{
	// 928 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x95, 0xc1, 0x6f, 0xdb, 0xb6,
	0x17, 0xc7, 0x2b, 0x26, 0x76, 0xed, 0xd7, 0xc6, 0xd6, 0x8f, 0x08, 0x7e, 0xf1, 0x82, 0x2c, 0xf0,
	0x74, 0x2a, 0x3a, 0x40, 0xea, 0xdc, 0xad, 0xa7, 0x62, 0x58, 0xed, 0xda, 0xb3, 0x31, 0xaf, 0x59,
	0x99, 0x1a, 0x2b, 0x36, 0x20, 0x06, 0x2d, 0xd1, 0xb6, 0x50, 0x59, 0x14, 0x28, 0xda, 0x40, 0xae,
	0x3b, 0xee, 0xd8, 0xeb, 0xfe, 0x91, 0x61, 0xbb, 0x74, 0xb7, 0x1d, 0xf7, 0x27, 0x0c, 0xb9, 0xf5,
	0xba, 0xbf, 0x60, 0x10, 0x49, 0x29, 0xb6, 0x5b, 0xc0, 0xc1, 0xb0, 0x1d, 0x6c, 0x89, 0x7c, 0xfc,
	0x7e, 0xde, 0x7b, 0x14, 0xdf, 0x23, 0x3c, 0x60, 0xf1, 0x8a, 0x5f, 0x7a, 0x3e, 0x8f, 0xa7, 0xe1,
	0xcc, 0x9b, 0x86, 0x91, 0x64, 0xc2, 0xa3, 0xbe, 0xcf, 0xd2, 0x34, 0xe2, 0x33, 0x6f, 0xd5, 0xba,
	0x1e, 0xb8, 0x89, 0xe0, 0x92, 0xe3, 0xa6, 0x52, 0xb8, 0x5a, 0xe1, 0x6a, 0x85, 0x7b, 0xbd, 0x68,
	0xd5, 0x3a, 0x3e, 0xd1, 0x4c, 0x9a, 0x84, 0x99, 0xde, 0xe7, 0x82, 0x79, 0x13, 0x9a, 0x32, 0xad,
	0x3f, 0x3e, 0xdd, 0xb0, 0x0a, 0xbe, 0x94, 0x4c, 0xff, 0x1b, 0x7b, 0x43, 0xdb, 0xe5, 0x65, 0xc2,
	0xbc, 0x84, 0x09, 0x9f, 0xc5, 0xd2, 0x58, 0x4e, 0x66, 0x9c, 0xcf, 0x22, 0xe6, 0xa9, 0xd1, 0x64,
	0x39, 0xf5, 0x52, 0x29, 0x96, 0x7e, 0x6e, 0x3d, 0x5a, 0xd1, 0x28, 0x0c, 0xa8, 0x64, 0x5e, 0xfe,
	0xa2, 0x0d, 0xce, 0x4f, 0x16, 0x54, 0x9f, 0xa8, 0xf8, 0x86, 0x7c, 0x86, 0x31, 0xec, 0xc7, 0x74,
	0xc1, 0x1a, 0x56, 0xd3, 0xba, 0x57, 0x25, 0xea, 0x1d, 0x0f, 0xa0, 0xac, 0xf3, 0x68, 0xa0, 0xa6,
	0x75, 0xef, 0x4e, 0xeb, 0x13, 0x77, 0x57, 0x8e, 0x6e, 0x01, 0xec, 0x29, 0x23, 0x31, 0x00, 0xec,
	0x41, 0x59, 0xab, 0x1a, 0x7b, 0x0a, 0x75, 0xe4, 0xea, 0xa0, 0xdd, 0x3c, 0x68, 0xf7, 0x5c, 0x05,
	0x4d, 0xcc, 0x32, 0xe7, 0xaf, 0x32, 0xd4, 0xb7, 0x60, 0x78, 0x02, 0x38, 0x95, 0x54, 0x2e, 0xd3,
	0xb1, 0xcf, 0x03, 0x36, 0x36, 0xb1, 0x59, 0x0a, 0xd8, 0xda, 0x1d, 0xdb, 0xb9, 0xd2, 0x76, 0x78,
	0xc0, 0x34, 0xaf, 0x7f, 0x8b, 0xd8, 0xe9, 0xd6, 0x1c, 0xfe, 0x1e, 0xea, 0xc1, 0x52, 0x50, 0x19,
	0xf2, 0x78, 0xbc, 0x91, 0xfc, 0x83, 0xdd, 0x0e, 0x9e, 0x1a, 0x61, 0x81, 0xaf, 0x05, 0x1b, 0x33,
	0x98, 0xc3, 0x51, 0xcc, 0xe5, 0x78, 0xce, 0x68, 0x24, 0xe7, 0x63, 0x7f, 0xce, 0xfc, 0x57, 0xb9,
	0x13, 0xbd, 0x2d, 0x8f, 0x76, 0x3b, 0x79, 0xc6, 0x65, 0x5f, 0xe9, 0x3b, 0x99, 0xbc, 0x70, 0x75,
	0x18, 0xbf, 0x67, 0x1e, 0x5f, 0x80, 0x2d, 0x05, 0xf5, 0x19, 0x9d, 0x44, 0xc5, 0x7e, 0xed, 0xdf,
	0xf4, 0x5b, 0xbe, 0xc8, 0x95, 0x85, 0x93, 0xba, 0xdc, 0x9c, 0xc2, 0x2f, 0xa1, 0x26, 0x96, 0xb1,
	0x0c, 0x17, 0x05, 0xbd, 0xa4, 0xe8, 0xde, 0x6e, 0x3a, 0xd1, 0xba, 0x82, 0x7d, 0x20, 0xd6, 0x27,
	0xf0, 0x10, 0x80, 0xc6, 0x41, 0x4e, 0x2d, 0x2b, 0xea, 0xc7, 0x37, 0x38, 0x7f, 0x71, 0x50, 0x10,
	0xab, 0x34, 0x1f, 0xe0, 0x01, 0x54, 0xb9, 0xc8, 0x61, 0xb7, 0x15, 0xec, 0xfe, 0x6e, 0xd8, 0x99,
	0x28, 0x58, 0x15, 0x6e, 0xde, 0xf1, 0x08, 0x0e, 0xe6, 0x8c, 0x06, 0xac, 0xc0, 0x55, 0x14, 0xce,
	0xdd, 0x8d, 0xeb, 0x2b, 0x59, 0x81, 0xbc, 0x3b, 0x5f, 0x1b, 0xe3, 0x39, 0x1c, 0x0a, 0x96, 0x26,
	0x3c, 0x4e, 0xd9, 0x78, 0x1a, 0xd1, 0x59, 0x4e, 0xaf, 0x2a, 0xfa, 0xa7, 0x37, 0xd8, 0x4f, 0xa3,
	0xee, 0x45, 0x74, 0x56, 0xf8, 0xc0, 0xe2, 0x9d, 0xd9, 0xf6, 0x07, 0x60, 0x6b, 0xfd, 0x38, 0x4d,
	0x98, 0x1f, 0x4e, 0x43, 0x26, 0x70, 0xe9, 0xe7, 0xb7, 0x6f, 0xf6, 0x2c, 0xe7, 0x57, 0x0b, 0xec,
	0x0e, 0x5f, 0x24, 0x54, 0x84, 0x69, 0x71, 0x68, 0x9f, 0x03, 0xe2, 0x89, 0xaa, 0xb2, 0x5a, 0xeb,
	0xb3, 0xdd, 0x71, 0x6c, 0xeb, 0xdd, 0xb3, 0xa4, 0x0d, 0xbf, 0xbc, 0x7d, 0xb3, 0x57, 0xfa, 0xc1,
	0x42, 0xb6, 0x45, 0x10, 0x4f, 0xf0, 0x23, 0x28, 0xad, 0x68, 0xb4, 0x64, 0xa6, 0xb4, 0x9a, 0x86,
	0x4a, 0x93, 0x30, 0x23, 0x64, 0x9d, 0x31, 0x3f, 0x1e, 0xa3, 0x41, 0x2c, 0x1f, 0xb6, 0x88, 0x5e,
	0xee, 0x9c, 0x00, 0x3a, 0x4b, 0x70, 0x19, 0x50, 0xf7, 0xb9, 0x7d, 0x2b, 0x7b, 0x7e, 0xd9, 0xb5,
	0xad, 0xec, 0x39, 0xec, 0xda, 0xc8, 0x11, 0x60, 0x6f, 0x97, 0x38, 0xbe, 0x00, 0xf0, 0x8b, 0x80,
	0x6e, 0xde, 0x2a, 0xb6, 0x93, 0x30, 0x19, 0xfc, 0xa8, 0x32, 0x58, 0x23, 0x3a, 0x09, 0xd4, 0x36,
	0xab, 0xfe, 0x3f, 0xf7, 0xf8, 0x7f, 0x38, 0x7c, 0x5f, 0x0b, 0x70, 0xfe, 0x07, 0xf5, 0xad, 0x82,
	0x75, 0x7e, 0xb3, 0xe0, 0x60, 0xa3, 0xcc, 0xf0, 0x7d, 0xb8, 0x93, 0xd7, 0xeb, 0x2b, 0x76, 0xa9,
	0x9b, 0x7d, 0xbb, 0x9a, 0x79, 0xda, 0x17, 0xa8, 0x69, 0x11, 0x30, 0xd6, 0xaf, 0xd8, 0x25, 0xee,
	0x41, 0xdd, 0xdc, 0x33, 0xe3, 0x94, 0x2e, 0x92, 0x88, 0x05, 0xe6, 0x73, 0x7d, 0x68, 0xb2, 0xc9,
	0xae, 0x22, 0xb7, 0x27, 0xa8, 0x9f, 0x65, 0x4f, 0xa3, 0x6f, 0xf4, 0x62, 0x52, 0x33, 0xaa, 0x73,
	0x2d, 0xc2, 0x8f, 0xe1, 0x78, 0x99, 0xb2, 0x71, 0x18, 0x07, 0x2c, 0x61, 0x71, 0x90, 0xf1, 0x04,
	0x8d, 0x03, 0xbe, 0x88, 0x59, 0x9a, 0xaa, 0xbe, 0x57, 0x21, 0x8d, 0x65, 0xca, 0x06, 0xd7, 0x0b,
	0x48, 0x61, 0x77, 0x02, 0xa8, 0x16, 0x35, 0x8d, 0xbf, 0x85, 0xdb, 0x7a, 0xef, 0xd2, 0x86, 0xd5,
	0xdc, 0xfb, 0x47, 0x37, 0x92, 0xd9, 0xd7, 0xd7, 0x16, 0xaa, 0x20, 0x92, 0xd3, 0x1c, 0x1f, 0x2a,
	0x79, 0xb1, 0xaf, 0x3b, 0x41, 0xff, 0xaa, 0x93, 0x11, 0xdc, 0x5d, 0x6f, 0x01, 0xb8, 0x0b, 0x65,
	0xdd, 0x02, 0xcc, 0x29, 0xf9, 0x68, 0xb3, 0x0c, 0xf4, 0xe5, 0xaf, 0x15, 0x5f, 0x53, 0xe9, 0xcf,
	0xb7, 0x0e, 0x85, 0x11, 0x3b, 0x12, 0xf0, 0xbb, 0xb5, 0x8f, 0x2f, 0xa0, 0x94, 0xb5, 0x11, 0xbd,
	0x51, 0xd5, 0x76, 0x3f, 0x13, 0x76, 0x5e, 0x5b, 0x5f, 0x38, 0x9f, 0x8b, 0xc7, 0x04, 0x0d, 0xfb,
	0x04, 0x8d, 0xb2, 0xdf, 0x0b, 0x82, 0x86, 0x84, 0xa0, 0x51, 0xf6, 0xeb, 0x11, 0x34, 0xea, 0x10,
	0x34, 0x3a, 0x23, 0xe8, 0x19, 0x21, 0xe8, 0xe9, 0x80, 0xa0, 0xde, 0x80, 0x20, 0x32, 0x24, 0xfb,
	0xa3, 0x27, 0xdd, 0x97, 0x64, 0x9f, 0x0c, 0xcf, 0xbb, 0x44, 0x63, 0xdb, 0xf6, 0xef, 0x57, 0xa7,
	0xd6, 0x1f, 0x57, 0xa7, 0xd6, 0x9f, 0x57, 0xa7, 0xd6, 0x77, 0x68, 0xd5, 0x9a, 0x94, 0xd5, 0x55,
	0xfe, 0xf0, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1c, 0x57, 0x65, 0x8d, 0x3b, 0x09, 0x00, 0x00,
}
