// Code generated by protoc-gen-validate
// source: envoy/api/v2/cds.proto
// DO NOT EDIT!!!

package v2

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/gogo/protobuf/types"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = types.DynamicAny{}
)

// Validate checks the field values on Cluster with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *Cluster) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return ClusterValidationError{
			Field:  "Name",
			Reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for AltStatName

	if _, ok := Cluster_DiscoveryType_name[int32(m.GetType())]; !ok {
		return ClusterValidationError{
			Field:  "Type",
			Reason: "value must be one of the defined enum values",
		}
	}

	if v, ok := interface{}(m.GetEdsClusterConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "EdsClusterConfig",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if true {
		dur := m.GetConnectTimeout()

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return ClusterValidationError{
				Field:  "ConnectTimeout",
				Reason: "value must be greater than 0s",
			}
		}

	}

	if v, ok := interface{}(m.GetPerConnectionBufferLimitBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "PerConnectionBufferLimitBytes",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if _, ok := Cluster_LbPolicy_name[int32(m.GetLbPolicy())]; !ok {
		return ClusterValidationError{
			Field:  "LbPolicy",
			Reason: "value must be one of the defined enum values",
		}
	}

	for idx, item := range m.GetHosts() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					Field:  fmt.Sprintf("Hosts[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetLoadAssignment()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "LoadAssignment",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	for idx, item := range m.GetHealthChecks() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					Field:  fmt.Sprintf("HealthChecks[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetMaxRequestsPerConnection()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "MaxRequestsPerConnection",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetCircuitBreakers()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "CircuitBreakers",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTlsContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "TlsContext",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetCommonHttpProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "CommonHttpProtocolOptions",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetHttpProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "HttpProtocolOptions",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetHttp2ProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "Http2ProtocolOptions",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for ExtensionProtocolOptions

	if d := m.GetDnsRefreshRate(); d != nil {
		dur := *d

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return ClusterValidationError{
				Field:  "DnsRefreshRate",
				Reason: "value must be greater than 0s",
			}
		}

	}

	if _, ok := Cluster_DnsLookupFamily_name[int32(m.GetDnsLookupFamily())]; !ok {
		return ClusterValidationError{
			Field:  "DnsLookupFamily",
			Reason: "value must be one of the defined enum values",
		}
	}

	for idx, item := range m.GetDnsResolvers() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					Field:  fmt.Sprintf("DnsResolvers[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetOutlierDetection()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "OutlierDetection",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if d := m.GetCleanupInterval(); d != nil {
		dur := *d

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return ClusterValidationError{
				Field:  "CleanupInterval",
				Reason: "value must be greater than 0s",
			}
		}

	}

	if v, ok := interface{}(m.GetUpstreamBindConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "UpstreamBindConfig",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetLbSubsetConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "LbSubsetConfig",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetCommonLbConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "CommonLbConfig",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTransportSocket()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "TransportSocket",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "Metadata",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for ProtocolSelection

	if v, ok := interface{}(m.GetUpstreamConnectionOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				Field:  "UpstreamConnectionOptions",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for CloseConnectionsOnHostHealthFailure

	// no validation rules for DrainConnectionsOnHostRemoval

	switch m.LbConfig.(type) {

	case *Cluster_RingHashLbConfig_:

		if v, ok := interface{}(m.GetRingHashLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					Field:  "RingHashLbConfig",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *Cluster_OriginalDstLbConfig_:

		if v, ok := interface{}(m.GetOriginalDstLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					Field:  "OriginalDstLbConfig",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// ClusterValidationError is the validation error returned by Cluster.Validate
// if the designated constraints aren't met.
type ClusterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e ClusterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = ClusterValidationError{}

// Validate checks the field values on UpstreamBindConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UpstreamBindConfig) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetSourceAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UpstreamBindConfigValidationError{
				Field:  "SourceAddress",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// UpstreamBindConfigValidationError is the validation error returned by
// UpstreamBindConfig.Validate if the designated constraints aren't met.
type UpstreamBindConfigValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e UpstreamBindConfigValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpstreamBindConfig.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = UpstreamBindConfigValidationError{}

// Validate checks the field values on UpstreamConnectionOptions with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *UpstreamConnectionOptions) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetTcpKeepalive()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UpstreamConnectionOptionsValidationError{
				Field:  "TcpKeepalive",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// UpstreamConnectionOptionsValidationError is the validation error returned by
// UpstreamConnectionOptions.Validate if the designated constraints aren't met.
type UpstreamConnectionOptionsValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e UpstreamConnectionOptionsValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpstreamConnectionOptions.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = UpstreamConnectionOptionsValidationError{}

// Validate checks the field values on Cluster_EdsClusterConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Cluster_EdsClusterConfig) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetEdsConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_EdsClusterConfigValidationError{
				Field:  "EdsConfig",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for ServiceName

	return nil
}

// Cluster_EdsClusterConfigValidationError is the validation error returned by
// Cluster_EdsClusterConfig.Validate if the designated constraints aren't met.
type Cluster_EdsClusterConfigValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Cluster_EdsClusterConfigValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_EdsClusterConfig.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Cluster_EdsClusterConfigValidationError{}

// Validate checks the field values on Cluster_LbSubsetConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Cluster_LbSubsetConfig) Validate() error {
	if m == nil {
		return nil
	}

	if _, ok := Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name[int32(m.GetFallbackPolicy())]; !ok {
		return Cluster_LbSubsetConfigValidationError{
			Field:  "FallbackPolicy",
			Reason: "value must be one of the defined enum values",
		}
	}

	if v, ok := interface{}(m.GetDefaultSubset()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_LbSubsetConfigValidationError{
				Field:  "DefaultSubset",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	for idx, item := range m.GetSubsetSelectors() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Cluster_LbSubsetConfigValidationError{
					Field:  fmt.Sprintf("SubsetSelectors[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	// no validation rules for LocalityWeightAware

	return nil
}

// Cluster_LbSubsetConfigValidationError is the validation error returned by
// Cluster_LbSubsetConfig.Validate if the designated constraints aren't met.
type Cluster_LbSubsetConfigValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Cluster_LbSubsetConfigValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_LbSubsetConfig.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Cluster_LbSubsetConfigValidationError{}

// Validate checks the field values on Cluster_RingHashLbConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Cluster_RingHashLbConfig) Validate() error {
	if m == nil {
		return nil
	}

	if wrapper := m.GetMinimumRingSize(); wrapper != nil {

		if wrapper.GetValue() > 8388608 {
			return Cluster_RingHashLbConfigValidationError{
				Field:  "MinimumRingSize",
				Reason: "value must be less than or equal to 8388608",
			}
		}

	}

	if v, ok := interface{}(m.GetDeprecatedV1()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_RingHashLbConfigValidationError{
				Field:  "DeprecatedV1",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// Cluster_RingHashLbConfigValidationError is the validation error returned by
// Cluster_RingHashLbConfig.Validate if the designated constraints aren't met.
type Cluster_RingHashLbConfigValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Cluster_RingHashLbConfigValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_RingHashLbConfig.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Cluster_RingHashLbConfigValidationError{}

// Validate checks the field values on Cluster_OriginalDstLbConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Cluster_OriginalDstLbConfig) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for UseHttpHeader

	return nil
}

// Cluster_OriginalDstLbConfigValidationError is the validation error returned
// by Cluster_OriginalDstLbConfig.Validate if the designated constraints
// aren't met.
type Cluster_OriginalDstLbConfigValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Cluster_OriginalDstLbConfigValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_OriginalDstLbConfig.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Cluster_OriginalDstLbConfigValidationError{}

// Validate checks the field values on Cluster_CommonLbConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Cluster_CommonLbConfig) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetHealthyPanicThreshold()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CommonLbConfigValidationError{
				Field:  "HealthyPanicThreshold",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetUpdateMergeWindow()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CommonLbConfigValidationError{
				Field:  "UpdateMergeWindow",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	switch m.LocalityConfigSpecifier.(type) {

	case *Cluster_CommonLbConfig_ZoneAwareLbConfig_:

		if v, ok := interface{}(m.GetZoneAwareLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Cluster_CommonLbConfigValidationError{
					Field:  "ZoneAwareLbConfig",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *Cluster_CommonLbConfig_LocalityWeightedLbConfig_:

		if v, ok := interface{}(m.GetLocalityWeightedLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Cluster_CommonLbConfigValidationError{
					Field:  "LocalityWeightedLbConfig",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// Cluster_CommonLbConfigValidationError is the validation error returned by
// Cluster_CommonLbConfig.Validate if the designated constraints aren't met.
type Cluster_CommonLbConfigValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Cluster_CommonLbConfigValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_CommonLbConfig.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Cluster_CommonLbConfigValidationError{}

// Validate checks the field values on Cluster_LbSubsetConfig_LbSubsetSelector
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// Cluster_LbSubsetConfig_LbSubsetSelectorValidationError is the validation
// error returned by Cluster_LbSubsetConfig_LbSubsetSelector.Validate if the
// designated constraints aren't met.
type Cluster_LbSubsetConfig_LbSubsetSelectorValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Cluster_LbSubsetConfig_LbSubsetSelectorValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_LbSubsetConfig_LbSubsetSelector.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Cluster_LbSubsetConfig_LbSubsetSelectorValidationError{}

// Validate checks the field values on Cluster_RingHashLbConfig_DeprecatedV1
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *Cluster_RingHashLbConfig_DeprecatedV1) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetUseStdHash()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_RingHashLbConfig_DeprecatedV1ValidationError{
				Field:  "UseStdHash",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// Cluster_RingHashLbConfig_DeprecatedV1ValidationError is the validation error
// returned by Cluster_RingHashLbConfig_DeprecatedV1.Validate if the
// designated constraints aren't met.
type Cluster_RingHashLbConfig_DeprecatedV1ValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Cluster_RingHashLbConfig_DeprecatedV1ValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_RingHashLbConfig_DeprecatedV1.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Cluster_RingHashLbConfig_DeprecatedV1ValidationError{}

// Validate checks the field values on Cluster_CommonLbConfig_ZoneAwareLbConfig
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetRoutingEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{
				Field:  "RoutingEnabled",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetMinClusterSize()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{
				Field:  "MinClusterSize",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError is the validation
// error returned by Cluster_CommonLbConfig_ZoneAwareLbConfig.Validate if the
// designated constraints aren't met.
type Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_CommonLbConfig_ZoneAwareLbConfig.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{}

// Validate checks the field values on
// Cluster_CommonLbConfig_LocalityWeightedLbConfig with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError is the
// validation error returned by
// Cluster_CommonLbConfig_LocalityWeightedLbConfig.Validate if the designated
// constraints aren't met.
type Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_CommonLbConfig_LocalityWeightedLbConfig.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError{}
