/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      CompressionView : NSObject <PrefsViewProtocol>
 *
 *  Description:  This view contains compression protocols preferences
 */

#import <AppKit/NSView.h>
#import <AppKit/NSBox.h>
#import <AppKit/NSButton.h>

#import "Compression.h"

@implementation CompressionView

- (id) initWithPrefs: (NSMutableDictionary *) sessionPrefs
{
  NSView *protocolsFrameView;

  [super init];
  
  if ((prefs = [sessionPrefs objectForKey: @"Compression"]) == nil)
  {
    [sessionPrefs 
      setObject: [NSMutableDictionary dictionary] forKey: @"Compression"];
    prefs = [sessionPrefs objectForKey: @"Compression"];
  }

  view = [[NSView alloc] initWithFrame: NSMakeRect (10, 44, 280, 393)];

  // IP address -------------------------------------------------- 
  protocolsFrame = [[NSBox alloc] initWithFrame:
    NSMakeRect (0, 178, 280, 212)];
  [protocolsFrame setTitle: @"Protocols and schemes to use"];
  [view addSubview: protocolsFrame];
  protocolsFrameView = [protocolsFrame contentView];

  bsdButton = [[NSButton alloc] initWithFrame: 
    NSMakeRect (10, 160, 233, 16)];
  [bsdButton setTitle: @"BSD compression scheme"];
  [bsdButton setButtonType: NSSwitchButton];
  [bsdButton setImagePosition: NSImageLeft];
  [protocolsFrameView addSubview: bsdButton];

  deflateButton = [[NSButton alloc] initWithFrame: 
    NSMakeRect (10, 139, 233, 16)];
  [deflateButton setTitle: @"Deflate compression scheme"];
  [deflateButton setButtonType: NSSwitchButton];
  [deflateButton setImagePosition: NSImageLeft];
  [protocolsFrameView addSubview: deflateButton];

  addressControlButton = [[NSButton alloc] initWithFrame: 
    NSMakeRect (10, 118, 233, 16)];
  [addressControlButton setTitle: @"Adress/Control compression"];
  [addressControlButton setButtonType: NSSwitchButton];
  [addressControlButton setImagePosition: NSImageLeft];
  [protocolsFrameView addSubview: addressControlButton];

  CCPButton = [[NSButton alloc] initWithFrame: 
    NSMakeRect (10, 97, 233, 16)];
  [CCPButton setTitle: @"Compression Control Protocol (CCP)"];
  [CCPButton setButtonType: NSSwitchButton];
  [CCPButton setImagePosition: NSImageLeft];
  [protocolsFrameView addSubview: CCPButton];

  protocolFieldButton = [[NSButton alloc] initWithFrame: 
    NSMakeRect (10, 76, 233, 16)];
  [protocolFieldButton setTitle: @"Protocol field compression"];
  [protocolFieldButton setButtonType: NSSwitchButton];
  [protocolFieldButton setImagePosition: NSImageLeft];
  [protocolsFrameView addSubview: protocolFieldButton];
 
  tcpipHeaderButton = [[NSButton alloc] initWithFrame: 
    NSMakeRect (10, 55, 233, 16)];
  [tcpipHeaderButton setTitle: @"TCP/IP header compression"];
  [tcpipHeaderButton setButtonType: NSSwitchButton];
  [tcpipHeaderButton setImagePosition: NSImageLeft];
  [protocolsFrameView addSubview: tcpipHeaderButton];
 
  connectionIDButton = [[NSButton alloc] initWithFrame: 
    NSMakeRect (10, 34, 233, 16)];
  [connectionIDButton setTitle: @"Connection-ID compression"];
  [connectionIDButton setButtonType: NSSwitchButton];
  [connectionIDButton setImagePosition: NSImageLeft];
  [protocolsFrameView addSubview: connectionIDButton];
  
  predictor1Button = [[NSButton alloc] initWithFrame: 
    NSMakeRect (10, 13, 233, 16)];
  [predictor1Button setTitle: @"Accept or agree Predictor-1"];
  [predictor1Button setButtonType: NSSwitchButton];
  [predictor1Button setImagePosition: NSImageLeft];
  [protocolsFrameView addSubview: predictor1Button];

  RELEASE (bsdButton);
  RELEASE (deflateButton);
  RELEASE (addressControlButton);
  RELEASE (CCPButton);
  RELEASE (protocolFieldButton);
  RELEASE (tcpipHeaderButton);
  RELEASE (connectionIDButton);
  RELEASE (predictor1Button);
  RELEASE (protocolsFrame);

  // load settings or set defaults
  [self setDefaults];

  return self;
}

// dealloc never called for array memebers
- (void) release
{
  NSLog (@"CompressionView: release (%i)", [view retainCount]);
  if ([view superview])
  {
    [view removeFromSuperview];
  }
  else
  {
    RELEASE (view);
  }

  [super dealloc];
}

/*-------------------------------------------------------------------------*
 *  Protocol methods
 *-------------------------------------------------------------------------*/
- (id) show: (id)superView
{
  [superView addSubview: view];
  RELEASE (view);

  return nil;
}

- (void) hide 
{
  RETAIN (view);
  [view removeFromSuperview];
}

- (void) setDefaults
{
  if ([prefs count] > 0)
  {
    if ([[prefs objectForKey: @"BSD"] isEqualToString: @"YES"])
    {
      [bsdButton setState: NSOnState];
    }
    else
    {
      [bsdButton setState: NSOffState];
    }
    if ([[prefs objectForKey: @"Deflate"] isEqualToString: @"YES"])
    {
      [deflateButton setState: NSOnState];
    }
    else
    {
      [deflateButton setState: NSOffState];
    }
    if ([[prefs objectForKey: @"AddressControl"] isEqualToString: @"YES"])
    {
      [addressControlButton setState: NSOnState];
    }
    else
    {
      [addressControlButton setState: NSOffState];
    }
    if ([[prefs objectForKey: @"CCP"] isEqualToString: @"YES"])
    {
      [CCPButton setState: NSOnState];
    }
    else
    {
      [CCPButton setState: NSOffState];
    }
    if ([[prefs objectForKey: @"ProtocolField"] isEqualToString: @"YES"])
    {
      [protocolFieldButton setState: NSOnState];
    }
    else
    {
      [protocolFieldButton setState: NSOffState];
    }
    if ([[prefs objectForKey: @"TCPIPHeader"] isEqualToString: @"YES"])
    {
      [tcpipHeaderButton setState: NSOnState];
    }
    else
    {
      [tcpipHeaderButton setState: NSOffState];
    }
    if ([[prefs objectForKey: @"ConnectionID"] isEqualToString: @"YES"])
    {
      [connectionIDButton setState: NSOnState];
    }
    else
    {
      [connectionIDButton setState: NSOffState];
    }
    if ([[prefs objectForKey: @"Predictor1"] isEqualToString: @"YES"])
    {
      [predictor1Button setState: NSOnState];
    }
    else
    {
      [predictor1Button setState: NSOffState];
    }
  }
  else
  {
    [bsdButton setState: NSOnState];
    [deflateButton setState: NSOnState];
    [addressControlButton setState: NSOnState];
    [CCPButton setState: NSOnState];
    [protocolFieldButton setState: NSOnState];
    [tcpipHeaderButton setState: NSOnState];
    [connectionIDButton setState: NSOnState];
    [predictor1Button setState: NSOnState];
  }
}

- (NSMutableDictionary *) prefsDict
{
  NSMutableString *isBSD;
  NSMutableString *isDeflate;
  NSMutableString *isAdressControl;
  NSMutableString *isCCP;
  NSMutableString *isProtocolField;
  NSMutableString *isTCPIPHeader;
  NSMutableString *isConnectionID;
  NSMutableString *isPredictor1;

  isBSD  = [NSMutableString stringWithString: @"YES"];
  isDeflate = [NSMutableString stringWithString: @"YES"];
  isAdressControl = [NSMutableString stringWithString: @"YES"];
  isCCP = [NSMutableString stringWithString: @"YES"];
  isProtocolField = [NSMutableString stringWithString: @"YES"];
  isTCPIPHeader = [NSMutableString stringWithString: @"YES"];
  isConnectionID = [NSMutableString stringWithString: @"YES"];
  isPredictor1 = [NSMutableString stringWithString: @"YES"];

  if ([bsdButton state] == NSOffState) [isBSD setString: @"NO"];
  [prefs setObject: isBSD forKey: @"BSD"];
  if ([deflateButton state] == NSOffState) [isDeflate setString: @"NO"];
  [prefs setObject: isDeflate  forKey: @"Deflate"];
  if ([addressControlButton state] == NSOffState) [isAdressControl setString: @"NO"];
  [prefs setObject: isAdressControl  forKey: @"AddressControl"];
  if ([CCPButton state] == NSOffState) [isCCP setString: @"NO"];
  [prefs setObject: isCCP  forKey: @"CCP"];
  if ([protocolFieldButton state] == NSOffState) [isProtocolField setString: @"NO"];
  [prefs setObject: isProtocolField forKey: @"ProtocolField"];
  if ([tcpipHeaderButton state] == NSOffState) [isTCPIPHeader setString: @"NO"];
  [prefs setObject: isTCPIPHeader forKey: @"TCPIPHeader"];
  if ([connectionIDButton state] == NSOffState) [isConnectionID setString: @"NO"];
  [prefs setObject: isConnectionID forKey: @"ConnectionID"];
  if ([predictor1Button state] == NSOffState) [isPredictor1 setString: @"NO"];
  [prefs setObject: isPredictor1 forKey: @"Predictor1"];

  return prefs;
}

/*-------------------------------------------------------------------------*
 *  Controls' action methods
 *-------------------------------------------------------------------------*/

@end
