unit Antlr.Runtime.Collections.Tests;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit 
  being tested.

}

interface

uses
  TestFramework,
  Antlr.Runtime.Collections,
  Generics.Collections,
  Antlr.Runtime.Tools;

type
  // Test methods for class IHashList
  TestIHashList = class(TTestCase)
  strict private
    FIHashList: IHashList<Integer, String>;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestInsertionOrder;
    procedure TestRemove;
  end;

  // Test methods for class IStackList
  TestIStackList = class(TTestCase)
  strict private
    FIStackList: IStackList<String>;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestPushPop;
    procedure TestPeek;
  end;

implementation

uses
  SysUtils;

const
  Values: array [0..9] of Integer = (50, 1, 33, 76, -22, 22, 34, 2, 88, 12);

procedure TestIHashList.SetUp;
var
  I: Integer;
begin
  FIHashList := THashList<Integer, String>.Create;
  for I in Values do
    FIHashList.Add(I,'Value' + IntToStr(I));
end;

procedure TestIHashList.TearDown;
begin
  FIHashList := nil;
end;

procedure TestIHashList.TestInsertionOrder;
var
  I: Integer;
  P: TPair<Integer, String>;
begin
  I := 0;
  for P in FIHashList do
  begin
    CheckEquals(P.Key, Values[I]);
    CheckEquals(P.Value, 'Value' + IntToStr(Values[I]));
    Inc(I);
  end;
end;

procedure TestIHashList.TestRemove;
var
  I: Integer;
  P: TPair<Integer, String>;
begin
  FIHashList.Remove(34);
  I := 0;
  for P in FIHashList do
  begin
    if (Values[I] = 34) then
      Inc(I);
    CheckEquals(P.Key, Values[I]);
    CheckEquals(P.Value, 'Value' + IntToStr(Values[I]));
    Inc(I);
  end;
end;

procedure TestIStackList.SetUp;
begin
  FIStackList := TStackList<String>.Create;
end;

procedure TestIStackList.TearDown;
begin
  FIStackList := nil;
end;

procedure TestIStackList.TestPushPop;
var
  Item: String;
begin
  Item := 'Item 1';
  FIStackList.Push(Item);
  Item := 'Item 2';
  FIStackList.Push(Item);
  CheckEquals(FIStackList.Pop,'Item 2');
  CheckEquals(FIStackList.Pop,'Item 1');
end;

procedure TestIStackList.TestPeek;
begin
  FIStackList.Push('Item 1');
  FIStackList.Push('Item 2');
  FIStackList.Push('Item 3');
  FIStackList.Pop;
  CheckEquals(FIStackList.Peek, 'Item 2');
  CheckEquals(FIStackList.Pop, 'Item 2');
end;

initialization
  // Register any test cases with the test runner
  RegisterTest(TestIHashList.Suite);
  RegisterTest(TestIStackList.Suite);
end.
