dnl $Progeny$
dnl
dnl figure out the path to our python libraries
dnl this macro takes no arguments
AC_DEFUN(AC_PY_LIB_PATH, 
[ac_cv_py_lib_path="`python -c "import sys; import string; print
string.join(sys.path,' ')"`"; 
PY_LIB_PATH=$ac_cv_py_lib_path;
])


dnl param is the name of a python module that should 
dnl exist in the sys.path
dnl note: we do not pass in the extension...
dnl may be used in configure.in like:
dnl
dnl     AC_PY_CHECK_LIB(threading)
dnl 

AC_DEFUN(AC_PY_CHECK_LIB,
[
  AC_MSG_CHECKING(for Python module $1)
  ac_cv_py_have_$1=false;

  if AC_TRY_COMMAND($PYTHON -c "import $1") >/dev/null 2>&1; then
    ac_cv_py_have_$1=true;
  fi

  AC_MSG_RESULT($ac_cv_py_have_$1)
  HAVE_PY_LIB_$1=$ac_cv_py_have_$1;
])

dnl wrapper for AC_PY_CHECK_LIB 
dnl that aborts the configure if
dnl the
AC_DEFUN(AC_PY_CHECK_REQUIRED,
[
  AC_PY_CHECK_LIB($1)
  if [[ $HAVE_PY_LIB_$1 == false ]]; then
  {
    echo "$1 is a required module... aborting.";
    exit
  }
  fi;
])
